set define '^'
set verify off
prompt ...wwv_flow_dynamic_action_native


create or replace package wwv_flow_dynamic_action_native
as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 2009 - 2012. All Rights Reserved.
--
--    NAME
--      wwv_flow_dynamic_action_native.sql
--
--    DESCRIPTION
--      This package is resonsible for handling native dynamic actions.
--
--    MODIFIED   (MM/DD/YYYY)
--    arayner     12/08/2009 - Created
--
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Public type definitions
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Public constant definitions
--------------------------------------------------------------------------------
--
--==============================================================================
-- Native plugin interface
--
-- This function is called from wwv_flow_plugin to run the render function.
--==============================================================================
function render (
    p_type           in varchar2,
    p_plugin         in wwv_flow_plugin_api.t_plugin,
    p_dynamic_action in wwv_flow_plugin_api.t_dynamic_action )
    return wwv_flow_plugin_api.t_dynamic_action_render_result;
--
--==============================================================================
-- Native plugin interface
--
-- This function is called from wwv_flow_plugin to run the ajax function.
--==============================================================================
function ajax (
    p_type           in varchar2,
    p_plugin         in wwv_flow_plugin_api.t_plugin,
    p_dynamic_action in wwv_flow_plugin_api.t_dynamic_action )
    return wwv_flow_plugin_api.t_dynamic_action_ajax_result;
--
end wwv_flow_dynamic_action_native;
/
show errors
