set define '^' verify off
prompt ...wwv_flow_db_env_detection.sql
create or replace package wwv_flow_db_env_detection is
--------------------------------------------------------------------------------
--
--  Copyright (c) 2017, 2022, Oracle and/or its affiliates.
--
--    NAME
--      wwv_flow_db_env_detection.sql
--
--    DESCRIPTION
--      This script is to detect database the detailed database version and
--      selected database features (SQL/JSON) and make that information
--      available as constants in the wwv_flow_db_version package for
--      conditional compilation.
--
--    MODIFIED   (MM/DD/YYYY)
--    cczarski    09/07/2017 - Created
-- 
--------------------------------------------------------------------------------

--==============================================================================
-- dynamically creates the WWV_FLOW_DB_VERSION package containing the following
-- constants:
--
--     c_ver_le_11_2_0_1            constant boolean        := c_full_version < '11.2.0.2.';
--     c_ver_le_11_2_0_2            constant boolean        := c_full_version < '11.2.0.3.';
--     c_ver_le_12_1_0_1            constant boolean        := c_full_version < '12.1.0.2.';
--     c_has_sql_json               constant boolean        := {JSON_TABLE SQL function is avaiable};
--     c_has_soda                   constant boolean        := {SODA type is available};
--     c_has_locator                constant boolean        := {MDSYS.SDO_GEOMETRY type is available};
--     c_has_extended_string_size   constant boolean        := {max_string_size is extended};
--     c_has_dbms_crypto_pkencrypt  constant boolean        := {DBMS_CRYPTO.PKENCRYPT is available};
--     c_has_javavm                 constant boolean        := {JAVAVM is available};
--     c_has_mle_with_modules       constant boolean        := {DB 23c+ and MLE is availbale};
--     c_has_dbms_cloud             constant boolean        := {DBMS_CLOUD is available};
--     c_dbms_cloud_owner           constant varchar2(1)    := {owner of DBMS_CLOUD};
--     c_actual_dbms_id_length      constant pls_integer    := {max length of identifiers};
--     c_checksum                   constant varchar2(15)   := {checksum for all options above};
--
--==============================================================================
procedure generate_wwv_flow_db_version;

end wwv_flow_db_env_detection;
/
show err

set define '^'

