set define '^' verify off
prompt ...wwv_flow_data_export_pdf.sql
create or replace package wwv_flow_data_export_pdf as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 2020 - 2022. All Rights Reserved.
--
--    NAME
--      wwv_flow_data_export_pdf.sql
--
--    DESCRIPTION
--      This package is responsible for PDF data exports
--
--

--------------------------------------------------------------------------------
-- Global variables
--------------------------------------------------------------------------------
--

--==============================================================================
-- The procedure initializes attributes needed for data export.
--
-- p_pdf_accessible    Include accessibility tags in the PDF
--==============================================================================
procedure init ( 
    p_run               in out nocopy   wwv_flow_data_export.t_run,
    p_pdf_accessible    in              boolean,
    p_pdf_exact_widths  in              boolean );

--==============================================================================
-- The procedure emits top header and necessary logic to emit headings
--==============================================================================
procedure emit_header (
    p_run in out nocopy wwv_flow_data_export.t_run );

--==============================================================================
-- The procedure emits multiple rows
--==============================================================================
procedure emit_rows (
    p_run   in out nocopy   wwv_flow_data_export.t_run,
    p_rows  in              wwv_flow_data_export.t_rows );

--==============================================================================
-- The function returns the clob buffer as a blob.
--==============================================================================
function get_blob_output
    return blob;

--==============================================================================
-- Clears all the memory structures
--==============================================================================
procedure free;

end wwv_flow_data_export_pdf;
/
show errors
