set define '^' verify off
prompt ...wwv_flow_data_export_json.sql
create or replace package wwv_flow_data_export_json as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 2020 - 2022. All Rights Reserved.
--
--    NAME
--      wwv_flow_data_export_json.sql
--
--    DESCRIPTION
--      This package is responsible for JSON data exports
--
--

--------------------------------------------------------------------------------
-- Global variables
--------------------------------------------------------------------------------
--

--==============================================================================
-- The procedure initializes attributes needed for data export.
--==============================================================================
procedure init(
    p_run               in out nocopy   wwv_flow_data_export.t_run,
    p_for_print_server  in              boolean );

--==============================================================================
-- The procedure emits top header and necessary logic to emit headings
--==============================================================================
procedure emit_header (
    p_run in out nocopy wwv_flow_data_export.t_run );

--==============================================================================
-- The procedure emits bottom footer and necessary logic to finish
--==============================================================================
procedure emit_footer (
    p_run in out nocopy wwv_flow_data_export.t_run );

--==============================================================================
-- The procedure emits multiple rows
--==============================================================================
procedure emit_rows (
    p_run   in out nocopy   wwv_flow_data_export.t_run,
    p_rows  in              wwv_flow_data_export.t_rows );

--==============================================================================
-- The function returns the clob buffer.
--==============================================================================
function get_clob_output (
    p_run in out nocopy wwv_flow_data_export.t_run ) 
    return clob;

--==============================================================================
-- The function returns the clob buffer as a blob.
--==============================================================================
function get_blob_output (
    p_run in out nocopy wwv_flow_data_export.t_run )
    return blob;

--==============================================================================
-- Clears all the memory structures
--==============================================================================
procedure free(
    p_run in out nocopy wwv_flow_data_export.t_run );

end wwv_flow_data_export_json;
/
show errors
