set define off verify off
prompt ...wwv_flow_approval_dev
create or replace package wwv_flow_approval_dev as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 1999 - 2021. All Rights Reserved.
--
--    NAME
--      wwv_flow_approval_dev.sql
--
--    DESCRIPTION
--      Oracle APEX Approvals Component App Builder API.
--
--    SECURITY
--
--    NOTES:
--
--    RUNTIME DEPLOYMENT: NO
--
--    MODIFIED    (MM/DD/YYYY)
--      ralmuell   08/30/2021 - Created
--      ogobrech   01/19/2022 - Add unified task list creation
--
--------------------------------------------------------------------------------
 
 
--==============================================================================
-- Create a new task definition.
--
-- Parameters:
-- * p_flow_id                   application ID
-- * p_name                      name of the new task definition
-- * p_static_id                 internal id of the new task definition
-- * p_subject:                  The subject (expression) of the task
-- * p_potential_participant:    The (optional) potential owner of the task
-- * p_business_participant:     The (optional) administrator of the task
-- * p_due_on                    The optional due on interval for the task
-- * p_priority                  A (optional) task priority, default is 5
--
-- Returns:
-- Returns the ID of the newly created task definition.
--
-- Since:
-- 22.1
--==============================================================================

function create_task_def(
    p_flow_id                in number    default v( 'FB_FLOW_ID' ),
    p_name                   in varchar2,
    p_static_id              in varchar2,
    p_subject                in varchar2,
    p_potential_participant  in varchar2 default null,
    p_admin_participant      in varchar2 default null,
    p_due_on                 in varchar2 default 'NONE',
    p_priority               in integer default wwv_flow_approval_api.c_task_priority_medium,
    p_comment                in varchar2 default null
)
return number;

--==============================================================================
-- synchronizes parameter attributes in all components based on the
-- given task definition id.
--==============================================================================
procedure sync_task_def_param_attributes(
    p_application_id       in number,
    p_task_def_id          in number );

--==============================================================================
-- Creates a unified task list report.
-- Is called by the page creation wizard.
--==============================================================================
procedure create_task_list_report (
    p_flow_id                    in number                 ,
    p_report_page_id             in number                 ,
    p_report_page_name           in varchar2               ,
    p_report_context             in varchar2  default wwv_flow_approval_api.c_context_my_tasks,
    --
    p_group_name                 in varchar2  default null ,
    --
    p_breadcrumb_id              in number    default null ,
    p_breadcrumb_entry_name      in varchar2  default null ,
    p_parent_breadcrumb_entry_id in number    default null ,
    --
    p_nav_list_id                in number    default null ,
    p_nav_list_item_id           in number    default null ,
    p_nav_list_item_name         in varchar2  default null ,
    p_nav_list_item_icon         in varchar2  default null ,
    p_nav_list_parent_item_id    in number    default null ,
    p_nav_list_child_item_name   in varchar2  default null );

--==============================================================================
-- Creates a task details form.
-- Is called by the page creation wizard.
--==============================================================================
procedure create_task_details_forms (
    p_flow_id              in number   ,
    p_details_page_id      in number   ,
    p_task_definition_name in varchar2 );

end wwv_flow_approval_dev;
/

show err
set define '^'
