set define '^' verify off
prompt ...wwv_flow_4050_ui
create or replace package wwv_flow_4050_ui as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 2009 - 2022. All Rights Reserved.
--
--  NAME
--    wwv_flow_4050_ui.sql
--
--  DESCRIPTION
--    User interface plsql for internal administration application
--
--  MODIFIED  (MM/DD/YYYY)
--    mhichwa  05/06/2009 - Created
--    mhichwa  08/14/2009 - added cw and p_chart_width
--    mhichwa  11/16/2009 - added procedure show_edit_system_message
--    jstraub  08/02/2010 - Changed p_days default to be represented is seconds
--    vuvarov  06/26/2012 - Added show_system_message() and system_message_exists()
--    vuvarov  09/18/2014 - Removed show_edit_system_message
--    cneumuel 10/30/2018 - Added p79_validate_password (bug #28855725)
--
--------------------------------------------------------------------------------

--==============================================================================
-- System Messages/Announcements (defined in app 4050, but can be displayed in
-- other apps)
--==============================================================================
procedure show_system_message (
    p_app_session in number default null);

function system_message_exists
    return boolean;
--==============================================================================

--##############################################################################
--#
--# INSTANCE LEVEL REPORTING
--#
--##############################################################################

--==============================================================================
procedure top_applications (
    p_app_session   in varchar2,
    p_image_prefix  in varchar2,
    p_days          in number default 43200, --p_days is now actually in seconds (bug 9886194)
    p_display_count in number default 8,
    p_max_length    in number default 20,
    p_chart_width   in number default 50);

--==============================================================================
procedure top_workspaces (
    p_app_session   in varchar2,
    p_image_prefix  in varchar2,
    p_days          in number default 43200, --p_days is now actually in seconds (bug 9886194)
    p_display_count in number default 8,
    p_max_length    in number default 20,
    p_chart_width   in number default 50 );

--==============================================================================
procedure top_users (
    p_app_session   in varchar2,
    p_image_prefix  in varchar2,
    p_days          in number default 43200, --p_days is now actually in seconds (bug 9886194)
    p_display_count in number default 8,
    p_max_length    in number default 20,
    p_chart_width   in number default 50 );

--##############################################################################
--#
--# WORKSPACE LEVEL REPORTING
--#
--##############################################################################

--==============================================================================
procedure top_workspace_applications (
    p_app_session       in varchar2,
    p_image_prefix      in varchar2,
    p_security_group_id in number,
    p_days              in number default 1,
    p_display_count     in number default 8,
    p_max_length        in number default 20,
    p_chart_width       in number default 50 );

--==============================================================================
procedure top_workspace_users (
    p_app_session       in varchar2,
    p_image_prefix      in varchar2,
    p_security_group_id in number,
    p_days              in number default 1,
    p_display_count     in number default 8,
    p_max_length        in number default 20,
    p_chart_width       in number default 50 );

--==============================================================================
procedure show_workspace_admins (
    p_app_session       in varchar2,
    p_security_group_id in number,
    p_image_prefix      in varchar2,
    p_display_count     in number default 8 );

--##############################################################################
--#
--# PAGE 79
--#
--##############################################################################

--==============================================================================
-- Validate username/password
--==============================================================================
function p79_validate_password (
    p_username in varchar2,
    p_password in varchar2 )
    return boolean;

--##############################################################################
--#
--# PAGE 136
--#
--##############################################################################

--==============================================================================
procedure p136_fetch_credential (
    p_id        out number,
    p_client_id out varchar2 );

--==============================================================================
procedure p136_save_credential (
    p_id            in number,
    p_client_id     in varchar2,
    p_client_secret in varchar2 );

--==============================================================================
procedure p136_fetch_saml_attributes (
    p_saml_enabled                 out varchar2,
    p_saml_ip_issuer               out varchar2,
    p_saml_ip_signing_certificate  out varchar2,
    p_saml_ip_signing_certificate2 out varchar2,
    p_saml_sign_in_url             out varchar2,
    p_saml_sign_out_url            out varchar2,
    p_saml_nameid_format           out varchar2,
    p_saml_sp_issuer               out varchar2,
    p_saml_username_attribute      out varchar2,
    p_saml_apex_certificate        out varchar2,
    p_saml_apex_certificate2       out varchar2,
    p_saml_apex_private_key        out varchar2,
    p_saml_apex_private_key2       out varchar2 );

--==============================================================================
procedure p136_save_saml_attributes (
    p_saml_enabled                 in varchar2,
    p_saml_ip_issuer               in varchar2,
    p_saml_ip_signing_certificate  in varchar2,
    p_saml_ip_signing_certificate2 in varchar2,
    p_saml_sign_in_url             in varchar2,
    p_saml_sign_out_url            in varchar2,
    p_saml_nameid_format           in varchar2,
    p_saml_sp_issuer               in varchar2,
    p_saml_username_attribute      in varchar2,
    p_saml_apex_certificate        in varchar2,
    p_saml_apex_certificate2       in varchar2,
    p_saml_apex_private_key        in varchar2,
    p_saml_apex_private_key2       in varchar2 );

--==============================================================================
-- User Preferences for Workspace Administration
procedure ajax_set_ui_mode;

end wwv_flow_4050_ui;
/
show errors
