set define '^' verify off
prompt ...wwv_data_pkg_api.sql
create or replace package wwv_data_pkg_api as
--------------------------------------------------------------------------------
--
-- Copyright (c) Oracle Corporation 1999 - 2021. All Rights Reserved.
--
-- The APEX_DATA_INSTALL provides the ability to install the data from a Data Package
-- produced in Supporting Objects install scripts. The data is contained in a JSON document
-- as part of the static application files.
--
--    NAME
--      wwv_data_pkg_api.sql
--
--    DESCRIPTION
--      This package contains the API for data install in APEX.
--
--
-- Since: 21.2
--
--    MODIFIED   (MM/DD/YYYY)
--     jstraub    01/11/2021 - Created from Anton Nielsen, Eduardo Diaz
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------

--------------------------------------------------------------------------------

$IF sys.dbms_db_version.version < 18 $THEN

$ELSE
--==================================================================================================================
-- This procedure will load the supporting object data and install the data in the specified application, using the internal package
-- It makes use of the static files generated through the create_data_migration procedure to carry out the installation
--
-- Parameters:
-- * p_table_name:               Name of the table where the data will be loaded into
-- * p_delete_after_install:     default TRUE, indicates if files are removed after installing supporting objects
--   p_app_id:                   APEX application ID of the application that contains the static files associated with a data migration export
--                               This can be used from SQL workshop outside the context of installing supporting objects, allowing a developer
--                               to reinstall migrated data without reinstalling all supporting objects.
--
-- Example:
--
-- This is an example of executing the API from SQL Workshop to load data into the EMP table
-- and get the JSON document from the static application files of application 100.
--
--   declare
--       l_table_name    constant varchar2(30) := 'EMP';
--   begin
--      apex_data_install.load_supporting_object_data(
--          p_table_name            => l_table_name,
--          p_delete_after_install  => true,
--          p_app_id                => 100 );
--   end;
--==================================================================================================================
procedure load_supporting_object_data(
    p_table_name            in varchar2,
    p_delete_after_install  in boolean,
    p_app_id                in number    default null);

$END

end wwv_data_pkg_api;
/
