set define off
set verify off
set serveroutput on size 1000000
set feedback off
--
-- ORACLE
--
-- Application Express (APEX)
--
-- NOTE: This script is auto-generated. Do not edit directly!
--
prompt Set Credentials...
begin
  wwv_flow_api.set_security_group_id(p_security_group_id=>nvl(wwv_flow_application_install.get_workspace_id,12));
end;
/
prompt Creating Packaged Application Wizard Information...
prompt Check Compatibility...
begin
-- This date identifies the minimum version required to import this file.
wwv_flow_team_api.check_version(p_version_yyyy_mm_dd=>'2010.05.13');
end;
/

begin wwv_flow.g_import_in_progress := true; wwv_flow.g_user := USER; end;
/

prompt ...Delete Packaged Applications and associated images
delete from wwv_flow_pkg_app_images
where app_id in ( select id from wwv_flow_pkg_applications where app_group in ('PACKAGE','SAMPLE'))
/
delete from wwv_flow_pkg_applications
where app_group in ('PACKAGE','SAMPLE')
/
update wwv_flow_pkg_applications
set app_category_id_1 = null, app_category_id_2 = null, app_category_id_3 = null
where app_group in ('CUSTOM')
/

prompt ...Load Packaged Application Categories

delete from wwv_flow_pkg_app_categories
/

insert into wwv_flow_pkg_app_categories (
    category_name,
    category_desc )
values (
    'Community',
    '' )
/

insert into wwv_flow_pkg_app_categories (
    category_name,
    category_desc )
values (
    'IT Management',
    '' )
/

insert into wwv_flow_pkg_app_categories (
    category_name,
    category_desc )
values (
    'Knowledge Management',
    '' )
/

insert into wwv_flow_pkg_app_categories (
    category_name,
    category_desc )
values (
    'Marketing',
    '' )
/

insert into wwv_flow_pkg_app_categories (
    category_name,
    category_desc )
values (
    'Other',
    '' )
/

insert into wwv_flow_pkg_app_categories (
    category_name,
    category_desc )
values (
    'Project Management',
    '' )
/

insert into wwv_flow_pkg_app_categories (
    category_name,
    category_desc )
values (
    'Sample',
    '' )
/

insert into wwv_flow_pkg_app_categories (
    category_name,
    category_desc )
values (
    'Software Development',
    '' )
/

insert into wwv_flow_pkg_app_categories (
    category_name,
    category_desc )
values (
    'Team Productivity',
    '' )
/

insert into wwv_flow_pkg_app_categories (
    category_name,
    category_desc )
values (
    'Template',
    '' )
/

insert into wwv_flow_pkg_app_categories (
    category_name,
    category_desc )
values (
    'Tracking',
    '' )
/

update wwv_flow_pkg_applications
set app_category_id_1 = (select id from wwv_flow_pkg_app_categories where category_name = 'Template')
where app_group in ('CUSTOM') and app_category_id_1 is null
/

commit;

set verify on
set feedback on
prompt ...done

