set define off verify off
prompt ...create Quick SQL objects

Rem  Copyright (c) Oracle Corporation 2017 - 2017. All Rights Reserved.
Rem
Rem    NAME
Rem      wwv_qs_tables.sql
Rem
Rem    DESCRIPTION
Rem      Creates the tables required to run Quick SQL functionality from within APEX
Rem
Rem    NOTES
Rem
Rem    REQUIRMENTS
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem    mhichwa     10/12/2017 - Created
Rem    hfarrell    10/27/2017 - Resolved public synonym dependency issues in Hudson: prefixed occurrence of dual with sys.
Rem    jstraub     08/22/2018 - Replaced timestamp with local timezone with date (Bug 28538783)


create sequence WWV_QS_seq  minvalue 1000 maxvalue 999999999999999999999999999 increment by 1 start with 1000 cache 20 noorder  nocycle;

CREATE TABLE WWV_QS_MODELS (
    id                      number primary key,
    name                    varchar2(255) not null,
    description             varchar2(4000),
    model_type              varchar2(60),
    identifier              varchar2(255),
    --
    quick_sql               clob,
    generated_sql           clob,
    --
    ERD                     blob,
    ERD_filename            varchar2(512),
    ERD_mimetype            varchar2(512),
    ERD_charset             varchar2(512),
    ERD_lastupd             date,
    --
    published_yn            varchar2(1) default 'N',
    --
    created                 date,
    created_by              varchar2(255),
    updated                 date,
    updated_by              varchar2(255)
    )
/


create or replace trigger biu_wwv_qs_models
before insert or update on wwv_qs_models
for each row
begin
    if inserting then
        if :new.id is null then
            :new.id := to_number(sys_guid(), 'XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX');
        end if;
        :new.created_by         := nvl(v('APP_USER'), USER);
        :new.created            := sysdate;
    end if;
    :new.identifier := lower(:new.identifier);
    :NEW.UPDATED := sysdate;
    :NEW.UPDATED_BY := nvl(v('APP_USER'),USER);
    if :new.published_yn is null then
       :new.published_yn := 'N';
    end if;
end;
/
show errors

create unique index wwv_qs_models_i1 on WWV_QS_models(identifier)
/

create table wwv_qs_random_names (
    id                             number not null constraint wwv_qs_random_id_pk primary key,
    seq                            integer,
    language                       varchar2(30) default 'en',
    first_name                     varchar2(255),
    last_name                      varchar2(255),
    full_name                      varchar2(255),
    email                          varchar2(255),
    profile                        varchar2(4000),
    job                            varchar2(100),
    guid                           varchar2(255),
    phone_number                   varchar2(30),
    num_1_100                      integer,
    num_1_10                       integer,
    words_1                        varchar2(100),
    words_2                        varchar2(100),
    words_3                        varchar2(255),
    words_4                        varchar2(255),
    words_1_60                     varchar2(4000),
    words_1_100                    varchar2(4000),
    project_name                   varchar2(100),
    department_name                varchar2(100),
    city                           varchar2(100),
    country                        varchar2(50),
    tswtz                          timestamp with time zone,
    tswltz                         date,
    d                              date,
    tags                           varchar2(4000) );

create sequence wwv_qs_random_names_seq;

set define '^'
