set define '^' verify off
prompt ...wwv_qs_design_schema_pub
create or replace package wwv_qs_design_schema_pub as
--------------------------------------------------------------------------------
--
--  Copyright (c) Oracle Corporation 2017 - 2021. All Rights Reserved.
--
--    NAME
--      wwv_qs_design_schema_pub.sql
--
--    DESCRIPTION
--     Primary package that facilitates Quick SQL functionality within APEX
--
--    NOTES
--      This API is unsupported.    
--
--    MODIFIED    (MM/DD/YYYY)
--     mhichwa     10/12/2017 - Created
--
--------------------------------------------------------------------------------

--------------------------------------------------------------------------------
-- Global variables
--------------------------------------------------------------------------------
g_enable_inserts         boolean := true;
g_clob                   clob := null;
g_gen_mode               varchar2(30) := 'HTP';    -- valid values are HTP and CLOB

--==============================================================================
-- Functions used in Quick SQL Help
--==============================================================================
function get_view_syntax return varchar2 ;

function get_pound_options return varchar2;
   
function get_column_datatypes return varchar2;

function get_column_directives return varchar2;

function get_table_directives return varchar2;

function get_about return varchar2 ;

--==============================================================================
-- Generation API
--==============================================================================
function get_default_db_version return varchar2;

procedure add_tables (
    p_table_prefix       in varchar2 default null,
    p_date_datatype      in varchar2 default null,
    p_inc_auditing       in varchar2 default null,
    p_primary_key        in varchar2 default null,
    p_tables             in varchar2 default null,
    p_row_version        in varchar2 default 'N',
    p_row_key            in varchar2 default 'N',
    p_tenant_id          in varchar2 default 'N',
    p_compressed         in varchar2 default 'N',
    p_longer_identifiers in varchar2 default 'N',
    p_auto_gen_pk        in varchar2 default 'Y',
    p_apis               in varchar2 default 'N',
    p_audit_cols         in varchar2 default 'N',
    p_audit              in varchar2 default 'N',
    p_longer_varchars_yn in varchar2 default 'N',
    p_verbose_yn         in varchar2 default 'N',
    p_schema             in varchar2 default null,
    p_inserts            in number   default 0,
    p_selects            in varchar2 default 'N',
    p_uncomment          in varchar2 default 'Y',
    p_tags_fw_yn         in varchar2 default 'N',
    p_semantics          in varchar2 default 'DEFAULT' );
    
procedure save_as_sql (
    p_app_user           in varchar2 default null,
    p_app_session        in varchar2 default null,
    p_trigger_method     in varchar2 default 'STANDARD',
    p_fk                 in varchar2 default 'RESTRICT',
    P_row_version        in varchar2 default 'N',
    p_row_key            in varchar2 default 'N',
    p_tenant_id          in varchar2 default 'N',
    P_TABLE_PREFIX       in varchar2 default null,
    p_compressed         in varchar2 default 'N',
    p_db_version         in varchar2 default null,
    p_include_drops      in varchar2 default 'N',
    p_LONGER_IDENTIFIERS in varchar2 default 'N',
    p_apis               in varchar2 default 'N',
    p_AUTO_GEN_PK        in varchar2 default 'Y',
    p_audit_cols         in varchar2 default 'N',
    p_DATE_DATATYPE      in varchar2 default 'DATE',
    p_editionable        in varchar2 default 'N',
    p_language           in varchar2 default 'EN',
    p_apex               in varchar2 default 'N',
    --
    p_prefix_pk_with_tname   in varchar2, --mike
    p_created_column_name    in varchar2, --mike
    p_created_by_column_name in varchar2, --mike
    p_updated_column_name    in varchar2, --mike
    p_updated_by_column_name in varchar2, --mike
    --
    p_audit              in varchar2 default 'N',
    p_longer_varchars_yn in varchar2 default 'N',
    p_verbose_yn         in varchar2 default 'N',
    p_schema             in varchar2 default null,
    p_inserts            in number   default 0,
    p_selects            in varchar2 default 'N',
    p_uncomment          in varchar2 default 'Y',
    p_format_mask        in varchar2 default 'MM/DD/RR HH24:MI',
    p_tags_fw_yn         in varchar2 default 'N',
    p_semantics           in varchar2 default 'DEFAULT',
    --
    p_message            out varchar2,
    p_script_id          out varchar2 );

procedure print_settings (p_text in varchar2 default null);

end wwv_qs_design_schema_pub;
/
show errors

set define '^'
