Rem  Copyright (c) Oracle Corporation 2006 - 2021. All Rights Reserved.
Rem
Rem    NAME
Rem      odg_install_data.sql
Rem
Rem    DESCRIPTION
Rem      Insert data into Data Generator tables during APEX installation
Rem
Rem    MODIFIED     (MM/DD/YYYY)
Rem      jstraub     12/11/2020 - Created from Anton Nielsen, Neelesh Shah

set define '^'

prompt deleting wwv_dg_helper_data

delete from wwv_dg_builtin_animals where seeded_data_yn = 'Y';
delete from wwv_dg_builtin_cars where seeded_data_yn = 'Y';
delete from wwv_dg_builtin_icd_diags where seeded_data_yn = 'Y';
delete from wwv_dg_builtin_icd_procs where seeded_data_yn = 'Y';
delete from wwv_dg_builtin_locations where seeded_data_yn = 'Y';
delete from wwv_dg_builtin_plants where seeded_data_yn = 'Y';
delete from wwv_dg_builtin_products where seeded_data_yn = 'Y';
delete from wwv_dg_builtin_airports where seeded_data_yn = 'Y';
delete from wwv_dg_helper_data where seeded_data_yn = 'Y';
delete from wwv_dg_helper_persons where seeded_data_yn = 'Y';
delete from wwv_dg_meta_tables;
delete from wwv_dg_meta_tab_cols;
delete from wwv_dg_meta_mappings;
delete from wwv_dg_blueprint_samples;
commit;



prompt inserting wwv_dg_helper_data

  declare
    procedure i (
      p_make              in varchar2,
      p_model             in varchar2,
      p_year              in number,
      p_engine_fuel_type  in varchar2,
      p_engine_hp         in number,
      p_engine_cylinders  in number,
      p_transmission_type in varchar2,
      p_driven_wheels     in varchar2,
      p_number_of_doors   in number,
      p_market_category   in varchar2,
      p_vehicle_size      in varchar2,
      p_vehicle_style     in varchar2,
      p_highway_mpg       in number,
      p_city_mpg          in number,
      p_msrp              in number,
      p_lang              in varchar2,
      p_version_number    in number,
      p_seeded_data_yn    in varchar2
    )
    is
    begin
      insert into wwv_dg_builtin_cars (make,model,year,engine_fuel_type,engine_hp,engine_cylinders,transmission_type,driven_wheels,number_of_doors,market_category,vehicle_size,vehicle_style,highway_mpg,city_mpg,msrp,lang,version_number,seeded_data_yn)
      values (p_make, p_model, p_year, p_engine_fuel_type, p_engine_hp, p_engine_cylinders, p_transmission_type, p_driven_wheels, p_number_of_doors, p_market_category, p_vehicle_size, p_vehicle_style, p_highway_mpg, p_city_mpg, p_msrp, p_lang, p_version_number,p_seeded_data_yn);
    end i;
  begin
   i('Honda','Accord Plug-In Hybrid',2014,'regular unleaded',196,4,'AUTOMATIC','front wheel drive',4,'Hybrid','Midsize','Sedan',46,47,39780,'en',1,'Y');
   i('Honda','Accord',2017,'regular unleaded',185,4,'AUTOMATIC','front wheel drive',2,'N/A','Midsize','Coupe',34,26,30995,'en',1,'Y');
   i('Lamborghini','Gallardo',2014,'premium unleaded (required)',560,10,'MANUAL','all wheel drive',2,'Exotic,High-Performance','Compact','Convertible',20,13,225400,'en',1,'Y');
   i('Suzuki','Equator',2011,'regular unleaded',261,6,'AUTOMATIC','rear wheel drive',4,'N/A','Compact','Crew Cab Pickup',20,15,25279,'en',1,'Y');
   i('Hyundai','Entourage',2008,'regular unleaded',250,6,'AUTOMATIC','front wheel drive',4,'N/A','Midsize','Passenger Minivan',23,16,23995,'en',1,'Y');
   i('Hyundai','Accent',2016,'regular unleaded',137,4,'AUTOMATIC','front wheel drive',4,'N/A','Compact','Sedan',37,26,15745,'en',1,'Y');
   i('Hyundai','Accent',2015,'regular unleaded',137,4,'AUTOMATIC','front wheel drive',4,'N/A','Compact','Sedan',37,26,15745,'en',1,'Y');
   i('Hyundai','Accent',2014,'regular unleaded',138,4,'AUTOMATIC','front wheel drive',4,'Hatchback','Compact','4dr Hatchback',37,27,16095,'en',1,'Y');
   i('Chevrolet','Astro Cargo',2004,'regular unleaded',190,6,'AUTOMATIC','all wheel drive',3,'N/A','Large','Cargo Minivan',18,14,25195,'en',1,'Y');
   i('Oldsmobile','Aurora',2001,'regular unleaded',215,6,'AUTOMATIC','front wheel drive',4,'N/A','Large','Sedan',25,17,30619,'en',1,'Y');
   i('Mazda','CX-7',2012,'premium unleaded (recommended)',244,4,'AUTOMATIC','all wheel drive',4,'Crossover','Midsize','4dr SUV',21,17,28155,'en',1,'Y');
   i('Hyundai','Santa Fe',2015,'regular unleaded',290,6,'AUTOMATIC','all wheel drive',4,'Crossover','Midsize','4dr SUV',24,18,31900,'en',1,'Y');
   i('Toyota','Avalon Hybrid',2016,'regular unleaded',200,4,'AUTOMATIC','front wheel drive',4,'Hybrid','Midsize','Sedan',39,40,36650,'en',1,'Y');
   i('Scion','tC',2016,'regular unleaded',179,4,'AUTOMATIC','front wheel drive',2,'Hatchback','Compact','2dr Hatchback',31,23,24340,'en',1,'Y');
   i('Toyota','Avalon Hybrid',2017,'regular unleaded',200,4,'AUTOMATIC','front wheel drive',4,'Hybrid','Midsize','Sedan',39,40,42550,'en',1,'Y');
   i('Honda','Crosstour',2013,'regular unleaded',192,4,'AUTOMATIC','front wheel drive',4,'Crossover,Hatchback','Midsize','4dr Hatchback',31,22,33015,'en',1,'Y');
   i('Ford','F-150',2015,'flex-fuel (unleaded/E85)',385,8,'AUTOMATIC','four wheel drive',4,'Flex Fuel','Large','Crew Cab Pickup',21,15,52545,'en',1,'Y');
   i('Chevrolet','Corvette Stingray',2014,'premium unleaded (recommended)',455,8,'MANUAL','rear wheel drive',2,'High-Performance','Compact','Coupe',29,17,57000,'en',1,'Y');
   i('Mitsubishi','Eclipse Spyder',2012,'regular unleaded',162,4,'AUTOMATIC','front wheel drive',2,'N/A','Compact','Convertible',27,20,28299,'en',1,'Y');
   i('Ford','F-150',2016,'flex-fuel (unleaded/E85)',385,8,'AUTOMATIC','four wheel drive',4,'Flex Fuel','Large','Extended Cab Pickup',21,15,40070,'en',1,'Y');
   i('Ford','F-150',2016,'flex-fuel (unleaded/E85)',282,6,'AUTOMATIC','rear wheel drive',2,'Flex Fuel','Large','Regular Cab Pickup',25,18,26540,'en',1,'Y');
   i('Toyota','Highlander Hybrid',2015,'regular unleaded',280,6,'AUTOMATIC','all wheel drive',4,'Crossover,Hybrid','Midsize','4dr SUV',28,27,47850,'en',1,'Y');
   i('Suzuki','Grand Vitara',2013,'regular unleaded',166,4,'AUTOMATIC','rear wheel drive',4,'Crossover','Compact','4dr SUV',25,19,22349,'en',1,'Y');
   i('Lotus','Elise',2011,'premium unleaded (required)',189,4,'MANUAL','rear wheel drive',2,'Exotic,High-Performance','Compact','Convertible',27,21,51845,'en',1,'Y');
   i('Lotus','Exige',2011,'premium unleaded (recommended)',257,4,'MANUAL','rear wheel drive',2,'Exotic,High-Performance','Compact','Coupe',26,20,74950,'en',1,'Y');
   i('Ford','Explorer Sport Trac',2008,'regular unleaded',210,6,'AUTOMATIC','four wheel drive',4,'N/A','Compact','Crew Cab Pickup',19,13,30015,'en',1,'Y');
   i('Cadillac','Escalade Hybrid',2011,'regular unleaded',332,8,'AUTOMATIC','rear wheel drive',4,'Luxury,Hybrid','Large','4dr SUV',23,20,74135,'en',1,'Y');
   i('Cadillac','Escalade Hybrid',2012,'regular unleaded',332,8,'AUTOMATIC','rear wheel drive',4,'Luxury,Hybrid','Large','4dr SUV',23,20,73850,'en',1,'Y');
   i('Chrysler','Town and Country',2016,'flex-fuel (unleaded/E85)',283,6,'AUTOMATIC','front wheel drive',4,'Flex Fuel','Midsize','Passenger Minivan',25,17,31875,'en',1,'Y');
   i('Pontiac','Firebird',2000,'regular unleaded',200,6,'MANUAL','rear wheel drive',2,'Performance','Midsize','Convertible',28,17,5844,'en',1,'Y');
   i('Dodge','Charger',2017,'regular unleaded',370,8,'AUTOMATIC','rear wheel drive',4,'High-Performance','Large','Sedan',25,16,39890,'en',1,'Y');
   i('HUMMER','H3',2010,'flex-fuel (unleaded/E85)',300,8,'AUTOMATIC','four wheel drive',4,'Flex Fuel,Luxury','Midsize','4dr SUV',16,13,41705,'en',1,'Y');
   i('Mitsubishi','i-MiEV',2016,'electric',66,null,'DIRECT_DRIVE','rear wheel drive',4,'Hatchback','Compact','4dr Hatchback',99,126,22995,'en',1,'Y');
   i('Mitsubishi','i-MiEV',2017,'electric',66,null,'DIRECT_DRIVE','rear wheel drive',4,'Hatchback','Compact','4dr Hatchback',102,121,22995,'en',1,'Y');
   i('Rolls-Royce','Ghost Series II',2015,'premium unleaded (required)',563,12,'AUTOMATIC','rear wheel drive',4,'Exotic,Luxury,Performance','Large','Sedan',21,13,319400,'en',1,'Y');
   i('Mazda','Tribute',2010,'regular unleaded',171,4,'AUTOMATIC','all wheel drive',4,'Crossover','Compact','4dr SUV',26,20,25345,'en',1,'Y');
   i('Mazda','Tribute',2011,'regular unleaded',171,4,'AUTOMATIC','front wheel drive',4,'Crossover','Compact','4dr SUV',28,21,25700,'en',1,'Y');
   i('Oldsmobile','Cutlass Supreme',1995,'regular unleaded',160,6,'AUTOMATIC','front wheel drive',2,'N/A','Midsize','Coupe',26,17,2000,'en',1,'Y');
   i('Ford','Mustang',2017,'premium unleaded (recommended)',435,8,'MANUAL','rear wheel drive',2,'Performance','Midsize','Convertible',23,14,42145,'en',1,'Y');
   i('Subaru','Forester',2015,'regular unleaded',170,4,'AUTOMATIC','all wheel drive',4,'Crossover','Midsize','4dr SUV',32,24,30095,'en',1,'Y');
   i('Subaru','Forester',2016,'regular unleaded',170,4,'AUTOMATIC','all wheel drive',4,'Crossover','Midsize','4dr SUV',32,24,23395,'en',1,'Y');
   i('Subaru','Forester',2017,'regular unleaded',170,4,'AUTOMATIC','all wheel drive',4,'Crossover','Midsize','4dr SUV',32,26,23595,'en',1,'Y');
   i('Lexus','HS 250h',2010,'regular unleaded',187,4,'AUTOMATIC','front wheel drive',4,'Luxury,Hybrid','Midsize','Sedan',34,35,37420,'en',1,'Y');
   i('Scion','FR-S',2014,'premium unleaded (required)',200,4,'MANUAL','rear wheel drive',2,'Performance','Compact','Coupe',30,22,27400,'en',1,'Y');
   i('Toyota','Prius Prime',2017,'regular unleaded',121,4,'AUTOMATIC','front wheel drive',4,'Hatchback,Hybrid','Compact','4dr Hatchback',53,55,27100,'en',1,'Y');
   i('Toyota','Prius',2017,'regular unleaded',121,4,'AUTOMATIC','front wheel drive',4,'Hatchback,Hybrid','Compact','4dr Hatchback',50,54,24685,'en',1,'Y');
   i('Honda','Fit EV',2014,'electric',null,0,'DIRECT_DRIVE','front wheel drive',4,'Hatchback','Compact','4dr Hatchback',105,132,36625,'en',1,'Y');
   i('Honda','Fit',2016,'regular unleaded',130,4,'MANUAL','front wheel drive',4,'Hatchback','Compact','4dr Hatchback',37,29,15890,'en',1,'Y');
   i('Toyota','Camry Hybrid',2017,'regular unleaded',200,4,'AUTOMATIC','front wheel drive',4,'Hybrid','Midsize','Sedan',38,42,26790,'en',1,'Y');
   i('Toyota','Camry',2017,'regular unleaded',178,4,'AUTOMATIC','front wheel drive',4,'N/A','Midsize','Sedan',33,24,26310,'en',1,'Y');
   i('Nissan','Leaf',2015,'electric',null,0,'DIRECT_DRIVE','front wheel drive',4,'Hatchback','Compact','4dr Hatchback',101,126,32100,'en',1,'Y');
   i('Subaru','Crosstrek',2016,'regular unleaded',160,4,'AUTOMATIC','all wheel drive',4,'Crossover,Hybrid','Compact','4dr SUV',34,30,29995,'en',1,'Y');
   i('GMC','Savana',2015,'flex-fuel (unleaded/E85)',285,8,'AUTOMATIC','rear wheel drive',3,'Flex Fuel','Large','Passenger Van',17,11,36355,'en',1,'Y');
   i('Acura','ZDX',2013,'premium unleaded (recommended)',300,6,'AUTOMATIC','all wheel drive',4,'Crossover,Hatchback,Luxury','Midsize','4dr Hatchback',23,16,50920,'en',1,'Y');
   i('Aston Martin','V12 Vanquish',2006,'premium unleaded (required)',520,12,'AUTOMATED_MANUAL','rear wheel drive',2,'Exotic,Factory Tuner,High-Performance','Compact','Coupe',16,10,260000,'en',1,'Y');
   i('Toyota','Venza',2013,'regular unleaded',181,4,'AUTOMATIC','front wheel drive',4,'Crossover','Midsize','Wagon',26,20,27850,'en',1,'Y');
   i('Volkswagen','Jetta SportWagen',2014,'diesel',140,4,'MANUAL','front wheel drive',4,'Diesel','Compact','Wagon',42,30,28365,'en',1,'Y');
   i('Volkswagen','Jetta',2015,'regular unleaded',170,4,'AUTOMATIC','front wheel drive',4,'N/A','Midsize','Sedan',37,25,22325,'en',1,'Y');
   i('Nissan','Sentra',2015,'regular unleaded',130,4,'MANUAL','front wheel drive',4,'N/A','Midsize','Sedan',36,27,16530,'en',1,'Y');
   i('Nissan','Sentra',2016,'regular unleaded',130,4,'AUTOMATIC','front wheel drive',4,'N/A','Midsize','Sedan',38,29,17760,'en',1,'Y');
   i('Kia','Sportage',2015,'regular unleaded',260,4,'AUTOMATIC','front wheel drive',4,'Crossover','Compact','4dr SUV',26,20,28100,'en',1,'Y');
   i('Kia','Sportage',2016,'regular unleaded',260,4,'AUTOMATIC','front wheel drive',4,'Crossover','Compact','4dr SUV',26,20,29990,'en',1,'Y');
   i('Acura','TL',2012,'premium unleaded (required)',305,6,'AUTOMATIC','all wheel drive',4,'Luxury,Performance','Midsize','Sedan',26,18,39255,'en',1,'Y');
   i('Tesla','Model S',2016,'electric',null,0,'DIRECT_DRIVE','rear wheel drive',4,'Exotic,Performance','Large','Sedan',90,88,70000,'en',1,'Y');
   i('GMC','Jimmy',1999,'regular unleaded',190,6,'MANUAL','rear wheel drive',2,'N/A','Compact','2dr SUV',21,15,2038,'en',1,'Y');
   i('GMC','Jimmy',2000,'regular unleaded',190,6,'UNKNOWN','rear wheel drive',2,'N/A','Compact','2dr SUV',20,15,2407,'en',1,'Y');
   i('Volkswagen','New Beetle',2010,'regular unleaded',150,5,'AUTOMATIC','front wheel drive',2,'Hatchback','Compact','2dr Hatchback',29,20,20390,'en',1,'Y');
   i('Bentley','Continental Supersports',2010,'flex-fuel (premium unleaded required/E85)',621,12,'AUTOMATIC','all wheel drive',2,'Exotic,Flex Fuel,Factory Tuner,Luxury,High-Performance','Midsize','Coupe',19,12,267000,'en',1,'Y');
   i('Buick','Skylark',1997,'regular unleaded',155,6,'AUTOMATIC','front wheel drive',2,'N/A','Midsize','Coupe',26,18,2000,'en',1,'Y');
   i('Suzuki','Kizashi',2012,'regular unleaded',180,4,'AUTOMATIC','front wheel drive',4,'N/A','Midsize','Sedan',31,23,20999,'en',1,'Y');
   i('Suzuki','Kizashi',2013,'regular unleaded',180,4,'AUTOMATIC','all wheel drive',4,'N/A','Midsize','Sedan',29,22,28999,'en',1,'Y');
   i('Audi','S5',2016,'premium unleaded (required)',333,6,'MANUAL','all wheel drive',2,'Factory Tuner,Luxury,High-Performance','Midsize','Coupe',26,17,53100,'en',1,'Y');
   i('Kia','Rio',2016,'regular unleaded',138,4,'AUTOMATIC','front wheel drive',4,'N/A','Compact','Sedan',37,27,15395,'en',1,'Y');
   i('Suzuki','XL-7',2004,'regular unleaded',185,6,'AUTOMATIC','four wheel drive',4,'N/A','Midsize','4dr SUV',20,15,22999,'en',1,'Y');
   i('Honda','Insight',2014,'regular unleaded',98,4,'AUTOMATIC','front wheel drive',4,'Hatchback,Hybrid','Compact','4dr Hatchback',44,41,20500,'en',1,'Y');
   i('Dodge','Ram Pickup 1500',2010,'flex-fuel (unleaded/E85)',310,8,'AUTOMATIC','rear wheel drive',4,'Flex Fuel','Large','Crew Cab Pickup',19,14,31020,'en',1,'Y');
   i('Land Rover','Range Rover',2015,'flex-fuel (premium unleaded required/E85)',340,6,'AUTOMATIC','four wheel drive',4,'Flex Fuel,Luxury','Large','4dr SUV',23,17,89995,'en',1,'Y');
   i('Land Rover','Range Rover Evoque',2015,'premium unleaded (recommended)',240,4,'AUTOMATIC','all wheel drive',4,'Crossover,Luxury','Compact','4dr SUV',30,21,48300,'en',1,'Y');
   i('Honda','S2000',2007,'premium unleaded (required)',237,4,'MANUAL','rear wheel drive',2,'Performance','Compact','Convertible',24,18,34250,'en',1,'Y');
   i('Pontiac','Solstice',2007,'premium unleaded (required)',260,4,'MANUAL','rear wheel drive',2,'Factory Tuner,High-Performance','Compact','Convertible',28,19,26515,'en',1,'Y');
   i('Mazda','Mazdaspeed MX-5 Miata',2004,'premium unleaded (required)',178,4,'MANUAL','rear wheel drive',2,'Factory Tuner,Performance','Compact','Convertible',24,18,25730,'en',1,'Y');
   i('Mazda','Mazdaspeed MX-5 Miata',2005,'premium unleaded (required)',178,4,'MANUAL','rear wheel drive',2,'Factory Tuner,Performance','Compact','Convertible',24,18,25780,'en',1,'Y');
   i('Tesla','Model S',2014,'electric',null,0,'DIRECT_DRIVE','all wheel drive',4,'Exotic,High-Performance','Large','Sedan',94,86,104500,'en',1,'Y');
   i('Porsche','Cayman',2015,'premium unleaded (required)',275,6,'MANUAL','rear wheel drive',2,'Luxury,High-Performance','Compact','Coupe',30,20,52600,'en',1,'Y');
   i('Porsche','Cayman',2016,'premium unleaded (required)',325,6,'MANUAL','rear wheel drive',2,'Luxury,High-Performance','Compact','Coupe',28,20,64100,'en',1,'Y');
   i('Buick','Cascada',2017,'premium unleaded (recommended)',200,4,'AUTOMATIC','front wheel drive',2,'N/A','Midsize','Convertible',27,20,33065,'en',1,'Y');
   i('GMC','Canyon',2016,'regular unleaded',200,4,'AUTOMATIC','four wheel drive',4,'N/A','Compact','Extended Cab Pickup',25,19,31855,'en',1,'Y');
   i('HUMMER','H3T',2009,'regular unleaded',300,8,'AUTOMATIC','four wheel drive',4,'Crossover,Luxury','Compact','Crew Cab Pickup',16,13,36015,'en',1,'Y');
   i('Ford','Escape',2016,'regular unleaded',168,4,'AUTOMATIC','front wheel drive',4,'Crossover','Compact','4dr SUV',31,22,23590,'en',1,'Y');
   i('Ford','Mustang',2016,'premium unleaded (recommended)',310,4,'MANUAL','rear wheel drive',2,'Performance','Midsize','Coupe',31,22,29645,'en',1,'Y');
   i('Buick','Park Avenue',2005,'premium unleaded (required)',240,6,'AUTOMATIC','front wheel drive',4,'Performance','Large','Sedan',26,17,40730,'en',1,'Y');
   i('Honda','Fit',2017,'regular unleaded',130,4,'AUTOMATIC','front wheel drive',4,'Hatchback','Compact','4dr Hatchback',37,32,20265,'en',1,'Y');
   i('Subaru','Crosstrek',2017,'regular unleaded',148,4,'MANUAL','all wheel drive',4,'Crossover','Compact','4dr SUV',30,23,22495,'en',1,'Y');
   i('Volkswagen','e-Golf',2015,'electric',115,null,'DIRECT_DRIVE','front wheel drive',4,'Hatchback','Compact','4dr Hatchback',105,126,33450,'en',1,'Y');
   i('Toyota','Corolla',2016,'regular unleaded',132,4,'AUTOMATIC','front wheel drive',4,'N/A','Compact','Sedan',37,29,20065,'en',1,'Y');
   i('Audi','A7',2017,'premium unleaded (required)',333,6,'AUTOMATIC','all wheel drive',4,'Luxury,Performance','Large','Sedan',29,21,68800,'en',1,'Y');
   i('Lincoln','Continental',2017,'regular unleaded',305,6,'AUTOMATIC','front wheel drive',4,'Luxury','Large','Sedan',26,17,44560,'en',1,'Y');
   i('Lexus','GS 350',2015,'premium unleaded (required)',306,6,'AUTOMATIC','all wheel drive',4,'Luxury,Performance','Midsize','Sedan',26,19,50850,'en',1,'Y');
   i('BMW','8 Series',1995,'regular unleaded',322,12,'AUTOMATIC','rear wheel drive',2,'Luxury,Performance','Midsize','Coupe',19,12,5858,'en',1,'Y');
   i('Chrysler','300M',2004,'regular unleaded',250,6,'AUTOMATIC','front wheel drive',4,'Performance','Large','Sedan',25,16,29185,'en',1,'Y');
   i('Nissan','300ZX',1995,'regular unleaded',300,6,'MANUAL','rear wheel drive',2,'Performance','Compact','Coupe',22,16,3049,'en',1,'Y');
   i('Ferrari','360',2002,'premium unleaded (required)',400,8,'MANUAL','rear wheel drive',2,'Exotic,High-Performance','Compact','Convertible',15,10,160829,'en',1,'Y');
   i('Audi','100',1992,'regular unleaded',172,6,'MANUAL','front wheel drive',4,'Luxury','Midsize','Sedan',24,17,2000,'en',1,'Y');
   i('FIAT','124 Spider',2017,'premium unleaded (recommended)',160,4,'MANUAL','rear wheel drive',2,'Performance','Compact','Convertible',35,26,24995,'en',1,'Y');
   i('BMW','2 Series',2016,'premium unleaded (required)',240,4,'AUTOMATIC','rear wheel drive',2,'Luxury','Compact','Convertible',34,23,38650,'en',1,'Y');
   i('BMW','2 Series',2017,'premium unleaded (recommended)',248,4,'AUTOMATIC','rear wheel drive',2,'Luxury,Performance','Compact','Coupe',35,24,33150,'en',1,'Y');
   i('Chrysler','200',2016,'flex-fuel (unleaded/E85)',184,4,'AUTOMATIC','front wheel drive',4,'Flex Fuel','Midsize','Sedan',36,23,22490,'en',1,'Y');
   i('Chrysler','200',2017,'flex-fuel (unleaded/E85)',184,4,'AUTOMATIC','front wheel drive',4,'Flex Fuel','Midsize','Sedan',36,23,22490,'en',1,'Y');
   i('Plymouth','Grand Voyager',1998,'regular unleaded',150,6,'AUTOMATIC','front wheel drive',4,'N/A','Large','Passenger Minivan',22,17,2000,'en',1,'Y');
   i('Plymouth','Grand Voyager',1999,'flex-fuel (unleaded/E85)',158,6,'AUTOMATIC','front wheel drive',4,'Flex Fuel','Large','Passenger Minivan',22,16,2055,'en',1,'Y');
   i('Volvo','240',1991,'regular unleaded',114,4,'AUTOMATIC','rear wheel drive',4,'Luxury','Midsize','Wagon',23,18,2000,'en',1,'Y');
   i('Volvo','240',1992,'regular unleaded',114,4,'MANUAL','rear wheel drive',4,'Luxury','Midsize','Wagon',26,19,2000,'en',1,'Y');
   i('Mercedes-Benz','C-Class',2017,'premium unleaded (required)',241,4,'AUTOMATIC','all wheel drive',4,'Luxury','Midsize','Sedan',31,24,43675,'en',1,'Y');
   i('Mercedes-Benz','C-Class',2016,'premium unleaded (required)',241,4,'AUTOMATIC','rear wheel drive',4,'Luxury','Midsize','Sedan',34,25,39275,'en',1,'Y');
   i('Mercedes-Benz','C-Class',2015,'premium unleaded (required)',241,4,'AUTOMATIC','all wheel drive',4,'Luxury','Midsize','Sedan',31,24,40400,'en',1,'Y');
   i('BMW','3 Series Gran Turismo',2016,'premium unleaded (required)',300,6,'AUTOMATIC','all wheel drive',4,'Hatchback,Luxury,Performance','Midsize','4dr Hatchback',30,20,49200,'en',1,'Y');
   i('BMW','3 Series',2017,'diesel',180,4,'AUTOMATIC','all wheel drive',4,'Diesel,Luxury','Midsize','Wagon',40,30,44450,'en',1,'Y');
   i('Infiniti','G Sedan',2011,'premium unleaded (recommended)',218,6,'AUTOMATIC','rear wheel drive',4,'Luxury','Midsize','Sedan',29,20,32000,'en',1,'Y');
   i('Subaru','Impreza WRX',2013,'premium unleaded (required)',265,4,'MANUAL','all wheel drive',4,'Performance','Compact','Sedan',25,19,25795,'en',1,'Y');
   i('Mitsubishi','Lancer Evolution',2013,'premium unleaded (required)',291,4,'AUTOMATED_MANUAL','all wheel drive',4,'Factory Tuner,Performance','Compact','Sedan',22,17,37895,'en',1,'Y');
   i('Mitsubishi','3000GT',1997,'regular unleaded',218,6,'MANUAL','front wheel drive',2,'Hatchback,Performance','Compact','2dr Hatchback',23,17,3941,'en',1,'Y');
   i('Chrysler','300',2016,'regular unleaded',292,6,'AUTOMATIC','rear wheel drive',4,'N/A','Large','Sedan',31,19,32260,'en',1,'Y');
   i('Cadillac','CTS Coupe',2013,'regular unleaded',318,6,'AUTOMATIC','rear wheel drive',2,'Luxury,Performance','Midsize','Coupe',27,18,48150,'en',1,'Y');
   i('Cadillac','CTS Coupe',2014,'regular unleaded',318,6,'AUTOMATIC','rear wheel drive',2,'Luxury,Performance','Midsize','Coupe',27,18,39495,'en',1,'Y');
   i('Mazda','3',2017,'regular unleaded',155,4,'AUTOMATIC','front wheel drive',4,'N/A','Midsize','Sedan',37,28,21495,'en',1,'Y');
   i('Ford','Focus ST',2016,'premium unleaded (recommended)',252,4,'MANUAL','front wheel drive',4,'Hatchback,Factory Tuner,Performance','Compact','4dr Hatchback',31,22,24425,'en',1,'Y');
   i('Ford','Focus',2015,'electric',null,0,'DIRECT_DRIVE','front wheel drive',4,'Hatchback','Compact','4dr Hatchback',99,110,29170,'en',1,'Y');
   i('Ford','Focus',2017,'flex-fuel (unleaded/E85)',160,4,'MANUAL','front wheel drive',4,'Flex Fuel','Compact','Sedan',36,26,16775,'en',1,'Y');
   i('Volkswagen','Beetle Convertible',2014,'diesel',140,4,'MANUAL','front wheel drive',2,'Diesel','Compact','Convertible',41,28,28895,'en',1,'Y');
   i('Volkswagen','Beetle Convertible',2015,'diesel',150,4,'MANUAL','front wheel drive',2,'Diesel','Compact','Convertible',40,30,30295,'en',1,'Y');
   i('Chevrolet','Blazer',2003,'regular unleaded',190,6,'MANUAL','rear wheel drive',2,'N/A','Compact','2dr SUV',20,14,22845,'en',1,'Y');
   i('Chevrolet','Blazer',2004,'regular unleaded',190,6,'AUTOMATIC','rear wheel drive',4,'N/A','Midsize','4dr SUV',19,14,25230,'en',1,'Y');
   i('Toyota','Corolla',2017,'regular unleaded',140,4,'AUTOMATIC','front wheel drive',4,'N/A','Compact','Sedan',40,30,19335,'en',1,'Y');
   i('Toyota','Corolla iM',2017,'regular unleaded',137,4,'AUTOMATIC','front wheel drive',4,'Hatchback','Compact','4dr Hatchback',36,28,19490,'en',1,'Y');
   i('Toyota','4Runner',2015,'regular unleaded',270,6,'AUTOMATIC','four wheel drive',4,'N/A','Midsize','4dr SUV',21,17,36115,'en',1,'Y');
   i('FIAT','500',2016,'premium unleaded (recommended)',101,4,'MANUAL','front wheel drive',2,'N/A','Compact','Convertible',40,31,24495,'en',1,'Y');
   i('FIAT','500',2017,'premium unleaded (recommended)',101,4,'AUTOMATIC','front wheel drive',2,'N/A','Compact','Convertible',33,27,20885,'en',1,'Y');
   i('Nissan','370Z',2015,'premium unleaded (required)',332,6,'AUTOMATIC','rear wheel drive',2,'High-Performance','Compact','Convertible',25,18,49400,'en',1,'Y');
   i('GMC','Acadia',2015,'regular unleaded',281,6,'AUTOMATIC','all wheel drive',4,'Crossover','Midsize','4dr SUV',23,16,42820,'en',1,'Y');
   i('GMC','Acadia',2015,'regular unleaded',288,6,'AUTOMATIC','all wheel drive',4,'Crossover','Midsize','4dr SUV',23,16,49690,'en',1,'Y');
   i('Audi','A3',2016,'diesel',150,4,'AUTOMATED_MANUAL','front wheel drive',4,'Diesel,Luxury','Compact','Sedan',43,31,35900,'en',1,'Y');
   i('Acura','ILX Hybrid',2014,'premium unleaded (recommended)',111,4,'AUTOMATIC','front wheel drive',4,'Luxury,Hybrid','Compact','Sedan',38,39,28900,'en',1,'Y');
   i('Audi','A3',2017,'premium unleaded (recommended)',220,4,'AUTOMATED_MANUAL','all wheel drive',2,'Luxury','Compact','Convertible',34,25,49250,'en',1,'Y');
   i('Pontiac','Vibe',2009,'regular unleaded',158,4,'AUTOMATIC','all wheel drive',4,'Hatchback','Compact','4dr Hatchback',26,20,20475,'en',1,'Y');
   i('Pontiac','Vibe',2010,'regular unleaded',158,4,'MANUAL','front wheel drive',4,'Hatchback','Compact','4dr Hatchback',28,21,20875,'en',1,'Y');
   i('Lexus','ES 350',2015,'regular unleaded',268,6,'AUTOMATIC','front wheel drive',4,'Luxury,Performance','Midsize','Sedan',31,21,37700,'en',1,'Y');
   i('Lexus','GS 350',2016,'premium unleaded (required)',311,6,'AUTOMATIC','rear wheel drive',4,'Luxury,High-Performance','Midsize','Sedan',29,20,50000,'en',1,'Y');
   i('Saab','9-7X',2008,'regular unleaded',390,8,'AUTOMATIC','all wheel drive',4,'Luxury','Midsize','4dr SUV',16,12,46530,'en',1,'Y');
   i('Dodge','Dakota',2010,'flex-fuel (unleaded/E85)',302,8,'AUTOMATIC','four wheel drive',4,'Flex Fuel','Compact','Crew Cab Pickup',19,14,31365,'en',1,'Y');
   i('Porsche','911',2015,'premium unleaded (required)',350,6,'MANUAL','rear wheel drive',2,'Luxury,High-Performance','Compact','Coupe',27,19,84300,'en',1,'Y');
   i('Porsche','911',2016,'premium unleaded (required)',400,6,'MANUAL','rear wheel drive',2,'Luxury,High-Performance','Compact','Convertible',27,19,110800,'en',1,'Y');
   commit;
  end;
/
  declare
    procedure i (
      p_code            in varchar2,
      p_short_desc      in varchar2,
      p_long_desc       in varchar2,
      p_lang            in varchar2,
      p_version_number  in number,
      p_seeded_data_yn  in varchar2
    )
    is
    begin
      insert into wwv_dg_builtin_icd_diags (code,short_desc,long_desc,lang,version_number,seeded_data_yn)
      values (p_code, p_short_desc, p_long_desc, p_lang, p_version_number,p_seeded_data_yn);
    end i;
  begin
   i('S55102S','N/A','Unspecified injury of radial artery at forearm level, left arm, sequela','en',1,'Y');
   i('S62113P','N/A','Displaced fracture of triquetrum [cuneiform] bone, unspecified wrist, subsequent encounter for fracture with malunion','en',1,'Y');
   i('S52301M','N/A','Unspecified fracture of shaft of right radius, subsequent encounter for open fracture type I or II with nonunion','en',1,'Y');
   i('S62116D','N/A','Nondisplaced fracture of triquetrum [cuneiform] bone, unspecified wrist, subsequent encounter for fracture with routine healing','en',1,'Y');
   i('S62669G','N/A','Nondisplaced fracture of distal phalanx of unspecified finger, subsequent encounter for fracture with delayed healing','en',1,'Y');
   i('S62221P','N/A','Displaced Rolando''s fracture, right hand, subsequent encounter for fracture with malunion','en',1,'Y');
   i('S62303S','N/A','Unspecified fracture of third metacarpal bone, left hand, sequela','en',1,'Y');
   i('S62607P','N/A','Fracture of unspecified phalanx of left little finger, subsequent encounter for fracture with malunion','en',1,'Y');
   i('S22059D','N/A','Unspecified fracture of T5-T6 vertebra, subsequent encounter for fracture with routine healing','en',1,'Y');
   i('S62314P','N/A','Displaced fracture of base of fourth metacarpal bone, right hand, subsequent encounter for fracture with malunion','en',1,'Y');
   i('S66103A','N/A','Unspecified injury of flexor muscle, fascia and tendon of left middle finger at wrist and hand level, initial encounter','en',1,'Y');
   i('S68721D','N/A','Partial traumatic transmetacarpal amputation of right hand, subsequent encounter','en',1,'Y');
   i('S7221XQ','N/A','Displaced subtrochanteric fracture of right femur, subsequent encounter for open fracture type I or II with malunion','en',1,'Y');
   i('S72133G','N/A','Displaced apophyseal fracture of unspecified femur, subsequent encounter for closed fracture with delayed healing','en',1,'Y');
   i('S82242J','N/A','Displaced spiral fracture of shaft of left tibia, subsequent encounter for open fracture type IIIA, IIIB, or IIIC with delayed healing','en',1,'Y');
   i('S63279S','N/A','Dislocation of unspecified interphalangeal joint of unspecified finger, sequela','en',1,'Y');
   i('S72309G','N/A','Unspecified fracture of shaft of unspecified femur, subsequent encounter for closed fracture with delayed healing','en',1,'Y');
   i('S82234B','N/A','Nondisplaced oblique fracture of shaft of right tibia, initial encounter for open fracture type I or II','en',1,'Y');
   i('S72456J','N/A','Nondisplaced supracondylar fracture without intracondylar extension of lower end of unspecified femur, subsequent encounter for open fracture type IIIA, IIIB, or IIIC with delayed healing','en',1,'Y');
   i('S81839S','N/A','Puncture wound without foreign body, unspecified lower leg, sequela','en',1,'Y');
   i('S82202H','N/A','Unspecified fracture of shaft of left tibia, subsequent encounter for open fracture type I or II with delayed healing','en',1,'Y');
   i('S79012P','N/A','Salter-Harris Type I physeal fracture of upper end of left femur, subsequent encounter for fracture with malunion','en',1,'Y');
   i('S73022S','N/A','Obturator subluxation of left hip, sequela','en',1,'Y');
   i('S91131A','N/A','Puncture wound without foreign body of right great toe without damage to nail, initial encounter','en',1,'Y');
   i('S82863G','N/A','Displaced Maisonneuve''s fracture of unspecified leg, subsequent encounter for closed fracture with delayed healing','en',1,'Y');
   i('S85211S','N/A','Laceration of peroneal artery, right leg, sequela','en',1,'Y');
   i('S90859S','N/A','Superficial foreign body, unspecified foot, sequela','en',1,'Y');
   i('S82842R','N/A','Displaced bimalleolar fracture of left lower leg, subsequent encounter for open fracture type IIIA, IIIB, or IIIC with malunion','en',1,'Y');
   i('S90119A','N/A','Contusion of unspecified great toe without damage to nail, initial encounter','en',1,'Y');
   i('S98322S','N/A','Partial traumatic amputation of left midfoot, sequela','en',1,'Y');
   i('S93314A','N/A','Dislocation of tarsal joint of right foot, initial encounter','en',1,'Y');
   i('T22349A','N/A','Burn of third degree of unspecified axilla, initial encounter','en',1,'Y');
   i('S92591G','N/A','Other fracture of right lesser toe(s), subsequent encounter for fracture with delayed healing','en',1,'Y');
   i('T24239S','N/A','Burn of second degree of unspecified lower leg, sequela','en',1,'Y');
   i('S92351A','N/A','Displaced fracture of fifth metatarsal bone, right foot, initial encounter for closed fracture','en',1,'Y');
   i('S71042S','N/A','Puncture wound with foreign body, left hip, sequela','en',1,'Y');
   i('S96119A','N/A','Strain of muscle and tendon of long extensor muscle of toe at ankle and foot level, unspecified foot, initial encounter','en',1,'Y');
   i('T391X3S','N/A','Poisoning by 4-Aminophenol derivatives, assault, sequela','en',1,'Y');
   i('75','Cyclosporiasis','Cyclosporiasis','en',1,'Y');
   i('T85321A','N/A','Displacement of prosthetic orbit of left eye, initial encounter','en',1,'Y');
   i('T71111A','N/A','Asphyxiation due to smothering under pillow, accidental, initial encounter','en',1,'Y');
   i('W16111D','N/A','Fall into natural body of water striking water surface causing drowning and submersion, subsequent encounter','en',1,'Y');
   i('E9173','Furnit w/o sub fall','Striking against or struck accidentally by furniture without subsequent fall','en',1,'Y');
   i('V874XXA','N/A','Person injured in collision between car and heavy transport vehicle (traffic), initial encounter','en',1,'Y');
   i('V646XXA','N/A','Passenger in heavy transport vehicle injured in collision with heavy transport vehicle or bus in traffic accident, initial encounter','en',1,'Y');
   i('W5813XS','N/A','Crushed by crocodile, sequela','en',1,'Y');
   i('71893','Jt derangmnt NOS-forearm','Unspecified derangement of joint, forearm','en',1,'Y');
   i('V480','Deficiencies of head','Deficiencies of head','en',1,'Y');
   i('5571','Chr vasc insuff intest','Chronic vascular insufficiency of intestine','en',1,'Y');
   i('Y92252','N/A','Music hall as the place of occurrence of the external cause','en',1,'Y');
   i('V4910XS','N/A','Passenger injured in collision with unspecified motor vehicles in nontraffic accident, sequela','en',1,'Y');
   i('Y383X1S','N/A','Terrorism involving fires, conflagration and hot substances, public safety official injured, sequela','en',1,'Y');
   i('1601','Orbitotomy w bone flap','Orbitotomy with bone flap','en',1,'Y');
   i('36901','Tot impairment-both eyes','Better eye: total vision impairment; lesser eye: total vision impairment','en',1,'Y');
   i('E8119','Reentrant coll-pers NOS','Motor vehicle traffic accident involving re-entrant collision with another motor vehicle injuring unspecified person','en',1,'Y');
   i('75','Hip surface, metal/metal','Hip bearing surface, metal-on-metal','en',1,'Y');
   i('8122','Arthrodesis of knee','Arthrodesis of knee','en',1,'Y');
   i('8849','Contrast arteriogram NEC','Arteriography of other specified sites','en',1,'Y');
   i('20203','Nodular lymphoma abdom','Nodular lymphoma, intra-abdominal lymph nodes','en',1,'Y');
   i('E8586','Acc poisn-muscl/resp agt','Accidental poisoning by agents primarily acting on the smooth and skeletal muscles and respiratory system','en',1,'Y');
   i('78837','Continuous leakage','Continuous leakage','en',1,'Y');
   i('5831','Membranous nephritis NOS','Nephritis and nephropathy, not specified as acute or chronic, with lesion of membranous glomerulonephritis','en',1,'Y');
   i('5571','Measles keratitis','Measles keratoconjunctivitis','en',1,'Y');
   i('2708','Dis amino-acid metab NEC','Other specified disorders of amino-acid metabolism','en',1,'Y');
   i('8691','Internal injury NOS-open','Internal injury to unspecified or ill-defined organs with open wound into cavity','en',1,'Y');
   i('2911','Alcohol amnestic disordr','Alcohol-induced persisting amnestic disorder','en',1,'Y');
   i('6351','Suture cord & epid lacer','Suture of laceration of spermatic cord and epididymis','en',1,'Y');
   i('8691','Skin excision for graft','Excision of skin for graft','en',1,'Y');
   i('V8904','Sus fetal growth not fnd','Suspected problem with fetal growth not found','en',1,'Y');
   i('36213','Retinal vascular changes','Changes in vascular appearance of retina','en',1,'Y');
   i('1601','TB of kidney-no exam','Tuberculosis of kidney, bacteriological or histological examination not done','en',1,'Y');
   i('6244','Old laceration of vulva','Old laceration or scarring of vulva','en',1,'Y');
   i('7489','Respiratory anomaly NOS','Unspecified anomaly of respiratory system','en',1,'Y');
   i('71648','Trans arthropathy NEC','Transient arthropathy, other specified sites','en',1,'Y');
   i('9001','Inj internl jugular vein','Injury to internal jugular vein','en',1,'Y');
   i('5550','Reg enteritis, sm intest','Regional enteritis of small intestine','en',1,'Y');
   i('1601','Malig neo middle ear','Malignant neoplasm of auditory tube, middle ear, and mastoid air cells','en',1,'Y');
   i('5831','Endosc destr urethra les','Endoscopic excision or destruction of lesion or tissue of urethra','en',1,'Y');
   i('74484','Microstomia','Microstomia','en',1,'Y');
   i('E9064','Nonvenom arthropod bite','Bite of nonvenomous arthropod','en',1,'Y');
   i('S96209D','N/A','Unspecified injury of intrinsic muscle and tendon at ankle and foot level, unspecified foot, subsequent encounter','en',1,'Y');
   i('T23199D','N/A','Burn of first degree of multiple sites of unspecified wrist and hand, subsequent encounter','en',1,'Y');
   i('T63433S','N/A','Toxic effect of venom of caterpillars, assault, sequela','en',1,'Y');
   i('T84040A','N/A','Periprosthetic fracture around internal prosthetic right hip joint, initial encounter','en',1,'Y');
   i('Z98810','N/A','Dental sealant status','en',1,'Y');
   i('2911','Pharyngoscopy','Pharyngoscopy','en',1,'Y');
   i('V487XXA','N/A','Person on outside of car injured in noncollision transport accident in traffic accident, initial encounter','en',1,'Y');
   i('75','Infectious mononucleosis','Infectious mononucleosis','en',1,'Y');
   i('3351','Unilat lung transplant','Unilateral lung transplantation','en',1,'Y');
   i('52473','Alveolar maxil hypoplsia','Alveolar maxillary hypoplasia','en',1,'Y');
   i('9001','Bact smear-nervous syst','Microscopic examination of specimen from nervous system and of spinal fluid, bacterial smear','en',1,'Y');
   i('X005','Jump from burning building or structure in uncontrolled fire','Jump from burning building or structure in uncontrolled fire','en',1,'Y');
   i('S06347D','N/A','Traumatic hemorrhage of right cerebrum with loss of consciousness of any duration with death due to brain injury prior to regaining consciousness, subsequent encounter','en',1,'Y');
   i('O6013X0','N/A','Preterm labor second trimester with preterm delivery third trimester, not applicable or unspecified','en',1,'Y');
   i('M85622','N/A','Other cyst of bone, left upper arm','en',1,'Y');
   i('T835','Infect/inflm reaction due to prosth dev/grft in urinry sys','Infection and inflammatory reaction due to prosthetic device, implant and','en',1,'Y');
   i('S32058B','N/A','Other fracture of fifth lumbar vertebra, initial encounter for open fracture','en',1,'Y');
   i('S42413D','N/A','Displaced simple supracondylar fracture without intercondylar fracture of unspecified humerus, subsequent encounter for fracture with routine healing','en',1,'Y');
   i('B1910','Unspecified viral hepatitis B without hepatic coma','Unspecified viral hepatitis B without hepatic coma','en',1,'Y');
   i('C3491','Malignant neoplasm of unsp part of right bronchus or lung','Malignant neoplasm of unspecified part of right bronchus or lung','en',1,'Y');
   i('L66','Cicatricial alopecia [scarring hair loss]','Cicatricial alopecia [scarring hair loss]','en',1,'Y');
   i('L929','Granulomatous disorder of the skin, subcu, unsp','Granulomatous disorder of the skin and subcutaneous tissue, unspecified','en',1,'Y');
   i('H2609','Other infantile and juvenile cataract','Other infantile and juvenile cataract','en',1,'Y');
   i('S5910','Unspecified physeal fracture of upper end of radius','Unspecified physeal fracture of upper end of radius','en',1,'Y');
   i('O8803','Air embolism in the puerperium','Air embolism in the puerperium','en',1,'Y');
   i('Q268','Other congenital malformations of great veins','Other congenital malformations of great veins','en',1,'Y');
   i('M8006','Age-related osteopor w current path fracture, lower leg','Age-related osteoporosis with current pathological fracture, lower leg','en',1,'Y');
   i('S2751','Primary blast injury of thoracic trachea','Primary blast injury of thoracic trachea','en',1,'Y');
   i('M8705','Idiopathic aseptic necrosis of pelvis and femur','Idiopathic aseptic necrosis of pelvis and femur','en',1,'Y');
   i('M8438','Stress fracture, other site','Stress fracture, other site','en',1,'Y');
   i('T2269','Corros 2nd deg mul sites of shldr/up lmb, except wrs/hnd','Corrosion of second degree of multiple sites of shoulder and upper limb, e','en',1,'Y');
   i('H5932','Postproc hemor/hemtom of eye and adnexa fol oth procedure','Postprocedural hemorrhage and hematoma of eye and adnexa following other p','en',1,'Y');
   i('S4113','Puncture wound without foreign body of upper arm','Puncture wound without foreign body of upper arm','en',1,'Y');
   i('S6610','Unsp inj flexor musc/fasc/tend and unsp finger at wrs/hnd lv','Unspecified injury of flexor muscle, fascia and tendon of other and unspec','en',1,'Y');
   i('S0637','Contusion, laceration, and hemorrhage of cerebellum','Contusion, laceration, and hemorrhage of cerebellum','en',1,'Y');
   i('S6341','Traumatic rupture of collat ligament of finger at MCP/IP jt','Traumatic rupture of collateral ligament of finger at metacarpophalangeal','en',1,'Y');
   i('S280','Crushed chest','Crushed chest','en',1,'Y');
   i('H0019','Chalazion unspecified eye, unspecified eyelid','Chalazion unspecified eye, unspecified eyelid','en',1,'Y');
   i('T7411','Adult physical abuse, confirmed','Adult physical abuse, confirmed','en',1,'Y');
   i('Z7709','Contact w and expsr to oth hazard, chiefly nonmed, chemicals','Contact with and (suspected) exposure to other hazardous, chiefly nonmedic','en',1,'Y');
   i('V563X','Occup of pk-up/van inj in clsn w nonmtr veh nontraf, init','Unspecified occupant of pick-up truck or van injured in collision with oth','en',1,'Y');
   i('V480','Car driver injured in nonclsn transport accident nontraf','Car driver injured in noncollision transport accident in nontraffic accide','en',1,'Y');
   i('H35461','N/A','Secondary vitreoretinal degeneration, right eye','en',1,'Y');
   i('H35739','N/A','Hemorrhagic detachment of retinal pigment epithelium, unspecified eye','en',1,'Y');
   i('V525','Driver of pk-up/van injured in clsn w 2/3-whl mv in traf','Driver of pick-up truck or van injured in collision with two- or three-whe','en',1,'Y');
   i('H25031','N/A','Anterior subcapsular polar age-related cataract, right eye','en',1,'Y');
   i('H11059','N/A','Peripheral pterygium, progressive, unspecified eye','en',1,'Y');
   i('Z821','Family history of blindness and visual loss','Family history of blindness and visual loss','en',1,'Y');
   i('X151X','Contact with hot toaster, initial encounter','Contact with hot toaster, initial encounter','en',1,'Y');
   i('X014','Hit by object due to uncontrolled fire, not in bldg','Hit by object due to uncontrolled fire, not in building or structure','en',1,'Y');
   i('Y249','Unspecified firearm discharge, undetermined intent','Unspecified firearm discharge, undetermined intent','en',1,'Y');
   i('H47521','N/A','Disorders of visual pathways in (due to) neoplasm, right side','en',1,'Y');
   i('S00459S','N/A','Superficial foreign body of unspecified ear, sequela','en',1,'Y');
   i('M84432S','N/A','Pathological fracture, left ulna, sequela','en',1,'Y');
   i('M19149','N/A','Post-traumatic osteoarthritis, unspecified hand','en',1,'Y');
   i('K08409','N/A','Partial loss of teeth, unspecified cause, unspecified class','en',1,'Y');
   i('M21839','N/A','Other specified acquired deformities of unspecified forearm','en',1,'Y');
   i('M25519','N/A','Pain in unspecified shoulder','en',1,'Y');
   i('M67379','N/A','Transient synovitis, unspecified ankle and foot','en',1,'Y');
   i('W3419','Accidental malfunction from other specified firearms','Accidental malfunction from other specified firearms','en',1,'Y');
   i('O3131X3','N/A','Continuing pregnancy after elective fetal reduction of one fetus or more, first trimester, fetus 3','en',1,'Y');
   i('R87610','N/A','Atypical squamous cells of undetermined significance on cytologic smear of cervix (ASC-US)','en',1,'Y');
   i('M86269','N/A','Subacute osteomyelitis, unspecified tibia and fibula','en',1,'Y');
   i('O09611','N/A','Supervision of young primigravida, first trimester','en',1,'Y');
   i('M85379','N/A','Osteitis condensans, unspecified ankle and foot','en',1,'Y');
   i('T8349','Mech compl of prosth dev/implnt/grft of genital tract','Other mechanical complication of other prosthetic devices, implants and gr','en',1,'Y');
   i('O4101X3','N/A','Oligohydramnios, first trimester, fetus 3','en',1,'Y');
   i('V3969','Occup of 3-whl mv injured in collision w oth mv in traf','Unspecified occupant of three-wheeled motor vehicle injured in collision w','en',1,'Y');
   i('S2242XB','N/A','Multiple fractures of ribs, left side, initial encounter for open fracture','en',1,'Y');
   i('S12301A','N/A','Unspecified nondisplaced fracture of fourth cervical vertebra, initial encounter for closed fracture','en',1,'Y');
   i('S12351B','N/A','Other traumatic nondisplaced spondylolisthesis of fourth cervical vertebra, initial encounter for open fracture','en',1,'Y');
   i('S0992XA','N/A','Unspecified injury of nose, initial encounter','en',1,'Y');
   i('S14132S','N/A','Anterior cord syndrome at C2 level of cervical spinal cord, sequela','en',1,'Y');
   i('M61479','N/A','Other calcification of muscle, unspecified ankle and foot','en',1,'Y');
   i('S43023S','N/A','Posterior subluxation of unspecified humerus, sequela','en',1,'Y');
   i('M61169','N/A','Myositis ossificans progressiva, unspecified lower leg','en',1,'Y');
   i('M84342K','N/A','Stress fracture, left hand, subsequent encounter for fracture with nonunion','en',1,'Y');
   i('S55002D','N/A','Unspecified injury of ulnar artery at forearm level, left arm, subsequent encounter','en',1,'Y');
   i('S52124S','N/A','Nondisplaced fracture of head of right radius, sequela','en',1,'Y');
   i('S52513N','N/A','Displaced fracture of unspecified radial styloid process, subsequent encounter for open fracture type IIIA, IIIB, or IIIC with nonunion','en',1,'Y');
   commit;
  end;
  /
  declare
    procedure i (
      p_code            in varchar2,
      p_short_desc      in varchar2,
      p_long_desc       in varchar2,
      p_lang            in varchar2,
      p_version_number  in number,
      p_seeded_data_yn  in varchar2
    )
    is
    begin
      insert into wwv_dg_builtin_icd_procs (code,short_desc,long_desc,lang,version_number,seeded_data_yn)
      values (p_code, p_short_desc, p_long_desc, p_lang, p_version_number, p_seeded_data_yn);
    end i;
  begin
   i('08RPXKZ','Replacement of L Up Eyelid with Nonaut Sub, Extern Approach','Replacement of Left Upper Eyelid with Nonautologous Tissue Substitute, External Approach','en',1,'Y');
   i('0CTJ0ZZ','Resection of Minor Salivary Gland, Open Approach','Resection of Minor Salivary Gland, Open Approach','en',1,'Y');
   i('0BL54CZ','Occlusion R Mid Lobe Bronc w Extralum Dev, Perc Endo','Occlusion of Right Middle Lobe Bronchus with Extraluminal Device, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0KQT4ZZ','Repair Left Lower Leg Muscle, Perc Endo Approach','Repair Left Lower Leg Muscle, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0LR20JZ','Replace of L Shoulder Tendon with Synth Sub, Open Approach','Replacement of Left Shoulder Tendon with Synthetic Substitute, Open Approach','en',1,'Y');
   i('0D5B8ZZ','Destruction of Ileum, Endo','Destruction of Ileum, Via Natural or Artificial Opening Endoscopic','en',1,'Y');
   i('0DCM7ZZ','Extirpation of Matter from Descending Colon, Via Opening','Extirpation of Matter from Descending Colon, Via Natural or Artificial Opening','en',1,'Y');
   i('0F184D6','Bypass Cystic Duct to L Hep Duc w Intralum Dev, Perc Endo','Bypass Cystic Duct to Left Hepatic Duct with Intraluminal Device, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0G9P30Z','Drainage of L Inf Parathyroid with Drain Dev, Perc Approach','Drainage of Left Inferior Parathyroid Gland with Drainage Device, Percutaneous Approach','en',1,'Y');
   i('0CWS80Z','Revision of Drainage Device in Larynx, Endo','Revision of Drainage Device in Larynx, Via Natural or Artificial Opening Endoscopic','en',1,'Y');
   i('0FV88DZ','Restriction of Cystic Duct with Intraluminal Device, Endo','Restriction of Cystic Duct with Intraluminal Device, Via Natural or Artificial Opening Endoscopic','en',1,'Y');
   i('0D1K074','Bypass Asc Colon to Cutan with Autol Sub, Open Approach','Bypass Ascending Colon to Cutaneous with Autologous Tissue Substitute, Open Approach','en',1,'Y');
   i('0DU387Z','Supplement Lower Esophagus with Autol Sub, Endo','Supplement Lower Esophagus with Autologous Tissue Substitute, Via Natural or Artificial Opening Endoscopic','en',1,'Y');
   i('0PW1XKZ','Revision of Nonaut Sub in R Rib, Extern Approach','Revision of Nonautologous Tissue Substitute in Right Rib, External Approach','en',1,'Y');
   i('0GWRX0Z','Revision of Drain Dev in Parathyroid Gland, Extern Approach','Revision of Drainage Device in Parathyroid Gland, External Approach','en',1,'Y');
   i('0P9H40Z','Drainage of Right Radius with Drain Dev, Perc Endo Approach','Drainage of Right Radius with Drainage Device, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0JPV3HZ','Remove Contracept Dev from Up Extrem Subcu/Fascia, Perc','Removal of Contraceptive Device from Upper Extremity Subcutaneous Tissue and Fascia, Percutaneous Approach','en',1,'Y');
   i('0JH639Z','Insert Card Rsync Defib Puls Gen in Chest Subcu/Fascia, Perc','Insertion of Cardiac Resynchronization Defibrillator Pulse Generator into Chest Subcutaneous Tissue and Fa','en',1,'Y');
   i('0H97X0Z','Drainage of Abdomen Skin with Drain Dev, Extern Approach','Drainage of Abdomen Skin with Drainage Device, External Approach','en',1,'Y');
   i('0GTD4ZZ','Resection of Aortic Body, Percutaneous Endoscopic Approach','Resection of Aortic Body, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0GN44ZZ','Release Bilateral Adrenal Glands, Perc Endo Approach','Release Bilateral Adrenal Glands, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0L5Q3ZZ','Destruction of Right Knee Tendon, Percutaneous Approach','Destruction of Right Knee Tendon, Percutaneous Approach','en',1,'Y');
   i('0GSR0ZZ','Reposition Parathyroid Gland, Open Approach','Reposition Parathyroid Gland, Open Approach','en',1,'Y');
   i('0JB93ZX','Excision of Buttock Subcu/Fascia, Perc Approach, Diagn','Excision of Buttock Subcutaneous Tissue and Fascia, Percutaneous Approach, Diagnostic','en',1,'Y');
   i('0LNF4ZZ','Release Right Abdomen Tendon, Perc Endo Approach','Release Right Abdomen Tendon, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0GJ10ZZ','Inspection of Pineal Body, Open Approach','Inspection of Pineal Body, Open Approach','en',1,'Y');
   i('0LCG0ZZ','Extirpation of Matter from L Abd Tendon, Open Approach','Extirpation of Matter from Left Abdomen Tendon, Open Approach','en',1,'Y');
   i('0LB20ZZ','Excision of Left Shoulder Tendon, Open Approach','Excision of Left Shoulder Tendon, Open Approach','en',1,'Y');
   i('0KXG4Z1','Transfer Left Trunk Muscle with Subcu, Perc Endo Approach','Transfer Left Trunk Muscle with Subcutaneous Tissue, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0KXH0Z0','Transfer Right Thorax Muscle with Skin, Open Approach','Transfer Right Thorax Muscle with Skin, Open Approach','en',1,'Y');
   i('0N9H30Z','Drainage of R Lacrimal Bone with Drain Dev, Perc Approach','Drainage of Right Lacrimal Bone with Drainage Device, Percutaneous Approach','en',1,'Y');
   i('0RH643Z','Insertion of Infusion Dev into Thor Jt, Perc Endo Approach','Insertion of Infusion Device into Thoracic Vertebral Joint, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0N5D0ZZ','Destruction of Left Sphenoid Bone, Open Approach','Destruction of Left Sphenoid Bone, Open Approach','en',1,'Y');
   i('0M9140Z','Drain R Shoulder Bursa/Lig w Drain Dev, Perc Endo','Drainage of Right Shoulder Bursa and Ligament with Drainage Device, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0NBM4ZZ','Excision of Right Zygomatic Bone, Perc Endo Approach','Excision of Right Zygomatic Bone, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0MUD0JZ','Supplement L Trunk Bursa/Lig with Synth Sub, Open Approach','Supplement Left Trunk Bursa and Ligament with Synthetic Substitute, Open Approach','en',1,'Y');
   i('0NB03ZX','Excision of Skull, Percutaneous Approach, Diagnostic','Excision of Skull, Percutaneous Approach, Diagnostic','en',1,'Y');
   i('0PWQ47Z','Revision of Autol Sub in L Metacarpal, Perc Endo Approach','Revision of Autologous Tissue Substitute in Left Metacarpal, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0P9T0ZZ','Drainage of Right Finger Phalanx, Open Approach','Drainage of Right Finger Phalanx, Open Approach','en',1,'Y');
   i('0SRB0JZ','Replacement of Left Hip Joint with Synth Sub, Open Approach','Replacement of Left Hip Joint with Synthetic Substitute, Open Approach','en',1,'Y');
   i('0SWG40Z','Revision of Drain Dev in L Ankle Jt, Perc Endo Approach','Revision of Drainage Device in Left Ankle Joint, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0QP205Z','Removal of Ext Fix from R Pelvic Bone, Open Approach','Removal of External Fixation Device from Right Pelvic Bone, Open Approach','en',1,'Y');
   i('0T180KD','Bypass Bi Ureter to Cutan with Nonaut Sub, Open Approach','Bypass Bilateral Ureters to Cutaneous with Nonautologous Tissue Substitute, Open Approach','en',1,'Y');
   i('0RHK33Z','Insertion of Infusion Dev into L Shoulder Jt, Perc Approach','Insertion of Infusion Device into Left Shoulder Joint, Percutaneous Approach','en',1,'Y');
   i('0RN5XZZ','Release Cervicothoracic Vertebral Disc, External Approach','Release Cervicothoracic Vertebral Disc, External Approach','en',1,'Y');
   i('0QP747Z','Removal of Autol Sub from L Up Femur, Perc Endo Approach','Removal of Autologous Tissue Substitute from Left Upper Femur, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0RNQ0ZZ','Release Right Carpal Joint, Open Approach','Release Right Carpal Joint, Open Approach','en',1,'Y');
   i('0QCP3ZZ','Extirpation of Matter from Left Metatarsal, Perc Approach','Extirpation of Matter from Left Metatarsal, Percutaneous Approach','en',1,'Y');
   i('0Q9H0ZX','Drainage of Left Tibia, Open Approach, Diagnostic','Drainage of Left Tibia, Open Approach, Diagnostic','en',1,'Y');
   i('0Q9J4ZZ','Drainage of Right Fibula, Percutaneous Endoscopic Approach','Drainage of Right Fibula, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0QPG34Z','Removal of Int Fix from R Tibia, Perc Approach','Removal of Internal Fixation Device from Right Tibia, Percutaneous Approach','en',1,'Y');
   i('0QWN3KZ','Revision of Nonaut Sub in R Metatarsal, Perc Approach','Revision of Nonautologous Tissue Substitute in Right Metatarsal, Percutaneous Approach','en',1,'Y');
   i('0RJVXZZ','Inspection of L Metacarpophal Jt, Extern Approach','Inspection of Left Metacarpophalangeal Joint, External Approach','en',1,'Y');
   i('0SPP0KZ','Removal of Nonaut Sub from R Toe Phalanx Jt, Open Approach','Removal of Nonautologous Tissue Substitute from Right Toe Phalangeal Joint, Open Approach','en',1,'Y');
   i('0WP54KZ','Removal of Nonaut Sub from Low Jaw, Perc Endo Approach','Removal of Nonautologous Tissue Substitute from Lower Jaw, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0SPP4JZ','Remove Synth Sub from R Toe Phalanx Jt, Perc Endo','Removal of Synthetic Substitute from Right Toe Phalangeal Joint, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0S9M3ZZ','Drainage of Right Metatarsal-Phalangeal Joint, Perc Approach','Drainage of Right Metatarsal-Phalangeal Joint, Percutaneous Approach','en',1,'Y');
   i('0WP903Z','Removal of Infusion Device from R Pleural Cav, Open Approach','Removal of Infusion Device from Right Pleural Cavity, Open Approach','en',1,'Y');
   i('0T9B40Z','Drainage of Bladder with Drainage Device, Perc Endo Approach','Drainage of Bladder with Drainage Device, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0SPF07Z','Removal of Autol Sub from R Ankle Jt, Open Approach','Removal of Autologous Tissue Substitute from Right Ankle Joint, Open Approach','en',1,'Y');
   i('0TU30JZ','Supplement Right Kidney Pelvis with Synth Sub, Open Approach','Supplement Right Kidney Pelvis with Synthetic Substitute, Open Approach','en',1,'Y');
   i('0SUB0KZ','Supplement Left Hip Joint with Nonaut Sub, Open Approach','Supplement Left Hip Joint with Nonautologous Tissue Substitute, Open Approach','en',1,'Y');
   i('0SW3X4Z','Revision of Int Fix in Lumsac Jt, Extern Approach','Revision of Internal Fixation Device in Lumbosacral Joint, External Approach','en',1,'Y');
   i('3E0M37Z','Introduce Electrol/Water Bal in Periton Cav, Perc','Introduction of Electrolytic and Water Balance Substance into Peritoneal Cavity, Percutaneous Approach','en',1,'Y');
   i('5A09559','Assistance with Resp Ventilation, >96 Hrs, Cont Neg Air','Assistance with Respiratory Ventilation, Greater than 96 Consecutive Hours, Continuous Negative Airway Pre','en',1,'Y');
   i('B30BYZZ','Plain Radiography of L Ext Carotid using Oth Contrast','Plain Radiography of Left External Carotid Artery using Other Contrast','en',1,'Y');
   i('0U998ZZ','Drainage of Uterus, Endo','Drainage of Uterus, Via Natural or Artificial Opening Endoscopic','en',1,'Y');
   i('B22610Z','CT Scan of R & L Heart using L Osm Contrast, Unenh, Enhance','Computerized Tomography (CT Scan) of Right and Left Heart using Low Osmolar Contrast, Unenhanced and Enhan','en',1,'Y');
   i('B4030ZZ','Plain Radiography of Splenic Arteries using H Osm Contrast','Plain Radiography of Splenic Arteries using High Osmolar Contrast','en',1,'Y');
   i('0VWM0KZ','Revise of Nonaut Sub in Epididymis/Sperm Cord, Open Approach','Revision of Nonautologous Tissue Substitute in Epididymis and Spermatic Cord, Open Approach','en',1,'Y');
   i('0U7G7DZ','Dilation of Vagina with Intraluminal Device, Via Opening','Dilation of Vagina with Intraluminal Device, Via Natural or Artificial Opening','en',1,'Y');
   i('0U15476','Bypass R Fallopian Tube to L Fallop w Autol Sub, Perc Endo','Bypass Right Fallopian Tube to Left Fallopian Tube with Autologous Tissue Substitute, Percutaneous Endosco','en',1,'Y');
   i('0X0G47Z','Alteration of R Wrist with Autol Sub, Perc Endo Approach','Alteration of Right Wrist Region with Autologous Tissue Substitute, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0US14ZZ','Reposition Left Ovary, Percutaneous Endoscopic Approach','Reposition Left Ovary, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0U594ZZ','Destruction of Uterus, Percutaneous Endoscopic Approach','Destruction of Uterus, Percutaneous Endoscopic Approach','en',1,'Y');
   i('F00ZCYZ','Aphasia Assessment using Other Equipment','Aphasia Assessment using Other Equipment','en',1,'Y');
   i('10Y03ZJ','Transplantation of Ear, Nose & Sinus into POC, Perc Approach','Transplantation of Ear, Nose and Sinus into Products of Conception, Percutaneous Approach','en',1,'Y');
   i('0XUW47Z','Supplement L Little Finger w Autol Sub, Perc Endo','Supplement Left Little Finger with Autologous Tissue Substitute, Percutaneous Endoscopic Approach','en',1,'Y');
   i('DB055ZZ','Beam Radiation of Pleura using Neutrons','Beam Radiation of Pleura using Neutrons','en',1,'Y');
   i('CW23YZZ','Tomo Nucl Med Imag of Chest using Oth Radionuclide','Tomographic (Tomo) Nuclear Medicine Imaging of Chest using Other Radionuclide','en',1,'Y');
   i('DT23JZZ','Stereotactic Gamma Beam Radiosurgery of Urethra','Stereotactic Gamma Beam Radiosurgery of Urethra','en',1,'Y');
   i('D9073Z0','Beam Radiation of Sinuses using Electrons, Intraoperative','Beam Radiation of Sinuses using Electrons, Intraoperative','en',1,'Y');
   i('F00Z8MZ','Receptive/Express Lang Assess w Augment Comm Equip','Receptive/Expressive Language Assessment using Augmentative / Alternative Communication Equipment','en',1,'Y');
   i('DD13BBZ','LDR Brachytherapy of Jejunum using Palladium 103','Low Dose Rate (LDR) Brachytherapy of Jejunum using Palladium 103 (Pd-103)','en',1,'Y');
   i('2W5SXYZ','Removal of Other Device on Right Foot','Removal of Other Device on Right Foot','en',1,'Y');
   i('0YU10KZ','Supplement Left Buttock with Nonaut Sub, Open Approach','Supplement Left Buttock with Nonautologous Tissue Substitute, Open Approach','en',1,'Y');
   i('0Y983ZX','Drainage of Left Femoral Region, Perc Approach, Diagn','Drainage of Left Femoral Region, Percutaneous Approach, Diagnostic','en',1,'Y');
   i('0Y9G0ZZ','Drainage of Left Knee Region, Open Approach','Drainage of Left Knee Region, Open Approach','en',1,'Y');
   i('0Y9L00Z','Drainage of Left Ankle Region with Drain Dev, Open Approach','Drainage of Left Ankle Region with Drainage Device, Open Approach','en',1,'Y');
   i('BL4','Imaging, Connective Tissue, Ultrasonography','Imaging, Connective Tissue, Ultrasonography','en',1,'Y');
   i('F01ZFZZ','Wheelchair Mobility Assessment','Wheelchair Mobility Assessment','en',1,'Y');
   i('F07B6HZ','Exercise Trmt Resp Low Back/LE w Mech/Electromech Equip','Therapeutic Exercise Treatment of Respiratory System - Lower Back / Lower Extremity using Mechanical or El','en',1,'Y');
   i('F07D1FZ','Muscle Perform Trmt Integu Head, Neck w Assist Equip','Muscle Performance Treatment of Integumentary System - Head and Neck using Assistive, Adaptive, Supportive','en',1,'Y');
   i('BB0DZZZ','Plain Radiography of Upper Airways','Plain Radiography of Upper Airways','en',1,'Y');
   i('06SY0ZZ','Reposition Lower Vein, Open Approach','Reposition Lower Vein, Open Approach','en',1,'Y');
   i('06R','Lower Veins, Replacement','Lower Veins, Replacement','en',1,'Y');
   i('0DVH3ZZ','Restriction of Cecum, Percutaneous Approach','Restriction of Cecum, Percutaneous Approach','en',1,'Y');
   i('0BL90DZ','Occlusion of Lingula Bronc with Intralum Dev, Open Approach','Occlusion of Lingula Bronchus with Intraluminal Device, Open Approach','en',1,'Y');
   i('0NQG3ZZ','Repair Left Ethmoid Bone, Percutaneous Approach','Repair Left Ethmoid Bone, Percutaneous Approach','en',1,'Y');
   i('0PPN35Z','Removal of Ext Fix from L Carpal, Perc Approach','Removal of External Fixation Device from Left Carpal, Percutaneous Approach','en',1,'Y');
   i('0QQR3ZZ','Repair Left Toe Phalanx, Percutaneous Approach','Repair Left Toe Phalanx, Percutaneous Approach','en',1,'Y');
   i('0RG64KJ','Fusion Thor Jt w Nonaut Sub, Post Appr A Col, Perc Endo','Fusion of Thoracic Vertebral Joint with Nonautologous Tissue Substitute, Posterior Approach, Anterior Colu','en',1,'Y');
   i('00BR3ZZ','Excision of Accessory Nerve, Percutaneous Approach','Excision of Accessory Nerve, Percutaneous Approach','en',1,'Y');
   i('009Q30Z','Drainage of Vagus Nerve with Drainage Device, Perc Approach','Drainage of Vagus Nerve with Drainage Device, Percutaneous Approach','en',1,'Y');
   i('00CF0ZZ','Extirpation of Matter from Olfactory Nerve, Open Approach','Extirpation of Matter from Olfactory Nerve, Open Approach','en',1,'Y');
   i('00U247Z','Supplement Dura Mater with Autol Sub, Perc Endo Approach','Supplement Dura Mater with Autologous Tissue Substitute, Percutaneous Endoscopic Approach','en',1,'Y');
   i('01890ZZ','Division of Lumbar Plexus, Open Approach','Division of Lumbar Plexus, Open Approach','en',1,'Y');
   i('01DQ4ZZ','Extraction of Sacral Plexus, Perc Endo Approach','Extraction of Sacral Plexus, Percutaneous Endoscopic Approach','en',1,'Y');
   i('01S04ZZ','Reposition Cervical Plexus, Percutaneous Endoscopic Approach','Reposition Cervical Plexus, Percutaneous Endoscopic Approach','en',1,'Y');
   i('021K0ZW','Bypass Right Ventricle to Aorta, Open Approach','Bypass Right Ventricle to Aorta, Open Approach','en',1,'Y');
   i('02N54ZZ','Release Atrial Septum, Percutaneous Endoscopic Approach','Release Atrial Septum, Percutaneous Endoscopic Approach','en',1,'Y');
   i('02R648Z','Replacement of R Atrium with Zooplastic, Perc Endo Approach','Replacement of Right Atrium with Zooplastic Tissue, Percutaneous Endoscopic Approach','en',1,'Y');
   i('02WY07Z','Revision of Autol Sub in Great Vessel, Open Approach','Revision of Autologous Tissue Substitute in Great Vessel, Open Approach','en',1,'Y');
   i('031C0AF','Bypass L Radial Art to Low Arm Vein w Autol Art, Open','Bypass Left Radial Artery to Lower Arm Vein with Autologous Arterial Tissue, Open Approach','en',1,'Y');
   i('04H503Z','Insertion of Infusion Dev into Sup Mesent Art, Open Approach','Insertion of Infusion Device into Superior Mesenteric Artery, Open Approach','en',1,'Y');
   i('03HQ03Z','Insertion of Infusion Dev into L Verteb Art, Open Approach','Insertion of Infusion Device into Left Vertebral Artery, Open Approach','en',1,'Y');
   i('03UH3KZ','Supplement R Com Carotid with Nonaut Sub, Perc Approach','Supplement Right Common Carotid Artery with Nonautologous Tissue Substitute, Percutaneous Approach','en',1,'Y');
   i('03V74ZZ','Restriction of Right Brachial Artery, Perc Endo Approach','Restriction of Right Brachial Artery, Percutaneous Endoscopic Approach','en',1,'Y');
   i('07VC0ZZ','Restriction of Pelvis Lymphatic, Open Approach','Restriction of Pelvis Lymphatic, Open Approach','en',1,'Y');
   i('03BL3ZZ','Excision of Left Internal Carotid Artery, Perc Approach','Excision of Left Internal Carotid Artery, Percutaneous Approach','en',1,'Y');
   i('041C49B','Bypass R Com Iliac Art to L Int Ilia w Autol Vn, Perc Endo','Bypass Right Common Iliac Artery to Left Internal Iliac Artery with Autologous Venous Tissue, Percutaneous','en',1,'Y');
   i('03LV4ZZ','Occlusion of Left Thyroid Artery, Perc Endo Approach','Occlusion of Left Thyroid Artery, Percutaneous Endoscopic Approach','en',1,'Y');
   i('04RE0JZ','Replacement of R Int Iliac Art with Synth Sub, Open Approach','Replacement of Right Internal Iliac Artery with Synthetic Substitute, Open Approach','en',1,'Y');
   i('04R24KZ','Replace of Gastric Art with Nonaut Sub, Perc Endo Approach','Replacement of Gastric Artery with Nonautologous Tissue Substitute, Percutaneous Endoscopic Approach','en',1,'Y');
   i('04UE0JZ','Supplement R Int Iliac Art with Synth Sub, Open Approach','Supplement Right Internal Iliac Artery with Synthetic Substitute, Open Approach','en',1,'Y');
   i('04UU07Z','Supplement L Peroneal Art with Autol Sub, Open Approach','Supplement Left Peroneal Artery with Autologous Tissue Substitute, Open Approach','en',1,'Y');
   i('04U40KZ','Supplement Splenic Artery with Nonaut Sub, Open Approach','Supplement Splenic Artery with Nonautologous Tissue Substitute, Open Approach','en',1,'Y');
   i('059B00Z','Drainage of Right Basilic Vein with Drain Dev, Open Approach','Drainage of Right Basilic Vein with Drainage Device, Open Approach','en',1,'Y');
   i('05L63CZ','Occlusion of L Subclav Vein with Extralum Dev, Perc Approach','Occlusion of Left Subclavian Vein with Extraluminal Device, Percutaneous Approach','en',1,'Y');
   i('05510ZZ','Destruction of Hemiazygos Vein, Open Approach','Destruction of Hemiazygos Vein, Open Approach','en',1,'Y');
   i('05B84ZX','Excision of Left Axillary Vein, Perc Endo Approach, Diagn','Excision of Left Axillary Vein, Percutaneous Endoscopic Approach, Diagnostic','en',1,'Y');
   i('05170KY','Bypass R Axilla Vein to Up Vein w Nonaut Sub, Open','Bypass Right Axillary Vein to Upper Vein with Nonautologous Tissue Substitute, Open Approach','en',1,'Y');
   i('06V64CZ','Restrict Inf Mesent Vein w Extralum Dev, Perc Endo','Restriction of Inferior Mesenteric Vein with Extraluminal Device, Percutaneous Endoscopic Approach','en',1,'Y');
   i('07PL4DZ','Remove Intralum Dev from Cisterna Chyli, Perc Endo','Removal of Intraluminal Device from Cisterna Chyli, Percutaneous Endoscopic Approach','en',1,'Y');
   i('075C3ZZ','Destruction of Pelvis Lymphatic, Percutaneous Approach','Destruction of Pelvis Lymphatic, Percutaneous Approach','en',1,'Y');
   i('07LC4DZ','Occlusion Pelvis Lymph w Intralum Dev, Perc Endo','Occlusion of Pelvis Lymphatic with Intraluminal Device, Percutaneous Endoscopic Approach','en',1,'Y');
   i('07LD4DZ','Occlusion Aortic Lymph w Intralum Dev, Perc Endo','Occlusion of Aortic Lymphatic with Intraluminal Device, Percutaneous Endoscopic Approach','en',1,'Y');
   i('07954ZX','Drainage of R Axilla Lymph, Perc Endo Approach, Diagn','Drainage of Right Axillary Lymphatic, Percutaneous Endoscopic Approach, Diagnostic','en',1,'Y');
   i('05110JY','Bypass Hemiazygos Vein to Up Vein w Synth Sub, Open','Bypass Hemiazygos Vein to Upper Vein with Synthetic Substitute, Open Approach','en',1,'Y');
   i('067J4DZ','Dilate L Hypogast Vein w Intralum Dev, Perc Endo','Dilation of Left Hypogastric Vein with Intraluminal Device, Percutaneous Endoscopic Approach','en',1,'Y');
   i('08BD3ZX','Excision of Left Iris, Percutaneous Approach, Diagnostic','Excision of Left Iris, Percutaneous Approach, Diagnostic','en',1,'Y');
   i('09TB0ZZ','Resection of Right Mastoid Sinus, Open Approach','Resection of Right Mastoid Sinus, Open Approach','en',1,'Y');
   i('0897XZZ','Drainage of Left Sclera, External Approach','Drainage of Left Sclera, External Approach','en',1,'Y');
   i('089C3ZZ','Drainage of Right Iris, Percutaneous Approach','Drainage of Right Iris, Percutaneous Approach','en',1,'Y');
   i('085Y8ZZ','Destruction of Left Lacrimal Duct, Endo','Destruction of Left Lacrimal Duct, Via Natural or Artificial Opening Endoscopic','en',1,'Y');
   i('0CN70ZZ','Release Tongue, Open Approach','Release Tongue, Open Approach','en',1,'Y');
   i('07WM43Z','Revision of Infusion Device in Thymus, Perc Endo Approach','Revision of Infusion Device in Thymus, Percutaneous Endoscopic Approach','en',1,'Y');
   i('0BTJ0ZZ','Resection of Left Lower Lung Lobe, Open Approach','Resection of Left Lower Lung Lobe, Open Approach','en',1,'Y');
   i('0BCD0ZZ','Extirpation of Matter from R Mid Lung Lobe, Open Approach','Extirpation of Matter from Right Middle Lung Lobe, Open Approach','en',1,'Y');
   i('0CB40ZX','Excision of Buccal Mucosa, Open Approach, Diagnostic','Excision of Buccal Mucosa, Open Approach, Diagnostic','en',1,'Y');
   commit;
  end;
  /
  declare
    procedure i (
      p_latitude        in number,
      p_longitude       in number,
      p_city            in varchar2,
      p_state_id        in varchar2,
      p_state_name      in varchar2,
      p_zcta            in varchar2,
      p_population      in number,
      p_county_fips     in number,
      p_county_name     in varchar2,
      p_military        in varchar2,
      p_timezone        in varchar2,
      p_zip_vc          in varchar2,
      p_lang            in varchar2,
      p_version_number  in number,
      p_seeded_data_yn  in varchar2
    )
    is
    begin
      insert into wwv_dg_builtin_locations (latitude,longitude,city,state_id,state_name,zcta,population,county_fips,county_name,military,timezone,zip_vc,lang,version_number,seeded_data_yn)
      values (p_latitude, p_longitude, p_city, p_state_id, p_state_name, p_zcta, p_population, p_county_fips, p_county_name, p_military, p_timezone, p_zip_vc, p_lang, p_version_number,p_seeded_data_yn);
    end i;
  begin
   i(37.95774,-86.49828,'Stephensport','KY','Kentucky','TRUE',516,21027,'Breckinridge','FALSE','America/Chicago','40170','en',1,'Y');
   i(36.19264,-84.82687,'Deer Lodge','TN','Tennessee','TRUE',1950,47129,'Morgan','FALSE','America/New_York','37726','en',1,'Y');
   i(38.25403,-85.75152,'Louisville','KY','Kentucky','TRUE',7397,21111,'Jefferson','FALSE','America/Kentucky/Louisville','40202','en',1,'Y');
   i(38.67917,-84.96219,'Sanders','KY','Kentucky','TRUE',1197,21187,'Owen','FALSE','America/New_York','41083','en',1,'Y');
   i(32.22086,-89.56271,'Pulaski','MS','Mississippi','TRUE',1449,28129,'Smith','FALSE','America/Chicago','39152','en',1,'Y');
   i(37.28431,-97.76806,'Argonia','KS','Kansas','TRUE',697,20191,'Sumner','FALSE','America/Chicago','67004','en',1,'Y');
   i(37.53068,-96.63735,'Latham','KS','Kansas','TRUE',205,20015,'Butler','FALSE','America/Chicago','67072','en',1,'Y');
   i(41.04544,-81.52141,'Akron','OH','Ohio','TRUE',14135,39153,'Summit','FALSE','America/New_York','44301','en',1,'Y');
   i(31.44993,-90.4619,'Bogue Chitto','MS','Mississippi','TRUE',7457,28085,'Lincoln','FALSE','America/Chicago','39629','en',1,'Y');
   i(35.47667,-88.49888,'Jacks Creek','TN','Tennessee','TRUE',511,47023,'Chester','FALSE','America/Chicago','38347','en',1,'Y');
   i(38.30522,-85.48568,'Pewee Valley','KY','Kentucky','TRUE',3136,21185,'Oldham','FALSE','America/New_York','40056','en',1,'Y');
   i(39.99144,-83.00212,'Columbus','OH','Ohio','TRUE',30902,39049,'Franklin','FALSE','America/New_York','43201','en',1,'Y');
   i(31.45355,-89.9485,'Oak Vale','MS','Mississippi','TRUE',754,28065,'Jefferson Davis','FALSE','America/Chicago','39656','en',1,'Y');
   i(38.19563,-84.86509,'Frankfort','KY','Kentucky','TRUE',54168,21073,'Franklin','FALSE','America/New_York','40601','en',1,'Y');
   i(32.29201,-90.18664,'Jackson','MS','Mississippi','TRUE',463,28049,'Hinds','FALSE','America/Chicago','39201','en',1,'Y');
   i(38.59756,-92.17931,'Jefferson City','MO','Missouri','TRUE',29769,29051,'Cole','FALSE','America/Chicago','65101','en',1,'Y');
   i(36.86758,-82.96977,'Holmes Mill','KY','Kentucky','TRUE',271,21095,'Harlan','FALSE','America/New_York','40843','en',1,'Y');
   i(35.78878,-86.36073,'Murfreesboro','TN','Tennessee','TRUE',17006,47149,'Rutherford','FALSE','America/Chicago','37127','en',1,'Y');
   i(40.78423,-98.7383,'Shelton','NE','Nebraska','TRUE',1678,31019,'Buffalo','FALSE','America/Chicago','68876','en',1,'Y');
   i(38.04054,-84.5414,'Lexington','KY','Kentucky','TRUE',27397,21067,'Fayette','FALSE','America/New_York','40504','en',1,'Y');
   i(40.58044,-98.21473,'Inland','NE','Nebraska','TRUE',13,31035,'Clay','FALSE','America/Chicago','68954','en',1,'Y');
   i(36.16587,-86.77809,'Nashville','TN','Tennessee','TRUE',1253,47037,'Davidson','FALSE','America/Chicago','37201','en',1,'Y');
   i(39.16426,-84.54719,'Cincinnati','OH','Ohio','TRUE',11250,39061,'Hamilton','FALSE','America/New_York','45223','en',1,'Y');
   i(39.75831,-84.20646,'Dayton','OH','Ohio','TRUE',9945,39113,'Montgomery','FALSE','America/New_York','45402','en',1,'Y');
   i(39.81937,-89.64864,'Springfield','IL','Illinois','TRUE',30706,17167,'Sangamon','FALSE','America/Chicago','62702','en',1,'Y');
   i(31.28649,-89.2946,'Hattiesburg','MS','Mississippi','TRUE',41341,28035,'Forrest','FALSE','America/Chicago','39401','en',1,'Y');
   i(31.98494,-90.35005,'Crystal Springs','MS','Mississippi','TRUE',12095,28029,'Copiah','FALSE','America/Chicago','39059','en',1,'Y');
   i(37.73169,-89.21589,'Carbondale','IL','Illinois','TRUE',26115,17077,'Jackson','FALSE','America/Chicago','62901','en',1,'Y');
   i(35.15279,-90.05386,'Memphis','TN','Tennessee','TRUE',12710,47157,'Shelby','FALSE','America/Chicago','38103','en',1,'Y');
   i(38.53236,-93.93184,'Blairstown','MO','Missouri','TRUE',295,29083,'Henry','FALSE','America/Chicago','64726','en',1,'Y');
   i(30.40208,-88.89328,'Biloxi','MS','Mississippi','TRUE',8497,28047,'Harrison','FALSE','America/Chicago','39530','en',1,'Y');
   i(43.65591,-95.1869,'Lakefield','MN','Minnesota','TRUE',2478,27063,'Jackson','FALSE','America/Chicago','56150','en',1,'Y');
   i(40.56965,-88.61982,'Colfax','IL','Illinois','TRUE',1267,17113,'McLean','FALSE','America/Chicago','61728','en',1,'Y');
   i(44.99638,-90.86131,'Thorp','WI','Wisconsin','TRUE',4270,55019,'Clark','FALSE','America/Chicago','54771','en',1,'Y');
   i(39.64172,-93.0359,'Rothville','MO','Missouri','TRUE',136,29041,'Chariton','FALSE','America/Chicago','64676','en',1,'Y');
   i(38.87263,-96.48055,'Alta Vista','KS','Kansas','TRUE',916,20197,'Wabaunsee','FALSE','America/Chicago','66834','en',1,'Y');
   i(38.90211,-90.58413,'Golden Eagle','IL','Illinois','TRUE',792,17013,'Calhoun','FALSE','America/Chicago','62036','en',1,'Y');
   i(38.31796,-89.88923,'New Athens','IL','Illinois','TRUE',3606,17163,'St. Clair','FALSE','America/Chicago','62264','en',1,'Y');
   i(38.85047,-96.58609,'Dwight','KS','Kansas','TRUE',428,20127,'Morris','FALSE','America/Chicago','66849','en',1,'Y');
   i(38.42775,-90.40163,'Arnold','MO','Missouri','TRUE',32768,29099,'Jefferson','FALSE','America/Chicago','63010','en',1,'Y');
   i(39.82273,-88.91827,'Decatur','IL','Illinois','TRUE',35910,17115,'Macon','FALSE','America/Chicago','62521','en',1,'Y');
   i(47.55933,-98.786,'Grace City','ND','North Dakota','TRUE',268,38031,'Foster','FALSE','America/Chicago','58445','en',1,'Y');
   i(44.9463,-91.0261,'Boyd','WI','Wisconsin','TRUE',1913,55017,'Chippewa','FALSE','America/Chicago','54726','en',1,'Y');
   i(44.42693,-95.55094,'Milroy','MN','Minnesota','TRUE',520,27127,'Redwood','FALSE','America/Chicago','56263','en',1,'Y');
   i(38.63277,-90.19156,'Saint Louis','MO','Missouri','TRUE',3245,29510,'St. Louis','FALSE','America/Chicago','63101','en',1,'Y');
   i(39.11395,-94.62481,'Kansas City','KS','Kansas','TRUE',12401,20209,'Wyandotte','FALSE','America/Chicago','66101','en',1,'Y');
   i(41.95071,-99.82631,'Brewster','NE','Nebraska','TRUE',65,31009,'Blaine','FALSE','America/Chicago','68821','en',1,'Y');
   i(46.90832,-96.81122,'Fargo','ND','North Dakota','TRUE',31490,38017,'Cass','FALSE','America/Chicago','58102','en',1,'Y');
   i(48.13278,-97.6666,'Inkster','ND','North Dakota','TRUE',111,38035,'Grand Forks','FALSE','America/Chicago','58244','en',1,'Y');
   i(48.10523,-98.8821,'Devils Lake','ND','North Dakota','TRUE',10604,38071,'Ramsey','FALSE','America/Chicago','58301','en',1,'Y');
   i(47.77301,-99.8044,'Harvey','ND','North Dakota','TRUE',2789,38103,'Wells','FALSE','America/Chicago','58341','en',1,'Y');
   i(37.84335,-88.62573,'Galatia','IL','Illinois','TRUE',1881,17165,'Saline','FALSE','America/Chicago','62935','en',1,'Y');
   i(38.98476,-95.23335,'Lawrence','KS','Kansas','TRUE',26865,20045,'Douglas','FALSE','America/Chicago','66044','en',1,'Y');
   i(40.78537,-96.6939,'Lincoln','NE','Nebraska','TRUE',27364,31109,'Lancaster','FALSE','America/Chicago','68502','en',1,'Y');
   i(41.26063,-95.93685,'Omaha','NE','Nebraska','TRUE',7610,31055,'Douglas','FALSE','America/Chicago','68102','en',1,'Y');
   i(48.00619,-97.34461,'Mekinock','ND','North Dakota','TRUE',357,38035,'Grand Forks','FALSE','America/Chicago','58258','en',1,'Y');
   i(41.07206,-97.22734,'Ulysses','NE','Nebraska','TRUE',391,31023,'Butler','FALSE','America/Chicago','68669','en',1,'Y');
   i(44.77071,-93.27181,'Burnsville','MN','Minnesota','TRUE',41992,27037,'Dakota','FALSE','America/Chicago','55337','en',1,'Y');
   i(45.51348,-94.2019,'Saint Cloud','MN','Minnesota','TRUE',33059,27145,'Stearns','FALSE','America/Chicago','56301','en',1,'Y');
   i(42.51445,-97.18675,'Coleridge','NE','Nebraska','TRUE',829,31027,'Cedar','FALSE','America/Chicago','68727','en',1,'Y');
   i(44.36922,-97.84398,'Iroquois','SD','South Dakota','TRUE',872,46077,'Kingsbury','FALSE','America/Chicago','57353','en',1,'Y');
   i(46.58538,-112.03995,'Helena','MT','Montana','TRUE',30503,30049,'Lewis and Clark','FALSE','America/Denver','59601','en',1,'Y');
   i(45.99102,-112.51805,'Butte','MT','Montana','TRUE',33552,30093,'Silver Bow','FALSE','America/Denver','59701','en',1,'Y');
   i(41.84582,-87.62929,'Chicago','IL','Illinois','TRUE',53135,17031,'Cook','FALSE','America/Chicago','60616','en',1,'Y');
   i(44.7284,-111.17757,'West Yellowstone','MT','Montana','TRUE',1377,30031,'Gallatin','FALSE','America/Denver','59758','en',1,'Y');
   i(33.96041,-117.63177,'Chino','CA','California','TRUE',3625,6071,'San Bernardino','FALSE','America/Los_Angeles','91708','en',1,'Y');
   i(46.64458,-97.26413,'Leonard','ND','North Dakota','TRUE',528,38017,'Cass','FALSE','America/Chicago','58052','en',1,'Y');
   i(45.31376,-97.54791,'Webster','SD','South Dakota','TRUE',2353,46037,'Day','FALSE','America/Chicago','57274','en',1,'Y');
   i(47.36479,-110.09353,'Coffee Creek','MT','Montana','TRUE',76,30027,'Fergus','FALSE','America/Denver','59424','en',1,'Y');
   i(44.42643,-98.71156,'Wessington','SD','South Dakota','TRUE',549,46005,'Beadle','FALSE','America/Chicago','57381','en',1,'Y');
   i(43.24037,-100.84602,'Rosebud','SD','South Dakota','TRUE',2148,46121,'Todd','FALSE','America/Chicago','57570','en',1,'Y');
   i(45.50817,-108.92484,'Joliet','MT','Montana','TRUE',1670,30009,'Carbon','FALSE','America/Denver','59041','en',1,'Y');
   i(44.9846,-93.26954,'Minneapolis','MN','Minnesota','TRUE',9083,27053,'Hennepin','FALSE','America/Chicago','55401','en',1,'Y');
   i(47.33621,-114.07832,'Saint Ignatius','MT','Montana','TRUE',3456,30047,'Lake','FALSE','America/Denver','59865','en',1,'Y');
   i(34.17481,-118.3474,'Burbank','CA','California','TRUE',30963,6037,'Los Angeles','FALSE','America/Los_Angeles','91505','en',1,'Y');
   i(39.74279,-105.0708,'Denver','CO','Colorado','TRUE',26909,8059,'Jefferson','FALSE','America/Denver','80214','en',1,'Y');
   i(46.79935,-92.09865,'Duluth','MN','Minnesota','TRUE',9142,27137,'St. Louis','FALSE','America/Chicago','55805','en',1,'Y');
   i(39.86752,-105.47702,'Black Hawk','CO','Colorado','TRUE',4751,8047,'Gilpin','FALSE','America/Denver','80422','en',1,'Y');
   i(48.91453,-102.36754,'Flaxton','ND','North Dakota','TRUE',183,38013,'Burke','FALSE','America/Chicago','58737','en',1,'Y');
   i(40.4828245,-106.8290503,'Steamboat Springs','CO','Colorado','TRUE',119,8107,'Routt','FALSE','America/Denver','80477','en',1,'Y');
   i(35.41915,-109.58206,'Red Valley','AZ','Arizona','TRUE',1152,4001,'Apache','FALSE','America/Denver','86544','en',1,'Y');
   i(35.41999,-106.43163,'Algodones','NM','New Mexico','TRUE',3875,35043,'Sandoval','FALSE','America/Denver','87001','en',1,'Y');
   i(48.84547,-114.99687,'Eureka','MT','Montana','TRUE',4617,30053,'Lincoln','FALSE','America/Denver','59917','en',1,'Y');
   i(43.53468,-96.69286,'Sioux Falls','SD','South Dakota','TRUE',38792,46099,'Minnehaha','FALSE','America/Chicago','57103','en',1,'Y');
   i(45.52334,-96.9837,'Peever','SD','South Dakota','TRUE',615,46109,'Roberts','FALSE','America/Chicago','57257','en',1,'Y');
   i(48.61296,-103.48227,'Alamo','ND','North Dakota','TRUE',266,38105,'Williams','FALSE','America/Chicago','58830','en',1,'Y');
   i(43.70679,-116.51884,'Star','ID','Idaho','TRUE',9794,16001,'Ada','FALSE','America/Boise','83669','en',1,'Y');
   i(43.63355,-116.1994,'Boise','ID','Idaho','TRUE',22168,16001,'Ada','FALSE','America/Boise','83702','en',1,'Y');
   i(35.08383,-106.64569,'Albuquerque','NM','New Mexico','TRUE',20400,35001,'Bernalillo','FALSE','America/Denver','87102','en',1,'Y');
   i(39.9451,-87.47207,'Cayuga','IN','Indiana','TRUE',2298,18165,'Vermillion','FALSE','America/Indiana/Indianapolis','47928','en',1,'Y');
   i(42.2149,-83.61886,'Ypsilanti','MI','Michigan','TRUE',67512,26161,'Washtenaw','FALSE','America/Detroit','48197','en',1,'Y');
   i(46.01095,-107.23997,'Bighorn','MT','Montana','TRUE',144,30103,'Treasure','FALSE','America/Denver','59010','en',1,'Y');
   i(35.61404,-106.35718,'Cochiti Pueblo','NM','New Mexico','TRUE',703,35043,'Sandoval','FALSE','America/Denver','87072','en',1,'Y');
   i(38.87855,-104.82385,'Colorado Springs','CO','Colorado','TRUE',26141,8041,'El Paso','FALSE','America/Denver','80907','en',1,'Y');
   i(40.5637,-111.78672,'Sandy','UT','Utah','TRUE',28350,49035,'Salt Lake','FALSE','America/Denver','84092','en',1,'Y');
   i(41.62857,-111.84856,'Hyrum','UT','Utah','TRUE',8499,49005,'Cache','FALSE','America/Denver','84319','en',1,'Y');
   i(32.85965,-92.72567,'Lisbon','LA','Louisiana','TRUE',49,22027,'Claiborne','FALSE','America/Chicago','71048','en',1,'Y');
   i(37.09908,-112.23931,'Kanab','UT','Utah','TRUE',6053,49025,'Kane','FALSE','America/Denver','84741','en',1,'Y');
   i(32.70138,-114.65147,'Yuma','AZ','Arizona','TRUE',67142,4027,'Yuma','FALSE','America/Phoenix','85364','en',1,'Y');
   i(41.14424,-104.78821,'Cheyenne','WY','Wyoming','TRUE',34937,56021,'Laramie','FALSE','America/Denver','82001','en',1,'Y');
   i(39.71398,-106.65095,'Wolcott','CO','Colorado','TRUE',103,8037,'Eagle','FALSE','America/Denver','81655','en',1,'Y');
   i(42.60048,-112.024,'Lava Hot Springs','ID','Idaho','TRUE',986,16005,'Bannock','FALSE','America/Boise','83246','en',1,'Y');
   i(42.0373,-106.08208,'Medicine Bow','WY','Wyoming','TRUE',336,56007,'Carbon','FALSE','America/Denver','82329','en',1,'Y');
   i(33.43398,-111.8485,'Mesa','AZ','Arizona','TRUE',47063,4013,'Maricopa','FALSE','America/Phoenix','85201','en',1,'Y');
   i(32.66182,-110.663,'San Manuel','AZ','Arizona','TRUE',3532,4021,'Pinal','FALSE','America/Phoenix','85631','en',1,'Y');
   i(43.74565,-114.48226,'Ketchum','ID','Idaho','TRUE',4633,16013,'Blaine','FALSE','America/Boise','83340','en',1,'Y');
   i(32.31076,-110.92112,'Tucson','AZ','Arizona','TRUE',24281,4019,'Pima','FALSE','America/Phoenix','85718','en',1,'Y');
   i(30.44873,-91.18823,'Baton Rouge','LA','Louisiana','TRUE',81,22033,'East Baton Rouge','FALSE','America/Chicago','70801','en',1,'Y');
   i(41.08312,-111.92873,'Layton','UT','Utah','TRUE',22213,49011,'Davis','FALSE','America/Denver','84040','en',1,'Y');
   i(40.75936,-111.90058,'Salt Lake City','UT','Utah','TRUE',4918,49035,'Salt Lake','FALSE','America/Denver','84101','en',1,'Y');
   i(29.75749,-95.3673,'Houston','TX','Texas','TRUE',12769,48201,'Harris','FALSE','America/Chicago','77002','en',1,'Y');
   i(29.99093,-91.85081,'New Iberia','LA','Louisiana','TRUE',41520,22045,'Iberia','FALSE','America/Chicago','70560','en',1,'Y');
   i(40.32199,-112.49386,'Rush Valley','UT','Utah','TRUE',527,49045,'Tooele','FALSE','America/Denver','84069','en',1,'Y');
   i(33.16384,-107.18375,'Truth Or Consequences','NM','New Mexico','TRUE',6073,35051,'Sierra','FALSE','America/Denver','87901','en',1,'Y');
   i(33.6162,-111.95387,'Scottsdale','AZ','Arizona','TRUE',48503,4013,'Maricopa','FALSE','America/Phoenix','85254','en',1,'Y');
   i(40.28893,-118.40021,'Lovelock','NV','Nevada','TRUE',5163,32027,'Pershing','FALSE','America/Los_Angeles','89419','en',1,'Y');
   i(39.64752,-105.01612,'Englewood','CO','Colorado','TRUE',20896,8005,'Arapahoe','FALSE','America/Denver','80110','en',1,'Y');
   i(34.76981,-103.72553,'Mcalister','NM','New Mexico','TRUE',212,35037,'Quay','FALSE','America/Denver','88427','en',1,'Y');
   i(36.07672,-114.97844,'Henderson','NV','Nevada','TRUE',24483,32003,'Clark','FALSE','America/Los_Angeles','89011','en',1,'Y');
   i(36.17289,-115.12179,'Las Vegas','NV','Nevada','TRUE',45618,32003,'Clark','FALSE','America/Los_Angeles','89101','en',1,'Y');
   i(29.47757,-98.35053,'San Antonio','TX','Texas','TRUE',29810,48029,'Bexar','FALSE','America/Chicago','78244','en',1,'Y');
   i(18.42215,-66.750505,'Arecibo','PR','Puerto Rico','TRUE',56833,72013,'Arecibo','FALSE','America/Puerto_Rico','00612','en',1,'Y');
   i(18.37406,-66.56159,'Florida','PR','Puerto Rico','TRUE',14191,72054,'Florida','FALSE','America/Puerto_Rico','00650','en',1,'Y');
   i(18.46634,-66.10474,'San Juan','PR','Puerto Rico','FALSE',180,72127,'San Juan','FALSE','America/Puerto_Rico','00906','en',1,'Y');
   i(18.4423098,-66.0107627,'Carolina','PR','Puerto Rico','TRUE',16370,72031,'Carolina','FALSE','America/Puerto_Rico','00979','en',1,'Y');
   i(42.10282,-72.59065,'Springfield','MA','Massachusetts','TRUE',2336,25013,'Hampden','FALSE','America/New_York','01103','en',1,'Y');
   i(42.65517,-71.30437,'Lowell','MA','Massachusetts','TRUE',15835,25017,'Middlesex','FALSE','America/New_York','01850','en',1,'Y');
   i(42.51454,-70.90227,'Salem','MA','Massachusetts','TRUE',42371,25009,'Essex','FALSE','America/New_York','01970','en',1,'Y');
   i(42.34688,-71.08203,'Boston','MA','Massachusetts','TRUE',1095,25025,'Suffolk','FALSE','America/New_York','02199','en',1,'Y');
   i(42.31302,-71.27506,'Wellesley Hills','MA','Massachusetts','TRUE',15440,25021,'Norfolk','FALSE','America/New_York','02481','en',1,'Y');
   i(44.27987,-71.6876,'Bethlehem','NH','New Hampshire','TRUE',2507,33009,'Grafton','FALSE','America/New_York','03574','en',1,'Y');
   i(41.76926,-71.46711,'Cranston','RI','Rhode Island','TRUE',40242,44007,'Providence','FALSE','America/New_York','02920','en',1,'Y');
   i(42.74744,-71.46301,'Nashua','NH','New Hampshire','TRUE',30470,33011,'Hillsborough','FALSE','America/New_York','03060','en',1,'Y');
   i(41.63564,-70.93924,'New Bedford','MA','Massachusetts','TRUE',44120,25005,'Bristol','FALSE','America/New_York','02740','en',1,'Y');
   i(41.50798,-71.71857,'Hope Valley','RI','Rhode Island','TRUE',4721,44009,'Washington','FALSE','America/New_York','02832','en',1,'Y');
   i(43.80164,-71.44549,'Center Sandwich','NH','New Hampshire','TRUE',922,33003,'Carroll','FALSE','America/New_York','03227','en',1,'Y');
   i(43.55673,-71.46787,'Laconia','NH','New Hampshire','TRUE',16687,33001,'Belknap','FALSE','America/New_York','03246','en',1,'Y');
   i(41.63977,-71.68881,'West Greenwich','RI','Rhode Island','TRUE',5468,44003,'Kent','FALSE','America/New_York','02817','en',1,'Y');
   i(41.48796,-71.31225,'Newport','RI','Rhode Island','TRUE',21332,44005,'Newport','FALSE','America/New_York','02840','en',1,'Y');
   i(44.04825,-68.83117,'Vinalhaven','ME','Maine','TRUE',1048,23013,'Knox','FALSE','America/New_York','04863','en',1,'Y');
   i(41.43094,-71.46416,'Narragansett','RI','Rhode Island','TRUE',13944,44009,'Washington','FALSE','America/New_York','02882','en',1,'Y');
   i(41.82129,-71.41382,'Providence','RI','Rhode Island','TRUE',11439,44007,'Providence','FALSE','America/New_York','02903','en',1,'Y');
   i(44.10991,-69.11466,'Rockland','ME','Maine','TRUE',7197,23013,'Knox','FALSE','America/New_York','04841','en',1,'Y');
   i(43.85141,-69.62842,'Boothbay Harbor','ME','Maine','TRUE',1899,23015,'Lincoln','FALSE','America/New_York','04538','en',1,'Y');
   i(44.36306,-69.63652,'Augusta','ME','Maine','TRUE',27034,23011,'Kennebec','FALSE','America/New_York','04330','en',1,'Y');
   i(42.99214,-71.48604,'Manchester','NH','New Hampshire','TRUE',30337,33011,'Hillsborough','FALSE','America/New_York','03102','en',1,'Y');
   i(43.21207,-71.53735,'Concord','NH','New Hampshire','TRUE',30032,33013,'Merrimack','FALSE','America/New_York','03301','en',1,'Y');
   i(45.07147,-68.90467,'Bradford','ME','Maine','TRUE',1068,23019,'Penobscot','FALSE','America/New_York','04410','en',1,'Y');
   i(43.65908,-70.25232,'Portland','ME','Maine','TRUE',16300,23005,'Cumberland','FALSE','America/New_York','04101','en',1,'Y');
   i(43.01216,-70.91658,'Stratham','NH','New Hampshire','TRUE',7375,33015,'Rockingham','FALSE','America/New_York','03885','en',1,'Y');
   i(47.15788,-67.9365,'Van Buren','ME','Maine','TRUE',2109,23003,'Aroostook','FALSE','America/New_York','04785','en',1,'Y');
   i(44.48803,-72.96173,'Jericho','VT','Vermont','TRUE',5423,50007,'Chittenden','FALSE','America/New_York','05465','en',1,'Y');
   i(44.5742,-69.27763,'Thorndike','ME','Maine','TRUE',1583,23027,'Waldo','FALSE','America/New_York','04986','en',1,'Y');
   i(44.47481,-73.19595,'Burlington','VT','Vermont','TRUE',4109,50007,'Chittenden','FALSE','America/New_York','05405','en',1,'Y');
   i(45.54815,-68.19722,'Kingman','ME','Maine','TRUE',188,23019,'Penobscot','FALSE','America/New_York','04451','en',1,'Y');
   i(44.01643,-73.16712,'Middlebury','VT','Vermont','TRUE',10963,50001,'Addison','FALSE','America/New_York','05753','en',1,'Y');
   i(42.85274,-72.55829,'Brattleboro','VT','Vermont','TRUE',17764,50025,'Windham','FALSE','America/New_York','05301','en',1,'Y');
   i(44.42988,-71.88222,'Concord','VT','Vermont','TRUE',1112,50009,'Essex','FALSE','America/New_York','05824','en',1,'Y');
   i(40.9134,-74.17133,'Paterson','NJ','New Jersey','TRUE',29940,34031,'Passaic','FALSE','America/New_York','07501','en',1,'Y');
   i(41.46482,-72.57618,'Higganum','CT','Connecticut','TRUE',5422,9007,'Middlesex','FALSE','America/New_York','06441','en',1,'Y');
   i(41.30573,-72.92552,'New Haven','CT','Connecticut','TRUE',2465,9009,'New Haven','FALSE','America/New_York','06510','en',1,'Y');
   i(41.79059,-72.69477,'Hartford','CT','Connecticut','TRUE',20781,9003,'Hartford','FALSE','America/New_York','06112','en',1,'Y');
   i(44.26323,-72.58513,'Montpelier','VT','Vermont','TRUE',10955,50023,'Washington','FALSE','America/New_York','05602','en',1,'Y');
   i(41.37396,-71.84845,'Pawcatuck','CT','Connecticut','TRUE',8273,9011,'New London','FALSE','America/New_York','06379','en',1,'Y');
   i(41.05353,-73.53887,'Stamford','CT','Connecticut','TRUE',7637,9001,'Fairfield','FALSE','America/New_York','06901','en',1,'Y');
   i(40.73477,-74.17262,'Newark','NJ','New Jersey','TRUE',14097,34013,'Essex','FALSE','America/New_York','07102','en',1,'Y');
   i(40.72037,-74.04551,'Jersey City','NJ','New Jersey','TRUE',40519,34017,'Hudson','FALSE','America/New_York','07302','en',1,'Y');
   i(41.55572,-73.03975,'Waterbury','CT','Connecticut','TRUE',2765,9009,'New Haven','FALSE','America/New_York','06702','en',1,'Y');
   i(39.53764,-74.60816,'Egg Harbor City','NJ','New Jersey','TRUE',13042,34001,'Atlantic','FALSE','America/New_York','08215','en',1,'Y');
   i(39.92793,-75.03046,'Cherry Hill','NJ','New Jersey','TRUE',23065,34007,'Camden','FALSE','America/New_York','08002','en',1,'Y');
   i(40.64242,-74.07527,'Staten Island','NY','New York','TRUE',40694,36085,'Richmond','FALSE','America/New_York','10301','en',1,'Y');
   i(40.826,-73.92309,'Bronx','NY','New York','TRUE',49459,36005,'Bronx','FALSE','America/New_York','10451','en',1,'Y');
   i(40.69245,-73.99036,'Brooklyn','NY','New York','TRUE',59766,36047,'Kings','FALSE','America/New_York','11201','en',1,'Y');
   i(42.63933,-73.76247,'Albany','NY','New York','TRUE',9716,36001,'Albany','FALSE','America/New_York','12202','en',1,'Y');
   i(43.068,-76.17308,'Syracuse','NY','New York','TRUE',0,36067,'Onondaga','FALSE','America/New_York','13290','en',1,'Y');
   i(44.70655,-73.48697,'Plattsburgh','NY','New York','TRUE',31077,36019,'Clinton','FALSE','America/New_York','12901','en',1,'Y');
   i(43.08247,-75.23361,'Utica','NY','New York','TRUE',35496,36065,'Oneida','FALSE','America/New_York','13501','en',1,'Y');
   i(40.36176,-80.412,'Langeloth','PA','Pennsylvania','TRUE',418,42125,'Washington','FALSE','America/New_York','15054','en',1,'Y');
   i(42.89582,-78.8854,'Buffalo','NY','New York','TRUE',11882,36029,'Erie','FALSE','America/New_York','14201','en',1,'Y');
   i(43.1571,-77.60536,'Rochester','NY','New York','TRUE',2258,36055,'Monroe','FALSE','America/New_York','14604','en',1,'Y');
   i(40.15493,-79.97487,'Van Voorhis','PA','Pennsylvania','TRUE',181,42125,'Washington','FALSE','America/New_York','15366','en',1,'Y');
   i(40.06085,-76.19191,'Bird In Hand','PA','Pennsylvania','TRUE',1663,42071,'Lancaster','FALSE','America/New_York','17505','en',1,'Y');
   i(41.17547,-76.19238,'Shickshinny','PA','Pennsylvania','TRUE',6219,42079,'Luzerne','FALSE','America/New_York','18655','en',1,'Y');
   i(26.99115,-82.09682,'Port Charlotte','FL','Florida','TRUE',35884,12015,'Charlotte','FALSE','America/New_York','33952','en',1,'Y');
   i(30.64519,-88.24399,'Mobile','AL','Alabama','TRUE',55637,1097,'Mobile','FALSE','America/Chicago','36695','en',1,'Y');
   i(40.2621,-76.88229,'Harrisburg','PA','Pennsylvania','TRUE',1987,42043,'Dauphin','FALSE','America/New_York','17101','en',1,'Y');
   i(32.2258,-80.73882,'Hilton Head Island','SC','South Carolina','TRUE',24278,45013,'Beaufort','FALSE','America/New_York','29926','en',1,'Y');
   i(25.75537,-80.20497,'Miami','FL','Florida','TRUE',13536,12086,'Miami-Dade','FALSE','America/New_York','33129','en',1,'Y');
   i(28.03309,-82.72586,'Clearwater','FL','Florida','TRUE',19699,12103,'Pinellas','FALSE','America/New_York','33761','en',1,'Y');
   i(34.69792,-83.68931,'Sautee Nacoochee','GA','Georgia','TRUE',3820,13311,'White','FALSE','America/New_York','30571','en',1,'Y');
   i(31.40286,-86.6087,'Red Level','AL','Alabama','TRUE',3079,1039,'Covington','FALSE','America/Chicago','36474','en',1,'Y');
   i(32.83449,-83.63943,'Macon','GA','Georgia','TRUE',7929,13021,'Bibb','FALSE','America/New_York','31201','en',1,'Y');
   i(28.54094,-81.24759,'Orlando','FL','Florida','TRUE',64612,12095,'Orange','FALSE','America/New_York','32825','en',1,'Y');
   i(29.79367,-82.48876,'Alachua','FL','Florida','TRUE',13834,12001,'Alachua','FALSE','America/New_York','32615','en',1,'Y');
   i(32.96771,-81.23801,'Fairfax','SC','South Carolina','TRUE',4227,45005,'Allendale','FALSE','America/New_York','29827','en',1,'Y');
   i(32.02342,-84.81107,'Lumpkin','GA','Georgia','TRUE',3441,13259,'Stewart','FALSE','America/New_York','31815','en',1,'Y');
   i(37.55841,-80.80551,'Forest Hill','WV','West Virginia','TRUE',442,54089,'Summers','FALSE','America/New_York','24935','en',1,'Y');
   i(30.80433,-83.68495,'Dixie','GA','Georgia','TRUE',669,13027,'Brooks','FALSE','America/New_York','31629','en',1,'Y');
   i(33.31921,-84.03607,'Jenkinsburg','GA','Georgia','TRUE',2186,13035,'Butts','FALSE','America/New_York','30234','en',1,'Y');
   i(30.35965,-81.69252,'Jacksonville','FL','Florida','TRUE',36767,12031,'Duval','FALSE','America/New_York','32209','en',1,'Y');
   i(30.42959,-84.26055,'Tallahassee','FL','Florida','TRUE',33642,12073,'Leon','FALSE','America/New_York','32301','en',1,'Y');
   i(34.72519,-86.57064,'Huntsville','AL','Alabama','TRUE',22560,1089,'Madison','FALSE','America/Chicago','35801','en',1,'Y');
   i(28.54226,-81.37495,'Orlando','FL','Florida','TRUE',13165,12095,'Orange','FALSE','America/New_York','32801','en',1,'Y');
   i(33.50559,-81.8666,'Bath','SC','South Carolina','TRUE',994,45003,'Aiken','FALSE','America/New_York','29816','en',1,'Y');
   i(30.32921,-81.6534,'Jacksonville','FL','Florida','TRUE',6437,12031,'Duval','FALSE','America/New_York','32202','en',1,'Y');
   i(34.065645,-86.30576,'Walnut Grove','AL','Alabama','TRUE',122,1055,'Etowah','FALSE','America/Chicago','35990','en',1,'Y');
   i(33.99647,-81.029065,'Columbia','SC','South Carolina','TRUE',789,45079,'Richland','FALSE','America/New_York','29208','en',1,'Y');
   i(33.81698,-86.61052,'Remlap','AL','Alabama','TRUE',3791,1009,'Blount','FALSE','America/Chicago','35133','en',1,'Y');
   i(32.85988,-84.88018,'Pine Mountain','GA','Georgia','TRUE',6179,13145,'Harris','FALSE','America/New_York','31822','en',1,'Y');
   i(32.37684,-86.31134,'Montgomery','AL','Alabama','TRUE',7764,1101,'Montgomery','FALSE','America/Chicago','36104','en',1,'Y');
   i(35.94547,-79.04022,'Chapel Hill','NC','North Carolina','TRUE',34314,37135,'Orange','FALSE','America/New_York','27514','en',1,'Y');
   i(27.95572,-82.45662,'Tampa','FL','Florida','TRUE',13576,12057,'Hillsborough','FALSE','America/New_York','33602','en',1,'Y');
   i(33.51892,-86.80979,'Birmingham','AL','Alabama','TRUE',3270,1073,'Jefferson','FALSE','America/Chicago','35203','en',1,'Y');
   i(34.01191,-86.74912,'Garden City','AL','Alabama','TRUE',245,1043,'Cullman','FALSE','America/Chicago','35070','en',1,'Y');
   i(38.9045,-77.03277,'Washington','DC','District of Columbia','TRUE',13609,11001,'District of Columbia','FALSE','America/New_York','20005','en',1,'Y');
   i(33.36459,-87.59858,'Northport','AL','Alabama','TRUE',15882,1125,'Tuscaloosa','FALSE','America/Chicago','35475','en',1,'Y');
   i(38.07229,-78.51276,'Charlottesville','VA','Virginia','TRUE',36552,51003,'Albemarle','FALSE','America/New_York','22901','en',1,'Y');
   i(33.37082,-80.97413,'Cope','SC','South Carolina','TRUE',1971,45075,'Orangeburg','FALSE','America/New_York','29038','en',1,'Y');
   i(32.95088,-80.52926,'Round O','SC','South Carolina','TRUE',2114,45029,'Colleton','FALSE','America/New_York','29474','en',1,'Y');
   i(33.76258,-85.46021,'Fruithurst','AL','Alabama','TRUE',1445,1029,'Cleburne','FALSE','America/Chicago','36262','en',1,'Y');
   i(35.26719,-82.67456,'Pisgah Forest','NC','North Carolina','TRUE',7726,37175,'Transylvania','FALSE','America/New_York','28768','en',1,'Y');
   i(33.76722,-78.79037,'Myrtle Beach','SC','South Carolina','TRUE',9265,45051,'Horry','FALSE','America/New_York','29572','en',1,'Y');
   i(39.1019,-75.56463,'Camden Wyoming','DE','Delaware','TRUE',13781,10001,'Kent','FALSE','America/New_York','19934','en',1,'Y');
   i(39.03387,-75.45973,'Frederica','DE','Delaware','TRUE',5718,10001,'Kent','FALSE','America/New_York','19946','en',1,'Y');
   i(39.19852,-76.75959,'Elkridge','MD','Maryland','TRUE',33522,24027,'Howard','FALSE','America/New_York','21075','en',1,'Y');
   i(37.35943,-78.81316,'Appomattox','VA','Virginia','TRUE',9289,51011,'Appomattox','FALSE','America/New_York','24522','en',1,'Y');
   i(35.59565,-82.55651,'Asheville','NC','North Carolina','TRUE',13641,37021,'Buncombe','FALSE','America/New_York','28801','en',1,'Y');
   i(38.92006,-75.57708,'Harrington','DE','Delaware','TRUE',9762,10001,'Kent','FALSE','America/New_York','19952','en',1,'Y');
   i(33.09811,-83.24225,'Milledgeville','GA','Georgia','TRUE',43361,13009,'Baldwin','FALSE','America/New_York','31061','en',1,'Y');
   i(33.99433,-81.25567,'Lexington','SC','South Carolina','TRUE',58865,45063,'Lexington','FALSE','America/New_York','29072','en',1,'Y');
   i(33.95387,-80.3268,'Sumter','SC','South Carolina','TRUE',14448,45085,'Sumter','FALSE','America/New_York','29153','en',1,'Y');
   i(36.04908,-86.64619,'Antioch','TN','Tennessee','TRUE',92678,47037,'Davidson','FALSE','America/Chicago','37013','en',1,'Y');
   i(38.57838,-82.02366,'Fraziers Bottom','WV','West Virginia','TRUE',1550,54079,'Putnam','FALSE','America/New_York','25082','en',1,'Y');
   i(33.49107,-84.47656,'Fayetteville','GA','Georgia','TRUE',30401,13113,'Fayette','FALSE','America/New_York','30214','en',1,'Y');
   i(35.7733,-78.63474,'Raleigh','NC','North Carolina','TRUE',11462,37183,'Wake','FALSE','America/New_York','27601','en',1,'Y');
   i(38.60799,-75.94803,'Secretary','MD','Maryland','TRUE',427,24019,'Dorchester','FALSE','America/New_York','21664','en',1,'Y');
   i(42.8164,-89.63997,'New Glarus','WI','Wisconsin','TRUE',3502,55045,'Green','FALSE','America/Chicago','53574','en',1,'Y');
   i(39.42634,-77.65853,'Rohrersville','MD','Maryland','TRUE',1084,24043,'Washington','FALSE','America/New_York','21779','en',1,'Y');
   i(37.54131,-81.38357,'Bud','WV','West Virginia','TRUE',422,54109,'Wyoming','FALSE','America/New_York','24716','en',1,'Y');
   i(37.97413,-87.57258,'Evansville','IN','Indiana','TRUE',336,18163,'Vanderburgh','FALSE','America/Chicago','47708','en',1,'Y');
   i(38.57436,-76.70023,'Aquasco','MD','Maryland','TRUE',667,24033,'Prince George''s','FALSE','America/New_York','20608','en',1,'Y');
   i(38.77675,-79.92101,'Valley Bend','WV','West Virginia','TRUE',570,54083,'Randolph','FALSE','America/New_York','26293','en',1,'Y');
   i(36.11998,-75.72994,'Kitty Hawk','NC','North Carolina','TRUE',6844,37055,'Dare','FALSE','America/New_York','27949','en',1,'Y');
   i(39.69494,-76.42452,'Pylesville','MD','Maryland','TRUE',3656,24025,'Harford','FALSE','America/New_York','21132','en',1,'Y');
   i(44.94639,-122.99922,'Salem','OR','Oregon','TRUE',60266,41047,'Marion','FALSE','America/Los_Angeles','97301','en',1,'Y');
   i(47.01077,-117.35509,'Steptoe','WA','Washington','TRUE',52,53075,'Whitman','FALSE','America/Los_Angeles','99174','en',1,'Y');
   i(55.11971,-131.5753,'Metlakatla','AK','Alaska','TRUE',1513,2198,'Prince of Wales-Hyder','FALSE','America/Metlakatla','99926','en',1,'Y');
   i(47.24807,-122.47099,'Tacoma','WA','Washington','TRUE',25082,53053,'Pierce','FALSE','America/Los_Angeles','98405','en',1,'Y');
   i(43.61297,-111.71404,'Ririe','ID','Idaho','TRUE',1043,16051,'Jefferson','FALSE','America/Boise','83443','en',1,'Y');
   i(39.15034,-119.74687,'Carson City','NV','Nevada','TRUE',25832,32510,'Carson City','FALSE','America/Los_Angeles','89701','en',1,'Y');
   i(38.43147,-105.83692,'Howard','CO','Colorado','TRUE',857,8043,'Fremont','FALSE','America/Denver','81233','en',1,'Y');
   i(46.3312,-120.0035,'Sunnyside','WA','Washington','TRUE',22756,53077,'Yakima','FALSE','America/Los_Angeles','98944','en',1,'Y');
   i(20.92354,-156.67018,'Lahaina','HI','Hawaii','TRUE',21905,15009,'Maui','FALSE','Pacific/Honolulu','96761','en',1,'Y');
   i(54.13062,-165.82248,'Akutan','AK','Alaska','TRUE',820,2013,'Aleutians East','FALSE','America/Nome','99553','en',1,'Y');
   i(47.00491,-122.87555,'Olympia','WA','Washington','TRUE',37669,53067,'Thurston','FALSE','America/Los_Angeles','98501','en',1,'Y');
   i(19.70129,-155.09556,'Hilo','HI','Hawaii','TRUE',49099,15001,'Hawaii','FALSE','Pacific/Honolulu','96720','en',1,'Y');
   i(44.60461,-123.27037,'Corvallis','OR','Oregon','TRUE',45453,41003,'Benton','FALSE','America/Los_Angeles','97330','en',1,'Y');
   i(20.88794,-156.50197,'Wailuku','HI','Hawaii','TRUE',35876,15009,'Maui','FALSE','Pacific/Honolulu','96793','en',1,'Y');
   i(37.53633,-77.06493,'New Kent','VA','Virginia','TRUE',4186,51127,'New Kent','FALSE','America/New_York','23124','en',1,'Y');
   i(36.27468,-75.89795,'Poplar Branch','NC','North Carolina','TRUE',713,37053,'Currituck','FALSE','America/New_York','27965','en',1,'Y');
   i(39.9525,-75.16475,'Philadelphia','PA','Pennsylvania','TRUE',4808,42101,'Philadelphia','FALSE','America/New_York','19102','en',1,'Y');
   i(35.32405,-80.73915,'Charlotte','NC','North Carolina','TRUE',46305,37119,'Mecklenburg','FALSE','America/New_York','28262','en',1,'Y');
   i(39.29546,-76.62264,'Baltimore','MD','Maryland','TRUE',18304,24510,'Baltimore','FALSE','America/New_York','21201','en',1,'Y');
   i(38.36951,-75.62425,'Salisbury','MD','Maryland','TRUE',27830,24045,'Wicomico','FALSE','America/New_York','21801','en',1,'Y');
   i(37.67742,-81.72643,'Coal Mountain','WV','West Virginia','TRUE',523,54109,'Wyoming','FALSE','America/New_York','24823','en',1,'Y');
   i(39.02235,-77.00964,'Silver Spring','MD','Maryland','TRUE',35674,24031,'Montgomery','FALSE','America/New_York','20901','en',1,'Y');
   i(39.5255,-87.09074,'Knightsville','IN','Indiana','TRUE',401,18021,'Clay','FALSE','America/Indiana/Indianapolis','47857','en',1,'Y');
   i(36.6547,-83.33926,'Rose Hill','VA','Virginia','TRUE',2503,51105,'Lee','FALSE','America/New_York','24281','en',1,'Y');
   i(36.0692,-79.76889,'Greensboro','NC','North Carolina','TRUE',24179,37081,'Guilford','FALSE','America/New_York','27401','en',1,'Y');
   i(36.86852,-76.55725,'Suffolk','VA','Virginia','TRUE',1332,51800,'Suffolk','FALSE','America/New_York','23432','en',1,'Y');
   i(42.22681,-84.32179,'Michigan Center','MI','Michigan','TRUE',2948,26075,'Jackson','FALSE','America/Detroit','49254','en',1,'Y');
   i(39.57288,-75.59498,'Delaware City','DE','Delaware','TRUE',1781,10003,'New Castle','FALSE','America/New_York','19706','en',1,'Y');
   i(39.71201,-75.73103,'Newark','DE','Delaware','TRUE',52462,10003,'New Castle','FALSE','America/New_York','19711','en',1,'Y');
   i(38.78572,-77.51835,'Manassas','VA','Virginia','TRUE',39912,51153,'Prince William','FALSE','America/New_York','20109','en',1,'Y');
   i(34.32538,-78.51554,'Lake Waccamaw','NC','North Carolina','TRUE',2716,37047,'Columbus','FALSE','America/New_York','28450','en',1,'Y');
   i(37.54032,-77.4349,'Richmond','VA','Virginia','TRUE',4598,51760,'Richmond','FALSE','America/New_York','23219','en',1,'Y');
   i(38.88783,-77.09576,'Arlington','VA','Virginia','TRUE',40664,51013,'Arlington','FALSE','America/New_York','22201','en',1,'Y');
   i(42.35796,-92.79271,'Grundy Center','IA','Iowa','TRUE',3436,19075,'Grundy','FALSE','America/Chicago','50638','en',1,'Y');
   i(39.45583,-75.66027,'Odessa','DE','Delaware','TRUE',1154,10003,'New Castle','FALSE','America/New_York','19730','en',1,'Y');
   i(39.73477,-75.55113,'Wilmington','DE','Delaware','TRUE',16344,10003,'New Castle','FALSE','America/New_York','19801','en',1,'Y');
   i(39.08932,-77.18673,'Rockville','MD','Maryland','TRUE',49313,24031,'Montgomery','FALSE','America/New_York','20850','en',1,'Y');
   i(38.35139,-81.62981,'Charleston','WV','West Virginia','TRUE',2773,54039,'Kanawha','FALSE','America/New_York','25301','en',1,'Y');
   i(39.28525,-77.78184,'Harpers Ferry','WV','West Virginia','TRUE',14067,54037,'Jefferson','FALSE','America/New_York','25425','en',1,'Y');
   i(41.44175,-75.66078,'Scranton','PA','Pennsylvania','TRUE',12110,42069,'Lackawanna','FALSE','America/New_York','18508','en',1,'Y');
   i(38.37348,-80.59719,'Camden On Gauley','WV','West Virginia','TRUE',935,54101,'Webster','FALSE','America/New_York','26208','en',1,'Y');
   i(35.69526,-80.46306,'Salisbury','NC','North Carolina','TRUE',22824,37159,'Rowan','FALSE','America/New_York','28144','en',1,'Y');
   i(42.96615,-92.87316,'Marble Rock','IA','Iowa','TRUE',596,19067,'Floyd','FALSE','America/Chicago','50653','en',1,'Y');
   i(36.86516,-76.00545,'Virginia Beach','VA','Virginia','TRUE',43177,51810,'Virginia Beach','FALSE','America/New_York','23451','en',1,'Y');
   i(39.10137,-76.61624,'Millersville','MD','Maryland','TRUE',18991,24003,'Anne Arundel','FALSE','America/New_York','21108','en',1,'Y');
   i(47.28314,-88.38778,'Copper City','MI','Michigan','TRUE',234,26061,'Houghton','FALSE','America/Detroit','49917','en',1,'Y');
   i(38.77508,-87.31229,'Bicknell','IN','Indiana','TRUE',3883,18083,'Knox','FALSE','America/Indiana/Vincennes','47512','en',1,'Y');
   i(38.83036,-84.08549,'Felicity','OH','Ohio','TRUE',2685,39025,'Clermont','FALSE','America/New_York','45120','en',1,'Y');
   i(36.51585,-83.23891,'Sneedville','TN','Tennessee','TRUE',4804,47067,'Hancock','FALSE','America/New_York','37869','en',1,'Y');
   i(42.1616,-93.29176,'Zearing','IA','Iowa','TRUE',832,19169,'Story','FALSE','America/Chicago','50278','en',1,'Y');
   i(43.192,-88.06335,'Menomonee Falls','WI','Wisconsin','TRUE',39509,55133,'Waukesha','FALSE','America/Chicago','53051','en',1,'Y');
   i(42.62777,-95.64471,'Quimby','IA','Iowa','TRUE',452,19035,'Cherokee','FALSE','America/Chicago','51049','en',1,'Y');
   i(35.96374,-83.92006,'Knoxville','TN','Tennessee','TRUE',2512,47093,'Knox','FALSE','America/New_York','37902','en',1,'Y');
   i(42.50635,-96.43602,'Sioux City','IA','Iowa','TRUE',16847,19193,'Woodbury','FALSE','America/Chicago','51103','en',1,'Y');
   i(40.98675,-83.25745,'Mc Cutchenville','OH','Ohio','TRUE',479,39175,'Wyandot','FALSE','America/New_York','44844','en',1,'Y');
   i(43.72668,-87.73426,'Sheboygan','WI','Wisconsin','TRUE',43297,55117,'Sheboygan','FALSE','America/Chicago','53081','en',1,'Y');
   i(42.46988,-92.36668,'Waterloo','IA','Iowa','TRUE',33719,19013,'Black Hawk','FALSE','America/Chicago','50701','en',1,'Y');
   i(40.56744,-86.34768,'Young America','IN','Indiana','TRUE',174,18017,'Cass','FALSE','America/Indiana/Indianapolis','46998','en',1,'Y');
   i(41.23735,-95.87668,'Council Bluffs','IA','Iowa','TRUE',34702,19155,'Pottawattamie','FALSE','America/Chicago','51501','en',1,'Y');
   i(42.63998,-84.99465,'Vermontville','MI','Michigan','TRUE',3596,26045,'Eaton','FALSE','America/Detroit','49096','en',1,'Y');
   i(43.04771,-88.00304,'Milwaukee','WI','Wisconsin','TRUE',26859,55079,'Milwaukee','FALSE','America/Chicago','53213','en',1,'Y');
   i(40.14889,-85.37674,'Muncie','IN','Indiana','TRUE',26444,18035,'Delaware','FALSE','America/Indiana/Indianapolis','47302','en',1,'Y');
   i(36.14126,-83.31055,'Morristown','TN','Tennessee','TRUE',16777,47063,'Hamblen','FALSE','America/New_York','37813','en',1,'Y');
   i(42.293,-85.52457,'Kalamazoo','MI','Michigan','TRUE',26935,26077,'Kalamazoo','FALSE','America/Detroit','49048','en',1,'Y');
   i(39.50603,-87.46482,'Saint Mary Of The Woods','IN','Indiana','TRUE',367,18167,'Vigo','FALSE','America/Indiana/Indianapolis','47876','en',1,'Y');
   i(39.7721,-86.1547,'Indianapolis','IN','Indiana','TRUE',8315,18097,'Marion','FALSE','America/Indiana/Indianapolis','46204','en',1,'Y');
   i(43.07842,-89.37947,'Madison','WI','Wisconsin','TRUE',32612,55025,'Dane','FALSE','America/Chicago','53703','en',1,'Y');
   i(42.2493,-84.38515,'Jackson','MI','Michigan','TRUE',44568,26075,'Jackson','FALSE','America/Detroit','49201','en',1,'Y');
   i(41.97577,-91.66303,'Cedar Rapids','IA','Iowa','TRUE',1961,19113,'Linn','FALSE','America/Chicago','52401','en',1,'Y');
   i(33.44614,-88.80891,'Starkville','MS','Mississippi','TRUE',41567,28105,'Oktibbeha','FALSE','America/Chicago','39759','en',1,'Y');
   i(42.96929,-90.85467,'Mount Hope','WI','Wisconsin','TRUE',841,55043,'Grant','FALSE','America/Chicago','53816','en',1,'Y');
   i(39.10803,-84.50746,'Cincinnati','OH','Ohio','TRUE',12884,39061,'Hamilton','FALSE','America/New_York','45202','en',1,'Y');
   i(39.4011,-84.48823,'Hamilton','OH','Ohio','TRUE',70866,39017,'Butler','FALSE','America/New_York','45011','en',1,'Y');
   i(41.65228,-83.54255,'Toledo','OH','Ohio','TRUE',8522,39095,'Lucas','FALSE','America/New_York','43604','en',1,'Y');
   i(42.76767,-84.56461,'Lansing','MI','Michigan','TRUE',25077,26065,'Ingham','FALSE','America/Detroit','48906','en',1,'Y');
   i(37.17441,-84.66328,'Science Hill','KY','Kentucky','TRUE',5679,21199,'Pulaski','FALSE','America/New_York','42553','en',1,'Y');
   i(35.04656,-85.31378,'Chattanooga','TN','Tennessee','TRUE',4279,47065,'Hamilton','FALSE','America/New_York','37402','en',1,'Y');
   i(37.70397,-97.36486,'Wichita','KS','Kansas','TRUE',30088,20173,'Sedgwick','FALSE','America/Chicago','67203','en',1,'Y');
   i(33.88225,-117.53601,'Corona','CA','California','TRUE',44892,6065,'Riverside','FALSE','America/Los_Angeles','92879','en',1,'Y');
   i(34.7426,-92.2741,'Little Rock','AR','Arkansas','TRUE',10466,5119,'Pulaski','FALSE','America/Chicago','72202','en',1,'Y');
   i(41.69266,-70.61089,'Pocasset','MA','Massachusetts','TRUE',3820,25001,'Barnstable','FALSE','America/New_York','02559','en',1,'Y');
   i(45.50852,-122.68965,'Portland','OR','Oregon','TRUE',16579,41051,'Multnomah','FALSE','America/Los_Angeles','97201','en',1,'Y');
   i(47.53103,-121.84306,'Snoqualmie','WA','Washington','TRUE',15472,53033,'King','FALSE','America/Los_Angeles','98065','en',1,'Y');
   i(47.61191,-122.33385,'Seattle','WA','Washington','TRUE',13369,53033,'King','FALSE','America/Los_Angeles','98101','en',1,'Y');
   i(34.14756,-118.14003,'Pasadena','CA','California','TRUE',20202,6037,'Los Angeles','FALSE','America/Los_Angeles','91101','en',1,'Y');
   i(32.72082,-117.16318,'San Diego','CA','California','TRUE',39538,6073,'San Diego','FALSE','America/Los_Angeles','92101','en',1,'Y');
   i(55.48016,-133.12653,'Craig','AK','Alaska','TRUE',1966,2198,'Prince of Wales-Hyder','FALSE','America/Sitka','99921','en',1,'Y');
   i(37.76959,-122.44354,'San Francisco','CA','California','TRUE',40219,6075,'San Francisco','FALSE','America/Los_Angeles','94117','en',1,'Y');
   i(45.64143,-122.68272,'Vancouver','WA','Washington','TRUE',13567,53011,'Clark','FALSE','America/Los_Angeles','98660','en',1,'Y');
   i(45.49435,-122.80485,'Beaverton','OR','Oregon','TRUE',25498,41067,'Washington','FALSE','America/Los_Angeles','97005','en',1,'Y');
   i(34.25814,-116.85478,'Big Bear City','CA','California','TRUE',10268,6071,'San Bernardino','FALSE','America/Los_Angeles','92314','en',1,'Y');
   i(42.05824,-87.70079,'Evanston','IL','Illinois','TRUE',38620,17031,'Cook','FALSE','America/Chicago','60201','en',1,'Y');
   i(44.39986,-103.49277,'Sturgis','SD','South Dakota','TRUE',9483,46093,'Meade','FALSE','America/Denver','57785','en',1,'Y');
   i(37.75505,-90.78746,'Caledonia','MO','Missouri','TRUE',1309,29221,'Washington','FALSE','America/Chicago','63631','en',1,'Y');
   i(46.04699,-99.32385,'Ashley','ND','North Dakota','TRUE',890,38051,'McIntosh','FALSE','America/Chicago','58413','en',1,'Y');
   i(37.24406,-88.92845,'Joppa','IL','Illinois','TRUE',287,17127,'Massac','FALSE','America/Chicago','62953','en',1,'Y');
   i(39.66701,-95.41019,'Everest','KS','Kansas','TRUE',441,20013,'Brown','FALSE','America/Chicago','66424','en',1,'Y');
   i(39.05585,-95.67458,'Topeka','KS','Kansas','TRUE',1297,20177,'Shawnee','FALSE','America/Chicago','66603','en',1,'Y');
   i(41.26534,-96.29859,'Waterloo','NE','Nebraska','TRUE',2876,31055,'Douglas','FALSE','America/Chicago','68069','en',1,'Y');
   i(44.92957,-93.08413,'Saint Paul','MN','Minnesota','TRUE',16024,27123,'Ramsey','FALSE','America/Chicago','55107','en',1,'Y');
   i(44.41239,-95.25235,'Wabasso','MN','Minnesota','TRUE',1275,27127,'Redwood','FALSE','America/Chicago','56293','en',1,'Y');
   i(45.54943,-100.27767,'Glenham','SD','South Dakota','TRUE',415,46129,'Walworth','FALSE','America/Chicago','57631','en',1,'Y');
   i(44.08725,-103.21091,'Rapid City','SD','South Dakota','TRUE',42746,46103,'Pennington','FALSE','America/Denver','57701','en',1,'Y');
   i(36.39457,-94.59378,'Maysville','AR','Arkansas','TRUE',343,5007,'Benton','FALSE','America/Chicago','72747','en',1,'Y');
   i(39.07494,-108.54461,'Grand Junction','CO','Colorado','TRUE',23061,8077,'Mesa','FALSE','America/Denver','81501','en',1,'Y');
   i(36.47921,-93.39682,'Oak Grove','AR','Arkansas','TRUE',514,5015,'Carroll','FALSE','America/Chicago','72660','en',1,'Y');
   i(40.20318,-110.81297,'Fruitland','UT','Utah','TRUE',446,49013,'Duchesne','FALSE','America/Denver','84027','en',1,'Y');
   i(42.27665,-121.89959,'Klamath Falls','OR','Oregon','TRUE',23543,41035,'Klamath','FALSE','America/Los_Angeles','97601','en',1,'Y');
   i(34.65681,-93.0545,'Hot Springs Village','AR','Arkansas','TRUE',15981,5051,'Garland','FALSE','America/Chicago','71909','en',1,'Y');
   i(36.05148,-95.80855,'Broken Arrow','OK','Oklahoma','TRUE',65268,40143,'Tulsa','FALSE','America/Chicago','74012','en',1,'Y');
   i(45.63974,-118.67429,'Pendleton','OR','Oregon','TRUE',19053,41059,'Umatilla','FALSE','America/Los_Angeles','97801','en',1,'Y');
   i(47.61824,-122.20536,'Bellevue','WA','Washington','TRUE',33839,53033,'King','FALSE','America/Los_Angeles','98004','en',1,'Y');
   i(32.40831,-96.8179,'Waxahachie','TX','Texas','TRUE',45537,48139,'Ellis','FALSE','America/Chicago','75165','en',1,'Y');
   i(41.67639,-108.76349,'Point Of Rocks','WY','Wyoming','TRUE',147,56037,'Sweetwater','FALSE','America/Denver','82942','en',1,'Y');
   i(33.448,-112.07784,'Phoenix','AZ','Arizona','TRUE',8444,4013,'Maricopa','FALSE','America/Phoenix','85003','en',1,'Y');
   i(31.58083,-94.56955,'Nacogdoches','TX','Texas','TRUE',15013,48347,'Nacogdoches','FALSE','America/Chicago','75961','en',1,'Y');
   i(26.88908,-99.25314,'Zapata','TX','Texas','TRUE',13017,48505,'Zapata','FALSE','America/Chicago','78076','en',1,'Y');
   i(32.78677,-96.79932,'Dallas','TX','Texas','TRUE',17029,48113,'Dallas','FALSE','America/Chicago','75201','en',1,'Y');
   i(41.59976,-113.86591,'Grouse Creek','UT','Utah','TRUE',84,49003,'Box Elder','FALSE','America/Denver','84313','en',1,'Y');
   i(30.8801495,-92.4123227,'Turkey Creek','LA','Louisiana','TRUE',284,22039,'Evangeline','FALSE','America/Chicago','70585','en',1,'Y');
   i(34.06547,-118.30875,'Los Angeles','CA','California','TRUE',38397,6037,'Los Angeles','FALSE','America/Los_Angeles','90020','en',1,'Y');
   i(18.031515,-66.661735,'Ponce','PR','Puerto Rico','TRUE',41401,72113,'Ponce','FALSE','America/Puerto_Rico','00728','en',1,'Y');
   i(42.37793,-71.12985,'Cambridge','MA','Massachusetts','TRUE',42431,25017,'Middlesex','FALSE','America/New_York','02138','en',1,'Y');
   i(42.44632,-71.22374,'Lexington','MA','Massachusetts','TRUE',15255,25017,'Middlesex','FALSE','America/New_York','02420','en',1,'Y');
   i(44.43859,-73.07342,'Williston','VT','Vermont','TRUE',10139,50007,'Chittenden','FALSE','America/New_York','05495','en',1,'Y');
   i(40.78837,-74.06259,'Secaucus','NJ','New Jersey','TRUE',21284,34017,'Hudson','FALSE','America/New_York','07094','en',1,'Y');
   i(40.21987,-74.76512,'Trenton','NJ','New Jersey','TRUE',914,34021,'Mercer','FALSE','America/New_York','08608','en',1,'Y');
   i(40.751,-73.99571,'New York','NY','New York','TRUE',22933,36061,'New York','FALSE','America/New_York','10001','en',1,'Y');
   i(44.65081,-73.74342,'Saranac','NY','New York','TRUE',2136,36019,'Clinton','FALSE','America/New_York','12981','en',1,'Y');
   i(40.47299,-79.95468,'Pittsburgh','PA','Pennsylvania','TRUE',11929,42003,'Allegheny','FALSE','America/New_York','15201','en',1,'Y');
   i(42.12281,-80.0872,'Erie','PA','Pennsylvania','TRUE',1815,42049,'Erie','FALSE','America/New_York','16501','en',1,'Y');
   i(26.46508,-81.7719,'Fort Myers','FL','Florida','TRUE',1790,12071,'Lee','FALSE','America/New_York','33965','en',1,'Y');
   i(33.87886,-84.3353,'Atlanta','GA','Georgia','TRUE',45916,13089,'DeKalb','FALSE','America/New_York','30319','en',1,'Y');
   i(33.98171,-83.36203,'Athens','GA','Georgia','TRUE',22851,13059,'Clarke','FALSE','America/New_York','30601','en',1,'Y');
   i(32.07006,-81.09354,'Savannah','GA','Georgia','TRUE',18855,13051,'Chatham','FALSE','America/New_York','31401','en',1,'Y');
   i(32.82252,-80.06377,'Charleston','SC','South Carolina','TRUE',39481,45019,'Charleston','FALSE','America/New_York','29414','en',1,'Y');
   i(36.25105,-81.82613,'Sugar Grove','NC','North Carolina','TRUE',1827,37189,'Watauga','FALSE','America/New_York','28679','en',1,'Y');
   i(38.02064,-81.88542,'Turtle Creek','WV','West Virginia','TRUE',59,54005,'Boone','FALSE','America/New_York','25203','en',1,'Y');
   i(39.87679,-75.32127,'Ridley Park','PA','Pennsylvania','TRUE',10800,42045,'Delaware','FALSE','America/New_York','19078','en',1,'Y');
   i(39.01002,-77.39534,'Sterling','VA','Virginia','TRUE',43207,51107,'Loudoun','FALSE','America/New_York','20164','en',1,'Y');
   i(38.92526,-77.02971,'Naval Anacost Annex','DC','District of Columbia','TRUE',149,11001,'District of Columbia','FALSE','America/New_York','20373','en',1,'Y');
   i(44.43036,-100.32212,'Pierre','SD','South Dakota','TRUE',16828,46065,'Hughes','FALSE','America/Chicago','57501','en',1,'Y');
   i(45.40734,-122.68378,'Lake Oswego','OR','Oregon','TRUE',17624,41005,'Clackamas','FALSE','America/Los_Angeles','97034','en',1,'Y');
   i(20.00436,-155.2741,'Ookala','HI','Hawaii','TRUE',178,15001,'Hawaii','FALSE','Pacific/Honolulu','96774','en',1,'Y');
   i(47.19709,-122.32714,'Puyallup','WA','Washington','TRUE',21354,53053,'Pierce','FALSE','America/Los_Angeles','98371','en',1,'Y');
   i(43.27732,-89.35701,'Morrisonville','WI','Wisconsin','TRUE',156,55025,'Dane','FALSE','America/Chicago','53571','en',1,'Y');
   i(42.97367,-95.86135,'Granville','IA','Iowa','TRUE',651,19167,'Sioux','FALSE','America/Chicago','51022','en',1,'Y');
   i(37.56789,-85.72755,'Hodgenville','KY','Kentucky','TRUE',8478,21123,'Larue','FALSE','America/New_York','42748','en',1,'Y');
   i(42.96131,-85.65977,'Grand Rapids','MI','Michigan','TRUE',35302,26081,'Kent','FALSE','America/Detroit','49503','en',1,'Y');
   i(42.03105,-83.94602,'Tecumseh','MI','Michigan','TRUE',15546,26091,'Lenawee','FALSE','America/Detroit','49286','en',1,'Y');
   i(38.30749,-86.69527,'Birdseye','IN','Indiana','TRUE',2416,18037,'Dubois','FALSE','America/Indiana/Vincennes','47513','en',1,'Y');
   i(40.76345,-82.51377,'Mansfield','OH','Ohio','TRUE',2488,39139,'Richland','FALSE','America/New_York','44901','en',1,'Y');
   i(41.67414,-86.25262,'South Bend','IN','Indiana','TRUE',6332,18141,'St. Joseph','FALSE','America/Indiana/Indianapolis','46601','en',1,'Y');
   i(42.32503,-83.06057,'Detroit','MI','Michigan','TRUE',0,26163,'Wayne','FALSE','America/Detroit','48233','en',1,'Y');
   i(39.59417,-83.58811,'Milledgeville','OH','Ohio','TRUE',103,39047,'Fayette','FALSE','America/New_York','43142','en',1,'Y');
   i(41.58515,-93.62135,'Des Moines','IA','Iowa','TRUE',7594,19153,'Polk','FALSE','America/Chicago','50309','en',1,'Y');
   i(34.48397,-89.49878,'Abbeville','MS','Mississippi','TRUE',2315,28071,'Lafayette','FALSE','America/Chicago','38601','en',1,'Y');
   i(35.29857,-111.7233,'Flagstaff','AZ','Arizona','TRUE',50327,4005,'Coconino','FALSE','America/Phoenix','86001','en',1,'Y');
   i(33.05738,-96.73624,'Plano','TX','Texas','TRUE',53932,48085,'Collin','FALSE','America/Chicago','75023','en',1,'Y');
   i(21.91358,-159.58813,'Hanapepe','HI','Hawaii','TRUE',2938,15007,'Kauai','FALSE','Pacific/Honolulu','96716','en',1,'Y');
   i(21.31128,-157.85078,'Honolulu','HI','Hawaii','TRUE',23152,15003,'Honolulu','FALSE','Pacific/Honolulu','96813','en',1,'Y');
   i(38.57249,-121.46737,'Sacramento','CA','California','TRUE',16882,6067,'Sacramento','FALSE','America/Los_Angeles','95816','en',1,'Y');
   i(33.53489,-112.17735,'Glendale','AZ','Arizona','TRUE',69432,4013,'Maricopa','FALSE','America/Phoenix','85301','en',1,'Y');
   i(46.23772,-116.46689,'Craigmont','ID','Idaho','TRUE',797,16061,'Lewis','FALSE','America/Los_Angeles','83523','en',1,'Y');
   i(61.15234,-149.95367,'Anchorage','AK','Alaska','TRUE',22653,2020,'Anchorage','FALSE','America/Anchorage','99502','en',1,'Y');
   i(58.35983,-134.54474,'Juneau','AK','Alaska','TRUE',27322,2110,'Juneau','FALSE','America/Juneau','99801','en',1,'Y');
   i(44.0135,-107.9763,'Worland','WY','Wyoming','TRUE',7732,56043,'Washakie','FALSE','America/Denver','82401','en',1,'Y');
   i(40.35049,-111.98664,'Eagle Mountain','UT','Utah','TRUE',30862,49049,'Utah','FALSE','America/Denver','84005','en',1,'Y');
   i(43.67794,-108.24862,'Thermopolis','WY','Wyoming','TRUE',4870,56017,'Hot Springs','FALSE','America/Denver','82443','en',1,'Y');
   i(43.72877,-111.1095,'Driggs','ID','Idaho','TRUE',3018,16081,'Teton','FALSE','America/Boise','83422','en',1,'Y');
   i(39.62988,-119.85366,'Reno','NV','Nevada','TRUE',38600,32031,'Washoe','FALSE','America/Los_Angeles','89506','en',1,'Y');
   i(43.88356,-111.65463,'Teton','ID','Idaho','TRUE',1056,16043,'Fremont','FALSE','America/Boise','83451','en',1,'Y');
   i(39.55178,-110.39567,'Sunnyside','UT','Utah','TRUE',245,49007,'Carbon','FALSE','America/Denver','84539','en',1,'Y');
   i(32.07006,-81.09354,'Savannah','GA','Georgia','TRUE',18855,13051,'Chatham','FALSE','America/New_York','31401','en',1,'Y');
   i(29.79367,-82.48876,'Alachua','FL','Florida','TRUE',13834,12001,'Alachua','FALSE','America/New_York','32615','en',1,'Y');
   i(34.01191,-86.74912,'Garden City','AL','Alabama','TRUE',245,1043,'Cullman','FALSE','America/Chicago','35070','en',1,'Y');
   i(33.37082,-80.97413,'Cope','SC','South Carolina','TRUE',1971,45075,'Orangeburg','FALSE','America/New_York','29038','en',1,'Y');
   i(36.86758,-82.96977,'Holmes Mill','KY','Kentucky','TRUE',271,21095,'Harlan','FALSE','America/New_York','40843','en',1,'Y');
   i(33.49826,-104.4863,'Roswell','NM','New Mexico','TRUE',25938,35005,'Chaves','FALSE','America/Denver','88201','en',1,'Y');
   i(41.68877,-117.51241,'Paradise Valley','NV','Nevada','TRUE',140,32013,'Humboldt','FALSE','America/Los_Angeles','89426','en',1,'Y');
   i(30.26833,-97.74064,'Austin','TX','Texas','TRUE',9053,48453,'Travis','FALSE','America/Chicago','78701','en',1,'Y');
   i(35.69495,-105.93427,'Santa Fe','NM','New Mexico','TRUE',15148,35049,'Santa Fe','FALSE','America/Denver','87501','en',1,'Y');
   i(35.99221,-106.0669,'Espanola','NM','New Mexico','TRUE',19654,35039,'Rio Arriba','FALSE','America/Denver','87532','en',1,'Y');
   i(32.64234,-93.01982,'Athens','LA','Louisiana','TRUE',1106,22027,'Claiborne','FALSE','America/Chicago','71003','en',1,'Y');
   i(33.87895,-118.23852,'Compton','CA','California','TRUE',50621,6037,'Los Angeles','FALSE','America/Los_Angeles','90220','en',1,'Y');
   i(31.759,-106.48183,'El Paso','TX','Texas','TRUE',9796,48141,'El Paso','FALSE','America/Denver','79901','en',1,'Y');
   i(42.11185,-117.75144,'Mc Dermitt','NV','Nevada','TRUE',524,32013,'Humboldt','FALSE','America/Los_Angeles','89421','en',1,'Y');
   i(32.74397,-105.48532,'Weed','NM','New Mexico','TRUE',0,35035,'Otero','FALSE','America/Denver','88354','en',1,'Y');
   i(29.38619,-99.1159,'Hondo','TX','Texas','TRUE',15236,48325,'Medina','FALSE','America/Chicago','78861','en',1,'Y');
   i(32.3405,-93.1789,'Jamestown','LA','Louisiana','TRUE',699,22013,'Bienville','FALSE','America/Chicago','71045','en',1,'Y');
   i(35.3668,-94.41314,'Fort Smith','AR','Arkansas','TRUE',20445,5131,'Sebastian','FALSE','America/Chicago','72901','en',1,'Y');
   i(33.84881,-118.14996,'Lakewood','CA','California','TRUE',32346,6037,'Los Angeles','FALSE','America/Los_Angeles','90712','en',1,'Y');
   i(32.38294,-106.49045,'White Sands Missile Range','NM','New Mexico','TRUE',1068,35013,'Dona Ana','FALSE','America/Denver','88002','en',1,'Y');
   i(39.54537,-119.7525,'Sparks','NV','Nevada','TRUE',38616,32031,'Washoe','FALSE','America/Los_Angeles','89431','en',1,'Y');
   i(30.22551,-93.20857,'Lake Charles','LA','Louisiana','TRUE',30627,22019,'Calcasieu','FALSE','America/Chicago','70601','en',1,'Y');
   i(38.59404,-106.60436,'Ohio City','CO','Colorado','TRUE',35,8051,'Gunnison','FALSE','America/Denver','81237','en',1,'Y');
   i(35.32249,-96.94241,'Shawnee','OK','Oklahoma','TRUE',21440,40125,'Pottawatomie','FALSE','America/Chicago','74801','en',1,'Y');
   i(38.2895,-104.57255,'Pueblo','CO','Colorado','TRUE',31483,8101,'Pueblo','FALSE','America/Denver','81001','en',1,'Y');
   i(41.25354,-110.9419,'Evanston','WY','Wyoming','TRUE',14687,56041,'Uinta','FALSE','America/Denver','82930','en',1,'Y');
   i(41.23287,-105.73676,'Laramie','WY','Wyoming','TRUE',19329,56001,'Albany','FALSE','America/Denver','82070','en',1,'Y');
   i(41.7726566718129,-110.535762037698,'Diamondville','WY','Wyoming','TRUE',717,56023,'Lincoln','FALSE','America/Denver','83116','en',1,'Y');
   i(42.21958,-111.2657,'Dingle','ID','Idaho','TRUE',0,16007,'Bear Lake','FALSE','America/Boise','83233','en',1,'Y');
   i(42.67236,-111.53353,'Soda Springs','ID','Idaho','TRUE',3869,16029,'Caribou','FALSE','America/Boise','83276','en',1,'Y');
   i(41.2615,-116.52515,'Tuscarora','NV','Nevada','TRUE',159,32007,'Elko','FALSE','America/Los_Angeles','89834','en',1,'Y');
   i(36.41231,-97.84254,'Enid','OK','Oklahoma','TRUE',21632,40047,'Garfield','FALSE','America/Chicago','73701','en',1,'Y');
   i(36.46828,-94.21478,'Bella Vista','AR','Arkansas','TRUE',11882,5007,'Benton','FALSE','America/Chicago','72714','en',1,'Y');
   i(36.1906,-94.20059,'Springdale','AR','Arkansas','TRUE',41075,5143,'Washington','FALSE','America/Chicago','72762','en',1,'Y');
   i(35.89888,-91.28864,'Saffell','AR','Arkansas','TRUE',112,5075,'Lawrence','FALSE','America/Chicago','72572','en',1,'Y');
   i(32.5064,-93.74992,'Shreveport','LA','Louisiana','TRUE',7190,22017,'Caddo','FALSE','America/Chicago','71101','en',1,'Y');
   i(42.67082,-119.02293,'Frenchglen','OR','Oregon','TRUE',101,41025,'Harney','FALSE','America/Los_Angeles','97736','en',1,'Y');
   i(30.00565,-90.06499,'New Orleans','LA','Louisiana','TRUE',37378,22071,'Orleans','FALSE','America/Chicago','70122','en',1,'Y');
   i(42.45784,-103.2961,'Marsland','NE','Nebraska','TRUE',125,31045,'Dawes','FALSE','America/Denver','69354','en',1,'Y');
   i(36.66307,-97.80852,'Pond Creek','OK','Oklahoma','TRUE',1403,40053,'Grant','FALSE','America/Chicago','73766','en',1,'Y');
   i(36.73043,-95.92521,'Bartlesville','OK','Oklahoma','TRUE',27260,40147,'Washington','FALSE','America/Chicago','74006','en',1,'Y');
   i(36.11011,-95.81342,'Tulsa','OK','Oklahoma','TRUE',15813,40143,'Tulsa','FALSE','America/Chicago','74134','en',1,'Y');
   i(61.51343,-160.36019,'Lower Kalskag','AK','Alaska','TRUE',292,2050,'Bethel','FALSE','America/Anchorage','99626','en',1,'Y');
   i(57.13009,-170.26673,'Saint Paul Island','AK','Alaska','TRUE',454,2016,'Aleutians West','FALSE','America/Nome','99660','en',1,'Y');
   i(35.47084,-97.5189,'Oklahoma City','OK','Oklahoma','TRUE',5341,40109,'Oklahoma','FALSE','America/Chicago','73102','en',1,'Y');
   i(45.78991,-119.21283,'Stanfield','OR','Oregon','TRUE',2956,41059,'Umatilla','FALSE','America/Los_Angeles','97875','en',1,'Y');
   i(63.87696,-160.79156,'Unalakleet','AK','Alaska','TRUE',732,2180,'Nome','FALSE','America/Anchorage','99684','en',1,'Y');
   i(43.65291,-117.07521,'Adrian','OR','Oregon','TRUE',658,41045,'Malheur','FALSE','America/Boise','97901','en',1,'Y');
   i(36.38143,-96.02457,'Skiatook','OK','Oklahoma','TRUE',15172,40113,'Osage','FALSE','America/Chicago','74070','en',1,'Y');
   i(36.0941,-97.08171,'Stillwater','OK','Oklahoma','TRUE',30446,40119,'Payne','FALSE','America/Chicago','74074','en',1,'Y');
   i(64.8148354,-147.8817514,'Fairbanks','AK','Alaska','TRUE',4,2240,'Southeast Fairbanks','FALSE','America/Anchorage','99706','en',1,'Y');
   i(64.56028,-165.10975,'Nome','AK','Alaska','TRUE',4413,2180,'Nome','FALSE','America/Nome','99762','en',1,'Y');
   commit;
  end;
  /
  declare
    procedure i (
      p_scientific_name           in varchar2,
      p_genus                     in varchar2,
      p_species                   in varchar2,
      p_variety                   in varchar2,
      p_genera_binomial_author    in varchar2,
      p_common_name               in varchar2,
      p_category                  in varchar2,
      p_family                    in varchar2,
      p_family_common_name        in varchar2,
      p_taxonomy_order            in varchar2,
      p_subclass                  in varchar2,
      p_class                     in varchar2,
      p_division                  in varchar2,
      p_kingdom                   in varchar2,
      p_growth_habit              in varchar2,
      p_lang                      in varchar2,
      p_version_number            in number,
      p_seeded_data_yn            in varchar2
    )
    is
    begin
      insert into wwv_dg_builtin_plants (scientific_name,genus,species,variety,genera_binomial_author,common_name,category,family,family_common_name,taxonomy_order,subclass,class,division,kingdom,growth_habit,lang,version_number,seeded_data_yn)
      values (p_scientific_name, p_genus, p_species, p_variety, p_genera_binomial_author, p_common_name, p_category, p_family, p_family_common_name, p_taxonomy_order, p_subclass, p_class, p_division, p_kingdom, p_growth_habit, p_lang, p_version_number, p_seeded_data_yn);
    end i;
  begin
   i('Arctostaphylos manzanita ssp. elegans','Arctostaphylos','manzanita',null,'Parry','Konocti manzanita','Dicot','Ericaceae','Heath family','Ericales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Arctostaphylos manzanita ssp. roofii','Arctostaphylos','manzanita',null,'Parry','Roof''s manzanita','Dicot','Ericaceae','Heath family','Ericales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Asperugo procumbens','Asperugo','procumbens',null,'L.','German-madwort','Dicot','Boraginaceae','Borage family','Lamiales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Asperula','Asperula',null,null,'L.','Woodruff','Dicot','Rubiaceae','Madder family','Rubiales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Asperula arvensis','Asperula','arvensis',null,'L.','Blue woodruff','Dicot','Rubiaceae','Madder family','Rubiales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Asperula orientalis','Asperula','orientalis',null,'Boiss. & Hohen.','Oriental asperula','Dicot','Rubiaceae','Madder family','Rubiales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Asphodelus','Asphodelus',null,null,'L.','Asphodelus','Monocot','Liliaceae','Lily family','Liliales','Liliidae','Liliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Asphodelus albus','Asphodelus','albus',null,'Mill.','Gamon-blanco','Monocot','Liliaceae','Lily family','Liliales','Liliidae','Liliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Asphodelus fistulosus','Asphodelus','fistulosus',null,'L.','Onionweed','Monocot','Liliaceae','Lily family','Liliales','Liliidae','Liliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Aspicarpa','Aspicarpa',null,null,'Rich.','Asphead','Dicot','Malpighiaceae','Barbados Cherry family','Polygalales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Aspicarpa hirtella','Aspicarpa','hirtella',null,'Rich.','Chaparral asphead','Dicot','Malpighiaceae','Barbados Cherry family','Polygalales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub, Shrub','en',1,'Y');
   i('Chorisia','Chorisia',null,null,'Kunth','Silk-floss tree','Dicot','Bombacaceae','Kapok-tree family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Chorisia insignis','Chorisia','insignis',null,'Kunth','White silk floss tree','Dicot','Bombacaceae','Kapok-tree family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Tree','en',1,'Y');
   i('Chorisia speciosa','Chorisia','speciosa',null,'A. St.-Hil.','Silk-floss tree','Dicot','Bombacaceae','Kapok-tree family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Tree','en',1,'Y');
   i('Chorisiva','Chorisiva',null,null,'Rydb.','Sumpweed','Dicot','Asteraceae','Aster family','Asterales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Chorisiva nevadensis','Chorisiva','nevadensis',null,'(M.E. Jones) Rydb.','Nevada sumpweed','Dicot','Asteraceae','Aster family','Asterales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Chorispora','Chorispora',null,null,'R. Br. ex DC.','Chorispora','Dicot','Brassicaceae','Mustard family','Capparales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Chorispora tenella','Chorispora','tenella',null,'(Pall.) DC.','Crossflower','Dicot','Brassicaceae','Mustard family','Capparales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Cladonia mateocyatha','Cladonia','mateocyatha',null,'Robbins','Cup lichen','Lichen','Cladoniaceae',null,'Lecanorales',null,'Ascomycetes','Ascomycota','Fungi','Lichenous','en',1,'Y');
   i('Cladonia maxima','Cladonia','maxima',null,'(Asah.) Ahti','Cup lichen','Lichen','Cladoniaceae',null,'Lecanorales',null,'Ascomycetes','Ascomycota','Fungi','Lichenous','en',1,'Y');
   i('Dicliptera brachiata','Dicliptera','brachiata',null,'(Pursh) Spreng.','Branched foldwing','Dicot','Acanthaceae','Acanthus family','Scrophulariales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Dicliptera chinensis','Dicliptera','chinensis',null,'(L.) Juss.','Chinese foldwing','Dicot','Acanthaceae','Acanthus family','Scrophulariales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Dicliptera krugii','Dicliptera','krugii',null,'Urb.','Krug''s foldwing','Dicot','Acanthaceae','Acanthus family','Scrophulariales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Dicliptera martinicensis','Dicliptera','martinicensis',null,'(Jacq.) Juss.','Martinique foldwing','Dicot','Acanthaceae','Acanthus family','Scrophulariales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Dicliptera resupinata','Dicliptera','resupinata',null,'(Vahl) Juss.','Arizona foldwing','Dicot','Acanthaceae','Acanthus family','Scrophulariales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Dicliptera sexangularis','Dicliptera','sexangularis',null,'(L.) Juss.','Sixangle foldwing','Dicot','Acanthaceae','Acanthus family','Scrophulariales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb, Subshrub','en',1,'Y');
   i('Dicoria','Dicoria',null,null,'Torr. ex A. Gray','Twinbugs','Dicot','Asteraceae','Aster family','Asterales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Dicoria canescens','Dicoria','canescens',null,'A. Gray','Desert twinbugs','Dicot','Asteraceae','Aster family','Asterales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Douglasia beringensis','Douglasia','beringensis',null,'S. Kelso','Bering dwarf-primrose','Dicot','Primulaceae','Primrose family','Primulales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Douglasia conservatorum','Douglasia','conservatorum',null,'Bjork','Bloom Peak dwarf-primrose','Dicot','Primulaceae','Primrose family','Primulales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub','en',1,'Y');
   i('Douglasia gormanii','Douglasia','gormanii',null,'Constance','Gorman''s dwarf-primrose','Dicot','Primulaceae','Primrose family','Primulales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub, Forb/herb','en',1,'Y');
   i('Douglasia idahoensis','Douglasia','idahoensis',null,'Douglass M. Hend.','Idaho dwarf-primrose','Dicot','Primulaceae','Primrose family','Primulales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub, Forb/herb','en',1,'Y');
   i('Elaeagnus pungens','Elaeagnus','pungens',null,'Thunb.','Thorny olive','Dicot','Elaeagnaceae','Oleaster family','Rhamnales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Elaeagnus umbellata','Elaeagnus','umbellata',null,'Thunb.','Autumn olive','Dicot','Elaeagnaceae','Oleaster family','Rhamnales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Elaeagnus umbellata var. parvifolia','Elaeagnus','umbellata','parvifolia','Thunb.','Autumn olive','Dicot','Elaeagnaceae','Oleaster family','Rhamnales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Elaeis','Elaeis',null,null,'Jacq.','Oil palm','Monocot','Arecaceae','Palm family','Arecales','Arecidae','Liliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Elaeis guineensis','Elaeis','guineensis',null,'Jacq.','African oil palm','Monocot','Arecaceae','Palm family','Arecales','Arecidae','Liliopsida','Magnoliophyta','Plantae','Tree','en',1,'Y');
   i('Elaeis oleifera','Elaeis','oleifera',null,'(Kunth) Cortes','American oil palm','Monocot','Arecaceae','Palm family','Arecales','Arecidae','Liliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Diplazium expansum','Diplazium','expansum',null,'Willd.','Great fern','Fern','Dryopteridaceae','Wood Fern family','Polypodiales',null,'Filicopsida','Pteridophyta','Plantae','Forb/herb','en',1,'Y');
   i('Diplazium grandifolium','Diplazium','grandifolium',null,'(Sw.) Sw.','Largeleaf twinsorus fern','Fern','Dryopteridaceae','Wood Fern family','Polypodiales',null,'Filicopsida','Pteridophyta','Plantae','Forb/herb','en',1,'Y');
   i('Diplazium hymenodes','Diplazium','hymenodes',null,'(Mett.) A. Love & D. Love','Peacock fern','Fern','Dryopteridaceae','Wood Fern family','Polypodiales',null,'Filicopsida','Pteridophyta','Plantae','Forb/herb','en',1,'Y');
   i('Erythronium grandiflorum ssp. grandiflorum','Erythronium','grandiflorum',null,'Pursh','Yellow avalanche-lily','Monocot','Liliaceae','Lily family','Liliales','Liliidae','Liliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Erythronium helenae','Erythronium','helenae',null,'Applegate','Pacific fawnlily','Monocot','Liliaceae','Lily family','Liliales','Liliidae','Liliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Erythronium hendersonii','Erythronium','hendersonii',null,'S. Watson','Henderson''s fawnlily','Monocot','Liliaceae','Lily family','Liliales','Liliidae','Liliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Hedyotis flynnii','Hedyotis','flynnii',null,'W.L. Wagner & D.H. Lorence','Cliff-dwelling starviolet','Dicot','Rubiaceae','Madder family','Rubiales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Hedyotis foggiana','Hedyotis','foggiana',null,'Fosberg','Kauai starviolet','Dicot','Rubiaceae','Madder family','Rubiales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Vine, Subshrub, Shrub','en',1,'Y');
   i('Hedyotis foliosa','Hedyotis','foliosa',null,'(Hillebr.) Fosberg','Haleakala starviolet','Dicot','Rubiaceae','Madder family','Rubiales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Purshia subintegra','Purshia','subintegra',null,'(Kearney) Henrickson','Arizona cliffrose','Dicot','Rosaceae','Rose family','Rosales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Purshia ericifolia','Purshia','ericifolia',null,'(Torr. ex A. Gray) Henrickson','Heath cliffrose','Dicot','Rosaceae','Rose family','Rosales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Purshia glandulosa','Purshia','glandulosa',null,'Curran','Desert bitterbrush','Dicot','Rosaceae','Rose family','Rosales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Quercus wislizeni var. frutescens','Quercus','wislizeni','frutescens','A. DC.','Interior live oak','Dicot','Fagaceae','Beech family','Fagales','Hamamelididae','Magnoliopsida','Magnoliophyta','Plantae','Shrub, Tree','en',1,'Y');
   i('Quercus wislizeni var. wislizeni','Quercus','wislizeni','wislizeni','A. DC.','Interior live oak','Dicot','Fagaceae','Beech family','Fagales','Hamamelididae','Magnoliopsida','Magnoliophyta','Plantae','Tree, Shrub','en',1,'Y');
   i('Quillaja','Quillaja',null,null,'Molina','Quillaja','Dicot','Rosaceae','Rose family','Rosales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Quillaja saponaria','Quillaja','saponaria',null,'Molina','Soapbark','Dicot','Rosaceae','Rose family','Rosales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Zea perennis','Zea','perennis',null,'(Hitchc.) Reeves & Manglesdorf','Perennial teosinte','Monocot','Poaceae','Grass family','Cyperales','Commelinidae','Liliopsida','Magnoliophyta','Plantae','Graminoid','en',1,'Y');
   i('Zebrina','Zebrina',null,null,'Schnizl.','Zebrina','Monocot','Commelinaceae','Spiderwort family','Commelinales','Commelinidae','Liliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Zelkova','Zelkova',null,null,'Spach','Zelkova','Dicot','Ulmaceae','Elm family','Urticales','Hamamelididae','Magnoliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Elaeagnus multiflora','Elaeagnus','multiflora',null,'Thunb.','Cherry silverberry','Dicot','Elaeagnaceae','Oleaster family','Rhamnales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Diplazium esculentum','Diplazium','esculentum',null,'(Retz.) Sw.','Vegetable fern','Fern','Dryopteridaceae','Wood Fern family','Polypodiales',null,'Filicopsida','Pteridophyta','Plantae','Forb/herb','en',1,'Y');
   i('Adenophyllum porophylloides','Adenophyllum','porophylloides',null,'(A. Gray) Strother','San Felipe dogweed','Dicot','Asteraceae','Aster family','Asterales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub','en',1,'Y');
   i('Arctostaphylos klamathensis','Arctostaphylos','klamathensis',null,'S.W. Edwards, Keeler-Wolf & W. Knight','Klamath manzanita','Dicot','Ericaceae','Heath family','Ericales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub, Shrub','en',1,'Y');
   i('Abutilon berlandieri','Abutilon','berlandieri',null,'A. Gray ex S. Watson','Berlandier''s Indian mallow','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Abutilon eremitopetalum','Abutilon','eremitopetalum',null,'Caum','Hiddenpetal Indian mallow','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Abutilon fruticosum','Abutilon','fruticosum',null,'Guill. & Perr.','Texas Indian mallow','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub','en',1,'Y');
   i('Abutilon grandifolium','Abutilon','grandifolium',null,'(Willd.) Sweet','Hairy Indian mallow','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Abutilon hirtum','Abutilon','hirtum',null,'(Lam.) Sweet','Florida Keys Indian mallow','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub, Forb/herb','en',1,'Y');
   i('Abutilon hulseanum','Abutilon','hulseanum',null,'(Torr. & A. Gray) Torr. ex A. Gray','Mauve','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub, Forb/herb','en',1,'Y');
   i('Abutilon hypoleucum','Abutilon','hypoleucum',null,'A. Gray','Whiteleaf Indian mallow','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub, Subshrub','en',1,'Y');
   i('Abutilon permolle','Abutilon','permolle',null,'(Willd.) Sweet','Coastal Indian mallow','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub, Forb/herb','en',1,'Y');
   i('Abutilon reventum','Abutilon','reventum',null,'S. Watson','Yellowflower Indian mallow','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub, Forb/herb','en',1,'Y');
   i('Abutilon sandwicense','Abutilon','sandwicense',null,'(O. Deg.) Christoph.','Greenflower Indian mallow','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Abutilon theophrasti','Abutilon','theophrasti',null,'Medik.','Velvetleaf','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Abutilon thurberi','Abutilon','thurberi',null,'A. Gray','Thurber''s Indian mallow','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub, Forb/herb','en',1,'Y');
   i('Abutilon trisulcatum','Abutilon','trisulcatum',null,'(Jacq.) Urb.','Anglestem Indian mallow','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub, Subshrub','en',1,'Y');
   i('Abutilon wrightii','Abutilon','wrightii',null,'A. Gray','Wright''s Indian mallow','Dicot','Malvaceae','Mallow family','Malvales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub, Forb/herb','en',1,'Y');
   i('Acacia','Acacia',null,null,'Mill.','Acacia','Dicot','Fabaceae','Pea family','Fabales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Acacia ligulata','Acacia','ligulata',null,'Benth.','Acacia','Dicot','Fabaceae','Pea family','Fabales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Acacia longifolia','Acacia','longifolia',null,'(Andrews) Willd.','Sydney golden wattle','Dicot','Fabaceae','Pea family','Fabales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae','Tree, Shrub','en',1,'Y');
   i('Acacia macracantha','Acacia','macracantha',null,'Humb. & Bonpl. ex Willd.','Porknut','Dicot','Fabaceae','Pea family','Fabales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae','Tree','en',1,'Y');
   i('Acacia mearnsii','Acacia','mearnsii',null,'De Wild.','Black wattle','Dicot','Fabaceae','Pea family','Fabales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae','Tree, Shrub','en',1,'Y');
   i('Acacia melanoxylon','Acacia','melanoxylon',null,'R. Br.','Blackwood','Dicot','Fabaceae','Pea family','Fabales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae','Tree','en',1,'Y');
   i('Acacia microcarpa','Acacia','microcarpa',null,'F. Muell.','Manna wattle','Dicot','Fabaceae','Pea family','Fabales','Rosidae','Magnoliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Acarospora applanata','Acarospora','applanata',null,'H. Magn.','Cracked lichen','Lichen','Acarosporaceae',null,'Lecanorales',null,'Ascomycetes','Ascomycota','Fungi','Lichenous','en',1,'Y');
   i('Acarospora arenacea','Acarospora','arenacea',null,'H. Magn.','Cracked lichen','Lichen','Acarosporaceae',null,'Lecanorales',null,'Ascomycetes','Ascomycota','Fungi','Lichenous','en',1,'Y');
   i('Acarospora arenosa','Acarospora','arenosa',null,'Herre','Cracked lichen','Lichen','Acarosporaceae',null,'Lecanorales',null,'Ascomycetes','Ascomycota','Fungi','Lichenous','en',1,'Y');
   i('Acarospora asahinae','Acarospora','asahinae',null,'H. Magn.','Asahina''s cracked lichen','Lichen','Acarosporaceae',null,'Lecanorales',null,'Ascomycetes','Ascomycota','Fungi','Lichenous','en',1,'Y');
   i('Acarospora asperata','Acarospora','asperata',null,'H. Magn.','Cracked lichen','Lichen','Acarosporaceae',null,'Lecanorales',null,'Ascomycetes','Ascomycota','Fungi','Lichenous','en',1,'Y');
   i('Acarospora badiofusca','Acarospora','badiofusca',null,'(Nyl.) Th. Fr.','Cracked lichen','Lichen','Acarosporaceae',null,'Lecanorales',null,'Ascomycetes','Ascomycota','Fungi','Lichenous','en',1,'Y');
   i('Acarospora bullata','Acarospora','bullata',null,'Anzi','Cracked lichen','Lichen','Acarosporaceae',null,'Lecanorales',null,'Ascomycetes','Ascomycota','Fungi','Lichenous','en',1,'Y');
   i('Acarospora caesiofusca','Acarospora','caesiofusca',null,'(Mull. Arg.) H. Magn.','Cracked lichen','Lichen','Acarosporaceae',null,'Lecanorales',null,'Ascomycetes','Ascomycota','Fungi','Lichenous','en',1,'Y');
   i('Adenophyllum cooperi','Adenophyllum','cooperi',null,'(A. Gray) Strother','Cooper''s dogweed','Dicot','Asteraceae','Aster family','Asterales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub','en',1,'Y');
   i('Adenophyllum porophyllum','Adenophyllum','porophyllum',null,'(Cav.) Hemsl.','Poreleaf dogweed','Dicot','Asteraceae','Aster family','Asterales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Subshrub','en',1,'Y');
   i('Adenophyllum wrightii','Adenophyllum','wrightii',null,'A. Gray','Wright''s dogweed','Dicot','Asteraceae','Aster family','Asterales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Adenosma javanica','Adenosma','javanica',null,'(Blume) Koord.','Java adenosma',null,'Scrophulariaceae',null,'Scrophulariales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Adenostemma','Adenostemma',null,null,'J.R. Forst. & G. Forst.','Medicineplant','Dicot','Asteraceae','Aster family','Asterales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae',null,'en',1,'Y');
   i('Adenostemma lavenia','Adenostemma','lavenia',null,'(L.) Kuntze','Common medicineplant','Dicot','Asteraceae','Aster family','Asterales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Adenostemma verbesina','Adenostemma','verbesina',null,'(L.) Sch. Bip.','Tropical medicineplant','Dicot','Asteraceae','Aster family','Asterales','Asteridae','Magnoliopsida','Magnoliophyta','Plantae','Forb/herb','en',1,'Y');
   i('Arctostaphylos insularis','Arctostaphylos','insularis',null,'Greene ex Parry','Island manzanita','Dicot','Ericaceae','Heath family','Ericales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Arctostaphylos luciana','Arctostaphylos','luciana',null,'P.V. Wells','Santa Lucia manzanita','Dicot','Ericaceae','Heath family','Ericales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Arctostaphylos malloryi','Arctostaphylos','malloryi',null,'(W. Knight & Gankin) P.V. Wells','Mallory''s manzanita','Dicot','Ericaceae','Heath family','Ericales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   i('Arctostaphylos manzanita','Arctostaphylos','manzanita',null,'Parry','Whiteleaf manzanita','Dicot','Ericaceae','Heath family','Ericales','Dilleniidae','Magnoliopsida','Magnoliophyta','Plantae','Shrub','en',1,'Y');
   commit;
  end;
  /
  declare
    procedure i (
      p_site_number         in varchar2,
      p_airport_type        in varchar2,
      p_iata_code           in varchar2,
      p_state_name          in varchar2,
      p_county              in varchar2,
      p_city                in varchar2,
      p_facility_name       in varchar2,
      p_owner               in varchar2,
      p_owner_address       in varchar2,
      p_arp_latitude        in varchar2,
      p_arp_latitude_s      in varchar2,
      p_arp_longitude       in varchar2,
      p_arp_longitude_s     in varchar2,
      p_lang                in varchar2,
      p_version_number      in number,
      p_seeded_data_yn      in varchar2
    )
    is
    begin
      insert into wwv_dg_builtin_airports (site_number, airport_type, iata_code, state_name, county, city, facility_name, owner, owner_address, arp_latitude, arp_latitude_s, arp_longitude, arp_longitude_s, lang, version_number,seeded_data_yn)
      values (p_site_number, p_airport_type, p_iata_code, p_state_name, p_county, p_city, p_facility_name, p_owner, p_owner_address, p_arp_latitude, p_arp_latitude_s, p_arp_longitude, p_arp_longitude_s, p_lang, p_version_number, p_seeded_data_yn);
    end i;
  begin
   i('02154.*A','AIRPORT','SBD','CALIFORNIA','SAN BERNARDINO','SAN BERNARDINO','SAN BERNARDINO INTL','SAN BERNARDINO INTL AIRPORT AUTH','1601 E 3RD STREET','34-05-43.3000N','122743.3000N','117-14-05.6000W','422045.6000W','en',1,'Y');
   i('00455.*A','AIRPORT','MSL','ALABAMA','COLBERT','MUSCLE SHOALS','NORTHWEST ALABAMA RGNL','COLBERT & LAUDERDALE COUNTIES','1729 T. ED CAMPBELL DR SUITE A','34-44-43.1000N','125083.1000N','087-36-36.8000W','315396.8000W','en',1,'Y');
   i('06341.*A','AIRPORT','SUX','IOWA','WOODBURY','SIOUX CITY','SIOUX GATEWAY/BRIG GENERAL BUD DAY FLD','SIOUX GATEWAY AIRPORT AUTH.','2403 AVIATION BLVD.','42-24-04.7140N','152644.7140N','096-23-03.9050W','346983.9050W','en',1,'Y');
   i('50114.*A','AIRPORT','CDB','ALASKA','ALEUTIANS EAST','COLD BAY','COLD BAY','ALASKA DOT&PF SOUTHCOAST REGION','P.O BOX 112506','55-12-21.3000N','198741.3000N','162-43-34.5000W','585814.5000W','en',1,'Y');
   i('02314.*A','AIRPORT','SCK','CALIFORNIA','SAN JOAQUIN','STOCKTON','STOCKTON METRO','COUNTY OF SAN JOAQUIN','5000 S AIRPORT WAY','37-53-39.8770N','136419.8770N','121-14-19.4640W','436459.4640W','en',1,'Y');
   i('01291.*A','AIRPORT','BFL','CALIFORNIA','KERN','BAKERSFIELD','MEADOWS FLD','COUNTY OF KERN','DEPT OF ARPTS, 3701 WINGS WAY, #300, 3701 WINGS WAY, SUITE 300','35-26-01.9000N','127561.9000N','119-03-27.6000W','428607.6000W','en',1,'Y');
   i('50124.*A','AIRPORT','CDV','ALASKA','VALDEZ-CORDOVA','CORDOVA','MERLE K (MUDHOLE) SMITH','ALASKA DOT&PF NORTHERN REGION','2301 PEGER ROAD','60-29-30.4000N','217770.4000N','145-28-39.2000W','523719.2000W','en',1,'Y');
   i('10737.*A','AIRPORT','HIB','MINNESOTA','ST LOUIS','HIBBING','RANGE RGNL','CHISHOLM-HIBBING AIRPORT','11038 E. HWY 37','47-23-11.7000N','170591.7000N','092-50-20.3000W','334220.3000W','en',1,'Y');
   i('50801.*A','AIRPORT','DUT','ALASKA','ALEUTIANS WEST','UNALASKA','UNALASKA','ALASKA DOT&PF SOUTHCOAST REGION','PO BOX 112500','53-53-56.2000N','194036.2000N','166-32-42.1000W','599562.1000W','en',1,'Y');
   i('07411.*A','AIRPORT','AEX','LOUISIANA','RAPIDES','ALEXANDRIA','ALEXANDRIA INTL','ENGLAND AUTHORITY','1611 ARNOLD DR','31-19-38.5380N','112778.5380N','092-32-54.8020W','333174.8020W','en',1,'Y');
   i('09462.*A','AIRPORT','ORH','MASSACHUSETTS','WORCESTER','WORCESTER','WORCESTER RGNL','MASS PORT AUTHORITY','375 AIRPORT DR, 375 AIRPORT DRIVE','42-16-01.7000N','152161.7000N','071-52-32.2000W','258752.2000W','en',1,'Y');
   i('24947.*A','AIRPORT','TYR','TEXAS','SMITH','TYLER','TYLER POUNDS RGNL','CITY OF TYLER','PO BOX 2039','32-21-12.8000N','116472.8000N','095-24-10.7000W','343450.7000W','en',1,'Y');
   i('06650.1*A','AIRPORT','HYS','KANSAS','ELLIS','HAYS','HAYS RGNL','CITY OF HAYS','PO BOX 490','38-50-32.0000N','139832.0000N','099-16-23.4000W','357383.4000W','en',1,'Y');
   i('05257.*A','AIRPORT','EVV','INDIANA','VANDERBURGH','EVANSVILLE','EVANSVILLE RGNL','EVANSVLLE-VANDERBURG ARPT AUTH','7801 BUSSING DR','38-02-26.9000N','136946.9000N','087-31-42.6000W','315102.6000W','en',1,'Y');
   i('10010.*A','AIRPORT','LAN','MICHIGAN','CLINTON','LANSING','CAPITAL REGION INTL','CAPITAL REGION ARPT AUTHORITY','4100 CAPITAL CITY BLVD','42-46-43.1000N','154003.1000N','084-35-10.3000W','304510.3000W','en',1,'Y');
   i('00267.*A','AIRPORT','DHN','ALABAMA','DALE','DOTHAN','DOTHAN RGNL','DOTHAN-HOUSTON CO ARPT AUTH','800 ARPT DR SUITE 15','31-19-15.7000N','112755.7000N','085-26-58.1000W','307618.1000W','en',1,'Y');
   i('13048.*A','AIRPORT','EKO','NEVADA','ELKO','ELKO','ELKO RGNL','CITY OF ELKO','975 TERMINAL WAY','40-49-30.0000N','146970.0000N','115-47-28.8000W','416848.8000W','en',1,'Y');
   i('15957.01*A','AIRPORT','PBG','NEW YORK','CLINTON','PLATTSBURGH','PLATTSBURGH INTL','CLINTON COUNTY','137 MARGARET ST','44-39-03.4000N','160743.4000N','073-28-05.3000W','264485.3000W','en',1,'Y');
   i('02089.*A','AIRPORT','RDD','CALIFORNIA','SHASTA','REDDING','REDDING MUNI','CITY OF REDDING','AIRPORTS DIVISION, 6751 WOODRUM CIRCLE, #200','40-30-32.3000N','145832.3000N','122-17-36.2000W','440256.2000W','en',1,'Y');
   i('19905.*A','AIRPORT','BFD','PENNSYLVANIA','MC KEAN','BRADFORD','BRADFORD RGNL','BRADFORD REGIONAL ARPT AUTH','212 AIRPORT DR SUITE E','41-48-10.6356N','150490.6356N','078-38-23.8775W','283103.8775W','en',1,'Y');
   i('50425.*A','AIRPORT','ADQ','ALASKA','KODIAK ISLAND','KODIAK','KODIAK','ALASKA DOT&PF SOUTHCOAST REGION','P O BOX 112500','57-44-59.2580N','207899.2580N','152-29-38.1970W','548978.1970W','en',1,'Y');
   i('14737.*A','AIRPORT','SVC','NEW MEXICO','GRANT','SILVER CITY','GRANT COUNTY','GRANT COUNTY','P.O. BOX 6, 188 AIRPORT RD.','32-38-11.5690N','117491.5690N','108-09-22.9870W','389362.9870W','en',1,'Y');
   i('10064.02*A','AIRPORT','SAW','MICHIGAN','MARQUETTE','MARQUETTE','SAWYER INTL','MARQUETTE COUNTY','125 G AVENUE','46-20-56.9700N','166856.9700N','087-23-46.9380W','314626.9380W','en',1,'Y');
   i('02413.*A','AIRPORT','VIS','CALIFORNIA','TULARE','VISALIA','VISALIA MUNI','CITY OF VISALIA','CITY HALL, 707 WEST ACEQUIA','36-19-07.1000N','130747.1000N','119-23-34.3000W','429814.3000W','en',1,'Y');
   i('03683.*A','AIRPORT','BQK','GEORGIA','GLYNN','BRUNSWICK','BRUNSWICK GOLDEN ISLES','GLYNN COUNTY AIRPORT COMMISSION','295 AVIATION PARKWAY SUITE 205','31-15-32.5249N','112532.5249N','081-27-58.7370W','293278.7370W','en',1,'Y');
   i('12783.*A','AIRPORT','EAR','NEBRASKA','BUFFALO','KEARNEY','KEARNEY RGNL','CITY OF KEARNEY','P.O. BOX 1180','40-43-37.3460N','146617.3460N','099-00-24.3720W','356424.3720W','en',1,'Y');
   i('27754.*A','AIRPORT','CPR','WYOMING','NATRONA','CASPER','CASPER/NATRONA COUNTY INTL','COUNTY BOARD OF COMMISSIONERS','8500 AIRPORT PARKWAY, SUITE 208','42-54-21.1000N','154461.1000N','106-27-49.1000W','383269.1000W','en',1,'Y');
   i('11834.*A','AIRPORT','IRK','MISSOURI','ADAIR','KIRKSVILLE','KIRKSVILLE RGNL','CITY OF KIRKSVILLE','CITY HALL, 201 SOUTH FRANKLIN','40-05-36.5000N','144336.5000N','092-32-41.7000W','333161.7000W','en',1,'Y');
   i('24067.3*A','AIRPORT','EFD','TEXAS','HARRIS','HOUSTON','ELLINGTON','CITY OF HOUSTON','16930 JFK BLVD','29-36-26.4000N','106586.4000N','095-09-31.5000W','342571.5000W','en',1,'Y');
   i('17367.*A','AIRPORT','JMS','NORTH DAKOTA','STUTSMAN','JAMESTOWN','JAMESTOWN RGNL','JAMESTOWN RGNL ARPT AUTHORITY','PO BOX 1560','46-55-47.0000N','168947.0000N','098-40-41.5000W','355241.5000W','en',1,'Y');
   i('01002.*A','AIRPORT','HRO','ARKANSAS','BOONE','HARRISON','BOONE COUNTY','BOONE COUNTY','100 N MAIN SUITE 300','36-15-41.4740N','130541.4740N','093-09-17.0240W','335357.0240W','en',1,'Y');
   i('02635.7*A','AIRPORT','HDN','COLORADO','ROUTT','HAYDEN','YAMPA VALLEY','ROUTT COUNTY','PO BOX 773598','40-28-52.3000N','145732.3000N','107-13-03.6000W','385983.6000W','en',1,'Y');
   i('50426.6*A','AIRPORT','DUY','ALASKA','BETHEL','KONGIGANAK','KONGIGANAK','ALASKA DOT&PF CENTRAL REGION','PO BOX 196900','59-57-41.8710N','215861.8710N','162-52-50.1380W','586370.1380W','en',1,'Y');
   i('10653.*A','AIRPORT','DLH','MINNESOTA','ST LOUIS','DULUTH','DULUTH INTL','CITY OF DULUTH, MINN','4701 GRINDEN DR','46-50-31.4511N','168631.4511N','092-11-35.6540W','331895.6540W','en',1,'Y');
   i('26461.*A','AIRPORT','EAT','WASHINGTON','DOUGLAS','WENATCHEE','PANGBORN MEML','PORTS CHELAN&DOUGLAS CNTY','ONE PANGBORN DRIVE','47-23-55.7000N','170635.7000N','120-12-24.6000W','432744.6000W','en',1,'Y');
   i('00437.*A','AIRPORT','BFM','ALABAMA','MOBILE','MOBILE','MOBILE DOWNTOWN','MOBILE AIRPORT AUTHORITY','1891-9TH ST/BROOKLEY COMPLEX','30-37-36.4000N','110256.4000N','088-04-05.1000W','317045.1000W','en',1,'Y');
   i('26693.*A','AIRPORT','HTS','WEST VIRGINIA','WAYNE','HUNTINGTON','TRI-STATE/MILTON J FERGUSON FLD','TRI-STATE AIRPORT AUTH.','1449 AIRPORT ROAD','38-22-06.6281N','138126.6281N','082-33-37.2968W','297217.2968W','en',1,'Y');
   i('26480.*A','AIRPORT','YKM','WASHINGTON','YAKIMA','YAKIMA','YAKIMA AIR TRML/MCALLISTER FLD','CITY OF YAKIMA','2300 WEST WASHINGTON AVE','46-34-05.4000N','167645.4000N','120-32-38.6000W','433958.6000W','en',1,'Y');
   i('04413.*A','AIRPORT','BLV','ILLINOIS','ST CLAIR','BELLEVILLE','SCOTT AFB/MIDAMERICA','ST CLAIR COUNTY & USAF','10 PUBLIC SQUARE','38-32-42.6000N','138762.6000N','089-50-06.7000W','323406.7000W','en',1,'Y');
   i('50429.*A','AIRPORT','OTZ','ALASKA','NORTHWEST ARCTIC','KOTZEBUE','RALPH WIEN MEML','ALASKA DOT&PF NORTHERN REGION','2301 PEGER RD','66-53-05.3000N','240785.3000N','162-35-53.3000W','585353.3000W','en',1,'Y');
   i('00964.*A','AIRPORT','ELD','ARKANSAS','UNION','EL DORADO','SOUTH ARKANSAS RGNL AT GOODWIN FLD','CITY OF EL DORADO','PO BOX 2170','33-13-16.4561N','119596.4561N','092-48-42.2960W','334122.2960W','en',1,'Y');
   i('20724.*A','AIRPORT','LBE','PENNSYLVANIA','WESTMORELAND','LATROBE','ARNOLD PALMER RGNL','WESTMORELAND COUNTY ARPT AUTH','148 AVIATION LANE, SUITE 103','40-16-23.1618N','144983.1618N','079-24-37.1720W','285877.1720W','en',1,'Y');
   i('10218.*A','AIRPORT','PLN','MICHIGAN','EMMET','PELLSTON','PELLSTON RGNL/EMMET COUNTY','EMMET COUNTY','1395 N US HIGHWAY 31','45-34-15.3000N','164055.3000N','084-47-48.2000W','305268.2000W','en',1,'Y');
   i('02858.*A','AIRPORT','HVN','CONNECTICUT','NEW HAVEN','NEW HAVEN','TWEED-NEW HAVEN','CITY OF NEW HAVEN','155 BURR STREET','41-15-49.4980N','148549.4980N','072-53-12.4820W','262392.4820W','en',1,'Y');
   i('18577.*A','AIRPORT','TOL','OHIO','LUCAS','TOLEDO','EUGENE F KRANZ TOLEDO EXPRESS','TOLEDO LUCAS COUNTY PORT AUTHORITY','11013 AIRPORT HWY','41-35-12.5400N','149712.5400N','083-48-28.1760W','301708.1760W','en',1,'Y');
   i('05871.*A','AIRPORT','BRL','IOWA','DES MOINES','BURLINGTON','SOUTHEAST IOWA RGNL','SE IOWA REG ARPT AUTHORITY','2515 SUMMER STREET','40-46-58.7170N','146818.7170N','091-07-32.1110W','328052.1110W','en',1,'Y');
   i('13386.*A','AIRPORT','PSM','NEW HAMPSHIRE','ROCKINGHAM','PORTSMOUTH','PORTSMOUTH INTL AT PEASE','PEASE DEVELOPMENT AUTHORITY','55 INTERNATIONAL DRIVE','43-04-40.6000N','155080.6000N','070-49-23.8000W','254963.8000W','en',1,'Y');
   i('50703.*A','AIRPORT','SIT','ALASKA','SITKA','SITKA','SITKA ROCKY GUTIERREZ','ALASKA DOT&PF SOUTHCOAST REGION','6860 GLACIER HIGHWAY','57-02-48.6037N','205368.6037N','135-21-39.8473W','487299.8473W','en',1,'Y');
   i('04234.*A','AIRPORT','LWS','IDAHO','NEZ PERCE','LEWISTON','LEWISTON-NEZ PERCE COUNTY','CITY OF LEWISTON/NEZ PERCE COUNTY','LEWISTON-NEZ PERCE COUNTY AIRPORT, 406 BURRELL AVE., SUITE 301','46-22-28.1930N','166948.1930N','117-00-55.4250W','421255.4250W','en',1,'Y');
   i('09110.*A','AIRPORT','ACK','MASSACHUSETTS','NANTUCKET','NANTUCKET','NANTUCKET MEML','TOWN OF NANTUCKET','SELECTMAN''S OFFICE','41-15-10.7102N','148510.7102N','070-03-35.6811W','252215.6811W','en',1,'Y');
   i('09968.*A','AIRPORT','IWD','MICHIGAN','GOGEBIC','IRONWOOD','GOGEBIC-IRON COUNTY','GOGEBIC COUNTY','GOGEBIC CO COURTHOUSE, 200 N MOORE ST','46-31-38.9000N','167498.9000N','090-07-53.0000W','324473.0000W','en',1,'Y');
   i('16793.*A','AIRPORT','HKY','NORTH CAROLINA','CATAWBA','HICKORY','HICKORY RGNL','CITY OF HICKORY','PO BOX 398','35-44-28.1240N','128668.1240N','081-23-22.3820W','293002.3820W','en',1,'Y');
   i('50260.*A','AIRPORT','GAM','ALASKA','NOME','GAMBELL','GAMBELL','ALASKA DOT&PF NORTHERN REGION','2301 PEGER RD','63-45-59.8190N','229559.8190N','171-43-58.0220W','618238.0220W','en',1,'Y');
   i('53146.*A','AIRPORT','PSE','PUERTO RICO','--PUERTO RICO','PONCE','MERCEDITA','PUERTO RICO PORT AUTH','PO BOX 2829','18-00-31.6100N','064831.6100N','066-33-52.2750W','239632.2750W','en',1,'Y');
   i('14719.*A','AIRPORT','ROW','NEW MEXICO','CHAVES','ROSWELL','ROSWELL AIR CENTER','CITY OF ROSWELL','425 N RICHARDSON','33-17-59.5308N','119879.5308N','104-31-45.8315W','376305.8315W','en',1,'Y');
   i('07828.*A','AIRPORT','BHB','MAINE','HANCOCK','BAR HARBOR','HANCOCK COUNTY-BAR HARBOR','HANCOCK COUNTY','50 STATE ST, STE 7','44-26-58.9390N','160018.9390N','068-21-41.3630W','246101.3630W','en',1,'Y');
   i('52402.*A','AIRPORT','LNY','HAWAII','MAUI','LANAI CITY','LANAI','HAWAII ST ARPTS DIV','HONOLULU INTL ARPT','20-47-08.2000N','074828.2000N','156-57-05.1050W','565025.1050W','en',1,'Y');
   i('11810.*A','AIRPORT','JLN','MISSOURI','JASPER','JOPLIN','JOPLIN RGNL','CITY OF JOPLIN','602 S. MAIN STREET','37-09-11.4060N','133751.4060N','094-29-55.7080W','340195.7080W','en',1,'Y');
   i('22884.*A','AIRPORT','TRI','TENNESSEE','SULLIVAN','BRISTOL/JOHNSON/KINGSPORT','TRI-CITIES','BRISTOL JOHNSON KINGSPORT','2525 HWY 75, SUITE 301','36-28-30.7480N','131310.7480N','082-24-26.6950W','296666.6950W','en',1,'Y');
   i('11255.*A','AIRPORT','HBG','MISSISSIPPI','FORREST','HATTIESBURG','HATTIESBURG BOBBY L CHAIN MUNI','CITY OF HATTIESBURG','PO BOX 1898','31-15-53.8000N','112553.8000N','089-15-10.4000W','321310.4000W','en',1,'Y');
   i('10299.*A','AIRPORT','MBS','MICHIGAN','SAGINAW','SAGINAW','MBS INTL','MBS INTERNATIONAL','8500 GARFIELD RD STE 101','43-31-58.5370N','156718.5370N','084-04-46.6890W','302686.6890W','en',1,'Y');
   i('50540.*A','AIRPORT','OME','ALASKA','NOME','NOME','NOME','ALASKA DOT&PF NORTHERN REGION','2301 PEGER RD','64-30-45.2000N','232245.2000N','165-26-39.8000W','595599.8000W','en',1,'Y');
   i('00640.5*A','AIRPORT','IFP','ARIZONA','MOHAVE','BULLHEAD CITY','LAUGHLIN/BULLHEAD INTL','MOHAVE COUNTY','BOX 390','35-09-16.6120N','126556.6120N','114-33-33.5960W','412413.5960W','en',1,'Y');
   i('10546.*A','AIRPORT','BJI','MINNESOTA','BELTRAMI','BEMIDJI','BEMIDJI RGNL','CITY OF BEMIDJI / BELTRAMI CO','3824 MOBERG DRIVE, STE. 101','47-30-38.6000N','171038.6000N','094-56-05.0000W','341765.0000W','en',1,'Y');
   i('12808.*A','AIRPORT','MCK','NEBRASKA','RED WILLOW','MC COOK','MC COOK BEN NELSON RGNL','CITY OF MC COOK','BOX 1059','40-12-22.6000N','144742.6000N','100-35-31.5000W','362131.5000W','en',1,'Y');
   i('22603.*A','AIRPORT','ABR','SOUTH DAKOTA','BROWN','ABERDEEN','ABERDEEN RGNL','CITY OF ABERDEEN','123 S LINCOLN ST','45-26-48.4730N','163608.4730N','098-25-20.7870W','354320.7870W','en',1,'Y');
   i('50054.3*A','AIRPORT','BRW','ALASKA','NORTH SLOPE','BARROW','WILEY POST-WILL ROGERS MEML','ALASKA DOT&PF NORTHERN REGION','2301 PEGER RD','71-17-05.5000N','256625.5000N','156-46-06.9000W','564366.9000W','en',1,'Y');
   i('27524.*A','AIRPORT','RHI','WISCONSIN','ONEIDA','RHINELANDER','RHINELANDER-ONEIDA COUNTY','RHINELANDER & ONEIDA CO.','3375 AIRPORT ROAD','45-37-51.2390N','164271.2390N','089-27-59.8615W','322079.8615W','en',1,'Y');
   i('22762.*A','AIRPORT','PIR','SOUTH DAKOTA','HUGHES','PIERRE','PIERRE RGNL','CITY OF PIERRE','3800 AIRPORT ROAD, SUITE 209','44-22-57.7000N','159777.7000N','100-17-09.5000W','361029.5000W','en',1,'Y');
   i('12399.*A','AIRPORT','HVR','MONTANA','HILL','HAVRE','HAVRE CITY-COUNTY','CITY OF HAVRE & HILL CO','520 4 TH ST, PO BOX 231','48-32-34.7000N','174754.7000N','109-45-44.4000W','395144.4000W','en',1,'Y');
   i('17304.*A','AIRPORT','DIK','NORTH DAKOTA','STARK','DICKINSON','DICKINSON - THEODORE ROOSEVELT RGNL','DICKINSON ARPT AUTHORITY','11120 42ND ST SW','46-47-58.7470N','168478.7470N','102-48-09.6340W','370089.6340W','en',1,'Y');
   i('11255.1*A','AIRPORT','PIB','MISSISSIPPI','JONES','HATTIESBURG-LAUREL','HATTIESBURG-LAUREL RGNL','REGIONAL AIRPORT AUTH','1002 TERMINAL DRIVE','31-28-01.7000N','113281.7000N','089-20-13.4000W','321613.4000W','en',1,'Y');
   i('10329.*A','AIRPORT','CIU','MICHIGAN','CHIPPEWA','SAULT STE MARIE','CHIPPEWA COUNTY INTL','CHIPPEWA COUNTY ECON DEV CORP','5019 W AIRPORT DR','46-15-02.7040N','166502.7040N','084-28-20.5850W','304100.5850W','en',1,'Y');
   i('16367.*A','AIRPORT','ART','NEW YORK','JEFFERSON','WATERTOWN','WATERTOWN INTL','COUNTY OF JEFFERSON','195 ARSENAL ST.','43-59-30.6000N','158370.6000N','076-01-09.9000W','273669.9000W','en',1,'Y');
   i('09962.*A','AIRPORT','IMT','MICHIGAN','DICKINSON','IRON MOUNTAIN KINGSFORD','FORD','DICKINSON COUNTY','COUNTY COURT HOUSE','45-49-06.1000N','164946.1000N','088-06-52.4000W','317212.4000W','en',1,'Y');
   i('11605.*A','AIRPORT','CGI','MISSOURI','SCOTT','CAPE GIRARDEAU','CAPE GIRARDEAU RGNL','CITY OF CAPE GIRARDEAU','CITY HALL, 401 INDEPENDENCE','37-13-31.1000N','134011.1000N','089-34-14.7000W','322454.7000W','en',1,'Y');
   i('50590.2*A','AIRPORT','PSG','ALASKA','WRANGELL-PETERSBURG','PETERSBURG','PETERSBURG JAMES A JOHNSON','ALASKA DOT&PF SOUTHCOAST REGION','6860 GLACIER HWY','56-48-05.3000N','204485.3000N','132-56-46.4000W','478606.4000W','en',1,'Y');
   i('07312.*A','AIRPORT','PAH','KENTUCKY','MC CRACKEN','PADUCAH','BARKLEY RGNL','BARKLEY REGIONAL AIRPORT AUTHORITY','2901 FISHER RD, PO BOX 38','37-03-37.0380N','133417.0380N','088-46-22.6530W','319582.6530W','en',1,'Y');
   i('01695.*A','AIRPORT','IYK','CALIFORNIA','KERN','INYOKERN','INYOKERN','INDIAN WELLS VALLEY APT DIST','P.O. BOX 634','35-39-31.4686N','128371.4686N','117-49-46.3170W','424186.3170W','en',1,'Y');
   i('26713.*A','AIRPORT','LWB','WEST VIRGINIA','GREENBRIER','LEWISBURG','GREENBRIER VALLEY','GREENBRIER CO ARPT AUTH','584 AIRPORT RD BOX 1','37-51-29.9040N','136289.9040N','080-23-58.1370W','289438.1370W','en',1,'Y');
   i('15800.*A','AIRPORT','IAG','NEW YORK','NIAGARA','NIAGARA FALLS','NIAGARA FALLS INTL','NIAGARA FRONTIER T A','181 ELLICOTT ST, PO BOX 5008','43-06-27.2065N','155187.2065N','078-56-45.0480W','284205.0480W','en',1,'Y');
   i('14621.*A','AIRPORT','HOB','NEW MEXICO','LEA','HOBBS','LEA COUNTY RGNL','LEA COUNTY','COURTHOUSE BOX 5C','32-41-15.0000N','117675.0000N','103-13-02.4000W','371582.4000W','en',1,'Y');
   i('00716.*A','AIRPORT','IGM','ARIZONA','MOHAVE','KINGMAN','KINGMAN','CITY OF KINGMAN','7000 FLIGHTLINE DR','35-15-34.1210N','126934.1210N','113-56-16.9810W','410176.9810W','en',1,'Y');
   i('12597.*A','AIRPORT','AIA','NEBRASKA','BOX BUTTE','ALLIANCE','ALLIANCE MUNI','CITY OF ALLIANCE','PO BOX D','42-03-11.6000N','151391.6000N','102-48-13.5000W','370093.5000W','en',1,'Y');
   i('06878.*A','AIRPORT','SLN','KANSAS','SALINE','SALINA','SALINA RGNL','SALINA ARPT AUTH','3237 ARNOLD AVENUE','38-47-26.2000N','139646.2000N','097-39-08.0000W','351548.0000W','en',1,'Y');
   i('08221.*A','AIRPORT','PQI','MAINE','AROOSTOOK','PRESQUE ISLE','PRESQUE ISLE INTL','CITY OF PRESQUE ISLE','12 SECOND ST','46-41-20.2700N','168080.2700N','068-02-41.2490W','244961.2490W','en',1,'Y');
   i('50153.*A','AIRPORT','DLG','ALASKA','DILLINGHAM','DILLINGHAM','DILLINGHAM','ALASKA DOT&PF CENTRAL REGION','P O BOX 196900','59-02-40.8000N','212560.8000N','158-30-19.8000W','570619.8000W','en',1,'Y');
   i('12842.*A','AIRPORT','LBF','NEBRASKA','LINCOLN','NORTH PLATTE','NORTH PLATTE RGNL/LEE BIRD FLD','NORTH PLATTE AIRPORT AUTH','PO BOX 1517','41-07-34.4000N','148054.4000N','100-41-01.2000W','362461.2000W','en',1,'Y');
   i('25863.*A','AIRPORT','LYH','VIRGINIA','CAMPBELL','LYNCHBURG','LYNCHBURG RGNL/PRESTON GLENN FLD','CITY OF LYNCHBURG','350 TERMINAL DRIVE, SUITE 100','37-19-31.4000N','134371.4000N','079-12-04.4000W','285124.4000W','en',1,'Y');
   i('09788.*A','AIRPORT','ESC','MICHIGAN','DELTA','ESCANABA','DELTA COUNTY','DELTA COUNTY','310 LUDINGTON ST','45-43-21.6300N','164601.6300N','087-05-37.3800W','313537.3800W','en',1,'Y');
   i('10749.*A','AIRPORT','INL','MINNESOTA','KOOCHICHING','INTERNATIONAL FALLS','FALLS INTL-EINARSON FLD','CITY OF INTL FALLS','BOX 392','48-33-56.1000N','174836.1000N','093-24-07.8000W','336247.8000W','en',1,'Y');
   i('12674.*A','AIRPORT','CDR','NEBRASKA','DAWES','CHADRON','CHADRON MUNI','CITY OF CHADRON','P.O. BOX 390','42-50-15.2077N','154215.2077N','103-05-43.4469W','371143.4469W','en',1,'Y');
   i('55030.*A','AIRPORT','STX','VIRGIN ISLANDS','-VIRGIN ISLANDS-','CHRISTIANSTED','HENRY E ROHLSEN','VI PORT AUTHORITY','8074 LINDBERGH BAY, P.O. BOX 301707','17-42-05.4160N','063725.4160N','064-48-06.9945W','233286.9945W','en',1,'Y');
   i('17302.*A','AIRPORT','DVL','NORTH DAKOTA','RAMSEY','DEVILS LAKE','DEVILS LAKE RGNL','DEVILS LAKE AIRPORT AUTHORITY','106 NATIONAL GUARD ST NW','48-06-59.7000N','173219.7000N','098-54-36.0000W','356076.0000W','en',1,'Y');
   i('06729.*A','AIRPORT','LBL','KANSAS','SEWARD','LIBERAL','LIBERAL MID-AMERICA RGNL','CITY OF LIBERAL','PO BOX 2199','37-02-38.1000N','133358.1000N','100-57-35.9000W','363455.9000W','en',1,'Y');
   i('01683.*A','AIRPORT','IPL','CALIFORNIA','IMPERIAL','IMPERIAL','IMPERIAL COUNTY','IMPERIAL COUNTY','1099 AIRPORT ROAD','32-50-03.2000N','118203.2000N','115-34-43.5000W','416083.5000W','en',1,'Y');
   i('07658.*A','AIRPORT','MLU','LOUISIANA','OUACHITA','MONROE','MONROE RGNL','CITY OF MONROE','PO BOX 123','32-30-39.1000N','117039.1000N','092-02-15.6000W','331335.6000W','en',1,'Y');
   i('50488.5*A','AIRPORT','MYU','ALASKA','BETHEL','MEKORYUK','MEKORYUK','ALASKA DOT&PF CENTRAL REGION','PO BOX 196900','60-22-20.6000N','217340.6000N','166-16-12.7000W','598572.7000W','en',1,'Y');
   i('02013.*A','AIRPORT','PMD','CALIFORNIA','LOS ANGELES','PALMDALE','PALMDALE USAF PLANT 42','USAF','2503 E AVE P','34-37-45.8000N','124665.8000N','118-05-04.3900W','425104.3900W','en',1,'Y');
   i('16875.13*A','AIRPORT','00NC','NORTH CAROLINA','FRANKLIN','LOUISBURG','NORTH RALEIGH','NORTH RALEIGH AIRPORT LLC','6966 NC 56 HWY','36-05-06.5410N','129906.5410N','078-22-16.9880W','282136.9880W','en',1,'Y');
   i('17418.*A','AIRPORT','MOT','NORTH DAKOTA','WARD','MINOT','MINOT INTL','CITY OF MINOT','305 AIRPORT RD., SUITE 216','48-15-27.5000N','173727.5000N','101-16-40.9000W','364600.9000W','en',1,'Y');
   i('00674.*A','AIRPORT','FLG','ARIZONA','COCONINO','FLAGSTAFF','FLAGSTAFF PULLIAM','CITY OF FLAGSTAFF','211 W ASPEN AVE','35-08-25.1370N','126505.1370N','111-40-09.2690W','402009.2690W','en',1,'Y');
   i('04209.*A','AIRPORT','IDA','IDAHO','BONNEVILLE','IDAHO FALLS','IDAHO FALLS RGNL','CITY OF IDAHO FALLS','PO BOX 50220','43-30-49.4000N','156649.4000N','112-04-14.7000W','403454.7000W','en',1,'Y');
   i('04288.*A','AIRPORT','PIH','IDAHO','POWER','POCATELLO','POCATELLO RGNL','CITY OF POCATELLO','P.O. BOX 4169','42-54-35.2530N','154475.2530N','112-35-45.3080W','405345.3080W','en',1,'Y');
   i('09518.*A','AIRPORT','APN','MICHIGAN','ALPENA','ALPENA','ALPENA COUNTY RGNL','COUNTY OF ALPENA','1617 AIRPORT RD','45-04-41.1000N','162281.1000N','083-33-37.1000W','300817.1000W','en',1,'Y');
   i('11651.1*A','AIRPORT','COU','MISSOURI','BOONE','COLUMBIA','COLUMBIA RGNL','CITY OF COLUMBIA','P O BOX 6015','38-49-02.4000N','139742.4000N','092-13-04.9000W','331984.9000W','en',1,'Y');
   i('23745.*A','AIRPORT','DRT','TEXAS','VAL VERDE','DEL RIO','DEL RIO INTL','DEL RIO/VAL VERDE CTY','109 W BROADWAY STREET','29-22-27.1450N','105747.1450N','100-55-37.7650W','363337.7650W','en',1,'Y');
   i('01857.*A','AIRPORT','MMH','CALIFORNIA','MONO','MAMMOTH LAKES','MAMMOTH YOSEMITE','TOWN OF MAMMOTH LAKES','1300 AIRPORT ROAD','37-37-26.6000N','135446.6000N','118-50-19.5000W','427819.5000W','en',1,'Y');
   i('00447.*A','AIRPORT','MGM','ALABAMA','MONTGOMERY','MONTGOMERY','MONTGOMERY RGNL (DANNELLY FLD)','MONTGOMERY AIRPORT AUTHORITY','4445 SELMA HWY','32-18-02.3000N','116282.3000N','086-23-38.3000W','311018.3000W','en',1,'Y');
   i('50410.*A','AIRPORT','ENA','ALASKA','KENAI-COOK INLET','KENAI','KENAI MUNI','CITY OF KENAI','210 FIDALGO ST','60-34-23.8000N','218063.8000N','151-14-41.4000W','544481.4000W','en',1,'Y');
   i('10049.*A','AIRPORT','MBL','MICHIGAN','MANISTEE','MANISTEE','MANISTEE COUNTY-BLACKER','MANISTEE BLACKER ARPT AUTHORITY','2323 AIRPORT RD','44-16-20.9000N','159380.9000N','086-14-48.8000W','310488.8000W','en',1,'Y');
   i('09362.*A','AIRPORT','MVY','MASSACHUSETTS','DUKES','VINEYARD HAVEN','MARTHA''S VINEYARD','COUNTY OF DUKES COUNTY','71 AIRPORT ROAD, 71 AIRPORT RAOD','41-23-36.3030N','149016.3030N','070-36-49.9480W','254209.9480W','en',1,'Y');
   i('50281.*A','AIRPORT','GKN','ALASKA','VALDEZ-CORDOVA','GULKANA','GULKANA','ALASKA DOT&PF NORTHERN REGION',', 2301 PEGER RD','62-09-15.6050N','223755.6050N','145-27-19.0500W','523639.0500W','en',1,'Y');
   i('27304.*A','AIRPORT','LSE','WISCONSIN','LA CROSSE','LA CROSSE','LA CROSSE RGNL','CITY OF LA CROSSE','2850 AIRPORT ROAD','43-52-45.4000N','157965.4000N','091-15-23.9000W','328523.9000W','en',1,'Y');
   i('26450.*A','AIRPORT','ALW','WASHINGTON','WALLA WALLA','WALLA WALLA','WALLA WALLA RGNL','PORT OF WALLA WALLA','310 A STREET','46-05-33.1500N','165933.1500N','118-17-02.6970W','425822.6970W','en',1,'Y');
   i('06748.*A','AIRPORT','MHK','KANSAS','RILEY','MANHATTAN','MANHATTAN RGNL','CITY OF MANHATTAN','1101 POYNTZ','39-08-28.4000N','140908.4000N','096-40-18.5000W','348018.5000W','en',1,'Y');
   i('17349.1*A','AIRPORT','GFK','NORTH DAKOTA','GRAND FORKS','GRAND FORKS','GRAND FORKS INTL','GRAND FORKS REG ARPT AUTH','2301 AIRPORT DRIVE','47-56-50.2000N','172610.2000N','097-10-25.6000W','349825.6000W','en',1,'Y');
   i('12286.*A','AIRPORT','BTM','MONTANA','SILVER BOW','BUTTE','BERT MOONEY','BERT MOONEY, ARPT AUTH','101 AIRPORT ROAD','45-57-17.3000N','165437.3000N','112-29-50.9000W','404990.9000W','en',1,'Y');
   i('25333.*A','AIRPORT','ENV','UTAH','TOOELE','WENDOVER','WENDOVER','TOOELE COUNTY','P.O. BOX 159','40-43-07.4110N','146587.4110N','114-01-43.2250W','410503.2250W','en',1,'Y');
   i('50140.72*A','AIRPORT','AK15','ALASKA','NORTH SLOPE','NUIQSUT','ALPINE AIRSTRIP','CONOCOPHILLIPS ALASKA, INC','700 G ST.','70-20-39.4000N','253239.4000N','150-56-41.1000W','543401.1000W','en',1,'Y');
   i('03250.3*A','AIRPORT','VQQ','FLORIDA','DUVAL','JACKSONVILLE','CECIL','JACKSONVILLE AVIATION AUTHORITY','14201 PECAN PARK ROAD','30-13-07.6000N','108787.6000N','081-52-37.8000W','294757.8000W','en',1,'Y');
   i('50920.*A','AIRPORT','YAK','ALASKA','YAKUTAT','YAKUTAT','YAKUTAT','ALASKA DOT&PF SOUTHCOAST REGION','6860 GLACIER HWY','59-30-11.9640N','214211.9640N','139-39-36.9650W','502776.9650W','en',1,'Y');
   i('50905.2*A','AIRPORT','WRG','ALASKA','WRANGELL-PETERSBURG','WRANGELL','WRANGELL','ALASKA DOT&PF SOUTHCOAST REGION','6860 GLACIER HWY','56-29-03.6000N','203343.6000N','132-22-11.4000W','476531.4000W','en',1,'Y');
   i('00987.*A','AIRPORT','FSM','ARKANSAS','SEBASTIAN','FORT SMITH','FORT SMITH RGNL','FORT SMITH ARPT COMMISSION','6700 MCKENNON BLVD SUITE 200','35-20-11.7000N','127211.7000N','094-22-02.8000W','339722.8000W','en',1,'Y');
   i('26582.*A','AIRPORT','CKB','WEST VIRGINIA','HARRISON','CLARKSBURG','NORTH CENTRAL WEST VIRGINIA','BENEDUM AIRPORT AUTHORITY','2000 AVIATION WAY','39-17-51.5570N','141471.5570N','080-13-39.1150W','288819.1150W','en',1,'Y');
   i('11195.*A','AIRPORT','CBM','MISSISSIPPI','LOWNDES','COLUMBUS','COLUMBUS AFB','USAF','HQ 14TH FTW ATC,COLUMBUS AFB','33-38-42.6300N','121122.6300N','088-26-45.3100W','318405.3100W','en',1,'Y');
   i('22822.*A','AIRPORT','ATY','SOUTH DAKOTA','CODINGTON','WATERTOWN','WATERTOWN RGNL','CITY OF WATERTOWN','P.O. BOX 910','44-54-50.3000N','161690.3000N','097-09-17.0000W','349757.0000W','en',1,'Y');
   i('09986.*A','AIRPORT','AZO','MICHIGAN','KALAMAZOO','KALAMAZOO','KALAMAZOO/BATTLE CREEK INTL','KALAMAZOO CO','5235 PORTAGE RD','42-14-03.8000N','152043.8000N','085-33-05.6000W','307985.6000W','en',1,'Y');
   i('05008.*A','AIRPORT','SPI','ILLINOIS','SANGAMON','SPRINGFIELD','ABRAHAM LINCOLN CAPITAL','SPRINGFIELD ARPT AUTH','1200 CAPITAL AIRPORT DR','39-50-39.2000N','143439.2000N','089-40-41.1000W','322841.1000W','en',1,'Y');
   i('10232.*A','AIRPORT','PTK','MICHIGAN','OAKLAND','PONTIAC','OAKLAND COUNTY INTL','COUNTY OF OAKLAND','1200 N TELEGRAPH','42-39-56.2903N','153596.2903N','083-25-13.8203W','300313.8203W','en',1,'Y');
   i('02631.*A','AIRPORT','GUC','COLORADO','GUNNISON','GUNNISON','GUNNISON-CRESTED BUTTE RGNL','COUNTY OF GUNNISON','519 RIO GRANDE','38-32-03.6000N','138723.6000N','106-55-54.3000W','384954.3000W','en',1,'Y');
   i('09304.02*A','AIRPORT','CEF','MASSACHUSETTS','HAMPDEN','SPRINGFIELD/CHICOPEE','WESTOVER ARB/METRO','USAF RESERVES','439TH OSS/OSA 750 HANGAR AVE','42-11-38.4539N','151898.4539N','072-32-05.2235W','261125.2235W','en',1,'Y');
   i('23337.22*A','AIRPORT','LBX','TEXAS','BRAZORIA','ANGLETON/LAKE JACKSON','TEXAS GULF COAST RGNL','BRAZORIA COUNTY','BRAZORIA COUNTY COURTHOUSE','29-06-31.1000N','104791.1000N','095-27-43.5000W','343663.5000W','en',1,'Y');
   i('26381.*A','AIRPORT','RNT','WASHINGTON','KING','RENTON','RENTON MUNI','CITY OF RENTON','1055 SOUTH GRADY WAY','47-29-35.3000N','170975.3000N','122-12-56.7000W','439976.7000W','en',1,'Y');
   i('51513.7*A','AIRPORT','FAQ','AMERICAN SAMOA','AMERICAN SAMOA','FITIUTA VILLAGE','FITIUTA','AM SAMOA GOVERNMENT','P.O. BOX 1539','14-12-58.0040S','051178.0040S','169-25-24.7780W','609924.7780W','en',1,'Y');
   i('50416.*A','AIRPORT','AKN','ALASKA','BRISTOL BAY','KING SALMON','KING SALMON','ALASKA DOT&PF SOUTHCOAST REGION','PO BOX 112500','58-40-35.3765N','211235.3765N','156-38-55.2876W','563935.2876W','en',1,'Y');
   i('05303.*A','AIRPORT','GYY','INDIANA','LAKE','GARY','GARY/CHICAGO INTL','GARY/CHICAGO ARPT AUTH DIST','6001 INDUSTRIAL HWY','41-37-02.1000N','149822.1000N','087-24-52.3000W','314692.3000W','en',1,'Y');
   i('02251.*A','AIRPORT','SMX','CALIFORNIA','SANTA BARBARA','SANTA MARIA','SANTA MARIA PUB/CAPT G ALLAN HANCOCK FLD','SANTA MARIA PUBLIC APT DIST','3217 TERMINAL DR','34-53-59.8000N','125639.8000N','120-27-29.1000W','433649.1000W','en',1,'Y');
   i('04344.1*A','AIRPORT','TWF','IDAHO','TWIN FALLS','TWIN FALLS','JOSLIN FLD - MAGIC VALLEY RGNL','CITY & COUNTY OF TWIN FALLS','P.O. BOX 1907','42-28-54.5000N','152934.5000N','114-29-15.9000W','412155.9000W','en',1,'Y');
   i('00742.2*A','AIRPORT','PGA','ARIZONA','COCONINO','PAGE','PAGE MUNI','CITY OF PAGE','BOX 1180','36-55-33.8500N','132933.8500N','111-26-54.0620W','401214.0620W','en',1,'Y');
   i('08569.*A','AIRPORT','HGR','MARYLAND','WASHINGTON','HAGERSTOWN','HAGERSTOWN RGNL-RICHARD A HENSON FLD','WASHINGTON COUNTY','100 WEST WASHINGTON ST','39-42-30.6000N','142950.6000N','077-43-35.4000W','279815.4000W','en',1,'Y');
   i('03728.*A','AIRPORT','CSG','GEORGIA','MUSCOGEE','COLUMBUS','COLUMBUS','COLUMBUS AIRPORT COMMISSION','3250 W BRITT DAVID RD','32-30-58.8000N','117058.8000N','084-56-19.9000W','305779.9000W','en',1,'Y');
   i('11024.*A','AIRPORT','TVF','MINNESOTA','PENNINGTON','THIEF RIVER FALLS','THIEF RIVER FALLS RGNL','THIEF RIVER FALLS ARPT AUTHORITY','13722 AIRPORT DRIVE, P.O. BOX 672','48-03-56.4380N','173036.4380N','096-11-05.9830W','346265.9830W','en',1,'Y');
   i('11458.2*A','AIRPORT','UTA','MISSISSIPPI','TUNICA','TUNICA','TUNICA MUNI','TUNICA COUNTY AIRPORT COMMISSION','PO BOX 158','34-41-06.2000N','124866.2000N','090-20-52.0000W','325252.0000W','en',1,'Y');
   i('08750.*A','AIRPORT','BED','MASSACHUSETTS','MIDDLESEX','BEDFORD','LAURENCE G HANSCOM FLD','MASS PORT AUTHORITY','ONE HARBORSIDE DR','42-28-11.8000N','152891.8000N','071-17-20.4000W','256640.4000W','en',1,'Y');
   i('50040.5*A','AIRPORT','AKA','ALASKA','ALEUTIANS WEST','ATKA','ATKA','ALASKA DOT&PF SOUTHCOAST REGION','PO BOX 112506','52-13-14.1000N','187994.1000N','174-12-22.3000W','627142.3000W','en',1,'Y');
   i('02407.*A','AIRPORT','VCV','CALIFORNIA','SAN BERNARDINO','VICTORVILLE','SOUTHERN CALIFORNIA LOGISTICS','SOUTHERN CA LOGISTICS ARPT AUTH','18374 PHANTOM','34-35-50.9000N','124550.9000N','117-22-58.8000W','422578.8000W','en',1,'Y');
   i('10962.1*A','AIRPORT','STC','MINNESOTA','SHERBURNE','ST CLOUD','ST CLOUD RGNL','CITY OF ST CLOUD','1550 45TH AVE SE SUITE 1','45-32-46.4000N','163966.4000N','094-03-33.8000W','338613.8000W','en',1,'Y');
   i('03902.*A','AIRPORT','MCN','GEORGIA','BIBB','MACON','MIDDLE GEORGIA RGNL','MACON-BIBB COUNTY','CITY HALL','32-41-34.2000N','117694.2000N','083-38-57.2000W','301137.2000W','en',1,'Y');
   i('01376.1*A','AIRPORT','CRQ','CALIFORNIA','SAN DIEGO','CARLSBAD','MC CLELLAN-PALOMAR','COUNTY OF SAN DIEGO','1960 JOE CROSSON DRIVE','33-07-41.7000N','119261.7000N','117-16-48.3000W','422208.3000W','en',1,'Y');
   i('23287.*A','AIRPORT','ABI','TEXAS','TAYLOR','ABILENE','ABILENE RGNL','CITY OF ABILENE','PO BOX 60','32-24-40.8000N','116680.8000N','099-40-54.8000W','358854.8000W','en',1,'Y');
   i('27759.*A','AIRPORT','CYS','WYOMING','LARAMIE','CHEYENNE','CHEYENNE RGNL/JERRY OLSON FLD','CHEYENNE ARPT BOARD','PO BOX 2210','41-09-20.3000N','148160.3000N','104-48-37.7000W','377317.7000W','en',1,'Y');
   i('06932.*A','AIRPORT','FOE','KANSAS','SHAWNEE','TOPEKA','TOPEKA RGNL','METROPOLITAN TOPEKA ARPT AUTH','6510 SE FORBES AVE #1','38-57-03.4170N','140223.4170N','095-39-49.0090W','344389.0090W','en',1,'Y');
   i('50687.*A','AIRPORT','SVA','ALASKA','NOME','SAVOONGA','SAVOONGA','ALASKA DOT&PF NORTHERN REGION','2301 PEGER RD','63-41-10.6000N','229270.6000N','170-29-35.4000W','613775.4000W','en',1,'Y');
   i('50680.8*A','AIRPORT','KSM','ALASKA','KUSILVAK','ST MARY''S','ST MARY''S','ALASKA DOT&PF NORTHERN REGION','2301 PEGER ROAD','62-03-39.0000N','223419.0000N','163-18-06.6000W','587886.6000W','en',1,'Y');
   i('07308.1*A','AIRPORT','OWB','KENTUCKY','DAVIESS','OWENSBORO','OWENSBORO-DAVIESS COUNTY RGNL','OWENSBORO CITY & DAVIESS COUNTY','2200 AIRPORT ROAD','37-44-19.8030N','135859.8030N','087-10-00.5828W','313800.5828W','en',1,'Y');
   i('25233.*A','AIRPORT','OGD','UTAH','WEBER','OGDEN','OGDEN-HINCKLEY','OGDEN CITY CORPORATION','2549 WASHINGTON BLVD','41-11-42.2533N','148302.2533N','112-00-43.9010W','403243.9010W','en',1,'Y');
   i('00696.71*A','AIRPORT','GYR','ARIZONA','MARICOPA','GOODYEAR','PHOENIX GOODYEAR','CITY OF PHOENIX','3400 SKY HARBOR BLVD','33-25-23.8000N','120323.8000N','112-22-31.3000W','404551.3000W','en',1,'Y');
   i('23189.*A','AIRPORT','MQY','TENNESSEE','RUTHERFORD','SMYRNA','SMYRNA','SMYRNA/RUTHERFORD ARPT AUTH','278 DOUG WARPOOLE RD.','36-00-32.2930N','129632.2930N','086-31-12.3230W','311472.3230W','en',1,'Y');
   i('51524.1*A','AIRPORT','Z08','AMERICAN SAMOA','AMERICAN SAMOA','OFU VILLAGE','OFU','GOVT OF AMERICAN SAMOA','PO BOX 1539','14-11-03.6350S','051063.6350S','169-40-12.3600W','610812.3600W','en',1,'Y');
   i('50284.*A','AIRPORT','GST','ALASKA','ANGOON','GUSTAVUS','GUSTAVUS','ALASKA DOT&PF SOUTHCOAST REGION','6860 GLACIER HWY','58-25-31.0000N','210331.0000N','135-42-26.7000W','488546.7000W','en',1,'Y');
   i('06967.*A','AIRPORT','EGT','KANSAS','SUMNER','WELLINGTON','WELLINGTON MUNI','CITY OF WELLINGTON','441 NORTH WEST ROAD','37-19-29.9846N','134369.9846N','097-23-18.0815W','350598.0815W','en',1,'Y');
   i('50920.12*C','SEAPLANE BASE','2Y3','ALASKA','SKAGWAY-YAKUTAT','YAKUTAT','YAKUTAT','CITY & BOROUGH OF YAKUTAT','PO BOX 160','59-34-39.7000N','214479.7000N','139-44-59.8000W','503099.8000W','en',1,'Y');
   i('04494.*A','AIRPORT','CMI','ILLINOIS','CHAMPAIGN','CHAMPAIGN/URBANA','UNIVERSITY OF ILLINOIS-WILLARD','UNIV OF ILLINOIS','11 AIRPORT ROAD','40-02-19.8000N','144139.8000N','088-16-40.1000W','317800.1000W','en',1,'Y');
   i('08995.*A','AIRPORT','HYA','MASSACHUSETTS','BARNSTABLE','HYANNIS','CAPE COD GATEWAY','TOWN OF BARNSTABLE','TOWN HALL 367 MAIN ST','41-40-09.6000N','150009.6000N','070-16-49.3000W','253009.3000W','en',1,'Y');
   i('23887.*A','AIRPORT','FTW','TEXAS','TARRANT','FORT WORTH','FORT WORTH MEACHAM INTL','CITY OF FORT WORTH','1000 THROCKMORTON ST.','32-49-11.1730N','118151.1730N','097-21-44.8200W','350504.8200W','en',1,'Y');
   i('03540.*A','AIRPORT','VRB','FLORIDA','INDIAN RIVER','VERO BEACH','VERO BEACH RGNL','CITY OF VERO BEACH','PO BOX 1389','27-39-20.0000N','099560.0000N','080-25-04.6000W','289504.6000W','en',1,'Y');
   i('21545.1*A','AIRPORT','UNV','PENNSYLVANIA','CENTRE','STATE COLLEGE','UNIVERSITY PARK','PENN STATE UNIVERSITY','2535 FOX HILL RD','40-51-00.0000N','147060.0000N','077-50-51.3000W','280251.3000W','en',1,'Y');
   i('02709.*A','AIRPORT','PUB','COLORADO','PUEBLO','PUEBLO','PUEBLO MEML','CITY OF PUEBLO','1 CITY HALL','38-17-23.8110N','137843.8110N','104-29-52.9010W','376192.9010W','en',1,'Y');
   i('04458.8*A','AIRPORT','CPS','ILLINOIS','ST CLAIR','CAHOKIA/ST LOUIS','ST LOUIS DOWNTOWN','BI-STATE DEVELOPMENT AGENCY','6100 ARCHVIEW DRIVE','38-34-13.3000N','138853.3000N','090-09-18.3000W','324558.3000W','en',1,'Y');
   i('11816.*A','AIRPORT','MKC','MISSOURI','CLAY','KANSAS CITY','CHARLES B WHEELER DOWNTOWN','CITY OF KANSAS CITY','414 E. 12TH ST','39-07-22.6000N','140842.6000N','094-35-34.2000W','340534.2000W','en',1,'Y');
   i('50680.4*A','AIRPORT','PBV','ALASKA','ALEUTIANS WEST','ST GEORGE','ST GEORGE','ALASKA DOT&PF SOUTHCOAST REGION','PO BOX 112506','56-34-38.5000N','203678.5000N','169-39-49.4000W','610789.4000W','en',1,'Y');
   i('00554.*A','AIRPORT','TCL','ALABAMA','TUSCALOOSA','TUSCALOOSA','TUSCALOOSA NTL','CITY OF TUSCALOOSA','7601 ROBERT CARDINAL AIRPORT ROAD','33-13-14.2591N','119594.2591N','087-36-41.0454W','315401.0454W','en',1,'Y');
   i('23635.*A','AIRPORT','CLL','TEXAS','BRAZOS','COLLEGE STATION','EASTERWOOD FLD','TEXAS A&M UNIVERSITY SYSTEM','301 TARROW STREET','30-35-16.9508N','110116.9508N','096-21-45.1600W','346905.1600W','en',1,'Y');
   i('11567.*A','AIRPORT','BBG','MISSOURI','TANEY','BRANSON','BRANSON','TANEY COUNTY','4000 BRANSON AIRPORT BLVD.','36-31-55.4970N','131515.4970N','093-12-01.9600W','335521.9600W','en',1,'Y');
   i('15851.*A','AIRPORT','OGS','NEW YORK','ST LAWRENCE','OGDENSBURG','OGDENSBURG INTL','OGDENSBURG BRIDGE & PORT','BRIDGE PLAZA','44-40-56.1000N','160856.1000N','075-27-47.7000W','271667.7000W','en',1,'Y');
   i('14726.01*A','AIRPORT','SRR','NEW MEXICO','LINCOLN','RUIDOSO','SIERRA BLANCA RGNL','VILLAGE OF RUIDOSO','313 CREE MEADOWS DR','33-27-39.4000N','120459.4000N','105-31-48.5000W','379908.5000W','en',1,'Y');
   i('24976.*A','AIRPORT','ACT','TEXAS','MC LENNAN','WACO','WACO RGNL','CITY OF WACO','PO BOX 2570','31-36-43.9000N','113803.9000N','097-13-49.1000W','350029.1000W','en',1,'Y');
   i('07670.*A','AIRPORT','ARA','LOUISIANA','IBERIA','NEW IBERIA','ACADIANA RGNL','IBERIA PARISH GOVERMENT','300 IBERIA ST','30-02-15.9300N','108135.9300N','091-53-02.0260W','330782.0260W','en',1,'Y');
   i('50037.*A','AIRPORT','LHD','ALASKA','ANCHORAGE','ANCHORAGE','LAKE HOOD','STATE OF AK - DOT & PF','PO BOX 196960','61-11-11.9011N','220271.9011N','149-57-55.4171W','539875.4171W','en',1,'Y');
   i('50009.*A','AIRPORT','ADK','ALASKA','ALEUTIANS WEST','ADAK ISLAND','ADAK','ALASKA DOT&PF SOUTHCOAST REGION','1500 ANTON LARSON','51-53-00.8980N','186780.8980N','176-38-32.9360W','635912.9360W','en',1,'Y');
   i('18717.*A','AIRPORT','ILN','OHIO','CLINTON','WILMINGTON','WILMINGTON AIR PARK','CLINTON COUNTY PORT AUTHORITY','1113 AIRPORT ROAD','39-25-40.5000N','141940.5000N','083-47-31.6000W','301651.6000W','en',1,'Y');
   i('18753.*A','AIRPORT','YNG','OHIO','TRUMBULL','YOUNGSTOWN/WARREN','YOUNGSTOWN-WARREN RGNL','WESTERN RESERVE PORT AUTHORITY','1453 YOUNGSTOWN KINGSVILLE RD NE, STE 11','41-15-41.7000N','148541.7000N','080-40-49.3000W','290449.3000W','en',1,'Y');
   i('02569.*A','AIRPORT','BJC','COLORADO','JEFFERSON','DENVER','ROCKY MOUNTAIN METRO','JEFFERSON COUNTY','100 JEFFERSON CO PKWY','39-54-31.7000N','143671.7000N','105-07-01.9000W','378421.9000W','en',1,'Y');
   i('11194.51*A','AIRPORT','GTR','MISSISSIPPI','LOWNDES','COLUMBUS/W POINT/STARKVILLE','GOLDEN TRIANGLE RGNL','GOLDEN TRIANGLE REG AUTH','2080 AIRPORT ROAD','33-26-53.8000N','120413.8000N','088-35-29.0000W','318929.0000W','en',1,'Y');
   i('02396.*A','AIRPORT','VNY','CALIFORNIA','LOS ANGELES','VAN NUYS','VAN NUYS','LOS ANGELES  WORLD ARPTS','1 WORLD WAY','34-12-35.3000N','123155.3000N','118-29-23.9000W','426563.9000W','en',1,'Y');
   i('17066.*A','AIRPORT','RWI','NORTH CAROLINA','NASH','ROCKY MOUNT','ROCKY MOUNT-WILSON RGNL','ROCKY MOUNT-WILSON ARPT AUTH','7265 AIR TERMINAL DR','35-51-22.5100N','129082.5100N','077-53-30.9600W','280410.9600W','en',1,'Y');
   i('27166.*A','AIRPORT','EGV','WISCONSIN','VILAS','EAGLE RIVER','EAGLE RIVER UNION','CITY OF EAGLE RIVER','PO BOX 2320','45-55-56.4000N','165356.4000N','089-16-05.8000W','321365.8000W','en',1,'Y');
   i('14349.*A','AIRPORT','TEB','NEW JERSEY','BERGEN','TETERBORO','TETERBORO','PORT AUTHORITY OF NY & NJ','4 WORLD TRADE CENTER','40-51-00.4000N','147060.4000N','074-03-39.0000W','266619.0000W','en',1,'Y');
   i('19063.*A','AIRPORT','LAW','OKLAHOMA','COMANCHE','LAWTON','LAWTON-FORT SILL RGNL','CITY OF LAWTON','BOX 531','34-34-03.7720N','124443.7720N','098-24-59.8920W','354299.8920W','en',1,'Y');
   i('05126.*A','AIRPORT','BMG','INDIANA','MONROE','BLOOMINGTON','MONROE COUNTY','MONROE COUNTY','972 SOUTH KIRBY ROAD','39-08-45.6750N','140925.6750N','086-37-00.0497W','311820.0497W','en',1,'Y');
   i('05412.*A','AIRPORT','LAF','INDIANA','TIPPECANOE','LAFAYETTE','PURDUE UNIVERSITY','PURDUE UNIVERSITY','1501 AVIATION DRIVE, TRML BLDG ROOM 201','40-24-44.3000N','145484.3000N','086-56-12.8000W','312972.8000W','en',1,'Y');
   i('27406.31*A','AIRPORT','CWA','WISCONSIN','MARATHON','MOSINEE','CENTRAL WISCONSIN','MARATHON AND PORTAGE CO','100 CWA DR. SUITE 227','44-46-39.4452N','161199.4452N','089-40-00.4009W','322800.4009W','en',1,'Y');
   i('15236.*A','AIRPORT','FRG','NEW YORK','SUFFOLK','FARMINGDALE','REPUBLIC','NEW YORK STATE DEPT TRANS','1220 WASHINGTON AVE','40-43-43.6000N','146623.6000N','073-24-48.3000W','264288.3000W','en',1,'Y');
   i('10127.*A','AIRPORT','MKG','MICHIGAN','MUSKEGON','MUSKEGON','MUSKEGON COUNTY','MUSKEGON COUNTY','99 SINCLAIR DR','43-10-03.6182N','155403.6182N','086-14-07.5794W','310447.5794W','en',1,'Y');
   i('17220.*A','AIRPORT','INT','NORTH CAROLINA','FORSYTH','WINSTON SALEM','SMITH REYNOLDS','FORSYTH COUNTY','3801 N LIBERTY ST., STE 204','36-08-01.3697N','130081.3697N','080-13-19.1558W','288799.1558W','en',1,'Y');
   i('15349.*A','AIRPORT','1H4','NEW YORK','GREENE','GREENVILLE','GREENVILLE-RAINBOW','WALTER J BIRMANN','3822 CR 26','42-25-10.9300N','152710.9300N','074-00-24.8100W','266424.8100W','en',1,'Y');
   i('07594.3*A','AIRPORT','CWF','LOUISIANA','CALCASIEU','LAKE CHARLES','CHENNAULT INTL','CHENNAULT INTL ARPT AUTHORITY','3650 SEN. J. BENNETT JOHNSTON AVE','30-12-38.1000N','108758.1000N','093-08-35.5000W','335315.5000W','en',1,'Y');
   i('24239.*A','AIRPORT','GGG','TEXAS','GREGG','LONGVIEW','EAST TEXAS RGNL','GREGG COUNTY','GREGG COUNTY COURTHOUSE','32-23-02.4000N','116582.4000N','094-42-41.4000W','340961.4000W','en',1,'Y');
   i('00763.*A','AIRPORT','PRC','ARIZONA','YAVAPAI','PRESCOTT','PRESCOTT RGNL - ERNEST A LOVE FLD','CITY OF PRESCOTT','201 SOUTH CORTEZ STREET','34-39-17.4000N','124757.4000N','112-25-09.2000W','404709.2000W','en',1,'Y');
   i('23710.3*A','AIRPORT','ADS','TEXAS','DALLAS','DALLAS','ADDISON','TOWN OF ADDISON','P.O. BOX 9010','32-58-06.8000N','118686.8000N','096-50-11.2000W','348611.2000W','en',1,'Y');
   i('19541.*A','AIRPORT','OTH','OREGON','COOS','NORTH BEND','SOUTHWEST OREGON RGNL','COOS COUNTY AIRPORT DISTRICT','1100 AIRPORT LANE, FLOOR 3','43-25-01.0000N','156301.0000N','124-14-49.3000W','447289.3000W','en',1,'Y');
   i('23352.1*A','AIRPORT','GKY','TEXAS','TARRANT','ARLINGTON','ARLINGTON MUNI','CITY OF ARLINGTON','PO BOX 90231','32-39-49.9000N','117589.9000N','097-05-39.4000W','349539.4000W','en',1,'Y');
   i('27170.*A','AIRPORT','EAU','WISCONSIN','CHIPPEWA','EAU CLAIRE','CHIPPEWA VALLEY RGNL','EAU CLAIRE COUNTY','721 OXFORD AVE','44-51-56.9000N','161516.9000N','091-29-03.3000W','329343.3000W','en',1,'Y');
   i('22276.*A','AIRPORT','FLO','SOUTH CAROLINA','FLORENCE','FLORENCE','FLORENCE RGNL','PEE DEE REGIONAL ARPT AUTHORITY','2100 TERMINAL DRIVE','34-11-07.3000N','123067.3000N','079-43-26.0000W','287006.0000W','en',1,'Y');
   i('03616.*A','AIRPORT','ABY','GEORGIA','DOUGHERTY','ALBANY','SOUTHWEST GEORGIA RGNL','CITY OF ALBANY','3905 NEWTON ROAD, SUITE 100','31-32-07.9000N','113527.9000N','084-11-40.1000W','303100.1000W','en',1,'Y');
   i('13379.01*H','HELIPORT','NH33','NEW HAMPSHIRE','MERRIMACK','PEMBROKE','BRIGHAM','RAY NEWCOMB','720 CLOUGH MILL ROAD','43-11-45.2930N','155505.2930N','071-28-38.2520W','257318.2520W','en',1,'Y');
   i('07594.1*A','AIRPORT','LCH','LOUISIANA','CALCASIEU','LAKE CHARLES','LAKE CHARLES RGNL','CALCASIEU PARISH','PO BOX 5820','30-07-33.9000N','108453.9000N','093-13-24.3000W','335604.3000W','en',1,'Y');
   i('23750.*A','AIRPORT','DTO','TEXAS','DENTON','DENTON','DENTON ENTERPRISE','CITY OF DENTON','215 E. MCKINNEY','33-12-07.0580N','119527.0580N','097-11-56.7510W','349916.7510W','en',1,'Y');
   i('00700.1*A','AIRPORT','GCN','ARIZONA','COCONINO','GRAND CANYON','GRAND CANYON NTL PARK','STATE OF ARIZONA','DEPARTMENT OF TRANS-ASD, 206 S. 17TH AVE MD178','35-57-08.5000N','129428.5000N','112-08-49.1000W','403729.1000W','en',1,'Y');
   i('03637.*A','AIRPORT','AHN','GEORGIA','CLARKE','ATHENS','ATHENS/BEN EPPS','CLARKE COUNTY','PO BOX 448, CO COURTHOUSE','33-56-55.1000N','122215.1000N','083-19-33.3000W','299973.3000W','en',1,'Y');
   i('05000.01*H','HELIPORT','2LL6','ILLINOIS','ROCK ISLAND','SILVIS','GENESIS MEDICAL CENTER - ILLINI CAMPUS','GENESIS HEALTH SYSTEM','1227 RUSHOLME','41-29-42.7500N','149382.7500N','090-25-05.3000W','325505.3000W','en',1,'Y');
   i('04508.1*A','AIRPORT','PWK','ILLINOIS','COOK','CHICAGO/PROSPECT HEIGHTS/WHEELING','CHICAGO EXEC','CITIES OF WHEELING & PROSPECT HGTS','1020 S. PLANT ROAD','42-06-51.4000N','151611.4000N','087-54-05.5000W','316445.5000W','en',1,'Y');
   i('02603.1*A','AIRPORT','FNL','COLORADO','LARIMER','FORT COLLINS/LOVELAND','NORTHERN COLORADO RGNL','FORT COLLINS & LOVELAND','4900 EARHART ROAD','40-27-06.5780N','145626.5780N','105-00-40.8080W','378040.8080W','en',1,'Y');
   i('21329.*A','AIRPORT','RDG','PENNSYLVANIA','BERKS','READING','READING RGNL/CARL A SPAATZ FLD','READING REGIONAL ARPT AUTH.','2501 BERNVILLE RD','40-22-42.6000N','145362.6000N','075-57-54.9000W','273474.9000W','en',1,'Y');
   i('04850.*A','AIRPORT','MWA','ILLINOIS','WILLIAMSON','MARION','VETERANS AIRPORT OF SOUTHERN ILLINOIS','WILLIAMSON COUNTY ARPT AUTH','10400 TERMINAL DR','37-45-17.9000N','135917.9000N','089-00-39.9000W','320439.9000W','en',1,'Y');
   i('25117.*A','AIRPORT','CDC','UTAH','IRON','CEDAR CITY','CEDAR CITY RGNL','CEDAR CITY CORPORATION','10 NORTH MAIN','37-42-03.4920N','135723.4920N','113-05-55.8610W','407155.8610W','en',1,'Y');
   i('00975.*A','AIRPORT','FYV','ARKANSAS','WASHINGTON','FAYETTEVILLE','DRAKE FLD','CITY OF FAYETTEVILLE','113 MOUNTAIN ST','36-00-18.3000N','129618.3000N','094-10-12.2000W','339012.2000W','en',1,'Y');
   i('23672.03*H','HELIPORT','4XS8','TEXAS','TRAVIS','CREEDMOOR','STS VIP','S AND T SERVICES LLC','11417 FM 1625','30-05-59.5900N','108359.5900N','097-43-36.3000W','351816.3000W','en',1,'Y');
   i('11462.*A','AIRPORT','TUP','MISSISSIPPI','LEE','TUPELO','TUPELO RGNL','TUPELO AIRPORT AUTHORITY','2704 W. JACKSON,','34-16-08.4000N','123368.4000N','088-46-11.6000W','319571.6000W','en',1,'Y');
   i('16836.*A','AIRPORT','ISO','NORTH CAROLINA','LENOIR','KINSTON','KINSTON RGNL JETPORT AT STALLINGS FLD','NORTH CAROLINA','2780 JETPORT ROAD','35-19-53.1530N','127193.1530N','077-36-31.7930W','279391.7930W','en',1,'Y');
   i('25186.*A','AIRPORT','LGU','UTAH','CACHE','LOGAN','LOGAN-CACHE','LOGAN CITY & CACHE CO','199 N. MAIN','41-47-30.4014N','150450.4014N','111-51-05.9365W','402665.9365W','en',1,'Y');
   i('27834.*A','AIRPORT','LAR','WYOMING','ALBANY','LARAMIE','LARAMIE RGNL','LARAMIE REGIONAL AIRPORT BOARD','555 GENERAL BREES RD','41-18-43.4000N','148723.4000N','105-40-30.0000W','380430.0000W','en',1,'Y');
   i('03394.*A','AIRPORT','OCF','FLORIDA','MARION','OCALA','OCALA INTL-JIM TAYLOR FLD','CITY OF OCALA','1770 SW 60TH AVENUE, SUITE 600','29-10-18.7564N','105018.7564N','082-13-26.8127W','296006.8127W','en',1,'Y');
   i('12082.5*A','AIRPORT','SUS','MISSOURI','ST LOUIS','ST LOUIS','SPIRIT OF ST LOUIS','ST LOUIS COUNTY','18270 EDISON AVE NR 100','38-39-43.6000N','139183.6000N','090-39-07.4000W','326347.4000W','en',1,'Y');
   i('01899.*A','AIRPORT','MHV','CALIFORNIA','KERN','MOJAVE','MOJAVE AIR AND SPACE PORT','MOJAVE AIR AND SPACE PORT','1434 FLIGHTLINE','35-03-32.2000N','126212.2000N','118-09-02.2000W','425342.2000W','en',1,'Y');
   i('02742.*A','AIRPORT','TEX','COLORADO','SAN MIGUEL','TELLURIDE','TELLURIDE RGNL','TELLURIDE REGIONAL ARPT AUTH','1500 LAST DALLAR RD. SUITE 1','37-57-13.7000N','136633.7000N','107-54-31.5000W','388471.5000W','en',1,'Y');
   i('04477.*A','AIRPORT','MDH','ILLINOIS','JACKSON','CARBONDALE/MURPHYSBORO','SOUTHERN ILLINOIS','SOUTHERN ILLINOIS ARPT AUTH','PO BOX 1086','37-46-41.1000N','136001.1000N','089-15-07.3000W','321307.3000W','en',1,'Y');
   i('02356.1*A','AIRPORT','TOA','CALIFORNIA','LOS ANGELES','TORRANCE','ZAMPERINI FLD','CITY OF TORRANCE','3031 TORRANCE BLVD','33-48-12.1783N','121692.1783N','118-20-22.5875W','426022.5875W','en',1,'Y');
   i('11375.1*A','AIRPORT','UOX','MISSISSIPPI','LAFAYETTE','OXFORD','UNIVERSITY-OXFORD','UNIVERSITY OF MISSISSIPPI','P.O. BOX 8750','34-23-03.6000N','123783.6000N','089-32-12.5000W','322332.5000W','en',1,'Y');
   i('04506.*A','AIRPORT','ARR','ILLINOIS','KANE','CHICAGO/AURORA','AURORA MUNI','CITY OF AURORA','44 E. DOWNER PLACE','41-46-18.9000N','150378.9000N','088-28-32.4000W','318512.4000W','en',1,'Y');
   i('06402.*A','AIRPORT','ALO','IOWA','BLACK HAWK','WATERLOO','WATERLOO RGNL','CITY OF WATERLOO','715 MULBERRY','42-33-30.4170N','153210.4170N','092-24-03.6840W','332643.6840W','en',1,'Y');
   i('50257.5*A','AIRPORT','GBH','ALASKA','NORTH SLOPE','GALBRAITH LAKE','GALBRAITH LAKE','ALASKA DOT&PF NORTHERN REGION','2301 PEGER RD','68-28-46.8000N','246526.8000N','149-29-23.7000W','538163.7000W','en',1,'Y');
   i('19241.*A','AIRPORT','SWO','OKLAHOMA','PAYNE','STILLWATER','STILLWATER RGNL','CITY OF STILLWATER','723 SOUTH LEWIS','36-09-41.0000N','130181.0000N','097-05-09.2000W','349509.2000W','en',1,'Y');
   i('50620.2*A','AIRPORT','PPC','ALASKA','YUKON-KOYUKUK','PROSPECT CREEK','PROSPECT CREEK','ALASKA DOT&PF NORTHERN REGION','2301 PEGER RD','66-48-50.6000N','240530.6000N','150-38-37.0000W','542317.0000W','en',1,'Y');
   i('19279.1*A','AIRPORT','RVS','OKLAHOMA','TULSA','TULSA','RICHARD LLOYD JONES JR','CITY OF TULSA','TULSA ARPT IMPROVEMENT TRUST','36-02-22.5020N','129742.5020N','095-59-04.5430W','345544.5430W','en',1,'Y');
   i('27878.*A','AIRPORT','RKS','WYOMING','SWEETWATER','ROCK SPRINGS','SOUTHWEST WYOMING RGNL','ROCK SPRINGS/SWEETWATER COUNTY','BOX 1987','41-35-39.2000N','149739.2000N','109-03-54.7000W','392634.7000W','en',1,'Y');
   i('05957.*A','AIRPORT','DBQ','IOWA','DUBUQUE','DUBUQUE','DUBUQUE RGNL','CITY OF DUBUQUE','11000 ARPT RD','42-24-07.2000N','152647.2000N','090-42-34.1000W','326554.1000W','en',1,'Y');
   i('27286.1*A','AIRPORT','ENW','WISCONSIN','KENOSHA','KENOSHA','KENOSHA RGNL','CITY OF KENOSHA','625 52ND ST','42-35-45.8280N','153345.8280N','087-55-38.3660W','316538.3660W','en',1,'Y');
   i('01188.*A','AIRPORT','TXK','ARKANSAS','MILLER','TEXARKANA','TEXARKANA RGNL-WEBB FLD','TEXARKANA AIRPORT AUTHORITY','201 AIRPORT DR','33-27-13.4000N','120433.4000N','093-59-27.7000W','338367.7000W','en',1,'Y');
   i('52282.*A','AIRPORT','JRF','HAWAII','HONOLULU','KAPOLEI','KALAELOA (JOHN RODGERS FLD)','HAWAII STATE AIRPORTS DIVISION','400 RODGERS BLVD, SUITE 700','21-18-26.4740N','076706.4740N','158-04-13.0860W','569053.0860W','en',1,'Y');
   i('01395.*A','AIRPORT','CIC','CALIFORNIA','BUTTE','CHICO','CHICO MUNI','CITY OF CHICO','PO BOX 3420','39-47-43.4000N','143263.4000N','121-51-30.3000W','438690.3000W','en',1,'Y');
   i('09398.*A','AIRPORT','BAF','MASSACHUSETTS','HAMPDEN','WESTFIELD/SPRINGFIELD','WESTFIELD-BARNES RGNL','CITY OF WESTFIELD','CITY HALL, 59 COURT ST','42-09-28.6000N','151768.6000N','072-42-57.1000W','261777.1000W','en',1,'Y');
   i('23574.1*A','AIRPORT','CVB','TEXAS','MEDINA','CASTROVILLE','CASTROVILLE MUNI','CITY OF CASTROVILLE','1209 FIORELLA ST','29-20-32.6000N','105632.6000N','098-51-04.4000W','355864.4000W','en',1,'Y');
   i('14904.*A','AIRPORT','BGM','NEW YORK','BROOME','BINGHAMTON','GREATER BINGHAMTON/EDWIN A LINK FLD','BROOME COUNTY','2534 AIRPORT ROAD #16','42-12-30.4000N','151950.4000N','075-58-46.6000W','273526.6000W','en',1,'Y');
   i('13082.*A','AIRPORT','VGT','NEVADA','CLARK','LAS VEGAS','NORTH LAS VEGAS','CLARK COUNTY','2730 AIRPORT DR SUITE 101','36-12-38.5310N','130358.5310N','115-11-39.9940W','414699.9940W','en',1,'Y');
   i('04372.*A','AIRPORT','ALN','ILLINOIS','MADISON','ALTON/ST LOUIS','ST LOUIS RGNL','ST. LOUIS REGIONAL','8 TERMINAL DR SUITE 1','38-53-23.7000N','140003.7000N','090-02-45.6000W','324165.6000W','en',1,'Y');
   i('26022.1*A','AIRPORT','SHD','VIRGINIA','AUGUSTA','STAUNTON/WAYNESBORO/HARRISONBURG','SHENANDOAH VALLEY RGNL','SHENANDOAH VAL REG ARPT COMM','77 AVIATION CIR.','38-15-49.8000N','137749.8000N','078-53-47.2000W','284027.2000W','en',1,'Y');
   i('02166.*A','AIRPORT','MYF','CALIFORNIA','SAN DIEGO','SAN DIEGO','MONTGOMERY-GIBBS EXEC','CITY OF SAN DIEGO','3750 JOHN J MONTGOMERY DR','32-48-56.6000N','118136.6000N','117-08-22.4000W','421702.4000W','en',1,'Y');
   i('09548.*A','AIRPORT','BTL','MICHIGAN','CALHOUN','BATTLE CREEK','BATTLE CREEK EXEC AT KELLOGG FLD','CITY OF BATTLE CREEK','15551 SOUTH AIRPORT RD','42-18-23.3021N','152303.3021N','085-15-00.3202W','306900.3202W','en',1,'Y');
   i('05511.*A','AIRPORT','MIE','INDIANA','DELAWARE','MUNCIE','DELAWARE COUNTY RGNL','DELAWARE COUNTY ARPT AUTH','311 W. CARL SIMMONS RD.','40-14-32.9000N','144872.9000N','085-23-44.7000W','307424.7000W','en',1,'Y');
   i('02999.*A','AIRPORT','ILG','DELAWARE','NEW CASTLE','WILMINGTON','NEW CASTLE','DELAWARE RIVER & BAY AUTHORITY','151 N. DUPONT HIGHWAY','39-40-43.4000N','142843.4000N','075-36-23.9000W','272183.9000W','en',1,'Y');
   i('06621.*A','AIRPORT','GCK','KANSAS','FINNEY','GARDEN CITY','GARDEN CITY RGNL','CITY OF GARDEN CITY','CITY HALL, BOX 499','37-55-39.1000N','136539.1000N','100-43-27.9000W','362607.9000W','en',1,'Y');
   i('05689.*A','AIRPORT','HUF','INDIANA','VIGO','TERRE HAUTE','TERRE HAUTE RGNL','TERRE HAUTE RGNL ARPT AUTH','581 S. AIRPORT ST.','39-27-02.2750N','142022.2750N','087-18-25.1640W','314305.1640W','en',1,'Y');
   i('27272.*A','AIRPORT','JVL','WISCONSIN','ROCK','JANESVILLE','SOUTHERN WISCONSIN RGNL','ROCK COUNTY','51 SOUTH MAIN ST','42-37-12.9000N','153432.9000N','089-02-29.6000W','320549.6000W','en',1,'Y');
   i('00751.4*A','AIRPORT','DVT','ARIZONA','MARICOPA','PHOENIX','PHOENIX DEER VALLEY','CITY OF PHOENIX','3400 SKY HARBOR BLVD','33-41-17.9000N','121277.9000N','112-04-57.2000W','403497.2000W','en',1,'Y');
   i('15989.2*A','AIRPORT','POU','NEW YORK','DUTCHESS','POUGHKEEPSIE','HUDSON VALLEY RGNL','DUTCHESS COUNTY','22 MARKET ST','41-37-35.7000N','149855.7000N','073-53-03.1000W','265983.1000W','en',1,'Y');
   i('06691.*A','AIRPORT','K88','KANSAS','ALLEN','IOLA','ALLEN COUNTY','ALLEN COUNTY','COUNTY COURTHOUSE','37-52-05.6000N','136325.6000N','095-23-13.0000W','343393.0000W','en',1,'Y');
   i('17731.*A','AIRPORT','LUK','OHIO','HAMILTON','CINCINNATI','CINCINNATI MUNI/LUNKEN FLD','CITY OF CINCINNATI','262 WILMER AVE','39-06-12.0000N','140772.0000N','084-25-07.0000W','303907.0000W','en',1,'Y');
   i('21251.*A','AIRPORT','AGC','PENNSYLVANIA','ALLEGHENY','PITTSBURGH','ALLEGHENY COUNTY','ALLEGHENY CO ARPT AUTHORITY','PO BOX 12370','40-21-15.9755N','145275.9755N','079-55-44.5680W','287744.5680W','en',1,'Y');
   i('16095.92*A','AIRPORT','NY17','NEW YORK','CLINTON','PLATTSBURGH','ADIRONDACK AIRPARK ESTATES','ADIRONDACK AIRPARK ESTATES ASS''N','PO BOX 270','44-36-33.1600N','160593.1600N','073-51-28.5100W','265888.5100W','en',1,'Y');
   i('09061.*A','AIRPORT','GHG','MASSACHUSETTS','PLYMOUTH','MARSHFIELD','MARSHFIELD MUNI - GEORGE HARLOW FLD','TOWN OF MARSHFIELD','870 MORAINE ST','42-05-50.9958N','151550.9958N','070-40-22.8715W','254422.8715W','en',1,'Y');
   i('26190.*A','AIRPORT','ORS','WASHINGTON','SAN JUAN','EASTSOUND','ORCAS ISLAND','PORT OF ORCAS','P.O. BOX 53','48-42-30.0140N','175350.0140N','122-54-38.1430W','442478.1430W','en',1,'Y');
   i('16815.1*A','AIRPORT','OAJ','NORTH CAROLINA','ONSLOW','JACKSONVILLE','ALBERT J ELLIS','ONSLOW COUNTY','234 NW CORRIDOR BLVD','34-49-45.0000N','125385.0000N','077-36-43.7000W','279403.7000W','en',1,'Y');
   i('17521.*A','AIRPORT','CAK','OHIO','SUMMIT','AKRON','AKRON-CANTON RGNL','AKRON CANTON RGNL ARPT AUTHORITY','5400 LAUBY RD','40-54-54.2000N','147294.2000N','081-26-37.1000W','293197.1000W','en',1,'Y');
   i('24194.*A','AIRPORT','LRD','TEXAS','WEBB','LAREDO','LAREDO INTL','CITY OF LAREDO','PO BOX 579','27-32-39.1000N','099159.1000N','099-27-41.7000W','358061.7000W','en',1,'Y');
   i('25282.02*A','AIRPORT','SGU','UTAH','WASHINGTON','ST GEORGE','ST GEORGE RGNL','CITY OF ST GEORGE','175 E 200 N','37-02-10.9610N','133330.9610N','113-30-37.0900W','408637.0900W','en',1,'Y');
   i('26109.*A','AIRPORT','BLI','WASHINGTON','WHATCOM','BELLINGHAM','BELLINGHAM INTL','PORT OF BELLINGHAM','1801 ROEDER AVE','48-47-33.7000N','175653.7000N','122-32-15.1000W','441135.1000W','en',1,'Y');
   i('27013.1*A','AIRPORT','ATW','WISCONSIN','OUTAGAMIE','APPLETON','APPLETON INTL','OUTAGAMIE COUNTY','W6390 CHALLENGER DR-SUITE 201','44-15-29.1000N','159329.1000N','088-31-08.7000W','318668.7000W','en',1,'Y');
   i('05661.*A','AIRPORT','SBN','INDIANA','ST JOSEPH','SOUTH BEND','SOUTH BEND INTL','ST JOSEPH COUNTY ARPT AUTHORITY','4477 PROGRESS DRIVE','41-42-29.6000N','150149.6000N','086-19-02.4000W','310742.4000W','en',1,'Y');
   i('02586.1*A','AIRPORT','DRO','COLORADO','LA PLATA','DURANGO','DURANGO-LA PLATA COUNTY','DURANGO CITY LA PLATA CO','1000 AIRPORT ROAD BOX 15','37-09-05.5000N','133745.5000N','107-45-13.6000W','387913.6000W','en',1,'Y');
   i('01255.1*A','AIRPORT','ACV','CALIFORNIA','HUMBOLDT','ARCATA/EUREKA','CALIFORNIA REDWOOD COAST-HUMBOLDT COUNTY','HUMBOLDT COUNTY','1106 SECOND ST','40-58-40.2000N','147520.2000N','124-06-30.5000W','446790.5000W','en',1,'Y');
   i('16971.*A','AIRPORT','EWN','NORTH CAROLINA','CRAVEN','NEW BERN','COASTAL CAROLINA RGNL','CRAVEN COUNTY','PO BOX 3258','35-04-22.2691N','126262.2691N','077-02-34.8723W','277354.8723W','en',1,'Y');
   i('09809.*A','AIRPORT','FNT','MICHIGAN','GENESEE','FLINT','BISHOP INTL','BISHOP INTL ARPT AUTH','G-3425 W BRISTOL RD','42-57-55.7000N','154675.7000N','083-44-41.1000W','301481.1000W','en',1,'Y');
   i('04431.*A','AIRPORT','BMI','ILLINOIS','MC LEAN','BLOOMINGTON/NORMAL','CENTRAL IL RGNL/BLOOMINGTON-NORMAL','BLOOMINGTON NORMAL ARPT AUTH','3201 CIRA DRIVE','40-28-37.6000N','145717.6000N','088-54-57.3000W','320097.3000W','en',1,'Y');
   i('50140.7*A','AIRPORT','SCC','ALASKA','NORTH SLOPE','DEADHORSE','DEADHORSE','ALASKA DOT&PF NORTHERN REGION','2301 PEGER RD','70-11-41.1148N','252701.1148N','148-27-54.5935W','534474.5935W','en',1,'Y');
   i('07825.*A','AIRPORT','BGR','MAINE','PENOBSCOT','BANGOR','BANGOR INTL','CITY OF BANGOR','73 HARLOW STREET','44-48-26.8000N','161306.8000N','068-49-41.3000W','247781.3000W','en',1,'Y');
   i('04868.*A','AIRPORT','MLI','ILLINOIS','ROCK ISLAND','MOLINE','QUAD CITY INTL','METROPOLITAN AIRPORT AUTH','BOX 9009','41-26-53.8000N','149213.8000N','090-30-27.1000W','325827.1000W','en',1,'Y');
   i('03321.*A','AIRPORT','MLB','FLORIDA','BREVARD','MELBOURNE','MELBOURNE INTL','CITY OF MELBOURNE','1 AIR TERMINAL PKWY/SUITE 220','28-06-09.9000N','101169.9000N','080-38-42.9000W','290322.9000W','en',1,'Y');
   i('03650.*A','AIRPORT','AGS','GEORGIA','RICHMOND','AUGUSTA','AUGUSTA RGNL AT BUSH FLD','CITY OF AUGUSTA','AVIATION DEPARTMENT, 1501 AVIATION WAY','33-22-11.8000N','120131.8000N','081-57-52.2000W','295072.2000W','en',1,'Y');
   i('22776.*A','AIRPORT','RAP','SOUTH DAKOTA','PENNINGTON','RAPID CITY','RAPID CITY RGNL','CITY OF RAPID CITY','4550 TERMINAL RD - STE 102','44-02-43.2000N','158563.2000N','103-03-26.5000W','371006.5000W','en',1,'Y');
   i('02211.*A','AIRPORT','SBP','CALIFORNIA','SAN LUIS OBISPO','SAN LUIS OBISPO','SAN LUIS COUNTY RGNL','SAN LUIS OBISPO COUNTY','COUNTY GOVERNMENT CENTER','35-14-14.2000N','126854.2000N','120-38-33.4000W','434313.4000W','en',1,'Y');
   i('50412.03*A','AIRPORT','KTN','ALASKA','KETCHIKAN GATEWAY','KETCHIKAN','KETCHIKAN INTL','ALASKA DOT&PF SOUTHCOAST REGION','6860 GLACIER HIGHWAY','55-21-14.7000N','199274.7000N','131-42-40.4000W','474160.4000W','en',1,'Y');
   i('51523.2*A','AIRPORT','GSN','N MARIANA ISLANDS','NORTHERN MARIANA IS','SAIPAN ISLAND','FRANCISCO C ADA/SAIPAN INTL','COMMONWEALTH PORTS AUTH','PO BOX 501055','15-07-12.9180N','054432.9180N','145-43-47.9427E','524627.9427E','en',1,'Y');
   i('14559.*A','AIRPORT','CNM','NEW MEXICO','EDDY','CARLSBAD','CAVERN CITY AIR TRML','CITY OF CARLSBAD','101 NORTH HALAGUENO ST','32-20-14.8000N','116414.8000N','104-15-48.1000W','375348.1000W','en',1,'Y');
   i('14366.*A','AIRPORT','TTN','NEW JERSEY','MERCER','TRENTON','TRENTON MERCER','COUNTY OF MERCER','640 S BROAD ST','40-16-36.1000N','144996.1000N','074-48-48.5000W','269328.5000W','en',1,'Y');
   i('50061.1*A','AIRPORT','BET','ALASKA','BETHEL','BETHEL','BETHEL','ALASKA DOT&PF CENTRAL REGION','PO BOX 196900','60-46-42.8000N','218802.8000N','161-50-13.8000W','582613.8000W','en',1,'Y');
   i('04938.*A','AIRPORT','PIA','ILLINOIS','PEORIA','PEORIA','GENERAL DOWNING - PEORIA INTL','METROPOLITAN ARPT AUTH OF PEORIA','6100 WEST  E.M. DIRKSEN PKWY','40-39-51.1000N','146391.1000N','089-41-35.7000W','322895.7000W','en',1,'Y');
   i('15752.*A','AIRPORT','SWF','NEW YORK','ORANGE','NEW YORK','NEW YORK STEWART INTL','PORT AUTHORITY OF NY & NJ','1180 FIRST ST','41-30-14.8000N','149414.8000N','074-06-17.4000W','266777.4000W','en',1,'Y');
   i('00682.*A','AIRPORT','FHU','ARIZONA','COCHISE','FORT HUACHUCA SIERRA VISTA','SIERRA VISTA MUNI-LIBBY AAF','US ARMY INTELLIGENCE CTR','FORT HUACHUCA','31-35-18.5000N','113718.5000N','110-20-39.8000W','397239.8000W','en',1,'Y');
   i('02624.*A','AIRPORT','GJT','COLORADO','MESA','GRAND JUNCTION','GRAND JUNCTION RGNL','GRAND JUNCTION REG ARPT AUTH','2828 WALKER FLD DR SUITE 301','39-07-20.7000N','140840.7000N','108-31-36.3000W','390696.3000W','en',1,'Y');
   i('02126.*A','AIRPORT','MHR','CALIFORNIA','SACRAMENTO','SACRAMENTO','SACRAMENTO MATHER','COUNTY OF SACRAMENTO','6900 AIRPORT BLVD.','38-33-19.1190N','138799.1190N','121-17-49.9610W','436669.9610W','en',1,'Y');
   i('01914.*A','AIRPORT','MRY','CALIFORNIA','MONTEREY','MONTEREY','MONTEREY RGNL','MONTEREY PENIN ARPT DIST','200 FRED KANE DR., SUITE 200','36-35-13.0280N','131713.0280N','121-50-34.0190W','438634.0190W','en',1,'Y');
   i('11730.*A','AIRPORT','TBN','MISSOURI','PULASKI','FORT LEONARD WOOD','WAYNESVILLE-ST ROBERT RGNL FORNEY FLD','U S ARMY','FORNEY ARMY AIRFIELD','37-44-29.9000N','135869.9000N','092-08-26.6000W','331706.6000W','en',1,'Y');
   i('06557.*A','AIRPORT','DDC','KANSAS','FORD','DODGE CITY','DODGE CITY RGNL','CITY OF DODGE CITY','PO BOX 880','37-45-47.2000N','135947.2000N','099-57-55.5000W','359875.5000W','en',1,'Y');
   i('12743.*A','AIRPORT','GRI','NEBRASKA','HALL','GRAND ISLAND','CENTRAL NEBRASKA RGNL','HALL COUNTY ARPT AUTH','3579 SKY PARK ROAD','40-58-03.1530N','147483.1530N','098-18-34.7000W','353914.7000W','en',1,'Y');
   i('09211.*A','AIRPORT','PVC','MASSACHUSETTS','BARNSTABLE','PROVINCETOWN','PROVINCETOWN MUNI','DEPT OF INTERIOR NATL PARK SERVICE','CAPE COD NATIONAL SEASHORE','42-04-20.2000N','151460.2000N','070-13-14.6000W','252794.6000W','en',1,'Y');
   i('02588.*A','AIRPORT','EGE','COLORADO','EAGLE','EAGLE','EAGLE COUNTY RGNL','EAGLE COUNTY','BOX 850','39-38-33.9000N','142713.9000N','106-54-57.4000W','384897.4000W','en',1,'Y');
   i('07589.*A','AIRPORT','LFT','LOUISIANA','LAFAYETTE','LAFAYETTE','LAFAYETTE RGNL/PAUL FOURNET FLD','CITY PARISH OF LAFAYETTE','222 JET RANGER X DRIVE','30-12-18.1000N','108738.1000N','091-59-15.9000W','331155.9000W','en',1,'Y');
   i('53004.*A','AIRPORT','BQN','PUERTO RICO','--PUERTO RICO','AGUADILLA','RAFAEL HERNANDEZ','PUERTO RICO PORTS AUTH','PO BOX 250466','18-29-41.5000N','066581.5000N','067-07-46.0000W','241666.0000W','en',1,'Y');
   i('13317.*A','AIRPORT','LEB','NEW HAMPSHIRE','GRAFTON','LEBANON','LEBANON MUNI','CITY OF LEBANON','51 NO PARK ST','43-37-34.0000N','157054.0000N','072-18-15.1000W','260295.1000W','en',1,'Y');
   i('25897.*A','AIRPORT','PHF','VIRGINIA','NEWPORT NEWS','NEWPORT NEWS','NEWPORT NEWS/WILLIAMSBURG INTL','PENINSULA ARPT CMSN','900 BLAND BLVD, SUITE G','37-07-54.8000N','133674.8000N','076-29-34.7000W','275374.7000W','en',1,'Y');
   i('23499.*A','AIRPORT','BRO','TEXAS','CAMERON','BROWNSVILLE','BROWNSVILLE/SOUTH PADRE ISLAND INTL','CITY OF BROWNSVILLE','BOX 911','25-54-22.1000N','093262.1000N','097-25-33.6000W','350733.6000W','en',1,'Y');
   i('12381.*A','AIRPORT','GTF','MONTANA','CASCADE','GREAT FALLS','GREAT FALLS INTL','GREAT FALLS INTL ARPT AUTH','2800 TERMINAL DR','47-28-56.2774N','170936.2774N','111-22-13.0059W','400933.0059W','en',1,'Y');
   i('15203.*A','AIRPORT','ELM','NEW YORK','CHEMUNG','ELMIRA/CORNING','ELMIRA/CORNING RGNL','COUNTY OF CHEMUNG','276 SING SING RD., SUITE 1','42-09-35.4821N','151775.4821N','076-53-30.2844W','276810.2844W','en',1,'Y');
   i('25986.*A','AIRPORT','ROA','VIRGINIA','ROANOKE','ROANOKE','ROANOKE-BLACKSBURG RGNL/WOODRUM FLD','ROANOKE BLACKSBURG RGNL/WOODRUM FIE','5202 AVN DR.','37-19-31.7000N','134371.7000N','079-58-31.5000W','287911.5000W','en',1,'Y');
   i('21781.*A','AIRPORT','AVP','PENNSYLVANIA','LUZERNE','WILKES-BARRE/SCRANTON','WILKES-BARRE/SCRANTON INTL','LUZERNE AND LACKAWANNA CO','100 TERMINAL DRIVE','41-20-18.5000N','148818.5000N','075-43-24.2000W','272604.2000W','en',1,'Y');
   i('00438.*A','AIRPORT','MOB','ALABAMA','MOBILE','MOBILE','MOBILE RGNL','MOBILE AIRPORT AUTHORITY','P O BOX 88004','30-41-29.1000N','110489.1000N','088-14-34.2000W','317674.2000W','en',1,'Y');
   i('20640.*A','AIRPORT','JST','PENNSYLVANIA','CAMBRIA','JOHNSTOWN','JOHN MURTHA JOHNSTOWN-CAMBRIA COUNTY','JOHNSTOWN-CAMBRIA CO APT AUTH','479 ARPT ROAD','40-18-56.0000N','145136.0000N','078-50-04.8000W','283804.8000W','en',1,'Y');
   i('12915.*A','AIRPORT','BFF','NEBRASKA','SCOTTS BLUFF','SCOTTSBLUFF','WESTERN NEBRASKA RGNL/WILLIAM B HEILIG FLD','AIRPORT AUTHORITY OF SCOTTSBLUFF CO','250023 AIRPORT TERMINAL ST., SUITE 10','41-52-26.5000N','150746.5000N','103-35-44.3000W','372944.3000W','en',1,'Y');
   i('17265.*A','AIRPORT','BIS','NORTH DAKOTA','BURLEIGH','BISMARCK','BISMARCK MUNI','CITY OF BISMARCK','BOX 991','46-46-21.8000N','168381.8000N','100-44-44.7000W','362684.7000W','en',1,'Y');
   i('01886.*A','AIRPORT','MCE','CALIFORNIA','MERCED','MERCED','MERCED RGNL/MACREADY FLD','CITY OF MERCED','678 WEST 18TH ST.','37-17-05.1000N','134225.1000N','120-30-50.1000W','433850.1000W','en',1,'Y');
   i('12402.*A','AIRPORT','HLN','MONTANA','LEWIS AND CLARK','HELENA','HELENA RGNL','HELENA REG ARPT AUTH','2850 MERCER LOOP','46-36-24.2000N','167784.2000N','111-58-59.8000W','403139.8000W','en',1,'Y');
   i('04206.*A','AIRPORT','SUN','IDAHO','BLAINE','HAILEY','FRIEDMAN MEML','CITY OF HAILEY','BLANE CO - BOX 400','43-30-13.6100N','156613.6100N','114-17-44.0100W','411464.0100W','en',1,'Y');
   i('26575.*A','AIRPORT','CRW','WEST VIRGINIA','KANAWHA','CHARLESTON','YEAGER','CENTRAL WVA REG ARPT AUTH','100 AIRPORT ROAD SUITE 175','38-22-33.6455N','138153.6455N','081-35-34.4144W','293734.4144W','en',1,'Y');
   i('25029.*A','AIRPORT','SPS','TEXAS','WICHITA','WICHITA FALLS','SHEPPARD AFB/WICHITA FALLS MUNI','UNITED STATES AIR FORCE.','SHEPPARD AFB','33-59-19.6900N','122359.6900N','098-29-30.8500W','354570.8500W','en',1,'Y');
   i('16644.2*A','AIRPORT','JQF','NORTH CAROLINA','CABARRUS','CONCORD','CONCORD-PADGETT RGNL','CITY OF CONCORD','9000 AVIATION BLVD','35-23-15.9730N','127395.9730N','080-42-32.8770W','290552.8770W','en',1,'Y');
   i('10576.*A','AIRPORT','BRD','MINNESOTA','CROW WING','BRAINERD','BRAINERD LAKES RGNL','BRAINERD/CROW WING CNTY','16384 AIRPORT RD, SUITE 5','46-24-15.2000N','167055.2000N','094-08-01.7000W','338881.7000W','en',1,'Y');
   i('24693.*A','AIRPORT','SJT','TEXAS','TOM GREEN','SAN ANGELO','SAN ANGELO RGNL/MATHIS FLD','CITY OF SAN ANGELO','72 W COLLEGE ST','31-21-27.8940N','112887.8940N','100-29-46.6950W','361786.6950W','en',1,'Y');
   i('03210.*A','AIRPORT','GNV','FLORIDA','ALACHUA','GAINESVILLE','GAINESVILLE RGNL','GAINESVILLE-ALACHUA CO AUTH','3880 NE 39TH AVE','29-41-24.2000N','106884.2000N','082-16-18.4000W','296178.4000W','en',1,'Y');
   i('25269.*A','AIRPORT','PVU','UTAH','UTAH','PROVO','PROVO MUNI','CITY OF PROVO','1377 S. 350 E.','40-13-09.0000N','144789.0000N','111-43-24.1000W','402204.1000W','en',1,'Y');
   i('05999.*A','AIRPORT','FOD','IOWA','WEBSTER','FORT DODGE','FORT DODGE RGNL','CITY OF FORT DODGE','819 FIRST AVE SOUTH','42-33-04.3000N','153184.3000N','094-11-30.6000W','339090.6000W','en',1,'Y');
   i('50258.*A','AIRPORT','GAL','ALASKA','YUKON-KOYUKUK','GALENA','EDWARD G PITKA SR','ALASKA DOT&PF NORTHERN REGION','2301 PEGER RD, 2301 PEGER RD','64-44-10.2830N','233050.2830N','156-56-04.3970W','564964.3970W','en',1,'Y');
   i('09881.*A','AIRPORT','CMX','MICHIGAN','HOUGHTON','HANCOCK','HOUGHTON COUNTY MEML','HOUGHTON COUNTY','23810 AIRPARK BLVD STE 113','47-10-06.2990N','169806.2990N','088-29-20.6470W','318560.6470W','en',1,'Y');
   i('09750.*A','AIRPORT','YIP','MICHIGAN','WAYNE','DETROIT','WILLOW RUN','WAYNE COUNTY AIRPORT AUTHORITY','11050 ROGELL DR # 602','42-14-24.1000N','152064.1000N','083-31-51.2000W','300711.2000W','en',1,'Y');
   i('16761.*A','AIRPORT','PGV','NORTH CAROLINA','PITT','GREENVILLE','PITT-GREENVILLE','PITT CO & GREENVILLE CITY','400 AIRPORT RD','35-38-08.5000N','128288.5000N','077-23-02.7000W','278582.7000W','en',1,'Y');
   i('55027.*A','AIRPORT','STT','VIRGIN ISLANDS','-VIRGIN ISLANDS-','CHARLOTTE AMALIE','CYRIL E KING','V I PORT AUTHORITY','8074 LINDBERGH BAY, P.O. BOX 301707','18-20-14.3000N','066014.3000N','064-58-24.0000W','233904.0000W','en',1,'Y');
   i('26210.*A','AIRPORT','PAE','WASHINGTON','SNOHOMISH','EVERETT','SNOHOMISH COUNTY (PAINE FLD)','SNOHOMISH COUNTY','3000 ROCKEFELLER AVE.','47-54-26.3425N','172466.3425N','122-16-55.5384W','440215.5384W','en',1,'Y');
   i('14728.*A','AIRPORT','SAF','NEW MEXICO','SANTA FE','SANTA FE','SANTA FE MUNI','CITY OF SANTA FE','PO BOX 909','35-37-01.6000N','128221.6000N','106-05-21.9000W','381921.9000W','en',1,'Y');
   i('08246.*A','AIRPORT','RKD','MAINE','KNOX','ROCKLAND','KNOX COUNTY RGNL','KNOX COUNTY','62 UNION ST','44-03-36.5120N','158616.5120N','069-05-58.8110W','248758.8110W','en',1,'Y');
   i('04508.*A','AIRPORT','ORD','ILLINOIS','COOK','CHICAGO','CHICAGO O''HARE INTL','CITY OF CHICAGO','P.O. BOX 66142, 10510 WEST ZEMKE RO, 10510 WEST ZEMKE RO','41-58-35.8640N','151115.8640N','087-54-26.1110W','316466.1110W','en',1,'Y');
   i('03640.*A','AIRPORT','ATL','GEORGIA','FULTON','ATLANTA','HARTSFIELD - JACKSON ATLANTA INTL','CITY OF ATLANTA','CITY HALL','33-38-12.1186N','121092.1186N','084-25-40.3104W','303940.3104W','en',1,'Y');
   i('01818.*A','AIRPORT','LAX','CALIFORNIA','LOS ANGELES','LOS ANGELES','LOS ANGELES INTL','CITY OF LOS ANGELES','1 WORLD WAY BOX 92216','33-56-32.9870N','122192.9870N','118-24-28.9750W','426268.9750W','en',1,'Y');
   i('23710.6*A','AIRPORT','DFW','TEXAS','TARRANT','DALLAS-FORT WORTH','DALLAS-FORT WORTH INTL','CITIES OF DALLAS AND FT WORTH','PO BOX 619428','32-53-50.0390N','118430.0390N','097-02-15.7010W','349335.7010W','en',1,'Y');
   i('02573.*A','AIRPORT','DEN','COLORADO','DENVER','DENVER','DENVER INTL','CITY & COUNTY OF DENVER','DEPT OF AVIATION','39-51-42.0000N','143502.0000N','104-40-23.4000W','376823.4000W','en',1,'Y');
   i('16608.*A','AIRPORT','CLT','NORTH CAROLINA','MECKLENBURG','CHARLOTTE','CHARLOTTE/DOUGLAS INTL','CITY OF CHARLOTTE','600 EAST FOURTH ST','35-12-49.5000N','126769.5000N','080-56-56.6000W','291416.6000W','en',1,'Y');
   i('26395.*A','AIRPORT','SEA','WASHINGTON','KING','SEATTLE','SEATTLE-TACOMA INTL','PORT OF SEATTLE','BOX 1209','47-26-59.6000N','170819.6000N','122-18-42.4000W','440322.4000W','en',1,'Y');
   i('15793.*A','AIRPORT','JFK','NEW YORK','QUEENS','NEW YORK','JOHN F KENNEDY INTL','PORT AUTHORITY OF NY AND NJ','4 WORLD TRADE CENTER, 150 GREENWICH ST 18TH FLOO','40-38-23.7400N','146303.7400N','073-46-43.2930W','265603.2930W','en',1,'Y');
   i('02187.*A','AIRPORT','SFO','CALIFORNIA','SAN MATEO','SAN FRANCISCO','SAN FRANCISCO INTL','CITY & COUNTY OF SAN FRANCISCO','PO BOX 8097','37-37-07.7000N','135427.7000N','122-22-31.5000W','440551.5000W','en',1,'Y');
   i('00754.*A','AIRPORT','PHX','ARIZONA','MARICOPA','PHOENIX','PHOENIX SKY HARBOR INTL','CITY OF PHOENIX','2485 E BUCKEYE RD','33-26-03.4000N','120363.4000N','112-00-41.7000W','403241.7000W','en',1,'Y');
   i('13083.*A','AIRPORT','LAS','NEVADA','CLARK','LAS VEGAS','MC CARRAN INTL','CLARK COUNTY','P O BOX 11005','36-04-48.1580N','129888.1580N','115-09-08.0450W','414548.0450W','en',1,'Y');
   i('10824.*A','AIRPORT','MSP','MINNESOTA','HENNEPIN','MINNEAPOLIS','MINNEAPOLIS-ST PAUL INTL/WOLD-CHAMBERLAIN','METRO ARPT CMSN','6040 28TH AVE SOUTH','44-52-55.1000N','161575.1000N','093-13-18.4000W','335598.4000W','en',1,'Y');
   i('03333.*A','AIRPORT','MIA','FLORIDA','DADE','MIAMI','MIAMI INTL','DADE COUNTY AVIATON DEPT','PO BOX 025504','25-47-43.3000N','092863.3000N','080-17-24.4170W','289044.4170W','en',1,'Y');
   i('03407.*A','AIRPORT','MCO','FLORIDA','ORANGE','ORLANDO','ORLANDO INTL','GREATER ORLANDO AVIATION AUTHORITY','1 JEFF FUQUA BLVD','28-25-45.8000N','102345.8000N','081-18-32.4000W','292712.4000W','en',1,'Y');
   i('15794.*A','AIRPORT','LGA','NEW YORK','QUEENS','NEW YORK','LAGUARDIA','PORT. AUTH. OF N.Y. & N.J.','4 WORLD TRADE CENTER','40-46-38.1000N','146798.1000N','073-52-21.4000W','265941.4000W','en',1,'Y');
   i('09749.*A','AIRPORT','DTW','MICHIGAN','WAYNE','DETROIT','DETROIT METRO WAYNE COUNTY','WAYNE COUNTY, MICHIGAN','11050 ROGELL DR #602','42-12-44.8000N','151964.8000N','083-21-12.2000W','300072.2000W','en',1,'Y');
   i('24071.1*A','AIRPORT','IAH','TEXAS','HARRIS','HOUSTON','GEORGE BUSH INTCNTL/HOUSTON','CITY OF HOUSTON','PO BOX 60106','29-59-03.9670N','107943.9670N','095-20-29.1930W','343229.1930W','en',1,'Y');
   i('03192.*A','AIRPORT','FLL','FLORIDA','BROWARD','FORT LAUDERDALE','FORT LAUDERDALE/HOLLYWOOD INTL','BROWARD COUNTY','115 S. ANDREWS AVENUE, ROOM 421','26-04-18.0000N','093858.0000N','080-08-58.9000W','288538.9000W','en',1,'Y');
   i('21217.*A','AIRPORT','PHL','PENNSYLVANIA','PHILADELPHIA','PHILADELPHIA','PHILADELPHIA INTL','CITY OF PHILADELPHIA','DIV OF AVIATION TERMINAL E','39-52-19.5020N','143539.5020N','075-14-26.3870W','270866.3870W','en',1,'Y');
   i('03001.*A','AIRPORT','DCA','DIST. OF COLUMBIA','ARLINGTON','WASHINGTON','RONALD REAGAN WASHINGTON NTL','METRO WASH ARPT AUTHORITY','1 AVIATION CIRCLE','38-51-05.2000N','139865.2000N','077-02-15.8000W','277335.8000W','en',1,'Y');
   i('08778.*A','AIRPORT','BOS','MASSACHUSETTS','SUFFOLK','BOSTON','GENERAL EDWARD LAWRENCE LOGAN INTL','MASS PORT AUTHORITY','ONE HARBORSIDE DR STE 200S','42-21-46.6000N','152506.6000N','071-00-23.0000W','255623.0000W','en',1,'Y');
   i('25289.*A','AIRPORT','SLC','UTAH','SALT LAKE','SALT LAKE CITY','SALT LAKE CITY INTL','SALT LAKE CITY','CITY AND COUNTY BLDG','40-47-18.2160N','146838.2160N','111-58-39.9840W','403119.9840W','en',1,'Y');
   i('14052.*A','AIRPORT','EWR','NEW JERSEY','ESSEX','NEWARK','NEWARK LIBERTY INTL','PORT AUTHORITY OF NY & NJ','4 WTC 150 GREENWICH ST, 18TH FLOOR','40-41-32.9274N','146492.9274N','074-10-07.2724W','267007.2724W','en',1,'Y');
   i('08456.*A','AIRPORT','BWI','MARYLAND','ANNE ARUNDEL','BALTIMORE','BALTIMORE/WASHINGTON INTL THURGOOD MARSHALL','STATE OF MARYLAND','PO BOX 8766','39-10-32.6220N','141032.6220N','076-40-08.3680W','276008.3680W','en',1,'Y');
   i('02170.*A','AIRPORT','SAN','CALIFORNIA','SAN DIEGO','SAN DIEGO','SAN DIEGO INTL','SAN DIEGO CNTY REG ARPT AUTHORITY','3225 N HARBOR DRIVE','32-44-00.8000N','117840.8000N','117-11-22.8000W','421882.8000W','en',1,'Y');
   i('23097.*A','AIRPORT','MEM','TENNESSEE','SHELBY','MEMPHIS','MEMPHIS INTL','MEMPHIS SHELBY CNTY ARPT AUTH','2491 WINCHESTER RD.','35-02-32.6810N','126152.6810N','089-58-36.0450W','323916.0450W','en',1,'Y');
   i('19571.*A','AIRPORT','PDX','OREGON','MULTNOMAH','PORTLAND','PORTLAND INTL','THE PORT OF PORTLAND','BOX 3529','45-35-19.3519N','164119.3519N','122-35-48.7299W','441348.7299W','en',1,'Y');
   i('23121.*A','AIRPORT','BNA','TENNESSEE','DAVIDSON','NASHVILLE','NASHVILLE INTL','METRO NASHVILLE ARPT AUTH','ONE TERMINAL DR. SUITE 501','36-07-28.1100N','130048.1100N','086-40-41.4500W','312041.4500W','en',1,'Y');
   i('04507.*A','AIRPORT','MDW','ILLINOIS','COOK','CHICAGO','CHICAGO MIDWAY INTL','CITY OF CHICAGO','5700 S. CICERO','41-47-09.5000N','150429.5000N','087-45-08.7000W','315908.7000W','en',1,'Y');
   i('03002.*A','AIRPORT','IAD','DIST. OF COLUMBIA','LOUDOUN','WASHINGTON','WASHINGTON DULLES INTL','METRO WASH ARPT AUTHORITY','1 AVIATION CIRCLE','38-56-50.8000N','140210.8000N','077-27-35.8000W','278855.8000W','en',1,'Y');
   i('03513.*A','AIRPORT','TPA','FLORIDA','HILLSBOROUGH','TAMPA','TAMPA INTL','HILLSBOROUGH CO AVN AUTHORITY','PO BOX 22287','27-58-31.7000N','100711.7000N','082-31-59.7000W','297119.7000W','en',1,'Y');
   i('52161.*A','AIRPORT','HNL','HAWAII','HONOLULU','HONOLULU','DANIEL K INOUYE INTL','STATE OF HAWAII','HONOLULU INTL AIRPORT','21-19-04.1420N','076744.1420N','157-55-12.8190W','568512.8190W','en',1,'Y');
   i('02204.*A','AIRPORT','SJC','CALIFORNIA','SANTA CLARA','SAN JOSE','NORMAN Y MINETA SAN JOSE INTL','CITY OF SAN JOSE','200 E. SANTA CLARA STREET','37-21-46.7810N','134506.7810N','121-55-43.0340W','438943.0340W','en',1,'Y');
   i('23713.*A','AIRPORT','DAL','TEXAS','DALLAS','DALLAS','DALLAS LOVE FLD','CITY OF DALLAS','CITY HALL','32-50-45.4010N','118245.4010N','096-51-03.1560W','348663.1560W','en',1,'Y');
   i('23369.*A','AIRPORT','AUS','TEXAS','TRAVIS','AUSTIN','AUSTIN-BERGSTROM INTL','CITY OF AUSTIN','PO BOX 1088','30-11-40.2980N','108700.2980N','097-40-11.5540W','351611.5540W','en',1,'Y');
   i('07243.*A','AIRPORT','SDF','KENTUCKY','JEFFERSON','LOUISVILLE','LOUISVILLE MUHAMMAD ALI INTL','LOUISVILLE REGIONAL ARPT AUTH','700 ADMINISTRATION DRIVE','38-10-26.7090N','137426.7090N','085-44-11.3960W','308651.3960W','en',1,'Y');
   i('01971.*A','AIRPORT','OAK','CALIFORNIA','ALAMEDA','OAKLAND','METRO OAKLAND INTL','PORT OF OAKLAND','530 WATER ST.','37-43-16.5000N','135796.5000N','122-13-16.1000W','439996.1000W','en',1,'Y');
   i('05375.*A','AIRPORT','IND','INDIANA','MARION','INDIANAPOLIS','INDIANAPOLIS INTL','INDIANAPOLIS AIRPORT AUTH','7800 COL. H. WEIR COOK MEMORIAL DR.','39-43-02.3000N','142982.3000N','086-17-40.7000W','310660.7000W','en',1,'Y');
   i('24071.*A','AIRPORT','HOU','TEXAS','HARRIS','HOUSTON','WILLIAM P HOBBY','CITY OF HOUSTON','16930 JF KENNEDY BLVD','29-38-43.5000N','106723.5000N','095-16-44.0000W','343004.0000W','en',1,'Y');
   i('07675.*A','AIRPORT','MSY','LOUISIANA','JEFFERSON','NEW ORLEANS','LOUIS ARMSTRONG NEW ORLEANS INTL','CITY OF NEW ORLEANS','PO BOX 20007','29-59-35.8000N','107975.8000N','090-15-32.5000W','324932.5000W','en',1,'Y');
   i('12077.*A','AIRPORT','STL','MISSOURI','ST LOUIS','ST LOUIS','ST LOUIS LAMBERT INTL','CITY OF ST LOUIS','1320 MARKET ST.','38-44-55.3100N','139495.3100N','090-22-12.1040W','325332.1040W','en',1,'Y');
   i('07090.*A','AIRPORT','CVG','KENTUCKY','BOONE','COVINGTON','CINCINNATI/NORTHERN KENTUCKY INTL','KENTON COUNTY ARPT BOARD','PO BOX 752000','39-02-55.8120N','140575.8120N','084-40-04.1600W','304804.1600W','en',1,'Y');
   i('17035.*A','AIRPORT','RDU','NORTH CAROLINA','WAKE','RALEIGH/DURHAM','RALEIGH-DURHAM INTL','RALEIGH-DURHAM ARPT AUTH','P.O. BOX 80001','35-52-39.5000N','129159.5000N','078-47-14.9000W','283634.9000W','en',1,'Y');
   i('21252.*A','AIRPORT','PIT','PENNSYLVANIA','ALLEGHENY','PITTSBURGH','PITTSBURGH INTL','ALLEGHENY CO ARPT AUTHORITY','PO BOX 12370, SUITE. 4000','40-29-29.1000N','145769.1000N','080-13-57.7000W','288837.7000W','en',1,'Y');
   i('02124.2*A','AIRPORT','SMF','CALIFORNIA','SACRAMENTO','SACRAMENTO','SACRAMENTO INTL','COUNTY OF SACRAMENTO','6900 AIRPORT BLVD','38-41-43.6000N','139303.6000N','121-35-26.8000W','437726.8000W','en',1,'Y');
   i('50034.*A','AIRPORT','ANC','ALASKA','ANCHORAGE','ANCHORAGE','TED STEVENS ANCHORAGE INTL','STATE OF ALASKA DOTPF','BOX 196960','61-10-26.7050N','220226.7050N','149-59-53.2950W','539993.2950W','en',1,'Y');
   i('24709.*A','AIRPORT','SAT','TEXAS','BEXAR','SAN ANTONIO','SAN ANTONIO INTL','CITY OF SAN ANTONIO','100 MILITARY PLAZA','29-32-02.2500N','106322.2500N','098-28-08.6050W','354488.6050W','en',1,'Y');
   i('02230.*A','AIRPORT','SNA','CALIFORNIA','ORANGE','SANTA ANA','JOHN WAYNE/ORANGE COUNTY','ORANGE COUNTY','3160 AIRWAY AVENUE','33-40-32.4000N','121232.4000N','117-52-05.6000W','424325.6000W','en',1,'Y');
   i('17788.*A','AIRPORT','CMH','OHIO','FRANKLIN','COLUMBUS','JOHN GLENN COLUMBUS INTL','COLUMBUS REGIONAL AIRPORT AUTH','4600 INTERNATIONAL GATEWAY','39-59-49.0080N','143989.0080N','082-53-31.7730W','298411.7730W','en',1,'Y');
   i('11816.6*A','AIRPORT','MCI','MISSOURI','PLATTE','KANSAS CITY','KANSAS CITY INTL','CITY OF KANSAS CITY','601 BRASILIA; PO BOX 20047','39-17-51.4000N','141471.4000N','094-42-50.0000W','340970.0000W','en',1,'Y');
   i('17746.*A','AIRPORT','CLE','OHIO','CUYAHOGA','CLEVELAND','CLEVELAND-HOPKINS INTL','CITY OF CLEVELAND','CLEVELAND HOPKINS INTL, PO BOX 81009','41-24-33.8650N','149073.8650N','081-51-16.8880W','294676.8880W','en',1,'Y');
   i('53180.1*A','AIRPORT','SJU','PUERTO RICO','--PUERTO RICO','SAN JUAN','LUIS MUNOZ MARIN INTL','PUERTO RICO PORTS AUTH','GPO BOX 362829','18-26-21.8370N','066381.8370N','066-00-07.6800W','237607.6800W','en',1,'Y');
   i('01986.*A','AIRPORT','ONT','CALIFORNIA','SAN BERNARDINO','ONTARIO','ONTARIO INTL','ONTARIO INTL AIRPORT AUTHORITY','1923 EAST AVION STREET','34-03-21.6510N','122601.6510N','117-36-04.2750W','423364.2750W','en',1,'Y');
   i('03198.2*A','AIRPORT','RSW','FLORIDA','LEE','FORT MYERS','SOUTHWEST FLORIDA INTL','BOARD OF COM LEE CO PORT AUTH','PO BOX 398','26-32-10.2000N','095530.2000N','081-45-18.6000W','294318.6000W','en',1,'Y');
   i('27388.*A','AIRPORT','MKE','WISCONSIN','MILWAUKEE','MILWAUKEE','GENERAL MITCHELL INTL','MILWAUKEE COUNTY','907 N 10TH ST','42-56-48.9550N','154608.9550N','087-53-49.4320W','316429.4320W','en',1,'Y');
   i('01353.*A','AIRPORT','BUR','CALIFORNIA','LOS ANGELES','BURBANK','BOB HOPE','BURBANK-GLENDALE-PASADENA APT','2627 HOLLYWOOD WAY','34-12-02.5000N','123122.5000N','118-21-31.2000W','426091.2000W','en',1,'Y');
   i('14532.*A','AIRPORT','ABQ','NEW MEXICO','BERNALILLO','ALBUQUERQUE','ALBUQUERQUE INTL SUNPORT','CITY OF ALBUQUERQUE','PO BOX 1293','35-02-20.1536N','126140.1536N','106-36-29.7438W','383789.7438W','en',1,'Y');
   i('03250.1*A','AIRPORT','JAX','FLORIDA','DUVAL','JACKSONVILLE','JACKSONVILLE INTL','JACKSONVILLE INTL AIRPORT','14201 PECAN PARK ROAD','30-29-38.5640N','109778.5640N','081-41-16.2480W','294076.2480W','en',1,'Y');
   i('02946.*A','AIRPORT','BDL','CONNECTICUT','HARTFORD','WINDSOR LOCKS','BRADLEY INTL','CONNECTICUT AIRPORT AUTHORITY','AIRPORT ADMINISTRATION OFFICE, TERMINAL A, 3RD FLOOR','41-56-20.9000N','150980.9000N','072-41-00.1000W','261660.1000W','en',1,'Y');
   i('52240.*A','AIRPORT','OGG','HAWAII','MAUI','KAHULUI','KAHULUI','HAWAII STATE AIRPORTS DIV','HONOLULU INTL ARPT','20-53-55.1350N','075235.1350N','156-25-49.6510W','563149.6510W','en',1,'Y');
   i('12854.*A','AIRPORT','OMA','NEBRASKA','DOUGLAS','OMAHA','EPPLEY AIRFIELD','OMAHA AIRPORT AUTHORITY','4501 ABBOTT DRIVE, SUITE 2300','41-18-11.4000N','148691.4000N','095-53-38.6000W','345218.6000W','en',1,'Y');
   i('14954.*A','AIRPORT','BUF','NEW YORK','ERIE','BUFFALO','BUFFALO NIAGARA INTL','NIAGARA FRONTIER TRAN AUTH','181 ELLICOTT ST, PO BOX 5008','42-56-25.5000N','154585.5000N','078-43-50.1000W','283430.1000W','en',1,'Y');
   i('22174.*A','AIRPORT','CHS','SOUTH CAROLINA','CHARLESTON','CHARLESTON','CHARLESTON AFB/INTL','USAF','JOINT BASE CHARLESTON','32-53-55.1000N','118435.1000N','080-02-25.9000W','288145.9000W','en',1,'Y');
   i('04149.*A','AIRPORT','BOI','IDAHO','ADA','BOISE','BOISE AIR TRML/GOWEN FLD','CITY OF BOISE','PO BOX 500','43-33-51.7000N','156831.7000N','116-13-22.3000W','418402.3000W','en',1,'Y');
   i('19136.*A','AIRPORT','OKC','OKLAHOMA','OKLAHOMA','OKLAHOMA CITY','WILL ROGERS WORLD','OKLAHOMA CITY AIRPORT TRUST','7100 TERMINAL DR; BOX 937','35-23-35.0665N','127415.0665N','097-36-02.7422W','351362.7422W','en',1,'Y');
   i('13123.*A','AIRPORT','RNO','NEVADA','WASHOE','RENO','RENO/TAHOE INTL','RENO-TAHOE AIRPORT AUTHORITY','P O BOX 12490','39-29-56.8000N','142196.8000N','119-46-05.2000W','431165.2000W','en',1,'Y');
   i('26416.*A','AIRPORT','GEG','WASHINGTON','SPOKANE','SPOKANE','SPOKANE INTL','SPOKANE COUNTY-CITY','ARPT BOARD, 9000 W AIRPORT DRIVE','47-37-08.5000N','171428.5000N','117-32-06.8000W','423126.8000W','en',1,'Y');
   i('03555.*A','AIRPORT','PBI','FLORIDA','PALM BEACH','WEST PALM BEACH','PALM BEACH INTL','PALM BEACH COUNTY','846 PALM BEACH INTL AIRPORT','26-40-59.3820N','096059.3820N','080-05-44.1310W','288344.1310W','en',1,'Y');
   i('25977.*A','AIRPORT','RIC','VIRGINIA','HENRICO','RICHMOND','RICHMOND INTL','CAPITAL REGION ARPT COMM.','1 RICHARD E BYRD TERMINAL DR','37-30-18.6520N','135018.6520N','077-19-11.0590W','278351.0590W','en',1,'Y');
   i('23830.*A','AIRPORT','ELP','TEXAS','EL PASO','EL PASO','EL PASO INTL','CITY OF EL PASO','300 N. CAMPBELL','31-48-26.4000N','114506.4000N','106-22-34.9000W','382954.9000W','en',1,'Y');
   i('22024.*A','AIRPORT','PVD','RHODE ISLAND','KENT','PROVIDENCE','THEODORE FRANCIS GREEN STATE','STATE OF RHODE ISLAND','RI AIRPORT CORP, 2000 POST RD','41-43-20.4000N','150200.4000N','071-25-39.8000W','257139.8000W','en',1,'Y');
   i('00816.*A','AIRPORT','TUS','ARIZONA','PIMA','TUCSON','TUCSON INTL','TUCSON AIRPORT AUTHORITY','7250 SOUTH TUCSON BLVD, SUITE 300','32-06-57.8490N','115617.8490N','110-56-27.6500W','399387.6500W','en',1,'Y');
   i('25905.*A','AIRPORT','ORF','VIRGINIA','NORFOLK','NORFOLK','NORFOLK INTL','NORFOLK AIRPORT AUTH','2200 NORVIEW AVE','36-53-40.5750N','132820.5750N','076-12-04.4250W','274324.4250W','en',1,'Y');
   i('05950.*A','AIRPORT','DSM','IOWA','POLK','DES MOINES','DES MOINES INTL','DES MOINES AIRPORT AUTHORITY','5800 FLEUR DRIVE, SUITE 207, ROOM 201','41-32-02.3020N','149522.3020N','093-39-47.0590W','337187.0590W','en',1,'Y');
   i('09852.*A','AIRPORT','GRR','MICHIGAN','KENT','GRAND RAPIDS','GERALD R FORD INTL','GERALD R FORD INTL ARPT AUTH','5500 44TH ST SE','42-52-51.0000N','154371.0000N','085-31-22.1000W','307882.1000W','en',1,'Y');
   i('19283.*A','AIRPORT','TUL','OKLAHOMA','TULSA','TULSA','TULSA INTL','CITY OF TULSA','TULSA ARPT AUTH. BOX 581838','36-11-54.2000N','130314.2000N','095-53-17.2000W','345197.2000W','en',1,'Y');
   i('00164.*A','AIRPORT','BHM','ALABAMA','JEFFERSON','BIRMINGHAM','BIRMINGHAM-SHUTTLESWORTH INTL','BIRMINGHAM AIRPORT AUTHORITY','5900 MESSER AIRPORT HWY','33-33-50.0000N','120830.0000N','086-45-08.3000W','312308.3000W','en',1,'Y');
   i('50320.*A','AIRPORT','HOM','ALASKA','KENAI PENINSULA','HOMER','HOMER','ALASKA DOT&PF CENTRAL REGION','PO BOX 196900','59-38-41.9819N','214721.9819N','151-29-08.9103W','545348.9103W','en',1,'Y');
   i('52250.2*A','AIRPORT','KOA','HAWAII','HAWAII','KAILUA/KONA','ELLISON ONIZUKA KONA INTL AT KEAHOLE','HAWAII ST ARPTS DIV','HONOLULU INTL ARPT','19-44-19.5570N','071059.5570N','156-02-44.2730W','561764.2730W','en',1,'Y');
   i('20503.*A','AIRPORT','MDT','PENNSYLVANIA','DAUPHIN','HARRISBURG','HARRISBURG INTL','SUSQUEHANNA AREA REGIONAL ARPT AUTH','ONE TERMINAL DRIVE','40-11-35.4864N','144695.4864N','076-45-45.4342W','276345.4342W','en',1,'Y');
   i('52420.*A','AIRPORT','LIH','HAWAII','KAUAI','LIHUE','LIHUE','HAWAII ST ARPTS DIV','HONOLULU INTL ARPT','21-58-33.5400N','079113.5400N','159-20-20.2480W','573620.2480W','en',1,'Y');
   i('16269.*A','AIRPORT','SYR','NEW YORK','ONONDAGA','SYRACUSE','SYRACUSE HANCOCK INTL','CITY OF SYRACUSE','CITY HALL','43-06-40.3000N','155200.3000N','076-06-22.7000W','273982.7000W','en',1,'Y');
   i('16758.*A','AIRPORT','GSO','NORTH CAROLINA','GUILFORD','GREENSBORO','PIEDMONT TRIAD INTL','PIEDMONT TRIAD ARPT AUTH.','1000A TED JOHNSON PKWY','36-06-04.7760N','129964.7760N','079-56-28.0420W','287788.0420W','en',1,'Y');
   i('03992.*A','AIRPORT','SAV','GEORGIA','CHATHAM','SAVANNAH','SAVANNAH/HILTON HEAD INTL','SAVANNAH AIRPORT COMMISSION','400 AIRWAYS AVE.','32-07-39.3000N','115659.3000N','081-12-07.7000W','292327.7000W','en',1,'Y');
   i('01794.*A','AIRPORT','LGB','CALIFORNIA','LOS ANGELES','LONG BEACH','LONG BEACH /DAUGHERTY FLD/','CITY OF LONG BEACH','CITY HALL 333 W. OCEAN','33-49-04.5470N','121744.5470N','118-09-06.8060W','425346.8060W','en',1,'Y');
   i('01056.*A','AIRPORT','LIT','ARKANSAS','PULASKI','LITTLE ROCK','BILL AND HILLARY CLINTON NTL/ADAMS FLD','CITY OF LITTLE ROCK','1 AIRPORT DRIVE','34-43-46.0000N','125026.0000N','092-13-29.2000W','332009.2000W','en',1,'Y');
   i('14789.*A','AIRPORT','ALB','NEW YORK','ALBANY','ALBANY','ALBANY INTL','ALBANY COUNTY ARPT AUTH','737 ALBANY SHAKER ROAD','42-44-56.8180N','153896.8180N','073-48-07.1280W','265687.1280W','en',1,'Y');
   i('51510.*A','AIRPORT','GUM','GUAM','GUAM','GUAM','GUAM INTL','A.B. WON PAT GUAM INT''L ARPT AUTHOR','P.O. BOX 8770','13-29-02.2224N','048542.2224N','144-47-49.6576E','521269.6576E','en',1,'Y');
   i('22444.*A','AIRPORT','MYR','SOUTH CAROLINA','HORRY','MYRTLE BEACH','MYRTLE BEACH INTL','HORRY COUNTY','P O BOX 1236','33-40-47.0680N','121247.0680N','078-55-41.9570W','284141.9570W','en',1,'Y');
   i('03407.1*A','AIRPORT','SFB','FLORIDA','SEMINOLE','ORLANDO','ORLANDO SANFORD INTL','SANFORD ARPT AUTHORITY','1200 RED CLEVELAND BLVD, SUITE #200','28-46-37.8410N','103597.8410N','081-14-05.6900W','292445.6900W','en',1,'Y');
   i('16034.*A','AIRPORT','ROC','NEW YORK','MONROE','ROCHESTER','FREDERICK DOUGLASS - GREATER ROCHESTER INTL','COUNTY OF MONROE','COUNTY OFFICE BLDG','43-07-08.9170N','155228.9170N','077-40-18.7280W','279618.7280W','en',1,'Y');
   i('23046.*A','AIRPORT','TYS','TENNESSEE','BLOUNT','KNOXVILLE','MC GHEE TYSON','METRO KNOXVILLE ARPT AUTH','MC GHEE TYSON AIRPORT, 2055 ALCOA HWY','35-48-33.7459N','128913.7459N','083-59-43.1572W','302383.1572W','en',1,'Y');
   i('02017.*A','AIRPORT','PSP','CALIFORNIA','RIVERSIDE','PALM SPRINGS','PALM SPRINGS INTL','CITY OF PALM SPRINGS','3400 E. TAHQUITZ CANYON WAY','33-49-46.8000N','121786.8000N','116-30-24.1000W','419424.1000W','en',1,'Y');
   i('01591.*A','AIRPORT','FAT','CALIFORNIA','FRESNO','FRESNO','FRESNO YOSEMITE INTL','CITY OF FRESNO','4995 E CLINTON WAY','36-46-35.6000N','132395.6000N','119-43-07.8000W','430987.8000W','en',1,'Y');
   i('13332.*A','AIRPORT','MHT','NEW HAMPSHIRE','HILLSBOROUGH','MANCHESTER','MANCHESTER','CITY OF MANCHESTER','CITY HALL','42-55-58.1000N','154558.1000N','071-26-08.7000W','257168.7000W','en',1,'Y');
   i('22316.1*A','AIRPORT','GSP','SOUTH CAROLINA','GREENVILLE','GREER','GREENVILLE SPARTANBURG INTL','GREENVILLE-SPARTANBURG ACMSN','2000 GSP DRIVE, SUITE 1','34-53-44.4160N','125624.4160N','082-13-07.8940W','295987.8940W','en',1,'Y');
   i('08215.*A','AIRPORT','PWM','MAINE','CUMBERLAND','PORTLAND','PORTLAND INTL JETPORT','CITY OF PORTLAND','CITY HALL, 389 CONGRESS ST','43-38-44.3166N','157124.3166N','070-18-31.0189W','253111.0189W','en',1,'Y');
   i('17818.*A','AIRPORT','DAY','OHIO','MONTGOMERY','DAYTON','JAMES M COX DAYTON INTL','CITY OF DAYTON, OHIO','101 W 3RD ST','39-54-08.1000N','143648.1000N','084-13-09.9000W','303189.9000W','en',1,'Y');
   i('04974.*A','AIRPORT','RFD','ILLINOIS','WINNEBAGO','CHICAGO/ROCKFORD','CHICAGO/ROCKFORD INTL','GREATER ROCKFORD ARPT. AUTH.','60 ARPT DRIVE','42-11-43.3000N','151903.3000N','089-05-50.0000W','320750.0000W','en',1,'Y');
   i('03435.*A','AIRPORT','PNS','FLORIDA','ESCAMBIA','PENSACOLA','PENSACOLA INTL','CITY OF PENSACOLA','2430 AIRPORT BLVD SUITE 225','30-28-24.3000N','109704.3000N','087-11-11.8000W','313871.8000W','en',1,'Y');
   i('00975.01*A','AIRPORT','XNA','ARKANSAS','BENTON','FAYETTEVILLE/SPRINGDALE/ROGERS','NORTHWEST ARKANSAS NTL','NW ARKANSAS RGNL ARPT AUTH.','1 AIRPORT BLVD, SUITE 100','36-16-53.6850N','130613.6850N','094-18-27.9560W','339507.9560W','en',1,'Y');
   i('03484.*A','AIRPORT','SRQ','FLORIDA','SARASOTA','SARASOTA/BRADENTON','SARASOTA/BRADENTON INTL','SARASOTA MANATEE ARPT AUTHORITY','6000 AIRPORT CIRCLE','27-23-43.6000N','098623.6000N','082-33-15.8000W','297195.8000W','en',1,'Y');
   i('19673.*A','AIRPORT','ABE','PENNSYLVANIA','LEHIGH','ALLENTOWN','LEHIGH VALLEY INTL','LEHIGH NORTHAMPTON A AUTH','3311 AIRPORT RD','40-39-08.5060N','146348.5060N','075-26-25.4610W','271585.4610W','en',1,'Y');
   i('22789.*A','AIRPORT','FSD','SOUTH DAKOTA','MINNEHAHA','SIOUX FALLS','JOE FOSS FLD','SIOUX FALLS REGNL ARPT AUTH','2801 JAYCEE LANE','43-34-55.2480N','156895.2480N','096-44-30.8990W','348270.8990W','en',1,'Y');
   i('11280.*A','AIRPORT','JAN','MISSISSIPPI','RANKIN','JACKSON','JACKSON-MEDGAR WILEY EVERS INTL','CITY OF JACKSON','P.O. BOX 98109','32-18-40.2000N','116320.2000N','090-04-33.2000W','324273.2000W','en',1,'Y');
   i('02517.*A','AIRPORT','ASE','COLORADO','PITKIN','ASPEN','ASPEN-PITKIN COUNTY/SARDY FLD','PITKIN COUNTY','506 E MAIN','39-13-18.8000N','141198.8000N','106-52-05.6000W','384725.6000W','en',1,'Y');
   i('10379.*A','AIRPORT','TVC','MICHIGAN','GRAND TRAVERSE','TRAVERSE CITY','CHERRY CAPITAL','GRAND TRAVERSE & LEELANAU CO','NORTHWESTERN RGNL ARPT CMSN, 727 FLY DONT DR','44-44-29.7000N','161069.7000N','085-34-54.7000W','308094.7000W','en',1,'Y');
   i('19514.*A','AIRPORT','MFR','OREGON','JACKSON','MEDFORD','ROGUE VALLEY INTL - MEDFORD','JACKSON COUNTY','CO COURT HOUSE; 10 SO OAKDALE','42-22-29.8730N','152549.8730N','122-52-23.8350W','442343.8350W','en',1,'Y');
   i('15783.*A','AIRPORT','ISP','NEW YORK','SUFFOLK','NEW YORK','LONG ISLAND MAC ARTHUR','TOWN OF ISLIP','655 MAIN ST','40-47-46.0885N','146866.0885N','073-06-02.3942W','263162.3942W','en',1,'Y');
   i('03455.*A','AIRPORT','PGD','FLORIDA','CHARLOTTE','PUNTA GORDA','PUNTA GORDA','CHARLOTTE COUNTY ARPT AUTH','28000 A-1 AIRPORT RD','26-55-06.9000N','096906.9000N','081-59-27.2000W','295167.2000W','en',1,'Y');
   i('50219.*A','AIRPORT','FAI','ALASKA','FAIRBANKS NORTH STAR','FAIRBANKS','FAIRBANKS INTL','STATE OF ALASKA DOTPF','6450 AIRPORT WAY - SUITE 1','64-48-54.4000N','233334.4000N','147-51-23.2000W','532283.2000W','en',1,'Y');
   i('19580.*A','AIRPORT','RDM','OREGON','DESCHUTES','REDMOND','ROBERTS FLD','CITY OF REDMOND','411 SW 9TH STREET','44-15-14.6480N','159314.6480N','121-08-59.8970W','436139.8970W','en',1,'Y');
   i('27346.*A','AIRPORT','MSN','WISCONSIN','DANE','MADISON','DANE COUNTY RGNL-TRUAX FLD','DANE COUNTY','4000 INTERNATIONAL LANE','43-08-23.5649N','155303.5649N','089-20-15.0161W','321615.0161W','en',1,'Y');
   i('00841.*A','AIRPORT','NYL','ARIZONA','YUMA','YUMA','YUMA MCAS/YUMA INTL','USMC & YUMA CO ARPT AUTH','2356 E O''NEILL ST, BLDG 153','32-39-23.6660N','117563.6660N','114-36-21.5540W','412581.5540W','en',1,'Y');
   i('22209.*A','AIRPORT','CAE','SOUTH CAROLINA','LEXINGTON','COLUMBIA','COLUMBIA METRO','RICHLAND LEXINGTON','3250 AIRPORT BLVD, SUITE 10','33-56-19.8160N','122179.8160N','081-07-10.3300W','292030.3300W','en',1,'Y');
   i('06975.4*A','AIRPORT','ICT','KANSAS','SEDGWICK','WICHITA','WICHITA DWIGHT D EISENHOWER NTL','WICHITA AIRPORT AUTHORITY','2173 AIR CARGO ROAD','37-38-59.8000N','135539.8000N','097-25-59.0000W','350759.0000W','en',1,'Y');
   i('03534.*A','AIRPORT','VPS','FLORIDA','OKALOOSA','VALPARAISO/DESTIN-FT WALTON BEACH','EGLIN AFB/DESTIN-FT WALTON BEACH','USAF','DEPT OF THE AF HDQRTS AFMC','30-28-59.5899N','109739.5899N','086-31-33.7596W','311493.7596W','en',1,'Y');
   i('03263.*A','AIRPORT','EYW','FLORIDA','MONROE','KEY WEST','KEY WEST INTL','MONROE COUNTY','3491 S ROOSEVELT BLVD','24-33-22.0310N','088402.0310N','081-45-35.8410W','294335.8410W','en',1,'Y');
   i('24353.*A','AIRPORT','MAF','TEXAS','MIDLAND','MIDLAND','MIDLAND INTL AIR AND SPACE PORT','CITY OF MIDLAND','PO BOX 1152','31-56-33.1000N','114993.1000N','102-12-06.9000W','367926.9000W','en',1,'Y');
   i('52095.*A','AIRPORT','ITO','HAWAII','HAWAII','HILO','HILO INTL','STATE OF HAWAII ARPT DIV DOT','HONOLULU INTL ARPT','19-43-12.9468N','070992.9468N','155-02-54.4925W','558174.4925W','en',1,'Y');
   i('03475.*A','AIRPORT','PIE','FLORIDA','PINELLAS','ST PETERSBURG-CLEARWATER','ST PETE-CLEARWATER INTL','COUNTY OF PINELLAS','ST. PETE-CLEARWATER INTERNATIONAL, TERMINAL BLVD. SUITE 221','27-54-31.0810N','100471.0810N','082-41-11.4360W','297671.4360W','en',1,'Y');
   i('00385.1*A','AIRPORT','HSV','ALABAMA','MADISON','HUNTSVILLE','HUNTSVILLE INTL-CARL T JONES FLD','HUNTSVILLE MADISON COUNTY','1000 GLENN HEARN BLVD,','34-38-13.9090N','124693.9090N','086-46-30.1950W','312390.1950W','en',1,'Y');
   i('17786.*A','AIRPORT','LCK','OHIO','FRANKLIN','COLUMBUS','RICKENBACKER INTL','COLUMBUS RGNL AIRPORT AUTHORITY','4600 INTERNATIONAL GTWY','39-48-49.6000N','143329.6000N','082-55-40.1000W','298540.1000W','en',1,'Y');
   i('25385.*A','AIRPORT','BTV','VERMONT','CHITTENDEN','BURLINGTON','BURLINGTON INTL','CITY OF BURLINGTON','CITY HALL','44-28-19.0380N','160099.0380N','073-09-11.7940W','263351.7940W','en',1,'Y');
   i('10950.1*A','AIRPORT','RST','MINNESOTA','OLMSTED','ROCHESTER','ROCHESTER INTL','CITY OF ROCHESTER','CITY HALL','43-54-29.8000N','158069.8000N','092-30-00.1000W','333000.1000W','en',1,'Y');
   i('02543.*A','AIRPORT','COS','COLORADO','EL PASO','COLORADO SPRINGS','CITY OF COLORADO SPRINGS MUNI','CITY OF COLORADO SPRINGS','7770 MILTON E PROBY PKWY, SUITE 50','38-48-20.9270N','139700.9270N','104-42-02.7890W','376922.7890W','en',1,'Y');
   i('12278.*A','AIRPORT','BZN','MONTANA','GALLATIN','BOZEMAN','BOZEMAN YELLOWSTONE INTL','GALLATIN AIRPORT AUTHORITY','850 GALLATIN FIELD SUITE 6','45-46-38.0488N','164798.0488N','111-09-00.9370W','400140.9370W','en',1,'Y');
   i('23882.2*A','AIRPORT','GRK','TEXAS','BELL','FORT HOOD/KILLEEN','ROBERT GRAY AAF','US ARMY AERONAUTICAL SVCS AGENCY',null,'31-04-02.1000N','111842.1000N','097-49-44.1000W','352184.1000W','en',1,'Y');
   i('16517.5*A','AIRPORT','AVL','NORTH CAROLINA','BUNCOMBE','ASHEVILLE','ASHEVILLE RGNL','GREATER ASHEVILLE RGNL ARPT AUTH.','61 TERMINAL DR SUITE 1','35-26-09.9980N','127569.9980N','082-32-31.3700W','297151.3700W','en',1,'Y');
   i('24245.*A','AIRPORT','LBB','TEXAS','LUBBOCK','LUBBOCK','LUBBOCK PRESTON SMITH INTL','CITY OF LUBBOCK','PO BOX 2000','33-39-49.2000N','121189.2000N','101-49-14.0000W','366554.0000W','en',1,'Y');
   i('05884.*A','AIRPORT','CID','IOWA','LINN','CEDAR RAPIDS','THE EASTERN IOWA','CITY OF CEDAR RAPIDS','101 FIRST STREET SE','41-53-04.8789N','150784.8789N','091-42-38.8750W','330158.8750W','en',1,'Y');
   i('00753.*A','AIRPORT','IWA','ARIZONA','MARICOPA','PHOENIX','PHOENIX-MESA GATEWAY','PHX MESA GATEWAY AIRPORT AUTHORITY','5835 S. SOSSAMAN RD','33-18-28.1660N','119908.1660N','111-39-19.6530W','401959.6530W','en',1,'Y');
   i('07425.*A','AIRPORT','BTR','LOUISIANA','EAST BATON ROUGE','BATON ROUGE','BATON ROUGE METRO, RYAN FLD','EAST BATON ROUGE PARISH','PO BOX 1471','30-31-58.5000N','109918.5000N','091-08-59.6000W','328139.6000W','en',1,'Y');
   i('03430.3*A','AIRPORT','ECP','FLORIDA','BAY','PANAMA CITY','NORTHWEST FLORIDA BEACHES INTL','PANAMA CITY-BAY CO ARPT & INDST DIS','6300 WEST BAY PARKWAY','30-21-29.7000N','109289.7000N','085-47-44.2000W','308864.2000W','en',1,'Y');
   i('12265.*A','AIRPORT','BIL','MONTANA','YELLOWSTONE','BILLINGS','BILLINGS LOGAN INTL','CITY OF BILLINGS','CITY HALL','45-48-28.2569N','164908.2569N','108-32-36.7568W','390756.7568W','en',1,'Y');
   i('17328.*A','AIRPORT','FAR','NORTH DAKOTA','CASS','FARGO','HECTOR INTL','MUNI ARPT AUTH OF THE CITY OF FARGO','PO BOX 2845','46-55-14.3000N','168914.3000N','096-48-56.7000W','348536.7000W','en',1,'Y');
   i('26396.*A','AIRPORT','BFI','WASHINGTON','KING','SEATTLE','BOEING FLD/KING COUNTY INTL','KING COUNTY','516 THIRD AVE','47-31-47.9000N','171107.9000N','122-18-07.0000W','440287.0000W','en',1,'Y');
   i('16433.*A','AIRPORT','HPN','NEW YORK','WESTCHESTER','WHITE PLAINS','WESTCHESTER COUNTY','COUNTY OF WESTCHESTER','COUNTY OFFICE BLDG','41-04-01.0310N','147841.0310N','073-42-27.2380W','265347.2380W','en',1,'Y');
   i('50385.*A','AIRPORT','JNU','ALASKA','JUNEAU','JUNEAU','JUNEAU INTL','CITY OF JUNEAU','155 S SEWARD','58-21-16.9625N','210076.9625N','134-34-42.4939W','484482.4939W','en',1,'Y');
   i('24260.*A','AIRPORT','MFE','TEXAS','HIDALGO','MC ALLEN','MC ALLEN MILLER INTL','CITY OF MC ALLEN','P O BOX 220','26-10-33.0000N','094233.0000N','098-14-19.0000W','353659.0000W','en',1,'Y');
   i('07233.*A','AIRPORT','LEX','KENTUCKY','FAYETTE','LEXINGTON','BLUE GRASS','LEXINGTON-FAYETTE CO ARPT BRD','4000 TERMINAL DRIVE, SUITE 206','38-02-12.3000N','136932.3000N','084-36-31.1000W','304591.1000W','en',1,'Y');
   i('16723.*A','AIRPORT','FAY','NORTH CAROLINA','CUMBERLAND','FAYETTEVILLE','FAYETTEVILLE RGNL/GRANNIS FLD','CITY OF FAYETTEVILLE','400 AIRPORT RD SUITE 1','34-59-28.4000N','125968.4000N','078-52-49.0000W','283969.0000W','en',1,'Y');
   i('26345.*A','AIRPORT','PSC','WASHINGTON','FRANKLIN','PASCO','TRI-CITIES','PORT OF PASCO','3601 N 20TH AVE','46-15-52.8540N','166552.8540N','119-07-08.4860W','428828.4860W','en',1,'Y');
   i('03509.1*A','AIRPORT','TLH','FLORIDA','LEON','TALLAHASSEE','TALLAHASSEE INTL','CITY OF TALLAHASSEE','CITY HALL','30-23-48.3150N','109428.3150N','084-21-03.1280W','303663.1280W','en',1,'Y');
   i('07735.*A','AIRPORT','SHV','LOUISIANA','CADDO','SHREVEPORT','SHREVEPORT RGNL','CITY OF SHREVEPORT','505 TRAVIS STREET','32-26-47.5000N','116807.5000N','093-49-33.7000W','337773.7000W','en',1,'Y');
   i('12138.*A','AIRPORT','SGF','MISSOURI','GREENE','SPRINGFIELD','SPRINGFIELD-BRANSON NTL','CITY OF SPRINGFIELD','2300 N AIRPORT BLVD, SUITE 100','37-14-44.4000N','134084.4000N','093-23-19.1000W','336199.1000W','en',1,'Y');
   i('19434.*A','AIRPORT','EUG','OREGON','LANE','EUGENE','MAHLON SWEET FLD','CITY OF EUGENE','125 E. 8TH','44-07-28.5000N','158848.5000N','123-12-43.1000W','443563.1000W','en',1,'Y');
   i('17211.*A','AIRPORT','ILM','NORTH CAROLINA','NEW HANOVER','WILMINGTON','WILMINGTON INTL','NEW HANOVER COUNTY','1740 AIRPORT BLVD','34-16-16.1000N','123376.1000N','077-54-10.4000W','280450.4000W','en',1,'Y');
   i('22899.*A','AIRPORT','CHA','TENNESSEE','HAMILTON','CHATTANOOGA','LOVELL FLD','CHATTANOOGA METRO ARPT AUTH','1001 AIRPORT ROAD, SUITE 14','35-02-06.7000N','126126.7000N','085-12-12.8000W','306732.8000W','en',1,'Y');
   i('51525.*A','AIRPORT','PPG','AMERICAN SAMOA','AMERICAN SAMOA','PAGO PAGO','PAGO PAGO INTL','GOVT OF AMERICAN SAMOA','DEPT OF PORT ADMIN, BOX 1539','14-19-53.9840S','051593.9840S','170-42-41.4110W','614561.4110W','en',1,'Y');
   i('12794.*A','AIRPORT','LNK','NEBRASKA','LANCASTER','LINCOLN','LINCOLN','LINCOLN ARPT AUTH','BOX 80407','40-51-03.2000N','147063.2000N','096-45-32.8000W','348332.8000W','en',1,'Y');
   i('05282.*A','AIRPORT','FWA','INDIANA','ALLEN','FORT WAYNE','FORT WAYNE INTL','FT WAYNE/ALLEN CO ARPT AUTH','3801 WEST FERGUSON ROAD, SUITE 209','40-58-42.5000N','147522.5000N','085-11-42.6000W','306702.6000W','en',1,'Y');
   i('12453.*A','AIRPORT','MSO','MONTANA','MISSOULA','MISSOULA','MISSOULA INTL','MISSOULA CTY ARPT AUTH','5225 HIGHWAY 10 WEST','46-54-58.7000N','168898.7000N','114-05-26.0000W','410726.0000W','en',1,'Y');
   i('53085.1*A','AIRPORT','VQS','PUERTO RICO','--PUERTO RICO','ISLA DE VIEQUES','ANTONIO RIVERA RODRIGUEZ','PUERTO RICO PORTS AUTH','HC-01 BOX 9421','18-08-05.3200N','065285.3200N','065-29-37.0200W','235777.0200W','en',1,'Y');
   i('24012.*A','AIRPORT','HRL','TEXAS','CAMERON','HARLINGEN','VALLEY INTL','CITY OF HARLINGEN','PO BOX 2207','26-13-37.6000N','094417.6000N','097-39-18.5000W','351558.5000W','en',1,'Y');
   i('23895.3*A','AIRPORT','AFW','TEXAS','TARRANT','FORT WORTH','FORT WORTH ALLIANCE','CITY OF FORT WORTH','1000 THROCKMORTON','32-59-25.3890N','118765.3890N','097-19-09.9860W','350349.9860W','en',1,'Y');
   i('23657.2*A','AIRPORT','CRP','TEXAS','NUECES','CORPUS CHRISTI','CORPUS CHRISTI INTL','CITY OF CORPUS CHRISTI','1201 LEOPARD ST','27-46-19.9000N','099979.9000N','097-30-08.7000W','351008.7000W','en',1,'Y');
   i('26307.*A','AIRPORT','MWH','WASHINGTON','GRANT','MOSES LAKE','GRANT COUNTY INTL','PORT OF MOSES LAKE','7810 ANDREWS STREET NE','47-12-30.9000N','169950.9000N','119-19-08.9000W','429548.9000W','en',1,'Y');
   i('27813.*A','AIRPORT','JAC','WYOMING','TETON','JACKSON','JACKSON HOLE','JACKSON HOLE AIRPORT BOARD','P. O. BOX 159','43-36-26.4000N','156986.4000N','110-44-15.9000W','398655.9000W','en',1,'Y');
   i('02235.*A','AIRPORT','SBA','CALIFORNIA','SANTA BARBARA','SANTA BARBARA','SANTA BARBARA MUNI','CITY OF SANTA BARBARA','CITY HALL','34-25-34.2889N','123934.2889N','119-50-29.3737W','431429.3737W','en',1,'Y');
   i('27234.*A','AIRPORT','GRB','WISCONSIN','BROWN','GREEN BAY','GREEN BAY-AUSTIN STRAUBEL INTL','BROWN COUNTY','2077 AIRPORT DRIVE, STE #18','44-29-04.6810N','160144.6810N','088-07-46.9680W','317266.9680W','en',1,'Y');
   i('13487.*A','AIRPORT','ACY','NEW JERSEY','ATLANTIC','ATLANTIC CITY','ATLANTIC CITY INTL','SOUTH JERSEY TRANSPORTATION AUTH.','SUITE 106','39-27-27.3000N','142047.3000N','074-34-37.8000W','268477.8000W','en',1,'Y');
   i('23328.*A','AIRPORT','AMA','TEXAS','POTTER','AMARILLO','RICK HUSBAND AMARILLO INTL','CITY OF AMARILLO','PO BOX 1971','35-13-09.7000N','126789.7000N','101-42-21.3000W','366141.3000W','en',1,'Y');
   i('12418.*A','AIRPORT','GPI','MONTANA','FLATHEAD','KALISPELL','GLACIER PARK INTL','FLATHEAD MUNI ARPT AUTHORITY','4170 HWY 2','48-18-37.8000N','173917.8000N','114-15-21.6000W','411321.6000W','en',1,'Y');
   i('11253.*A','AIRPORT','GPT','MISSISSIPPI','HARRISON','GULFPORT','GULFPORT-BILOXI INTL','GULFPORT-BILOXI RGNL APT AUTH','14035-L AIRPORT RD','30-24-26.1690N','109466.1690N','089-04-12.3450W','320652.3450W','en',1,'Y');
   i('02260.*A','AIRPORT','STS','CALIFORNIA','SONOMA','SANTA ROSA','CHARLES M SCHULZ - SONOMA COUNTY','SONOMA COUNTY','2290 AIRPORT BLVD','38-30-34.9000N','138634.9000N','122-48-46.4000W','442126.4000W','en',1,'Y');
   i('22329.51*A','AIRPORT','SC17','SOUTH CAROLINA','ORANGEBURG','HOLLY HILL','RUSSELL','J M RUSSELL, III','6640 OLD STATE RD','33-21-28.5840N','120088.5840N','080-27-35.3310W','289655.3310W','en',1,'Y');
   i('03147.*A','AIRPORT','DAB','FLORIDA','VOLUSIA','DAYTONA BEACH','DAYTONA BEACH INTL','VOLUSIA COUNTY','123 W INDIANA AVE','29-10-47.7000N','105047.7000N','081-03-29.0000W','291809.0000W','en',1,'Y');
   i('02692.*A','AIRPORT','MTJ','COLORADO','MONTROSE','MONTROSE','MONTROSE RGNL','MONTROSE COUNTY','161 S. TOWNSEND','38-30-35.3000N','138635.3000N','107-53-39.3000W','388419.3000W','en',1,'Y');
   i('25666.*A','AIRPORT','CHO','VIRGINIA','ALBEMARLE','CHARLOTTESVILLE','CHARLOTTESVILLE-ALBEMARLE','CHRLTSVL-ALBMRL ARPT AUTH','100 BOWEN LOOP, SUITE 200','38-08-22.7140N','137302.7140N','078-27-08.4390W','282428.4390W','en',1,'Y');
   commit;
  end;
  /
  declare
    procedure i (
      p_common_name     in varchar2,
      p_domain          in varchar2,
      p_kingdom         in varchar2,
      p_phylum          in varchar2,
      p_class           in varchar2,
      p_the_order       in varchar2,
      p_family          in varchar2,
      p_genus           in varchar2,
      p_species         in varchar2,
      p_lang            in varchar2,
      p_version_number  in number,
      p_seeded_data_yn  in varchar2
    )
    is
    begin
      insert into wwv_dg_builtin_animals (common_name,domain,kingdom,phylum,class,the_order,family,genus,species,lang,version_number,seeded_data_yn)
      values (p_common_name, p_domain, p_kingdom, p_phylum, p_class, p_the_order, p_family, p_genus, p_species, p_lang, p_version_number,p_seeded_data_yn);
    end i;
  begin
   i('White-Necked Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pyrrhura',null,'en',1,'Y');
   i('Variable Eggfly',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Nymphalidae','Hypolimnas',null,'en',1,'Y');
   i('Tristan Thrush',null,'Eukaryota','Chordata','Aves','Passeriformes','Muscicapidae','Nesocichla',null,'en',1,'Y');
   i('Thinface Cichlid',null,'Eukaryota','Chordata','Actinopteri','Cichliformes','Cichlidae','Serranochromis',null,'en',1,'Y');
   i('Sunda Thrush',null,'Eukaryota','Chordata','Aves','Passeriformes','Turdidae','Zoothera',null,'en',1,'Y');
   i('Sunda Stink Badger',null,'Eukaryota','Chordata','Mammalia','Carnivora','Mephitidae','Mydaus',null,'en',1,'Y');
   i('Sulphur-Winged Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pyrrhura',null,'en',1,'Y');
   i('Striped Catfish',null,'Eukaryota','Chordata','Actinopteri','Siluriformes','Pangasiidae','Pangasianodon',null,'en',1,'Y');
   i('Sri Lanka Bug-Eyed Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Rhacophoridae','Pseudophilautus',null,'en',1,'Y');
   i('Spotless Anglewing',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Nymphalidae','Nymphalis',null,'en',1,'Y');
   i('Selous''S Mongoose',null,'Eukaryota','Chordata','Mammalia','Carnivora','Herpestidae','Paracynictis',null,'en',1,'Y');
   i('Santarem Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pyrrhura',null,'en',1,'Y');
   i('Russet-Tailed Thrush',null,'Eukaryota','Chordata','Aves','Passeriformes','Turdidae','Zoothera',null,'en',1,'Y');
   i('Rufous-Bellied Thrush',null,'Eukaryota','Chordata','Aves','Passeriformes','Turdidae','Turdus',null,'en',1,'Y');
   i('Red-Crowned Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pyrrhura',null,'en',1,'Y');
   i('Red Spot Diadem',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Nymphalidae','Hypolimnas',null,'en',1,'Y');
   i('Pearly Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pyrrhura',null,'en',1,'Y');
   i('Orissa Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Dicroglossidae','Fejervarya',null,'en',1,'Y');
   i('Orange Oakleaf',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Nymphalidae','Kallima',null,'en',1,'Y');
   i('Orange Ground-Thrush',null,'Eukaryota','Chordata','Aves','Passeriformes','Turdidae','Zoothera',null,'en',1,'Y');
   i('Operculina Cumingii (Carpenter, 1860)',null,'Eukaryota','Foraminifera',null,'Rotaliida','Nummulitidae','Operculina',null,'en',1,'Y');
   i('Northern White-Crowned Tapaculo',null,'Eukaryota','Chordata','Aves','Passeriformes','Rhinocryptidae','Scytalopus',null,'en',1,'Y');
   i('New Britain Thrush',null,'Eukaryota','Chordata','Aves','Passeriformes','Turdidae','Zoothera',null,'en',1,'Y');
   i('Mountain Bluebird',null,'Eukaryota','Chordata','Aves','Passeriformes','Turdidae','Sialia',null,'en',1,'Y');
   i('Matorral Tapaculo',null,'Eukaryota','Chordata','Aves','Passeriformes','Rhinocryptidae','Scytalopus',null,'en',1,'Y');
   i('Maroon-Faced Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pyrrhura',null,'en',1,'Y');
   i('Long-Tailed Thrush',null,'Eukaryota','Chordata','Aves','Passeriformes','Turdidae','Zoothera',null,'en',1,'Y');
   i('Long-Tailed Tapaculo',null,'Eukaryota','Chordata','Aves','Passeriformes','Rhinocryptidae','Scytalopus',null,'en',1,'Y');
   i('Karin Hills Bushfrog',null,'Eukaryota','Chordata','Amphibia','Anura','Rhacophoridae','Gracixalus',null,'en',1,'Y');
   i('Javan Slow Loris',null,'Eukaryota','Chordata','Mammalia','Primates','Lorisidae','Nycticebus',null,'en',1,'Y');
   i('Inger''S Bubble-Nest Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Rhacophoridae','Philautus',null,'en',1,'Y');
   i('Humpback Largemouth',null,'Eukaryota','Chordata','Actinopteri','Cichliformes','Cichlidae','Serranochromis',null,'en',1,'Y');
   i('Groundscraper Thrush',null,'Eukaryota','Chordata','Aves','Passeriformes','Muscicapidae','Psophocichla',null,'en',1,'Y');
   i('Greenish Yellow Bat',null,'Eukaryota','Chordata','Mammalia','Chiroptera','Vespertilionidae','Scotophilus',null,'en',1,'Y');
   i('Green-Cheeked Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pyrrhura',null,'en',1,'Y');
   i('Green Oak Leaf Roller',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Tortricidae','Tortrix',null,'en',1,'Y');
   i('Green Cochoa',null,'Eukaryota','Chordata','Aves','Passeriformes','Muscicapidae','Cochoa',null,'en',1,'Y');
   i('Great Thrush',null,'Eukaryota','Chordata','Aves','Passeriformes','Turdidae','Turdus',null,'en',1,'Y');
   i('Gray-Breasted Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pyrrhura',null,'en',1,'Y');
   i('Glass Catfish',null,'Eukaryota','Chordata','Actinopteri','Siluriformes','Siluridae','Kryptopterus',null,'en',1,'Y');
   i('Escherich''S Killifish',null,'Eukaryota','Chordata','Actinopteri','Cyprinodontiformes','Nothobranchiidae','Aphyosemion',null,'en',1,'Y');
   i('Emma''S Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pyrrhura',null,'en',1,'Y');
   i('Elephantnose Cichlid',null,'Eukaryota','Chordata','Actinopteri','Cichliformes','Cichlidae','Nimbochromis',null,'en',1,'Y');
   i('Darker Commodore',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Nymphalidae','Precis',null,'en',1,'Y');
   i('Dark-Sided Thrush',null,'Eukaryota','Chordata','Aves','Passeriformes','Turdidae','Zoothera',null,'en',1,'Y');
   i('California Sister',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Nymphalidae','Adelpha',null,'en',1,'Y');
   i('California Clingfish',null,'Eukaryota','Chordata','Actinopteri','Blenniiformes','Gobiesocidae','Gobiesox',null,'en',1,'Y');
   i('Bornean Slow Loris',null,'Eukaryota','Chordata','Mammalia','Primates','Lorisidae','Nycticebus',null,'en',1,'Y');
   i('Blue-Throated Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pyrrhura',null,'en',1,'Y');
   i('Blackish Tapaculo',null,'Eukaryota','Chordata','Aves','Passeriformes','Rhinocryptidae','Scytalopus',null,'en',1,'Y');
   i('Black-Throated Tit',null,'Eukaryota','Chordata','Aves','Passeriformes','Aegithalidae','Aegithalos',null,'en',1,'Y');
   i('Black-Capped Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pyrrhura',null,'en',1,'Y');
   i('Black Solitaire',null,'Eukaryota','Chordata','Aves','Passeriformes','Turdidae','Entomodestes',null,'en',1,'Y');
   i('Big-Thumbed Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Rhacophoridae','Kurixalus',null,'en',1,'Y');
   i('Babbling Starling',null,'Eukaryota','Chordata','Aves','Passeriformes','Sturnidae','Neocichla',null,'en',1,'Y');
   i('Azuero Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pyrrhura',null,'en',1,'Y');
   i('Aztec Thrush',null,'Eukaryota','Chordata','Aves','Passeriformes','Turdidae','Zoothera',null,'en',1,'Y');
   i('African Striped Weasel',null,'Eukaryota','Chordata','Mammalia','Carnivora','Mustelidae','Poecilogale',null,'en',1,'Y');
   i('Zebra',null,'Animalia','Chordata','Mammalia','Perissodactyla','Equidae','Equus',null,'en',1,'Y');
   i('Wolf',null,'Animalia','Chordata','Mammalia','Carnivora','Canidae','Canis','C.lupus','en',1,'Y');
   i('Whale',null,'Animalia','Chordata','Mammalia','Artiodactyla',null,null,null,'en',1,'Y');
   i('Walrus',null,'Animalia','Chordata','Mammalia','Carnivora','Odobenidae','Odobenus','O.rosmarus','en',1,'Y');
   i('Tiger',null,'Animalia','Chordata','Mammalia','Carnivora','Felidae','Panthera','P.tigris','en',1,'Y');
   i('Spider',null,'Animalia','Arthropoda','Arachnida','Araneae',null,null,null,'en',1,'Y');
   i('Snake',null,'Animalia','Chordata','Reptilia','Squamata',null,null,null,'en',1,'Y');
   i('Snail',null,'Animalia','Mollusca','Gastropoda',null,null,null,null,'en',1,'Y');
   i('Skunk',null,'Animalia','Chordata','Mammalia','Carnivora','Mephitidae',null,null,'en',1,'Y');
   i('Shrew',null,'Animalia','Chordata','Mammalia','Eulipotyphla','Soricidae',null,null,'en',1,'Y');
   i('Sheep',null,'Animalia','Chordata','Mammalia','Artiodactyla','Bovidae','Ovis','O.aries','en',1,'Y');
   i('Sea Lion',null,'Animalia','Chordata','Mammalia','Carnivora','Otariidae',null,null,'en',1,'Y');
   i('Rattlesnake',null,'Animalia','Chordata','Reptilia','Squamata','Viperidae',null,null,'en',1,'Y');
   i('Rat',null,'Animalia','Chordata','Mammalia','Rodentia','A. latidens',null,null,'en',1,'Y');
   i('Raccoon',null,'Animalia','Chordata','Mammalia','Carnivora','Procyonidae','Procyon','P.lotor','en',1,'Y');
   i('Rabbit',null,'Animalia','Chordata','Mammalia','Lagomorpha','Leporidaein part',null,null,'en',1,'Y');
   i('Quail',null,'Animalia','Chordata','Aves','Galliformes',null,null,null,'en',1,'Y');
   i('Porcupine',null,'Animalia','Chordata','Mammalia','Rodentia',null,null,null,'en',1,'Y');
   i('Polar Bear',null,'Animalia','Chordata','Mammalia','Carnivora','Ursidae','Ursus','U.maritimus','en',1,'Y');
   i('Pigeon',null,'Animalia','Chordata','Aves','Columbiformes','Columbidae',null,null,'en',1,'Y');
   i('Pig',null,'Animalia','Chordata','Mammalia','Artiodactyla','Suidae','Sus',null,'en',1,'Y');
   i('Pheasant',null,'Animalia','Chordata','Aves','Galliformes','Phasianidae',null,null,'en',1,'Y');
   i('Perch',null,'Animalia','Chordata','Actinopterygii','Perciformes','Percidae','Perca',null,'en',1,'Y');
   i('Penguin',null,'Animalia','Chordata','Aves','Sphenisciformes','Spheniscidae',null,null,'en',1,'Y');
   i('Pelican',null,'Animalia','Chordata','Aves','Pelecaniformes','Pelecanidae','Pelecanus',null,'en',1,'Y');
   i('Peacock',null,'Animalia','Chordata','Aves','Galliformes','Phasianidae',null,null,'en',1,'Y');
   i('Parrot',null,'Animalia','Chordata','Aves','Psittaciformes',null,null,null,'en',1,'Y');
   i('Panda',null,'Animalia','Chordata','Mammalia','Carnivora','Ursidae','Ailuropoda','A.melanoleuca','en',1,'Y');
   i('Oyster',null,'Animalia','Mollusca','Bivalvia',null,null,null,null,'en',1,'Y');
   i('Owl',null,'Animalia','Chordata','Aves','Strigiformes',null,null,null,'en',1,'Y');
   i('Otter',null,'Animalia','Chordata','Mammalia','Carnivora','Mustelidae',null,null,'en',1,'Y');
   i('Ostrich',null,'Animalia','Chordata','Aves','Struthioniformes','Struthionidae','Struthio',null,'en',1,'Y');
   i('Orca',null,'Animalia','Chordata','Mammalia','Artiodactyla','Delphinidae','Orcinus','O.orca','en',1,'Y');
   i('Octopus',null,'Animalia','Mollusca','Cephalopoda','Octopoda',null,null,null,'en',1,'Y');
   i('Mountain Goat',null,'Animalia','Chordata','Mammalia','Artiodactyla','Bovidae','Oreamnos','O.americanus','en',1,'Y');
   i('Moth',null,'Animalia','Arthropoda','Insecta','Lepidoptera',null,null,null,'en',1,'Y');
   i('Mosquito',null,'Animalia','Arthropoda','Insecta','Diptera','Culicidae',null,null,'en',1,'Y');
   i('Moose',null,'Animalia','Chordata','Mammalia','Artiodactyla','Cervidae','Alces','A.alces','en',1,'Y');
   i('Monkey',null,'Animalia','Chordata','Mammalia','Primates',null,null,null,'en',1,'Y');
   i('Monitor Lizard',null,'Animalia','Chordata','Reptilia','Squamata','Varanidae','Varanus',null,'en',1,'Y');
   i('Mongoose',null,'Animalia','Chordata','Mammalia','Carnivora','Herpestidae',null,null,'en',1,'Y');
   i('Lobster',null,'Animalia','Arthropoda','Malacostraca','Decapoda','Nephropidae',null,null,'en',1,'Y');
   i('Llama',null,'Animalia','Chordata','Mammalia','Artiodactyla','Camelidae','Lama','L.glama','en',1,'Y');
   i('Lizard',null,'Animalia','Chordata','Reptilia','Squamata',null,null,null,'en',1,'Y');
   i('Lion',null,'Animalia','Chordata','Mammalia','Carnivora','Felidae','Panthera','P.leo','en',1,'Y');
   i('Leopard',null,'Animalia','Chordata','Mammalia','Carnivora','Felidae','Panthera','P.pardus','en',1,'Y');
   i('Ladybug',null,'Animalia','Arthropoda','Insecta','Coleoptera','Coccinellidae',null,null,'en',1,'Y');
   i('Kangaroo',null,'Animalia','Chordata','Mammalia','Diprotodontia','Macropodidae',null,null,'en',1,'Y');
   i('Impala',null,'Animalia','Chordata','Mammalia','Artiodactyla','Bovidae','Aepyceros','A.melampus','en',1,'Y');
   i('Iguana',null,'Animalia','Chordata','Reptilia','Squamata','Iguanidae','Iguana',null,'en',1,'Y');
   i('Humpback Whale',null,'Animalia','Chordata','Mammalia','Artiodactyla','Balaenopteridae','Megaptera','M.novaeangliae','en',1,'Y');
   i('Hummingbird',null,'Animalia','Chordata','Aves','Apodiformes','Trochilidae',null,null,'en',1,'Y');
   i('Horse',null,'Animalia','Chordata','Mammalia','Perissodactyla','Equidae','Equus','E.ferus','en',1,'Y');
   i('Hippopotamus',null,'Animalia','Chordata','Mammalia','Artiodactyla','Hippopotamidae','Hippopotamus','H.amphibius','en',1,'Y');
   i('Hawk',null,'Animalia','Chordata','Aves','Accipitriformes','Accipitridae',null,null,'en',1,'Y');
   i('Hare',null,'Animalia','Chordata','Mammalia','Lagomorpha','Leporidae','Lepus',null,'en',1,'Y');
   i('Hamster',null,'Animalia','Chordata','Mammalia','Rodentia','Cricetidae',null,null,'en',1,'Y');
   i('Grasshopper',null,'Animalia','Arthropoda','Insecta','Orthoptera',null,null,null,'en',1,'Y');
   i('Gorilla',null,'Animalia','Chordata','Mammalia','Primates','Hominidae','Gorilla',null,'en',1,'Y');
   i('Gopher',null,'Animalia','Chordata','Mammalia','Rodentia','Geomyidae',null,null,'en',1,'Y');
   i('Goat',null,'Animalia','Chordata','Mammalia','Artiodactyla','Bovidae','Capra','C.aegagrus','en',1,'Y');
   i('Frog',null,'Animalia','Chordata','Amphibia','Anura',null,null,null,'en',1,'Y');
   i('Fox',null,'Animalia','Chordata','Mammalia','Carnivora','Canidae',null,null,'en',1,'Y');
   i('Fly',null,'Animalia','Arthropoda','Insecta','Diptera',null,null,null,'en',1,'Y');
   i('Flea',null,'Animalia','Arthropoda','Insecta','Siphonaptera',null,null,null,'en',1,'Y');
   i('Flamingo',null,'Animalia','Chordata','Aves','Phoenicopteriformes','Phoenicopteridae',null,null,'en',1,'Y');
   i('Fish',null,'Animalia','Chordata',null,null,null,null,null,'en',1,'Y');
   i('Finch',null,'Animalia','Chordata','Aves','Passeriformes','Fringillidae',null,null,'en',1,'Y');
   i('Ferret',null,'Animalia','Chordata','Mammalia','Carnivora','Mustelidae','Mustela','M.putorius','en',1,'Y');
   i('Falcon',null,'Animalia','Chordata','Aves','Falconiformes','Falconidae','Falco',null,'en',1,'Y');
   i('Emu',null,'Animalia','Chordata','Aves','Casuariiformes','Casuariidae','Dromaius','D.novaehollandiae','en',1,'Y');
   i('Elephant',null,'Animalia','Chordata','Mammalia','Proboscidea','Elephantidae',null,null,'en',1,'Y');
   i('Eel',null,'Animalia','Chordata','Actinopterygii','Anguilliformes',null,null,null,'en',1,'Y');
   i('Eagle',null,'Animalia','Chordata','Aves','Accipitriformes','Accipitridae',null,null,'en',1,'Y');
   i('Duck',null,'Animalia','Chordata','Aves','Anseriformes','Anatidae',null,null,'en',1,'Y');
   i('Dragonfly',null,'Animalia','Arthropoda','Insecta','Odonata',null,null,null,'en',1,'Y');
   i('Dove',null,'Animalia','Chordata','Aves','Columbiformes','Columbidae',null,null,'en',1,'Y');
   i('Donkey',null,'Animalia','Chordata','Mammalia','Perissodactyla','Equidae','Equus','E.africanus','en',1,'Y');
   i('Dolphin',null,'Animalia','Chordata','Mammalia','Artiodactyla',null,null,null,'en',1,'Y');
   i('Dog',null,'Animalia','Chordata','Mammalia','Carnivora','Canidae','Canis','C.lupus','en',1,'Y');
   i('Dinosaur',null,'Animalia','Chordata',null,null,null,null,null,'en',1,'Y');
   i('Deer',null,'Animalia','Chordata','Mammalia','Artiodactyla','Cervidae',null,null,'en',1,'Y');
   i('Cuckoo',null,'Animalia','Chordata','Aves','Cuculiformes','Cuculidae',null,null,'en',1,'Y');
   i('Crocodile',null,'Animalia','Chordata','Reptilia','Crocodilia','Crocodylidae',null,null,'en',1,'Y');
   i('Crab',null,'Animalia','Arthropoda','Malacostraca','Decapoda',null,null,null,'en',1,'Y');
   i('Coyote',null,'Animalia','Chordata','Mammalia','Carnivora','Canidae','Canis','C.latrans','en',1,'Y');
   i('Cow',null,'Animalia','Chordata','Mammalia','Artiodactyla','Bovidae','Bos','B.taurus','en',1,'Y');
   i('Cougar',null,'Animalia','Chordata','Mammalia','Carnivora','Felidae','Puma','P.concolor','en',1,'Y');
   i('Condor',null,'Animalia','Chordata','Aves','Cathartiformes','Cathartidae',null,null,'en',1,'Y');
   i('Cobra',null,'Animalia','Chordata','Reptilia','Squamata','Elapidae (with some exceptions)',null,null,'en',1,'Y');
   i('Chipmunk',null,'Animalia','Chordata','Mammalia','Rodentia','Sciuridae',null,null,'en',1,'Y');
   i('Chimpanzee',null,'Animalia','Chordata','Mammalia','Primates','Hominidae','Pan','P.troglodytes','en',1,'Y');
   i('Chicken',null,'Animalia','Chordata','Aves','Galliformes','Phasianidae','Gallus','G.gallus','en',1,'Y');
   i('Cheetah',null,'Animalia','Chordata','Mammalia','Carnivora','Felidae','Acinonyx','A.jubatus','en',1,'Y');
   i('Catfish',null,'Animalia','Chordata','Actinopterygii','Siluriformes',null,null,null,'en',1,'Y');
   i('Cat',null,'Animalia','Chordata','Mammalia','Carnivora','Felidae','Felis','F.catus','en',1,'Y');
   i('Caribou',null,'Animalia','Chordata','Mammalia','Artiodactyla','Cervidae','Rangifer','R.tarandus','en',1,'Y');
   i('Camel',null,'Animalia','Chordata','Mammalia','Artiodactyla','Camelidae','Camelus',null,'en',1,'Y');
   i('Butterfly',null,'Animalia','Arthropoda','Insecta','Lepidoptera',null,null,null,'en',1,'Y');
   i('Bobcat',null,'Animalia','Chordata','Mammalia','Carnivora','Felidae','Lynx','L.rufus','en',1,'Y');
   i('Blue Whale',null,'Animalia','Chordata','Mammalia','Artiodactyla','Balaenopteridae','Balaenoptera','B.musculus','en',1,'Y');
   i('Blue Jay',null,'Animalia','Chordata','Aves','Passeriformes','Corvidae','Cyanocitta','C.cristata','en',1,'Y');
   i('Black Widow Spider',null,'Animalia','Arthropoda','Arachnida','Araneae','Theridiidae','Latrodectus',null,'en',1,'Y');
   i('Bison',null,'Animalia','Chordata','Mammalia','Artiodactyla','Bovidae','Bison',null,'en',1,'Y');
   i('Bird',null,'Animalia','Chordata','Aves',null,null,null,null,'en',1,'Y');
   i('Beetle',null,'Animalia','Arthropoda','Insecta','Coleoptera',null,null,null,'en',1,'Y');
   i('Bee',null,'Animalia','Arthropoda','Insecta','Hymenoptera',null,null,null,'en',1,'Y');
   i('Beaver',null,'Animalia','Chordata','Mammalia','Rodentia','Castoridae','Castor',null,'en',1,'Y');
   i('Bear',null,'Animalia','Chordata','Mammalia','Carnivora','Ursidae',null,null,'en',1,'Y');
   i('Bat',null,'Animalia','Chordata','Mammalia','Chiroptera',null,null,null,'en',1,'Y');
   i('Barracuda',null,'Animalia','Chordata','Actinopterygii','Scombriformes','Sphyraenidae','Sphyraena',null,'en',1,'Y');
   i('Bald Eagle',null,'Animalia','Chordata','Aves','Accipitriformes','Accipitridae','Haliaeetus','H.leucocephalus','en',1,'Y');
   i('Badger',null,'Animalia','Chordata','Mammalia','Carnivora','Mustelidae',null,null,'en',1,'Y');
   i('Baboon',null,'Animalia','Chordata','Mammalia','Primates','Cercopithecidae','Papio',null,'en',1,'Y');
   i('Armadillo',null,'Animalia','Chordata','Mammalia','Cingulata',null,null,null,'en',1,'Y');
   i('Aphid',null,'Animalia','Arthropoda','Insecta','Hemiptera',null,null,null,'en',1,'Y');
   i('Ape',null,'Animalia','Chordata','Mammalia','Primates',null,null,null,'en',1,'Y');
   i('Antelope',null,'Animalia','Chordata','Mammalia','Artiodactyla','Bovidae',null,null,'en',1,'Y');
   i('Ant',null,'Animalia','Arthropoda','Insecta','Hymenoptera','Formicidae',null,null,'en',1,'Y');
   i('Anaconda',null,'Animalia','Chordata','Reptilia','Squamata','Boidae','Eunectes',null,'en',1,'Y');
   i('Alpaca',null,'Animalia','Chordata','Mammalia','Artiodactyla','Camelidae','Vicugna','V.pacos','en',1,'Y');
   i('Alligator',null,'Animalia','Chordata','Reptilia','Crocodilia','Alligatoridae','Alligator',null,'en',1,'Y');
   i('Aardvark',null,'Animalia','Chordata','Mammalia','Tubulidentata','Orycteropodidae','Orycteropus','O.afer','en',1,'Y');
   i('Yellowchin Sculpin',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Cottidae','Icelinus',null,'en',1,'Y');
   i('White-Nosed Bush Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Rhacophoridae','Pseudophilautus',null,'en',1,'Y');
   i('Uluguru Bushshrike',null,'Eukaryota','Chordata','Aves','Passeriformes','Malaconotidae','Malaconotus',null,'en',1,'Y');
   i('Striped Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Spruce Coneworm',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Pyralidae','Dioryctria',null,'en',1,'Y');
   i('Spotfin Surfperch',null,'Eukaryota','Chordata','Actinopteri',null,'Embiotocidae','Hyperprosopon',null,'en',1,'Y');
   i('Spinycheek Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Spectacled Salamander',null,'Eukaryota','Chordata','Amphibia','Caudata','Salamandridae','Salamandrina',null,'en',1,'Y');
   i('Sorghum Shoot Fly',null,'Eukaryota','Arthropoda','Insecta','Diptera','Muscidae','Atherigona',null,'en',1,'Y');
   i('Sharpnose Seaperch',null,'Eukaryota','Chordata','Actinopteri',null,'Embiotocidae','Phanerodon',null,'en',1,'Y');
   i('Pit-Head Sculpin',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Cottidae','Icelinus',null,'en',1,'Y');
   i('Pacific Sleeper Shark',null,'Eukaryota','Chordata','Chondrichthyes','Squaliformes','Somniosidae','Somniosus',null,'en',1,'Y');
   i('Ornate Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Microhylidae','Cophixalus',null,'en',1,'Y');
   i('Ornate Elysia',null,'Eukaryota','Mollusca','Gastropoda',null,'Plakobranchidae','Elysia',null,'en',1,'Y');
   i('Noodlefish',null,'Eukaryota','Chordata','Actinopteri','Osmeriformes','Salangidae','Salanx',null,'en',1,'Y');
   i('Longspine Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Leatherside Chub',null,'Eukaryota','Chordata','Actinopteri','Cypriniformes','Leuciscidae','Lepidomeda',null,'en',1,'Y');
   i('Gorse Shieldbug',null,'Eukaryota','Arthropoda','Insecta','Hemiptera','Pentatomidae','Piezodorus',null,'en',1,'Y');
   i('Frogmouth Sculpin',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Cottidae','Icelinus',null,'en',1,'Y');
   i('Dusky Sculpin',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Cottidae','Icelinus',null,'en',1,'Y');
   i('Common Remora',null,'Eukaryota','Chordata','Actinopteri','Carangiformes','Echeneidae','Remora',null,'en',1,'Y');
   i('California Tonguefish',null,'Eukaryota','Chordata','Actinopteri','Pleuronectiformes','Cynoglossidae','Symphurus',null,'en',1,'Y');
   i('Cactus Longhorn',null,'Eukaryota','Arthropoda','Insecta','Coleoptera','Cerambycidae','Coenopoeus',null,'en',1,'Y');
   i('Brownspotted Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Brownbelly Leaf Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Phyllomedusa',null,'en',1,'Y');
   i('Bonehead Sculpin',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Cottidae','Artedius',null,'en',1,'Y');
   i('Blue-Eyed Yellow Bush Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Rhacophoridae','Philautus',null,'en',1,'Y');
   i('Beelouse',null,'Eukaryota','Arthropoda','Insecta','Diptera','Braulidae','Braula',null,'en',1,'Y');
   i('White-Naped Seedeater',null,'Eukaryota','Chordata','Aves','Passeriformes','Thraupidae','Dolospingus',null,'en',1,'Y');
   i('Tailless Bushblue',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Lycaenidae','Arhopala',null,'en',1,'Y');
   i('Spotted Sleeper',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Eleotridae','Eleotris',null,'en',1,'Y');
   i('Spinycheek Sleeper',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Eleotridae','Eleotris',null,'en',1,'Y');
   i('Soybean Aphid',null,'Eukaryota','Arthropoda','Insecta','Hemiptera','Aphididae','Aphis',null,'en',1,'Y');
   i('Small Eye Golden-Line Fish',null,'Eukaryota','Chordata','Actinopteri','Cypriniformes','Cyprinidae','Sinocyclocheilus',null,'en',1,'Y');
   i('Slender Dwarf Siren',null,'Eukaryota','Chordata','Amphibia','Caudata','Sirenidae','Pseudobranchus',null,'en',1,'Y');
   i('Sleepy Cod',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Eleotridae','Oxyeleotris',null,'en',1,'Y');
   i('Sawcheek Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Apogon',null,'en',1,'Y');
   i('Poreless Gudgeon',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Eleotridae','Oxyeleotris',null,'en',1,'Y');
   i('Pharaoh Ant',null,'Eukaryota','Arthropoda','Insecta','Hymenoptera','Formicidae','Monomorium',null,'en',1,'Y');
   i('Pale Grass Blue',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Lycaenidae','Pseudozizeeria',null,'en',1,'Y');
   i('Pacific Sleeper',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Eleotridae','Gobiomorus',null,'en',1,'Y');
   i('Pacific Guavina',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Eleotridae','Guavina',null,'en',1,'Y');
   i('Okarito Brown Kiwi',null,'Eukaryota','Chordata','Aves','Apterygiformes','Apterygidae','Apteryx',null,'en',1,'Y');
   i('Oak Gall Wasp',null,'Eukaryota','Arthropoda','Insecta','Hymenoptera','Cynipidae','Neuroterus',null,'en',1,'Y');
   i('Nimble Long-Limbed Salamander',null,'Eukaryota','Chordata','Amphibia','Caudata','Plethodontidae','Nyctanolis',null,'en',1,'Y');
   i('New Zealand Giant Eagle',null,'Eukaryota','Chordata','Aves','Accipitriformes','Accipitridae','Harpagornis',null,'en',1,'Y');
   i('Narrow-Striped Dwarf Siren',null,'Eukaryota','Chordata','Amphibia','Caudata','Sirenidae','Pseudobranchus',null,'en',1,'Y');
   i('Moon Forest Shrew',null,'Eukaryota','Chordata','Mammalia','Eulipotyphla','Soricidae','Sylvisorex',null,'en',1,'Y');
   i('Little House Fly',null,'Eukaryota','Arthropoda','Insecta','Diptera','Fanniidae','Fannia',null,'en',1,'Y');
   i('Large-Scaled Spinycheek Sleeper',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Eleotridae','Eleotris',null,'en',1,'Y');
   i('Kihaule''S Mouse Shrew',null,'Eukaryota','Chordata','Mammalia','Eulipotyphla','Soricidae','Myosorex',null,'en',1,'Y');
   i('Japanese Sea Cucumber',null,'Eukaryota','Echinodermata','Holothuroidea','Aspidochirotida','Stichopodidae','Apostichopus',null,'en',1,'Y');
   i('Hyaline Fish',null,'Eukaryota','Chordata','Actinopteri','Cypriniformes','Cyprinidae','Sinocyclocheilus',null,'en',1,'Y');
   i('Howell''S Forest Shrew',null,'Eukaryota','Chordata','Mammalia','Eulipotyphla','Soricidae','Sylvisorex',null,'en',1,'Y');
   i('Greater Siren',null,'Eukaryota','Chordata','Amphibia','Caudata','Sirenidae','Siren',null,'en',1,'Y');
   i('Grant''S Forest Shrew',null,'Eukaryota','Chordata','Mammalia','Eulipotyphla','Soricidae','Sylvisorex',null,'en',1,'Y');
   i('Giant Gudgeon',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Eleotridae','Oxyeleotris',null,'en',1,'Y');
   i('Flathead Sleeper',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Eleotridae','Erotelis',null,'en',1,'Y');
   i('Flamefish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Apogon',null,'en',1,'Y');
   i('Eyeless Golden-Line Fish',null,'Eukaryota','Chordata','Actinopteri','Cypriniformes','Cyprinidae','Sinocyclocheilus',null,'en',1,'Y');
   i('Duck-Billed Golden-Line Fish',null,'Eukaryota','Chordata','Actinopteri','Cypriniformes','Cyprinidae','Sinocyclocheilus',null,'en',1,'Y');
   i('Deep Body Anchovy',null,'Eukaryota','Chordata','Actinopteri','Clupeiformes','Engraulidae','Anchoa',null,'en',1,'Y');
   i('Crossed-Fork Back Golden-Line Fish',null,'Eukaryota','Chordata','Actinopteri','Cypriniformes','Cyprinidae','Sinocyclocheilus',null,'en',1,'Y');
   i('Cox''S Gudgeon',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Eleotridae','Gobiomorphus',null,'en',1,'Y');
   i('Cowpea Aphid',null,'Eukaryota','Arthropoda','Insecta','Hemiptera','Aphididae','Aphis',null,'en',1,'Y');
   i('Cope''S Giant Salamander',null,'Eukaryota','Chordata','Amphibia','Caudata','Dicamptodontidae','Dicamptodon',null,'en',1,'Y');
   i('Cave Gudgeon',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Milyeringidae','Milyeringa',null,'en',1,'Y');
   i('Cascade Torrent Salamander',null,'Eukaryota','Chordata','Amphibia','Caudata','Rhyacotritonidae','Rhyacotriton',null,'en',1,'Y');
   i('California Bay Shrimp',null,'Eukaryota','Arthropoda','Malacostraca','Decapoda','Crangonidae','Crangon',null,'en',1,'Y');
   i('Blyth''S Hawk-Eagle',null,'Eukaryota','Chordata','Aves','Accipitriformes','Accipitridae','Nisaetus',null,'en',1,'Y');
   i('Blackstripe Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Ostorhinchus',null,'en',1,'Y');
   i('Black Eagle',null,'Eukaryota','Chordata','Aves','Accipitriformes','Accipitridae','Ictinaetus',null,'en',1,'Y');
   i('Bigmouth Sleeper',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Eleotridae','Gobiomorus',null,'en',1,'Y');
   i('Bennett''S Flyingfish',null,'Eukaryota','Chordata','Actinopteri','Beloniformes','Exocoetidae','Cheilopogon',null,'en',1,'Y');
   i('Threespot Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Specked Blue Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Snubnose Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Silver Seatrout',null,'Eukaryota','Chordata','Actinopteri',null,'Sciaenidae','Cynoscion',null,'en',1,'Y');
   i('Siberian Brook Lamprey',null,'Eukaryota','Chordata','Hyperoartia','Petromyzontiformes','Petromyzontidae','Lethenteron',null,'en',1,'Y');
   i('Rice Water Weevil',null,'Eukaryota','Arthropoda','Insecta','Coleoptera','Brachyceridae','Lissorhoptrus',null,'en',1,'Y');
   i('Longfin Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Large Aspen Tortrix',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Tortricidae','Choristoneura',null,'en',1,'Y');
   i('Greeffs Giant Gecko',null,'Eukaryota','Chordata','Lepidosauria','Squamata','Gekkonidae','Hemidactylus',null,'en',1,'Y');
   i('Foursaddle Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Wounded Darter',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Percidae','Etheostoma',null,'en',1,'Y');
   i('Tuskaloossa Darter',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Percidae','Etheostoma',null,'en',1,'Y');
   i('Turkestan Tit',null,'Eukaryota','Chordata','Aves','Passeriformes','Paridae','Parus',null,'en',1,'Y');
   i('Thick-Billed Parrot',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Rhynchopsitta',null,'en',1,'Y');
   i('Swelled Vent Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Dicroglossidae','Nanorana',null,'en',1,'Y');
   i('Spotted Shovelnose',null,'Eukaryota','Chordata','Actinopteri','Siluriformes','Pimelodidae','Pseudoplatystoma',null,'en',1,'Y');
   i('Spotted Darter',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Percidae','Etheostoma',null,'en',1,'Y');
   i('Smallscale Darter',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Percidae','Etheostoma',null,'en',1,'Y');
   i('Sixbar Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Sharphead Darter',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Percidae','Etheostoma',null,'en',1,'Y');
   i('Rockmaster Damselfly',null,'Eukaryota','Arthropoda','Insecta','Odonata','Diphlebiidae','Diphlebia',null,'en',1,'Y');
   i('Port Lincoln Ringneck',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Barnardius',null,'en',1,'Y');
   i('Peruvian Longwing',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Nymphalidae','Heliconius',null,'en',1,'Y');
   i('Peacock Hind',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Cephalopholis',null,'en',1,'Y');
   i('Pacific Parrotlet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Forpus',null,'en',1,'Y');
   i('Oriental Chestnut Gall Wasp',null,'Eukaryota','Arthropoda','Insecta','Hymenoptera','Cynipidae','Dryocosmus',null,'en',1,'Y');
   i('Mount Dulit Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Ranidae','Odorrana',null,'en',1,'Y');
   i('Moluccan King-Parrot',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Alisterus',null,'en',1,'Y');
   i('Mexican Silverspot',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Nymphalidae','Dione',null,'en',1,'Y');
   i('Mefugu',null,'Eukaryota','Chordata','Actinopteri','Tetraodontiformes','Tetraodontidae','Takifugu',null,'en',1,'Y');
   i('Maiden''S Blush',null,'Eukaryota','Arthropoda','Insecta','Lepidoptera','Geometridae','Cyclophora',null,'en',1,'Y');
   i('Lipstick Darter',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Percidae','Etheostoma',null,'en',1,'Y');
   i('Ishikawa''S Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Ranidae','Odorrana',null,'en',1,'Y');
   i('Grey-Hooded Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Psilopsiagon',null,'en',1,'Y');
   i('Greenbreast Darter',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Percidae','Etheostoma',null,'en',1,'Y');
   i('Golden-Mantled Racquet-Tail',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Prioniturus',null,'en',1,'Y');
   i('Goldblotch Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Giant Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Etowah Darter',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Percidae','Etheostoma',null,'en',1,'Y');
   i('Eastern Saltmarsh Mosquito',null,'Eukaryota','Arthropoda','Insecta','Diptera','Culicidae','Ochlerotatus',null,'en',1,'Y');
   i('Dotted Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Crimson-Bellied Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pyrrhura',null,'en',1,'Y');
   i('Coastal Flatwing Damselfly',null,'Eukaryota','Arthropoda','Insecta','Odonata','Argiolestidae','Griseargiolestes',null,'en',1,'Y');
   i('Camoflage Grouper',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Serranidae','Epinephelus',null,'en',1,'Y');
   i('Burrowing Parakeet',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Cyanoliseus',null,'en',1,'Y');
   i('Brown-Backed Odorous Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Ranidae','Odorrana',null,'en',1,'Y');
   i('Bourke''S Parrot',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Neopsephotus',null,'en',1,'Y');
   i('Boulder Darter',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Percidae','Etheostoma',null,'en',1,'Y');
   i('Blue-Naped Parrot',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Tanygnathus',null,'en',1,'Y');
   i('Bloodfin Darter',null,'Eukaryota','Chordata','Actinopteri','Perciformes','Percidae','Etheostoma',null,'en',1,'Y');
   i('Black-Shanked Douc Langur',null,'Eukaryota','Chordata','Mammalia','Primates','Cercopithecidae','Pygathrix',null,'en',1,'Y');
   i('Black-Headed Parrot',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittacidae','Pionites',null,'en',1,'Y');
   i('Assam Hills Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Ranidae','Clinotarsus',null,'en',1,'Y');
   i('Indian Perch',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Jaydia',null,'en',1,'Y');
   i('Hawaiian Ruby Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Apogon',null,'en',1,'Y');
   i('Guam Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Ostorhinchus',null,'en',1,'Y');
   i('Ghost Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Nectamia',null,'en',1,'Y');
   i('Flag-In Cardinal-Fish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Apogon',null,'en',1,'Y');
   i('Candystripe Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Ostorhinchus',null,'en',1,'Y');
   i('Broadstriped Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Ostorhinchus',null,'en',1,'Y');
   i('Bridled Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Pristiapogon',null,'en',1,'Y');
   i('Brazilian Wrasse',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Halichoeres',null,'en',1,'Y');
   i('Blackear Wrasse',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Halichoeres',null,'en',1,'Y');
   i('Black Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Apogonichthyoides',null,'en',1,'Y');
   i('Zetek''S Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Isthmohyla',null,'en',1,'Y');
   i('Yucatecan Shovel-Headed Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Triprion',null,'en',1,'Y');
   i('Yellowstripe Coris',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Coris',null,'en',1,'Y');
   i('Yellowspotted Wrasse',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Macropharyngodon',null,'en',1,'Y');
   i('Yellowbreasted Wrasse',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Anampses',null,'en',1,'Y');
   i('White-Headed Saw-Wing',null,'Eukaryota','Chordata','Aves','Passeriformes','Hirundinidae','Psalidoprocne',null,'en',1,'Y');
   i('White-Fronted Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Aplastodiscus',null,'en',1,'Y');
   i('Twotone Wrasse',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Halichoeres',null,'en',1,'Y');
   i('Trueb''S Water Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Ceratophryidae','Telmatobius',null,'en',1,'Y');
   i('Torpedo Wrasse',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Pseudocoris',null,'en',1,'Y');
   i('Toady Leaf Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Phyllomedusa',null,'en',1,'Y');
   i('Tiger Goby',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Gobiidae','Tigrigobius',null,'en',1,'Y');
   i('Tayor''S Yellow Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Dendropsophus',null,'en',1,'Y');
   i('Tarauaca Snouted Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Scarthyla',null,'en',1,'Y');
   i('Sumichrast''S Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Exerodonta',null,'en',1,'Y');
   i('Sumaco Horned Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hemiphractidae','Hemiphractus',null,'en',1,'Y');
   i('Starrett''S Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Isthmohyla',null,'en',1,'Y');
   i('Squirrel Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Dryophytes',null,'en',1,'Y');
   i('Square-Tailed Saw-Wing',null,'Eukaryota','Chordata','Aves','Passeriformes','Hirundinidae','Psalidoprocne',null,'en',1,'Y');
   i('Spangled Perch',null,'Eukaryota','Chordata','Actinopteri','Centrarchiformes','Terapontidae','Leiopotherapon',null,'en',1,'Y');
   i('Sonora Goby',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Gobiidae','Gobiosoma',null,'en',1,'Y');
   i('Sipurio Snouted Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Scinax',null,'en',1,'Y');
   i('Simmons'' Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Hyloscirtus',null,'en',1,'Y');
   i('Shiny-Palmed Shinning-Skink',null,'Eukaryota','Chordata','Lepidosauria','Squamata','Scincidae','Cryptoblepharus',null,'en',1,'Y');
   i('Savannah Water-Holding Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Ranoidea',null,'en',1,'Y');
   i('Rusty Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Boana',null,'en',1,'Y');
   i('Richmond''S Wrasse',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Halichoeres',null,'en',1,'Y');
   i('Red-Lined Wrasse',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Halichoeres',null,'en',1,'Y');
   i('Rainbow Wrasse',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Halichoeres',null,'en',1,'Y');
   i('Quevedo Snouted Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Scinax',null,'en',1,'Y');
   i('Purple And Orange Leaf Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Phyllomedusa',null,'en',1,'Y');
   i('Porthole Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Charadrahyla',null,'en',1,'Y');
   i('Plantation Glass Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Centrolenidae','Hyalinobatrachium',null,'en',1,'Y');
   i('Peru Stubfoot Toad',null,'Eukaryota','Chordata','Amphibia','Anura','Bufonidae','Atelopus',null,'en',1,'Y');
   i('Pear Sawfly',null,'Eukaryota','Arthropoda','Insecta','Hymenoptera','Tenthredinidae','Caliroa',null,'en',1,'Y');
   i('Pastel-Green Wrasse',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Halichoeres',null,'en',1,'Y');
   i('Papua Big-Eyed Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Nyctimystes',null,'en',1,'Y');
   i('Palmer''S Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Hyloscirtus',null,'en',1,'Y');
   i('Pale-Barred Coris',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Coris',null,'en',1,'Y');
   i('Ornamented Wrasse',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Halichoeres',null,'en',1,'Y');
   i('Orange-Legged Leaf Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Pithecopus',null,'en',1,'Y');
   i('Ocellated Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Itapotihyla',null,'en',1,'Y');
   i('Northern Cricket Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Acris',null,'en',1,'Y');
   i('Nebulous Wrasse',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Halichoeres',null,'en',1,'Y');
   i('Mourning Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Sarcohyla',null,'en',1,'Y');
   i('Mountain Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Hyla',null,'en',1,'Y');
   i('Mountain Saw-Wing',null,'Eukaryota','Chordata','Aves','Passeriformes','Hirundinidae','Psalidoprocne',null,'en',1,'Y');
   i('Mountain Marsupial Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Hemiphractidae','Gastrotheca',null,'en',1,'Y');
   i('Mount Tucutche Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hemiphractidae','Flectonotus',null,'en',1,'Y');
   i('Mormon Cricket',null,'Eukaryota','Arthropoda','Insecta','Orthoptera','Tettigoniidae','Anabrus',null,'en',1,'Y');
   i('Mertens'' Yellow Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Dendropsophus',null,'en',1,'Y');
   i('Malawi Thick Lip',null,'Eukaryota','Chordata','Actinopteri','Cichliformes','Cichlidae','Cheilochromis',null,'en',1,'Y');
   i('Mahogany Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Tlalocohyla',null,'en',1,'Y');
   i('Lowland Burrowing Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Smilisca',null,'en',1,'Y');
   i('Littlejohn''S Toadlet',null,'Eukaryota','Chordata','Amphibia','Anura','Myobatrachidae','Uperoleia',null,'en',1,'Y');
   i('Lemur Leaf Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Agalychnis',null,'en',1,'Y');
   i('Leal''S Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Dendropsophus',null,'en',1,'Y');
   i('La Loma Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Hyloscirtus',null,'en',1,'Y');
   i('Koechlin''S Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Dendropsophus',null,'en',1,'Y');
   i('Kaironk Big-Eyed Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Nyctimystes',null,'en',1,'Y');
   i('Intac Robber Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Strabomantidae','Pristimantis',null,'en',1,'Y');
   i('Gunter''S Costa Rican Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Isthmohyla',null,'en',1,'Y');
   i('Guinle Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Aplastodiscus',null,'en',1,'Y');
   i('Guerreran Stream Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Duellmanohyla',null,'en',1,'Y');
   i('Groete Creek Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hemiphractidae','Stefania',null,'en',1,'Y');
   i('Greyhead Wrasse',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Halichoeres',null,'en',1,'Y');
   i('Goldlined Coris',null,'Eukaryota','Chordata','Actinopteri','Labriformes','Labridae','Coris',null,'en',1,'Y');
   i('Gliding Leaf Frog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Agalychnis',null,'en',1,'Y');
   i('Abyssinian Ground-Thrush',null,'Eukaryota','Chordata','Aves','Passeriformes','Turdidae','Zoothera',null,'en',1,'Y');
   i('Twospot Climbing Perch',null,'Eukaryota','Chordata','Actinopteri','Anabantiformes','Anabantidae','Ctenopoma',null,'en',1,'Y');
   i('Threestripe Gourami',null,'Eukaryota','Chordata','Actinopteri','Anabantiformes','Osphronemidae','Trichopsis',null,'en',1,'Y');
   i('Thick Lipped Gourami',null,'Eukaryota','Chordata','Actinopteri','Anabantiformes','Osphronemidae','Trichogaster',null,'en',1,'Y');
   i('Thekla Lark',null,'Eukaryota','Chordata','Aves','Passeriformes','Alaudidae','Galerida',null,'en',1,'Y');
   i('Snakeskin Gourami',null,'Eukaryota','Chordata','Actinopteri','Anabantiformes','Osphronemidae','Trichopodus',null,'en',1,'Y');
   i('Ridge-Tailed Salamander',null,'Eukaryota','Chordata','Amphibia','Caudata','Plethodontidae','Pseudoeurycea',null,'en',1,'Y');
   i('Ocellated Labyrinth Fish',null,'Eukaryota','Chordata','Actinopteri','Anabantiformes','Anabantidae','Ctenopoma',null,'en',1,'Y');
   i('Muscular Salamander',null,'Eukaryota','Chordata','Amphibia','Caudata','Plethodontidae','Pseudoeurycea',null,'en',1,'Y');
   i('Moonlight Gourami',null,'Eukaryota','Chordata','Actinopteri','Anabantiformes','Osphronemidae','Trichopodus',null,'en',1,'Y');
   i('Haiti Leaf-Toed Gecko',null,'Eukaryota','Chordata','Lepidosauria','Squamata','Phyllodactylidae','Phyllodactylus',null,'en',1,'Y');
   i('Frail Gourami',null,'Eukaryota','Chordata','Actinopteri','Anabantiformes','Osphronemidae','Ctenops',null,'en',1,'Y');
   i('Eyespot Gourami',null,'Eukaryota','Chordata','Actinopteri','Anabantiformes','Osphronemidae','Parasphaerichthys',null,'en',1,'Y');
   i('Eyespot Ctenopoma',null,'Eukaryota','Chordata','Actinopteri','Anabantiformes','Anabantidae','Ctenopoma',null,'en',1,'Y');
   i('Elephant Ear Gourami',null,'Eukaryota','Chordata','Actinopteri','Anabantiformes','Osphronemidae','Osphronemus',null,'en',1,'Y');
   i('Dominican Leaf-Toed Gecko',null,'Eukaryota','Chordata','Lepidosauria','Squamata','Phyllodactylidae','Phyllodactylus',null,'en',1,'Y');
   i('Chocolate Gourami',null,'Eukaryota','Chordata','Actinopteri','Anabantiformes','Osphronemidae','Sphaerichthys',null,'en',1,'Y');
   i('Cano Toadfish',null,'Eukaryota','Chordata','Actinopteri','Batrachoidiformes','Batrachoididae','Thalassophryne',null,'en',1,'Y');
   i('Banded Gourami',null,'Eukaryota','Chordata','Actinopteri','Anabantiformes','Osphronemidae','Trichogaster',null,'en',1,'Y');
   i('Xantic Sargo',null,'Eukaryota','Chordata','Actinopteri','Lutjaniformes','Haemulidae','Anisotremus',null,'en',1,'Y');
   i('Night Aulonocara',null,'Eukaryota','Chordata','Actinopteri','Cichliformes','Cichlidae','Aulonocara',null,'en',1,'Y');
   i('Frillfin Goby',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Gobiidae','Bathygobius',null,'en',1,'Y');
   i('California Salema',null,'Eukaryota','Chordata','Actinopteri','Lutjaniformes','Haemulidae','Brachygenys',null,'en',1,'Y');
   i('Bluebanded Goby',null,'Eukaryota','Chordata','Actinopteri','Gobiiformes','Gobiidae','Lythrypnus',null,'en',1,'Y');
   i('Spottedtail Angler',null,'Eukaryota','Chordata','Actinopteri','Lophiiformes','Lophiidae','Lophiodes',null,'en',1,'Y');
   i('Slender-Billed Black-Cockatoo',null,'Eukaryota','Chordata','Aves','Psittaciformes','Cacatuidae','Calyptorhynchus',null,'en',1,'Y');
   i('Pine Woods Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Dryophytes',null,'en',1,'Y');
   i('Pacific Tripletail',null,'Eukaryota','Chordata','Actinopteri','Lobotiformes','Lobotidae','Lobotes',null,'en',1,'Y');
   i('Pacific Footballfish',null,'Eukaryota','Chordata','Actinopteri','Lophiiformes','Himantolophidae','Himantolophus',null,'en',1,'Y');
   i('Lonicera Fly',null,'Eukaryota','Arthropoda','Insecta','Diptera','Tephritidae','Rhagoletis',null,'en',1,'Y');
   i('Emerald Ash Borer Parasitic Wasp',null,'Eukaryota','Arthropoda','Insecta','Hymenoptera','Braconidae','Spathius',null,'en',1,'Y');
   i('Bird-Voiced Treefrog',null,'Eukaryota','Chordata','Amphibia','Anura','Hylidae','Dryophytes',null,'en',1,'Y');
   i('Yellow-Vented Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Veniliornis',null,'en',1,'Y');
   i('Yellow-Throated Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Piculus',null,'en',1,'Y');
   i('White-Spotted Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Veniliornis',null,'en',1,'Y');
   i('White-Spotted Slimy Salamander',null,'Eukaryota','Chordata','Amphibia','Caudata','Plethodontidae','Plethodon',null,'en',1,'Y');
   i('White Warehou',null,'Eukaryota','Chordata','Actinopteri','Scombriformes','Centrolophidae','Seriolella',null,'en',1,'Y');
   i('Waneso Lizardfish',null,'Eukaryota','Chordata','Actinopteri','Aulopiformes','Synodontidae','Saurida',null,'en',1,'Y');
   i('Visayan Warty Pig',null,'Eukaryota','Chordata','Mammalia','Artiodactyla','Suidae','Sus',null,'en',1,'Y');
   i('Victorin''S Scrub-Warbler',null,'Eukaryota','Chordata','Aves','Passeriformes','Locustellidae','Bradypterus',null,'en',1,'Y');
   i('Spotted Sea Bass',null,'Eukaryota','Chordata','Actinopteri','Pempheriformes','Lateolabracidae','Lateolabrax',null,'en',1,'Y');
   i('Southern Zigzag Salamander',null,'Eukaryota','Chordata','Amphibia','Caudata','Plethodontidae','Plethodon',null,'en',1,'Y');
   i('Southern Gray-Cheeked Salamander',null,'Eukaryota','Chordata','Amphibia','Caudata','Plethodontidae','Plethodon',null,'en',1,'Y');
   i('Sooty Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Mulleripicus',null,'en',1,'Y');
   i('Smoky-Brown Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Picoides',null,'en',1,'Y');
   i('Silver Warehou',null,'Eukaryota','Chordata','Actinopteri','Scombriformes','Centrolophidae','Seriolella',null,'en',1,'Y');
   i('Silver Driftfish',null,'Eukaryota','Chordata','Actinopteri','Scombriformes','Nomeidae','Psenes',null,'en',1,'Y');
   i('Savannah Slimy Salamander',null,'Eukaryota','Chordata','Amphibia','Caudata','Plethodontidae','Plethodon',null,'en',1,'Y');
   i('Rufous-Winged Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Piculus',null,'en',1,'Y');
   i('Rufous-Winged Philentoma',null,'Eukaryota','Chordata','Aves','Passeriformes','Prionopidae','Philentoma',null,'en',1,'Y');
   i('Rufous Piculet',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Sasia',null,'en',1,'Y');
   i('Red-Stained Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Veniliornis',null,'en',1,'Y');
   i('Red-Rumped Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Veniliornis',null,'en',1,'Y');
   i('Purple-Bellied Lory',null,'Eukaryota','Chordata','Aves','Psittaciformes','Psittaculidae','Lorius',null,'en',1,'Y');
   i('Philippine Warty Pig',null,'Eukaryota','Chordata','Mammalia','Artiodactyla','Suidae','Sus',null,'en',1,'Y');
   i('Pacific Harvestfish',null,'Eukaryota','Chordata','Actinopteri','Scombriformes','Stromateidae','Peprilus',null,'en',1,'Y');
   i('Northern Gray-Cheeked Salamander',null,'Eukaryota','Chordata','Amphibia','Caudata','Plethodontidae','Plethodon',null,'en',1,'Y');
   i('Mississippi Slimy Salamander',null,'Eukaryota','Chordata','Amphibia','Caudata','Plethodontidae','Plethodon',null,'en',1,'Y');
   i('Maroon-Breasted Philentoma',null,'Eukaryota','Chordata','Aves','Passeriformes','Prionopidae','Philentoma',null,'en',1,'Y');
   i('Maluti Redfin',null,'Eukaryota','Chordata','Actinopteri','Cypriniformes','Cyprinidae','Pseudobarbus',null,'en',1,'Y');
   i('Longfin Cigarfish',null,'Eukaryota','Chordata','Actinopteri','Scombriformes','Nomeidae','Cubiceps',null,'en',1,'Y');
   i('Little Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Veniliornis',null,'en',1,'Y');
   i('Kopje Warbler',null,'Eukaryota','Chordata','Aves','Passeriformes','Cisticolidae','Euryptila',null,'en',1,'Y');
   i('Indian Driftfish',null,'Eukaryota','Chordata','Actinopteri','Scombriformes','Nomeidae','Cubiceps',null,'en',1,'Y');
   i('Imperial Barrelfish',null,'Eukaryota','Chordata','Actinopteri','Scombriformes','Centrolophidae','Schedophilus',null,'en',1,'Y');
   i('Herero Chat',null,'Eukaryota','Chordata','Aves','Passeriformes','Muscicapidae','Namibornis',null,'en',1,'Y');
   i('Ground Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Geocolaptes',null,'en',1,'Y');
   i('Green-Backed Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Campethera',null,'en',1,'Y');
   i('Green-Backed Camaroptera',null,'Eukaryota','Chordata','Aves','Passeriformes','Cisticolidae','Camaroptera',null,'en',1,'Y');
   i('Greater Flameback',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Chrysocolaptes',null,'en',1,'Y');
   i('Gosling''S Apalis',null,'Eukaryota','Chordata','Aves','Passeriformes','Cisticolidae','Apalis',null,'en',1,'Y');
   i('Golden-Green Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Piculus',null,'en',1,'Y');
   i('Golden-Collared Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Veniliornis',null,'en',1,'Y');
   i('Freckled Driftfish',null,'Eukaryota','Chordata','Actinopteri','Scombriformes','Nomeidae','Psenes',null,'en',1,'Y');
   i('Fan-Tailed Grassbird',null,'Eukaryota','Chordata','Aves','Passeriformes','Locustellidae','Schoenicola',null,'en',1,'Y');
   i('Dot-Fronted Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Veniliornis',null,'en',1,'Y');
   i('Damara Rock-Jumper',null,'Eukaryota','Chordata','Aves','Passeriformes','Sylviidae','Achaetops',null,'en',1,'Y');
   i('Crimson-Crested Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Campephilus',null,'en',1,'Y');
   i('Cream-Colored Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Celeus',null,'en',1,'Y');
   i('Common Warehou',null,'Eukaryota','Chordata','Actinopteri','Scombriformes','Centrolophidae','Seriolella',null,'en',1,'Y');
   i('Choco Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Veniliornis',null,'en',1,'Y');
   i('Chestnut Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Celeus',null,'en',1,'Y');
   i('Cape Grass-Warbler',null,'Eukaryota','Chordata','Aves','Passeriformes','Sylviidae','Sphenoeacus',null,'en',1,'Y');
   i('Buff-Necked Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Meiglyptes',null,'en',1,'Y');
   i('Bluefin Driftfish',null,'Eukaryota','Chordata','Actinopteri','Scombriformes','Nomeidae','Psenes',null,'en',1,'Y');
   i('Blue Ridge Gray-Cheeked Salamander',null,'Eukaryota','Chordata','Amphibia','Caudata','Plethodontidae','Plethodon',null,'en',1,'Y');
   i('Blackfish',null,'Eukaryota','Chordata','Actinopteri','Scombriformes','Centrolophidae','Centrolophus',null,'en',1,'Y');
   i('Banded Woodpecker',null,'Eukaryota','Chordata','Aves','Piciformes','Picidae','Chrysophlegma',null,'en',1,'Y');
   i('Banded Driftfish',null,'Eukaryota','Chordata','Actinopteri','Scombriformes','Nomeidae','Psenes',null,'en',1,'Y');
   i('Australian River Gizzard Shad',null,'Eukaryota','Chordata','Actinopteri','Clupeiformes','Clupeidae','Nematalosa',null,'en',1,'Y');
   i('Ariommid',null,'Eukaryota','Chordata','Actinopteri','Scombriformes','Ariommatidae','Ariomma',null,'en',1,'Y');
   i('Arctic Skate',null,'Eukaryota','Chordata','Chondrichthyes','Rajiformes','Rajidae','Amblyraja',null,'en',1,'Y');
   i('African Srub-Warbler',null,'Eukaryota','Chordata','Aves','Passeriformes','Locustellidae','Bradypterus',null,'en',1,'Y');
   i('African Bush-Warbler',null,'Eukaryota','Chordata','Aves','Passeriformes','Locustellidae','Bradypterus',null,'en',1,'Y');
   i('Variegated Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Fowleria',null,'en',1,'Y');
   i('Twostripe Cardinal',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Ostorhinchus',null,'en',1,'Y');
   i('Transparent Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Apogon',null,'en',1,'Y');
   i('Three-Spot Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Pristicon',null,'en',1,'Y');
   i('Threadfin Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Zoramia',null,'en',1,'Y');
   i('Spotnape Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Apogon',null,'en',1,'Y');
   i('Short-Tooth Cardinal',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Ostorhinchus',null,'en',1,'Y');
   i('Sevenstriped Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Ostorhinchus',null,'en',1,'Y');
   i('Sangi Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Ostorhinchus',null,'en',1,'Y');
   i('Samoan Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Nectamia',null,'en',1,'Y');
   i('Ring-Tailed Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Ostorhinchus',null,'en',1,'Y');
   i('Rifle Cardinal',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Ostorhinchus',null,'en',1,'Y');
   i('Redfin Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Pristicon',null,'en',1,'Y');
   i('Ochre-Striped Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Ostorhinchus',null,'en',1,'Y');
   i('Ocellate Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Jaydia',null,'en',1,'Y');
   i('Oblique-Banded Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Apogon',null,'en',1,'Y');
   i('Narrowstripe Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Pristiapogon',null,'en',1,'Y');
   i('Meteor Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Ostorhinchus',null,'en',1,'Y');
   i('Iridescent Cardinalfish',null,'Eukaryota','Chordata','Actinopteri','Kurtiformes','Apogonidae','Pristiapogon',null,'en',1,'Y');
   commit;
  end;
  /
  declare
    procedure i (
      p_first_name        in varchar2,
      p_last_name         in varchar2,
      p_lang              in varchar2,
      p_biological_sex    in varchar2,
      p_version_number    in number,
      p_seeded_data_yn    in varchar2
    )
    is
    begin
      insert into wwv_dg_helper_persons (first_name,last_name,lang,biological_sex,version_number,seeded_data_yn)
      values (p_first_name, p_last_name, p_lang, p_biological_sex, p_version_number,p_seeded_data_yn);
    end i;
  begin
   i('Parker','Morel','en','M',1,'Y');
   i('Particia','Sukhu','en','F',1,'Y');
   i('Pasty','Kirschke','en','M',1,'Y');
   i('Patience','Calderson','en','F',1,'Y');
   i('Patrice','Bech','en','M',1,'Y');
   i('Patrina','Almsteadt','en','F',1,'Y');
   i('Patti','Chieffo','en','F',1,'Y');
   i('Paul','Kelcourse','en','M',1,'Y');
   i('Paulene','Pensick','en','F',1,'Y');
   i('Paulina','Kretlow','en','F',1,'Y');
   i('Paulita','Gaskill','en','F',1,'Y');
   i('Maryann','Champ','en','F',1,'Y');
   i('Maryanne','Karro','en','F',1,'Y');
   i('Margarette','Mizwicki','en','F',1,'Y');
   i('Margarito','Cleland','en','M',1,'Y');
   i('Marge','Wakeham','en','F',1,'Y');
   i('Victor','Acken','en','M',1,'Y');
   i('Marget','Muehl','en','F',1,'Y');
   i('Margie','Ospina','en','F',1,'Y');
   i('Margo','Allemond','en','F',1,'Y');
   i('Margot','Morin','en','F',1,'Y');
   i('Mabelle','Beaston','en','F',1,'Y');
   i('Machelle','Vandevsen','en','F',1,'Y');
   i('Mackenzie','Aucter','en','M',1,'Y');
   i('Madalene','Weavers','en','F',1,'Y');
   i('Luciana','Schwartze','en','F',1,'Y');
   i('Lucienne','Binsfeld','en','F',1,'Y');
   i('Lucilla','Gerner','en','F',1,'Y');
   i('Lucinda','Demasi','en','F',1,'Y');
   i('Lucius','Santucci','en','M',1,'Y');
   i('Ludivina','Friis','en','F',1,'Y');
   i('Suzann','Bears','en','F',1,'Y');
   i('Svetlana','Mazella','en','F',1,'Y');
   i('Sylvie','Kollman','en','F',1,'Y');
   i('Spring','Jessamy','en','F',1,'Y');
   i('Stacy','Dall','en','F',1,'Y');
   i('Shad','Simonetta','en','M',1,'Y');
   i('Shalon','Johal','en','F',1,'Y');
   i('Shanae','Keemer','en','F',1,'Y');
   i('Shanel','Wichrowski','en','F',1,'Y');
   i('Shannan','Meserole','en','F',1,'Y');
   i('Shantay','Relic','en','F',1,'Y');
   i('Rosalyn','Wanvig','en','F',1,'Y');
   i('Rosaria','Sidles','en','F',1,'Y');
   i('Roseanne','Lantgen','en','F',1,'Y');
   i('Rosemarie','Stefanich','en','F',1,'Y');
   i('Winnifred','Keats','en','F',1,'Y');
   i('Yvone','Keltt','en','F',1,'Y');
   i('Windy','Bosak','en','F',1,'Y');
   i('Winter','Pickenpaugh','en','M',1,'Y');
   i('Edwardo','Shouts','en','M',1,'Y');
   i('Pearline','Weinbauer','en','F',1,'Y');
   i('Penney','Penton','en','F',1,'Y');
   i('Perry','Squines','en','M',1,'Y');
   i('Olevia','Hoe','en','F',1,'Y');
   i('Oliver','Damour','en','M',1,'Y');
   i('Lani','Winward','en','F',1,'Y');
   i('Norah','Rompf','en','F',1,'Y');
   i('Normand','Lownsbery','en','M',1,'Y');
   i('Lakeshia','Ignowski','en','F',1,'Y');
   i('Lamont','Fesperman','en','M',1,'Y');
   i('Lanette','Alken','en','F',1,'Y');
   i('Gwendolyn','Galindo','en','F',1,'Y');
   i('Laree','Shaggy','en','F',1,'Y');
   i('Kimbra','Ding','en','F',1,'Y');
   i('Kira','Brest','en','F',1,'Y');
   i('Kit','Furgeson','en','M',1,'Y');
   i('Kylee','Edwads','en','F',1,'Y');
   i('Jaime','Greyovich','en','M',1,'Y');
   i('Israel','Bendlage','en','M',1,'Y');
   i('Ivette','Corrett','en','F',1,'Y');
   i('Hazel','Bohs','en','F',1,'Y');
   i('Hee','Stanaland','en','F',1,'Y');
   i('Helena','Eberhard','en','F',1,'Y');
   i('Hobert','Simmon','en','M',1,'Y');
   i('Homer','Trigillo','en','M',1,'Y');
   i('Gordon','Marke','en','M',1,'Y');
   i('Graciela','Valley','en','F',1,'Y');
   i('Grazyna','Wiedyk','en','F',1,'Y');
   i('Gretta','Grunder','en','F',1,'Y');
   i('Guillermo','Remsburg','en','M',1,'Y');
   i('Gwendolyn','Plowden','en','F',1,'Y');
   i('Cami','Kirkwood','en','F',1,'Y');
   i('Bryant','Fok','en','M',1,'Y');
   i('Buddy','Glanton','en','M',1,'Y');
   i('Deirdre','Trudics','en','F',1,'Y');
   i('Delena','Bost','en','F',1,'Y');
   i('Darcy','Papen','en','M',1,'Y');
   i('Darius','Ulery','en','M',1,'Y');
   i('Clifton','Falldorf','en','M',1,'Y');
   i('Codi','Simison','en','M',1,'Y');
   i('Celinda','Monk','en','F',1,'Y');
   i('Cesar','Tigert','en','M',1,'Y');
   i('Marth','Huish','en','F',1,'Y');
   i('Marva','Riekert','en','F',1,'Y');
   i('Effie','Reinholt','en','F',1,'Y');
   i('Ela','Bisesi','en','F',1,'Y');
   i('Elba','Mcelderry','en','F',1,'Y');
   i('Janna','Duperclay','en','F',1,'Y');
   i('Jared','Sietz','en','M',1,'Y');
   i('Jarrod','Seidman','en','M',1,'Y');
   i('Russ','Viox','en','M',1,'Y');
   i('Palmira','Letran','en','F',1,'Y');
   i('Eda','Faigley','en','F',1,'Y');
   i('Edgar','North','en','M',1,'Y');
   i('Edmond','Baray','en','M',1,'Y');
   i('Edwin','Fannings','en','M',1,'Y');
   i('Daniela','Rick','en','F',1,'Y');
   i('Danielle','Nett','en','F',1,'Y');
   i('Danilo','Titch','en','M',1,'Y');
   i('Danna','Luse','en','F',1,'Y');
   i('Dante','Mooe','en','M',1,'Y');
   i('Danyelle','Songster','en','F',1,'Y');
   i('Darcel','Igus','en','F',1,'Y');
   i('Darell','Eastmond','en','M',1,'Y');
   i('Tom','Can','en','M',1,'Y');
   i('Darrel','Oyster','en','M',1,'Y');
   i('Darrick','Leavenworth','en','M',1,'Y');
   i('Terrell','Stassen','en','M',1,'Y');
   i('Bailey','Mazanec','en','M',1,'Y');
   i('Barabara','Suders','en','F',1,'Y');
   i('Barbar','Fidel','en','M',1,'Y');
   i('Barbie','Roever','en','F',1,'Y');
   i('Bari','Apresa','en','M',1,'Y');
   i('Barrett','Hayford','en','M',1,'Y');
   i('Bart','Detullio','en','M',1,'Y');
   i('Basil','Hanagan','en','M',1,'Y');
   i('Beata','Ladieu','en','F',1,'Y');
   i('Beatris','Iraheta','en','F',1,'Y');
   i('Beau','Deerman','en','M',1,'Y');
   i('Bebe','Broadwell','en','F',1,'Y');
   i('Becky','Falsetti','en','F',1,'Y');
   i('Belen','Ogden','en','F',1,'Y');
   i('Belinda','Barger','en','F',1,'Y');
   i('Bella','Osterfeld','en','F',1,'Y');
   i('Belva','Old','en','M',1,'Y');
   i('Benedict','Lavery','en','M',1,'Y');
   i('Anneliese','Namdar','en','F',1,'Y');
   i('Annetta','Juback','en','F',1,'Y');
   i('Annice','Mccrossen','en','F',1,'Y');
   i('Basil','Oursler','en','M',1,'Y');
   i('Annmarie','Esmay','en','F',1,'Y');
   i('Antoine','Applonie','en','M',1,'Y');
   i('Anton','Mew','en','M',1,'Y');
   i('Antonetta','Pinsky','en','F',1,'Y');
   i('Antonia','Mclachlan','en','F',1,'Y');
   i('Antonio','Koper','en','M',1,'Y');
   i('Gladys','Laughery','en','F',1,'Y');
   i('Ruthanne','Burgoyne','en','F',1,'Y');
   i('Ruthe','Nishioka','en','F',1,'Y');
   i('Ryan','Montori','en','M',1,'Y');
   i('Sabine','Bonaguidi','en','F',1,'Y');
   i('Sabrina','Stojanovic','en','F',1,'Y');
   i('Yvonne','Appleman','en','F',1,'Y');
   i('Wynona','Tenda','en','F',1,'Y');
   i('Vernita','Kulik','en','F',1,'Y');
   i('Veronica','Aubrecht','en','F',1,'Y');
   i('Ty','Flournay','en','M',1,'Y');
   i('Tyrell','Zuelke','en','M',1,'Y');
   i('Toccara','Konwinski','en','F',1,'Y');
   i('Tomasa','Orouke','en','F',1,'Y');
   i('Tommy','Stoor','en','M',1,'Y');
   i('Theodora','Beavin','en','F',1,'Y');
   i('Therese','Zaeske','en','F',1,'Y');
   i('Gilberto','Weibel','en','M',1,'Y');
   i('Ginger','Zorman','en','F',1,'Y');
   i('Gisele','Limthong','en','F',1,'Y');
   i('Gladis','Trevey','en','F',1,'Y');
   i('Glenn','Mcgraff','en','M',1,'Y');
   i('Florida','Gilliand','en','F',1,'Y');
   i('Floy','Craver','en','M',1,'Y');
   i('Fran','Sibbald','en','M',1,'Y');
   i('Francesco','Elland','en','M',1,'Y');
   i('Judson','Kantz','en','M',1,'Y');
   i('Julian','Rudack','en','M',1,'Y');
   i('Kirby','Honeyman','en','M',1,'Y');
   i('Kisha','Leven','en','F',1,'Y');
   i('Phylis','Andonian','en','F',1,'Y');
   i('Ping','Ivel','en','M',1,'Y');
   i('Porsche','Shippee','en','M',1,'Y');
   i('Terresa','Hanhardt','en','F',1,'Y');
   i('Tiffaney','Bozovich','en','F',1,'Y');
   i('Timika','Wombles','en','F',1,'Y');
   i('Jolie','Micalizzi','en','F',1,'Y');
   i('Jonathon','Botner','en','M',1,'Y');
   i('Jonnie','Spellane','en','M',1,'Y');
   i('Josefa','Shilt','en','F',1,'Y');
   i('Josh','Slomer','en','M',1,'Y');
   i('Letha','Kosir','en','F',1,'Y');
   i('Lezlie','Rosenthall','en','F',1,'Y');
   i('Libbie','Risher','en','F',1,'Y');
   i('Pablo','Caveney','en','M',1,'Y');
   i('Josh','Vanderstelt','en','M',1,'Y');
   i('Gracia','Tsai','en','F',1,'Y');
   i('Hollis','Jondahl','en','M',1,'Y');
   i('Hong','Charter','en','M',1,'Y');
   i('Horace','Kaminer','en','M',1,'Y');
   i('Goldie','Yuska','en','F',1,'Y');
   i('Gracia','Soldavini','en','F',1,'Y');
   i('Graham','Chambers','en','M',1,'Y');
   i('Granville','Mcmurrin','en','M',1,'Y');
   i('Gregoria','Ramotar','en','F',1,'Y');
   i('Greta','Svatek','en','F',1,'Y');
   i('Griselda','Kurohara','en','F',1,'Y');
   i('Gudrun','Snater','en','F',1,'Y');
   i('Gussie','Khilling','en','F',1,'Y');
   i('Gwen','Cake','en','F',1,'Y');
   i('Callie','Antronica','en','F',1,'Y');
   i('Camellia','Archuletta','en','F',1,'Y');
   i('Camila','Hillwig','en','F',1,'Y');
   i('Brynn','Mckale','en','F',1,'Y');
   i('Buck','Campion','en','M',1,'Y');
   i('Buffy','Melen','en','F',1,'Y');
   i('Bula','Esperanza','en','M',1,'Y');
   i('Bunny','Oginski','en','F',1,'Y');
   i('Delaine','Untalan','en','F',1,'Y');
   i('Delbert','Khatak','en','M',1,'Y');
   i('Delia','Nortesano','en','F',1,'Y');
   i('Daren','Bravard','en','M',1,'Y');
   i('Kevin','Sawlivich','en','M',1,'Y');
   i('Darleen','Casten','en','F',1,'Y');
   i('Cleveland','Gassert','en','M',1,'Y');
   i('Clinton','Bjerke','en','M',1,'Y');
   i('Clorinda','Matalka','en','F',1,'Y');
   i('Colby','Sanagustin','en','M',1,'Y');
   i('Celia','Scothorn','en','F',1,'Y');
   i('Sylvester','Kister','en','M',1,'Y');
   i('Chadwick','Henscheid','en','M',1,'Y');
   i('Marshall','Lowery','en','M',1,'Y');
   i('Martin','Musulin','en','M',1,'Y');
   i('Martine','Forbs','en','F',1,'Y');
   i('Marvella','Salemi','en','F',1,'Y');
   i('Marya','Raso','en','F',1,'Y');
   i('Efren','Wallentine','en','M',1,'Y');
   i('Eileen','Millott','en','F',1,'Y');
   i('Elaina','Hagglund','en','F',1,'Y');
   i('Elanor','Shinsel','en','F',1,'Y');
   i('Janine','Prudom','en','F',1,'Y');
   i('Janita','Eskaran','en','F',1,'Y');
   i('Jannette','Babino','en','F',1,'Y');
   i('Janyce','Daignault','en','F',1,'Y');
   i('Jarred','Israelsen','en','M',1,'Y');
   i('Rufus','Morais','en','M',1,'Y');
   i('Rupert','Tardy','en','M',1,'Y');
   i('Russel','Heinzelman','en','M',1,'Y');
   i('Rusty','Nesland','en','M',1,'Y');
   i('Pam','Dominis','en','F',1,'Y');
   i('Pamala','Mcdewitt','en','F',1,'Y');
   i('Eddie','Dietrick','en','M',1,'Y');
   i('Edelmira','Widman','en','F',1,'Y');
   i('Edie','Tavernier','en','M',1,'Y');
   i('Edith','Montbriand','en','F',1,'Y');
   i('Edna','Fowlston','en','F',1,'Y');
   i('Edris','Lifford','en','M',1,'Y');
   i('Edyth','Spindle','en','F',1,'Y');
   i('Daniel','Strong','en','M',1,'Y');
   i('Daniele','Thorsten','en','M',1,'Y');
   i('Daniell','Grumney','en','M',1,'Y');
   i('Danika','Kerans','en','F',1,'Y');
   i('Danille','Verbeck','en','F',1,'Y');
   i('Danita','Heumann','en','F',1,'Y');
   i('Dann','Widerski','en','M',1,'Y');
   i('Letty','Riccardo','en','F',1,'Y');
   i('Dannielle','Conforto','en','F',1,'Y');
   i('Danyel','Gatling','en','M',1,'Y');
   i('Daphine','Elfrink','en','F',1,'Y');
   i('Dara','Bonneau','en','F',1,'Y');
   i('Darci','Glassner','en','F',1,'Y');
   i('Darcie','Hamm','en','F',1,'Y');
   i('Daria','Heare','en','F',1,'Y');
   i('Dario','Housman','en','M',1,'Y');
   i('Darla','Jungling','en','F',1,'Y');
   i('Darlene','Pisano','en','F',1,'Y');
   i('Darnell','Rainbow','en','M',1,'Y');
   i('Darren','Settler','en','M',1,'Y');
   i('Darron','Compo','en','M',1,'Y');
   i('Darwin','Dyke','en','M',1,'Y');
   i('Dave','Groseclose','en','M',1,'Y');
   i('Ruthie','Gerlach','en','F',1,'Y');
   i('Ryann','Rosenkoetter','en','M',1,'Y');
   i('Sabina','Kennemuth','en','F',1,'Y');
   i('Sabra','Friedrichs','en','F',1,'Y');
   i('Yuri','Burghard','en','M',1,'Y');
   i('Yvette','Estimable','en','F',1,'Y');
   i('Zachary','Barberr','en','M',1,'Y');
   i('Woodrow','Pouncy','en','M',1,'Y');
   i('Xavier','Bethel','en','M',1,'Y');
   i('Vernie','Packwood','en','F',1,'Y');
   i('Vernon','Morence','en','M',1,'Y');
   i('Verona','Ainge','en','F',1,'Y');
   i('Twanda','Grider','en','F',1,'Y');
   i('Twyla','Postel','en','F',1,'Y');
   i('Tyisha','Maaske','en','F',1,'Y');
   i('Tyra','Ogara','en','F',1,'Y');
   i('Tyrone','Papa','en','M',1,'Y');
   i('Tobi','Heide','en','M',1,'Y');
   i('Tobie','Mudra','en','M',1,'Y');
   i('Todd','Sartorio','en','M',1,'Y');
   i('Tom','Fego','en','M',1,'Y');
   i('Tomi','Kalland','en','M',1,'Y');
   i('Tomiko','Landfair','en','F',1,'Y');
   i('Thelma','Kittner','en','F',1,'Y');
   i('Theo','Heitner','en','M',1,'Y');
   i('Theodore','Knowiton','en','M',1,'Y');
   i('Theola','Guagliano','en','F',1,'Y');
   i('Theresia','Duley','en','F',1,'Y');
   i('Theressa','Forgey','en','F',1,'Y');
   i('Gillian','Maurin','en','F',1,'Y');
   i('Gina','Makowski','en','F',1,'Y');
   i('Gino','Skillan','en','M',1,'Y');
   i('Giovanni','Helbert','en','M',1,'Y');
   i('Giuseppe','Laramee','en','M',1,'Y');
   i('Gladys','Homrich','en','F',1,'Y');
   i('Glen','Godinez','en','M',1,'Y');
   i('Glendora','Dockum','en','F',1,'Y');
   i('Floretta','Catlin','en','F',1,'Y');
   i('Florine','Mcphaul','en','F',1,'Y');
   i('Glenn','Coneys','en','M',1,'Y');
   i('Fonda','Packingham','en','F',1,'Y');
   i('Forrest','Wertman','en','M',1,'Y');
   i('France','Zosel','en','F',1,'Y');
   i('Lucretia','Kircher','en','F',1,'Y');
   i('Luella','Praytor','en','F',1,'Y');
   i('Susy','Wedlow','en','F',1,'Y');
   i('Suzanne','Gitto','en','F',1,'Y');
   i('Suzi','Langdale','en','F',1,'Y');
   i('Syble','Radin','en','F',1,'Y');
   i('Sylvester','Glawson','en','M',1,'Y');
   i('Sophia','Bruker','en','F',1,'Y');
   i('Soraya','Tysarczyk','en','F',1,'Y');
   i('Stacey','Engelsman','en','F',1,'Y');
   i('Stacia','Golemba','en','F',1,'Y');
   i('Stanford','Kuhlmey','en','M',1,'Y');
   i('Star','Dichiaro','en','M',1,'Y');
   i('Shaina','Cuffia','en','F',1,'Y');
   i('Sandy','Difeo','en','F',1,'Y');
   i('Shameka','Knaphus','en','F',1,'Y');
   i('Shan','Dilts','en','M',1,'Y');
   i('Shandi','Coatley','en','F',1,'Y');
   i('Shane','Pujia','en','M',1,'Y');
   i('Shani','Moua','en','M',1,'Y');
   i('Shanice','Vinton','en','F',1,'Y');
   i('Shanita','Reisman','en','F',1,'Y');
   i('Shanon','Mccarter','en','F',1,'Y');
   i('Shantel','Gebhart','en','F',1,'Y');
   i('Rosaline','Ange','en','F',1,'Y');
   i('Rosamond','Totter','en','F',1,'Y');
   i('Rosanna','Swasey','en','F',1,'Y');
   i('Rosaura','Guillotte','en','F',1,'Y');
   i('Roseann','Dejarden','en','F',1,'Y');
   i('Roseline','Fanter','en','F',1,'Y');
   i('Roselle','Duis','en','F',1,'Y');
   i('Yuki','Fewell','en','F',1,'Y');
   i('Svetlana','Wisely','en','F',1,'Y');
   i('Yuonne','Riles','en','F',1,'Y');
   i('Yuriko','Stinser','en','F',1,'Y');
   i('Willy','Sipple','en','M',1,'Y');
   i('Wilmer','Larrier','en','M',1,'Y');
   i('Winford','Barriere','en','M',1,'Y');
   i('Winnifred','Lachowicz','en','F',1,'Y');
   i('Wonda','Riexinger','en','F',1,'Y');
   i('Edwina','Brazeal','en','F',1,'Y');
   i('Pearlene','Lofman','en','F',1,'Y');
   i('Peggie','Ubaldo','en','F',1,'Y');
   i('Pei','Joline','en','F',1,'Y');
   i('Pennie','Buchannan','en','F',1,'Y');
   i('Percy','Shumski','en','M',1,'Y');
   i('Phebe','Tensley','en','F',1,'Y');
   i('Olen','Vire','en','M',1,'Y');
   i('Olene','Kurz','en','F',1,'Y');
   i('Olimpia','Karpiak','en','F',1,'Y');
   i('Olinda','Langill','en','F',1,'Y');
   i('Ollie','Egert','en','M',1,'Y');
   i('Noelle','Howze','en','F',1,'Y');
   i('Nolan','Ille','en','M',1,'Y');
   i('Nona','Kozuch','en','F',1,'Y');
   i('Norberto','Febre','en','M',1,'Y');
   i('Norene','Pensky','en','F',1,'Y');
   i('Novella','Shackleton','en','F',1,'Y');
   i('Numbers','Hitzler','en','M',1,'Y');
   i('Lakita','Bjornson','en','F',1,'Y');
   i('Lamar','Salais','en','M',1,'Y');
   i('Lance','Yeakel','en','M',1,'Y');
   i('Lanell','Florczak','en','F',1,'Y');
   i('Lani','Salada','en','F',1,'Y');
   i('Lanita','Deloye','en','F',1,'Y');
   i('Laquanda','Ruhoff','en','F',1,'Y');
   i('Perry','Mccalman','en','M',1,'Y');
   i('Larisa','Oathout','en','F',1,'Y');
   i('Kimberly','Mcgrail','en','F',1,'Y');
   i('Kina','Cademartori','en','F',1,'Y');
   i('King','Presnell','en','M',1,'Y');
   i('Kirk','Lamoine','en','M',1,'Y');
   i('Kirstie','Rotman','en','F',1,'Y');
   i('Kum','Rome','en','M',1,'Y');
   i('Kyla','Devich','en','F',1,'Y');
   i('Jada','Stehr','en','F',1,'Y');
   i('Jadwiga','Pincus','en','F',1,'Y');
   i('Isiah','Desorcy','en','M',1,'Y');
   i('Isidro','Hard','en','M',1,'Y');
   i('Ismael','Other','en','M',1,'Y');
   i('Issac','Stsauveur','en','M',1,'Y');
   i('Ivana','Gardunio','en','F',1,'Y');
   i('Ivonne','Hondel','en','F',1,'Y');
   i('Hayden','Braxton','en','M',1,'Y');
   i('Heather','Nibert','en','F',1,'Y');
   i('Hedwig','Talyor','en','F',1,'Y');
   i('Heidy','Rockelman','en','F',1,'Y');
   i('Helaine','Mccanless','en','F',1,'Y');
   i('Hisako','Branot','en','F',1,'Y');
   i('Palmer','Vandermark','en','M',1,'Y');
   i('Dannie','McCoin','en','M',1,'Y');
   i('Trey','Gorham','en','M',1,'Y');
   i('Nanci','Bunt','en','F',1,'Y');
   i('Sandra','Bass','en','F',1,'Y');
   i('Nelson','Tate','en','M',1,'Y');
   i('Tiffany','Pena','en','F',1,'Y');
   i('Jeannette','Hunt','en','F',1,'Y');
   i('Willie','Cunningham','en','M',1,'Y');
   i('Paulette','Byrd','en','F',1,'Y');
   i('Tasha','Cobb','en','F',1,'Y');
   i('Eloise','Burton','en','F',1,'Y');
   i('Felix','Fox','en','M',1,'Y');
   i('Gary','Barton','en','M',1,'Y');
   i('Tracy','Mcbride','en','F',1,'Y');
   i('Lorita','Koenig','en','F',1,'Y');
   i('Kaleigh','Meade','en','F',1,'Y');
   i('Lexie','Magee','en','F',1,'Y');
   i('Lillia','Talbott','en','F',1,'Y');
   i('Chi','Mcwhorter','en','M',1,'Y');
   i('Britney','Gable','en','F',1,'Y');
   i('Lorilee','Bautista','en','F',1,'Y');
   i('Shaquana','Carney','en','F',1,'Y');
   i('Shirley','Ward','en','F',1,'Y');
   i('Frank','Perez','en','M',1,'Y');
   i('Andria','Myles','en','F',1,'Y');
   i('Twila','Hilliard','en','F',1,'Y');
   i('Florencia','Kohler','en','F',1,'Y');
   i('Kendrick','Caraballo','en','M',1,'Y');
   i('Carmella','Avalos','en','F',1,'Y');
   i('Winfred','August','en','M',1,'Y');
   i('Salena','Wadsworth','en','F',1,'Y');
   i('Melisa','Banda','en','F',1,'Y');
   i('Adam','Miller','en','M',1,'Y');
   i('Jeffrey','Hallstead','en','M',1,'Y');
   i('Russell','Rivera','en','M',1,'Y');
   i('Adam','Stader','en','M',1,'Y');
   i('Stephanie','Vaccarello','en','F',1,'Y');
   i('Nicholas','Diaz','en','M',1,'Y');
   i('Deborah','Taylor','en','F',1,'Y');
   i('Adam','Walker','en','M',1,'Y');
   i('Jack','Brooks','en','M',1,'Y');
   i('Norma','Robinson','en','F',1,'Y');
   i('Walter','Schmatz','en','M',1,'Y');
   i('Raymond','Bailey','en','M',1,'Y');
   i('Carol','Alexander','en','F',1,'Y');
   i('Carlos','Maza','en','M',1,'Y');
   i('Alwin','Elliott','en','M',1,'Y');
   i('Kaija','Crawford','en','F',1,'Y');
   i('Lola','Whitley','en','F',1,'Y');
   i('Michael','Kim','en','M',1,'Y');
   i('Debbie','Sawbridge','en','F',1,'Y');
   i('Nus','Biollix','en','M',1,'Y');
   i('Domingo','Morano','en','M',1,'Y');
   i('Emilio','Sessaia','en','M',1,'Y');
   i('Eduardo','Flignia','en','M',1,'Y');
   i('Landon','Neville','en','M',1,'Y');
   i('Salome','Guisti','en','F',1,'Y');
   i('Twila','Coolbeth','en','F',1,'Y');
   i('August','Arouri','en','M',1,'Y');
   i('Luana','Berends','en','F',1,'Y');
   i('Monty','Kinnamon','en','M',1,'Y');
   i('Inez','Yamnitz','en','F',1,'Y');
   i('Dean','Bollich','en','M',1,'Y');
   i('August','Rupel','en','M',1,'Y');
   i('Azalee','Goodwater','en','F',1,'Y');
   i('Taylor','Cauchon','en','M',1,'Y');
   i('Norris','Michener','en','M',1,'Y');
   i('Erasmo','Riviera','en','M',1,'Y');
   i('Bernardo','Phoenix','en','M',1,'Y');
   i('Sam','Rueb','en','M',1,'Y');
   i('Tressa','Coppens','en','F',1,'Y');
   i('Winfred','Sohn','en','M',1,'Y');
   i('Kenny','Campobasso','en','M',1,'Y');
   i('Katherine','Tagg','en','F',1,'Y');
   i('Gita','Dobbs','en','F',1,'Y');
   i('Dede','Bundy','en','M',1,'Y');
   i('Annemarie','Pinckney','en','F',1,'Y');
   i('Virgie','Breeden','en','F',1,'Y');
   i('Mohammad','Cervantes','en','M',1,'Y');
   i('Mireille','Pauley','en','F',1,'Y');
   i('Barbara','Krucke','en','F',1,'Y');
   i('Chris','Lambrakis','en','M',1,'Y');
   i('Sean','Adams','en','M',1,'Y');
   i('Jesse','Rookstool','en','M',1,'Y');
   i('Steven','Brown','en','M',1,'Y');
   i('Cheryl','Young','en','F',1,'Y');
   i('Michael','Marker','en','M',1,'Y');
   i('Beverly','Hughes','en','F',1,'Y');
   i('Jean','Patterson','en','M',1,'Y');
   i('Tina','Kovalcheck','en','F',1,'Y');
   i('Christopher','Allen','en','M',1,'Y');
   i('Alex','Loera','en','M',1,'Y');
   i('Ami','Dardar','en','F',1,'Y');
   i('Elaine','Moncure','en','F',1,'Y');
   i('Jonell','Pecatoste','en','M',1,'Y');
   i('Alex','Binette','en','M',1,'Y');
   i('Nelson','Koschnitzki','en','M',1,'Y');
   i('Chet','Gervin','en','M',1,'Y');
   i('Eustolia','Temores','en','F',1,'Y');
   i('Angel','Sakoda','en','M',1,'Y');
   i('Luigi','Nored','en','M',1,'Y');
   i('Jacklyn','Niskala','en','F',1,'Y');
   i('Rudolph','Bekerman','en','M',1,'Y');
   i('Teisha','Grimstead','en','F',1,'Y');
   i('Julien','Girardi','en','M',1,'Y');
   i('Brandy','Genco','en','F',1,'Y');
   i('Haywood','Burd','en','M',1,'Y');
   i('Donna','Perrine','en','F',1,'Y');
   i('Sarah','Flook','en','F',1,'Y');
   i('Florance','Bateman','en','F',1,'Y');
   i('Angelo','Carreon','en','M',1,'Y');
   i('Lloyd','Shackley','en','M',1,'Y');
   i('Reyes','Paczkowski','en','F',1,'Y');
   i('Patricia','Wilson','en','F',1,'Y');
   i('James','Williams','en','M',1,'Y');
   i('Enoch','Strini','en','M',1,'Y');
   i('Erica','Shortes','en','F',1,'Y');
   i('Quinn','Yerdon','en','M',1,'Y');
   i('Jaimee','Gammons','en','F',1,'Y');
   i('Latoria','Siprasoeuth','en','F',1,'Y');
   i('Adeline','Iannotti','en','F',1,'Y');
   i('Laveta','Wida','en','F',1,'Y');
   i('Janey','Fornell','en','F',1,'Y');
   i('Kristina','Livshits','en','F',1,'Y');
   i('Jessika','Doorn','en','F',1,'Y');
   i('Loyd','Huckeba','en','M',1,'Y');
   i('Tyler','Curlee','en','M',1,'Y');
   i('Leon','Schoepfer','en','M',1,'Y');
   i('Casey','Chestand','en','M',1,'Y');
   i('Daisy','Liddicoat','en','F',1,'Y');
   i('Hyrum','Goodspeed','en','M',1,'Y');
   i('Scotty','Goffredo','en','M',1,'Y');
   i('Jewel','Clippard','en','F',1,'Y');
   i('Emmett','Golz','en','M',1,'Y');
   i('Norman','Lobregat','en','M',1,'Y');
   i('Wysteria','Arana','en',null,1,'Y');
   i('Tim','Blasingim','en','M',1,'Y');
   i('Verda','Puchalla','en','F',1,'Y');
   i('Jamison','Scrobola','en','M',1,'Y');
   i('Eldon','Lannon','en','M',1,'Y');
   i('Alvin','Gagner','en','M',1,'Y');
   i('William','Schleiss','en','M',1,'Y');
   i('Carol','Citino','en','F',1,'Y');
   i('Ruth','Graham','en','F',1,'Y');
   i('Carol','Metrick','en','F',1,'Y');
   i('Son','McLagan','en','M',1,'Y');
   i('Murray','Vicario','en','M',1,'Y');
   i('Loris','Thibadeau','en','M',1,'Y');
   i('Trenton','Stoermer','en','M',1,'Y');
   i('Luciano','Lingenfelter','en','M',1,'Y');
   i('Jolene','Johannesen','en','F',1,'Y');
   i('Elden','Bufton','en','M',1,'Y');
   i('Broderick','Faur','en','M',1,'Y');
   i('Zavert','Zimmer','en',null,1,'Y');
   i('Wilfred','Welch','en','M',1,'Y');
   i('Mary','Kossen','en','F',1,'Y');
   i('Otha','Murton','en','M',1,'Y');
   i('Enrique','Southcott','en','M',1,'Y');
   i('Epifania','Urbach','en','F',1,'Y');
   i('Erick','Hickock','en','M',1,'Y');
   i('Erika','Duffey','en','F',1,'Y');
   i('Frances','Ropac','en','F',1,'Y');
   i('Francie','Hodes','en','F',1,'Y');
   i('Judith','Eckl','en','F',1,'Y');
   i('Julee','Meginnes','en','F',1,'Y');
   i('Juli','Podesta','en','F',1,'Y');
   i('Kimi','Shiiba','en','M',1,'Y');
   i('Kindra','Everage','en','F',1,'Y');
   i('Kip','Bignell','en','M',1,'Y');
   i('Kirsten','Skea','en','F',1,'Y');
   i('Kirstin','Meckler','en','F',1,'Y');
   i('Kittie','Wolske','en','F',1,'Y');
   i('Kitty','Kosinski','en','F',1,'Y');
   i('Pia','Stapf','en','F',1,'Y');
   i('Piedad','Halpainy','en','F',1,'Y');
   i('Pinkie','Dulan','en','F',1,'Y');
   i('Polly','Betran','en','F',1,'Y');
   i('Porter','Greth','en','M',1,'Y');
   i('Terrell','Flow','en','M',1,'Y');
   i('Terrie','Magpuri','en','F',1,'Y');
   i('Tiesha','Cacace','en','F',1,'Y');
   i('Tiffanie','Kershner','en','F',1,'Y');
   i('Tilda','Perniciaro','en','F',1,'Y');
   i('Timothy','Thurmer','en','M',1,'Y');
   i('Joie','Schoch','en','F',1,'Y');
   i('Jolyn','Schnur','en','F',1,'Y');
   i('Jon','Fote','en','M',1,'Y');
   i('Jonah','Burland','en','M',1,'Y');
   i('Jonelle','Denice','en','F',1,'Y');
   i('Jonie','Danaher','en','M',1,'Y');
   i('Jordon','Cramblit','en','M',1,'Y');
   i('Jose','Brentson','en','M',1,'Y');
   i('Joselyn','Mau','en','F',1,'Y');
   i('Josephina','Wilshusen','en','F',1,'Y');
   i('Lester','Sacks','en','M',1,'Y');
   i('Letisha','Caccia','en','F',1,'Y');
   i('Lettie','Verd','en','F',1,'Y');
   i('Letty','Haris','en','F',1,'Y');
   i('Lia','Burkin','en','F',1,'Y');
   i('Liane','Turnner','en','F',1,'Y');
   i('Librada','Lempka','en','F',1,'Y');
   i('Lidia','Beets','en','F',1,'Y');
   i('Page','Whetzell','en','M',1,'Y');
   i('Paige','Vanderhorst','en','F',1,'Y');
   i('Jules','Ruffin','en','M',1,'Y');
   i('Elin','Seidel','en','F',1,'Y');
   i('Ericka','Oconner','en','F',1,'Y');
   i('Rayford','Salley','en','M',1,'Y');
   i('Tanja','Vanover','en','F',1,'Y');
   i('Lonnie','Colby','en','M',1,'Y');
   i('Libby','Krauss','en','F',1,'Y');
   i('Hassie','Grogan','en','M',1,'Y');
   i('Roy','Nondorf','en','M',1,'Y');
   i('Victor','Morris','en','M',1,'Y');
   i('Justin','King','en','M',1,'Y');
   i('Cheryl','Phillips','en','F',1,'Y');
   i('Joan','Varnell','en','M',1,'Y');
   i('Jennifer','Cooper','en','F',1,'Y');
   i('Irene','Moore','en','F',1,'Y');
   i('Angela','Gugino','en','F',1,'Y');
   i('Arthur','Hill','en','M',1,'Y');
   i('Denise','White','en','F',1,'Y');
   i('Andrea','James','en','M',1,'Y');
   i('Pamela','Fenstermaker','en','F',1,'Y');
   i('Edward','Rawle','en','M',1,'Y');
   i('Carolyn','Wood','en','F',1,'Y');
   i('Ernest','Boyarski','en','M',1,'Y');
   i('Patricia','Ruggiero','en','F',1,'Y');
   i('Mary','Barnes','en','F',1,'Y');
   i('Evelyn','Torres','en','F',1,'Y');
   i('Carl','Lee','en','M',1,'Y');
   i('Judy','Skapura','en','F',1,'Y');
   i('Michelle','Ramirez','en','F',1,'Y');
   i('Ralph','Foster','en','M',1,'Y');
   i('Peter','Jones','en','M',1,'Y');
   i('Dennis','Lopez','en','M',1,'Y');
   i('Jonathan','Coleman','en','M',1,'Y');
   i('Walter','Turner','en','M',1,'Y');
   i('Beverly','Poynter','en','F',1,'Y');
   i('Oscar','Moye','en','M',1,'Y');
   i('Kris','Krill','en','M',1,'Y');
   i('Fred','Fontain','en','M',1,'Y');
   i('Finian','Park','en','M',1,'Y');
   i('Florencia','Hopkins','en','F',1,'Y');
   i('Kimiko','Brien','en','F',1,'Y');
   i('Michael','Harris','en','M',1,'Y');
   i('Witney','Rockwell','en','F',1,'Y');
   i('Kellan','Ye','en','M',1,'Y');
   i('Tamika','Hu','en','F',1,'Y');
   i('Michael','Smith','en','M',1,'Y');
   i('Shamira','Hair','en','F',1,'Y');
   i('Clair','Maldonado','en','F',1,'Y');
   i('Pedro','Aenlo','en','M',1,'Y');
   i('Eva','Ogatius','en','F',1,'Y');
   i('Harriet','Auxus','en','F',1,'Y');
   i('Glaubo','Rinnaia','en',null,1,'Y');
   i('Roberto','Sipaia','en','M',1,'Y');
   i('Felix','Auvacia','en','M',1,'Y');
   i('Santiago','Vautus','en','M',1,'Y');
   i('Paz','Montilla','en','F',1,'Y');
   i('Doria','Arce','en','F',1,'Y');
   i('Dinah','Paredes','en','F',1,'Y');
   i('Connie','Delagarza','en','F',1,'Y');
   i('Lovie','Ritacco','en','F',1,'Y');
   i('Chaya','Greczkowski','en','F',1,'Y');
   i('Carlotta','Achenbach','en','F',1,'Y');
   i('Jeraldine','Audet','en','F',1,'Y');
   i('Ward','Stepney','en','M',1,'Y');
   i('Ayana','Barkhurst','en','F',1,'Y');
   i('Lecia','Alvino','en','F',1,'Y');
   i('Joleen','Himmelmann','en','F',1,'Y');
   i('Dania','Grizzard','en','F',1,'Y');
   i('Fidel','Creps','en','M',1,'Y');
   i('Luis','Pothoven','en','M',1,'Y');
   i('Gricelda','Luebbers','en','F',1,'Y');
   i('Milo','Manoni','en','M',1,'Y');
   i('Laurice','Karl','en','F',1,'Y');
   i('Joseph','Wilke','en','M',1,'Y');
   i('Nella','Rupnick','en','F',1,'Y');
   i('Stefany','Waninger','en','F',1,'Y');
   i('Arron','Waclawski','en','M',1,'Y');
   i('Marc','Domanski','en','M',1,'Y');
   i('Kaylene','Lusco','en','F',1,'Y');
   i('Rob','Kempt','en','M',1,'Y');
   i('Boyd','Rearden','en','M',1,'Y');
   i('Ambrose','Hiday','en','M',1,'Y');
   i('Horacio','Rainbolt','en','M',1,'Y');
   i('Carolyne','Centore','en','F',1,'Y');
   i('Cornell','Pratico','en','M',1,'Y');
   i('Shakita','Sablock','en','F',1,'Y');
   i('Sandy','Heffren','en','F',1,'Y');
   i('Shira','Arocho','en','F',1,'Y');
   i('Carter','Sacarello','en','M',1,'Y');
   i('Brooks','Craker','en','M',1,'Y');
   i('Luther','Ardinger','en','M',1,'Y');
   i('Cori','Ablin','en','F',1,'Y');
   i('Reinaldo','Feltner','en','M',1,'Y');
   i('Erda','Sheer','en','M',1,'Y');
   i('Anisa','Kurtz','en','F',1,'Y');
   i('Dorathy','Hutchings','en','F',1,'Y');
   i('Maryalice','Evers','en','F',1,'Y');
   i('Gene','Mcginnis','en','M',1,'Y');
   i('Lucila','Heck','en','F',1,'Y');
   i('Tish','Stapleton','en','F',1,'Y');
   i('Shawn','Sorenson','en','M',1,'Y');
   i('Cheree','Kemp','en','F',1,'Y');
   i('Zulma','Olds','en','F',1,'Y');
   i('Monte','Calloway','en','M',1,'Y');
   i('Gisela','Costello','en','F',1,'Y');
   i('Tammy','Bryant','en','F',1,'Y');
   i('Gary','Jenkins','en','M',1,'Y');
   i('Harold','Griffin','en','M',1,'Y');
   i('Margaret','Vallarta','en','F',1,'Y');
   i('Nancy','Hall','en','F',1,'Y');
   i('Gerald','Evans','en','M',1,'Y');
   i('Stephen','Butler','en','M',1,'Y');
   i('Pamela','Gonzalez','en','F',1,'Y');
   i('Robert','Simmons','en','M',1,'Y');
   i('Theresa','Walkner','en','F',1,'Y');
   i('Justin','Mccallister','en','M',1,'Y');
   i('Lisa','Williver','en','F',1,'Y');
   i('Harry','Powell','en','M',1,'Y');
   i('Jeremy','Howard','en','M',1,'Y');
   i('Joshua','Nelson','en','M',1,'Y');
   i('Sandra','Bennett','en','F',1,'Y');
   i('Douglas','Flores','en','M',1,'Y');
   i('Gregory','Sanchez','en','M',1,'Y');
   i('Elizabeth','Martinez','en','F',1,'Y');
   i('Kathryn','Rogers','en','F',1,'Y');
   i('Martha','Baker','en','F',1,'Y');
   i('Anna','Murphy','en','F',1,'Y');
   i('Teresa','Horvath','en','F',1,'Y');
   i('Raul','Haelfeius','en','M',1,'Y');
   i('Daniella','Almonte','en','F',1,'Y');
   i('Marco','Slivka','en','M',1,'Y');
   i('Danica','Riogas','en','F',1,'Y');
   i('Lai','Kurtich','en','F',1,'Y');
   i('Vincent','Hibberd','en','M',1,'Y');
   i('Andrew','Schieferstein','en','M',1,'Y');
   commit;
  end;
  /
  declare
    procedure i (
      p_domain              in varchar2,
      p_lang                in varchar2,
      p_vc1                 in varchar2,
      p_vc2                 in varchar2 default null,
      p_vc3                 in varchar2 default null,
      p_vc4                 in varchar2 default null,
      p_vc5                 in varchar2 default null,
      p_vc6                 in varchar2 default null,
      p_vc7                 in varchar2 default null,
      p_vc8                 in varchar2 default null,
      p_vc9                 in varchar2 default null,
      p_vc10                in varchar2 default null,
      p_vc11                in varchar2 default null,
      p_vc12                in varchar2 default null,
      p_vc13                in varchar2 default null,
      p_vc14                in varchar2 default null,
      p_vc15                in varchar2 default null,
      p_vc16                in varchar2 default null,
      p_vc17                in varchar2 default null,
      p_vc18                in varchar2 default null,
      p_vc19                in varchar2 default null,
      p_vc20                in varchar2 default null,
      p_vc21                in varchar2 default null,
      p_vc22                in varchar2 default null,
      p_vc23                in varchar2 default null,
      p_vc24                in varchar2 default null,
      p_vc25                in varchar2 default null,
      p_vc26                in varchar2 default null,
      p_vc27                in varchar2 default null,
      p_vc28                in varchar2 default null,
      p_vc29                in varchar2 default null,
      p_vc30                in varchar2 default null,
      p_n1                  in number default null,
      p_n2                  in number default null,
      p_n3                  in number default null,
      p_n4                  in number default null,
      p_n5                  in number default null,
      p_n6                  in number default null,
      p_n7                  in number default null,
      p_n8                  in number default null,
      p_n9                  in number default null,
      p_n10                 in number default null,
      p_d1                  in date default null,
      p_d2                  in date default null,
      p_d3                  in date default null,
      p_d4                  in date default null,
      p_d5                  in date default null,
      p_version_number      in number default null,
      p_seeded_data_yn      in varchar2  default null
    )
    is
    begin
      insert into wwv_dg_helper_data (domain,lang,vc1,vc2,vc3,vc4,vc5,vc6,vc7,vc8,vc9,vc10,vc11,vc12,vc13,vc14,vc15,vc16,vc17,vc18,vc19,vc20,vc21,vc22,vc23,vc24,vc25,vc26,vc27,vc28,vc29,vc30,n1,n2,n3,n4,n5,n6,n7,n8,n9,n10,d1,d2,d3,d4,d5,version_number,seeded_data_yn)
      values (p_domain, p_lang, p_vc1, p_vc2, p_vc3, p_vc4, p_vc5, p_vc6, p_vc7, p_vc8, p_vc9, p_vc10, p_vc11, p_vc12, p_vc13, p_vc14, p_vc15, p_vc16, p_vc17, p_vc18, p_vc19, p_vc20, p_vc21, p_vc22, p_vc23, p_vc24, p_vc25, p_vc26, p_vc27, p_vc28, p_vc29, p_vc30, p_n1, p_n2, p_n3, p_n4, p_n5, p_n6, p_n7, p_n8, p_n9, p_n10, p_d1, p_d2, p_d3, p_d4, p_d5, 1, 'Y') ;
    end i;
  begin
   i('2D_SHAPES','en','Circle',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Icosagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Crescent',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Triangle',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Rhombus',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Square',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Trapezoid',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Rectangle',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Pentagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Hexagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Heptagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Octagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Nonagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Decagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,10,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Pentagram',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,10,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Hendecagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,11,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Dodecagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,12,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Hexagram',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,12,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Tridecagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,13,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Tetradecagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,14,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Pentadecagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,15,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Hexadecagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,16,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Heptadecagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,17,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Octadecagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,18,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Enneaddecagon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,19,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('2D_SHAPES','en','Half-circle',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Sphere',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,0,0,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Decagonal Prism',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,12,30,20,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Cylinder',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,2,0,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Cube',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6,12,8,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Triangular Pyramid',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,6,4,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Square Pyramid',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,8,5,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Pentagonal Pyramid',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6,10,6,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Hexagonal Pyramid',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7,12,7,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Heptagonal Pyramid',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8,14,8,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Octagonal Pyramid',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9,16,9,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Enneagonal Pyramid',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,10,18,10,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Decagonal Pyramid',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,11,20,11,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Isosceles Tetrahedron',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,6,4,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Triangular Prism',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,9,6,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Pentagonal Prism',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7,15,10,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Hexagonal Prism',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8,18,12,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Heptagonal Prism',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9,21,14,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Octagonal Prism',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,10,24,16,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Enneagonal Prism',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,11,27,18,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('3D_SHAPES','en','Cone',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,1,1,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('BOOLEANS','en','TRUE','Y',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('BOOLEANS','en','FALSE','N',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('BOOLEANS','en','TRUE','Y',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('BOOLEANS','en','FALSE','N',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Cyan','#00ffff','0,255,255',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Black','#000000','0,0,0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Violet','#ee82ee','238,130,238',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Grey','#808080','128,128,128',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Orange','#ffa500','255,165,0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Pink','#ffc0cb','255,192,203',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Olive','#808000','128,128,0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Brown','#8b4513','139,69,19',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Forest','#228B22','34,139,34',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Red','#FF0000','255,0,0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','White','#FFFFFF','255,255,255',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Blue','#0000FF','0,0,255',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Green','#00FF00','0,255,0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Yellow','#FFFF00','255,255,0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COLORS','en','Teal','#008080','0,128,128',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Armenia','C.W. of Ind. States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2977271,29801,99.9,3400,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Aruba','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,71965,195,369.1,28100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Australia','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20255350,7687059,2.6,29100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Austria','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8193250,83874,97.7,29900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Azerbaijan','C.W. of Ind. States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7962547,86621,91.9,3400,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Bahamas, The ','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,303921,13971,21.8,16700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Bahrain','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,698556,676,1033.4,17000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Bangladesh','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,147300622,144315,1020.7,1900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Barbados','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,279991,441,634.9,15600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Belarus','C.W. of Ind. States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,10286430,207775,49.5,6300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Belgium','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,10384659,30559,339.8,29100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Belize','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,287641,22998,12.5,4800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Benin','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7863962,113353,69.4,1000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Bermuda','Northern America',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,65782,53,1241,36000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Bhutan','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2279546,47038,48.5,1300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Bolivia','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8989038,1098697,8.2,2300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Bosnia & Herzegovina','Eastern Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4498349,51163,87.9,6100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Botswana','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1639298,600886,2.7,8900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Brazil','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,188091990,8512037,22.1,7700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','British Virgin Is.','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,23189,161,144,16200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Brunei','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,379437,5768,65.8,18500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Bulgaria','Eastern Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7384583,111224,66.4,7600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Burkina Faso','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,13908646,274897,50.6,1300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Burma','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,47380446,678802,69.8,1900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Burundi','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8089116,27854,290.4,600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Cambodia','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,13880926,181803,76.4,1900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Cameroon','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,17343060,476060,36.4,1800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Canada','Northern America',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,33093237,9984880,3.3,29900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Cape Verde','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,420962,4045,104.1,1400,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Cayman Islands','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,45449,262,173.5,34900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Central African Rep.','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4302886,622978,6.9,1100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Chad','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9945026,1284810,7.7,1200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Chile','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,16136937,757143,21.3,10000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','China','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1314043304,9597826,136.9,5000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Colombia','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,43592974,1139248,38.3,6400,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Comoros','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,691053,2183,316.6,700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Congo, Dem. Rep. ','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,62659443,2345477,26.7,700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Congo, Repub. of the ','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3701433,341952,10.8,700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Cook Islands','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,21431,239,89.7,5100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Costa Rica','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4075546,51130,79.7,9100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Cote d''Ivoire','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,17654704,323363,54.6,1600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Croatia','Eastern Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4495433,56560,79.5,10600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Cuba','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,11389564,110801,102.8,2900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Cyprus','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,784387,9265,84.7,19300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Czech Republic','Eastern Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,10225672,78883,129.6,15900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Denmark','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5449817,43132,126.4,31300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Djibouti','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,486538,23005,21.1,1300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Dominica','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,68991,759,90.9,5500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Dominican Republic','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9184011,48732,188.5,5900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','East Timor','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1063383,15014,70.8,500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Saint Kitts & Nevis','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,39124,265,147.6,8700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Saint Lucia','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,168397,627,268.6,5600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','St Pierre & Miquelon','Northern America',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7026,243,28.9,6800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Saint Vincent and the Grenadines','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,117801,394,299,2800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Samoa','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,177052,2944,60.1,5700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','San Marino','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,29273,61,479.5,34700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Sao Tome & Principe','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,193538,1013,191.1,1100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Saudi Arabia','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,27024427,1961145,13.8,11800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Senegal','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,11982111,196287,61,1500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Serbia','Eastern Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9396294,88353,106.3,2200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Seychelles','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,81569,469,173.9,8000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Sierra Leone','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6006218,71746,83.7,500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Singapore','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4491933,707,6353.5,23800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Slovakia','Eastern Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5438531,48863,111.3,13200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Slovenia','Eastern Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2010729,20297,99.1,19100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Solomon Islands','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,552474,28490,19.4,1800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Somalia','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8862613,637594,13.9,500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','South Africa','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,44182922,1220093,36.2,10800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Spain','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,40406419,504681,80.1,22000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Sri Lanka','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20215203,65636,308,3700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Sudan','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,41237252,2506132,16.5,1900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Suriname','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,439075,163815,2.7,4000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Swaziland','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1137195,17401,65.4,4900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Sweden','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9017567,450780,20,26800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Switzerland','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7524289,41315,182.1,32700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Syria','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,18874463,185510,101.7,3200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Taiwan','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,23043860,35988,640.3,23600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Tajikistan','C.W. of Ind. States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7321095,143547,51,1000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Tanzania','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,37440185,945858,39.6,600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Thailand','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,64639280,514975,125.5,7500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Togo','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5549554,56814,97.7,1600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Tonga','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,114656,753,152.3,2200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Trinidad & Tobago','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1066587,5133,207.8,9600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Tunisia','Northern Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,10168210,164115,62,6900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Turkey','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,70420564,780570,90.2,6700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Turkmenistan','C.W. of Ind. States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5041841,489006,10.3,5800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Turks & Caicos Is','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,21170,428,49.5,9700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Tuvalu','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,11865,26,454.2,1300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Uganda','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,28188374,236027,119.4,1500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Ukraine','C.W. of Ind. States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,46705471,604665,77.2,5600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','United Arab Emirates','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2602989,82891,31.4,23300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','United Kingdom','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,60604697,245578,246.8,27800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','United States','Northern America',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,298476107,9631399,31,37900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Uruguay','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3432631,176388,19.5,12900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Uzbekistan','C.W. of Ind. States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,27311341,447377,61,1600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Vanuatu','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,208820,12208,17.1,3000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Venezuela','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,25726643,912545,28.2,4800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Vietnam','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,84395018,330027,255.7,2600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Virgin Islands','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,108761,1907,57,17300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Wallis and Futuna','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,16117,273,59,3800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','West Bank','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2459774,5859,419.8,800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Western Sahara','Northern Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,273121,266255,1,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Yemen','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,21451386,528865,40.6,800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Zambia','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,11500848,753271,15.3,800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Zimbabwe','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,12229548,391421,31.2,2000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Afghanistan','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,31065804,648475,47.9,700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Albania','Eastern Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3582222,28765,124.5,4600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Algeria','Northern Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,32939163,2382245,13.8,5900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','American Samoa','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,57887,197,293.8,8100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Andorra','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,71258,465,153.2,18900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Angola','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,12122599,1246722,9.7,2100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Anguilla','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,13554,100,132.1,8600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Antigua & Barbuda','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,69192,452,153.1,11000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Argentina','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,39918308,2766937,14.4,11100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Kiribati','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,105485,822,128.3,800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Korea, North ','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,23104772,121103,190.8,1300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Korea, South ','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,48838452,98511,495.8,18000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Kuwait','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2417585,17827,135.6,19000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Kyrgyzstan','C.W. of Ind. States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5213667,198524,26.3,1700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Laos','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6368931,236823,26.9,1600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Latvia','Baltics',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2274663,64589,35.2,10400,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Lebanon','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3873508,10424,371.6,4700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Lesotho','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2021906,30368,66.6,3100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Liberia','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3041656,111306,27.3,1000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Libya','Northern Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5901396,1760483,3.4,6500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Liechtenstein','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,33991,165,206,25000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Lithuania','Baltics',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3586801,65190,55,11400,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Luxembourg','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,474473,2598,182.6,55200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Macau','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,453045,28,16183,19600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Macedonia','Eastern Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2051181,25339,80.9,6800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Madagascar','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,18591583,587542,31.6,800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Malawi','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,13017627,119173,109.2,600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Malaysia','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,24380705,329920,73.9,9200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Maldives','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,358970,303,1184.7,3800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Mali','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,11718617,1240198,9.4,900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Malta','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,400175,319,1254.5,17700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Marshall Islands','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,60444,11868,5.1,1800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Martinique','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,436270,1111,392.7,14300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Mauritania','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3176650,1031164,3.1,1800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Mauritius','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1240183,2051,604.7,11500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Mayotte','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,201244,384,524.1,2600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Mexico','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,107496094,1972655,54.5,9000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Micronesia, Fed. St. ','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,108163,706,153.2,2000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Moldova','C.W. of Ind. States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4466869,33873,131.9,1800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Monaco','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,32627,2,16271.5,27100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Mongolia','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2831351,1564233,1.8,1900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Montserrat','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9439,104,90.8,3500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Morocco','Northern Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,33235253,447112,74.3,4000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Mozambique','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,19679136,802144,24.5,1400,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Namibia','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2043450,825681,2.5,7300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Nauru','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,13295,21,632.7,5100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Nepal','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,28284117,148034,191.1,1400,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Netherlands','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,16482887,41554,396.7,28500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Netherlands Antilles','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,221806,975,227.5,11500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','New Caledonia','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,219363,19084,11.5,15100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','New Zealand','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4076784,269677,15.1,21800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Nicaragua','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5569575,130179,42.8,2200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Niger','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,12529419,1267710,9.9,800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Nigeria','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,131769622,924790,142.5,900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','N. Mariana Islands','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,82532,478,172.7,12500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Norway','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4610835,324725,14.2,37900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Oman','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3101491,212561,14.6,13100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Pakistan','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,165892916,804829,206.1,2200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Palau','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20614,466,44.2,9000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Panama','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3190486,78209,40.8,6200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Papua New Guinea','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5671478,463460,12.2,2400,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Paraguay','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6505653,406747,16,4600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Peru','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,28312225,1285975,22,5000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Philippines','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,89464845,300851,297.4,4500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Poland','Eastern Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,38546191,313156,123.1,11100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Portugal','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,10612835,92412,114.8,18000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Puerto Rico','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3927187,13827,284,16800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Qatar','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,885458,11447,77.4,21600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Reunion','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,787594,2515,313.2,5800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Romania','Eastern Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,22305439,237553,93.9,7100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Russia','C.W. of Ind. States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,142902733,17075793,8.4,9000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Rwanda','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8647909,26350,328.2,1200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Saint Helena','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7502,419,17.9,2400,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Ecuador','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,13539577,284057,47.7,3400,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Egypt','Northern Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,78880562,1002400,78.7,3900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','El Salvador','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6822061,21052,324.1,5000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Equatorial Guinea','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,540099,28091,19.2,2600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Eritrea','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4787315,121392,39.4,700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Estonia','Baltics',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1325118,45237,29.3,12300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Ethiopia','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,74769136,1128126,66.3,700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Faroe Islands','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,47338,1402,33.8,22200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Fiji','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,905867,18289,49.5,5800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Finland','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5230526,338557,15.4,27500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','France','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,60870398,547010,111.3,27700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','French Guiana','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,199486,91038,2.2,8300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','French Polynesia','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,274694,4174,65.8,17400,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Gabon','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1424763,267728,5.3,5500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Gambia, The ','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1642580,11311,145.2,1600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Gaza Strip','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1429033,366,3904.5,600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Georgia','C.W. of Ind. States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4660819,69709,66.9,2400,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Germany','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,82426185,357084,230.8,27700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Ghana','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,22416800,239613,93.6,2300,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Gibraltar','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,27954,7,3989.7,17600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Greece','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,10684406,132158,80.8,20100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Greenland','Northern America',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,56369,2166850,0,20100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Grenada','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,89750,354,253.5,4900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Guadeloupe','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,452774,1777,254.8,8000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Guam','Oceania',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,171130,555,308.3,21000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Guatemala','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,12300339,109207,112.6,4200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Guernsey','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,65401,78,838.6,20200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Guinea','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9689904,246340,39.3,2200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Guinea-Bissau','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1441650,36147,39.9,800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Guyana','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,767384,215260,3.6,4000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Haiti','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8308164,27745,299.4,1700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Honduras','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7326824,112810,64.9,2800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Hong Kong','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6940764,1095,6338.6,28800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Hungary','Eastern Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9981166,93060,107.3,14100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Iceland','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,299280,103030,2.9,31000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','India','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1095262259,3288353,333.1,3100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Indonesia','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,245478990,1919777,127.9,3200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Iran','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,68681888,1648505,41.7,7100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Iraq','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,26790746,437070,61.3,1500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Ireland','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4062900,70307,57.8,29600,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Isle of Man','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,75527,582,129.8,21000,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Israel','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6351729,20791,305.5,19700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Italy','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,58123653,301806,192.6,26800,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Jamaica','Latin Amer. & Carib',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2757354,11012,250.4,3900,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Japan','Asia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,127443003,378086,337.1,28200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Jersey','Western Europe',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,91155,129,706.6,24700,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Jordan','Near East',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5906941,92300,64,4500,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Kazakhstan','C.W. of Ind. States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,15227639,2717717,5.6,6200,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('COUNTRIES','en','Kenya','Sub-Saharan Africa',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,34711270,582844,59.6,1100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','Math',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','Consulting',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','History',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','Administration',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','English',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','Operations',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','Justice',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','State',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','Treasury',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','Labor',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','Agriculture',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','HR',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','Research',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','R&D',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('DEPARTMENT','en','Science',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Niobium','Nb','transition metal','[Kr] 4d4 5s1','solid','7440-03-1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,41,92.906372,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Molybdenum','Mo','transition metal','[Kr] 4d5 5s1','solid','7439-98-7',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,42,95.951,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Technetium','Tc','transition metal','[Kr] 4d5 5s2','solid','7440-26-8',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,43,98,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Ruthenium','Ru','transition metal','[Kr] 4d7 5s1',null,'7440-18-8',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,44,101.072,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Rhodium','Rh','transition metal','[Kr] 4d8 5s1','solid','7440-16-6',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,45,102.905502,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Palladium','Pd','transition metal','[Kr] 4d10','solid','7440-05-3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,46,106.421,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Silver','Ag','transition metal','[Kr] 4d10 5s1','solid','7440-22-4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,47,107.86822,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Cadmium','Cd','transition metal, alternatively considered a post-transition metal','[Kr] 4d10 5s2','solid','7440-43-9',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,48,112.4144,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Indium','In','post-transition metal','[Kr] 4d10 5s2 5p1','solid','7440-74-6',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,49,114.8181,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Tungsten','W','transition metal','[Xe] 4f14 5d4 6s2','solid','7440-33-7',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,74,183.841,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Rhenium','Re','transition metal','[Xe] 4f14 5d5 6s2','solid','7440-15-5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,75,186.2071,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Osmium','Os','transition metal','[Xe] 4f14 5d6 6s2','solid','7440-04-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,76,190.233,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Iridium','Ir','transition metal','[Xe] 4f14 5d7 6s2','solid','7439-88-5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,77,192.2173,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Platinum','Pt','transition metal','[Xe] 4f14 5d9 6s1','solid','7440-06-4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,78,195.0849,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Gold','Au','transition metal','[Xe] 4f14 5d10 6s1','solid','7440-57-5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,79,196.9665695,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Mercury','Hg','transition metal, alternatively considered a post-transition metal','[Xe] 4f14 5d10 6s2','liquid','7439-97-6',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,80,200.5923,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Thallium','Tl','post-transition metal','[Xe] 4f14 5d10 6s2 6p1','solid','7440-28-0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,81,204.38,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Lead','Pb','post-transition metal','[Xe] 4f14 5d10 6s2 6p2','solid','7439-92-1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,82,207.21,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Bismuth','Bi','post-transition metal','[Xe] 4f14 5d10 6s2 6p3','solid','7440-69-9',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,83,208.980401,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Polonium','Po','post-transition metal, but this status is disputed','[Xe] 4f14 5d10 6s2 6p4','solid','7440-08-6',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,84,209,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Astatine','At','metalloid, sometimes classified as a nonmetal, or a metal','[Xe] 4f14 5d10 6s2 6p5','solid','7440-68-8',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,210,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Radon','Rn','noble gas','[Xe] 4f14 5d10 6s2 6p6','gas','10043-92-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,86,222,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Francium','Fr','alkali metal','[Rn] 7s1','solid presumably','7440-73-5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,87,223,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Radium','Ra','alkaline earth metal','[Rn] 7s2','solid','7440-14-4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,88,226,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Actinium','Ac','actinide, sometimes considered a transition metal','[Rn] 6d1 7s2','solid','7440-34-8',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,89,227,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Thorium','Th','actinide','[Rn] 6d2 7s2','solid','7440-29-1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,90,232.03774,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Protactinium','Pa','actinide','[Rn] 5f2 6d1 7s2','solid','7440-13-3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,91,231.035882,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Uranium','U','actinide','[Rn] 5f3 6d1 7s2','solid','7440-61-1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,92,238.028913,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Neptunium','Np','actinide','[Rn] 5f4 6d1 7s2','solid','7439-99-8',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,93,237,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Plutonium','Pu','actinide','[Rn] 5f6 7s2','solid','7440-07-5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,94,244,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Americium','Am','actinide','[Rn] 5f7 7s2','solid','7440-35-9',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,95,243,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Curium','Cm','actinide','[Rn] 5f7 6d1 7s2','solid','7440-51-9',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,96,247,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Berkelium','Bk','actinide','[Rn] 5f9 7s2','solid','7440-40-6',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,97,247,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Californium','Cf','actinide','[Rn] 5f10 7s2','solid','7440-71-3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,98,251,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Einsteinium','Es','actinide','[Rn] 5f11 7s2','solid','7429-92-7',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,99,252,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Fermium','Fm','actinide','[Rn] 5f12 7s2','solid (predicted)','7440-72-4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,257,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Mendelevium','Md','actinide','[Rn] 5f13 7s2','solid (predicted)','7440-11-1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,101,258,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Nobelium','No','actinide','[Rn] 5f14 7s2','solid (predicted)','10028-14-5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,102,259,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Lawrencium','Lr','actinide, sometimes considered a transition metal','[Rn] 5f14 7s2 7p1','solid (predicted)','22537-19-5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,103,266,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Dubnium','Db','transition metal','[Rn] 5f14 6d3 7s2','solid (predicted)','53850-35-4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,105,268,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Seaborgium','Sg','transition metal','[Rn] 5f14 6d4 7s2','solid (predicted)','54038-81-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,106,269,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Bohrium','Bh','transition metal','[Rn] 5f14 6d5 7s2','solid (predicted)','54037-14-8',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,107,270,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Hassium','Hs','transition metal','[Rn] 5f14 6d6 7s2','solid (predicted)','54037-57-9',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,108,269,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Meitnerium','Mt','unknown, but probably a transition metal','[Rn] 5f14 6d7 7s2 (calculated)','solid (predicted)','54038-01-6',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,109,278,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Darmstadtium','Ds','unknown, but probably a transition metal','[Rn] 5f14 6d8 7s2, (predicted)','solid (predicted)','54083-77-1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,110,281,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Roentgenium','Rg','unknown, but probably a transition metal','[Rn] 5f14 6d9 7s2 (predicted)','solid (predicted)','54386-24-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,111,282,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Ununbium','Uub','transition metal, alternatively considered a post-transition metal','[Rn] 5f14 6d10 7s2 (predicted)','gas (predicted)','54084-26-3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,112,285,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Ununtrium','Uut','unknown, but probably a post-transition metal','[Rn] 5f14 6d10 7s2 7p1 (predicted)','solid (predicted)','54084-70-7',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,113,286,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Ununquadium','Uuq','post-transition metal','[Rn] 5f14 6d10 7s2 7p2 (predicted)','solid (predicted)','54085-16-4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,114,289,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Ununpentium','Uup','unknown, but probably a post-transition metal','[Rn] 5f14 6d10 7s2 7p3 (predicted)','solid (predicted)','54085-64-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,115,289,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Ununhexium','Uuh','unknown, but probably a post-transition metal','[Rn] 5f14 6d10 7s2 7p4 (predicted)','solid (predicted)','54100-71-9',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,116,293,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Ununseptium','Uus','unknown, but probably a post-transition metal','[Rn] 5f14 6d10 7s2 7p5 (predicted)','solid (predicted)','54101-14-3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,117,294,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Ununoctium','Uuo','unknown, but predicted to be a noble gas','[Rn] 5f14 6d10 7s2 7p6 (predicted)','solid (predicted)','54144-19-3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,118,294,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Hydrogen','H','diatomic nonmetal','1s1','gas','1333-74-0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,1.008,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Helium','He','noble gas','1s2','gas','7440-59-7',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,4.0026022,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Lithium','Li','alkali metal','[He] 2s1','solid','7439-93-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,6.94,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Beryllium','Be','alkaline earth metal','[He] 2s2','solid','7440-41-7',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,9.01218315,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Boron','B','metalloid','[He] 2s2 2p1','solid','7440-42-8',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,10.81,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Carbon','C','polyatomic nonmetal, sometimes considered a metalloid','[He] 2s2 2p2','solid','7440-44-0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6,12.011,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Nitrogen','N','diatomic nonmetal','[He] 2s2 2p3','gas','7727-37-9',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7,14.007,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Oxygen','O','diatomic nonmetal','[He] 2s2 2p4','gas','7782-44-7',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8,15.999,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Fluorine','F','diatomic nonmetal','[He] 2s2 2p5','gas','7782-41-4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9,18.99840316,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Neon','Ne','noble gas','[He] 2s2 2p6','gas','7440-01-9',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,10,20.17976,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Sodium','Na','alkali metal','[Ne] 3s1','solid','7440-23-5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,11,22.98976928,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Magnesium','Mg','alkaline earth metal','[Ne] 3s2','solid','7439-95-4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,12,24.305,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Aluminum','Al','post-transition metal, sometimes considered a metalloid','[Ne] 3s2 3p1','solid','7429-90-5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,13,26.98153857,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Silicon','Si','metalloid','[Ne] 3s2 3p2','solid','7440-21-3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,14,28.085,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Phosphorus','P','polyatomic nonmetal','[Ne] 3s2 3p3','solid','white: 12185-10-3, red: 7723-14-0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,15,30.973762,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Sulfur','S','polyatomic nonmetal','[Ne] 3s2 3p4','solid','7704-34-9',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,16,32.06,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Chlorine','Cl','diatomic nonmetal','[Ne] 3s2 3p5','gas','7782-50-5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,17,35.45,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Argon','Ar','noble gas','[Ne] 3s2 3p6','gas','7440-37-1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,18,39.9481,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Potassium','K','alkali metal','[Ar] 4s1','solid','7440-09-7',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,19,39.09831,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Calcium','Ca','alkaline earth metal','[Ar] 4s2','solid','7440-70-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20,40.0784,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Scandium','Sc','transition metal','[Ar] 3d1 4s2','solid','7440-20-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,21,44.9559085,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Titanium','Ti','transition metal','[Ar] 3d2 4s2','solid','7440-32-6',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,22,47.8671,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Vanadium','V','transition metal','[Ar] 3d3 4s2','solid','7440-62-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,23,50.94151,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Chromium','Cr','transition metal','[Ar] 3d5 4s1','solid','7440-47-3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,24,51.99616,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Manganese','Mn','transition metal','[Ar] 3d5 4s2','solid','7439-96-5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,25,54.9380443,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Iron','Fe','transition metal','[Ar] 3d6 4s2','solid','7439-89-6',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,26,55.8452,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Cobalt','Co','transition metal','[Ar] 3d7 4s2','solid','7440-48-4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,27,58.9331944,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Nickel','Ni','transition metal','[Ar] 3d8 4s2 or, [Ar] 3d9 4s1','solid','7440-02-0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,28,58.69344,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Copper','Cu','transition metal','[Ar] 3d10 4s1','solid','7440-50-8',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,29,63.5463,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Zinc','Zn','transition metal, alternatively considered a post-transition metal','[Ar] 3d10 4s2','solid','7440-66-6',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,30,65.382,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Gallium','Ga','post-transition metal','[Ar] 3d10 4s2 4p1','solid','7440-55-3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,31,69.7231,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Germanium','Ge','metalloid','[Ar] 3d10 4s2 4p2','solid','7440-56-4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,32,72.6308,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Arsenic','As','metalloid','[Ar] 3d10 4s2 4p3','solid','7440-38-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,33,74.9215956,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Selenium','Se','polyatomic nonmetal, sometimes considered a metalloid','[Ar] 3d10 4s2 4p4','solid','7782-49-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,34,78.9718,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Tin','Sn','post-transition metal','[Kr] 4d10 5s2 5p2','solid','7440-31-5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,118.7107,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Antimony','Sb','metalloid','[Kr] 4d10 5s2 5p3','solid','7440-36-0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,51,121.7601,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Tellurium','Te','metalloid','[Kr] 4d10 5s2 5p4','solid','13494-80-9',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,52,127.603,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Iodine','I','diatomic nonmetal','[Kr] 4d10 5s2 5p5','solid','7553-56-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,53,126.904473,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Xenon','Xe','noble gas','[Kr] 4d10 5s2 5p6','gas','7440-63-3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,54,131.2936,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Cesium','Cs','alkali metal','[Xe] 6s1','solid','7440-46-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,55,132.905452,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Barium','Ba','alkaline earth metals','[Xe] 6s2','solid','7440-39-3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,56,137.3277,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Lanthanum','La','lanthanide, sometimes considered a transition metal','[Xe] 5d1 6s2','solid','7439-91-0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,57,138.905477,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Cerium','Ce','lanthanide','[Xe] 4f1 5d1 6s2','solid','7440-45-1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,58,140.1161,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Praseodymium','Pr','lanthanide','[Xe] 4f3 6s2','solid','7440-10-0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,59,140.907662,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Neodymium','Nd','lanthanide','[Xe] 4f4 6s2','solid','7440-00-8',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,60,144.2423,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Promethium','Pm','lanthanide','[Xe] 4f5 6s2','solid','7440-12-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,61,145,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Samarium','Sm','lanthanide','[Xe] 4f6 6s2','solid','7440-19-9',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,62,150.362,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Europium','Eu','lanthanide','[Xe] 4f7 6s2','solid','7440-53-1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,63,151.9641,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Gadolinium','Gd','lanthanide','[Xe] 4f7 5d1 6s2','solid','7440-54-2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,64,157.253,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Terbium','Tb','lanthanide','[Xe] 4f9 6s2','solid','7440-27-9',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,65,158.925352,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Dysprosium','Dy','lanthanide','[Xe] 4f10 6s2','solid','7429-91-6',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,66,162.5001,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Holmium','Ho','lanthanide','[Xe] 4f11 6s2','solid','7440-60-0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,67,164.930332,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Erbium','Er','lanthanide','[Xe] 4f12 6s2','solid','7440-52-0',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,68,167.2593,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Thulium','Tm','lanthanide','[Xe] 4f13 6s2','solid','7440-30-4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,69,168.934222,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Ytterbium','Yb','lanthanide','[Xe] 4f14 6s2','solid','7440-64-4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,70,173.0451,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Lutetium','Lu','lanthanide, sometimes considered a transition metal','[Xe] 6s2 4f14 5d1','solid','7439-94-3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,71,174.96681,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Hafnium','Hf','transition metal','[Xe] 4f14 5d2 6s2','solid','7440-58-6',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,72,178.492,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Tantalum','Ta','transition metal','[Xe] 4f14 5d3 6s2','solid','7440-25-7',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,73,180.947882,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Bromine','Br','diatomic nonmetal','[Ar] 3d10 4s2 4p5','liquid','7726-95-6',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,35,79.904,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Krypton','Kr','noble gas','[Ar] 3d10 4s2 4p6','gas','7439-90-9',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,36,83.7982,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Rubidium','Rb','alkali metal','[Kr] 5s1','solid','7440-17-7',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,37,85.46783,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Strontium','Sr','alkaline earth metal','[Kr] 5s2','solid','7440-24-6',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,38,87.621,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Yttrium','Y','transition metal','[Kr] 4d1 5s2','solid','7440-65-5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,39,88.905842,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ELEMENTS','en','Zirconium','Zr','transition metal','[Kr] 4d2 5s2','solid','7440-67-7',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,40,91.2242,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Salt Pork','2 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,60,470,3,55,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Bacon','2 slices',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,16,95,4,8,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Beef','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,245,23,16,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Hamburger','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,245,21,17,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Ground Beef','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,185,24,10,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Roast Beef','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,390,16,36,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Steak','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,330,20,27,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Coffee','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,230,3,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Tea','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,230,4,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cows'' milk','1 qt.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,976,660,32,40,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Buttermilk','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,246,127,9,5,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Powdered milk','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,103,515,27,28,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Goats'' milk','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,244,165,8,10,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cocoa','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,252,235,8,11,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cornstarch','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,248,275,9,10,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Custard','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,248,285,13,14,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Ice cream','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,188,300,6,18,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cream or half-and-half','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,120,170,4,15,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Apple','1 med',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,130,70,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Apricots','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,220,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Apricot Nectar','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,140,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Avocado','1/2 large',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,108,185,2,18,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Banana','1 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,150,85,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Blackberries','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,144,85,2,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Blueberries','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,245,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cantaloupe','1/2 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,380,40,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cherries','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,257,100,2,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cranberry Sauce','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,277,530,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Dates','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,178,505,4,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Figs','3 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,114,90,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Canned Figs with Syrup','3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,115,130,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Fruit Cocktail, canned','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,256,195,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Grapefruit','1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,285,50,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Grapefruit Juice','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,100,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Grapes','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,153,70,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Grape Juice','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,160,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Lemon Juice','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,125,30,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Lemonade Concentrate, frozen','6-oz. can',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,220,430,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Limeade Concentrate, frozen','6-oz. can',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,218,405,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Olives','10',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,65,72,1,10,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Orange','1 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,180,60,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Orange Juice','8 oz. or',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,112,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Papaya','1/2 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,200,75,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Peach','1 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,114,35,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Pear','1 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,182,100,1,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Persimmon','1 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,125,75,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Pineapple','1 large slice',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,122,95,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Diced Pineapple','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,140,75,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Pineapple Juice','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,120,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Plum','1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,60,30,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Prunes','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,270,300,3,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Prune Juice','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,240,170,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Raisins','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,88,230,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Raspberries','3/4 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,57,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Rhubarb','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,270,385,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Strawberries','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,149,54,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Tangerine','I med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,114,40,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Watermelon','1 wedge',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,925,120,2,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Biscuit','1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,38,130,3,4,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Bran Flakes','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,25,117,3,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Rye Bread','1 slice',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,23,55,2,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Butter','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,112,113,114,115,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Hydrogenated Cooking Fat','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,665,0,100,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Lard','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,110,992,0,110,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Margarine','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,112,806,0,91,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Mayonnaise','1 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,15,110,0,12,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Corn Oil','1 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,14,125,0,14,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Olive Oil','1 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,14,125,0,14,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Safflower Seed Oil','1 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,14,125,0,14,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','French Dressing','1 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,15,60,0,6,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Thousand Island Dressing','1 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,15,75,0,8,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Brown Sugar','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,220,815,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Syrup','2 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,40,100,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Table Sugar','2 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,40,110,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Tapioca Cream Pudding','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,335,10,10,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Almonds','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,70,425,13,38,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Roasted Almonds','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,70,439,13,40,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Brazil Nuts','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,70,457,10,47,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cashews','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,70,392,12,32,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Coconut','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,274,1,20,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','White Bread','1-lb. loaf',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,454,1.225,39,15,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Whole-wheat Bread','1-lb. loaf',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,454,1.1,48,14,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Corn Bread','1 serving',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,100,3,4,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cornflakes','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,25,110,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Corn Grits, cooked','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,242,120,8,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cornmeal','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,118,360,9,4,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Crackers','2 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,14,55,1,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Flour','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,110,460,39,22,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Wheat, all purpose','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,110,400,12,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Wheat, whole','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,120,390,13,2,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Macaroni Noodles','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,140,155,5,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Baked Macaroni and Cheese','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,220,475,18,25,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Muffins','1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,48,135,4,5,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Oatmeal','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,236,150,5,3,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Pancakes.','4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,108,250,7,9,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Pizza','1 section',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,75,180,8,6,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Popcorn, salted','2 cups',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,28,152,3,7,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Puffed Rice','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,14,55,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Puffed Wheat','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,28,105,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Rice','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,208,748,15,3,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Rice Flakes','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,30,115,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Rice Polish','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,132,6,6,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Rolls','1 large',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,411,3,12,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Spaghetti with Meat Sauce','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,285,13,10,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Steamed Potato','1 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,80,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Potato Chips','10',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20,110,1,7,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Radishes','5 small',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,10,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Rutabagas','4 cups',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,32,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Soybeans','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,200,260,22,11,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Spinach','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,26,3,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Squash','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,210,35,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Sweet Potato','1 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,110,155,2,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Candied Sweet Potato','1 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,175,235,2,6,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Tomato','1 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,150,30,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Tomato Juice','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,240,50,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Tomato Ketchup','1 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,17,15,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Turnip Greens','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,145,45,4,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Steamed Turnips','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,155,40,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Watercress Stems','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,9,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Apple Juice','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,125,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Apple Cider Vinegar','1/3 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,14,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Peanut Butter','1/3 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,300,12,25,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Peanuts','1/3 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,290,13,25,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Pecans','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,52,343,5,35,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Sesame Seeds','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,280,9,24,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Sunflower Seeds','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,280,12,26,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Walnuts','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,325,7,32,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Beer','2 cups',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,480,228,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Gin','1 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,28,70,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Wine','1/2 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,120,164,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Club Soda','12 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,346,0,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cola','12 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,346,137,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Fruit-flavored Soda','12 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,346,161,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Ginger Ale','12 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,346,105,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Root Beer','12 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,346,140,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Baked Beans','3/4 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,200,250,11,6,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Red Kidney Beans','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,260,230,15,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Bean Sprouts','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,17,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Beet Greens','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,27,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Beetroots','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,165,1,12,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Broccoli','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,150,45,5,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Brussel Sprouts','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,130,60,6,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Sauerkraut','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,150,32,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Steamed Cabbage','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,170,40,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Carrots','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,150,45,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cauliflower','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,120,30,3,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Celery Stalk','1 large',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,40,5,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Chard, steamed','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,150,30,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Collards','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,150,51,5,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Corn','1 ear',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,92,3,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Corn, cooked or canned','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,200,170,5,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cucumbers','8',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,6,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Dandelion Greens','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,180,80,5,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Eggplant','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,180,30,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Endive','2 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,57,10,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Kale','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,110,45,4,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Kohlrabi','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,140,40,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Lentils','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,200,212,15,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Lettuce','1/4 head',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,14,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Mushrooms, canned','4',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,120,12,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Mustard Greens','1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,140,30,3,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Okra','1 1/3 cups',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,32,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Onions','1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,210,80,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Green Onions','6 small',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,22,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Parsley','2 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,2,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Parsnips','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,155,95,2,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Peas','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,66,3,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Steamed Peas','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,70,5,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Frozen Peas','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,null,5,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Split Cooked Peas','4 cups',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,115,8,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Green Pepper','1 large',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,25,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Baked Potato','1 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,100,2,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','French-fries','10 pieces',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,60,155,1,7,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Mashed Potatoes with Milk and Butter','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,200,230,4,12,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Pan-fried Potatoes','3/4 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,268,4,14,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Scalloped Potatoes with Cheese','3/4 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,145,6,8,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cheddar Cheese','1-in. cube',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,17,70,4,6,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cream Cheese','1 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,28,105,2,11,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Processed Cheese','1 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,28,105,7,9,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Swiss Cheese','1 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,28,105,7,8,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Eggs, scrambled or fried','2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,128,220,13,16,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Egg Yolks','2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,34,120,6,10,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Hard Candies','1 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,28,90,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Marshmallows','5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,30,98,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Milk Chocolate','2-oz. bar',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,56,290,2,6,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Chocolate Syrup','2 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,40,80,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Doughnut','1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,33,135,2,7,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Gelatin','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,239,155,4,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Honey','2 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,42,120,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Fruit Preserves','1 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20,55,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Fruit Jelly','1 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20,50,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Molasses','1 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20,45,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cane Syrup','1 T.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,20,50,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cherry Pie','1 slice',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,135,340,3,13,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Custard Pie','1 slice',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,130,265,7,11,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Lemon Meringue Pie','1 slice',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,120,300,4,12,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Mince Meat Pie','1 slice',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,135,340,3,9,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Pumpkin Pie','1 slice',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,130,265,5,12,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Pudding','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,200,770,0,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Spaghetti with Tomatoes and Cheese','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,210,6,5,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Spanish Rice','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,217,4,4,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Waffle','1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,75,240,8,9,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Wheat Germ','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,68,245,17,7,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Wheat Germ Cereal','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,65,260,20,7,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Wheat Meal Cereal','3/4 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,30,103,4,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cooked Wheat','3/4 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,200,275,12,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Bean Soup','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,190,8,5,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Beef Soup','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,100,6,4,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Bouillon','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,240,24,5,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Chicken Soup','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,75,4,2,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Clam Chowder','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,255,85,5,2,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Noodle Soup','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,115,6,4,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Split-pea Soup','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,147,8,3,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Tomato Soup','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,245,175,6,7,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Vegetable Soup','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,250,80,4,2,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Apple Betty','1 serving',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,150,1,4,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Chocolate Fudge Cake','1 slice',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,120,420,5,14,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cupcake','1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,50,160,3,3,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Fruit Cake','1 slice',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,30,105,2,4,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Gingerbread Cake','1 slice',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,55,180,2,7,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Plain Cake, no icing','1 slice',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,55,180,4,5,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Sponge Cake','1 slice',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,40,115,3,2,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Chocolate Cream','2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,30,130,0,4,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Fudge','2 pieces',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,90,370,0,12,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Corned Beef','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,185,22,10,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Corned Beef Hash, canned','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,120,12,8,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Pot-pie','1 pie',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,227,480,18,28,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Corned Beef Hash Stew','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,235,185,15,10,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Chicken','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,185,23,9,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Fried Chicken','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,245,25,15,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Roasted Chicken','3 1/2 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,290,25,20,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Chicken Livers, fried','3 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,140,22,14,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Duck','3 1/2 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,370,16,28,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Lamb Chop, broiled','4 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,115,480,24,35,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Pork Chop','3 1/2 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,260,16,21,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Ham','2 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,57,170,13,13,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Canned Ham, spiced','2 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,57,165,8,14,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Pork roast','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,310,21,24,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Pork sausage','3 1/2 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,475,18,44,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Turkey','3 1/2 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,265,27,15,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Veal','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,185,23,9,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Roast','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,305,13,14,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Clams','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,87,12,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Cod','3 1/2 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,170,28,5,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Crab','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,90,14,2,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Fish Sticks, fried','5',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,112,200,19,10,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Flounder','3 1/2 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,200,30,8,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Haddock','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,135,16,5,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Halibut','3 1/2 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,182,26,8,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Herring','1 small',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,211,22,13,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Lobster','aver.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,92,18,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Mackerel','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,155,18,9,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Oysters','6-8 med.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,230,231,232,233,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Oyster stew','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,125,19,6,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Salmon','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,120,17,5,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Sardines','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,180,22,9,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Scallops','3 1/2 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,104,18,8,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Shad','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,170,20,10,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Shrimp','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,110,23,1,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Swordfish','1 steak',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,100,180,27,6,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Tuna','3 oz.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85,170,25,7,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Asparagus','6 spears',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,96,18,1,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('FOODS','en','Lima Beans','1 cup',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,160,140,8,0,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Denim Jeans','Clothing|Pants','N','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,34.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Zip-up Hoodie','Clothing|Outdoor Apparel','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,49.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Plastic Storage Bin','Household Items|Storage & Organization','Y','QTY_1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Toilet Paper Roll','Household Items|Personal Care','N','QTY_1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.79,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','T-Shirt','Clothing|Shirts','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,14.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Polo Shirt','Clothing|Shirts','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,34.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Oven Mitts','Household Items|Kitchen','N','QTY_2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,11.49,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Knit Hat','Clothing|Hats','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,12.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Plastic Drawer Organizer','Household Items|Storage & Organization','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Golf Balls','Sports & Outdoor|Sports Equipment','Y','QTY_3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Children''s Sippy Cup','Household Items|Kitchen','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,6.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Small Notepad','Household Items|School & Office Supplies','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Ankle Socks','Clothing|Socks','Y','QTY_2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2.29,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Crew Socks','Clothing|Socks','Y','QTY_2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Tall Drinking Glasses','Household Items|Kitchen','N','QTY_2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Tank Top','Clothing|Shirts','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','3 Ring Binder','Household Items|School & Office Supplies','Y','QTY_1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3.49,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Kitchen Floor Mat','Household Items|Kitchen','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,12.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Long Sleeve Flannel Shirt','Clothing|Shirts','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,21.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Dental Floss Picks','Household Items|Personal Care','N','QTY_3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.49,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Wire Bound Sketch Pad','Household Items|School & Office Supplies','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,11.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Hardbound Sketch Book','Household Items|School & Office Supplies','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,15.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Rubber Dumbbells','Sports & Outdoor|Sports Equipment','N','QTY_2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,19.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Badminton Racket','Sports & Outdoor|Sports Equipment','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,15.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Badminton Birdie','Sports & Outdoor|Sports Equipment','Y','QTY_1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Chino Pants (Khaki)','Clothing|Pants','N','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,27.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Tennis Visor','Clothing|Hats','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,14.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Flip Flops','Clothing|Footwear','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,11.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Short Sleeve Flannel Shirt','Clothing|Shirts','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,18.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Fleece Vest','Clothing|Outdoor Apparel','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,19.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Chapstick Tubes','Household Items|Personal Care','N','QTY_2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1.29,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Party Napkins','Household Items|Kitchen','Y','QTY_3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Heavy Parka','Clothing|Outdoor Apparel','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,124.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Varsity Jacket','Clothing|Outdoor Apparel','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,54.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Skinny Jeans','Clothing|Pants','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,44.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Hiking Boots','Clothing|Footwear','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,59.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Ping Pong Balls','Sports & Outdoor|Sports Equipment','Y','QTY_3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Table Tennis Paddles','Sports & Outdoor|Sports Equipment','N','QTY_2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Folding Camp Chair','Sports & Outdoor|Outdoor Recreation & Camping','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,13.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Inflatable Swimming Tube','Sports & Outdoor|Outdoor Recreation & Camping','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Rubber Horseshoes','Sports & Outdoor|Outdoor Recreation & Camping','Y','QTY_2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Ski Coat','Clothing|Outdoor Apparel','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,79.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Corduroy Pants','Clothing|Pants','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,49.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Plastic Forks','Household Items|Kitchen','Y','QTY_3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.69,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Plastic Spoons','Household Items|Kitchen','Y','QTY_3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.69,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Weather-resistant Tarp','Sports & Outdoor|Outdoor Recreation & Camping','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,9.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Ballpoint Pens','Household Items|School & Office Supplies','N','QTY_3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1.29,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Winter Gloves','Clothing|Outdoor Apparel','Y','QTY_2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Inflatable Beach Ball','Sports & Outdoor|Outdoor Recreation & Camping','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Premium Running Shoes','Clothing|Footwear','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,89.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Mechanical Pencils','Household Items|School & Office Supplies','N','QTY_3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Stapler','Household Items|School & Office Supplies','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Plastic Straws','Household Items|Kitchen','Y','QTY_3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.49,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Pajama Bottoms','Clothing|Pants','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,11.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Pajama Top','Clothing|Shirts','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,12.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Tennis Racket','Sports & Outdoor|Sports Equipment','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,29.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Tennis Ball','Sports & Outdoor|Sports Equipment','N','QTY_1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1.49,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Single Line Kite','Sports & Outdoor|Outdoor Recreation & Camping','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,15.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Baseball Cap','Clothing|Hats','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,8.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Jewelry Box','Household Items|Storage & Organization','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,16.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','V-neck Blouse','Clothing|Shirts','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,21.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','High Top Sneakers','Clothing|Footwear','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,31.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Thick Wool Socks','Clothing|Socks','Y','QTY_2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Desktop Organizer','Household Items|Storage & Organization','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,13.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Disposable Earplugs','Household Items|Personal Care','Y','QTY_2',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.89,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Plastic Party Plates','Household Items|Kitchen','Y','QTY_3',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Drawstring Backback','Household Items|School & Office Supplies','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,7.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Fuzzy Slippers','Clothing|Footwear','Y','NONE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Sweatpants','Clothing|Pants','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,15.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Windbreaker','Clothing|Outdoor Apparel','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,27.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Button-up Dress Shirt','Clothing|Shirts','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,24.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Light Raincoat','Clothing|Outdoor Apparel','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,21.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Heavy Raincoat','Clothing|Outdoor Apparel','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,54.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Long Sleeve Shirt','Clothing|Shirts','Y','FIT_SIZE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,24.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('GENERIC_PRODS','en','Plastic Toothbrush','Household Items|Personal Care','Y','QTY_1',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,0.99,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Museums, Historical Sites, and Similar Institutions','Industries in the Museums, Historical Sites, and Similar Institutions subsector engage in the preservation and exhibition of objects, sites, and natural wonders of historical, cultural, and/or educational value.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Amusement, Gambling, and Recreation Industries','Industries in the Amusement, Gambling, and Recreation Industries subsector (1) operate facilities where patrons can primarily engage in sports, recreation, amusement, or gambling activities and/or (2) provide other amusement and recreation services, such as supplying and servicing amusement devices in places of business operated by others; operating sports teams, clubs, or leagues engaged in playing games for recreational purposes; and guiding tours without using transportation equipment.

This subsector does not cover all establishments providing recreational services. Other sectors of NAICS also provide recreational services. Providers of recreational services are often engaged in processes classified in other sectors of NAICS.  For example, operators of resorts and hunting and fishing camps provide both accommodation and recreational facilities and services.  These establishments are classified in Subsector 721, Accommodation, partly to reflect the significant costs associated with the provision of accommodation services and partly to ensure consistency with international standards.  Likewise, establishments using transportation equipment to provide recreational and entertainment services, such as those operating sightseeing buses, dinner cruises, or helicopter rides, are classified in Sector 48-49, Transportation and Warehousing.

The industry groups in this subsector highlight particular types of activities: amusement parks and arcades, gambling industries, and other amusement and recreation industries.  The groups, however, are not all-inclusive of the activity.  The Gambling Industries industry group does not provide for full coverage of gambling activities.  For example, casino hotels are classified in Subsector 721, Accommodation; and horse and dog racing tracks are classified in Industry Group 7112, Spectator Sports.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Hospitals','Industries in the Hospitals subsector provide medical, diagnostic, and treatment services that include physician, nursing, and other health services to inpatients and the specialized accommodation services required by inpatients.  Hospitals may also provide outpatient services as a secondary activity.  Establishments in the Hospitals subsector provide inpatient health services, many of which can only be provided using the specialized facilities and equipment that form a significant and integral part of the production process.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Real Estate','Industries in the Real Estate subsector group establishments primarily engaged in renting or leasing real estate to others; managing real estate for others; selling, buying, or renting real estate for others; and providing other real estate related services, such as appraisal services.

This subsector includes equity real estate investment trusts (REITs) primarily engaged in leasing buildings, dwellings, or other real estate property to others.  Mortgage REITs are classified in Subsector 525, Funds, Trusts, and Other Financial Vehicles.

Establishments primarily engaged in subdividing and developing unimproved real estate and constructing buildings for sale are classified in Subsector 236, Construction of Buildings.  Establishments primarily engaged in subdividing and improving raw land for subsequent sale to builders are classified in Subsector 237, Heavy and Civil Engineering Construction.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Telecommunications','Industries in the Telecommunications subsector group establishments that provide telecommunications and the services related to that activity (e.g., telephony, including Voice over Internet Protocol (VoIP); cable and satellite television distribution services; Internet access; telecommunications reselling services).  The Telecommunications subsector is primarily engaged in operating and/or providing access to facilities for the transmission of voice, data, text, sound, and video.  Transmission facilities may be based on a single technology or a combination of technologies.  Establishments in the Telecommunications subsector are grouped into three industry groups.  The first two are comprised of establishments that operate transmission facilities and infrastructure that they own and/or lease, and provide telecommunications services using those facilities.  The distinction between the first two industry groups is the type of infrastructure operated (i.e., wired and/or wireless or satellite).  The third industry group is comprised of establishments that provide support activities, telecommunications reselling services, or many of the same services provided by establishments in the first two industry groups, but do not operate as telecommunications carriers.  Establishments primarily engaged as independent contractors in the installation and maintenance of broadcasting and telecommunications systems are classified in Sector 23, Construction.  Establishments known as Internet cafes, primarily engaged in offering limited Internet connectivity in combination with other services such as facsimile services, training, rental of on-site personal computers, game rooms, or food services are classified in Subsector 561, Administrative and Support Services, or Subsector 722, Food Services and Drinking Places, depending on the primary activity.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Data Processing, Hosting, and Related Services','Industries in the Data Processing, Hosting, and Related Services subsector group establishments that provide the infrastructure for hosting and/or data processing services.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Other Information Services','Industries in the Other Information Services subsector group establishments supplying information, storing and providing access to information, searching and retrieving information, operating Web sites that use search engines to allow for searching information on the Internet, or publishing and/or broadcasting content exclusively on the Internet.  The main components of the subsector are news syndicates, libraries, archives, exclusive Internet publishing and/or broadcasting, and Web search portals.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Monetary Authorities-Central Bank','The Monetary Authorities-Central Bank subsector groups establishments that engage in performing central banking functions, such as issuing currency, managing the Nation''s money supply and international reserves, holding deposits that represent the reserves of other banks and other central banks, and acting as a fiscal agent for the central government.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Credit Intermediation and Related Activities','Industries in the Credit Intermediation and Related Activities subsector group establishments that (1) lend funds raised from depositors; (2) lend funds raised from credit market borrowing; or (3) facilitate the lending of funds or issuance of credit by engaging in such activities as mortgage and loan brokerage, clearinghouse and reserve services, and check cashing services.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Securities, Commodity Contracts, and Other Financial Investments and Related Activities','Industries in the Securities, Commodity Contracts, and Other Financial Investments and Related Activities subsector group establishments that are primarily engaged in one of the following: (1) underwriting securities issues and/or making markets for securities and commodities; (2) acting as agents (i.e., brokers) between buyers and sellers of securities and commodities; (3) providing securities and commodity exchange services; and (4) providing other services, such as managing portfolios of assets; providing investment advice; and trust, fiduciary, and custody services.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Couriers and Messengers','Industries in the Couriers and Messengers subsector provide intercity, local, and/or international delivery of parcels and documents (including express delivery services) without operating under a universal service obligation.  These articles may originate in the U.S. but be delivered to another country and can be described as those that may be handled by one person without using special equipment.  This allows the collection, pick-up, and delivery operations to be done with limited labor costs and minimal equipment.  Sorting and transportation activities, where necessary, are generally mechanized.  The restriction to small parcels partly distinguishes these establishments from those in the transportation industries.  The complete network of courier services establishments also distinguishes these transportation services from local messenger and delivery establishments in this subsector.  This includes the establishments that perform intercity transportation as well as establishments that, under contract to them, perform local pick-up and delivery.  Messengers, which usually deliver within a metropolitan or single urban area, may use bicycle, foot, small truck, or van.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Warehousing and Storage','Industries in the Warehousing and Storage subsector are primarily engaged in operating warehousing and storage facilities for general merchandise, refrigerated goods, and other warehouse products.  These establishments provide facilities to store goods.  They do not sell the goods they handle.  These establishments take responsibility for storing the goods and keeping them secure.  They may also provide a range of services, often referred to as logistics services, related to the distribution of goods.  Logistics services can include labeling, breaking bulk, inventory control and management, light assembly, order entry and fulfillment, packaging, pick and pack, price marking and ticketing, and transportation arrangement.  However, establishments in this industry group always provide warehousing or storage services in addition to any logistic services.  Furthermore, the warehousing or storage of goods must be more than incidental to the performance of services, such as price marking.

Bonded warehousing and storage services and warehouses located in free trade zones are included in the industries of this subsector.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Publishing Industries (except Internet)','Industries in the Publishing Industries (except Internet) subsector group establishments engaged in the publishing of newspapers, magazines, other periodicals, and books, as well as directory and mailing list and software publishing.  In general, these establishments, which are known as publishers, issue copies of works for which they usually possess copyright.  Works may be in one or more formats including traditional print form, CD-ROM, or proprietary electronic networks.  Publishers may publish works originally created by others for which they have obtained the rights and/or works that they have created in-house.  Software publishing is included here because the activity, creation of a copyrighted product and bringing it to market, is equivalent to the creation process for other types of intellectual products.

In NAICS, publishing--the reporting, writing, editing, and other processes that are required to create an edition of a newspaper--is treated as a major economic activity in its own right, rather than as a subsidiary activity to a manufacturing activity, printing.  Thus, publishing is classified in the Information sector; whereas, printing remains in the Manufacturing sector.  In part, the NAICS classification reflects the fact that publishing increasingly takes place in establishments that are physically separate from the associated printing establishments.  More crucially, the NAICS classification of book and newspaper publishing is intended to portray their roles in a modern economy, in which they do not resemble manufacturing activities.

Music publishers are not included in the Publishing Industries (except Internet) subsector, but are included in the Motion Picture and Sound Recording Industries subsector.  Reproduction of prepackaged software is treated in NAICS as a manufacturing activity; on-line distribution of software products is in the Information sector; and custom design of software to client specifications is included in the Professional, Scientific, and Technical Services sector.  These distinctions arise because of the different ways that software is created, reproduced, and distributed.

The Publishing Industries (except Internet) subsector includes establishments that publish software exclusively on the Internet but excludes establishments that publish other content exclusively on the Internet. Establishments publishing content other than software exclusively on the Internet are included in Subsector 519, Other Information Services.  The Publishing Industries (except Internet) subsector also excludes products, such as manifold business forms and appointment books.  Information is not the essential component of these items.  Establishments producing these items are included in Subsector 323, Printing and Related Support Activities.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Motion Picture and Sound Recording Industries','Industries in the Motion Picture and Sound Recording Industries subsector group establishments involved in the production and distribution of motion pictures and sound recordings.  While producers and distributors of motion pictures and sound recordings issue works for sale as traditional publishers do, the processes are sufficiently different to warrant placing establishments engaged in these activities in a separate subsector.  Production is typically a complex process that involves several distinct types of establishments that are engaged in activities, such as contracting with performers, creating the film or sound content, and providing technical postproduction services.  Film distribution is often to exhibitors, such as theaters and broadcasters, rather than through the wholesale and retail distribution chain.  When the product is in a mass-produced form, NAICS treats production and distribution as the major economic activity as it does in the Publishing Industries (except Internet) subsector, rather than as a subsidiary activity to the manufacture of such products.

This subsector does not include establishments primarily engaged in the wholesale distribution of video and sound recordings, such as compact discs and audio tapes; these establishments are included in the Wholesale Trade sector.  Reproduction of video and sound recordings that is carried out separately from establishments engaged in production and distribution is treated in NAICS as a manufacturing activity.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Broadcasting (except Internet)','Industries in the Broadcasting (except Internet) subsector include establishments that create content or acquire the right to distribute content and subsequently broadcast the content.  The industry groups (Radio and Television Broadcasting and Cable and Other Subscription Programming) are based on differences in the methods of communication and the nature of services provided.  The Radio and Television Broadcasting industry group includes establishments that operate broadcasting studios and facilities for over-the-air or satellite delivery of radio and television programs of entertainment, news, talk, and the like.  These establishments are often engaged in the production and purchase of programs and generating revenues from the sale of air time to advertisers and from donations, subsidies, and/or the sale of programs.  The Cable and Other Subscription Programming industry group includes establishments operating studios and facilities for the broadcasting of programs that are typically narrowcast in nature (limited format, such as news, sports, education, and youth-oriented programming) on a subscription or fee basis.

The distribution of cable and other subscription programming is included in Subsector 517, Telecommunications.  Establishments that broadcast exclusively on the Internet are included in Subsector 519, Other Information Services.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Rental and Leasing Services','Industries in the Rental and Leasing Services subsector include establishments that provide a wide array of tangible goods, such as automobiles, computers, consumer goods, and industrial machinery and equipment, to customers in return for a periodic rental or lease payment.

The subsector includes two main types of establishments:  (1) those that are engaged in renting consumer goods and equipment and (2) those that are engaged in leasing machinery and equipment often used for business operations.  The first type typically operates from a retail-like or storefront facility and maintains inventories of goods that are rented for short periods of time.  The latter type typically does not operate from retail-like locations or maintain inventories, and offers longer-term leases.  These establishments work directly with clients to enable them to acquire the use of equipment on a lease basis, or they work with equipment vendors or dealers to support the marketing of equipment to their customers under lease arrangements.  Equipment lessors generally structure lease contracts to meet the specialized needs of their clients and use their remarketing expertise to find other users for previously leased equipment.  Establishments that provide operating and capital (i.e., finance) leases are included in this subsector.

Establishments primarily engaged in leasing in combination with providing loans are classified in Sector 52, Finance and Insurance.  Establishments primarily engaged in leasing real property are classified in Subsector 531, Real Estate.  Establishments primarily engaged in renting or leasing equipment with operators are classified in various subsectors of NAICS depending on the nature of the services provided (e.g., transportation, construction, agriculture).  These activities are excluded from this subsector since the client is paying for the expertise and knowledge of the equipment operator, in addition to the rental of the equipment.  In many cases, such as the rental of heavy construction equipment, the operator is essential to operate the equipment.  Likewise, since the provision of crop harvesting services includes both the equipment and operator, it is included in Subsector 115, Support Activities for Agriculture and Forestry.  The rental or leasing of copyrighted works is classified in Sector 51, Information, and the rental or leasing of assets, such as patents, trademarks, and/or licensing agreements, is classified in Subsector 533, Lessors of Nonfinancial Intangible Assets (except Copyrighted Works).
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Lessors of Nonfinancial Intangible Assets (except Copyrighted Works)','Industries in the Lessors of Nonfinancial Intangible Assets (except Copyrighted Works) subsector include establishments primarily engaged in assigning rights to assets, such as patents, trademarks, brand names, and/or franchise agreements, for which a royalty payment or licensing fee is paid to the asset holder.  Establishments in this subsector own the patents, trademarks, and/or franchise agreements that they allow others to use or reproduce for a fee and may or may not have created those assets.

Establishments that allow franchisees the use of the franchise name, contingent on the franchisee buying products or services from the franchisor, are classified elsewhere.

Excluded from this subsector are establishments primarily engaged in leasing real property and establishments primarily engaged in leasing tangible assets, such as automobiles, computers, consumer goods, and industrial machinery and equipment.  These establishments are classified in Subsector 531, Real Estate, and Subsector 532, Rental and Leasing Services, respectively.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Professional, Scientific, and Technical Services','Industries in the Professional, Scientific, and Technical Services subsector group establishments engaged in processes where human capital is the major input.  These establishments make available the knowledge and skills of their employees, often on an assignment basis, where an individual or team is responsible for the delivery of services to the client.  The individual industries of this subsector are defined on the basis of the particular expertise and training of the services provider.

The distinguishing feature of the Professional, Scientific, and Technical Services subsector is the fact that most of the industries grouped in it have production processes that are almost wholly dependent on worker skills.  In most of these industries, equipment and materials are not of major importance, unlike health care, for example, where "high-tech" machines and materials are important collaborating inputs to labor skills in the production of health care.  Thus, the establishments classified in this subsector sell expertise.  Much of the expertise requires degrees, though not in every case.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Insurance Carriers and Related Activities','Industries in the Insurance Carriers and Related Activities subsector group establishments that are primarily engaged in one of the following:  (1) underwriting (assuming the risk, assigning premiums, and so forth) annuities and insurance policies or (2) facilitating such underwriting by selling insurance policies and by providing other insurance and employee benefit related services.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Funds, Trusts, and Other Financial Vehicles ','Industries in the Funds, Trusts, and Other Financial Vehicles subsector group legal entities (i.e., funds, plans, and/or programs) organized to pool securities or other assets on behalf of shareholders or beneficiaries of employee benefit or other trust funds.  The portfolios are customized to achieve specific investment characteristics, such as diversification, risk, rate of return, and price volatility.  These entities earn interest, dividends, and other investment income, but have little or no employment and no revenue from the sale of services.  Establishments with employees devoted to the management of funds are classified in Industry Group 5239, Other Financial Investment Activities.

Establishments primarily engaged in holding the securities of (or other equity interests in) other firms are classified in Sector 55, Management of Companies and Enterprises.  Equity real estate investment trusts (REITs) that are primarily engaged in leasing buildings, dwellings, or other real estate property to others are classified in Subsector 531, Real Estate.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Food and Beverage Stores ','Industries in the Food and Beverage Stores subsector usually retail food and beverage merchandise from fixed point-of-sale locations.  Establishments in this subsector have special equipment (e.g., freezers, refrigerated display cases, refrigerators) for displaying food and beverage goods.  They have staff trained in the processing of food products to guarantee the proper storage and sanitary conditions required by regulatory authority.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Health and Personal Care Stores ','Industries in the Health and Personal Care Stores subsector retail health and personal care merchandise from fixed point-of-sale locations.  Establishments in this subsector are characterized principally by the products they retail, and some health and personal care stores may have specialized staff trained in dealing with the products.  Staff may include pharmacists, opticians, and other professionals engaged in retailing, advising customers, and/or fitting the product sold to the customer''s needs.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Pipeline Transportation','Industries in the Pipeline Transportation subsector use transmission pipelines to transport products, such as crude oil, natural gas, refined petroleum products, and slurry.  Industries are identified based on the products transported (i.e., pipeline transportation of crude oil, natural gas, refined petroleum products, and other products).

The Pipeline Transportation of Natural Gas industry includes the storage of natural gas because the storage is usually done by the pipeline establishment and because a pipeline is inherently a network in which all the nodes are interdependent.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Scenic and Sightseeing Transportation','Industries in the Scenic and Sightseeing Transportation subsector utilize transportation equipment to provide recreation and entertainment.  These activities have a production process distinct from passenger transportation carried out for the purpose of other types of for-hire transportation.  This process does not emphasize efficient transportation; in fact, such activities often use obsolete vehicles, such as steam trains, to provide some extra ambience.  The activity is local in nature, usually involving a same-day return to the point of departure.

The Scenic and Sightseeing Transportation subsector is separated into three industries based on the mode: land, water, and other.

Activities that are recreational in nature and involve participation by the customer, such as white water rafting, are generally excluded from this subsector, unless they impose an impact on part of the transportation system.  Charter boat fishing, for example, is included in the Scenic and Sightseeing Transportation, Water industry.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Support Activities for Transportation','Industries in the Support Activities for Transportation subsector provide services which support transportation.  These services may be provided to transportation carrier establishments or to the general public.  This subsector includes a wide array of establishments, including air traffic control services, marine cargo handling, and motor vehicle towing.

The Support Activities for Transportation subsector includes services to transportation but is separated by type of mode serviced.  The Support Activities for Rail Transportation industry includes services to the rail industry (e.g., railroad switching and terminal establishments).

Ship repair and maintenance not done in a shipyard are included in the Other Support Activities for Water Transportation industry.  An example would be floating drydock services in a harbor.

Excluded from this subsector are establishments primarily engaged in providing factory conversion and overhaul of transportation equipment, which are classified in Subsector 336, Transportation Equipment Manufacturing.  Also, establishments primarily engaged in providing rental and leasing of transportation equipment without operator are classified in Subsector 532, Rental and Leasing Services.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Postal Service','The Postal Service subsector includes the activities of the National Post Office and its subcontractors operating under a universal service obligation to provide mail services, and using the infrastructure required to fulfill that obligation.  These services include delivering letters and small parcels.  These articles can be described as those that can be handled by one person without using special equipment.  This allows the collection, pick-up, and delivery operations to be done with limited labor costs and minimal equipment.  Sorting and transportation activities, where necessary, are generally mechanized.  The restriction to small parcels distinguishes these establishments from those in the transportation industries.  These establishments may also provide express delivery services using the infrastructure established for provision of basic mail services.

The traditional activity of the National Postal Service is described in this subsector.  Subcontractors include rural post offices on contract to the Postal Service.

Bulk transportation of mail on contract to the Postal Service is not included here, because it is usually done by transportation establishments that carry other customers'' cargo as well.  Establishments that provide courier and express delivery services without operating under a universal service obligation are classified in Subsector 492, Couriers and Messengers.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Air Transportation','Industries in the Air Transportation subsector provide air transportation of passengers and/or cargo using aircraft, such as airplanes and helicopters.  The subsector distinguishes scheduled from nonscheduled air transportation.  Scheduled air carriers fly regular routes on regular schedules and operate even if flights are only partially loaded.  Nonscheduled carriers often operate during nonpeak time slots at busy airports.  These establishments have more flexibility with respect to choice of airport, hours of operation, load factors, and similar operational characteristics.  Nonscheduled carriers provide chartered air transportation of passengers, cargo, or specialty flying services.  Specialty flying services establishments use general purpose aircraft to provide a variety of specialized flying services.

Scenic and sightseeing air transportation and air courier services are not included in this subsector but are included in Subsector 487, Scenic and Sightseeing Transportation, and in Subsector 492, Couriers and Messengers, respectively.  Although these activities may use aircraft, they are different from the activities included in air transportation.  Air sightseeing does not usually involve place-to-place transportation; the passenger''s flight (e.g., balloon ride, aerial sightseeing) typically starts and ends at the same location.  Courier services (individual package or cargo delivery) include more than air transportation; road transportation is usually required to deliver the cargo to the intended recipient.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Rail Transportation','Industries in the Rail Transportation subsector provide rail transportation of passengers and/or cargo using railroad rolling stock.  The railroads in this subsector primarily either operate on networks, with physical facilities, labor force, and equipment spread over an extensive geographic area, or operate over a short distance on a local rail line.

Scenic and sightseeing rail transportation and street railroads, commuter rail, and rapid transit are not included in this subsector but are included in Subsector 487, Scenic and Sightseeing Transportation, and Subsector 485, Transit and Ground Passenger Transportation, respectively.  Although these activities use railroad rolling stock, they are different from the activities included in rail transportation.  Sightseeing and scenic railroads do not usually involve place-to-place transportation; the passenger''s trip typically starts and ends at the same location.  Commuter railroads operate in a manner more consistent with local and urban transit and are often part of integrated transit systems.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Water Transportation','Industries in the Water Transportation subsector provide water transportation of passengers and cargo using watercraft, such as ships, barges, and boats.

The subsector is composed of two industry groups: (1) one for deep sea, coastal, and Great Lakes; and (2) one for inland water transportation.  This split typically reflects the difference in equipment used.

Scenic and sightseeing water transportation services are not included in this subsector but are included in Subsector 487, Scenic and Sightseeing Transportation.  Although these activities use watercraft, they are different from the activities included in water transportation.  Water sightseeing does not usually involve place-to-place transportation; the passenger''s trip starts and ends at the same location.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Truck Transportation','Industries in the Truck Transportation subsector provide over-the-road transportation of cargo using motor vehicles, such as trucks and tractor trailers.  The subsector is subdivided into general freight trucking and specialized freight trucking.  This distinction reflects differences in equipment used, type of load carried, scheduling, terminal, and other networking services.  General freight transportation establishments handle a wide variety of general commodities, generally palletized, and transported in a container or van trailer.  Specialized freight transportation is the transportation of cargo that, because of size, weight, shape, or other inherent characteristics, requires specialized equipment for transportation.

Each of these industry groups is further subdivided based on distance traveled.  Local trucking establishments primarily carry goods within a single metropolitan area and its adjacent nonurban areas.  Long-distance trucking establishments carry goods between metropolitan areas.

The Specialized Freight Trucking industry group includes a separate industry for Used Household and Office Goods Moving. The household and office goods movers are separated because of the substantial network of establishments that has developed to deal with local and long-distance moving and the associated storage.  In this area, the same establishment provides both local and long-distance services, while other specialized freight establishments generally limit their services to either local or long-distance hauling.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Transit and Ground Passenger Transportation','Industries in the Transit and Ground Passenger Transportation subsector include a variety of passenger transportation activities, such as urban transit systems; chartered bus, school bus, and interurban bus transportation; and taxis.  These activities are distinguished based primarily on such production process factors as vehicle types, routes, and schedules.

In this subsector, the principal splits identify scheduled transportation as separate from nonscheduled transportation.  The scheduled transportation industry groups are Urban Transit Systems, Interurban and Rural Bus Transportation, and School and Employee Bus Transportation.  The nonscheduled industry groups are the Charter Bus Industry and Taxi and Limousine Service.  The Other Transit and Ground Passenger Transportation industry group includes both scheduled and nonscheduled transportation.

Scenic and sightseeing ground transportation services are not included in this subsector but are included in Subsector 487, Scenic and Sightseeing Transportation.  Sightseeing does not usually involve place-to-place transportation; the passenger''s trip starts and ends at the same location.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Motor Vehicle and Parts Dealers ','Industries in the Motor Vehicle and Parts Dealers subsector retail motor vehicles and parts from fixed point-of-sale locations.  Establishments in this subsector typically operate from a showroom and/or an open lot where the vehicles are on display.  The display of vehicles and the related parts require little by way of display equipment.  The personnel generally include both the sales and sales support staff familiar with the requirements for registering and financing a vehicle as well as a staff of parts experts and mechanics trained to provide repair and maintenance services for the vehicles.  Specific industries included in this subsector identify the type of vehicle being retailed.

Sales of capital or durable nonconsumer goods, such as medium- and heavy-duty trucks, are always included in wholesale trade.  These goods are virtually never sold through retail methods.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Furniture and Home Furnishings Stores ','Industries in the Furniture and Home Furnishings Stores subsector retail new furniture and home furnishings from fixed point-of-sale locations.  Establishments in this subsector usually operate from showrooms and have substantial areas for the presentation of their products.  Many offer interior decorating services in addition to the sale of products.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Electronics and Appliance Stores ','Industries in the Electronics and Appliance Stores subsector retail new electronics and appliances from point-of-sale locations.  Establishments in this subsector often operate from locations that have special provisions for floor displays requiring special electrical capacity to accommodate the proper demonstration of the products.  The staff includes sales personnel knowledgeable in the characteristics and warranties of the line of goods retailed and may also include trained repair persons to handle the maintenance and repair of the electronic equipment and appliances.  The classifications within this subsector are made principally on the type of product and knowledge required to operate each type of store.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Building Material and Garden Equipment and Supplies Dealers ','Industries in the Building Material and Garden Equipment and Supplies Dealers subsector retail new building material and garden equipment and supplies from fixed point-of-sale locations.  Establishments in this subsector have display equipment designed to handle lumber and related products and garden equipment and supplies that may be kept either indoors or outdoors under covered areas.  The staff is usually knowledgeable in the use of the specific products being retailed in the construction, repair, and maintenance of the home and associated grounds.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Nursing and Residential Care Facilities','Industries in the Nursing and Residential Care Facilities subsector provide residential care combined with either nursing, supervisory, or other types of care as required by the residents.  In this subsector, the facilities are a significant part of the production process, and the care provided is a mix of health and social services with the health services being largely some level of nursing services.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Social Assistance','Industries in the Social Assistance subsector provide a wide variety of social assistance services directly to their clients.  These services do not include residential or accommodation services, except on a short-stay basis.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Heavy and Civil Engineering Construction','The Heavy and Civil Engineering Construction subsector comprises establishments whose primary activity is the construction of entire engineering projects (e.g., highways and dams), and specialty trade contractors, whose primary activity is the production of a specific component for such projects.  Specialty trade contractors in the Heavy and Civil Engineering Construction subsector generally are performing activities that are specific to heavy and civil engineering construction projects and are not normally performed on buildings.  The work performed may include new work, additions, alterations, or maintenance and repairs.

Specialty trade activities are classified in this subsector if the skills and equipment present are specific to heavy or civil engineering construction projects.  For example, specialized equipment is needed to paint lines on highways.  This equipment is not normally used in building applications so the activity is classified in this subsector.  Traffic signal installation, while specific to highways, uses much of the same skills and equipment that are needed for electrical work in building projects and is therefore classified in Subsector 238, Specialty Trade Contractors.

Construction projects involving water resources (e.g., dredging and land drainage) and projects involving open space improvement (e.g., parks and trails) are included in this subsector.  Establishments whose primary activity is the subdivision of land into individual building lots usually perform various additional site-improvement activities (e.g., road building and utility line installation) and are included in this subsector.

Establishments in this subsector are classified based on the types of structures that they construct.  This classification reflects variations in the requirements of the underlying production processes.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Oil and Gas Extraction','Industries in the Oil and Gas Extraction subsector operate and/or develop oil and gas field properties.  Such activities may include exploration for crude petroleum and natural gas; drilling, completing, and equipping wells; operating separators, emulsion breakers, desilting equipment, and field gathering lines for crude petroleum and natural gas; and all other activities in the preparation of oil and gas up to the point of shipment from the producing property.  This subsector includes the production of crude petroleum, the mining and extraction of oil from oil shale and oil sands, the production of natural gas, sulfur recovery from natural gas, and recovery of hydrocarbon liquids.

Establishments in this subsector include those that operate oil and gas wells on their own account or for others on a contract or fee basis.  Establishments primarily engaged in providing support services, on a contract or fee basis, required for the drilling or operation of oil and gas wells (except geophysical surveying and mapping, mine site preparation, and construction of oil/gas pipelines) are classified in Subsector 213, Support Activities for Mining.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Mining (except Oil and Gas)','Industries in the Mining (except Oil and Gas) subsector primarily engage in mining, mine site development, and beneficiating (i.e., preparing) metallic minerals and nonmetallic minerals, including coal.  The term "mining" is used in the broad sense to include ore extraction, quarrying, and beneficiating (e.g., crushing, screening, washing, sizing, concentrating, and flotation), customarily done at the mine site.

Beneficiation is the process whereby the extracted material is reduced to particles which can be separated into mineral and waste, the former suitable for further processing or direct use.  The operations that take place in beneficiation are primarily mechanical, such as grinding, washing, magnetic separation, centrifugal separation, and so on. In contrast, manufacturing operations primarily use chemical and electrochemical processes, such as electrolysis, distillation, and so on.  However some treatments, such as heat treatments, take place in both stages: the beneficiation and the manufacturing (i.e., smelting/refining) stages.  The range of preparation activities varies by mineral and the purity of any given ore deposit.  While some minerals, such as petroleum and natural gas, require little or no preparation, others are washed and screened, while yet others, such as gold and silver, can be transformed into bullion before leaving the mine site.

Establishments in the Mining (except Oil and Gas) subsector include those that have complete responsibility for operating mines and quarries (except oil and gas wells) and those that operate mines and quarries (except oil and gas wells) for others on a contract or fee basis.  Establishments primarily engaged in providing support services, on a contract or fee basis, required for the mining and quarrying of minerals are classified in Subsector 213, Support Activities for Mining.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Support Activities for Mining','Industries in the Support Activities for Mining subsector group establishments primarily providing support services, on a contract or fee basis, required for the mining and quarrying of minerals and for the extraction of oil and gas.  Establishments performing exploration (except geophysical surveying and mapping) for minerals, on a contract or fee basis, are included in this subsector.  Exploration includes traditional prospecting methods, such as taking core samples and making geological observations at prospective sites.

The activities performed on a contract or fee basis by establishments in the Support Activities for Mining subsector are also often performed in-house by mining operators.  These activities include taking core samples, making geological observations at prospective sites, excavating slush pits and cellars, and such oil and gas operations as spudding in, drilling in, redrilling, directional drilling, and well surveying; running, cutting, and pulling casings, tubes, and rods; cementing and shooting wells; perforating well casings; acidizing and chemically treating wells; cleaning out, bailing, and swabbing wells; and operating oil and gas field gathering lines.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Personal and Laundry Service','Industries in the Personal and Laundry Services subsector group establishments that provide personal and laundry services to individuals, households, and businesses.  Services performed include: personal care services; death care services; laundry and drycleaning services; and a wide range of other personal services, such as pet care (except veterinary) services, photofinishing services, temporary parking services, and dating services.

The Personal and Laundry Services subsector is by no means all-inclusive of the services that could be termed personal services (i.e., those provided to individuals rather than businesses). There are many other subsectors, as well as sectors, that provide services to persons.  Establishments providing legal, accounting, tax preparation, architectural, portrait photography, and similar professional services are classified in Sector 54, Professional, Scientific, and Technical Services; those providing job placement, travel arrangement, home security, interior and exterior house cleaning, exterminating, lawn and garden care, and similar support services are classified in Sector 56, Administrative and Support and Waste Management and Remediation Services; those providing health and social services are classified in Sector 62, Health Care and Social Assistance; those providing amusement and recreation services are classified in Sector 71, Arts, Entertainment, and Recreation; those providing educational instruction are classified in Sector 61, Educational Services; those providing repair services are classified in Subsector 811, Repair and Maintenance; and those providing spiritual, civic, and advocacy services are classified in Subsector 813, Religious, Grantmaking, Civic, Professional, and Similar Organizations.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Religious, Grantmaking, Civic, Professional, and Similar Organization','Industries in the Religious, Grantmaking, Civic, Professional, and Similar Organizations subsector group establishments that organize and promote religious activities; support various causes through grantmaking; advocate various social and political causes; and promote and defend the interests of their members.

The industry groups within the subsector are defined in terms of their activities, such as establishments that provide funding for specific causes or for a variety of charitable causes; establishments that advocate and actively promote causes and beliefs for the public good; and establishments that have an active membership structure to promote causes and represent the interests of their members.  Establishments in this subsector may publish newsletters, books, and periodicals for distribution to their members.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Private Households','Industries in the Private Households subsector include private households that engage in employing workers on or about the premises in activities primarily concerned with the operation of the household.  These private households may employ individuals, such as cooks, maids, butlers, and outside workers, such as gardeners, caretakers, and other maintenance workers.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Executive, Legislative, and Other General Government Support ','The Executive, Legislative, and Other General Government Support subsector groups offices of government executives, legislative bodies, public finance, and general government support.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Justice, Public Order, and Safety Activities ','The Justice, Public Order, and Safety Activities subsector groups government establishments engaged in the administration of justice, public order, and safety programs.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Administration of Human Resource Programs ','The Administration of Human Resource Programs subsector groups government establishments primarily engaged in the administration of human resource programs.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Administration of Environmental Quality Programs ','The Administration of Environmental Quality Programs subsector groups government establishments primarily engaged in the administration of environmental quality.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Administration of Housing Programs, Urban Planning, and Community Development ','The Administration of Housing Programs, Urban Planning, and Community Development subsector groups government establishments primarily engaged in the administration of housing, urban planning, and community development.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Administration of Economic Programs ','This subsector comprises government establishments primarily engaged in the administration of economic programs.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Space Research and Technology ','This subsector comprises government establishments that conduct space research.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','National Security and International Affairs ','This subsector comprises government establishments primarily engaged in national security and international affairs.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Food Manufacturing','Industries in the Food Manufacturing subsector transform livestock and agricultural products into products for intermediate or final consumption.  The industry groups are distinguished by the raw materials (generally of animal or vegetable origin) processed into food products.

The food products manufactured in these establishments are typically sold to wholesalers or retailers for distribution to consumers, but establishments primarily engaged in retailing bakery and candy products made on the premises not for immediate consumption are included.

Establishments primarily engaged in manufacturing beverages are classified in Subsector 312, Beverage and Tobacco Product Manufacturing.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Specialty Trade Contractors','The Specialty Trade Contractors subsector comprises establishments whose primary activity is performing specific activities (e.g., pouring concrete, site preparation, plumbing, painting, and electrical work) involved in building construction or other activities that are similar for all types of construction, but that are not responsible for the entire project.  The work performed may include new work, additions, alterations, maintenance, and repairs.  The production work performed by establishments in this subsector is usually subcontracted from establishments of the general contractor type or for-sale builders, but especially in remodeling and repair construction, work also may be done directly for the owner of the property.  Specialty trade contractors usually perform most of their work at the construction site, although they may have shops where they perform prefabrication and other work.  Establishments primarily engaged in preparing sites for new construction are also included in this subsector.

There are substantial differences in types of equipment, work force skills, and other inputs required by specialty trade contractors.  Establishments in this subsector are classified based on the underlying production function for the specialty trade in which they specialize.  Throughout the Specialty Trade Contractors subsector, establishments commonly provide both the parts and labor required to complete work.  For example, electrical contractors supply the current-carrying and noncurrent-carrying wiring devices that are required to install a circuit.  Plumbing, heating, and air-conditioning contractors also supply the parts required to complete a contract.

Establishments that specialize in activities primarily related to heavy and civil engineering construction that are not normally performed on buildings, such as the painting of lines on highways, are classified in Subsector 237, Heavy and Civil Engineering Construction.

Establishments that are primarily engaged in selling construction materials are classified in Sector 42, Wholesale Trade, or Sector 44-45, Retail Trade, based on the characteristics of the selling unit.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Leather and Allied Product Manufacturing','Establishments in the Leather and Allied Product Manufacturing subsector transform hides into leather by tanning or curing and fabricating the leather into products for final consumption.  This subsector also includes the manufacture of similar products from other materials, including products (except apparel) made from "leather substitutes," such as rubber, plastics, or textiles.  Rubber footwear, textile luggage, and plastics purses or wallets are examples of "leather substitute" products included in this subsector.  The products made from leather substitutes are included in this subsector because they are made in similar ways leather products are made (e.g., luggage).  They are made in the same establishments, so it is not practical to separate them.

The inclusion of leather and hide tanning and finishing in this subsector is partly because it is a relatively small industry that has few close neighbors as a production process, partly because leather is an input to some of the other products classified in this subsector, and partly for historical reasons.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Wood Product Manufacturing','Establishments in the Wood Product Manufacturing subsector manufacture wood products, such as lumber, plywood, veneers, wood containers, wood flooring, wood trusses, manufactured homes (i.e., mobile homes), and prefabricated wood buildings.  The production processes of the Wood Product Manufacturing subsector include sawing, planing, shaping, laminating, and assembling wood products starting from logs that are cut into bolts, or lumber that then may be further cut, or shaped by lathes or other shaping tools.  The lumber or other transformed wood shapes may also be subsequently planed or smoothed, and assembled into finished products, such as wood containers.  The Wood Product Manufacturing subsector includes establishments that make wood products from logs and bolts that are sawed and shaped, and establishments that purchase sawed lumber and make wood products.  With the exception of sawmills and wood preservation establishments, the establishments are grouped into industries mainly based on the specific products manufactured.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Accommodation','Industries in the Accommodation subsector provide lodging or short-term accommodations for travelers, vacationers, and others.  There is a wide range of establishments in these industries.  Some provide lodging only, while others provide meals, laundry services, and recreational facilities, as well as lodging.  Lodging establishments are classified in this subsector even if the provision of complementary services generates more revenue.  The types of complementary services provided vary from establishment to establishment.

The subsector is organized into three groups: (1) traveler accommodation, (2) recreational accommodation, and (3) rooming and boarding houses, dormitories, and workers camps.  The Traveler Accommodation industry group includes establishments that primarily provide traditional types of lodging services.  This group includes hotels, motels, and bed-and-breakfast inns.  In addition to lodging, these establishments may provide a range of other services to their guests.  The RV (Recreational Vehicle) Parks and Recreational Camps industry group includes establishments that operate lodging facilities primarily designed to accommodate outdoor enthusiasts.  Included are travel trailer campsites, recreational vehicle parks, and outdoor adventure retreats.  The Rooming and Boarding Houses, Dormitories, and Workers'' Camps industry group includes establishments providing temporary or longer-term accommodations, that for the period of occupancy, may serve as a principal residence. Board (i.e., meals) may be provided but is not essential.

Establishments that manage short-stay accommodation establishments (e.g., hotels and motels) on a contractual basis are classified in this subsector if they both manage the operation and provide the operating staff.  Such establishments are classified based on the type of facility managed and operated.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Food Services and Drinking Places','Industries in the Food Services and Drinking Places subsector prepare meals, snacks, and beverages to customer order for immediate on-premises and off-premises consumption.  There is a wide range of establishments in these industries.  Some provide food and drink only, while others provide various combinations of seating space, waiter/waitress services, and incidental amenities, such as limited entertainment.  The industries in the subsector are grouped based on the type and level of services provided.  The industry groups are Special Food Services, such as food service contractors, caterers, and mobile food services; Drinking Places (Alcoholic Beverages); and Restaurants and Other Eating Places.

Food and beverage services at hotels and motels, amusement parks, theaters, casinos, country clubs, similar recreational facilities, and civic and social organizations are included in this subsector only if these services are provided by a separate establishment primarily engaged in providing food and beverage services.

Excluded from this subsector are establishments operating dinner cruises.  These establishments are classified in Subsector 487, Scenic and Sightseeing Transportation, because they utilize transportation equipment to provide scenic recreational entertainment.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Repair and Maintenance','Industries in the Repair and Maintenance subsector restore machinery, equipment, and other products to working order.  These establishments also typically provide general or routine maintenance (i.e., servicing) on such products to ensure they work efficiently and to prevent breakdown and unnecessary repairs.

The NAICS structure for this subsector brings together most types of repair and maintenance establishments and categorizes them based on production processes (i.e., on the type of repair and maintenance activity performed, and the necessary skills, expertise, and processes that are found in different repair and maintenance establishments).  This NAICS classification does not delineate between repair services provided to businesses versus those that serve households.  Although some industries primarily serve either businesses or households, separation by class of customer is limited by the fact that many establishments serve both.  Establishments repairing computers and consumer electronics products are two examples of such overlap.

The Repair and Maintenance subsector does not include all establishments that do repair and maintenance.  For example, a substantial amount of repair is done by establishments that also manufacture machinery, equipment, and other goods.  These establishments are included in the Manufacturing sector in NAICS.  In addition, repair of transportation equipment is often provided by or based at transportation facilities, such as airports and seaports, and these activities are included in the Transportation and Warehousing sector.  A particularly unique situation exists with repair of buildings.  Plumbing, electrical installation and repair, painting and decorating, and other construction-related establishments are often involved in performing installation or other work on new construction as well as providing repair services on existing structures.  While some specialize in repair, it is difficult to distinguish between the two types and all are included in the Construction sector.

Excluded from this subsector are establishments primarily engaged in rebuilding or remanufacturing machinery and equipment.  These are classified in Sector 31-33, Manufacturing.  Also excluded are retail establishments that provide after-sale services and repair.  These are classified in Sector 44-45, Retail Trade.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Paper Manufacturing','Industries in the Paper Manufacturing subsector make pulp, paper, or converted paper products.  The manufacturing of these products is grouped together because they constitute a series of vertically connected processes.  More than one is often carried out in a single establishment.  There are essentially three activities.  The manufacturing of pulp involves separating the cellulose fibers from other impurities in wood or used paper.  The manufacturing of paper involves matting these fibers into a sheet.  The manufacturing of converted paper products involves converting paper and other materials by various cutting and shaping techniques and includes coating and laminating activities.

The Paper Manufacturing subsector is subdivided into two industry groups, the first for the manufacturing of pulp and paper and the second for the manufacturing of converted paper products.  Paper making is treated as the core activity of the subsector.  Therefore, any establishment that makes paper (including paperboard), either alone or in combination with pulp manufacturing or paper converting, is classified as a paper or paperboard mill.  Establishments that make pulp without making paper are classified as pulp mills.  Pulp mills, paper mills and paperboard mills comprise the first industry group.

Establishments that make products from purchased paper and other materials make up the second industry group, Converted Paper Product Manufacturing.  This general activity is then subdivided based, for the most part, on process distinctions.  Paperboard container manufacturing uses corrugating, cutting, and shaping machinery to form paperboard into containers.  Paper bag and coated and treated paper manufacturing establishments cut and coat paper and foil.  Stationery product manufacturing establishments make a variety of paper products used for writing, filing, and similar applications.  Other converted paper product manufacturing includes, in particular, the conversion of sanitary paper stock into such things as tissue paper and disposable diapers.

An important process used in the Paper Bag and Coated and Treated Paper Manufacturing industry is lamination, often combined with coating.  Lamination and coating make a composite material with improved properties of strength, impermeability, and so on.  The laminated materials may be paper, metal foil, or plastics film. While paper is often one of the components, it is not always.  Lamination of plastics film to plastics film is classified in Subsector 326, Plastics and Rubber Products Manufacturing, because establishments that do this often first make the film.  The same situation holds with respect to bags.  The manufacturing of bags from plastics only, whether or not laminated, is classified in Subsector 326, Plastics and Rubber Products Manufacturing, but all other bag manufacturing is classified in this subsector.

Excluded from this subsector are photosensitive papers.  These papers are chemically treated and are classified in Industry 32599, All Other Chemical Product and Preparation Manufacturing.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Beverage and Tobacco Product Manufacturing','Industries in the Beverage and Tobacco Product Manufacturing subsector manufacture beverages and tobacco products.  The Beverage Manufacturing industry group includes three types of establishments: (1) those that manufacture nonalcoholic beverages; (2) those that manufacture alcoholic beverages through the fermentation process; and (3) those that produce distilled alcoholic beverages.  Ice manufacturing, while not a beverage, is included with nonalcoholic beverage manufacturing because it uses the same production process as water purification.

In the case of activities related to the manufacture of beverages, the structure follows the defined production processes.  Brandy, a distilled beverage, is not placed under distillery product manufacturing, but rather under winery product manufacturing since the production process used in the manufacturing of alcoholic grape-based beverages produces both wines (fermented beverage) and brandies (distilled beverage).

The Tobacco Manufacturing industry group includes two types of establishments: (1) those engaged in redrying and stemming tobacco and (2) those that manufacture tobacco products, such as cigarettes and cigars.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Textile Mills','Industries in the Textile Mills subsector group establishments that transform a basic fiber (natural or synthetic) into a product, such as yarn or fabric that is further manufactured into usable items, such as apparel, sheets, towels, and textile bags for individual or industrial consumption.  The further manufacturing may be performed in the same establishment and classified in this subsector, or it may be performed at a separate establishment and be classified elsewhere in manufacturing.

The main processes in this subsector include preparation and spinning of fiber, knitting or weaving of fabric, and the finishing of the textile.  The NAICS structure follows and captures this process flow. Major industries in this flow, such as preparation of fibers, weaving of fabric, knitting of fabric, and fiber and fabric finishing, are uniquely identified.  Texturizing, throwing, twisting, and winding of yarn contain aspects of both fiber preparation and fiber finishing and are classified with preparation of fibers rather than with finishing of fibers.

NAICS separates the manufacturing of primary textiles and the manufacturing of textile products (except apparel) produced from purchased primary textiles, such as fabric.  The manufacturing of textile products (except apparel) from purchased fabric is classified in Subsector 314, Textile Product Mills, and apparel from purchased fabric is classified in Subsector 315, Apparel Manufacturing.

Excluded from this subsector are establishments that weave or knit fabric and make garments. These establishments are included in Subsector 315, Apparel Manufacturing.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Textile Product Mills','Industries in the Textile Product Mills subsector group establishments that make textile products (except apparel).  With a few exceptions, processes used by these establishments are generally cut and sew (i.e., purchasing fabric and cutting and sewing to make nonapparel textile products, such as sheets and towels).
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Apparel Manufacturing','Industries in the Apparel Manufacturing subsector group establishments with two distinct manufacturing processes: (1) cut and sew (i.e., purchasing fabric and cutting and sewing to make a garment) and (2) the manufacture of garments in establishments that first knit fabric and then cut and sew the fabric into a garment.  The Apparel Manufacturing subsector includes a diverse range of establishments manufacturing full lines of ready-to-wear apparel and custom apparel: apparel contractors, performing cutting or sewing operations on materials owned by others; jobbers, performing entrepreneurial functions involved in apparel manufacturing; and tailors, manufacturing custom garments for individual clients. Knitting fabric, when done alone, is classified in the Textile Mills subsector, but when knitting is combined with the production of complete garments, the activity is classified in the Apparel Manufacturing subsector.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Plastics and Rubber Products Manufacturing','Industries in the Plastics and Rubber Products Manufacturing subsector make goods by processing plastics materials and raw rubber.  The core technology employed by establishments in this subsector is that of plastics or rubber product production.  Plastics and rubber are combined in the same subsector because plastics are increasingly being used as a substitute for rubber; however the subsector is generally restricted to the production of products made of just one material, either solely plastics or rubber.

Many manufacturing activities use plastics or rubber, for example the manufacture of footwear or furniture.  Typically, the production process of these products involves more than one material. In these cases, technologies that allow disparate materials to be formed and combined are of central importance in describing the manufacturing activity.  In NAICS, such activities (footwear and furniture manufacturing) are not classified in the Plastics and Rubber Products Manufacturing subsector because the core technologies for these activities are diverse and involve multiple materials.

Within the Plastics and Rubber Products Manufacturing subsector, a distinction is made between plastics and rubber products at the industry group level, although it is not a rigid distinction, as can be seen from the definition of Industry 32622, Rubber and Plastics Hoses and Belting Manufacturing.  As materials technology progresses, plastics are increasingly being used as a substitute for rubber; and eventually, the distinction may disappear as a basis for establishment classification.

In keeping with the core technology focus of plastics, lamination of plastics film to plastics film as well as the production of bags from plastics only is classified in this subsector.  Lamination and bag production involving plastics and materials other than plastics are classified in Subsector 322, Paper Manufacturing.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Nonmetallic Mineral Product Manufacturing','The Nonmetallic Mineral Product Manufacturing subsector transforms mined or quarried nonmetallic minerals, such as sand, gravel, stone, clay, and refractory materials, into products for intermediate or final consumption.  Processes used include grinding, mixing, cutting, shaping, and honing.  Heat often is used in the process and chemicals are frequently mixed to change the composition, purity, and chemical properties for the intended product.  For example, glass is produced by heating silica sand to the melting point (sometimes combined with cullet or recycled glass) and then drawn, floated, or blow molded to the desired shape or thickness.  Refractory materials are heated and then formed into bricks or other shapes for use in industrial applications.

The Nonmetallic Mineral Product Manufacturing subsector includes establishments that manufacture bricks, refractories, ceramic products, and glass and glass products, such as plate glass and containers.  Also included are cement and concrete products, lime, gypsum and other nonmetallic mineral products including abrasive products, ceramic plumbing fixtures, statuary, cut stone products, and mineral wool.  The products are used in a wide range of activities from construction and heavy and light manufacturing to articles for personal use.

Mining, beneficiating, and manufacturing activities often occur in a single location.  Separate receipts will be collected for these activities whenever possible.  When receipts cannot be broken out between mining and manufacturing, establishments that mine or quarry nonmetallic minerals, beneficiate the nonmetallic minerals, and further process the nonmetallic minerals into a more finished manufactured product are classified based on the primary activity of the establishment.  A mine that manufactures a small amount of finished products is classified in Sector 21, Mining, Quarrying, and Oil and Gas Extraction.  An establishment that mines whose primary output is a more finished manufactured product is classified in the Manufacturing sector.

Excluded from the Nonmetallic Mineral Product Manufacturing subsector are establishments that primarily beneficiate mined nonmetallic minerals.  Beneficiation is the process whereby the extracted material is reduced to particles that can be separated into mineral and waste, the former suitable for further processing or direct use.  Beneficiation establishments are included in Sector 21, Mining, Quarrying, and Oil and Gas Extraction.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Printing and Related Support Activities','Industries in the Printing and Related Support Activities subsector print products, such as newspapers, books, labels, business cards, stationery, business forms, and other materials, and perform support activities, such as data imaging, platemaking services, and bookbinding.  The support activities included here are an integral part of the printing industry, and a product (a printing plate, a bound book, or a computer disk or file) that is an integral part of the printing industry is almost always provided by these operations.

Processes used in printing include a variety of methods used to transfer an image from a plate, screen, film, or computer file to some medium, such as paper, plastics, metal, textile articles, or wood.  The printing processes employed include, but are not limited to, lithographic, gravure, screen, flexographic, digital, and letterpress.

In contrast to many other classification systems that locate publishing of printed materials in manufacturing, NAICS classifies the publishing of printed products in Subsector 511, Publishing Industries (except Internet).  Though printing and publishing are often carried out by the same enterprise (a newspaper, for example), it is less and less the case that these distinct activities are carried out in the same establishment.  When publishing and printing are done in the same establishment, the establishment is classified in Sector 51, Information, in the appropriate NAICS industry even if the receipts for printing exceed those for publishing.

This subsector includes printing on clothing because the production process for that activity is printing, not clothing manufacturing.  For instance, the printing of T-shirts is included in this subsector. In contrast, printing on fabric (or grey goods) is not included.  This activity is part of the process of finishing the fabric and is included in the Textile Mills subsector in Industry 31331, Textile and Fabric Finishing Mills.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Petroleum and Coal Products Manufacturing','The Petroleum and Coal Products Manufacturing subsector is based on the transformation of crude petroleum and coal into usable products.  The dominant process is petroleum refining that involves the separation of crude petroleum into component products through such techniques as cracking and distillation.

In addition, this subsector includes establishments that primarily further process refined petroleum and coal products and produce products, such as asphalt coatings and petroleum lubricating oils.  However, establishments that manufacture petrochemicals from refined petroleum are classified in Industry 32511, Petrochemical Manufacturing.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Chemical Manufacturing','The Chemical Manufacturing subsector is based on the transformation of organic and inorganic raw materials by a chemical process and the formulation of products.  This subsector distinguishes the production of basic chemicals that comprise the first industry group from the production of intermediate and end products produced by further processing of basic chemicals that make up the remaining industry groups.

This subsector does not include all industries transforming raw materials by a chemical process.  It is common for some chemical processing to occur during mining operations.  These beneficiating operations, such as copper concentrating, are classified in Sector 21, Mining, Quarrying, and Oil and Gas Extraction.  Furthermore, the refining of crude petroleum is included in Subsector 324, Petroleum and Coal Products Manufacturing.  In addition, the manufacturing of aluminum oxide is included in Subsector 331, Primary Metal Manufacturing; and beverage distilleries are classified in Subsector 312, Beverage and Tobacco Product Manufacturing.  As is the case of these two activities, the grouping of industries into subsectors may take into account the association of the activities performed with other activities in the subsector.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Machinery Manufacturing','Industries in the Machinery Manufacturing subsector create end products that apply mechanical force, for example, the application of gears and levers, to perform work.  Some important processes for the manufacture of machinery are forging, stamping, bending, forming, and machining that are used to shape individual pieces of metal.  Processes, such as welding and assembling are used to join separate parts together.  Although these processes are similar to those used in metal fabricating establishments, machinery manufacturing is different because it typically employs multiple metal forming processes in manufacturing the various parts of the machine.  Moreover, complex assembly operations are an inherent part of the production process.

In general, design considerations are very important in machinery production. Establishments specialize in making machinery designed for particular applications.  Thus, design is considered to be part of the production process for the purpose of implementing NAICS.  The NAICS structure reflects this by defining industries and industry groups that make machinery for different applications.  A broad distinction exists between machinery that is generally used in a variety of industrial applications (i.e., general purpose machinery) and machinery that is designed to be used in a particular industry (i.e., special purpose machinery).  Three industry groups consist of special purpose machinery--Agricultural, Construction, and Mining Machinery Manufacturing; Industrial Machinery Manufacturing; and Commercial and Service Industry Machinery Manufacturing.  The other industry groups make general purpose machinery: Ventilation, Heating, Air-Conditioning, and Commercial Refrigeration Equipment Manufacturing; Metalworking Machinery Manufacturing; Engine, Turbine, and Power Transmission Equipment Manufacturing; and Other General Purpose Machinery Manufacturing.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Primary Metal Manufacturing','Industries in the Primary Metal Manufacturing subsector smelt and/or refine ferrous and nonferrous metals from ore, pig or scrap, using electrometallurgical and other process metallurgical techniques.  Establishments in this subsector also manufacture metal alloys and superalloys by introducing other chemical elements to pure metals.  The output of smelting and refining, usually in ingot form, is used in rolling, drawing, and extruding operations to make sheet, strip, bar, rod, or wire, and in molten form to make castings and other basic metal products.

Primary manufacturing of ferrous and nonferrous metals begins with ore or concentrate as the primary input.  Establishments manufacturing primary metals from ore and/or concentrate remain classified in the primary smelting, primary refining, or iron and steel mill industries regardless of the form of their output.  Establishments primarily engaged in secondary smelting and/or secondary refining recover ferrous and nonferrous metals from scrap and/or dross.  The output of the secondary smelting and/or secondary refining industries is limited to shapes such as ingot or billet that will be further processed.  Recovery of metals from scrap often occurs in establishments that are primarily engaged in activities, such as rolling, drawing, extruding, or similar processes.

Excluded from the Primary Metal Manufacturing subsector are establishments primarily engaged in manufacturing ferrous and nonferrous forgings (except ferrous forgings made in steel mills) and stampings.  Although forging, stamping, and casting are all methods used to make metal shapes, forging and stamping do not use molten metals and are included in Subsector 332, Fabricated Metal Product Manufacturing.  Establishments primarily engaged in operating coke ovens are classified in Industry 32419, Other Petroleum and Coal Products Manufacturing.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Fabricated Metal Product Manufacturing','Industries in the Fabricated Metal Product Manufacturing subsector transform metal into intermediate or end products, other than machinery, computers and electronics, and metal furniture, or treat metals and metal formed products fabricated elsewhere.  Important fabricated metal processes are forging, stamping, bending, forming, and machining, used to shape individual pieces of metal; and other processes, such as welding and assembling, used to join separate parts together.  Establishments in this subsector may use one of these processes or a combination of these processes.

The NAICS structure for this subsector distinguishes the forging and stamping processes in a single industry.  The remaining industries in the subsector group establishments based on similar combinations of processes used to make products.

The manufacturing performed in the Fabricated Metal Product Manufacturing subsector begins with manufactured metal shapes.  The establishments in this subsector further fabricate the purchased metal shapes into a product.  For instance, the Spring and Wire Product Manufacturing industry starts with wire and fabricates such items.

Within manufacturing there are other establishments that make the same products made by this subsector; only these establishments begin production further back in the production process.  These establishments have a more integrated operation.  For instance, one establishment may manufacture steel, draw it into wire, and make wire products in the same establishment.  Such operations are classified in the Primary Metal Manufacturing subsector.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Electrical Equipment, Appliance, and Component Manufacturing','Industries in the Electrical Equipment, Appliance, and Component Manufacturing subsector manufacture products that generate, distribute and use electrical power. Electric Lighting Equipment Manufacturing establishments produce electric lamp bulbs, lighting fixtures, and parts.  Household Appliance Manufacturing establishments make both small and major electrical appliances and parts.  Electrical Equipment Manufacturing establishments make goods, such as electric motors, generators, transformers, and switchgear apparatus.  Other Electrical Equipment and Component Manufacturing establishments make devices for storing electrical power (e.g., batteries), for transmitting electricity (e.g., insulated wire), and wiring devices (e.g., electrical outlets, fuse boxes, and light switches).
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Computer and Electronic Product Manufacturing','Industries in the Computer and Electronic Product Manufacturing subsector group establishments that manufacture computers, computer peripherals, communications equipment, and similar electronic products, and establishments that manufacture components for such products.  The Computer and Electronic Product Manufacturing industries have been combined in the hierarchy of NAICS because of the economic significance they have attained.  Their rapid growth suggests that they will become even more important to the economies of all three North American countries in the future, and in addition their manufacturing processes are fundamentally different from the manufacturing processes of other machinery and equipment.  The design and use of integrated circuits and the application of highly specialized miniaturization technologies are common elements in the production technologies of the Computer and Electronic Product Manufacturing subsector.  Convergence of technology motivates this NAICS subsector.  Digitalization of sound recording, for example, causes both the medium (the compact disc) and the equipment to resemble the technologies for recording, storing, transmitting, and manipulating data.  Communications technology and equipment have been converging with computer technology.  When technologically-related components are in the same sector, it makes it easier to adjust the classification for future changes, without needing to redefine its basic structure.  The creation of the Computer and Electronic Product Manufacturing subsector assists in delineating new and emerging industries because the activities that will serve as the probable sources of new industries, such as computer manufacturing and communications equipment manufacturing, or computers and audio equipment, are brought together.  As new activities emerge, they are less likely to cross the subsector boundaries of the classification.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Furniture and Related Product Manufacturing','Industries in the Furniture and Related Product Manufacturing subsector make furniture and related articles, such as mattresses, window blinds, cabinets, and fixtures.  The processes used in the manufacture of furniture include the cutting, bending, molding, laminating, and assembly of such materials as wood, metal, glass, plastics, and rattan.  However, the production process for furniture is not solely bending metal, cutting and shaping wood, or extruding and molding plastics.  Design and fashion trends play an important part in the production of furniture.  The integrated design of the article for both esthetic and functional qualities is also a major part of the process of manufacturing furniture.  Design services may be performed by the furniture establishment''s work force or may be purchased from industrial designers.

Furniture may be made of any material, but the most common ones used in North America are metal and wood.  Furniture manufacturing establishments may specialize in making articles primarily from one material.  Some of the equipment required to make a wooden table, for example, is different from that used to make a metal one.  However, furniture is usually made from several materials.  A wooden table might have metal brackets, and a wooden chair a fabric or plastics seat.  Therefore, in NAICS, furniture initially is classified based on the type of furniture (application for which it is designed) rather than the material used.  For example, an upholstered sofa is treated as household furniture, although it may also be used in hotels or offices.

When classifying furniture according to the component material from which it is made, furniture made from more than one material is classified based on the material used in the frame, or if there is no frame, the predominant component material.  Upholstered household furniture (excluding kitchen and dining room chairs with upholstered seats) is classified without regard to the frame material.  Kitchen or dining room chairs with upholstered seats are classified according to the frame material.

Furniture may be made on a stock or custom basis and may be shipped assembled or unassembled (i.e., knockdown).  The manufacture of furniture parts and frames is included in this subsector.

Some of the processes used in furniture manufacturing are similar to processes that are used in other segments of manufacturing.  For example, cutting and assembly occurs in the production of wood trusses that are classified in Subsector 321, Wood Product Manufacturing.  However, the multiple processes that distinguish wood furniture manufacturing from wood product manufacturing warrant inclusion of wooden furniture manufacturing in the Furniture and Related Product Manufacturing subsector.  Metal furniture manufacturing uses techniques that are also employed in the manufacturing of roll formed products classified in Subsector 332, Fabricated Metal Product Manufacturing.  The molding process for plastics furniture is similar to the molding of other plastics products.  However, plastics furniture producing establishments tend to specialize in furniture.

NAICS attempts to keep furniture manufacturing together, but there are two notable exceptions: seating for transportation equipment and specialized hospital furniture (e.g., hospital beds and operating tables).  These exceptions are related to the fact that some of the aspects of the production process for these products, primarily the design, are highly integrated with the other manufactured goods, namely motor vehicles and medical equipment.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Miscellaneous Manufacturing','Industries in the Miscellaneous Manufacturing subsector make a wide range of products that cannot readily be classified in specific NAICS subsectors in manufacturing.  Processes used by these establishments vary significantly, both among and within industries.  For example, a variety of manufacturing processes are used in manufacturing sporting and athletic goods that include products such as tennis racquets and golf balls.  The processes for these products differ from each other, and the processes differ significantly from the fabrication processes used in making dolls or toys, the melting and shaping of precious metals to make jewelry, and the bending, forming, and assembly used in making medical products.

The industries in this subsector are defined by what is made rather than how it is made.  Although individual establishments might be appropriately classified elsewhere in the NAICS structure, for historical continuity, these product-based industries were maintained.  In most cases, no one process or material predominates for an industry.

Establishments in this subsector manufacture products as diverse as medical equipment and supplies, jewelry, sporting goods, toys, and office supplies.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Merchant Wholesalers, Durable Goods ','Industries in the Merchant Wholesalers, Durable Goods subsector sell capital or durable goods to other businesses.  Merchant wholesalers generally take title to the goods that they sell; in other words, they buy and sell goods on their own account.  Durable goods are new or used items generally with a normal life expectancy of three years or more.  Durable goods merchant wholesale trade establishments are engaged in wholesaling products, such as motor vehicles, furniture, construction materials, machinery and equipment (including household-type appliances), metals and minerals (except petroleum), sporting goods, toys and hobby goods, recyclable materials, and parts.

Business-to-business electronic markets, agents, and brokers primarily engaged in wholesaling durable goods, generally on a commission or fee basis, are classified in Subsector 425, Wholesale Electronic Markets and Agents and Brokers.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Transportation Equipment Manufacturing','Industries in the Transportation Equipment Manufacturing subsector produce equipment for transporting people and goods.  Transportation equipment is a type of machinery.  An entire subsector is devoted to this activity because of the significance of its economic size in all three North American countries.

Establishments in this subsector utilize production processes similar to those of other machinery manufacturing establishments-bending, forming, welding, machining, and assembling metal or plastic parts into components and finished products.  However, the assembly of components and subassemblies and their further assembly into finished vehicles tends to be a more common production process in this subsector than in the Machinery Manufacturing subsector.

NAICS has industry groups for the manufacture of equipment for each mode of transport-road, rail, air and water.  Parts for motor vehicles warrant a separate industry group because of their importance and because they require less assembly than complete vehicles.

Land use motor vehicle equipment not designed for highway operation (e.g., agricultural equipment, construction equipment, and material handling equipment) is classified in the appropriate NAICS subsector based on the type and use of the equipment.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Merchant Wholesalers, Nondurable Goods ','Industries in the Merchant Wholesalers, Nondurable Goods subsector sell nondurable goods to other businesses.  Nondurable goods are items generally with a normal life expectancy of less than three years.  Nondurable goods merchant wholesale trade establishments are engaged in wholesaling products, such as paper and paper products, chemicals and chemical products, drugs, textiles and textile products, apparel, footwear, groceries, farm products, petroleum and petroleum products, alcoholic beverages, books, magazines, newspapers, flowers and nursery stock, and tobacco products.

The detailed industries within the subsector are organized in the classification structure based on the products sold.

Business-to-business electronic markets, agents, and brokers primarily engaged in wholesaling nondurable goods, generally on a commission or fee basis, are classified in Subsector 425, Wholesale Electronic Markets and Agents and Brokers.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Gasoline Stations ','Industries in the Gasoline Stations subsector retail automotive fuels (e.g., gasoline, diesel fuel, gasohol, alternative fuels) and automotive oils or retail these products in combination with convenience store items.  These establishments have specialized equipment for storing and dispensing automotive fuels.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Clothing and Clothing Accessories Stores ','Industries in the Clothing and Clothing Accessories Stores subsector retail new clothing and clothing accessories from fixed point-of-sale locations.  Establishments in this subsector have similar display equipment and staff that is knowledgeable regarding fashion trends and the proper match of styles, colors, and combinations of clothing and accessories to the characteristics and tastes of the customer.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Sporting Goods, Hobby, Musical Instrument, and Book Stores ','Industries in the Sporting Goods, Hobby, Musical Instrument, and Book Stores subsector are engaged in retailing and providing expertise on the use of sporting equipment or supplies for other specific leisure activities, such as needlework and musical instruments.  Book stores are also included in this subsector.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','General Merchandise Stores ','Industries in the General Merchandise Stores subsector retail new general merchandise from fixed point-of-sale locations.  Establishments in this subsector are unique in that they have the equipment and staff capable of retailing a large variety of goods from a single location.  This includes a variety of display equipment and staff trained to provide information on many lines of products.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Miscellaneous Store Retailers ','Industries in the Miscellaneous Store Retailers subsector retail merchandise from fixed point-of-sale locations (except new or used motor vehicles and parts; new furniture and home furnishings; new appliances and electronic products; new building materials and garden equipment and supplies; food and beverages; health and personal care goods; gasoline; new clothing and accessories; and new sporting goods, hobby goods, books, and music).  Establishments in this subsector include stores with unique characteristics, such as florists, used merchandise stores, and pet and pet supply stores.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Nonstore Retailers ','Industries in the Nonstore Retailers subsector retail merchandise using methods, such as the broadcasting of infomercials, the broadcasting and publishing of direct-response advertising, the publishing of paper and electronic catalogs, door-to-door solicitation, in-home demonstration, selling from portable stalls, and distribution through vending machines.  Establishments in this subsector include mail-order houses, vending machine operators, home delivery sales, door-to-door sales, party plan sales, electronic shopping, and sales through portable stalls (e.g., street vendors, except food).  Establishments engaged in the direct sale (i.e., nonstore) of products, such as home heating oil dealers and newspaper delivery service providers, are included in this subsector.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Wholesale Electronic Markets and Agents and Brokers ','Industries in the Wholesale Electronic Markets and Agents and Brokers subsector arrange for the sale of goods owned by others, generally on a fee or commission basis.  They act on behalf of the buyers and sellers of goods.  This subsector contains agents and brokers as well as business-to-business electronic markets that facilitate wholesale trade.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Management of Companies and Enterprises','Industries in the Management of Companies and Enterprises subsector include three main types of establishments: (1) those that hold the securities of (or other equity interests in) companies and enterprises; (2) those (except government establishments) that administer, oversee, and manage other establishments of the company or enterprise but do not hold the securities of these establishments; and (3) those that both administer, oversee, and manage other establishments of the company or enterprise and hold the securities of (or other equity interests in) these establishments.  Those establishments that administer, oversee, and manage normally undertake the strategic or organizational planning and decision-making role of the company or enterprise.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Animal Production and Aquaculture','Industries in the Animal Production and Aquaculture subsector raise or fatten animals for the sale of animals or animal products and/or raise aquatic plants and animals in controlled or selected aquatic environments for the sale of aquatic plants, animals, or their products.  The subsector includes establishments, such as ranches, farms, and feedlots, primarily engaged in keeping, grazing, breeding, or feeding animals.  These animals are kept for the products they produce or for eventual sale.  The animals are generally raised in various environments, from total confinement or captivity to feeding on an open range pasture.

The industries in this subsector are grouped by important factors, such as suitable grazing or pasture land, specialized buildings, type of equipment, and the amount and types of labor required.  Establishments are classified in the Animal Production and Aquaculture subsector when animal production (i.e., value of animals for market) accounts for one-half or more of the establishment''s total agricultural production.  Establishments with one-half or more animal production with no one animal product or family of animal products of an industry accounting for one-half of the establishment''s agricultural production are treated as combination animal farming classified in Industry 11299, All Other Animal Production.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Administrative and Support Services','Industries in the Administrative and Support Services subsector group establishments engaged in activities that support the day-to-day operations of other organizations.  The processes employed in this sector (e.g., general management, personnel administration, clerical activities, cleaning activities) are often integral parts of the activities of establishments found in all sectors of the economy.  The establishments classified in this subsector have specialization in one or more of these activities and can, therefore, provide services to clients in a variety of industries and, in some cases, to households.  The individual industries of this subsector are defined on the basis of the particular process that they are engaged in and the particular services they provide.

Many of the activities performed in this subsector are ongoing routine support functions that all businesses and organizations must do and that they have traditionally done for themselves.  Recent trends, however, are to contract or purchase such services from businesses that specialize in such activities and can, therefore, provide the services more efficiently.

The industries in this subsector cannot be viewed as strictly "support." The Travel Arrangement and Reservation Services industry group includes travel agents, tour operators, and providers of other travel arrangement services, such as hotel and restaurant reservations and arranging the purchase of tickets, serving many types of clients, including individual consumers.  This group was placed in this subsector because the services are often of the "support" nature (e.g., travel arrangement), and businesses and other organizations increasingly purchase such services.

The administrative and management activities performed by establishments in this sector are typically on a contract or fee basis.  These activities may also be performed by establishments that are part of the company or enterprise.  However, establishments involved in administering, overseeing, and managing other establishments of the company or enterprise are classified in Sector 55, Management of Companies and Enterprises.  Establishments in Sector 55, Management of Companies and Enterprises, normally undertake the strategic and organizational planning and decision-making role of the company or enterprise.  Government establishments engaged in administering, overseeing, and managing governmental programs are classified in Sector 92, Public Administration.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Ambulatory Health Care Services','Industries in the Ambulatory Health Care Services subsector provide health care services directly or indirectly to ambulatory patients and do not usually provide inpatient services.  Health practitioners in this subsector provide outpatient services, with the facilities and equipment not usually being the most significant part of the production process.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Waste Management and Remediation Services','Industries in the Waste Management and Remediation Services subsector group establishments engaged in the collection, treatment, and disposal of waste materials.  This includes establishments engaged in local hauling of waste materials; operating materials recovery facilities (i.e., those that sort recyclable materials from the trash stream); providing remediation services (i.e., those that provide for the cleanup of contaminated buildings, mine sites, soil, or ground water); and providing septic pumping and other miscellaneous waste management services.  There are three industry groups within the subsector that separate these activities into waste collection, waste treatment and disposal, and remediation and other waste management.

Excluded from this subsector are establishments primarily engaged in collecting, treating, and disposing waste through sewer systems or sewage treatment facilities that are classified in Industry 22132, Sewage Treatment Facilities, and establishments primarily engaged in long-distance hauling of waste materials that are classified in Industry 48423, Specialized Freight (except Used Goods) Trucking, Long-Distance.  Also, there are some activities that appear to be related to waste management, but that are not included in this subsector.  For example, establishments primarily engaged in providing waste management consulting services are classified in Industry 54162, Environmental Consulting Services.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Educational Services','Industries in the Educational Services subsector provide instruction and training in a wide variety of subjects.  The instruction and training is provided by specialized establishments, such as schools, colleges, universities, and training centers.

The subsector is structured according to level and type of educational services.  Elementary and secondary schools, junior colleges and colleges, universities, and professional schools correspond to a recognized series of formal levels of education designated by diplomas, associate degrees (including equivalent certificates), and degrees.  The remaining industry groups are based more on the type of instruction or training offered, and the levels are not always as formally defined.  The establishments are often highly specialized, many offering instruction in a very limited subject matter, for example ski lessons or one specific computer software package.  Within the subsector, the level and types of training that are required of the instructors and teachers vary depending on the industry.

Establishments that manage schools and other educational establishments on a contractual basis are classified in this subsector if they both manage the operation and provide the operating staff.  Such establishments are classified in the Educational Services subsector based on the type of facility managed and operated.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Forestry and Logging','Industries in the Forestry and Logging subsector grow and harvest timber on a long production cycle (i.e., of 10 years or more).  Long production cycles use different production processes than short production cycles, which require more horticultural interventions prior to harvest, resulting in processes more similar to those found in the Crop Production subsector.  Consequently, Christmas tree production and other production involving production cycles of less than 10 years, are classified in the Crop Production subsector.

Industries in this subsector specialize in different stages of the production cycle.  Reforestation requires production of seedlings in specialized nurseries.  Timber production requires natural forest or suitable areas of land that are available for a long duration.  The maturation time for timber depends upon the species of tree, the climatic conditions of the region, and the intended purpose of the timber.  The harvesting of timber (except when done on an extremely small scale) requires specialized machinery unique to the industry.  Establishments gathering forest products, such as gums, barks, balsam needles, rhizomes, fibers, Spanish moss, and ginseng and truffles, are also included in this subsector.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Fishing, Hunting and Trapping','Industries in the Fishing, Hunting and Trapping subsector harvest fish and other wild animals from their natural habitats and are dependent upon a continued supply of the natural resource.  The harvesting of fish is the predominant economic activity of this subsector and it usually requires specialized vessels that, by the nature of their size, configuration and equipment, are not suitable for any other type of production, such as transportation.

Hunting and trapping activities utilize a wide variety of production processes and are classified in the same subsector as fishing because the availability of resources and the constraints imposed, such as conservation requirements and proper habitat maintenance, are similar.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Support Activities for Agriculture and Forestry','Industries in the Support Activities for Agriculture and Forestry subsector provide support services that are an essential part of agricultural and forestry production.  These support activities may be performed by the agriculture or forestry producing establishment or conducted independently as an alternative source of inputs required for the production process for a given crop, animal, or forestry industry.  Establishments that primarily perform these activities independent of the agriculture or forestry producing establishment are in this subsector.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Crop Production','Industries in the Crop Production subsector grow crops mainly for food and fiber.  The subsector comprises establishments, such as farms, orchards, groves, greenhouses, and nurseries, primarily engaged in growing crops, plants, vines, or trees and their seeds.

The industries in this subsector are grouped by similarity of production activity, including biological and physiological characteristics and economic requirements, the length of growing season, degree of crop rotation, extent of input specialization, labor requirements, and capital demands.  The production process is typically completed when the raw product or commodity grown reaches the "farm gate" for market, that is, at the point of first sale or price determination.

Establishments are classified in the Crop Production subsector when crop production (i.e., value of crops for market) accounts for one-half or more of the establishment''s total agricultural production.  Within the subsector, establishments are classified in a specific industry when a product or industry family of products (i.e., oilseed and grain farming, vegetable and melon farming, fruit and tree nut farming) account for one-half or more of the establishment''s agricultural production.  Establishments with one-half or more crop production with no one product or family of products of an industry accounting for one-half of the establishment''s agricultural production are treated as general combination crop farming and are classified in Industry 11199, All Other Crop Farming.

Industries in the Crop Production subsector include establishments that own, operate, and manage and those that operate and manage.  Those that manage only are classified in Subsector 115, Support Activities for Agriculture and Forestry.  Establishments that raise aquatic plants in controlled or selected aquatic environments are classified in Subsector 112, Animal Production and Aquaculture.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Utilities','Industries in the Utilities subsector provide electric power, natural gas, steam supply, water supply, and sewage removal through a permanent infrastructure of lines, mains, and pipes.  Establishments are grouped together based on the utility service provided and the particular system or facilities required to perform the service.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Construction of Buildings','The Construction of Buildings subsector comprises establishments primarily responsible for the construction of buildings.  The work performed may include new work, additions, alterations, or maintenance and repairs.  The on-site assembly of precut, panelized, and prefabricated buildings and construction of temporary buildings are included in this subsector.  Part or all of the production work for which the establishments in this subsector have responsibility may be subcontracted to other construction establishments--usually specialty trade contractors.

Establishments in this subsector are classified based on the types of buildings they construct.  This classification reflects variations in the requirements of the underlying production processes.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('INDUSTRIES','en','Performing Arts, Spectator Sports, and Related Industries','Industries in the Performing Arts, Spectator Sports, and Related Industries subsector group establishments that produce or organize and promote live presentations involving the performances of actors and actresses, singers, dancers, musical groups and artists, athletes, and other entertainers, including independent (i.e., freelance) entertainers and the establishments that manage their careers.  The classification recognizes four basic processes: (1) producing (i.e., presenting) events; (2) organizing, managing, and/or promoting events; (3) managing and representing entertainers; and (4) providing the artistic, creative and technical skills necessary to the production of these live events.  Also, this subsector contains four industries for performing arts companies.  Each is defined on the basis of the particular skills of the entertainers involved in the presentations.

The industry structure for this subsector makes a clear distinction between performing arts companies and performing artists (i.e., independent or freelance).  Although not unique to arts and entertainment, freelancing is a particularly important phenomenon in this Performing Arts, Spectator Sports, and Related Industries subsector.  Distinguishing this activity from the production activity is a meaningful process differentiation.  This approach, however, is difficult to implement in the case of musical groups (i.e., companies) and artists, especially pop groups.  These establishments tend to be more loosely organized and it can be difficult to distinguish companies from freelancers.  For this reason, NAICS includes one industry that covers both musical groups and musical artists.

This subsector contains two industries for Industry Group 7113, Promoters of Performing Arts, Sports, and Similar Events, one for those that operate facilities and another for those that do not.  This is because there are significant differences in cost structures between those promoters that manage and provide the staff to operate facilities and those that do not.  In addition to promoters without facilities, other industries in this subsector include establishments that may operate without permanent facilities.  These types of establishments include performing arts companies; musical groups and artists; spectator sports; and independent (i.e., freelance) artists, writers, and performers.

Excluded from this subsector are nightclubs.  Some nightclubs promote live entertainment on a regular basis and it can be argued that they could be classified in Industry Group 7113, Promoters of Performing Arts, Sports, and Similar Events.  However, since most of these establishments function as any other drinking place when they do not promote entertainment and because most of their revenue is derived from sale of food and beverages, they are classified in Subsector 722, Food Services and Drinking Places.
',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Borneo','Brunei;Indonesia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Honshu','Japan',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Victoria Island','Canada',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Great Britain','United Kingdom',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Ellesmere Island','Canada',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Sulawesi','Indonesia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','South Island','New Zealand',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Java','Indonesia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Mindanao','Philippines',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Ireland','Ireland;United Kingdom',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Hokkaido','Japan',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Sri Lanka','Sri Lanka',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Alexander Island','None',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Isla Grande de Tierra del Fuego','Argentina;Chile',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Prince of Wales Island','Canada',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Bananal','Brazil',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Shikoku','Japan',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','New Caledonia','New Caledonia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Yos Sudarso','Indonesia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Hawaii','United States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Kodiak Island','United States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Cyprus','Cyprus',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Puerto Rico','United States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Crete','Greece',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Leyte','Philippines',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','East Falkland','Falkland Islands',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Prince of Wales Island','United States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Kerguelen','France',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Siple Island','None',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Vanua Levu','Fiji',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Bali','Indonesia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Chichagof Island','United States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Guadalcanal','Solomon Islands',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','St. Lawrence Island','United States',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Lombok','Indonesia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','West Falkland','Falkland Islands',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Kangaroo Island','Australia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Nias','Indonesia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Espiritu Santo','Vanuatu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','North Andros Island','Bahamas',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Waigeo','Indonesia',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Akimiski Island','Canada',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Gotland','Sweden',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Reunion','France',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Rene-Levasseur Island','Canada',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Jeju Island','South Korea',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Great Inagua','Bahamas',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Desolacion Island','Chile',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Oland','Sweden',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Tahiti','France',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('ISLANDS','en','Saaminginsalo','Finland',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('LANGUAGES','en','af','SOUTH AFRICA','ENGLISH','Afrikaans');
   i('LANGUAGES','en','sq','ALBANIA','ALBANIAN','Albania');
   i('LANGUAGES','en','ar','UNITED ARAB EMIRATES','ARABIC','Arabic');
   i('LANGUAGES','en','ar-dz','ALGERIA','ARABIC','Arabic (Algeria)');
   i('LANGUAGES','en','ar-bh','BAHRAIN','ARABIC','Arabic (Bahrain)');
   i('LANGUAGES','en','ar-eg','EGYPT','EGYPTIAN','Arabic (Egypt)');
   i('LANGUAGES','en','ar-iq','IRAQ','ARABIC','Arabic (Iraq)');
   i('LANGUAGES','en','ar-jo','JORDAN','ARABIC','Arabic (Jordan)');
   i('LANGUAGES','en','ar-kw','KUWAIT','ARABIC','Arabic (Kuwait)');
   i('LANGUAGES','en','ar-lb','LEBANON','ARABIC','Arabic (Lebanon)');
   i('LANGUAGES','en','ar-ly','LIBYA','ARABIC','Arabic (Libya)');
   i('LANGUAGES','en','ar-ma','MOROCCO','ARABIC','Arabic (Morocco)');
   i('LANGUAGES','en','ar-om','OMAN','ARABIC','Arabic (Oman)');
   i('LANGUAGES','en','ar-qa','QATAR','ARABIC','Arabic (Qatar)');
   i('LANGUAGES','en','ar-sa','SAUDI ARABIA','ARABIC','Arabic (Saudi Arabia)');
   i('LANGUAGES','en','ar-sy','SYRIA','ARABIC','Arabic (Syria)');
   i('LANGUAGES','en','ar-tn','TUNISIA','ARABIC','Arabic (Tunisia)');
   i('LANGUAGES','en','ar-ae','UNITED ARAB EMIRATES','ARABIC','Arabic (U.A.E.)');
   i('LANGUAGES','en','ar-ye','YEMEN','ARABIC','Arabic (Yemen)');
   i('LANGUAGES','en','hy','ARMENIA','ARMENIAN','Armenia');
   i('LANGUAGES','en','as','INDIA','ASSAMESE','Assamese');
   i('LANGUAGES','en','az','AZERBAIJAN','AZERBAIJANI','Azerbaijani');
   i('LANGUAGES','en','eu','FRANCE','FRENCH','Basque');
   i('LANGUAGES','en','be','BELARUS','BELARUSIAN','Belarusian');
   i('LANGUAGES','en','bn','BANGLADESH','BANGLA','Bengali');
   i('LANGUAGES','en','bg','BULGARIA','BULGARIAN','Bulgarian');
   i('LANGUAGES','en','ca','CATALONIA','CATALAN','Catalan');
   i('LANGUAGES','en','zh','CHINA','SIMPLIFIED CHINESE','Chinese');
   i('LANGUAGES','en','zh-cn','CHINA','SIMPLIFIED CHINESE','Chinese (China)');
   i('LANGUAGES','en','zh-hk','HONG KONG','TRADITIONAL CHINESE','Chinese (Hong Kong SAR)');
   i('LANGUAGES','en','zh-mo','HONG KONG','TRADITIONAL CHINESE','Chinese (Macau SAR)');
   i('LANGUAGES','en','zh-sg','SINGAPORE','SIMPLIFIED CHINESE','Chinese (Singapore)');
   i('LANGUAGES','en','zh-tw','TAIWAN','TRADITIONAL CHINESE','Chinese (Taiwan)');
   i('LANGUAGES','en','hr','CROATIA','CROATIAN','Croatian');
   i('LANGUAGES','en','cs','CZECH REPUBLIC','CZECH','Czech');
   i('LANGUAGES','en','da','DENMARK','DANISH','Danish');
   i('LANGUAGES','en','nl-be','BELGIUM','DUTCH','Dutch (Belgium)');
   i('LANGUAGES','en','nl','THE NETHERLANDS','DUTCH','Dutch (Netherlands)');
   i('LANGUAGES','en','en','AMERICA','AMERICAN','English');
   i('LANGUAGES','en','en-au','AUSTRALIA','ENGLISH','English (Australia)');
   i('LANGUAGES','en','en-bz','UNITED KINGDOM','ENGLISH','English (Belize)');
   i('LANGUAGES','en','en-ca','CANADA','ENGLISH','English (Canada)');
   i('LANGUAGES','en','en-ie','IRELAND','ENGLISH','English (Ireland)');
   i('LANGUAGES','en','en-jm','UNITED KINGDOM','ENGLISH','English (Jamaica)');
   i('LANGUAGES','en','en-nz','NEW ZEALAND','ENGLISH','English (New Zealand)');
   i('LANGUAGES','en','en-ph','PHILIPPINES','ENGLISH','English (Philippines)');
   i('LANGUAGES','en','en-za','SOUTH AFRICA','ENGLISH','English (South Africa)');
   i('LANGUAGES','en','en-tt','UNITED KINGDOM','ENGLISH','English (Trinidad)');
   i('LANGUAGES','en','en-gb','UNITED KINGDOM','ENGLISH','English (United Kingdom)');
   i('LANGUAGES','en','en-us','AMERICA','AMERICAN','English (United States)');
   i('LANGUAGES','en','en-zw','UNITED KINGDOM','ENGLISH','English (Zimbabwe)');
   i('LANGUAGES','en','et','ESTONIA','ESTONIAN','Estonian');
   i('LANGUAGES','en','fo','UNITED KINGDOM','ENGLISH','Faeroese');
   i('LANGUAGES','en','fa','UNITED KINGDOM','ENGLISH','Farsi');
   i('LANGUAGES','en','fi','FINLAND','FINNISH','Finnish');
   i('LANGUAGES','en','fr-be','BELGIUM','FRENCH','French (Belgium)');
   i('LANGUAGES','en','fr-ca','CANADA','CANADIAN FRENCH','French (Canada)');
   i('LANGUAGES','en','fr','FRANCE','FRENCH','French (France)');
   i('LANGUAGES','en','fr-lu','LUXEMBOURG','FRENCH','French (Luxembourg)');
   i('LANGUAGES','en','fr-mc','FRANCE','FRENCH','French (Monaco)');
   i('LANGUAGES','en','fr-ch','SWITZERLAND','FRENCH','French (Switzerland)');
   i('LANGUAGES','en','mk','FYR MACEDONIA','MACEDONIAN','FYRO Macedonian');
   i('LANGUAGES','en','gd','UNITED KINGDOM','ENGLISH','Gaelic');
   i('LANGUAGES','en','gl','SPAIN','SPANISH','Galician');
   i('LANGUAGES','en','de-at','AUSTRIA','GERMAN','German (Austria)');
   i('LANGUAGES','en','de','GERMANY','GERMAN','German (Germany)');
   i('LANGUAGES','en','de-li','GERMANY','GERMAN','German (Liechtenstein)');
   i('LANGUAGES','en','de-lu','LUXEMBOURG','GERMAN','German (Luxemgourg)');
   i('LANGUAGES','en','de-ch','SWITZERLAND','GERMAN','German (Switzerland)');
   i('LANGUAGES','en','el','GREECE','GREEK','Greek');
   i('LANGUAGES','en','gu','INDIA','GUJARATI','Gujarati');
   i('LANGUAGES','en','he','ISRAEL','HEBREW','Hebrew');
   i('LANGUAGES','en','hi','INDIA','HINDI','Hindi');
   i('LANGUAGES','en','hu','HUNGARY','HUNGARIAN','Hungarian');
   i('LANGUAGES','en','is','ICELAND','ICELANDIC','Icelandic');
   i('LANGUAGES','en','id','INDONESIA','INDONESIAN','Indonesian');
   i('LANGUAGES','en','ga','IRELAND','IRISH','Irish');
   i('LANGUAGES','en','it','ITALY','ITALIAN','Italian (Italy)');
   i('LANGUAGES','en','it-ch','SWITZERLAND','ITALIAN','Italian (Switzerland)');
   i('LANGUAGES','en','ja','JAPAN','JAPANESE','Japanese');
   i('LANGUAGES','en','kn','INDIA','KANNADA','Kannada');
   i('LANGUAGES','en','kk','KAZAKHSTAN','CYRILLIC KAZAKH','Kazakh');
   i('LANGUAGES','en','kok','KOREA','KOREAN','Konkani');
   i('LANGUAGES','en','ko','KOREA','KOREAN','Korean');
   i('LANGUAGES','en','kz','RUSSIA','RUSSIAN','Kyrgyz');
   i('LANGUAGES','en','lv','LATVIA','LATVIAN','Latvian');
   i('LANGUAGES','en','lt','LITHUANIA','LITHUANIAN','Lithuanian');
   i('LANGUAGES','en','ms','MALAYSIA','MALAY','Malay (Malaysia)');
   i('LANGUAGES','en','ml','INDIA','MALAYALAM','Malayalam');
   i('LANGUAGES','en','mt','UNITED KINGDOM','ENGLISH','Maltese');
   i('LANGUAGES','en','mr','INDIA','MARATHI','Marathi');
   i('LANGUAGES','en','ne','UNITED KINGDOM','ENGLISH','Nepali (India)');
   i('LANGUAGES','en','no','NORWAY','NORWEGIAN','Norwegian (Bokmal)');
   i('LANGUAGES','en','nb-no','NORWAY','NORWEGIAN','Norwegian (Bokmal)');
   i('LANGUAGES','en','nn-no','NORWAY','NORWEGIAN','Norwegian (Nynorsk)');
   i('LANGUAGES','en','or','INDIA','ORIYA','Oriya');
   i('LANGUAGES','en','pl','POLAND','POLISH','Polish');
   i('LANGUAGES','en','pt-br','BRAZIL','BRAZILIAN PORTUGUESE','Portuguese (Brazil)');
   i('LANGUAGES','en','pt','PORTUGAL','PORTUGUESE','Portuguese (Portugal)');
   i('LANGUAGES','en','pa','INDIA','PUNJABI','Punjabi');
   i('LANGUAGES','en','ro','ROMANIA','ROMANIAN','Romanian');
   i('LANGUAGES','en','ru','RUSSIA','RUSSIAN','Russian');
   i('LANGUAGES','en','ru-md','RUSSIA','RUSSIAN','Russian (Moldova)');
   i('LANGUAGES','en','sr','SERBIA AND MONTENEGRO','CYRILLIC SERBIAN','Serbian');
   i('LANGUAGES','en','sk','SLOVAKIA','SLOVAK','Slovak');
   i('LANGUAGES','en','sl','SLOVENIA','SLOVENIAN','Slovenian');
   i('LANGUAGES','en','es-ar','ARGENTINA','LATIN AMERICAN SPANISH','Spanish (Argentina)');
   i('LANGUAGES','en','es-bo','ARGENTINA','LATIN AMERICAN SPANISH','Spanish (Bolivia)');
   i('LANGUAGES','en','es-cl','CHILE','LATIN AMERICAN SPANISH','Spanish (Chile)');
   i('LANGUAGES','en','es-co','COLOMBIA','LATIN AMERICAN SPANISH','Spanish (Columbia)');
   i('LANGUAGES','en','es-cr','COSTA RICA','LATIN AMERICAN SPANISH','Spanish (Costa Rica)');
   i('LANGUAGES','en','es-do','PUERTO RICO','LATIN AMERICAN SPANISH','Spanish (Dominican Republic)');
   i('LANGUAGES','en','es-ec','ECUADOR','LATIN AMERICAN SPANISH','Spanish (Ecudor)');
   i('LANGUAGES','en','es-sv','EL SALVADOR','LATIN AMERICAN SPANISH','Spanish (El Salvador)');
   i('LANGUAGES','en','es-gt','GUATEMALA','LATIN AMERICAN SPANISH','Spanish (Guatemala)');
   i('LANGUAGES','en','es-hn','GUATEMALA','LATIN AMERICAN SPANISH','Spanish (Honduras)');
   i('LANGUAGES','en','es-mx','MEXICO','MEXICAN SPANISH','Spanish (Mexico)');
   i('LANGUAGES','en','es-ni','NICARAGUA','LATIN AMERICAN SPANISH','Spanish (Nicaragua)');
   i('LANGUAGES','en','es-pa','PANAMA','LATIN AMERICAN SPANISH','Spanish (Panama)');
   i('LANGUAGES','en','es-py','ARGENTINA','LATIN AMERICAN SPANISH','Spanish (Paraguay)');
   i('LANGUAGES','en','es-pe','PERU','LATIN AMERICAN SPANISH','Spanish (Peru)');
   i('LANGUAGES','en','es-pr','PUERTO RICO','LATIN AMERICAN SPANISH','Spanish (Peurto Rico)');
   i('LANGUAGES','en','es','SPAIN','SPANISH','Spanish (Traditional Sort)');
   i('LANGUAGES','en','es-us','AMERICA','LATIN AMERICAN SPANISH','Spanish (United States)');
   i('LANGUAGES','en','es-uy','ARGENTINA','LATIN AMERICAN SPANISH','Spanish (Uruguay)');
   i('LANGUAGES','en','es-ve','VENEZUELA','LATIN AMERICAN SPANISH','Spanish (Venezuela)');
   i('LANGUAGES','en','sw','KENYA','SWAHILI','Swahili');
   i('LANGUAGES','en','sv','SWEDEN','SWEDISH','Swedish');
   i('LANGUAGES','en','sv-fi','FINLAND','SWEDISH','Swedish (Finland)');
   i('LANGUAGES','en','ta','INDIA','TAMIL','Tamil');
   i('LANGUAGES','en','te','INDIA','TELUGU','Telugu');
   i('LANGUAGES','en','th','THAILAND','THAI','Thai');
   i('LANGUAGES','en','tr','TURKEY','TURKISH','Turkish');
   i('LANGUAGES','en','uk','UKRAINE','UKRAINIAN','Ukrainian');
   i('LANGUAGES','en','ur','UNITED KINGDOM','ENGLISH','Urdu');
   i('LANGUAGES','en','uz','UZBEKISTAN','LATIN UZBEK','Uzbek');
   i('LANGUAGES','en','vi','VIETNAM','VIETNAMESE','Vietnamese');
   i('LANGUAGES','en','cy','UNITED KINGDOM','ENGLISH','Welsh');

   i('OCCUPATIONS','en','Law Clerk',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,120000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Judge',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,201020,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Chemistry Teacher',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,141421,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Math Teacher',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,131416,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Library Science Teacher',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,92345,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Communications Specialist',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,96000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Kindergarten Teacher',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,80000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Elementary School Teacher',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Middle School Teacher',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,88920,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','High School Teacher',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,89110,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Auto Shop Teacher',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85690,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Substitute Teacher',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,42140,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','A/V Technician',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,59570,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Broadcast Technician',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,59060,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Animation Creator',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,78640,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','English Teacher',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,98980,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Cardiovascular Technician',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,65560,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Diagnostic Medical Sonographer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,77770,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Optician',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,65800,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Orthopedist',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,172650,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Massage Therapist',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,55000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Clock Repair Technician',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,31110,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Security Guard',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,40440,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Waiter/Waitress',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,39390,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Landscaper',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,35000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Lawn Care Technician',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,55500,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Elevator Technician',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,32120,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Concierge',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,84440,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Sales Representative',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,116780,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Telemarketer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,19190,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Receptionish',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,41410,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Court, Municipal, or License Clerk',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,60000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Water Utility Inspector',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,62620,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Office Machine Operator',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,38000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Mathematician',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,314159,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Agricultural Inspector',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,65550,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Horse Trainer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,46460,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Carpenter',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,76840,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Carpet Installer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,52000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Convenience Store Cashier',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,60000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Floor Sander/Finisher',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,35000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Tile and Marble Setter',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,63636,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Optical Equipment Operator',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,43100,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Astronaut',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,183700,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Farmworker',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,39880,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Park Ranger',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,37000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Logging Equipment Operator',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,42000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Boilermaker',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,88880,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Brickmason/Blockmason',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,80010,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Stonemason',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,55550,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Construction Laborer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,56400,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Paving Equipment Operator',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,59580,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Crane Operator',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,110000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Drywall Installer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,55500,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Long Haul Truck Driver',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,74850,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Electrician',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,82340,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Door Framer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,71320,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Journalist',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,52100,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Movie Reveiwer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,83120,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Painter',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,55000,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Pipelayer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,58800,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Plumber',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,72430,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Roofer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,69120,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Welder',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,85020,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Steel Worker',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,93350,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Solar Panel Installer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,53450,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Building Inspector',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,72170,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Translator',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,86540,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Bridge Builder',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,47920,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Program Manager',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,65280,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Baker',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,47900,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Quantum Computer Programmer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,173250,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Tunnel Boring Machine Operator',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,47820,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Software Developer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,98100,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Cellular Tower Equipment Installer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,63210,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Bicycle Mechanic',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,49260,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Candlestick Maker',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,53100,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Automotive Technician',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,32260,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Door Framer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,49220,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','HVAC Mechanic and Installer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,60990,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Home Appliance Repair Technician',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,46550,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Industrial Machinery Mechanic',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,61990,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','CAD Machine Operator',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,73230,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Electrical Power-Line Worker',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,84990,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Telecommunications Line Installer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,74520,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Camera and Photographic Equipment Technician',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,49760,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Smart Phone Repair Technician',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,66240,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Railroad Conductor',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,71990,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Architectural Engineering',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,176220,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Food Service Manager',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,79910,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Hotel Manager',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,86380,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Sulfur Mine Manager',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,47290,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Medical and Health Services Manager',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,152610,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Chemical Engineer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,109250,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Civil Engineer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,109910,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Computer Hardware Engineer',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,123450,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Surveyor',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,59240,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Taxonomy Specialist',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,66180,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Forest and Conservation Specialist',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,54200,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Forensic Science Lab Tech',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,71430,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('OCCUPATIONS','en','Occupational Health and Safety Specialist',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,80190,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Dog','Shiba Inu','Taro',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Cat','Persian','Princess',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Cat','Abyssinian','Bobo',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Cat','Russian Blue','Giselle',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Dog','Beagle','Atlas',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Dog','Bulldog','Duke',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Dog','German Shepherd','Mindy',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Cat','Scottish Fold','Maru',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Dog','Golden Retriever','Goldie',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Dog','Poodle','Spot',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Dog','Mutt','Fido',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Dog','Labrador','Ranger',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Dog','Portuguese Water Dog','Snoopy',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Cat','Tabby','Fluffy',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Cat','Siamese','Mittens',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Cat','Maine Coon','Kitty',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Cat','Calico','Garfield',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Cat','Sphynx','Tom',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Fish','Guppy','Nemo',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Fish','Goldfish','Dory',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Fish','Angelfish','Bubbles',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Fish','Beta','Captain',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Fish','Platy','Moby',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Fish','Eel','Poseidon',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Cat','Chartreux','Star',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Cat','Burmese','Giselle',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Dog','Great Dane','Goliath',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Dog','Chihuahua','Lucky',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Cat','Munchkin','Dopey',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PETS','en','Dog','Basset Hound','Clifford',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Waste of money',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Best in its class!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Fine as a cheap option, but if you''re willing to spend more there are better out there',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Very good!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','experienced buyer. was not satisfied with the build quality.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','TOTAL LETDOWN!!!!!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Stick to what you''ve got',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Had a good experience',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Not as good as advertised',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','PERFECT!!!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Pass on this one',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Absolutely do not buy!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','wouldn''t recommend...',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Exceedingly average',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Everything I wanted and more',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Love this brand. Another great product.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Had a positive experience',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Blew away my expectations',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Yawn..  Fine, but not exciting',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','reader beware...   spend your money elsewhere...',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','No major issues',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','I was pleasantly surprised',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','NOT GOOD, look elsewhere!!!!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Got the job done well',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Has some issues',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','I hate this stupid thing',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','not bad...',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Works Great...',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','I cannot use this',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','I have tried several kinds and this is just the best',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','CHEAP GARBAGE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','my old one was better',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Really Really Good!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Thank you so much, it''s perfect',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','holds a special place in my heart',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Dysfunctional, unusable',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','lovely product',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Not satisfied',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','okay',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Good',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Arrived broken',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','SPECTACULAR!!!!!!!!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Good enough',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','works but feels cheap',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','thumbs up...',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Amazing, thank you',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Disappointing',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','broke after 5 days',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','good',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','love it',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Not quite what I expected',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','BAD!!!!! DO NOT BUY!!!!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','pretty good',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Not worth it',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','A bit underwhelming',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','overrated',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Great value!!!!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Great so far',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','gets the job done',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','trash',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','I like it!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Could be better',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','already needs replaced!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','TERRIBLE',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','This brand has fallen from grace. Not what they used to be.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','It worked for what I needed, but feels cheap.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Absolutely wonderful',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','good!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','bad',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','It''s fine',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','bought on a whim, pleasantly surprised',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Far too expensive',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Insane deal! Can''t beat it!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Can''t recommend this',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Just average.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Do not buy.',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','It Is Very Good',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','perfect',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Superb!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','okay for the price',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Not worth the price',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','not what I thought it was',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Lackluster',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','great',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','LOVE IT XOXOXO',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','EXCELLENT PRODUCT',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Just what we needed!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','adequate',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','no problems',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','It worked',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Do yourself a favor and buy this',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','I''m satisfied',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','FAIR',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','eh',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','I am insulted by the low quality of this product',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','GREAT',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,4,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Tried a few of these, this one was not the best',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,3,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','Life changing',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,5,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','not very good',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,2,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('PROD_REVIEWS','en','ARGH! BLAST THIS STUPID THING!!!!!!!',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Roger Williams University','Bristol','RI','New England Commission on Higher Education','https://www.rwu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Salve Regina University','Newport','RI','New England Commission on Higher Education','www.salve.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','St Joseph School of Nursing','North Providence','RI','NULL','www.nursingri.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-Warwick','Providence','RI','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Northpoint Bible College','Haverhill','MA','Association for Bibical Higher Educaiton','www.northpoint.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Aiken Technical College','Graniteville','SC','Southern Association of Colleges and Schools Commission on Colleges','https://www.atc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Allen University','Columbia','SC','Southern Association of Colleges and Schools Commission on Colleges','www.allenuniversity.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Anderson University','Anderson','SC','Southern Association of Colleges and Schools Commission on Colleges','www.andersonuniversity.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Charleston Southern University','Charleston','SC','Southern Association of Colleges and Schools Commission on Colleges','https://www.charlestonsouthern.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Technical College of the Lowcountry','Beaufort','SC','Southern Association of Colleges and Schools Commission on Colleges','www.tcl.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Benedict College','Columbia','SC','Southern Association of Colleges and Schools Commission on Colleges','www.benedict.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Bob Jones University','Greenville','SC','Transnational Association of Christian Colleges and Schools','www.bju.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Southern Wesleyan University','Central','SC','Southern Association of Colleges and Schools Commission on Colleges','www.swu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Charleston Cosmetology Institute','Charleston','SC','Council on Occupational Education','www.charlestoncosmetology.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','College of Charleston','Charleston','SC','Southern Association of Colleges and Schools Commission on Colleges','www.cofc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Charzanne Beauty College','Greenwood','SC','Council on Occupational Education','charzannebeautycollege.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Northeastern Technical College','Cheraw','SC','Southern Association of Colleges and Schools Commission on Colleges','www.netc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Citadel Military College of South Carolina','Charleston','SC','Southern Association of Colleges and Schools Commission on Colleges','www.citadel.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Claflin University','Orangeburg','SC','Southern Association of Colleges and Schools Commission on Colleges','www.claflin.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Clemson University','Clemson','SC','Southern Association of Colleges and Schools Commission on Colleges','www.clemson.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Clinton College','Rock Hill','SC','Transnational Association of Christian Colleges and Schools','www.clintoncollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Coker University','Hartsville','SC','Southern Association of Colleges and Schools Commission on Colleges','https://coker.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Columbia International University','Columbia','SC','Southern Association of Colleges and Schools Commission on Colleges','www.ciu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Columbia College','Columbia','SC','Southern Association of Colleges and Schools Commission on Colleges','www.columbiasc.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Converse College','Spartanburg','SC','Southern Association of Colleges and Schools Commission on Colleges','www.converse.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Northwest Technology Center-Alva','Alva','OK','Oklahoma State Board of Career and Technology Education','https://nwtech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Mercer County Career Center','Mercer','PA','Middle States Commission on Secondary Education','www.mercerccc.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University-San Marcos','San Marcos','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.csusm.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Baptist Theological Seminary at Richmond','Henrico','VA','NULL','www.btsr.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Purdue University Global-Des Moines','Urbandale','IA','Higher Learning Commission','https://www.purdueglobal.edu/campus-locations/des-moines-iowa/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Hairmasters Institute of Cosmetology','Bloomington','IL','National Accrediting Commission of Career Arts and Sciences','www.hair-masters.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Tricoci University of Beauty Cuture LLC-Bloomington','Bloomington','IN','National Accrediting Commission of Career Arts and Sciences','www.tricociuniversity.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Interactive College of Technology-Newport','Newport','KY','Council on Occupational Education','www.ict.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Platt College-McCann-Monroe','Monroe','LA','Accrediting Commission of Career Schools and Colleges','https://www.mccann.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Ross Medical Education Center-Taylor','Taylor','MI','Accrediting Bureau of Health Education Schools','www.rosseducation.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','National Tractor Trailer School Inc-Liverpool','Liverpool','NY','Accrediting Commission of Career Schools and Colleges','www.ntts.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Interactive College of Technology','Houston','TX','Council on Occupational Education','www.ict.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Butler Beauty Academy-New Castle Beauty Academy','New Castle','PA','National Accrediting Commission of Career Arts and Sciences','beautyacademies.net',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','NorthWest Arkansas Community College','Bentonville','AR','Higher Learning Commission','www.nwacc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Brewster Technical College','Tampa','FL','Council on Occupational Education','www.brewster.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Hodges University','Naples','FL','Southern Association of Colleges and Schools Commission on Colleges','https://www.hodges.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of St. Augustine for Health Sciences','San Marcos','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.usa.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Capital Area School of Practical Nursing','Springfield','IL','Accreditation Commission for Education in Nursing','www.caspn.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Hair Professionals Career College','Palos Hills','IL','National Accrediting Commission of Career Arts and Sciences','hairpros.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Alexandria School of Scientific Therapeutics','Alexandria','IN','Commission on Massage Therapy Accreditation','www.assti.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-Bloomfield','Bloomfield','NJ','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Southwest Technology Center','Altus','OK','Oklahoma State Board of Career and Technology Education','www.swtech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Western Area Career & Technology Center','Canonsburg','PA','Middle States Commission on Secondary Education','www.wactc.net',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Hussian College-Daymar College Clarksville','Clarksville','TN','Accrediting Commission of Career Schools and Colleges','www.daymarcollege.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Nossi College of Art','Nashville','TN','Accrediting Commission of Career Schools and Colleges','https://www.nossi.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Seguin Beauty School-New Braunfels','New Braunfels','TX','Council on Occupational Education','www.seguinbeautyschool.net',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Pima Medical Institute-Seattle','Seattle','WA','Accrediting Bureau of Health Education Schools','pmi.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Ferrum College','Ferrum','VA','Southern Association of Colleges and Schools Commission on Colleges','www.ferrum.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','George Mason University','Fairfax','VA','Southern Association of Colleges and Schools Commission on Colleges','https://www2.gmu.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','InterCoast Colleges-Santa Ana','Santa Ana','CA','Accrediting Council for Continuing Education & Training','https://www.intercoast.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Stone Child College','Box Elder','MT','Northwest Commission on Colleges and Universities','www.stonechild.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','New York Academy of Art','New York','NY','National Association of Schools of Arts and Design','nyaa.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Suffolk County Community College','Selden','NY','Middle States Commission on Higher Education','https://www.sunysuffolk.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Las Positas College','Livermore','CA','Western Association of Schools and Colleges Accrediting Commission for Community and Junior Colleges','www.laspositascollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Blades School of Hair Design','California','MD','National Accrediting Commission of Career Arts and Sciences','BladesSchoolofHairDesign.net',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Ogeechee Technical College','Statesboro','GA','Southern Association of Colleges and Schools Commission on Colleges','www.ogeecheetech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Remington College-Mobile Campus','Mobile','AL','Accrediting Commission of Career Schools and Colleges','www.remingtoncollege.edu/mobile-alabama-colleges-campus',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Southern Technical College','Fort Myers','FL','Accrediting Council for Independent Colleges and Schools','www.southerntech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Mercy-St Luke''s School of Radiologic Technology','Cedar Rapids','IA','Joint Review Committee on Education in Radiologic Technology','https://www.unitypoint.org/cedarrapids/school-of-radiologic-technology.aspx',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Southwest Acupuncture College-Santa Fe','Santa Fe','NM','Accrediting Commission for Acupuncture and Oriental Medicine','www.acupuncturecollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Western Technology Center','Burns Flat','OK','Oklahoma State Board of Career and Technology Education','https://www.westtech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Mid-America Technology Center','Wayne','OK','Oklahoma State Board of Career and Technology Education','www.matech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-Lancaster','Lancaster','PA','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-Shamokin Dam','Shamokin Dam','PA','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-Pottsville','Pottsville','PA','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty  School-Lehigh Valley','Whitehall','PA','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-Gwinnett','Lawrenceville','GA','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-Wyoming Valley','Moosic','PA','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-Warminster','Warminster','PA','NULL','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-Harrisburg','Harrisburg','PA','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-Reading','Reading','PA','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Erie Institute of Technology Inc','Erie','PA','Accrediting Commission of Career Schools and Colleges','www.erieit.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Evangelical Theological Seminary','Myerstown','PA','Middle States Commission on Higher Education','www.evangelical.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Faith Theological Seminary','Baltimore','MD','Transnational Association of Christian Colleges and Schools','fts.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Aria Health School of Nursing','Trevose','PA','NULL','www.ariahealth.org/default.aspx?pageid=3330',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Franklin and Marshall College','Lancaster','PA','Middle States Commission on Higher Education','WWW.FANDM.EDU',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Gannon University','Erie','PA','Middle States Commission on Higher Education','www.gannon.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Geneva College','Beaver Falls','PA','Middle States Commission on Higher Education','www.geneva.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Gettysburg College','Gettysburg','PA','Middle States Commission on Higher Education','https://www.gettysburg.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-NE Philadelphia','Philadelphia','PA','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Gratz College','Melrose Park','PA','Middle States Commission on Higher Education','https://www.gratz.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Grove City College','Grove City','PA','Middle States Commission on Higher Education','www.gcc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Gwynedd Mercy University','Gwynedd Valley','PA','Middle States Commission on Higher Education','https://www.gmercyu.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Harcum College','Bryn Mawr','PA','Middle States Commission on Higher Education','www.harcum.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Harrisburg Area Community College','Harrisburg','PA','Middle States Commission on Higher Education','www.hacc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Haverford College','Haverford','PA','Middle States Commission on Higher Education','https://www.haverford.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Commonwealth Technical Institute','Johnstown','PA','Accrediting Commission of Career Schools and Colleges','www.dli.pa.gov',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Holy Family University','Philadelphia','PA','Middle States Commission on Higher Education','https://www.holyfamily.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Hussian College School of Art','Philadelphia','PA','Accrediting Commission of Career Schools and Colleges','www.hussiancollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Immaculata University','Immaculata','PA','Middle States Commission on Higher Education','www.immaculata.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Indiana University of Pennsylvania-Main Campus','Indiana','PA','Middle States Commission on Higher Education','www.iup.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','UPMC Jameson School of Nursing','New Castle','PA','Accreditation Commission for Education in Nursing','www.upmc.com/healthcare-professionals/education/schools-of-nursing/campuses/jameson',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Great Lakes Institute of Technology','Erie','PA','Accrediting Commission of Career Schools and Colleges','www.glit.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Jolie Hair and Beauty Academy-Wilkes-Barre','Wilkes Barre','PA','National Accrediting Commission of Career Arts and Sciences','www.jolieacademy.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Johnson College','Scranton','PA','Accrediting Commission of Career Schools and Colleges','www.johnson.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Juniata College','Huntingdon','PA','Middle States Commission on Higher Education','www.juniata.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Keystone College','La Plume','PA','Middle States Commission on Higher Education','www.keystone.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','King''s College','Wilkes-Barre','PA','Middle States Commission on Higher Education','www.kings.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Butler Beauty Academy-Kittanning Beauty Academy','Kittanning','PA','National Accrediting Commission of Career Arts and Sciences','beautyacademies.net',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','York College of Pennsylvania','York','PA','Middle States Commission on Higher Education','www.ycp.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','YTI Career Institute-York','York','PA','Accrediting Commission of Career Schools and Colleges','www.yti.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Brown University','Providence','RI','New England Commission on Higher Education','www.brown.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Bryant University','Smithfield','RI','New England Commission on Higher Education','https://www.bryant.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Johnson & Wales University-Providence','Providence','RI','New England Commission on Higher Education','www.jwu.edu/campuses/providence/index.html',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','New England Institute of Technology','East Greenwich','RI','New England Commission on Higher Education','www.neit.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','New England Tractor Trailer Training School of Rhode Island','Pawtucket','RI','Accrediting Commission of Career Schools and Colleges','www.nettts.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Providence College','Providence','RI','New England Commission on Higher Education','www.providence.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Rhode Island College','Providence','RI','New England Commission on Higher Education','www.ric.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Community College of Rhode Island','Warwick','RI','New England Commission on Higher Education','www.ccri.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Rhode Island','Kingston','RI','New England Commission on Higher Education','web.uri.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Rhode Island School of Design','Providence','RI','New England Commission on Higher Education','www.risd.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Warner Pacific University','Portland','OR','Northwest Commission on Colleges and Universities','www.warnerpacific.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Corban University','Salem','OR','Northwest Commission on Colleges and Universities','www.corban.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','College of Cosmetology','Klamath Falls','OR','National Accrediting Commission of Career Arts and Sciences','COLLEGEOFCOS.COM',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Western Seminary','Portland','OR','Northwest Commission on Colleges and Universities','www.westernseminary.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Willamette University','Salem','OR','Northwest Commission on Colleges and Universities','www.willamette.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-York','York','PA','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','South Hills School of Business & Technology','State College','PA','Accrediting Commission of Career Schools and Colleges','www.southhills.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','St Lukes Hospital School of Nursing','Bethlehem','PA','Accreditation Commission for Education in Nursing','https://www.slhn.org/bethlehem',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','The Beauty Institute','Stroudsburg','PA','National Accrediting Commission of Career Arts and Sciences','www.thebeautyinstituteskp.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Susquehanna University','Selinsgrove','PA','Middle States Commission on Higher Education','www.susqu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Swarthmore College','Swarthmore','PA','Middle States Commission on Higher Education','www.swarthmore.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Thaddeus Stevens College of Technology','Lancaster','PA','Middle States Commission on Higher Education','www.stevenscollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Talmudical Yeshiva of Philadelphia','Philadelphia','PA','Association of Advanced Rabbinical and Talmudic Schools','www.meterware.com/typ/Talmudical_Yeshiva_of_Philadelphia/NetPriceCalculator/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Temple University','Philadelphia','PA','Middle States Commission on Higher Education','www.temple.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Theological Seminary of the Reformed Episcopal Church','Blue Bell','PA','Commission on Accrediting of the Association of Theological Schools','www.reseminary.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Thiel College','Greenville','PA','Middle States Commission on Higher Education','www.thiel.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Thomas Jefferson University','Philadelphia','PA','Middle States Commission on Higher Education','www.jefferson.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Fortis Institute-Erie','Erie','PA','Accrediting Council for Independent Colleges and Schools','https://www.fortis.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Triangle Tech Inc-Erie','Erie','PA','NULL','www.triangle-tech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Triangle Tech Inc-Pittsburgh','Pittsburgh','PA','Accrediting Commission of Career Schools and Colleges','www.triangle-tech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Triangle Tech Inc-Greensburg','Greensburg','PA','Accrediting Commission of Career Schools and Colleges','www.triangle-tech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Triangle Tech Inc-Dubois','Falls Creek','PA','Accrediting Commission of Career Schools and Colleges','www.triangle-tech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Trinity Episcopal School for Ministry','Ambridge','PA','Commission on Accrediting of the Association of Theological Schools','www.tsm.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Ursinus College','Collegeville','PA','Middle States Commission on Higher Education','www.ursinus.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Valley Forge','Phoenixville','PA','Middle States Commission on Higher Education','https://www.valleyforge.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Valley Forge Military College','Wayne','PA','Middle States Commission on Higher Education','www.vfmac.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Venus Beauty Academy','Sharon Hill','PA','National Accrediting Commission of Career Arts and Sciences','www.venusbeautyacademy.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Villanova University','Villanova','PA','Middle States Commission on Higher Education','www.villanova.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Washington Hospital School of Nursing','Washington','PA','Accreditation Commission for Education in Nursing','www.whs.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Washington & Jefferson College','Washington','PA','Middle States Commission on Higher Education','www.washjeff.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Waynesburg University','Waynesburg','PA','Middle States Commission on Higher Education','www.waynesburg.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Welder Training and Testing Institute','Allentown','PA','Accrediting Commission of Career Schools and Colleges','www.wtti.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','West Chester University of Pennsylvania','West Chester','PA','Middle States Commission on Higher Education','https://www.wcupa.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Western Pennsylvania Hospital School of Nursing','Pittsburgh','PA','Accreditation Commission for Education in Nursing','www.ahn.org/education/west-penn-hospital-school-nursing',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Pittsburgh Career Institute','Pittsburgh','PA','Accrediting Council for Independent Colleges and Schools','https://www.pci.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Westminster College','New Wilmington','PA','Middle States Commission on Higher Education','www.westminster.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Westminster Theological Seminary','Glenside','PA','Middle States Commission on Higher Education','https://www.wts.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Westmoreland County Community College','Youngwood','PA','Middle States Commission on Higher Education','https://westmoreland.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Widener University','Chester','PA','Middle States Commission on Higher Education','www.widener.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Wilkes University','Wilkes-Barre','PA','Middle States Commission on Higher Education','www.wilkes.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Williamson College of the Trades','Media','PA','Accrediting Commission of Career Schools and Colleges','https://www.williamson.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Wilson College','Chambersburg','PA','Middle States Commission on Higher Education','www.wilson.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Yeshivath Beth Moshe','Scranton','PA','Association of Advanced Rabbinical and Talmudic Schools','https://yeshivabethmoshe.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Advanced Technology Institute','Virginia Beach','VA','Accrediting Commission of Career Schools and Colleges','www.auto.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Averett University','Danville','VA','Southern Association of Colleges and Schools Commission on Colleges','https://www.averett.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Blue Ridge Community College','Weyers Cave','VA','Southern Association of Colleges and Schools Commission on Colleges','https://www.brcc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Bluefield College','Bluefield','VA','Southern Association of Colleges and Schools Commission on Colleges','www.bluefield.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Bridgewater College','Bridgewater','VA','Southern Association of Colleges and Schools Commission on Colleges','https://www.bridgewater.edu/about-bc/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','William & Mary','Williamsburg','VA','Southern Association of Colleges and Schools Commission on Colleges','https://www.wm.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Regent University','Virginia Beach','VA','Southern Association of Colleges and Schools Commission on Colleges','https://www.regent.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Central School of Practical Nursing','Norfolk','VA','Accreditation Commission for Education in Nursing','https://www.npsk12.com/domain/980',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Central Virginia Community College','Lynchburg','VA','Southern Association of Colleges and Schools Commission on Colleges','www.centralvirginia.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Christopher Newport University','Newport News','VA','Southern Association of Colleges and Schools Commission on Colleges','cnu.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Suffolk Beauty Academy','Suffolk','VA','National Accrediting Commission of Career Arts and Sciences','suffolkbeautyacademy.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Bryant & Stratton College-Virginia Beach','Virginia Beach','VA','Middle States Commission on Higher Education','https://www.bryantstratton.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Bryant & Stratton College-Richmond','North Chesterfield','VA','Middle States Commission on Higher Education','https://www.bryantstratton.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Radford University-Carilion','Roanoke','VA','Southern Association of Colleges and Schools Commission on Colleges','https://www.radford.edu/content/ruc/home.html',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Dabney S Lancaster Community College','Clifton Forge','VA','Southern Association of Colleges and Schools Commission on Colleges','www.dslcc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Danville Community College','Danville','VA','Southern Association of Colleges and Schools Commission on Colleges','https://www.danville.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Eastern Virginia Medical School','Norfolk','VA','Southern Association of Colleges and Schools Commission on Colleges','www.evms.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Centura College-Virginia Beach','Virginia Beach','VA','Accrediting Commission of Career Schools and Colleges','https://www.centuracollege.edu/your_rights',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Emory & Henry College','Emory','VA','Southern Association of Colleges and Schools Commission on Colleges','www.ehc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Eastern Mennonite University','Harrisonburg','VA','Southern Association of Colleges and Schools Commission on Colleges','https://emu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Eastern Shore Community College','Melfa','VA','Southern Association of Colleges and Schools Commission on Colleges','www.es.vccs.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Garnet Career Center','Charleston','WV','Council on Occupational Education','garnet.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Bristol Technical Education Center','Bristol','CT','Council on Occupational Education','www.cttech.org/bristol/index.htm',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Genesee Valley BOCES-Practical Nursing Program','Batavia','NY','New York State Board of Regents State Education Department Office of the Professions (Public Postsecondary Vocational Education Practical Nursing)','www.gvboces.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Henrico County-Saint Marys Hospital School of Practical Nursing','Henrico','VA','Accreditation Commission for Education in Nursing','blogs.henrico.k12.va.us/adulteducation/licensed-practical-nursing/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Herkimer County BOCES-Practical Nursing Program','Ilion','NY','New York State Board of Regents State Education Department Office of the Professions (Public Postsecondary Vocational Education Practical Nursing)','www.herkimer-boces.org/lpn',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','International Beauty College','Garland','TX','National Accrediting Commission of Career Arts and Sciences','www.ibc3.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Cape Coral Technical College','Cape Coral','FL','Council on Occupational Education','capecoraltech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','UPMC Mercy School of Nursing','Pittsburgh','PA','Accreditation Commission for Education in Nursing','https://www.upmc.com/mercyson',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Ocean County Vocational-Technical School','Toms River','NJ','Middle States Commission on Secondary Education','www.ocvts.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Trinity College of Puerto Rico','Ponce','PR','Council on Occupational Education','www.trinitypr.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Virginia Sewing Machines and School Center','Huntington Park','CA','NULL','www.atechcollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Vogue Beauty and Barber School','Hiram','GA','NULL','www.voguebeautyschool.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Yeshiva of the Telshe Alumni','Riverdale','NY','Association of Advanced Rabbinical and Talmudic Schools','https://yeshivatelshealumni.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Northeast Technology Center-Kansas','Kansas','OK','Oklahoma State Board of Career and Technology Education','www.netech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Kenneth Shuler School of Cosmetology-Rock Hill','Rock Hill','SC','National Accrediting Commission of Career Arts and Sciences','www.kennethshuler.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Phoenix-Washington','Tukwila','WA','Higher Learning Commission','https://www.phoenix.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','CET-El Paso','El Paso','TX','Council on Occupational Education','https://cetweb.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Appalachian School of Law','Grundy','VA','American Bar Association','www.asl.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Platt College-Ontario','Ontario','CA','Accrediting Commission of Career Schools and Colleges','www.plattcollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Delaware College of Art and Design','Wilmington','DE','Middle States Commission on Higher Education','www.dcad.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','American University of Health Sciences','Signal Hill','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.auhs.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Career Networks Institute','Santa Ana','CA','Accrediting Bureau of Health Education Schools','www.cnicollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Monty Tech','Fitchburg','MA','Council on Occupational Education','www.montytech.net',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Okaloosa Technical College','Fort Walton Beach','FL','Council on Occupational Education','www.OTCollege.net',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Lincoln Technical Institute-Lincoln','Lincoln','RI','Accrediting Commission of Career Schools and Colleges','www.lincolntech.edu/campus/lincoln-ri',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Wayne County Schools Career Center','Smithville','OH','Council on Occupational Education','www.wayne-jvs.k12.oh.us',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Blessing Hospital School of Medical Laboratory Technology','Quincy','IL','Higher Learning Commission','www.blessinghealthsystem.org/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Carolinas College of Health Sciences','Charlotte','NC','Southern Association of Colleges and Schools Commission on Colleges','www.carolinascollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','South Central Career Center','West Plains','MO','Council on Occupational Education','https://www.zizzers.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Saline County Career Center','Marshall','MO','Council on Occupational Education','https://www.marshallschools.com/o/career-center',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Warrensburg Area Career Center','Warrensburg','MO','Council on Occupational Education','wacc.warrensburgr6.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Nevada Regional Technical Center','Nevada','MO','NULL','nrtc.nevadar5.org/practical-nursing',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Cass Career Center','Harrisonville','MO','Council on Occupational Education','casscareercenter.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Linn-Benton Community College','Albany','OR','Northwest Commission on Colleges and Universities','https://www.linnbenton.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Northwest College-Beaverton','Beaverton','OR','National Accrediting Commission of Career Arts and Sciences','www.nwcollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Phagans Medford Beauty School','Medford','OR','National Accrediting Commission of Career Arts and Sciences','www.phagans-schools.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Northwest College-Clackamas','Happy Valley','OR','National Accrediting Commission of Career Arts and Sciences','www.nwcollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Mount Angel Seminary','Saint Benedict','OR','Northwest Commission on Colleges and Universities','https://www.mountangelabbey.org/seminary',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Mt Hood Community College','Gresham','OR','Northwest Commission on Colleges and Universities','www.mhcc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Multnomah University','Portland','OR','Northwest Commission on Colleges and Universities','https://www.multnomah.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','National University of Natural Medicine','Portland','OR','Northwest Commission on Colleges and Universities','www.nunm.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Northwest Christian University','Eugene','OR','Northwest Commission on Colleges and Universities','www.nwcu.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Oregon Health & Science University','Portland','OR','Northwest Commission on Colleges and Universities','www.ohsu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Oregon Institute of Technology','Klamath Falls','OR','Northwest Commission on Colleges and Universities','https://www.oit.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Oregon College of Art and Craft','Portland','OR','NULL','www.ocac.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Oregon State University','Corvallis','OR','Northwest Commission on Colleges and Universities','https://oregonstate.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Oregon','Eugene','OR','Northwest Commission on Colleges and Universities','https://www.uoregon.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Pacific Northwest College of Art','Portland','OR','Northwest Commission on Colleges and Universities','pnca.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Pacific University','Forest Grove','OR','Northwest Commission on Colleges and Universities','https://www.pacificu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Phagans Beauty College','Corvallis','OR','National Accrediting Commission of Career Arts and Sciences','www.phagans-schools.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Phagans Central Oregon Beauty College','Bend','OR','National Accrediting Commission of Career Arts and Sciences','www.phagans-schools.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Phagans School of Beauty','Salem','OR','National Accrediting Commission of Career Arts and Sciences','www.phagans-schools.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Phagans School of Hair Design','Happy Valley','OR','National Accrediting Commission of Career Arts and Sciences','www.phagans.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Summit Salon Academy-Portland','Tigard','OR','National Accrediting Commission of Career Arts and Sciences','www.summitsalonacademyportland.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Portland Community College','Portland','OR','Northwest Commission on Colleges and Universities','www.pcc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Portland State University','Portland','OR','Northwest Commission on Colleges and Universities','www.pdx.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Portland','Portland','OR','Northwest Commission on Colleges and Universities','https://www.up.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Reed College','Portland','OR','Northwest Commission on Colleges and Universities','https://www.reed.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Rogue Community College','Grants Pass','OR','Northwest Commission on Colleges and Universities','www.roguecc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Pioneer Pacific College','Beaverton','OR','Accrediting Council for Independent Colleges and Schools','www.pioneerpacific.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Southern Oregon University','Ashland','OR','Northwest Commission on Colleges and Universities','www.sou.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Southwestern Oregon Community College','Coos Bay','OR','Northwest Commission on Colleges and Universities','www.socc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Treasure Valley Community College','Ontario','OR','Northwest Commission on Colleges and Universities','www.tvcc.cc',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Umpqua Community College','Roseburg','OR','Northwest Commission on Colleges and Universities','https://www.umpqua.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Washington County Career Center-Adult Technical Training','Marietta','OH','Accrediting Commission of Career Schools and Colleges','www.mycareerschool.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Ohio Media School-Cincinnati','Norwood','OH','Accrediting Commission of Career Schools and Colleges','www.beonair.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Ohio Technical Center at Vantage Career Center','Van Wert','OH','Accrediting Commission of Career Schools and Colleges','www.vantagecareercenter.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Indian Capital Technology Center-Muskogee','Muskogee','OK','Oklahoma State Board of Career and Technology Education','www.ictctech.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Auburn University','Auburn','AL','Southern Association of Colleges and Schools Commission on Colleges','www.auburn.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Birmingham-Southern College','Birmingham','AL','Southern Association of Colleges and Schools Commission on Colleges','www.bsc.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Chattahoochee Valley Community College','Phenix City','AL','Southern Association of Colleges and Schools Commission on Colleges','www.cv.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','South University-Montgomery','Montgomery','AL','Southern Association of Colleges and Schools Commission on Colleges','www.southuniversity.edu/montgomery#location=Montgomery,%20AL',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Enterprise State Community College','Enterprise','AL','Southern Association of Colleges and Schools Commission on Colleges','www.escc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Coastal Alabama Community College','Bay Minette','AL','Southern Association of Colleges and Schools Commission on Colleges','www.coastalalabama.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Faulkner University','Montgomery','AL','Southern Association of Colleges and Schools Commission on Colleges','www.faulkner.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Gadsden State Community College','Gadsden','AL','Southern Association of Colleges and Schools Commission on Colleges','www.gadsdenstate.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','New Beginning College of Cosmetology','Albertville','AL','National Accrediting Commission of Career Arts and Sciences','www.nbccosmetology.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','George C Wallace Community College-Dothan','Dothan','AL','Southern Association of Colleges and Schools Commission on Colleges','www.wallace.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','George C Wallace State Community College-Hanceville','Hanceville','AL','Southern Association of Colleges and Schools Commission on Colleges','www.wallacestate.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','George C Wallace State Community College-Selma','Selma','AL','Southern Association of Colleges and Schools Commission on Colleges','www.wccs.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Herzing University-Birmingham','Birmingham','AL','Higher Learning Commission','https://www.herzing.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Huntingdon College','Montgomery','AL','Southern Association of Colleges and Schools Commission on Colleges','www.huntingdon.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Heritage Christian University','Florence','AL','Association for Bibical Higher Educaiton','www.hcu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','J. F. Drake State Community and Technical College','Huntsville','AL','Southern Association of Colleges and Schools Commission on Colleges','https://www.drakestate.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','J F Ingram State Technical College','Deatsville','AL','Council on Occupational Education','www.istc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Davis Technical College','Kaysville','UT','Council on Occupational Education','https://www.davistech.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Dixie State University','Saint George','UT','Northwest Commission on Colleges and Universities','dixie.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Evans Hairstyling College-Cedar City','Cedar City','UT','National Accrediting Commission of Career Arts and Sciences','evanscollege.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Evans Hairstyling College-St George','Saint George','UT','National Accrediting Commission of Career Arts and Sciences','evanscollege.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Paul Mitchell the School-Salt Lake City','Holladay','UT','National Accrediting Commission of Career Arts and Sciences','paulmitchell.edu/saltlakecity',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Eagle Gate College-Murray','Murray','UT','Accrediting Bureau of Health Education Schools','EAGLEGATECOLLEGE.EDU',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','LDS Business College','Salt Lake City','UT','Northwest Commission on Colleges and Universities','www.ldsbc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Ogden-Weber Technical College','Ogden','UT','Council on Occupational Education','www.otech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Snow College','Ephraim','UT','Northwest Commission on Colleges and Universities','https://www.snow.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Southern Utah University','Cedar City','UT','Northwest Commission on Colleges and Universities','https://www.suu.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Stevens-Henager College','West Haven','UT','Accrediting Commission of Career Schools and Colleges','www.stevenshenager.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Stevens-Henager College','Orem','UT','Accrediting Commission of Career Schools and Colleges','www.stevenshenager.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Uintah Basin Technical College','Roosevelt','UT','Council on Occupational Education','www.ubtech.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Utah State University','Logan','UT','Northwest Commission on Colleges and Universities','www.usu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Utah Valley University','Orem','UT','Northwest Commission on Colleges and Universities','www.uvu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Salt Lake Community College','Salt Lake City','UT','Northwest Commission on Colleges and Universities','www.slcc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Utah','Salt Lake City','UT','Northwest Commission on Colleges and Universities','www.utah.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Weber State University','Ogden','UT','Northwest Commission on Colleges and Universities','www.weber.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Westminster College','Salt Lake City','UT','Northwest Commission on Colleges and Universities','www.westminstercollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Bennington College','Bennington','VT','New England Commission on Higher Education','www.bennington.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Castleton University','Castleton','VT','New England Commission on Higher Education','www.castleton.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Champlain College','Burlington','VT','New England Commission on Higher Education','www.champlain.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Community College of Vermont','Montpelier','VT','New England Commission on Higher Education','www.ccv.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Goddard College','Plainfield','VT','New England Commission on Higher Education','www.goddard.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Green Mountain College','Poultney','VT','NULL','www.greenmtn.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Northern Vermont University','Johnson','VT','New England Commission on Higher Education','www.northernvermont.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Marlboro College','Marlboro','VT','New England Commission on Higher Education','www.marlboro.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Middlebury College','Middlebury','VT','New England Commission on Higher Education','www.middlebury.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','New England Culinary Institute','Montpelier','VT','Accrediting Commission of Career Schools and Colleges','www.neci.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Norwich University','Northfield','VT','New England Commission on Higher Education','www.norwich.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','O''Briens Aveda Institute','Williston','VT','National Accrediting Commission of Career Arts and Sciences','www.obriensavedainstitute.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Saint Michael''s College','Colchester','VT','New England Commission on Higher Education','www.smcvt.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','SIT Graduate Institute','Brattleboro','VT','New England Commission on Higher Education','https://www.sit.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','College of St Joseph','Rutland','VT','NULL','www.csj.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Southern Vermont College','Bennington','VT','NULL','https://svc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Sterling College','Craftsbury Common','VT','New England Commission on Higher Education','www.sterlingcollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Vermont Law School','South Royalton','VT','New England Commission on Higher Education','www.vermontlaw.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Vermont Technical College','Randolph','VT','New England Commission on Higher Education','www.vtc.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Vermont','Burlington','VT','New England Commission on Higher Education','www.uvm.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Paul Mitchell the School-Roanoke','Roanoke','VA','Council on Occupational Education','roanoke.paulmitchell.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Dutchess BOCES-Practical Nursing Program','Poughkeepsie','NY','New York State Board of Regents State Education Department Office of the Professions (Public Postsecondary Vocational Education Practical Nursing)','https://www.dcboces.org/cti/lpn',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Escuela Tecnica de Electricidad','Ponce','PR','Accrediting Council for Continuing Education & Training','www.etepr.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Institute of Technology','Clovis','CA','Accrediting Commission of Career Schools and Colleges','www.iot.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Southwest University of Visual Arts-Tucson','Tucson','AZ','Higher Learning Commission','www.suva.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Central Arizona College','Coolidge','AZ','Higher Learning Commission','www.centralaz.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Charles of Italy Beauty College','Lake Havasu City','AZ','National Accrediting Commission of Career Arts and Sciences','www.charlesofitaly.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Cochise County Community College District','Sierra Vista','AZ','Higher Learning Commission','https://www.cochise.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-Flagstaff','Flagstaff','AZ','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-Chandler','Chandler','AZ','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Cortiva Institute-Tucson','Tucson','AZ','NULL','www.cortiva.com/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Avalon School of Cosmetology-Mesa','Mesa','AZ','National Accrediting Commission of Career Arts and Sciences','avalon.edu/locations/mesa-az/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Eastern Arizona College','Thatcher','AZ','Higher Learning Commission','www.eac.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Embry-Riddle Aeronautical University-Prescott','Prescott','AZ','Southern Association of Colleges and Schools Commission on Colleges','prescott.erau.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','School of Architecture at Taliesin','Scottsdale','AZ','Higher Learning Commission','www.taliesin.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Glendale Community College','Glendale','AZ','Higher Learning Commission','www.gccaz.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Grand Canyon University','Phoenix','AZ','Higher Learning Commission','www.gcu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','GateWay Community College','Phoenix','AZ','Higher Learning Commission','www.gatewaycc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Mesa Community College','Mesa','AZ','Higher Learning Commission','www.mesacc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Mohave Community College','Kingman','AZ','Higher Learning Commission','https://www.mohave.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Universal Technical Institute of Arizona Inc-Motorcycle Mechanics Institute Division','Phoenix','AZ','Accrediting Commission of Career Schools and Colleges','www.uti.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Dine College','Tsaile','AZ','Higher Learning Commission','https://www.dinecollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Northern Arizona University','Flagstaff','AZ','Higher Learning Commission','https://nau.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Northland Pioneer College','Holbrook','AZ','Higher Learning Commission','www.npc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Ottawa University-Phoenix','Phoenix','AZ','Higher Learning Commission','www.ottawa.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Phoenix College','Phoenix','AZ','Higher Learning Commission','www.phoenixcollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Cortiva Institute-Scottsdale','Scottsdale','AZ','NULL','www.cortiva.com/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Pima Community College','Tucson','AZ','Higher Learning Commission','www.pima.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Pima Medical Institute-Tucson','Tucson','AZ','Accrediting Bureau of Health Education Schools','pmi.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Pima Medical Institute-Albuquerque','Albuquerque','NM','Accrediting Bureau of Health Education Schools','pmi.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University-Bakersfield','Bakersfield','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.csub.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University-Stanislaus','Turlock','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','https://www.csustan.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University-San Bernardino','San Bernardino','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.csusb.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State Polytechnic University-Pomona','Pomona','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.cpp.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University-Chico','Chico','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.csuchico.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University-Dominguez Hills','Carson','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','https://www.csudh.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University-Fresno','Fresno','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.fresnostate.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University-Fullerton','Fullerton','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.fullerton.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University-East Bay','Hayward','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.csueastbay.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University-Long Beach','Long Beach','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.csulb.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University-Los Angeles','Los Angeles','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.calstatela.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University-Northridge','Northridge','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','https://www.csun.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University-Sacramento','Sacramento','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.csus.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of California-Berkeley','Berkeley','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.berkeley.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Applied Technology Services','Sunset Hills','MO','Council on Occupational Education','www.appliedtech-stl.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Central College of Cosmetology','Saint Robert','MO','National Accrediting Commission of Career Arts and Sciences','centralandsalemcolleges.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Southeast Missouri Hospital College of Nursing and Health Sciences','Cape Girardeau','MO','Higher Learning Commission','www.sehcollege.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Messenger College','Bedford','TX','Transnational Association of Christian Colleges and Schools','www.messengercollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Durham Beauty Academy','Durham','NC','NULL','www.durhambeautyacademy.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Union County Vocational Technical School','Scotch Plains','NJ','Middle States Commission on Secondary Education','www.ucvts.tec.nj.us/domain/11',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Prism Career Institute-Philadelphia','Philadelphia','PA','Accrediting Council for Continuing Education & Training','PrismCareerInstitute.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Clinton Essex Warren Washington BOCES','Plattsburgh','NY','New York State Board of Regents State Education Department Office of the Professions (Public Postsecondary Vocational Education Practical Nursing)','www.cves.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Jefferson Lewis BOCES-Practical Nursing Program','Watertown','NY','New York State Board of Regents State Education Department Office of the Professions (Public Postsecondary Vocational Education Practical Nursing)','www.boces.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Veeb Nassau County School of Practical Nursing','Hicksville','NY','New York State Board of Regents State Education Department Office of the Professions (Public Postsecondary Vocational Education Practical Nursing)','www.veeb.org/PN_main.php',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Cattaraugus Allegany BOCES-Practical Nursing Program','Olean','NY','New York State Board of Regents State Education Department Office of the Professions (Public Postsecondary Vocational Education Practical Nursing)','www.caboces.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Orange Ulster BOCES-Practical Nursing Program','Goshen','NY','New York State Board of Regents State Education Department Office of the Professions (Public Postsecondary Vocational Education Practical Nursing)','www.ouboces.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Wayne Finger Lakes BOCES-Practical Nursing Program','Newark','NY','New York State Board of Regents State Education Department Office of the Professions (Public Postsecondary Vocational Education Practical Nursing)','https://www.wflboces.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Broome Delaware Tioga BOCES-Practical Nursing Program','Binghamton','NY','New York State Board of Regents and the Commissioner of Education','www.btboces.org/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Washington Saratoga Warren Hamilton Essex BOCES-Practical Nursing Program','Hudson Falls','NY','New York State Board of Regents State Education Department Office of the Professions (Public Postsecondary Vocational Education Practical Nursing)','www.wswheboces.org/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Albany BOCES-Adult Practical Nursing Program','Albany','NY','New York State Board of Regents State Education Department Office of the Professions (Public Postsecondary Vocational Education Practical Nursing)','https://www.capitalregionboces.org/adult-education/classes-programs/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Ulster BOCES-School of Practical Nursing','Lake Katrine','NY','Council on Occupational Education','www.ulsterboces.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Eastern Suffolk BOCES','Brentwood','NY','Middle States Commission on Secondary Education','www.esboces.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Rockland County BOCES-Practical Nursing Program','West Nyack','NY','New York State Board of Regents State Education Department Office of the Professions (Public Postsecondary Vocational Education Practical Nursing)','www.rocklandboces.org/adult-education-business-services/practical-nursing/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','New York College of Health Professions','Syosset','NY','New York State Board of Regents and the Commissioner of Education','www.nycollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Charles Stuart School of Diamond Setting','Brooklyn','NY','Accrediting Commission of Career Schools and Colleges','charlesstuartschool.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Penta County Joint Vocational School','Perrysburg','OH','Council on Occupational Education','www.pentacareercenter.org',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Career and Technology Education Centers of Licking County','Newark','OH','Accrediting Commission of Career Schools and Colleges','www.c-tec.edu/cms/One.aspx?portalId=76736&pageId=77833',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Northern Career Institute','Eastlake','OH','Council on Occupational Education','ncioh.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','CET-Watsonville','Watsonville','CA','Council on Occupational Education','https://www.cetweb.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','CET-Salinas','Salinas','CA','Council on Occupational Education','https://cetweb.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Cerritos College','Norwalk','CA','Western Association of Schools and Colleges Accrediting Commission for Community and Junior Colleges','www.cerritos.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Alabama A & M University','Normal','AL','Southern Association of Colleges and Schools Commission on Colleges','www.aamu.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Alabama at Birmingham','Birmingham','AL','Southern Association of Colleges and Schools Commission on Colleges','https://www.uab.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Amridge University','Montgomery','AL','Southern Association of Colleges and Schools Commission on Colleges','www.amridgeuniversity.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Alabama in Huntsville','Huntsville','AL','Southern Association of Colleges and Schools Commission on Colleges','www.uah.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Alabama State University','Montgomery','AL','Southern Association of Colleges and Schools Commission on Colleges','www.alasu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','The University of Alabama','Tuscaloosa','AL','Southern Association of Colleges and Schools Commission on Colleges','www.ua.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Central Alabama Community College','Alexander City','AL','Southern Association of Colleges and Schools Commission on Colleges','www.cacc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Athens State University','Athens','AL','Southern Association of Colleges and Schools Commission on Colleges','www.athens.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Auburn University at Montgomery','Montgomery','AL','Southern Association of Colleges and Schools Commission on Colleges','www.aum.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Jacksonville State University','Jacksonville','AL','Southern Association of Colleges and Schools Commission on Colleges','www.jsu.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Jefferson State Community College','Birmingham','AL','Southern Association of Colleges and Schools Commission on Colleges','www.jeffersonstate.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','John C Calhoun State Community College','Tanner','AL','Southern Association of Colleges and Schools Commission on Colleges','https://calhoun.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Judson College','Marion','AL','Southern Association of Colleges and Schools Commission on Colleges','www.judson.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Lawson State Community College','Birmingham','AL','Southern Association of Colleges and Schools Commission on Colleges','www.lawsonstate.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of West Alabama','Livingston','AL','Southern Association of Colleges and Schools Commission on Colleges','www.uwa.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Lurleen B Wallace Community College','Andalusia','AL','Southern Association of Colleges and Schools Commission on Colleges','https://www.lbwcc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Marion Military Institute','Marion','AL','Southern Association of Colleges and Schools Commission on Colleges','www.marionmilitary.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Miles College','Fairfield','AL','Southern Association of Colleges and Schools Commission on Colleges','www.miles.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Mobile','Mobile','AL','Southern Association of Colleges and Schools Commission on Colleges','www.umobile.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Montevallo','Montevallo','AL','Southern Association of Colleges and Schools Commission on Colleges','www.montevallo.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Northwest-Shoals Community College','Muscle Shoals','AL','Southern Association of Colleges and Schools Commission on Colleges','https://www.nwscc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of North Alabama','Florence','AL','Southern Association of Colleges and Schools Commission on Colleges','www.una.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Northeast Alabama Community College','Rainsville','AL','Southern Association of Colleges and Schools Commission on Colleges','https://www.nacc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Oakwood University','Huntsville','AL','Southern Association of Colleges and Schools Commission on Colleges','https://www2.oakwood.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Reid State Technical College','Evergreen','AL','Council on Occupational Education','www.rstc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Bishop State Community College','Mobile','AL','Southern Association of Colleges and Schools Commission on Colleges','www.bishop.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Samford University','Birmingham','AL','Southern Association of Colleges and Schools Commission on Colleges','www.samford.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Selma University','Selma','AL','NULL','selmauniversity.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Shelton State Community College','Tuscaloosa','AL','Southern Association of Colleges and Schools Commission on Colleges','www.sheltonstate.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Snead State Community College','Boaz','AL','Southern Association of Colleges and Schools Commission on Colleges','www.snead.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of South Alabama','Mobile','AL','Southern Association of Colleges and Schools Commission on Colleges','www.southalabama.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Spring Hill College','Mobile','AL','Southern Association of Colleges and Schools Commission on Colleges','www.shc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Stillman College','Tuscaloosa','AL','Southern Association of Colleges and Schools Commission on Colleges','https://stillman.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Talladega College','Talladega','AL','Southern Association of Colleges and Schools Commission on Colleges','www.talladega.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','H Councill Trenholm State Community College','Montgomery','AL','Southern Association of Colleges and Schools Commission on Colleges','www.trenholmstate.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Troy University','Troy','AL','Southern Association of Colleges and Schools Commission on Colleges','www.troy.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Tuskegee University','Tuskegee','AL','Southern Association of Colleges and Schools Commission on Colleges','www.tuskegee.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','United States Sports Academy','Daphne','AL','Southern Association of Colleges and Schools Commission on Colleges','www.ussa.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Bevill State Community College','Jasper','AL','Southern Association of Colleges and Schools Commission on Colleges','www.bscc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Alaska Anchorage','Anchorage','AK','Northwest Commission on Colleges and Universities','www.uaa.alaska.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Alaska Bible College','Palmer','AK','Association for Bibical Higher Educaiton','www.akbible.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Alaska Fairbanks','Fairbanks','AK','Northwest Commission on Colleges and Universities','www.uaf.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Alaska Southeast','Juneau','AK','Northwest Commission on Colleges and Universities','www.uas.alaska.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Alaska Pacific University','Anchorage','AK','Northwest Commission on Colleges and Universities','www.alaskapacific.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Alaska Vocational Technical Center','Seward','AK','Council on Occupational Education','www.avtec.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California Lutheran University','Thousand Oaks','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.callutheran.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California Polytechnic State University-San Luis Obispo','San Luis Obispo','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','calpoly.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Alliant International University-San Diego','San Diego','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.alliant.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Charter College','Vancouver','WA','Accrediting Bureau of Health Education Schools','https://www.chartercollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Alaska Career College','Anchorage','AK','Accrediting Commission of Career Schools and Colleges','www.alaskacareercollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-Tucson','Tucson','AZ','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Carrington College-Phoenix North','Phoenix','AZ','Western Association of Schools and Colleges Accrediting Commission for Community and Junior Colleges','https://carrington.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Carrington College-Mesa','Mesa','AZ','Western Association of Schools and Colleges Accrediting Commission for Community and Junior Colleges','https://carrington.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Carrington College-Tucson','Tucson','AZ','Western Association of Schools and Colleges Accrediting Commission for Community and Junior Colleges','https://carrington.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','CollegeAmerica-Flagstaff','Flagstaff','AZ','Accrediting Commission of Career Schools and Colleges','www.collegeamerica.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Arizona Academy of Beauty-East','Tucson','AZ','National Accrediting Commission of Career Arts and Sciences','www.arizonaacademy.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Platt College-Arizona Automotive Institute Arizona','Glendale','AZ','Accrediting Commission of Career Schools and Colleges','www.aai.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Brookline College-Phoenix','Phoenix','AZ','Accrediting Bureau of Health Education Schools','www.brooklinecollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Arizona State University-Tempe','Tempe','AZ','Higher Learning Commission','www.asu.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Arizona Western College','Yuma','AZ','Higher Learning Commission','www.azwestern.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Arizona','Tucson','AZ','Higher Learning Commission','https://www.arizona.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of California-Davis','Davis','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','ucdavis.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of California-Irvine','Irvine','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.uci.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of California-Los Angeles','Los Angeles','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.ucla.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of California-Riverside','Riverside','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.ucr.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of California-San Diego','La Jolla','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.ucsd.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of California-San Francisco','San Francisco','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','ucsf.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of California-Santa Barbara','Santa Barbara','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.ucsb.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of California-Santa Cruz','Santa Cruz','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.ucsc.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Sofia University','Palo Alto','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.sofia.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California Beauty School','Modesto','CA','National Accrediting Commission of Career Arts and Sciences','www.calbeautycollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California Christian College','Fresno','CA','Transnational Association of Christian Colleges and Schools','www.calchristiancollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California Coast University','Santa Ana','CA','Distance Education Accrediting Commission','https://www.calcoast.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California Hair Design Academy','La Mesa','CA','National Accrediting Commission of Career Arts and Sciences','https://chdaschools.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California Institute of the Arts','Valencia','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','www.calarts.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California State University Maritime Academy','Vallejo','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','https://www.csum.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','California Western School of Law','San Diego','CA','Western Association of Schools and Colleges Senior Colleges and University Commission','https://www.cwsl.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Canada College','Redwood City','CA','Western Association of Schools and Colleges Accrediting Commission for Community and Junior Colleges','canadacollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Prescott College','Prescott','AZ','Higher Learning Commission','https://www.prescott.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Refrigeration School Inc','Phoenix','AZ','Accrediting Commission of Career Schools and Colleges','https://www.refrigerationschool.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Rio Salado College','Tempe','AZ','Higher Learning Commission','www.rio.maricopa.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Roberto-Venn School of Luthiery','Phoenix','AZ','Accrediting Commission of Career Schools and Colleges','www.roberto-venn.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Scottsdale Community College','Scottsdale','AZ','Higher Learning Commission','www.scottsdalecc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','South Mountain Community College','Phoenix','AZ','Higher Learning Commission','www.southmountaincc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Arizona Christian University','Glendale','AZ','Higher Learning Commission','www.arizonachristian.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Universal Technical Institute of Arizona Inc','Avondale','AZ','Accrediting Commission of Career Schools and Colleges','www.uti.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Empire Beauty School-NW Phoenix','Phoenix','AZ','National Accrediting Commission of Career Arts and Sciences','www.empire.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Yavapai College','Prescott','AZ','Higher Learning Commission','www.YC.EDU',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Arkansas at Little Rock','Little Rock','AR','Higher Learning Commission','ualr.edu/www/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Arkansas for Medical Sciences','Little Rock','AR','Higher Learning Commission','www.uams.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Arkansas Baptist College','Little Rock','AR','Higher Learning Commission','www.arkansasbaptist.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Arkansas Beauty School-Little Rock','Little Rock','AR','National Accrediting Commission of Career Arts and Sciences','arkbeautyschool.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Arkansas Beauty College','Russellville','AR','Accrediting Commission of Career Schools and Colleges','https://www.arkansasbeautycollege.us/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Lyon College','Batesville','AR','Higher Learning Commission','www.lyon.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Arkansas College of Barbering and Hair Design','North Little Rock','AR','Accrediting Commission of Career Schools and Colleges','www.arkansascollegeofbarbering.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Arthur''s Beauty College Inc-Fort Smith','Fort Smith','AR','National Accrediting Commission of Career Arts and Sciences','www.arthursbeautycollege.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Arkansas','Fayetteville','AR','Higher Learning Commission','https://www.uark.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Arkansas at Pine Bluff','Pine Bluff','AR','Higher Learning Commission','www.uapb.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Arkansas State University-Beebe','Beebe','AR','Higher Learning Commission','www.asub.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Arkansas State University-Main Campus','Jonesboro','AR','Higher Learning Commission','www.astate.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Arkansas Tech University','Russellville','AR','Higher Learning Commission','www.atu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Arkansas at Monticello','Monticello','AR','Higher Learning Commission','www.uamont.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Arthur''s Beauty College Inc-Jacksonville','Jacksonville','AR','National Accrediting Commission of Career Arts and Sciences','arthursbeautycollege.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Baptist Health College Little Rock','Little Rock','AR','Accrediting Bureau of Health Education Schools','https://www.bhclr.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Black River Technical College','Pocahontas','AR','Higher Learning Commission','www.blackrivertech.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Central Arkansas','Conway','AR','Higher Learning Commission','www.uca.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Central Baptist College','Conway','AR','Higher Learning Commission','www.cbc.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Cossatot Community College of the University of Arkansas','De Queen','AR','Higher Learning Commission','www.cccua.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Crowley''s Ridge College','Paragould','AR','Higher Learning Commission','www.crc.edu/',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Crowley''s Ridge Technical Institute','Forrest City','AR','Council on Occupational Education','www.crti.tec.ar.us',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','East Arkansas Community College','Forrest City','AR','Higher Learning Commission','https://WWW.EACC.EDU',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Eastern College of Health Vocations-Little Rock','Little Rock','AR','Accrediting Bureau of Health Education Schools','www.easterncollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Imagine-Paul Mitchell Partner School','North Little Rock','AR','National Accrediting Commission of Career Arts and Sciences','paulmitchell.edu/littlerock',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','National Park College','Hot Springs','AR','Higher Learning Commission','www.np.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','University of Arkansas Community College-Batesville','Batesville','AR','Higher Learning Commission','www.uaccb.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Harding University','Searcy','AR','Higher Learning Commission','www.harding.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Henderson State University','Arkadelphia','AR','Higher Learning Commission','https://www.hsu.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Hendrix College','Conway','AR','Higher Learning Commission','www.hendrix.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','College of the Canyons','Santa Clarita','CA','Western Association of Schools and Colleges Accrediting Commission for Community and Junior Colleges','www.canyons.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Career Academy of Beauty','Garden Grove','CA','National Accrediting Commission of Career Arts and Sciences','CAofB.com',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','Casa Loma College-Van Nuys','Van Nuys','CA','Accrediting Bureau of Health Education Schools','https://www.casalomacollege.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','CET-San Diego','San Diego','CA','Council on Occupational Education','https://www.cetweb.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','CET-San Jose','San Jose','CA','Council on Occupational Education','https://cetweb.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','CET-El Centro','El Centro','CA','Council on Occupational Education','https://cetweb.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
   i('SCHOOLS','en','CET-Colton','Colton','CA','Council on Occupational Education','https://cetweb.edu',null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');
    i('LATIN_TEXTS','en','Teque Cu Eos Sonet Nemore Del.','M Vocent Fabulaset Tantas Sanctus Incorrupte Cum Ne Est.','Alia Debet Iisque Te Cum Dicat Minim Accusamus Ne Mucius Erroribus Usu Te Eam Id Consul Electram Periculis Comprehensam.','Tuto Et Idque Aliquam Vimper Te Liber Eruditi Invidunt Mei Facer Tantas Interesset Cu Autem Ridens Convenire Te Usu Error Praesent Ne Usu Mel Ferri Alienum Ea Ad Inermis Delectus Conceptam Eos Tollit Explicari Expetendis Ius At Vel Ne Elit P.','Opiosae Eleifend Adcu Eum Purto Tation Referrentur Quodsi Intellegat Ex Qui Per Cibo Quaestio Te Magna Corpora An Sed Mei Verear Delectus Assueverit Ad Vis No Dolorum Explicari Mel Ei Brute Errem Suavitate Dictas Tacimates Forensibus Eu Eos Est Falli Paulo Urbanitas Utvel Et Simul Eirmod Admodum Et Cibo Noluisse Reprehendunt Nec Et Mollis Sententiae Assueverit Mea Ea Mea Habeo Dictas Sadipscing Eos Te Ubique Probatus Qui Et Petentium Iudicabit Interesset Ei Eam Facete Efficiantur Putent Labores Per In Eum Possim Fabulas At Has Eu Altera Perfecto Ut Dictas Electram Mediocrem Vix Duo Ex Dicta Suavitate Evertiturveri Meis Scribentur Ei Nec Usu No Alienum Placerat Sententiae Disputando Suscipiantur Et Sed Sed Alii Admodum Cu Audiam Aeterno Copiosae Ut Vis Te Habemus Corpora Epicurei Vim Has Melius Legimus Noelit Sale Ad His Cum Te Gubergren Dissentiunt Ad Quodsi Docendi Facilisi Vel In Est Natum Lorem Aliquid Moderatius Necessitatibus No Vix Te Mel Quaeque Consulatu Philosophiasit Ei Nobis Maluisset Urbanitas.',
   'Ertitur In Epicuri Definitionem Sed His Numquam Facilisi Suscipiantur Cu Et Tation Vivendo Usu Ea Eum Alii Eros Sea Latine Adipiscing Cotidieque Ut Simul Semper Ne Sitnam Id Laudem Commune Tincidunt Summo Verear Quo Ad Alterum Feugiat Theophrastus Et Eam Ea Mel Vide Oblique Nonumes In Ornatus Utroque Persecuti Pri Pri Ut Erat Mundi Ei Dicam Utroque Consulatu Quo Quidam Imperdiet Persequeris Ea Mel Ius Eu Deleniti Consulatupossit Legimus Ad Quo Sit Ea Antiopam Tincidunt Forensibus Probo Aperiri Pericula Te Mea Sale Ancillae Nominati In His Dignissim Incorrupte Vel Ne Nam An Volumus Splendide Reprehendunt Latine Bonorum Te Sit Eruditi Probatus Nam Ea Altera Torquatos Cum Id Modo Everti Vulputate Ius Utin Quot Maiorum Dignissim Vim Nusquam Perpetua Similique At Mea In Mutat Omittantur Vix Sapientem Abhorreant Id Eum Vim Et Etiam Conceptam Ne Mea Case Philosophia Mea Diam Cetero Ne Per Ea Labitur Euripidis Eos Verear Audire Facilis Te An Modus Doming Luptatum Mea Sed Tacimates Elaboraret Deterruisset Eaut Mea Sanctus Luptatum Vulputate Sententiae Sadipscing Vel Id Cum Cu Iisque Bonorum Inermis Iisque Neglegentur Cu Sed An Vix Facete Virtute Oportere Purto Nonumes Senserit Est At Nec Te Ipsum Zril Scripta Tale Tamquam Disputationi Sit Et Dolore Sententiae No Vimminim Paulo Complectitur No Vim Quod Virtute Et Mel Mea Te Quot Clita Philosophia Nam Dico Justo Expetenda Eu Cu Inimicus Senserit Ius Ullum Minim Eos Eu An Atqui Falli Integre Est Et Laoreet Consetetur Vixid Ignota Detracto Neglegentur Has Timeam Intellegebat Vis Ea Ea Sit Minim Omittam Noluisse Te Sea Diam Summo Laboramus Quo Aperiri Electram Eu Odio Expetenda In Pri Pri Nibh Mediocritatem Nementitum Assentior Mei At Ne Aliquid Recusabo Has Sumo Inciderint No Pri Alii Tacimates Vel Et Pri Sanctus Alienum Efficiantur Etmazim Veniam Expetenda Eu Vis Epicurei Mandamus An Has Ceteros Commune Adipisci Eum Eu Te Wisi Vivendum Accusata Mea Clita Nonumes Ne Mei Vel Id Nostrum Posidonium Id Has Virtute Voluptua '
    || 'Intellegebat Regione Ullamcorper Eum Anqui At Eirmod Persecuti Contentiones Id Stet Vero Ullamcorper Pro Eum Sint Graeci Platonem At Vim Iusto Voluptaria In Vim Te Paulo Voluptatibus Mei Tota Vidit In Qui Cu Adhuc Dissentiunt Nec Id Debet Essent Laudem Inimicus Ex Vis Tation Mandamus Facilisis Vis Ad Ne Sint Affert Honestatis Nambrute Ullum Conclusionemque Ad His Verear Accusata Electram No Pro Vocent Facilis Mediocrem An Eos Ei Duo Utamur Intellegam Pri An Esse Suscipiantur Vel Iriure Integre Noluisse Cu Ex Vim Omittam Ancillae Gloriatur Nec Ei Duis Scripta Abhorreant Eum Audire Iuvaret Et Euismod Delectus Insolens Id Namhis Et Tempor Ceteros Contentiones Sale Detracto Deleniti Vel Cu Ne Velit Populo Euismod Has Ullum Oporteat Scripserit Quo An Te Vel Choro Tation Dolorem Sea Porro Virtute Ex Mel Viris Tritani Ne Ex Tale Rebum Per Velit Delenit Antiopam An Cum Libris Laboramus An Meacu Sale Adipiscing Mea Vel Nulla Essent Definitiones An Errem Persequeris Eos Ex Vel Te Nisl Recteque Mundi Appareat Legendos Mel An Ut Has Tale Alienum Eam No Quas Copiosae Consulatu Nam Ei Hinc Quas Stet Facer Vulputate Cu Est Ad Has Veniam Impedit Omittamaliquando Interesset Ea Pri Et Quidam Animal Oblique His Facer Epicurei Petentium Cu Vix No Per Purto Honestatis Quaerendum Pro Assueverit Quaerendum At Est Petentium Omittantur Ne Ea Mei Graeco Alienum Et Vim Nostrud Dolorum Inani Iusto Essent No Vel Probatus Tincidunt Eu Mei Oblique Posidonium An Quo Soluta Suscipit Conceptam Vel An Clita Iriure An Has Soleat Evertitur Deterruisset Eu Usu Ea Rebum Atqui Definitionem Mel Tation Inimicus Ut Hascu Alia Primis Pri Omnis Mollis Invenire Sit No Ut Adhuc Putent Inimicus Vix In Wisi Affert Equidem Ius Blandit Menandri Est Ei Eu Nec Vide Congue Aliquip Has No Meis Utroqueat Duo Errem Iuvaret Voluptaria Ei Eos Modus Laoreet Mea Semper Persecuti Signiferumque Eu Eu Has Qualisque Periculis Qui Virtute Impedit Instructior Ad Usu Facilis Offendit Adipisci Et Pri No Petentium Erroribus Signiferu.'
   ,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');

   i('LATIN_TEXTS','en','Initiones Cu Cum Eu Has Debe.','Cetero Detraxit Ei Cumei Vim Accusata Democritum Eu Gu.','Stet Omnis Sonetne Ius Saepe Invidunt Etiam Mollis No Pro Nam Ad Fugit Docendi Et Eam Erat Affert Ignota Denique Perp.','Cius Oblique Dolorum Per In At Usu Doctus Oblique Molestie In Dictas Sadipscing Nec Graeci Discere Phaedrum Cum Ea Laoreet Copiosae Dissentiunt Ex Pro Duo Ex Quot Bonorum Ornatus Tibique Et Vel In Tation Ignota Epicuri Sed Eu Sit Volumus Expetend.','Mus Te Eos Ne Mei Discere Facilisis Gubergren Nobis Suscipit Vim Ex No Aperiri Honestatis His Mel Cu Natum Iriure Oportere Usu Eu Vidit Recusabo Debet Constituto Et Nam Harum Officiis Cu Pri Atqui Oratio Numquam Vim Cu Essent Volutpat Id Meivim Et Placerat Omittantur Adversarium Consul Lobortis Perpetua Vis Eu Ut Repudiare Percipitur Quo Quod Pertinax Ex Pro Eripuit Feugiat Scribentur Sed An Tamquam Mnesarchum Pri Ne Et His Modo Dolorum Splendide Mundi Graeco Ut Ius Vis At Harum Feugait Ius Omnium Voluptaria Adan Ius Volumus Pertinax Assentior Vim Movet Iusto An Tantas Civibus Indoctum Eum Ne Ad Eam Civibus Phaedrum Nobis Menandri Ea Vis Eum Exerci Partem An Has Tempor Graeco Iudicabit Ut Modo Dicant Virtute Usu At Pro No Odio Intellegam Vituperatoribus Te Pertinax Explicari Per Ex Noster Convenire Instructior Esteu Tollit Detraxit Eos Cu Facete Integre Nam Eos Ea Ullum Integre Ad Vide Iisque Tacimates Usu Eam Esse Patrioque At Ea Est Errem Clita Affert Illud Sanctus Apeirian Eum Te No His Alii Ancillae N.',
   'Id Vel Democritum Definitiones Cu Eam Ea Qui Omnium Prompta Has Lucilius Repudiandae Id Ludus Dictas Accusata Est Ne At Malorum Habemus Accusamus Cummei An Lucilius Abhorreant Consetetur Cu Liber Dolore Qualisque Eos Ut Amet Gloriatur Pro Per No Graeci Inermis Vix No Liber Solet Vix Dolor Minimum Cu Sed In Aliquid Antiopam Conceptam His Diam Iuvaret Suscipiantur Ut Solet Fastidii Suavitate Ei Esteum Tempor Putent Eu Quo Tation Aeterno Referrentur In Eu Dolore Populo Quo Vim Ad Aeterno Sensibus Molestiae Duis Deterruisset In Sed Tota Mollis Placerat Ut Ius Ut Sea Labores Accusam Eos Ut Elitr Volutpat Ut Vel Justo Errem Tritanian Iusto Simul Nostro Mel Nobis Albucius His Ad In Omnes Facilis Vis Eos Cu Tale Nemore Mel Mollis Debitis Ut Appareat Disputationi Te Mel Est Feugait Accumsan Ex Ne Etiam Ludus Recteque Per Sea Prompta Rationibus Ne Error Cetero Interesset Pri Utte Nominavi Sapientem Vel Vocent Utamur Persius Eum Et Wisi Similique Rationibus Id Sit Mutat Discere Civibus Sit Ea Ei Est Debitis Eloquentiam Exerci Quaestio Cu Cum Liber Intellegebat Est Ad Mei Semper Nostrum Hendrerit No Vis At Esse Wisi Primis Ocurreret Deseruisse Ad Duo Mei Natum Mutat Volutpat Inmelius Oportere Ea Qui Omnesque Deserunt Id Sed In Usu Impedit Repudiare Pro At Mucius Labore Democritum Debet Indoctum Ei Est Quaeque Scripserit Omittantur In Eum Nominavi Noluisse At Duo Ea Mel Diam Erant Eros Menandri In Sea No Errem Timeam Pri At Causae Noluisse His Pro Te Tota Feugait Eligendite Illum Assueverit Pri Usu Ne Blandit Petentium Quaeque Docendi Te Mea Habeo Dicunt Graecis An Mel Utamur Deserunt Pericula Nec Ad Minimum Eleifend Sea Utubique Docendi Dissentias Mel Ne Eum Cu Purto Integre Aliquam Dolores Eligendi Salutatus No Pro Per Senserit Efficiendi Intellegebat Ei Animal Nusquam Nominavi Ex Sea Sanctus Docendi Invenire An Sea Clita Graecis Vim Ne Option Vocibus Adolescens Ne Sit Ea Vis Adipiscing Dissentias Comprehensam Mei Rebum Animal Commodo At Vim Ea Ponderum Contentiones Ei '
    || 'Vix Mollis Complectitur Contentiones Ad Eum Vide Invenirepro Oratio Expetendis Ne Tota Fierent Interpretaris Pri Et Expetendis Definitiones In Sea Ut Eum Adhuc Senserit Instructior Ne Saperet Alienum Vel At His Quaeque Fabulas Impedit Est Ad Unum Eligendi Id Sea Ullum Nullam Alienum Te Duo Nusquam Epicuri Temporibus No Solet Labores Mei Ius Ut Malis Legere Utamur Sit Id Latine Quaeque Moderatius Mea In Quod Iudicabitcum Et Nominavi Intellegat Per At Suavitate Consequuntur Ex Est Indoctum Dissentiunt Te Mea Novum Facilis Id Vix Reque Inermis Invidunt Cetero Utamur Commodo Quo Ei Torquatos Scriptorem Dissentiet Cu Nec Eius Placerat Liberavisse Nam Eu Cum Et Tempor Invenire Sapientem Eu His Viris Labores Menandri No Habemus Prodesset Quidolore Explicari Repudiare Eu Ius Cu Justo Dolores Molestie Cum Affert Facilis Appetere Id Vim Ex Consequat Interpretaris Ius Sit Aperiri Malorum Imperdiet Id Nusquam Gloriatur Sed Eu Ut Vis Delenit Omnesque Eam Solet Gloriatur Moderatius Ut Per Falli Melius Propriae Ut No Omnis Urbanitas Pro Feugait Alienum Et Iuseu Sed Cetero Conceptam Intellegat Sed No Laboramus Prodesset Eum Et Oporteat Voluptatum Simul Graeco Appellantur Ea Has Vel Ne Equidem Forensibus At Velit Tollit Urbanitas Vel Per Ne Agam Vulputate Nam Errem Dolore Ea Per Meliore Eligendi Forensibus Et Cum Brute Dissentias Inut Eius Magna Tritani Eum Ne Quando Vulputate Ius Aeque Simul Nam At Vel Ea Agam Cotidieque Commodo Denique Pri An Ex Quo Habemus Lobortis Vim Iisque Nonumes Eu Eum Ex Mundi Erroribus Qui Cu Docendi Intellegat Suscipiantur Sit Oblique Veritus Tibique Atte Usu Munere Delicatissimi Cum Liber Utinam Verterem Ei Facer Malorum Euismod No Nam Te Vim Bonorum Liberavisse Te Mel Propriae Vivendum Sensibus Eam Eu Nulla Corrumpit Mucius Eruditi Evertitur Ei Eam Alii Duis Et Cum Usu Facilis Pertinacia Ne Id Usu Nisl Civibus Quem Idque Vix Eu Mea Ea Ponderum Fabellas Duo An Expetenda Corrumpit Sententiae Ne Pri Exerci Sanctusmei Sint Corrumpit Id At Odio Enim Mut.'
   ,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');

   i('LATIN_TEXTS','en','Iendo An Est Et Eam Commune.','O Deleniti Posidonium Ad Melquo Eros Senserit Ut Pro No.','Temporibus Deterruisset Nec Eirmod Prompta Splendide Eahis Cu Cibo Sonet Oporteat Ne Duo Deleniti Deseruisse Vituperato.','Explicari Gloriatur Est Pro Ne Solet Hendrerit An Nec Adipisci Intellegat Qui Malis Forensibus Id Eu Pri Intellegam Consequuntur At Modo Sanctus Cum In Viris Epicurei Mandamus Vis Tibique Comprehensam Ne Quo Ne Sea Case Porro Nonumy Vidit Accus.','Eum Ut Eleifend Efficiendi Inciderint Nec Exerci Nostrum Cu Ea Sumo Offendit Sit Duo Virtute Vivendo Vivendum Eu Est Te Inermis Verterem Contentiones At Quo Dicant Iuvaret Tibiqueei Saepe Deserunt Pri Eum Omnis Munere Ad Officiis Quaerendum Nec Et Pri Te Docendi Deseruisse Dico Veri Dictas Est Ea An Quodsi Laoreet Pro Qui Audire Tibique Ad Vidit Exerci Salutandi No Qui Vim Facilis Oportere Eu Sit Propriae Maiestatis Referrentur An Quod Dicam Euripidis Id Sit Ad Mel Noluisse Dissentieteum Id Soleat Quidam Delicata Tation Mnesarchum Consetetur Has Et Cum Stet Mundi No Cum Regione Diceret Platonem Id Te Laudem Verterem Quaerendum Mea Malorum Vituperata Cu Ius Senserit Similique Inciderint Ex Duo Ei Eum Velit Ridens Cum Falli Officiis At Ex Nostro Pertinacia Has Sea Veri Idque Choro Eaconsetetur Appellantur Et Mea Est Tota Saepe Graeco Et Putant Legimus Adversarium Ne Usu Ea Case Tollit Omittantur Eos Harum Oratio At Usu Sea Ad Prima Adhuc Utamur Impedit Pericula Suscipiantur An Vix Ne Mundi Adolescens Pri N.',
   'S Summo An Eam Cum Dicta Luptatum Ei Deserunt Adversarium At Sed Cu Per Vitae Pertinax Sapientem Feugiat Legimus Ad Vix In Sint Velit Laudem Mei Has Decore Fabellas Ne Mei In Nulla Tinciduntvim Natum Insolens Ad Dico Facilisi Convenire Ut Pro Mel No Audiam Voluptatum Ei Quo Apeirian Convenire Case Vituperatoribus Id Per Duo No Purto Omittam Imperdiet Modo Facilisi Eu Usu Justo Adipiscing Mediocritatem At Quo An Ius Vide Iuvaretmel Agam Atomorum Ei Delenit Lucilius Ex Mea Mei Id Suas Hinc Maiorum Tation Putent Interpretaris At Pro Id Sea Etiam Deserunt Pertinax Quod Pertinax Maluisset At Qui Latine Aperiam Nominavi Eos Eu Ut Sit Elitr Facilisi An Duo Dolore Essent Choro Invenire Ex Quoea Quis Modo Vel Nec Ornatus Vituperatoribus Et Cu Adhuc Illum Atqui Nam Nec Solum Soluta Insolens Ne Mea Latine Appareat Contentiones An An Sit Impetus Virtute Gubergren Mel Sanctus Civibus Temporibus Ei Ut Aliquid Denique Volutpat Eos Sed Cu Vide Duis Suscipiteu Purto Nonumes Epicuri Ius Eu Per Mundi Audire Reprehendunt Elitr Omnes Utinam Ex Eos Duo No Commodo Debitis Commune Hinc Definiebas Ne Has Esse Illum Mundi Pro An Usu Ad Epicuri Accumsan Id Hinc Qualisque Vel Nec In Soleat Fabellas Suscipiantur An Primis Gubergren Maiestatis Duoduo Homero Reprimique Ne Ubique Delectus Disputationi Ea Pro Ea Nam Cibo Erant Eu Posse Lorem Cetero Vel Vis At Summo Partem An Suas Habeo Consul Eumin Per Quem Cibo Democritum Dico Aliquam Conclusionemque Cum No Et Eam Falli Viderer Usu Te Exerci Ignota Partiendo Ne Pro Oratio Iudicabit Mentitum Principes Ne Eam Tritani Posidonium Percipitur Cu Sed Idque Patrioque Interesset Sit Ex Summo Philosophia Per Eisit Tempor Splendide Assueverit In Magna Errem Suavitate Ex Nam Id Clita Partiendo Ius Duo In Facilis Mnesarchum Mel Ad Natum Dolorum Delicata Quas Persecuti Sed An Mea At Odio Similique Usu An Harum Tamquam Voluptaria Exerci Dictas Quaestio Ea Ius At Commune Concludaturque Eos Porro Errem Vel An Idque Assum Sed No Id Eros Mutat Vix In Volumus '
    || 'Sadipscing Conclusionemque Eamputent Erroribus Mei In Ei Utamur Accusam Explicari Qui Qui Te Graeci Insolens Novum Integre Tractatos Sed Eu Mazim Intellegam No Eam Veri Nobis Causae Cu Nec No Vide Laudem Per Cum Eu Probatus Molestiae Complectitur Qui Accusata Elaboraret Exei Error Malorum Ius Ei Essent Option Dolorem Duo Altera Molestiae Mea Ea Mei Ad Illud Laboramus Duo Dicam Feugait Ad Mel Te Elit Aliquid Sensibus Quem Wisi Illud Has Ut Case Posidonium Vis Ei Quod Rebum Iriure Nec Cu Nisl Choro Mollis Ex Eamdiam Complectitur Sea Ad At Dico Postea Mea Cu Omnes Adipiscing Elaboraret Mel Te Odio Errem Volutpat Duo Euismod Ponderum An Pro Vel Ei Modo Iracundia Id Cum Sonet Putent Expetendis Sonet Munere Patrioque Vix Tete Qui Possim Tincidunt Sed Solet Luptatum Phaedrum Ne Has Ei Suas Saepe Vide Detracto Moderatius Eos Ne Usu Ullum Interesset Ei In His Dicam Audire Voluptatibus Case Hendrerit Eu Pro Vis Te Affert Philosophia Eum Latine Dolores Inimicus Adcu Epicuri Nostrum Praesent Qui Ius Et Sint Accusata Cum Ne Sanctus Cotidieque At Pri Illum Quidam Cu Fugit Consequuntur Quo Ne Nec Graeco Disputando Ea Eligendi Probatus Efficiendi Sea An Soleat Nonumes Accommodare Sit Ea Voluptua Similique Mel Agam Nihil Nominavi Eu Qui Nam Ea Causae Saperet Suavitateeam Vide Eruditi Feugait No Pro Ea Odio Vocibus Est Vitae Delicata Et Nullam Percipitur Definitiones Ex Pro Ius Legere Dolores Volutpat Te At Mei Stet Habeo Impetus Cu Laudem Nostro Eosfacilisi Voluptaria Vel Ad Modus Nonumes Periculis In Mel At Nobis Albucius Mea Dicta Repudiandae Vel Cu Vim Aeterno Indoctum Laboramus Id At Iriure Elaboraret Persequeris Ius Cum Ea Postea Repudiare Sea Virtute Probatus Ut Iudicabit Moderatius Pri Anmolestie Pertinacia Disputationi Ut Mea Ad Movet Dolores Invidunt Sit Ex Ius Inani Mediocritatem Et Per Sale Liberavisse Cu Graeci Dolores Reprimique Vel Sit Te Epicuri Recteque Gloriatur Ad His Omnis Illum Option Ea Vim Tation Nostrud Eam Corrumpit Disputando Ad Porro Tacimates Ullamcorper.'
   ,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');

   i('LATIN_TEXTS','en','Ex Eam At Utroque Laoreet.','T Utamur Sensibus An Ex Solet Iuvaret Delectus His Mea Ex S.','Urei Eleifend Tempor Graeci Civibus Id Sea Eu Mea Soluta Integre Corpora Modo Modus No Namduo Mollis Recteque An No C.','Mei Cu At Ferri Conceptam Vim Id Sumo Pertinacia Sadipscing Sea Per Quem Petentium Id Te Qui Repudiare Efficiantur Stet Lobortis Aliquando Eum Indolore Semper Elaboraret Ex Per Eos Suas Dicant Suscipiantur Ea Ut Maiorum Indoctum Vix Simul Nusq.','Ortere Ea Has Vis Possim Fabulas Tevel Nostrud Propriae Invidunt Ne Ad Sea Tale Suas Zril Congue Patrioque Disputationi Ne Nam Sea Ei Facete Docendi Constituam Duo An Brute Accusam Postulantper At Noster Suscipiantur Sit Eu Etiam Soleat Aliquip Ut Illum Melius Sensibus Pro Commune Persecuti Mea In Pro Id Nibh Prima Voluptatum Putant Oblique Partiendo Id Ius Cu Maiorum Adolescens Cumsed In Modo Invidunt Legendos Dicunt Regione Voluptua In Pri An Facer Soluta Integre Nam Nam Ne Ipsum Atomorum Forensibus No Sumo Dissentiet Sed Quem Error Qualisque Per Ea Legere Consectetuer Qui Et Amet Wisi Vis Ut At Eum Numquam Accommodare Laboramus Consequat Ex Quiid Aperiri Gloriatur Pri Eu Noster Interesset Intellegebat Quo Ad Eam Consul Perpetua An Recteque Assentior Vulputate Vim Quo Omnis Voluptua Te An Suas Debet Fuisset Vim Sit Invidunt Partiendo At Et Persius Virtute Officiis His Sea Te Dicit Iudico Nonumy Duis Quaerendum Ex Duo Duo Quidam Dolorem Vituperata An Duo Idque Detracto Voluptua Id Detraxit Constituto Et S.',
   'Er Feugiat Persecuti Ex No Veri Dicit Sententiae Priipsum Disputando At Duo At Quot Volutpat Qui Sed In Molestiae Percipitur Sea No Velit Iisque Phaedrum Posse Tacimates Mei Cu Ei Labores Insolens Cotidieque Velid Affert Nominavi Mel In Mei Sale Graece Molestie Consulatu Eu Quo Est In Dico Ancillae Maluisset Mea Ea Vidisse Aliquam Atomorum No Pri Nominavi Oporteat Incorrupte Eam An Saepe Albucius Facer Nostrum Temporibus Ea Nam Cum Et Numquam Qualisque Splendide Error Decore No Vix Ne Eum Dicat Assum Salutatuset Vel Veri Omnis Signiferumque Elit Animal Repudiare Et Nam Eos Eu Velit Doming Persius Vitae Tantas Suavitate No Eam Mea Euismod Liberavisse Ex Mei Detracto Qualisque Voluptatum Eaduo No Dicat Etiam Sea Te Nostro Efficiendi Appellantur Has Ut Quando Iriure Sensibus Mel Dicam Deserunt No Affert Eirmod Constituam Ei His Vis No Case Luptatumex Vel Malorum Facilisis Bonorum Apeirian Te Vis Zril Sapientem Te Qui Debitis Deserunt Laboramus Has Eiin Partem Laboramus Definitiones Qui Facer Saperet Salutatus Mei Ea Numquam Conceptam Mel Cu Ad Eum Quodsi Feugiat Suscipit Te Corpora Efficiendi Mediocritatem Sed Usu Te Senserit Democritum Mel Ad Modo Animal Necessitatibus Eos Cu Meis Adipisci Temporibus His Te Diam Fierent Copiosae Cu Eos Malis Ornatusei Probatus Accusamus Suscipiantur Sea Omnes Tibique Maiestatis Est Ei Inermis Efficiantur Ad Sed Usu Homero Mentitum Comprehensam Ad In Sumo Detracto Elaboraret Duo Offendit Singulis Forensibus Eam Cu Timeam Suscipit Nec No Cu Ubique Suavitate Adolescens Eos Quo Id Vidit Sapientem Repudiare Modo Instructior Vel Cuvis Delicata Contentiones Ut Eos Alii Etiam Ubique An Ridens Offendit Consulatu Ex Sit Pro Alia Meliore In Eum Saepe Affert Labitur An Laudem Voluptaria Mea Ne Vis Everti Lobortis Expetendis Ad Eos Te Mandamus Scribentur Idque Intellegat Ullamcorper Vix Ne Cu Usu Brute Nemore Ornatus Senserit Explicari Eu Pri His Ex Omnesque Imperdiet Ne Tota Quidam Mel Ius Ad Nulla Promptaea Vel Menandri Definiebas In Aperiri '
    || 'Oblique Graecis Usu Nostrum Consulatu Euripidis Est Ei Cu Nihil Volutpat Vix Doming Partiendo Temporibus Eu Sit Tantas Abhorreant In Ius Vocent Offendit Expetendis Pro Ad Ad Sea Nulla Delicatissimi Cum Cu Adhuc Vidissedolores Noluisse Intellegebat Mel In Quo Suscipit Assueverit Ex Probo Vocent Democritum Id Mei Ad Voluptatum Comprehensam Vel Pro Et Unum Ludus Patrioque At Ocurreret Scriptorem Instructior Vim Nostrud Epicurei Recteque Te Sit Has Te Modus Movet Nostro Mei Ex Tempor Patrioque Honestatisei Percipit Imperdiet Voluptatibus Mea Te Utinam Intellegat Cum Et Tamquam Maiestatis Usu Nec Legere Commodo Id Per Ne Nihil Labore Tractatos In Nec Maiestatis Accommodare Duo An Etiam Aliquip Definiebas Pro Meis Iudico Ullamcorper Easea Ut Amet Aliquam Singulis Ea Ius Dicunt Percipit Ei Wisi Eius Fuisset Mei Ut Usu Alii Hinc Convenire Quando Ancillae Oportere Vis Cu Mea Ei Solet Assueverit Stet Possit Ancillae Ex Pri Pro Maiorum Adolescens Ei Quo No Viderer Inciderint Referrentur Ad Ius Augue Munere Dolorum Feugait Scripserit Vel Tenam Mundi Elitr Scribentur At Cu Eos Quod Menandri Unum Mollis Eam Ut Eum Et Diceret Consetetur Delicatissimi Duo Ut Vidisse Epicurei Mandamus Fabulas Ullamcorper Vis Cu Offendit Legendos Imperdiet Sed At Quis Exerci Audire Ut Pro Mutat Erroribus Honestatis Ne Pri Ei Cum Accommodare Ullamcorper Comprehensaman Qui Offendit Persequeris Vel Iisque Lucilius Ad Noster Probatus Eu Eum Cetero Mandamus Dissentiet Mel Cu Ea Mea Semper Docendi Eos Ornatus Intellegam Ex Eu His Alterum Repudiandae Deleniti Accusamus Ea Mei Alii Vidit Splendide Nec Exmea Ea Ancillae Corrumpit Intellegebat Duo Rebum Inimicus Qualisque Ex Ea Vis Tation Vocibus Graecis At Sonet Efficiendi Theophrastus Qui Fugit Qualisque Definitionem Est No Eu Nemore Alterum Ius Usu Ut Partem Noluisse Salutandi Appareat Antiopam Facilisis Pri No Theophrastus Complectitur Eu Mea Mea Lobortis Suavitate Temporibus Ne Velit Appareat Sit Idnostro Eripuit Mandamus Eu Nec Democritum Vituperat.'
   ,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');

   i('LATIN_TEXTS','en','Tincidunt Liber Aeterno Adve.','Xpetenda Neglegentur At Audire Perpetua Ei Quo Te Mazim F.','Eque Duo Dicta Commodo Vituperata Ethas Id Tota Pertinax Eos Verear Definitionem Eu At Has Nominati Dissentiunt Dicta.','Ut Sale Quando Volumus Pri Minim Postea Alienum Est Eximpedit Detracto Splendide His No Corpora Sapientem Eum Eu Quot Augue Sed Ea Mel Docendi Urbanitas Adipiscing Id Quem Senserit Has Ex Sed An Enim Brute Meliore Soluta Commune Officiis I.','Debet Ullamcorper Per Detracto Albucius At Mea Noster Fierent Ut An Has Lorem Mazim Disputationi Ad Meliore Insolens Eloquentiam Duoeu Habemus Pericula Quaerendum Qui Eos Clita Regione Accusata At An Nec Prompta Ponderum Consequuntur Te Vero Detraxit Per Eligendi Mediocritatem Mei Te Cu Qui Saperet Ponderum Deserunt Iriure Regione Quo In Sit Lobortis Salutatus Voluptatibus Ea Ea Magna Eirmod Corpora Mel Vim Ne Veniam Doctus Volutpat Qui Offendit Facilisi Ei Cu Falli Concludaturque Sed Ei Cum Dictas Repudiandaeridens Prompta Id Pri Utroque Placerat Insolens Ea Pri Atqui Congue Id Pri Ad Vel Erat Delenit Conceptam Ex Cum Senserit Repudiare Pri Justo Fugit Ut At Has Consequat Disputationi Quo Brute Veritus Assueverit Ne Duo Brute Praesent Scriptorem Id Pri An Novum Fuisset Eum Graeco Laboramus Tevim In Movet Putent Dissentias Interpretaris Has Et Sea Ea Nibh Contentiones Amet Oratio Dolores Id Has Pertinax Efficiantur Consequuntur Eam Ne Unum Tation Aliquid His Utvel Apeirian Urbanitas Id Ius In Malorum Facil.',
   'U Cum In His Fastidii Facilisis Splendide Usu Ex Scripta Appareat In Per Affert Aperiri Wisi Adhuc At Sit Ad Eam Omnis Equidem Patrioque Facilisis Rationibus Efficiendi Duo Ne Eum Elit Homero Quaerendum Te Ne Sit Patrioque Theophrastus Vix Probatus Recteque Ea Mel Id Melius Voluptua Theophrastusea Veritus Hendrerit Sadipscing Nam Eam In Probo Doming Labitur Nostrum Vivendum In Qui Mei Velit Molestiae Cu Pri Te Tacimates Referrentur Ex Altera Oporteat Mediocritatem Per Sed Et Nibh Concludaturque Viderer Consulatu Per At Nullam Eripuit Laoreet Mei Eu Mel Te Postea Sapientemeu Iusto Nihil Mea Erat Melius Disputationi Nam Et Assum Quaeque Laboramus Per Te Quot Primis Vix Eu Ut Nisl Oporteat Mediocrem Nam Sea Ea Veniam Mandamus His Sale Consetetur Cu Id Legimus Volumus Cum Sed Ne Invenire Consequuntuream Ea Omnium Graecis Efficiantur Viderer Maiestatis Eam Ex Perfecto Mandamus Oportere Qui Ne Sed Cu Ludus Aperiam Sapientem Qui Paulo Choro Id Ipsum Oratio Graece Has Eu Ea Dolor Docendi Lobortis Cum At Rebum Numquam Aliquando Seacu Dolores Partiendo Per Nam Possim Feugait Ne In Labores Assentior Repudiandae Sed Vel Commodo Nostrud Intellegam Ei Id Inermis Platonem Sit Ne Vivendo Indoctum Assueverit Eum Et Diceret Aliquam Appellantur Per Ne Ius Sumo Laudem Omittamsed Iudico Invenire No Duo In Legere Eripuit Rationibus Mel Id Nemore Prodesset Contentiones Ei Malorum Sententiae Vix Nec Ea Solet Partem Commodo Nostrud Efficiantur Vim Eiadhuc Facete Lucilius In Eum Fastidii Omnesque Ad Vim Aeque Paulo Nihil Vim Te Pro Veniam Perpetua Ut Est Debet Solet Philosophia Ne Has No Sint Albucius Honestatis In Cum Eleifend Consequuntur Eam Eu Brute Porro Detracto Nec Commodo Accusata Ad Mei Ad Tritani Menandri Complectiturvide Scriptorem Ex Vim Vix Mazim Oporteat Efficiantur Ad Pri Quas Decore Cu Torquatos Conclusionemque Nam Cu Eu Nec Malis Placerat Electram At Usu Mucius Detracto Ex Duo Putant Delectus In Mel Nisl Labore Doctus Eum Dicta Salutandi Comprehensam Te Fugit Definitiones '
    || 'No Vimharum Exerci Lucilius Pri Eu Ne Errem Affert Necessitatibus Ius Quo Ei Inimicus Salutatus Sadipscing Duo At Oblique Laoreet Hendrerit Ea Usu Sonet Veritus Brute Constituam Temporibus No Sea Mei Ex Brute Verterem Expetendis Et Vocibus Lucilius Inciderint His Ea Est Quem Purto Affert Per Tota Etiam Veritus Ineuismod Admodum Voluptatum Ne Nec Ne Per Hendrerit Democritum Mea Dico Gubergren Ut Veri Eruditi Comprehensam Qui An Nec Ad Delenit Aliquando Ullamcorper Sea Et Illud Reformidans Comprehensam Eam Nisl Efficiendi Et Mei Te Graeco Labitur Tacimates Mea Errem Docendi Liberavisse Ad Ei Omnes Commodo Mea Veri Appetere Persequeris Ex Mea Mei Vidit Elaboraret Atnec Cu Amet Movet Aliquid Dicta Facilisi Hendrerit In Mei Ne Mei Autem Commune Eu Mei Soleat Tempor Nominavi Usu Ex Quidam Officiis Nam Consul Scripta Appetere Ut Veri Clita Ad Est Nam Ne Quas Iracundia Ad Pri Exerci Laoreet Indoctum In Duo Hinc Habeoanimal Mentitum Vis Ea Quo Cu Case Hendrerit Erat Dicunt Intellegebat His Et Eam Prompta Euismod Delectus Ne Ne Vim Tota Diceret Est Rebum Quando Ut Vix Quem Referrentur In Verear Inimicus Ius At Eu Sed Nisl Deterruissetmenandri Expetendis Ut Mea Sea Ea Aliquid Mediocritatem Clita Scripserit In Sit Mei Ut Quot Ponderum Id Hinc Dolorem Has Ius Admodum Detracto Platonem Utcu Per Ignota Melius Audiam Facilis Vis No No Usu Hinc Integre Insolens Nisl Saepe Iudico Eos An Usu Unum Putant In Volumus Hendrerit Ut Sit Tempor Primis Pertinacia His Ad Has Cibo Choro Quaestio Ea Quem Adipiscing Quo Te Iudico Nemore Diceret Ius Ei Nam Nostrud Qualisque Dissentiet Ut Et Sadipscing Liberavisse Accommodare Mea Usu At Mazimmel An Inani Exerci In Dico Legendos Mea Vim Reque Iudico Posidonium Ei No Pro Recteque Abhorreant Cum Altera Necessitatibus An An Cum Elit Dicant Viderer Indoctum Mea Inornatus Deleniti Invidunt Ut Vim Ferri Nihil Recteque Ius Ad Sumo Vitae Detraxit Te Mei Choro Abhorreant Eam Te Labore Facilisis No Usu Aliquando Reformidans Et Sea Augue Appellantur Mel.'
   ,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');

   i('LATIN_TEXTS','en','Adolescens Ex Nemore Facilisi.','Expetendis Pro Omnis Simul Adversarium Sea In Te Mazim C.','Iciis Ius Sed Mollis Volutpat Adipiscing Eu Ne Usu Purto Atqui Eruditi Ad Veritus Accommodare Sed Eos Probo Omnesque Ne.','Am Concludaturque Eu Mei Homero Nostro Antiopam Sea Eu Eum Te Veri Graecis Conclusionemque Ei Duo Sanctus Lobortis Iudicabit Nec Te Probo Dissentiet At Ubique Omnium Quaeque Duo Causae Sanctus Instructior Ea Cumsed In Noluisse Euripidis Accom.','Ocritum Vel Alii Delicata Facilisis Ne Seaequidem Repudiandae Duo Ei Eirmod Fierent Et Eos Ei Nam Recusabo Delicata Torquatos Usu Ad Adhuc Putent Per An Alia Vivendo Ullamcorper Ea Agam Adhuc Dicat Pro Solum Hendrerit Mei Ut Ei Eam Mollis Prodesset Incorrupteet Eos Habeo Aeque Vivendum Liber Causae Ad Per In Tamquam Offendit Sea Magna Ludus Eleifend Eos Ex Autem Populo Nominati Ut Vim Dicat Saperet Instructior An Sea Ei Eos Homero Invenire Consulatu Nec Eripuit Nonumes Electram Te Mel Epicurei Repudiare In Et Mea Diam Iudicabit Intellegat No Aperiam Numquam Nonumes Est Choro Alterum Ea Per Ex Usu Petentium Honestatis No Solum Ponderum Apeirian Privide Discere Menandri Te His Eu Dolor Mediocrem Pri Cum Meis Timeam Ceteros Te Nihil Nobis Iriure Pri Ei Cum Ea Labitur Fierent Repudiandae Animal Saperet Dissentias Ad Per Cu Has Voluptaria Persequeris Eu Mei Laudem Primis Eloquentiam Sed At Civibus Pericula Ad Menandri Repudiare Incorrupte Melnam Cu Primis Convenire Id Clita Voluptua Per Vocent Consulatu Quo No V.',
   'Porteat Sit Duo Ad Vide Fabellas Hendrerit Et Est Fugit Homero Disputando No Vim Enim Delenit Epicuri Id Nec Feugait Albucius His Ex Modo Ceterospri Amet Aperiam Menandri Cu Ullum Error Officiis No Eam Corpora Aliquando Eum Te Ad Tota Timeam Suscipiantur Vix Cu Novum Munere Eum Ut Sea Clita Tantas Dignissim Has Indoctum Percipitur Et Duis Patrioque Sea Ea Ius Ea Malis Temporqui Lorem Voluptatum Sadipscing Ex Est Ut Illum Essent Definitiones Mea An Facilisi Explicari An Wisi Putent Reprehendunt Eum Munere Facete Eos Ne Cu Similique Efficiantur Ius Mel In Assum Nostrum Delicatissimi Cu Nam Zril Dissentias Vis Corrumpit Omittantur Id Iudicabit Abhorreant Moderatius Ea Quodiam Latine Saperet Est An Mel Ex Odio Wisi Possim Eum Moderatius Dissentias An Dictas Voluptua Recusabo Cu Cum Ei Fugit Dicat Vel No Invidunt Torquatos Sea Nec Et Dicit Pericula Rationibus Ex Vix Eirmod Vocibus Expetendisvis Reque Ubique Minimum Ea Splendide Disputando Ne Per Sit Ex Oblique Eruditi Mea At Nobis Euripidis His Ut Quod Meliore Consetetur Et Qui Tota Adhuc Porro His An Probo Homero Equidem Ut Mel Utinam Possim Animal Ex Ludus Menandri Nam Simul Nominavi Eloquentiam Ex Necusu Veri Illud No Putant Tamquam Eos Eu Eum Cetero Consulatu At Elit Corpora Cu Has Cu Munere Corpora Erroribus Qui An Nec Illud Detraxit Adipisci Ius No Iudico Omnesque Ex His Quem Illum Duo Enim Tollit Nemore No Vim Ex Quod Nemore Ex Illum Iuvaret Deterruisset Sea Inciderint Comprehensam Eu Duo Duo Tota Posse Fierent Euoffendit Recusabo Ne Pri Legimus Insolens Legendos Usu Eu Sit Agam Deterruisset Ad Ei Nam Porro Labitur An Mucius Abhorreant Vix Te Fugit Saepe Est Malis Dissentias Sea An Sea Ad Maiestatis Cotidieque Est Legendos Principes Eu Officiis Ocurreret Ex Seane Per Audiam Corpora Offendit Ius Eu Quis Dictas Intellegat Has Vivendum Hendrerit An Ut Partem Euripidis Intellegebat Mel Qui Ut Solet Partem Sapientem Sit An Appareat Praesent Principes Ceteros Mandamus Concludaturque Ne Mei Ius Te Veri Utinamte Mei Duis '
    || 'Dolore Timeam Quo Ne Aeque Fierent Ad Blandit Neglegentur Usu Eu Illud Atomorum Eum Vim Dicant Fastidii Ut Vel Ad Euismod Euripidis Ad Quo Delenit Appareat Laboramus Ex Est Deleniti Indoctum Periculis Eum Et Dicta Aequeea Sit Affert Mentitum Eleifend Soluta Fastidii Usu Ut Ea Ipsum Simul Scriptorem Vel Per Ei Fabulas Definiebas Eloquentiam Aliquam Officiis Atomorum Ex Vel No Sale Omnis Mel Quodsi Timeam Denique Id Per Mea Rebum Alterum Persecuti Idesse Tota Iudicabit Id Mel Et Pro Lucilius Interesset Quo Nominavi Convenire No Purto Brute Populo Eu Mei At Mea Alii Scripta Cotidieque Usu Omnesque Reprehendunt Ex Soleat Vidisse Recteque In Vis In Partiendo Philosophia Nam Te Has Aeterno Ceterosstet Assum Putent Id Ius Sea Suas Facilis Cu Has At Aliquip Denique Ea Invenire Incorrupte Vim Ei Postea Dolores Persecuti Eos Ius At Nibh Suscipiantur Saepe Audiam Prompta Mei Cu Quod Iudico Scriptorem Usu Cuet Vel Hinc Adipisci Accommodare Quando Ubique Vituperatoribus Eum Cu An Vix Diam Minimum Mnesarchum Te Sed Movet Admodum Pri Id Deleniti Maluisset Scriptorem Magna Elitr No Pro Veri Singulis Ne Eam Vim Nisl Meis Eu Populo Mnesarchum Dissentias Ea Eos Vim Ex Oratio Ornatus Posidonium Admodum Eleifend Cum Ex Mel In Erant Persecuti Comprehensamliber Petentium Qualisque At Has Mel Ea Torquatos Definitiones Quem Qualisque Est Ei Aeque Inermis Admodum Sit In Sed Eros Elit Tation No Vel Fugit Graece Adolescens At Nam Malorum Nostrum Lobortis An Ei Vel Alii Dolor Omnium Ad Laoreet Veritus Inciderint Permel An Movet Quidam Mnesarchum Diceret Splendide Id Vix Ne His Splendide Forensibus Efficiendi Audiam Accusamus Eloquentiam Cu Est Illud Assum Qui Te Eu His Lucilius Eleifend Abhorreant Ut Dicat Aliquid Consequuntur His Eleifend Molestiae An Mei Quot Quaestio Signiferumque Id Usu At Mentitum Voluptua Suscipiantur Vix Sea Cu Autem Ornatus Reprehendunt Ut His Epicurei Oportereut Vel Postea Detraxit Omittantur At Porro Pertinax Sit Id Noster Civibus Vituperata Mea Sit Mutat Labor.'
   ,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,1,'Y');

   i('LATIN_TEXTS','en','Rtem Altera Suscipiantur Con.','Modum Scaevola Mel Eu Duo Erat Mucius Graeci Sale Minim Rec.','M Tation Delectus Molestiae Ei Qui Graeco Dignissim Ne Vix Modo Vituperata Cumei Eu Nonumy Albucius Viderer Legimus Pl.','Soluta Doctus Vel Erat Incorrupte Eu Ubique Tacimates Signiferumque Mel Ne Ad Cum Sint Populo Definitiones Eam Illum Omnium Et Hinc Dicta Pro In Ad Vix Purto Vocent Prompta Velit Labores Duo Euvix Impetus Scripta Legimus In Sed Nisl Mediocrem.','Irian Honestatis Id Sedmediocrem Intellegebat Et Sit Prima Choro In Vim Ea Vel Amet Duis Pri Habeo Dolore Regione Ei Quo Quas Soluta Blandit Te Ex Omnis Omnesque Definiebas Vis Quo Posse Aeque Sententiae Et Duo No Possim Elaboraretinimicus Accommodare Sea Ad Amet Invenire Democritum In Eam Ut Populo Dignissim Deseruisse Eum Vidit Malis Clita Vix Ut Per Assentior Vituperata At Natum Nostrum Vim Ne Doming Vocent Voluptua Te Sed Vim Decore Nostro Complectitur Eu Graeco Tritani Id Pererrem Dolore Dolorum No Vix Ancillae Rationibus Et Est At Fabellas Salutandi Adversarium Has Eam In Lorem Atqui Consectetuer Laudem Labitur Elaboraret Eum Cu Odio Utinam Invenire Qui Ne Enim Error Quaestio Eos Id Fierent Assentior Efficiantur Eu Pro Per Omnes Aliquip Albucius Ea Ad Sea Antiopam Dignissim Sea Soleat Tritani Fuisset Ne At Ius Nibh Novum Minimumad Nam Atqui Contentiones Mediocritatem Duis Dicunt Ex Usu Sed Eu Meliore Accusam Noluisse Senserit Sed Cu In Vix Animal Viderer Nominavi Ea Vix Wisi Etiam Suscipit Sit Imp.',
   'Cu Tota Idque Voluptatum Qui Ex Quot Convenire Concludaturque Qui Eu Affert Theophrastus Qui Purto Harum Cotidieque An Mea Vel Eu Semper Aliquip Ubique Hendrerit Has In Quem Purto Mentitum Qui Id Eius Decore Sed Eaea Option Fastidii Petentium Nec Atqui Fabellas Per Ne Ne Possit Utroque Disputationi Mea Cibo Phaedrum Has Te Has At Liber Voluptaria His D