set define '^' verify off
prompt dev_grants.sql

Rem  Copyright (c) Oracle Corporation 2007 - 2022. All Rights Reserved.
Rem
Rem    NAME
Rem      dev_grants.sql
Rem
Rem    DESCRIPTION
Rem      System and object grants for Oracle APEX development installation
Rem
Rem    NOTES
Rem
Rem
Rem    SCRIPT ARGUMENTS
Rem      None
Rem
Rem    RUNTIME DEPLOYMENT: No
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      jkallman  07/09/2007 - Created

prompt ...grant APEX owner development privileges

grant execute   on sys.dbms_metadata                  to ^APPUN;
grant execute   on sys.diana                          to ^APPUN;
grant execute   on sys.diutil                         to ^APPUN;
grant execute   on sys.ku$_ddls                       to ^APPUN;
grant execute   on sys.ku$_ddl                        to ^APPUN;
grant execute   on sys.pidl                           to ^APPUN;
grant execute   on xdb.dbms_xmldom                    to ^APPUN;
grant execute   on xdb.dbms_xmlparser                 to ^APPUN;
grant execute   on sys.dbms_xmlstore                  to ^APPUN;
grant flashback on dual                               to ^APPUN;
grant select    on dba_rollback_segs                  to ^APPUN;
grant select    on sys.all_constraints                to ^APPUN with grant option;
grant select    on sys.all_dependencies               to ^APPUN with grant option;
grant select    on sys.all_objects                    to ^APPUN with grant option;
grant select    on sys.all_synonyms                   to ^APPUN with grant option;
grant select    on sys.dba_arguments                  to ^APPUN;
grant select    on sys.dba_col_privs                  to ^APPUN;
grant select    on sys.dba_db_links                   to ^APPUN;
grant select    on sys.dba_ind_expressions            to ^APPUN;
grant select    on sys.dba_profiles                   to ^APPUN;
grant select    on sys.dba_rsrc_consumer_groups       to ^APPUN;
grant select    on sys.dba_rsrc_plan_directives       to ^APPUN;
grant select    on sys.dba_snapshots                  to ^APPUN;
grant select    on sys.dba_trigger_cols               to ^APPUN;
grant select    on sys.dba_external_tables            to ^APPUN;
grant select    on sys.gv_$locked_object              to ^APPUN;
grant select    on sys.gv_$mystat                     to ^APPUN;
grant select    on sys.gv_$process                    to ^APPUN;
grant select    on sys.gv_$session_longops            to ^APPUN;
grant select    on sys.gv_$session_wait               to ^APPUN;
grant select    on sys.gv_$sess_io                    to ^APPUN;
grant select    on sys.gv_$sql_plan                   to ^APPUN;
grant select    on sys.gv_$sql                        to ^APPUN;
grant select    on sys.gv_$sysstat                    to ^APPUN;
grant select    on sys.obj$                           to ^APPUN;
grant select    on sys.user_constraints               to ^APPUN;
grant select    on sys.user_source                    to ^APPUN;
grant select    on sys.user_tab_columns               to ^APPUN;
grant select    on sys.v_$object_privilege            to ^APPUN;
grant select    on sys.v_$version                     to ^APPUN;

--
-- Grants to silently fail if the base object does not exist
--
declare
    procedure ddl ( p_sql in varchar2 ) is
    begin
        execute immediate p_sql;
    exception
        when others then null;
    end ddl;
begin
    ddl( 'grant select on sys.dba_recyclebin to ^APPUN' );
    ddl( 'grant select on mdsys.cs_srs to ^APPUN' );
    ddl( 'grant select on sys.dba_feature_usage_statistics to ^APPUN' );

    -- mle-specific dev-grants
    if sys.dbms_db_version.version >= 23 then
        -- with admin option is needed to grant CREATE MLE to new schemas
        ddl( 'grant create mle                    to ^APPUN with admin option' );
        -- used by object browser
        ddl( 'grant read on sys.dba_mle_envs        to ^APPUN' );
        ddl( 'grant read on sys.dba_mle_modules     to ^APPUN' );
        ddl( 'grant read on sys.dba_mle_env_imports to ^APPUN' );
    end if;
end;
/

prompt ...done grant APEX owner development privileges
