Rem  Copyright (c) 2006, 2022, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      apex_install_data.sql
Rem
Rem    DESCRIPTION
Rem      Insert data into tables during APEX installation
Rem
Rem    MODIFIED     (MM/DD/YYYY)
Rem      jkallman    01/23/2007 - Created (moved insert statements from tab.sql)

set define '^'
prompt ...Oracle APEX installation data


prompt
prompt ...insert into ui types
prompt

begin
    wwv_flow_security.g_security_group_id := null;
    --
    delete from wwv_flow_ui_types;
    --
    insert into wwv_flow_ui_types (id, name, based_on_ui_type_id, autodetect_plsql_function_body) values (1, 'DESKTOP',                 null, '-BUILTIN-');
    insert into wwv_flow_ui_types (id, name, based_on_ui_type_id, autodetect_plsql_function_body) values (2, 'JQM_SMARTPHONE',          null, '-BUILTIN-');
    -- insert into wwv_flow_ui_types (id, name, based_on_ui_type_id, autodetect_plsql_function_body) values (3, 'JQM_TABLET',              2, '-BUILTIN-');
    -- insert into wwv_flow_ui_types (id, name, based_on_ui_type_id, autodetect_plsql_function_body) values (4, 'PHONEGAP_JQM_SMARTPHONE', 2, '-BUILTIN-');
    -- insert into wwv_flow_ui_types (id, name, based_on_ui_type_id, autodetect_plsql_function_body) values (5, 'PHONEGAP_JQM_TABLET',     3, '-BUILTIN-');
    wwv_flow_security.g_security_group_id := 10;
    commit;
end;
/


prompt
prompt ...insert into builder features and ui type features
prompt

declare
    l_ui_type_id number;
    --
    procedure add_builder_feature (
        p_id   in number,
        p_name in varchar2 )
    is
    begin
        insert into wwv_flow_builder_features (
            id,
            name )
        values (
            p_id,
            p_name );
    end add_builder_feature;
    --
    procedure add_assignment (
        p_builder_feature_name in varchar2 )
    is
        l_builder_feature_id number;
    begin
        select id
          into l_builder_feature_id
          from wwv_flow_builder_features
         where name = p_builder_feature_name;
        --
        insert into wwv_flow_ui_type_features (
            ui_type_id,
            builder_feature_id,
            security_group_id )
        values (
            l_ui_type_id,
            l_builder_feature_id,
            null );
    end add_assignment;
begin
    wwv_flow_security.g_security_group_id := null;
    --
    delete from wwv_flow_ui_type_features;
    delete from wwv_flow_builder_features;
    --
    -- Create "Features" which are used as conditions in the APEX Builder to show components/...
    -- depending on the selected UI.
    --
    -- Note: Don't change existing builder feature ids, because they are referenced in export files!
    --
    add_builder_feature( 1, 'CLASSIC_REPORT');
    add_builder_feature( 2, 'INTERACTIVE_REPORT');
    add_builder_feature( 4, 'JSTREE');
    add_builder_feature( 5, 'DATA_LOADING');
    add_builder_feature( 6, 'JQM_LIST_VIEW');
    add_builder_feature( 7, 'TABS');
    add_builder_feature( 8, 'MASTER_DETAIL');
    add_builder_feature( 10, 'TABULAR_FORM');
    add_builder_feature( 11, 'JQM_REFLOW_TABLE');
    add_builder_feature( 12, 'JQM_COLUMN_TOGGLE');
    add_builder_feature( 13, 'INTERACTIVE_GRID');
    --
    -- Assign "Features" to the different UI types
    --
    l_ui_type_id := 1; -- DESKTOP
    add_assignment('CLASSIC_REPORT');
    add_assignment('INTERACTIVE_REPORT');
    add_assignment('JSTREE');
    add_assignment('DATA_LOADING');
    add_assignment('TABS');
    add_assignment('MASTER_DETAIL');
    add_assignment('TABULAR_FORM');
    add_assignment('INTERACTIVE_GRID');
    add_assignment('JQM_LIST_VIEW'); -- added for Desktop apps
    add_assignment('JQM_REFLOW_TABLE');
    add_assignment('JQM_COLUMN_TOGGLE');
    --
    l_ui_type_id := 2; -- JQM_SMARTPHONE
    add_assignment('JQM_LIST_VIEW');
    add_assignment('JQM_REFLOW_TABLE');
    add_assignment('JQM_COLUMN_TOGGLE');
    --
    wwv_flow_security.g_security_group_id := 10;
    commit;
end;
/


prompt
prompt ...insert into wwv_flow_translatable_cols$
prompt

delete from wwv_flow_translatable_cols$;

declare
    subtype t_rec is wwv_flow_translatable_cols$%rowtype;
    type    t_tab is table of t_rec index by pls_integer;
    l_tab   t_tab;
    procedure ins (
        p_id                    in number,
        p_table_name            in varchar2,
        p_column_name           in varchar2,
        p_table_pk              in varchar2,
        p_flow_id_column        in varchar2,
        p_page_id_column        in varchar2,
        p_datatype              in varchar2,
        p_template_translatable in varchar2,
        p_column_description    in varchar2 )
    is
        c_idx constant pls_integer := l_tab.count+1;
    begin
        l_tab(c_idx).id                    := p_id;
        l_tab(c_idx).table_name            := p_table_name;
        l_tab(c_idx).column_name           := p_column_name;
        l_tab(c_idx).table_pk              := p_table_pk;
        l_tab(c_idx).flow_id_column        := p_flow_id_column;
        l_tab(c_idx).page_id_column        := p_page_id_column;
        l_tab(c_idx).datatype              := p_datatype;
        l_tab(c_idx).template_translatable := p_template_translatable;
        l_tab(c_idx).column_description    := p_column_description;
    end ins;
    procedure flush
    is
    begin
        forall i in 1 .. l_tab.count
            insert into wwv_flow_translatable_cols$ (
                id,
                table_name,
                column_name,
                table_pk,
                flow_id_column,
                page_id_column,
                datatype,
                template_translatable,
                column_description )
            values (
                l_tab(i).id,
                l_tab(i).table_name,
                l_tab(i).column_name,
                l_tab(i).table_pk,
                l_tab(i).flow_id_column,
                l_tab(i).page_id_column,
                l_tab(i).datatype,
                l_tab(i).template_translatable,
                l_tab(i).column_description );
    end flush;
begin
    ins(1.1,'WWV_FLOW_TOPLEVEL_TABS','TAB_TEXT','ID','FLOW_ID','','VARCHAR2','N','Top Level Tab Name.');
    ins(2,'WWV_FLOW_ICON_BAR','ICON_IMAGE_ALT','ID','FLOW_ID','','VARCHAR2','N','Navigation Bar Icon Text.');
    ins(2.1,'WWV_FLOW_ICON_BAR','ICON_SUBTEXT','ID','FLOW_ID','','VARCHAR2','N','Icon SubText Look1.');
    ins(2.2,'WWV_FLOW_ICON_BAR','ICON_SUBTEXT2','ID','FLOW_ID','','VARCHAR2','N','Icon SubText Look2.');
    ins(2.3,'WWV_FLOW_ICON_BAR','ICON_SUBTEXT3','ID','FLOW_ID','','VARCHAR2','N','Icon SubText Look3.');
    ins(3,'WWV_FLOW_PROCESSING','PROCESS_ERROR_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Flow Process Error Message.');
    ins(4,'WWV_FLOW_TABS','TAB_TEXT','ID','FLOW_ID','','VARCHAR2','N','Tab Text.');
    ins(5,'WWV_FLOW_STEPS','NAME','ID','FLOW_ID','ID','VARCHAR2','N','Page Name.');
    ins(6,'WWV_FLOW_STEPS','STEP_TITLE','ID','FLOW_ID','ID','VARCHAR2','N','Page Title.');
    ins(8,'WWV_FLOW_STEPS','WELCOME_TEXT','ID','FLOW_ID','ID','VARCHAR2','N','Page Header Text.');
    ins(9,'WWV_FLOW_STEPS','BOX_WELCOME_TEXT','ID','FLOW_ID','ID','VARCHAR2','N','Page Body Header Text.');
    ins(11,'WWV_FLOW_STEPS','FOOTER_TEXT','ID','FLOW_ID','ID','VARCHAR2','N','Page Footer Text.');
    ins(12,'WWV_FLOW_STEPS','HELP_TEXT','ID','FLOW_ID','ID','CLOB','N','Page Help Text.');
    ins(13,'WWV_FLOW_STEP_BUTTONS','BUTTON_IMAGE_ALT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Button Text.');
    ins(13.1,'WWV_FLOW_STEP_BUTTONS','CONFIRM_MESSAGE','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Confirmation dialog message');
    ins(14,'WWV_FLOW_STEP_ITEMS','PROMPT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Item Prompt.');
    ins(16,'WWV_FLOW_STEP_VALIDATIONS','ERROR_MESSAGE','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Validation ErrMsg.');
    ins(17,'WWV_FLOW_STEP_PROCESSING','PROCESS_ERROR_MESSAGE','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Process ErrMsg.');
    ins(18,'WWV_FLOW_STEP_PROCESSING','PROCESS_SUCCESS_MESSAGE','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Process Success Message.');
    ins(19,'WWV_FLOW_PAGE_PLUG_TEMPLATES','TEMPLATE','ID','FLOW_ID','','CLOB','Y','Region template, typically does not include translatable text.');
    ins(20,'WWV_FLOW_PAGE_PLUGS','PLUG_NAME','ID','FLOW_ID','PAGE_ID','VARCHAR2','Y','Region name');
    ins(21,'WWV_FLOW_PAGE_PLUGS','PLUG_SOURCE','ID','FLOW_ID','PAGE_ID','CLOB','N','Region source');
    ins(23,'WWV_FLOW_TEMPLATES','HEADER_TEMPLATE','ID','FLOW_ID','','CLOB','Y','Page Header Template');
    ins(24,'WWV_FLOW_TEMPLATES','FOOTER_TEMPLATE','ID','FLOW_ID','','CLOB','Y','Page Footer Template');
    ins(25,'WWV_FLOW_TEMPLATES','BOX','ID','FLOW_ID','','CLOB','Y','Page Body Template');
    ins(26,'WWV_FLOW_PAGE_PLUGS','PLUG_HEADER','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Region header');
    ins(27,'WWV_FLOW_PAGE_PLUGS','PLUG_FOOTER','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Region footer');
    ins(28,'WWV_FLOW_LIST_ITEMS','LIST_ITEM_LINK_TEXT','ID','FLOW_ID','','VARCHAR2','N','List Item Display Text');
    ins(29,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE1','ID','FLOW_ID','','CLOB','Y','Row Template 1');
    ins(30,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE2','ID','FLOW_ID','','CLOB','Y','Row Template 2');
    ins(31,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE3','ID','FLOW_ID','','CLOB','Y','Row Template 3');
    ins(32,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE4','ID','FLOW_ID','','CLOB','Y','Row Template 4');
    ins(34,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE_BEFORE_ROWS','ID','FLOW_ID','','VARCHAR2','Y','Report Template Before Rows');
    ins(35,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE_AFTER_ROWS','ID','FLOW_ID','','VARCHAR2','Y','Report Template After Rows');
    ins(36,'WWV_FLOW_PAGE_PLUGS','PLUG_QUERY_NO_DATA_FOUND','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','No Data Found Message For Regions');
    ins(37,'WWV_FLOW_FIELD_TEMPLATES','TEMPLATE_BODY1','ID','FLOW_ID','','VARCHAR2','Y','Before Label, typically does not include translatable text');
    ins(38,'WWV_FLOW_FIELD_TEMPLATES','TEMPLATE_BODY2','ID','FLOW_ID','','VARCHAR2','Y','After Label, typically does not include translatable text');
    ins(39,'WWV_FLOW_FIELD_TEMPLATES','ON_ERROR_BEFORE_LABEL','ID','FLOW_ID','','VARCHAR2','Y','On Error Before Label, typically does not include translatable text');
    ins(40,'WWV_FLOW_FIELD_TEMPLATES','ON_ERROR_AFTER_LABEL','ID','FLOW_ID','','VARCHAR2','Y','On Error After Label, typically does not include translatable text');
    ins(41,'WWV_FLOW_PAGE_PLUGS','CSV_OUTPUT_LINK_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Link text the user will see when the report region is displayed in CSV format');
    ins(42,'WWV_FLOW_PAGE_PLUGS','REPORT_TOTAL_TEXT_FORMAT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Text to display when printing report sums');
    ins(43,'WWV_FLOW_PAGE_PLUGS','BREAK_COLUMN_TEXT_FORMAT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Heading template for repeating headings');
    ins(44,'WWV_FLOW_ROW_TEMPLATES','COLUMN_HEADING_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Column Heading Template');
    ins(45,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE_BEFORE_FIRST','ID','FLOW_ID','','VARCHAR2','Y','Report Template Before First Row');
    ins(46,'WWV_FLOW_ROW_TEMPLATES','ROW_TEMPLATE_AFTER_LAST','ID','FLOW_ID','','VARCHAR2','Y','Report Template After Last Row');
    ins(47,'WWV_FLOW_ROW_TEMPLATES','PAGINATION_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Pagination Template');
    ins(48,'WWV_FLOW_ROW_TEMPLATES','NEXT_PAGE_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Next Page Template');
    ins(49,'WWV_FLOW_ROW_TEMPLATES','PREVIOUS_PAGE_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Previous Page Template');
    ins(50,'WWV_FLOW_ROW_TEMPLATES','NEXT_SET_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Next Set Template');
    ins(51,'WWV_FLOW_ROW_TEMPLATES','PREVIOUS_SET_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Previous Set Template');
    ins(52,'WWV_FLOW_BUTTON_TEMPLATES','TEMPLATE','ID','FLOW_ID','','CLOB','Y','Button Template');
    ins(53,'WWV_FLOW_LIST_TEMPLATES','LIST_TEMPLATE_CURRENT','ID','FLOW_ID','','CLOB','Y','Template when list item is current');
    ins(54,'WWV_FLOW_LIST_TEMPLATES','LIST_TEMPLATE_NONCURRENT','ID','FLOW_ID','','CLOB','Y','Template when list item is not current');
    ins(55,'WWV_FLOW_LIST_TEMPLATES','LIST_TEMPLATE_BEFORE_ROWS','ID','FLOW_ID','','VARCHAR2','Y','Appears before list template items');
    ins(56,'WWV_FLOW_LIST_TEMPLATES','LIST_TEMPLATE_AFTER_ROWS','ID','FLOW_ID','','VARCHAR2','Y','Appears after list template items');
    ins(57,'WWV_FLOW_MENU_TEMPLATES','BEFORE_FIRST','ID','FLOW_ID','','VARCHAR2','Y','Appears before menu items');
    ins(58,'WWV_FLOW_MENU_TEMPLATES','CURRENT_PAGE_OPTION','ID','FLOW_ID','','VARCHAR2','Y','Template when menu item is current');
    ins(59,'WWV_FLOW_MENU_TEMPLATES','NON_CURRENT_PAGE_OPTION','ID','FLOW_ID','','VARCHAR2','Y','Template when menu item is not current');
    ins(60,'WWV_FLOW_MENU_TEMPLATES','MENU_LINK_ATTRIBUTES','ID','FLOW_ID','','VARCHAR2','Y','The attributes of the link, such as class or id');
    ins(61,'WWV_FLOW_MENU_TEMPLATES','BETWEEN_LEVELS','ID','FLOW_ID','','VARCHAR2','Y','Appears between menu items');
    ins(62,'WWV_FLOW_MENU_TEMPLATES','AFTER_LAST','ID','FLOW_ID','','VARCHAR2','Y','Appears after the last menu item');
    ins(63,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_TITLE','ID','FLOW_ID','','VARCHAR2','N','Title of page');
    ins(64,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_HTML_HEAD','ID','FLOW_ID','','VARCHAR2','Y','HTML <head> of the popup page');
    ins(65,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_BODY_ATTR','ID','FLOW_ID','','VARCHAR2','Y','Attributes listed in the <body> tag');
    ins(66,'WWV_FLOW_POPUP_LOV_TEMPLATE','BEFORE_FIELD_TEXT','ID','FLOW_ID','','VARCHAR2','N','Text that appears before the search field');
    ins(67,'WWV_FLOW_POPUP_LOV_TEMPLATE','AFTER_FIELD_TEXT','ID','FLOW_ID','','VARCHAR2','N','Text that appears after the search field');
    ins(68,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_HEADING_TEXT','ID','FLOW_ID','','VARCHAR2','Y','Text that appears at the top of the popup page');
    ins(69,'WWV_FLOW_POPUP_LOV_TEMPLATE','PAGE_FOOTER_TEXT','ID','FLOW_ID','','VARCHAR2','Y','Text that appears at the bottom of the popup page');
    ins(70,'WWV_FLOW_POPUP_LOV_TEMPLATE','BEFORE_RESULT_SET','ID','FLOW_ID','','VARCHAR2','N','Text that appears before choices');
    ins(71,'WWV_FLOW_POPUP_LOV_TEMPLATE','AFTER_RESULT_SET','ID','FLOW_ID','','VARCHAR2','N','Text that appears after choices');
    ins(72,'WWV_FLOW_POPUP_LOV_TEMPLATE','FIND_BUTTON_TEXT','ID','FLOW_ID','','VARCHAR2','N','Text that appears on the search button');
    ins(73,'WWV_FLOW_POPUP_LOV_TEMPLATE','CLOSE_BUTTON_TEXT','ID','FLOW_ID','','VARCHAR2','N','Text that appears on the close button');
    ins(74,'WWV_FLOW_POPUP_LOV_TEMPLATE','NEXT_BUTTON_TEXT','ID','FLOW_ID','','VARCHAR2','N','Text that appears on the next button');
    ins(75,'WWV_FLOW_POPUP_LOV_TEMPLATE','PREV_BUTTON_TEXT','ID','FLOW_ID','','VARCHAR2','N','Text that appears on the previous button');
    ins(76,'WWV_FLOW_POPUP_LOV_TEMPLATE','WHEN_NO_DATA_FOUND_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Text that appears when search returns 0 results');
    ins(77,'WWV_FLOW_POPUP_LOV_TEMPLATE','BEFORE_FIRST_FETCH_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Text that appears before first time search button is pressed');
    ins(78,'WWV_FLOW_STEP_ITEMS','POST_ELEMENT_TEXT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Text that is displayed following the display of a form element');
    ins(79,'WWV_FLOW_SHORTCUTS','SHORTCUT','ID','FLOW_ID','','CLOB','N','Shortcut is shared static or dynamic HTML');
    ins(80,'WWV_FLOWS','SUBSTITUTION_VALUE_01','ID','ID','','VARCHAR2','N','Application substitution string 01');
    ins(81,'WWV_FLOWS','SUBSTITUTION_VALUE_02','ID','ID','','VARCHAR2','N','Application substitution string 02');
    ins(82,'WWV_FLOWS','SUBSTITUTION_VALUE_03','ID','ID','','VARCHAR2','N','Application substitution string 03');
    ins(83,'WWV_FLOWS','SUBSTITUTION_VALUE_04','ID','ID','','VARCHAR2','N','Application substitution string 04');
    ins(84,'WWV_FLOWS','SUBSTITUTION_VALUE_05','ID','ID','','VARCHAR2','N','Application substitution string 05');
    ins(85,'WWV_FLOWS','SUBSTITUTION_VALUE_06','ID','ID','','VARCHAR2','N','Application substitution string 06');
    ins(86,'WWV_FLOWS','SUBSTITUTION_VALUE_07','ID','ID','','VARCHAR2','N','Application substitution string 07');
    ins(87,'WWV_FLOWS','SUBSTITUTION_VALUE_08','ID','ID','','VARCHAR2','N','Application substitution string 08');
    ins(88,'WWV_FLOWS','SUBSTITUTION_VALUE_09','ID','ID','','VARCHAR2','N','Application substitution string 09');
    ins(89,'WWV_FLOWS','SUBSTITUTION_VALUE_10','ID','ID','','VARCHAR2','N','Application substitution string 10');
    ins(90,'WWV_FLOWS','SUBSTITUTION_VALUE_11','ID','ID','','VARCHAR2','N','Application substitution string 11');
    ins(91,'WWV_FLOWS','SUBSTITUTION_VALUE_12','ID','ID','','VARCHAR2','N','Application substitution string 12');
    ins(92,'WWV_FLOWS','SUBSTITUTION_VALUE_13','ID','ID','','VARCHAR2','N','Application substitution string 13');
    ins(93,'WWV_FLOWS','SUBSTITUTION_VALUE_14','ID','ID','','VARCHAR2','N','Application substitution string 14');
    ins(94,'WWV_FLOWS','SUBSTITUTION_VALUE_15','ID','ID','','VARCHAR2','N','Application substitution string 15');
    ins(95,'WWV_FLOWS','SUBSTITUTION_VALUE_16','ID','ID','','VARCHAR2','N','Application substitution string 16');
    ins(96,'WWV_FLOWS','SUBSTITUTION_VALUE_17','ID','ID','','VARCHAR2','N','Application substitution string 17');
    ins(97,'WWV_FLOWS','SUBSTITUTION_VALUE_18','ID','ID','','VARCHAR2','N','Application substitution string 18');
    ins(98,'WWV_FLOWS','SUBSTITUTION_VALUE_19','ID','ID','','VARCHAR2','N','Application substitution string 19');
    ins(99,'WWV_FLOWS','SUBSTITUTION_VALUE_20','ID','ID','','VARCHAR2','N','Application substitution string 20');
    ins(100,'WWV_FLOW_MENU_OPTIONS','SHORT_NAME','ID','FLOW_ID','','VARCHAR2','N','Shortcut short name');
    ins(101,'WWV_FLOW_MENU_OPTIONS','LONG_NAME','ID','FLOW_ID','','VARCHAR2','N','Shortcut long name');
    ins(102,'WWV_FLOW_PAGE_PLUGS','PLUG_QUERY_MORE_DATA','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','More Data found message');
    ins(103,'WWV_FLOW_LIST_OF_VALUES_DATA','LOV_DISP_VALUE','ID','FLOW_ID','','VARCHAR2','N','List of values display value');
    ins(104,'WWV_FLOW_AUTHENTICATIONS','HELP_TEXT','ID','FLOW_ID','','VARCHAR2','N','Login help text for the built-in login page');
    ins(105,'WWV_FLOW_STEP_ITEMS','LOV_NULL_TEXT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Value displayed when null selected in LOV');
    ins(106,'WWV_FLOW_REGION_REPORT_COLUMN','COLUMN_HEADING','ID','FLOW_ID','','VARCHAR2','N','Report column heading');
    ins(107,'WWV_FLOW_REGION_REPORT_COLUMN','COLUMN_LINKTEXT','ID','FLOW_ID','','VARCHAR2','N','Text to display inside of HTML anchor in report');
    ins(108,'WWV_FLOW_REGION_REPORT_COLUMN','COLUMN_HTML_EXPRESSION','ID','FLOW_ID','','VARCHAR2','N','HTML expression');
    ins(109,'WWV_FLOW_REGION_REPORT_COLUMN','LOV_NULL_TEXT','ID','FLOW_ID','','VARCHAR2','N','Value displayed when null selected from LOV');
    ins(110,'WWV_FLOW_PAGE_PLUGS','PLUG_CUSTOMIZED_NAME','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Customizable region name');
    ins(111,'WWV_FLOW_STEP_ITEM_HELP','HELP_TEXT','FLOW_ITEM_ID','FLOW_ID','','VARCHAR2','N','Item level help text');
    ins(112,'WWV_FLOW_POPUP_LOV_TEMPLATE','RESULT_ROW_X_OF_Y','ID','FLOW_ID','','VARCHAR2','N','Set pagination text');
    ins(113,'WWV_FLOW_SHORTCUTS','ERROR_TEXT','ID','FLOW_ID','','VARCHAR2','N','Shortcut is shared static or dynamic HTML');
    ins(114,'WWV_FLOW_LIST_TEMPLATES','BETWEEN_ITEMS','ID','FLOW_ID','','VARCHAR2','Y','Appears between list template items');
    ins(115,'WWV_FLOW_LIST_TEMPLATES','BEFORE_SUB_LIST','ID','FLOW_ID','','VARCHAR2','Y','Appears before list template sub list items');
    ins(116,'WWV_FLOW_LIST_TEMPLATES','AFTER_SUB_LIST','ID','FLOW_ID','','VARCHAR2','Y','Appears after list template sub list items');
    ins(117,'WWV_FLOW_LIST_TEMPLATES','BETWEEN_SUB_LIST_ITEMS','ID','FLOW_ID','','VARCHAR2','Y','Appears between list template sub list items');
    ins(118,'WWV_FLOW_LIST_TEMPLATES','SUB_LIST_ITEM_CURRENT','ID','FLOW_ID','','CLOB','Y','Appears as current list template sub list item');
    ins(119,'WWV_FLOW_LIST_TEMPLATES','SUB_LIST_ITEM_NONCURRENT','ID','FLOW_ID','','CLOB','Y','Appears as noncurrent list template sub list item');
    ins(120,'WWV_FLOW_LIST_TEMPLATES','ITEM_TEMPLATE_CURR_W_CHILD','ID','FLOW_ID','','CLOB','Y','Template for current list item with child');
    ins(121,'WWV_FLOW_LIST_TEMPLATES','ITEM_TEMPLATE_NONCURR_W_CHILD','ID','FLOW_ID','','CLOB','Y','Template for non-current list item with child');
    ins(122,'WWV_FLOW_LIST_TEMPLATES','SUB_TEMPLATE_CURR_W_CHILD','ID','FLOW_ID','','CLOB','Y','Sub template for current list item with child');
    ins(123,'WWV_FLOW_LIST_TEMPLATES','SUB_TEMPLATE_NONCURR_W_CHILD','ID','FLOW_ID','','CLOB','Y','Sub template for non-current list item with child');
    ins(124,'WWV_FLOW_COMPUTATIONS','COMPUTATION_ERROR_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Application computation error message');
    ins(125,'WWV_FLOW_STEP_COMPUTATIONS','COMPUTATION_ERROR_MESSAGE','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page computation error message');
    ins(126,'WWV_FLOW_STEP_ITEMS','PRE_ELEMENT_TEXT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Text that is displayed before the display of a form element');
    ins(142,'WWV_FLOW_PAGE_PLUGS','PRN_OUTPUT_LINK_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Link label name for region printing');
    ins(143,'WWV_FLOW_PAGE_PLUGS','PRN_PAGE_HEADER','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Region printing report header');
    ins(144,'WWV_FLOW_PAGE_PLUGS','PRN_PAGE_FOOTER','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Region printing report footer');
    ins(145,'WWV_FLOW_WORKSHEETS','DESCRIPTION','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Worksheet description');
    ins(146,'WWV_FLOW_WORKSHEETS','MAX_ROW_COUNT_MESSAGE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Message displayed when showing the maximum number of rows in a worksheet');
    ins(147,'WWV_FLOW_WORKSHEETS','NO_DATA_FOUND_MESSAGE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Message displayed when no data found in a worksheet');
    ins(147.1,'WWV_FLOW_WORKSHEETS','ICON_VIEW_ALT_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Icon view text for the image');
    ins(147.2,'WWV_FLOW_WORKSHEETS','ICON_VIEW_TITLE_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Icon view title text for the image');
    ins(148,'WWV_FLOW_WORKSHEET_COLUMNS','COLUMN_LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Worksheet column label');
    ins(149,'WWV_FLOW_WORKSHEET_COLUMNS','REPORT_LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Worksheet report label');
    ins(150,'WWV_FLOW_WORKSHEET_COLUMNS','COLUMN_HTML_EXPRESSION','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Worksheet column HTML expression');
    ins(151,'WWV_FLOW_WORKSHEET_COLUMNS','COLUMN_LINKTEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Worksheet column link text');
    ins(152,'WWV_FLOW_WORKSHEET_COLUMNS','HELP_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Worksheet column help text');
    ins(153,'WWV_FLOW_WORKSHEET_COL_GROUPS','NAME','ID','FLOW_ID','','VARCHAR2','N','Worksheet column group name');
    ins(154,'WWV_FLOW_WORKSHEET_COL_GROUPS','DESCRIPTION','ID','FLOW_ID','','VARCHAR2','N','Worksheet column group description');
    ins(155,'WWV_FLOW_WORKSHEETS','SEARCH_BUTTON_LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Label of search button in Interactive Report.');
    ins(156,'WWV_FLOW_TEMPLATES','BODY_TITLE','ID','FLOW_ID','','VARCHAR2','Y','Body Title');
    ins(157,'WWV_FLOW_TEMPLATES','CURRENT_IMAGE_TAB','ID','FLOW_ID','','VARCHAR2','Y','Current Image Tab');
    ins(158,'WWV_FLOW_TEMPLATES','CURRENT_TAB','ID','FLOW_ID','','VARCHAR2','Y','Current Tab');
    ins(159,'WWV_FLOW_TEMPLATES','CURRENT_TAB_FONT_ATTR','ID','FLOW_ID','','VARCHAR2','Y','Current Tab Font Attributes');
    ins(160,'WWV_FLOW_TEMPLATES','ERROR_PAGE_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','Error Page Template');
    ins(161,'WWV_FLOW_TEMPLATES','MESSAGE','ID','FLOW_ID','','VARCHAR2','Y','Notification');
    ins(162,'WWV_FLOW_TEMPLATES','NAVBAR_ENTRY','ID','FLOW_ID','','VARCHAR2','Y','Navigation Bar Entry');
    ins(163,'WWV_FLOW_TEMPLATES','NAVIGATION_BAR','ID','FLOW_ID','','VARCHAR2','Y','Navigation Bar');
    ins(164,'WWV_FLOW_TEMPLATES','NON_CURRENT_IMAGE_TAB','ID','FLOW_ID','','VARCHAR2','Y','Non Current Image Tab');
    ins(165,'WWV_FLOW_TEMPLATES','NON_CURRENT_TAB','ID','FLOW_ID','','VARCHAR2','Y','Non Current Standard Tab');
    ins(166,'WWV_FLOW_TEMPLATES','NON_CURRENT_TAB_FONT_ATTR','ID','FLOW_ID','','VARCHAR2','Y','Non Current Tab Font Attributes');
    ins(167,'WWV_FLOW_TEMPLATES','REGION_TABLE_CATTRIBUTES','ID','FLOW_ID','','VARCHAR2','Y','Region Table Attributes');
    ins(168,'WWV_FLOW_TEMPLATES','SUCCESS_MESSAGE','ID','FLOW_ID','','VARCHAR2','Y','Success Message');
    ins(169,'WWV_FLOW_TEMPLATES','TOP_CURRENT_TAB','ID','FLOW_ID','','VARCHAR2','Y','Current Parent Tab');
    ins(170,'WWV_FLOW_TEMPLATES','TOP_CURRENT_TAB_FONT_ATTR','ID','FLOW_ID','','VARCHAR2','Y','Parent Current Tab Font Attributes');
    ins(171,'WWV_FLOW_TEMPLATES','TOP_NON_CURRENT_TAB','ID','FLOW_ID','','VARCHAR2','Y','Non Current Parent Tab');
    ins(172,'WWV_FLOW_TEMPLATES','TOP_NON_CURRENT_TAB_FONT_ATTR','ID','FLOW_ID','','VARCHAR2','Y','Parent Non Current Tab Font Attributes');
    ins(173,'WWV_FLOW_CAL_TEMPLATES','DAILY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(174,'WWV_FLOW_CAL_TEMPLATES','DAILY_DAY_OF_WEEK_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(175,'WWV_FLOW_CAL_TEMPLATES','DAILY_MONTH_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(176,'WWV_FLOW_CAL_TEMPLATES','DAILY_MONTH_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(177,'WWV_FLOW_CAL_TEMPLATES','DAILY_MONTH_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(178,'WWV_FLOW_CAL_TEMPLATES','DAILY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(179,'WWV_FLOW_CAL_TEMPLATES','DAILY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(180,'WWV_FLOW_CAL_TEMPLATES','DAY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(181,'WWV_FLOW_CAL_TEMPLATES','DAY_OF_WEEK_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(182,'WWV_FLOW_CAL_TEMPLATES','DAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(183,'WWV_FLOW_CAL_TEMPLATES','DAY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(184,'WWV_FLOW_CAL_TEMPLATES','MONTH_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(185,'WWV_FLOW_CAL_TEMPLATES','MONTH_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(186,'WWV_FLOW_CAL_TEMPLATES','MONTH_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(187,'WWV_FLOW_CAL_TEMPLATES','NONDAY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(188,'WWV_FLOW_CAL_TEMPLATES','NONDAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(189,'WWV_FLOW_CAL_TEMPLATES','NONDAY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(190,'WWV_FLOW_CAL_TEMPLATES','TODAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(191,'WWV_FLOW_CAL_TEMPLATES','WEEKEND_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(192,'WWV_FLOW_CAL_TEMPLATES','WEEKEND_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(193,'WWV_FLOW_CAL_TEMPLATES','WEEKEND_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(194,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_DAY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(195,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_DAY_OF_WEEK_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(196,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_DAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(197,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_DAY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(198,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_HOUR_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(199,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_HOUR_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(200,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_MONTH_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(201,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_MONTH_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(202,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TIME_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(203,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TIME_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(204,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TIME_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(205,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(206,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_TODAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(207,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_WEEKEND_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(208,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_WEEKEND_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(209,'WWV_FLOW_CAL_TEMPLATES','WEEKLY_WEEKEND_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(210,'WWV_FLOW_CAL_TEMPLATES','WEEK_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(211,'WWV_FLOW_CAL_TEMPLATES','WEEK_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(212,'WWV_FLOW_PAGE_PLUG_TEMPLATES','TEMPLATE2','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(213,'WWV_FLOW_POPUP_LOV_TEMPLATE','CLOSE_BUTTON_ATTR','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(214,'WWV_FLOW_POPUP_LOV_TEMPLATE','FILTER_TEXT_ATTR','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(215,'WWV_FLOW_POPUP_LOV_TEMPLATE','FIND_BUTTON_ATTR','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(216,'WWV_FLOW_POPUP_LOV_TEMPLATE','NEXT_BUTTON_ATTR','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(217,'WWV_FLOW_POPUP_LOV_TEMPLATE','POPUP_ICON','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(218,'WWV_FLOW_POPUP_LOV_TEMPLATE','POPUP_ICON2','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(219,'WWV_FLOW_POPUP_LOV_TEMPLATE','POPUP_ICON_ATTR','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(220,'WWV_FLOW_POPUP_LOV_TEMPLATE','POPUP_ICON_ATTR2','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(221,'WWV_FLOW_POPUP_LOV_TEMPLATE','PREV_BUTTON_ATTR','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(222,'WWV_FLOW_ROW_TEMPLATES','AFTER_COLUMN_HEADING','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(223,'WWV_FLOW_ROW_TEMPLATES','BEFORE_COLUMN_HEADING','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(224,'WWV_FLOW_CAL_TEMPLATES','DAILY_DAY_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(225,'WWV_FLOW_CAL_TEMPLATES','DAILY_DAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(226,'WWV_FLOW_CAL_TEMPLATES','DAILY_DAY_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(227,'WWV_FLOW_CAL_TEMPLATES','DAILY_HOUR_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(228,'WWV_FLOW_CAL_TEMPLATES','DAILY_HOUR_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(229,'WWV_FLOW_CAL_TEMPLATES','DAILY_TIME_CLOSE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(230,'WWV_FLOW_CAL_TEMPLATES','DAILY_TIME_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(231,'WWV_FLOW_CAL_TEMPLATES','DAILY_TIME_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(232,'WWV_FLOW_CAL_TEMPLATES','DAILY_TODAY_OPEN_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(233,'WWV_FLOW_CAL_TEMPLATES','WEEK_TITLE_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(234,'WWV_FLOW_PAGE_PLUG_TEMPLATES','SUB_PLUG_HEADER_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(235,'WWV_FLOW_PAGE_PLUG_TEMPLATES','SUB_PLUG_HEADER_ENTRY_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(236,'WWV_FLOW_PAGE_PLUG_TEMPLATES','SUB_PLUG_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(237,'WWV_FLOW_PLUGINS','DISPLAY_NAME','ID','FLOW_ID','','VARCHAR2','N','');
    ins(238,'WWV_FLOW_PLUGINS','HELP_TEXT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(239,'WWV_FLOW_PLUGIN_ATTRIBUTES','PROMPT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(240,'WWV_FLOW_PLUGIN_ATTRIBUTES','HELP_TEXT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(241,'WWV_FLOW_PLUGIN_EVENTS','DISPLAY_NAME','ID','FLOW_ID','','VARCHAR2','N','');
    ins(242,'WWV_FLOW_PLUGIN_ATTR_VALUES','DISPLAY_VALUE','ID','FLOW_ID','','VARCHAR2','N','');
    ins(256,'WWV_FLOW_PLUGINS','SQL_EXAMPLES','ID','FLOW_ID','','VARCHAR2','N','');
    ins(257,'WWV_FLOW_SECURITY_SCHEMES','ERROR_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Error message of an authorization scheme');
    ins(258,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_01','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 1.');
    ins(259,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_02','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 2.');
    ins(260,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_03','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 3.');
    ins(261,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_04','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 4.');
    ins(262,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_05','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 5.');
    ins(263,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_06','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 6.');
    ins(264,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_07','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 7.');
    ins(265,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_08','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 8.');
    ins(266,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_09','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 9.');
    ins(267,'WWV_FLOW_STEP_ITEMS','QUICK_PICK_LABEL_10','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Quick Pick Label 10.');
    ins(268,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_01','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 1.');
    ins(269,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_02','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 2.');
    ins(270,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_03','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 3.');
    ins(271,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_04','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 4.');
    ins(272,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_05','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 5.');
    ins(273,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_06','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 6.');
    ins(274,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_07','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 7.');
    ins(275,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_08','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 8.');
    ins(276,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_09','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 9.');
    ins(277,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_10','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 10.');
    ins(278,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_01','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 1.');
    ins(279,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_02','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 2.');
    ins(280,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_03','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 3.');
    ins(281,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_04','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 4.');
    ins(282,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_05','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 5.');
    ins(283,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_06','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 6.');
    ins(284,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_07','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 7.');
    ins(285,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_08','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 8.');
    ins(286,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_09','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 9.');
    ins(287,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_10','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 10.');
    ins(288,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_01','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 1.');
    ins(289,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_02','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 2.');
    ins(290,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_03','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 3.');
    ins(291,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_04','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 4.');
    ins(292,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_05','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 5.');
    ins(293,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_06','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 6.');
    ins(294,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_07','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 7.');
    ins(295,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_08','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 8.');
    ins(296,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_09','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 9.');
    ins(297,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_10','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 10.');
    ins(298,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_01','ID','FLOW_ID','','VARCHAR2','N','Attribute 1.');
    ins(299,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_02','ID','FLOW_ID','','VARCHAR2','N','Attribute 2.');
    ins(300,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_03','ID','FLOW_ID','','VARCHAR2','N','Attribute 3.');
    ins(301,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_04','ID','FLOW_ID','','VARCHAR2','N','Attribute 4.');
    ins(302,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_05','ID','FLOW_ID','','VARCHAR2','N','Attribute 5.');
    ins(303,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_06','ID','FLOW_ID','','VARCHAR2','N','Attribute 6.');
    ins(304,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_07','ID','FLOW_ID','','VARCHAR2','N','Attribute 7.');
    ins(305,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_08','ID','FLOW_ID','','VARCHAR2','N','Attribute 8.');
    ins(306,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_09','ID','FLOW_ID','','VARCHAR2','N','Attribute 9.');
    ins(307,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_10','ID','FLOW_ID','','VARCHAR2','N','Attribute 10.');
    ins(308,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_01','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 1.');
    ins(309,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_02','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 2.');
    ins(310,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_03','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 3.');
    ins(311,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_04','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 4.');
    ins(312,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_05','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 5.');
    ins(313,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_06','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 6.');
    ins(314,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_07','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 7.');
    ins(315,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_08','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 8.');
    ins(316,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_09','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 9.');
    ins(317,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_10','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 10.');
    ins(318,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_11','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 11.');
    ins(319,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_12','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 12.');
    ins(320,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_13','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 13.');
    ins(321,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_14','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 14.');
    ins(322,'WWV_FLOW_STEP_ITEMS','ATTRIBUTE_15','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 15.');
    ins(323,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_11','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 11.');
    ins(324,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_12','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 12.');
    ins(325,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_13','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 13.');
    ins(326,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_14','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 14.');
    ins(327,'WWV_FLOW_STEP_PROCESSING','ATTRIBUTE_15','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Attribute 15.');
    ins(328,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_11','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 11.');
    ins(329,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_12','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 12.');
    ins(330,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_13','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 13.');
    ins(331,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_14','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 14.');
    ins(332,'WWV_FLOW_PAGE_DA_ACTIONS','ATTRIBUTE_15','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 15.');
    ins(333,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_11','ID','FLOW_ID','','VARCHAR2','N','Attribute 11.');
    ins(334,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_12','ID','FLOW_ID','','VARCHAR2','N','Attribute 12.');
    ins(335,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_13','ID','FLOW_ID','','VARCHAR2','N','Attribute 13.');
    ins(336,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_14','ID','FLOW_ID','','VARCHAR2','N','Attribute 14.');
    ins(337,'WWV_FLOW_PLUGIN_SETTINGS','ATTRIBUTE_15','ID','FLOW_ID','','VARCHAR2','N','Attribute 15.');
    ins(338,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_11','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 11.');
    ins(339,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_12','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 12.');
    ins(340,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_13','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 13.');
    ins(341,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_14','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 14.');
    ins(342,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_15','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 15.');
    ins(343,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_01','ID','FLOW_ID','','VARCHAR2','N','Attribute 1.');
    ins(344,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_02','ID','FLOW_ID','','VARCHAR2','N','Attribute 2.');
    ins(345,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_03','ID','FLOW_ID','','VARCHAR2','N','Attribute 3.');
    ins(346,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_04','ID','FLOW_ID','','VARCHAR2','N','Attribute 4.');
    ins(347,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_05','ID','FLOW_ID','','VARCHAR2','N','Attribute 5.');
    ins(348,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_06','ID','FLOW_ID','','VARCHAR2','N','Attribute 6.');
    ins(349,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_07','ID','FLOW_ID','','VARCHAR2','N','Attribute 7.');
    ins(350,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_08','ID','FLOW_ID','','VARCHAR2','N','Attribute 8.');
    ins(351,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_09','ID','FLOW_ID','','VARCHAR2','N','Attribute 9.');
    ins(352,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_10','ID','FLOW_ID','','VARCHAR2','N','Attribute 10.');
    ins(353,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_11','ID','FLOW_ID','','VARCHAR2','N','Attribute 11.');
    ins(354,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_12','ID','FLOW_ID','','VARCHAR2','N','Attribute 12.');
    ins(355,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_13','ID','FLOW_ID','','VARCHAR2','N','Attribute 13.');
    ins(356,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_14','ID','FLOW_ID','','VARCHAR2','N','Attribute 14.');
    ins(357,'WWV_FLOW_SECURITY_SCHEMES','ATTRIBUTE_15','ID','FLOW_ID','','VARCHAR2','N','Attribute 15.');
    ins(358,'WWV_FLOW_LIST_ITEMS','LIST_ITEM_ICON_ALT_ATTRIBUTE','ID','FLOW_ID','','VARCHAR2','N','List Item Icon Alt Tag Text');
    ins(359,'WWV_FLOW_LOAD_TABLE_LOOKUPS','ERROR_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Error Message');
    ins(360,'WWV_FLOW_LOAD_TABLE_RULES','ERROR_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Error Message');
    ins(361,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_01','ID','FLOW_ID','','VARCHAR2','N','Attribute 1.');
    ins(362,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_02','ID','FLOW_ID','','VARCHAR2','N','Attribute 2.');
    ins(363,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_03','ID','FLOW_ID','','VARCHAR2','N','Attribute 3.');
    ins(364,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_04','ID','FLOW_ID','','VARCHAR2','N','Attribute 4.');
    ins(365,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_05','ID','FLOW_ID','','VARCHAR2','N','Attribute 5.');
    ins(366,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_06','ID','FLOW_ID','','VARCHAR2','N','Attribute 6.');
    ins(367,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_07','ID','FLOW_ID','','VARCHAR2','N','Attribute 7.');
    ins(368,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_08','ID','FLOW_ID','','VARCHAR2','N','Attribute 8.');
    ins(369,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_09','ID','FLOW_ID','','VARCHAR2','N','Attribute 9.');
    ins(370,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_10','ID','FLOW_ID','','VARCHAR2','N','Attribute 10.');
    ins(371,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_11','ID','FLOW_ID','','VARCHAR2','N','Attribute 11.');
    ins(372,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_12','ID','FLOW_ID','','VARCHAR2','N','Attribute 12.');
    ins(373,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_13','ID','FLOW_ID','','VARCHAR2','N','Attribute 13.');
    ins(374,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_14','ID','FLOW_ID','','VARCHAR2','N','Attribute 14.');
    ins(375,'WWV_FLOW_AUTHENTICATIONS','ATTRIBUTE_15','ID','FLOW_ID','','VARCHAR2','N','Attribute 15.');
    ins(376,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_01','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 1');
    ins(377,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_02','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 2');
    ins(378,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_03','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 3');
    ins(379,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_04','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 4');
    ins(380,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_05','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 5');
    ins(381,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_06','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 6');
    ins(382,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_07','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 7');
    ins(383,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_08','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 8');
    ins(384,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_09','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 9');
    ins(385,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_10','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 10');
    ins(386,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_11','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 11');
    ins(387,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_12','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 12');
    ins(388,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_13','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 13');
    ins(389,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_14','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 14');
    ins(390,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_15','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 15');
    ins(391,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_16','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 16');
    ins(392,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_17','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 17');
    ins(393,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_18','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 18');
    ins(394,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_19','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 19');
    ins(395,'WWV_FLOW_LIST_ITEMS','LIST_TEXT_20','ID','FLOW_ID','','VARCHAR2','N','Text Attribute 20');
    ins(396,'WWV_FLOW_STEP_ITEMS','PLACEHOLDER','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Page Item Placeholder.');
    ins(398,'WWV_FLOW_CAL_TEMPLATES','AGENDA_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(399,'WWV_FLOW_CAL_TEMPLATES','AGENDA_PAST_DAY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(400,'WWV_FLOW_CAL_TEMPLATES','AGENDA_TODAY_DAY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(401,'WWV_FLOW_CAL_TEMPLATES','AGENDA_FUTURE_DAY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(402,'WWV_FLOW_CAL_TEMPLATES','AGENDA_PAST_ENTRY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(403,'WWV_FLOW_CAL_TEMPLATES','AGENDA_TODAY_ENTRY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(404,'WWV_FLOW_CAL_TEMPLATES','AGENDA_FUTURE_ENTRY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(405,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_16','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 16.');
    ins(406,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_17','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 17.');
    ins(407,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_18','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 18.');
    ins(408,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_19','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 19.');
    ins(409,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_20','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 20.');
    ins(410,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_21','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 21.');
    ins(411,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_22','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 22.');
    ins(413,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_23','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 23.');
    ins(414,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_24','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 24.');
    ins(415,'WWV_FLOW_PAGE_PLUGS','ATTRIBUTE_25','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 25.');
    ins(416,'WWV_FLOW_PLUGIN_ATTRIBUTES','NULL_TEXT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(417,'WWV_FLOW_CAL_TEMPLATES','MONTH_DATA_ENTRY_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(418,'WWV_FLOW_CAL_TEMPLATES','MONTH_DATA_FORMAT','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(419,'WWV_FLOW_PLUGIN_ATTR_VALUES','HELP_TEXT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(420,'WWV_FLOW_PLUGIN_ATTRIBUTES','EXAMPLES','ID','FLOW_ID','','VARCHAR2','N','');
    ins(421,'WWV_FLOW_REGION_COLUMNS','HEADING','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Heading');
    ins(422,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_01','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 01.');
    ins(423,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_02','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 02.');
    ins(424,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_03','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 03.');
    ins(425,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_04','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 04.');
    ins(426,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_05','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 05.');
    ins(427,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_06','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 06.');
    ins(428,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_07','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 07.');
    ins(429,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_08','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 08.');
    ins(430,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_09','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 09.');
    ins(431,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_10','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 10.');
    ins(432,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_11','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 11.');
    ins(433,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_12','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 12.');
    ins(434,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_13','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 13.');
    ins(435,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_14','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 14.');
    ins(436,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_15','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 15.');
    ins(437,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_16','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 16.');
    ins(438,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_17','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 17.');
    ins(439,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_18','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 18.');
    ins(440,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_19','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 19.');
    ins(441,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_20','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 20.');
    ins(442,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_21','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 21.');
    ins(443,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_22','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 22.');
    ins(444,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_23','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 23.');
    ins(445,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_24','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 24.');
    ins(446,'WWV_FLOW_REGION_COLUMNS','ATTRIBUTE_25','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Attribute 25.');
    ins(447,'WWV_FLOW_PLUGIN_ATTRIBUTES','UNIT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(448,'WWV_FLOW_REGION_COLUMNS','LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','An alternative column label');
    ins(449,'WWV_FLOW_REGION_COLUMNS','ITEM_PLACEHOLDER','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','The hint text when no value for that item is entered');
    ins(450,'WWV_FLOW_REGION_COLUMNS','LOV_NULL_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Value displayed when null selected from LOV');
    ins(451,'WWV_FLOW_REGION_COLUMNS','LINK_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','The text to be shown as a link');
    ins(452,'WWV_FLOW_REGION_COLUMNS','HELP_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Help text for the column');
    ins(453,'WWV_FLOW_REGION_COLUMN_GROUPS','LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','An alternative group label');
    ins(454,'WWV_FLOW_REGION_COLUMN_GROUPS','HEADING','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Group heading text');
    ins(455,'WWV_FLOW_INTERACTIVE_GRIDS','NO_DATA_FOUND_MESSAGE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Message displayed when the query does not return any rows');
    ins(456,'WWV_FLOW_INTERACTIVE_GRIDS','MAX_ROW_COUNT_MESSAGE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Message displayed when more rows are returned from the query than the maximum row count entered');
    ins(457,'WWV_FLOW_INTERACTIVE_GRIDS','ADD_BUTTON_LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','An alternative label for the Add button');
    ins(458,'WWV_FLOW_STEP_ITEMS','INLINE_HELP_TEXT','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Item Inline help text.');
    ins(459,'WWV_FLOW_FIELD_TEMPLATES','ITEM_PRE_TEXT','ID','FLOW_ID','','VARCHAR2','Y','HTML template to format "Item Pre Test", typically does not include translatable text');
    ins(460,'WWV_FLOW_FIELD_TEMPLATES','ITEM_POST_TEXT','ID','FLOW_ID','','VARCHAR2','Y','HTML template to format "Item Post Test", typically does not include translatable text');
    ins(461,'WWV_FLOW_JET_CHARTS','TITLE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','JET chart title');
    ins(462,'WWV_FLOW_JET_CHARTS','LEGEND_TITLE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','JET chart legend title');
    ins(463,'WWV_FLOW_JET_CHARTS','NO_DATA_FOUND_MESSAGE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','JET chart query no data found message');
    ins(464,'WWV_FLOW_JET_CHARTS','CUSTOM_TOOLTIP','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','JET chart custom tooltip');
    ins(465,'WWV_FLOW_JET_CHART_AXES','TITLE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','JET chart axis title');
    ins(466,'WWV_FLOW_JET_CHART_SERIES','NAME','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','JET chart series name');
    ins(467,'WWV_FLOW_PLUGIN_STD_ATTRIBUTES','EXAMPLES','ID','FLOW_ID','','VARCHAR2','N','');
    ins(468,'WWV_FLOW_PLUGIN_STD_ATTRIBUTES','HELP_TEXT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(469,'WWV_FLOW_EMAIL_TEMPLATES','SUBJECT','ID','FLOW_ID','','VARCHAR2','N','');
    ins(470,'WWV_FLOW_EMAIL_TEMPLATES','HTML_BODY','ID','FLOW_ID','','VARCHAR2','N','');
    ins(471,'WWV_FLOW_EMAIL_TEMPLATES','HTML_HEADER','ID','FLOW_ID','','VARCHAR2','N','');
    ins(472,'WWV_FLOW_EMAIL_TEMPLATES','HTML_FOOTER','ID','FLOW_ID','','VARCHAR2','N','');
    ins(473,'WWV_FLOW_EMAIL_TEMPLATES','HTML_TEMPLATE','ID','FLOW_ID','','VARCHAR2','N','');
    ins(474,'WWV_FLOW_EMAIL_TEMPLATES','TEXT_TEMPLATE','ID','FLOW_ID','','VARCHAR2','N','');
    ins(475,'WWV_FLOW_LIST_OF_VALUES_COLS','HEADING','ID','FLOW_ID','','VARCHAR2','N','The heading used for the column in the dialog / popup');
    ins(476,'WWV_FLOWS','LOGO_TEXT','ID','ID','','VARCHAR2','N','Logo Text');
    ins(477,'WWV_FLOW_PAGE_PLUGS','SUPPLEMENTAL_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Text at the top of all download formats');
    ins(478,'WWV_FLOW_WORKSHEETS','SUPPLEMENTAL_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Text at the top of all download formats');
    ins(479,'WWV_FLOW_INTERACTIVE_GRIDS','SUPPLEMENTAL_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Text at the top of all download formats');
    ins(480,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_01','ID','FLOW_ID','','VARCHAR2','N','Attribute 1.');
    ins(481,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_02','ID','FLOW_ID','','VARCHAR2','N','Attribute 2.');
    ins(482,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_03','ID','FLOW_ID','','VARCHAR2','N','Attribute 3.');
    ins(483,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_04','ID','FLOW_ID','','VARCHAR2','N','Attribute 4.');
    ins(484,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_05','ID','FLOW_ID','','VARCHAR2','N','Attribute 5.');
    ins(485,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_06','ID','FLOW_ID','','VARCHAR2','N','Attribute 6.');
    ins(486,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_07','ID','FLOW_ID','','VARCHAR2','N','Attribute 7.');
    ins(487,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_08','ID','FLOW_ID','','VARCHAR2','N','Attribute 8.');
    ins(488,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_09','ID','FLOW_ID','','VARCHAR2','N','Attribute 9.');
    ins(489,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_10','ID','FLOW_ID','','VARCHAR2','N','Attribute 10.');
    ins(490,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_11','ID','FLOW_ID','','VARCHAR2','N','Attribute 11.');
    ins(491,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_12','ID','FLOW_ID','','VARCHAR2','N','Attribute 12.');
    ins(492,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_13','ID','FLOW_ID','','VARCHAR2','N','Attribute 13.');
    ins(493,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_14','ID','FLOW_ID','','VARCHAR2','N','Attribute 14.');
    ins(494,'WWV_FLOW_WEB_SRC_MODULES','ATTRIBUTE_15','ID','FLOW_ID','','VARCHAR2','N','Attribute 15.');
    ins(495,'WWV_FLOW_STEP_ITEM_GROUPS','LABEL','ID','FLOW_ID','FLOW_STEP_ID','VARCHAR2','N','Item Group label');
    --
    ins(496,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_01','ID','FLOW_ID','','VARCHAR2','N','Attribute 1.');
    ins(497,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_02','ID','FLOW_ID','','VARCHAR2','N','Attribute 2.');
    ins(498,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_03','ID','FLOW_ID','','VARCHAR2','N','Attribute 3.');
    ins(499,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_04','ID','FLOW_ID','','VARCHAR2','N','Attribute 4.');
    ins(500,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_05','ID','FLOW_ID','','VARCHAR2','N','Attribute 5.');
    ins(501,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_06','ID','FLOW_ID','','VARCHAR2','N','Attribute 6.');
    ins(502,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_07','ID','FLOW_ID','','VARCHAR2','N','Attribute 7.');
    ins(503,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_08','ID','FLOW_ID','','VARCHAR2','N','Attribute 8.');
    ins(504,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_09','ID','FLOW_ID','','VARCHAR2','N','Attribute 9.');
    ins(505,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_10','ID','FLOW_ID','','VARCHAR2','N','Attribute 10.');
    ins(506,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_11','ID','FLOW_ID','','VARCHAR2','N','Attribute 11.');
    ins(507,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_12','ID','FLOW_ID','','VARCHAR2','N','Attribute 12.');
    ins(508,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_13','ID','FLOW_ID','','VARCHAR2','N','Attribute 13.');
    ins(509,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_14','ID','FLOW_ID','','VARCHAR2','N','Attribute 14.');
    ins(510,'WWV_FLOW_AUTOMATION_ACTIONS','ATTRIBUTE_15','ID','FLOW_ID','','VARCHAR2','N','Attribute 15.');
    ins(511,'WWV_FLOW_AUTOMATION_ACTIONS','ERROR_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Action error message.');
    --
    ins(512,'WWV_FLOW_CARDS','ICON_DESCRIPTION','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Icon description');
    ins(513,'WWV_FLOW_CARDS','BADGE_LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Badge label');
    ins(514,'WWV_FLOW_CARDS','MEDIA_DESCRIPTION','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Media description');
    ins(515,'WWV_FLOW_CARDS','TITLE_HTML_EXPR','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Title HTML expression');
    ins(516,'WWV_FLOW_CARDS','SUB_TITLE_HTML_EXPR','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Subtitle HTML expression');
    ins(517,'WWV_FLOW_CARDS','BODY_HTML_EXPR','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Body HTML expression');
    ins(518,'WWV_FLOW_CARDS','SECOND_BODY_HTML_EXPR','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Secondary Body HTML expression');
    ins(519,'WWV_FLOW_CARDS','MEDIA_HTML_EXPR','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Media HTML expression');
    ins(520,'WWV_FLOW_CARD_ACTIONS','LABEL','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Button label');
    --
    ins(521,'WWV_FLOW_MAP_REGIONS',      'LEGEND_TITLE',           'ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Legend title');
    ins(522,'WWV_FLOW_MAP_REGIONS',      'COPYRIGHT_NOTICE',       'ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Copyright Notice');
    ins(523,'WWV_FLOW_MAP_REGION_LAYERS','NAME',                   'ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Name');
    ins(524,'WWV_FLOW_MAP_REGION_LAYERS','LABEL',                  'ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Label');
    ins(525,'WWV_FLOW_MAP_REGION_LAYERS','CLUSTER_TOOLTIP',        'ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Cluster Tooltip HTML expression');
    ins(526,'WWV_FLOW_MAP_REGION_LAYERS','TOOLTIP_HTML_EXPR',      'ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Tooltip HTML expression');
    ins(527,'WWV_FLOW_MAP_REGION_LAYERS','INFO_WINDOW_HTML_EXPR',  'ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Info Window HTML expression');
    ins(528,'WWV_FLOW_MAP_REGION_LAYERS','NO_DATA_FOUND_MESSAGE',  'ID','FLOW_ID','PAGE_ID','VARCHAR2','N','No Data Found Message');
    ins(529,'WWV_FLOW_MAP_REGION_LAYERS','MORE_DATA_FOUND_MESSAGE','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','More Data Found Message');
    --
    ins(530,'WWV_FLOW_PAGE_PLUG_TEMPLATES','IMAGE_TEMPLATE','ID','FLOW_ID','','VARCHAR2','Y','');
    ins(531,'WWV_FLOW_PAGE_PLUGS','REGION_IMAGE_ALT_TEXT','ID','FLOW_ID','PAGE_ID','VARCHAR2','N','Image accessible description');
    --
    ins(532,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_01',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 1.');
    ins(533,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_02',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 2.');
    ins(534,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_03',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 3.');
    ins(535,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_04',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 4.');
    ins(536,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_05',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 5.');
    ins(537,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_06',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 6.');
    ins(538,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_07',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 7.');
    ins(539,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_08',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 8.');
    ins(540,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_09',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 9.');
    ins(541,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_10',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 10.');
    ins(542,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_11',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 11.');
    ins(543,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_12',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 12.');
    ins(544,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_13',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 13.');
    ins(545,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_14',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 14.');
    ins(546,'WWV_FLOW_TASK_DEF_ACTIONS','ATTRIBUTE_15',   'ID','FLOW_ID','','VARCHAR2','N','Attribute 15.');
    ins(547,'WWV_FLOW_TASK_DEF_ACTIONS','ERROR_MESSAGE',  'ID','FLOW_ID','','VARCHAR2','N','Action error message.');
    ins(548,'WWV_FLOW_TASK_DEF_ACTIONS','SUCCESS_MESSAGE','ID','FLOW_ID','','VARCHAR2','N','Action success message.');
    --
    ins(549,'WWV_FLOW_TASK_DEFS','NAME','ID','FLOW_ID','','VARCHAR2','N','Task Definition Name.');
    ins(550,'WWV_FLOW_TASK_DEF_PARAMS','LABEL','ID','FLOW_ID','','VARCHAR2','N','Task Parameter Label.');

    flush;
    commit;
end;
/

prompt
prompt ...insert into wwv_flow_sw_sqlplus_cmd
prompt

delete wwv_flow_sw_sqlplus_cmd
/

insert into wwv_flow_sw_sqlplus_cmd
values('PROMPT')
/
insert into wwv_flow_sw_sqlplus_cmd
values('SET')
/
insert into wwv_flow_sw_sqlplus_cmd
values('SPOOL')
/
insert into wwv_flow_sw_sqlplus_cmd
values('SHOW')
/
insert into wwv_flow_sw_sqlplus_cmd
values('REM')
/
insert into wwv_flow_sw_sqlplus_cmd
values('/')
/
insert into wwv_flow_sw_sqlplus_cmd
values('@@')
/
insert into wwv_flow_sw_sqlplus_cmd
values('WHENEVER')
/
commit
/


prompt
prompt ...insert into wwv_flow_sw_main_keywords
prompt

declare
    procedure ins_kw (
        p_id         in wwv_flow_sw_main_keywords.id%type,
        p_keyword    in wwv_flow_sw_main_keywords.keyword%type,
        p_stmt_class in wwv_flow_sw_main_keywords.stmt_class%type,
        p_stmt_id    in wwv_flow_sw_main_keywords.stmt_id%type,
        p_isrunnable in wwv_flow_sw_main_keywords.isrunnable%type )
    is
    begin
        insert into wwv_flow_sw_main_keywords (id, keyword, stmt_class, stmt_id, isrunnable )
        values (p_id, p_keyword, p_stmt_class, p_stmt_id, p_isrunnable );
    end ins_kw;
begin
    delete from wwv_flow_sw_main_keywords;
    ins_kw(1   , 'REM'          , 4 /* G_C_SQLPLUS */         , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(2   , 'INSERT'       , 2 /* G_C_SQL */             , 48 /* G_S_INSERT */        , 'Y');
    ins_kw(3   , 'CREATE'       , 10 /* G_C_UNKNOWN_CREATE */ , 1 /* G_S_UNKNOWN */        , 'N');
    ins_kw(4   , 'DROP'         , 2 /* G_C_SQL */             , 35 /* G_S_DROP */          , 'Y');
    ins_kw(5   , 'GRANT'        , 2 /* G_C_SQL */             , 43 /* G_S_GRANT */         , 'Y');
    ins_kw(6   , 'ALTER'        , 2 /* G_C_SQL */             , 3 /* G_S_ALTER */          , 'Y');
    ins_kw(7   , 'SELECT'       , 2 /* G_C_SQL */             , 72 /* G_S_SELECT */        , 'Y');
    ins_kw(8   , 'UPDATE'       , 2 /* G_C_SQL */             , 88 /* G_S_UPDATE */        , 'Y');
    ins_kw(9   , 'BEGIN'        , 3 /* G_C_PLSQL */           , 12 /* G_S_BEGIN */         , 'Y');
    ins_kw(10  , 'DECLARE'      , 3 /* G_C_PLSQL */           , 28 /* G_S_DECLARE */       , 'Y');
    ins_kw(11  , 'DELETE'       , 2 /* G_C_SQL */             , 31 /* G_S_DELETE */        , 'Y');
    ins_kw(12  , 'COL'          , 4 /* G_C_SQLPLUS */         , 19 /* G_S_COLUMN */        , 'N');
    ins_kw(13  , 'COLU'         , 4 /* G_C_SQLPLUS */         , 19 /* G_S_COLUMN */        , 'N');
    ins_kw(14  , 'COLUM'        , 4 /* G_C_SQLPLUS */         , 19 /* G_S_COLUMN */        , 'N');
    ins_kw(15  , 'COLUMN'       , 4 /* G_C_SQLPLUS */         , 19 /* G_S_COLUMN */        , 'N');
    ins_kw(16  , 'SET'          , 9 /* G_C_UNKNOWN_SET */     , 1 /* G_S_UNKNOWN */        , 'N');
    ins_kw(17  , 'VAR'          , 4 /* G_C_SQLPLUS */         , 90 /* G_S_VARIABLE */      , 'N');
    ins_kw(18  , 'VARI'         , 4 /* G_C_SQLPLUS */         , 90 /* G_S_VARIABLE */      , 'N');
    ins_kw(19  , 'VARIA'        , 4 /* G_C_SQLPLUS */         , 90 /* G_S_VARIABLE */      , 'N');
    ins_kw(20  , 'VARIAB'       , 4 /* G_C_SQLPLUS */         , 90 /* G_S_VARIABLE */      , 'N');
    ins_kw(21  , 'VARIABL'      , 4 /* G_C_SQLPLUS */         , 90 /* G_S_VARIABLE */      , 'N');
    ins_kw(22  , 'VARIABLE'     , 4 /* G_C_SQLPLUS */         , 90 /* G_S_VARIABLE */      , 'N');
    ins_kw(23  , 'PRO'          , 4 /* G_C_SQLPLUS */         , 59 /* G_S_PROMPT */        , 'N');
    ins_kw(24  , 'PROM'         , 4 /* G_C_SQLPLUS */         , 59 /* G_S_PROMPT */        , 'N');
    ins_kw(25  , 'PROMP'        , 4 /* G_C_SQLPLUS */         , 59 /* G_S_PROMPT */        , 'N');
    ins_kw(26  , 'PROMPT'       , 4 /* G_C_SQLPLUS */         , 59 /* G_S_PROMPT */        , 'N');
    ins_kw(27  , 'EXEC'         , 4 /* G_C_SQLPLUS */         , 37 /* G_S_EXECUTE */       , 'N');
    ins_kw(28  , 'EXECU'        , 4 /* G_C_SQLPLUS */         , 37 /* G_S_EXECUTE */       , 'N');
    ins_kw(29  , 'EXECUT'       , 4 /* G_C_SQLPLUS */         , 37 /* G_S_EXECUTE */       , 'N');
    ins_kw(30  , 'EXECUTE'      , 4 /* G_C_SQLPLUS */         , 37 /* G_S_EXECUTE */       , 'N');
    ins_kw(31  , 'SHO'          , 4 /* G_C_SQLPLUS */         , 75 /* G_S_SHOW */          , 'N');
    ins_kw(32  , 'SHOW'         , 4 /* G_C_SQLPLUS */         , 75 /* G_S_SHOW */          , 'N');
    ins_kw(33  , 'WHENEVER'     , 4 /* G_C_SQLPLUS */         , 91 /* G_S_WHENEVER */      , 'N');
    ins_kw(34  , 'SPO'          , 4 /* G_C_SQLPLUS */         , 78 /* G_S_SPOOL */         , 'N');
    ins_kw(35  , 'SPOO'         , 4 /* G_C_SQLPLUS */         , 78 /* G_S_SPOOL */         , 'N');
    ins_kw(36  , 'SPOOL'        , 4 /* G_C_SQLPLUS */         , 78 /* G_S_SPOOL */         , 'N');
    ins_kw(37  , 'DEF'          , 4 /* G_C_SQLPLUS */         , 29 /* G_S_DEFINE */        , 'N');
    ins_kw(38  , 'DEFI'         , 4 /* G_C_SQLPLUS */         , 29 /* G_S_DEFINE */        , 'N');
    ins_kw(39  , 'DEFIN'        , 4 /* G_C_SQLPLUS */         , 29 /* G_S_DEFINE */        , 'N');
    ins_kw(40  , 'DEFINE'       , 4 /* G_C_SQLPLUS */         , 29 /* G_S_DEFINE */        , 'N');
    ins_kw(41  , 'STA'          , 4 /* G_C_SQLPLUS */         , 81 /* G_S_START */         , 'Y');
    ins_kw(42  , 'STAR'         , 4 /* G_C_SQLPLUS */         , 81 /* G_S_START */         , 'Y');
    ins_kw(43  , 'START'        , 4 /* G_C_SQLPLUS */         , 81 /* G_S_START */         , 'Y');
    ins_kw(44  , 'BRE'          , 4 /* G_C_SQLPLUS */         , 14 /* G_S_BREAK */         , 'N');
    ins_kw(45  , 'BREA'         , 4 /* G_C_SQLPLUS */         , 14 /* G_S_BREAK */         , 'N');
    ins_kw(46  , 'BREAK'        , 4 /* G_C_SQLPLUS */         , 14 /* G_S_BREAK */         , 'N');
    ins_kw(47  , 'COMP'         , 4 /* G_C_SQLPLUS */         , 23 /* G_S_COMPUTE */       , 'N');
    ins_kw(48  , 'COMPU'        , 4 /* G_C_SQLPLUS */         , 23 /* G_S_COMPUTE */       , 'N');
    ins_kw(49  , 'COMPUT'       , 4 /* G_C_SQLPLUS */         , 23 /* G_S_COMPUTE */       , 'N');
    ins_kw(50  , 'COMPUTE'      , 4 /* G_C_SQLPLUS */         , 23 /* G_S_COMPUTE */       , 'N');
    ins_kw(51  , 'CONN'         , 4 /* G_C_SQLPLUS */         , 24 /* G_S_CONNECT */       , 'N');
    ins_kw(52  , 'CONNE'        , 4 /* G_C_SQLPLUS */         , 24 /* G_S_CONNECT */       , 'N');
    ins_kw(53  , 'CONNEC'       , 4 /* G_C_SQLPLUS */         , 24 /* G_S_CONNECT */       , 'N');
    ins_kw(54  , 'CONNECT'      , 4 /* G_C_SQLPLUS */         , 24 /* G_S_CONNECT */       , 'N');
    ins_kw(55  , 'EXIT'         , 4 /* G_C_SQLPLUS */         , 39 /* G_S_EXIT */          , 'N');
    ins_kw(56  , 'QUIT'         , 4 /* G_C_SQLPLUS */         , 61 /* G_S_QUIT */          , 'N');
    ins_kw(57  , 'DESC'         , 4 /* G_C_SQLPLUS */         , 32 /* G_S_DESCRIBE */      , 'N');
    ins_kw(58  , 'DESCR'        , 4 /* G_C_SQLPLUS */         , 32 /* G_S_DESCRIBE */      , 'N');
    ins_kw(59  , 'DESCRI'       , 4 /* G_C_SQLPLUS */         , 32 /* G_S_DESCRIBE */      , 'N');
    ins_kw(60  , 'DESCRIB'      , 4 /* G_C_SQLPLUS */         , 32 /* G_S_DESCRIBE */      , 'N');
    ins_kw(61  , 'DESCRIBE'     , 4 /* G_C_SQLPLUS */         , 32 /* G_S_DESCRIBE */      , 'N');
    ins_kw(62  , 'FLASHBACK'    , 2 /* G_C_SQL */             , 41 /* G_S_FLASHBACK */     , 'N');
    ins_kw(63  , 'COMMIT'       , 2 /* G_C_SQL */             , 21 /* G_S_COMMIT */        , 'Y');
    ins_kw(64  , 'ROLLBACK'     , 2 /* G_C_SQL */             , 68 /* G_S_ROLLBACK_SQL */  , 'Y');
    ins_kw(65  , 'CALL'         , 2 /* G_C_SQL */             , 16 /* G_S_CALL */          , 'N');
    ins_kw(66  , 'LOCK'         , 2 /* G_C_SQL */             , 50 /* G_S_LOCK */          , 'N');
    ins_kw(67  , 'MERGE'        , 2 /* G_C_SQL */             , 51 /* G_S_MERGE */         , 'Y');
    ins_kw(68  , 'PURGE'        , 2 /* G_C_SQL */             , 60 /* G_S_PURGE */         , 'N');
    ins_kw(69  , 'EXPLAIN'      , 2 /* G_C_SQL */             , 40 /* G_S_EXPLAIN */       , 'N');
    ins_kw(70  , 'ANALYZE'      , 2 /* G_C_SQL */             , 4 /* G_S_ANALYZE */        , 'Y');
    ins_kw(71  , 'VALIDATE'     , 2 /* G_C_SQL */             , 89 /* G_S_VALIDATE */      , 'N');
    ins_kw(72  , 'TRUNCATE'     , 2 /* G_C_SQL */             , 85 /* G_S_TRUNCATE */      , 'Y');
    ins_kw(73  , 'WITH'         , 2 /* G_C_SQL */             , 92 /* G_S_WITH */          , 'Y');
    ins_kw(74  , 'REVOKE'       , 2 /* G_C_SQL */             , 66 /* G_S_REVOKE */        , 'Y');
    ins_kw(75  , 'RENAME'       , 2 /* G_C_SQL */             , 63 /* G_S_RENAME */        , 'N');
    ins_kw(76  , 'SAVEPOINT'    , 2 /* G_C_SQL */             , 71 /* G_S_SAVEPOINT */     , 'N');
    ins_kw(77  , 'AUDIT'        , 2 /* G_C_SQL */             , 11 /* G_S_AUDIT */         , 'N');
    ins_kw(78  , 'NOAUDIT'      , 2 /* G_C_SQL */             , 53 /* G_S_NOAUDIT */       , 'N');
    ins_kw(79  , 'ASSOCIATE'    , 2 /* G_C_SQL */             , 7 /* G_S_ASSOCIATE */      , 'N');
    ins_kw(80  , 'DISASSOCIATE' , 2 /* G_C_SQL */             , 33 /* G_S_DISASSOCIATE */  , 'N');
    ins_kw(81  , 'EXPAND'       , 2 /* G_C_SQL */             , 38 /* G_S_EXPAND */        , 'N');
    ins_kw(82  , 'COMMENT'      , 2 /* G_C_SQL */             , 20 /* G_S_COMMENT_SQL */   , 'Y');
    ins_kw(83  , 'XQUERY'       , 3 /* G_C_PLSQL */           , 93 /* G_S_XQUERY */        , 'N');
    ins_kw(84  , 'COPY'         , 4 /* G_C_SQLPLUS */         , 25 /* G_S_COPY */          , 'N');
    ins_kw(85  , 'DISC'         , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(86  , 'DISCO'        , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(87  , 'DISCON'       , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(88  , 'DISCONN'      , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(89  , 'DISCONNE'     , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(90  , 'DISCONNEC'    , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(91  , 'DISCONNECT'   , 4 /* G_C_SQLPLUS */         , 34 /* G_S_DISCONNECT */    , 'N');
    ins_kw(92  , 'TIMI'         , 4 /* G_C_SQLPLUS */         , 84 /* G_S_TIMING */        , 'N');
    ins_kw(93  , 'TIMIN'        , 4 /* G_C_SQLPLUS */         , 84 /* G_S_TIMING */        , 'N');
    ins_kw(94  , 'TIMING'       , 4 /* G_C_SQLPLUS */         , 84 /* G_S_TIMING */        , 'N');
    ins_kw(95  , 'GET'          , 4 /* G_C_SQLPLUS */         , 42 /* G_S_GET */           , 'N');
    ins_kw(96  , 'HELP'         , 4 /* G_C_SQLPLUS */         , 46 /* G_S_HELP */          , 'N');
    ins_kw(97  , 'PRINT'        , 4 /* G_C_SQLPLUS */         , 58 /* G_S_PRINT */         , 'N');
    ins_kw(98  , 'UNDEF'        , 4 /* G_C_SQLPLUS */         , 87 /* G_S_UNDEFINE */      , 'N');
    ins_kw(99  , 'UNDEFI'       , 4 /* G_C_SQLPLUS */         , 87 /* G_S_UNDEFINE */      , 'N');
    ins_kw(100 , 'UNDEFIN'      , 4 /* G_C_SQLPLUS */         , 87 /* G_S_UNDEFINE */      , 'N');
    ins_kw(101 , 'UNDEFINE'     , 4 /* G_C_SQLPLUS */         , 87 /* G_S_UNDEFINE */      , 'N');
    ins_kw(102 , 'TTI'          , 4 /* G_C_SQLPLUS */         , 86 /* G_S_TTITLE */        , 'N');
    ins_kw(103 , 'TTIT'         , 4 /* G_C_SQLPLUS */         , 86 /* G_S_TTITLE */        , 'N');
    ins_kw(104 , 'TTITL'        , 4 /* G_C_SQLPLUS */         , 86 /* G_S_TTITLE */        , 'N');
    ins_kw(105 , 'TTITLE'       , 4 /* G_C_SQLPLUS */         , 86 /* G_S_TTITLE */        , 'N');
    ins_kw(106 , 'BTI'          , 4 /* G_C_SQLPLUS */         , 15 /* G_S_BTITLE */        , 'N');
    ins_kw(107 , 'BTIT'         , 4 /* G_C_SQLPLUS */         , 15 /* G_S_BTITLE */        , 'N');
    ins_kw(108 , 'BTITL'        , 4 /* G_C_SQLPLUS */         , 15 /* G_S_BTITLE */        , 'N');
    ins_kw(109 , 'BTITLE'       , 4 /* G_C_SQLPLUS */         , 15 /* G_S_BTITLE */        , 'N');
    ins_kw(110 , 'REPF'         , 4 /* G_C_SQLPLUS */         , 64 /* G_S_REPFOOTER */     , 'N');
    ins_kw(111 , 'REPFO'        , 4 /* G_C_SQLPLUS */         , 64 /* G_S_REPFOOTER */     , 'N');
    ins_kw(112 , 'REPFOO'       , 4 /* G_C_SQLPLUS */         , 64 /* G_S_REPFOOTER */     , 'N');
    ins_kw(113 , 'REPFOOT'      , 4 /* G_C_SQLPLUS */         , 64 /* G_S_REPFOOTER */     , 'N');
    ins_kw(114 , 'REPFOOTE'     , 4 /* G_C_SQLPLUS */         , 64 /* G_S_REPFOOTER */     , 'N');
    ins_kw(115 , 'REPFOOTER'    , 4 /* G_C_SQLPLUS */         , 64 /* G_S_REPFOOTER */     , 'N');
    ins_kw(116 , 'REPH'         , 4 /* G_C_SQLPLUS */         , 65 /* G_S_REPHEADER */     , 'N');
    ins_kw(117 , 'REPHE'        , 4 /* G_C_SQLPLUS */         , 65 /* G_S_REPHEADER */     , 'N');
    ins_kw(118 , 'REPHEA'       , 4 /* G_C_SQLPLUS */         , 65 /* G_S_REPHEADER */     , 'N');
    ins_kw(119 , 'REPHEAD'      , 4 /* G_C_SQLPLUS */         , 65 /* G_S_REPHEADER */     , 'N');
    ins_kw(120 , 'REPHEADE'     , 4 /* G_C_SQLPLUS */         , 65 /* G_S_REPHEADER */     , 'N');
    ins_kw(121 , 'REPHEADER'    , 4 /* G_C_SQLPLUS */         , 65 /* G_S_REPHEADER */     , 'N');
    ins_kw(122 , 'ATTR'         , 4 /* G_C_SQLPLUS */         , 10 /* G_S_ATTRIBUTE */     , 'N');
    ins_kw(123 , 'ATTRI'        , 4 /* G_C_SQLPLUS */         , 10 /* G_S_ATTRIBUTE */     , 'N');
    ins_kw(124 , 'ATTRIB'       , 4 /* G_C_SQLPLUS */         , 10 /* G_S_ATTRIBUTE */     , 'N');
    ins_kw(125 , 'ATTRIBU'      , 4 /* G_C_SQLPLUS */         , 10 /* G_S_ATTRIBUTE */     , 'N');
    ins_kw(126 , 'ATTRIBUT'     , 4 /* G_C_SQLPLUS */         , 10 /* G_S_ATTRIBUTE */     , 'N');
    ins_kw(127 , 'ATTRIBUTE'    , 4 /* G_C_SQLPLUS */         , 10 /* G_S_ATTRIBUTE */     , 'N');
    ins_kw(128 , 'STORE'        , 4 /* G_C_SQLPLUS */         , 83 /* G_S_STORE */         , 'N');
    ins_kw(129 , 'R'            , 4 /* G_C_SQLPLUS */         , 69 /* G_S_RUN */           , 'N');
    ins_kw(130 , 'RU'           , 4 /* G_C_SQLPLUS */         , 69 /* G_S_RUN */           , 'N');
    ins_kw(131 , 'RUN'          , 4 /* G_C_SQLPLUS */         , 69 /* G_S_RUN */           , 'N');
    ins_kw(132 , 'SAV'          , 4 /* G_C_SQLPLUS */         , 70 /* G_S_SAVE */          , 'N');
    ins_kw(133 , 'SAVE'         , 4 /* G_C_SQLPLUS */         , 70 /* G_S_SAVE */          , 'N');
    ins_kw(134 , 'ORADEBUG'     , 4 /* G_C_SQLPLUS */         , 54 /* G_S_ORADEBUG */      , 'N');
    ins_kw(135 , 'PASSW'        , 4 /* G_C_SQLPLUS */         , 55 /* G_S_PASSWORD */      , 'N');
    ins_kw(136 , 'PASSWO'       , 4 /* G_C_SQLPLUS */         , 55 /* G_S_PASSWORD */      , 'N');
    ins_kw(137 , 'PASSWOR'      , 4 /* G_C_SQLPLUS */         , 55 /* G_S_PASSWORD */      , 'N');
    ins_kw(138 , 'PASSWORD'     , 4 /* G_C_SQLPLUS */         , 55 /* G_S_PASSWORD */      , 'N');
    ins_kw(139 , 'PAU'          , 4 /* G_C_SQLPLUS */         , 56 /* G_S_PAUSE */         , 'N');
    ins_kw(140 , 'PAUS'         , 4 /* G_C_SQLPLUS */         , 56 /* G_S_PAUSE */         , 'N');
    ins_kw(141 , 'PAUSE'        , 4 /* G_C_SQLPLUS */         , 56 /* G_S_PAUSE */         , 'N');
    ins_kw(142 , 'REMA'         , 4 /* G_C_SQLPLUS */         , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(143 , 'REMAR'        , 4 /* G_C_SQLPLUS */         , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(144 , 'REMARK'       , 4 /* G_C_SQLPLUS */         , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(145 , 'HO'           , 4 /* G_C_SQLPLUS */         , 44 /* G_S_HOST */          , 'N');
    ins_kw(146 , 'HOS'          , 4 /* G_C_SQLPLUS */         , 44 /* G_S_HOST */          , 'N');
    ins_kw(147 , 'HOST'         , 4 /* G_C_SQLPLUS */         , 44 /* G_S_HOST */          , 'N');
    ins_kw(148 , 'ACC'          , 4 /* G_C_SQLPLUS */         , 2 /* G_S_ACCEPT */         , 'N');
    ins_kw(149 , 'ACCE'         , 4 /* G_C_SQLPLUS */         , 2 /* G_S_ACCEPT */         , 'N');
    ins_kw(150 , 'ACCEP'        , 4 /* G_C_SQLPLUS */         , 2 /* G_S_ACCEPT */         , 'N');
    ins_kw(151 , 'ACCEPT'       , 4 /* G_C_SQLPLUS */         , 2 /* G_S_ACCEPT */         , 'N');
    ins_kw(152 , 'ED'           , 4 /* G_C_SQLPLUS */         , 36 /* G_S_EDIT */          , 'N');
    ins_kw(153 , 'EDI'          , 4 /* G_C_SQLPLUS */         , 36 /* G_S_EDIT */          , 'N');
    ins_kw(154 , 'EDIT'         , 4 /* G_C_SQLPLUS */         , 36 /* G_S_EDIT */          , 'N');
    ins_kw(155 , 'A'            , 4 /* G_C_SQLPLUS */         , 5 /* G_S_APPEND */         , 'N');
    ins_kw(156 , 'AP'           , 4 /* G_C_SQLPLUS */         , 5 /* G_S_APPEND */         , 'N');
    ins_kw(157 , 'APP'          , 4 /* G_C_SQLPLUS */         , 5 /* G_S_APPEND */         , 'N');
    ins_kw(158 , 'APPE'         , 4 /* G_C_SQLPLUS */         , 5 /* G_S_APPEND */         , 'N');
    ins_kw(159 , 'APPEN'        , 4 /* G_C_SQLPLUS */         , 5 /* G_S_APPEND */         , 'N');
    ins_kw(160 , 'APPEND'       , 4 /* G_C_SQLPLUS */         , 5 /* G_S_APPEND */         , 'N');
    ins_kw(161 , 'C'            , 4 /* G_C_SQLPLUS */         , 17 /* G_S_CHANGE */        , 'N');
    ins_kw(162 , 'CH'           , 4 /* G_C_SQLPLUS */         , 17 /* G_S_CHANGE */        , 'N');
    ins_kw(163 , 'CHA'          , 4 /* G_C_SQLPLUS */         , 17 /* G_S_CHANGE */        , 'N');
    ins_kw(164 , 'CHAN'         , 4 /* G_C_SQLPLUS */         , 17 /* G_S_CHANGE */        , 'N');
    ins_kw(165 , 'CHANG'        , 4 /* G_C_SQLPLUS */         , 17 /* G_S_CHANGE */        , 'N');
    ins_kw(166 , 'CHANGE'       , 4 /* G_C_SQLPLUS */         , 17 /* G_S_CHANGE */        , 'N');
    ins_kw(167 , 'CL'           , 4 /* G_C_SQLPLUS */         , 18 /* G_S_CLEAR */         , 'N');
    ins_kw(168 , 'CLE'          , 4 /* G_C_SQLPLUS */         , 18 /* G_S_CLEAR */         , 'N');
    ins_kw(169 , 'CLEA'         , 4 /* G_C_SQLPLUS */         , 18 /* G_S_CLEAR */         , 'N');
    ins_kw(170 , 'CLEAR'        , 4 /* G_C_SQLPLUS */         , 18 /* G_S_CLEAR */         , 'N');
    ins_kw(171 , 'I'            , 4 /* G_C_SQLPLUS */         , 47 /* G_S_INPUT */         , 'N');
    ins_kw(172 , 'IN'           , 4 /* G_C_SQLPLUS */         , 47 /* G_S_INPUT */         , 'N');
    ins_kw(173 , 'INP'          , 4 /* G_C_SQLPLUS */         , 47 /* G_S_INPUT */         , 'N');
    ins_kw(174 , 'INPU'         , 4 /* G_C_SQLPLUS */         , 47 /* G_S_INPUT */         , 'N');
    ins_kw(175 , 'INPUT'        , 4 /* G_C_SQLPLUS */         , 47 /* G_S_INPUT */         , 'N');
    ins_kw(176 , 'L'            , 4 /* G_C_SQLPLUS */         , 49 /* G_S_LIST */          , 'N');
    ins_kw(177 , 'LI'           , 4 /* G_C_SQLPLUS */         , 49 /* G_S_LIST */          , 'N');
    ins_kw(178 , 'LIS'          , 4 /* G_C_SQLPLUS */         , 49 /* G_S_LIST */          , 'N');
    ins_kw(179 , 'LIST'         , 4 /* G_C_SQLPLUS */         , 49 /* G_S_LIST */          , 'N');
    ins_kw(180 , 'DEL'          , 4 /* G_C_SQLPLUS */         , 30 /* G_S_DEL_PLUS */      , 'N');
    ins_kw(181 , 'ARCHIVE'      , 4 /* G_C_SQLPLUS */         , 6 /* G_S_ARCHIVE */        , 'N');
    ins_kw(182 , 'SHU'          , 4 /* G_C_SQLPLUS */         , 76 /* G_S_SHUTDOWN */      , 'N');
    ins_kw(183 , 'SHUT'         , 4 /* G_C_SQLPLUS */         , 76 /* G_S_SHUTDOWN */      , 'N');
    ins_kw(184 , 'SHUTD'        , 4 /* G_C_SQLPLUS */         , 76 /* G_S_SHUTDOWN */      , 'N');
    ins_kw(185 , 'SHUTDOW'      , 4 /* G_C_SQLPLUS */         , 76 /* G_S_SHUTDOWN */      , 'N');
    ins_kw(186 , 'SHUTDOWN'     , 4 /* G_C_SQLPLUS */         , 76 /* G_S_SHUTDOWN */      , 'N');
    ins_kw(187 , 'STARTUP'      , 4 /* G_C_SQLPLUS */         , 82 /* G_S_STARTUP */       , 'N');
    ins_kw(188 , 'RECOVER'      , 4 /* G_C_SQLPLUS */         , 62 /* G_S_RECOVER */       , 'N');
    ins_kw(189 , 'DOC'          , 8 /* G_C_OLDCOMMENT */      , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(190 , 'DOCU'         , 8 /* G_C_OLDCOMMENT */      , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(191 , 'DOCUM'        , 8 /* G_C_OLDCOMMENT */      , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(192 , 'DOCUME'       , 8 /* G_C_OLDCOMMENT */      , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(193 , 'DOCUMEN'      , 8 /* G_C_OLDCOMMENT */      , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(194 , 'DOCUMENT'     , 8 /* G_C_OLDCOMMENT */      , 22 /* G_S_COMMENT_PLUS */  , 'N');
    ins_kw(195 , 'ROLL'         , 4 /* G_C_SQLPLUS */         , 67 /* G_S_ROLLBACK_PLUS */ , 'N');
    ins_kw(196 , 'ROLLB'        , 4 /* G_C_SQLPLUS */         , 67 /* G_S_ROLLBACK_PLUS */ , 'N');
    ins_kw(197 , 'ROLLBA'       , 4 /* G_C_SQLPLUS */         , 67 /* G_S_ROLLBACK_PLUS */ , 'N');
    ins_kw(198 , 'ROLLBAC'      , 4 /* G_C_SQLPLUS */         , 67 /* G_S_ROLLBACK_PLUS */ , 'N');
    ins_kw(199 , 'NEWPAGE'      , 4 /* G_C_SQLPLUS */         , 52 /* G_S_NEWPAGE */       , 'N');
    commit;
end;
/

prompt
prompt ...insert into wwv_flow_charsets
prompt

declare
    procedure ins_cs (
        p_id           in wwv_flow_charsets.id%type,
        p_display_name in wwv_flow_charsets.display_name%type,
        p_iana_charset in wwv_flow_charsets.iana_charset%type,
        p_db_charset   in wwv_flow_charsets.db_charset%type )
    is
    begin
        insert into wwv_flow_charsets(id, display_name, iana_charset, db_charset )
        values (p_id, p_display_name, p_iana_charset, p_db_charset );
    end ins_cs;
begin
    delete from wwv_flow_charsets;
    ins_cs(1,'Arabic ISO-8859-6','iso-8859-6','AR8ISO8859P6');
    ins_cs(2, 'Arabic Windows 1256','windows-1256','AR8MSWIN1256');
    ins_cs(3, 'Chinese Big5','big5','ZHT16MSWIN950');
    ins_cs(4, 'Chinese GBK','gbk','ZHS16GBK');
    ins_cs(5, 'Cyrilic ISO-8859-5','iso-8859-5','CL8ISO8859P5');
    ins_cs(6, 'Cyrilic KOI8-R','koi8-r','CL8KOI8R');
    ins_cs(7, 'Cyrilic KOI8-U','koi8-u','CL8KOI8U');
    ins_cs(8, 'Cyrilic Windows 1251','windows-1251','CL8MSWIN1251');
    ins_cs(9, 'Eastern European ISO-8859-2','iso-8859-2','EE8ISO8859P2');
    ins_cs(10, 'Eastern European Windows 1250','windows-1250','EE8MSWIN1250');
    ins_cs(11, 'Greek ISO-8859-7','iso-8859-7','EL8ISO8859P7');
    ins_cs(12, 'Greek Windows 1253','windows-1253','EL8MSWIN1253');
    ins_cs(13, 'Hebrew ISO-8859-8-i','iso-8859-8-i','IW8ISO8859P8');
    ins_cs(14, 'Hebrew Windows 1255','windows-1255','IW8MSWIN1255');
    ins_cs(15, 'Japanese EUC','euc-jp','JA16EUC');
    ins_cs(16, 'Japanese Shift JIS','shift_jis','JA16SJIS');
    ins_cs(17, 'Korean EUC','euc-kr','KO16MSWIN949');
    ins_cs(18, 'Northern European ISO-8859-4','iso-8859-4','NEE8ISO8859P4');
    ins_cs(19, 'Northern European Windows 1257','windows-1257','BLT8MSWIN1257');
    ins_cs(20, 'Southern European ISO-8859-3','iso-8859-3','SE8ISO8859P3');
    ins_cs(21, 'Thai TIS-620','tis-620','TH8TISASCII');
    ins_cs(22, 'Turkish ISO-8859-9','iso-8859-9','WE8ISO8859P9');
    ins_cs(23, 'Turkish Windows 1254','windows-1254','TR8MSWIN1254');
    ins_cs(24, 'Unicode UTF-8','utf-8','AL32UTF8');
    ins_cs(25, 'Unicode UTF-16 Big Endian','utf-16be','AL16UTF16');
    ins_cs(26, 'Unicode UTF-16 Little Endian','utf-16le','AL16UTF16LE');
    ins_cs(27, 'Vietnamese Windows 1258','windows-1258','VN8MSWIN1258');
    ins_cs(28, 'Western European ISO-8859-1','iso-8859-1','WE8ISO8859P1');
    ins_cs(29, 'Western European ISO-8859-15','iso-8859-15','WE8ISO8859P15');
    ins_cs(30, 'Western European Windows 1252','windows-1252','WE8MSWIN1252');
    ins_cs(31, 'Chinese EUC','euc-tw','ZHT32EUC');
    ins_cs(32, 'US-ASCII','us-ascii','US7ASCII');
    commit;
end;
/

prompt
prompt ...insert into wwv_flow_standard_icons
prompt

declare
    procedure ins_icon (
        p_icon_name    in wwv_flow_standard_icons.icon_name%type,
        p_icon_size    in wwv_flow_standard_icons.icon_size%type,
        p_icon_library in wwv_flow_standard_icons.icon_library%type )
    is
    begin
        insert into wwv_flow_standard_icons(icon_name,icon_size,icon_library )
        values ( p_icon_name, p_icon_size, p_icon_library );
    end ins_icon;
begin
    delete from wwv_flow_standard_icons;
    --
    -- apex 3.1 16x16 images
    --
    ins_icon('blue_function_16x16.gif',16,'APEX');
    ins_icon('blue_folder_16x16.gif',16,'APEX');
    ins_icon('blue_info_16x16.gif',16,'APEX');
    ins_icon('edit_16x16.gif',16,'APEX');
    ins_icon('check2_16x16.gif',16,'APEX');
    ins_icon('attach_16x16.gif',16,'APEX');
    ins_icon('Fndtre_info_16x16.gif',16,'APEX');
    ins_icon('go_button_16x16.gif',16,'APEX');
    ins_icon('hs_infohidden_16x16.gif',16,'APEX');
    ins_icon('icon_button_16x16.gif',16,'APEX');
    ins_icon('icon_comp_16x16.gif',16,'APEX');
    ins_icon('icon_item_16x16.gif',16,'APEX');
    ins_icon('icon_page_16x16.gif',16,'APEX');
    ins_icon('icon_process_16x16.gif',16,'APEX');
    ins_icon('icon_region_16x16.gif',16,'APEX');
    ins_icon('icon_validation_16x16.gif',16,'APEX');
    ins_icon('idle_session_16x16.gif',16,'APEX');
    ins_icon('i_status_16x16.gif',16,'APEX');
    ins_icon('i_status_gray_16x16.gif',16,'APEX');
    ins_icon('inline_error_16x16.gif',16,'APEX');
    ins_icon('jtfuhide_16x16.gif',16,'APEX');
    ins_icon('jtfunexe_16x16.gif',16,'APEX');
    ins_icon('jtfupree_16x16.gif',16,'APEX');
    ins_icon('jtfushow_16x16.gif',16,'APEX');
    ins_icon('locks_16x16.gif',16,'APEX');
    ins_icon('long_trans_16x16.gif',16,'APEX');
    ins_icon('pkt_stats_16x16.gif',16,'APEX');
    ins_icon('pkt_studygu_16x16.gif',16,'APEX');
    ins_icon('pobcol_16x16.gif',16,'APEX');
    ins_icon('pobrow_16x16.gif',16,'APEX');
    ins_icon('icon_status_16x16.gif',16,'APEX');
    ins_icon('icon_status2_16x16.gif',16,'APEX');
    ins_icon('icon_status_red_16x16.gif',16,'APEX');
    ins_icon('rup_minus_dgray_16x16.gif',16,'APEX');
    ins_icon('rup_plus_dgray_16x16.gif',16,'APEX');
    ins_icon('small_chart_16x16.gif',16,'APEX');
    ins_icon('wwv_smprt_16x16.gif',16,'APEX');
    ins_icon('pencil16x16.gif',16,'APEX');
    --
    -- apex 3.1 140x90 images
    --
    ins_icon('wiz_blank_140x90.gif',140,'APEX');
    ins_icon('wiz_multiple_140x90.gif',140,'APEX');
    ins_icon('wiz_classic_report_140x90.gif',140,'APEX');
    ins_icon('wiz_flash_chart_140x90.gif',140,'APEX');
    ins_icon('wiz_calendar_140x90.gif',140,'APEX');
    ins_icon('wiz_access_ctrl_140x90.gif',140,'APEX');
    ins_icon('wiz_interactive_report_140x90.gif',140,'APEX');
    ins_icon('wiz_webservices_report_140x90.gif',140,'APEX');
    ins_icon('wiz_ez_report_140x90.gif',140,'APEX');
    ins_icon('wiz_tree_140x90.gif',140,'APEX');
    ins_icon('wiz_svg_chart_140x90.gif',140,'APEX');
    ins_icon('wiz_html_chart_140x90.gif',140,'APEX');
    ins_icon('wiz_help_140x90.gif',140,'APEX');
    ins_icon('wiz_plsql_140x90.gif',140,'APEX');
    ins_icon('wiz_ez_calendar_140x90.gif',140,'APEX');
    --
    -- apex 3.1 128x128 images
    --
    ins_icon('app_bx_128x128.png',128,'APEX');
    ins_icon('biz_users_bx_128x128.png',128,'APEX');
    ins_icon('bug_bx_128x128.png',128,'APEX');
    ins_icon('convert_bx_128x128.png',128,'APEX');
    ins_icon('doc_library_bx_128x128.png',128,'APEX');
    ins_icon('eba_tube_featured_bx_128x128.png',128,'APEX');
    ins_icon('issue_tracker_bx_128x128.png',128,'APEX');
    ins_icon('movie_bx_128x128.png',128,'APEX');
    ins_icon('page_bx_128x128.png',128,'APEX');
    ins_icon('ws_from_database.png',128,'APEX');
    ins_icon('ws_from_scratch.png',128,'APEX');
    ins_icon('ws_from_template.png',128,'APEX');
    ins_icon('blank_bx_128x128.png',128,'APEX');
    ins_icon('home_bx_128x128.png',128,'APEX');
    ins_icon('mail_bx_128x128.png',128,'APEX');
    ins_icon('globe_americas_bx_128x128.png',128,'APEX');
    ins_icon('recycle_bx_128x128.png',128,'APEX');
    ins_icon('bug_report_bx_128x128.png',128,'APEX');
    ins_icon('users_bx_128x128.png',128,'APEX');
    ins_icon('wizreport_bx_128x128.png',128,'APEX');
    ins_icon('paintbrush_bx_128x128.png',128,'APEX');
    ins_icon('report_w_globe_bx_128x128.png',128,'APEX');
    ins_icon('interactive_report_bx_128x128.png',128,'APEX');
    ins_icon('barchart_bx_128x128.png',128,'APEX');
    ins_icon('clusterchart_bx_128x128.png',128,'APEX');
    ins_icon('chart_bx_128x128.png',128,'APEX');
    ins_icon('monitor_bx_128x128.png',128,'APEX');
    ins_icon('db_grey_bx_128x128.png',128,'APEX');
    ins_icon('barchart2_bx_128x128.png',128,'APEX');
    ins_icon('clusterchart2_bx_128x128.png',128,'APEX');
    ins_icon('wizard_bx_128x128.png',128,'APEX');
    ins_icon('temperature_bx_128x128.png',128,'APEX');
    ins_icon('census_bx_128x128.png',128,'APEX');
    ins_icon('modern_printer_bx_128x128.png',128,'APEX');
    ins_icon('navigation_bx_128x128.png',128,'APEX');
    ins_icon('gear_bx_128x128.png',128,'APEX');
    ins_icon('law_bx_128x128.png',128,'APEX');
    ins_icon('buildings_bx_128x128.png',128,'APEX');
    ins_icon('address_book_bx_128x128.png',128,'APEX');
    ins_icon('addresses_bx_128x128.png',128,'APEX');
    ins_icon('biz_user_green_bx_128x128.png',128,'APEX');
    ins_icon('biz_user_red_bx_128x128.png',128,'APEX');
    ins_icon('biz_user_yellow_bx_128x128.png',128,'APEX');
    ins_icon('brush_bx_128x128.png',128,'APEX');
    ins_icon('calendar_bx_128x128.png',128,'APEX');
    ins_icon('camera_bx_128x128.png',128,'APEX');
    ins_icon('computer_bx_128x128.png',128,'APEX');
    ins_icon('dashboard_bx_128x128.png',128,'APEX');
    ins_icon('database_bx_128x128.png',128,'APEX');
    ins_icon('db_blue_bx_128x128.png',128,'APEX');
    ins_icon('discussion_bx_128x128.png',128,'APEX');
    ins_icon('display_bx_128x128.png',128,'APEX');
    ins_icon('download_bx_128x128.png',128,'APEX');
    ins_icon('eba_admin_bx_128x128.png',128,'APEX');
    ins_icon('eba_artwork_bx_128x128.png',128,'APEX');
    ins_icon('eba_checklist_bx_128x128.png',128,'APEX');
    ins_icon('eba_sales_products_bx_128x128.png',128,'APEX');
    ins_icon('eba_software_bx_128x128.png',128,'APEX');
    ins_icon('eba_timesheets_bx_128x128.png',128,'APEX');
    ins_icon('edit_bx_128x28.png',128,'APEX');
    ins_icon('filmroll_bx_128x128.png',128,'APEX');
    ins_icon('flashlight_bx_128x128.png',128,'APEX');
    ins_icon('folder_bx_128x128.png',128,'APEX');
    ins_icon('generate_bx_128x128.png',128,'APEX');
    ins_icon('globe_bx_128x128.png',128,'APEX');
    ins_icon('lightbulb_bx_128x128.png',128,'APEX');
    ins_icon('openbook_bx_128x128.png',128,'APEX');
    ins_icon('pencil_bx_128x128.png',128,'APEX');
    ins_icon('piechart_bx_128x128.png',128,'APEX');
    ins_icon('podcase_bx_128x128.png',128,'APEX');
    ins_icon('printer_bx_128x128.png',128,'APEX');
    ins_icon('report_bx_128x128.png',128,'APEX');
    ins_icon('shapes_bx_128x128.png',128,'APEX');
    ins_icon('shoppingcart_bx_128x128.png',128,'APEX');
    ins_icon('student_bx_128x128.png',128,'APEX');
    ins_icon('upload_bx_128x128.png',128,'APEX');
    ins_icon('faces128.png',128,'APEX');
    --
    -- apex 4.0 12x12 images
    --
    ins_icon('go-small.png',12,'APEX');
    ins_icon('edit-small.png',12,'APEX');
    ins_icon('add-small.png',12,'APEX');
    ins_icon('search-small.png',12,'APEX');
    ins_icon('minus-small.png',12,'APEX');
    ins_icon('edit-pencil-small.png',12,'APEX');
    --
    -- apex 4.0 128x128 images
    --
    ins_icon('menu-page-128.png',128,'APEX');
    ins_icon('menu-disk-128.png',128,'APEX');
    ins_icon('menu-add_hw-128.gif',128,'APEX');
    ins_icon('menu-add-page-128.png',128,'APEX');
    ins_icon('menu-admin-128.gif',128,'APEX');
    ins_icon('menu-app-128.png',128,'APEX');
    ins_icon('menu-appbuilder-128.gif',128,'APEX');
    ins_icon('menu-blank-128.gif',128,'APEX');
    ins_icon('menu-blank-128.png',128,'APEX');
    ins_icon('menu-bug-128.gif',128,'APEX');
    ins_icon('menu-camera-128.gif',128,'APEX');
    ins_icon('menu-calendar-128.png',128,'APEX');
    ins_icon('menu-change-log-128.png',128,'APEX');
    ins_icon('menu-chart-128.png',128,'APEX');
    ins_icon('menu-clipboard-128.gif',128,'APEX');
    ins_icon('menu-dashboard-128.gif',128,'APEX');
    ins_icon('menu-db-monitor-128.gif',128,'APEX');
    ins_icon('menu-dbmonitor-128.gif',128,'APEX');
    ins_icon('menu-discussion-128.gif',128,'APEX');
    ins_icon('menu-docs-128.gif',128,'APEX');
    ins_icon('menu-docsettings-128.gif',128,'APEX');
    ins_icon('menu-dynaction-128.png',128,'APEX');
    ins_icon('menu-expimp-128.gif',128,'APEX');
    ins_icon('menu-feedback-128.gif',128,'APEX');
    ins_icon('menu-globe-128.png',128,'APEX');
    ins_icon('menu-home-128.gif',128,'APEX');
    ins_icon('menu-instance-manage-128.gif',128,'APEX');
    ins_icon('menu-lightbulb-128.gif',128,'APEX');
    ins_icon('menu-mail-128.gif',128,'APEX');
    ins_icon('menu-megaphone-128.gif',128,'APEX');
    ins_icon('menu-nested-128.png',128,'APEX');
    ins_icon('menu-ob-128.gif',128,'APEX');
    ins_icon('menu-objects-128.png',128,'APEX');
    ins_icon('menu-page-dir-128.gif',128,'APEX');
    ins_icon('menu-pkg-128.gif',128,'APEX');
    ins_icon('menu-plugin-128.png',128,'APEX');
    ins_icon('menu-qb-128.gif',128,'APEX');
    ins_icon('menu-run-128.gif',128,'APEX');
    ins_icon('menu-shared-128.gif',128,'APEX');
    ins_icon('menu-sqlcmd-128.gif',128,'APEX');
    ins_icon('menu-sqlscripts-128.gif',128,'APEX');
    ins_icon('menu-sqlws-128.gif',128,'APEX');
    ins_icon('menu-supporting-obj-128.gif',128,'APEX');
    ins_icon('menu-tabform-128.png',128,'APEX');
    ins_icon('menu-tasks-128.gif',128,'APEX');
    ins_icon('menu-teamdev-128.gif',128,'APEX');
    ins_icon('menu-trash-128.gif',128,'APEX');
    ins_icon('menu-uidefaults-128.gif',128,'APEX');
    ins_icon('menu-users-128.gif',128,'APEX');
    ins_icon('menu-util-128.gif',128,'APEX');
    ins_icon('menu-webservice-128.png',128,'APEX');
    ins_icon('menu-websheets-128.gif',128,'APEX');
    ins_icon('menu-ws-add-128.gif',128,'APEX');
    ins_icon('menu-ws-info-128.png',128,'APEX');
    ins_icon('menu-ws-learn-128.png',128,'APEX');
    ins_icon('menu-ws-manage-128.gif',128,'APEX');
    --
    -- apex 4.0 64x64 images
    --
    ins_icon('bug_new_64.png',64,'APEX');
    --
    -- apex 3.1 64x64 images
    --
    ins_icon('address_book_wbg_64x64.png',64,'APEX');
    ins_icon('addresses_wbg_64x64.png',64,'APEX');
    ins_icon('flashlight_wbg_64x64.png',64,'APEX');
    ins_icon('pencil_wbg_64x64.png',64,'APEX');
    ins_icon('camera_wbg_64x64.png',64,'APEX');
    ins_icon('buildings_wbg_64x64.png',64,'APEX');
    ins_icon('eba_software_wbg_64x64.png',64,'APEX');
    ins_icon('eba_timesheets_wbg_64x64.png',64,'APEX');
    ins_icon('filmroll_wbg_64x64.png',64,'APEX');
    ins_icon('instructor_wbg_64x64.png',64,'APEX');
    ins_icon('generate_wbg_64x64.png',64,'APEX');
    ins_icon('law_wbg_64x64.png',64,'APEX');
    ins_icon('discussion_wbg_64x64.png',64,'APEX');
    ins_icon('trash_empty_64.gif',64,'APEX');
    ins_icon('shoppingcart_wbg_64x64.png',64,'APEX');
    ins_icon('alarm_bell_wbg_64x64.png',64,'APEX');
    ins_icon('compass_64.gif',64,'APEX');
    --
    -- apex 3.0 64x64 images
    --
    ins_icon('users_business_64.gif',64,'APEX');
    ins_icon('application_64.gif',64,'APEX');
    ins_icon('bug_64.gif',64,'APEX');
    ins_icon('calendar_64.gif',64,'APEX');
    ins_icon('client_64.gif',64,'APEX');
    ins_icon('db_64.gif',64,'APEX');
    ins_icon('key_64.gif',64,'APEX');
    ins_icon('disk_64.gif',64,'APEX');
    ins_icon('draw_64.gif',64,'APEX');
    ins_icon('edit_64.gif',64,'APEX');
    ins_icon('folder_64.gif',64,'APEX');
    ins_icon('globe_64.gif',64,'APEX');
    ins_icon('lightbulb_64.gif',64,'APEX');
    ins_icon('chart_line_64.gif',64,'APEX');
    ins_icon('lock_64.gif',64,'APEX');
    ins_icon('navigation_64.gif',64,'APEX');
    ins_icon('package_64.gif',64,'APEX');
    ins_icon('page_64.gif',64,'APEX');
    ins_icon('pdf_64.gif',64,'APEX');
    ins_icon('chart_pie_64.gif',64,'APEX');
    ins_icon('pin_64.gif',64,'APEX');
    ins_icon('search_64.gif',64,'APEX');
    ins_icon('server_64.gif',64,'APEX');
    ins_icon('shapes_64.gif',64,'APEX');
    ins_icon('spreadsheet_64.gif',64,'APEX');
    ins_icon('users_64.gif',64,'APEX');
    ins_icon('clipboard_64.gif',64,'APEX');
    ins_icon('info_64.gif',64,'APEX');
    ins_icon('prod_apex_64.gif',64,'APEX');
    ins_icon('download_64.gif',64,'APEX');
    ins_icon('memo_64.gif',64,'APEX');
    ins_icon('phone_64.gif',64,'APEX');
    ins_icon('todo_64.gif',64,'APEX');
    ins_icon('mail_64.gif',64,'APEX');
    ins_icon('prod_sqldev_64.gif',64,'APEX');
    ins_icon('news_64.gif',64,'APEX');
    ins_icon('bboard_64.gif',64,'APEX');
    ins_icon('books_64.gif',64,'APEX');
    ins_icon('chart_bar_64.gif',64,'APEX');
    ins_icon('trafficlight_64.gif',64,'APEX');
    ins_icon('folder_yellow_64.gif',64,'APEX');
    ins_icon('report_64.gif',64,'APEX');
    ins_icon('tabform_64.gif',64,'APEX');
    ins_icon('form_64.gif',64,'APEX');
    ins_icon('tree_64.gif',64,'APEX');
    ins_icon('dynamic_64.gif',64,'APEX');
    ins_icon('home_64.gif',64,'APEX');
    ins_icon('login_64.gif',64,'APEX');
    ins_icon('calendar_page_64.gif',64,'APEX');
    ins_icon('chart_page_64.gif',64,'APEX');
    ins_icon('global_64.gif',64,'APEX');
    ins_icon('navigation_page_64.gif',64,'APEX');
    ins_icon('form_proc_page_64.gif',64,'APEX');
    ins_icon('form_wiz_page_64.gif',64,'APEX');
    ins_icon('files_64.gif',64,'APEX');
    ins_icon('ui_64.gif',64,'APEX');
    ins_icon('printer_64.gif',64,'APEX');
    ins_icon('logic_64.gif',64,'APEX');
    ins_icon('trash_64.gif',64,'APEX');
    ins_icon('supporting_obj_64.gif',64,'APEX');
    ins_icon('blank_app_64.gif',64,'APEX');
    ins_icon('browse_db_64.gif',64,'APEX');
    ins_icon('manage_service_64.gif',64,'APEX');
    ins_icon('change_storage_64.gif',64,'APEX');
    ins_icon('dbshare_64.gif',64,'APEX');
    ins_icon('db_tools_64.gif',64,'APEX');
    ins_icon('user_red_64.gif',64,'APEX');
    ins_icon('user_yellow_64.gif',64,'APEX');
    ins_icon('user_green_64.gif',64,'APEX');
    --
    -- apex 3.1 32x32
    --
    ins_icon('trash_empty_32.gif',32,'APEX');
    --
    -- apex 3.0 32x32
    --
    ins_icon('users_business_32.gif',32,'APEX');
    ins_icon('application_32.gif',32,'APEX');
    ins_icon('bug_32.gif',32,'APEX');
    ins_icon('calendar_32.gif',32,'APEX');
    ins_icon('client_32.gif',32,'APEX');
    ins_icon('db_32.gif',32,'APEX');
    ins_icon('key_32.gif',32,'APEX');
    ins_icon('disk_32.gif',32,'APEX');
    ins_icon('draw_32.gif',32,'APEX');
    ins_icon('edit_32.gif',32,'APEX');
    ins_icon('folder_32.gif',32,'APEX');
    ins_icon('globe_32.gif',32,'APEX');
    ins_icon('lightbulb_32.gif',32,'APEX');
    ins_icon('chart_line_32.gif',32,'APEX');
    ins_icon('lock_32.gif',32,'APEX');
    ins_icon('navigation_32.gif',32,'APEX');
    ins_icon('package_32.gif',32,'APEX');
    ins_icon('page_32.gif',32,'APEX');
    ins_icon('pdf_32.gif',32,'APEX');
    ins_icon('chart_pie_32.gif',32,'APEX');
    ins_icon('pin_32.gif',32,'APEX');
    ins_icon('search_32.gif',32,'APEX');
    ins_icon('server_32.gif',32,'APEX');
    ins_icon('shapes_32.gif',32,'APEX');
    ins_icon('spreadsheet_32.gif',32,'APEX');
    ins_icon('users_32.gif',32,'APEX');
    ins_icon('clipboard_32.gif',32,'APEX');
    ins_icon('info_32.gif',32,'APEX');
    ins_icon('prod_apex_32.gif',32,'APEX');
    ins_icon('download_32.gif',32,'APEX');
    ins_icon('memo_32.gif',32,'APEX');
    ins_icon('phone_32.gif',32,'APEX');
    ins_icon('todo_32.gif',32,'APEX');
    ins_icon('mail_32.gif',32,'APEX');
    ins_icon('prod_sqldev_32.gif',32,'APEX');
    ins_icon('news_32.gif',32,'APEX');
    ins_icon('bboard_32.gif',32,'APEX');
    ins_icon('books_32.gif',32,'APEX');
    ins_icon('chart_bar_32.gif',32,'APEX');
    ins_icon('trafficlight_32.gif',32,'APEX');
    ins_icon('folder_yellow_32.gif',32,'APEX');
    ins_icon('report_32.gif',32,'APEX');
    ins_icon('tabform_32.gif',32,'APEX');
    ins_icon('form_32.gif',32,'APEX');
    ins_icon('tree_32.gif',32,'APEX');
    ins_icon('dynamic_32.gif',32,'APEX');
    ins_icon('home_32.gif',32,'APEX');
    ins_icon('login_32.gif',32,'APEX');
    ins_icon('calendar_page_32.gif',32,'APEX');
    ins_icon('chart_page_32.gif',32,'APEX');
    ins_icon('global_32.gif',32,'APEX');
    ins_icon('navigation_page_32.gif',32,'APEX');
    ins_icon('form_proc_page_32.gif',32,'APEX');
    ins_icon('form_wiz_page_32.gif',32,'APEX');
    ins_icon('files_32.gif',32,'APEX');
    ins_icon('ui_32.gif',32,'APEX');
    ins_icon('printer_32.gif',32,'APEX');
    ins_icon('logic_32.gif',32,'APEX');
    ins_icon('trash_32.gif',32,'APEX');
    ins_icon('supporting_obj_32.gif',32,'APEX');
    ins_icon('blank_app_32.gif',32,'APEX');
    ins_icon('browse_db_32.gif',32,'APEX');
    ins_icon('manage_service_32.gif',32,'APEX');
    ins_icon('change_storage_32.gif',32,'APEX');
    ins_icon('dbshare_32.gif',32,'APEX');
    ins_icon('db_tools_32.gif',32,'APEX');
    ins_icon('user_red_32.gif',32,'APEX');
    ins_icon('user_yellow_32.gif',32,'APEX');
    ins_icon('user_green_32.gif',32,'APEX');
    --
    -- apex 3.1 20x20
    --
    ins_icon('pt_all_20.png',20,'APEX');
    ins_icon('pt_arrows_20.png',20,'APEX');
    ins_icon('pt_boxes_20.png',20,'APEX');
    ins_icon('pt_branch_20.png',20,'APEX');
    ins_icon('pt_breadcrumb_20.png',20,'APEX');
    ins_icon('pt_build_options_20.png',20,'APEX');
    ins_icon('pt_button_20.png',20,'APEX');
    ins_icon('pt_computation_20.png',20,'APEX');
    ins_icon('pt_condition_20.png',20,'APEX');
    ins_icon('pt_css_20.png',20,'APEX');
    ins_icon('pt_door_20.png',20,'APEX');
    ins_icon('pt_files_20.png',20,'APEX');
    ins_icon('pt_globalization_20.png',20,'APEX');
    ins_icon('pt_images_20.png',20,'APEX');
    ins_icon('pt_item_20.png',20,'APEX');
    ins_icon('pt_list_20.png',20,'APEX');
    ins_icon('pt_lov_20.png',20,'APEX');
    ins_icon('pt_messages_20.png',20,'APEX');
    ins_icon('pt_nav_20.png',20,'APEX');
    ins_icon('pt_page_20.png',20,'APEX');
    ins_icon('pt_print_20.png',20,'APEX');
    ins_icon('pt_process_20.png',20,'APEX');
    ins_icon('pt_region_20.png',20,'APEX');
    ins_icon('pt_security_20.png',20,'APEX');
    ins_icon('pt_security_attr_20.png',20,'APEX');
    ins_icon('pt_session_20.png',20,'APEX');
    ins_icon('pt_shortcuts_20.png',20,'APEX');
    ins_icon('pt_tab_20.png',20,'APEX');
    ins_icon('pt_template_20.png',20,'APEX');
    ins_icon('pt_theme_20.png',20,'APEX');
    ins_icon('pt_translate_20.png',20,'APEX');
    ins_icon('pt_tree_20.png',20,'APEX');
    ins_icon('pt_validation_20.png',20,'APEX');
    commit;
end;
/

---------------------------
-- Font Awesome CSS Classes
---------------------------
/* Script to generate the add_icon calls for Font Awesome
var xhttp = new XMLHttpRequest(),
    i = 0,
    lines = [],
    icons = [],
    category,
    alias,
    filter,
    parseFilter = false,
    parseCategories = false,
    output = "";
xhttp.open( "GET", "https://raw.githubusercontent.com/FortAwesome/Font-Awesome/v4.5.0/src/icons.yml", false );
xhttp.send();
lines = xhttp.responseText.split( "\n" );
for ( i = 0; i < lines.length; i++ ) {
  pos = lines[ i ].indexOf( "name:" );
  if ( pos !== -1 ) {
    icons.push({
      icon: "",
      filters: [],
      categories: []
    });
    parseFilter = false;
    parseCategories = false;
  } else {
    if ( parseCategories ) {
      if ( lines[ i ].indexOf( "-" ) !== -1 ) {
          category = lines[ i ].replace( /-/g, "" ).replace( " Icons", "" ).toUpperCase().trim().replace( / /g, "_" );
          if ( category !== "" ) {
            icons[ icons.length - 1 ].categories.push( category );
          }
      } else {
          parseCategories = false;
      }
    } else if ( parseFilter ) {
      if ( lines[ i ].indexOf( "-" ) !== -1 ) {
          filter = lines[ i ].replace( /-/g, "" ).replace( /"/g, "" ).trim();
          if ( filter !== "" ) {
            icons[ icons.length - 1 ].filters.push( filter );
          }
      } else {
          parseFilter = false;
      }
    }
    if ( lines[ i ].indexOf( "filter:" ) !== -1 || lines[ i ].indexOf( "aliases:" ) !== -1 ) {
      parseFilter = true;
    } else if ( lines[ i ].indexOf( "categories:" ) !== -1 ) {
      parseCategories = true;
    } else if ( lines[ i ].indexOf( "id:" ) !== -1 ) {
      icons[ icons.length - 1 ].icon = lines[ i ].substr( lines[ i ].indexOf( "id:" ) + 3 ).trim();
    }
  }
}
for ( i = 0; i < icons.length; i++ ) {
  output += "\nadd_icon( '" + icons[ i ].icon + "', '" + icons[ i ].categories.join( ":" );
  if ( icons[ i ].filters.length > 0 ) {
    output += "', '" + icons[ i ].filters.join( "," );
  }
  output += "' );";
}
console.log( output );
*/

---------------------------
-- Font APEX CSS Classes
---------------------------
delete from wwv_flow_standard_icons
 where icon_library = 'FONTAPEX'
/
commit;

declare
    procedure add_icon (
        p_icon       in varchar2,
        p_categories in varchar2,
        p_filters    in varchar2 default null )
    is
    begin
        insert into wwv_flow_standard_icons ( icon_name ,icon_library, icon_category, icon_filters ) values ( 'fa-' || p_icon, 'FONTAPEX', p_categories, p_filters );
    end add_icon;
begin
add_icon( 'address-book', 'WEB_APPLICATION', 'contacts' );
add_icon( 'address-book-o', 'WEB_APPLICATION', 'contacts' );
add_icon( 'address-card', 'WEB_APPLICATION', 'vcard' );
add_icon( 'address-card-o', 'WEB_APPLICATION', 'vcard-o' );
add_icon( 'adjust', 'WEB_APPLICATION', 'contrast' );
add_icon( 'alert', 'WEB_APPLICATION', 'message,comment' );
add_icon( 'align-center', 'TEXT_EDITOR', 'middle,text' );
add_icon( 'align-justify', 'TEXT_EDITOR', 'text' );
add_icon( 'align-left', 'TEXT_EDITOR', 'text' );
add_icon( 'align-right', 'TEXT_EDITOR', 'text' );
add_icon( 'ambulance', 'MEDICAL:TRANSPORTATION', 'support,help' );
add_icon( 'american-sign-language-interpreting', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'anchor', 'WEB_APPLICATION', 'link' );
add_icon( 'angle-double-down', 'DIRECTIONAL' );
add_icon( 'angle-double-left', 'DIRECTIONAL', 'laquo,quote,previous,back' );
add_icon( 'angle-double-right', 'DIRECTIONAL', 'raquo,quote,next,forward' );
add_icon( 'angle-double-up', 'DIRECTIONAL' );
add_icon( 'angle-down', 'DIRECTIONAL' );
add_icon( 'angle-left', 'DIRECTIONAL', 'previous,back' );
add_icon( 'angle-right', 'DIRECTIONAL', 'next,forward' );
add_icon( 'angle-up', 'DIRECTIONAL' );
add_icon( 'apex', 'WEB_APPLICATION', 'applicationexpress,htmldb,webdb' );
add_icon( 'apex-square', 'WEB_APPLICATION', 'applicationexpress,htmldb,webdb' );
add_icon( 'archive', 'WEB_APPLICATION', 'box,storage' );
add_icon( 'area-chart', 'WEB_APPLICATION:CHART', 'graph,analytics' );
add_icon( 'arrow-circle-down', 'DIRECTIONAL', 'download' );
add_icon( 'arrow-circle-left', 'DIRECTIONAL', 'previous,back' );
add_icon( 'arrow-circle-o-down', 'DIRECTIONAL', 'download' );
add_icon( 'arrow-circle-o-left', 'DIRECTIONAL', 'previous,back' );
add_icon( 'arrow-circle-o-right', 'DIRECTIONAL', 'next,forward' );
add_icon( 'arrow-circle-o-up', 'DIRECTIONAL' );
add_icon( 'arrow-circle-right', 'DIRECTIONAL', 'next,forward' );
add_icon( 'arrow-circle-up', 'DIRECTIONAL' );
add_icon( 'arrow-down', 'DIRECTIONAL', 'download' );
add_icon( 'arrow-down-alt', 'DIRECTIONAL' );
add_icon( 'arrow-down-left-alt', 'DIRECTIONAL' );
add_icon( 'arrow-down-right-alt', 'DIRECTIONAL' );
add_icon( 'arrow-left', 'DIRECTIONAL', 'previous,back' );
add_icon( 'arrow-left-alt', 'DIRECTIONAL' );
add_icon( 'arrow-right', 'DIRECTIONAL', 'next,forward' );
add_icon( 'arrow-right-alt', 'DIRECTIONAL' );
add_icon( 'arrow-up', 'DIRECTIONAL' );
add_icon( 'arrow-up-alt', 'DIRECTIONAL' );
add_icon( 'arrow-up-left-alt', 'DIRECTIONAL' );
add_icon( 'arrow-up-right-alt', 'DIRECTIONAL' );
add_icon( 'arrows', 'WEB_APPLICATION:DIRECTIONAL', 'move,reorder,resize' );
add_icon( 'arrows-alt', 'VIDEO_PLAYER:DIRECTIONAL', 'expand,enlarge,fullscreen,bigger,move,reorder,resize' );
add_icon( 'arrows-h', 'WEB_APPLICATION:DIRECTIONAL', 'resize' );
add_icon( 'arrows-v', 'WEB_APPLICATION:DIRECTIONAL', 'resize' );
add_icon( 'asl-interpreting', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'assistive-listening-systems', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'asterisk', 'WEB_APPLICATION', 'details' );
add_icon( 'at', 'WEB_APPLICATION' );
add_icon( 'audio-description', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'awesome-face', 'EMOJI' );
add_icon( 'backward', 'VIDEO_PLAYER', 'rewind,previous' );
add_icon( 'badge-list', 'WEB_APPLICATION' );
add_icon( 'badges', 'WEB_APPLICATION' );
add_icon( 'balance-scale', 'WEB_APPLICATION' );
add_icon( 'ban', 'WEB_APPLICATION', 'delete,remove,trash,hide,block,stop,abort,cancel' );
add_icon( 'bar-chart', 'WEB_APPLICATION:CHART', 'barcharto,graph,analytics' );
add_icon( 'bar-chart-horizontal', 'CHART' );
add_icon( 'barcode', 'WEB_APPLICATION', 'scan' );
add_icon( 'bars', 'WEB_APPLICATION', 'navicon,reorder,menu,drag,reorder,settings,list,ul,ol,checklist,todo,list,hamburger' );
add_icon( 'bath', 'WEB_APPLICATION', 'bathtub' );
add_icon( 'battery-0', 'WEB_APPLICATION', 'empty' );
add_icon( 'battery-1', 'WEB_APPLICATION', 'quarter' );
add_icon( 'battery-2', 'WEB_APPLICATION', 'half' );
add_icon( 'battery-3', 'WEB_APPLICATION', 'three quarters' );
add_icon( 'battery-4', 'WEB_APPLICATION', 'full' );
add_icon( 'battleship', 'WEB_APPLICATION' );
add_icon( 'bed', 'WEB_APPLICATION', 'travel,hotel' );
add_icon( 'beer', 'WEB_APPLICATION', 'alcohol,stein,drink,mug,bar,liquor' );
add_icon( 'bell', 'WEB_APPLICATION', 'alert,reminder,notification' );
add_icon( 'bell-o', 'WEB_APPLICATION', 'alert,reminder,notification' );
add_icon( 'bell-slash', 'WEB_APPLICATION' );
add_icon( 'bell-slash-o', 'WEB_APPLICATION' );
add_icon( 'bicycle', 'WEB_APPLICATION:TRANSPORTATION', 'vehicle,bike' );
add_icon( 'binoculars', 'WEB_APPLICATION' );
add_icon( 'birthday-cake', 'WEB_APPLICATION' );
add_icon( 'bitcoin', 'CURRENCY' );
add_icon( 'blind', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'bold', 'TEXT_EDITOR' );
add_icon( 'bolt', 'WEB_APPLICATION', 'lightning,weather,flash' );
add_icon( 'bomb', 'WEB_APPLICATION' );
add_icon( 'book', 'WEB_APPLICATION', 'read,documentation' );
add_icon( 'bookmark', 'WEB_APPLICATION', 'save' );
add_icon( 'bookmark-o', 'WEB_APPLICATION', 'save' );
add_icon( 'box-arrow-in-east', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-ne', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-north', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-nw', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-se', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-south', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-sw', 'DIRECTIONAL' );
add_icon( 'box-arrow-in-west', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-east', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-ne', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-north', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-nw', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-se', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-south', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-sw', 'DIRECTIONAL' );
add_icon( 'box-arrow-out-west', 'DIRECTIONAL' );
add_icon( 'box-plot-chart', 'CHART' );
add_icon( 'braille', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'breadcrumb', 'WEB_APPLICATION', 'navigation' );
add_icon( 'briefcase', 'WEB_APPLICATION', 'work,business,office,luggage,bag' );
add_icon( 'btc', 'CURRENCY' );
add_icon( 'bubble-chart', 'CHART' );
add_icon( 'bug', 'WEB_APPLICATION', 'report,insect' );
add_icon( 'building', 'WEB_APPLICATION', 'work,business,apartment,office,company' );
add_icon( 'building-o', 'WEB_APPLICATION', 'work,business,apartment,office,company' );
add_icon( 'bullhorn', 'WEB_APPLICATION', 'announcement,share,broadcast,louder' );
add_icon( 'bullseye', 'WEB_APPLICATION', 'target' );
add_icon( 'bus', 'WEB_APPLICATION:TRANSPORTATION', 'vehicle' );
add_icon( 'button', 'WEB_APPLICATION' );
add_icon( 'button-container', 'WEB_APPLICATION', 'region' );
add_icon( 'button-group', 'WEB_APPLICATION', 'pill' );
add_icon( 'calculator', 'WEB_APPLICATION' );
add_icon( 'calendar', 'WEB_APPLICATION', 'date,time,when' );
add_icon( 'calendar-alarm', 'CALENDAR' );
add_icon( 'calendar-arrow-down', 'CALENDAR' );
add_icon( 'calendar-arrow-up', 'CALENDAR' );
add_icon( 'calendar-ban', 'CALENDAR' );
add_icon( 'calendar-chart', 'CALENDAR' );
add_icon( 'calendar-check-o', 'WEB_APPLICATION' );
add_icon( 'calendar-clock', 'CALENDAR', 'history' );
add_icon( 'calendar-edit', 'CALENDAR', 'pencil' );
add_icon( 'calendar-heart', 'CALENDAR', 'like,favorite' );
add_icon( 'calendar-lock', 'CALENDAR' );
add_icon( 'calendar-minus-o', 'WEB_APPLICATION' );
add_icon( 'calendar-o', 'WEB_APPLICATION', 'date,time,when' );
add_icon( 'calendar-plus-o', 'WEB_APPLICATION' );
add_icon( 'calendar-pointer', 'CALENDAR' );
add_icon( 'calendar-search', 'CALENDAR' );
add_icon( 'calendar-times-o', 'WEB_APPLICATION' );
add_icon( 'calendar-user', 'CALENDAR' );
add_icon( 'calendar-wrench', 'CALENDAR' );
add_icon( 'camera', 'WEB_APPLICATION', 'photo,picture,record' );
add_icon( 'camera-retro', 'WEB_APPLICATION', 'photo,picture,record' );
add_icon( 'car', 'WEB_APPLICATION:TRANSPORTATION', 'automobile,vehicle' );
add_icon( 'cards', 'WEB_APPLICATION', 'blocks' );
add_icon( 'caret-down', 'DIRECTIONAL', 'more,dropdown,menu,triangledown' );
add_icon( 'caret-left', 'DIRECTIONAL', 'previous,back,triangleleft' );
add_icon( 'caret-right', 'DIRECTIONAL', 'next,forward,triangleright' );
add_icon( 'caret-square-o-down', 'WEB_APPLICATION:DIRECTIONAL', 'toggledown,more,dropdown,menu' );
add_icon( 'caret-square-o-left', 'WEB_APPLICATION:DIRECTIONAL', 'previous,back,toggleleft' );
add_icon( 'caret-square-o-right', 'WEB_APPLICATION:DIRECTIONAL', 'next,forward,toggleright' );
add_icon( 'caret-square-o-up', 'WEB_APPLICATION:DIRECTIONAL', 'toggleup' );
add_icon( 'caret-up', 'DIRECTIONAL', 'triangleup' );
add_icon( 'carousel', 'WEB_APPLICATION', 'slideshow' );
add_icon( 'cart-arrow-down', 'WEB_APPLICATION', 'shopping' );
add_icon( 'cart-arrow-up', 'WEB_APPLICATION' );
add_icon( 'cart-check', 'WEB_APPLICATION' );
add_icon( 'cart-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'cart-empty', 'WEB_APPLICATION' );
add_icon( 'cart-full', 'WEB_APPLICATION' );
add_icon( 'cart-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'cart-lock', 'WEB_APPLICATION' );
add_icon( 'cart-magnifying-glass', 'WEB_APPLICATION' );
add_icon( 'cart-plus', 'WEB_APPLICATION', 'add,shopping' );
add_icon( 'cart-times', 'WEB_APPLICATION' );
add_icon( 'cc', 'WEB_APPLICATION' );
add_icon( 'certificate', 'WEB_APPLICATION', 'badge,star' );
add_icon( 'change-case', 'WEB_APPLICATION', 'lowercase,uppercase' );
add_icon( 'check', 'WEB_APPLICATION', 'checkmark,done,todo,agree,accept,confirm,tick' );
add_icon( 'check-circle', 'WEB_APPLICATION', 'todo,done,agree,accept,confirm' );
add_icon( 'check-circle-o', 'WEB_APPLICATION', 'todo,done,agree,accept,confirm' );
add_icon( 'check-square', 'WEB_APPLICATION:FORM_CONTROL', 'checkmark,done,todo,agree,accept,confirm' );
add_icon( 'check-square-o', 'WEB_APPLICATION:FORM_CONTROL', 'todo,done,agree,accept,confirm' );
add_icon( 'chevron-circle-down', 'DIRECTIONAL', 'more,dropdown,menu' );
add_icon( 'chevron-circle-left', 'DIRECTIONAL', 'previous,back' );
add_icon( 'chevron-circle-right', 'DIRECTIONAL', 'next,forward' );
add_icon( 'chevron-circle-up', 'DIRECTIONAL' );
add_icon( 'chevron-down', 'DIRECTIONAL' );
add_icon( 'chevron-left', 'DIRECTIONAL', 'bracket,previous,back' );
add_icon( 'chevron-right', 'DIRECTIONAL', 'bracket,next,forward' );
add_icon( 'chevron-up', 'DIRECTIONAL' );
add_icon( 'child', 'WEB_APPLICATION' );
add_icon( 'circle', 'WEB_APPLICATION:FORM_CONTROL', 'dot,notification' );
add_icon( 'circle-0-8', 'WEB_APPLICATION' );
add_icon( 'circle-1-8', 'WEB_APPLICATION' );
add_icon( 'circle-2-8', 'WEB_APPLICATION' );
add_icon( 'circle-3-8', 'WEB_APPLICATION' );
add_icon( 'circle-4-8', 'WEB_APPLICATION' );
add_icon( 'circle-5-8', 'WEB_APPLICATION' );
add_icon( 'circle-6-8', 'WEB_APPLICATION' );
add_icon( 'circle-7-8', 'WEB_APPLICATION' );
add_icon( 'circle-8-8', 'WEB_APPLICATION' );
add_icon( 'circle-arrow-in-east', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-ne', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-north', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-nw', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-se', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-south', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-sw', 'DIRECTIONAL' );
add_icon( 'circle-arrow-in-west', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-east', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-ne', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-north', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-nw', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-se', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-south', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-sw', 'DIRECTIONAL' );
add_icon( 'circle-arrow-out-west', 'DIRECTIONAL' );
add_icon( 'circle-o', 'WEB_APPLICATION:FORM_CONTROL' );
add_icon( 'circle-o-notch', 'WEB_APPLICATION:SPINNER' );
add_icon( 'circle-thin', 'WEB_APPLICATION' );
add_icon( 'clipboard', 'TEXT_EDITOR', 'copy,paste' );
add_icon( 'clipboard-arrow-down', 'TEXT_EDITOR' );
add_icon( 'clipboard-arrow-up', 'TEXT_EDITOR' );
add_icon( 'clipboard-ban', 'TEXT_EDITOR' );
add_icon( 'clipboard-bookmark', 'TEXT_EDITOR' );
add_icon( 'clipboard-chart ', 'TEXT_EDITOR' );
add_icon( 'clipboard-check', 'TEXT_EDITOR' );
add_icon( 'clipboard-check-alt', 'TEXT_EDITOR' );
add_icon( 'clipboard-clock', 'TEXT_EDITOR' );
add_icon( 'clipboard-edit', 'TEXT_EDITOR' );
add_icon( 'clipboard-heart', 'TEXT_EDITOR' );
add_icon( 'clipboard-list', 'TEXT_EDITOR' );
add_icon( 'clipboard-lock', 'TEXT_EDITOR' );
add_icon( 'clipboard-new', 'TEXT_EDITOR' );
add_icon( 'clipboard-plus', 'TEXT_EDITOR' );
add_icon( 'clipboard-pointer', 'TEXT_EDITOR' );
add_icon( 'clipboard-search', 'TEXT_EDITOR' );
add_icon( 'clipboard-user', 'TEXT_EDITOR' );
add_icon( 'clipboard-wrench', 'TEXT_EDITOR' );
add_icon( 'clipboard-x', 'TEXT_EDITOR' );
add_icon( 'clock-o', 'WEB_APPLICATION', 'watch,timer,late,timestamp' );
add_icon( 'clone', 'WEB_APPLICATION', 'copy' );
add_icon( 'cloud', 'WEB_APPLICATION', 'save' );
add_icon( 'cloud-arrow-down', 'WEB_APPLICATION' );
add_icon( 'cloud-arrow-up', 'WEB_APPLICATION' );
add_icon( 'cloud-ban', 'WEB_APPLICATION' );
add_icon( 'cloud-bookmark', 'WEB_APPLICATION' );
add_icon( 'cloud-chart', 'WEB_APPLICATION' );
add_icon( 'cloud-check', 'WEB_APPLICATION' );
add_icon( 'cloud-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'cloud-cursor', 'WEB_APPLICATION' );
add_icon( 'cloud-download', 'WEB_APPLICATION', 'import' );
add_icon( 'cloud-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'cloud-file', 'WEB_APPLICATION' );
add_icon( 'cloud-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'cloud-lock', 'WEB_APPLICATION' );
add_icon( 'cloud-new', 'WEB_APPLICATION' );
add_icon( 'cloud-play', 'WEB_APPLICATION' );
add_icon( 'cloud-plus', 'WEB_APPLICATION' );
add_icon( 'cloud-pointer', 'WEB_APPLICATION' );
add_icon( 'cloud-search', 'WEB_APPLICATION' );
add_icon( 'cloud-upload', 'WEB_APPLICATION', 'import' );
add_icon( 'cloud-user', 'WEB_APPLICATION' );
add_icon( 'cloud-wrench', 'WEB_APPLICATION' );
add_icon( 'cloud-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'cny', 'CURRENCY', 'china,renminbi,yuan' );
add_icon( 'code', 'WEB_APPLICATION', 'html,brackets' );
add_icon( 'code-fork', 'WEB_APPLICATION', 'git,fork,vcs,svn,github,rebase,version,merge' );
add_icon( 'code-group', 'WEB_APPLICATION', 'group,overlap' );
add_icon( 'coffee', 'WEB_APPLICATION', 'morning,mug,breakfast,tea,drink,cafe' );
add_icon( 'collapsible', 'WEB_APPLICATION' );
add_icon( 'columns', 'TEXT_EDITOR', 'split,panes' );
add_icon( 'combo-chart', 'CHART' );
add_icon( 'comment', 'WEB_APPLICATION', 'speech,notification,note,chat,bubble,feedback' );
add_icon( 'comment-o', 'WEB_APPLICATION', 'notification,note' );
add_icon( 'commenting', 'WEB_APPLICATION' );
add_icon( 'commenting-o', 'WEB_APPLICATION' );
add_icon( 'comments', 'WEB_APPLICATION', 'conversation,notification,notes' );
add_icon( 'comments-o', 'WEB_APPLICATION', 'conversation,notification,notes' );
add_icon( 'compass', 'WEB_APPLICATION', 'safari,directory,menu,location' );
add_icon( 'compress', 'VIDEO_PLAYER', 'collapse,combine,contract,merge,smaller' );
add_icon( 'contacts', 'WEB_APPLICATION' );
add_icon( 'copy', 'TEXT_EDITOR', 'duplicate,copy' );
add_icon( 'copyright', 'WEB_APPLICATION' );
add_icon( 'creative-commons', 'WEB_APPLICATION' );
add_icon( 'credit-card', 'WEB_APPLICATION:PAYMENT', 'money,buy,debit,checkout,purchase,payment' );
add_icon( 'credit-card-alt', 'WEB_APPLICATION:PAYMENT' );
add_icon( 'credit-card-terminal', 'PAYMENT:WEB_APPLICATION' );
add_icon( 'crop', 'WEB_APPLICATION' );
add_icon( 'crosshairs', 'WEB_APPLICATION', 'picker' );
add_icon( 'cube', 'WEB_APPLICATION' );
add_icon( 'cubes', 'WEB_APPLICATION' );
add_icon( 'cut', 'TEXT_EDITOR', 'scissors' );
add_icon( 'cutlery', 'WEB_APPLICATION', 'food,restaurant,spoon,knife,dinner,eat' );
add_icon( 'dashboard', 'WEB_APPLICATION', 'tachometer' );
add_icon( 'database', 'WEB_APPLICATION' );
add_icon( 'database-arrow-down', 'WEB_APPLICATION' );
add_icon( 'database-arrow-up', 'WEB_APPLICATION' );
add_icon( 'database-ban', 'WEB_APPLICATION' );
add_icon( 'database-bookmark', 'WEB_APPLICATION' );
add_icon( 'database-chart', 'WEB_APPLICATION' );
add_icon( 'database-check', 'WEB_APPLICATION' );
add_icon( 'database-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'database-cursor', 'WEB_APPLICATION' );
add_icon( 'database-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'database-file', 'WEB_APPLICATION' );
add_icon( 'database-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'database-lock', 'WEB_APPLICATION' );
add_icon( 'database-new', 'WEB_APPLICATION' );
add_icon( 'database-play', 'WEB_APPLICATION' );
add_icon( 'database-plus', 'WEB_APPLICATION' );
add_icon( 'database-pointer', 'WEB_APPLICATION' );
add_icon( 'database-search', 'WEB_APPLICATION' );
add_icon( 'database-user', 'WEB_APPLICATION' );
add_icon( 'database-wrench', 'WEB_APPLICATION' );
add_icon( 'database-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'deaf', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'deafness', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'design', 'WEB_APPLICATION' );
add_icon( 'desktop', 'WEB_APPLICATION', 'monitor,screen,desktop,computer,demo,device' );
add_icon( 'dial-gauge-chart', 'CHART' );
add_icon( 'diamond', 'WEB_APPLICATION', 'gem,gemstone' );
add_icon( 'dollar', 'CURRENCY', 'usd' );
add_icon( 'donut-chart', 'CHART' );
add_icon( 'dot-circle-o', 'WEB_APPLICATION:FORM_CONTROL', 'target,bullseye,notification' );
add_icon( 'download', 'WEB_APPLICATION', 'import' );
add_icon( 'download-alt', 'WEB_APPLICATION' );
add_icon( 'dynamic-content', 'WEB_APPLICATION' );
add_icon( 'edit', 'WEB_APPLICATION', 'write,edit,update' );
add_icon( 'eject', 'VIDEO_PLAYER' );
add_icon( 'ellipsis-h', 'WEB_APPLICATION', 'dots' );
add_icon( 'ellipsis-h-o', 'WEB_APPLICATION' );
add_icon( 'ellipsis-v', 'WEB_APPLICATION', 'dots' );
add_icon( 'ellipsis-v-o', 'WEB_APPLICATION' );
add_icon( 'emoji-angry', 'EMOJI' );
add_icon( 'emoji-astonished', 'EMOJI' );
add_icon( 'emoji-big-eyes-smile', 'EMOJI' );
add_icon( 'emoji-big-frown', 'EMOJI' );
add_icon( 'emoji-cold-sweat', 'EMOJI' );
add_icon( 'emoji-confounded', 'EMOJI' );
add_icon( 'emoji-confused', 'EMOJI' );
add_icon( 'emoji-cool', 'EMOJI' );
add_icon( 'emoji-cringe', 'EMOJI' );
add_icon( 'emoji-cry', 'EMOJI' );
add_icon( 'emoji-delicious', 'EMOJI' );
add_icon( 'emoji-disappointed', 'EMOJI' );
add_icon( 'emoji-disappointed-relieved', 'EMOJI' );
add_icon( 'emoji-expressionless', 'EMOJI' );
add_icon( 'emoji-fearful', 'EMOJI' );
add_icon( 'emoji-frown', 'EMOJI' );
add_icon( 'emoji-grimace', 'EMOJI' );
add_icon( 'emoji-grin-sweat', 'EMOJI' );
add_icon( 'emoji-happy-smile', 'EMOJI' );
add_icon( 'emoji-hushed', 'EMOJI' );
add_icon( 'emoji-laughing', 'EMOJI' );
add_icon( 'emoji-lol', 'EMOJI' );
add_icon( 'emoji-love', 'EMOJI' );
add_icon( 'emoji-mean', 'EMOJI' );
add_icon( 'emoji-nerd', 'EMOJI' );
add_icon( 'emoji-neutral', 'EMOJI' );
add_icon( 'emoji-no-mouth', 'EMOJI' );
add_icon( 'emoji-open-mouth', 'EMOJI' );
add_icon( 'emoji-pensive', 'EMOJI' );
add_icon( 'emoji-persevere', 'EMOJI' );
add_icon( 'emoji-pleased', 'EMOJI' );
add_icon( 'emoji-relieved', 'EMOJI' );
add_icon( 'emoji-rotfl', 'EMOJI' );
add_icon( 'emoji-scream', 'EMOJI' );
add_icon( 'emoji-sleeping', 'EMOJI' );
add_icon( 'emoji-sleepy', 'EMOJI' );
add_icon( 'emoji-slight-frown', 'EMOJI' );
add_icon( 'emoji-slight-smile', 'EMOJI' );
add_icon( 'emoji-smile', 'EMOJI' );
add_icon( 'emoji-smirk', 'EMOJI' );
add_icon( 'emoji-stuck-out-tongue', 'EMOJI' );
add_icon( 'emoji-stuck-out-tongue-closed-eyes', 'EMOJI' );
add_icon( 'emoji-stuck-out-tongue-wink', 'EMOJI' );
add_icon( 'emoji-sweet-smile', 'EMOJI' );
add_icon( 'emoji-tired', 'EMOJI' );
add_icon( 'emoji-unamused', 'EMOJI' );
add_icon( 'emoji-upside-down', 'EMOJI' );
add_icon( 'emoji-weary', 'EMOJI' );
add_icon( 'emoji-wink', 'EMOJI' );
add_icon( 'emoji-worry', 'EMOJI' );
add_icon( 'emoji-zipper-mouth', 'EMOJI' );
add_icon( 'envelope', 'WEB_APPLICATION', 'email,email,letter,support,mail,notification' );
add_icon( 'envelope-arrow-down', 'WEB_APPLICATION' );
add_icon( 'envelope-arrow-up', 'WEB_APPLICATION' );
add_icon( 'envelope-ban', 'WEB_APPLICATION' );
add_icon( 'envelope-bookmark', 'WEB_APPLICATION' );
add_icon( 'envelope-chart', 'WEB_APPLICATION' );
add_icon( 'envelope-check', 'WEB_APPLICATION' );
add_icon( 'envelope-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'envelope-cursor', 'WEB_APPLICATION' );
add_icon( 'envelope-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'envelope-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'envelope-lock', 'WEB_APPLICATION' );
add_icon( 'envelope-o', 'WEB_APPLICATION', 'email,support,email,letter,mail,notification' );
add_icon( 'envelope-open', 'WEB_APPLICATION', 'mail' );
add_icon( 'envelope-open-o', 'WEB_APPLICATION' );
add_icon( 'envelope-play', 'WEB_APPLICATION' );
add_icon( 'envelope-plus', 'WEB_APPLICATION' );
add_icon( 'envelope-pointer', 'WEB_APPLICATION' );
add_icon( 'envelope-search', 'WEB_APPLICATION' );
add_icon( 'envelope-square', 'WEB_APPLICATION' );
add_icon( 'envelope-user', 'WEB_APPLICATION' );
add_icon( 'envelope-wrench', 'WEB_APPLICATION' );
add_icon( 'envelope-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'eraser', 'TEXT_EDITOR:WEB_APPLICATION' );
add_icon( 'eur', 'CURRENCY', 'euro' );
add_icon( 'euro', 'CURRENCY', 'euro' );
add_icon( 'exception', 'WEB_APPLICATION', 'warning,error' );
add_icon( 'exchange', 'WEB_APPLICATION:DIRECTIONAL', 'transfer,arrows' );
add_icon( 'exclamation', 'WEB_APPLICATION', 'warning,error,problem,notification,notify,alert' );
add_icon( 'exclamation-circle', 'WEB_APPLICATION', 'warning,error,problem,notification,alert' );
add_icon( 'exclamation-circle-o', 'WEB_APPLICATION', 'warning,error,problem,notification,alert' );
add_icon( 'exclamation-diamond', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'exclamation-diamond-o', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'exclamation-square', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'exclamation-square-o', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'exclamation-triangle', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'exclamation-triangle-o', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'expand', 'VIDEO_PLAYER', 'enlarge,bigger,resize' );
add_icon( 'expand-collapse', 'WEB_APPLICATION', 'plus,minus' );
add_icon( 'external-link', 'WEB_APPLICATION', 'open,new' );
add_icon( 'external-link-square', 'WEB_APPLICATION', 'open,new' );
add_icon( 'eye', 'WEB_APPLICATION', 'show,visible,views' );
add_icon( 'eye-slash', 'WEB_APPLICATION', 'toggle,show,hide,visible,visiblity,views' );
add_icon( 'eyedropper', 'WEB_APPLICATION' );
add_icon( 'fast-backward', 'VIDEO_PLAYER', 'rewind,previous,beginning,start,first' );
add_icon( 'fast-forward', 'VIDEO_PLAYER', 'next,end,last' );
add_icon( 'fax', 'WEB_APPLICATION' );
add_icon( 'feed', 'WEB_APPLICATION', 'blog,rss' );
add_icon( 'female', 'WEB_APPLICATION', 'woman,user,person,profile' );
add_icon( 'fighter-jet', 'WEB_APPLICATION:TRANSPORTATION', 'fly,plane,airplane,quick,fast,travel' );
add_icon( 'fighter-jet-alt', 'WEB_APPLICATION', 'plane' );
add_icon( 'file', 'TEXT_EDITOR:FILE_TYPE', 'new,page,pdf,document' );
add_icon( 'file-archive-o', 'WEB_APPLICATION:FILE_TYPE', 'zip' );
add_icon( 'file-arrow-down', 'WEB_APPLICATION' );
add_icon( 'file-arrow-up', 'WEB_APPLICATION' );
add_icon( 'file-audio-o', 'WEB_APPLICATION:FILE_TYPE', 'sound' );
add_icon( 'file-ban', 'WEB_APPLICATION' );
add_icon( 'file-bookmark', 'WEB_APPLICATION' );
add_icon( 'file-chart', 'WEB_APPLICATION' );
add_icon( 'file-check', 'WEB_APPLICATION' );
add_icon( 'file-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'file-code-o', 'WEB_APPLICATION:FILE_TYPE' );
add_icon( 'file-cursor', 'WEB_APPLICATION' );
add_icon( 'file-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'file-excel-o', 'WEB_APPLICATION:FILE_TYPE' );
add_icon( 'file-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'file-image-o', 'WEB_APPLICATION:FILE_TYPE', 'photo,picture' );
add_icon( 'file-lock', 'WEB_APPLICATION' );
add_icon( 'file-new', 'WEB_APPLICATION' );
add_icon( 'file-o', 'TEXT_EDITOR:FILE_TYPE', 'new,page,pdf,document' );
add_icon( 'file-pdf-o', 'WEB_APPLICATION:FILE_TYPE' );
add_icon( 'file-play', 'WEB_APPLICATION' );
add_icon( 'file-plus', 'WEB_APPLICATION' );
add_icon( 'file-pointer', 'WEB_APPLICATION' );
add_icon( 'file-powerpoint-o', 'WEB_APPLICATION:FILE_TYPE' );
add_icon( 'file-search', 'WEB_APPLICATION' );
add_icon( 'file-sql-o', 'WEB_APPLICATION:FILE_TYPE' );
add_icon( 'file-text', 'TEXT_EDITOR:FILE_TYPE', 'new,page,pdf,document' );
add_icon( 'file-text-o', 'TEXT_EDITOR:FILE_TYPE', 'new,page,pdf,document' );
add_icon( 'file-user', 'WEB_APPLICATION' );
add_icon( 'file-video-o', 'WEB_APPLICATION:FILE_TYPE', 'filemovieo' );
add_icon( 'file-word-o', 'WEB_APPLICATION:FILE_TYPE' );
add_icon( 'file-wrench', 'WEB_APPLICATION' );
add_icon( 'file-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'files-o', 'TEXT_EDITOR', 'duplicate,copy' );
add_icon( 'film', 'WEB_APPLICATION', 'movie' );
add_icon( 'filter', 'WEB_APPLICATION', 'funnel,options' );
add_icon( 'fire', 'WEB_APPLICATION', 'flame,hot,popular' );
add_icon( 'fire-extinguisher', 'WEB_APPLICATION' );
add_icon( 'fit-to-height', 'WEB_APPLICATION' );
add_icon( 'fit-to-size', 'WEB_APPLICATION' );
add_icon( 'fit-to-width', 'WEB_APPLICATION' );
add_icon( 'flag', 'WEB_APPLICATION', 'report,notification,notify' );
add_icon( 'flag-checkered', 'WEB_APPLICATION', 'report,notification,notify' );
add_icon( 'flag-o', 'WEB_APPLICATION', 'report,notification' );
add_icon( 'flashlight', 'WEB_APPLICATION', 'find,search' );
add_icon( 'flask', 'WEB_APPLICATION', 'science,beaker,experimental,labs' );
add_icon( 'folder', 'WEB_APPLICATION' );
add_icon( 'folder-arrow-down', 'WEB_APPLICATION' );
add_icon( 'folder-arrow-up', 'WEB_APPLICATION' );
add_icon( 'folder-ban', 'WEB_APPLICATION' );
add_icon( 'folder-bookmark', 'WEB_APPLICATION' );
add_icon( 'folder-chart', 'WEB_APPLICATION' );
add_icon( 'folder-check', 'WEB_APPLICATION' );
add_icon( 'folder-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'folder-cloud', 'WEB_APPLICATION' );
add_icon( 'folder-cursor', 'WEB_APPLICATION' );
add_icon( 'folder-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'folder-file', 'WEB_APPLICATION' );
add_icon( 'folder-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'folder-lock', 'WEB_APPLICATION' );
add_icon( 'folder-network', 'WEB_APPLICATION' );
add_icon( 'folder-new', 'WEB_APPLICATION' );
add_icon( 'folder-o', 'WEB_APPLICATION' );
add_icon( 'folder-open', 'WEB_APPLICATION' );
add_icon( 'folder-open-o', 'WEB_APPLICATION' );
add_icon( 'folder-play', 'WEB_APPLICATION' );
add_icon( 'folder-plus', 'WEB_APPLICATION' );
add_icon( 'folder-pointer', 'WEB_APPLICATION' );
add_icon( 'folder-search', 'WEB_APPLICATION' );
add_icon( 'folder-user', 'WEB_APPLICATION' );
add_icon( 'folder-wrench', 'WEB_APPLICATION' );
add_icon( 'folder-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'folders', 'WEB_APPLICATION' );
add_icon( 'font', 'TEXT_EDITOR', 'text' );
add_icon( 'font-size', 'WEB_APPLICATION', 'text' );
add_icon( 'font-size-decrease', 'WEB_APPLICATION', 'text' );
add_icon( 'font-size-increase', 'WEB_APPLICATION', 'text' );
add_icon( 'format', 'WEB_APPLICATION', 'indentation,code' );
add_icon( 'forms', 'WEB_APPLICATION', 'input' );
add_icon( 'forward', 'VIDEO_PLAYER', 'forward,next' );
add_icon( 'frown-o', 'WEB_APPLICATION', 'emoticon,sad,disapprove,rating' );
add_icon( 'function', 'WEB_APPLICATION', 'computation,procedure,fx' );
add_icon( 'funnel-chart', 'CHART' );
add_icon( 'futbol-o', 'WEB_APPLICATION', 'soccer' );
add_icon( 'gamepad', 'WEB_APPLICATION', 'controller' );
add_icon( 'gantt-chart', 'CHART' );
add_icon( 'gavel', 'WEB_APPLICATION', 'legal' );
add_icon( 'gbp', 'CURRENCY' );
add_icon( 'gear', 'WEB_APPLICATION:SPINNER', 'settings,cog' );
add_icon( 'gears', 'WEB_APPLICATION', 'cogs,settings' );
add_icon( 'genderless', 'GENDER' );
add_icon( 'gift', 'WEB_APPLICATION', 'present' );
add_icon( 'glass', 'WEB_APPLICATION', 'martini,drink,bar,alcohol,liquor' );
add_icon( 'glasses', 'WEB_APPLICATION' );
add_icon( 'globe', 'WEB_APPLICATION', 'world,planet,map,place,travel,earth,global,translate,all,language,localize,location,coordinates,country' );
add_icon( 'graduation-cap', 'WEB_APPLICATION', 'mortar board,learning,school,student' );
add_icon( 'h-square', 'MEDICAL', 'hospital,hotel' );
add_icon( 'hand-grab-o', 'WEB_APPLICATION:HAND', 'hand rock' );
add_icon( 'hand-lizard-o', 'WEB_APPLICATION:HAND' );
add_icon( 'hand-o-down', 'DIRECTIONAL:HAND', 'point' );
add_icon( 'hand-o-left', 'DIRECTIONAL:HAND', 'point,left,previous,back' );
add_icon( 'hand-o-right', 'DIRECTIONAL:HAND', 'point,right,next,forward' );
add_icon( 'hand-o-up', 'DIRECTIONAL:HAND', 'point' );
add_icon( 'hand-peace-o', 'WEB_APPLICATION:HAND' );
add_icon( 'hand-pointer-o', 'WEB_APPLICATION:HAND' );
add_icon( 'hand-scissors-o', 'WEB_APPLICATION:HAND' );
add_icon( 'hand-spock-o', 'WEB_APPLICATION:HAND' );
add_icon( 'hand-stop-o', 'WEB_APPLICATION:HAND', 'hand paper' );
add_icon( 'handshake-o', 'WEB_APPLICATION', 'agreement' );
add_icon( 'hard-of-hearing', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'hardware', 'WEB_APPLICATION', 'chip,computer' );
add_icon( 'hashtag', 'WEB_APPLICATION' );
add_icon( 'hdd-o', 'WEB_APPLICATION', 'harddrive,harddrive,storage,save' );
add_icon( 'header', 'TEXT_EDITOR', 'heading' );
add_icon( 'headphones', 'WEB_APPLICATION', 'sound,listen,music' );
add_icon( 'headset', 'WEB_APPLICATION', 'chat,support,help' );
add_icon( 'heart', 'WEB_APPLICATION:MEDICAL', 'love,like,favorite' );
add_icon( 'heart-o', 'WEB_APPLICATION:MEDICAL', 'love,like,favorite' );
add_icon( 'heartbeat', 'WEB_APPLICATION:MEDICAL', 'ekg' );
add_icon( 'helicopter', 'WEB_APPLICATION' );
add_icon( 'hero', 'WEB_APPLICATION' );
add_icon( 'hipster', 'EMOJI' );
add_icon( 'history', 'WEB_APPLICATION' );
add_icon( 'home', 'WEB_APPLICATION', 'main,house' );
add_icon( 'hospital-o', 'MEDICAL', 'building' );
add_icon( 'hourglass', 'WEB_APPLICATION' );
add_icon( 'hourglass-1', 'WEB_APPLICATION', 'hourglass-start' );
add_icon( 'hourglass-2', 'WEB_APPLICATION', 'hourglass-half' );
add_icon( 'hourglass-3', 'WEB_APPLICATION', 'hourglass-end' );
add_icon( 'hourglass-o', 'WEB_APPLICATION' );
add_icon( 'i-cursor', 'WEB_APPLICATION' );
add_icon( 'id-badge', 'WEB_APPLICATION', 'lanyard' );
add_icon( 'id-card', 'WEB_APPLICATION', 'drivers license, identification, identity' );
add_icon( 'id-card-o', 'WEB_APPLICATION', 'drivers license, identification, identity' );
add_icon( 'ils', 'CURRENCY', 'shekel,sheqel' );
add_icon( 'image', 'WEB_APPLICATION', 'photo,picture' );
add_icon( 'inbox', 'WEB_APPLICATION' );
add_icon( 'indent', 'TEXT_EDITOR' );
add_icon( 'index', 'WEB_APPLICATION' );
add_icon( 'industry', 'WEB_APPLICATION' );
add_icon( 'info', 'WEB_APPLICATION', 'help,information,more,details' );
add_icon( 'info-circle', 'WEB_APPLICATION', 'help,information,more,details' );
add_icon( 'info-circle-o', 'WEB_APPLICATION', 'help,information,more,details' );
add_icon( 'info-square', 'WEB_APPLICATION', 'help,information,more,details' );
add_icon( 'info-square-o', 'WEB_APPLICATION', 'help,information,more,details' );
add_icon( 'inr', 'CURRENCY', 'rupee' );
add_icon( 'italic', 'TEXT_EDITOR', 'italics' );
add_icon( 'jpy', 'CURRENCY', 'japan,yen' );
add_icon( 'key', 'WEB_APPLICATION', 'unlock,password' );
add_icon( 'key-alt', 'WEB_APPLICATION', 'lock,key' );
add_icon( 'keyboard-o', 'WEB_APPLICATION', 'type,input' );
add_icon( 'krw', 'CURRENCY', 'won' );
add_icon( 'language', 'WEB_APPLICATION' );
add_icon( 'laptop', 'WEB_APPLICATION', 'demo,computer,device' );
add_icon( 'layers', 'WEB_APPLICATION' );
add_icon( 'layout-1col-2col', 'WEB_APPLICATION' );
add_icon( 'layout-1col-3col', 'WEB_APPLICATION' );
add_icon( 'layout-1row-2row', 'WEB_APPLICATION' );
add_icon( 'layout-2col', 'WEB_APPLICATION' );
add_icon( 'layout-2col-1col', 'WEB_APPLICATION' );
add_icon( 'layout-2row', 'WEB_APPLICATION' );
add_icon( 'layout-2row-1row', 'WEB_APPLICATION' );
add_icon( 'layout-3col', 'WEB_APPLICATION' );
add_icon( 'layout-3col-1col', 'WEB_APPLICATION' );
add_icon( 'layout-3row', 'WEB_APPLICATION' );
add_icon( 'layout-blank', 'WEB_APPLICATION' );
add_icon( 'layout-footer', 'WEB_APPLICATION' );
add_icon( 'layout-grid-3x', 'WEB_APPLICATION' );
add_icon( 'layout-header', 'WEB_APPLICATION' );
add_icon( 'layout-header-1col-3col', 'WEB_APPLICATION' );
add_icon( 'layout-header-2row', 'WEB_APPLICATION' );
add_icon( 'layout-header-footer', 'WEB_APPLICATION' );
add_icon( 'layout-header-nav-left-cards', 'WEB_APPLICATION' );
add_icon( 'layout-header-nav-left-right-footer', 'WEB_APPLICATION' );
add_icon( 'layout-header-nav-right-cards', 'WEB_APPLICATION' );
add_icon( 'layout-header-sidebar-left', 'WEB_APPLICATION' );
add_icon( 'layout-header-sidebar-right', 'WEB_APPLICATION' );
add_icon( 'layout-list-left', 'WEB_APPLICATION' );
add_icon( 'layout-list-right', 'WEB_APPLICATION' );
add_icon( 'layout-modal-blank', 'WEB_APPLICATION' );
add_icon( 'layout-modal-columns', 'WEB_APPLICATION' );
add_icon( 'layout-modal-grid-2x', 'WEB_APPLICATION' );
add_icon( 'layout-modal-header', 'WEB_APPLICATION' );
add_icon( 'layout-modal-nav-left', 'WEB_APPLICATION' );
add_icon( 'layout-modal-nav-right', 'WEB_APPLICATION' );
add_icon( 'layout-modal-rows', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-cards', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-hamburger', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-hamburger-header', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-header-cards', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-header-header', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-right', 'WEB_APPLICATION' );
add_icon( 'layout-nav-left-right-header-footer', 'WEB_APPLICATION' );
add_icon( 'layout-nav-right', 'WEB_APPLICATION' );
add_icon( 'layout-nav-right-cards', 'WEB_APPLICATION' );
add_icon( 'layout-nav-right-hamburger', 'WEB_APPLICATION' );
add_icon( 'layout-nav-right-hamburger-header', 'WEB_APPLICATION' );
add_icon( 'layout-nav-right-header', 'WEB_APPLICATION' );
add_icon( 'layout-nav-right-header-cards', 'WEB_APPLICATION' );
add_icon( 'layout-sidebar-left', 'WEB_APPLICATION' );
add_icon( 'layout-sidebar-right', 'WEB_APPLICATION' );
add_icon( 'layouts-grid-2x', 'WEB_APPLICATION' );
add_icon( 'leaf', 'WEB_APPLICATION', 'eco,nature' );
add_icon( 'lemon-o', 'WEB_APPLICATION' );
add_icon( 'level-down', 'WEB_APPLICATION' );
add_icon( 'level-up', 'WEB_APPLICATION' );
add_icon( 'life-ring', 'WEB_APPLICATION', 'lifebuoy,lifesaver,support' );
add_icon( 'lightbulb-o', 'WEB_APPLICATION', 'idea,inspiration' );
add_icon( 'line-area-chart', 'CHART' );
add_icon( 'line-chart', 'WEB_APPLICATION:CHART', 'graph,analytics' );
add_icon( 'link', 'TEXT_EDITOR', 'chain' );
add_icon( 'list', 'TEXT_EDITOR', 'ul,ol,checklist,finished,completed,done,todo' );
add_icon( 'list-alt', 'TEXT_EDITOR', 'ul,ol,checklist,finished,completed,done,todo' );
add_icon( 'list-ol', 'TEXT_EDITOR', 'ul,ol,checklist,list,todo,list,numbers' );
add_icon( 'list-ul', 'TEXT_EDITOR', 'ul,ol,checklist,todo,list' );
add_icon( 'location-arrow-o', 'WEB_APPLICATION', 'map,coordinates,location,address,place,where' );
add_icon( 'lock', 'WEB_APPLICATION', 'protect,admin' );
add_icon( 'lock-check', 'WEB_APPLICATION' );
add_icon( 'lock-file', 'WEB_APPLICATION' );
add_icon( 'lock-new', 'WEB_APPLICATION' );
add_icon( 'lock-password', 'WEB_APPLICATION' );
add_icon( 'lock-plus', 'WEB_APPLICATION' );
add_icon( 'lock-user', 'WEB_APPLICATION' );
add_icon( 'lock-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'long-arrow-down', 'DIRECTIONAL' );
add_icon( 'long-arrow-left', 'DIRECTIONAL', 'previous,back' );
add_icon( 'long-arrow-right', 'DIRECTIONAL' );
add_icon( 'long-arrow-up', 'DIRECTIONAL' );
add_icon( 'low-vision', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'magic', 'WEB_APPLICATION', 'wizard,automatic,autocomplete' );
add_icon( 'magnet', 'WEB_APPLICATION' );
add_icon( 'mail-forward', 'WEB_APPLICATION', 'mail share' );
add_icon( 'male', 'WEB_APPLICATION', 'man,user,person,profile' );
add_icon( 'map', 'WEB_APPLICATION' );
add_icon( 'map-marker-o', 'WEB_APPLICATION', 'map,pin,location,coordinates,localize,address,travel,where,place' );
add_icon( 'map-o', 'WEB_APPLICATION' );
add_icon( 'map-pin', 'WEB_APPLICATION' );
add_icon( 'map-signs', 'WEB_APPLICATION' );
add_icon( 'mars', 'GENDER', 'male' );
add_icon( 'mars-double', 'GENDER' );
add_icon( 'mars-stroke', 'GENDER' );
add_icon( 'mars-stroke-h', 'GENDER' );
add_icon( 'mars-stroke-v', 'GENDER' );
add_icon( 'materialized-view', 'WEB_APPLICATION' );
add_icon( 'media-list', 'WEB_APPLICATION' );
add_icon( 'medkit', 'MEDICAL', 'firstaid,firstaid,help,support,health' );
add_icon( 'meh-o', 'WEB_APPLICATION', 'emoticon,rating,neutral' );
add_icon( 'mercury', 'GENDER', 'transgender' );
add_icon( 'microchip', 'WEB_APPLICATION', 'silicon,chip,cpu' );
add_icon( 'microphone', 'WEB_APPLICATION', 'record,voice,sound' );
add_icon( 'microphone-slash', 'WEB_APPLICATION', 'record,voice,sound,mute' );
add_icon( 'military-vehicle', 'WEB_APPLICATION', 'humvee,car,truck' );
add_icon( 'minus', 'WEB_APPLICATION', 'hide,minify,delete,remove,trash,hide,collapse' );
add_icon( 'minus-circle', 'WEB_APPLICATION', 'delete,remove,trash,hide' );
add_icon( 'minus-circle-o', 'WEB_APPLICATION', 'delete,remove,trash,hide' );
add_icon( 'minus-square', 'WEB_APPLICATION:FORM_CONTROL', 'hide,minify,delete,remove,trash,hide,collapse' );
add_icon( 'minus-square-o', 'WEB_APPLICATION:FORM_CONTROL', 'hide,minify,delete,remove,trash,hide,collapse' );
add_icon( 'missile', 'WEB_APPLICATION' );
add_icon( 'mobile', 'WEB_APPLICATION', 'cellphone,cellphone,text,call,iphone,number,phone' );
add_icon( 'money', 'WEB_APPLICATION:CURRENCY', 'cash,money,buy,checkout,purchase,payment' );
add_icon( 'moon-o', 'WEB_APPLICATION', 'night,darker,contrast' );
add_icon( 'motorcycle', 'WEB_APPLICATION:TRANSPORTATION', 'vehicle,bike' );
add_icon( 'mouse-pointer', 'WEB_APPLICATION' );
add_icon( 'music', 'WEB_APPLICATION', 'note,sound' );
add_icon( 'navicon', 'WEB_APPLICATION', 'reorder,menu,drag,reorder,settings,list,ul,ol,checklist,todo,list,hamburger' );
add_icon( 'network-hub', 'WEB_APPLICATION' );
add_icon( 'network-triangle', 'WEB_APPLICATION' );
add_icon( 'neuter', 'GENDER' );
add_icon( 'newspaper-o', 'WEB_APPLICATION', 'press' );
add_icon( 'number-0', 'NUMBERS' );
add_icon( 'notebook', 'WEB_APPLICATION' );
add_icon( 'number-0-o', 'NUMBERS' );
add_icon( 'number-1', 'NUMBERS' );
add_icon( 'number-1-o', 'NUMBERS' );
add_icon( 'number-2', 'NUMBERS' );
add_icon( 'number-2-o', 'NUMBERS' );
add_icon( 'number-3', 'NUMBERS' );
add_icon( 'number-3-o', 'NUMBERS' );
add_icon( 'number-4', 'NUMBERS' );
add_icon( 'number-4-o', 'NUMBERS' );
add_icon( 'number-5', 'NUMBERS' );
add_icon( 'number-5-o', 'NUMBERS' );
add_icon( 'number-6', 'NUMBERS' );
add_icon( 'number-6-o', 'NUMBERS' );
add_icon( 'number-7', 'NUMBERS' );
add_icon( 'number-7-o', 'NUMBERS' );
add_icon( 'number-8', 'NUMBERS' );
add_icon( 'number-8-o', 'NUMBERS' );
add_icon( 'number-9', 'NUMBERS' );
add_icon( 'number-9-o', 'NUMBERS' );
add_icon( 'object-group', 'WEB_APPLICATION' );
add_icon( 'object-ungroup', 'WEB_APPLICATION' );
add_icon( 'office-phone', 'WEB_APPLICATION', 'phone,fax' );
add_icon( 'outdent', 'TEXT_EDITOR', 'dedent' );
add_icon( 'package', 'WEB_APPLICATION', 'product' );
add_icon( 'padlock', 'WEB_APPLICATION' );
add_icon( 'padlock-unlock', 'WEB_APPLICATION' );
add_icon( 'page-bottom', 'DIRECTIONAL' );
add_icon( 'page-first', 'DIRECTIONAL' );
add_icon( 'page-last', 'DIRECTIONAL' );
add_icon( 'page-top', 'DIRECTIONAL' );
add_icon( 'paint-brush', 'WEB_APPLICATION' );
add_icon( 'paper-plane', 'WEB_APPLICATION', 'send' );
add_icon( 'paper-plane-o', 'WEB_APPLICATION', 'sendo' );
add_icon( 'paperclip', 'TEXT_EDITOR', 'attachment' );
add_icon( 'paragraph', 'TEXT_EDITOR' );
add_icon( 'paste', 'TEXT_EDITOR', 'clipboard' );
add_icon( 'pause', 'VIDEO_PLAYER', 'wait' );
add_icon( 'pause-circle', 'VIDEO_PLAYER' );
add_icon( 'pause-circle-o', 'VIDEO_PLAYER' );
add_icon( 'paw', 'WEB_APPLICATION', 'pet' );
add_icon( 'pencil', 'WEB_APPLICATION', 'write,edit,update' );
add_icon( 'pencil-square', 'WEB_APPLICATION', 'write,edit,update' );
add_icon( 'pencil-square-o', 'WEB_APPLICATION', 'write,edit,update,edit' );
add_icon( 'percent', 'WEB_APPLICATION' );
add_icon( 'phone', 'WEB_APPLICATION', 'call,voice,number,support,earphone' );
add_icon( 'phone-square', 'WEB_APPLICATION', 'call,voice,number,support' );
add_icon( 'photo', 'WEB_APPLICATION', 'image,picture' );
add_icon( 'pie-chart', 'WEB_APPLICATION:CHART', 'graph,analytics' );
add_icon( 'pie-chart-0', 'CHART' );
add_icon( 'pie-chart-10', 'CHART' );
add_icon( 'pie-chart-100', 'CHART' );
add_icon( 'pie-chart-15', 'CHART' );
add_icon( 'pie-chart-20', 'CHART' );
add_icon( 'pie-chart-25', 'CHART' );
add_icon( 'pie-chart-30', 'CHART' );
add_icon( 'pie-chart-35', 'CHART' );
add_icon( 'pie-chart-40', 'CHART' );
add_icon( 'pie-chart-45', 'CHART' );
add_icon( 'pie-chart-5', 'CHART' );
add_icon( 'pie-chart-50', 'CHART' );
add_icon( 'pie-chart-55', 'CHART' );
add_icon( 'pie-chart-60', 'CHART' );
add_icon( 'pie-chart-65', 'CHART' );
add_icon( 'pie-chart-70', 'CHART' );
add_icon( 'pie-chart-75', 'CHART' );
add_icon( 'pie-chart-80', 'CHART' );
add_icon( 'pie-chart-85', 'CHART' );
add_icon( 'pie-chart-90', 'CHART' );
add_icon( 'pie-chart-95', 'CHART' );
add_icon( 'plane', 'WEB_APPLICATION:TRANSPORTATION', 'travel,trip,location,destination,airplane,fly,mode' );
add_icon( 'play', 'VIDEO_PLAYER', 'start,playing,music,sound' );
add_icon( 'play-circle', 'VIDEO_PLAYER', 'start,playing' );
add_icon( 'play-circle-o', 'VIDEO_PLAYER' );
add_icon( 'plug', 'WEB_APPLICATION' );
add_icon( 'plus', 'WEB_APPLICATION', 'add,new,create,expand' );
add_icon( 'plus-circle', 'WEB_APPLICATION', 'add,new,create,expand' );
add_icon( 'plus-circle-o', 'WEB_APPLICATION', 'add,new,create,expand' );
add_icon( 'plus-square', 'MEDICAL:WEB_APPLICATION:FORM_CONTROL', 'add,new,create,expand' );
add_icon( 'plus-square-o', 'WEB_APPLICATION:FORM_CONTROL', 'add,new,create,expand' );
add_icon( 'podcast', 'WEB_APPLICATION' );
add_icon( 'polar-chart', 'CHART' );
add_icon( 'power-off', 'WEB_APPLICATION', 'on' );
add_icon( 'pragma', 'WEB_APPLICATION', 'number,sign,hash,sharp' );
add_icon( 'print', 'WEB_APPLICATION' );
add_icon( 'procedure', 'WEB_APPLICATION', 'computation,function' );
add_icon( 'puzzle-piece', 'WEB_APPLICATION', 'addon,addon,section' );
add_icon( 'pyramid-chart', 'CHART' );
add_icon( 'qrcode', 'WEB_APPLICATION', 'scan' );
add_icon( 'question', 'WEB_APPLICATION', 'help,information,unknown,support' );
add_icon( 'question-circle', 'WEB_APPLICATION', 'help,information,unknown,support' );
add_icon( 'question-circle-o', 'WEB_APPLICATION', 'help,information,unknown,support' );
add_icon( 'question-square', 'WEB_APPLICATION', 'help,information,unknown,support' );
add_icon( 'question-square-o', 'WEB_APPLICATION', 'help,information,unknown,support' );
add_icon( 'quote-left', 'WEB_APPLICATION' );
add_icon( 'quote-right', 'WEB_APPLICATION' );
add_icon( 'radar-chart', 'CHART' );
add_icon( 'random', 'WEB_APPLICATION:VIDEO_PLAYER', 'sort,shuffle' );
add_icon( 'range-chart-area', 'CHART' );
add_icon( 'range-chart-bar', 'CHART' );
add_icon( 'recycle', 'WEB_APPLICATION' );
add_icon( 'redo-alt', 'WEB_APPLICATION' );
add_icon( 'redo-arrow', 'WEB_APPLICATION' );
add_icon( 'refresh', 'WEB_APPLICATION:SPINNER', 'reload,sync' );
add_icon( 'registered', 'WEB_APPLICATION' );
add_icon( 'remove', 'WEB_APPLICATION', 'remove,close,close,exit,x,cross' );
add_icon( 'repeat', 'TEXT_EDITOR', 'redo,forward,rotate' );
add_icon( 'reply', 'WEB_APPLICATION', 'mail' );
add_icon( 'reply-all', 'WEB_APPLICATION', 'mail' );
add_icon( 'retweet', 'WEB_APPLICATION', 'refresh,reload,share' );
add_icon( 'rmb', 'CURRENCY', 'china,renminbi,yuan' );
add_icon( 'road', 'WEB_APPLICATION', 'street' );
add_icon( 'rocket', 'WEB_APPLICATION:TRANSPORTATION', 'app' );
add_icon( 'rotate-left', 'TEXT_EDITOR', 'back,undo' );
add_icon( 'rotate-right', 'TEXT_EDITOR', 'redo,forward,repeat' );
add_icon( 'rss', 'WEB_APPLICATION', 'blog,feed' );
add_icon( 'rss-square', 'WEB_APPLICATION', 'feed,blog' );
add_icon( 'rub', 'CURRENCY', 'ruble,rouble' );
add_icon( 'save', 'TEXT_EDITOR', 'floppy' );
add_icon( 'save-as', 'WEB_APPLICATION' );
add_icon( 'scatter-chart', 'CHART' );
add_icon( 'scissors', 'TEXT_EDITOR', 'cut' );
add_icon( 'search', 'WEB_APPLICATION', 'magnify,zoom,enlarge,bigger' );
add_icon( 'search-minus', 'WEB_APPLICATION', 'magnify,minify,zoom,smaller' );
add_icon( 'search-plus', 'WEB_APPLICATION', 'magnify,zoom,enlarge,bigger' );
add_icon( 'send', 'WEB_APPLICATION', 'plane' );
add_icon( 'send-o', 'WEB_APPLICATION', 'plane' );
add_icon( 'sequence', 'WEB_APPLICATION' );
add_icon( 'server', 'WEB_APPLICATION' );
add_icon( 'server-arrow-down', 'WEB_APPLICATION' );
add_icon( 'server-arrow-up', 'WEB_APPLICATION' );
add_icon( 'server-ban', 'WEB_APPLICATION' );
add_icon( 'server-bookmark', 'WEB_APPLICATION' );
add_icon( 'server-chart', 'WEB_APPLICATION' );
add_icon( 'server-check', 'WEB_APPLICATION' );
add_icon( 'server-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'server-edit', 'WEB_APPLICATION' );
add_icon( 'server-file', 'WEB_APPLICATION' );
add_icon( 'server-heart', 'WEB_APPLICATION' );
add_icon( 'server-lock', 'WEB_APPLICATION' );
add_icon( 'server-new', 'WEB_APPLICATION' );
add_icon( 'server-play', 'WEB_APPLICATION' );
add_icon( 'server-plus', 'WEB_APPLICATION' );
add_icon( 'server-pointer', 'WEB_APPLICATION' );
add_icon( 'server-search', 'WEB_APPLICATION' );
add_icon( 'server-user', 'WEB_APPLICATION' );
add_icon( 'server-wrench', 'WEB_APPLICATION' );
add_icon( 'server-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'shapes', 'WEB_APPLICATION', 'shared,components' );
add_icon( 'share', 'WEB_APPLICATION', 'mail forward' );
add_icon( 'share-alt', 'WEB_APPLICATION' );
add_icon( 'share-alt-square', 'WEB_APPLICATION' );
add_icon( 'share-square', 'WEB_APPLICATION', 'social,send' );
add_icon( 'share-square-o', 'WEB_APPLICATION', 'social,send' );
add_icon( 'share2', 'WEB_APPLICATION' );
add_icon( 'shield', 'WEB_APPLICATION', 'award,achievement,winner' );
add_icon( 'ship', 'WEB_APPLICATION:TRANSPORTATION', 'boat,sea' );
add_icon( 'shopping-bag', 'WEB_APPLICATION' );
add_icon( 'shopping-basket', 'WEB_APPLICATION' );
add_icon( 'shopping-cart', 'WEB_APPLICATION', 'checkout,buy,purchase,payment' );
add_icon( 'shower', 'WEB_APPLICATION' );
add_icon( 'sign-in', 'WEB_APPLICATION', 'enter,join,login,login,signup,signin,signin,signup,arrow' );
add_icon( 'sign-language', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'sign-out', 'WEB_APPLICATION', 'logout,logout,leave,exit,arrow' );
add_icon( 'signal', 'WEB_APPLICATION' );
add_icon( 'signing', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'sitemap', 'WEB_APPLICATION', 'directory,hierarchy,organization' );
add_icon( 'sitemap-horizontal', 'WEB_APPLICATION' );
add_icon( 'sitemap-vertical', 'WEB_APPLICATION' );
add_icon( 'sliders', 'WEB_APPLICATION' );
add_icon( 'smile-o', 'WEB_APPLICATION', 'emoticon,happy,approve,satisfied,rating' );
add_icon( 'snowflake', 'WEB_APPLICATION', 'frozen' );
add_icon( 'soccer-ball-o', 'WEB_APPLICATION', 'football' );
add_icon( 'sort', 'WEB_APPLICATION', 'order,unsorted' );
add_icon( 'sort-alpha-asc', 'WEB_APPLICATION' );
add_icon( 'sort-alpha-desc', 'WEB_APPLICATION' );
add_icon( 'sort-amount-asc', 'WEB_APPLICATION' );
add_icon( 'sort-amount-desc', 'WEB_APPLICATION' );
add_icon( 'sort-asc', 'WEB_APPLICATION', 'up' );
add_icon( 'sort-desc', 'WEB_APPLICATION', 'dropdown,more,menu,down' );
add_icon( 'sort-numeric-asc', 'WEB_APPLICATION', 'numbers' );
add_icon( 'sort-numeric-desc', 'WEB_APPLICATION', 'numbers' );
add_icon( 'space-shuttle', 'WEB_APPLICATION:TRANSPORTATION' );
add_icon( 'spinner', 'WEB_APPLICATION:SPINNER', 'loading,progress' );
add_icon( 'spoon', 'WEB_APPLICATION' );
add_icon( 'square', 'WEB_APPLICATION:FORM_CONTROL', 'block,box' );
add_icon( 'square-o', 'WEB_APPLICATION:FORM_CONTROL', 'block,square,box' );
add_icon( 'square-selected-o', 'WEB_APPLICATION:FORM_CONTROL', 'block,square,box' );
add_icon( 'star', 'WEB_APPLICATION', 'award,achievement,night,rating,score' );
add_icon( 'star-half', 'WEB_APPLICATION', 'award,achievement,rating,score' );
add_icon( 'star-half-o', 'WEB_APPLICATION', 'award,achievement,rating,score,half' );
add_icon( 'star-o', 'WEB_APPLICATION', 'award,achievement,night,rating,score' );
add_icon( 'step-backward', 'VIDEO_PLAYER', 'rewind,previous,beginning,start,first' );
add_icon( 'step-forward', 'VIDEO_PLAYER', 'next,end,last' );
add_icon( 'stethoscope', 'MEDICAL' );
add_icon( 'sticky-note', 'WEB_APPLICATION' );
add_icon( 'sticky-note-o', 'WEB_APPLICATION' );
add_icon( 'stock-chart', 'CHART' );
add_icon( 'stop', 'VIDEO_PLAYER', 'block,box,square' );
add_icon( 'stop-circle', 'VIDEO_PLAYER' );
add_icon( 'stop-circle-o', 'VIDEO_PLAYER' );
add_icon( 'street-view', 'WEB_APPLICATION', 'map' );
add_icon( 'strikethrough', 'TEXT_EDITOR' );
add_icon( 'subscript', 'TEXT_EDITOR' );
add_icon( 'subway', 'TRANSPORTATION' );
add_icon( 'suitcase', 'WEB_APPLICATION', 'trip,luggage,travel,move,baggage' );
add_icon( 'sun-o', 'WEB_APPLICATION', 'weather,contrast,lighter,brighten,day' );
add_icon( 'superscript', 'TEXT_EDITOR', 'exponential' );
add_icon( 'support', 'WEB_APPLICATION', 'lifebuoy,lifesaver,lifering' );
add_icon( 'synonym', 'WEB_APPLICATION', 'copy,duplicate' );
add_icon( 'table', 'TEXT_EDITOR', 'data,excel,spreadsheet' );
add_icon( 'table-arrow-down', 'WEB_APPLICATION' );
add_icon( 'table-arrow-up', 'WEB_APPLICATION' );
add_icon( 'table-ban', 'WEB_APPLICATION' );
add_icon( 'table-bookmark', 'WEB_APPLICATION' );
add_icon( 'table-chart', 'WEB_APPLICATION' );
add_icon( 'table-check', 'WEB_APPLICATION' );
add_icon( 'table-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'table-cursor', 'WEB_APPLICATION' );
add_icon( 'table-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'table-file', 'WEB_APPLICATION' );
add_icon( 'table-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'table-lock', 'WEB_APPLICATION' );
add_icon( 'table-new', 'WEB_APPLICATION' );
add_icon( 'table-play', 'WEB_APPLICATION' );
add_icon( 'table-plus', 'WEB_APPLICATION' );
add_icon( 'table-pointer', 'WEB_APPLICATION' );
add_icon( 'table-search', 'WEB_APPLICATION' );
add_icon( 'table-user', 'WEB_APPLICATION' );
add_icon( 'table-wrench', 'WEB_APPLICATION' );
add_icon( 'table-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'tablet', 'WEB_APPLICATION', 'ipad,device' );
add_icon( 'tabs', 'WEB_APPLICATION' );
add_icon( 'tachometer', 'WEB_APPLICATION', 'dashboard' );
add_icon( 'tag', 'WEB_APPLICATION', 'label' );
add_icon( 'tags', 'WEB_APPLICATION', 'labels' );
add_icon( 'tank', 'WEB_APPLICATION' );
add_icon( 'tasks', 'WEB_APPLICATION', 'progress,loading,downloading,downloads,settings' );
add_icon( 'taxi', 'WEB_APPLICATION:TRANSPORTATION', 'cab,vehicle' );
add_icon( 'television', 'WEB_APPLICATION', 'tv' );
add_icon( 'terminal', 'WEB_APPLICATION', 'command,prompt,code' );
add_icon( 'text-height', 'TEXT_EDITOR' );
add_icon( 'text-width', 'TEXT_EDITOR' );
add_icon( 'th', 'TEXT_EDITOR', 'blocks,squares,boxes,grid' );
add_icon( 'th-large', 'TEXT_EDITOR', 'blocks,squares,boxes,grid' );
add_icon( 'th-list', 'TEXT_EDITOR', 'ul,ol,checklist,finished,completed,done,todo' );
add_icon( 'thermometer-0', 'WEB_APPLICATION', 'thermometer-empty' );
add_icon( 'thermometer-1', 'WEB_APPLICATION', 'thermometer-quarter' );
add_icon( 'thermometer-2', 'WEB_APPLICATION', 'thermometer-half' );
add_icon( 'thermometer-3', 'WEB_APPLICATION', 'thermometer-three-quarters' );
add_icon( 'thermometer-4', 'WEB_APPLICATION', 'thermometer-full,thermometer' );
add_icon( 'thumb-tack', 'WEB_APPLICATION', 'marker,pin,location,coordinates' );
add_icon( 'thumbs-down', 'WEB_APPLICATION:HAND', 'dislike,disapprove,disagree,hand' );
add_icon( 'thumbs-o-down', 'WEB_APPLICATION:HAND', 'dislike,disapprove,disagree,hand' );
add_icon( 'thumbs-o-up', 'WEB_APPLICATION:HAND', 'like,approve,favorite,agree,hand' );
add_icon( 'thumbs-up', 'WEB_APPLICATION:HAND', 'like,favorite,approve,agree,hand' );
add_icon( 'ticket', 'WEB_APPLICATION', 'movie,pass,support' );
add_icon( 'tiles-2x2', 'WEB_APPLICATION' );
add_icon( 'tiles-3x3', 'WEB_APPLICATION' );
add_icon( 'tiles-8', 'WEB_APPLICATION' );
add_icon( 'tiles-9', 'WEB_APPLICATION' );
add_icon( 'times', 'WEB_APPLICATION', 'remove,close,close,exit,x,cross' );
add_icon( 'times-circle', 'WEB_APPLICATION', 'close,exit,x' );
add_icon( 'times-circle-o', 'WEB_APPLICATION', 'close,exit,x' );
add_icon( 'times-rectangle', 'WEB_APPLICATION', 'remove,close,close,exit,x,cross' );
add_icon( 'times-rectangle-o', 'WEB_APPLICATION', 'remove,close,close,exit,x,cross' );
add_icon( 'times-square', 'FORM_CONTROL', 'remove,close,close,exit,x,cross' );
add_icon( 'times-square-o', 'FORM_CONTROL', 'remove,close,close,exit,x,cross' );
add_icon( 'tint', 'WEB_APPLICATION', 'raindrop,waterdrop,drop,droplet' );
add_icon( 'toggle-off', 'WEB_APPLICATION' );
add_icon( 'toggle-on', 'WEB_APPLICATION' );
add_icon( 'tools', 'WEB_APPLICATION', 'screwdriver,wrench' );
add_icon( 'trademark', 'WEB_APPLICATION' );
add_icon( 'train', 'TRANSPORTATION' );
add_icon( 'transgender', 'GENDER', 'intersex' );
add_icon( 'transgender-alt', 'GENDER' );
add_icon( 'trash', 'WEB_APPLICATION', 'garbage,delete,remove,hide' );
add_icon( 'trash-o', 'WEB_APPLICATION', 'garbage,delete,remove,trash,hide' );
add_icon( 'tree', 'WEB_APPLICATION' );
add_icon( 'tree-org', 'WEB_APPLICATION' );
add_icon( 'trigger', 'WEB_APPLICATION' );
add_icon( 'trophy', 'WEB_APPLICATION', 'award,achievement,winner,game' );
add_icon( 'truck', 'WEB_APPLICATION:TRANSPORTATION', 'shipping' );
add_icon( 'try', 'CURRENCY', 'turkey, lira, turkish' );
add_icon( 'tty', 'WEB_APPLICATION' );
add_icon( 'umbrella', 'WEB_APPLICATION' );
add_icon( 'underline', 'TEXT_EDITOR' );
add_icon( 'undo', 'TEXT_EDITOR', 'back,rotate' );
add_icon( 'undo-alt', 'WEB_APPLICATION' );
add_icon( 'undo-arrow', 'WEB_APPLICATION' );
add_icon( 'universal-access', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'university', 'WEB_APPLICATION', 'institution,bank' );
add_icon( 'unlink', 'TEXT_EDITOR', 'remove,chain,broken' );
add_icon( 'unlock', 'WEB_APPLICATION', 'protect,admin,password,lock' );
add_icon( 'unlock-alt', 'WEB_APPLICATION', 'protect,admin,password,lock' );
add_icon( 'upload', 'WEB_APPLICATION', 'import' );
add_icon( 'upload-alt', 'WEB_APPLICATION' );
add_icon( 'usd', 'CURRENCY', 'dollar' );
add_icon( 'user', 'WEB_APPLICATION', 'person,man,head,profile' );
add_icon( 'user-arrow-down', 'WEB_APPLICATION' );
add_icon( 'user-arrow-up', 'WEB_APPLICATION' );
add_icon( 'user-ban', 'WEB_APPLICATION' );
add_icon( 'user-chart', 'WEB_APPLICATION' );
add_icon( 'user-check', 'WEB_APPLICATION' );
add_icon( 'user-circle', 'WEB_APPLICATION' );
add_icon( 'user-circle-o', 'WEB_APPLICATION' );
add_icon( 'user-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'user-cursor', 'WEB_APPLICATION' );
add_icon( 'user-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'user-graduate', 'WEB_APPLICATION' );
add_icon( 'user-headset', 'WEB_APPLICATION' );
add_icon( 'user-heart', 'WEB_APPLICATION', 'like,favorite,love' );
add_icon( 'user-lock', 'WEB_APPLICATION' );
add_icon( 'user-magnifying-glass', 'WEB_APPLICATION' );
add_icon( 'user-man', 'WEB_APPLICATION' );
add_icon( 'user-md', 'MEDICAL', 'doctor,profile,medical,nurse' );
add_icon( 'user-play', 'WEB_APPLICATION' );
add_icon( 'user-plus', 'WEB_APPLICATION', 'signup,signup' );
add_icon( 'user-pointer', 'WEB_APPLICATION' );
add_icon( 'user-secret', 'WEB_APPLICATION', 'whisper,spy,incognito' );
add_icon( 'user-woman', 'WEB_APPLICATION' );
add_icon( 'user-wrench', 'WEB_APPLICATION' );
add_icon( 'user-x', 'WEB_APPLICATION' );
add_icon( 'users', 'WEB_APPLICATION', 'people,profiles,persons,group' );
add_icon( 'users-chat', 'WEB_APPLICATION' );
add_icon( 'variable', 'WEB_APPLICATION' );
add_icon( 'venus', 'GENDER', 'female' );
add_icon( 'venus-double', 'GENDER' );
add_icon( 'venus-mars', 'GENDER' );
add_icon( 'video-camera', 'WEB_APPLICATION', 'film,movie,record' );
add_icon( 'volume-control-phone', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'volume-down', 'WEB_APPLICATION', 'lower,quieter,sound,music' );
add_icon( 'volume-off', 'WEB_APPLICATION', 'mute,sound,music' );
add_icon( 'volume-up', 'WEB_APPLICATION', 'higher,louder,sound,music' );
add_icon( 'warning', 'WEB_APPLICATION', 'warning,error,problem,notification,alert,warning' );
add_icon( 'wheelchair', 'WEB_APPLICATION:MEDICAL:TRANSPORTATION', 'handicap,person,accessibility,accessible' );
add_icon( 'wheelchair-alt', 'WEB_APPLICATION:ACCESSIBILITY' );
add_icon( 'wifi', 'WEB_APPLICATION' );
add_icon( 'window', 'WEB_APPLICATION' );
add_icon( 'window-alt', 'WEB_APPLICATION' );
add_icon( 'window-alt-2', 'WEB_APPLICATION' );
add_icon( 'window-arrow-down', 'WEB_APPLICATION' );
add_icon( 'window-arrow-up', 'WEB_APPLICATION' );
add_icon( 'window-ban', 'WEB_APPLICATION' );
add_icon( 'window-bookmark', 'WEB_APPLICATION' );
add_icon( 'window-chart', 'WEB_APPLICATION' );
add_icon( 'window-check', 'WEB_APPLICATION' );
add_icon( 'window-clock', 'WEB_APPLICATION', 'history' );
add_icon( 'window-close', 'WEB_APPLICATION', 'times, rectangle' );
add_icon( 'window-close-o', 'WEB_APPLICATION', 'times, rectangle' );
add_icon( 'window-cursor', 'WEB_APPLICATION' );
add_icon( 'window-edit', 'WEB_APPLICATION', 'pencil' );
add_icon( 'window-file', 'WEB_APPLICATION' );
add_icon( 'window-heart', 'WEB_APPLICATION', 'like,favorite' );
add_icon( 'window-lock', 'WEB_APPLICATION' );
add_icon( 'window-maximize', 'WEB_APPLICATION' );
add_icon( 'window-minimize', 'WEB_APPLICATION' );
add_icon( 'window-new', 'WEB_APPLICATION' );
add_icon( 'window-play', 'WEB_APPLICATION' );
add_icon( 'window-plus', 'WEB_APPLICATION' );
add_icon( 'window-pointer', 'WEB_APPLICATION' );
add_icon( 'window-restore', 'WEB_APPLICATION' );
add_icon( 'window-search', 'WEB_APPLICATION' );
add_icon( 'window-terminal', 'WEB_APPLICATION', 'console' );
add_icon( 'window-user', 'WEB_APPLICATION' );
add_icon( 'window-wrench', 'WEB_APPLICATION' );
add_icon( 'window-x', 'WEB_APPLICATION', 'delete,remove' );
add_icon( 'wizard', 'WEB_APPLICATION', 'steps,progress' );
add_icon( 'wrench', 'WEB_APPLICATION', 'settings,fix,update' );
add_icon( 'x-axis', 'CHART' );
add_icon( 'y-axis', 'CHART' );
add_icon( 'y1-axis', 'CHART' );
add_icon( 'y2-axis', 'CHART' );
add_icon( 'yen', 'CURRENCY' );
add_icon( 'map-pin-triangle', 'MAPS', 'pin,navigation,location,way finding,directions' );
add_icon( 'traffic-light-stop', 'MAPS', 'stop,go,sign' );
add_icon( 'map-pin-heart', 'MAPS', 'pin,navigation,location,way finding,directions' );
add_icon( 'map-pin-heart-o', 'MAPS', 'pin,navigation,location,way finding,directions' );
add_icon( 'map-pin-circle', 'MAPS', 'pin,navigation,location,way finding,directions' );
add_icon( 'map-pin-circle-o', 'MAPS', 'pin,navigation,location,way finding,directions' );
add_icon( 'map-markers', 'MAPS', 'pin,navigation,location,way finding,directions' );
add_icon( 'map-markers-o', 'MAPS', 'pin,navigation,location,way finding,directions' );
add_icon( 'map-marker-slash', 'MAPS', 'pin,navigation,location,way finding,directions' );
add_icon( 'map-marker-slash-o', 'MAPS', 'pin,navigation,location,way finding,directions' );
add_icon( 'map-marker-shine', 'MAPS', 'pin,navigation,location,way finding,directions,highlight' );
add_icon( 'map-marker-shine-o', 'MAPS', 'pin,navigation,location,way finding,directions,highlight' );
add_icon( 'map-marker-face-frown', 'MAPS', 'pin,navigation,location,way finding,directions,emoji,sad' );
add_icon( 'map-marker-face-frown-o', 'MAPS', 'pin,navigation,location,way finding,directions,emoji,sad' );
add_icon( 'map-marker-face-meh', 'MAPS', 'pin,navigation,location,way finding,directions,emoji,neutral' );
add_icon( 'map-marker-face-meh-o', 'MAPS', 'pin,navigation,location,way finding,directions,emoji,neutral' );
add_icon( 'map-marker-face-smile', 'MAPS', 'pin,navigation,location,way finding,directions,emoji,happy' );
add_icon( 'map-marker-face-smile-o', 'MAPS', 'pin,navigation,location,way finding,directions,emoji,happy' );
add_icon( 'map-marker-camera-o', 'MAPS', 'pin,navigation,location,way finding,directions,photo,photography' );
add_icon( 'map-marker-camera', 'MAPS', 'pin,navigation,location,way finding,directions,photo,photography' );
add_icon( 'map-marker', 'MAPS', 'pin,navigation,location,way finding,directions' );
add_icon( 'map-marker-check-o', 'MAPS', 'pin,navigation,location,way finding,directions' );
add_icon( 'map-marker-check', 'MAPS', 'pin,navigation,location,way finding,directions' );
add_icon( 'line-map', 'MAPS', 'road,train,subway' );
add_icon( '2d-mode', 'MAPS', 'maps,mode,2d,3d' );
add_icon( '3d-mode', 'MAPS', 'maps,mode,2d,3d' );
add_icon( 'location', 'MAPS', 'map,crosshairs' );
add_icon( 'location-slash', 'MAPS', 'map,crosshairs' );
add_icon( 'map-pin-triangle-o', 'MAPS', 'pin,navigation,location,way finding,directions' );
add_icon( 'traffic-light-go', 'MAPS', 'stop,go,sign' );
add_icon( 'traffic-light', 'MAPS', 'stop,go,sign' );
add_icon( 'location-circle', 'MAPS', 'navigation,map,way finding,compass,direction' );
add_icon( 'location-circle-o', 'MAPS', 'navigation,map,way finding,compass,direction' );
add_icon( 'location-arrow', 'MAPS', 'navigation,map,way finding,compass,direction' );
add_icon( 'nurse', 'MEDICAL', 'hospital,doctor,paramedic' );
add_icon( 'biohazard', 'MEDICAL', 'danger,waste' );
add_icon( 'prescription-sheet', 'MEDICAL', 'medicine,drug' );
add_icon( 'radiation', 'MEDICAL', 'danger,x ray,nuclear' );
add_icon( 'syringe', 'MEDICAL', 'medicine,drug,shot,vaccine,needle' );
add_icon( 'vial', 'MEDICAL', 'medicine,drug,formula,science,test tube,chemistry' );
add_icon( 'vials', 'MEDICAL', 'medicine,drug,formula,science,test tube,chemistry' );
add_icon( 'x-ray', 'MEDICAL', 'exam,hospital' );
add_icon( 'file-medical', 'MEDICAL' );
add_icon( 'file-prescription', 'MEDICAL', 'drug,medicine' );
add_icon( 'medication-pills', 'MEDICAL', 'medicine,drug' );
add_icon( 'medication-pill-bottle', 'MEDICAL', 'medicine,drug' );
add_icon( 'medication-pill', 'MEDICAL', 'medicine,drug' );
add_icon( 'medication', 'MEDICAL', 'medicine,drug' );
add_icon( 'medical-mask', 'MEDICAL', 'safety,protection' );
add_icon( 'prescription', 'MEDICAL', 'medicine,drug' );
add_icon( 'text-color', 'WEB_APPLICATION', 'text,editor,font,format,color' );
add_icon( 'abacus', 'WEB_APPLICATION', 'math,mathematics,counting,calculator' );
add_icon( 'frown', 'WEB_APPLICATION', 'emotion,face,emoji,sad' );
add_icon( 'meh', 'WEB_APPLICATION', 'emotion,face,emoji,neutral' );
add_icon( 'smile', 'WEB_APPLICATION', 'emotion,face,emoji,happy' );
add_icon( 'size-xxl', 'WEB_APPLICATION', 'measurement,shirt,badge' );
add_icon( 'size-xl', 'WEB_APPLICATION', 'measurement,shirt,badge' );
add_icon( 'size-l', 'WEB_APPLICATION', 'measurement,shirt,badge' );
add_icon( 'size-m', 'WEB_APPLICATION', 'measurement,shirt,badge' );
add_icon( 'size-s', 'WEB_APPLICATION', 'measurement,shirt,badge' );
add_icon( 'size-xs', 'WEB_APPLICATION', 'measurement,shirt,badge' );
add_icon( 'heat-map', 'WEB_APPLICATION', 'bubble,spot,circle' );
add_icon( 'flag-swallowtail-o', 'WEB_APPLICATION', 'map,marker,pin,navigation,location,way finding' );
add_icon( 'flag-swallowtail', 'WEB_APPLICATION', 'map,marker,pin,navigation,location,way finding' );
add_icon( 'flag-pennant-o', 'WEB_APPLICATION', 'map,marker,pin,navigation,location,way finding' );
add_icon( 'flag-pennant', 'WEB_APPLICATION', 'map,marker,pin,navigation,location,way finding' );
add_icon( 'alarm-clock', 'WEB_APPLICATION', 'time' );
add_icon( 'alarm-check', 'WEB_APPLICATION', 'time' );
add_icon( 'alarm-snooze', 'WEB_APPLICATION', 'time' );
add_icon( 'alarm-plus', 'WEB_APPLICATION', 'time' );
add_icon( 'alarm-minus', 'WEB_APPLICATION', 'time' );
add_icon( 'alarm-times', 'WEB_APPLICATION', 'time' );
add_icon( 'user-slash', 'WEB_APPLICATION', 'person' );
add_icon( 'users-alt', 'WEB_APPLICATION', 'person' );
add_icon( 'podium', 'WEB_APPLICATION', 'presentation,presenter,lecture,lecturer,speaker' );
add_icon( 'presentation', 'WEB_APPLICATION', 'chart,presentation,performance' );
add_icon( 'analytics', 'WEB_APPLICATION', 'analyze,magnifying glass,search,arrow,up' );
add_icon( 'tasks-alt', 'WEB_APPLICATION', 'check,list,survey' );
add_icon( 'bug-slash', 'WEB_APPLICATION', 'insect' );
add_icon( 'file-brackets', 'WEB_APPLICATION', 'programming,code' );
add_icon( 'file-csv-o', 'WEB_APPLICATION', 'programming,code' );
add_icon( 'file-json-o', 'WEB_APPLICATION', 'programming,code' );
add_icon( 'file-signature', 'WEB_APPLICATION', 'sign,authorized,contract' );
add_icon( 'sort-amount-asc-alt', 'WEB_APPLICATION' );
add_icon( 'sort-amount-desc-alt', 'WEB_APPLICATION' );
add_icon( '404', 'WEB_APPLICATION', 'broken link,error page' );
add_icon( '4k', 'WEB_APPLICATION' );
add_icon( 'accordion', 'WEB_APPLICATION', 'navigation,menu,list,expand' );
add_icon( 'accessor-more', 'WEB_APPLICATION', 'programming,network,branch,connection' );
add_icon( 'accessor-one', 'WEB_APPLICATION', 'programming,network,connection' );
add_icon( 'badge', 'WEB_APPLICATION', 'status' );
add_icon( 'badge-check', 'WEB_APPLICATION', 'status' );
add_icon( 'badge-dollar', 'WEB_APPLICATION', 'status' );
add_icon( 'badge-percent', 'WEB_APPLICATION', 'status' );
add_icon( 'workflow', 'WEB_APPLICATION', 'decision,branch,model,diagram' );
end;
/
commit;

prompt
prompt ...insert into wwv_flow_standard_item_types
prompt

delete from wwv_flow_standard_item_types;
insert into wwv_flow_standard_item_types(name, display_name) values ('BUTTON', 'Button');



prompt
prompt ...wwv_flow_languages
prompt

declare
    procedure ins_lang (
        p_id                   in wwv_flow_languages.id%type,
        p_lang_id              in wwv_flow_languages.lang_id%type,
        p_lang_id_upper        in wwv_flow_languages.lang_id_upper%type,
        p_lang_name            in wwv_flow_languages.lang_name%type,
        p_nls_language         in wwv_flow_languages.nls_language%type,
        p_nls_territory        in wwv_flow_languages.nls_territory%type,
        p_nls_sort             in wwv_flow_languages.nls_sort%type,
        p_nls_windows_charset  in wwv_flow_languages.nls_windows_charset%type,
        p_translated_lang_name in wwv_flow_languages.translated_lang_name%type,
        p_dl_format            in wwv_flow_languages.dl_format%type,
        p_ds_format            in wwv_flow_languages.ds_format%type,
        p_ms_lcid              in wwv_flow_languages.ms_lcid%type,
        p_mysql_lang_id        in wwv_flow_languages.mysql_lang_id%type )
    is
    begin
        insert into wwv_flow_languages(id,lang_id,lang_id_upper,lang_name,nls_language,nls_territory,nls_sort,nls_windows_charset,translated_lang_name,dl_format,ds_format,ms_lcid,mysql_lang_id)
        values (p_id,p_lang_id,p_lang_id_upper,p_lang_name,p_nls_language,p_nls_territory,p_nls_sort,p_nls_windows_charset,p_translated_lang_name,p_dl_format,p_ds_format,p_ms_lcid,p_mysql_lang_id);
    end ins_lang;
begin
    delete from wwv_flow_languages;
    ins_lang( 1, 'af', null, 'Afrikaans', 'ENGLISH', 'SOUTH AFRICA', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('RRRR/MM/DD'), 54,null);
    ins_lang( 2, 'sq', null, 'Albania', 'ALBANIAN', 'ALBANIA', null, 'EE8MSWIN1250',unistr('Shqip\00EBria'),unistr('fmday, dd month yyyy'),unistr('DD.MM.RRRR'), 28,'sq_AL');
    ins_lang( 3, 'ar', null, 'Arabic', 'ARABIC', 'UNITED ARAB EMIRATES', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 14337,'ar_SA');
    ins_lang( 4, 'ar-ae', null, 'Arabic (U.A.E.)', 'ARABIC', 'UNITED ARAB EMIRATES', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 14337,'ar_AE');
    ins_lang( 5, 'ar-bh', null, 'Arabic (Bahrain)', 'ARABIC', 'BAHRAIN', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 15361,'ar-BH');
    ins_lang( 6, 'ar-dz', null, 'Arabic (Algeria)', 'ARABIC', 'ALGERIA', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 5121,'ar-DZ');
    ins_lang( 7, 'hy', null, 'Armenia', 'ARMENIAN', 'ARMENIA', null, 'EE8MSWIN1250',unistr('\0540\0561\0575\0565\0580\0565\0576'),unistr('d fmMonth,yyyy'),unistr('DD.MM.RRRR'), 1067,null);
    ins_lang( 8, 'ar-eg', null, 'Arabic (Egypt)', 'EGYPTIAN', 'EGYPT', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 3073,'ar_EG');
    ins_lang( 9, 'ar-iq', null, 'Arabic (Iraq)', 'ARABIC', 'IRAQ', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 2049,'ar_IQ');
    ins_lang( 10, 'ar-jo', null, 'Arabic (Jordan)', 'ARABIC', 'JORDAN', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 11265,'ar_JO');
    ins_lang( 11, 'ar-kw', null, 'Arabic (Kuwait)', 'ARABIC', 'KUWAIT', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 13313,'ar_KW');
    ins_lang( 12, 'ar-lb', null, 'Arabic (Lebanon)', 'ARABIC', 'LEBANON', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 12289,'ar_LB');
    ins_lang( 13, 'ar-ly', null, 'Arabic (Libya)', 'ARABIC', 'LIBYA', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 4097,'ar_LY');
    ins_lang( 14, 'ar-ma', null, 'Arabic (Morocco)', 'ARABIC', 'MOROCCO', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 6145,'ar_MA');
    ins_lang( 15, 'ar-om', null, 'Arabic (Oman)', 'ARABIC', 'OMAN', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 8193,'ar_OM');
    ins_lang( 16, 'ar-qa', null, 'Arabic (Qatar)', 'ARABIC', 'QATAR', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 16385,'ar_QA');
    ins_lang( 17, 'ar-sa', null, 'Arabic (Saudi Arabia)', 'ARABIC', 'SAUDI ARABIA', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 1025,'ar_SA');
    ins_lang( 18, 'ar-sy', null, 'Arabic (Syria)', 'ARABIC', 'SYRIA', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 10241,'ar_SY');
    ins_lang( 19, 'ar-tn', null, 'Arabic (Tunisia)', 'ARABIC', 'TUNISIA', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 7169,'ar_TN');
    ins_lang( 20, 'ar-ye', null, 'Arabic (Yemen)', 'ARABIC', 'YEMEN', null, 'AR8MSWIN1256',unistr('\0627\0644\0639\0631\0628\064A\0629'),unistr('fmday, fmdd fmmonth, yyyy'),unistr('DD/MM/RRRR'), 9217,'ar_YE');
    ins_lang( 21, 'as', null, 'Assamese', 'ASSAMESE', 'INDIA', null, 'AL32UTF8',unistr('Assamese'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'), 1101, null);
    ins_lang( 22, 'be', null, 'Belarusian', 'BELARUSIAN', 'BELARUS', null, 'CL8MSWIN1251',unistr('Belarusian'),unistr('fmday dd month yyyy "\0433."'),unistr('DD.MM.RRRR'), 1059,'be_BY');
    ins_lang( 23, 'bg', null, 'Bulgarian', 'BULGARIAN', 'BULGARIA', null, 'CL8MSWIN1251',unistr('\0431\044A\043B\0433\0430\0440\0441\043A\0438'),unistr('fmDay, dd Month yyyy" \0433."'),unistr('DD.MM.RRRR'), 1026,'bg_BG');
    ins_lang( 24, 'bn', null, 'Bengali', 'BANGLA', 'BANGLADESH', null, 'AL32UTF8',unistr('\09AC\09BE\0982\09B2\09BE'),unistr('fmday, fmdd fmmonth yyyy'),unistr('DD-MM-RRRR'), 2117,null);
    ins_lang( 25, 'ca', null, 'Catalan', 'CATALAN', 'CATALONIA', null, 'WE8MSWIN1252',unistr('Catal\00E0'),unistr('fmday, dd" / "month" / "yyyy'),unistr('DD-MM-RR'), 1027,'ca_ES');
    ins_lang( 26, 'cs', null, 'Czech', 'CZECH', 'CZECH REPUBLIC', null, 'EE8MSWIN1250',unistr('\010De\0161tina'),unistr('fmday, dd. month yyyy'),unistr('fmDD.MM.RRRR'), 1029,'cs_CZ');
    ins_lang( 27, 'cy', null, 'Welsh', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252', unistr('Cymraeg'), unistr('DD/MM/RRRR'), unistr('DD/MM/RRRR'), 1106,'en_GB');
    ins_lang( 28, 'da', null, 'Danish', 'DANISH', 'DENMARK', null, 'WE8MSWIN1252',unistr('Dansk'),unistr('fmday dd. month yyyy'),unistr('DD-MM-RRRR'), 1030,'da_DK');
    ins_lang( 29, 'de', null, 'German (Germany)', 'GERMAN', 'GERMANY', null, 'WE8MSWIN1252',unistr('Deutsch'),unistr('fmDay, dd. Month yyyy'),unistr('DD.MM.RRRR'), 1031,'de_DE');
    ins_lang( 30, 'de-at', null, 'German (Austria)', 'GERMAN', 'AUSTRIA', null, 'WE8MSWIN1252',unistr('Deutsch'),unistr('fmDay, fmdd. fmMonth yyyy'),unistr('DD.MM.RRRR'), 3079,'de_AT');
    ins_lang( 31, 'de-ch', null, 'German (Switzerland)', 'GERMAN', 'SWITZERLAND', null, 'WE8MSWIN1252',unistr('Deutsch'),unistr('fmDay, dd. Month yyyy'),unistr('DD.MM.RRRR'), 2055,'de_CH');
    ins_lang( 32, 'de-li', null, 'German (Liechtenstein)', 'GERMAN', 'GERMANY', null, 'WE8MSWIN1252',unistr('Deutsch'),unistr('fmDay, dd. Month yyyy'),unistr('DD.MM.RRRR'), 5127,'de_DE');
    ins_lang( 33, 'de-lu', null, 'German (Luxembourg)', 'GERMAN', 'LUXEMBOURG', null, 'WE8MSWIN1252',unistr('Deutsch'),unistr('fmDay, dd. Month yyyy'),unistr('DD.MM.RRRR'), 4103,'de_LU');
    ins_lang( 34, 'el', null, 'Greek', 'GREEK', 'GREECE', null, 'EL8MSWIN1253',unistr('\0395\03BB\03BB\03B7\03BD\03B9\03BA\03AC'),unistr('fmDay dd Month yyyy'),unistr('fmDD/MM/RRRR'), 1032,'el_GR');
    ins_lang( 35, 'en', null, 'English', 'AMERICAN', 'AMERICA', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay, Month fmdd, yyyy'),unistr('fmMM/DD/RRRR'), 1033,'en_US');
    ins_lang( 36, 'en-au', null, 'English (Australia)', 'ENGLISH', 'AUSTRALIA', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay, dd Month yyyy'),unistr('fmDD/fmMM/RRRR'), 3081,'en_AU');
    ins_lang( 37, 'en-bz', null, 'English (Belize)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'), 10249,'en_GB');
    ins_lang( 38, 'en-ca', null, 'English (Canada)', 'ENGLISH', 'CANADA', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay, Month dd, yyyy'),unistr('DD/MM/RRRR'), 4105,'en_CA');
    ins_lang( 39, 'en-gb', null, 'English (United Kingdom)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'), 2057,'en_GB');
    ins_lang( 40, 'en-ie', null, 'English (Ireland)', 'ENGLISH', 'IRELAND', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'), 6153,'en_GB');
    ins_lang( 41, 'en-jm', null, 'English (Jamaica)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'), 8201,'en_GB');
    ins_lang( 42, 'en-nz', null, 'English (New Zealand)', 'ENGLISH', 'NEW ZEALAND', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay, dd Month yyyy'),unistr('fmDD/fmMM/RRRR'), 5129,'en_NZ');
    ins_lang( 43, 'en-ph', null, 'English (Philippines)', 'ENGLISH', 'PHILIPPINES', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay, Month fmdd, yyyy'),unistr('fmMM/DD/RRRR'), 13321,'en_PH');
    ins_lang( 44, 'en-tt', null, 'English (Trinidad)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'), 11273,'en_GB');
    ins_lang( 45, 'en-us', null, 'English (United States)', 'AMERICAN', 'AMERICA', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay, Month fmdd, yyyy'),unistr('fmMM/DD/RRRR'), 1033,'en_US');
    ins_lang( 46, 'en-za', null, 'English (South Africa)', 'ENGLISH', 'SOUTH AFRICA', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('RRRR/MM/DD'), 7177,'en_ZA');
    ins_lang( 47, 'en-zw', null, 'English (Zimbabwe)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('English'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'), 12297,'en_ZW');
    ins_lang( 48, 'es', null, 'Spanish (Traditional Sort)', 'SPANISH', 'SPAIN', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 1034,'es_ES');
    ins_lang( 49, 'es-ar', null, 'Spanish (Argentina)', 'LATIN AMERICAN SPANISH', 'ARGENTINA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 11274,'es_AR');
    ins_lang( 50, 'es-bo', null, 'Spanish (Bolivia)', 'LATIN AMERICAN SPANISH', 'ARGENTINA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 16394,'es_BO');
    ins_lang( 51, 'es-cl', null, 'Spanish (Chile)', 'LATIN AMERICAN SPANISH', 'CHILE', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD-MM-RRRR'), 13322,'es_CL');
    ins_lang( 52, 'es-co', null, 'Spanish (Colombia)', 'LATIN AMERICAN SPANISH', 'COLOMBIA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 9226,'es_CO');
    ins_lang( 53, 'es-cr', null, 'Spanish (Costa Rica)', 'LATIN AMERICAN SPANISH', 'COSTA RICA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 5130,'es_CR');
    ins_lang( 54, 'es-do', null, 'Spanish (Dominican Republic)', 'LATIN AMERICAN SPANISH', 'PUERTO RICO', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 7178,'es_DO');
    ins_lang( 55, 'es-ec', null, 'Spanish (Ecuador)', 'LATIN AMERICAN SPANISH', 'ECUADOR', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 12298,'es_EC');
    ins_lang( 56, 'es-gt', null, 'Spanish (Guatemala)', 'LATIN AMERICAN SPANISH', 'GUATEMALA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 4106,'es_GT');
    ins_lang( 57, 'es-hn', null, 'Spanish (Honduras)', 'LATIN AMERICAN SPANISH', 'GUATEMALA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 18442,'es_HN');
    ins_lang( 58, 'es-mx', null, 'Spanish (Mexico)', 'MEXICAN SPANISH', 'MEXICO', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 2058,'es_MX');
    ins_lang( 59, 'es-ni', null, 'Spanish (Nicaragua)', 'LATIN AMERICAN SPANISH', 'NICARAGUA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 19466,'es_NI');
    ins_lang( 60, 'es-pa', null, 'Spanish (Panama)', 'LATIN AMERICAN SPANISH', 'PANAMA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('MM/DD/RRRR'), 6154,'es_PA');
    ins_lang( 61, 'es-pe', null, 'Spanish (Peru)', 'LATIN AMERICAN SPANISH', 'PERU', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 10250,'es_PE');
    ins_lang( 62, 'es-pr', null, 'Spanish (Puerto Rico)', 'LATIN AMERICAN SPANISH', 'PUERTO RICO', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 20490,'es_PR');
    ins_lang( 63, 'es-py', null, 'Spanish (Paraguay)', 'LATIN AMERICAN SPANISH', 'ARGENTINA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 15370,'es_PY');
    ins_lang( 64, 'es-sv', null, 'Spanish (El Salvador)', 'LATIN AMERICAN SPANISH', 'EL SALVADOR', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 17418,'es_SV');
    ins_lang( 65, 'es-us', null, 'Spanish (United States)', 'LATIN AMERICAN SPANISH', 'AMERICA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay, Month fmdd, yyyy'),unistr('fmMM/DD/RRRR'), 21514,'es_US');
    ins_lang( 66, 'es-uy', null, 'Spanish (Uruguay)', 'LATIN AMERICAN SPANISH', 'ARGENTINA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 14346,'es_UY');
    ins_lang( 67, 'es-ve', null, 'Spanish (Venezuela)', 'LATIN AMERICAN SPANISH', 'VENEZUELA', null, 'WE8MSWIN1252',unistr('Espa\00F1ol'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 8202,'es_VE');
    ins_lang( 68, 'et', null, 'Estonian', 'ESTONIAN', 'ESTONIA', null, 'BLT8MSWIN1257',unistr('Estonian'),unistr('fmDay, fmdd.mm.yyyy'),unistr('DD.MM.RRRR'), 1061,'et_EE');
    ins_lang( 69, 'eu', null, 'Basque', 'FRENCH', 'FRANCE', null, 'WE8MSWIN1252',unistr('Basque'),unistr('fmday dd month yyyy'),unistr('DD/MM/RRRR'), 1069,'eu_ES');
    ins_lang( 70, 'fa', null, 'Farsi', 'ENGLISH', 'UNITED KINGDOM', null, 'AR8MSWIN1256',unistr('\0641\0627\0631\0633\06CC'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'), 1065,'en_GB');
    ins_lang( 71, 'fi', null, 'Finnish', 'FINNISH', 'FINLAND', null, 'WE8MSWIN1252',unistr('suomi'),unistr('fmday dd. month"ta "yyyy'),unistr('fmDD.MM.RRRR'), 1035,'fi_FI');
    ins_lang( 72, 'fo', null, 'Faeroese', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('Faeroese'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'), 1080,'fo_FO');
    ins_lang( 73, 'fr', null, 'French (France)', 'FRENCH', 'FRANCE', null, 'WE8MSWIN1252',unistr('Fran\00E7ais'),unistr('fmday dd month yyyy'),unistr('DD/MM/RRRR'), 1036,'fr_FR');
    ins_lang( 74, 'fr-be', null, 'French (Belgium)', 'FRENCH', 'BELGIUM', null, 'WE8MSWIN1252',unistr('Fran\00E7ais'),unistr('fmday, dd month yyyy'),unistr('DD.MM.RRRR'), 2060,'fr_BE');
    ins_lang( 75, 'fr-ca', null, 'French (Canada)', 'CANADIAN FRENCH', 'CANADA', null, 'WE8MSWIN1252',unistr('Fran\00E7ais'),unistr('fmday dd month yyyy'),unistr('RRRR-MM-DD'), 3084,'fr_CA');
    ins_lang( 76, 'fr-ch', null, 'French (Switzerland)', 'FRENCH', 'SWITZERLAND', null, 'WE8MSWIN1252',unistr('French (Switzerland)'),unistr('fmday, dd. month yyyy'),unistr('DD.MM.RRRR'), 4108,'fr_CH');
    ins_lang( 77, 'fr-lu', null, 'French (Luxembourg)', 'FRENCH', 'LUXEMBOURG', null, 'WE8MSWIN1252',unistr('Fran\00E7ais'),unistr('fmday, dd month yyyy'),unistr('DD.MM.RRRR'), 5132,'fr_LU');
    ins_lang( 78, 'fr-mc', null, 'French (Monaco)', 'FRENCH', 'FRANCE', null, 'WE8MSWIN1252',unistr('Fran\00E7ais'),unistr('fmday dd month yyyy'),unistr('DD/MM/RRRR'), 6156,'fr_FR');
    ins_lang( 79, 'ga', null, 'Irish', 'IRISH', 'IRELAND', null, 'WE8MSWIN1252', unistr('Gaeilge'), unistr('fmDay fmdd fmMonth yyyy'), unistr('DD/MM/RRRR'), 2108,null);
    ins_lang( 80, 'gd', null, 'Gaelic', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('Gaelic'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'), 1084,null);
    ins_lang( 81, 'gl', null, 'Galician', 'SPANISH', 'SPAIN', null, 'WE8MSWIN1252',unistr('Galician'),unistr('fmDay dd" de "Month" de "yyyy'),unistr('DD/MM/RRRR'), 1110,'gl_ES');
    ins_lang( 82, 'gu', null, 'Gujarati', 'GUJARATI', 'INDIA', null, 'AL32UTF8',unistr('\0A97\0AC1\0A9C\0AB0\0ABE\0AA4\0AC0'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'), 1095,'gu_IN');
    ins_lang( 83, 'he', null, 'Hebrew', 'HEBREW', 'ISRAEL', null, 'IW8MSWIN1255',unistr('\05E2\05D1\05E8\05D9\05EA'),unistr('fmDay dd Month yyyy'),unistr('DD/MM/RRRR'), 1037,'he_IL');
    ins_lang( 84, 'hi', null, 'Hindi', 'HINDI', 'INDIA', null, 'AL32UTF8',unistr('\0939\093F\0928\094D\0926\0940'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'), 1081,'hi_IN');
    ins_lang( 85, 'hr', null, 'Croatian', 'CROATIAN', 'CROATIA', null, 'EE8MSWIN1250',unistr('Hrvatski'),unistr('fmday, dd. month yyyy'),unistr('DD.MM.RR'), 1050,'hr_HR');
    ins_lang( 86, 'hu', null, 'Hungarian', 'HUNGARIAN', 'HUNGARY', null, 'EE8MSWIN1250',unistr('magyar'),unistr('fmyyyy. month dd., day'),unistr('RRRR.MM.DD.'), 1038,'hu_HU');
    ins_lang( 87, 'id', null, 'Indonesian', 'INDONESIAN', 'INDONESIA', null, 'WE8MSWIN1252',unistr('Bahasa Indonesia'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD-MM-RRRR'), 1057,'id_ID');
    ins_lang( 88, 'is', null, 'Icelandic', 'ICELANDIC', 'ICELAND', null, 'WE8MSWIN1252',unistr('\00EDslenska'),unistr('fmday dd. month yyyy'),unistr('DD.MM.RRRR'), 1039,'is_IS');
    ins_lang( 89, 'it', null, 'Italian (Italy)', 'ITALIAN', 'ITALY', null, 'WE8MSWIN1252',unistr('Italiano'),unistr('fmday dd month yyyy'),unistr('DD/MM/RRRR'), 1040,'it_IT');
    ins_lang( 90, 'it-ch', null, 'Italian (Switzerland)', 'ITALIAN', 'SWITZERLAND', null, 'WE8MSWIN1252',unistr('Italiano'),unistr('fmday, dd. month yyyy'),unistr('DD.MM.RRRR'), 2064,'it_CH');
    ins_lang( 91, 'ja', null, 'Japanese', 'JAPANESE', 'JAPAN', null, 'JA16SJIS',unistr('\65E5\672C\8A9E'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" Day'),unistr('RRRR/MM/DD'), 1041,'ja_JP');
    ins_lang( 92, 'kk', null, 'Kazakh', 'CYRILLIC KAZAKH', 'KAZAKHSTAN', null, 'CL8MSWIN1251',unistr('Kazakh'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD.MM.RRRR'), 1087,null);
    ins_lang( 93, 'kn', null, 'Kannada', 'KANNADA', 'INDIA', null, 'AL32UTF8',unistr('\0C95\0CA8\0CCD\0CA8\0CA1'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'), 1099,null);
    ins_lang( 94, 'ko', null, 'Korean', 'KOREAN', 'KOREA', null, 'KO16MSWIN949',unistr('\D55C\AD6D\C5B4'),unistr('fmyyyy"\B144" mm"\C6D4" dd"\C77C" day'),unistr('RRRR/MM/DD'), 1042,'ko_KR');
    ins_lang( 95, 'kok', null, 'Konkani', 'KOREAN', 'KOREA', null, 'KO16MSWIN949',unistr('Konkani'),unistr('fmyyyy"\B144" mm"\C6D4" dd"\C77C" day'),unistr('RRRR/MM/DD'), 1111,'ko_KR');
    ins_lang( 96, 'kz', null, 'Kyrgyz', 'RUSSIAN', 'RUSSIA', null, 'CL8MSWIN1251',unistr('Kyrgyz'),unistr('fmday dd month yyyy "\0433."'),unistr('DD.MM.RRRR'), 1088,'ru_RU');
    ins_lang( 97, 'lt', null, 'Lithuanian', 'LITHUANIAN', 'LITHUANIA', null, 'BLT8MSWIN1257',unistr('Lietuvi\0173'),unistr('fmday yyyy"m." month dd "d."'),unistr('RRRR-MM-DD'), 1063,'lt_LT');
    ins_lang( 98, 'lv', null, 'Latvian', 'LATVIAN', 'LATVIA', null, 'BLT8MSWIN1257',unistr('Latvie\0161u valoda'),unistr('fmDay, yyyy". gada "dd. Month'),unistr('RRRR.MM.DD'), 1062,'lv_LV');
    ins_lang( 99, 'mk', null, 'FYRO Macedonian', 'MACEDONIAN', 'FYR MACEDONIA', null, 'CL8MSWIN1251',unistr('\041C\0430\043A\0435\0434\043E\043D\0441\043A\0438'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD.MM.RRRR'), 1071,'mk_MK');
    ins_lang( 100, 'ml', null, 'Malayalam', 'MALAYALAM', 'INDIA', null, 'AL32UTF8',unistr('\0D2E\0D32\0D2F\0D3E\0D33\0D02'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'), 1100,null);
    ins_lang( 101, 'mr', null, 'Marathi', 'MARATHI', 'INDIA', null, 'AL32UTF8',unistr('\092E\0930\093E\0920\0940'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'), 1102,null);
    ins_lang( 102, 'ms', null, 'Malay (Malaysia)', 'MALAY', 'MALAYSIA', null, 'WE8MSWIN1252',unistr('Bahasa Malaysia'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'), 1086,'ms_MY');
    ins_lang( 103, 'mt', null, 'Maltese', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('Maltese'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'), 1082,null);
    ins_lang( 104, 'nb-no', null, 'Norwegian (Bokmal)', 'NORWEGIAN', 'NORWAY', null, 'WE8MSWIN1252',unistr('Norsk'),unistr('fmday dd. month yyyy'),unistr('DD.MM.RRRR'), 1044,'no_NO');
    ins_lang( 105, 'ne', null, 'Nepali (India)', 'ENGLISH', 'UNITED KINGDOM', null, 'WE8MSWIN1252',unistr('Nepali (India)'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'), 1121,null);
    ins_lang( 106, 'nl', null, 'Dutch (Netherlands)', 'DUTCH', 'THE NETHERLANDS', null, 'WE8MSWIN1252',unistr('Nederlands'),unistr('fmday dd month yyyy'),unistr('fmDD-MM-RRRR'), 1043,'nl_NL');
    ins_lang( 107, 'nl-be', null, 'Dutch (Belgium)', 'DUTCH', 'BELGIUM', null, 'WE8MSWIN1252',unistr('Nederlands'),unistr('fmday dd month yyyy'),unistr('fmDD/fmMM/RRRR'), 2067,'nl_BE');
    ins_lang( 108, 'nn-no', null, 'Norwegian (Nynorsk)', 'NORWEGIAN', 'NORWAY', null, 'WE8MSWIN1252',unistr('Norsk'),unistr('fmday dd. month yyyy'),unistr('DD.MM.RRRR'), 2068,'no_NO');
    ins_lang( 109, 'no', null, 'Norwegian (Bokmal)', 'NORWEGIAN', 'NORWAY', null, 'WE8MSWIN1252',unistr('Norsk'),unistr('fmday dd. month yyyy'),unistr('DD.MM.RRRR'), 1044,'no_NO');
    ins_lang( 110, 'or', null, 'Oriya', 'ORIYA', 'INDIA', null, 'AL32UTF8',unistr('\0B13\0B21\0B3F\0B06'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'), 1096,null);
    ins_lang( 111, 'pa', null, 'Punjabi', 'PUNJABI', 'INDIA', null, 'AL32UTF8',unistr('Punjabi'),unistr('dd fmmonth yyyy day'),unistr('DD-MM-RR'), 1094,null);
    ins_lang( 112, 'pl', null, 'Polish', 'POLISH', 'POLAND', null, 'EE8MSWIN1250',unistr('polski'),unistr('fmday, dd month yyyy'),unistr('RRRR-MM-DD'), 1045,'pl_PL');
    ins_lang( 113, 'pt', null, 'Portuguese (Portugal)', 'PORTUGUESE', 'PORTUGAL', null, 'WE8MSWIN1252',unistr('Portugu\00EAs (Portugal)'),unistr('fmday, dd" de "Month" de "yyyy'),unistr('DD-MM-RRRR'), 2070,'pt_PT');
    ins_lang( 114, 'pt-br', null, 'Portuguese (Brazil)', 'BRAZILIAN PORTUGUESE', 'BRAZIL', null, 'WE8MSWIN1252',unistr('Portugu\00EAs (Brasil)'),unistr('fmday, dd" de "month" de "yyyy'),unistr('fmDD/MM/RRRR'), 1046,'pt_BR');
    ins_lang( 115, 'ro', null, 'Romanian', 'ROMANIAN', 'ROMANIA', null, 'EE8MSWIN1250',unistr('Rom\00E2n\0103'),unistr('fmday, dd month yyyy'),unistr('DD.MM.RRRR'), 1048,'ro_RO');
    ins_lang( 116, 'ru', null, 'Russian', 'RUSSIAN', 'RUSSIA', null, 'CL8MSWIN1251',unistr('\0420\0443\0441\0441\043A\0438\0439'),unistr('fmday dd month yyyy "\0433."'),unistr('DD.MM.RRRR'), 1049,'ru_RU');
    ins_lang( 117, 'ru-md', null, 'Russian (Moldova)', 'RUSSIAN', 'RUSSIA', null, 'CL8MSWIN1251',unistr('\0420\0443\0441\0441\043A\0438\0439'),unistr('fmday dd month yyyy "\0433."'),unistr('DD.MM.RRRR'), 2073,'ru_RU');
    ins_lang( 118, 'sk', null, 'Slovak', 'SLOVAK', 'SLOVAKIA', null, 'EE8MSWIN1250',unistr('Sloven\010Dina'),unistr('fmday, dd. month yyyy'),unistr('DD.MM.RR'), 1051,'sk_SK');
    ins_lang( 119, 'sl', null, 'Slovenian', 'SLOVENIAN', 'SLOVENIA', null, 'EE8MSWIN1250',unistr('Sloven\0161\010Dina'),unistr('fmday, dd. month yyyy'),unistr('DD.MM.RR'), 1060,'sl_SI');
    ins_lang( 120, 'sr', null, 'Serbian', 'CYRILLIC SERBIAN', 'SERBIA AND MONTENEGRO', null, 'CL8MSWIN1251',unistr('\0441\0440\043F\0441\043A\0438'),unistr('fmday, dd. month yyyy'),unistr('DD.MM.RRRR'), 3098,'sr_RS');
    ins_lang( 121, 'sv', null, 'Swedish', 'SWEDISH', 'SWEDEN', null, 'WE8MSWIN1252',unistr('Svenska'),unistr('fmday "den "dd month yyyy'),unistr('RRRR-MM-DD'), 1053,'sv_SE');
    ins_lang( 122, 'sv-fi', null, 'Swedish (Finland)', 'SWEDISH', 'FINLAND', null, 'WE8MSWIN1252',unistr('Svenska'),unistr('fmday "den "dd month yyyy'),unistr('fmDD.MM.RRRR'), 2077,'sv_FI');
    ins_lang( 123, 'ta', null, 'Tamil', 'TAMIL', 'INDIA', null, 'AL32UTF8',unistr('\0BA4\0BAE\0BBF\0BB4\0BCD'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'), 1097,'ta_IN');
    ins_lang( 124, 'te', null, 'Telugu', 'TELUGU', 'INDIA', null, 'AL32UTF8',unistr('\0C24\0C46\0C32\0C41\0C17\0C41'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RR'), 1098,'te_IN');
    ins_lang( 125, 'th', null, 'Thai', 'THAI', 'THAILAND', null, 'TH8TISASCII',unistr('\0E44\0E17\0E22'),unistr('fmday dd month E yyyy'),unistr('DD/MM/RRRR'), 1054,'th_TH');
    ins_lang( 126, 'tr', null, 'Turkish', 'TURKISH', 'TURKEY', null, 'TR8MSWIN1254',unistr('T\00FCrk\00E7e'),unistr('dd fmMonth yyyy Day'),unistr('DD.MM.RRRR'), 1055,'tr_TR');
    ins_lang( 127, 'uk', null, 'Ukrainian', 'UKRAINIAN', 'UKRAINE', null, 'CL8MSWIN1251',unistr('\0423\043A\0440\0430\0457\043D\0441\044C\043A\0430'),unistr('fmday dd month yyyy" \0440\043E\043A\0443"'),unistr('DD.MM.RRRR'), 1058,'uk_UA');
    ins_lang( 128, 'ur', null, 'Urdu', 'ENGLISH', 'UNITED KINGDOM', null, 'AR8MSWIN1256',unistr('Urdu'),unistr('fmDay fmdd fmMonth yyyy'),unistr('DD/MM/RRRR'), 1056,'ur_PK');
    ins_lang( 129, 'uz', null, 'Uzbek', 'LATIN UZBEK', 'UZBEKISTAN', null, 'AL32UTF8',unistr('Uzbek'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD/MON/RR'), 1091,null);
    ins_lang( 130, 'vi', null, 'Vietnamese', 'VIETNAMESE', 'VIETNAM', null, 'VN8MSWIN1258',unistr('Ti\1EBFng Vi\1EC7t'),unistr('fmday fmdd fmmonth yyyy'),unistr('DD-MM-RRRR'), 1066,'vi_VN');
    ins_lang( 131, 'zh', null, 'Chinese', 'SIMPLIFIED CHINESE', 'CHINA', null, 'ZHS16GBK',unistr('\4E2D\6587\FF08\7B80\4F53\FF09'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" day'),unistr('RRRR-MM-DD'), 2052,'zh_CN');
    ins_lang( 132, 'zh-cn', null, 'Chinese (China)', 'SIMPLIFIED CHINESE', 'CHINA', null, 'ZHS16GBK',unistr('\4E2D\6587\FF08\7B80\4F53\FF09'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" day'),unistr('RRRR-MM-DD'), 2052,'zh_CN');
    ins_lang( 133, 'zh-hk', null, 'Chinese (Hong Kong SAR)', 'TRADITIONAL CHINESE', 'HONG KONG', null, 'ZHT16MSWIN950',unistr('Chinese (Hong Kong SAR)'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" day'),unistr('fmDD/MM/RRRR'), 3076,'zh_HK');
    ins_lang( 134, 'zh-mo', null, 'Chinese (Macau SAR)', 'TRADITIONAL CHINESE', 'HONG KONG', null, 'ZHT16MSWIN950',unistr('Chinese (Macau SAR)'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" day'),unistr('fmDD/MM/RRRR'), 5124,'zh_CN');
    ins_lang( 135, 'zh-sg', null, 'Chinese (Singapore)', 'SIMPLIFIED CHINESE', 'SINGAPORE', null, 'ZHS16GBK',unistr('Chinese (Singapore)'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" day'),unistr('fmDD/MM/RRRR'), 4100,'zh_CN');
    ins_lang( 136, 'zh-tw', null, 'Chinese (Taiwan)', 'TRADITIONAL CHINESE', 'TAIWAN', null, 'ZHT16MSWIN950',unistr('\4E2D\6587 (\7E41\9AD4)'),unistr('fmyyyy"\5E74"mm"\6708"dd"\65E5" day'),unistr('fmRRRR/MM/DD'), 1028,'zh_TW');
    ins_lang( 137, 'az', null, 'Azerbaijani', 'AZERBAIJANI', 'AZERBAIJAN', null, 'AL32UTF8',unistr('Az\0259rbaycan'),unistr('fmdd Month yyyy, Day'),unistr('DD.MM.RRRR'), 1068,null);
    ins_lang( 138, 'sw', null, 'Swahili', 'SWAHILI', 'KENYA', null, 'AL32UTF8', 'Swahili', unistr('Day, Month fmdd, yyyy'),unistr('fmMM/DD/RRRR'), 1089,null);

    update wwv_flow_languages set translated_lang_name = lang_name where translated_lang_name is null;
    commit;
end;
/

prompt
prompt ...wwv_flow_dbcharset_lang_map
prompt

declare
    procedure ins_dbchar (
        p_id                   in wwv_flow_dbcharset_lang_map.id%type,
        p_nls_db_charset       in wwv_flow_dbcharset_lang_map.nls_db_charset%type,
        p_language_code	       in wwv_flow_dbcharset_lang_map.language_code%type )
    is
    begin
        insert into wwv_flow_dbcharset_lang_map(id,nls_db_charset,language_code)
        values (p_id,p_nls_db_charset,p_language_code);
    end ins_dbchar;
begin
    delete from wwv_flow_dbcharset_lang_map;

    ins_dbchar(1,'AR8ADOS710','ar');
    ins_dbchar(2,'AR8ADOS710','en');
    ins_dbchar(3,'AR8ADOS710','id');
    ins_dbchar(4,'AR8ADOS710','ms');
    ins_dbchar(5,'AR8ADOS710','sw');
    ins_dbchar(6,'AR8ADOS720','ar');
    ins_dbchar(7,'AR8ADOS720','en');
    ins_dbchar(8,'AR8ADOS720','id');
    ins_dbchar(9,'AR8ADOS720','ms');
    ins_dbchar(10,'AR8ADOS720','sw');
    ins_dbchar(11,'AR8APTEC715','ar');
    ins_dbchar(12,'AR8APTEC715','en');
    ins_dbchar(13,'AR8APTEC715','id');
    ins_dbchar(14,'AR8APTEC715','ms');
    ins_dbchar(15,'AR8APTEC715','sw');
    ins_dbchar(16,'AR8ARABICMACS','ar');
    ins_dbchar(17,'AR8ARABICMACS','en');
    ins_dbchar(18,'AR8ARABICMACS','eu');
    ins_dbchar(19,'AR8ARABICMACS','id');
    ins_dbchar(20,'AR8ARABICMACS','ms');
    ins_dbchar(21,'AR8ARABICMACS','sw');
    ins_dbchar(22,'AR8ASMO8X','ar');
    ins_dbchar(23,'AR8ASMO8X','en');
    ins_dbchar(24,'AR8ASMO8X','id');
    ins_dbchar(25,'AR8ASMO8X','ms');
    ins_dbchar(26,'AR8ASMO8X','sw');
    ins_dbchar(27,'AR8ISO8859P6','ar');
    ins_dbchar(28,'AR8ISO8859P6','en');
    ins_dbchar(29,'AR8ISO8859P6','id');
    ins_dbchar(30,'AR8ISO8859P6','ms');
    ins_dbchar(31,'AR8ISO8859P6','sw');
    ins_dbchar(32,'AR8MSWIN1256','ar');
    ins_dbchar(33,'AR8MSWIN1256','en');
    ins_dbchar(34,'AR8MSWIN1256','fa');
    ins_dbchar(35,'AR8MSWIN1256','id');
    ins_dbchar(36,'AR8MSWIN1256','ms');
    ins_dbchar(37,'AR8MSWIN1256','sw');
    ins_dbchar(38,'AR8MSWIN1256','ur');
    ins_dbchar(39,'AR8MUSSAD768','ar');
    ins_dbchar(40,'AR8MUSSAD768','en');
    ins_dbchar(41,'AR8MUSSAD768','id');
    ins_dbchar(42,'AR8MUSSAD768','ms');
    ins_dbchar(43,'AR8MUSSAD768','sw');
    ins_dbchar(44,'AR8NAFITHA711','ar');
    ins_dbchar(45,'AR8NAFITHA711','en');
    ins_dbchar(46,'AR8NAFITHA711','id');
    ins_dbchar(47,'AR8NAFITHA711','ms');
    ins_dbchar(48,'AR8NAFITHA711','sw');
    ins_dbchar(49,'AR8NAFITHA721','ar');
    ins_dbchar(50,'AR8NAFITHA721','en');
    ins_dbchar(51,'AR8NAFITHA721','id');
    ins_dbchar(52,'AR8NAFITHA721','ms');
    ins_dbchar(53,'AR8NAFITHA721','sw');
    ins_dbchar(54,'AR8SAKHR706','ar');
    ins_dbchar(55,'AR8SAKHR706','da');
    ins_dbchar(56,'AR8SAKHR706','en');
    ins_dbchar(57,'AR8SAKHR706','eu');
    ins_dbchar(58,'AR8SAKHR706','id');
    ins_dbchar(59,'AR8SAKHR706','ms');
    ins_dbchar(60,'AR8SAKHR706','sw');
    ins_dbchar(61,'AR8SAKHR707','ar');
    ins_dbchar(62,'AR8SAKHR707','en');
    ins_dbchar(63,'AR8SAKHR707','id');
    ins_dbchar(64,'AR8SAKHR707','ms');
    ins_dbchar(65,'AR8SAKHR707','sw');
    ins_dbchar(66,'AZ8ISO8859P9E','az');
    ins_dbchar(67,'AZ8ISO8859P9E','ca');
    ins_dbchar(68,'AZ8ISO8859P9E','de');
    ins_dbchar(69,'AZ8ISO8859P9E','en');
    ins_dbchar(70,'AZ8ISO8859P9E','eu');
    ins_dbchar(71,'AZ8ISO8859P9E','ga');
    ins_dbchar(72,'AZ8ISO8859P9E','id');
    ins_dbchar(73,'AZ8ISO8859P9E','it');
    ins_dbchar(74,'AZ8ISO8859P9E','ms');
    ins_dbchar(75,'AZ8ISO8859P9E','pt');
    ins_dbchar(76,'AZ8ISO8859P9E','sq');
    ins_dbchar(77,'AZ8ISO8859P9E','sv');
    ins_dbchar(78,'AZ8ISO8859P9E','sw');
    ins_dbchar(79,'AZ8ISO8859P9E','tr');
    ins_dbchar(80,'BG8MSWIN','bg');
    ins_dbchar(81,'BG8MSWIN','en');
    ins_dbchar(82,'BG8MSWIN','id');
    ins_dbchar(83,'BG8MSWIN','ms');
    ins_dbchar(84,'BG8MSWIN','ru');
    ins_dbchar(85,'BG8MSWIN','sw');
    ins_dbchar(86,'BG8PC437S','bg');
    ins_dbchar(87,'BG8PC437S','en');
    ins_dbchar(88,'BG8PC437S','id');
    ins_dbchar(89,'BG8PC437S','ms');
    ins_dbchar(90,'BG8PC437S','sw');
    ins_dbchar(91,'BLT8CP921','da');
    ins_dbchar(92,'BLT8CP921','de');
    ins_dbchar(93,'BLT8CP921','en');
    ins_dbchar(94,'BLT8CP921','et');
    ins_dbchar(95,'BLT8CP921','fi');
    ins_dbchar(96,'BLT8CP921','id');
    ins_dbchar(97,'BLT8CP921','lt');
    ins_dbchar(98,'BLT8CP921','lv');
    ins_dbchar(99,'BLT8CP921','ms');
    ins_dbchar(100,'BLT8CP921','pl');
    ins_dbchar(101,'BLT8CP921','sl');
    ins_dbchar(102,'BLT8CP921','sw');
    ins_dbchar(103,'BLT8ISO8859P13','da');
    ins_dbchar(104,'BLT8ISO8859P13','de');
    ins_dbchar(105,'BLT8ISO8859P13','en');
    ins_dbchar(106,'BLT8ISO8859P13','et');
    ins_dbchar(107,'BLT8ISO8859P13','fi');
    ins_dbchar(108,'BLT8ISO8859P13','id');
    ins_dbchar(109,'BLT8ISO8859P13','lt');
    ins_dbchar(110,'BLT8ISO8859P13','lv');
    ins_dbchar(111,'BLT8ISO8859P13','ms');
    ins_dbchar(112,'BLT8ISO8859P13','pl');
    ins_dbchar(113,'BLT8ISO8859P13','sl');
    ins_dbchar(114,'BLT8ISO8859P13','sw');
    ins_dbchar(115,'BLT8MSWIN1257','da');
    ins_dbchar(116,'BLT8MSWIN1257','de');
    ins_dbchar(117,'BLT8MSWIN1257','en');
    ins_dbchar(118,'BLT8MSWIN1257','et');
    ins_dbchar(119,'BLT8MSWIN1257','fi');
    ins_dbchar(120,'BLT8MSWIN1257','id');
    ins_dbchar(121,'BLT8MSWIN1257','lt');
    ins_dbchar(122,'BLT8MSWIN1257','lv');
    ins_dbchar(123,'BLT8MSWIN1257','ms');
    ins_dbchar(124,'BLT8MSWIN1257','nb');
    ins_dbchar(125,'BLT8MSWIN1257','pl');
    ins_dbchar(126,'BLT8MSWIN1257','sl');
    ins_dbchar(127,'BLT8MSWIN1257','sw');
    ins_dbchar(128,'BLT8PC775','da');
    ins_dbchar(129,'BLT8PC775','de');
    ins_dbchar(130,'BLT8PC775','en');
    ins_dbchar(131,'BLT8PC775','et');
    ins_dbchar(132,'BLT8PC775','fi');
    ins_dbchar(133,'BLT8PC775','id');
    ins_dbchar(134,'BLT8PC775','lt');
    ins_dbchar(135,'BLT8PC775','lv');
    ins_dbchar(136,'BLT8PC775','ms');
    ins_dbchar(137,'BLT8PC775','pl');
    ins_dbchar(138,'BLT8PC775','sl');
    ins_dbchar(139,'BLT8PC775','sw');
    ins_dbchar(140,'BN8BSCII','as');
    ins_dbchar(141,'BN8BSCII','bn');
    ins_dbchar(142,'BN8BSCII','en');
    ins_dbchar(143,'BN8BSCII','id');
    ins_dbchar(144,'BN8BSCII','ms');
    ins_dbchar(145,'BN8BSCII','sw');
    ins_dbchar(146,'CDN8PC863','en');
    ins_dbchar(147,'CDN8PC863','id');
    ins_dbchar(148,'CDN8PC863','ms');
    ins_dbchar(149,'CDN8PC863','sq');
    ins_dbchar(150,'CDN8PC863','sw');
    ins_dbchar(151,'CEL8ISO8859P14','da');
    ins_dbchar(152,'CEL8ISO8859P14','de');
    ins_dbchar(153,'CEL8ISO8859P14','en');
    ins_dbchar(154,'CEL8ISO8859P14','es');
    ins_dbchar(155,'CEL8ISO8859P14','eu');
    ins_dbchar(156,'CEL8ISO8859P14','ga');
    ins_dbchar(157,'CEL8ISO8859P14','id');
    ins_dbchar(158,'CEL8ISO8859P14','it');
    ins_dbchar(159,'CEL8ISO8859P14','ms');
    ins_dbchar(160,'CEL8ISO8859P14','nb');
    ins_dbchar(161,'CEL8ISO8859P14','pt');
    ins_dbchar(162,'CEL8ISO8859P14','sq');
    ins_dbchar(163,'CEL8ISO8859P14','sv');
    ins_dbchar(164,'CEL8ISO8859P14','sw');
    ins_dbchar(165,'CL8ISO8859P5','be');
    ins_dbchar(166,'CL8ISO8859P5','bg');
    ins_dbchar(167,'CL8ISO8859P5','en');
    ins_dbchar(168,'CL8ISO8859P5','id');
    ins_dbchar(169,'CL8ISO8859P5','mk');
    ins_dbchar(170,'CL8ISO8859P5','ms');
    ins_dbchar(171,'CL8ISO8859P5','ru');
    ins_dbchar(172,'CL8ISO8859P5','sr');
    ins_dbchar(173,'CL8ISO8859P5','sw');
    ins_dbchar(174,'CL8ISOIR111','be');
    ins_dbchar(175,'CL8ISOIR111','bg');
    ins_dbchar(176,'CL8ISOIR111','en');
    ins_dbchar(177,'CL8ISOIR111','id');
    ins_dbchar(178,'CL8ISOIR111','mk');
    ins_dbchar(179,'CL8ISOIR111','ms');
    ins_dbchar(180,'CL8ISOIR111','ru');
    ins_dbchar(181,'CL8ISOIR111','sr');
    ins_dbchar(182,'CL8ISOIR111','sw');
    ins_dbchar(183,'CL8KOI8R','bg');
    ins_dbchar(184,'CL8KOI8R','en');
    ins_dbchar(185,'CL8KOI8R','id');
    ins_dbchar(186,'CL8KOI8R','ms');
    ins_dbchar(187,'CL8KOI8R','ru');
    ins_dbchar(188,'CL8KOI8R','sw');
    ins_dbchar(189,'CL8KOI8U','bg');
    ins_dbchar(190,'CL8KOI8U','en');
    ins_dbchar(191,'CL8KOI8U','id');
    ins_dbchar(192,'CL8KOI8U','ms');
    ins_dbchar(193,'CL8KOI8U','ru');
    ins_dbchar(194,'CL8KOI8U','sw');
    ins_dbchar(195,'CL8KOI8U','uk');
    ins_dbchar(196,'CL8MACCYRILLICS','be');
    ins_dbchar(197,'CL8MACCYRILLICS','bg');
    ins_dbchar(198,'CL8MACCYRILLICS','en');
    ins_dbchar(199,'CL8MACCYRILLICS','id');
    ins_dbchar(200,'CL8MACCYRILLICS','mk');
    ins_dbchar(201,'CL8MACCYRILLICS','ms');
    ins_dbchar(202,'CL8MACCYRILLICS','ru');
    ins_dbchar(203,'CL8MACCYRILLICS','sr');
    ins_dbchar(204,'CL8MACCYRILLICS','sw');
    ins_dbchar(205,'CL8MSWIN1251','be');
    ins_dbchar(206,'CL8MSWIN1251','bg');
    ins_dbchar(207,'CL8MSWIN1251','en');
    ins_dbchar(208,'CL8MSWIN1251','id');
    ins_dbchar(209,'CL8MSWIN1251','mk');
    ins_dbchar(210,'CL8MSWIN1251','ms');
    ins_dbchar(211,'CL8MSWIN1251','ru');
    ins_dbchar(212,'CL8MSWIN1251','sr');
    ins_dbchar(213,'CL8MSWIN1251','sw');
    ins_dbchar(214,'CL8MSWIN1251','uk');
    ins_dbchar(215,'EE8ISO8859P2','bs');
    ins_dbchar(216,'EE8ISO8859P2','cs');
    ins_dbchar(217,'EE8ISO8859P2','de');
    ins_dbchar(218,'EE8ISO8859P2','en');
    ins_dbchar(219,'EE8ISO8859P2','ga');
    ins_dbchar(220,'EE8ISO8859P2','hr');
    ins_dbchar(221,'EE8ISO8859P2','hu');
    ins_dbchar(222,'EE8ISO8859P2','id');
    ins_dbchar(223,'EE8ISO8859P2','ms');
    ins_dbchar(224,'EE8ISO8859P2','pl');
    ins_dbchar(225,'EE8ISO8859P2','ro');
    ins_dbchar(226,'EE8ISO8859P2','sk');
    ins_dbchar(227,'EE8ISO8859P2','sl');
    ins_dbchar(228,'EE8ISO8859P2','sq');
    ins_dbchar(229,'EE8ISO8859P2','sr-Latn');
    ins_dbchar(230,'EE8ISO8859P2','sw');
    ins_dbchar(231,'EE8ISO8859P2','tk');
    ins_dbchar(232,'EE8MACCES','cs');
    ins_dbchar(233,'EE8MACCES','de');
    ins_dbchar(234,'EE8MACCES','en');
    ins_dbchar(235,'EE8MACCES','et');
    ins_dbchar(236,'EE8MACCES','ga');
    ins_dbchar(237,'EE8MACCES','hu');
    ins_dbchar(238,'EE8MACCES','id');
    ins_dbchar(239,'EE8MACCES','lt');
    ins_dbchar(240,'EE8MACCES','ms');
    ins_dbchar(241,'EE8MACCES','pl');
    ins_dbchar(242,'EE8MACCES','sk');
    ins_dbchar(243,'EE8MACCES','sl');
    ins_dbchar(244,'EE8MACCES','sw');
    ins_dbchar(245,'EE8MACCROATIANS','da');
    ins_dbchar(246,'EE8MACCROATIANS','de');
    ins_dbchar(247,'EE8MACCROATIANS','en');
    ins_dbchar(248,'EE8MACCROATIANS','eu');
    ins_dbchar(249,'EE8MACCROATIANS','id');
    ins_dbchar(250,'EE8MACCROATIANS','ms');
    ins_dbchar(251,'EE8MACCROATIANS','sv');
    ins_dbchar(252,'EE8MACCROATIANS','sw');
    ins_dbchar(253,'EE8MSWIN1250','bs');
    ins_dbchar(254,'EE8MSWIN1250','cs');
    ins_dbchar(255,'EE8MSWIN1250','de');
    ins_dbchar(256,'EE8MSWIN1250','en');
    ins_dbchar(257,'EE8MSWIN1250','ga');
    ins_dbchar(258,'EE8MSWIN1250','hr');
    ins_dbchar(259,'EE8MSWIN1250','hu');
    ins_dbchar(260,'EE8MSWIN1250','id');
    ins_dbchar(261,'EE8MSWIN1250','ms');
    ins_dbchar(262,'EE8MSWIN1250','pl');
    ins_dbchar(263,'EE8MSWIN1250','ro');
    ins_dbchar(264,'EE8MSWIN1250','sk');
    ins_dbchar(265,'EE8MSWIN1250','sl');
    ins_dbchar(266,'EE8MSWIN1250','sq');
    ins_dbchar(267,'EE8MSWIN1250','sr-Latn');
    ins_dbchar(268,'EE8MSWIN1250','sw');
    ins_dbchar(269,'EE8MSWIN1250','tk');
    ins_dbchar(270,'EE8PC852','bs');
    ins_dbchar(271,'EE8PC852','cs');
    ins_dbchar(272,'EE8PC852','de');
    ins_dbchar(273,'EE8PC852','en');
    ins_dbchar(274,'EE8PC852','ga');
    ins_dbchar(275,'EE8PC852','hr');
    ins_dbchar(276,'EE8PC852','hu');
    ins_dbchar(277,'EE8PC852','id');
    ins_dbchar(278,'EE8PC852','ms');
    ins_dbchar(279,'EE8PC852','pl');
    ins_dbchar(280,'EE8PC852','sk');
    ins_dbchar(281,'EE8PC852','sl');
    ins_dbchar(282,'EE8PC852','sq');
    ins_dbchar(283,'EE8PC852','sr-Latn');
    ins_dbchar(284,'EE8PC852','sw');
    ins_dbchar(285,'EE8PC852','tk');
    ins_dbchar(286,'EL8DEC','el');
    ins_dbchar(287,'EL8DEC','en');
    ins_dbchar(288,'EL8DEC','id');
    ins_dbchar(289,'EL8DEC','ms');
    ins_dbchar(290,'EL8DEC','sw');
    ins_dbchar(291,'EL8ISO8859P7','el');
    ins_dbchar(292,'EL8ISO8859P7','en');
    ins_dbchar(293,'EL8ISO8859P7','id');
    ins_dbchar(294,'EL8ISO8859P7','ms');
    ins_dbchar(295,'EL8ISO8859P7','sw');
    ins_dbchar(296,'EL8MACGREEKS','el');
    ins_dbchar(297,'EL8MACGREEKS','en');
    ins_dbchar(298,'EL8MACGREEKS','eu');
    ins_dbchar(299,'EL8MACGREEKS','id');
    ins_dbchar(300,'EL8MACGREEKS','ms');
    ins_dbchar(301,'EL8MACGREEKS','sw');
    ins_dbchar(302,'EL8MSWIN1253','el');
    ins_dbchar(303,'EL8MSWIN1253','en');
    ins_dbchar(304,'EL8MSWIN1253','id');
    ins_dbchar(305,'EL8MSWIN1253','ms');
    ins_dbchar(306,'EL8MSWIN1253','sw');
    ins_dbchar(307,'EL8PC437S','el');
    ins_dbchar(308,'EL8PC437S','en');
    ins_dbchar(309,'EL8PC437S','id');
    ins_dbchar(310,'EL8PC437S','ms');
    ins_dbchar(311,'EL8PC437S','sw');
    ins_dbchar(312,'EL8PC851','el');
    ins_dbchar(313,'EL8PC851','en');
    ins_dbchar(314,'EL8PC851','id');
    ins_dbchar(315,'EL8PC851','ms');
    ins_dbchar(316,'EL8PC851','sw');
    ins_dbchar(317,'EL8PC869','el');
    ins_dbchar(318,'EL8PC869','en');
    ins_dbchar(319,'EL8PC869','id');
    ins_dbchar(320,'EL8PC869','ms');
    ins_dbchar(321,'EL8PC869','sw');
    ins_dbchar(322,'ET8MSWIN923','ca');
    ins_dbchar(323,'ET8MSWIN923','da');
    ins_dbchar(324,'ET8MSWIN923','de');
    ins_dbchar(325,'ET8MSWIN923','en');
    ins_dbchar(326,'ET8MSWIN923','es');
    ins_dbchar(327,'ET8MSWIN923','et');
    ins_dbchar(328,'ET8MSWIN923','eu');
    ins_dbchar(329,'ET8MSWIN923','fi');
    ins_dbchar(330,'ET8MSWIN923','ga');
    ins_dbchar(331,'ET8MSWIN923','id');
    ins_dbchar(332,'ET8MSWIN923','is');
    ins_dbchar(333,'ET8MSWIN923','it');
    ins_dbchar(334,'ET8MSWIN923','ms');
    ins_dbchar(335,'ET8MSWIN923','nb');
    ins_dbchar(336,'ET8MSWIN923','pt');
    ins_dbchar(337,'ET8MSWIN923','sq');
    ins_dbchar(338,'ET8MSWIN923','sv');
    ins_dbchar(339,'ET8MSWIN923','sw');
    ins_dbchar(340,'HU8ABMOD','ca');
    ins_dbchar(341,'HU8ABMOD','da');
    ins_dbchar(342,'HU8ABMOD','de');
    ins_dbchar(343,'HU8ABMOD','en');
    ins_dbchar(344,'HU8ABMOD','es');
    ins_dbchar(345,'HU8ABMOD','eu');
    ins_dbchar(346,'HU8ABMOD','ga');
    ins_dbchar(347,'HU8ABMOD','hu');
    ins_dbchar(348,'HU8ABMOD','id');
    ins_dbchar(349,'HU8ABMOD','is');
    ins_dbchar(350,'HU8ABMOD','it');
    ins_dbchar(351,'HU8ABMOD','ms');
    ins_dbchar(352,'HU8ABMOD','sq');
    ins_dbchar(353,'HU8ABMOD','sv');
    ins_dbchar(354,'HU8ABMOD','sw');
    ins_dbchar(355,'HU8CWI2','en');
    ins_dbchar(356,'HU8CWI2','eu');
    ins_dbchar(357,'HU8CWI2','ga');
    ins_dbchar(358,'HU8CWI2','hu');
    ins_dbchar(359,'HU8CWI2','id');
    ins_dbchar(360,'HU8CWI2','ms');
    ins_dbchar(361,'HU8CWI2','sw');
    ins_dbchar(362,'IN8ISCII','en');
    ins_dbchar(363,'IN8ISCII','hi');
    ins_dbchar(364,'IN8ISCII','id');
    ins_dbchar(365,'IN8ISCII','mr');
    ins_dbchar(366,'IN8ISCII','ms');
    ins_dbchar(367,'IN8ISCII','ne');
    ins_dbchar(368,'IN8ISCII','sw');
    ins_dbchar(369,'IS8PC861','da');
    ins_dbchar(370,'IS8PC861','de');
    ins_dbchar(371,'IS8PC861','en');
    ins_dbchar(372,'IS8PC861','ga');
    ins_dbchar(373,'IS8PC861','id');
    ins_dbchar(374,'IS8PC861','is');
    ins_dbchar(375,'IS8PC861','ms');
    ins_dbchar(376,'IS8PC861','sw');
    ins_dbchar(377,'IW8ISO8859P8','en');
    ins_dbchar(378,'IW8ISO8859P8','he');
    ins_dbchar(379,'IW8ISO8859P8','id');
    ins_dbchar(380,'IW8ISO8859P8','ms');
    ins_dbchar(381,'IW8ISO8859P8','sw');
    ins_dbchar(382,'IW8MACHEBREWS','en');
    ins_dbchar(383,'IW8MACHEBREWS','eu');
    ins_dbchar(384,'IW8MACHEBREWS','he');
    ins_dbchar(385,'IW8MACHEBREWS','id');
    ins_dbchar(386,'IW8MACHEBREWS','ms');
    ins_dbchar(387,'IW8MACHEBREWS','sw');
    ins_dbchar(388,'IW8MSWIN1255','en');
    ins_dbchar(389,'IW8MSWIN1255','he');
    ins_dbchar(390,'IW8MSWIN1255','id');
    ins_dbchar(391,'IW8MSWIN1255','ms');
    ins_dbchar(392,'IW8MSWIN1255','sw');
    ins_dbchar(393,'IW8PC1507','en');
    ins_dbchar(394,'IW8PC1507','he');
    ins_dbchar(395,'IW8PC1507','id');
    ins_dbchar(396,'IW8PC1507','ms');
    ins_dbchar(397,'IW8PC1507','sw');
    ins_dbchar(398,'JA16EUC','be');
    ins_dbchar(399,'JA16EUC','bg');
    ins_dbchar(400,'JA16EUC','bs');
    ins_dbchar(401,'JA16EUC','cs');
    ins_dbchar(402,'JA16EUC','da');
    ins_dbchar(403,'JA16EUC','de');
    ins_dbchar(404,'JA16EUC','el');
    ins_dbchar(405,'JA16EUC','en');
    ins_dbchar(406,'JA16EUC','es');
    ins_dbchar(407,'JA16EUC','et');
    ins_dbchar(408,'JA16EUC','eu');
    ins_dbchar(409,'JA16EUC','fi');
    ins_dbchar(410,'JA16EUC','fr');
    ins_dbchar(411,'JA16EUC','ga');
    ins_dbchar(412,'JA16EUC','hr');
    ins_dbchar(413,'JA16EUC','hu');
    ins_dbchar(414,'JA16EUC','id');
    ins_dbchar(415,'JA16EUC','it');
    ins_dbchar(416,'JA16EUC','ja');
    ins_dbchar(417,'JA16EUC','lt');
    ins_dbchar(418,'JA16EUC','mk');
    ins_dbchar(419,'JA16EUC','ms');
    ins_dbchar(420,'JA16EUC','mt');
    ins_dbchar(421,'JA16EUC','nb');
    ins_dbchar(422,'JA16EUC','pl');
    ins_dbchar(423,'JA16EUC','pt');
    ins_dbchar(424,'JA16EUC','ru');
    ins_dbchar(425,'JA16EUC','sk');
    ins_dbchar(426,'JA16EUC','sl');
    ins_dbchar(427,'JA16EUC','sq');
    ins_dbchar(428,'JA16EUC','sr');
    ins_dbchar(429,'JA16EUC','sr-Latn');
    ins_dbchar(430,'JA16EUC','sv');
    ins_dbchar(431,'JA16EUC','sw');
    ins_dbchar(432,'JA16EUC','tk');
    ins_dbchar(433,'JA16EUC','tr');
    ins_dbchar(434,'JA16EUCTILDE','be');
    ins_dbchar(435,'JA16EUCTILDE','bg');
    ins_dbchar(436,'JA16EUCTILDE','bs');
    ins_dbchar(437,'JA16EUCTILDE','cs');
    ins_dbchar(438,'JA16EUCTILDE','da');
    ins_dbchar(439,'JA16EUCTILDE','de');
    ins_dbchar(440,'JA16EUCTILDE','el');
    ins_dbchar(441,'JA16EUCTILDE','en');
    ins_dbchar(442,'JA16EUCTILDE','es');
    ins_dbchar(443,'JA16EUCTILDE','et');
    ins_dbchar(444,'JA16EUCTILDE','eu');
    ins_dbchar(445,'JA16EUCTILDE','fi');
    ins_dbchar(446,'JA16EUCTILDE','fr');
    ins_dbchar(447,'JA16EUCTILDE','ga');
    ins_dbchar(448,'JA16EUCTILDE','hr');
    ins_dbchar(449,'JA16EUCTILDE','hu');
    ins_dbchar(450,'JA16EUCTILDE','id');
    ins_dbchar(451,'JA16EUCTILDE','it');
    ins_dbchar(452,'JA16EUCTILDE','ja');
    ins_dbchar(453,'JA16EUCTILDE','lt');
    ins_dbchar(454,'JA16EUCTILDE','mk');
    ins_dbchar(455,'JA16EUCTILDE','ms');
    ins_dbchar(456,'JA16EUCTILDE','mt');
    ins_dbchar(457,'JA16EUCTILDE','nb');
    ins_dbchar(458,'JA16EUCTILDE','pl');
    ins_dbchar(459,'JA16EUCTILDE','pt');
    ins_dbchar(460,'JA16EUCTILDE','ru');
    ins_dbchar(461,'JA16EUCTILDE','sk');
    ins_dbchar(462,'JA16EUCTILDE','sl');
    ins_dbchar(463,'JA16EUCTILDE','sq');
    ins_dbchar(464,'JA16EUCTILDE','sr');
    ins_dbchar(465,'JA16EUCTILDE','sr-Latn');
    ins_dbchar(466,'JA16EUCTILDE','sv');
    ins_dbchar(467,'JA16EUCTILDE','sw');
    ins_dbchar(468,'JA16EUCTILDE','tk');
    ins_dbchar(469,'JA16EUCTILDE','tr');
    ins_dbchar(470,'JA16SJIS','bg');
    ins_dbchar(471,'JA16SJIS','en');
    ins_dbchar(472,'JA16SJIS','id');
    ins_dbchar(473,'JA16SJIS','ja');
    ins_dbchar(474,'JA16SJIS','ms');
    ins_dbchar(475,'JA16SJIS','ru');
    ins_dbchar(476,'JA16SJIS','sw');
    ins_dbchar(477,'JA16SJISTILDE','bg');
    ins_dbchar(478,'JA16SJISTILDE','en');
    ins_dbchar(479,'JA16SJISTILDE','id');
    ins_dbchar(480,'JA16SJISTILDE','ja');
    ins_dbchar(481,'JA16SJISTILDE','ms');
    ins_dbchar(482,'JA16SJISTILDE','ru');
    ins_dbchar(483,'JA16SJISTILDE','sw');
    ins_dbchar(484,'JA16VMS','bg');
    ins_dbchar(485,'JA16VMS','en');
    ins_dbchar(486,'JA16VMS','id');
    ins_dbchar(487,'JA16VMS','ja');
    ins_dbchar(488,'JA16VMS','ms');
    ins_dbchar(489,'JA16VMS','ru');
    ins_dbchar(490,'JA16VMS','sw');
    ins_dbchar(491,'KO16KSC5601','bg');
    ins_dbchar(492,'KO16KSC5601','en');
    ins_dbchar(493,'KO16KSC5601','id');
    ins_dbchar(494,'KO16KSC5601','ko');
    ins_dbchar(495,'KO16KSC5601','ms');
    ins_dbchar(496,'KO16KSC5601','ru');
    ins_dbchar(497,'KO16KSC5601','sw');
    ins_dbchar(498,'KO16KSCCS','bg');
    ins_dbchar(499,'KO16KSCCS','en');
    ins_dbchar(500,'KO16KSCCS','id');
    ins_dbchar(501,'KO16KSCCS','ko');
    ins_dbchar(502,'KO16KSCCS','ms');
    ins_dbchar(503,'KO16KSCCS','ru');
    ins_dbchar(504,'KO16KSCCS','sw');
    ins_dbchar(505,'KO16MSWIN949','bg');
    ins_dbchar(506,'KO16MSWIN949','en');
    ins_dbchar(507,'KO16MSWIN949','id');
    ins_dbchar(508,'KO16MSWIN949','ko');
    ins_dbchar(509,'KO16MSWIN949','ms');
    ins_dbchar(510,'KO16MSWIN949','ru');
    ins_dbchar(511,'KO16MSWIN949','sw');
    ins_dbchar(512,'LA8ISO6937','en');
    ins_dbchar(513,'LA8ISO6937','id');
    ins_dbchar(514,'LA8ISO6937','ms');
    ins_dbchar(515,'LA8ISO6937','sw');
    ins_dbchar(516,'LA8PASSPORT','ca');
    ins_dbchar(517,'LA8PASSPORT','de');
    ins_dbchar(518,'LA8PASSPORT','en');
    ins_dbchar(519,'LA8PASSPORT','ga');
    ins_dbchar(520,'LA8PASSPORT','hu');
    ins_dbchar(521,'LA8PASSPORT','id');
    ins_dbchar(522,'LA8PASSPORT','is');
    ins_dbchar(523,'LA8PASSPORT','it');
    ins_dbchar(524,'LA8PASSPORT','ms');
    ins_dbchar(525,'LA8PASSPORT','mt');
    ins_dbchar(526,'LA8PASSPORT','pl');
    ins_dbchar(527,'LA8PASSPORT','sq');
    ins_dbchar(528,'LA8PASSPORT','sw');
    ins_dbchar(529,'LA8PASSPORT','tr');
    ins_dbchar(530,'LT8MSWIN921','da');
    ins_dbchar(531,'LT8MSWIN921','de');
    ins_dbchar(532,'LT8MSWIN921','en');
    ins_dbchar(533,'LT8MSWIN921','et');
    ins_dbchar(534,'LT8MSWIN921','fi');
    ins_dbchar(535,'LT8MSWIN921','id');
    ins_dbchar(536,'LT8MSWIN921','lt');
    ins_dbchar(537,'LT8MSWIN921','lv');
    ins_dbchar(538,'LT8MSWIN921','ms');
    ins_dbchar(539,'LT8MSWIN921','pl');
    ins_dbchar(540,'LT8MSWIN921','sl');
    ins_dbchar(541,'LT8MSWIN921','sw');
    ins_dbchar(542,'LT8PC772','bg');
    ins_dbchar(543,'LT8PC772','en');
    ins_dbchar(544,'LT8PC772','id');
    ins_dbchar(545,'LT8PC772','lt');
    ins_dbchar(546,'LT8PC772','ms');
    ins_dbchar(547,'LT8PC772','ru');
    ins_dbchar(548,'LT8PC772','sl');
    ins_dbchar(549,'LT8PC772','sw');
    ins_dbchar(550,'LT8PC774','en');
    ins_dbchar(551,'LT8PC774','eu');
    ins_dbchar(552,'LT8PC774','fi');
    ins_dbchar(553,'LT8PC774','id');
    ins_dbchar(554,'LT8PC774','lt');
    ins_dbchar(555,'LT8PC774','ms');
    ins_dbchar(556,'LT8PC774','sl');
    ins_dbchar(557,'LT8PC774','sw');
    ins_dbchar(558,'LV8PC1117','da');
    ins_dbchar(559,'LV8PC1117','de');
    ins_dbchar(560,'LV8PC1117','en');
    ins_dbchar(561,'LV8PC1117','et');
    ins_dbchar(562,'LV8PC1117','fi');
    ins_dbchar(563,'LV8PC1117','id');
    ins_dbchar(564,'LV8PC1117','lt');
    ins_dbchar(565,'LV8PC1117','lv');
    ins_dbchar(566,'LV8PC1117','ms');
    ins_dbchar(567,'LV8PC1117','pl');
    ins_dbchar(568,'LV8PC1117','sl');
    ins_dbchar(569,'LV8PC1117','sw');
    ins_dbchar(570,'LV8PC8LR','bg');
    ins_dbchar(571,'LV8PC8LR','en');
    ins_dbchar(572,'LV8PC8LR','id');
    ins_dbchar(573,'LV8PC8LR','lv');
    ins_dbchar(574,'LV8PC8LR','ms');
    ins_dbchar(575,'LV8PC8LR','sl');
    ins_dbchar(576,'LV8PC8LR','sw');
    ins_dbchar(577,'LV8RST104090','bg');
    ins_dbchar(578,'LV8RST104090','en');
    ins_dbchar(579,'LV8RST104090','id');
    ins_dbchar(580,'LV8RST104090','lv');
    ins_dbchar(581,'LV8RST104090','ms');
    ins_dbchar(582,'LV8RST104090','sl');
    ins_dbchar(583,'LV8RST104090','sw');
    ins_dbchar(584,'N8PC865','da');
    ins_dbchar(585,'N8PC865','en');
    ins_dbchar(586,'N8PC865','eu');
    ins_dbchar(587,'N8PC865','id');
    ins_dbchar(588,'N8PC865','ms');
    ins_dbchar(589,'N8PC865','sw');
    ins_dbchar(590,'NE8ISO8859P10','da');
    ins_dbchar(591,'NE8ISO8859P10','de');
    ins_dbchar(592,'NE8ISO8859P10','en');
    ins_dbchar(593,'NE8ISO8859P10','et');
    ins_dbchar(594,'NE8ISO8859P10','fi');
    ins_dbchar(595,'NE8ISO8859P10','ga');
    ins_dbchar(596,'NE8ISO8859P10','id');
    ins_dbchar(597,'NE8ISO8859P10','is');
    ins_dbchar(598,'NE8ISO8859P10','lt');
    ins_dbchar(599,'NE8ISO8859P10','lv');
    ins_dbchar(600,'NE8ISO8859P10','ms');
    ins_dbchar(601,'NE8ISO8859P10','sl');
    ins_dbchar(602,'NE8ISO8859P10','sw');
    ins_dbchar(603,'NEE8ISO8859P4','da');
    ins_dbchar(604,'NEE8ISO8859P4','de');
    ins_dbchar(605,'NEE8ISO8859P4','en');
    ins_dbchar(606,'NEE8ISO8859P4','et');
    ins_dbchar(607,'NEE8ISO8859P4','fi');
    ins_dbchar(608,'NEE8ISO8859P4','id');
    ins_dbchar(609,'NEE8ISO8859P4','lt');
    ins_dbchar(610,'NEE8ISO8859P4','lv');
    ins_dbchar(611,'NEE8ISO8859P4','ms');
    ins_dbchar(612,'NEE8ISO8859P4','sl');
    ins_dbchar(613,'NEE8ISO8859P4','sw');
    ins_dbchar(614,'RU8BESTA','bg');
    ins_dbchar(615,'RU8BESTA','en');
    ins_dbchar(616,'RU8BESTA','id');
    ins_dbchar(617,'RU8BESTA','ms');
    ins_dbchar(618,'RU8BESTA','sw');
    ins_dbchar(619,'RU8PC855','be');
    ins_dbchar(620,'RU8PC855','bg');
    ins_dbchar(621,'RU8PC855','en');
    ins_dbchar(622,'RU8PC855','id');
    ins_dbchar(623,'RU8PC855','mk');
    ins_dbchar(624,'RU8PC855','ms');
    ins_dbchar(625,'RU8PC855','ru');
    ins_dbchar(626,'RU8PC855','sr');
    ins_dbchar(627,'RU8PC855','sw');
    ins_dbchar(628,'RU8PC866','bg');
    ins_dbchar(629,'RU8PC866','en');
    ins_dbchar(630,'RU8PC866','id');
    ins_dbchar(631,'RU8PC866','ms');
    ins_dbchar(632,'RU8PC866','ru');
    ins_dbchar(633,'RU8PC866','sw');
    ins_dbchar(634,'SE8ISO8859P3','ca');
    ins_dbchar(635,'SE8ISO8859P3','de');
    ins_dbchar(636,'SE8ISO8859P3','en');
    ins_dbchar(637,'SE8ISO8859P3','eu');
    ins_dbchar(638,'SE8ISO8859P3','ga');
    ins_dbchar(639,'SE8ISO8859P3','id');
    ins_dbchar(640,'SE8ISO8859P3','it');
    ins_dbchar(641,'SE8ISO8859P3','ms');
    ins_dbchar(642,'SE8ISO8859P3','mt');
    ins_dbchar(643,'SE8ISO8859P3','sq');
    ins_dbchar(644,'SE8ISO8859P3','sw');
    ins_dbchar(645,'SE8ISO8859P3','tr');
    ins_dbchar(646,'TH8MACTHAIS','en');
    ins_dbchar(647,'TH8MACTHAIS','id');
    ins_dbchar(648,'TH8MACTHAIS','ms');
    ins_dbchar(649,'TH8MACTHAIS','sw');
    ins_dbchar(650,'TH8MACTHAIS','th');
    ins_dbchar(651,'TH8TISASCII','en');
    ins_dbchar(652,'TH8TISASCII','id');
    ins_dbchar(653,'TH8TISASCII','ms');
    ins_dbchar(654,'TH8TISASCII','sw');
    ins_dbchar(655,'TH8TISASCII','th');
    ins_dbchar(656,'TR8DEC','ca');
    ins_dbchar(657,'TR8DEC','da');
    ins_dbchar(658,'TR8DEC','de');
    ins_dbchar(659,'TR8DEC','en');
    ins_dbchar(660,'TR8DEC','eu');
    ins_dbchar(661,'TR8DEC','fr');
    ins_dbchar(662,'TR8DEC','ga');
    ins_dbchar(663,'TR8DEC','id');
    ins_dbchar(664,'TR8DEC','it');
    ins_dbchar(665,'TR8DEC','ms');
    ins_dbchar(666,'TR8DEC','nb');
    ins_dbchar(667,'TR8DEC','pt');
    ins_dbchar(668,'TR8DEC','sq');
    ins_dbchar(669,'TR8DEC','sv');
    ins_dbchar(670,'TR8DEC','sw');
    ins_dbchar(671,'TR8DEC','tr');
    ins_dbchar(672,'TR8MACTURKISHS','ca');
    ins_dbchar(673,'TR8MACTURKISHS','da');
    ins_dbchar(674,'TR8MACTURKISHS','de');
    ins_dbchar(675,'TR8MACTURKISHS','en');
    ins_dbchar(676,'TR8MACTURKISHS','eu');
    ins_dbchar(677,'TR8MACTURKISHS','fr');
    ins_dbchar(678,'TR8MACTURKISHS','ga');
    ins_dbchar(679,'TR8MACTURKISHS','id');
    ins_dbchar(680,'TR8MACTURKISHS','it');
    ins_dbchar(681,'TR8MACTURKISHS','ms');
    ins_dbchar(682,'TR8MACTURKISHS','nb');
    ins_dbchar(683,'TR8MACTURKISHS','pt');
    ins_dbchar(684,'TR8MACTURKISHS','sq');
    ins_dbchar(685,'TR8MACTURKISHS','sv');
    ins_dbchar(686,'TR8MACTURKISHS','sw');
    ins_dbchar(687,'TR8MACTURKISHS','tr');
    ins_dbchar(688,'TR8MSWIN1254','ca');
    ins_dbchar(689,'TR8MSWIN1254','da');
    ins_dbchar(690,'TR8MSWIN1254','de');
    ins_dbchar(691,'TR8MSWIN1254','en');
    ins_dbchar(692,'TR8MSWIN1254','eu');
    ins_dbchar(693,'TR8MSWIN1254','fr');
    ins_dbchar(694,'TR8MSWIN1254','ga');
    ins_dbchar(695,'TR8MSWIN1254','id');
    ins_dbchar(696,'TR8MSWIN1254','it');
    ins_dbchar(697,'TR8MSWIN1254','ms');
    ins_dbchar(698,'TR8MSWIN1254','nb');
    ins_dbchar(699,'TR8MSWIN1254','pt');
    ins_dbchar(700,'TR8MSWIN1254','sq');
    ins_dbchar(701,'TR8MSWIN1254','sv');
    ins_dbchar(702,'TR8MSWIN1254','sw');
    ins_dbchar(703,'TR8MSWIN1254','tr');
    ins_dbchar(704,'TR8PC857','ca');
    ins_dbchar(705,'TR8PC857','da');
    ins_dbchar(706,'TR8PC857','de');
    ins_dbchar(707,'TR8PC857','en');
    ins_dbchar(708,'TR8PC857','eu');
    ins_dbchar(709,'TR8PC857','ga');
    ins_dbchar(710,'TR8PC857','id');
    ins_dbchar(711,'TR8PC857','it');
    ins_dbchar(712,'TR8PC857','ms');
    ins_dbchar(713,'TR8PC857','nb');
    ins_dbchar(714,'TR8PC857','pt');
    ins_dbchar(715,'TR8PC857','sq');
    ins_dbchar(716,'TR8PC857','sv');
    ins_dbchar(717,'TR8PC857','sw');
    ins_dbchar(718,'TR8PC857','tr');
    ins_dbchar(719,'US7ASCII','en');
    ins_dbchar(720,'US7ASCII','id');
    ins_dbchar(721,'US7ASCII','ms');
    ins_dbchar(722,'US7ASCII','sw');
    ins_dbchar(723,'US8PC437','en');
    ins_dbchar(724,'US8PC437','eu');
    ins_dbchar(725,'US8PC437','id');
    ins_dbchar(726,'US8PC437','ms');
    ins_dbchar(727,'US8PC437','sw');
    ins_dbchar(728,'VN8MSWIN1258','da');
    ins_dbchar(729,'VN8MSWIN1258','de');
    ins_dbchar(730,'VN8MSWIN1258','en');
    ins_dbchar(731,'VN8MSWIN1258','eu');
    ins_dbchar(732,'VN8MSWIN1258','fr');
    ins_dbchar(733,'VN8MSWIN1258','ga');
    ins_dbchar(734,'VN8MSWIN1258','id');
    ins_dbchar(735,'VN8MSWIN1258','ms');
    ins_dbchar(736,'VN8MSWIN1258','nl');
    ins_dbchar(737,'VN8MSWIN1258','sq');
    ins_dbchar(738,'VN8MSWIN1258','sv');
    ins_dbchar(739,'VN8MSWIN1258','sw');
    ins_dbchar(740,'VN8MSWIN1258','vi');
    ins_dbchar(741,'VN8VN3','en');
    ins_dbchar(742,'VN8VN3','id');
    ins_dbchar(743,'VN8VN3','ms');
    ins_dbchar(744,'VN8VN3','sw');
    ins_dbchar(745,'VN8VN3','vi');
    ins_dbchar(746,'WE8DEC','ca');
    ins_dbchar(747,'WE8DEC','da');
    ins_dbchar(748,'WE8DEC','de');
    ins_dbchar(749,'WE8DEC','en');
    ins_dbchar(750,'WE8DEC','eu');
    ins_dbchar(751,'WE8DEC','fr');
    ins_dbchar(752,'WE8DEC','ga');
    ins_dbchar(753,'WE8DEC','id');
    ins_dbchar(754,'WE8DEC','it');
    ins_dbchar(755,'WE8DEC','ms');
    ins_dbchar(756,'WE8DEC','nb');
    ins_dbchar(757,'WE8DEC','pt');
    ins_dbchar(758,'WE8DEC','sq');
    ins_dbchar(759,'WE8DEC','sv');
    ins_dbchar(760,'WE8DEC','sw');
    ins_dbchar(761,'WE8DG','da');
    ins_dbchar(762,'WE8DG','de');
    ins_dbchar(763,'WE8DG','en');
    ins_dbchar(764,'WE8DG','eu');
    ins_dbchar(765,'WE8DG','ga');
    ins_dbchar(766,'WE8DG','id');
    ins_dbchar(767,'WE8DG','it');
    ins_dbchar(768,'WE8DG','ms');
    ins_dbchar(769,'WE8DG','nb');
    ins_dbchar(770,'WE8DG','pt');
    ins_dbchar(771,'WE8DG','sq');
    ins_dbchar(772,'WE8DG','sv');
    ins_dbchar(773,'WE8DG','sw');
    ins_dbchar(774,'WE8ISO8859P1','ca');
    ins_dbchar(775,'WE8ISO8859P1','da');
    ins_dbchar(776,'WE8ISO8859P1','de');
    ins_dbchar(777,'WE8ISO8859P1','en');
    ins_dbchar(778,'WE8ISO8859P1','es');
    ins_dbchar(779,'WE8ISO8859P1','et');
    ins_dbchar(780,'WE8ISO8859P1','eu');
    ins_dbchar(781,'WE8ISO8859P1','fi');
    ins_dbchar(782,'WE8ISO8859P1','fr');
    ins_dbchar(783,'WE8ISO8859P1','ga');
    ins_dbchar(784,'WE8ISO8859P1','id');
    ins_dbchar(785,'WE8ISO8859P1','is');
    ins_dbchar(786,'WE8ISO8859P1','it');
    ins_dbchar(787,'WE8ISO8859P1','ms');
    ins_dbchar(788,'WE8ISO8859P1','nb');
    ins_dbchar(789,'WE8ISO8859P1','nl');
    ins_dbchar(790,'WE8ISO8859P1','pt');
    ins_dbchar(791,'WE8ISO8859P1','sq');
    ins_dbchar(792,'WE8ISO8859P1','sv');
    ins_dbchar(793,'WE8ISO8859P1','sw');
    ins_dbchar(794,'WE8ISO8859P15','ca');
    ins_dbchar(795,'WE8ISO8859P15','da');
    ins_dbchar(796,'WE8ISO8859P15','de');
    ins_dbchar(797,'WE8ISO8859P15','en');
    ins_dbchar(798,'WE8ISO8859P15','es');
    ins_dbchar(799,'WE8ISO8859P15','et');
    ins_dbchar(800,'WE8ISO8859P15','eu');
    ins_dbchar(801,'WE8ISO8859P15','fi');
    ins_dbchar(802,'WE8ISO8859P15','fr');
    ins_dbchar(803,'WE8ISO8859P15','ga');
    ins_dbchar(804,'WE8ISO8859P15','id');
    ins_dbchar(805,'WE8ISO8859P15','is');
    ins_dbchar(806,'WE8ISO8859P15','it');
    ins_dbchar(807,'WE8ISO8859P15','ms');
    ins_dbchar(808,'WE8ISO8859P15','nb');
    ins_dbchar(809,'WE8ISO8859P15','nl');
    ins_dbchar(810,'WE8ISO8859P15','pt');
    ins_dbchar(811,'WE8ISO8859P15','sq');
    ins_dbchar(812,'WE8ISO8859P15','sv');
    ins_dbchar(813,'WE8ISO8859P15','sw');
    ins_dbchar(814,'WE8ISO8859P9','ca');
    ins_dbchar(815,'WE8ISO8859P9','da');
    ins_dbchar(816,'WE8ISO8859P9','de');
    ins_dbchar(817,'WE8ISO8859P9','en');
    ins_dbchar(818,'WE8ISO8859P9','eu');
    ins_dbchar(819,'WE8ISO8859P9','ga');
    ins_dbchar(820,'WE8ISO8859P9','id');
    ins_dbchar(821,'WE8ISO8859P9','it');
    ins_dbchar(822,'WE8ISO8859P9','ms');
    ins_dbchar(823,'WE8ISO8859P9','nb');
    ins_dbchar(824,'WE8ISO8859P9','pt');
    ins_dbchar(825,'WE8ISO8859P9','sq');
    ins_dbchar(826,'WE8ISO8859P9','sv');
    ins_dbchar(827,'WE8ISO8859P9','sw');
    ins_dbchar(828,'WE8ISO8859P9','tr');
    ins_dbchar(829,'WE8MACROMAN8S','ca');
    ins_dbchar(830,'WE8MACROMAN8S','da');
    ins_dbchar(831,'WE8MACROMAN8S','de');
    ins_dbchar(832,'WE8MACROMAN8S','en');
    ins_dbchar(833,'WE8MACROMAN8S','eu');
    ins_dbchar(834,'WE8MACROMAN8S','fr');
    ins_dbchar(835,'WE8MACROMAN8S','ga');
    ins_dbchar(836,'WE8MACROMAN8S','id');
    ins_dbchar(837,'WE8MACROMAN8S','it');
    ins_dbchar(838,'WE8MACROMAN8S','ms');
    ins_dbchar(839,'WE8MACROMAN8S','nb');
    ins_dbchar(840,'WE8MACROMAN8S','pt');
    ins_dbchar(841,'WE8MACROMAN8S','sq');
    ins_dbchar(842,'WE8MACROMAN8S','sv');
    ins_dbchar(843,'WE8MACROMAN8S','sw');
    ins_dbchar(844,'WE8MSWIN1252','ca');
    ins_dbchar(845,'WE8MSWIN1252','da');
    ins_dbchar(846,'WE8MSWIN1252','de');
    ins_dbchar(847,'WE8MSWIN1252','en');
    ins_dbchar(848,'WE8MSWIN1252','es');
    ins_dbchar(849,'WE8MSWIN1252','et');
    ins_dbchar(850,'WE8MSWIN1252','eu');
    ins_dbchar(851,'WE8MSWIN1252','fi');
    ins_dbchar(852,'WE8MSWIN1252','fr');
    ins_dbchar(853,'WE8MSWIN1252','ga');
    ins_dbchar(854,'WE8MSWIN1252','id');
    ins_dbchar(855,'WE8MSWIN1252','is');
    ins_dbchar(856,'WE8MSWIN1252','it');
    ins_dbchar(857,'WE8MSWIN1252','ms');
    ins_dbchar(858,'WE8MSWIN1252','nb');
    ins_dbchar(859,'WE8MSWIN1252','nl');
    ins_dbchar(860,'WE8MSWIN1252','pt');
    ins_dbchar(861,'WE8MSWIN1252','sq');
    ins_dbchar(862,'WE8MSWIN1252','sv');
    ins_dbchar(863,'WE8MSWIN1252','sw');
    ins_dbchar(864,'WE8NCR4970','ca');
    ins_dbchar(865,'WE8NCR4970','da');
    ins_dbchar(866,'WE8NCR4970','de');
    ins_dbchar(867,'WE8NCR4970','en');
    ins_dbchar(868,'WE8NCR4970','eu');
    ins_dbchar(869,'WE8NCR4970','fr');
    ins_dbchar(870,'WE8NCR4970','ga');
    ins_dbchar(871,'WE8NCR4970','id');
    ins_dbchar(872,'WE8NCR4970','it');
    ins_dbchar(873,'WE8NCR4970','ms');
    ins_dbchar(874,'WE8NCR4970','nb');
    ins_dbchar(875,'WE8NCR4970','pt');
    ins_dbchar(876,'WE8NCR4970','sq');
    ins_dbchar(877,'WE8NCR4970','sv');
    ins_dbchar(878,'WE8NCR4970','sw');
    ins_dbchar(879,'WE8NEXTSTEP','ca');
    ins_dbchar(880,'WE8NEXTSTEP','da');
    ins_dbchar(881,'WE8NEXTSTEP','de');
    ins_dbchar(882,'WE8NEXTSTEP','en');
    ins_dbchar(883,'WE8NEXTSTEP','es');
    ins_dbchar(884,'WE8NEXTSTEP','eu');
    ins_dbchar(885,'WE8NEXTSTEP','ga');
    ins_dbchar(886,'WE8NEXTSTEP','id');
    ins_dbchar(887,'WE8NEXTSTEP','is');
    ins_dbchar(888,'WE8NEXTSTEP','it');
    ins_dbchar(889,'WE8NEXTSTEP','ms');
    ins_dbchar(890,'WE8NEXTSTEP','nb');
    ins_dbchar(891,'WE8NEXTSTEP','pt');
    ins_dbchar(892,'WE8NEXTSTEP','sq');
    ins_dbchar(893,'WE8NEXTSTEP','sv');
    ins_dbchar(894,'WE8NEXTSTEP','sw');
    ins_dbchar(895,'WE8PC850','ca');
    ins_dbchar(896,'WE8PC850','da');
    ins_dbchar(897,'WE8PC850','de');
    ins_dbchar(898,'WE8PC850','en');
    ins_dbchar(899,'WE8PC850','es');
    ins_dbchar(900,'WE8PC850','eu');
    ins_dbchar(901,'WE8PC850','ga');
    ins_dbchar(902,'WE8PC850','id');
    ins_dbchar(903,'WE8PC850','is');
    ins_dbchar(904,'WE8PC850','it');
    ins_dbchar(905,'WE8PC850','ms');
    ins_dbchar(906,'WE8PC850','nb');
    ins_dbchar(907,'WE8PC850','pt');
    ins_dbchar(908,'WE8PC850','sq');
    ins_dbchar(909,'WE8PC850','sv');
    ins_dbchar(910,'WE8PC850','sw');
    ins_dbchar(911,'WE8PC858','ca');
    ins_dbchar(912,'WE8PC858','da');
    ins_dbchar(913,'WE8PC858','de');
    ins_dbchar(914,'WE8PC858','en');
    ins_dbchar(915,'WE8PC858','es');
    ins_dbchar(916,'WE8PC858','eu');
    ins_dbchar(917,'WE8PC858','ga');
    ins_dbchar(918,'WE8PC858','id');
    ins_dbchar(919,'WE8PC858','is');
    ins_dbchar(920,'WE8PC858','it');
    ins_dbchar(921,'WE8PC858','ms');
    ins_dbchar(922,'WE8PC858','nb');
    ins_dbchar(923,'WE8PC858','pt');
    ins_dbchar(924,'WE8PC858','sq');
    ins_dbchar(925,'WE8PC858','sv');
    ins_dbchar(926,'WE8PC858','sw');
    ins_dbchar(927,'WE8PC860','en');
    ins_dbchar(928,'WE8PC860','eu');
    ins_dbchar(929,'WE8PC860','ga');
    ins_dbchar(930,'WE8PC860','id');
    ins_dbchar(931,'WE8PC860','it');
    ins_dbchar(932,'WE8PC860','ms');
    ins_dbchar(933,'WE8PC860','pt');
    ins_dbchar(934,'WE8PC860','sw');
    ins_dbchar(935,'WE8ROMAN8','ca');
    ins_dbchar(936,'WE8ROMAN8','da');
    ins_dbchar(937,'WE8ROMAN8','de');
    ins_dbchar(938,'WE8ROMAN8','en');
    ins_dbchar(939,'WE8ROMAN8','es');
    ins_dbchar(940,'WE8ROMAN8','eu');
    ins_dbchar(941,'WE8ROMAN8','ga');
    ins_dbchar(942,'WE8ROMAN8','id');
    ins_dbchar(943,'WE8ROMAN8','is');
    ins_dbchar(944,'WE8ROMAN8','it');
    ins_dbchar(945,'WE8ROMAN8','ms');
    ins_dbchar(946,'WE8ROMAN8','nb');
    ins_dbchar(947,'WE8ROMAN8','pt');
    ins_dbchar(948,'WE8ROMAN8','sq');
    ins_dbchar(949,'WE8ROMAN8','sv');
    ins_dbchar(950,'WE8ROMAN8','sw');
    ins_dbchar(951,'ZHS16CGB231280','bg');
    ins_dbchar(952,'ZHS16CGB231280','en');
    ins_dbchar(953,'ZHS16CGB231280','id');
    ins_dbchar(954,'ZHS16CGB231280','ms');
    ins_dbchar(955,'ZHS16CGB231280','ru');
    ins_dbchar(956,'ZHS16CGB231280','sw');
    ins_dbchar(957,'ZHS16CGB231280','zh-cn');
    ins_dbchar(958,'ZHS16GBK','bg');
    ins_dbchar(959,'ZHS16GBK','en');
    ins_dbchar(960,'ZHS16GBK','id');
    ins_dbchar(961,'ZHS16GBK','ja');
    ins_dbchar(962,'ZHS16GBK','ms');
    ins_dbchar(963,'ZHS16GBK','ru');
    ins_dbchar(964,'ZHS16GBK','sw');
    ins_dbchar(965,'ZHS16GBK','zh-cn');
    ins_dbchar(966,'ZHS16GBK','zh-tw');
    ins_dbchar(967,'ZHT16BIG5','en');
    ins_dbchar(968,'ZHT16BIG5','id');
    ins_dbchar(969,'ZHT16BIG5','ms');
    ins_dbchar(970,'ZHT16BIG5','sw');
    ins_dbchar(971,'ZHT16BIG5','zh-tw');
    ins_dbchar(972,'ZHT16CCDC','en');
    ins_dbchar(973,'ZHT16CCDC','id');
    ins_dbchar(974,'ZHT16CCDC','ms');
    ins_dbchar(975,'ZHT16CCDC','sw');
    ins_dbchar(976,'ZHT16CCDC','zh-tw');
    ins_dbchar(977,'ZHT16DBT','en');
    ins_dbchar(978,'ZHT16DBT','id');
    ins_dbchar(979,'ZHT16DBT','ms');
    ins_dbchar(980,'ZHT16DBT','sw');
    ins_dbchar(981,'ZHT16DBT','zh-tw');
    ins_dbchar(982,'ZHT16HKSCS','bg');
    ins_dbchar(983,'ZHT16HKSCS','en');
    ins_dbchar(984,'ZHT16HKSCS','id');
    ins_dbchar(985,'ZHT16HKSCS','ms');
    ins_dbchar(986,'ZHT16HKSCS','ru');
    ins_dbchar(987,'ZHT16HKSCS','sw');
    ins_dbchar(988,'ZHT16HKSCS','zh-tw');
    ins_dbchar(989,'ZHT16HKSCS31','bg');
    ins_dbchar(990,'ZHT16HKSCS31','en');
    ins_dbchar(991,'ZHT16HKSCS31','id');
    ins_dbchar(992,'ZHT16HKSCS31','ms');
    ins_dbchar(993,'ZHT16HKSCS31','ru');
    ins_dbchar(994,'ZHT16HKSCS31','sw');
    ins_dbchar(995,'ZHT16HKSCS31','zh-tw');
    ins_dbchar(996,'ZHT16MSWIN950','en');
    ins_dbchar(997,'ZHT16MSWIN950','id');
    ins_dbchar(998,'ZHT16MSWIN950','ms');
    ins_dbchar(999,'ZHT16MSWIN950','sw');
    ins_dbchar(1000,'ZHT16MSWIN950','zh-tw');
    ins_dbchar(1001,'ZHT32EUC','en');
    ins_dbchar(1002,'ZHT32EUC','id');
    ins_dbchar(1003,'ZHT32EUC','ms');
    ins_dbchar(1004,'ZHT32EUC','sw');
    ins_dbchar(1005,'ZHT32EUC','zh-tw');
    ins_dbchar(1006,'ZHT32SOPS','en');
    ins_dbchar(1007,'ZHT32SOPS','id');
    ins_dbchar(1008,'ZHT32SOPS','ms');
    ins_dbchar(1009,'ZHT32SOPS','sw');
    ins_dbchar(1010,'ZHT32SOPS','zh-tw');
    ins_dbchar(1011,'ZHT32TRIS','en');
    ins_dbchar(1012,'ZHT32TRIS','id');
    ins_dbchar(1013,'ZHT32TRIS','ms');
    ins_dbchar(1014,'ZHT32TRIS','sw');
    ins_dbchar(1015,'ZHT32TRIS','zh-tw');
    ins_dbchar(1016,'AL32UTF8','en');
    ins_dbchar(1017,'AL32UTF8','pt-br');
    ins_dbchar(1018,'AL32UTF8','it');
    ins_dbchar(1019,'AL32UTF8','ja');
    ins_dbchar(1020,'AL32UTF8','zh-cn');
    ins_dbchar(1021,'AL32UTF8','de');
    ins_dbchar(1022,'AL32UTF8','fr');
    ins_dbchar(1023,'AL32UTF8','ko');
    ins_dbchar(1024,'AL32UTF8','zh-tw');
    ins_dbchar(1025,'AL32UTF8','es');
    --
    ins_dbchar(1026,'AZ8ISO8859P9E','pt-br');
    ins_dbchar(1027,'CEL8ISO8859P14','pt-br');
    ins_dbchar(1028,'ET8MSWIN923','pt-br');
    ins_dbchar(1029,'JA16EUC','pt-br');
    ins_dbchar(1030,'JA16EUCTILDE','pt-br');
    ins_dbchar(1031,'TR8DEC','pt-br');
    ins_dbchar(1032,'TR8MACTURKISHS','pt-br');
    ins_dbchar(1033,'TR8MSWIN1254','pt-br');
    ins_dbchar(1034,'TR8PC857','pt-br');
    ins_dbchar(1035,'WE8DEC','pt-br');
    ins_dbchar(1036,'WE8DG','pt-br');
    ins_dbchar(1037,'WE8ISO8859P1','pt-br');
    ins_dbchar(1038,'WE8ISO8859P15','pt-br');
    ins_dbchar(1039,'WE8ISO8859P9','pt-br');
    ins_dbchar(1040,'WE8MACROMAN8S','pt-br');
    ins_dbchar(1041,'WE8MSWIN1252','pt-br');
    ins_dbchar(1042,'WE8NCR4970','pt-br');
    ins_dbchar(1043,'WE8NEXTSTEP','pt-br');
    ins_dbchar(1044,'WE8PC850','pt-br');
    ins_dbchar(1045,'WE8PC858','pt-br');
    ins_dbchar(1046,'WE8PC860','pt-br');
    ins_dbchar(1047,'WE8ROMAN8','pt-br');
    ins_dbchar(1048,'UTF8','en');
    ins_dbchar(1049,'UTF8','pt-br');
    ins_dbchar(1050,'UTF8','it');
    ins_dbchar(1051,'UTF8','ja');
    ins_dbchar(1052,'UTF8','zh-cn');
    ins_dbchar(1053,'UTF8','de');
    ins_dbchar(1054,'UTF8','fr');
    ins_dbchar(1055,'UTF8','ko');
    ins_dbchar(1056,'UTF8','zh-tw');
    ins_dbchar(1057,'UTF8','es');


    commit;
end;
/

prompt
prompt ...insert into wwv_flow_standard_events
prompt

begin
delete from wwv_flow_standard_events;
----------------
-- Browser events (both jQuery and jQuery Mobile abstractions)
----------------
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('focusout',                    'Lose Focus',                     'BROWSER',  'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('focusin',                     'Get Focus',                      'BROWSER',  'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('load',                        'Resource Load',                  'BROWSER',  'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('resize',                      'Resize',                         'BROWSER',  'DESKTOP');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('scroll',                      'Scroll',                         'BROWSER',  'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('unload',                      'Page Unload',                    'BROWSER',  'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('click',                       'Click',                          'BROWSER',  'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('dblclick',                    'Double Click',                   'BROWSER',  'DESKTOP');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('mousedown',                   'Mouse Button Press',             'BROWSER',  'DESKTOP');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('mouseup',                     'Mouse Button Release',           'BROWSER',  'DESKTOP');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('mousemove',                   'Mouse Move',                     'BROWSER',  'DESKTOP');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('mouseenter',                  'Mouse Enter',                    'BROWSER',  'DESKTOP');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('mouseleave',                  'Mouse Leave',                    'BROWSER',  'DESKTOP');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('change',                      'Change',                         'BROWSER',  'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('select',                      'Select',                         'BROWSER',  'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('keydown',                     'Key Down',                       'BROWSER',  'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('keypress',                    'Key Press',                      'BROWSER',  'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('keyup',                       'Key Release',                    'BROWSER',  'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('ready',                       'Page Load',                      'BROWSER',  'DESKTOP:JQM_SMARTPHONE');
-- JQM Touch Events
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('tap',                         'Tap',                            'BROWSER',  'JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('taphold',                     'Tap and Hold',                   'BROWSER',  'JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('swipe',                       'Swipe',                          'BROWSER',  'JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('swipeleft',                   'Swipe Left',                     'BROWSER',  'JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('swiperight',                  'Swipe Right',                    'BROWSER',  'JQM_SMARTPHONE');
-- JQM Virtual Mouse
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('vmousedown',                  'Touch Start',                    'BROWSER',  'JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('vmousemove',                  'Touch Move',                     'BROWSER',  'JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('vmouseup',                    'Touch End',                      'BROWSER',  'JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('vclick',                      'Virtual Click',                  'BROWSER',  'JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('vmousecancel',                'Touch Cancel',                   'BROWSER',  'JQM_SMARTPHONE');
-- JQM Orientation
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('orientationchange',           'Orientation Change',             'BROWSER',  'JQM_SMARTPHONE');
-- JQM Scroll
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('scrollstart',                 'Scroll Start',                   'BROWSER',  'JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('scrollstop',                  'Scroll Stop',                    'BROWSER',  'JQM_SMARTPHONE');
-- Hammer Events
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('apextap',                     'Tap',                            'BROWSER',  'DESKTOP');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('apexdoubletap',               'Double Tap',                     'BROWSER',  'DESKTOP');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('apexpress',                   'Press',                          'BROWSER',  'DESKTOP');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('apexpan',                     'Pan',                            'BROWSER',  'DESKTOP');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('apexswipe',                   'Swipe',                          'BROWSER',  'DESKTOP');
----------------
-- APEX events
----------------
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('apexbeforerefresh',           'Before Refresh',                 'APEX',     'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('apexafterrefresh',            'After Refresh',                  'APEX',     'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('apexbeforepagesubmit',        'Before Page Submit',             'APEX',     'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('apexafterclosedialog',        'Close Dialog Page',              'APEX',     'DESKTOP:JQM_SMARTPHONE');
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('apexafterclosecanceldialog',  'Close or Cancel Dialog Page',    'APEX',     'DESKTOP:JQM_SMARTPHONE');
----------------
-- Custom event
----------------
insert into wwv_flow_standard_events(name,display_name,event_type,supported_ui_types) values ('custom',                      'Custom',                         'CUSTOM',   'DESKTOP:JQM_SMARTPHONE');

commit;
end;
/
--==============================================================================
prompt ...
prompt ...insert into wwv_flow_web_entry_points
prompt ...
declare
    c_appun constant varchar2(30) := wwv_flow.g_flow_schema_owner;
    procedure add (
        p_name        in varchar2,               -- name in CGI PATH_INFO
        p_methods     in varchar2,               -- request method (GET, GET:POST, ...)
        p_is_legacy   in boolean default false ) -- true if entry point is not actively used by engine anymore
    is
        l_origin  wwv_flow_web_entry_points.origin%type;
    begin
        l_origin  := case when p_is_legacy   then 'LEGACY' else 'INTERN' end;
        insert into wwv_flow_web_entry_points (
            id,
            name,
            request_methods,
            origin,
            created_by,
            created_on )
        values (
            wwv_flow_id.next_val,
            p_name,
            p_methods,
            l_origin,
            user,
            sysdate );
    end add;
begin
    delete from wwv_flow_web_entry_points;
    --
    -- global public procedures
    --
    add('APEX_ADMIN'                                      , 'GET');
    add('APEX'                                            , 'GET');
    add('APEX_LOGIN'                                      , 'GET'      , p_is_legacy => true);
    add('F'                                               , 'GET,POST');
    add('HTMLDB_ADMIN'                                    , 'GET'      , p_is_legacy => true);
    add('HTMLDB'                                          , 'GET'      , p_is_legacy => true);
    add('HTMLDB_LOGIN'                                    , 'GET'      , p_is_legacy => true);
    add('P'                                               , 'GET');
    add('WS'                                              , 'GET');
    add('Z'                                               , 'GET');
    --
    -- authorized procedures in public packages
    --
    add('APEX_APPLICATION.ACCEPT'                         , 'GET,POST' , p_is_legacy => true);
    add('APEX_APPLICATION.AJAX'                           , 'GET,POST');
    add('APEX_APPLICATION.HELP'                           , 'GET'      , p_is_legacy => true);
    add('APEX_APPLICATION.JS_MESSAGES'                    , 'GET'      , p_is_legacy => true);
    add('APEX_APPLICATION.S'                              , 'GET,POST' , p_is_legacy => true);
    add('APEX_APPLICATION.SHOW'                           , 'GET,POST');
    --
    add('APEX_AUTHENTICATION.CALLBACK'                    , 'GET,POST');
    add('APEX_AUTHENTICATION.CALLBACK2'                   , 'GET,POST');
    add('APEX_AUTHENTICATION.LOGOUT'                      , 'GET');
    add('APEX_AUTHENTICATION.SAML_CALLBACK'               , 'GET,POST');
    add('APEX_AUTHENTICATION.SAML_METADATA'               , 'GET');
    --
    add('APEX_CUSTOM_AUTH.LOGOUT'                         , 'GET'      , p_is_legacy => true);
    add('APEX_CUSTOM_AUTH.LOGOUT_THEN_GO_TO_PAGE'         , 'GET'      , p_is_legacy => true);
    add('APEX_CUSTOM_AUTH.LOGOUT_THEN_GO_TO_URL'          , 'GET'      , p_is_legacy => true);
    --
    add('APEX_SESSION.EMIT_TIMEOUTS'                      , 'GET');
    --
    add('APEX_UTIL.COUNT_CLICK'                           , 'GET');
    add('APEX_UTIL.GET_BLOB'                              , 'GET');
    add('APEX_UTIL.GET_BLOB_FILE'                         , 'GET');
    add('APEX_UTIL.GET_FILE'                              , 'GET');
    --
    add('HTMLDB_CUSTOM_AUTH.LOGOUT'                       , 'GET'      , p_is_legacy => true);
    add('HTMLDB_CUSTOM_AUTH.LOGOUT_THEN_GO_TO_PAGE'       , 'GET'      , p_is_legacy => true);
    add('HTMLDB_CUSTOM_AUTH.LOGOUT_THEN_GO_TO_URL'        , 'GET'      , p_is_legacy => true);
    --
    add('HTMLDB_UTIL.COUNT_CLICK'                         , 'GET'      , p_is_legacy => true);
    add('HTMLDB_UTIL.GET_BLOB'                            , 'GET'      , p_is_legacy => true);
    add('HTMLDB_UTIL.GET_BLOB_FILE'                       , 'GET'      , p_is_legacy => true);
    add('HTMLDB_UTIL.GET_FILE'                            , 'GET'      , p_is_legacy => true);
    --
    add('WWV_FLOW.ACCEPT'                                 , 'GET,POST'); -- GET allowed for better error msgs
    add('WWV_FLOW.AJAX'                                   , 'GET,POST');
    add('WWV_FLOW.HELP'                                   , 'GET');
    add('WWV_FLOW.JS_MESSAGES'                            , 'GET');
    add('WWV_FLOW.S'                                      , 'GET,POST' , p_is_legacy => true);
    add('WWV_FLOW.SHOW'                                   , 'GET,POST'  );
    --
    add('WWV_FLOW_CUSTOMIZE.ACCEPT'                       , 'POST');
    add('WWV_FLOW_CUSTOMIZE.SHOW'                         , 'GET');
    --
    add('WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PAGE'             , 'GET');--     , p_is_legacy => true);
    add('WWV_FLOW_CUSTOM_AUTH_STD.LOGOUT'                 , 'GET');--     , p_is_legacy => true);
    add('WWV_FLOW_CUSTOM_AUTH_STD.LOGOUT_THEN_GO_TO_PAGE' , 'GET');--     , p_is_legacy => true);
    add('WWV_FLOW_CUSTOM_AUTH_STD.LOGOUT_THEN_GO_TO_URL'  , 'GET');--     , p_is_legacy => true);
    add('WWV_FLOW_CUSTOM_AUTH_STD.WS_LOGOUT'              , 'GET');
    --
    add('WWV_FLOW_FILE_MGR.GET_FILE'                      , 'GET');
    add('WWV_FLOW_FILE_MGR.GET_TEAM_FILE'                 , 'GET'      , p_is_legacy => true);
    add('WWV_FLOW_FILE_MGR.GET_WS_FILE'                   , 'GET');
    --
    add('WWV_FLOW_ITEM_HELP.SHOW_HELP'                    , 'GET');
    add('WWV_FLOW_ITEM_HELP.SHOW_PLUGIN_ATTRIBUTE_HELP'   , 'GET');
    --
    add('WWV_FLOW_LISTENER'                               , 'GET');
    --
    add('WWV_FLOW_UTILITIES.GEN_POPUP_LIST'               , 'GET');
    add('WWV_FLOW_UTILITIES.GET_THEME_FILE'               , 'GET');
    add('WWV_FLOW_UTILITIES.SHOW_AS_POPUP_CALENDAR'       , 'GET');
    add('WWV_FLOW_UTILITIES.SHOW_IR_HELP'                 , 'GET');
end;
/
