prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- Oracle APEX export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_220100 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_imp.import_begin (
 p_version_yyyy_mm_dd=>'2022.04.12'
,p_release=>'22.1.0-17'
,p_default_workspace_id=>10
,p_default_application_id=>4600
,p_default_id_offset=>0
,p_default_owner=>'APEX_220100'
);
end;
/
 
prompt APPLICATION 4600 - Oracle APEX Issues
--
-- Application Export:
--   Application:     4600
--   Name:            Oracle APEX Issues
--   Exported By:     APEX_220100
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                     43
--       Items:                  142
--       Computations:            20
--       Validations:              9
--       Processes:               84
--       Regions:                168
--       Buttons:                106
--       Dynamic Actions:         63
--     Shared Components:
--       Logic:
--         Items:                 23
--         Processes:              1
--         Computations:           2
--         Build Options:          3
--       Navigation:
--         Lists:                  8
--         Breadcrumbs:            1
--           Entries:             27
--       Security:
--         Authentication:         1
--         Authorization:         11
--       User Interface:
--         Themes:                 1
--         Templates:
--           Page:                 8
--           Region:              39
--           Label:               11
--           List:                17
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           1
--           Button:               7
--           Report:              22
--         LOVs:                  11
--         Shortcuts:              2
--         Plug-ins:              14
--       Globalization:
--       Reports:
--       E-Mail:
--         Templates:              2
--     Supporting Objects:  Included
--   Version:         22.1.0-17
--   Instance ID:     697845941895809
--

prompt --application/delete_application
begin
wwv_flow_imp.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_imp.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_220100')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX Issues')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'APEXISSUES4600')
,p_application_group=>wwv_flow_imp.id(91050719712959059)
,p_application_group_name=>'APEX Product'
,p_application_group_comment=>'Applications shipped with the APEX product distribution'
,p_page_view_logging=>'YES'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt_last_reset=>'20220418132209'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'19.2'
,p_flow_language=>'en'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_publish_yn=>'Y'
,p_documentation_banner=>'Oracle APEX Team Development to track and manage issues.'
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_imp.id(544702116026132813)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 22.1.0-17'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_deep_linking=>'Y'
,p_security_scheme=>wwv_flow_imp.id(183695412901211253)
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_friendly_url=>'N'
,p_substitution_string_01=>'MSG_LANGUAGE'
,p_substitution_value_01=>'Language'
,p_substitution_string_02=>'MSG_USER'
,p_substitution_value_02=>'User'
,p_substitution_string_03=>'MSG_COMPANY'
,p_substitution_value_03=>'Workspace: &COMPANY.'
,p_substitution_string_04=>'DELETE_MSG'
,p_substitution_value_04=>'Would you like to perform this delete action?'
,p_substitution_string_05=>'PRODUCT_NAME'
,p_substitution_value_05=>'Oracle APEX'
,p_substitution_string_06=>'HELP'
,p_substitution_value_06=>'Help'
,p_substitution_string_07=>'EDIT'
,p_substitution_value_07=>'Edit'
,p_substitution_string_08=>'TOP'
,p_substitution_value_08=>'Top'
,p_substitution_string_09=>'CLOSE'
,p_substitution_value_09=>'Close'
,p_substitution_string_10=>'MSG_COPYRIGHT'
,p_substitution_value_10=>'Copyright &copy; 1999, 2022, Oracle and/or its affiliates.'
,p_substitution_string_11=>'DATE_FORMAT'
,p_substitution_value_11=>'mm/dd/yyyy'
,p_substitution_string_12=>'MSG_JSCRIPT'
,p_substitution_value_12=>'You must run this product with JavaScript enabled.'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20220418132209'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_ui_type_name => null
,p_print_server_type=>'INSTANCE'
,p_is_pwa=>'N'
);
end;
/
prompt --application/shared_components/navigation/lists/issues_jump_menu
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(5181728677916157)
,p_name=>'Issues Jump Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16168536941093080)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Issues'
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-list'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16180080482256471)
,p_list_item_display_sequence=>11
,p_list_item_link_text=>'View My Profile'
,p_list_item_link_target=>'f?p=&APP_ID.:500:&SESSION.::&DEBUG.:RP:P500_USER_NAME:&APP_USER.:'
,p_list_item_icon=>'fa fa-user'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16172422180101261)
,p_list_item_display_sequence=>12
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5181944583916158)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Manage Labels'
,p_list_item_link_target=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-tags'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5182389007916162)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Manage Milestones'
,p_list_item_link_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-map-signs'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5182706276916162)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Manage Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-files-o'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16177134226140587)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16168929118093088)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-wrench'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_tabs
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(5251802537036599)
,p_name=>'APEX 5 - Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5252023031036605)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'App Builder'
,p_list_item_link_target=>'f?p=4000:1500:&SESSION.::&DEBUG.::::'
,p_list_item_icon_alt_attribute=>'App Builder Drill Down'
,p_list_text_01=>'tab-app-builder'
,p_security_scheme=>wwv_flow_imp.id(183694515603211251)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5253638356036613)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Create'
,p_list_item_link_target=>'f?p=4000:56:&SESSION.::NO:56,103,104,106,130,131,35,227,3020,3000,3001:FB_FLOW_ID,FB_FLOW_PAGE_ID:'
,p_parent_list_item_id=>wwv_flow_imp.id(5252023031036605)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5254074795036613)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Import'
,p_list_item_link_target=>'f?p=4000:460:&SESSION.::&DEBUG.:460:F4000_P56_CREATE_OPTION,P460_FILE_TYPE:IMP,FLOW_EXPORT:'
,p_parent_list_item_id=>wwv_flow_imp.id(5252023031036605)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5254449813036614)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Export'
,p_list_item_link_target=>'f?p=4000:523:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(5252023031036605)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5254843947036614)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(5252023031036605)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5255289379036614)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Workspace Utilities'
,p_parent_list_item_id=>wwv_flow_imp.id(5252023031036605)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5255655140036614)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'All Workspace Utilities'
,p_list_item_link_target=>'f?p=4000:182:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(5255289379036614)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5256075954036614)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(5255289379036614)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5256434081036615)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'App Builder Defaults'
,p_list_item_link_target=>'f?p=4000:800:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(5255289379036614)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5256834468036615)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>'Workspace Themes'
,p_list_item_link_target=>'f?p=4000:763:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(5255289379036614)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5257222669036615)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>'Application Groups'
,p_list_item_link_target=>'f?p=4000:722:&SESSION.::&DEBUG.:RP'
,p_parent_list_item_id=>wwv_flow_imp.id(5255289379036614)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5257610331036615)
,p_list_item_display_sequence=>180
,p_list_item_link_text=>'APEX Views'
,p_list_item_link_target=>'f?p=4000:714:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(5255289379036614)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5258089674036615)
,p_list_item_display_sequence=>190
,p_list_item_link_text=>'Cross Application Reports'
,p_list_item_link_target=>'f?p=4000:9009:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(5255289379036614)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5259273028036616)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'SQL Workshop'
,p_list_item_link_target=>'f?p=4500:3002:&SESSION.'
,p_list_item_icon_alt_attribute=>'SQL Workshop Drill Down'
,p_list_text_01=>'tab-sql-workshop'
,p_security_scheme=>wwv_flow_imp.id(183694924473211252)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5259665699036616)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'Object Browser'
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5259273028036616)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5260069543036617)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'SQL Commands'
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5259273028036616)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5260436953036617)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'SQL Scripts'
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5259273028036616)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'Utilities'
,p_parent_list_item_id=>wwv_flow_imp.id(5259273028036616)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5261243650036617)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>'All Utilities'
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5261654532036617)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5262022150036639)
,p_list_item_display_sequence=>270
,p_list_item_link_text=>'Data Workshop'
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5262417967036639)
,p_list_item_display_sequence=>280
,p_list_item_link_text=>'Query Builder'
,p_list_item_link_target=>'f?p=4500:1002:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5262856644036640)
,p_list_item_display_sequence=>290
,p_list_item_link_text=>'Quick SQL'
,p_list_item_link_target=>'f?p=4500:1100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5263253617036640)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Sample Datasets'
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5263623442036640)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>'Generate DDL'
,p_list_item_link_target=>'f?p=4500:12:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1693971489305645)
,p_list_item_display_sequence=>315
,p_list_item_link_text=>'Data Generator'
,p_list_item_link_target=>'f?p=4500:4000:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_security_scheme=>wwv_flow_imp.id(1755605405001643)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5264073733036640)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>'User Interface Defaults'
,p_list_item_link_target=>'f?p=4500:813:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5264428148036640)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>'Schema Comparison'
,p_list_item_link_target=>'f?p=4500:1350:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5264878435036641)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>'Methods on Tables'
,p_list_item_link_target=>'f?p=4500:120:&SESSION.::NO::P117_CREATE_PACKAGE:TABLE'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5265215399036641)
,p_list_item_display_sequence=>350
,p_list_item_link_text=>'Recycle Bin'
,p_list_item_link_target=>'f?p=4500:1070:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5265626007036641)
,p_list_item_display_sequence=>360
,p_list_item_link_text=>'Object Reports'
,p_list_item_link_target=>'f?p=4500:1042:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5266058341036641)
,p_list_item_display_sequence=>370
,p_list_item_link_text=>'About Database'
,p_list_item_link_target=>'f?p=4500:36:&SESSION.'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_list_item_disp_condition2=>'PLSQL'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5266483775036641)
,p_list_item_display_sequence=>380
,p_list_item_link_text=>'Database Monitor'
,p_list_item_link_target=>'f?p=4500:11:&SESSION.'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_list_item_disp_condition2=>'PLSQL'
,p_parent_list_item_id=>wwv_flow_imp.id(5260839481036617)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5266819235036642)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>'RESTful Services'
,p_list_item_link_target=>'f?p=4850:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(5259273028036616)
,p_security_scheme=>wwv_flow_imp.id(807841331942262216)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5297237022094844)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Team Development'
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>'Issues Drill Down'
,p_list_text_01=>'tab-team-dev'
,p_security_scheme=>wwv_flow_imp.id(183695412901211253)
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5298294556155132)
,p_list_item_display_sequence=>390
,p_list_item_link_text=>'Labels'
,p_list_item_link_target=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_imp.id(5297237022094844)
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5299469878216734)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>'Milestones'
,p_list_item_link_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_imp.id(5297237022094844)
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5299708358219790)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>'Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(5297237022094844)
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5302803126254705)
,p_list_item_display_sequence=>420
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(5297237022094844)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5298748302170715)
,p_list_item_display_sequence=>430
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(5297237022094844)
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5267230397036642)
,p_list_item_display_sequence=>440
,p_list_item_link_text=>'Feedback'
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.:RP'
,p_list_item_icon_alt_attribute=>'Team Development Drill Down'
,p_parent_list_item_id=>wwv_flow_imp.id(5297237022094844)
,p_list_text_01=>'tab-team-dev'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5275699929036648)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Gallery'
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.'
,p_list_text_01=>'tab-apps'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'NEVER'
);
end;
/
prompt --application/shared_components/navigation/lists/issues_action_menu
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(6321465669737549)
,p_name=>'Issues Action Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6321683875737582)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Edit Title'
,p_list_item_link_target=>'f?p=&APP_ID.:102:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-pencil-square-o'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' ',
'  from wwv_flow_issues',
' where id = :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id',
'   and (created_by = :APP_USER',
'        or ',
'        instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') >0)'))
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6395527024620562)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Edit Issue Text'
,p_list_item_link_target=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-pencil-square-o'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' ',
'  from wwv_flow_issues',
' where id = :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id',
'   and (created_by = :APP_USER',
'        or ',
'        instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') >0)'))
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6428625570476851)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6322436967737593)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Set Assignees'
,p_list_item_link_target=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-user-edit'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6322865946737593)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Set Labels'
,p_list_item_link_target=>'f?p=&APP_ID.:107:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-tags'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6323201645737593)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Set Milestones'
,p_list_item_link_target=>'f?p=&APP_ID.:106:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-map-signs'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6659247514556184)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6397756984628146)
,p_list_item_display_sequence=>81
,p_list_item_link_text=>'Associate with App and Page'
,p_list_item_link_target=>'f?p=&APP_ID.:104:&SESSION.::&DEBUG.:104:::'
,p_list_item_icon=>'fa fa-window-plus'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6322058914737592)
,p_list_item_display_sequence=>85
,p_list_item_link_text=>'Mark as Duplicate'
,p_list_item_link_target=>'f?p=&APP_ID.:103:&SESSION.::&DEBUG.:103:::'
,p_list_item_icon=>'fa fa-synonym'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6667497053606755)
,p_list_item_display_sequence=>86
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10542353923952887)
,p_list_item_display_sequence=>87
,p_list_item_link_text=>'Delete Issue'
,p_list_item_icon=>'fa fa-trash-o'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' ',
'  from wwv_flow_issues',
' where id = :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id',
'   and (created_by = :APP_USER',
'        or ',
'        instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') >0)'))
,p_list_text_01=>'delete_issue_item'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10542678463952909)
,p_list_item_display_sequence=>88
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6667150941606755)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Close Issue'
,p_list_item_link_target=>'javascript:apex.page.submit(''CLOSE'');'
,p_list_item_icon=>'fa fa-check-circle-o'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P100_STATUS'
,p_list_item_disp_condition2=>'OPEN'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6668182022614506)
,p_list_item_display_sequence=>95
,p_list_item_link_text=>'Reopen Issue'
,p_list_item_link_target=>'javascript:apex.page.submit(''REOPEN'');'||wwv_flow.LF||
''
,p_list_item_icon=>'fa fa-undo-alt'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P100_STATUS'
,p_list_item_disp_condition2=>'CLOSED'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/issues_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(10555300999175496)
,p_name=>'Issues Utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10555576852175501)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Manage Deleted Issues'
,p_list_item_link_target=>'f?p=&APP_ID.:2010:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-exclamation-circle-o'
,p_list_text_01=>'Purge or Reinstate issues that have been deleted.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10883541872039963)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Manage Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.:RP,1000:::'
,p_list_item_icon=>'fa fa-synonym'
,p_list_text_01=>'Manage Templates for Issues and Comments.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11079055119909322)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Manage Milestones'
,p_list_item_link_target=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:RP,200:::'
,p_list_item_icon=>'fa fa-map-signs'
,p_list_text_01=>'Manage Milestones available to assign to Issues'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11079571642916049)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Manage Labels'
,p_list_item_link_target=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP,300:::'
,p_list_item_icon=>'fa fa-tags'
,p_list_text_01=>'Manage Label Groups and Labels available to assign to Issues'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11085752017069486)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'View Files'
,p_list_item_link_target=>'f?p=&APP_ID.:2030:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-folder-file'
,p_list_text_01=>'View details of the files uploaded to Issues.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11085146769053736)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Purge Data'
,p_list_item_link_target=>'f?p=&APP_ID.:2020:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-trash-o'
,p_list_text_01=>'Purge all data for the selected component(s).'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11086206760089752)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Update Assignees'
,p_list_item_link_target=>'f?p=&APP_ID.:2040:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-user-check'
,p_list_text_01=>'Perform bulk reassignment of Issues assigned to a given user.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11086771269112985)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Reassign Owner'
,p_list_item_link_target=>'f?p=&APP_ID.:2050:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-users'
,p_list_text_01=>'Bulk reassignment of issue owner to a given user.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11087216341139132)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Remove Milestone from All Issues'
,p_list_item_link_target=>'f?p=&APP_ID.:2060:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-map-signs fam-minus fam-is-disabled fa-lg'
,p_list_text_01=>'Remove a given milestone from all issues.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11087732023154648)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Remove Labels from All Issues'
,p_list_item_link_target=>'f?p=&APP_ID.:2070:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-tags fam-minus fam-is-disabled fa-lg'
,p_list_text_01=>'Remove specified Labels from all Issues.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1639797396471215)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Manage User Notification Preferences'
,p_list_item_link_target=>'f?p=&APP_ID.:2080:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'fa fa-envelope-o'
,p_list_text_01=>'Manage the notification preferences for all users  in the workspace.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/user_tabs
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(11496705512045322)
,p_name=>'User Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11496998817045325)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Issues'
,p_list_item_link_target=>'f?p=&APP_ID.:500:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11497325343045337)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Notifications'
,p_list_item_link_target=>'f?p=&APP_ID.:502:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/navigation_icons
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(182126621824656316)
,p_name=>'navigation icons'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_administration_header
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(702381952631922533)
,p_name=>'APEX 5 - Administration (Header)'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702382115982922536)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Administration'
,p_list_item_link_target=>'f?p=4350:1:&APP_SESSION.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702382408956922537)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702382744919922537)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Manage Service'
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702383056161922537)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Manage Service'
,p_list_item_link_target=>'f?p=4350:21:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(702382744919922537)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702383312325922537)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(702382744919922537)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702383669443922538)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Make a Service Request'
,p_list_item_link_target=>'f?p=4350:96:&SESSION.::NO:49::'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_list_item_disp_condition2=>'PLSQL'
,p_parent_list_item_id=>wwv_flow_imp.id(702382744919922537)
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(322768539415392140)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Set Workspace Preferences'
,p_list_item_link_target=>'f?p=4350:17:&SESSION.::NO:RP::'
,p_parent_list_item_id=>wwv_flow_imp.id(702382744919922537)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702384257135922538)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Define Workspace Message'
,p_list_item_link_target=>'f?p=4350:35:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(702382744919922537)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(180643795911538685)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Define Environment Banner'
,p_list_item_link_target=>'f?p=4350:105:&SESSION.:::105:P105_LAST_APP_ID,P105_LAST_PAGE_ID:&APP_ID.,&APP_PAGE_ID.'
,p_parent_list_item_id=>wwv_flow_imp.id(702382744919922537)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702384584543922538)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Workspace Utilization'
,p_list_item_link_target=>'f?p=4350:101:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(702382744919922537)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702384861674922538)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Manage Users and Groups'
,p_list_item_link_target=>'f?p=4350:55:&SESSION.'
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702385112276922538)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Monitor Activity'
,p_list_item_link_target=>'f?p=4350:22:&SESSION.'
,p_security_scheme=>wwv_flow_imp.id(15353907298685325)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702385449098922539)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Dashboards'
,p_list_item_link_target=>'f?p=4350:33:&SESSION.'
,p_security_scheme=>wwv_flow_imp.id(15353907298685325)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(327719664357119256)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Change My Password'
,p_list_item_link_target=>'f?p=4350:3:&SESSION.::&DEBUG.:3#pwd'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_list_item_disp_condition2=>'PLSQL'
,p_security_scheme=>wwv_flow_imp.id(15353907298685325)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(702386956612924063)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702387138145924064)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Documentation'
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2110715883843512302)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Discussion Forum'
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2190261126573039321)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Learn More about Oracle APEX'
,p_list_item_link_target=>'https://apex.oracle.com'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702388035956924065)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(28403868207090882)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'About'
,p_list_item_link_target=>'f?p=4350:9:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(895735745336087)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(6826142137869668)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(19608224744399589)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(96742782884031030)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(99821422985888928)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_GEOCODED_ADDRESS'
,p_attribute_01=>'RELAX_HOUSE_NUMBER'
,p_attribute_02=>'N'
,p_attribute_03=>'POPUP:ITEM'
,p_attribute_04=>'default'
,p_attribute_06=>'LIST'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(176118219366506807)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_SINGLE_CHECKBOX'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(592208881023709428)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_DATE_PICKER_JET'
,p_attribute_01=>'MONTH-PICKER:YEAR-PICKER'
,p_attribute_02=>'VISIBLE'
,p_attribute_03=>'15'
,p_attribute_04=>'FOCUS'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1769832374372170712)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1836482126643452536)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1922397339626398570)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'FULL'
,p_attribute_02=>'POPUP'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(2015742369962577737)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.FLOTLINECHART2'
,p_attribute_01=>'3'
,p_attribute_02=>'1.333'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_data_generator
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(1755605405001643)
,p_name=>'Flow: DATA_GENERATOR'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'DATA_GENERATOR'
,p_error_message=>'You are not authorized to use Data Generator in SQL Workshop'
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/dashboard_access
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(15353907298685325)
,p_name=>'Dashboard access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return',
'    wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''ADMIN''',
'    )',
'    or wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''EDIT''',
'    );'))
,p_error_message=>'You are not authorized to access Dashboards and Monitor Activity.'
,p_reference_id=>786936829326142579
,p_caching=>'BY_USER_BY_SESSION'
,p_comments=>'Used to control access to Dashboards and Monitor Activity under Administration. Developers will have access when Builder is enabled, while Admins will always have access. Prompted by Bug 13859631.'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(17268112003727577)
,p_name=>'Flow: EDIT'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>'You are not authorized to edit applications'
,p_reference_id=>12480509677812756
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(17281223028976738)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>'You are not authorized to administer applications'
,p_reference_id=>12511219858301010
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(183694515603211251)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>'No privilege for attempted operation'
,p_reference_id=>786516029127697713
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(183694924473211252)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>'You are not authorized to use SQL Workshop'
,p_reference_id=>786516265251697717
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(183695412901211253)
,p_name=>'APEX 5.0 Team development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>'Team development not enabled for this workspace'
,p_reference_id=>786516861027697723
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/team_dev_file_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(328409007532727880)
,p_name=>'Team Dev File Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_team_file.team_dev_file_enabled then',
'   return true;',
'else',
'   return false;',
'end if;'))
,p_error_message=>'Access to this page requires team development files to be enabled.'
,p_reference_id=>786943600005207200
,p_caching=>'NOCACHE'
);
end;
/
prompt --application/shared_components/security/authorizations/sso_authentication
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(339062033074422888)
,p_name=>'SSO authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication not in (''APEX'',''CLOUD_IDM'',''LDAP'',''DB'');'
,p_error_message=>'Builder SSO is not enabled'
,p_reference_id=>6738410669854771
,p_caching=>'BY_USER_BY_SESSION'
,p_comments=>wwv_flow_string.join(wwv_flow_t_varchar2(
'This authorization scheme checks whether the builder authentication can be used for single sign-on to workspaces. This includes SSO, header-based and LDAP authentication, but not',
'',
'  - APEX: login requires a workspace name',
'  - CLOUD_IDM: external login to IDM, but switching workspaces is not allowed, since the login is for a single tenant only'))
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_restful_services_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(807841331942262216)
,p_name=>'APEX 5.0 RESTful Services Enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies',
'where ALLOW_RESTFUL_SERVICES_YN = ''Y'' and ',
'      PROVISIONING_COMPANY_ID = :flow_security_group_id',
'and exists (select 1',
'                  from wwv_flow_platform_prefs',
'                 where name  = ''RESTFUL_SERVICES_ENABLED''',
'                   and value = ''Y'')'))
,p_error_message=>'No privilege for attempted operation'
,p_reference_id=>786519856057734816
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/service_requests_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(922396026104496881)
,p_name=>'Service Requests Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'' then',
'    return TRUE;',
'else',
'    return FALSE;',
'end if;'))
,p_error_message=>'No privilege for attempted operation.'
,p_reference_id=>786932326296107981
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
null;
end;
/
prompt --application/shared_components/logic/application_processes/spotlightindex
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(238481725164011026)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'spotlightIndex'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_spotlight_dev.emit_spotlight_index(',
'   p_app_id           => wwv_flow.g_x01,',
'   p_get_apps_list    => wwv_flow.g_x02);'))
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_items/ajax_ws_action
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(37912420806172595)
,p_name=>'AJAX_WS_ACTION'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
,p_item_comment=>'FILTER,SEARCH,SORT'
);
end;
/
prompt --application/shared_components/logic/application_items/ajax_ws_column
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(37940528715420891)
,p_name=>'AJAX_WS_COLUMN'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/ajax_ws_filter
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(37939746245416465)
,p_name=>'AJAX_WS_FILTER'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/ajax_ws_filter_type
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(37938333085412702)
,p_name=>'AJAX_WS_FILTER_TYPE'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/ajax_ws_num
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(38842438717798590)
,p_name=>'AJAX_WS_NUM'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/approval_status
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(38688041917115502)
,p_name=>'APPROVAL_STATUS'
,p_data_type=>'NUMBER'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/company
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(806410516575908378)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/f4600_last_view
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(174573819842644837)
,p_name=>'F4600_LAST_VIEW'
,p_protection_level=>'B'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/folder_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(185417628459576998)
,p_name=>'FOLDER_ID'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/fsp_after_login_url
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(168218724319674550)
,p_name=>'FSP_AFTER_LOGIN_URL'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/item_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(21369340420081660)
,p_name=>'ITEM_ID'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/msg_company
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(210854931189892354)
,p_name=>'MSG_COMPANY'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/owner_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(190079937165083234)
,p_name=>'OWNER_ID'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/rpt_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(193240824799898826)
,p_name=>'RPT_ID'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/shownav
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(185565221971032033)
,p_name=>'SHOWNAV'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/temporary_action
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(21400435233205909)
,p_name=>'TEMPORARY_ACTION'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
end;
/
prompt --application/shared_components/logic/application_items/temporary_filter
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(36523045963068949)
,p_name=>'TEMPORARY_FILTER'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/temporary_folder
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(21400031770204912)
,p_name=>'TEMPORARY_FOLDER'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
end;
/
prompt --application/shared_components/logic/application_items/temporary_item
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(21373845287234405)
,p_name=>'TEMPORARY_ITEM'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
,p_item_comment=>'This is used to run a action using Ajax it should not be used on anything else and not be expected to save it''s value between requests.'
);
end;
/
prompt --application/shared_components/logic/application_items/workgroup
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(17476426782744789)
,p_name=>'WORKGROUP'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/workgroup_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(17484043348395783)
,p_name=>'WORKGROUP_ID'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/worksheet_filter_type
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(37236418088215827)
,p_name=>'WORKSHEET_FILTER_TYPE'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/worksheet_name
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(92353535466226138)
,p_name=>'WORKSHEET_NAME'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_computations/company
begin
wwv_flow_imp_shared.create_flow_computation(
 p_id=>wwv_flow_imp.id(806410907010915119)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'EXPRESSION'
,p_computation_language=>'PLSQL'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>'Unable to compute workspace name.'
);
end;
/
prompt --application/shared_components/logic/application_computations/shownav
begin
wwv_flow_imp_shared.create_flow_computation(
 p_id=>wwv_flow_imp.id(185565827511033694)
,p_computation_sequence=>10
,p_computation_item=>'SHOWNAV'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'Y'
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/application_and_page_search
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(668635072324511178)
,p_lov_name=>'APPLICATION AND PAGE SEARCH'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id|| '' - ''|| f.name||''(''||f.alias||'')'' APP_NAME,',
'       --f.alias APP_ALIAS,',
'       f.id APP_ID,',
'       s.id||'' - ''||s.name PAGE_NAME, ',
'       s.alias PAGE_ALIAS,',
'       s.id PAGE_ID,',
'       g.group_name',
'  from wwv_flows f, ',
'       wwv_flow_steps s, ',
'       wwv_flow_page_groups g',
' where f.security_group_id = :flow_security_group_id',
'   and s.flow_id = f.id',
'   and g.id (+) = s.group_id',
'   and not exists (',
'    select null',
'      from wwv_flow_language_map',
'     where translation_flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
')',
'   and ( exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id is null',
'       and security_group_id = :flow_security_group_id',
')',
'    or exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
') )',
'order by f.id, s.id'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'APP_ID'
,p_display_column_name=>'APP_NAME'
,p_group_column_name=>'APP_NAME'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'PAGE_ID'
,p_default_sort_direction=>'ASC'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(672265511386888773)
,p_query_column_name=>'APP_ID'
,p_display_sequence=>10
,p_data_type=>'NUMBER'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(672265939351888774)
,p_query_column_name=>'APP_NAME'
,p_heading=>'App Name'
,p_display_sequence=>20
,p_data_type=>'VARCHAR2'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(672266395240888774)
,p_query_column_name=>'PAGE_ID'
,p_heading=>'Page Id'
,p_display_sequence=>30
,p_data_type=>'NUMBER'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(672266756188888774)
,p_query_column_name=>'PAGE_NAME'
,p_heading=>'Page Name'
,p_display_sequence=>40
,p_data_type=>'VARCHAR2'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(672267116153888774)
,p_query_column_name=>'PAGE_ALIAS'
,p_heading=>'Page Alias'
,p_display_sequence=>50
,p_data_type=>'VARCHAR2'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(672267522080888774)
,p_query_column_name=>'GROUP_NAME'
,p_heading=>'Group Name'
,p_display_sequence=>60
,p_data_type=>'VARCHAR2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_name_returning_id
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(5887246189354055)
,p_lov_name=>'APPLICATION NAME RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id',
'       || ''. ''',
'       || name d,',
'       id r',
'  from wwv_flows f',
' where security_group_id = :flow_security_group_id',
'   and not exists (',
'    select null',
'      from wwv_flow_language_map',
'     where translation_flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
')',
'   and ( exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id is null',
'       and security_group_id = :flow_security_group_id',
')',
'    or exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
') )',
'order by id'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'R'
,p_display_column_name=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/intervals
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1656102236549848)
,p_lov_name=>'INTERVALS'
,p_lov_query=>'.'||wwv_flow_imp.id(1656102236549848)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1656418374549852)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Immediately'
,p_lov_return_value=>'IMMEDIATELY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1656826725549855)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Hourly Summary'
,p_lov_return_value=>'HOURLY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1657255076549856)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Daily Summary'
,p_lov_return_value=>'DAILY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/issue_statuses_static
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(5664182917694426)
,p_lov_name=>'ISSUE_STATUSES_STATIC'
,p_lov_query=>'.'||wwv_flow_imp.id(5664182917694426)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5664453481694435)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Open'
,p_lov_return_value=>'OPEN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5664876171694445)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Closed'
,p_lov_return_value=>'CLOSED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/label_group_colors
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(5734638238767974)
,p_lov_name=>'LABEL_GROUP_COLORS'
,p_lov_query=>'.'||wwv_flow_imp.id(5734638238767974)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5734918745767983)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Color 1'
,p_lov_return_value=>'label-color-1'
,p_lov_template=>'<span class="color-option label-color-1" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5735321525788743)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Color 2'
,p_lov_return_value=>'label-color-2'
,p_lov_template=>'<span class="color-option label-color-2" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5735679529788743)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Color 3'
,p_lov_return_value=>'label-color-3'
,p_lov_template=>'<span class="color-option label-color-3" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5736043280788744)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Color 4'
,p_lov_return_value=>'label-color-4'
,p_lov_template=>'<span class="color-option label-color-4" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5736405025788744)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Color 5'
,p_lov_return_value=>'label-color-5'
,p_lov_template=>'<span class="color-option label-color-5" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5736803684788744)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Color 6'
,p_lov_return_value=>'label-color-6'
,p_lov_template=>'<span class="color-option label-color-6" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5737219761788744)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Color 7'
,p_lov_return_value=>'label-color-7'
,p_lov_template=>'<span class="color-option label-color-7" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5737679091788744)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Color 8'
,p_lov_return_value=>'label-color-8'
,p_lov_template=>'<span class="color-option label-color-8" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5738078036788745)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Color 9'
,p_lov_return_value=>'label-color-9'
,p_lov_template=>'<span class="color-option label-color-9" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5738459690788747)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Color 10'
,p_lov_return_value=>'label-color-10'
,p_lov_template=>'<span class="color-option label-color-10" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5738861781788748)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Color 11'
,p_lov_return_value=>'label-color-11'
,p_lov_template=>'<span class="color-option label-color-11" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5739240848788748)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Color 12'
,p_lov_return_value=>'label-color-12'
,p_lov_template=>'<span class="color-option label-color-12" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5739685253788748)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Color 13'
,p_lov_return_value=>'label-color-13'
,p_lov_template=>'<span class="color-option label-color-13" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5740078115788748)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Color 14'
,p_lov_return_value=>'label-color-14'
,p_lov_template=>'<span class="color-option label-color-14" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5740411405788748)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Color 15'
,p_lov_return_value=>'label-color-15'
,p_lov_template=>'<span class="color-option label-color-15" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6071628520214755)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'Color 16'
,p_lov_return_value=>'label-color-16'
,p_lov_template=>'<span class="color-option label-color-16" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6071948620214757)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'Color 17'
,p_lov_return_value=>'label-color-17'
,p_lov_template=>'<span class="color-option label-color-17" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6072354386214757)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>'Color 18'
,p_lov_return_value=>'label-color-18'
,p_lov_template=>'<span class="color-option label-color-18" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6072701888214757)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>'Color 19'
,p_lov_return_value=>'label-color-19'
,p_lov_template=>'<span class="color-option label-color-19" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6073167607214758)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Color 20'
,p_lov_return_value=>'label-color-20'
,p_lov_template=>'<span class="color-option label-color-20" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6073559823214758)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>'Color 21'
,p_lov_return_value=>'label-color-21'
,p_lov_template=>'<span class="color-option label-color-21" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6073957520214758)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>'Color 22'
,p_lov_return_value=>'label-color-22'
,p_lov_template=>'<span class="color-option label-color-22" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6074341681214758)
,p_lov_disp_sequence=>23
,p_lov_disp_value=>'Color 23'
,p_lov_return_value=>'label-color-23'
,p_lov_template=>'<span class="color-option label-color-23" aria-hidden="true"></span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6074730945214758)
,p_lov_disp_sequence=>24
,p_lov_disp_value=>'Color 24'
,p_lov_return_value=>'label-color-24'
,p_lov_template=>'<span class="color-option label-color-24" aria-hidden="true"></span>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/localized_open_closed
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(15773100381005765)
,p_lov_name=>'LOCALIZED OPEN CLOSED'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.OPEN'') d, ''OPEN'' r ',
'from dual',
'UNION',
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.CLOSED'') d, ''CLOSED'' r ',
'from dual'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/notification_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1643009509517335)
,p_lov_name=>'NOTIFICATION TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(1643009509517335)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1643337181517343)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Issue Text Edited'
,p_lov_return_value=>'ISSUE_EDIT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1643790317517359)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'New Comment'
,p_lov_return_value=>'COMMENT_ADD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1644118795517363)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Comment Text Edited'
,p_lov_return_value=>'COMMENT_EDIT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1644519868517363)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Status '
,p_lov_return_value=>'STATUS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1644981141517367)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Assignee'
,p_lov_return_value=>'ASSIGNEE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1645366808517367)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Subscriber'
,p_lov_return_value=>'SUBSCRIBER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1645788275517368)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Milestone'
,p_lov_return_value=>'MILESTONE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1646162433517368)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Label'
,p_lov_return_value=>'LABEL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1646597713517368)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Marked as Duplicate'
,p_lov_return_value=>'DUPLICATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1646959379517368)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application / Page Assignment'
,p_lov_return_value=>'ASSOCIATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1647355568517369)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Attachment(s)'
,p_lov_return_value=>'ATTACHMENT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/response_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(6673547635351160)
,p_lov_name=>'RESPONSE_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select template_name as d,',
'       id as r',
'  from wwv_flow_issue_templates',
' where template_type = ''RESPONSE'' ',
'   and security_group_id = :flow_security_group_id',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/template_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(5337630119489013)
,p_lov_name=>'TEMPLATE_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(5337630119489013)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5337833082489021)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Response'
,p_lov_return_value=>'RESPONSE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5338249958489023)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Issue'
,p_lov_return_value=>'ISSUE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/workspace_users
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(5669473527908412)
,p_lov_name=>'WORKSPACE_USERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'       case ',
'            when first_name||last_name is null then "USER"',
'            else first_name||'' ''||last_name',
'        end display,',
'         a."USER" return ',
'from wwv_flow_workspace_users a',
'where workspace_id = :flow_security_group_id'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'RETURN'
,p_display_column_name=>'DISPLAY'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'DISPLAY'
,p_default_sort_direction=>'ASC_NULLS_FIRST'
);
end;
/
prompt --application/shared_components/user_interface/lovs/yes_no_returns_y_n
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(17525524968129983)
,p_lov_name=>'YES NO RETURNS Y N'
,p_lov_query=>'.'||wwv_flow_imp.id(17525524968129983)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17525727619129986)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Yes'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17525935048129988)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'No'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/pages/page_groups
begin
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(4883840680127639)
,p_group_name=>'Administration'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(4883594172125992)
,p_group_name=>'Issue'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(4883741872127080)
,p_group_name=>'Labels'
);
wwv_flow_imp_page.create_page_group(
 p_id=>wwv_flow_imp.id(4883665819126633)
,p_group_name=>'Milestones'
);
end;
/
prompt --application/shared_components/navigation/breadcrumbs/issues_breadcrumbs
begin
wwv_flow_imp_shared.create_menu(
 p_id=>wwv_flow_imp.id(92331531826187224)
,p_name=>'Issues Breadcrumbs'
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(1609827273716053)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Manage Notification Preferences'
,p_link=>'f?p=&APP_ID.:2080:&SESSION.'
,p_page_id=>2080
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(4881171519105736)
,p_parent_id=>wwv_flow_imp.id(5845246212205599)
,p_short_name=>'Issue Details'
,p_link=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:::'
,p_page_id=>100
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(4882133165116855)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Milestones'
,p_link=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:::'
,p_page_id=>200
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(4882644814119470)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Labels'
,p_link=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:::'
,p_page_id=>300
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(5001217954462703)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Templates'
,p_link=>'f?p=&APP_ID.:1000:&SESSION.::&DEBUG.:::'
,p_page_id=>1000
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(5001686955462712)
,p_parent_id=>wwv_flow_imp.id(5001217954462703)
,p_short_name=>'Edit Template'
,p_link=>'f?p=&APP_ID.:1010:&SESSION.'
,p_page_id=>1010
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(5353737069645712)
,p_parent_id=>wwv_flow_imp.id(4882133165116855)
,p_short_name=>'Milestone'
,p_link=>'f?p=&APP_ID.:210:&SESSION.'
,p_page_id=>210
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(5384647942926430)
,p_parent_id=>wwv_flow_imp.id(4882133165116855)
,p_short_name=>'Milestone'
,p_link=>'f?p=&APP_ID.:205:&SESSION.'
,p_page_id=>205
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(5714590146586339)
,p_parent_id=>wwv_flow_imp.id(4882644814119470)
,p_short_name=>'Manage Labels'
,p_link=>'f?p=&APP_ID.:305:&SESSION.'
,p_page_id=>305
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(5845246212205599)
,p_parent_id=>wwv_flow_imp.id(116983012395599679)
,p_short_name=>'Issues'
,p_link=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:::'
,p_page_id=>1
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(6132745478763966)
,p_parent_id=>wwv_flow_imp.id(116983012395599679)
,p_short_name=>'Utilities '
,p_link=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.:::'
,p_page_id=>2000
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(6157811337242892)
,p_parent_id=>wwv_flow_imp.id(116983012395599679)
,p_short_name=>'User Profile'
,p_link=>'f?p=&APP_ID.:500:&SESSION.'
,p_page_id=>500
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(10558517588230547)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Manage Deleted Issues'
,p_link=>'f?p=&APP_ID.:2010:&SESSION.::&DEBUG.:::'
,p_page_id=>2010
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11145298131075273)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Purge Data '
,p_link=>'f?p=&APP_ID.:2020:&SESSION.::&DEBUG.:::'
,p_page_id=>2020
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11158477298366433)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Issue Files'
,p_link=>'f?p=&APP_ID.:2030:&SESSION.'
,p_page_id=>2030
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11223139265628904)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Update Assignees'
,p_link=>'f?p=&APP_ID.:2040:&SESSION.::&DEBUG.:::'
,p_page_id=>2040
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11225065027657825)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Remove Milestones'
,p_link=>'f?p=&APP_ID.:2060:&SESSION.::&DEBUG.:::'
,p_page_id=>2060
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11225560985663098)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Remove Labels'
,p_link=>'f?p=&APP_ID.:2070:&SESSION.::&DEBUG.:::'
,p_page_id=>2070
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11263840466388445)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Reassign Owner'
,p_link=>'f?p=&APP_ID.:2050:&SESSION.::&DEBUG.:::'
,p_page_id=>2050
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11264768364404173)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Update Assignees'
,p_link=>'f?p=&APP_ID.:2045:&SESSION.::&DEBUG.:::'
,p_page_id=>2045
,p_security_scheme=>wwv_flow_imp.id(17281223028976738)
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11272348512449506)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Reassign Owner'
,p_link=>'f?p=&APP_ID.:2055:&SESSION.'
,p_page_id=>2055
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11304459558976959)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Remove Milestone'
,p_link=>'f?p=&APP_ID.:2065:&SESSION.'
,p_page_id=>2065
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11316325099178200)
,p_parent_id=>wwv_flow_imp.id(6132745478763966)
,p_short_name=>'Remove Milestones'
,p_link=>'f?p=&APP_ID.:2075:&SESSION.'
,p_page_id=>2075
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(11492813428017727)
,p_parent_id=>wwv_flow_imp.id(116983012395599679)
,p_short_name=>'User Profile'
,p_link=>'f?p=&APP_ID.:502:&SESSION.::&DEBUG.:::'
,p_page_id=>502
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(116983012395599679)
,p_parent_id=>0
,p_short_name=>'<span class="u-VisuallyHidden">Issues</span><span class="a-Icon icon-breadcrumb-previous" title="Issues"></span>'
,p_link=>'f?p=&APP_ID.:999:&SESSION.::&DEBUG.:::'
,p_page_id=>999
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(393283835495701129)
,p_short_name=>'0'
,p_link=>'f?p=&FLOW_ID.:0:&SESSION.'
,p_page_id=>0
);
wwv_flow_imp_shared.create_menu_option(
 p_id=>wwv_flow_imp.id(597593414202185271)
,p_parent_id=>wwv_flow_imp.id(5845246212205599)
,p_short_name=>'Welcome'
,p_link=>'f?p=&APP_ID.:10:&SESSION.'
,p_page_id=>10
);
end;
/
prompt --application/shared_components/navigation/breadcrumbentry
begin
null;
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_4_2_popup
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(25147761418110187)
,p_theme_id=>101
,p_name=>unistr('\2713 APEX 4.2 - Popup')
,p_internal_name=>'APEX_4.2_POPUP'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title><link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'</head><body #ONLOAD# style="min-width:380px;"><noscript>&MSG_JSCRIPT.</noscript>#FORM_OPEN#<a name="PAGETOP"></a>'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="htmldbMessageHolder">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#</div>',
'<div>',
'  <div id="RP2">#REGION_POSITION_02#</div>',
'  <div id="RP3">#REGION_POSITION_03#</div>',
'  <div id="RP4">#REGION_POSITION_04#</div>',
'  <div id="RP5">#REGION_POSITION_05#</div>',
'  <div class="popupContent" id="ContentArea">#BODY#</div>',
'</div>',
'<div id="RP8" style="text-align:middle;">#REGION_POSITION_08#</div>',
'<br />',
'<br />',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>36144306570651063
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115761747455702374)
,p_page_template_id=>wwv_flow_imp.id(25147761418110187)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115762230314702374)
,p_page_template_id=>wwv_flow_imp.id(25147761418110187)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115762740992702375)
,p_page_template_id=>wwv_flow_imp.id(25147761418110187)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115763248882702375)
,p_page_template_id=>wwv_flow_imp.id(25147761418110187)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115763707143702375)
,p_page_template_id=>wwv_flow_imp.id(25147761418110187)
,p_name=>'Page Position 5'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115764226686702375)
,p_page_template_id=>wwv_flow_imp.id(25147761418110187)
,p_name=>'Page Position 8'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_dialog
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(126075773730973072)
,p_theme_id=>101
,p_name=>unistr('\2713 APEX 5.0 - Dialog')
,p_internal_name=>'APEX_5.0_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>'apex.builder.initWizardModal();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog" role="dialog" aria-label="#TITLE#">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--defaultIcons a-Alert--inlineDialog a-Alert--wizard margin-none padding-none">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header u-vh">',
'        <h2 class="a-Alert-title">&APP_TEXT$ERROR!HTML.</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        <p>#MESSAGE# #ADDITIONAL_INFO#</p>',
'        <p><a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a></p>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--uiDialog'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>120828417372192930
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115807493525787923)
,p_page_template_id=>wwv_flow_imp.id(126075773730973072)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115807926887787924)
,p_page_template_id=>wwv_flow_imp.id(126075773730973072)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115808419878787924)
,p_page_template_id=>wwv_flow_imp.id(126075773730973072)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_page_designer
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(389915650581127935)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Page Designer'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER'
,p_is_popup=>false
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if ( apex.jQuery( "#successMessage" ).length > 0 ) {',
'    window.pageDesigner.showNotification( apex.jQuery( "#successMessage" ).text() );',
'}'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#HEAD#',
'</head>',
'<body #ONLOAD# class="#PAGE_CSS_CLASSES#">',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_01#',
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" style="display: none;" id="pdNotification">',
' <div class="a-AlertMessages-item">',
'  <div id="pdNotificationState" class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span id="pdNotificationIcon" class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="pdNotificationMessage">#PD_MESSAGE#</h5>',
'      <button id="pdNotificationClose" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'',
'',
'<div id="a_PageDesigner" class="a-PageDesigner resize">',
'  #REGION_POSITION_02#',
'  #REGION_POSITION_03#',
'  #REGION_POSITION_04#',
'  #BODY#',
'  <div style="display:none;">',
'  #REGION_POSITION_06#',
'  </div>',
'</div>',
''))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#APEX_JAVASCRIPT#',
'#GENERATED_CSS#',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!--<div class="aNotification success" id="MESSAGE">',
'  <div class="aNotificationText">',
'    <h2 class="visuallyhidden">#SUCCESS_MESSAGE_HEADING#</h2>',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium success"/>',
'    <p>#SUCCESS_MESSAGE#</p>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>-->',
'<div style="display: none;" id="successMessage">#SUCCESS_MESSAGE#</div>',
''))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aNotification warning" id="MESSAGE" role="alert">',
'  <div class="aNotificationText">',
'    <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" class="iconMedium warning"/>',
'    <div class="warningMessage">',
'      <h2 class="visuallyhidden">#ERROR_MESSAGE_HEADING#</h2>',
'      #MESSAGE#',
'    </div>',
'    <a href="#" class="closeMessage" onclick="$x_Remove(''MESSAGE'');return false;"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#CLOSE_NOTIFICATION#" class="iconSmall close"/></a>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
'<br />',
'<pre>#MESSAGE#</pre>',
'<a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a>'))
,p_grid_type=>'TABLE'
,p_grid_always_use_max_columns=>false
,p_grid_has_column_span=>true
,p_grid_always_emit=>true
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_dialog_browser_frame=>'MODAL'
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140038444374349507)
,p_page_template_id=>wwv_flow_imp.id(389915650581127935)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140038576723349507)
,p_page_template_id=>wwv_flow_imp.id(389915650581127935)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140038607976349507)
,p_page_template_id=>wwv_flow_imp.id(389915650581127935)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140038718891349507)
,p_page_template_id=>wwv_flow_imp.id(389915650581127935)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140038889094349507)
,p_page_template_id=>wwv_flow_imp.id(389915650581127935)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140038928804349506)
,p_page_template_id=>wwv_flow_imp.id(389915650581127935)
,p_name=>'Page Position 7'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(389915886911127940)
,p_page_template_id=>wwv_flow_imp.id(389915650581127935)
,p_name=>'Dialog Area'
,p_placeholder=>'REGION_POSITION_06'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
,p_max_fixed_grid_columns=>-1
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_right_side_bar
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(391881764116992437)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Right Side Bar'
,p_internal_name=>'APEX_5.0_RIGHT_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'<a href="#main" id="a_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#REGION_POSITION_02#',
'  <div id="main" class="a-Body">',
'    <main class="a-Main">',
'        #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'        #BODY#',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'    </aside>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>386895861966224222
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(164505318608427240)
,p_page_template_id=>wwv_flow_imp.id(391881764116992437)
,p_name=>'Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(164505800746427240)
,p_page_template_id=>wwv_flow_imp.id(391881764116992437)
,p_name=>'Page Header (Position 3)'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(164506276586427240)
,p_page_template_id=>wwv_flow_imp.id(391881764116992437)
,p_name=>'Page Header (Position 4)'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(164506848325427241)
,p_page_template_id=>wwv_flow_imp.id(391881764116992437)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(164507257952427241)
,p_page_template_id=>wwv_flow_imp.id(391881764116992437)
,p_name=>'After Body'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(164507773640427241)
,p_page_template_id=>wwv_flow_imp.id(391881764116992437)
,p_name=>'Page Header (Position 1)'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(164508303273427242)
,p_page_template_id=>wwv_flow_imp.id(391881764116992437)
,p_name=>'Page Header (Position 2)'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_dialog
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(694269863376113197)
,p_theme_id=>101
,p_name=>unistr('\2713 APEX 5.0 - Wizard Dialog')
,p_internal_name=>'APEX_5.0_WIZARD_DIALOG'
,p_is_popup=>true
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.builder.initWizardModal();',
'apex.builder.initWizardProgressBar();'))
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="utf-8">  ',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#HEAD#',
'<meta name="viewport" content="width=device-width,initial-scale=1" />',
'</head>',
'<body class="a-Dialog-page #DIALOG_CSS_CLASSES# #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Dialog a-Dialog--wizard">',
'  <div class="a-Dialog-wrap">',
'    <div class=" a-Dialog-wizardSteps">',
'      #REGION_POSITION_01#',
'    </div>',
'    <div class="a-Dialog-body">',
'      #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'      #BODY#',
'    </div>',
'    <div class="a-Dialog-footer">',
'      #REGION_POSITION_03#',
'    </div>',
'  </div>',
'</div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#GENERATED_JAVASCRIPT#',
'</body>',
'</html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--dialog" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="0" width="100%'
,p_theme_class_id=>4
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--defaultIcons a-Alert--inlineDialog a-Alert--wizard margin-none padding-none">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header u-vh">',
'        <h2 class="a-Alert-title">&APP_TEXT$ERROR!HTML.</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        <p>#MESSAGE# #ADDITIONAL_INFO#</p>',
'        <p><a href="#BACK_LINK#">#RETURN_TO_APPLICATION#</a></p>',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    <div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>        '))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_height=>'480'
,p_dialog_width=>'800'
,p_dialog_max_width=>'1200'
,p_dialog_css_classes=>'a-Dialog--wizard'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689061037088924910
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(116752197058530383)
,p_page_template_id=>wwv_flow_imp.id(694269863376113197)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(116752639421530383)
,p_page_template_id=>wwv_flow_imp.id(694269863376113197)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(116753177107530383)
,p_page_template_id=>wwv_flow_imp.id(694269863376113197)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_edit_screen
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(694810454825113224)
,p_theme_id=>101
,p_name=>unistr('\2713 APEX 5.0 - Edit Screen')
,p_internal_name=>'APEX_5.0_EDIT_SCREEN'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initStickyHeader(''a_EditScreen_header'');'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'  <div class="a-Body">',
'    <main class="a-Main">',
'      #REGION_POSITION_02#',
'      <div class="a-EditScreen">',
'        <div class="a-EditScreen-header" id="a_EditScreen_header">',
'          #SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'          #REGION_POSITION_04#',
'        </div>',
'        <div class="a-EditScreen-body">',
'          #BODY#',
'        </div>',
'      </div>',
'    </main>',
'    <aside class="a-Side">',
'        #REGION_POSITION_03#',
'        #REGION_POSITION_05#',
'    </aside>',
'  </div>'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'REGION_POSITION_03'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_js_init_code=>'apex.navigation.dialog(#PAGE_URL#,{title:#TITLE#,height:#DIALOG_HEIGHT#,width:#DIALOG_WIDTH#,maxWidth:#DIALOG_MAX_WIDTH#,modal:#IS_MODAL#,dialog:#DIALOG#,#DIALOG_ATTRIBUTES#},#DIALOG_CSS_CLASSES#,#TRIGGERING_ELEMENT#);'
,p_dialog_js_close_code=>'apex.navigation.dialog.close(#IS_MODAL#,#TARGET#);'
,p_dialog_js_cancel_code=>'apex.navigation.dialog.cancel(#IS_MODAL#);'
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>689595297061847770
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115886666666843307)
,p_page_template_id=>wwv_flow_imp.id(694810454825113224)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115887117008843308)
,p_page_template_id=>wwv_flow_imp.id(694810454825113224)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115887662700843308)
,p_page_template_id=>wwv_flow_imp.id(694810454825113224)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115888128425843308)
,p_page_template_id=>wwv_flow_imp.id(694810454825113224)
,p_name=>'Right Side Bar'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115888632282843309)
,p_page_template_id=>wwv_flow_imp.id(694810454825113224)
,p_name=>'Edit Screen Header'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115889138651843309)
,p_page_template_id=>wwv_flow_imp.id(694810454825113224)
,p_name=>'Page Position 5'
,p_placeholder=>'REGION_POSITION_05'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115889641092843309)
,p_page_template_id=>wwv_flow_imp.id(694810454825113224)
,p_name=>'Page Position 7'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(115890179634843309)
,p_page_template_id=>wwv_flow_imp.id(694810454825113224)
,p_name=>'Page Position 8'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_no_side_bar
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(703879338414253261)
,p_theme_id=>101
,p_name=>'APEX 5.0 - No Side Bar'
,p_internal_name=>'APEX_5.0_NO_SIDE_BAR'
,p_is_popup=>false
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="#PAGE_CSS_CLASSES#" #ONLOAD#>',
'<!--[if lte IE 9]><div id="outdated-browser">#OUTDATED_BROWSER#</div><![endif]-->',
'<noscript>&MSG_JSCRIPT.</noscript>',
'<a href="#main" id="a_Body_skipToContent">&APP_TEXT$UI_PAGE_SKIP_TO_CONTENT.</a>',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#REGION_POSITION_01#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'#REGION_POSITION_02#',
'#REGION_POSITION_03#',
'  <div id="main" class="a-Body">',
'    <main class="a-Main">',
'        #BODY#',
'    </main>',
'  </div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--success a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_success_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#SUCCESS_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #SUCCESS_MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_success_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--warning a-Alert--horizontal a-Alert--defaultIcons a-Alert--colorBG a-Alert--page" id="page_warning_msg">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#ERROR_MESSAGE_HEADING#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #MESSAGE#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI" onclick="$x_Remove(''page_warning_msg'');" value="#CLOSE_NOTIFICATION#" type="button" title="#CLOSE_NOTIFICATION#"><span class="a-Icon icon-remove"></span></button>',
'    </div>',
'  </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#MESSAGE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>637437892049443496
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140036744046349509)
,p_page_template_id=>wwv_flow_imp.id(703879338414253261)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140036843253349509)
,p_page_template_id=>wwv_flow_imp.id(703879338414253261)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140036948462349509)
,p_page_template_id=>wwv_flow_imp.id(703879338414253261)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140037035582349509)
,p_page_template_id=>wwv_flow_imp.id(703879338414253261)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140037162534349508)
,p_page_template_id=>wwv_flow_imp.id(703879338414253261)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140037253760349508)
,p_page_template_id=>wwv_flow_imp.id(703879338414253261)
,p_name=>'Page Position 7'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140037351061349508)
,p_page_template_id=>wwv_flow_imp.id(703879338414253261)
,p_name=>'Page Position 8'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/page/apex_5_0_wizard_page
begin
wwv_flow_imp_shared.create_template(
 p_id=>wwv_flow_imp.id(707892828837195217)
,p_theme_id=>101
,p_name=>'APEX 5.0 - Wizard Page'
,p_internal_name=>'APEX_5.0_WIZARD_PAGE'
,p_is_popup=>false
,p_javascript_code_onload=>'apex.builder.initWizardProgressBar();'
,p_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!doctype html>',
'<html class="no-js page-&APP_PAGE_ID. app-&APP_ID." lang="&BROWSER_LANGUAGE.">',
'<head>',
'<meta http-equiv="x-ua-compatible" content="IE=edge" />',
'<meta charset="UTF-8" />',
'<title>#TITLE#</title>',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon.ico">',
'<link rel="icon" sizes="16x16" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-16x16.png">',
'<link rel="icon" sizes="32x32" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-32x32.png">',
'<link rel="apple-touch-icon" sizes="180x180" href="#IMAGE_PREFIX#apex_ui/img/favicons/favicon-180x180.png">',
'#APEX_CSS#',
'#THEME_CSS#',
'#TEMPLATE_CSS#',
'#THEME_STYLE_CSS#',
'#APPLICATION_CSS#',
'#PAGE_CSS#',
'#APEX_JAVASCRIPT# ',
'#THEME_JAVASCRIPT#',
'#TEMPLATE_JAVASCRIPT#',
'#HEAD#',
'</head>',
'<body class="a-Page--wizard #PAGE_CSS_CLASSES#" #ONLOAD#>',
'<noscript>&MSG_JSCRIPT.</noscript>',
'#ENVIRONMENT_BANNER#',
'#FORM_OPEN#'))
,p_box=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#REGION_POSITION_07#',
'#REGION_POSITION_08#',
'#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE##GLOBAL_NOTIFICATION#',
'<div class="u-Layout u-Layout--centerVertically">',
'  <div class="a-Wizard a-Wizard--default">',
'    #REGION_POSITION_02#',
'    <div class="a-Wizard-controls">#REGION_POSITION_01#</div>',
'    <div class="a-Wizard-body">#BODY#</div>',
'    <div class="a-Wizard-buttons">#REGION_POSITION_03#</div>',
'  </div>',
'</div>',
'#REGION_POSITION_04#'))
,p_footer_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<footer class="a-Footer">',
'  <div class="a-Footer-info">',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-user" title="&MSG_USER."></span>',
'      <span class="u-VisuallyHidden">&MSG_USER.</span>',
'      &USER.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-workspace" title="&MSG_WORKSPACE."></span>',
'      <span class="u-VisuallyHidden">&MSG_WORKSPACE.</span>',
'      &COMPANY.',
'    </span>',
'    <span class="a-Footer-attribute">',
'      <span class="a-Icon icon-language" title="&MSG_LANGUAGE."></span>',
'      &BROWSER_LANGUAGE.',
'    </span>',
'  </div>',
'  <div class="a-Footer-copyright">&MSG_COPYRIGHT.</div>',
'  <div class="a-Footer-version">#FLOW_VERSION#</div>',
'</footer>',
'#FORM_CLOSE#',
'#DEVELOPER_TOOLBAR#',
'#GENERATED_CSS#',
'#APPLICATION_JAVASCRIPT#',
'#PAGE_JAVASCRIPT#',
'#GENERATED_JAVASCRIPT#',
'</body></html>'))
,p_success_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="sucessMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-success">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-check"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="sucessMsg-Message">#SUCCESS_MESSAGE#</h5>',
'      <button id="sucessMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''sucessMsg'');return false;"><span class="a-I'
||'con icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_notification_message=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-AlertMessages a-AlertMessages--page" role="alert" id="errorMsg">',
' <div class="a-AlertMessages-item">',
'  <div class="a-MediaBlock a-AlertMessages-message is-error">',
'    <div class="a-MediaBlock-graphic">',
'      <span class="a-Icon a-Icon--medium icon-remove"></span> ',
'    </div>',
'    <div class="a-MediaBlock-content">',
'      <h5 class="a-AlertMessages-messageTitle" id="errorMsg-Message">#MESSAGE#</h5>',
'      <button id="errorMsg-Close" class="a-Button a-Button--small a-Button--noUI a-Button--noLabel a-Button--withIcon a-Button--alertMessages" type="button" title="#CLOSE_NOTIFICATION#" onclick="$x_Remove(''errorMsg'');return false;"><span class="a-Ico'
||'n icon-remove"></span></button>',
'    </div>',
'  </div>',
' </div>',
'</div>'))
,p_navigation_bar=>'#BAR_BODY#'
,p_navbar_entry=>'<a href="#LINK#" class="htmldbNavLink">#TEXT#</a>'
,p_region_table_cattributes=>' summary="" cellpadding="0" border="0" cellspacing="2" width="100%"'
,p_sidebar_def_reg_pos=>'BODY_3'
,p_breadcrumb_def_reg_pos=>'REGION_POSITION_08'
,p_theme_class_id=>1
,p_error_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--danger a-Alert--wizard a-Alert--defaultIcons">',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'      </div>',
'      <div class="a-Alert-body">',
'        <h2 class="a-Alert-subTitle">#MESSAGE#</h2>',
'        #ADDITIONAL_INFO#',
'        #TECHNICAL_INFO#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      <button class="a-Button a-Button--large a-Button--hot" onclick="#BACK_LINK#" type="button">#RETURN_TO_APPLICATION#</button>',
'    </div>',
'  </div>',
'</div>'))
,p_grid_type=>'FIXED'
,p_grid_max_columns=>12
,p_grid_always_use_max_columns=>true
,p_grid_has_column_span=>true
,p_grid_always_emit=>false
,p_grid_emit_empty_leading_cols=>true
,p_grid_emit_empty_trail_cols=>false
,p_grid_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-grid-container">',
'#ROWS#',
'</div>'))
,p_grid_row_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-row">',
'#COLUMNS#',
'</div>'))
,p_grid_column_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="apex-col apex-col-#COLUMN_SPAN_NUMBER# #ATTRIBUTES#">',
'#CONTENT#',
'</div>'))
,p_dialog_browser_frame=>'MODAL'
,p_reference_id=>702684260095026477
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140037432347349508)
,p_page_template_id=>wwv_flow_imp.id(707892828837195217)
,p_name=>'Page Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140037549866349508)
,p_page_template_id=>wwv_flow_imp.id(707892828837195217)
,p_name=>'Page Position 1'
,p_placeholder=>'REGION_POSITION_01'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140037608236349508)
,p_page_template_id=>wwv_flow_imp.id(707892828837195217)
,p_name=>'Page Position 2'
,p_placeholder=>'REGION_POSITION_02'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140037703124349508)
,p_page_template_id=>wwv_flow_imp.id(707892828837195217)
,p_name=>'Page Position 3'
,p_placeholder=>'REGION_POSITION_03'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140037854496349508)
,p_page_template_id=>wwv_flow_imp.id(707892828837195217)
,p_name=>'Page Position 4'
,p_placeholder=>'REGION_POSITION_04'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140037977138349508)
,p_page_template_id=>wwv_flow_imp.id(707892828837195217)
,p_name=>'Page Position 7'
,p_placeholder=>'REGION_POSITION_07'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_page_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140038052582349507)
,p_page_template_id=>wwv_flow_imp.id(707892828837195217)
,p_name=>'Page Position 8'
,p_placeholder=>'REGION_POSITION_08'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_menu_button
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(5208262349044176)
,p_template_name=>'APEX 5.0 - Icon Menu Button'
,p_internal_name=>'APEX_5.0_ICON_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#" aria-hidden="true"></span><span class="a-Icon  icon-menu-drop-down" aria-hidden="true"></span></button>'
,p_reference_id=>3705338883615
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_menu_button
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(5208327130603219)
,p_template_name=>'APEX 5.0 - Icon Badge Menu Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_MENU_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_'
||'CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--iconTextButton js-menuButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#><span class='
||'"a-Icon #ICON_CSS_CLASSES#"></span><span class="a-Button-badge"></span><span class="a-Icon icon-menu-drop-down"></span></button>'
,p_reference_id=>631020159860848910
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_badge_button
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(5208338701524668)
,p_template_name=>'APEX 5.0 - Icon Badge Button'
,p_internal_name=>'APEX_5.0_ICON_BADGE_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><span class="a-But'
||'ton-badge"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" aria-label="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#"></span><spa'
||'n class="a-Button-badge"></span></button>'
,p_reference_id=>631020282344854024
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(188432383783551716)
,p_template_name=>'APEX 5.0 - Button'
,p_internal_name=>'APEX_5.0_BUTTON'
,p_template=>'<button onclick="#JAVASCRIPT#" class="a-Button #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_hot_template=>'<button onclick="#JAVASCRIPT#" class="a-Button a-Button--hot #BUTTON_CSS_CLASSES#" type="button" #BUTTON_ATTRIBUTES# id="#BUTTON_ID#">#LABEL!HTML#</button>'
,p_reference_id=>174750904387485475
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_icon_only_button
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(359238865408012460)
,p_template_name=>'APEX 5.0 - Icon Only Button'
,p_internal_name=>'APEX_5.0_ICON_ONLY_BUTTON'
,p_template=>'<button class="a-Button a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CLASSES#" aria-h'
||'idden="true"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--noLabel a-Button--withIcon #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" aria-label="#LABEL!ATTR#" type="button" id="#BUTTON_ID#" title="#LABEL!ATTR#" #BUTTON_ATTRIBUTES#><span class="a-Icon #ICON_CSS_CL'
||'ASSES#" aria-hidden="true"></span></button>'
,p_reference_id=>353820721334283301
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(656569185201725731)
,p_template_name=>'APEX 5.0 - Button with Icon'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL!HTML#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_reference_id=>404889142313786233
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/button/apex_5_0_button_with_icon_not_escaped
begin
wwv_flow_imp_shared.create_button_templates(
 p_id=>wwv_flow_imp.id(2050872492464936456)
,p_template_name=>'APEX 5.0 - Button with Icon - NOT ESCAPED'
,p_internal_name=>'APEX_5.0_BUTTON_WITH_ICON_NOT_ESCAPED'
,p_template=>'<button class="a-Button a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_hot_template=>'<button class="a-Button a-Button--hot a-Button--iconTextButton #BUTTON_CSS_CLASSES#" onclick="#JAVASCRIPT#" type="button" id="#BUTTON_ID#" #BUTTON_ATTRIBUTES#>#LABEL#<span class="a-Icon #ICON_CSS_CLASSES#"></span></button>'
,p_translate_this_template=>'N'
,p_theme_class_id=>1
,p_theme_id=>101
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_search_and_replace_region_editor
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(9958270200471956)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <script type="text/javascript">  ',
'    function toggleFind() {',
'      html_ToggleElement(''body#REGION_ID#'');  ',
'    }',
'  </script>',
'  <div id="body#REGION_ID#" style="display:none;">',
'    <table cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_ID#">',
'      <tr>',
'        <td valign="top">#BODY#</td>',
'        <td valign="top">#CLOSE##EDIT##DELETE##CREATE##CREATE2##PREVIOUS##NEXT#</td>',
'      </tr>',
'    </table>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>unistr('\2713 APEX 4.0 - Search and Replace Region (Editor)')
,p_internal_name=>'APEX_4.0_SEARCH_AND_REPLACE_REGION_EDITOR'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>112829305325461983
,p_template_comment=>'Gray Head, white body'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92337305913279808)
,p_plug_template_id=>wwv_flow_imp.id(9958270200471956)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92337877232279809)
,p_plug_template_id=>wwv_flow_imp.id(9958270200471956)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92338322659279809)
,p_plug_template_id=>wwv_flow_imp.id(9958270200471956)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92338868986279809)
,p_plug_template_id=>wwv_flow_imp.id(9958270200471956)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92339325290279810)
,p_plug_template_id=>wwv_flow_imp.id(9958270200471956)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92339863364279810)
,p_plug_template_id=>wwv_flow_imp.id(9958270200471956)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92340368601279810)
,p_plug_template_id=>wwv_flow_imp.id(9958270200471956)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92340811320279810)
,p_plug_template_id=>wwv_flow_imp.id(9958270200471956)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92341341021279811)
,p_plug_template_id=>wwv_flow_imp.id(9958270200471956)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_dialog
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(10813455696794486)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#"  class="a-DialogRegion js-regionDialog #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# style="display:none" title="#TITLE#">',
'  <div class="a-DialogRegion-body">',
'#BODY#',
'  </div>',
'  <div class="a-DialogRegion-buttons">',
'     <div class="a-ButtonRegion a-ButtonRegion--dialogRegion">',
'       <div class="a-ButtonRegion-wrap">',
'         <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'         <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'       </div>',
'     </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Region Dialog')
,p_internal_name=>'APEX_5.0_REGION_DIALOG'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_template_options=>'js-draggable:js-resizable:js-modal'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>428597701677720079
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88386829079832848)
,p_plug_template_id=>wwv_flow_imp.id(10813455696794486)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88387340970832848)
,p_plug_template_id=>wwv_flow_imp.id(10813455696794486)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88387856893832848)
,p_plug_template_id=>wwv_flow_imp.id(10813455696794486)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88388357101832848)
,p_plug_template_id=>wwv_flow_imp.id(10813455696794486)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88388819562832849)
,p_plug_template_id=>wwv_flow_imp.id(10813455696794486)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88389345709832849)
,p_plug_template_id=>wwv_flow_imp.id(10813455696794486)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88389812345832849)
,p_plug_template_id=>wwv_flow_imp.id(10813455696794486)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88390374829832849)
,p_plug_template_id=>wwv_flow_imp.id(10813455696794486)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_anchors
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(11142767973379800)
,p_layout=>'TABLE'
,p_template=>'<div class="a-PageAnchors #COMPONENT_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>#BODY#</div>'
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Page Anchors')
,p_internal_name=>'APEX_5.0_PAGE_ANCHORS'
,p_plug_table_bgcolor=>'white'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'white'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17354206769599941
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(61219487019728421)
,p_plug_template_id=>wwv_flow_imp.id(11142767973379800)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(61219938731728422)
,p_plug_template_id=>wwv_flow_imp.id(11142767973379800)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_message_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(34638664849443220)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-SystemMessage #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Message Region')
,p_internal_name=>'APEX_5.0_MESSAGE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>29333927116050844
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(61204652863717345)
,p_plug_template_id=>wwv_flow_imp.id(34638664849443220)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(61205157125717346)
,p_plug_template_id=>wwv_flow_imp.id(34638664849443220)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_rounded_corner_small_gray_top
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(37822161250843049)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion smallRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>'APEX 4.0 - Rounded Corner Small (Gray Top)'
,p_internal_name=>'APEX_4.0_ROUNDED_CORNER_SMALL_GRAY_TOP'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>9
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140533970727344476)
,p_plug_template_id=>wwv_flow_imp.id(37822161250843049)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140534065221344476)
,p_plug_template_id=>wwv_flow_imp.id(37822161250843049)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140534176442344476)
,p_plug_template_id=>wwv_flow_imp.id(37822161250843049)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140534219804344476)
,p_plug_template_id=>wwv_flow_imp.id(37822161250843049)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140534321833344476)
,p_plug_template_id=>wwv_flow_imp.id(37822161250843049)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140534405555344476)
,p_plug_template_id=>wwv_flow_imp.id(37822161250843049)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140534524493344476)
,p_plug_template_id=>wwv_flow_imp.id(37822161250843049)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140534630469344476)
,p_plug_template_id=>wwv_flow_imp.id(37822161250843049)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140534735436344475)
,p_plug_template_id=>wwv_flow_imp.id(37822161250843049)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140534847584344475)
,p_plug_template_id=>wwv_flow_imp.id(37822161250843049)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140534959076344475)
,p_plug_template_id=>wwv_flow_imp.id(37822161250843049)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140535027927344475)
,p_plug_template_id=>wwv_flow_imp.id(37822161250843049)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_wizard_box_wide
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(41146075931369682)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="rounded-corner-wiz-region" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# style="width:100%;">',
'  <div class="rc-blue-top"><div class="rc-blue-top-r">',
'    <div class="rc-title"><h2>#TITLE#</h2></div>',
'    <div class="rc-buttons">#CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#</div>',
'  </div></div>',
'  <div class="rc-body"><div class="rc-body-r"><div class="rc-content">#BODY#</div></div></div>',
'  <div class="rc-bottom"><div class="rc-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>unistr('\2713 APEX 4.0 - Wizard Box (wide)')
,p_internal_name=>'APEX_4.0_WIZARD_BOX_WIDE'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>35936104232216540
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93394032075364336)
,p_plug_template_id=>wwv_flow_imp.id(41146075931369682)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93394572961364337)
,p_plug_template_id=>wwv_flow_imp.id(41146075931369682)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93395006325364337)
,p_plug_template_id=>wwv_flow_imp.id(41146075931369682)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93395598549364339)
,p_plug_template_id=>wwv_flow_imp.id(41146075931369682)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93396070436364339)
,p_plug_template_id=>wwv_flow_imp.id(41146075931369682)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93396570121364339)
,p_plug_template_id=>wwv_flow_imp.id(41146075931369682)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93397004758364340)
,p_plug_template_id=>wwv_flow_imp.id(41146075931369682)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93397573252364340)
,p_plug_template_id=>wwv_flow_imp.id(41146075931369682)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93398024026364340)
,p_plug_template_id=>wwv_flow_imp.id(41146075931369682)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_header
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(45982758247246967)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="wizardHeader" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Wizard Header')
,p_internal_name=>'APEX_5.0_WIZARD_HEADER'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42210710875242480
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88193247206816931)
,p_plug_template_id=>wwv_flow_imp.id(45982758247246967)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88193721043816932)
,p_plug_template_id=>wwv_flow_imp.id(45982758247246967)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(47229974494774989)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Wizard-region a-Form #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <h2 class="u-VisuallyHidden">#TITLE#</h2>',
'  <div class="a-Wizard-regionHeader">#REGION_HEADER#</div>',
'  <div class="a-Wizard-regionBody">#BODY#</div>',
'  <div class="a-Wizard-regionFooter">#REGION_FOOTER#</div>',
'</div>'))
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Wizard Region')
,p_internal_name=>'APEX_5.0_WIZARD_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>702777601713950915
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88166453069813703)
,p_plug_template_id=>wwv_flow_imp.id(47229974494774989)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88166914804813703)
,p_plug_template_id=>wwv_flow_imp.id(47229974494774989)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_wizard_body_divider
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(47231973932784377)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion dividerTop" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'<div class="wizardRegionHeading">',
'  <h1>#TITLE#</h1>',
'  <div class="buttonContainer">',
'#EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'  </div>',
'</div>',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>unistr('\2713 APEX 4.2 - Wizard Body (Divider)')
,p_internal_name=>'APEX_4.2_WIZARD_BODY_DIVIDER'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>42209811475242480
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93664089983541302)
,p_plug_template_id=>wwv_flow_imp.id(47231973932784377)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93664500349541305)
,p_plug_template_id=>wwv_flow_imp.id(47231973932784377)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93665013172541305)
,p_plug_template_id=>wwv_flow_imp.id(47231973932784377)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93665553237541305)
,p_plug_template_id=>wwv_flow_imp.id(47231973932784377)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93666061691541305)
,p_plug_template_id=>wwv_flow_imp.id(47231973932784377)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93666532332541306)
,p_plug_template_id=>wwv_flow_imp.id(47231973932784377)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93667051663541306)
,p_plug_template_id=>wwv_flow_imp.id(47231973932784377)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93667557866541306)
,p_plug_template_id=>wwv_flow_imp.id(47231973932784377)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93668095988541306)
,p_plug_template_id=>wwv_flow_imp.id(47231973932784377)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93668585497541310)
,p_plug_template_id=>wwv_flow_imp.id(47231973932784377)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93669077361541310)
,p_plug_template_id=>wwv_flow_imp.id(47231973932784377)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93669573442541310)
,p_plug_template_id=>wwv_flow_imp.id(47231973932784377)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_action_box
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(97184986249431616)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>unistr('\2713 APEX 4.2 - Action Box')
,p_internal_name=>'APEX_4.2_ACTION_BOX'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93452834921372000)
,p_plug_template_id=>wwv_flow_imp.id(97184986249431616)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93453315920372000)
,p_plug_template_id=>wwv_flow_imp.id(97184986249431616)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93453857130372000)
,p_plug_template_id=>wwv_flow_imp.id(97184986249431616)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93454336425372001)
,p_plug_template_id=>wwv_flow_imp.id(97184986249431616)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93454877087372001)
,p_plug_template_id=>wwv_flow_imp.id(97184986249431616)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93455342001372003)
,p_plug_template_id=>wwv_flow_imp.id(97184986249431616)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93455885726372003)
,p_plug_template_id=>wwv_flow_imp.id(97184986249431616)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93456307227372003)
,p_plug_template_id=>wwv_flow_imp.id(97184986249431616)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93456816796372004)
,p_plug_template_id=>wwv_flow_imp.id(97184986249431616)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_action_box_002
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(113038566483763896)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>unistr('\2713 APEX 4.2 - Action Box (2)')
,p_internal_name=>'APEX_4.2_ACTION_BOX'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>18253116293565611
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93461267060372007)
,p_plug_template_id=>wwv_flow_imp.id(113038566483763896)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93461726057372007)
,p_plug_template_id=>wwv_flow_imp.id(113038566483763896)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93462248388372007)
,p_plug_template_id=>wwv_flow_imp.id(113038566483763896)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93462788044372008)
,p_plug_template_id=>wwv_flow_imp.id(113038566483763896)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93463224473372008)
,p_plug_template_id=>wwv_flow_imp.id(113038566483763896)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93463764877372008)
,p_plug_template_id=>wwv_flow_imp.id(113038566483763896)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93464240489372008)
,p_plug_template_id=>wwv_flow_imp.id(113038566483763896)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93464761104372009)
,p_plug_template_id=>wwv_flow_imp.id(113038566483763896)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93465260006372009)
,p_plug_template_id=>wwv_flow_imp.id(113038566483763896)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/page_edit_standard_content
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(114707373931146077)
,p_layout=>'TABLE'
,p_template=>'<section class="aRegion smallHeading noPadding componentRegion #REGION_CSS_CLASSES#" id="#REGION_ID#" #REGION_ATTRIBUTES#>#BODY#</section>'
,p_page_plug_template_name=>'Page Edit - Standard Content'
,p_internal_name=>'PAGE_EDIT_STANDARD_CONTENT'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140539404382344471)
,p_plug_template_id=>wwv_flow_imp.id(114707373931146077)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140539516682344471)
,p_plug_template_id=>wwv_flow_imp.id(114707373931146077)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_page_edit_component_top_bar
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(114716561310184878)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="componentViewHeader aRegion #REGION_CSS_CLASSES#" id="#REGION_ID#" #REGION_ATTRIBUTES#>',
'  <h1>#TITLE#</h1>',
'  #BODY#',
'</section>'))
,p_page_plug_template_name=>'APEX 4.2 - Page Edit Component Top Bar'
,p_internal_name=>'APEX_4.2_PAGE_EDIT_COMPONENT_TOP_BAR'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140539666026344470)
,p_plug_template_id=>wwv_flow_imp.id(114716561310184878)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140539707671344470)
,p_plug_template_id=>wwv_flow_imp.id(114716561310184878)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_action_box_confirm
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(153782564453027959)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion confirmRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>unistr('\2713 APEX 4.2 - Action Box (Confirm) (2)')
,p_internal_name=>'APEX_4.2_ACTION_BOX_CONFIRM'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>186682507972859454
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93553571661376164)
,p_plug_template_id=>wwv_flow_imp.id(153782564453027959)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93554023331376165)
,p_plug_template_id=>wwv_flow_imp.id(153782564453027959)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93554530901376165)
,p_plug_template_id=>wwv_flow_imp.id(153782564453027959)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93555073740376166)
,p_plug_template_id=>wwv_flow_imp.id(153782564453027959)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93555579098376166)
,p_plug_template_id=>wwv_flow_imp.id(153782564453027959)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93556053525376166)
,p_plug_template_id=>wwv_flow_imp.id(153782564453027959)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93556523414376167)
,p_plug_template_id=>wwv_flow_imp.id(153782564453027959)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93557032184376167)
,p_plug_template_id=>wwv_flow_imp.id(153782564453027959)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93557545166376167)
,p_plug_template_id=>wwv_flow_imp.id(153782564453027959)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_action_box_warning
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(168458987621608889)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion warningRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>unistr('\2713 APEX 4.0 - Action Box / Wizard Box (Warning)')
,p_internal_name=>'APEX_4.0_ACTION_BOX_WARNING'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>162320107014603380
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60486650624140152)
,p_plug_template_id=>wwv_flow_imp.id(168458987621608889)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60487179980140152)
,p_plug_template_id=>wwv_flow_imp.id(168458987621608889)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60487656307140153)
,p_plug_template_id=>wwv_flow_imp.id(168458987621608889)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60488101900140153)
,p_plug_template_id=>wwv_flow_imp.id(168458987621608889)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60488617428140153)
,p_plug_template_id=>wwv_flow_imp.id(168458987621608889)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60489106553140153)
,p_plug_template_id=>wwv_flow_imp.id(168458987621608889)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60489649472140154)
,p_plug_template_id=>wwv_flow_imp.id(168458987621608889)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60490188006140154)
,p_plug_template_id=>wwv_flow_imp.id(168458987621608889)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60490621853140156)
,p_plug_template_id=>wwv_flow_imp.id(168458987621608889)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(179988979456212289)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn resize #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-PageColumn-header">',
'    <h2 class="a-PageColumn-heading">#TITLE#</h2>',
'  </div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613223222362440
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140543635407344466)
,p_plug_template_id=>wwv_flow_imp.id(179988979456212289)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140543788174344466)
,p_plug_template_id=>wwv_flow_imp.id(179988979456212289)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column_body
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(179998378981224010)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn-body resize #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column (Body)'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN_BODY'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174630015632506596
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140543898699344466)
,p_plug_template_id=>wwv_flow_imp.id(179998378981224010)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140543913568344466)
,p_plug_template_id=>wwv_flow_imp.id(179998378981224010)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(179998957300224011)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Region')
,p_internal_name=>'APEX_5.0_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174748721787471587
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(87964181140780105)
,p_plug_template_id=>wwv_flow_imp.id(179998957300224011)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(87964693532780105)
,p_plug_template_id=>wwv_flow_imp.id(179998957300224011)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(87965176498780106)
,p_plug_template_id=>wwv_flow_imp.id(179998957300224011)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(87965621155780106)
,p_plug_template_id=>wwv_flow_imp.id(179998957300224011)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(87966128601780106)
,p_plug_template_id=>wwv_flow_imp.id(179998957300224011)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(87966648272780106)
,p_plug_template_id=>wwv_flow_imp.id(179998957300224011)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(87967190558780107)
,p_plug_template_id=>wwv_flow_imp.id(179998957300224011)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(87967650769780107)
,p_plug_template_id=>wwv_flow_imp.id(179998957300224011)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(87968161905780107)
,p_plug_template_id=>wwv_flow_imp.id(179998957300224011)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(87968645207780107)
,p_plug_template_id=>wwv_flow_imp.id(179998957300224011)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(87969158271780108)
,p_plug_template_id=>wwv_flow_imp.id(179998957300224011)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(87969639570780108)
,p_plug_template_id=>wwv_flow_imp.id(179998957300224011)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(87970144781780108)
,p_plug_template_id=>wwv_flow_imp.id(179998957300224011)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_top_buttons
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(179999680126224011)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--left">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--right">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region (Top Buttons)'
,p_internal_name=>'APEX_5.0_REGION_TOP_BUTTONS'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174747104640428780
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140544084793344466)
,p_plug_template_id=>wwv_flow_imp.id(179999680126224011)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140544149150344466)
,p_plug_template_id=>wwv_flow_imp.id(179999680126224011)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140544239873344466)
,p_plug_template_id=>wwv_flow_imp.id(179999680126224011)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140544336128344466)
,p_plug_template_id=>wwv_flow_imp.id(179999680126224011)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140544491435344465)
,p_plug_template_id=>wwv_flow_imp.id(179999680126224011)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140544597747344465)
,p_plug_template_id=>wwv_flow_imp.id(179999680126224011)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140544623057344465)
,p_plug_template_id=>wwv_flow_imp.id(179999680126224011)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140544707114344465)
,p_plug_template_id=>wwv_flow_imp.id(179999680126224011)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140544845908344465)
,p_plug_template_id=>wwv_flow_imp.id(179999680126224011)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140544926369344465)
,p_plug_template_id=>wwv_flow_imp.id(179999680126224011)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140545018000344465)
,p_plug_template_id=>wwv_flow_imp.id(179999680126224011)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140545175177344465)
,p_plug_template_id=>wwv_flow_imp.id(179999680126224011)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140545265461344465)
,p_plug_template_id=>wwv_flow_imp.id(179999680126224011)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_toolbar
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(180000359887224011)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Toolbar #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Toolbar-items a-Toolbar-items--left">#PREVIOUS#</div>',
'  <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Toolbar'
,p_internal_name=>'APEX_5.0_TOOLBAR'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613705533399534
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140546668462344463)
,p_plug_template_id=>wwv_flow_imp.id(180000359887224011)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140546771064344463)
,p_plug_template_id=>wwv_flow_imp.id(180000359887224011)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140546832735344463)
,p_plug_template_id=>wwv_flow_imp.id(180000359887224011)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140546903744344463)
,p_plug_template_id=>wwv_flow_imp.id(180000359887224011)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_nested_splitter
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(182578463737748137)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES# class="resize #REGION_CSS_CLASSES#"> ',
'#BODY#',
'<div id="#REGION_STATIC_ID#_content" class="resize">',
'#SUB_REGIONS#',
'</div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Nested Splitter'
,p_internal_name=>'APEX_5.0_NESTED_SPLITTER'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140547035406344463)
,p_plug_template_id=>wwv_flow_imp.id(182578463737748137)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140547181633344463)
,p_plug_template_id=>wwv_flow_imp.id(182578463737748137)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_tabs
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(188424184018478913)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Tabs-toolbar a-Toolbar">',
'    #SUB_REGION_HEADERS#',
'    <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  </div>',
'  #SUB_REGIONS#',
'</div>',
''))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#">#SUB_REGION_TITLE#</a></li>'
,p_sub_plug_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#SUB_REGION#',
''))
,p_page_plug_template_name=>'APEX 5.0 - Tabs'
,p_internal_name=>'APEX_5.0_TABS'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>183211208341566300
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140547216554344463)
,p_plug_template_id=>wwv_flow_imp.id(188424184018478913)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140547369914344462)
,p_plug_template_id=>wwv_flow_imp.id(188424184018478913)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>false
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140547466089344462)
,p_plug_template_id=>wwv_flow_imp.id(188424184018478913)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_sidebar_gray_header
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(201817560415259244)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion sideRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'    <span class="aButtonContainer">',
'      #EDIT##CLOSE##CREATE##CREATE2##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT#',
'    </span>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>unistr('\2713 APEX 4.0 - Sidebar (Gray Header)')
,p_internal_name=>'APEX_4.0_SIDEBAR_GRAY_HEADER'
,p_plug_table_bgcolor=>'#F7F7E7'
,p_theme_id=>101
,p_theme_class_id=>2
,p_plug_heading_bgcolor=>'#F7F7E7'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>' '
,p_reference_id=>17355419405599943
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92402528083283262)
,p_plug_template_id=>wwv_flow_imp.id(201817560415259244)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92403094154283262)
,p_plug_template_id=>wwv_flow_imp.id(201817560415259244)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92403553857283263)
,p_plug_template_id=>wwv_flow_imp.id(201817560415259244)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92404096479283263)
,p_plug_template_id=>wwv_flow_imp.id(201817560415259244)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92404532261283263)
,p_plug_template_id=>wwv_flow_imp.id(201817560415259244)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92405089211283263)
,p_plug_template_id=>wwv_flow_imp.id(201817560415259244)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92405553897283264)
,p_plug_template_id=>wwv_flow_imp.id(201817560415259244)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92406039871283264)
,p_plug_template_id=>wwv_flow_imp.id(201817560415259244)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92406556209283264)
,p_plug_template_id=>wwv_flow_imp.id(201817560415259244)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92407044001283265)
,p_plug_template_id=>wwv_flow_imp.id(201817560415259244)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92407553605283265)
,p_plug_template_id=>wwv_flow_imp.id(201817560415259244)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92408058378283265)
,p_plug_template_id=>wwv_flow_imp.id(201817560415259244)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_2_action_box_confirm_002
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(207487462312907810)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aRegion aActionRegion confirmRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="aRegionHeading">',
'    <h1>#TITLE#</h1>',
'  </div>',
'  <div class="aRegionContent clearfix">',
'    <div class="aActionRegionIcon">',
'      <img src="#IMAGE_PREFIX#f_spacer.gif" alt="" />',
'    </div>',
'    #BODY#',
'  </div>',
'  <span class="aButtonContainer">',
'    #CLOSE##DELETE##EDIT##CHANGE##PREVIOUS##NEXT##CREATE#',
'  </span>',
'</section>'))
,p_page_plug_template_name=>unistr('\2713 APEX 4.2 - Action Box (Confirm)')
,p_internal_name=>'APEX_4.2_ACTION_BOX_CONFIRM'
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>186682507972859454
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93545111513376158)
,p_plug_template_id=>wwv_flow_imp.id(207487462312907810)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93545630309376158)
,p_plug_template_id=>wwv_flow_imp.id(207487462312907810)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93546175428376159)
,p_plug_template_id=>wwv_flow_imp.id(207487462312907810)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93546617198376159)
,p_plug_template_id=>wwv_flow_imp.id(207487462312907810)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93547173798376159)
,p_plug_template_id=>wwv_flow_imp.id(207487462312907810)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93547604083376159)
,p_plug_template_id=>wwv_flow_imp.id(207487462312907810)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93548160087376160)
,p_plug_template_id=>wwv_flow_imp.id(207487462312907810)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93548675175376160)
,p_plug_template_id=>wwv_flow_imp.id(207487462312907810)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(93549165734376160)
,p_plug_template_id=>wwv_flow_imp.id(207487462312907810)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_div_with_id_class_and_region_attributes
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(214132567690623104)
,p_layout=>'TABLE'
,p_template=>'<div id="#REGION_STATIC_ID#" class="#REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>#PREVIOUS##BODY##NEXT#</div>'
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Div with ID, Class, and Region Attributes')
,p_internal_name=>'APEX_5.0_DIV_WITH_ID,_CLASS,_AND_REGION_ATTRIBUTES'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>716895227337398760
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60873042694492547)
,p_plug_template_id=>wwv_flow_imp.id(214132567690623104)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60873504715492547)
,p_plug_template_id=>wwv_flow_imp.id(214132567690623104)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60874027551492547)
,p_plug_template_id=>wwv_flow_imp.id(214132567690623104)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60874531904492548)
,p_plug_template_id=>wwv_flow_imp.id(214132567690623104)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_column_no_heading
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(231276082996869606)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-PageColumn resize #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  #BODY#',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Column (No Heading)'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_COLUMN_NO_HEADING'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>174613223222362440
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140551189966344458)
,p_plug_template_id=>wwv_flow_imp.id(231276082996869606)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140551211679344458)
,p_plug_template_id=>wwv_flow_imp.id(231276082996869606)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_4_0_top_bar_for_list_buttons
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(259285788981232056)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="topbar" style="width:100%;clear:both;" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="topbar-top"><div class="topbar-top-r"></div></div>',
'  <div class="topbar-body"><div class="topbar-body-r"><div class="topbar-content">',
'     #BODY#',
'   </div></div></div>',
'  <div class="topbar-bottom"><div class="topbar-bottom-r"></div></div>',
'</div>'))
,p_page_plug_template_name=>unistr('\2713 APEX 4.0 - Top Bar (for list buttons)')
,p_internal_name=>'APEX_4.0_TOP_BAR_FOR_LIST_BUTTONS'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>254074518265073133
,p_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <table class="TopBarUIFix" cellpadding="0" cellspacing="0" border="0" summary="" id="#REGION_STATIC_ID#" width="100%"><tbody class="GreenBar"><tr><td valign="middle" class="L">#BODY#</td><td width="30" class="C"><br /></td><td valign="middle" class='
||'"R" align="right"><span style="margin-right:10px;">#CLOSE#</span>#COPY##DELETE##CHANGE##EDIT##PREVIOUS##NEXT##CREATE##EXPAND#</td></tr></tbody></table>',
''))
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92573551007304929)
,p_plug_template_id=>wwv_flow_imp.id(259285788981232056)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(92574076924304929)
,p_plug_template_id=>wwv_flow_imp.id(259285788981232056)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_body_hide_show
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(405054454026874128)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<section class="aWizardRegion aWizardRegion--disclosure" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="wizardRegionHeading">',
'    <h2>',
'        <button type="button">#TITLE#</button>',
'    </h2>',
'    <div class="buttonContainer">',
'    #EDIT##CLOSE##EXPAND##HELP##DELETE##COPY##PREVIOUS##NEXT##CREATE##CREATE2#',
'    </div>',
'  </div>',
'  <div class="hideShowRegion" id="#REGION_STATIC_ID#_content">',
'    #BODY#',
'  </div>',
'</section>'))
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Wizard Body (Hide/Show)')
,p_internal_name=>'APEX_5.0_WIZARD_BODY_HIDE/SHOW'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'$( "##REGION_STATIC_ID#" ).collapsible({',
'    content: $( "##REGION_STATIC_ID#_content" )',
'});'))
,p_theme_id=>101
,p_theme_class_id=>12
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>399850559367741099
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88258709520825403)
,p_plug_template_id=>wwv_flow_imp.id(405054454026874128)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88259223064825403)
,p_plug_template_id=>wwv_flow_imp.id(405054454026874128)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88259705022825403)
,p_plug_template_id=>wwv_flow_imp.id(405054454026874128)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88260255524825404)
,p_plug_template_id=>wwv_flow_imp.id(405054454026874128)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88260707800825404)
,p_plug_template_id=>wwv_flow_imp.id(405054454026874128)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88261266311825404)
,p_plug_template_id=>wwv_flow_imp.id(405054454026874128)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88261751723825404)
,p_plug_template_id=>wwv_flow_imp.id(405054454026874128)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88262201801825405)
,p_plug_template_id=>wwv_flow_imp.id(405054454026874128)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88262774932825405)
,p_plug_template_id=>wwv_flow_imp.id(405054454026874128)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88263243961825405)
,p_plug_template_id=>wwv_flow_imp.id(405054454026874128)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88263790082825406)
,p_plug_template_id=>wwv_flow_imp.id(405054454026874128)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88264245907825406)
,p_plug_template_id=>wwv_flow_imp.id(405054454026874128)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_interactive_report_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(651492083233530570)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" role="region" aria-labelledby="#REGION_STATIC_ID#_heading" class="a-IRR-region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>',
'  <h2 id="#REGION_STATIC_ID#_heading" class="u-vh">#TITLE#</h2>',
'  #PREVIOUS##BODY##NEXT#',
'</div>',
''))
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Interactive Report Region')
,p_internal_name=>'APEX_5.0_INTERACTIVE_REPORT_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_template_options=>'a-IRR-region--responsiveIconView'
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>678354360586321695
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(214861993066632768)
,p_plug_template_id=>wwv_flow_imp.id(651492083233530570)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(214862497582632769)
,p_plug_template_id=>wwv_flow_imp.id(651492083233530570)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(214862999247632769)
,p_plug_template_id=>wwv_flow_imp.id(651492083233530570)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(214863464743632769)
,p_plug_template_id=>wwv_flow_imp.id(651492083233530570)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_region_with_icon
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(660773436427335038)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hasIcon #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'    <div class="a-RegionMedia">',
'      <div class="a-RegionMedia-graphic">',
'        <span class="a-Icon a-Icon--regionIcon #ICON_CSS_CLASSES#"></span>',
'      </div>',
'      <div class="a-RegionMedia-content">',
'        #BODY#',
'      </div>',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Region with Icon'
,p_internal_name=>'APEX_5.0_REGION_WITH_ICON'
,p_theme_id=>101
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--noPadding'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>698829239393878937
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140553146344344456)
,p_plug_template_id=>wwv_flow_imp.id(660773436427335038)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140553203010344456)
,p_plug_template_id=>wwv_flow_imp.id(660773436427335038)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140553361249344456)
,p_plug_template_id=>wwv_flow_imp.id(660773436427335038)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140553417621344456)
,p_plug_template_id=>wwv_flow_imp.id(660773436427335038)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140553537458344456)
,p_plug_template_id=>wwv_flow_imp.id(660773436427335038)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140553682582344456)
,p_plug_template_id=>wwv_flow_imp.id(660773436427335038)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140553790917344456)
,p_plug_template_id=>wwv_flow_imp.id(660773436427335038)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140553810743344456)
,p_plug_template_id=>wwv_flow_imp.id(660773436427335038)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140553954807344456)
,p_plug_template_id=>wwv_flow_imp.id(660773436427335038)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140554013457344455)
,p_plug_template_id=>wwv_flow_imp.id(660773436427335038)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140554193838344455)
,p_plug_template_id=>wwv_flow_imp.id(660773436427335038)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140554255498344455)
,p_plug_template_id=>wwv_flow_imp.id(660773436427335038)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140554376759344455)
,p_plug_template_id=>wwv_flow_imp.id(660773436427335038)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_button_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(694479338908463138)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ButtonRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-ButtonRegion-wrap">',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--left"><div class="a-ButtonRegion-buttons">#PREVIOUS##DELETE##CLOSE#</div></div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--content">',
'      <h2 class="a-ButtonRegion-title">#TITLE#</h2>',
'      #BODY#',
'      <div class="a-ButtonRegion-buttons">#CHANGE#</div>',
'    </div>',
'    <div class="a-ButtonRegion-col a-ButtonRegion-col--right"><div class="a-ButtonRegion-buttons">#EDIT##CREATE##NEXT#</div></div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Button Region'
,p_internal_name=>'APEX_5.0_BUTTON_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_template_options=>'a-ButtonRegion--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>687153470345619376
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140554433752344455)
,p_plug_template_id=>wwv_flow_imp.id(694479338908463138)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140554594606344455)
,p_plug_template_id=>wwv_flow_imp.id(694479338908463138)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140554683217344455)
,p_plug_template_id=>wwv_flow_imp.id(694479338908463138)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140554758557344455)
,p_plug_template_id=>wwv_flow_imp.id(694479338908463138)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140554800150344455)
,p_plug_template_id=>wwv_flow_imp.id(694479338908463138)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140554969183344455)
,p_plug_template_id=>wwv_flow_imp.id(694479338908463138)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140555066366344454)
,p_plug_template_id=>wwv_flow_imp.id(694479338908463138)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140555101974344454)
,p_plug_template_id=>wwv_flow_imp.id(694479338908463138)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140555230164344454)
,p_plug_template_id=>wwv_flow_imp.id(694479338908463138)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_hide_show_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(695174842442319385)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region a-Region--hideShow #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--controls">',
'        <h2 class="a-Region-title">',
'            <button class="a-Region-toggle" type="button">#TITLE#</button>',
'        </h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Hide + Show Region')
,p_internal_name=>'APEX_5.0_HIDE_+_SHOW_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_template_options=>'a-Region--flush'
,p_preset_template_options=>'is-expanded'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>689955986849128825
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60996939602684343)
,p_plug_template_id=>wwv_flow_imp.id(695174842442319385)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60997469733684344)
,p_plug_template_id=>wwv_flow_imp.id(695174842442319385)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60997903186684344)
,p_plug_template_id=>wwv_flow_imp.id(695174842442319385)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60998431978684345)
,p_plug_template_id=>wwv_flow_imp.id(695174842442319385)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60998939654684345)
,p_plug_template_id=>wwv_flow_imp.id(695174842442319385)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60999453242684345)
,p_plug_template_id=>wwv_flow_imp.id(695174842442319385)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60999988629684345)
,p_plug_template_id=>wwv_flow_imp.id(695174842442319385)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(61000418679684346)
,p_plug_template_id=>wwv_flow_imp.id(695174842442319385)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(61000925592684346)
,p_plug_template_id=>wwv_flow_imp.id(695174842442319385)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(61001446293684346)
,p_plug_template_id=>wwv_flow_imp.id(695174842442319385)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(61001909379684347)
,p_plug_template_id=>wwv_flow_imp.id(695174842442319385)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(61002486255684347)
,p_plug_template_id=>wwv_flow_imp.id(695174842442319385)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(61002997026684347)
,p_plug_template_id=>wwv_flow_imp.id(695174842442319385)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_wizard_title_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(708692623972319459)
,p_layout=>'TABLE'
,p_template=>'<div class="#REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#><h1 class="a-Wizard-title">#TITLE#</h1></div>'
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Wizard Title Region')
,p_internal_name=>'APEX_5.0_WIZARD_TITLE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>703469000349150769
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88137615068806717)
,p_plug_template_id=>wwv_flow_imp.id(708692623972319459)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88138112314806718)
,p_plug_template_id=>wwv_flow_imp.id(708692623972319459)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_alert
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(775445099592054705)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon #ICON_CSS_CLASSES#"></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">#TITLE#</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        #BODY#',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      #PREVIOUS##CLOSE##CREATE##NEXT#',
'    </div>',
'  </div>',
'</div>'))
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Alert')
,p_internal_name=>'APEX_5.0_ALERT'
,p_theme_id=>101
,p_theme_class_id=>7
,p_default_template_options=>'a-Alert--defaultIcons'
,p_preset_template_options=>'a-Alert--warning:a-Alert--wizard'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>746362351042209764
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60685104840216328)
,p_plug_template_id=>wwv_flow_imp.id(775445099592054705)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60685611981216328)
,p_plug_template_id=>wwv_flow_imp.id(775445099592054705)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60686115903216328)
,p_plug_template_id=>wwv_flow_imp.id(775445099592054705)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60686695776216328)
,p_plug_template_id=>wwv_flow_imp.id(775445099592054705)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60687116918216329)
,p_plug_template_id=>wwv_flow_imp.id(775445099592054705)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60687689962216329)
,p_plug_template_id=>wwv_flow_imp.id(775445099592054705)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_1_tabs_with_icons_text
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(1099875267597409334)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Tabs-toolbar a-Toolbar">',
'    #SUB_REGION_HEADERS#',
'    <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  </div>',
'  #SUB_REGIONS#',
'</div>'))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#"><span title="#SUB_REGION_TITLE#" class="a-Icon #SUB_REGION_ICON_CSS_CLASSES#"></span><span class="a-Tabs-label">#SUB_REGION_TITLE#</span></a></li>'
,p_sub_plug_template=>'#SUB_REGION#'
,p_page_plug_template_name=>unistr('\2713 APEX 5.1 - Tabs with Icons + Text')
,p_internal_name=>'APEX_5.1_TABS_WITH_ICONS_+_TEXT'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>1094662472079256126
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88509260835887782)
,p_plug_template_id=>wwv_flow_imp.id(1099875267597409334)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88509759643887782)
,p_plug_template_id=>wwv_flow_imp.id(1099875267597409334)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(88510232633887783)
,p_plug_template_id=>wwv_flow_imp.id(1099875267597409334)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_processing_spinner_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(1152499662607227329)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ProcessingRegion #REGION_CSS_CLASSES#" id="#REGION_STATIC_ID#" #REGION_ATTRIBUTES#>',
'  <span class="u-Processing"><span class="u-Processing-spinner"></span></span>',
'  <div class="a-ProcessingRegion-title">#TITLE#</div>',
'  <div class="a-ProcessingRegion-body">#BODY#</div>',
'</div>'))
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Processing Spinner Region')
,p_internal_name=>'APEX_5.0_PROCESSING_SPINNER_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>1147280303078953726
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(61241994021733470)
,p_plug_template_id=>wwv_flow_imp.id(1152499662607227329)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(61242423389733470)
,p_plug_template_id=>wwv_flow_imp.id(1152499662607227329)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_grouping_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(1162906397341693705)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Region #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#" role="group" aria-labelledby="#REGION_STATIC_ID#_label">',
'  <div class="a-Region-header">',
'    <div class="a-Region-headerItems  a-Region-headerItems--title">',
'      <h2 class="a-Region-title" id="#REGION_STATIC_ID#_label">#TITLE#</h2>',
'    </div>',
'    <div class="a-Region-headerItems  a-Region-headerItems--buttons">',
'      #PREVIOUS##EXPAND##EDIT##CHANGE##DELETE##COPY##HELP##NEXT##CREATE##CREATE2##CLOSE#',
'    </div>',
'  </div>',
'  <div class="a-Region-body">',
'  <div class="a-Region-bodyHeader">#REGION_HEADER#</div>',
'  #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>unistr('\2713 APEX 5.0 - Grouping Region')
,p_internal_name=>'APEX_5.0_GROUPING_REGION'
,p_theme_id=>101
,p_theme_class_id=>21
,p_preset_template_options=>'a-Region--paddedBody:a-Region--simple'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>1157694368668532777
,p_template_comment=>'      <button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--noUI a-Button--goToTop" onclick="uF();" type="button" title="&TOP."><span class="a-Icon icon-up-chevron"></span></button>'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60804047600232524)
,p_plug_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60804585754232525)
,p_plug_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_name=>'Change'
,p_placeholder=>'CHANGE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60805066569232525)
,p_plug_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_name=>'Close'
,p_placeholder=>'CLOSE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60805545936232525)
,p_plug_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_name=>'Copy'
,p_placeholder=>'COPY'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60806069892232525)
,p_plug_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_name=>'Create'
,p_placeholder=>'CREATE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60806520019232526)
,p_plug_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_name=>'Create2'
,p_placeholder=>'CREATE2'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60807044990232526)
,p_plug_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_name=>'Delete'
,p_placeholder=>'DELETE'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60807525967232526)
,p_plug_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_name=>'Edit'
,p_placeholder=>'EDIT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60808061521232526)
,p_plug_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_name=>'Expand'
,p_placeholder=>'EXPAND'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60808555709232527)
,p_plug_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_name=>'Help'
,p_placeholder=>'HELP'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60809086726232527)
,p_plug_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60809513457232527)
,p_plug_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_name=>'Previous'
,p_placeholder=>'PREVIOUS'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(60810066629232528)
,p_plug_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_page_designer_tree_region
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(1498725972854847460)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div id="#REGION_STATIC_ID#" class="a-PageDesigner-treeRegion resize #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES#>',
'  <div class="a-Toolbar a-Toolbar-pageColumn a-Toolbar--treeRegion">',
'    <div class="a-Toolbar-items a-Toolbar-items--left">',
'      <h3 id="#REGION_STATIC_ID#_title" class="a-PageDesigner-treeTitle">#TITLE#</h3>',
'    </div>',
'    <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  </div>',
'  <div class="a-PageDesigner-treeWrap u-ScrollingViewport resize">',
'    #BODY#',
'  </div>',
'</div>'))
,p_page_plug_template_name=>'APEX 5.0 - Page Designer Tree Region'
,p_internal_name=>'APEX_5.0_PAGE_DESIGNER_TREE_REGION'
,p_plug_table_bgcolor=>'#FFFFFF'
,p_theme_id=>101
,p_theme_class_id=>0
,p_plug_heading_bgcolor=>'#FFFFFF'
,p_plug_font_size=>'-1'
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_form_table_attr=>'class="htmldbInstruct"'
,p_reference_id=>1493511686675667790
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140524107544344490)
,p_plug_template_id=>wwv_flow_imp.id(1498725972854847460)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140524276298344489)
,p_plug_template_id=>wwv_flow_imp.id(1498725972854847460)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140524318974344489)
,p_plug_template_id=>wwv_flow_imp.id(1498725972854847460)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/region/apex_5_0_tabs_with_icons
begin
wwv_flow_imp_shared.create_plug_template(
 p_id=>wwv_flow_imp.id(2051465203902440174)
,p_layout=>'TABLE'
,p_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer #REGION_CSS_CLASSES#" #REGION_ATTRIBUTES# id="#REGION_STATIC_ID#">',
'  <div class="a-Tabs-toolbar a-Toolbar">',
'    #SUB_REGION_HEADERS#',
'    <div class="a-Toolbar-items a-Toolbar-items--right">#NEXT#</div>',
'  </div>',
'  #SUB_REGIONS#',
'</div>'))
,p_sub_plug_header_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul>',
'#ENTRIES#',
'</ul>'))
,p_sub_plug_header_entry_templ=>'<li><a href="##SUB_REGION_ID#"><span title="#SUB_REGION_TITLE#" class="a-Icon #SUB_REGION_ICON_CSS_CLASSES#"></span><span class="u-VisuallyHidden">#SUB_REGION_TITLE#</span></a></li>'
,p_sub_plug_template=>'#SUB_REGION#'
,p_page_plug_template_name=>'APEX 5.0 - Tabs with Icons'
,p_internal_name=>'APEX_5.0_TABS_WITH_ICONS'
,p_theme_id=>101
,p_theme_class_id=>21
,p_default_label_alignment=>'RIGHT'
,p_default_field_alignment=>'LEFT'
,p_reference_id=>2046249791523279568
,p_translate_this_template=>'N'
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140524455557344489)
,p_plug_template_id=>wwv_flow_imp.id(2051465203902440174)
,p_name=>'Region Body'
,p_placeholder=>'BODY'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>true
,p_has_button_support=>true
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140524586080344489)
,p_plug_template_id=>wwv_flow_imp.id(2051465203902440174)
,p_name=>'Sub Regions'
,p_placeholder=>'SUB_REGIONS'
,p_has_grid_support=>true
,p_has_region_support=>true
,p_has_item_support=>false
,p_has_button_support=>false
,p_glv_new_row=>true
);
wwv_flow_imp_shared.create_plug_tmpl_display_point(
 p_id=>wwv_flow_imp.id(140524635101344489)
,p_plug_template_id=>wwv_flow_imp.id(2051465203902440174)
,p_name=>'Next'
,p_placeholder=>'NEXT'
,p_has_grid_support=>false
,p_has_region_support=>false
,p_has_item_support=>false
,p_has_button_support=>true
,p_glv_new_row=>true
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_menu_popup
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(5208269691267696)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Menu Popup'
,p_internal_name=>'APEX_5.0_MENU_POPUP'
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var e = apex.jQuery("##PARENT_STATIC_ID#_menu", apex.gPageContext$);',
'if (e.hasClass("js-addActions")) {',
'  apex.actions.addFromMarkup(e);',
'}',
'e.menu({ slide: e.hasClass("js-slide")});',
''))
,p_theme_id=>101
,p_theme_class_id=>20
,p_list_template_before_rows=>'<div id="#PARENT_STATIC_ID#_menu" class="#COMPONENT_CSS_CLASSES#" style="display:none;"><ul>'
,p_list_template_after_rows=>'</ul></div>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_sub_list_item_noncurrent=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_item_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_item_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_curr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_sub_templ_noncurr_w_child=>'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>'
,p_reference_id=>747588010155545129
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_second_level_tabs_navigation
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(11515926722097128)
,p_list_template_current=>'<li class="a-Tabs-item is-active"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX Second Level Tabs Navigation'
,p_internal_name=>'APEX_SECOND_LEVEL_TABS_NAVIGATION'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>' <div class="a-TabsContainer a-TabsContainer--subTabs"><ul class="a-Tabs a-Tabs--subTabButtons">'
,p_list_template_after_rows=>' '
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(40271258725782407)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item is-current #A03#" aria-current="page">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item #A03#">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>',
''))
,p_list_template_name=>unistr('\2713 APEX 5.0 - Links List (2)')
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>101
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item is-current #A03#" aria-current="page">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>'))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item #A03#">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>'))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item is-current is-expanded #A03#" aria-current="page">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'  #SUB_LISTS#',
'</li>'))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item #A03#">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'  #SUB_LISTS#',
'</li>'))
,p_reference_id=>60219508156141083
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_wizard_progress
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(45984563067371352)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-WizardSteps-step is-active" aria-current="step">',
'  <div class="a-WizardSteps-wrap">',
'    <span class="a-WizardSteps-marker" aria-hidden="true"><span class="a-Icon icon-wizard-step-complete"></span></span>',
'    <span class="a-WizardSteps-label">#TEXT#</span>',
'  </div>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-WizardSteps-step is-inactive">',
'  <div class="a-WizardSteps-wrap">',
'    <span class="a-WizardSteps-marker" aria-hidden="true"><span class="a-Icon icon-wizard-step-complete"></span></span>',
'    <span class="a-WizardSteps-label">#TEXT#</span>',
'  </div>',
'</li>',
''))
,p_list_template_name=>'APEX 5.0 - Wizard Progress'
,p_internal_name=>'APEX_5.0_WIZARD_PROGRESS'
,p_theme_id=>101
,p_theme_class_id=>17
,p_default_template_options=>'a-WizardSteps--slim'
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul aria-label="#CURRENT_PROGRESS#" class="a-WizardSteps #COMPONENT_CSS_CLASSES#">',
''))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>687902065557685310
);
end;
/
prompt --application/shared_components/user_interface/templates/list/horizontal_list_with_images_fixed_width_30pxc_htmldblistimageshfw
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(79963472647518994)
,p_list_template_current=>'<td align="center" valign="top"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="htmldbGreenIcon" /></a><a href="#LINK#" class="noVisit" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_noncurrent=>'<td align="center" valign="top"><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# class="htmldbGreenIcon"/></a><a href="#LINK#" class="noVisit" title="#TEXT_ESC_SC#">#TEXT#</a></td>'
,p_list_template_name=>'Horizontal List with Images Fixed Width 30px(c:htmldbListImagesHFW)'
,p_internal_name=>'HORIZONTAL_LIST_WITH_IMAGES_FIXED_WIDTH_30PXC:HTMLDBLISTIMAGESHFW'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<table cellspacing="0" cellpadding="0" border="0" class="htmldbListImages30px" summary=""><tr>'
,p_list_template_after_rows=>'</tr></table>'
,p_reference_id=>338219701416750315
);
end;
/
prompt --application/shared_components/user_interface/templates/list/simple_image_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(120406665657180147)
,p_list_template_current=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li><a href="#LINK#" title="#TEXT#">#TEXT#</a></li>'
,p_list_template_name=>'Simple Image List'
,p_internal_name=>'SIMPLE_IMAGE_LIST'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="listwithicon">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>32421627622986728
,p_list_template_comment=>'<img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# />'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/unordered_list_without_links
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(143051788198654131)
,p_list_template_current=>'<li><span class="fielddata">#TEXT#</span></li>'
,p_list_template_noncurrent=>'<li><span class="fielddata">#TEXT#</a></li>'
,p_list_template_name=>'unordered list without links'
,p_internal_name=>'UNORDERED_LIST_WITHOUT_LINKS'
,p_theme_id=>101
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="htmldbUl">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_sub_tabs
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(173916782273383700)
,p_list_template_current=>'<li class="a-Tabs-item is-active" aria-current="page"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-Tabs-item"><a href="#LINK#" class="a-Tabs-link">#TEXT#</a></li>'
,p_list_template_name=>'APEX 5.0 - Sub Tabs'
,p_internal_name=>'APEX_5.0_SUB_TABS'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TabsContainer a-TabsContainer--subTabs">',
'  <ul class="a-Tabs a-Tabs--subTabButtons">'))
,p_list_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  </ul>',
'</div>'))
,p_reference_id=>168708522102193705
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="aSubTabs"><ul>',
'<li class="active"><a href="#LINK#" title="#TEXT_ESC_SC#"><span>#TEXT#</span></a></li>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_2_run_edit_bar
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(215597759297909051)
,p_list_template_current=>'  <li><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#TEXT_ESC_SC#" class="iconSmall #A01#" /></a></li>'
,p_list_template_noncurrent=>'  <li><a href="#LINK#" title="#TEXT_ESC_SC#"><img src="#IMAGE_PREFIX#f_spacer.gif" alt="#TEXT_ESC_SC#" class="iconSmall #A01#" /></a></li>'
,p_list_template_name=>'APEX 4.2 - Run / Edit Bar'
,p_internal_name=>'APEX_4.2_RUN_/_EDIT_BAR'
,p_theme_id=>101
,p_theme_class_id=>3
,p_list_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="aRunEditBar">',
'  <li><span class="currentPage">&PAGE. &FB_FLOW_PAGE_ID.</span></li>'))
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>210390516819756900
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_4_0_pull_down_button_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(259079678731769191)
,p_list_template_current=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton hotButton #A01#" type="button"><span>#TEXT#</span></button> '
,p_list_template_noncurrent=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton #A01#" type="button"><span>#TEXT#</span></button> '
,p_list_template_name=>'APEX 4.0 - Pull Down Button List'
,p_internal_name=>'APEX_4.0_PULL_DOWN_BUTTON_LIST'
,p_theme_id=>101
,p_theme_class_id=>9
,p_list_template_before_rows=>'<div class="rButtonContainer dhtmlMenuLGButton">'
,p_list_template_after_rows=>'</div>'
,p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu" style="display:none;">'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep" /></li>'
,p_sub_list_item_noncurrent=>'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>'
,p_item_templ_curr_w_child=>'<button onclick="javascript:redirect(''#LINK#'')" class="aButton hotButton #A01#" type="button"><span>#TEXT#</span></button> '
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<button onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" class="dhtmlMenu" type="button"><span>#TEXT#<img src="#IMAGE_PREFIX#f_spacer.gif" alt="" /></span></button> ',
''))
,p_sub_templ_curr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>'
,p_sub_templ_noncurr_w_child=>'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>'
,p_reference_id=>253872418832604079
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_navigation_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(389919542813170530)
,p_list_template_current=>'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>'
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_list_template_name=>'APEX 5.0 - Navigation List'
,p_internal_name=>'APEX_5.0_NAVIGATION_LIST'
,p_theme_id=>101
,p_theme_class_id=>7
,p_list_template_before_rows=>'<ul>'
,p_list_template_after_rows=>'</ul>'
,p_before_sub_list=>'<ul>'
,p_after_sub_list=>'</ul></li>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a></li>',
''))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-current="true" data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_sub_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li data-id="#A01#" data-disabled="#A02#" data-hide="#A03#" data-shortcut="#A05#" data-icon="#IMAGE#"><a href="#LINK#" title="#A04#">#TEXT_ESC_SC#</a>',
''))
,p_reference_id=>573607518145151423
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_image_navigation
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(486498848592697101)
,p_list_template_current=>'<li class="a-ImageNav-item"><button type="button" data-link="#LINK#" class="a-ImageNav-link launch-aut #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></button></li>'
,p_list_template_noncurrent=>'<li class="a-ImageNav-item"><a href="#LINK#" class="a-ImageNav-link #A01#"><span class="a-ImageNav-img gi-icon-#IMAGE#"></span><span class="a-ImageNav-label">#TEXT_ESC_SC#</span></a></li>'
,p_list_template_name=>'APEX 5.0 - Image Navigation'
,p_internal_name=>'APEX_5.0_IMAGE_NAVIGATION'
,p_theme_id=>101
,p_theme_class_id=>0
,p_list_template_before_rows=>'<ul class="a-ImageNav #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>481290423891543508
,p_list_template_comment=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<td style="width: 20%">',
'	<a href="#LINK#" class="iconContainer" title="#TEXT_ESC_SC#">',
'		<span class="largeIcon"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# /></span>',
'		<span class="iconLabel">#TEXT#</span>',
'	</a>',
'</td>'))
);
end;
/
prompt --application/shared_components/user_interface/templates/list/unordered_list_no_links
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(497344687322855129)
,p_list_template_current=>'<li>#TEXT#</li>'
,p_list_template_noncurrent=>'<li>#TEXT#</li>'
,p_list_template_name=>'Unordered List (no links)'
,p_internal_name=>'UNORDERED_LIST_NO_LINKS'
,p_theme_id=>101
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="htmldbUl">'
,p_list_template_after_rows=>'</ul>'
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_media_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(698626888016487602)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item is-active">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon" aria-hidden="true"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title" aria-current="page">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-MediaList-item">',
'    <a href="#LINK#" class="a-MediaList-link" #A03#>',
'        <div class="a-MediaList-iconWrap">',
'            <span class="a-MediaList-icon" aria-hidden="true"><span class="a-Icon #IMAGE#" #IMAGE_ATTR#></span></span>',
'        </div>',
'        <div class="a-MediaList-body">',
'            <h3 class="a-MediaList-title">#TEXT#</h3>',
'            <p class="a-MediaList-desc">#A01#</p>',
'        </div>',
'        <div class="a-MediaList-badgeWrap">',
'            <span class="a-MediaList-badge">#A02#</span>',
'        </div>',
'    </a>',
'</li>'))
,p_list_template_name=>'APEX 5.0 - Media List'
,p_internal_name=>'APEX_5.0_MEDIA_LIST'
,p_theme_id=>101
,p_theme_class_id=>9
,p_default_template_options=>'a-MediaList--noBadge'
,p_list_template_before_rows=>'<ul class="a-MediaList #COMPONENT_CSS_CLASSES#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>692720897220784060
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_links_list_002
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(702419290542782266)
,p_list_template_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item is-current #A03#" aria-current="page">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>',
''))
,p_list_template_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item #A03#">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>',
''))
,p_list_template_name=>unistr('\2713 APEX 5.0 - Links List')
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_theme_id=>101
,p_theme_class_id=>1
,p_default_template_options=>'a-LinksList--showArrow'
,p_list_template_before_rows=>'<ul class="a-LinksList #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_after_sub_list=>'</ul>'
,p_sub_list_item_current=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item is-current #A03#" aria-current="page">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>'))
,p_sub_list_item_noncurrent=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item #A03#">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'</li>'))
,p_item_templ_curr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item is-current is-expanded #A03#" aria-current="page">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'  #SUB_LISTS#',
'</li>'))
,p_item_templ_noncurr_w_child=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-LinksList-item #A03#">',
'  <a href="#LINK#" class="a-LinksList-link" #A02#>',
'    <span class="a-LinksList-icon" aria-hidden="true"><span class="t-Icon #IMAGE#"></span></span>',
'    <span class="a-LinksList-label">#TEXT#</span>',
'    <span class="a-LinksList-badge">#A01#</span>',
'    <span class="a-LinksList-arrow" aria-hidden="true"></span>',
'  </a>',
'  #SUB_LISTS#',
'</li>'))
,p_reference_id=>60219508156141083
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_basic_list
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(1147196030581261316)
,p_list_template_current=>'<li class="a-List-item is-current"><a href="#LINK#" class="a-Links-link" #A02#>#TEXT#</a></li>'
,p_list_template_noncurrent=>'<li class="a-List-item"><a href="#LINK#" class="a-Links-link" #A02#>#TEXT#</a></li>'
,p_list_template_name=>'APEX 5.0 - Basic List'
,p_internal_name=>'APEX_5.0_BASIC_LIST'
,p_theme_id=>101
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="a-List #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>1141986383000090627
);
end;
/
prompt --application/shared_components/user_interface/templates/list/apex_5_0_basic_list_no_links
begin
wwv_flow_imp_shared.create_list_template(
 p_id=>wwv_flow_imp.id(1147196572106261322)
,p_list_template_current=>'<li class="a-List-item is-current">#TEXT#</li>'
,p_list_template_noncurrent=>'<li class="a-List-item">#TEXT#</li>'
,p_list_template_name=>'APEX 5.0 - Basic List (no links)'
,p_internal_name=>'APEX_5.0_BASIC_LIST_NO_LINKS'
,p_theme_id=>101
,p_theme_class_id=>1
,p_list_template_before_rows=>'<ul class="a-List a-List--basic #COMPONENT_CSS_CLASSES#" id="#LIST_ID#">'
,p_list_template_after_rows=>'</ul>'
,p_reference_id=>1141988805895106920
);
end;
/
prompt --application/shared_components/user_interface/templates/report/timeline
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(5473608411738262)
,p_row_template_name=>'Issue Timeline'
,p_internal_name=>'TIMELINE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<article class="a-TimelineEntry #ENTRY_MODIFIER_CLASSES#">',
'  <div class="a-TimelineEntry-wrap">',
'    <div class="a-TimelineEntry-header">',
'      <div class="a-TimelineEntry-headerItems a-TimelineEntry-headerItems--type">',
'        <span class="a-TimelineEntry-typeIcon #ENTRY_TYPE_ICON_MODIFIER#"><span class="#ENTRY_TYPE_ICON_CLASS#" aria-hidden="true"></span></span>',
'      </div>',
'      <div class="a-TimelineEntry-headerItems a-TimelineEntry-headerItems--info">',
'        <div class="a-TimelineEntry-infoAuthor">#ENTRY_AUTHOR#</div>',
'        <div class="a-TimelineEntry-infoStatus">#ENTRY_STATUS_TYPE#</div>',
'      </div>',
'      <div class="a-TimelineEntry-headerItems a-TimelineEntry-headerItems--actions">#ENTRY_ACTIONS#</div>',
'    </div>',
'    <div class="a-TimelineEntry-body">',
'        <div data-markdown="true" class="a-TimelineEntry-bodyContent" id="#ID#">#ENTRY_BODY#</div>',
'        <div class="a-TimelineEntry-more" id="MORE_#ID#">#MORE_DATA#</div>',
'    </div>',
'  </div>',
'</article>',
''))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-TimelineReport">',
'  <div class="a-Timeline">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'   </div>',
'</div>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_19_2_empty_report
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(6221345279028573)
,p_row_template_name=>'APEX 19.2 - Empty Report'
,p_internal_name=>'APEX_19.2_EMPTY_REPORT'
,p_row_template1=>'#DISPLAY_VALUE#'
,p_row_template_before_rows=>' '
,p_row_template_after_rows=>' '
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/content_row
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(6811165341870886)
,p_row_template_name=>'Content Row'
,p_internal_name=>'CONTENT_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ContentRowReport-item #ITEM_CSS_MODIFIERS#" #ITEM_CUSTOM_ATTRS#>',
'  <div class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemSelection">#ITEM_SELECTION#</div>',
'    <div class="a-ContentRowReport-itemIconWrap">',
'      <span class="a-ContentRowReport-itemIcon #ITEM_ICON#" aria-hidden="true"></span>',
'    </div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle"><a href="#ITEM_LINK#">#ITEM_TITLE#</a></h3>',
'        <div class="a-ContentRowReport-itemDescription">#ITEM_DESCRIPTION#</div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">#ITEM_MISC#</div>',
'      <div class="a-ContentRowReport-itemActions">#ITEM_ACTIONS#</div>',
'    </div>',
'  </div>',
'</div>',
''))
,p_row_template_condition1=>':ITEM_LINK is not null'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ContentRowReport-item #ITEM_CSS_MODIFIERS#" #ITEM_CUSTOM_ATTRS#>',
'  <div class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemSelection">#ITEM_SELECTION#</div>',
'    <div class="a-ContentRowReport-itemIconWrap">',
'      <span class="a-ContentRowReport-itemIcon #ITEM_ICON#" aria-hidden="true"></span>',
'    </div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle">#ITEM_TITLE#</h3>',
'        <div class="a-ContentRowReport-itemDescription">#ITEM_DESCRIPTION#</div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">#ITEM_MISC#</div>',
'      <div class="a-ContentRowReport-itemActions">#ITEM_ACTIONS#</div>',
'    </div>',
'  </div>',
'</div>',
''))
,p_row_template_condition2=>':ITEM_LINK is null'
,p_row_template_before_rows=>'<div class="a-ContentRowReport #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</div>',
'#PAGINATION#'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/content_row_link
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(10733983191535295)
,p_row_template_name=>'Content Row Link'
,p_internal_name=>'CONTENT_ROW_LINK'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ContentRowReport-item #ITEM_CSS_MODIFIERS#" #ITEM_CUSTOM_ATTRS#>',
'  <a class="a-ContentRowReport-itemWrap" href="#ITEM_LINK#">',
'    <div class="a-ContentRowReport-itemIconWrap">',
'      <span class="a-ContentRowReport-itemIcon #ITEM_ICON#" aria-hidden="true"></span>',
'    </div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle">#ITEM_TITLE#</h3>',
'        <div class="a-ContentRowReport-itemDescription">#ITEM_DESCRIPTION#</div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">#ITEM_MISC#</div>',
'      <div class="a-ContentRowReport-itemActions">#ITEM_ACTIONS#</div>',
'    </div>',
'  </a>',
'</div>',
''))
,p_row_template_condition1=>':ITEM_LINK is not null'
,p_row_template2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ContentRowReport-item #ITEM_CSS_MODIFIERS#" #ITEM_CUSTOM_ATTRS#>',
'  <div class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemIconWrap">',
'      <span class="a-ContentRowReport-itemIcon #ITEM_ICON#" aria-hidden="true"></span>',
'    </div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle">#ITEM_TITLE#</h3>',
'        <div class="a-ContentRowReport-itemDescription">#ITEM_DESCRIPTION#</div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">#ITEM_MISC#</div>',
'      <div class="a-ContentRowReport-itemActions">#ITEM_ACTIONS#</div>',
'    </div>',
'  </div>',
'</div>',
''))
,p_row_template_condition2=>':ITEM_LINK is null'
,p_row_template_before_rows=>'<div class="a-ContentRowReport #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</div>',
'#PAGINATION#'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>101
,p_theme_class_id=>4
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_links_list
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(16872467321495251)
,p_row_template_name=>'APEX 5.0 - Links List'
,p_internal_name=>'APEX_5.0_LINKS_LIST'
,p_row_template1=>'<li class="a-LinksList-item">#COLUMN_VALUE#</li>'
,p_row_template_before_rows=>'<ul class="a-LinksList a-LinksList--report #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES#>'
,p_row_template_after_rows=>'</ul>'
,p_row_template_before_first=>'OMIT'
,p_row_template_after_last=>'OMIT'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'OMIT'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>101
,p_theme_class_id=>0
,p_default_template_options=>'a-LinksList--nowrap:a-LinksList--showArrow'
,p_reference_id=>17383712077884846
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/result
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(38839184397267347)
,p_row_template_name=>'Result'
,p_internal_name=>'RESULT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr><td align="left" class="header" style="width:70px;">#COLUMN_HEADER#</th><td#ALIGNMENT#>#COLUMN_VALUE#</td></tr>',
''))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<style>',
'table.htmldbStandard3 td.header { vertical-align:middle; }',
'table.htmldbStandard3 td.pagination { border: medium none; }',
'</style>',
'<table width="100%" cellpadding="0" cellspacing="0" class="htmldbStandard3" role="presentation" datatable=0 summary="">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>',
''))
,p_row_template_after_last=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>',
'<p/>',
'<table width="100%" cellpadding="0" cellspacing="0" class="htmldbStandard3" role="presentation" datatable=0 summary="">',
'<tbody>'))
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>101
,p_theme_class_id=>6
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_2_portlet_row_template
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(52346073432218689)
,p_row_template_name=>'APEX 4.2 - Portlet Row Template'
,p_internal_name=>'APEX_4.2_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>46763700145123930
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_4_2_portlet_column_template
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(53143976115374711)
,p_row_template_name=>'APEX 4.2 - Portlet Column Template'
,p_internal_name=>'APEX_4.2_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>0
,p_reference_id=>43020300221196425
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/vertical_standard
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(87320675886385724)
,p_row_template_name=>'Vertical Standard'
,p_internal_name=>'VERTICAL_STANDARD'
,p_row_template1=>'<tr><td scope="row" class="label">#COLUMN_HEADER#</td><td class="data">#COLUMN_VALUE#</td></tr>'
,p_row_template_before_rows=>'#CSV_LINK#<table class="htmldbVerticalRegion2"  summary="#REGION_TITLE#" cellpadding="0" cellspacing="0" border="0">'
,p_row_template_after_rows=>'</table>'
,p_row_template_before_first=>' '
,p_row_template_after_last=>'<tr><td class="blank"><br /></td><td class="blank"><br /></td></tr>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'NOT_CONDITIONAL'
,p_row_template_display_cond2=>'NOT_CONDITIONAL'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'NOT_CONDITIONAL'
,p_theme_id=>101
,p_theme_class_id=>0
,p_reference_id=>81978430803840109
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_vertical_report
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(87612589317776005)
,p_row_template_name=>'APEX 5.0 - Vertical Report'
,p_internal_name=>'APEX_5.0_VERTICAL_REPORT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr>',
'  <td class="a-Report-cell a-Report-cell--header" scope="row">#COLUMN_HEADER#</td>',
'  <td class="a-Report-cell">#COLUMN_VALUE#</td>',
'</tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report a-Report--vertical a-Report--staticRowColors #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_before_first=>' '
,p_row_template_after_last=>' '
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>1126924627125205941
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/standard_mru_ajax_sortable
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(118284487222034553)
,p_row_template_name=>'Standard (MRU AJAX SORTABLE)'
,p_internal_name=>'STANDARD_MRU_AJAX_SORTABLE'
,p_row_template1=>'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" class="u-Report"  border="0" summary="#REGION_TITLE#" id="report_#REGION_ID#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'<tfoot>#PAGINATION#</tfoot>',
'</table>',
'<script type="text/javascript">',
'var g_rpreview_global = ''report_#REGION_ID#'';',
'var g_#REGION_ID#;',
'function f_#REGION_ID#(){',
'		g_#REGION_ID# =  new apex.tabular.sort(''report_#REGION_ID#'');',
'		g_#REGION_ID#.row.after_move = function(){rpreview()}',
'}',
'addLoadEvent(f_#REGION_ID#)',
'</script>'))
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#TEXT#',
''))
,p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-left:5px;"><img src="#IMAGE_PREFIX#jtfunexe.gif" alt="" /></a>'
,p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')" style="margin-right:5px;"><img src="#IMAGE_PREFIX#jtfupree.gif" alt=""/></a>'
,p_row_style_mouse_over=>'#CCCCCC'
,p_row_style_checked=>'#CCCCCC'
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>113076128479881902
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_standard_report
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(128932681614424007)
,p_row_template_name=>'APEX 5.0 - Standard Report'
,p_internal_name=>'APEX_5.0_STANDARD_REPORT'
,p_row_template1=>'<td class="a-Report-cell" #ALIGNMENT# headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Report #COMPONENT_CSS_CLASSES#" id="report_#REGION_STATIC_ID#" #REPORT_ATTRIBUTES#>',
'  <div class="a-Report-wrap">',
'    <table class="a-Report-pagination" role="presentation">#TOP_PAGINATION#</table>',
'    <div class="a-Report-tableWrap">',
'    <table class="a-Report-report" aria-label="#REGION_TITLE#">'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'      </tbody>',
'    </table>',
'    </div>',
'    <div class="a-Report-links">#EXTERNAL_LINK##CSV_LINK#</div>',
'    <table class="a-Report-pagination a-Report-pagination a-Report-pagination--bottom" role="presentation">#PAGINATION#</table>',
'  </div>',
'</div>'))
,p_row_template_before_first=>'<tr>'
,p_row_template_after_last=>'</tr>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_before_column_heading=>'<thead>'
,p_column_heading_template=>'<th class="a-Report-colHead" #ALIGNMENT# id="#COLUMN_HEADER_NAME#" #COLUMN_WIDTH#>#COLUMN_HEADER#</th>'
,p_after_column_heading=>'</thead><tbody>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_pagination_template=>'<span class="a-Report-paginationText">#TEXT#</span>'
,p_next_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_page_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS#',
'</a>'))
,p_next_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  #PAGINATION_NEXT_SET#<span class="a-Icon icon-right-arrow"></span>',
'</a>'))
,p_previous_set_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<a href="#LINK#" class="a-Report-paginationLink">',
'  <span class="a-Icon icon-left-arrow"></span>#PAGINATION_PREVIOUS_SET#',
'</a>'))
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>123725814882271159
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/no_background
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(254449264728006664)
,p_row_template_name=>'No Background'
,p_internal_name=>'NO_BACKGROUND'
,p_row_template1=>'<td#ALIGNMENT# id="td#ROWNUM#_#COLNUM#" headers="#COLUMN_HEADER_NAME#">#COLUMN_VALUE#</td>'
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellspacing="0" cellpadding="0" class="htmldbRptNoBackground" summary="#REGION_TITLE#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_before_first=>'<tr id="row#ROWNUM#">'
,p_row_template_after_last=>'</tr>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>237868603542157245
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/p890_ad_matching_items
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(259328758800535285)
,p_row_template_name=>'P890_AD_MATCHING_ITEMS'
,p_internal_name=>'P890_AD_MATCHING_ITEMS'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr><td>#CHK#</td><td>#REGION_NAME#</td><td>#I_NAME#</td><td>#I_LABEL#</td><td>#I_HELP_TEXT#</td><td>#I_FORMAT_MASK#</td><td>#I_FORMAT_MASK2#</td><td>#I_DEFAULT#</td><td>#I_WIDTH#</td><td>#I_HEIGHT#</td><td>#I_DATA_TYPE#</td></tr>',
'<tr><td>&nbsp;</td><td>#FROM_AD#</td><td>#C_COLUMN_NAME#</td><td>#C_LABEL#</td><td>#C_HELP_TEXT#</td><td>#C_FORMAT_MASK#</td><td>#C_FORM_FORMAT_MASK#</td><td>#C_DEFAULT_VALUE#</td><td>#C_FORM_DISPLAY_WIDTH#</td><td>#C_FORM_DISPLAY_HEIGHT#</td><td>#C_'
||'FORM_DATA_TYPE#</td></tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/p897_ad_matching_rc
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(262221362311141944)
,p_row_template_name=>'P897_AD_MATCHING_RC'
,p_internal_name=>'P897_AD_MATCHING_RC'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr><td>#CHK#</td><td>#REGION_NAME#</td><td>#RC_NAME#</td><td>#RC_LABEL#</td><td>#RC_HELP_TEXT#</td><td>#RC_FORMAT_MASK#</td><td>#RC_FORMAT_MASK2#</td><td>#RC_REPORT_COL_ALIGN#</td></tr>',
'<tr><td>&nbsp;</td><td>#FROM_AD#</td><td>&nbsp;</td><td>#C_LABEL#</td><td>#C_HELP_TEXT#</td><td>#C_FORMAT_MASK#</td><td>#C_REPORT_FORMAT_MASK#</td><td>#C_REPORT_COL_ALIGN#</td></tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/p921_ad_matching_items
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(451299075390647561)
,p_row_template_name=>'P921_AD_MATCHING_ITEMS'
,p_internal_name=>'P921_AD_MATCHING_ITEMS'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr><td>#CHK#</td><td>#REGION_NAME#</td><td>#I_NAME#</td><td>#I_LABEL#</td><td>#I_HELP_TEXT#</td><td>#I_FORMAT_MASK#</td><td>#I_DEFAULT#</td><td>#I_WIDTH#</td><td>#I_HEIGHT#</td><td>#I_DATA_TYPE#</td></tr>',
'<tr><td>&nbsp;</td><td>#FROM_AD#</td><td>#C_COLUMN_NAME#</td><td>#C_LABEL#</td><td>#C_HELP_TEXT#</td><td>#C_FORMAT_MASK#</td><td>#C_DEFAULT_VALUE#</td><td>#C_FORM_DISPLAY_WIDTH#</td><td>#C_FORM_DISPLAY_HEIGHT#</td><td>#C_FORM_DATA_TYPE#</td></tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/p922_ad_matching_rc
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(451456269530572938)
,p_row_template_name=>'P922_AD_MATCHING_RC'
,p_internal_name=>'P922_AD_MATCHING_RC'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<tr><td>#CHK#</td><td>#REGION_NAME#</td><td>#RC_NAME#</td><td>#RC_LABEL#</td><td>#RC_HELP_TEXT#</td><td>#RC_FORMAT_MASK#</td><td>#RC_REPORT_COL_ALIGN#</td></tr>',
'<tr><td>&nbsp;</td><td>#FROM_AD#</td><td>&nbsp;</td><td>#C_LABEL#</td><td>#C_HELP_TEXT#</td><td>#C_FORMAT_MASK#</td><td>#C_REPORT_COL_ALIGN#</td></tr>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table cellpadding="0" cellspacing="0" class="htmldbStandard3"  border="0" summary="" id="#REGION_ID#">',
'<tbody>'))
,p_row_template_after_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</tbody>',
'</table>'))
,p_row_template_type=>'NAMED_COLUMNS'
,p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>2
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_app_cards_report
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(1046844478120553869)
,p_row_template_name=>'APEX 5.0 - App Cards Report'
,p_internal_name=>'APEX_5.0_APP_CARDS_REPORT'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AppCards-item #ID#">',
'  <div class="a-AppCards-itemContainer">',
'    <div class="a-AppCards-iconContainer">',
'      <span class="a-AppCards-icon #ICON_CLASS#"></span>',
'    </div>',
'    <div class="a-AppCards-contentContainer" id="#ID#_name">',
'      <h2 class="a-AppCards-name">#APP_NAME#</h2>',
'      <div class="a-AppCards-info">#APP_INFO#</div>',
'    </div>',
'    <div class="a-AppCards-actionsContainer">',
'        #MODIFY_APP_BUTTON#',
'        #RUN_APP_BUTTON#',
'    </div>',
'  </div>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AppCards a-AppCards--slim  a-AppCards--stacked">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>932268343459577530
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_named_column
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(1046845011939553934)
,p_row_template_name=>'APEX 5.0 - Badge List (Named Column)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_NAMED_COLUMN'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-BadgeList-item #A01#">',
'  <span class="a-BadgeList-label">#COLUMN_HEADER#</span>',
'  <span class="a-BadgeList-value">#COLUMN_VALUE#</span>',
'</li>',
''))
,p_row_template_before_rows=>'<ul class="a-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>0
,p_preset_template_options=>'a-BadgeList--fixed:a-BadgeList--large'
,p_reference_id=>488487951233692049
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_badge_list_row
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(1046849559229553949)
,p_row_template_name=>'APEX 5.0 - Badge List (Row)'
,p_internal_name=>'APEX_5.0_BADGE_LIST_ROW'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="t-BadgeList-item">',
'  <span class="t-BadgeList-label">#1#</span>',
'  <span class="t-BadgeList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="t-BadgeList #COMPONENT_CSS_CLASSES#">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>6
,p_reference_id=>689060248369886348
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_column_template
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(1046850417023553952)
,p_row_template_name=>'APEX 5.0 - Portlet Column Template'
,p_internal_name=>'APEX_5.0_PORTLET_COLUMN_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#COLUMN_HEADER#</span>',
'  <span class="a-AVPList-value">#COLUMN_VALUE#</span>',
'</li>'))
,p_row_template_before_rows=>'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">'
,p_row_template_after_rows=>'</ul>'
,p_row_template_table_attr=>'OMIT'
,p_row_template_type=>'GENERIC_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'NOT_CONDITIONAL'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>0
,p_reference_id=>43020300221196425
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/report/apex_5_0_portlet_row_template
begin
wwv_flow_imp_shared.create_row_template(
 p_id=>wwv_flow_imp.id(1046851149224553954)
,p_row_template_name=>'APEX 5.0 - Portlet Row Template'
,p_internal_name=>'APEX_5.0_PORTLET_ROW_TEMPLATE'
,p_row_template1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-AVPList-item">',
'  <span class="a-AVPList-label">#1#</span>',
'  <span class="a-AVPList-value">#2#</span>',
'</li>'))
,p_row_template_before_rows=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<ul class="a-AVPList #COMPONENT_CSS_CLASSES#" #REPORT_ATTRIBUTES# id="#REGION_ID#_report">',
''))
,p_row_template_after_rows=>'</ul>'
,p_row_template_type=>'NAMED_COLUMNS'
,p_row_template_display_cond1=>'0'
,p_row_template_display_cond2=>'0'
,p_row_template_display_cond3=>'0'
,p_row_template_display_cond4=>'0'
,p_theme_id=>101
,p_theme_class_id=>7
,p_reference_id=>46763700145123930
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/hidden_label_read_by_screen_reader
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(10128482508892221)
,p_template_name=>'Hidden label, read by screen reader'
,p_internal_name=>'HIDDEN_LABEL,_READ_BY_SCREEN_READER'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" tabindex="999" class="hideMeButHearMe">'
,p_template_body2=>'</label>'
,p_on_error_after_label=>'<br/>#ERROR_MESSAGE#'
,p_theme_id=>101
,p_theme_class_id=>13
,p_reference_id=>4903009179971452
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional_no_labelonly_for_radiogroup
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(48271887820999885)
,p_template_name=>'FormField_Optional (no label-only for radiogroup)'
,p_internal_name=>'FORMFIELD_OPTIONAL_NO_LABELONLY_FOR_RADIOGROUP'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aOptional"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>101
,p_theme_class_id=>0
,p_reference_id=>43065615312847035
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_4_0_top_bar_label
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(62936183445003887)
,p_template_name=>'APEX 4.0 - Top Bar Label'
,p_internal_name=>'APEX_4.0_TOP_BAR_LABEL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#"><a class="apex-ga-label" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_theme_id=>101
,p_theme_class_id=>0
,p_reference_id=>57728329098847875
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/formfield_optional
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(98577379800732474)
,p_template_name=>'FormField_Optional'
,p_internal_name=>'FORMFIELD_OPTIONAL'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aOptional"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>17388415351892041
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/columnheader
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(99502069539557325)
,p_template_name=>'ColumnHeader'
,p_internal_name=>'COLUMNHEADER'
,p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="aLabel aOptional"><a href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
,p_template_body2=>'</a></label>'
,p_on_error_after_label=>'<small class="aError">#ERROR_MESSAGE#</small>'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>17388415351892041
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(457861279924367968)
,p_template_name=>'APEX 5.0 - Required Label'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_reference_id=>487443659585685414
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(566752393121369432)
,p_template_name=>'APEX 5.0 - Optional Label'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_reference_id=>487444299516703815
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_optional_label_above
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(566754195708398878)
,p_template_name=>'APEX 5.0 - Optional Label (Above)'
,p_internal_name=>'APEX_5.0_OPTIONAL_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_on_error_after_label=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_reference_id=>492676964457041934
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_required_label_above
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(566754273980399706)
,p_template_name=>'APEX 5.0 - Required Label (Above)'
,p_internal_name=>'APEX_5.0_REQUIRED_LABEL_ABOVE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>#HELP_TEMPLATE#',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer a-Form-fieldContainer--stacked #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_reference_id=>492677038682043223
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_hidden_label
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(571215478963548485)
,p_template_name=>'APEX 5.0 - Hidden Label'
,p_internal_name=>'APEX_5.0_HIDDEN_LABEL'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer a-Form-labelContainer--visuallyhidden">',
'<label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label visuallyhidden">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'#HELP_TEMPLATE##ERROR_TEMPLATE#</div>'
,p_help_link=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-itemHelp" data-itemhelp="#CURRENT_ITEM_ID#" title="#CURRENT_ITEM_HELP_LABEL#"  aria-label="#CURRENT_ITEM_HELP_LABEL#" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidde'
||'n="true"></span></button>'
,p_theme_id=>101
,p_theme_class_id=>4
,p_reference_id=>687907221148719616
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/label/apex_5_0_dynamic_attribute
begin
wwv_flow_imp_shared.create_field_template(
 p_id=>wwv_flow_imp.id(571257652710828592)
,p_template_name=>'APEX 5.0 - Dynamic Attribute'
,p_internal_name=>'APEX_5.0_DYNAMIC_ATTRIBUTE'
,p_template_body1=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Form-labelContainer">',
'  <span class="a-Form-required"><span class="a-Icon icon-asterisk"></span></span><label for="#CURRENT_ITEM_NAME#" id="#LABEL_ID#" class="a-Form-label">'))
,p_template_body2=>wwv_flow_string.join(wwv_flow_t_varchar2(
' <span class="u-VisuallyHidden">(#VALUE_REQUIRED#)</span></label>',
'</div>'))
,p_before_item=>'<div class="a-Form-fieldContainer #ITEM_CSS_CLASSES#" id="#CURRENT_ITEM_CONTAINER_ID#">'
,p_after_item=>'</div>'
,p_before_element=>'<div class="a-Form-inputContainer">'
,p_after_element=>'<button class="a-Button a-Button--noUI a-Button--helpButton js-dynamicItemHelp" data-itemname="#CURRENT_ITEM_NAME#" data-appid="&FB_FLOW_ID." title="" aria-label="" tabindex="-1" type="button"><span class="a-Icon icon-help" aria-hidden="true"></span>'
||'</button>#ERROR_TEMPLATE#</div>'
,p_error_template=>'<span class="a-Form-error">#ERROR_MESSAGE#</span>'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>692681574974429799
,p_translate_this_template=>'N'
,p_template_comment=>'<label for="#CURRENT_ITEM_NAME#"><a class="htmldbLabelOptional" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'',''&CLOSE.'')" tabindex="999">'
);
end;
/
prompt --application/shared_components/user_interface/templates/breadcrumb/apex_5_0_breadcrumbs
begin
wwv_flow_imp_shared.create_menu_template(
 p_id=>wwv_flow_imp.id(5208262300686444)
,p_name=>'APEX 5.0 - Breadcrumbs'
,p_internal_name=>'APEX_5.0_BREADCRUMBS'
,p_before_first=>'<ul class="a-Breadcrumb">'
,p_current_page_option=>'<li class="a-Breadcrumb-item a-Breadcrumb-item is-active" aria-current="page"><span class="a-Breadcrumb-label">#NAME#</span></li>'
,p_non_current_page_option=>'<li class="a-Breadcrumb-item"><a href="#LINK#" class="a-Breadcrumb-label">#NAME#</a></li>'
,p_after_last=>'</ul>'
,p_max_levels=>6
,p_start_with_node=>'PARENT_TO_LEAF'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>689285808648404711
,p_translate_this_template=>'N'
);
end;
/
prompt --application/shared_components/user_interface/templates/popuplov
begin
wwv_flow_imp_shared.create_popup_lov_template(
 p_id=>wwv_flow_imp.id(15421877085757803)
,p_page_name=>'winlov'
,p_page_title=>'Search Dialog'
,p_page_html_head=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE html>',
'<html lang="&BROWSER_LANGUAGE.">',
'<head>',
'<title>#TITLE#</title>',
'#APEX_CSS#',
'#THEME_CSS#',
'#APEX_JAVASCRIPT#',
'<meta name="viewport" content="width=device-width,initial-scale=1.0" />',
'<link rel="shortcut icon" href="#IMAGE_PREFIX#favicon.ico" type="image/x-icon">',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'<link rel="stylesheet" href="#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css?v=#APEX_VERSION#" type="text/css"/>',
'</head>'))
,p_page_body_attr=>'onload="first_field()" class="a-Page a-Page--popupLOV"'
,p_before_field_text=>'<div class="a-PopupLOV-actions a-Form--large">'
,p_filter_width=>'15'
,p_filter_max_width=>'100'
,p_filter_text_attr=>'class="a-Form-field a-Form-searchField"'
,p_find_button_text=>'Search'
,p_find_button_attr=>'class="a-Button a-Button--hot a-Button--padLeft"'
,p_close_button_text=>'Close'
,p_close_button_attr=>'class="a-Button u-pullRight"'
,p_next_button_text=>'Next &gt;'
,p_next_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_prev_button_text=>'&lt; Previous'
,p_prev_button_attr=>'class="a-Button a-PopupLOV-button"'
,p_after_field_text=>'</div>'
,p_scrollbars=>'1'
,p_resizable=>'1'
,p_width=>'380'
,p_height=>'480'
,p_result_row_x_of_y=>'<div class="a-PopupLOV-pagination">Row(s) #FIRST_ROW# - #LAST_ROW#</div>'
,p_result_rows_per_pg=>200
,p_before_result_set=>'<div class="a-PopupLOV-links">'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>17343114994581872
,p_translate_this_template=>'N'
,p_after_result_set=>'</div>'
);
end;
/
prompt --application/shared_components/user_interface/templates/calendar/default_calander
begin
wwv_flow_imp_shared.create_calendar_template(
 p_id=>wwv_flow_imp.id(53950578804123182)
,p_cal_template_name=>'Default Calander'
,p_internal_name=>'DEFAULT_CALANDER'
,p_day_of_week_format=>'<th scope="col" width="14%" class="htmldbDayOfWeek">#IDAY#</th>'
,p_month_title_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<table class="htmldbCalendarHolder" cellpadding="0" cellspacing="0" border="0" width="100%" summary="" role="presentation"><tr>',
'<td class="htmldbMonthTitle">#IMONTH# #YYYY#</td>',
'</tr>',
'<tr><td>'))
,p_month_open_format=>'<table class="htmldbCalendar" cellpadding="0" cellspacing="3" border="0" width="100%" summary="#CALENDAR_TITLE# #IMONTH# #YYYY#">'
,p_month_close_format=>wwv_flow_string.join(wwv_flow_t_varchar2(
'</table></td></tr></table>',
'',
''))
,p_day_title_format=>'<div class="htmldbDayTitle">#DD#</div>'
,p_day_open_format=>'<td class="htmldbDay">#TITLE_FORMAT##DATA#'
,p_day_close_format=>'</td>'
,p_today_open_format=>'<td class="htmldbToday">#TITLE_FORMAT##DATA#'
,p_weekend_title_format=>'<div class="htmldbWeekendDayTitle">#DD#</div>'
,p_weekend_open_format=>'<td class="htmldbWeekendDay">#TITLE_FORMAT##DATA#'
,p_weekend_close_format=>'</td>'
,p_nonday_title_format=>'<div class="htmldbNonDayTitle">#DD#</div>'
,p_nonday_open_format=>'<td class="htmldbNonDay">'
,p_nonday_close_format=>'</td>'
,p_week_open_format=>'<tr>'
,p_week_close_format=>'</tr>'
,p_daily_title_format=>'<th width="14%" class="calheader">#IDAY#</th>'
,p_daily_open_format=>'<tr>'
,p_daily_close_format=>'</tr>'
,p_month_data_format=>'#DAYS#'
,p_month_data_entry_format=>'#DATA#'
,p_theme_id=>101
,p_theme_class_id=>1
,p_reference_id=>353925314576528967
);
end;
/
prompt --application/shared_components/user_interface/themes
begin
wwv_flow_imp_shared.create_theme(
 p_id=>wwv_flow_imp.id(64301075378604300)
,p_theme_id=>101
,p_theme_name=>'APEX 5.0'
,p_theme_internal_name=>'APEX_5.0'
,p_ui_type_name=>'DESKTOP'
,p_navigation_type=>'T'
,p_nav_bar_type=>'NAVBAR'
,p_is_locked=>false
,p_default_page_template=>wwv_flow_imp.id(391881764116992437)
,p_default_dialog_template=>wwv_flow_imp.id(694269863376113197)
,p_error_template=>wwv_flow_imp.id(707892828837195217)
,p_printer_friendly_template=>wwv_flow_imp.id(391881764116992437)
,p_default_button_template=>wwv_flow_imp.id(188432383783551716)
,p_default_region_template=>wwv_flow_imp.id(179998957300224011)
,p_default_chart_template=>wwv_flow_imp.id(179998957300224011)
,p_default_form_template=>wwv_flow_imp.id(179998957300224011)
,p_default_reportr_template=>wwv_flow_imp.id(179998957300224011)
,p_default_tabform_template=>wwv_flow_imp.id(179998957300224011)
,p_default_wizard_template=>wwv_flow_imp.id(47229974494774989)
,p_default_menur_template=>wwv_flow_imp.id(214132567690623104)
,p_default_listr_template=>wwv_flow_imp.id(179998957300224011)
,p_default_irr_template=>wwv_flow_imp.id(651492083233530570)
,p_default_report_template=>wwv_flow_imp.id(128932681614424007)
,p_default_label_template=>wwv_flow_imp.id(566752393121369432)
,p_default_menu_template=>wwv_flow_imp.id(5208262300686444)
,p_default_calendar_template=>wwv_flow_imp.id(53950578804123182)
,p_default_list_template=>wwv_flow_imp.id(702419290542782266)
,p_default_nav_list_template=>wwv_flow_imp.id(389919542813170530)
,p_default_top_nav_list_temp=>wwv_flow_imp.id(389919542813170530)
,p_default_nav_list_position=>'TOP'
,p_default_page_transition=>'NONE'
,p_default_popup_transition=>'NONE'
,p_theme_description=>'Oracle APEX 5.0 Internal Theme'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_theme_file_prefix(101),'')
,p_files_version=>2
,p_icon_library=>'FONTAPEX_LATEST'
,p_css_file_urls=>'#IMAGE_PREFIX#libraries/oracle-fonts/oraclesans-apex#MIN#.css?v=#APEX_VERSION#'
);
end;
/
prompt --application/shared_components/user_interface/theme_style
begin
wwv_flow_imp_shared.create_theme_style(
 p_id=>wwv_flow_imp.id(77533347140630629)
,p_theme_id=>101
,p_name=>'DARK'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_current=>true
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_imp_shared.create_theme_style(
 p_id=>wwv_flow_imp.id(209225663324524664)
,p_theme_id=>101
,p_name=>'STANDARD'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_current=>false
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_imp_shared.create_theme_style(
 p_id=>wwv_flow_imp.id(556401045591113938)
,p_theme_id=>101
,p_name=>'DARK_AUTO'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Dark#MIN#.css'))
,p_is_current=>false
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
wwv_flow_imp_shared.create_theme_style(
 p_id=>wwv_flow_imp.id(556401349222114691)
,p_theme_id=>101
,p_name=>'STANDARD_AUTO'
,p_css_file_urls=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#IMAGE_PREFIX#apex_ui/css/Core#MIN#.css',
'#IMAGE_PREFIX#apex_ui/css/Theme-Standard#MIN#.css'))
,p_is_current=>false
,p_is_public=>false
,p_is_accessible=>false
,p_theme_roller_read_only=>false
);
end;
/
prompt --application/shared_components/user_interface/theme_files
begin
null;
end;
/
prompt --application/shared_components/user_interface/template_opt_groups
begin
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(10813894202794535)
,p_theme_id=>101
,p_name=>'DIALOG_SIZE'
,p_display_name=>'Dialog Size'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Predefined dialog sizes'
,p_null_text=>'Default Size'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(694480036806463139)
,p_theme_id=>101
,p_name=>'REGION_STYLE'
,p_display_name=>'Region Style'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Style'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(694481016688463140)
,p_theme_id=>101
,p_name=>'REGION_PADDING'
,p_display_name=>'Region Padding'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Padding'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(694814532471133994)
,p_theme_id=>101
,p_name=>'REGION_POSITION'
,p_display_name=>'Region Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(694816751912133995)
,p_theme_id=>101
,p_name=>'REGION_OVERFLOW'
,p_display_name=>'Region Overflow'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695072740319798635)
,p_theme_id=>101
,p_name=>'BUTTON_SET'
,p_display_name=>'Button Set'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Not Part of Button Set'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695072854793798635)
,p_theme_id=>101
,p_name=>'BUTTON_SIZE'
,p_display_name=>'Button Size'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Button Size'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695072938306798635)
,p_theme_id=>101
,p_name=>'BUTTON_TYPE'
,p_display_name=>'Button Type'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695072973969798636)
,p_theme_id=>101
,p_name=>'ICON_POSITION'
,p_display_name=>'Icon Position'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Icon on Right'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695073116328798636)
,p_theme_id=>101
,p_name=>'SPACING_LEFT'
,p_display_name=>'Spacing left'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Left Spacing'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695073211513798636)
,p_theme_id=>101
,p_name=>'SPACING_RIGHT'
,p_display_name=>'Spacing Right'
,p_display_sequence=>1
,p_template_types=>'BUTTON'
,p_null_text=>'Default Right Spacing'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695073322476798637)
,p_theme_id=>101
,p_name=>'HEIGHT'
,p_display_name=>'Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Behavior'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695073374573798637)
,p_theme_id=>101
,p_name=>'MAX_HEIGHT'
,p_display_name=>'Max Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'No Max Height'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695073477662798637)
,p_theme_id=>101
,p_name=>'MIN_HEIGHT'
,p_display_name=>'Min Height'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'No Min Height'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695073609547798637)
,p_theme_id=>101
,p_name=>'ALTERNATING_TABLE_ROWS'
,p_display_name=>'Alternating Table Rows'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Enable'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695073701037798637)
,p_theme_id=>101
,p_name=>'BADGE_LAYOUT'
,p_display_name=>'Badge Layout'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695073825395798637)
,p_theme_id=>101
,p_name=>'BADGE_SIZE'
,p_display_name=>'Badge Size'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695073892169798638)
,p_theme_id=>101
,p_name=>'REPORT_BORDER'
,p_display_name=>'Report Border'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default Border'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695073978083798638)
,p_theme_id=>101
,p_name=>'REPORT_WIDTH'
,p_display_name=>'Report Width'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695074115159798638)
,p_theme_id=>101
,p_name=>'ROW_HIGHLIGHTING'
,p_display_name=>'Row Highlighting'
,p_display_sequence=>1
,p_template_types=>'REPORT'
,p_null_text=>'Disable'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(695179142948319388)
,p_theme_id=>101
,p_name=>'DISPLAY'
,p_display_name=>'Display'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(698627343191487614)
,p_theme_id=>101
,p_name=>'LAYOUT'
,p_display_name=>'Layout'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(701826319113292817)
,p_theme_id=>101
,p_name=>'REGION_TITLE'
,p_display_name=>'Region Title'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(702432470636856200)
,p_theme_id=>101
,p_name=>'DISPLAY_ICONS'
,p_display_name=>'Display Icons'
,p_display_sequence=>1
,p_template_types=>'LIST'
,p_null_text=>'Default - No Icons'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746203959297757572)
,p_theme_id=>101
,p_name=>'FORM_LABEL_ALIGNMENT'
,p_display_name=>'Form Label Alignment'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_help_text=>'Set Form Alignment for Grid Based forms'
,p_null_text=>'Right'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746204290236757573)
,p_theme_id=>101
,p_name=>'FORM_LABEL_WIDTH'
,p_display_name=>'Form Label Width'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746205145910757573)
,p_theme_id=>101
,p_name=>'LABEL_WIDTH'
,p_display_name=>'Label Width'
,p_display_sequence=>1
,p_template_types=>'FIELD'
,p_null_text=>'Default'
,p_is_advanced=>'Y'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(746205382468757573)
,p_theme_id=>101
,p_name=>'FORM_LABEL_POSITION'
,p_display_name=>'Form Label Position'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_null_text=>'Default Position'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_opt_group(
 p_id=>wwv_flow_imp.id(775445499790054719)
,p_theme_id=>101
,p_name=>'ALERT_TYPE'
,p_display_name=>'Alert Type'
,p_display_sequence=>1
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
prompt --application/shared_components/user_interface/template_options
begin
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(6856778639622928)
,p_theme_id=>101
,p_name=>'HIDE_ICON_COLUMN'
,p_display_name=>'Hide Icon Column'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(6811165341870886)
,p_css_classes=>'a-ContentRowReport--hideIcons'
,p_template_types=>'REPORT'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(10734369185535315)
,p_theme_id=>101
,p_name=>'HIDE_ICON_COLUMN'
,p_display_name=>'Hide Icon Column'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(10733983191535295)
,p_css_classes=>'a-ContentRowReport--hideIcons'
,p_template_types=>'REPORT'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(10814278502794541)
,p_theme_id=>101
,p_name=>'SMALL_480X320'
,p_display_name=>'Small (480x320)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(10813455696794486)
,p_css_classes=>'js-dialog-size480x320'
,p_group_id=>wwv_flow_imp.id(10813894202794535)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(10814615790794547)
,p_theme_id=>101
,p_name=>'MEDIUM_600X400'
,p_display_name=>'Medium (600x400)'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_imp.id(10813455696794486)
,p_css_classes=>'js-dialog-size600x400'
,p_group_id=>wwv_flow_imp.id(10813894202794535)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(10814914136794547)
,p_theme_id=>101
,p_name=>'LARGE_720X480'
,p_display_name=>'Large (720x480)'
,p_display_sequence=>3
,p_region_template_id=>wwv_flow_imp.id(10813455696794486)
,p_css_classes=>'js-dialog-size720x480'
,p_group_id=>wwv_flow_imp.id(10813894202794535)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(10815365068794547)
,p_theme_id=>101
,p_name=>'DRAGGABLE'
,p_display_name=>'Draggable'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(10813455696794486)
,p_css_classes=>'js-draggable'
,p_template_types=>'REGION'
,p_help_text=>'Allow dialog to be moved.'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(10815769268794548)
,p_theme_id=>101
,p_name=>'MODAL'
,p_display_name=>'Modal'
,p_display_sequence=>3
,p_region_template_id=>wwv_flow_imp.id(10813455696794486)
,p_css_classes=>'js-modal'
,p_template_types=>'REGION'
,p_help_text=>'Display as modal.'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(10816139144794548)
,p_theme_id=>101
,p_name=>'RESIZABLE'
,p_display_name=>'Resizable'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_imp.id(10813455696794486)
,p_css_classes=>'js-resizable'
,p_template_types=>'REGION'
,p_help_text=>'Allow dialog to be resized.'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(702412839760774923)
,p_theme_id=>101
,p_name=>'2COLUMNGRID'
,p_display_name=>'2 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(698626888016487602)
,p_css_classes=>'a-MediaList--cols a-MediaList--2cols'
,p_group_id=>wwv_flow_imp.id(698627343191487614)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(702413156612774923)
,p_theme_id=>101
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(698626888016487602)
,p_css_classes=>'a-MediaList--cols a-MediaList--3cols'
,p_group_id=>wwv_flow_imp.id(698627343191487614)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(702413398335774923)
,p_theme_id=>101
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(698626888016487602)
,p_css_classes=>'a-MediaList--cols a-MediaList--4cols'
,p_group_id=>wwv_flow_imp.id(698627343191487614)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(702413726246774923)
,p_theme_id=>101
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(698626888016487602)
,p_css_classes=>'a-MediaList--cols a-MediaList--5cols'
,p_group_id=>wwv_flow_imp.id(698627343191487614)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(702414008912774923)
,p_theme_id=>101
,p_name=>'SPANHORIZONTALLY'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(698626888016487602)
,p_css_classes=>'a-MediaList--horizontal'
,p_group_id=>wwv_flow_imp.id(698627343191487614)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(702414308619774923)
,p_theme_id=>101
,p_name=>'HIDEBADGE'
,p_display_name=>'Hide Badge'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(698626888016487602)
,p_css_classes=>'a-MediaList--noBadge'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(702414635053774923)
,p_theme_id=>101
,p_name=>'HIDEDESCRIPTION'
,p_display_name=>'Hide Description'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(698626888016487602)
,p_css_classes=>'a-MediaList--noDesc'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(702414893173774924)
,p_theme_id=>101
,p_name=>'HIDETITLE'
,p_display_name=>'Hide Title'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(698626888016487602)
,p_css_classes=>'a-MediaList--noTitle'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(702415177789774924)
,p_theme_id=>101
,p_name=>'HIDEICONS'
,p_display_name=>'Hide Icons'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(698626888016487602)
,p_css_classes=>'a-MediaList--noIcons'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(702415501189774924)
,p_theme_id=>101
,p_name=>'SLIMLIST'
,p_display_name=>'Slim List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(698626888016487602)
,p_css_classes=>'a-MediaList--slim'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746294211505150949)
,p_theme_id=>101
,p_name=>'180PX'
,p_display_name=>'180px'
,p_display_sequence=>10
,p_css_classes=>'h180'
,p_group_id=>wwv_flow_imp.id(695073322476798637)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746294431394150949)
,p_theme_id=>101
,p_name=>'240PX'
,p_display_name=>'240px'
,p_display_sequence=>20
,p_css_classes=>'h240'
,p_group_id=>wwv_flow_imp.id(695073322476798637)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746294653320150949)
,p_theme_id=>101
,p_name=>'320PX'
,p_display_name=>'320px'
,p_display_sequence=>30
,p_css_classes=>'h320'
,p_group_id=>wwv_flow_imp.id(695073322476798637)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746294821672150950)
,p_theme_id=>101
,p_name=>'480PX'
,p_display_name=>'480px'
,p_display_sequence=>50
,p_css_classes=>'h480'
,p_group_id=>wwv_flow_imp.id(695073322476798637)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746295005920150950)
,p_theme_id=>101
,p_name=>'540PX'
,p_display_name=>'540px'
,p_display_sequence=>60
,p_css_classes=>'h540'
,p_group_id=>wwv_flow_imp.id(695073322476798637)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746295251397150950)
,p_theme_id=>101
,p_name=>'640PX'
,p_display_name=>'640px'
,p_display_sequence=>70
,p_css_classes=>'h640'
,p_group_id=>wwv_flow_imp.id(695073322476798637)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746295422626150951)
,p_theme_id=>101
,p_name=>'ALIGNLABELSLEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Form--leftLabels'
,p_group_id=>wwv_flow_imp.id(746203959297757572)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746295558353150952)
,p_theme_id=>101
,p_name=>'AUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form--autoWidthLabels'
,p_group_id=>wwv_flow_imp.id(746204290236757573)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746295785471150952)
,p_theme_id=>101
,p_name=>'FIRSTBUTTON'
,p_display_name=>'First Button'
,p_display_sequence=>1
,p_css_classes=>'a-Button--pillStart'
,p_group_id=>wwv_flow_imp.id(695072740319798635)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746296007578150952)
,p_theme_id=>101
,p_name=>'FIXEDLARGE'
,p_display_name=>'Fixed (Large Width)'
,p_display_sequence=>30
,p_css_classes=>'a-Form-fixedLabelsLarge'
,p_group_id=>wwv_flow_imp.id(746204290236757573)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746296166286150952)
,p_theme_id=>101
,p_name=>'FIXEDMEDIUM'
,p_display_name=>'Fixed (Medium Width)'
,p_display_sequence=>20
,p_css_classes=>'a-Form-fixedLabelsMed'
,p_group_id=>wwv_flow_imp.id(746204290236757573)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746296386377150952)
,p_theme_id=>101
,p_name=>'FIXEDWIDTH'
,p_display_name=>'Fixed'
,p_display_sequence=>10
,p_css_classes=>'a-Form--fixedLabels'
,p_group_id=>wwv_flow_imp.id(746204290236757573)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746296616105150952)
,p_theme_id=>101
,p_name=>'INNERBUTTON'
,p_display_name=>'Inner Button'
,p_display_sequence=>2
,p_css_classes=>'a-Button--pill'
,p_group_id=>wwv_flow_imp.id(695072740319798635)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746296801146150952)
,p_theme_id=>101
,p_name=>'LABELAUTOWIDTH'
,p_display_name=>'Auto Width'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--autoLabelWidth'
,p_group_id=>wwv_flow_imp.id(746205145910757573)
,p_template_types=>'FIELD'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746297038245150952)
,p_theme_id=>101
,p_name=>'LABELSABOVE'
,p_display_name=>'Labels Above'
,p_display_sequence=>1
,p_css_classes=>'a-Form--labelsAbove'
,p_group_id=>wwv_flow_imp.id(746205382468757573)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746297193678150952)
,p_theme_id=>101
,p_name=>'LARGE'
,p_display_name=>'Large'
,p_display_sequence=>3
,p_css_classes=>'a-Button--large'
,p_group_id=>wwv_flow_imp.id(695072854793798635)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746297433497150952)
,p_theme_id=>101
,p_name=>'LARGELEFT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapLeft'
,p_group_id=>wwv_flow_imp.id(695073116328798636)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746297631516150952)
,p_theme_id=>101
,p_name=>'LARGERIGHT'
,p_display_name=>'Large'
,p_display_sequence=>1
,p_css_classes=>'a-Button--gapRight'
,p_group_id=>wwv_flow_imp.id(695073211513798636)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746297847783150953)
,p_theme_id=>101
,p_name=>'LASTBUTTON'
,p_display_name=>'Last Button'
,p_display_sequence=>3
,p_css_classes=>'a-Button--pillEnd'
,p_group_id=>wwv_flow_imp.id(695072740319798635)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746298002917150953)
,p_theme_id=>101
,p_name=>'LEFTICON'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_imp.id(695072973969798636)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746298200231150953)
,p_theme_id=>101
,p_name=>'PRIMARY'
,p_display_name=>'Primary'
,p_display_sequence=>1
,p_css_classes=>'a-Button--primary'
,p_group_id=>wwv_flow_imp.id(695072938306798635)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746298317010150953)
,p_theme_id=>101
,p_name=>'REGIONHEADERBUTTON'
,p_display_name=>'Button in Region Header'
,p_display_sequence=>1
,p_css_classes=>'a-Button--regionHeader'
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746298487581150953)
,p_theme_id=>101
,p_name=>'SMALL'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--small'
,p_group_id=>wwv_flow_imp.id(695072854793798635)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746298691596150953)
,p_theme_id=>101
,p_name=>'SMALLLEFT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padLeft'
,p_group_id=>wwv_flow_imp.id(695073116328798636)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746298922805150953)
,p_theme_id=>101
,p_name=>'SMALLRIGHT'
,p_display_name=>'Small'
,p_display_sequence=>1
,p_css_classes=>'a-Button--padRight'
,p_group_id=>wwv_flow_imp.id(695073211513798636)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746298962077150953)
,p_theme_id=>101
,p_name=>'STRETCHFORMFIELD'
,p_display_name=>'Stretch Form Field'
,p_display_sequence=>1
,p_css_classes=>'a-Form-fieldContainer--stretch'
,p_template_types=>'FIELD'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746299057511150953)
,p_theme_id=>101
,p_name=>'STRONGBUTTONLABEL'
,p_display_name=>'Strong Button Label'
,p_display_sequence=>1
,p_css_classes=>'a-Button--strongLabel'
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746310971087489751)
,p_theme_id=>101
,p_name=>'REGIONCONTAINSITEMSTEXT'
,p_display_name=>'Region Contains Items / Text'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(694479338908463138)
,p_css_classes=>'a-ButtonRegion--withItems'
,p_template_types=>'REGION'
,p_help_text=>'Check this option if this region contains items or text.'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746311250336489752)
,p_theme_id=>101
,p_name=>'REMOVEUIDECORATION'
,p_display_name=>'Remove UI Decoration'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(694479338908463138)
,p_css_classes=>'a-ButtonRegion--noUI'
,p_group_id=>wwv_flow_imp.id(694480036806463139)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746311396306489758)
,p_theme_id=>101
,p_name=>'REMOVEBORDERS'
,p_display_name=>'Remove Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(694479338908463138)
,p_css_classes=>'a-ButtonRegion--noBorder'
,p_group_id=>wwv_flow_imp.id(694480036806463139)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746311583261489758)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(694479338908463138)
,p_css_classes=>'a-ButtonRegion--slimPadding'
,p_group_id=>wwv_flow_imp.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746311760604489760)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(694479338908463138)
,p_css_classes=>'a-ButtonRegion--noPadding'
,p_group_id=>wwv_flow_imp.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746311863031489760)
,p_theme_id=>101
,p_name=>'WIZARDDIALOG'
,p_display_name=>'Used for Wizard Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(694479338908463138)
,p_css_classes=>'a-ButtonRegion--wizard'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746312117555489760)
,p_theme_id=>101
,p_name=>'VISIBLE'
,p_display_name=>'Visible'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(694479338908463138)
,p_css_classes=>'a-ButtonRegion--showTitle'
,p_group_id=>wwv_flow_imp.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(746312272166489760)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(694479338908463138)
,p_css_classes=>'a-ButtonRegion--accessibleTitle'
,p_group_id=>wwv_flow_imp.id(701826319113292817)
,p_template_types=>'REGION'
,p_help_text=>'Use this option to add a visually hidden heading which is accessible for screen readers, but otherwise not visible to users.'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(775446710125054764)
,p_theme_id=>101
,p_name=>'USE_COLORED_BACKGROUND'
,p_display_name=>'Use Colored Background'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(775445099592054705)
,p_css_classes=>'a-Alert--colorBG'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(775446774761054764)
,p_theme_id=>101
,p_name=>'USE_DEFAULT_ICONS'
,p_display_name=>'Use Default Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(775445099592054705)
,p_css_classes=>'a-Alert--defaultIcons'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(775447012729054764)
,p_theme_id=>101
,p_name=>'WARNING'
,p_display_name=>'Warning'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(775445099592054705)
,p_css_classes=>'a-Alert--warning'
,p_group_id=>wwv_flow_imp.id(775445499790054719)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(775447185351054764)
,p_theme_id=>101
,p_name=>'ERROR'
,p_display_name=>'Error'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(775445099592054705)
,p_css_classes=>'a-Alert--danger'
,p_group_id=>wwv_flow_imp.id(775445499790054719)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(775447394419054764)
,p_theme_id=>101
,p_name=>'INFORMATIONAL'
,p_display_name=>'Informational'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(775445099592054705)
,p_css_classes=>'a-Alert--info'
,p_group_id=>wwv_flow_imp.id(775445499790054719)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(775447592646054764)
,p_theme_id=>101
,p_name=>'HORIZONTAL'
,p_display_name=>'Horizontal'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(775445099592054705)
,p_css_classes=>'a-Alert--horizontal'
,p_group_id=>wwv_flow_imp.id(695179142948319388)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(775447835567054764)
,p_theme_id=>101
,p_name=>'WIZARD'
,p_display_name=>'Wizard'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(775445099592054705)
,p_css_classes=>'a-Alert--wizard'
,p_group_id=>wwv_flow_imp.id(695179142948319388)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(775447873557054764)
,p_theme_id=>101
,p_name=>'REMOVE_ICON'
,p_display_name=>'Remove Icons'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(775445099592054705)
,p_css_classes=>'a-Alert--noIcon'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(775448137203054765)
,p_theme_id=>101
,p_name=>'SUCCESS'
,p_display_name=>'Success'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(775445099592054705)
,p_css_classes=>'a-Alert--success'
,p_group_id=>wwv_flow_imp.id(775445499790054719)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(792318870187097065)
,p_theme_id=>101
,p_name=>'DISABLE'
,p_display_name=>'Disable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(128932681614424007)
,p_css_classes=>'a-Report--staticRowColors'
,p_group_id=>wwv_flow_imp.id(695073609547798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(792319116358097065)
,p_theme_id=>101
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(128932681614424007)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_imp.id(695074115159798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(792319356976097066)
,p_theme_id=>101
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(128932681614424007)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_imp.id(695073892169798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(792319466176097066)
,p_theme_id=>101
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(128932681614424007)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_imp.id(695073892169798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(792319678160097066)
,p_theme_id=>101
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(128932681614424007)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_imp.id(695073892169798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(792319808446097066)
,p_theme_id=>101
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(128932681614424007)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(792320002434097066)
,p_theme_id=>101
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(128932681614424007)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_imp.id(695073978083798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(933730712592032542)
,p_theme_id=>101
,p_name=>'ADD_ACTIONS'
,p_display_name=>'Add Actions'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(5208269691267696)
,p_css_classes=>'js-addActions'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(933730787698032542)
,p_theme_id=>101
,p_name=>'ADD_SLIDE_ANIMATION'
,p_display_name=>'Add Slide Animation'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(5208269691267696)
,p_css_classes=>'js-slide'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(945899703441488925)
,p_theme_id=>101
,p_name=>'SLIMPROGRESSLIST'
,p_display_name=>'Slim Progress List'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(45984563067371352)
,p_css_classes=>'a-WizardSteps--slim'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1046847155863553947)
,p_theme_id=>101
,p_name=>'FLOATITEMS'
,p_display_name=>'Float Items'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1046845011939553934)
,p_css_classes=>'a-BadgeList--float'
,p_group_id=>wwv_flow_imp.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1046847339966553947)
,p_theme_id=>101
,p_name=>'FIXED'
,p_display_name=>'Span Horizontally'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1046845011939553934)
,p_css_classes=>'a-BadgeList--fixed'
,p_group_id=>wwv_flow_imp.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1046847476349553947)
,p_theme_id=>101
,p_name=>'STACKEDVERTICALLY'
,p_display_name=>'Stacked Vertically'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1046845011939553934)
,p_css_classes=>'a-BadgeList--stacked'
,p_group_id=>wwv_flow_imp.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1046847679905553947)
,p_theme_id=>101
,p_name=>'SMALL'
,p_display_name=>'32px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1046845011939553934)
,p_css_classes=>'a-BadgeList--small'
,p_group_id=>wwv_flow_imp.id(695073825395798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1046847873800553947)
,p_theme_id=>101
,p_name=>'MEDIUM'
,p_display_name=>'48px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1046845011939553934)
,p_css_classes=>'a-BadgeList--medium'
,p_group_id=>wwv_flow_imp.id(695073825395798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1046848091097553947)
,p_theme_id=>101
,p_name=>'LARGE'
,p_display_name=>'64px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1046845011939553934)
,p_css_classes=>'a-BadgeList--large'
,p_group_id=>wwv_flow_imp.id(695073825395798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1046848312274553947)
,p_theme_id=>101
,p_name=>'XLARGE'
,p_display_name=>'96px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1046845011939553934)
,p_css_classes=>'a-BadgeList--xlarge'
,p_group_id=>wwv_flow_imp.id(695073825395798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1046848550784553948)
,p_theme_id=>101
,p_name=>'XXLARGE'
,p_display_name=>'128px'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1046845011939553934)
,p_css_classes=>'a-BadgeList--xxlarge'
,p_group_id=>wwv_flow_imp.id(695073825395798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1046848682352553948)
,p_theme_id=>101
,p_name=>'2COLUMNNGRID'
,p_display_name=>'2 Columnn Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1046845011939553934)
,p_css_classes=>'a-BadgeList--cols'
,p_group_id=>wwv_flow_imp.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1046848892380553948)
,p_theme_id=>101
,p_name=>'3COLUMNGRID'
,p_display_name=>'3 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1046845011939553934)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--3cols'
,p_group_id=>wwv_flow_imp.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1046849088026553949)
,p_theme_id=>101
,p_name=>'4COLUMNGRID'
,p_display_name=>'4 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1046845011939553934)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--4cols'
,p_group_id=>wwv_flow_imp.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1046849355242553949)
,p_theme_id=>101
,p_name=>'5COLUMNGRID'
,p_display_name=>'5 Column Grid'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1046845011939553934)
,p_css_classes=>'a-BadgeList--cols a-BadgeList--5cols'
,p_group_id=>wwv_flow_imp.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1046849544358553949)
,p_theme_id=>101
,p_name=>'FLEXIBLEBOX'
,p_display_name=>'Flexible Box'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(1046845011939553934)
,p_css_classes=>'a-BadgeList--flex'
,p_group_id=>wwv_flow_imp.id(695073701037798637)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1136971639671341337)
,p_theme_id=>101
,p_name=>'ENABLE'
,p_display_name=>'Enable'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(87612589317776005)
,p_css_classes=>'a-Report--rowHighlight'
,p_group_id=>wwv_flow_imp.id(695074115159798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1136971791228341338)
,p_theme_id=>101
,p_name=>'HORIZONTALBORDERS'
,p_display_name=>'Horizontal Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(87612589317776005)
,p_css_classes=>'a-Report--horizontalBorders'
,p_group_id=>wwv_flow_imp.id(695073892169798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1136971924032341338)
,p_theme_id=>101
,p_name=>'INLINEBORDERS'
,p_display_name=>'Inline Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(87612589317776005)
,p_css_classes=>'a-Report--inline'
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1136972062275341338)
,p_theme_id=>101
,p_name=>'NOBORDERS'
,p_display_name=>'No Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(87612589317776005)
,p_css_classes=>'a-Report--noBorders'
,p_group_id=>wwv_flow_imp.id(695073892169798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1136972283158341338)
,p_theme_id=>101
,p_name=>'STRETCH'
,p_display_name=>'Stretch'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(87612589317776005)
,p_css_classes=>'a-Report--stretch'
,p_group_id=>wwv_flow_imp.id(695073978083798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1136972490407341338)
,p_theme_id=>101
,p_name=>'VERTICALBORDERS'
,p_display_name=>'Vertical Borders'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(87612589317776005)
,p_css_classes=>'a-Report--verticalBorders'
,p_group_id=>wwv_flow_imp.id(695073892169798638)
,p_template_types=>'REPORT'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1162908214577693718)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_imp.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1162908408137693718)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_imp.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1162908602718693718)
,p_theme_id=>101
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_imp.id(694480036806463139)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
end;
/
begin
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1162908853288693723)
,p_theme_id=>101
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_imp.id(694481016688463140)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1162909033397693723)
,p_theme_id=>101
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_imp.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1162909254304693723)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_imp.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1162909348932693723)
,p_theme_id=>101
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1162909500752693723)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_imp.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1162909706012693723)
,p_theme_id=>101
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_imp.id(694814532471133994)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1162909858582693724)
,p_theme_id=>101
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_imp.id(694480036806463139)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1162910126957693724)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_imp.id(1162906397341693705)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_imp.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1204766553506179789)
,p_theme_id=>101
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_imp.id(656569185201725731)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_imp.id(695072973969798636)
,p_template_types=>'BUTTON'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1246871186591544316)
,p_theme_id=>101
,p_name=>'USED_IN_DIALOG'
,p_display_name=>'Used in Dialog'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(1152499662607227329)
,p_css_classes=>'a-ProcessingRegion--dialog'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1530854820258329406)
,p_theme_id=>101
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(40271258725782407)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1530854866395329406)
,p_theme_id=>101
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(40271258725782407)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1530855046641329406)
,p_theme_id=>101
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(40271258725782407)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1530855150576329406)
,p_theme_id=>101
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(40271258725782407)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1530855284457329410)
,p_theme_id=>101
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(40271258725782407)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_imp.id(702432470636856200)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1530855479454329410)
,p_theme_id=>101
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(40271258725782407)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_imp.id(702432470636856200)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1530871148108329490)
,p_theme_id=>101
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(702419290542782266)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1530871158921329490)
,p_theme_id=>101
,p_name=>'SHOWBADGES'
,p_display_name=>'Show Badges'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(702419290542782266)
,p_css_classes=>'a-LinksList--showBadge'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1530871316106329490)
,p_theme_id=>101
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(702419290542782266)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1530871427150329490)
,p_theme_id=>101
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(702419290542782266)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1530871567576329491)
,p_theme_id=>101
,p_name=>'FORTOPLEVELONLY'
,p_display_name=>'For top level only'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(702419290542782266)
,p_css_classes=>'a-LinksList--showTopIcons'
,p_group_id=>wwv_flow_imp.id(702432470636856200)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1530871761769329491)
,p_theme_id=>101
,p_name=>'FORALLITEMS'
,p_display_name=>'For all items'
,p_display_sequence=>1
,p_list_template_id=>wwv_flow_imp.id(702419290542782266)
,p_css_classes=>'a-LinksList--showIcons'
,p_group_id=>wwv_flow_imp.id(702432470636856200)
,p_template_types=>'LIST'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1550019249633625338)
,p_theme_id=>101
,p_name=>'SHOWRIGHTARROW'
,p_display_name=>'Show Right Arrow'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(16872467321495251)
,p_css_classes=>'a-LinksList--showArrow'
,p_template_types=>'REPORT'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1550019294378625339)
,p_theme_id=>101
,p_name=>'USEBRIGHTHOVERS'
,p_display_name=>'Use Bright Hovers'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(16872467321495251)
,p_css_classes=>'a-LinksList--brightHover'
,p_template_types=>'REPORT'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1550019445696625339)
,p_theme_id=>101
,p_name=>'DONOTWRAPTEXT'
,p_display_name=>'Do not wrap text'
,p_display_sequence=>1
,p_report_template_id=>wwv_flow_imp.id(16872467321495251)
,p_css_classes=>'a-LinksList--nowrap'
,p_template_types=>'REPORT'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560014988358555730)
,p_theme_id=>101
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(179998957300224011)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_imp.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560015216681555730)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(179998957300224011)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_imp.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560015454132555730)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_imp.id(179998957300224011)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_imp.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560015617913555730)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_imp.id(179998957300224011)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_imp.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560015854389555731)
,p_theme_id=>101
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(179998957300224011)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_imp.id(694814532471133994)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560015978344555731)
,p_theme_id=>101
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(179998957300224011)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_imp.id(694480036806463139)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560016190470555731)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(179998957300224011)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_imp.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560016364623555731)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(179998957300224011)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_imp.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560016612303555731)
,p_theme_id=>101
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_imp.id(179998957300224011)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_imp.id(694481016688463140)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560016698724555731)
,p_theme_id=>101
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(179998957300224011)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560016860365555731)
,p_theme_id=>101
,p_name=>'SIMPLE'
,p_display_name=>'Simple'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(179998957300224011)
,p_css_classes=>'a-Region--simple'
,p_group_id=>wwv_flow_imp.id(694480036806463139)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560038171248674177)
,p_theme_id=>101
,p_name=>'RESPONSIVEICONCOLUMNS'
,p_display_name=>'Responsive Icon Columns'
,p_display_sequence=>2
,p_region_template_id=>wwv_flow_imp.id(651492083233530570)
,p_css_classes=>'a-IRR-region--responsiveIconView'
,p_template_types=>'REGION'
,p_help_text=>'Automatically increases number of icon columns to show based on screen resolution.'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560038304997674177)
,p_theme_id=>101
,p_name=>'ICONLABELSRIGHT'
,p_display_name=>'Icon Labels on Right'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(651492083233530570)
,p_css_classes=>'a-IRR-region--iconLabelsRight'
,p_template_types=>'REGION'
,p_help_text=>'Shows labels in Icon View to the right of the icon.'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560038401929674177)
,p_theme_id=>101
,p_name=>'REMOVEOUTERBORDERS'
,p_display_name=>'Remove Outer Borders'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(651492083233530570)
,p_css_classes=>'a-IRR-region--noOuterBorders'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560047458334689625)
,p_theme_id=>101
,p_name=>'FLUSHREGION'
,p_display_name=>'Flush Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(695174842442319385)
,p_css_classes=>'a-Region--flush'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560047633130689625)
,p_theme_id=>101
,p_name=>'STACKEDREGION'
,p_display_name=>'Stacked Region'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(695174842442319385)
,p_css_classes=>'a-Region--stacked'
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560047782133689626)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(695174842442319385)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_imp.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560047993254689626)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(695174842442319385)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_imp.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560048177638689626)
,p_theme_id=>101
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(695174842442319385)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_imp.id(694814532471133994)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560048433418689626)
,p_theme_id=>101
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(695174842442319385)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_imp.id(694480036806463139)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560048557981689626)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(695174842442319385)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_imp.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560048826398689626)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(695174842442319385)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_imp.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560049005427689626)
,p_theme_id=>101
,p_name=>'EXPANDED'
,p_display_name=>'Expanded'
,p_display_sequence=>.1
,p_region_template_id=>wwv_flow_imp.id(695174842442319385)
,p_css_classes=>'is-expanded'
,p_group_id=>wwv_flow_imp.id(695179142948319388)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560049178209689626)
,p_theme_id=>101
,p_name=>'COLLAPSED'
,p_display_name=>'Collapsed'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(695174842442319385)
,p_css_classes=>'is-collapsed'
,p_group_id=>wwv_flow_imp.id(695179142948319388)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560075282931698185)
,p_theme_id=>101
,p_name=>'REMOVE_TOP_BORDER'
,p_display_name=>'Remove Top Border'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(660773436427335038)
,p_css_classes=>'a-Region--noTopBorder'
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560075551079698185)
,p_theme_id=>101
,p_name=>'ACCESSIBLEHEADING'
,p_display_name=>'Hidden (Accessible)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(660773436427335038)
,p_css_classes=>'a-Region--accessibleHeader'
,p_group_id=>wwv_flow_imp.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560075683207698185)
,p_theme_id=>101
,p_name=>'AUTOSCROLL'
,p_display_name=>'Scroll'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(660773436427335038)
,p_css_classes=>'a-Region--scrollAuto'
,p_group_id=>wwv_flow_imp.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560075863456698186)
,p_theme_id=>101
,p_name=>'BORDERLESS'
,p_display_name=>'Borderless'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(660773436427335038)
,p_css_classes=>'a-Region--noBorder'
,p_group_id=>wwv_flow_imp.id(694480036806463139)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560076096057698186)
,p_theme_id=>101
,p_name=>'DEFAULTPADDING'
,p_display_name=>'Default Padding'
,p_display_sequence=>30
,p_region_template_id=>wwv_flow_imp.id(660773436427335038)
,p_css_classes=>'a-Region--paddedBody'
,p_group_id=>wwv_flow_imp.id(694481016688463140)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560076276641698186)
,p_theme_id=>101
,p_name=>'HIDDEN'
,p_display_name=>'Hidden'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(660773436427335038)
,p_css_classes=>'a-Region--hideHeader'
,p_group_id=>wwv_flow_imp.id(701826319113292817)
,p_template_types=>'REGION'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560076470349698186)
,p_theme_id=>101
,p_name=>'NOPADDING'
,p_display_name=>'No Padding'
,p_display_sequence=>10
,p_region_template_id=>wwv_flow_imp.id(660773436427335038)
,p_css_classes=>'a-Region--noPadding'
,p_group_id=>wwv_flow_imp.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560076749242698186)
,p_theme_id=>101
,p_name=>'SCROLLWITHSHADOWS'
,p_display_name=>'Scroll (with Shadows)'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(660773436427335038)
,p_css_classes=>'a-Region--shadowScroll'
,p_group_id=>wwv_flow_imp.id(694816751912133995)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560076920534698186)
,p_theme_id=>101
,p_name=>'SIDEBAR'
,p_display_name=>'Sidebar'
,p_display_sequence=>1
,p_region_template_id=>wwv_flow_imp.id(660773436427335038)
,p_css_classes=>'a-Region--sideRegion'
,p_group_id=>wwv_flow_imp.id(694814532471133994)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(1560077106633698186)
,p_theme_id=>101
,p_name=>'SLIMPADDING'
,p_display_name=>'Slim Padding'
,p_display_sequence=>20
,p_region_template_id=>wwv_flow_imp.id(660773436427335038)
,p_css_classes=>'a-Region--slimPadding'
,p_group_id=>wwv_flow_imp.id(694481016688463140)
,p_template_types=>'REGION'
,p_is_advanced=>'N'
);
wwv_flow_imp_shared.create_template_option(
 p_id=>wwv_flow_imp.id(2050872719238936523)
,p_theme_id=>101
,p_name=>'LEFT'
,p_display_name=>'Left'
,p_display_sequence=>1
,p_button_template_id=>wwv_flow_imp.id(2050872492464936456)
,p_css_classes=>'a-Button--iconLeft'
,p_group_id=>wwv_flow_imp.id(695072973969798636)
,p_template_types=>'BUTTON'
);
end;
/
prompt --application/shared_components/globalization/language
begin
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(1615675568296713)
,p_translation_flow_id=>4601
,p_translation_flow_language_cd=>'es'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(1615730224301265)
,p_translation_flow_id=>4602
,p_translation_flow_language_cd=>'fr'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(1615871977304282)
,p_translation_flow_id=>4603
,p_translation_flow_language_cd=>'de'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(1615993706305508)
,p_translation_flow_id=>4604
,p_translation_flow_language_cd=>'it'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(1616013889307020)
,p_translation_flow_id=>4605
,p_translation_flow_language_cd=>'pt-br'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(1616181469308948)
,p_translation_flow_id=>4606
,p_translation_flow_language_cd=>'zh-cn'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(1616226558310545)
,p_translation_flow_id=>4607
,p_translation_flow_language_cd=>'zh-tw'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(1616306155312278)
,p_translation_flow_id=>4608
,p_translation_flow_language_cd=>'ko'
,p_direction_right_to_left=>'N'
);
wwv_flow_imp_shared.create_language_map(
 p_id=>wwv_flow_imp.id(1616496473313405)
,p_translation_flow_id=>4609
,p_translation_flow_language_cd=>'ja'
,p_direction_right_to_left=>'N'
);
end;
/
prompt --application/shared_components/logic/build_options
begin
wwv_flow_imp_shared.create_build_option(
 p_id=>wwv_flow_imp.id(37871219870687828)
,p_build_option_name=>'Enable Approval Status'
,p_build_option_status=>'INCLUDE'
);
wwv_flow_imp_shared.create_build_option(
 p_id=>wwv_flow_imp.id(319172522601854021)
,p_build_option_name=>'file attachments'
,p_build_option_status=>'INCLUDE'
);
wwv_flow_imp_shared.create_build_option(
 p_id=>wwv_flow_imp.id(698205300939964492)
,p_build_option_name=>'Enable APEX Internal Feedback'
,p_build_option_status=>'EXCLUDE'
,p_default_on_export=>'EXCLUDE'
);
end;
/
prompt --application/shared_components/globalization/messages
begin
null;
end;
/
prompt --application/shared_components/globalization/dyntranslations
begin
null;
end;
/
prompt --application/shared_components/user_interface/shortcuts/ok_to_get_next_prev_pk_value
begin
wwv_flow_imp_shared.create_shortcut(
 p_id=>wwv_flow_imp.id(20611320407398152)
,p_shortcut_name=>'OK_TO_GET_NEXT_PREV_PK_VALUE'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>'Are you sure you want to leave this page without saving?'
);
end;
/
prompt --application/shared_components/user_interface/shortcuts/delete_confirm_msg
begin
wwv_flow_imp_shared.create_shortcut(
 p_id=>wwv_flow_imp.id(168592128240568136)
,p_shortcut_name=>'DELETE_CONFIRM_MSG'
,p_shortcut_type=>'TEXT_ESCAPE_JS'
,p_shortcut=>'Would you like to perform this delete action?'
);
end;
/
prompt --application/shared_components/email/templates/issues_summary
begin
wwv_flow_imp_shared.create_email_template(
 p_id=>wwv_flow_imp.id(15671658472460013)
,p_name=>'Issues Summary'
,p_static_id=>'ISSUES_SUMMARY'
,p_version_number=>1
,p_subject=>'You have #NOTIFICATION_COUNT# new notifications'
,p_html_body=>wwv_flow_string.join(wwv_flow_t_varchar2(
'              <!-- SubHeader -->',
'              <table width="100%" style="color: #3e3e3e; background-color: #fcfcfc; border-bottom: 1px solid #f0f0f0;">',
'                <tr>',
'                  <td class="hero-reduced" style="text-align: center; padding: 32px; font-size: 14px;">',
'                    <span style="font-size: 20px; font-weight: 500;"> #NOTIFICATION_COUNT# new notifications against the following Issues:</span>',
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // SubHeader -->',
'',
'              <!-- Main Body --> ',
'              <table width="100%" style="background-color: #ffffff;">',
'                <tr>',
'                  <td class="main main-reduced" style="text-align: left; padding: 32px; font-size: 14px; line-height: 20px;">',
'',
'                    #ISSUES_CHANGED!RAW#<br>',
'                    <br>',
'                    <!-- Button -->',
'                    <table align="center">',
'                      <tr>',
'                        <td style="background-color: #056abf; color: #ffffff; padding: 12px 32px; border-radius: 2px; min-width: 160px;" align="center">',
'                          <a href="#NOTIFICATIONS_URL#" target="_blank" style="font-size: 16px; font-weight: 500; color: #ffffff; text-decoration: none; display: inline-block;">',
'                            <span style="text-align: center; display: block; padding: 12px 32px; margin: -12px -32px;">View #NOTIFICATION_COUNT# Notifications</span>',
'                          </a>',
'                        </td>',
'                      </tr>',
'                    </table>',
'                    <!-- // Button -->',
'',
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // Main Body -->'))
,p_html_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'              <!-- Header -->',
'              <table width="100%">',
'                <tr>',
'                  <td style="border-bottom: 1px solid #e6e6e6; line-height: 0; padding: 4px 8px;">',
'',
'                    <!-- Logo -->',
'                    <a href="#EMAIL_LOGO_URL#" style=" display: inline-block; text-decoration: none;">',
'                      <table>',
'                        <tr>',
'                          <td style="vertical-align: middle;"><img src="https://apex.oracle.com/i/email/img/oracle-logo-2x.png" width="128" height="16" alt="Oracle" style="border: 0; font-size: 16px; line-height: 16px; display: block; width: 128px; h'
||'eight: 16px;"  /></td>',
'                          <td style="vertical-align: middle; padding: 12px; font-size: 16px; line-height: 20px; font-weight: 600; color: rgba(0,0,0,.85);">#APP_SHORT_NAME#</td>',
'                        </tr>',
'                      </table>',
'                    </a>',
'                    <!-- // Logo -->',
'',
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // Header -->',
''))
,p_html_footer=>wwv_flow_string.join(wwv_flow_t_varchar2(
'             <!-- Footer -->',
'              <table width="100%">',
'                <tr>',
'                  <td class="footer-reduced" style="font-size: 12px; padding: 12px 32px; text-align: center; border-top: 1px solid #e6e6e6;">',
'                    You have received this notification because you are subscribed to issues which have new activity. To stop receiving future updates, you may <a href="#EMAIL_PREFS_URL#" style="color: #056abf; text-decoration: none;">disable email n'
||'otifications</a>.',
'                  </td>',
'                </tr>',
'              </table>',
'            <!-- // Footer -->'))
,p_html_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE HTML>',
'<html>',
'<head>',
'  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">',
'  <meta name="viewport" content="width=device-width">',
'  <style>',
'    body { background-color: #fdfdfd; color: #3e3e3e; margin: 0; padding: 0; min-width: 100%; -webkit-text-size-adjust: none; -ms-text-size-adjust: none; text-size-adjust: none; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Helvetica N'
||'eue", Roboto, Helvetica, Arial, sans-serif; line-height: 1.5; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; }',
'    table { border: 0; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; }',
'    table td { padding: 0; vertical-align: top; border-collapse: collapse; }',
'    table, th, td { line-height: inherit; }',
'    img { vertical-align: middle; text-decoration: none; outline: none; border: 0; -ms-interpolation-mode: bicubic; }',
'    table.container { margin-right: auto; margin-left: auto; width: 600px; }',
'    p { margin: 0 0 20px 0; }',
'    a, .main a { color: #056abf; }',
'    @media only screen and (max-width: 612px) {',
'      .mobile-hide { display: none !important; }',
'      .stack { display: block !important; width: auto !important; }',
'      table.container { width: 100% !important; }',
'      table td { text-align: left !important; }',
'    }',
'  </style>',
'</head>',
'<body yahoo="fix" style="background-color: #efefef; line-height: 1.5;">',
'<table class="body" border="0" width="100%">',
'  <tr>',
'    <td align="center" valign="top" style="background-color: #efefef;">',
'      <center>',
'        <table class="container" width="600">',
'          <tr>',
'            <td style="padding: 12px 6px;">',
'',
'              #HEADER#',
'              #BODY#',
'              #FOOTER#',
'',
'            </td>',
'          </tr>',
'        </table>',
'      </center>',
'    </td>',
'  </tr>',
'</table>',
'</body>',
'</html>'))
,p_text_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#NOTIFICATION_COUNT# New Notifications',
'',
'#NOTIFICATIONS_URL#'))
);
end;
/
prompt --application/shared_components/email/templates/issue_change
begin
wwv_flow_imp_shared.create_email_template(
 p_id=>wwv_flow_imp.id(15674570214174148)
,p_name=>'Issue Change'
,p_static_id=>'ISSUE_CHANGE'
,p_version_number=>1
,p_subject=>'#EMAIL_SUBJECT#'
,p_html_body=>wwv_flow_string.join(wwv_flow_t_varchar2(
'              <!-- SubHeader -->',
'              <table width="100%" style="color: #3e3e3e; background-color: #fcfcfc; border-bottom: 1px solid #f0f0f0;">',
'                <tr>',
'                  <td class="hero-reduced" style="text-align: center; padding: 32px; font-size: 14px;">',
'                    <span style="font-size: 20px; font-weight: 500;">#HEADER_MESSAGE#</span>',
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // SubHeader -->',
'',
'              <!-- Main Body --> ',
'              <table width="100%" style="background-color: #ffffff;">',
'                <tr>',
'                  <td class="main main-reduced" style="text-align: left; padding: 32px; font-size: 14px; line-height: 20px;">',
'',
'                    #CHANGE_MESSAGE!RAW#<br>',
'                    <br>',
'                    <br>',
'                    <!-- Button -->',
'                    <table align="center">',
'                      <tr>',
'                        <td style="background-color: #056abf; color: #ffffff; padding: 12px 32px; border-radius: 2px; min-width: 160px;" align="center">',
'                          <a href="#ISSUE_URL#" target="_blank" style="font-size: 16px; font-weight: 500; color: #ffffff; text-decoration: none; display: inline-block;">',
'                            <span style="text-align: center; display: block; padding: 12px 32px; margin: -12px -32px;">View Issue</span>',
'                          </a>',
'                        </td>',
'                      </tr>',
'                    </table>',
'                    <!-- // Button -->',
'',
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // Main Body -->'))
,p_html_header=>wwv_flow_string.join(wwv_flow_t_varchar2(
'              <!-- Header -->',
'              <table width="100%">',
'                <tr>',
'                  <td style="border-bottom: 1px solid #e6e6e6; line-height: 0; padding: 4px 8px;">',
'',
'                    <!-- Logo -->',
'                    <a href="#EMAIL_LOGO_URL#" style=" display: inline-block; text-decoration: none;">',
'                      <table>',
'                        <tr>',
'                          <td style="vertical-align: middle;"><img src="https://apex.oracle.com/i/email/img/oracle-logo-2x.png" width="128" height="16" alt="Oracle" style="border: 0; font-size: 16px; line-height: 16px; display: block; width: 128px; h'
||'eight: 16px;"  /></td>',
'                          <td style="vertical-align: middle; padding: 12px; font-size: 16px; line-height: 20px; font-weight: 600; color: rgba(0,0,0,.85);">#APP_SHORT_NAME#</td>',
'                        </tr>',
'                      </table>',
'                    </a>',
'                    <!-- // Logo -->',
'',
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // Header -->',
'',
''))
,p_html_footer=>wwv_flow_string.join(wwv_flow_t_varchar2(
'             <!-- Footer -->',
'              <table width="100%">',
'                <tr>',
'                  <td class="footer-reduced" style="font-size: 12px; padding: 12px 32px; text-align: center; border-top: 1px solid #e6e6e6;">',
'                    You have received this notification because you are subscribed to issues which have new activity. To stop receiving future updates, you may <a href="#EMAIL_PREFS_URL#" style="color: #056abf; text-decoration: none;">disable email n'
||'otifications</a>.',
'                  </td>',
'                </tr>',
'              </table>',
'              <!-- // Footer -->'))
,p_html_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<!DOCTYPE HTML>',
'<html>',
'<head>',
'  <meta http-equiv="Content-Type" content="text/html; charset=utf-8">',
'  <meta name="viewport" content="width=device-width">',
'  <style>',
'    body { background-color: #fdfdfd; color: #3e3e3e; margin: 0; padding: 0; min-width: 100%; -webkit-text-size-adjust: none; -ms-text-size-adjust: none; text-size-adjust: none; font-family: -apple-system, BlinkMacSystemFont, "Segoe UI", "Helvetica N'
||'eue", Roboto, Helvetica, Arial, sans-serif; line-height: 1.5; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; }',
'    table { border: 0; border-spacing: 0; border-collapse: collapse; mso-table-lspace: 0pt; mso-table-rspace: 0pt; }',
'    table td { padding: 0; vertical-align: top; border-collapse: collapse; }',
'    table, th, td { line-height: inherit; }',
'    img { vertical-align: middle; text-decoration: none; outline: none; border: 0; -ms-interpolation-mode: bicubic; }',
'    table.container { margin-right: auto; margin-left: auto; width: 600px; }',
'    p { margin: 0 0 20px 0; }',
'    a, .main a { color: #056abf; }',
'    @media only screen and (max-width: 612px) {',
'      .mobile-hide { display: none !important; }',
'      .stack { display: block !important; width: auto !important; }',
'      table.container { width: 100% !important; }',
'    }',
'  </style>',
'</head>',
'<body yahoo="fix" style="background-color: #efefef; line-height: 1.5;">',
'<table class="body" border="0" width="100%">',
'  <tr>',
'    <td align="center" valign="top" style="background-color: #efefef;">',
'      <center>',
'        <table class="container" width="600">',
'          <tr>',
'            <td style="padding: 12px 6px;">',
'',
'              #HEADER#',
'              #BODY#',
'              #FOOTER#',
'',
'            </td>',
'          </tr>',
'        </table>',
'      </center>',
'    </td>',
'  </tr>',
'</table>',
'</body>',
'</html>'))
,p_text_template=>wwv_flow_string.join(wwv_flow_t_varchar2(
'#EMAIL_SUBJECT#',
'',
'#ISSUE_URL#'))
);
end;
/
prompt --application/shared_components/security/authentications/internal_authentication
begin
wwv_flow_imp_shared.create_authentication(
 p_id=>wwv_flow_imp.id(544702116026132813)
,p_name=>'Internal Authentication'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_invalid_session_type=>'LOGIN'
,p_logout_url=>'f?p=4550:8:&SESSION.'
,p_cookie_name=>'ORA_WWV_USER_&INSTANCE_ID.'
,p_use_secure_cookie_yn=>'N'
,p_ras_mode=>0
,p_reference_id=>540226219724705040
);
end;
/
prompt --application/shared_components/plugins/authorization_type/com_oracle_apex_developer_authorization
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(17268319223727578)
,p_plugin_type=>'AUTHORIZATION TYPE'
,p_name=>'COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_display_name=>'Developer Authorization'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHORIZATION TYPE','COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function is_authorized (',
'    p_authorization in wwv_flow_plugin_api.t_authorization,',
'    p_plugin        in wwv_flow_plugin_api.t_plugin )',
'    return wwv_flow_plugin_api.t_authorization_exec_result',
'is',
'    l_result               wwv_flow_plugin_api.t_authorization_exec_result;',
'begin',
'    l_result.is_authorized := wwv_flow_authorization.is_authorized_developer ( ',
'                                  p_developer_authorization => p_authorization.attribute_01 );',
'    return l_result;',
'exception',
'    when no_data_found then',
'        l_result.is_authorized := false;',
'        return l_result;',
'end;'))
,p_api_version=>1
,p_execution_function=>'is_authorized'
,p_substitute_attributes=>true
,p_reference_id=>12457518297512494
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(1697647110757966)
,p_plugin_id=>wwv_flow_imp.id(17268319223727578)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Developer Role'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>false
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1698501678757967)
,p_plugin_attribute_id=>wwv_flow_imp.id(1697647110757966)
,p_display_sequence=>10
,p_display_value=>'ADMIN: Ability to manage flow developer privileges'
,p_return_value=>'ADMIN'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1699086750757967)
,p_plugin_attribute_id=>wwv_flow_imp.id(1697647110757966)
,p_display_sequence=>20
,p_display_value=>'EDIT: Ability change all attributes of specified flow(s)'
,p_return_value=>'EDIT'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1699551228757967)
,p_plugin_attribute_id=>wwv_flow_imp.id(1697647110757966)
,p_display_sequence=>30
,p_display_value=>'HELP: Ability edit help page for a given company'
,p_return_value=>'HELP'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1700046011757968)
,p_plugin_attribute_id=>wwv_flow_imp.id(1697647110757966)
,p_display_sequence=>40
,p_display_value=>'BROWSE: Access to Oracle data dictionary browser'
,p_return_value=>'BROWSE'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1700596615757968)
,p_plugin_attribute_id=>wwv_flow_imp.id(1697647110757966)
,p_display_sequence=>50
,p_display_value=>'CREATE: Ability to create new flows'
,p_return_value=>'CREATE'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1701060363757969)
,p_plugin_attribute_id=>wwv_flow_imp.id(1697647110757966)
,p_display_sequence=>60
,p_display_value=>'MONITOR: Ability to monitor flow activity'
,p_return_value=>'MONITOR'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1701553298757969)
,p_plugin_attribute_id=>wwv_flow_imp.id(1697647110757966)
,p_display_sequence=>70
,p_display_value=>'DB_MONITOR: Ability to monitor Oracle database attributes'
,p_return_value=>'DB_MONITOR'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1702060424757969)
,p_plugin_attribute_id=>wwv_flow_imp.id(1697647110757966)
,p_display_sequence=>80
,p_display_value=>'SQL: Ability to issues SQL statements'
,p_return_value=>'SQL'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1702512040757970)
,p_plugin_attribute_id=>wwv_flow_imp.id(1697647110757966)
,p_display_sequence=>90
,p_display_value=>'USER_MANAGER: Manage user accounts for cookie based authentication'
,p_return_value=>'USER_MANAGER'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1703045260757970)
,p_plugin_attribute_id=>wwv_flow_imp.id(1697647110757966)
,p_display_sequence=>100
,p_display_value=>'DATA_LOADER: Data Workshop'
,p_return_value=>'DATA_LOADER'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1703554944757971)
,p_plugin_attribute_id=>wwv_flow_imp.id(1697647110757966)
,p_display_sequence=>110
,p_display_value=>'RESTFUL: Ability to enable RESTful Services'
,p_return_value=>'RESTFUL'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1704077840757971)
,p_plugin_attribute_id=>wwv_flow_imp.id(1697647110757966)
,p_display_sequence=>130
,p_display_value=>'EDIT or SQL'
,p_return_value=>'EDIT:SQL'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(1698087656757966)
,p_plugin_attribute_id=>wwv_flow_imp.id(1697647110757966)
,p_display_sequence=>140
,p_display_value=>'DATA_GENERATOR: Ability to access Data Generator in SQL Workshop'
,p_return_value=>'DATA_GENERATOR'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_saml
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(44506605844251870)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SAML'
,p_display_name=>'INTERNAL SAML'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SAML'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_saml'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_saml'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_saml'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_saml'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_saml'
,p_substitute_attributes=>true
,p_reference_id=>77082398185639908
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_searchbox
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(78652560687827668)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM.ORACLE.APEX.SEARCHBOX'
,p_display_name=>'Search Box'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM.ORACLE.APEX.SEARCHBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_searchbox'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT'
,p_substitute_attributes=>true
,p_reference_id=>42609120788689442
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(1517927831748688683)
,p_plugin_id=>wwv_flow_imp.id(78652560687827668)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Redirect URL'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:<target page>:&SESSION.::&DEBUG.::<target item>:'
,p_display_length=>80
,p_max_length=>4000
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(1517928294783688683)
,p_plugin_id=>wwv_flow_imp.id(78652560687827668)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Search Text'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'Search'
,p_is_translatable=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<br />',
''))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_apex
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(118506410176124090)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'
,p_display_name=>'INTERNAL Oracle APEX Accounts'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.APEX'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_apex'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113737019268347425
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_social
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(123365889011393768)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'
,p_display_name=>'INTERNAL Social Sign-In'
,p_supported_ui_types=>'DESKTOP'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SOCIAL'),'')
,p_api_version=>2
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_social'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_social'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_social'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_social'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_social'
,p_substitute_attributes=>true
,p_reference_id=>117694777698093086
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(107695204015481770)
,p_plugin_id=>wwv_flow_imp.id(123365889011393768)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Authentication Provider'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'OPENID_CONNECT'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(107695680516481771)
,p_plugin_attribute_id=>wwv_flow_imp.id(107695204015481770)
,p_display_sequence=>10
,p_display_value=>'OpenID Connect Provider'
,p_return_value=>'OPENID_CONNECT'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(107696126043481772)
,p_plugin_attribute_id=>wwv_flow_imp.id(107695204015481770)
,p_display_sequence=>20
,p_display_value=>'Generic OAuth2 Provider'
,p_return_value=>'OAUTH2'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(107696654161481772)
,p_plugin_attribute_id=>wwv_flow_imp.id(107695204015481770)
,p_display_sequence=>30
,p_display_value=>'Google'
,p_return_value=>'GOOGLE'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(107697138839481772)
,p_plugin_attribute_id=>wwv_flow_imp.id(107695204015481770)
,p_display_sequence=>40
,p_display_value=>'Facebook'
,p_return_value=>'FACEBOOK'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(107697647384481772)
,p_plugin_id=>wwv_flow_imp.id(123365889011393768)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Discovery URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(107695204015481770)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OPENID_CONNECT'
,p_examples=>'https://accounts.example.com/.well-known/openid-configuration'
,p_help_text=>'Enter the OpenID Connect provider''s discovery URL.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(107698020817481773)
,p_plugin_id=>wwv_flow_imp.id(123365889011393768)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Authorization Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(107695204015481770)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s authorization endpoint URL.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(107698440478481773)
,p_plugin_id=>wwv_flow_imp.id(123365889011393768)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Token Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(107695204015481770)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s token endpoint URL.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(107698895638481773)
,p_plugin_id=>wwv_flow_imp.id(123365889011393768)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'User Info Endpoint URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(107695204015481770)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_help_text=>'Enter the OAuth2 provider''s user info endpoint URL.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(107699221360481773)
,p_plugin_id=>wwv_flow_imp.id(123365889011393768)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Scope'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'profile'
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of permissions to request for the user who is logging in. The acceptable values depend on your authentication provider. For OpenID Connect and Google, Oracle APEX automatically adds the "openid" scope. The authentication '
||'provider returns user attributes based on these permissions. You can use a Post Authentication procedure to process these attributes, using the APEX_JSON.GET_% functions.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(107699630749481774)
,p_plugin_id=>wwv_flow_imp.id(123365889011393768)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Authentication URI Parameters'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter optional parameters for the authentication URI. Consult the authentication provider''s documentation for supported parameters.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(107700074148481774)
,p_plugin_id=>wwv_flow_imp.id(123365889011393768)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Username Attribute'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'email'
,p_is_translatable=>false
,p_help_text=>'Enter the attribute which contains the username. Consult the authentication provider''s documentation for supported attributes.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(107700485145481774)
,p_plugin_id=>wwv_flow_imp.id(123365889011393768)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Additional User Attributes'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>'Enter a comma separated list of additional user data attributes. Consult the authentication provider''s documentation for supported attributes.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(107700838350481774)
,p_plugin_id=>wwv_flow_imp.id(123365889011393768)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Logout URL'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Use this attribute to specify a URL to log out from your authentication provider.',
'For <em>OpenID Connect</em>, &PRODUCT_NAME. automatically uses the <em>end_session</em> endpoint, if that is defined in the <em>Discovery URL</em>.',
'For others, you can use #ID_TOKEN# and #REDIRECT_URI# in the URL, to substitute the ID token that was returned when logging in and the full URL to /apex on your instance, e.g. https://www.example.com/apex/apex.',
'Note that the redirect URI often has to be registered with your authentication provider.'))
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(107701295151481774)
,p_plugin_id=>wwv_flow_imp.id(123365889011393768)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>65
,p_prompt=>'Token Authentication Method'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BASIC_AND_CLID'
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(107695204015481770)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'OAUTH2'
,p_lov_type=>'STATIC'
,p_help_text=>'Enter how the credential''s client ID and client secret should be passed to the server.'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(107701616348481775)
,p_plugin_attribute_id=>wwv_flow_imp.id(107701295151481774)
,p_display_sequence=>10
,p_display_value=>'Basic Authentication'
,p_return_value=>'BASIC'
,p_help_text=>'Send client id and client secret in a Basic Authentication header.'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(107702136939481775)
,p_plugin_attribute_id=>wwv_flow_imp.id(107701295151481774)
,p_display_sequence=>20
,p_display_value=>'Basic Authentication and Client ID in Body'
,p_return_value=>'BASIC_AND_CLID'
,p_help_text=>'Send client id and client secret in a Basic Authentication header, but also send client it in the request body.'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(107702661220481775)
,p_plugin_attribute_id=>wwv_flow_imp.id(107701295151481774)
,p_display_sequence=>30
,p_display_value=>'Client ID and Client Secret in Body'
,p_return_value=>'BODY'
,p_help_text=>'Send client id and client secret in the request body.'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(107703163502481775)
,p_plugin_attribute_id=>wwv_flow_imp.id(107701295151481774)
,p_display_sequence=>40
,p_display_value=>'Client ID in Body'
,p_return_value=>'CLID'
,p_help_text=>'Only send client id in the request body.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(107703676712481776)
,p_plugin_id=>wwv_flow_imp.id(123365889011393768)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>91
,p_prompt=>'Verify Username'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>true
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'If enabled, &PRODUCT_NAME. will look for an attribute "#username#_verified" (e.g. "email_verified" for Username Attribute "email"). If this is set to "false", the username will not be accepted.'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_cloud_idm
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(361433126909906343)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'
,p_display_name=>'INTERNAL Oracle Cloud Identity Management'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.CLOUD_IDM'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_cloud'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_cloud'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_cloud'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_cloud'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_cloud'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749806821809026
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_db
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(361435914819906347)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.DB'
,p_display_name=>'INTERNAL Database Accounts'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.DB'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_db'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113749511183746276
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_header
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(361467810754906382)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'
,p_display_name=>'INTERNAL HTTP Header Variable'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.HEADER'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_header'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_header'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_header'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_header'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_header'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>708795120396802284
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(308156948483529819)
,p_plugin_id=>wwv_flow_imp.id(361467810754906382)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'HTTP Header Variable Name'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'OAM_REMOTE_USER'
,p_display_length=>30
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Specifies the name of the HTTP header variable which contains the username.',
'The default OAM_REMOTE_USER is used by Oracle Access Manager and has to be changed',
'if another authentication provider is used.</p>'))
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(308157379744529819)
,p_plugin_id=>wwv_flow_imp.id(361467810754906382)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Action if Username is Empty'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'BUILTIN_URL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the action which should be performed if the username stored in the HTTP header variable is empty. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Redirect to Built-In URL</strong> to initiate a login by the web server. This Built-In URL has to be setup to be protected by the web server, in order to force a login when called. After login, the web server must store the validated us'
||'ername in the HTTP header variable, so it is available to the authentication scheme. The Built-In URL is',
'<pre>/apex/apex_authentication.callback</pre>',
'The prefix <code>/apex/</code> depends on your server configuration.',
'</li>',
'  <li><strong>Redirect to URL</strong> to initiate a login on an external server which then sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CAL'
||'LBACK#</code> placeholder to complete authentication in the application.</li>',
'  <li><strong>Display Error</strong> will display the specified error message and no login will be performed in the application.</li>',
'</ul>',
'</p>'))
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(308157782905529819)
,p_plugin_attribute_id=>wwv_flow_imp.id(308157379744529819)
,p_display_sequence=>10
,p_display_value=>'Redirect to Built-In URL'
,p_return_value=>'BUILTIN_URL'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(308158246647529820)
,p_plugin_attribute_id=>wwv_flow_imp.id(308157379744529819)
,p_display_sequence=>20
,p_display_value=>'Redirect to URL'
,p_return_value=>'URL'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(308158726653529820)
,p_plugin_attribute_id=>wwv_flow_imp.id(308157379744529819)
,p_display_sequence=>30
,p_display_value=>'Display Error'
,p_return_value=>'ERROR'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(308159264767529820)
,p_plugin_id=>wwv_flow_imp.id(361467810754906382)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(308157379744529819)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'URL'
,p_examples=>'http://sso.example.com/?success=#CALLBACK#'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies the URL of an external login server which sets the validated username in the HTTP header variable. The external server should redirect back to the application using the URL generated by the <code>#CALLBACK#</code> placeholder to complete au'
||'thentication in the application.',
'</p>'))
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(308159601807529821)
,p_plugin_id=>wwv_flow_imp.id(361467810754906382)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Error Message'
,p_attribute_type=>'TEXTAREA'
,p_is_required=>true
,p_display_length=>60
,p_is_translatable=>true
,p_depending_on_attribute_id=>wwv_flow_imp.id(308157379744529819)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'ERROR'
,p_help_text=>'Specifies the error message to be displayed if the HTTP header variable does not contain a value or the HTTP header variable does not exist.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(308160003083529821)
,p_plugin_id=>wwv_flow_imp.id(361467810754906382)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Verify Username'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'ALWAYS'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'Specifies how often the username stored in the HTTP header variable is verified. The following options are available:',
'</p>',
'<p>',
'<ul>',
'  <li><strong>Each Request</strong> will expect that the CGI variable is always set as soon as the login has been performed by the web server. If the username is not identical to the one stored in the current &PRODUCT_NAME. session, the session will '
||'be invalidated and a new login will be initiated. This is the most secure option because it detects logouts or username changes.',
'  </li>',
'  <li><strong>After Login</strong> will only verify and store the username in the &PRODUCT_NAME. session after the web server has performed the login and calls the callback to complete authentication in the application. For callback see "Action if Us'
||'ername is Empty" configuration.',
'  </li>',
'</ul>',
'</p>'))
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(308160452206529825)
,p_plugin_attribute_id=>wwv_flow_imp.id(308160003083529821)
,p_display_sequence=>10
,p_display_value=>'Each Request'
,p_return_value=>'ALWAYS'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(308160994369529825)
,p_plugin_attribute_id=>wwv_flow_imp.id(308160003083529821)
,p_display_sequence=>20
,p_display_value=>'After Login'
,p_return_value=>'CALLBACK'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(308161409902529826)
,p_plugin_id=>wwv_flow_imp.id(361467810754906382)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Logout URL of SSO Server'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'If the authentication scheme is based on Oracle Access Manager or similar servers,',
'you can use this attribute to specify a URL to log out of the central single sign-on server.',
'<p/>',
'For Oracle Access Manager based SSO, enter for example',
'<pre>',
'/oamsso/logout.html?end_url=%POST_LOGOUT_URL%',
'</pre>',
'The substitution parameter <strong>%POST_LOGOUT_URL%</strong> will be replaced by an encoded URL to the login page of your application.'))
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_ldap
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(361538211820906436)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'
,p_display_name=>'INTERNAL LDAP Directory'
,p_supported_ui_types=>'DESKTOP:JQM_SMARTPHONE:JQM_TABLET'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.LDAP'),'')
,p_api_version=>1
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_ldap'
,p_standard_attributes=>'INVALID_SESSION:LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>863910941135523528
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the username and password for authentication against the LDAP directory identified on the login page. Remember, passwords may be case sensitive.</p>',
''))
,p_version_identifier=>'1.0'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(361538531240906436)
,p_plugin_id=>wwv_flow_imp.id(361538211820906436)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Host'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_max_length=>255
,p_is_translatable=>false
,p_help_text=>'The hostname of your LDAP directory server.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(361538917330906436)
,p_plugin_id=>wwv_flow_imp.id(361538211820906436)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Port'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>6
,p_max_length=>10
,p_is_translatable=>false
,p_help_text=>'The port number of your LDAP directory host. The default is 389.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(361539328797906436)
,p_plugin_id=>wwv_flow_imp.id(361538211820906436)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Use SSL'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'NO_SSL'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'Choose whether to use SSL to bind to the LDAP directory. If SSL with Authentication is chosen, a wallet must be configured for the &PRODUCT_NAME. instance.'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(361539709386906436)
,p_plugin_attribute_id=>wwv_flow_imp.id(361539328797906436)
,p_display_sequence=>10
,p_display_value=>'SSL'
,p_return_value=>'SSL'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(361540220840906436)
,p_plugin_attribute_id=>wwv_flow_imp.id(361539328797906436)
,p_display_sequence=>20
,p_display_value=>'SSL with Authentication'
,p_return_value=>'SSL_AUTH'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(361540722154906437)
,p_plugin_attribute_id=>wwv_flow_imp.id(361539328797906436)
,p_display_sequence=>30
,p_display_value=>'No SSL'
,p_return_value=>'NO_SSL'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(361541215083906437)
,p_plugin_id=>wwv_flow_imp.id(361538211820906436)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Distinguished Name (DN) String'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Enter the pattern used to construct the fully qualified distinguished name (DN) string to DBMS_LDAP.SIMPLE_BIND_S if using exact DN or the search base if using non-exact DN. Use <strong>%LDAP_USER%</strong> as a placeholder for the username.  For exa'
||'mple:',
'<p>',
'<strong>Exact DN</strong>',
'</p>',
'<p>',
'cn=%LDAP_USER%,l=amer,dc=yourdomain,dc=com',
'</p>',
'<p>',
'<strong>Non-Exact DN (Search Base)</strong>',
'</p>',
'<p>',
'dc=yourdomain,dc=com',
'</p>'))
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(361541630010906438)
,p_plugin_id=>wwv_flow_imp.id(361538211820906436)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Use Exact Distinguished Name (DN)'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'Choose whether the LDAP Distinguished Name (DN) String is exact or non-exact. If non-exact, LDAP Distinguished Name (DN) is the search base and you must supply a Search Filter.'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(361542006423906438)
,p_plugin_id=>wwv_flow_imp.id(361538211820906436)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Search Filter'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_display_length=>40
,p_is_translatable=>false
,p_depending_on_attribute_id=>wwv_flow_imp.id(361541630010906438)
,p_depending_on_has_to_exist=>true
,p_depending_on_condition_type=>'EQUALS'
,p_depending_on_expression=>'N'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Enter the search filter when not using an exact distinguished name (DN). Use <strong>%LDAP_USER%</strong> as a place-holder for the username. For example:',
'</p>',
'<p><pre>cn=%LDAP_USER%</pre></p>'))
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(361542419805906438)
,p_plugin_id=>wwv_flow_imp.id(361538211820906436)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'LDAP Username Edit Function'
,p_attribute_type=>'PLSQL FUNCTION BODY'
,p_is_required=>false
,p_is_translatable=>false
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'You may provide additional code to be executed to transform the username into a format perfectly suited to the LDAP directory entry or LDAP username.',
'The bind variable :USERNAME contains the name the end user specified.',
'For example, the following code calls a function which replaces all "."''s with "_"''s in the DN string:</p>',
'',
'<p><pre>',
'return apex_custom_auth.ldap_dnprep(p_username => :USERNAME);',
'</pre></p>',
'',
'<p>&PRODUCT_NAME. will escape the returned username based on the authentication attribute <strong>Username Escaping</strong>.'))
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(361542827737906438)
,p_plugin_id=>wwv_flow_imp.id(361538211820906436)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Username Escaping'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'STD'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Before replacing <strong>%LDAP_USER%</strong> in the LDAP distinguished name and search string,',
'&PRODUCT_NAME. can automatically escape special characters in the username.',
'<p/>',
'The possible rules for escaping are:',
'<ul>',
'<li><strong>Standard</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Additionally, escape unicode characters.',
'This is the most secure setting, but may cause problems with some LDAP servers.</li>',
'<li><strong>Only special characters</strong>:',
'Escape special characters based on RFC 4514 (for distinguished names) and RFC 4515 (for search strings).',
'Do not escape unicode characters.</li>',
'<li><strong>No escaping</strong>:',
'Do not escape any characters.',
'This setting is potentially insecure,',
'unless a <strong>Username Edit Function</strong> is employed that already',
'escapes the username (for example with apex_escape.ldap_dn or apex_escape.ldap_search_filter).</li>',
'</ul>'))
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(361543237609906438)
,p_plugin_attribute_id=>wwv_flow_imp.id(361542827737906438)
,p_display_sequence=>10
,p_display_value=>'Standard'
,p_return_value=>'STD'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(361543718091906439)
,p_plugin_attribute_id=>wwv_flow_imp.id(361542827737906438)
,p_display_sequence=>20
,p_display_value=>'Only special characters'
,p_return_value=>'ONLY'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(361544225021906439)
,p_plugin_attribute_id=>wwv_flow_imp.id(361542827737906438)
,p_display_sequence=>30
,p_display_value=>'No Escaping'
,p_return_value=>'NO'
);
end;
/
prompt --application/shared_components/plugins/authentication_type/com_oracle_apex_authn_internal_sso
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(361579733902906466)
,p_plugin_type=>'AUTHENTICATION TYPE'
,p_name=>'COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'
,p_display_name=>'INTERNAL Oracle Application Server Single Sign-On'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('AUTHENTICATION TYPE','COM.ORACLE.APEX.AUTHN.INTERNAL.SSO'),'')
,p_api_version=>1
,p_ajax_function=>'wwv_flow_authentication_dev.plugin_callback_osso'
,p_session_sentry_function=>'wwv_flow_authentication_dev.plugin_sentry_osso'
,p_invalid_session_function=>'wwv_flow_authentication_dev.plugin_invalid_session_osso'
,p_authentication_function=>'wwv_flow_authentication_dev.plugin_authenticate_osso'
,p_post_logout_function=>'wwv_flow_authentication_dev.plugin_post_logout_osso'
,p_standard_attributes=>'LOGIN_PAGE'
,p_substitute_attributes=>true
,p_reference_id=>113750429890071859
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_listcalendar
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(1522394186038843824)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.LISTCALENDAR'
,p_display_name=>'List Calendar (Builder)'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.LISTCALENDAR'),'#IMAGE_PREFIX#plugins/com.oracle.apex.listcalendar/')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'procedure render_list_calendar( p_region in apex_plugin.t_region ) is',
'    c_date_col           constant varchar2(255) := p_region.attribute_01;',
'    c_color_col          constant varchar2(255) := p_region.attribute_02;',
'    c_title_col          constant varchar2(255) := p_region.attribute_03;',
'    c_link_col           constant varchar2(255) := p_region.attribute_04;',
'    c_row1_attr1_lbl_col constant varchar2(255) := p_region.attribute_05;',
'    c_row1_attr1_val_col constant varchar2(255) := p_region.attribute_06;',
'    c_row1_attr2_lbl_col constant varchar2(255) := p_region.attribute_07;',
'    c_row1_attr2_val_col constant varchar2(255) := p_region.attribute_08;',
'    c_row2_attr1_lbl_col constant varchar2(255) := p_region.attribute_09;',
'    c_row2_attr1_val_col constant varchar2(255) := p_region.attribute_10;',
'    c_row2_attr2_lbl_col constant varchar2(255) := p_region.attribute_11;',
'    c_row2_attr2_val_col constant varchar2(255) := p_region.attribute_12;',
'    c_description_1_col  constant varchar2(255) := p_region.attribute_13;',
'    c_description_2_col  constant varchar2(255) := p_region.attribute_14;',
'    c_description_3_col  constant varchar2(255) := p_region.attribute_15;',
'',
'    l_date_col_no           pls_integer;',
'    l_color_col_no          pls_integer;',
'    l_title_col_no          pls_integer;',
'    l_link_col_no           pls_integer;',
'    l_row1_attr1_lbl_col_no pls_integer;',
'    l_row1_attr1_val_col_no pls_integer;',
'    l_row1_attr2_lbl_col_no pls_integer;',
'    l_row1_attr2_val_col_no pls_integer;',
'    l_row2_attr1_lbl_col_no pls_integer;',
'    l_row2_attr1_val_col_no pls_integer;',
'    l_row2_attr2_lbl_col_no pls_integer;',
'    l_row2_attr2_val_col_no pls_integer;',
'    l_description_1_col_no  pls_integer;',
'    l_description_2_col_no  pls_integer;',
'    l_description_3_col_no  pls_integer;',
'',
'    l_date           timestamp with local time zone;',
'    l_color          varchar2(4000);',
'    l_color_hex      varchar2(4000);',
'    l_title          varchar2(4000);',
'    l_link           varchar2(4000);',
'    l_row1_attr1_lbl varchar2(4000);',
'    l_row1_attr1_val varchar2(4000);',
'    l_row1_attr2_lbl varchar2(4000);',
'    l_row1_attr2_val varchar2(4000);',
'    l_row2_attr1_lbl varchar2(4000);',
'    l_row2_attr1_val varchar2(4000);',
'    l_row2_attr2_lbl varchar2(4000);',
'    l_row2_attr2_val varchar2(4000);',
'    l_description_1  varchar2(4000);',
'    l_description_2  varchar2(4000);',
'    l_description_3  varchar2(4000);',
'',
'    --',
'    l_no_data_found     varchar2(32767) := p_region.no_data_found_message;',
'    l_num_rows          pls_integer     := p_region.fetched_rows;',
'    --',
'    l_column_value_list    apex_plugin_util.t_column_value_list2;',
'    l_region_source        varchar2(32767) := p_region.source;',
'',
'    --',
'    l_last_month  varchar2(255) := ''x'';',
'    l_this_year   varchar2(4)   := ''x'';',
'',
'    l_found boolean;',
'    l_count pls_integer := 0;',
'begin',
'    -- get the data to be displayed',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'                               p_sql_statement  => l_region_source,',
'                               p_min_columns    => 3,',
'                               p_max_columns    => null,',
'                               p_component_name => p_region.name,',
'                               p_max_rows       => null );',
'',
'    -- Get the actual column number for the fields we want.',
'    l_date_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Date column'',',
'                        p_column_alias      => c_date_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => true,',
'                        p_data_type         => null -- might be date, timestamp, etc.',
'                    );',
'',
'    l_color_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Color column'',',
'                        p_column_alias      => c_color_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => true,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_title_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Title column'',',
'                        p_column_alias      => c_title_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => true,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_link_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Link column'',',
'                        p_column_alias      => c_link_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr1_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''First Attribute Label column'',',
'                        p_column_alias      => c_row1_attr1_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr1_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''First Attribute Value column'',',
'                        p_column_alias      => c_row1_attr1_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr2_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Second Attribute Label column'',',
'                        p_column_alias      => c_row1_attr2_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row1_attr2_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Second Attribute Value column'',',
'                        p_column_alias      => c_row1_attr2_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr1_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Third Attribute Label column'',',
'                        p_column_alias      => c_row2_attr1_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr1_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Third Attribute Value column'',',
'                        p_column_alias      => c_row2_attr1_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr2_lbl_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Fourth Attribute Label column'',',
'                        p_column_alias      => c_row2_attr2_lbl_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_row2_attr2_val_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Fourth Attribute Value column'',',
'                        p_column_alias      => c_row2_attr2_val_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_description_1_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''First Description column'',',
'                        p_column_alias      => c_description_1_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_description_2_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Second Description column'',',
'                        p_column_alias      => c_description_2_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    l_description_3_col_no := apex_plugin_util.get_column_no (',
'                        p_attribute_label   => ''Third Description column (allows HTML)'',',
'                        p_column_alias      => c_description_3_col,',
'                        p_column_value_list => l_column_value_list,',
'                        p_is_required       => false,',
'                        p_data_type         => apex_plugin_util.c_data_type_varchar2',
'                    );',
'',
'    -- Loop through the data',
'',
'    sys.htp.p(''<div class="a-StatusList a-StatusList--dates">'');',
'',
'    for l_row_num in 1..l_column_value_list(1).value_list.count loop',
'        l_found := true;',
'',
'        if l_column_value_list(l_date_col_no).value_list(l_row_num).date_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).date_value;',
'        elsif l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_value;',
'        elsif l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_tz_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_tz_value;',
'        elsif l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_ltz_value is not null then',
'            l_date := l_column_value_list(l_date_col_no).value_list(l_row_num).timestamp_ltz_value;',
'        else',
'            -- Couldn''t get a usable date value; ignore this row.',
'            l_found := false;',
'        end if;',
'        if l_found = true and l_count < nvl(l_num_rows,l_count) then',
'            l_count := l_count + 1;',
'            if l_color_col_no is not null then',
'                l_color := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_color_col_no).data_type,',
'                                p_value     => l_column_value_list(l_color_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_title_col_no is not null then',
'                l_title := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_title_col_no).data_type,',
'                                p_value     => l_column_value_list(l_title_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_link_col_no is not null then',
'                l_link := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_link_col_no).data_type,',
'                                p_value     => l_column_value_list(l_link_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr1_lbl_col_no is not null then',
'                l_row1_attr1_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr1_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr1_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr1_val_col_no is not null then',
'                l_row1_attr1_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr1_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr1_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr2_lbl_col_no is not null then',
'                l_row1_attr2_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr2_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr2_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row1_attr2_val_col_no is not null then',
'                l_row1_attr2_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row1_attr2_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row1_attr2_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr1_lbl_col_no is not null then',
'                l_row2_attr1_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr1_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr1_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr1_val_col_no is not null then',
'                l_row2_attr1_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr1_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr1_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr2_lbl_col_no is not null then',
'                l_row2_attr2_lbl := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr2_lbl_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr2_lbl_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_row2_attr2_val_col_no is not null then',
'                l_row2_attr2_val := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_row2_attr2_val_col_no).data_type,',
'                                p_value     => l_column_value_list(l_row2_attr2_val_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_description_1_col_no is not null then',
'                l_description_1 := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_description_1_col_no).data_type,',
'                                p_value     => l_column_value_list(l_description_1_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_description_2_col_no is not null then',
'                l_description_2 := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_description_2_col_no).data_type,',
'                                p_value     => l_column_value_list(l_description_2_col_no).value_list(l_row_num) ),',
'                            p_region.escape_output );',
'            end if;',
'',
'            if l_description_3_col_no is not null then',
'                l_description_3 := apex_plugin_util.escape(',
'                            apex_plugin_util.get_value_as_varchar2(',
'                                p_data_type => l_column_value_list(l_description_3_col_no).data_type,',
'                                p_value     => l_column_value_list(l_description_3_col_no).value_list(l_row_num) ),',
'                            false );',
'            end if;',
'',
'            -- Limit it down to the colors we support.',
'            l_color := initcap(l_color);',
'            if l_color not in (''Red'',''Black'',''Yellow'',''Green'') then',
'                l_color_hex := l_color;',
'                l_color     := '''';',
'            else',
'                l_color_hex := '''';',
'            end if;',
'',
'            if l_color = ''Red'' then',
'                l_color := ''is-error'';',
'            elsif l_color = ''Black'' then',
'                l_color := ''is-complete'';',
'            elsif l_color = ''Yellow'' then',
'                l_color := ''is-warning'';',
'            elsif l_color = ''Green'' then',
'                l_color := ''is-open'';',
'            end if;',
'',
'            -- Start of the actual rendering code.',
'',
'            if l_last_month != to_char(l_date,''YYYYMM'') then',
'                l_last_month := to_char(l_date,''YYYYMM'');',
'',
'                if l_count > 1 then',
'                    -- Not the first row; close the previous group.',
'                    sys.htp.p(''</ul></div>'');',
'                end if;',
'',
'                sys.htp.p(''<div class="a-StatusList-block">'');',
'                -- if to_char(l_date,''YYYY'') != l_this_year then',
'                sys.htp.p(''<h3 class="a-StatusList-blockHeader"><span class="a-StatusList-headerTextPrimary">''||trim(to_char(l_date,''Month''))||',
'                    ''</span><span class="a-StatusList-headerTextAlt">''||to_char(l_date,''YYYY'')||''</span></h3>'');',
'                l_this_year := to_char(l_date,''YYYY'');',
'                -- else',
'                    -- sys.htp.p(''<h3>''||to_char(l_date,''Month'')||''</h3>'');',
'                -- end if;',
'                sys.htp.p(''<ul class="a-StatusList-list">'');',
'            end if;',
'',
'            sys.htp.p(''<li class="a-StatusList-item ''||l_color||''"><div class="a-StatusList-itemMarker"><span class="a-StatusList-marker" role="presentation">''',
'                ||to_char(l_date,''fmDD'')||''</span></div>'');',
'            -- if l_color is not null then',
'                -- sys.htp.p(''<div class="status''||l_color||''">'');',
'            -- else',
'                -- sys.htp.p(''<div style="border-left-color: ''||l_color_hex||''">'');',
'            -- end if;',
'            sys.htp.p(''<div class="a-StatusList-itemBody">'');',
'            sys.htp.p(''<p class="a-StatusList-itemTitle"><a href="''||apex_util.prepare_url(l_link)||''">''||l_title||''</a></p>'');',
'',
'            if l_row1_attr1_lbl is not null or l_row1_attr1_val is not null',
'                    or l_row1_attr2_lbl is not null or l_row1_attr2_val is not null then',
'                sys.htp.prn(''<div class="a-StatusList-itemAttrs">'');',
'                if l_row1_attr1_lbl is not null and l_row1_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row1_attr1_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row1_attr1_val||''</span></span>'');',
'                elsif l_row1_attr1_lbl is null and l_row1_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row1_attr1_val||''</span></span>'');',
'                elsif l_row1_attr1_lbl is not null and l_row1_attr1_val is null then',
'                    sys.htp.prn(''<span><span class="a-StatusList-attrLabel">''||l_row1_attr1_lbl||''</span></span>'');',
'                else',
'                    -- No attr1.',
'                    null;',
'                end if;',
'',
'                if l_row1_attr2_lbl is not null and l_row1_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row1_attr2_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row1_attr2_val||''</span></span>'');',
'                elsif l_row1_attr2_lbl is null and l_row1_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row1_attr2_val||''</span></span>'');',
'                elsif l_row1_attr2_lbl is not null and l_row1_attr2_val is null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row1_attr2_lbl||''</span></span>'');',
'                else',
'                    -- No attr2.',
'                    null;',
'                end if;',
'                -- sys.htp.prn(''</div>'');',
'            end if;',
'',
'            if l_row2_attr1_lbl is not null or l_row2_attr1_val is not null',
'                    or l_row2_attr2_lbl is not null or l_row2_attr2_val is not null then',
'                -- sys.htp.prn(''<p>'');',
'                if l_row2_attr1_lbl is not null and l_row2_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr1_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row2_attr1_val||''</span></span>'');',
'                elsif l_row2_attr1_lbl is null and l_row2_attr1_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row2_attr1_val||''</span></span>'');',
'                elsif l_row2_attr1_lbl is not null and l_row2_attr1_val is null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr1_lbl||''</span></span>'');',
'                else',
'                    -- No attr3.',
'                    null;',
'                end if;',
'',
'                if l_row2_attr2_lbl is not null and l_row2_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr2_lbl||''</span> ''',
'                        ||''<span class="a-StatusList-attrValue">''||l_row2_attr2_val||''</span></span>'');',
'                elsif l_row2_attr2_lbl is null and l_row2_attr2_val is not null then',
'                    sys.htp.prn(''<span class="a-StatusList-attrValue">''||l_row2_attr2_val||''</span></span>'');',
'                elsif l_row2_attr2_lbl is not null and l_row2_attr2_val is null then',
'                    sys.htp.prn(''<span class="a-StatusList-attr"><span class="a-StatusList-attrLabel">''||l_row2_attr2_lbl||''</span></span>'');',
'                else',
'                    -- No attr4.',
'                    null;',
'                end if;',
'                sys.htp.prn(''</div>'');',
'            end if;',
'',
'            if l_description_1 is not null then',
'                sys.htp.prn(''<p class="a-StatusList-textDesc">''||l_description_1||''</p>'');',
'            end if;',
'',
'            if l_description_2 is not null then',
'                sys.htp.prn(''<p class="a-StatusList-textDesc">''||l_description_2||''</p>'');',
'            end if;',
'',
'            if l_description_3 is not null then',
'                sys.htp.prn(''<p class="a-StatusList-textDesc">''||l_description_3||''</p>'');',
'            end if;',
'',
'            sys.htp.prn(''</div></li>'');',
'        end if;',
'    end loop;',
'    if l_count > 0 then',
'        -- Close the HTML.',
'        sys.htp.p(''</ul></div>'');',
'    else',
'        sys.htp.p(''<span class="nodatafound">''||l_no_data_found||''</span>'');',
'    end if;',
'    sys.htp.p(''</div>'');',
'end render_list_calendar;',
'',
'function render ( p_region in apex_plugin.t_region,',
'    p_plugin in apex_plugin.t_plugin, p_is_printer_friendly in boolean )',
'    return apex_plugin.t_region_render_result is',
'begin',
'    render_list_calendar( p_region );',
'    return null;',
'end;'))
,p_api_version=>1
,p_render_function=>'render'
,p_standard_attributes=>'SOURCE_SQL:FETCHED_ROWS:NO_DATA_FOUND_MESSAGE:ESCAPE_OUTPUT'
,p_substitute_attributes=>true
,p_reference_id=>1517592169582192572
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
,p_files_version=>3
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396073891043383619)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Date column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'DATE:TIMESTAMP:TIMESTAMP_TZ:TIMESTAMP_LTZ'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396074282467383619)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Color column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396074605776383619)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Title column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>true
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396075016196383619)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Link column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396075429885383619)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'First Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396075877026383621)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'First Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396076209073383622)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Second Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396076606102383622)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Second Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396077103994383622)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>9
,p_display_sequence=>90
,p_prompt=>'Third Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396077425924383623)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>10
,p_display_sequence=>100
,p_prompt=>'Third Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396077848416383623)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>11
,p_display_sequence=>110
,p_prompt=>'Fourth Attribute Label column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396078237202383623)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>12
,p_display_sequence=>120
,p_prompt=>'Fourth Attribute Value column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
end;
/
begin
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396078564095383623)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>13
,p_display_sequence=>130
,p_prompt=>'First Description column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396079002274383623)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>14
,p_display_sequence=>140
,p_prompt=>'Second Description column'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2396079329774383623)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>15
,p_display_sequence=>150
,p_prompt=>'Third Description column (allows HTML)'
,p_attribute_type=>'REGION SOURCE COLUMN'
,p_is_required=>false
,p_column_data_types=>'VARCHAR2'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_std_attribute(
 p_id=>wwv_flow_imp.id(849917626128293237)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_name=>'SOURCE_SQL'
,p_sql_min_column_count=>3
);
end;
/
begin
wwv_flow_imp.g_varchar2_table := wwv_flow_imp.empty_varchar2_table;
wwv_flow_imp.g_varchar2_table(1) := '6469762E74696D656C696E655374617475734C6973747B706F736974696F6E3A72656C61746976653B626F726465722D746F703A31707820736F6C696420234343437D0D0A6469762E74696D656C696E655374617475734C6973743A66697273742D6368';
wwv_flow_imp.g_varchar2_table(2) := '696C647B626F726465722D746F703A6E6F6E657D0D0A6469762E74696D656C696E655374617475734C6973742E7465787448656164696E67732068337B706F736974696F6E3A7374617469633B626F726465722D626F74746F6D3A31707820736F6C6964';
wwv_flow_imp.g_varchar2_table(3) := '20234545453B6261636B67726F756E642D636F6C6F723A234638463846387D0D0A6469762E74696D656C696E655374617475734C6973742E7465787448656164696E677320756C206C69207370616E2E6974656D446174657B70616464696E673A307D0D';
wwv_flow_imp.g_varchar2_table(4) := '0A6469762E74696D656C696E655374617475734C6973742068337B706F736974696F6E3A6162736F6C7574653B746F703A303B6C6566743A303B636C6561723A626F74683B666F6E743A626F6C6420313370782F3136707820417269616C2C2073616E73';
wwv_flow_imp.g_varchar2_table(5) := '2D73657269663B636F6C6F723A233430343034303B70616464696E673A3870787D0D0A6469762E74696D656C696E655374617475734C69737420756C7B6C6973742D7374796C653A6E6F6E653B6D617267696E3A303B646973706C61793A7461626C653B';
wwv_flow_imp.g_varchar2_table(6) := '77696474683A313030257D0D0A6469762E74696D656C696E655374617475734C69737420756C206C697B646973706C61793A7461626C652D726F777D0D0A6469762E74696D656C696E655374617475734C69737420756C206C693A66697273742D636869';
wwv_flow_imp.g_varchar2_table(7) := '6C643E6469767B626F726465722D746F703A6E6F6E657D0D0A6469762E74696D656C696E655374617475734C69737420756C206C693A686F7665723E6469767B6261636B67726F756E642D636F6C6F723A234638463846387D0D0A6469762E74696D656C';
wwv_flow_imp.g_varchar2_table(8) := '696E655374617475734C69737420756C206C69207370616E2E6974656D446174657B666F6E743A6E6F726D616C20313370782F3136707820417269616C2C2073616E732D73657269663B70616464696E673A38707820387078203870782031303070783B';
wwv_flow_imp.g_varchar2_table(9) := '746578742D616C69676E3A72696768743B77686974652D73706163653A6E6F777261703B646973706C61793A7461626C652D63656C6C3B77696474683A323470783B636F6C6F723A233630363036307D0D0A6469762E74696D656C696E65537461747573';
wwv_flow_imp.g_varchar2_table(10) := '4C69737420756C206C69206469767B2D7765626B69742D7472616E736974696F6E3A6261636B67726F756E642D636F6C6F722C302E31733B2D6D6F7A2D7472616E736974696F6E3A6261636B67726F756E642D636F6C6F722C302E31733B7472616E7369';
wwv_flow_imp.g_varchar2_table(11) := '74696F6E3A6261636B67726F756E642D636F6C6F722C302E31733B646973706C61793A7461626C652D63656C6C3B626F726465722D746F703A31707820736F6C696420234545453B626F726465722D6C6566743A34707820736F6C696420234630463046';
wwv_flow_imp.g_varchar2_table(12) := '307D0D0A6469762E74696D656C696E655374617475734C69737420756C206C69206469763E7370616E2E6974656D446573637B70616464696E673A3870783B646973706C61793A626C6F636B7D0D0A6469762E74696D656C696E655374617475734C6973';
wwv_flow_imp.g_varchar2_table(13) := '7420756C206C69206469762E737461747573477265656E7B626F726465722D6C6566742D636F6C6F723A233243433232347D0D0A6469762E74696D656C696E655374617475734C69737420756C206C69206469762E7374617475735265647B626F726465';
wwv_flow_imp.g_varchar2_table(14) := '722D6C6566742D636F6C6F723A234542334534357D0D0A6469762E74696D656C696E655374617475734C69737420756C206C69206469762E73746174757359656C6C6F777B626F726465722D6C6566742D636F6C6F723A236663636433317D0D0A646976';
wwv_flow_imp.g_varchar2_table(15) := '2E74696D656C696E655374617475734C69737420756C206C69206469762E737461747573477261797B626F726465722D6C6566742D636F6C6F723A234430443044307D0D0A6469762E74696D656C696E655374617475734C69737420756C206C69206469';
wwv_flow_imp.g_varchar2_table(16) := '762E737461747573426C61636B7B626F726465722D6C6566742D636F6C6F723A233430343034307D0D0A6469762E74696D656C696E655374617475734C69737420756C206C6920646976207370616E2E6974656D446573633E68347B666F6E743A626F6C';
wwv_flow_imp.g_varchar2_table(17) := '6420313370782F3136707820417269616C2C2073616E732D73657269663B636F6C6F723A233430343034307D0D0A6469762E74696D656C696E655374617475734C69737420756C206C6920646976207370616E2E6974656D446573633E707B666F6E743A';
wwv_flow_imp.g_varchar2_table(18) := '6E6F726D616C20313170782F3136707820417269616C2C2073616E732D73657269663B636F6C6F723A233630363036303B6D617267696E3A3270782030203020303B70616464696E673A307D0D0A6469762E74696D656C696E655374617475734C697374';
wwv_flow_imp.g_varchar2_table(19) := '20756C206C6920646976207370616E2E6974656D446573633E70207370616E7B6D617267696E2D72696768743A313670787D0D0A2E6E6F2D63737333206469762E74696D656C696E655374617475734C69737420756C206C6920646976207370616E2E69';
wwv_flow_imp.g_varchar2_table(20) := '74656D446573637B626F726465722D6C6566743A34707820736F6C696420234630463046307D0D0A2E6E6F2D63737333206469762E74696D656C696E655374617475734C69737420756C206C69206469762E737461747573477265656E3E7370616E2E69';
wwv_flow_imp.g_varchar2_table(21) := '74656D446573637B626F726465722D636F6C6F723A233030434330307D0D0A2E6E6F2D63737333206469762E74696D656C696E655374617475734C69737420756C206C69206469762E7374617475735265643E7370616E2E6974656D446573637B626F72';
wwv_flow_imp.g_varchar2_table(22) := '6465722D636F6C6F723A234545323232327D0D0A2E6E6F2D63737333206469762E74696D656C696E655374617475734C69737420756C206C69206469762E73746174757359656C6C6F773E7370616E2E6974656D446573637B626F726465722D636F6C6F';
wwv_flow_imp.g_varchar2_table(23) := '723A234646433830307D0D0A2E6E6F2D63737333206469762E74696D656C696E655374617475734C69737420756C206C69206469762E737461747573477261793E7370616E2E6974656D446573637B626F726465722D636F6C6F723A234343437D0D0A2E';
wwv_flow_imp.g_varchar2_table(24) := '6E6F2D63737333206469762E74696D656C696E655374617475734C69737420756C206C69206469762E737461747573426C61636B3E7370616E2E6974656D446573637B626F726465722D636F6C6F723A233333337D0D0A2E696537206469762E74696D65';
wwv_flow_imp.g_varchar2_table(25) := '6C696E655374617475734C69737420756C7B6D617267696E2D6C6566743A31303070787D0D0A2E696537206469762E74696D656C696E655374617475734C69737420756C206C697B7A6F6F6D3A313B766572746963616C2D616C69676E3A626F74746F6D';
wwv_flow_imp.g_varchar2_table(26) := '3B706F736974696F6E3A72656C61746976653B70616464696E672D6C6566743A323470783B77696474683A6175746F7D0D0A2E696537206469762E74696D656C696E655374617475734C69737420756C206C69207370616E2E6974656D446174657B6469';
wwv_flow_imp.g_varchar2_table(27) := '73706C61793A626C6F636B3B77696474683A313670783B70616464696E673A387078203870782038707820303B706F736974696F6E3A6162736F6C7574653B6C6566743A303B746F703A307D';
null;
end;
/
begin
wwv_flow_imp_shared.create_plugin_file(
 p_id=>wwv_flow_imp.id(2396080375438383625)
,p_plugin_id=>wwv_flow_imp.id(1522394186038843824)
,p_file_name=>'listcalendar.css'
,p_mime_type=>'text/css'
,p_file_charset=>'utf-8'
,p_file_content=>wwv_flow_imp.varchar2_to_blob(wwv_flow_imp.g_varchar2_table)
);
end;
/
prompt --application/shared_components/plugins/region_type/com_oracle_apex_tag_cloud
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(1821820281896950874)
,p_plugin_type=>'REGION TYPE'
,p_name=>'COM.ORACLE.APEX.TAG_CLOUD'
,p_display_name=>'Tag Cloud 2'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('REGION TYPE','COM.ORACLE.APEX.TAG_CLOUD'),'')
,p_plsql_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function render (',
'    p_region              in apex_plugin.t_region,',
'    p_plugin              in apex_plugin.t_plugin,',
'    p_is_printer_friendly in boolean )',
'    return apex_plugin.t_region_render_result',
'is',
'    -- Constants for the columns of our region source query',
'    c_tag_col   constant pls_integer := 1;',
'    c_count_col constant pls_integer := 2;',
'',
'    -- attributes of the plug-in',
'    l_target_url           varchar2(4000)  := p_region.attribute_01;',
'    l_max_display_tags     number          := p_region.attribute_02;',
'    l_show_count           boolean         := nvl(p_region.attribute_03,''Y'') = ''Y'';',
'',
'',
'    l_valid_data_type_list wwv_flow_global.vc_arr2;',
'    l_column_value_list    apex_plugin_util.t_column_value_list2;',
'    l_printed_records    number := 0;',
'    l_available_records  number := 20;',
'    l_max                number;',
'    l_min                number;',
'    l_total              number := 0;',
'    l_cnts               number;',
'    l_tag                varchar2(4000);',
'',
'    l_class_size         number;',
'    l_class              varchar2(30);',
'',
'begin',
'    -- don''t need to load css file, styles are contained within theme_42',
'    ',
'    -- apex_css.add_file (',
'    --     p_name      => ''tag_cloud'',',
'    --     p_directory => p_plugin.file_prefix,',
'    --     p_version   => null );',
'',
'',
'    -- define the valid column data types for the region query',
'    l_valid_data_type_list(c_tag_col) := apex_plugin_util.c_data_type_varchar2;',
'    l_valid_data_type_list(c_count_col) := apex_plugin_util.c_data_type_number;',
'',
'    -- get the data to be displayed',
'    l_column_value_list := apex_plugin_util.get_data2 (',
'                               p_sql_statement  => p_region.source,',
'                               p_min_columns    => 2,',
'                               p_max_columns    => 2,',
'                               p_data_type_list => l_valid_data_type_list,',
'                               p_component_name => p_region.name );',
'',
'   l_available_records := l_column_value_list(c_tag_col).value_list.count;',
'',
'   -----------------------------------------------',
'   -- Determine total count and maximum tag counts',
'   --',
'   l_max := 0;',
'   l_min := 1000;',
'   FOR i in 1.. l_column_value_list(c_count_col).value_list.count loop',
'      l_cnts := l_column_value_list(c_count_col).value_list(i).number_value;',
'      l_total := l_total + l_cnts;',
'      if l_cnts > l_max then',
'         l_max := l_cnts;',
'      end if;',
'      if l_cnts < l_min then',
'         l_min := l_cnts;',
'      end if;',
'   end loop;',
'   if l_max = 0 then l_max := 1; end if;',
'',
'',
'   l_class_size := round((l_max-l_min)/6);',
'',
'   ------------------------',
'   -- Generate tag cloud --',
'   --',
'   ',
'   sys.htp.prn(''<ul class="a-TagCloud">'');',
'',
'   for i in 1.. l_column_value_list(c_tag_col).value_list.count loop',
'       l_printed_records := l_printed_records + 1;',
'       l_tag := sys.htf.escape_sc(l_column_value_list(c_tag_col).value_list(i).varchar2_value);',
'       l_cnts := l_column_value_list(c_count_col).value_list(i).number_value;',
'       if l_cnts < l_min + l_class_size then',
'          l_class := ''size1'';',
'       elsif l_cnts < l_min + (l_class_size*2) then',
'          l_class := ''size2'';',
'       elsif l_cnts < l_min + (l_class_size*3) then',
'          l_class := ''size3'';',
'       elsif l_cnts < l_min + (l_class_size*4) then',
'          l_class := ''size4'';',
'       elsif l_cnts < l_min + (l_class_size*5) then',
'          l_class := ''size5'';',
'       else l_class := ''size6'';',
'       end if;      ',
'       ',
'        sys.htp.prn(''<li class="a-TagCloud-item">''',
'            ||apex_plugin_util.get_link(',
'                p_url  => replace(l_target_url,''#TAG#'',l_tag),',
'                p_text => l_tag',
'                            ||case when l_show_count then',
'                                '' <span class="a-TagCloud-count">''||l_cnts||''</span>''',
'                            end,',
'                p_escape_text => false,',
'                p_attributes => ''class="a-TagCloud-link a-TagCloud-link--''',
'                    ||l_class||''"'')',
'            ||''</li>'');',
'',
'       if  l_printed_records > l_max_display_tags then',
'           exit;',
'       end if;',
'   end loop;',
'',
'   sys.htp.prn(''</ul>'');',
'',
'   return null;',
'end render;'))
,p_api_version=>1
,p_render_function=>'render'
,p_standard_attributes=>'SOURCE_SQL'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_version_identifier=>'1.0'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(1821852462681983135)
,p_plugin_id=>wwv_flow_imp.id(1821820281896950874)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Target URL'
,p_attribute_type=>'TEXT'
,p_is_required=>true
,p_default_value=>'f?p=&APP_ID.:2:&APP_SESSION.::::P2_FILTER:#TAG#'
,p_display_length=>60
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(1821853862466992590)
,p_plugin_id=>wwv_flow_imp.id(1821820281896950874)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Maximum Displayed Tags'
,p_attribute_type=>'INTEGER'
,p_is_required=>false
,p_display_length=>4
,p_max_length=>4
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(1821854673201995705)
,p_plugin_id=>wwv_flow_imp.id(1821820281896950874)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Show Count'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
);
wwv_flow_imp_shared.create_plugin_std_attribute(
 p_id=>wwv_flow_imp.id(849917909106293242)
,p_plugin_id=>wwv_flow_imp.id(1821820281896950874)
,p_name=>'SOURCE_SQL'
,p_is_required=>false
,p_sql_min_column_count=>2
,p_sql_max_column_count=>2
);
end;
/
prompt --application/shared_components/plugins/dynamic_action/com_oracle_apex_add_checkall_checkbox
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(2080239482051425991)
,p_plugin_type=>'DYNAMIC ACTION'
,p_name=>'COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'
,p_display_name=>'Add Check All Checkbox'
,p_category=>'MISC'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('DYNAMIC ACTION','COM.ORACLE.APEX.ADD_CHECKALL_CHECKBOX'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_add_check_all_checkbox'
,p_standard_attributes=>'ONLOAD'
,p_substitute_attributes=>true
,p_reference_id=>1223290239742970512
,p_subscribe_plugin_settings=>true
,p_help_text=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>The "Add Check All Checkbox" dynamic action turns a column heading containing the #CHECK_ALL_CHECKBOX# string into an accessible check all style checkbox, that will check and uncheck all the checkboxes in its corresponding column.<p>',
'<p>',
'To use this plug-in, please ensure the following attributes are set:',
'<ol>',
'<li>In the report column, defined ''#CHECK_ALL_CHECKBOX#'' as the Heading value.</li>',
'<li>For the Dynamic Action When attribute, select the report region containing the column.</li>',
'<li>Define the Dynamic Action to fire ''After Refresh'', and the Action to ''Fire on Page Load''. (Both will default appropriately if the Dynamic Action is created by selecting the region in the ''Rendering'' section of Page Designer and creating the Dynam'
||'ic Action from there.</li>',
'<li>This will not handle the accessibility of the checkboxes rendered on each row, this must be done separately in the region source. (See 4000:656 ''Regions'' region for an example).</li>',
'</ol>',
'</p>'))
,p_version_identifier=>'1.0'
);
end;
/
prompt --application/shared_components/plugins/item_type/com_oracle_apex_advanced_auto_complete
begin
wwv_flow_imp_shared.create_plugin(
 p_id=>wwv_flow_imp.id(2689778454340234650)
,p_plugin_type=>'ITEM TYPE'
,p_name=>'COM_ORACLE_APEX_ADVANCED_AUTO_COMPLETE'
,p_display_name=>'Advanced Autocomplete'
,p_supported_ui_types=>'DESKTOP'
,p_supported_component_types=>'APEX_APPLICATION_PAGE_ITEMS'
,p_image_prefix => nvl(wwv_flow_application_install.get_static_plugin_file_prefix('ITEM TYPE','COM_ORACLE_APEX_ADVANCED_AUTO_COMPLETE'),'')
,p_api_version=>1
,p_render_function=>'wwv_flow_f4000_plugins.render_advanced_auto_complete'
,p_ajax_function=>'wwv_flow_f4000_plugins.ajax_advanced_auto_complete'
,p_validation_function=>'wwv_flow_f4000_plugins.validate_advanced_auto_compl'
,p_standard_attributes=>'VISIBLE:FORM_ELEMENT:SESSION_STATE:READONLY:ESCAPE_OUTPUT:SOURCE:ELEMENT:WIDTH:ENCRYPT:LOV:CASCADING_LOV'
,p_substitute_attributes=>true
,p_subscribe_plugin_settings=>true
,p_help_text=>'<br />'
,p_version_identifier=>'1.0'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2689787645364459113)
,p_plugin_id=>wwv_flow_imp.id(2689778454340234650)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>1
,p_display_sequence=>10
,p_prompt=>'Search'
,p_attribute_type=>'SELECT LIST'
,p_is_required=>true
,p_default_value=>'CONTAINS_IGNORE'
,p_is_translatable=>false
,p_lov_type=>'STATIC'
,p_help_text=>'<p>Defines how the search with the entered value should be performed. When using &quot;Lazy Loading&quot; this setting can have an impact on query performance. Contains and/or Ignore Case will prevent the use of an existing index on the column.</p>'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(2340837999983480152)
,p_plugin_attribute_id=>wwv_flow_imp.id(2689787645364459113)
,p_display_sequence=>10
,p_display_value=>'Contains & Case Sensitive'
,p_return_value=>'CONTAINS_CASE'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(2340838092593480152)
,p_plugin_attribute_id=>wwv_flow_imp.id(2689787645364459113)
,p_display_sequence=>20
,p_display_value=>'Exact & Case Sensitive'
,p_return_value=>'EXACT_CASE'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(2340838186030480152)
,p_plugin_attribute_id=>wwv_flow_imp.id(2689787645364459113)
,p_display_sequence=>30
,p_display_value=>'Contains & Ignore Case'
,p_return_value=>'CONTAINS_IGNORE'
);
wwv_flow_imp_shared.create_plugin_attr_value(
 p_id=>wwv_flow_imp.id(2340838291521480153)
,p_plugin_attribute_id=>wwv_flow_imp.id(2689787645364459113)
,p_display_sequence=>40
,p_display_value=>'Exact & Ignore Case'
,p_return_value=>'EXACT_IGNORE'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2689788542725467853)
,p_plugin_id=>wwv_flow_imp.id(2689778454340234650)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>2
,p_display_sequence=>20
,p_prompt=>'Only Values from List'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_help_text=>'<p>If set to yes, the autocompleter will only allow to enter values which are returned by the SQL statement. Not existing values will result in an empty input box when leaving the field.</p>'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2689789327618472986)
,p_plugin_id=>wwv_flow_imp.id(2689778454340234650)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>3
,p_display_sequence=>30
,p_prompt=>'Separator for Multi-Selection'
,p_attribute_type=>'TEXT'
,p_is_required=>false
,p_display_length=>2
,p_max_length=>2
,p_is_translatable=>false
,p_help_text=>'<p>If defined, the textfield allows to select multiple values. The entered value will be used as a separator  between the values.</p>'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2689791540216486008)
,p_plugin_id=>wwv_flow_imp.id(2689778454340234650)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>4
,p_display_sequence=>40
,p_prompt=>'Lazy Loading'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_help_text=>'<p>If set to yes, the matching values will be read from the database each time the user types a character. If set to no, all values will be read only once when the page is rendered.</p>'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2689792554761490224)
,p_plugin_id=>wwv_flow_imp.id(2689778454340234650)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>5
,p_display_sequence=>50
,p_prompt=>'Maximum Values in List'
,p_attribute_type=>'NUMBER'
,p_is_required=>false
,p_display_length=>3
,p_max_length=>3
,p_is_translatable=>false
,p_help_text=>'<p>Limits the number of items in the select box to avoid performance problems by returning to many rows.</p>'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2689789940778476717)
,p_plugin_id=>wwv_flow_imp.id(2689778454340234650)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>6
,p_display_sequence=>60
,p_prompt=>'Automatic Fill'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'N'
,p_is_translatable=>false
,p_help_text=>'<p>Fill the textfield while still selecting a value, replacing the value if more is typed or something else is selected.</p>'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2689790830174483173)
,p_plugin_id=>wwv_flow_imp.id(2689778454340234650)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>7
,p_display_sequence=>70
,p_prompt=>'Select First'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'<p>If this is set, the first autocomplete value will be automatically selected on tab/return, even if it has not been handpicked by keyboard or mouse action. If there is a handpicked (highlighted) result, that result will take precedence.</p>'
);
wwv_flow_imp_shared.create_plugin_attribute(
 p_id=>wwv_flow_imp.id(2689793135845494212)
,p_plugin_id=>wwv_flow_imp.id(2689778454340234650)
,p_attribute_scope=>'COMPONENT'
,p_attribute_sequence=>8
,p_display_sequence=>80
,p_prompt=>'Highlight Search'
,p_attribute_type=>'CHECKBOX'
,p_is_required=>false
,p_default_value=>'Y'
,p_is_translatable=>false
,p_help_text=>'<p>Defines if the entered value is highlighted in the select box of matching entries.</p>'
);
wwv_flow_imp_shared.create_plugin_std_attribute(
 p_id=>wwv_flow_imp.id(849918180332293245)
,p_plugin_id=>wwv_flow_imp.id(2689778454340234650)
,p_name=>'LOV'
,p_sql_min_column_count=>1
,p_sql_max_column_count=>2
,p_depending_on_has_to_exist=>true
,p_examples=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>',
'<strong>Example 1: Display and store same value in page item</strong>',
'<pre>',
'SELECT ename FROM emp ORDER by 1',
'</pre>',
'</p>',
'',
'<p>',
'<strong>Example 2: Display ENAME but store EMPNO in page item</strong>',
'<pre>',
'SELECT ename d, empno r FROM emp ORDER BY 1',
'</pre>',
'</p>',
'',
'<p>',
'<strong>Example 3: Display employees of a specific department by using a bind variable</strong>',
'<pre>',
'SELECT ename FROM emp WHERE deptno = :P3_DEPTNO ORDER by 1',
'</pre>',
'</p>',
'',
'<p>',
'<strong>Example 4: Static list examples</strong>',
'<ul>',
'<li>STATIC:Cow,Dog,Cat,Lion (will be sorted alphabetically)</li>',
'<li>STATIC2:10,15,20,25,50,100,200,500,1000,10000 (sorted in order of creation)</li>',
'</ul>',
'</p>'))
);
end;
/
prompt --application/user_interfaces
begin
wwv_flow_imp_shared.create_user_interface(
 p_id=>wwv_flow_imp.id(9728334451760999)
,p_ui_type_name=>'DESKTOP'
,p_display_name=>'Desktop'
,p_display_seq=>10
,p_use_auto_detect=>true
,p_is_default=>true
,p_theme_id=>101
,p_home_url=>'f?p=&APP_ID.:1:&SESSION.'
,p_login_url=>'f?p=4550:1:&SESSION.'
,p_theme_style_by_user_pref=>false
,p_global_page_id=>0
,p_navigation_list_template_id=>wwv_flow_imp.id(389919542813170530)
,p_nav_list_template_options=>'#DEFAULT#'
,p_include_legacy_javascript=>'PRE18:18'
,p_nav_bar_type=>'NAVBAR'
,p_nav_bar_template_options=>'#DEFAULT#'
);
end;
/
prompt --application/user_interfaces/combined_files
begin
null;
end;
/
prompt --application/pages/page_00000
begin
wwv_flow_imp_page.create_page(
 p_id=>0
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Global Page'
,p_step_title=>'0'
,p_reload_on_submit=>'A'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'ON'
,p_page_template_options=>'#DEFAULT#'
,p_nav_list_template_options=>'#DEFAULT#'
,p_page_component_map=>'14'
,p_last_upd_yyyymmddhh24miss=>'20220228083221'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(21040795940063799)
,p_plug_name=>'Quick Links'
,p_region_name=>'issues_jump'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>350
,p_plug_display_point=>'REGION_POSITION_04'
,p_list_id=>wwv_flow_imp.id(5181728677916157)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_imp.id(5208269691267696)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(393161701706868148)
,p_plug_name=>'APEX 5 - Header'
,p_region_css_classes=>'a-Header apex-team-dev'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(393161820752868148)
,p_plug_name=>'APEX 5 - Header Left'
,p_parent_plug_id=>wwv_flow_imp.id(393161701706868148)
,p_region_css_classes=>'a-Header-col a-Header-col--left'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>20
,p_plug_display_point=>'SUB_REGIONS'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(42604339764717849)
,p_plug_name=>'APEX 5 - Tabs'
,p_region_name=>'a_Header_menu'
,p_parent_plug_id=>wwv_flow_imp.id(393161820752868148)
,p_region_css_classes=>'a-Header-tabsContainer'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display: none;"'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>60
,p_plug_display_point=>'SUB_REGIONS'
,p_plug_item_display_point=>'BELOW'
,p_list_id=>wwv_flow_imp.id(5251802537036599)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_imp.id(389919542813170530)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(393162297665868148)
,p_plug_name=>'APEX 5 - Logo'
,p_parent_plug_id=>wwv_flow_imp.id(393161820752868148)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>40
,p_plug_display_point=>'SUB_REGIONS'
,p_plug_source=>'sys.htp.p(''<a href="''||apex_util.prepare_url(''f?p=4500:1000:''||:APP_SESSION||''::''||:DEBUG||''::::'')||''" class="a-Header-logo" title="''||wwv_flow_lang.system_message(''HOME_NAV'')||''"><span class="a-Header-apexLogo"></span></a>'');'
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(393162044284868148)
,p_plug_name=>'APEX 5 - Header Right'
,p_parent_plug_id=>wwv_flow_imp.id(393161701706868148)
,p_region_css_classes=>'a-Header-col a-Header-col--right'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>30
,p_plug_display_point=>'SUB_REGIONS'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(393162683062868149)
,p_plug_name=>'APEX 5 - Header Navigation Links'
,p_parent_plug_id=>wwv_flow_imp.id(393162044284868148)
,p_region_css_classes=>'a-Header-navLinks'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>20
,p_plug_display_point=>'SUB_REGIONS'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(393280012828677060)
,p_plug_name=>'APEX 5 - Administration Menu'
,p_region_name=>'adminMenu'
,p_parent_plug_id=>wwv_flow_imp.id(393162683062868149)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>70
,p_plug_display_point=>'SUB_REGIONS'
,p_list_id=>wwv_flow_imp.id(702381952631922533)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_imp.id(5208269691267696)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(491531548304760390)
,p_plug_name=>'APEX 5 - Help Menu'
,p_region_name=>'helpMenu'
,p_parent_plug_id=>wwv_flow_imp.id(393162683062868149)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>80
,p_plug_display_point=>'SUB_REGIONS'
,p_list_id=>wwv_flow_imp.id(702386956612924063)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_imp.id(5208269691267696)
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(393162851516868149)
,p_plug_name=>'APEX 5 - Account'
,p_parent_plug_id=>wwv_flow_imp.id(393162044284868148)
,p_region_css_classes=>'a-Header-account'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>30
,p_plug_display_point=>'SUB_REGIONS'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_4000_ui.account_mega_menu (',
'    p_username          => :APP_USER,',
'    p_workspace_id      => :WORKSPACE_ID,',
'    p_session           => :APP_SESSION,',
'    p_logout_url        => :LOGOUT_URL',
');'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(393280813800685819)
,p_plug_name=>'APEX 5 - Control Bar'
,p_region_css_classes=>'a-ControlBar apex-team-dev'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>310
,p_plug_display_point=>'REGION_POSITION_07'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(393281636948687250)
,p_plug_name=>'APEX 5 - Control Bar Left'
,p_parent_plug_id=>wwv_flow_imp.id(393280813800685819)
,p_region_css_classes=>'a-ControlBar-col a-ControlBar-col--noPadding'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>320
,p_plug_display_point=>'SUB_REGIONS'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(393283583382701129)
,p_plug_name=>'APEX 5 - Breadcrumb'
,p_parent_plug_id=>wwv_flow_imp.id(393281636948687250)
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_display_sequence=>1
,p_plug_display_point=>'SUB_REGIONS'
,p_menu_id=>wwv_flow_imp.id(92331531826187224)
,p_plug_source_type=>'NATIVE_BREADCRUMB'
,p_menu_template_id=>wwv_flow_imp.id(5208262300686444)
,p_translate_title=>'N'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(393281844168687250)
,p_plug_name=>'APEX 5 - Control Bar Right'
,p_parent_plug_id=>wwv_flow_imp.id(393280813800685819)
,p_region_css_classes=>'a-ControlBar-col'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>330
,p_plug_display_point=>'SUB_REGIONS'
,p_translate_title=>'N'
,p_plug_query_num_rows=>15
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'N'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(735034047355168735)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(393162683062868149)
,p_button_name=>'UPGRADE_AVAILABLE'
,p_button_static_id=>'header-upgradeAvailable'
,p_button_action=>'REDIRECT_APP'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(359238865408012460)
,p_button_image_alt=>'Upgrade Available'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'f?p=4000:78:&SESSION.:UPGRADE_AVAILABLE:&DEBUG.:78::'
,p_button_condition=>'wwv_flow_cloud_db_services.get_upgrade_status().state = ''SCHEDULED'''
,p_button_condition2=>'PLSQL'
,p_button_condition_type=>'EXPRESSION'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-calendar u-info-text'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5948435972329309)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(393281844168687250)
,p_button_name=>'NOTIFICATIONS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(5208338701524668)
,p_button_image_alt=>'Notifications'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:502:&SESSION.::&DEBUG.:RP::'
,p_icon_css_classes=>'fa fa-bell-o'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(735033923883168734)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(393162683062868149)
,p_button_name=>'UPGRADE_IN_PROGRESS'
,p_button_static_id=>'header-upgradeInProgress'
,p_button_action=>'REDIRECT_APP'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(359238865408012460)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Upgrade In Progress'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'f?p=4000:78:&SESSION.:UPGRADE_IN_PROGRESS:&DEBUG.:78::'
,p_button_condition=>'wwv_flow_cloud_db_services.get_upgrade_status().state = ''RUNNING'''
,p_button_condition2=>'PLSQL'
,p_button_condition_type=>'EXPRESSION'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-warning u-danger-text'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(11815070154752023)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(393281844168687250)
,p_button_name=>'JUMP_MENU'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:a-Button--gapRight'
,p_button_template_id=>wwv_flow_imp.id(656569185201725731)
,p_button_image_alt=>'Jump to...'
,p_button_position=>'NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'js-menuButton'
,p_icon_css_classes=>'icon-menu-drop-down'
,p_button_cattributes=>'data-menu="issues_jump_menu"'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(238359912274538263)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(393162683062868149)
,p_button_name=>'SPOTLIGHT'
,p_button_static_id=>'header-spotlightSearch'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#:a-Button--iconLeft'
,p_button_template_id=>wwv_flow_imp.id(656569185201725731)
,p_button_image_alt=>'Search'
,p_button_position=>'NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'js-actionButton a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-search'
,p_button_cattributes=>'data-action="spotlight-search"'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5840009192198704)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_imp.id(393281844168687250)
,p_button_name=>'GO_MILESTONES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(359238865408012460)
,p_button_image_alt=>'Milestones'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:200:&SESSION.::&DEBUG.:RP::'
,p_button_condition_type=>'NEVER'
,p_icon_css_classes=>'fa fa-map-signs'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(389448583141391465)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_imp.id(393162683062868149)
,p_button_name=>'ADMINISTRATION'
,p_button_static_id=>'header-adminMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(5208262349044176)
,p_button_image_alt=>'Administration'
,p_button_position=>'NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-gears-alt'
,p_button_cattributes=>'data-menu="adminMenu_menu"'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5839960308198703)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_imp.id(393281844168687250)
,p_button_name=>'GO_LABELS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(359238865408012460)
,p_button_image_alt=>'Labels'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP::'
,p_button_condition_type=>'NEVER'
,p_icon_css_classes=>'fa fa-tags'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(389448647174391466)
,p_button_sequence=>50
,p_button_plug_id=>wwv_flow_imp.id(393162683062868149)
,p_button_name=>'FEEDBACK'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(359238865408012460)
,p_button_image_alt=>'Feedback'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'f?p=4750:11001:&SESSION.::&DEBUG.:RP,11001:P11001_APPLICATION_ID,P11001_PAGE_ID:&APP_ID.,&APP_PAGE_ID.:'
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-comments'
,p_required_patch=>wwv_flow_imp.id(698205300939964492)
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5840227830198706)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_imp.id(393281844168687250)
,p_button_name=>'GO_UTILITIES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--padRight'
,p_button_template_id=>wwv_flow_imp.id(359238865408012460)
,p_button_image_alt=>'Utilities'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:2000:&SESSION.::&DEBUG.:RP::'
,p_button_condition_type=>'NEVER'
,p_icon_css_classes=>'icon-tools'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(389448799086391467)
,p_button_sequence=>60
,p_button_plug_id=>wwv_flow_imp.id(393162683062868149)
,p_button_name=>'HELP'
,p_button_static_id=>'header-helpMenu'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(5208262349044176)
,p_button_image_alt=>'Help'
,p_button_position=>'NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_css_classes=>'a-Button--noUI a-Button--navLink'
,p_icon_css_classes=>'icon-help'
,p_button_cattributes=>'data-menu="helpMenu_menu"'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5839889927198702)
,p_button_sequence=>70
,p_button_plug_id=>wwv_flow_imp.id(393281844168687250)
,p_button_name=>'NEW_ISSUE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'New Issue'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP,109,110,111:F4600_LAST_VIEW:&P0_CURRENT_PAGE.'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issue_count  number;',
'    l_template_count number;',
'    l_label_count number;',
'    l_milestone_count number;',
'    ',
'begin ',
'    -- Issues',
'    select count(*)',
'      into l_issue_count',
'      from wwv_flow_issues',
'     where security_group_id = :flow_security_group_id;',
'    -- Labels',
'    select count(*)',
'      into l_label_count',
'      from wwv_flow_label_groups',
'     where security_group_id = :flow_security_group_id;',
'    -- templates',
'    select count(*)',
'      into l_template_count',
'      from wwv_flow_issue_templates',
'     where security_group_id = :flow_security_group_id;',
'    -- milestones',
'    select count(*)',
'      into l_milestone_count',
'      from wwv_flow_milestones',
'     where security_group_id = :flow_security_group_id;',
'',
'return (l_issue_count >0 or l_label_count >0 or l_template_count > 0 or l_milestone_count > 0);',
'',
'end;'))
,p_button_condition2=>'PLSQL'
,p_button_condition_type=>'FUNCTION_BODY'
,p_security_scheme=>wwv_flow_imp.id(17268112003727577)
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5712328082527240)
,p_name=>'P0_CURRENT_PAGE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(393281844168687250)
,p_use_cache_before_default=>'NO'
,p_item_default=>'&APP_PAGE_ID.'
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
end;
/
prompt --application/pages/page_00001
begin
wwv_flow_imp_page.create_page(
 p_id=>1
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Team Development Home'
,p_alias=>'TEAMDEV'
,p_step_title=>'Team Development'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function getSelectedIds() {',
'    var model,',
'        ids = [],',
'        issuesIG = apex.region("issues");',
'',
'    model = issuesIG.call("getCurrentView").model;',
'    ids = issuesIG.call("getSelectedRecords").map(function(rec) {return model.getRecordId(rec)});',
'    return ids.join('':'');',
'}'))
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var p1_app  = $v2("P1_APPLICATION_ID"), ',
'    p1_page = $v2("P1_PAGE_ID");',
'',
'/*',
'  Only deals with setting column filters using equal operator, case insensitive',
'  An empty string value removes the filter.',
'  columns and values are arrays and must have same length',
'*/',
'function setIGFilters( regionId, columns, values ) {',
'    var i, filter, col, val, id, curVal,',
'        colMap = {},',
'        idMap = {},',
'        changed = false,',
'        region = apex.region(regionId),',
'        inst = region.call("instance"),',
'        filters = region.call("getFilters"),',
'        options = { save: false };',
'',
'    for (i = 0; i < columns.length; i++) {',
'        col = columns[i];',
'        if (inst._getColumnByName(col)) {',
'            id = inst._getColumnByName(col).id;',
'            idMap[id] = col;',
'        }',
'    }',
'',
'    for (i = 0; i < filters.length; i++) {',
'        filter = filters[i];',
'        if (filter.type === "column" && filter.operator === "EQ" && idMap[filter.columnId]) {',
'            colMap[idMap[filter.columnId]] = {',
'                id: filter.id,',
'                val: filter.value',
'            };',
'        }',
'    }',
'',
'    for (i = 0; i < columns.length; i++) {',
'        col = columns[i];',
'        val = values[i];',
'        id = curVal = null;',
'        if (colMap[col]) {',
'            id = colMap[col].id;',
'            curVal = colMap[col].val;',
'        }',
'        if (val !== "") { ',
'            filter = {',
'                   type: "column",',
'                   columnType: "column",',
'                   operator: "EQ",',
'                   value: val,',
'                   isCaseSensitive: false',
'            };',
'            if (id) {',
'                if (val !== curVal) {',
'                    region.call("updateFilter", id, filter, options);',
'                    changed = true;',
'                }',
'            } else {',
'                filter.columnName = col;',
'                region.call("addFilter", filter, options);',
'                changed = true;',
'            }',
'        } else if ( id ) {',
'            region.call("deleteFilter", id, options);',
'            changed = true;',
'        }',
'    }',
'    if (changed) {',
'        inst._setReportSettings({});',
'    }',
'}',
'if (p1_app) {',
'    setIGFilters("issues", ["APPLICATION_ID", "PAGE_ID", "STATUS"],[ p1_app, p1_page, "Open" ]);',
'    apex.item("issues").show();',
'    apex.region("issues").call("resize"); // this seems to help with sizing after becoming visible',
'} else {',
'    apex.item("issues").show();',
'    apex.region("issues").call("resize"); // this seems to help with sizing after becoming visible',
'}'))
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.is-disabled {opacity: 0.5; pointer-events: none;}',
'.group h2 {',
'  margin-bottom: 8px;',
'  font-size: 14px;',
'  line-height: 24px;',
'}',
'',
'.group p {',
'  color: #707070;',
'  margin-top: -4px;',
'}',
'',
'.group-item {',
'  margin: 8px 0;',
'}',
'',
'.group {',
'  margin: 16px;',
'}',
''))
,p_step_template=>wwv_flow_imp.id(391881764116992437)
,p_page_template_options=>'#DEFAULT#'
,p_page_component_map=>'13'
,p_last_upd_yyyymmddhh24miss=>'20210910021730'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(4876236258998332)
,p_name=>'Open Issues'
,p_region_name=>'dashboard'
,p_template=>wwv_flow_imp.id(179998957300224011)
,p_display_sequence=>40
,p_region_sub_css_classes=>'a-BadgeList--cols a-BadgeList--responsive a-BadgeList--large'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-BadgeList--fixed:a-BadgeList--large'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4500P1000c */',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues ',
'      where security_group_id = :flow_security_group_id',
'        and status = ''OPEN''',
'        and deleted = ''N'')  issues,',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues ',
'      where security_group_id = :flow_security_group_id',
'        and created_by = :APP_USER',
'        and status = ''OPEN''',
'        and deleted = ''N'')  owned,',
'      (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues i, ',
'           wwv_flow_issue_stakeholders s',
'     where s.issue_id = i.id',
'       and s.stakeholder = :APP_USER',
'       and s.stakeholder_type = ''ASSIGNEE''',
'       and i.status = ''OPEN''',
'       and i.deleted = ''N''',
'       and s.security_group_id = :flow_security_group_id',
'       and i.security_group_id = :flow_security_group_id) assigned,',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues i, ',
'           wwv_flow_issue_stakeholders s',
'     where s.issue_id = i.id',
'       and s.stakeholder_type = ''SUBSCRIBER''',
'       and i.status = ''OPEN''',
'       and i.deleted = ''N''',
'       and s.security_group_id = :flow_security_group_id',
'       and i.security_group_id = :flow_security_group_id)  subscribed ',
' from dual'))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(1046845011939553934)
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>'Report contains no data'
,p_query_row_count_max=>7
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'Y'
,p_comment=>'style="width:33%; float:left;"'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5165497807832105)
,p_query_column_id=>1
,p_column_alias=>'ISSUES'
,p_column_display_sequence=>1
,p_column_heading=>'Total'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(15580950867474513)
,p_query_column_id=>2
,p_column_alias=>'OWNED'
,p_column_display_sequence=>2
,p_column_heading=>'Owned'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(15581023832474514)
,p_query_column_id=>3
,p_column_alias=>'ASSIGNED'
,p_column_display_sequence=>3
,p_column_heading=>'Assigned'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(15581179397474515)
,p_query_column_id=>4
,p_column_alias=>'SUBSCRIBED'
,p_column_display_sequence=>4
,p_column_heading=>'Subscribed'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(4926428596003033)
,p_plug_name=>'Status '
,p_region_name=>'statusDialog'
,p_region_template_options=>'#DEFAULT#:js-dialog-size480x320'
,p_plug_template=>wwv_flow_imp.id(10813455696794486)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'This status will be applied to all selected issues.'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5402528899234735)
,p_plug_name=>'Issues IG'
,p_region_name=>'issues'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_region_attributes=>'style="display:none;"'
,p_plug_template=>wwv_flow_imp.id(651492083233530570)
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'Y'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with agg_stakeholders as (',
'    select issue_id,',
'           listagg(case when seqnum <=5 then wwv_flow_issue_int.get_user_name(stakeholder) end, '', '') ',
'            within group(order by wwv_flow_issue_int.get_user_name(stakeholder) ) assignees, ',
'           listagg(case when seqnum <=5 then wwv_flow_issue_int.get_avatar(stakeholder, p_image_size => 24, p_include_link => ''Y'') end, '' '') ',
'            within group(order by stakeholder ) assignees_html, ',
'           count(*) assignee_count',
'      from (select ss.*, ',
'                   row_number() over (partition by ISSUE_ID order by stakeholder ) as seqnum ',
'              from wwv_flow_issue_stakeholders ss',
'             where ss.stakeholder_type = ''ASSIGNEE''',
'               and ss.security_group_id = :flow_security_group_id)',
'     group by issue_id',
'), agg_subscribers as (',
'    select issue_id,',
'           listagg(wwv_flow_issue_int.get_user_name(stakeholder), '':'') ',
'            within group(order by wwv_flow_issue_int.get_user_name(stakeholder) ) subcribers,',
'           listagg(wwv_flow_issue_int.get_avatar(stakeholder, p_image_size => 24, p_include_link => ''Y''), '' '') ',
'            within group( order by stakeholder ) subscribers_html, ',
'           count(*) subscriber_count',
'      from wwv_flow_issue_stakeholders',
'     where stakeholder_type = ''SUBSCRIBER''',
'       and security_group_id = :flow_security_group_id',
'     group by issue_id',
'), ',
'agg_labels as (',
'    select issue_id,',
'           listagg(wwv_flow_escape.html(label_name), '', '') within group(',
'                order by label_name',
'           ) labels, ',
'           listagg(''<span class="a-IssueLabel ''||g.group_color||''" > ''||wwv_flow_escape.html(label_name)||''</span>'', '''') within group(',
'                order by g.group_name, l.label_name',
'           ) labels_html',
'      from wwv_flow_issue_labels il,',
'           wwv_flow_labels l, ',
'           wwv_flow_label_groups g',
'     where il.label_id = l.id',
'       and l.label_group_id = g.id',
'       and il.security_group_id = :flow_security_group_id',
'       and l.security_group_id = :flow_security_group_id',
'       and g.security_group_id = :flow_security_group_id',
'     group by issue_id',
'), ',
'agg_milestones as (',
'  select issue_id,',
'           listagg(wwv_flow_escape.html(milestone_name), '':'') within group(',
'                order by milestone_name',
'           ) milestones,',
'           listagg(''<a class="a-IssueMilestone" href="''||apex_util.prepare_url(''f?p=''||:APP_ID||'':205:''||:APP_SESSION||''::::P205_ID:''||m.id )||''"><span class="fa fa-map-signs" aria-hidden="true"></span>''||wwv_flow_escape.html(milestone_name)||''</a> '''
||', '' '') within group(',
'                order by milestone_name',
'           ) milestones_html',
'      from wwv_flow_issue_milestones im,',
'           wwv_flow_milestones m',
'     where im.milestone_id = m.id',
'       and im.security_group_id = :flow_security_group_id',
'       and m.security_group_id = :flow_security_group_id',
'     group by issue_id',
')',
'select i.id,',
'       i.issue_number,',
'       i.title,',
'       i.slug,',
'       i.status,',
'       case ',
'           when i.status = ''OPEN'' then ''<span aria-hidden="true" class="a-IssueList-itemStatusIcon a-IssueList-itemStatusIcon--open fa fa-exclamation-circle-o" title="''||i.status||''"></span>''',
'           WHEN i.status = ''CLOSED'' then ''<span aria-hidden="true" class="a-IssueList-itemStatusIcon a-IssueList-itemStatusIcon--closed fa fa-exclamation-circle-o fam-check fam-is-danger" title="''||i.status||''"></span>''',
'       end issue_status,',
'       i.issue_text,',
'       case ',
'            when i.duplicate_of is not null then ',
'                wwv_flow_lang.system_message(''APEX.ISSUES.TIMELINE.MARKED_DUPLICATE_OF'', p0=> wwv_flow_escape.html(i2.title), p1=> apex_util.get_since(i.duplicate_identified_on),  p2=>wwv_flow_escape.html(i.duplicate_identified_by))',
'            else ''''',
'        end  marked_duplicate,',
'       i.application_id,',
'       i.page_id,',
'        wwv_flow_lang.system_message(''APEX.ISSUES.TIMELINE.OPENED'', p0=>apex_util.get_since(i.created_on)) created,',
'       apex_util.prepare_url(''f?p=''||:APP_ID||'':500:''||:APP_SESSION||''::::P500_USER_NAME:''||i.created_by) created_by_link,',
'       i.created_on ,',
'       wwv_flow_issue_int.get_user_name(i.created_by) created_by,',
'       (',
'           select count(*)',
'             from wwv_flow_issue_comments c',
'            where c.issue_id = i.id',
'       ) comment_count,',
'       (',
'           select count(*)',
'             from wwv_flow_issue_events e',
'            where e.issue_id = i.id',
'       ) event_count,',
'       h.assignees,',
'       h.assignees_html,',
'       ss.subcribers,',
'       ss.subscribers_html,',
'       l.labels,',
'       l.labels_html,',
'       m.milestones, ',
'       m.milestones_html,',
'       apex_util.prepare_url(''f?p=''||:APP_ID||'':100:''||:APP_SESSION||''::NO:RP:P100_ISSUE_ID:''||i.id )issue_link, ',
'       case ',
'         when h.assignee_count > 5 then ''+''||(h.assignee_count -5) ',
'         else null',
'       end more_assignees',
'  from wwv_flow_issues               i,',
'       wwv_flow_current_workspaces   w,',
'       agg_stakeholders              h,',
'       agg_subscribers               ss,',
'       agg_labels                    l,',
'       wwv_flow_issues               i2,',
'       agg_milestones                  m',
' where i.deleted = ''N'' ',
'   and i.security_group_id = w.workspace_id',
'   and i.security_group_id = :flow_security_group_id',
'   and w.workspace_id = :flow_security_group_id',
'   and h.issue_id (+) = i.id',
'   and ss.issue_id (+) = i.id',
'   and l.issue_id (+) = i.id',
'   and m.issue_id (+) = i.id',
'   and i.duplicate_of = i2.id (+)',
''))
,p_plug_source_type=>'NATIVE_IG'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'FUNCTION_BODY'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issue_count  number;',
'    l_template_count number;',
'    l_label_count number;',
'    l_milestone_count number;',
'    ',
'begin ',
'    -- Issues',
'    select count(*)',
'      into l_issue_count',
'      from wwv_flow_issues',
'     where security_group_id = :flow_security_group_id;',
'    -- Labels',
'    select count(*)',
'      into l_label_count',
'      from wwv_flow_label_groups',
'     where security_group_id = :flow_security_group_id;',
'    -- templates',
'    select count(*)',
'      into l_template_count',
'      from wwv_flow_issue_templates',
'     where security_group_id = :flow_security_group_id;',
'    -- milestones',
'    select count(*)',
'      into l_milestone_count',
'      from wwv_flow_milestones',
'     where security_group_id = :flow_security_group_id;',
'',
'return (l_issue_count >0 or l_label_count >0 or l_template_count > 0 or l_milestone_count > 0);',
'',
'end;'))
,p_plug_display_when_cond2=>'PLSQL'
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5402773306234737)
,p_name=>'ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'ID'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>20
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5402846102234738)
,p_name=>'TITLE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TITLE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_LINK'
,p_heading=>'Title'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>30
,p_value_alignment=>'LEFT'
,p_link_target=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP:P100_ISSUE_ID:&ID.'
,p_link_text=>'&TITLE.'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>true
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_escape_on_http_output=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5402921773234739)
,p_name=>'SLUG'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SLUG'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>40
,p_attribute_01=>'Y'
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5403034736234740)
,p_name=>'ISSUE_STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_STATUS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Status Icon'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_attribute_05=>'HTML'
,p_lov_type=>'SHARED'
,p_lov_id=>wwv_flow_imp.id(5664182917694426)
,p_lov_display_extra=>true
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5403109019234741)
,p_name=>'ISSUE_TEXT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_TEXT'
,p_data_type=>'CLOB'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Issue Text'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>60
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>true
,p_max_length=>32767
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5403271720234742)
,p_name=>'MARKED_DUPLICATE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MARKED_DUPLICATE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Marked Duplicate'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>70
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5403431737234744)
,p_name=>'PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PAGE_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Page ID'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>80
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5403552407234745)
,p_name=>'CREATED'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Created'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>90
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5403605548234746)
,p_name=>'CREATED_BY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_BY'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Created By'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>100
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5403778044234747)
,p_name=>'COMMENT_COUNT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'COMMENT_COUNT'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Comments'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>110
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5403864761234748)
,p_name=>'EVENT_COUNT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'EVENT_COUNT'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Events'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>120
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5403906064234749)
,p_name=>'ASSIGNEES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ASSIGNEES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Assignee List'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>130
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5404070524234750)
,p_name=>'ASSIGNEES_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ASSIGNEES_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Assignee Icons'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>140
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_attribute_05=>'HTML'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5442632521568801)
,p_name=>'SUBCRIBERS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SUBCRIBERS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Subcriber List'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>150
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5442743104568802)
,p_name=>'SUBSCRIBERS_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SUBSCRIBERS_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Subscriber Icons'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>160
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_attribute_05=>'HTML'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5442829111568803)
,p_name=>'LABELS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABELS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Label List'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>170
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5442980375568804)
,p_name=>'LABELS_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABELS_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Beautified Labels'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>180
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_attribute_05=>'HTML'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5443011520568805)
,p_name=>'MILESTONES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MILESTONES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Milestone List'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>190
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5443190471568806)
,p_name=>'MILESTONES_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MILESTONES_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Beautified Milestones'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>200
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_attribute_05=>'HTML'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5612738543530335)
,p_name=>'ISSUE_LINK'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_LINK'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Issue Link'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>210
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5947690738329301)
,p_name=>'STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'STATUS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Status'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>220
,p_value_alignment=>'LEFT'
,p_attribute_02=>'LOV'
,p_attribute_05=>'PLAIN'
,p_lov_type=>'SHARED'
,p_lov_id=>wwv_flow_imp.id(5664182917694426)
,p_lov_display_extra=>true
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'LOV'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5947743824329302)
,p_name=>'CREATED_ON'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_ON'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER_JET'
,p_heading=>'Created'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>230
,p_value_alignment=>'LEFT'
,p_attribute_01=>'N'
,p_attribute_02=>'POPUP'
,p_attribute_03=>'NONE'
,p_attribute_06=>'NONE'
,p_attribute_09=>'N'
,p_attribute_11=>'Y'
,p_attribute_12=>'MONTH-PICKER:YEAR-PICKER'
,p_attribute_13=>'VISIBLE'
,p_format_mask=>'SINCE'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_date_ranges=>'ALL'
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
end;
/
begin
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(6186097491627141)
,p_name=>'CREATED_BY_LINK'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_BY_LINK'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>240
,p_attribute_01=>'Y'
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(6332983198146504)
,p_name=>'ISSUE_NUMBER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_NUMBER'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Issue #'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>250
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(10861362760686809)
,p_name=>'MORE_ASSIGNEES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MORE_ASSIGNEES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'More Assignees'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>260
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>41
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(156404054164150743)
,p_name=>'APPLICATION_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'APPLICATION_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Application Id'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>270
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(2567473977208406322)
,p_name=>'Row Selector'
,p_item_type=>'NATIVE_ROW_SELECTOR'
,p_display_sequence=>10
,p_attribute_01=>'Y'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_use_as_row_header=>false
);
wwv_flow_imp_page.create_interactive_grid(
 p_id=>wwv_flow_imp.id(5402636881234736)
,p_internal_uid=>5402636881234736
,p_is_editable=>false
,p_lazy_loading=>true
,p_requires_filter=>false
,p_show_nulls_as=>'-'
,p_select_first_row=>false
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_no_data_found_message=>'There are no Issues defined in the system.'
,p_show_toolbar=>true
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_enable_mail_download=>true
,p_fixed_header=>'PAGE'
,p_show_icon_view=>true
,p_icon_view_use_custom=>true
,p_icon_view_custom=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-ContentRowReport-item" data-id="&APEX$ROW_ID.">',
'  <div class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemSelection"><span class="u-selector"></span></div>',
'    <div class="a-ContentRowReport-itemIconWrap">&ISSUE_STATUS.</div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle" id="label_&ID."><a href="&ISSUE_LINK.">&TITLE.</a></h3> <span class="a-IssueList-itemLabels">&LABELS_HTML.</span>',
'        <div class="a-ContentRowReport-itemDescription">#&ISSUE_NUMBER. &CREATED. <a class="a-IssueList-itemAuthor" href="&CREATED_BY_LINK.">&CREATED_BY.</a> <span class="a-IssueList-itemMilestones">&MILESTONES_HTML.</span></div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">&ASSIGNEES_HTML.<span class="a-User a-User--more" title="&MORE_ASSIGNEES. other assignees"><span class="a-User-initials" role="presentation">&MORE_ASSIGNEES.</span></span></div>',
'      <div class="a-ContentRowReport-itemActions">',
'        <a class="a-IssueList-itemCommentsLink" href="&ISSUE_LINK."><span class="a-IssueList-itemCommentsIcon fa fa-comments-o"></span><span class="a-IssueList-itemCommentsCount">&COMMENT_COUNT.</span></a>',
'      </div>',
'    </div>',
'  </div>',
'</li>',
''))
,p_show_detail_view=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function (options) {',
'    var $ = apex.jQuery,',
'        toolbarData = $.apex.interactiveGrid.copyDefaultToolbar();',
'',
'    toolbarData.toolbarInsertAfter( "actions_button", {',
'       type: "MENU",',
'       labelKey: "APEX.ISSUES.UPDATE_MENU",',
'       id: "multi_edit_issues",',
'       menu: {',
'           items: [',
'               {',
'                   type:     "action",',
'                   labelKey: "APEX.ISSUES.MENU.STATUS",',
'                   action:   "open-status-dialog"',
'               },',
'               {',
'                   type:     "action",',
'                   labelKey: "APEX.ISSUES.MENU.ASSIGNEES",',
'                   action:   "open-assignees-dialog"',
'               },',
'               {',
'                   type:     "action",',
'                   labelKey: "APEX.ISSUES.MENU.LABELS",',
'                   action:   "open-labels-dialog"',
'               },',
'               {',
'                   type:     "action",',
'                   labelKey: "APEX.ISSUES.MENU.MILESTONES",',
'                   action:   "open-milestones-dialog"',
'               }',
'           ]',
'       }',
'    });',
'',
'    ',
'    options.toolbarData = toolbarData;',
'',
'    // don''t want single row view',
'    apex.util.getNestedObject(options, "views.grid.features").singleRowView = false;',
'',
'    options.defaultIconViewOptions = {',
'        collectionClasses: "a-ContentRowReport a-IssueList",',
'        iconListOptions: {',
'            navigation: false,',
'            tabbableContent: "a"',
'            // comes from row selector when navigation is false',
'            // multiple: true ',
'            // itemSelector: true',
'        }',
'    };',
'',
'    function checkOpen(dialogId) {',
'        if (getSelectedIds()) {',
'            apex.theme.openRegion(dialogId);',
'        } else {',
'            apex.theme.openRegion("noSelectionDialog");',
'        }',
'        return true; // setting focus',
'    }',
'',
'    //',
'    // Actions ',
'    //',
'    options.initActions = function(actions) {',
'        var ig$ = $(actions.context),',
'            iconView = ig$.interactiveGrid("getViews").icon;',
'',
'        iconView.title = apex.lang.getMessage( "APEX.ISSUES.CARDS"); ',
'        iconView.icon = "icon-ig-details";',
'',
'        actions.add([',
'            {name: "open-status-dialog",',
'            shortcut: "Ctrl+/,S",',
'            action: function (event, elm) {',
'                return checkOpen("statusDialog");',
'            }},',
'            {name: "open-assignees-dialog",',
'            shortcut: "Ctrl+/,A",',
'            action: function (event, elm) {',
'                return checkOpen("assignDialog");',
'            }},',
'            {name: "open-labels-dialog",',
'            shortcut: "Ctrl+/,L",',
'            action: function (event, elm) {',
'                return checkOpen("labelDialog");',
'            }},',
'            {name: "open-milestones-dialog",',
'            shortcut: "Ctrl+/,M",',
'            action: function (event, elm) {',
'                return checkOpen("milestoneDialog");',
'            }}',
'        ]);',
'    };',
'    return options;',
'}'))
);
wwv_flow_imp_page.create_ig_report(
 p_id=>wwv_flow_imp.id(27818993000237613)
,p_interactive_grid_id=>wwv_flow_imp.id(5402636881234736)
,p_name=>'Primary'
,p_static_id=>'Primary'
,p_type=>'PRIMARY'
,p_default_view=>'ICON'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_imp_page.create_ig_report_view(
 p_id=>wwv_flow_imp.id(16238707396903622)
,p_report_id=>wwv_flow_imp.id(27818993000237613)
,p_view_type=>'ICON'
);
wwv_flow_imp_page.create_ig_report_view(
 p_id=>wwv_flow_imp.id(22370200104645133)
,p_report_id=>wwv_flow_imp.id(27818993000237613)
,p_view_type=>'DETAIL'
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(16238702200903622)
,p_view_id=>wwv_flow_imp.id(22370200104645133)
,p_display_seq=>1000
,p_column_id=>wwv_flow_imp.id(5947743824329302)
,p_is_visible=>false
,p_is_frozen=>false
,p_sort_order=>1
,p_sort_direction=>'DESC'
,p_sort_nulls=>'LAST'
);
wwv_flow_imp_page.create_ig_report_view(
 p_id=>wwv_flow_imp.id(27818994331237620)
,p_report_id=>wwv_flow_imp.id(27818993000237613)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(16238710198903621)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>22
,p_column_id=>wwv_flow_imp.id(6186097491627141)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(16238792183903621)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>1
,p_column_id=>wwv_flow_imp.id(6332983198146504)
,p_is_visible=>true
,p_is_frozen=>true
,p_width=>68
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27120332439827902)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>23
,p_column_id=>wwv_flow_imp.id(10861362760686809)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27819510935237634)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>0
,p_column_id=>wwv_flow_imp.id(5402773306234737)
,p_is_visible=>false
,p_is_frozen=>true
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27819988545237662)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>2
,p_column_id=>wwv_flow_imp.id(5402846102234738)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>367
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27820477450237664)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>4
,p_column_id=>wwv_flow_imp.id(5402921773234739)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27820959380237665)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>5
,p_column_id=>wwv_flow_imp.id(5403034736234740)
,p_is_visible=>false
,p_is_frozen=>false
,p_width=>109
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27821473461237667)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>6
,p_column_id=>wwv_flow_imp.id(5403109019234741)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27821901112237668)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>7
,p_column_id=>wwv_flow_imp.id(5403271720234742)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27822939112237671)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>8
,p_column_id=>wwv_flow_imp.id(5403431737234744)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27823493032237673)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>14
,p_column_id=>wwv_flow_imp.id(5403552407234745)
,p_is_visible=>false
,p_is_frozen=>false
,p_width=>166
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27823926520237674)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>10
,p_column_id=>wwv_flow_imp.id(5403605548234746)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>145
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27824416693237676)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>25
,p_column_id=>wwv_flow_imp.id(5403778044234747)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>129
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27824975903237677)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>20
,p_column_id=>wwv_flow_imp.id(5403864761234748)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>105
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27825399214237679)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>13
,p_column_id=>wwv_flow_imp.id(5403906064234749)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>265
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27825923932237680)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>18
,p_column_id=>wwv_flow_imp.id(5404070524234750)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27826454698237686)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>19
,p_column_id=>wwv_flow_imp.id(5442632521568801)
,p_is_visible=>false
,p_is_frozen=>false
,p_width=>139
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27826955029237687)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>16
,p_column_id=>wwv_flow_imp.id(5442743104568802)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27827454896237689)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>12
,p_column_id=>wwv_flow_imp.id(5442829111568803)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>383
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27827903155237690)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>17
,p_column_id=>wwv_flow_imp.id(5442980375568804)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27828393771237692)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>15
,p_column_id=>wwv_flow_imp.id(5443011520568805)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>298
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(27828911630237693)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>11
,p_column_id=>wwv_flow_imp.id(5443190471568806)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(28058036005571318)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>21
,p_column_id=>wwv_flow_imp.id(5612738543530335)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(28323824368992488)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>4
,p_column_id=>wwv_flow_imp.id(5947690738329301)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>106
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(28324439888992512)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>11
,p_column_id=>wwv_flow_imp.id(5947743824329302)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>167
,p_sort_order=>1
,p_sort_direction=>'ASC'
,p_sort_nulls=>'LAST'
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(510053795462183900)
,p_view_id=>wwv_flow_imp.id(27818994331237620)
,p_display_seq=>24
,p_column_id=>wwv_flow_imp.id(156404054164150743)
,p_is_visible=>false
,p_is_frozen=>false
,p_width=>106
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(9774052912317313)
,p_plug_name=>'About'
,p_region_css_classes=>'a-Region--stacked a-Region--padded a-Region--flush a-Region--sideRegion'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Team Development enables you to track and manage issues in a conversational fashion. You can classify issue using labels, assign users to issues, link an issue with milestones, and attach files to an issue.</p>',
'<p><a target="_blank" href="&SYSTEM_HELP_URL./htmdb/managing-team-development.html">Learn More ...</a></p>',
''))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(10422245393079420)
,p_plug_name=>'Label'
,p_region_name=>'labelDialog'
,p_region_css_classes=>'a-DialogRegion--noPadding'
,p_region_template_options=>'#DEFAULT#:js-dialog-size720x480'
,p_plug_template=>wwv_flow_imp.id(10813455696794486)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
' declare',
'    l_item_type    varchar2(30);',
'    l_label_select varchar2(4000) := wwv_flow_lang.system_message(''APEX.ISSUES.SELECT'');',
'    l_label_assign varchar2(4000) := wwv_flow_lang.system_message(''APEX.ISSUES.ASSIGN'');',
'    l_label_remove varchar2(4000) := wwv_flow_lang.system_message(''APEX.ISSUES.REMOVE'');',
'begin',
'',
'    for label_group in (select id,',
'                               group_name,',
'                               values_are_exclusive,',
'                               group_color,',
'                               wwv_flow_issue_int.gen_slug(group_name) group_slug',
'                          from wwv_flow_label_groups g',
'                         where security_group_id = :flow_security_group_id',
'                         order by group_name) ',
'    loop',
'',
'        if label_group.values_are_exclusive = ''Y'' then',
'          sys.htp.p(''<div class="group is-exclusive">'');',
'        else',
'          sys.htp.p(''<div class="group">'');',
'        end if;',
'        sys.htp.p(''<h2 id="group_''||label_group.group_slug||''">'');',
'        sys.htp.p(wwv_flow_escape.html(label_group.group_name)||''</h2>'');',
'        if  label_group.values_are_exclusive = ''Y'' then ',
'            sys.htp.p(''<div class="group-item">'');',
'            sys.htp.p( APEX_ITEM.SELECT_LIST(',
'              p_idx           => 3,',
'              p_value         => null,',
'              p_list_values   => l_label_assign||'';ASSIGN,''||l_label_remove||'';REMOVE'',',
'              p_attributes    => ''class="a-Form-select apex-item-select is-label-group"'',',
'              p_show_null     => ''YES'',',
'              p_null_value    => ''NONE'',',
'              p_null_text     => l_label_select,',
'              p_item_id       => ''group_''||label_group.id,',
'              p_item_label    => ''Set ''||wwv_flow_escape.html(label_group.group_name)||'' label'',',
'              p_show_extra    => ''NO'') );',
'            sys.htp.p(''</div>''); -- close .group-item',
'        end if;',
'        sys.htp.p(''<div class="group-items" role="group" data-group-id="group_''||label_group.id||''" aria-labelledby="group_''||label_group.group_slug||''">'');',
'        for label in (select id,',
'                             label_name',
'                      from wwv_flow_labels',
'                     where security_group_id = :flow_security_group_id',
'                       and label_group_id = label_group.id',
'                     order by display_sequence asc) ',
'        loop',
'            if label_group.values_are_exclusive = ''Y'' then ',
'                sys.htp.p(''<div class="group-item">'');',
'                sys.htp.p(''<label>'');',
'                sys.htp.p(''<input type="radio" ''',
'                           ||''name="''||label_group.group_slug||''_''||label_group.id||''" ''',
'                           ||''value="''||label.id||''" ''',
'                           ||''class="u-vh label-item apex-ui-selector-input ''||wwv_flow_escape.html_attribute(label_group.group_name)||''" ''',
'                           ||''id="P1_R_''||label.id||''">''',
'                           || ''<span class="apex-ui-selector"></span>''',
'                           || ''<span class="a-IssueLabel ''||label_group.group_color||''">''||wwv_flow_escape.html_attribute(label.label_name)||''</span>'');',
'                sys.htp.p(''</label>'');',
'                sys.htp.p(''</div>''); -- close .group-item',
'            else ',
'                sys.htp.prn(''<div class="group-item">'');',
'                sys.htp.p( APEX_ITEM.SELECT_LIST(',
'                    p_idx           => 4,',
'                    p_value         => null,',
'                    p_list_values   => l_label_assign||'';ASSIGN_''||label.id||'',''||l_label_remove||'';REMOVE_''||label.id,',
'                    p_attributes    => ''class="a-Form-select apex-item-select"'',',
'                    p_show_null     => ''YES'',',
'                    p_null_value    => ''NONE'',',
'                    p_null_text     => l_label_select,',
'                    p_item_id       => ''P1_L01_''||label.id,',
'                    p_item_label    => null,',
'                    p_show_extra    => ''NO'') );',
'                    sys.htp.p(''<label for="P1_L01_''||label.id||''">'' ||',
'                                -- ''<div class="a-TriSwitch">''||',
'                                -- ''<input id="P1_L01_''||label.id||''" type="radio" name="f''||label.id||''" value="ASSIGN_''||label.id||''"><label for="P1_L01_''||label.id||''"><span class="u-vh">Assign</span></label>''||',
'                                -- ''<input id="P1_L02_''||label.id||''" type="radio" name="f''||label.id||''" value="NONE" checked="checked"><label for="P1_L02_''||label.id||''"><span class="u-vh">None</span></label>''||',
'                                -- ''<input id="P1_L03_''||label.id||''" type="radio" name="f''||label.id||''" value="REMOVE_''||label.id||''"><label for="P1_L03_''||label.id||''"><span class="u-vh">Remove</span></label>''||',
'                                -- ''</div>''||',
'                                ''<span class="a-IssueLabel ''||label_group.group_color||''">''||wwv_flow_escape.html_attribute(label.label_name)||''</span><br/>''||',
'                                ''</label>''||',
'                                ''</div> '');',
'            end if;',
'        end loop;',
'',
'        sys.htp.p(''</div>''); -- close .group-items',
'',
'        sys.htp.p(''</div>''); -- close .group',
'    end loop;',
'',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(10422390008079421)
,p_plug_name=>'Milestone'
,p_region_name=>'milestoneDialog'
,p_region_css_classes=>'a-DialogRegion--noPadding'
,p_region_template_options=>'#DEFAULT#:js-dialog-size720x480'
,p_plug_template=>wwv_flow_imp.id(10813455696794486)
,p_plug_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(22141335210602257)
,p_name=>'MILESTONE'
,p_region_name=>'milestones'
,p_parent_plug_id=>wwv_flow_imp.id(10422390008079421)
,p_template=>wwv_flow_imp.id(214132567690623104)
,p_display_sequence=>10
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-ContentRowReport--hideIcons'
,p_display_point=>'SUB_REGIONS'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with messages as (',
'select',
'    wwv_flow_lang.system_message(''APEX.ISSUES.SELECT'') as label_select,',
'    wwv_flow_lang.system_message(''APEX.ISSUES.ASSIGN'') as label_assign,',
'    wwv_flow_lang.system_message(''APEX.ISSUES.REMOVE'') as label_remove',
'from dual ) ',
'select',
'  null as ITEM_CUSTOM_ATTRS,',
'  null as ITEM_CSS_MODIFIERS, ',
'  ''<label for="P1_M01_''||rownum||''">''||wwv_flow_escape.html(milestone_name)||''</label>'' as ITEM_TITLE,',
'  APEX_ITEM.SELECT_LIST(',
'    p_idx           => 2,',
'    p_value         => null,',
'    p_list_values   => msg.label_assign||'';ASSIGN_''||id||'',''||msg.label_remove||'';REMOVE_''||id||'''',',
'    p_attributes    => ''class="a-Form-select apex-item-select"'',',
'    p_show_null     => ''YES'',',
'    p_null_value    => ''NONE'',',
'    p_null_text     => msg.label_select,',
'    p_item_id       => ''P1_M01_''||rownum,',
'    p_item_label    => NULL,',
'    p_show_extra    => ''NO'') ITEM_ACTIONS,',
'  case ',
'      when milestone_status = ''CLOSED'' then ''fa fa-check-square xfam-check xfam-is-success u-success-text''',
'      when milestone_status = ''OPEN'' then',
'        case ',
'             when sysdate > milestone_date  then ''fa fa-exclamation-circle xfam-warning xfam-is-danger u-danger-text''',
'             when sysdate + 15 > milestone_date then ''fa fa-warning xfam-warning xfam-is-warning u-warning-text''',
'             else ''fa fa-flag-o''',
'        end ',
'  end as ITEM_ICON,',
'  null as ITEM_LINK,',
'  case ',
'      when milestone_status = ''CLOSED'' then ''<span class="fa fa-check-square u-success-text" aria-hidden="true"></span> Closed &mdash; '' || to_char(milestone_date, ''Month DD YYYY'')',
'      when milestone_status = ''OPEN'' then',
'        case ',
'             when sysdate > milestone_date  then ''<span class="fa fa-warning u-danger-text" aria-hidden="true"></span> Past due &mdash; '' || apex_util.get_since(milestone_date)',
'             when sysdate + 15 > milestone_date then ''<span aria-hidden="true" class="fa fa-info-square u-warning-text"></span> Due &mdash; '' || apex_util.get_since(milestone_date)',
'             else ''<span aria-hidden="true" class="fa fa-calendar-o"></span> Due &mdash; '' || apex_util.get_since(milestone_date)',
'        end ',
'  end as ITEM_DESCRIPTION,',
'',
'  -- apex_util.get_since(milestone_date) as ITEM_DESCRIPTION,',
'  null as ITEM_MISC,',
'  null as ITEM_SELECTION',
'  ',
'  from wwv_flow_milestones m, messages msg',
' where security_group_id = :flow_security_group_id',
' order by milestone_date asc',
''))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(6811165341870886)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(11058708634101631)
,p_query_column_id=>1
,p_column_alias=>'ITEM_CUSTOM_ATTRS'
,p_column_display_sequence=>1
,p_column_heading=>'Item Custom Attrs'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(11059111240101631)
,p_query_column_id=>2
,p_column_alias=>'ITEM_CSS_MODIFIERS'
,p_column_display_sequence=>2
,p_column_heading=>'Item Css Modifiers'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(11059959894101632)
,p_query_column_id=>3
,p_column_alias=>'ITEM_TITLE'
,p_column_display_sequence=>4
,p_column_heading=>'Item Title'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(11061998264101637)
,p_query_column_id=>4
,p_column_alias=>'ITEM_ACTIONS'
,p_column_display_sequence=>9
,p_column_heading=>'Item Actions'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(11060330192101632)
,p_query_column_id=>5
,p_column_alias=>'ITEM_ICON'
,p_column_display_sequence=>5
,p_column_heading=>'Item Icon'
,p_use_as_row_header=>'N'
,p_column_html_expression=>'fa-lg #ITEM_ICON#'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(11060763408101635)
,p_query_column_id=>6
,p_column_alias=>'ITEM_LINK'
,p_column_display_sequence=>6
,p_column_heading=>'Item Link'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(11061134833101635)
,p_query_column_id=>7
,p_column_alias=>'ITEM_DESCRIPTION'
,p_column_display_sequence=>7
,p_column_heading=>'Item Description'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(11061564234101635)
,p_query_column_id=>8
,p_column_alias=>'ITEM_MISC'
,p_column_display_sequence=>8
,p_column_heading=>'Item Misc'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(11059549127101632)
,p_query_column_id=>9
,p_column_alias=>'ITEM_SELECTION'
,p_column_display_sequence=>3
,p_column_heading=>'Item Selection'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(10422678430079424)
,p_plug_name=>'Assign '
,p_region_name=>'assignDialog'
,p_region_css_classes=>'a-DialogRegion--noPadding'
,p_region_template_options=>'#DEFAULT#:js-dialog-size720x480'
,p_plug_template=>wwv_flow_imp.id(10813455696794486)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(10424237842079440)
,p_name=>'ASIGNEES'
,p_parent_plug_id=>wwv_flow_imp.id(10422678430079424)
,p_template=>wwv_flow_imp.id(214132567690623104)
,p_display_sequence=>10
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-ContentRowReport--hideIcons'
,p_display_point=>'SUB_REGIONS'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with messages as (',
'select',
'    wwv_flow_lang.system_message(''APEX.ISSUES.SELECT'') as label_select,',
'    wwv_flow_lang.system_message(''APEX.ISSUES.ASSIGN'') as label_assign,',
'    wwv_flow_lang.system_message(''APEX.ISSUES.REMOVE'') as label_remove',
'from dual )',
'select',
'  null as ITEM_CUSTOM_ATTRS,',
'  null as ITEM_CSS_MODIFIERS,',
'  ''<label for="P1_A01_''||rownum||''">'' || wwv_flow_issue_int.get_avatar (p_user_name => user_name, p_include_name => ''Y'') || ''</label>'' as ITEM_TITLE,  ',
'  APEX_ITEM.SELECT_LIST(',
'    p_idx           => 1,',
'    p_value         => null,',
'    p_list_values   => msg.label_assign||'';ASSIGN_''||user_name||'',''||msg.label_remove||'';REMOVE_''||user_name||'''',',
'    p_attributes    => ''class="a-Form-select apex-item-select"'',',
'    p_show_null     => ''YES'',',
'    p_null_value    => ''NONE'',',
'    p_null_text     => msg.label_select,',
'    p_item_id       => ''P1_A01_''||rownum,',
'    p_item_label    => NULL,',
'    p_show_extra    => ''NO'') ITEM_ACTIONS,',
'  null as ITEM_ICON,',
'  null as ITEM_LINK,',
'  null as ITEM_DESCRIPTION,',
'  null as ITEM_MISC,',
'  null as ITEM_SELECTION',
'  from wwv_flow_fnd_user u, messages msg',
'  where security_group_id = :flow_security_group_id',
'',
'',
''))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(6811165341870886)
,p_query_num_rows=>10000
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
end;
/
begin
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(10424304640079441)
,p_query_column_id=>1
,p_column_alias=>'ITEM_CUSTOM_ATTRS'
,p_column_display_sequence=>1
,p_column_heading=>'Item Custom Attrs'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(10424482366079442)
,p_query_column_id=>2
,p_column_alias=>'ITEM_CSS_MODIFIERS'
,p_column_display_sequence=>2
,p_column_heading=>'Item Css Modifiers'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(10861483880686810)
,p_query_column_id=>3
,p_column_alias=>'ITEM_TITLE'
,p_column_display_sequence=>8
,p_column_heading=>'Item Title'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(10425187285079449)
,p_query_column_id=>4
,p_column_alias=>'ITEM_ACTIONS'
,p_column_display_sequence=>7
,p_column_heading=>'Item Actions'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(10424789792079445)
,p_query_column_id=>5
,p_column_alias=>'ITEM_ICON'
,p_column_display_sequence=>3
,p_column_heading=>'Item Icon'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(10424805175079446)
,p_query_column_id=>6
,p_column_alias=>'ITEM_LINK'
,p_column_display_sequence=>4
,p_column_heading=>'Item Link'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(10424995467079447)
,p_query_column_id=>7
,p_column_alias=>'ITEM_DESCRIPTION'
,p_column_display_sequence=>5
,p_column_heading=>'Item Description'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(10425021215079448)
,p_query_column_id=>8
,p_column_alias=>'ITEM_MISC'
,p_column_display_sequence=>6
,p_column_heading=>'Item Misc'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(499483267980605008)
,p_query_column_id=>9
,p_column_alias=>'ITEM_SELECTION'
,p_column_display_sequence=>9
,p_column_heading=>'Item Selection'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(10422744982079425)
,p_plug_name=>'No Issues Selected'
,p_region_name=>'noSelectionDialog'
,p_region_template_options=>'#DEFAULT#:js-dialog-size480x320'
,p_plug_template=>wwv_flow_imp.id(10813455696794486)
,p_plug_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source=>'You must select one or more Issues to perform a mass-update operation. Please select at least one issue and try again.'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(15607707130231509)
,p_name=>'Feedback'
,p_template=>wwv_flow_imp.id(179998957300224011)
,p_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-BadgeList--fixed:a-BadgeList--large'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'(select count(security_group_id||created_by) entries',
'   from wwv_flow_feedback f',
'  where f.security_group_id = :FLOW_SECURITY_GROUP_ID) total,',
'(select count(security_group_id||created_by)',
'   from wwv_flow_feedback f',
'  where f.security_group_id = :FLOW_SECURITY_GROUP_ID',
'    and feedback_status != 4) open',
'from dual'))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(1046845011939553934)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(15581219341474516)
,p_query_column_id=>1
,p_column_alias=>'TOTAL'
,p_column_display_sequence=>1
,p_column_heading=>'Total'
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=4650:8012:&SESSION.::&DEBUG.:RP,8012::'
,p_column_linktext=>'#TOTAL#'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(15581339109474517)
,p_query_column_id=>2
,p_column_alias=>'OPEN'
,p_column_display_sequence=>2
,p_column_heading=>'Open'
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=4650:8012:&SESSION.::&DEBUG.:RP,8012::'
,p_column_linktext=>'#OPEN#'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(10422836863079426)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(10422744982079425)
,p_button_name=>'CANCEL_ERROR'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(10860533434686801)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(10422678430079424)
,p_button_name=>'CANCEL_ASSIGNEES'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(10861506186686811)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(10422390008079421)
,p_button_name=>'CANCEL_MILESTONES'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(10423113777079429)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(4926428596003033)
,p_button_name=>'CANCEL_STATUS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(11140656805970428)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(10422245393079420)
,p_button_name=>'CANCEL_LABELS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(10423258900079430)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(4926428596003033)
,p_button_name=>'APPLY_STATUS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(11140770668970429)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(10422245393079420)
,p_button_name=>'APPLY_LABELS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(10425263415079450)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(10422678430079424)
,p_button_name=>'APPLY_ASSIGNEES'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(10861699421686812)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(10422390008079421)
,p_button_name=>'APPLY_MILESTONES'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'NEXT'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(156399999666150702)
,p_branch_name=>'Go To Page Team Dev if END USER'
,p_branch_action=>'f?p=4600:2000:&SESSION.::&DEBUG.:::'
,p_branch_point=>'BEFORE_HEADER'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'FUNCTION_BODY'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_is_end_user varchar2(1) := ''N'';',
'begin ',
'',
'    for l_user in ( select user_name,',
'                       security_group_id',
'                  from wwv_flow_fnd_user',
'                 where user_name = :APP_USER',
'                   and security_group_id = :flow_security_group_id )',
'    loop',
'         if  l_user.security_group_id=''10'' then ',
'             l_is_end_user := ''N'';',
'         elsif wwv_flow_fnd_user_int.get_user_roles (p_security_group_id => l_user.security_group_id,p_username => l_user.user_name ) is null then ',
'             l_is_end_user := ''Y'';',
'         else ',
'            l_is_end_user := ''N'';',
'         end if;',
'    end loop;',
'    if l_is_end_user = ''Y'' then ',
'        return TRUE;',
'    else ',
'        return FALSE;',
'    end if;',
'end;'))
,p_branch_condition_text=>'PLSQL'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(598174128609635601)
,p_branch_name=>'Redirect to Welcome Page'
,p_branch_action=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.:RP,10::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_HEADER'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
,p_branch_condition_type=>'FUNCTION_BODY'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issue_count  number;',
'    l_template_count number;',
'    l_label_count number;',
'    l_milestone_count number;',
'    ',
'begin ',
'    -- Issues',
'    select count(*)',
'      into l_issue_count',
'      from wwv_flow_issues',
'     where security_group_id = :flow_security_group_id;',
'    -- Labels',
'    select count(*)',
'      into l_label_count',
'      from wwv_flow_label_groups',
'     where security_group_id = :flow_security_group_id;',
'    -- templates',
'    select count(*)',
'      into l_template_count',
'      from wwv_flow_issue_templates',
'     where security_group_id = :flow_security_group_id;',
'    -- milestones',
'    select count(*)',
'      into l_milestone_count',
'      from wwv_flow_milestones',
'     where security_group_id = :flow_security_group_id;',
'',
'return NOT (l_issue_count >0 or l_label_count >0 or l_template_count > 0 or l_milestone_count > 0);',
'',
'end;'))
,p_branch_condition_text=>'PLSQL'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(10423739440079435)
,p_name=>'P1_SELECTED_ISSUES'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(5402528899234735)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(10860827363686804)
,p_name=>'P1_ASSIGNEES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(10422678430079424)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(10862171718686817)
,p_name=>'P1_MILESTONES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(10422390008079421)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(10862790753686823)
,p_name=>'P1_SELECTED_STATUS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(4926428596003033)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(11141256505970434)
,p_name=>'P1_LABELS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(10422245393079420)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(156404123007150744)
,p_name=>'P1_APPLICATION_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(5402528899234735)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
,p_item_comment=>'Used to filter the interactive grid.'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(156404221186150745)
,p_name=>'P1_PAGE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(5402528899234735)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
,p_item_comment=>'Used to filter the interactive grid.'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(499483349427605009)
,p_name=>'P1_STATUS'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(4926428596003033)
,p_prompt=>'Status'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'LOCALIZED OPEN CLOSED'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.OPEN'') d, ''OPEN'' r ',
'from dual',
'UNION',
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.CLOSED'') d, ''CLOSED'' r ',
'from dual'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Select -'
,p_lov_null_value=>'NONE'
,p_cHeight=>1
,p_field_template=>wwv_flow_imp.id(566752393121369432)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'YES'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(165798641973198807)
,p_computation_sequence=>10
,p_computation_item=>'P1_APPLICATION_ID'
,p_computation_point=>'AFTER_FOOTER'
,p_computation_type=>'EXPRESSION'
,p_computation_language=>'SQL'
,p_computation=>'null'
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(165798716780198808)
,p_computation_sequence=>20
,p_computation_item=>'P1_PAGE_ID'
,p_computation_point=>'AFTER_FOOTER'
,p_computation_type=>'EXPRESSION'
,p_computation_language=>'SQL'
,p_computation=>'null'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(10422950921079427)
,p_name=>'Close Dialog'
,p_event_sequence=>50
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(10422836863079426)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(10423047637079428)
,p_event_id=>wwv_flow_imp.id(10422950921079427)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_CLOSE_REGION'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(10422744982079425)
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(10423573307079433)
,p_name=>'Close Status Dialog'
,p_event_sequence=>60
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(10423113777079429)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(10423630195079434)
,p_event_id=>wwv_flow_imp.id(10423573307079433)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.item(''P1_STATUS'').setValue(''NONE'');',
'apex.theme.closeRegion("statusDialog");'))
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(10423871357079436)
,p_name=>'Apply Status Changes'
,p_event_sequence=>70
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(10423258900079430)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(10423940713079437)
,p_event_id=>wwv_flow_imp.id(10423871357079436)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var status = $("#P1_STATUS")[0];',
'var myIssues = getSelectedIds();',
'var myChecked = '''';',
'',
'if (status.value !== ''NONE'') {',
'  myChecked = status.value;',
'}',
'',
'apex.page.submit({',
'    request: "APPLY_STATUS",',
'        set: {',
'            "P1_SELECTED_ISSUES": myIssues,',
'            "P1_SELECTED_STATUS": myChecked',
'        },',
'        showWait: true,',
'} );',
'    ',
'    '))
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(10860629415686802)
,p_name=>'Close Assignee Dialog'
,p_event_sequence=>80
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(10860533434686801)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(10860729796686803)
,p_event_id=>wwv_flow_imp.id(10860629415686802)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_CLOSE_REGION'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(10422678430079424)
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(10860929671686805)
,p_name=>'Apply Assignee Changes'
,p_event_sequence=>90
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(10425263415079450)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(10861015427686806)
,p_event_id=>wwv_flow_imp.id(10860929671686805)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var mySelection = $("#assignDialog select").filter("[id^=P1_A]");',
'var myIssues = getSelectedIds();',
'var myChecked = '''';',
'',
'for  (var i=0; i<mySelection.length; i++)  {',
'  if (mySelection[i].value !== ''NONE'') {',
'      myChecked = myChecked + mySelection[i].value + '':'';',
'  }',
'}',
'',
'//',
'apex.page.submit({',
'    request: "APPLY_ASSIGNEES",',
'        set: {',
'            "P1_SELECTED_ISSUES": myIssues,',
'            "P1_ASSIGNEES": myChecked',
'        },',
'        showWait: true,',
'} );',
''))
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(10861708893686813)
,p_name=>'Close Milestone Dialog'
,p_event_sequence=>100
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(10861506186686811)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(10861848499686814)
,p_event_id=>wwv_flow_imp.id(10861708893686813)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_CLOSE_REGION'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(10422390008079421)
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(10861916311686815)
,p_name=>'Apply Assign Milestones'
,p_event_sequence=>110
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(10861699421686812)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(10862089533686816)
,p_event_id=>wwv_flow_imp.id(10861916311686815)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var mySelection = $("#milestoneDialog select").filter("[id^=P1_M]");',
'var myIssues = getSelectedIds();',
'myChecked = '''';',
'',
'for  (var i=0; i<mySelection.length; i++)  {',
'  if (mySelection[i].value !== ''NONE'') {',
'      myChecked = myChecked + mySelection[i].value + '':'';',
'  }',
'}',
'',
'//',
'apex.page.submit({',
'    request: "APPLY_MILESTONES",',
'        set: {',
'            "P1_SELECTED_ISSUES": myIssues,',
'            "P1_MILESTONES": myChecked',
'        },',
'        showWait: true,',
'} );'))
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(11140869150970430)
,p_name=>'Close Label Dialog'
,p_event_sequence=>120
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(11140656805970428)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(11140940424970431)
,p_event_id=>wwv_flow_imp.id(11140869150970430)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_CLOSE_REGION'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(10422245393079420)
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(11141058440970432)
,p_name=>'Apply Label Changes'
,p_event_sequence=>130
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(11140770668970429)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(11141101886970433)
,p_event_id=>wwv_flow_imp.id(11141058440970432)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var applyChanges = function (myChecked, myIssues) {',
'	apex.page.submit({',
'        request: "APPLY_LABELS",',
'        set: {',
'          "P1_SELECTED_ISSUES": myIssues,',
'          "P1_LABELS": myChecked',
'        },',
'        showWait: true,',
'      });',
'};',
'',
'var displayWarning = ''N'';',
'',
'// Do validations for',
'//  - Exclusive groups with an action selected but no radios checked',
'$(".is-exclusive > .group-item").each(function() {',
'	var currentGroup$ = $(this);',
'	var exclusiveGroupSelect$ = currentGroup$.find(".is-label-group");',
'	if (exclusiveGroupSelect$.val() !== "NONE") {',
'		var exclusiveGroupRadios$ = exclusiveGroupSelect$.parents(".group-item").next().find("input:radio");',
'		var radioChecked = ''N'';',
'		exclusiveGroupRadios$.each(function() {',
'			if ($(this).prop("checked")) {',
'				radioChecked = ''Y'';',
'			}',
'		});',
'		if (radioChecked === ''N'') {',
'			displayWarning = ''Y'';',
'			return;',
'		}',
'	}',
'});',
'',
'',
'// Generate request string',
'var myChecked = '''';',
'// Take care of the non-exclusive first - its easier.',
'// Loop through the non-exclusives',
'$(".group-item > select").filter("[id^=P1_L]").each(function() {',
'	if ($(this).val() !== "NONE") {',
'		myChecked = myChecked + $(this).val() + '':''; ',
'	}',
'});',
'',
'',
'$(".is-label-group").each(function (){',
'	var currentSelect$ = $(this);',
'	if (currentSelect$.val() !== "NONE"){',
'		var currentGroupRadios$ = currentSelect$.parents(".group-item").next().find("input:radio");',
'		currentGroupRadios$.each(function (){',
'			if ($(this).prop("checked")) {',
'				if ($(this).val() !== "NONE") {',
'					myChecked = myChecked + currentSelect$.val() + ''_'' + $(this).val() + '':'';',
'				}',
'			}',
'		})',
'	}',
'})',
'',
'',
'if (displayWarning == ''Y'') {',
'  apex.message.confirm("One or more exclusive Lable Group has an Action selected with no Value. This will result in no action being taken for the affected Group(s). Do you wish to continue?", function(okPressed) {',
'    if (okPressed) {',
'    	applyChanges(myChecked, getSelectedIds());',
'    }',
'  });',
'} else {',
'	applyChanges(myChecked, getSelectedIds());',
'}',
''))
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(2567474003359406323)
,p_name=>'Grid Enable / Disable Multi Update Button'
,p_event_sequence=>160
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_imp.id(5402528899234735)
,p_bind_type=>'live'
,p_bind_event_type=>'NATIVE_IG|REGION TYPE|interactivegridselectionchange'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(2567474137739406324)
,p_event_id=>wwv_flow_imp.id(2567474003359406323)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var records = apex.region("issues").call("getSelectedRecords");',
'var selectedCount = records ? records.length : 0;',
'apex.region("issues").call("getToolbar").toolbar("findElement", "multi_edit_issues").prop("disabled", selectedCount === 0);',
'// note just enabling/disabling the Update button doesn''t stop use of the actions such asopen-status-dialog ',
'// could disable the actions but not critical because there is the dialog that tells you there is no selection.'))
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(499483041333605006)
,p_name=>'Disable Issue Update Menu Button'
,p_event_sequence=>170
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(499483146523605007)
,p_event_id=>wwv_flow_imp.id(499483041333605006)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'apex.region("issues").call("getToolbar").toolbar("findElement", "multi_edit_issues").prop("disabled", true);'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(499483433817605010)
,p_name=>'Handle Exclusive Group Updates'
,p_event_sequence=>180
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'select.is-label-group'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(499483505727605011)
,p_event_id=>wwv_flow_imp.id(499483433817605010)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var status = this.triggeringElement.value;',
'var groupItem$ = $(this.triggeringElement).parents(".group-item").next(".group-items");',
'var groupRadios$ = groupItem$.find("input:radio");',
'',
'if (status === ''NONE'') {',
'    groupRadios$.prop("disabled",true).prop("checked",false);',
'    groupItem$.addClass("is-disabled");',
'} else {',
'    groupRadios$.prop("disabled",false);',
'    groupItem$.removeClass("is-disabled");    ',
'}',
''))
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(2567473477607406317)
,p_name=>'Init label dialog'
,p_event_sequence=>190
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(2567473508349406318)
,p_event_id=>wwv_flow_imp.id(2567473477607406317)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'$("#labelDialog").dialog({',
' open: function(){',
'    var labelGroupSelects$ = $(".is-label-group"),',
'        exclGroupItems$ = labelGroupSelects$.parents(".group-item").next();',
'',
'    labelGroupSelects$.val("NONE");',
'    exclGroupItems$.find("input:radio").prop("disabled",true).prop("checked",false);',
'    exclGroupItems$.addClass("is-disabled");',
' }',
'});',
''))
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(2567473797919406320)
,p_name=>'Grid view activate to open'
,p_event_sequence=>200
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_imp.id(5402528899234735)
,p_bind_type=>'bind'
,p_bind_event_type=>'custom'
,p_bind_event_type_custom=>'gridactivatecell'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(2567473807238406321)
,p_event_id=>wwv_flow_imp.id(2567473797919406320)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var rec, meta, link,',
'    issuesIG = apex.region("issues"),',
'    view =  issuesIG.call("getCurrentView"), // this will be the grid view',
'    model = view.model;',
'',
'rec = view.getContextRecord(this.browserEvent.originalEvent.target);',
'meta = model.getRecordMetadata(model.getRecordId(rec[0]));',
'if (meta && meta.fields.TITLE) {',
'    apex.navigation.redirect(meta.fields.TITLE.url);',
'}',
''))
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(581219589628849523)
,p_name=>'New'
,p_event_sequence=>210
,p_bind_type=>'bind'
,p_bind_event_type=>'resize'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(581219666266849524)
,p_event_id=>wwv_flow_imp.id(581219589628849523)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.region("issues").call("resize")',
''))
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(10423487360079432)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Apply Status'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issues     apex_t_varchar2 := apex_string.split(:P1_SELECTED_ISSUES, '':'');',
'    l_status     varchar2(100);',
'begin ',
'',
'l_status := trim(BOTH '':'' FROM :P1_SELECTED_STATUS);',
'if l_status in (''OPEN'',''CLOSED'') then ',
'    for i in 1..l_issues.count loop',
'        -- ',
'        wwv_flow_issue_int.set_status(p_issue_id => l_issues(i), p_status_id => l_status); ',
'        --',
'',
'    end loop;',
'end if;',
'    :P1_SELECTED_ISSUES:= '''';',
'end;',
''))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to update Status for selected Issues.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_imp.id(10423258900079430)
,p_process_success_message=>'Status updated for selected Issues;'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(10861239138686808)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Apply Assignees'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issues     apex_t_varchar2 := apex_string.split(:P1_SELECTED_ISSUES, '':'');',
'    l_assignees  apex_t_varchar2 := apex_string.split(:P1_ASSIGNEES, '':'');',
'    l_assign     apex_t_varchar2 := apex_t_varchar2();',
'    l_assign_cnt number := 0;',
'    l_remove     apex_t_varchar2 := apex_t_varchar2();',
'    l_remove_cnt number := 0;',
'begin ',
'',
'if :P1_ASSIGNEES is not null then ',
'    -- First loop through the assignees and sort the ASSIGN from the REMOVE.',
'    for a in 1..l_assignees.count loop',
'        if substr(l_assignees(a),1,6) = ''ASSIGN'' then ',
'           l_assign_cnt := l_assign_cnt +1;',
'           l_assign.extend;',
'           l_assign(l_assign_cnt) := substr(l_assignees(a),8);',
'        elsif substr(l_assignees(a),1,6) = ''REMOVE'' then ',
'           l_remove_cnt := l_remove_cnt +1;',
'           l_remove.extend;',
'           l_remove(l_remove_cnt) := substr(l_assignees(a),8);',
'        else',
'           null; -- Igonre anything that got in accidentally',
'        end if;',
'    end loop;',
'    --Now loop through each selected issue',
'    for i in 1..l_issues.count loop',
'        -- call the ADD_ASSIGNEES function ',
'        if l_assign_cnt > 0 then ',
'            wwv_flow_issue_int.add_assignees(p_issue_id => l_issues(i), p_assignee_ids => apex_string.join(p_table => l_assign, p_sep => '':'' )); ',
'        end if;',
'        -- loop through all REMOVALS and remove them',
'        if l_remove_cnt > 0 then ',
'            wwv_flow_issue_int.remove_assignees(p_issue_id => l_issues(i), p_assignee_ids => apex_string.join(p_table => l_remove, p_sep => '':'' )); ',
'        end if;',
'    end loop;',
'end if;',
'-- clean up session state',
'    :P1_SELECTED_ISSUES:= '''';',
'    :P1_ASSIGNEES := '''';',
'end;',
''))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to update Assignees for selected Issues.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_imp.id(10425263415079450)
,p_process_success_message=>'Assignees updated for selected Issues.'
);
end;
/
begin
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(10862200430686818)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Apply Milestones'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issues     apex_t_varchar2 := apex_string.split(:P1_SELECTED_ISSUES, '':'');',
'    l_milestones apex_t_varchar2 := apex_string.split(:P1_MILESTONES, '':'');',
'    l_assign     apex_t_varchar2 := apex_t_varchar2();',
'    l_assign_cnt number := 0;',
'    l_remove     apex_t_varchar2 := apex_t_varchar2();',
'    l_remove_cnt number := 0;',
'begin ',
'',
'if :P1_MILESTONES is not null then ',
'    -- First loop through the MILESTONES and sort the ASSIGN from the REMOVE.',
'    for a in 1..l_milestones.count loop',
'        if substr(l_milestones(a),1,6) = ''ASSIGN'' then ',
'           l_assign_cnt := l_assign_cnt +1;',
'           l_assign.extend;',
'           l_assign(l_assign_cnt) := substr(l_milestones(a),8);',
'        elsif substr(l_milestones(a),1,6) = ''REMOVE'' then ',
'           l_remove_cnt := l_remove_cnt +1;',
'           l_remove.extend;',
'           l_remove(l_remove_cnt) := substr(l_milestones(a),8);',
'        else',
'           null; -- Igonre anything that got in accidentally',
'        end if;',
'    end loop;',
'    --Now loop through each selected issue',
'    for i in 1..l_issues.count loop',
'        -- call the ADD_MILESTONES function ',
'        if l_assign_cnt > 0 then ',
'            wwv_flow_issue_int.add_milestones(p_issue_id => l_issues(i), p_milestone_ids => apex_string.join(p_table => l_assign, p_sep => '':'' )); ',
'        end if;',
'        -- loop through all REMOVALS and remove them',
'        if l_remove_cnt > 0 then ',
'            wwv_flow_issue_int.remove_milestones(p_issue_id => l_issues(i), p_milestone_ids => apex_string.join(p_table => l_remove, p_sep => '':'' )); ',
'        end if;',
'    end loop;',
'end if;',
'-- clean up session state',
'    :P1_SELECTED_ISSUES:= '''';',
'    :P1_MILESTONES := '''';',
'end;',
''))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to update Milestones for selected Issues.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_imp.id(10861699421686812)
,p_process_success_message=>'Milestones updated for selected Issues.'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(11141350269970435)
,p_process_sequence=>40
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Apply Labels'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issues     apex_t_varchar2 := apex_string.split(:P1_SELECTED_ISSUES, '':'');',
'    l_labels apex_t_varchar2 := apex_string.split(:P1_LABELS, '':'');',
'    l_assign     apex_t_varchar2 := apex_t_varchar2();',
'    l_assign_cnt number := 0;',
'    l_remove     apex_t_varchar2 := apex_t_varchar2();',
'    l_remove_cnt number := 0;',
'begin ',
'',
'if :P1_LABELS is not null then ',
'    -- First loop through the LABELS and sort the ASSIGN from the REMOVE.',
'    for a in 1..l_labels.count loop',
'        if substr(l_labels(a),1,6) = ''ASSIGN'' then ',
'           l_assign_cnt := l_assign_cnt +1;',
'           l_assign.extend;',
'           l_assign(l_assign_cnt) := substr(l_labels(a),8);',
'        elsif substr(l_labels(a),1,6) = ''REMOVE'' then ',
'           l_remove_cnt := l_remove_cnt +1;',
'           l_remove.extend;',
'           l_remove(l_remove_cnt) := substr(l_labels(a),8);',
'        else',
'           null; -- Igonre anything that got in accidentally',
'        end if;',
'    end loop;',
'    -- Now loop through each selected issue',
'    for i in 1..l_issues.count loop',
'        -- call the ADD_MILESTONES function ',
'        if l_assign_cnt > 0 then ',
'            wwv_flow_issue_int.add_labels(p_issue_id => l_issues(i), p_label_ids => apex_string.join(p_table => l_assign, p_sep => '':'' )); ',
'        end if;',
'        -- loop through all REMOVALS and remove them',
'        if l_remove_cnt > 0 then ',
'            wwv_flow_issue_int.remove_labels(p_issue_id => l_issues(i), p_label_ids => apex_string.join(p_table => l_remove, p_sep => '':'' )); ',
'        end if;',
'    end loop;',
'end if;',
'-- clean up session state',
'    --:P1_SELECTED_ISSUES:= '''';',
'    --:P1_LABELS := '''';',
'end;',
''))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Unable to update Labels for selected Issues.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_imp.id(11140770668970429)
,p_process_success_message=>'Labels updated for selected Issues.'
);
end;
/
prompt --application/pages/page_00010
begin
wwv_flow_imp_page.create_page(
 p_id=>10
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Welcome Page'
,p_step_title=>'Welcome to Team Development'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-Alert--horizontal .a-Alert-title {',
'    font-size: 14px;',
'    font-weight: 600;',
'}',
'',
'.a-Alert--horizontal.a-Alert--inline {',
'    border-width: 0;',
'}',
'',
'.a-Alert--inline.a-Alert--horizontal .a-Alert-body p {',
'    flex-grow: 1;',
'}',
'',
'.a-Alert--inline.a-Alert--horizontal  .a-Form-fieldContainer {',
'    text-align: right;',
'    flex-shrink: 0;',
'}',
'.a-Alert--inline.a-Alert--horizontal  .a-Form-fieldContainer.apex-item-wrapper--yes-no {',
'    flex-basis: 64px;',
'}',
'.a-Alert--inline.a-Alert--horizontal  .a-Form-fieldContainer.apex-item-wrapper--select-list {',
'    flex-basis: 180px;',
'}',
'',
'.a-Alert--inline.a-Alert--horizontal .a-Alert-buttons {',
'    display: none;',
'}',
'',
'.a-Alert--inline.a-Alert--horizontal .a-Alert-body {',
'    display: flex;',
'    align-items: center;',
'}'))
,p_step_template=>wwv_flow_imp.id(707892828837195217)
,p_page_template_options=>'#DEFAULT#'
,p_page_component_map=>'16'
,p_last_upd_yyyymmddhh24miss=>'20210225130545'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(597618556777219101)
,p_plug_name=>'Welcome to Team Development'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(708692623972319459)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_02'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(597619604653219112)
,p_plug_name=>'Options'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(597618807525219104)
,p_plug_name=>'Install Sample Labels'
,p_parent_plug_id=>wwv_flow_imp.id(597619604653219112)
,p_region_css_classes=>'a-Alert--inline margin-top-md'
,p_icon_css_classes=>'fa-lg fa-tags'
,p_region_template_options=>'a-Alert--info:a-Alert--horizontal:a-Form--leftLabels:a-Form--autoWidthLabels'
,p_plug_template=>wwv_flow_imp.id(775445099592054705)
,p_plug_display_sequence=>30
,p_plug_display_point=>'SUB_REGIONS'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>Team Development uses Label Groups and Labels to help users classify issues. A starter set of Label Groups and Labels can be created for you.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(597619013461219106)
,p_plug_name=>'Install Sample Templates'
,p_parent_plug_id=>wwv_flow_imp.id(597619604653219112)
,p_region_css_classes=>'a-Alert--inline'
,p_icon_css_classes=>'fa-lg fa-synonym'
,p_region_template_options=>'a-Alert--info:a-Alert--horizontal:a-Form--leftLabels:a-Form--autoWidthLabels'
,p_plug_template=>wwv_flow_imp.id(775445099592054705)
,p_plug_display_sequence=>40
,p_plug_display_point=>'SUB_REGIONS'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>Templates allow users to quickly fill out issues or generate responses based on editable text. A starter set of Templates can be created for you.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(597619275441219108)
,p_plug_name=>'Install Sample Milestones'
,p_parent_plug_id=>wwv_flow_imp.id(597619604653219112)
,p_region_css_classes=>'a-Alert--inline'
,p_icon_css_classes=>'fa-lg fa-map-signs'
,p_region_template_options=>'a-Alert--info:a-Alert--horizontal:a-Form--leftLabels:a-Form--autoWidthLabels'
,p_plug_template=>wwv_flow_imp.id(775445099592054705)
,p_plug_display_sequence=>50
,p_plug_display_point=>'SUB_REGIONS'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>Milestone help track important dates against which Issues can be assigned and tracked. A sample set of milestones can be created for you.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(597619501199219111)
,p_plug_name=>'Sample Data Language'
,p_parent_plug_id=>wwv_flow_imp.id(597619604653219112)
,p_region_css_classes=>'a-Alert--inline'
,p_icon_css_classes=>'fa-lg fa-language'
,p_region_template_options=>'a-Alert--info:a-Alert--horizontal:a-Form--leftLabels:a-Form--autoWidthLabels'
,p_plug_template=>wwv_flow_imp.id(775445099592054705)
,p_plug_display_sequence=>70
,p_plug_display_point=>'SUB_REGIONS'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Select a langauge to be used for the sample labels, milestones and templates.</p>',
''))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(753994592734338714)
,p_plug_name=>'Introduction Wizard'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(47229974494774989)
,p_plug_display_sequence=>90
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(753994648420338715)
,p_plug_name=>'Welcome Text'
,p_region_css_classes=>'a-Wizard-subTitle'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>10
,p_plug_source=>'<p>Team Development has been reimagined as a new way to work together in APEX! You can easily keep track of tasks, features, bugs and feedback for your entire team, all in a single location! It''s designed to be simpler than before but powerful and fl'
||'exible enough to be an essential part of your development process! Get a jump start by selecting the setup options below!</p>'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(753996721605338736)
,p_plug_name=>'Buttons Container'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI:a-ButtonRegion--accessibleTitle'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>80
,p_plug_item_display_point=>'BELOW'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(597599024765188045)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(753996721605338736)
,p_button_name=>'SETUP'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--strongLabel:a-Button--large'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Complete Set Up'
,p_button_position=>'CHANGE'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(597618653661219102)
,p_branch_name=>'Already Completed Setup'
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP,1::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_HEADER'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'FUNCTION_BODY'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issue_count  number;',
'    l_template_count number;',
'    l_label_count number;',
'    l_milestone_count number;',
'    ',
'begin ',
'    -- Issues',
'    select count(*)',
'      into l_issue_count',
'      from wwv_flow_issues',
'     where security_group_id = :flow_security_group_id;',
'    -- Labels',
'    select count(*)',
'      into l_label_count',
'      from wwv_flow_label_groups',
'     where security_group_id = :flow_security_group_id;',
'    -- templates',
'    select count(*)',
'      into l_template_count',
'      from wwv_flow_issue_templates',
'     where security_group_id = :flow_security_group_id;',
'    -- milestones',
'    select count(*)',
'      into l_milestone_count',
'      from wwv_flow_milestones',
'     where security_group_id = :flow_security_group_id;',
'',
'return (l_issue_count > 0 or l_label_count > 0 or l_template_count > 0 or l_milestone_count > 0);',
'',
'end;'))
,p_branch_condition_text=>'PLSQL'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(597594702973188029)
,p_name=>'P10_INSTALL_LABELS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(597618807525219104)
,p_item_default=>'Y'
,p_prompt=>'Install Default Labels'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_imp.id(571215478963548485)
,p_item_css_classes=>'a-Form-fieldContainer--noPadding'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(597595579273188033)
,p_name=>'P10_INSTALL_TEMPLATES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(597619013461219106)
,p_item_default=>'Y'
,p_prompt=>'Install Default Templates'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_imp.id(571215478963548485)
,p_item_css_classes=>'a-Form-fieldContainer--noPadding'
,p_item_template_options=>'#DEFAULT#'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(597596300982188035)
,p_name=>'P10_INSTALL_MILESTONES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(597619275441219108)
,p_item_default=>'Y'
,p_prompt=>'Install Sample Milestones'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_imp.id(571215478963548485)
,p_item_css_classes=>'a-Form-fieldContainer--noPadding'
,p_item_template_options=>'#DEFAULT#'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(597597969744188042)
,p_name=>'P10_LANGUAGE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(597619501199219111)
,p_item_default=>'APEX_UTIL.GET_SESSION_LANG'
,p_item_default_type=>'EXPRESSION'
,p_item_default_language=>'PLSQL'
,p_prompt=>'Sample Data language'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select  l.translated_lang_name d, f.flow_language r',
'                  from ( select flow_language',
'                           from wwv_flows f',
'                          where id = :APP_ID',
'                          union',
'                         select flow_language',
'                           from wwv_flows f',
'                          where id in ( select translation_flow_id',
'                                          from wwv_flow_language_map',
'                                         where primary_language_flow_id = :APP_ID )',
'                       ) f,',
'                       wwv_flow_languages l',
'                 where f.flow_language = l.lang_id'))
,p_cHeight=>1
,p_field_template=>wwv_flow_imp.id(571215478963548485)
,p_item_css_classes=>'a-Form-fieldContainer--noPadding'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(597600117330189669)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Complete Setup'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    --',
'    if :P10_INSTALL_LABELS = ''Y'' then ',
'        wwv_flow_issue_seed_int.install_default_labels(p_lang => :P10_LANGUAGE);',
'    end if;',
'    --',
'    if :P10_INSTALL_TEMPLATES = ''Y'' then ',
'        wwv_flow_issue_seed_int.install_default_templates(p_lang => :P10_LANGUAGE);',
'    end if;',
'    --',
'    if :P10_INSTALL_MILESTONES = ''Y'' then ',
'        wwv_flow_issue_seed_int.install_sample_milestones(p_lang => :P10_LANGUAGE);',
'    end if;',
'    --',
'    wwv_flow_issue_seed_int.install_sample_issue;',
'    --',
' end;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00011
begin
wwv_flow_imp_page.create_page(
 p_id=>11
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'File Does Not Exist'
,p_page_mode=>'MODAL'
,p_step_title=>'File Does Not Exist'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_page_template_options=>'#DEFAULT#'
,p_page_component_map=>'11'
,p_last_upd_yyyymmddhh24miss=>'20190911132306'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(1664201025663420)
,p_plug_name=>'New'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_source=>'NOPE.. NOt here.'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
end;
/
prompt --application/pages/page_00100
begin
wwv_flow_imp_page.create_page(
 p_id=>100
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Issue'
,p_alias=>'ISSUE'
,p_step_title=>'&P100_ISSUE_TITLE. - Issue'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_javascript_file_urls=>'#IMAGE_PREFIX#apex_ui/js/issues.utils.js'
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'//Catching the custom Close event from the View Files dialog',
'function customCloseEvent(event, data){',
'    apex.event.trigger(document, event, data);',
'}',
'',
'// Function to allow inserting file references after uploading a file.',
'function insertFileReference(data){',
'    //mdEditor.setValue(data);',
'    apex.item(''P100_COMMENT'').setValue(data);',
'}',
'',
'// Function to get the template body',
'function getResponseTemplate(pID) {',
'    apex.server.process("getResponseTemplate", { x01: pID },{',
'         success: function(pData) {',
'            var item = apex.item(''P100_COMMENT'');',
'            var text = item.getValue();',
'             var replace = true;',
'            if(text && text.length > 0){',
'                var message = apex.lang.getMessage("APEX.ISSUES.REPLACE_COMMENT_CONFIRM");',
'               replace = confirm(message);',
'            }',
'             if(replace){',
'                 apex.item(''P100_COMMENT'').setValue(pData.text);',
'            }',
'         }',
'    });',
'}',
'',
'// Edit Menus for Comments',
'var menu$ = $("<div id=''timelineMenu''></div>");',
'$("body").append(menu$);',
'menu$.menu({',
'  iconType: "fa",',
'  items: [{',
'      type: "action",',
'      labelKey: "APEX.ISSUES.EDIT",',
'      icon: "fa-pencil",',
'      action: function(menu, btn) {',
'        var link,',
'          dialogTitle,',
'          button$ = $(btn),',
'          commentType = button$.attr("data-type") === "comment" ? "EDIT_COMMENT" : "EDIT_ISSUE",',
'          link = button$.attr("data-link").replace(/\\u(\d\d\d\d)/g, function(m, d) {',
'            return String.fromCharCode(parseInt(d, 16));',
'          });',
'        apex.navigation.dialog(link, {',
'          title: apex.lang.getMessage(''APEX.ISSUES.'' + commentType),',
'          resizable: true,',
'          draggable: true,',
'          width: 640,',
'          height: ''auto''',
'        }, "a-Dialog--uiDialog", button$);',
'      },',
'      hide: function(menu) {',
'        var button$ = $("button.is-active.js-menuButton.js-timelineEditButton"),',
'          link = button$.attr("data-link");',
'        return button$.attr("data-link") ? false : true;',
'      }',
'    },',
'    {',
'      type: "separator"',
'    },',
'    {',
'      type: "action",',
'      labelKey: "APEX.ISSUES.HIDE",',
'      icon: "fa-eye-slash",',
'      action: function(menu, btn) {',
'        var button$ = $(btn),',
'          timelineItemId = button$.attr("data-comment-id");',
'        apex.server.process(',
'          ''hideComment'', {',
'            x01: timelineItemId',
'          }, {',
'            success: function(data) {',
'              apex.region(''issueTimeline'').refresh()',
'            }',
'          }',
'        );',
'      },',
'      hide: function(menu) {',
'        var btn$ = $("button.is-active.js-menuButton.js-timelineEditButton");',
'        type = btn$.attr("data-type"),',
'          commentStatus = btn$.attr("data-comment-status");',
'        if (type === "comment" && commentStatus === "visible") {',
'          return false;',
'        } else {',
'          return true;',
'        }',
'      }',
'    },',
'    {',
'      type: "action",',
'      labelKey: "APEX.ISSUES.UNHIDE",',
'      icon: "fa-eye",',
'      action: function(menu, btn) {',
'        var button$ = $(btn),',
'          timelineItemId = button$.attr("data-comment-id");',
'        apex.server.process(',
'          ''showComment'', {',
'            x01: timelineItemId',
'          }, {',
'            success: function(data) {',
'              apex.region(''issueTimeline'').refresh()',
'            }',
'          }',
'        );',
'      },',
'      hide: function(menu) {',
'        var btn$ = $("button.is-active.js-menuButton.js-timelineEditButton"),',
'          type = btn$.attr("data-type"),',
'          commentStatus = btn$.attr("data-comment-status");',
'',
'        if (type === "comment" && commentStatus === "hidden") {',
'          return false',
'        } else {',
'          return true;',
'        }',
'      }',
'    },',
'    {',
'      type: "action",',
'      labelKey: "APEX.ISSUES.DELETE",',
'      icon: "fa-trash-o",',
'      id: "delete_comment",',
'      action: function(menu, btn) {',
'        var button$ = $(btn),',
'          timelineItemId = button$.attr("data-comment-id");',
'',
'        apex.message.confirm(apex.lang.getMessage("APEX.ISSUES.DELETE_COMMENT_CONFIRM"), function(confirm) {',
'          if (confirm) {',
'            apex.server.process(',
'              ''deleteComment'', {',
'                x01: timelineItemId',
'              }, {',
'                success: function(data) {',
'                  apex.region(''issueTimeline'').refresh()',
'                }',
'              }',
'            );',
'          }',
'        });',
'      },',
'      hide: function(menu) {',
'        var btn$ = $("button.is-active.js-menuButton.js-timelineEditButton"),',
'          type = btn$.attr("data-type");',
'',
'        return type === "comment" ? false : true;',
'      }',
'    },',
'    {',
'      type: "action",',
'      labelKey: "APEX.ISSUES.DELETE_ISSUE",',
'      icon: "fa-trash-o",',
'      id: "delete_issue",',
'      action: function() {',
'        apex.confirm(apex.lang.getMessage("APEX.ISSUES.DELETE_ISSUE_CONFIRM"), {',
'          request: "DELETE"',
'        })',
'      },',
'      hide: function(menu) {',
'        var btn$ = $("button.is-active.js-menuButton.js-timelineEditButton"),',
'          type = btn$.attr("data-type");',
'',
'        return type === "issue" ? false : true;',
'      }',
'    }',
'  ]',
'});',
'',
'// Function to retrieve full text of issue or comment and replace what is currently in the page. ',
'function getFullText(pType, pID){',
'    apex.server.process("getFullText", { x01: pType, ',
'                                         x02: pID',
'    },{  dataType: ''text'',',
'         success: function(pData) {',
'               document.getElementById(pID).innerHTML = pData;',
'               document.getElementById("MORE_"+ pID).innerHTML = '' '';',
'               $( document.getElementById(pID) ).removeClass( ''is-markdownified'' );',
'               apex.widget.markdown.render( ''.a-TimelineEntry-bodyContent'' );',
'',
'',
'         }',
'    });',
'}'))
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'/* Handle Delete Issues menu item */',
'var deleteIssueMenuItem = $("#issueActions_menu").menu("find", "delete_issue_item");',
'',
'if ( deleteIssueMenuItem ) {',
'  deleteIssueMenuItem.action = function() {',
'    apex.confirm(apex.lang.getMessage("APEX.ISSUES.DELETE_ISSUE_CONFIRM"), {',
'      request: "DELETE"',
'    })',
'  }',
'}',
''))
,p_step_template=>wwv_flow_imp.id(391881764116992437)
,p_page_css_classes=>'a-Page--issue'
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_deep_linking=>'Y'
,p_page_component_map=>'03'
,p_last_upd_yyyymmddhh24miss=>'20210726062533'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(1664332366663421)
,p_plug_name=>'File Not Found'
,p_region_name=>'noFileFound'
,p_region_template_options=>'#DEFAULT#:js-dialog-size480x320:h240'
,p_region_attributes=>'style="display:none"'
,p_plug_template=>wwv_flow_imp.id(10813455696794486)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-Alert a-Alert--defaultIcons a-Alert--danger a-Alert--horizontal h240" >',
'  <div class="a-Alert-wrap">',
'    <div class="a-Alert-icon">',
'      <span class="a-Icon "></span>',
'    </div>',
'    <div class="a-Alert-content">',
'      <div class="a-Alert-header">',
'        <h2 class="a-Alert-title">File Error</h2>',
'      </div>',
'      <div class="a-Alert-body">',
'        The file you tried to reference no longer exists. You may want to remove all references to this file from this issue.',
'      </div>',
'    </div>',
'    <div class="a-Alert-buttons">',
'      ',
'    </div>',
'  </div>',
'</div>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(4873675327998306)
,p_plug_name=>'Title Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    for issue in (',
'        select ',
'            issue_number, ',
'            title,',
'            created_by,',
'            wwv_flow_issue_int.get_user_name(created_by) user_name,',
'            apex_util.get_since(created_on) created_on,',
'            case status when ''OPEN''   then ''a-IssueList-itemStatusIcon--open fa-exclamation-circle-o''',
'                        when ''CLOSED'' then ''a-IssueList-itemStatusIcon--closed fa-exclamation-circle-o fam-check fam-is-danger''',
'            end status_icon,',
'            ( select count(*) from wwv_flow_issue_comments c where c.issue_id = i.id ) comment_count',
'        from ',
'            wwv_flow_issues i',
'        where id = :P100_ISSUE_ID',
'          and security_group_id = :flow_security_group_id',
'    ) loop',
'        sys.htp.p(''<div class="a-IssueHeader">'' );',
'        sys.htp.p(''  <div class="a-IssueHeader-itemStatusIconWrap">'' );',
'        sys.htp.p(''    <span class="a-IssueList-itemStatusIcon fa fa-lg ''||issue.status_icon||''" aria-hidden="true"></span>'');',
'        sys.htp.p(''  </div>'');',
'        sys.htp.p(''  <div class="a-IssueHeader-body">'');',
'        sys.htp.p(''    <h1 class="a-IssueHeader-title">''||wwv_flow_escape.html(issue.title)||''</h1>'');',
'        sys.htp.p(''    <div class="a-IssueHeader-info"><span class="a-IssueHeader-issueNumber">#''||issue.issue_number||''</span> ''',
'                    || wwv_flow_lang.system_message(''APEX.ISSUES.TIMELINE.OPENED'', p0=> issue.created_on)||'' <a href="''',
'                    || apex_page.get_url(p_application => 4600,p_page=> 500,p_items=> ''P500_USER_NAME'',p_values=> issue.created_by)',
'                    ||''">''|| issue.user_name',
'                    || ''</a> &middot; ''|| issue.comment_count ||'' ''||wwv_flow_lang.system_message(''APEX.ISSUES.COMMENTS'')||''</div>'');',
'        sys.htp.p(''  </div>'');',
'        sys.htp.p(''</div>'');',
'    end loop;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(4874097402998310)
,p_name=>'Labels'
,p_template=>wwv_flow_imp.id(179998957300224011)
,p_display_sequence=>60
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''<a href="#" class="a-IssueLabel ''||g.group_color||''"> ''||wwv_flow_escape.html(l.label_name)||''</a>''  as display_value    ',
'  from wwv_flow_labels l,',
'       wwv_flow_label_groups g,',
'       wwv_flow_issue_labels il',
' where il.issue_id = :P100_ISSUE_ID',
'   and il.label_id = l.id',
'   and l.label_group_id = g.id',
'   and il.security_group_id = :flow_security_group_id',
'   and l.security_group_id = :flow_security_group_id',
'   and g.security_group_id = :flow_security_group_id',
'order by g.group_name, l.label_name'))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(6221345279028573)
,p_query_num_rows=>30
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>'No Labels Assigned'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8722121265916105)
,p_query_column_id=>1
,p_column_alias=>'DISPLAY_VALUE'
,p_column_display_sequence=>1
,p_column_heading=>'Display Value'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(4874178306998311)
,p_name=>'Milestones'
,p_template=>wwv_flow_imp.id(179998957300224011)
,p_display_sequence=>70
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id milestone_id,',
'        milestone_date, ',
'       ''<span class="a-IssueLabel ''|| case when milestone_date < sysdate then ''u-danger''',
'                                           when milestone_date >= sysdate and milestone_date <= sysdate + 15 then ''u-warning''',
'                                           else ''u-success''',
'                                       end',
'                       ||''"  style="width:100%"> ''||wwv_flow_escape.html(milestone_name)||''<br/>''||milestone_date||''</span>''  as display_value',
'  from wwv_flow_issue_milestones im ,',
'       wwv_flow_milestones m',
' where im.issue_id = :P100_ISSUE_ID',
'   and im.milestone_id = m.id',
'   and m.security_group_id = :flow_security_group_id',
'   and im.security_group_id = :flow_security_group_id',
'order by milestone_date asc'))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(6221345279028573)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>'No Milestones Assigned'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5948623774329311)
,p_query_column_id=>1
,p_column_alias=>'MILESTONE_ID'
,p_column_display_sequence=>2
,p_use_as_row_header=>'N'
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5611666794530324)
,p_query_column_id=>2
,p_column_alias=>'MILESTONE_DATE'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8722217770916106)
,p_query_column_id=>3
,p_column_alias=>'DISPLAY_VALUE'
,p_column_display_sequence=>3
,p_column_heading=>'Display Value'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(4874226588998312)
,p_plug_name=>'Notifications'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>80
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(4929538370267901)
,p_name=>'Issue Timeline'
,p_region_name=>'issueTimeline'
,p_template=>wwv_flow_imp.id(179998957300224011)
,p_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--noBorder:a-Region--accessibleHeader'
,p_component_template_options=>'#DEFAULT#'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with timeline as (',
'    --',
'    select id,',
'           ''ISSUE'' event_target,',
'           ''OPENED'' event_action,',
'           null entry_type_icon,',
'           ''a-TimelineEntry--expanded'' entry_modifier_classes,',
'            issue_text   entry_body,',
'            to_clob(wwv_flow_lang.system_message(''APEX.ISSUES.CREATED_THIS_ISSUE'', p0=>apex_util.get_since(created_on)))  entry_status_type,',
'           created_on   entry_date,',
'           created_by   entry_author,',
'           null public_yn',
'      from wwv_flow_issues',
'     where id = :P100_ISSUE_ID',
'       and security_group_id = :flow_security_group_id',
'    --   ',
'    union all',
'    --',
'    select id,',
'           ''COMMENT'' event_target,',
'           ''CREATED'' event_action,',
'           null entry_type_icon,',
'           case public_yn',
'                when ''N'' then ''a-TimelineEntry--collapsed a-TimelineEntry--hidden'' ',
'                else ''a-TimelineEntry--expanded'' ',
'           end entry_modifier_classes,',
'           comment_text entry_body,',
'           case public_yn ',
'                when ''N'' then to_clob(wwv_flow_lang.system_message(''APEX.ISSUES.TIMELINE.HIDDEN''))',
'                else to_clob(wwv_flow_lang.system_message(''APEX.ISSUES.COMMENTED'')||'' ''||apex_util.get_since(created_on)) ',
'           end entry_status_type,',
'           created_on     entry_date,',
'           created_by     entry_author,',
'           public_yn public_yn',
'      from wwv_flow_issue_comments',
'     where issue_id = :P100_ISSUE_ID',
'       and security_group_id = :flow_security_group_id',
'       and (public_yn != ''N'' ',
'            OR ',
'            instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') >0',
'            OR ',
'            created_by = :APP_USER)',
'    --',
'    union all',
'    --',
'    select id,',
'           upper(wwv_flow_issue_int.get_json_event_type(event_text)) event_target,',
'           upper(wwv_flow_issue_int.get_json_event_action(event_text)) event_action,',
'           null ENTRY_TYPE_ICON,',
'           ''a-TimelineEntry--collapsed'' entry_modifier_classes,',
'           null entry_body,',
'           wwv_flow_issue_int.format_event_json(event_text) entry_status_type,',
'           event_date   entry_date,',
'           created_by   entry_author,',
'           null public_yn',
'      from wwv_flow_issue_events',
'     where issue_id = :P100_ISSUE_ID',
'       and upper(wwv_flow_issue_int.get_json_event_type(event_text)) not in (''ISSUE'',''COMMENT'')',
'       and security_group_id = :flow_security_group_id',
')',
'--',
'select ',
'    id,',
'    event_target,',
'    event_action,',
'    case event_action ',
'        when ''ADD'' then ''u-success''',
'        when ''REMOVE'' then ''u-danger''',
'        when ''SET'' then ''u-info''',
'        else ''other-event-action''',
'    end entry_type_icon_modifier,',
'    case event_target',
'        when ''ISSUE''        then',
'            ''fa fa-exclamation-circle-o''',
'        when ''COMMENT''      then',
'                case public_yn ',
'                    when ''N'' then ',
'                        ''fa fa-eye-slash''',
'                    else ',
'                        ''fa fa-comment-o''',
'                end',
'        when ''STATUS''       then',
'           ''fa fa-pencil''         -- ''a-TimelineEntry-typeIcon -- status''',
'        when ''LABEL''        then',
'           ''fa fa-tag''            -- ''a-TimelineEntry-typeIcon -- label''',
'        when ''MILESTONE''    then',
'           ''fa fa-map-signs''      -- ''a-TimelineEntry-typeIcon -- milestone''',
'        when ''ASSIGNEE''     then',
'           case event_action when ''ADD'' then ''fa fa-user-plus''',
'                             when ''REMOVE'' then ''fa fa-user-x''',
'           end',
'        when ''SUBSCRIBER''   then',
'           ''fa fa-check-circle-o'' -- ''a-TimelineEntry-typeIcon -- subscriber''',
'        when ''ATTACHMENT''   then',
'           ''fa fa-paperclip''      -- ''a-TimelineEntry-typeIcon -- attachment''',
'        when ''DUPLICATE'' then ',
'           ''fa fa-copy'' ',
'        when ''ASSOCIATION'' then ',
'            ''fa fa-window-bookmark''',
'       else event_target',
'    end entry_type_icon_class,',
'    null entry_type_icon,',
'    entry_modifier_classes,',
'    --entry_body,',
'    wwv_flow_escape.html_trunc(replace(entry_body, ''#ISSUE_FILE#'',''f?p=''||:APP_ID||'':100:''||:APP_SESSION||'':APPLICATION_PROCESS=getAttachment:NO::P100_ISSUE_ID,P100_FILE_NAME_SLUG:''||:P100_ISSUE_ID||'','')) as entry_body,',
'    case ',
'    when sys.dbms_lob.getlength(replace(entry_body, ''#ISSUE_FILE#'',''f?p=''||:APP_ID||'':100:''||:APP_SESSION||'':APPLICATION_PROCESS=getAttachment:NO::P100_ISSUE_ID,P100_FILE_NAME_SLUG:''||:P100_ISSUE_ID||'','') ) > 4000 THEN ',
'        ''<a href="javascript:getFullText(''''''||event_target||'''''', ''''''||id||'''''');" class="a-TimelineEntry-moreLink">''|| wwv_flow_lang.system_message(''APEX.ISSUES.SHOW_MORE'') ||''</a>''',
'    else '' ''',
'    end as more_data,',
'    entry_status_type,',
'    case  ',
'        when (event_target = ''COMMENT'') THEN ',
'             case ',
'                 -- if ADMIN',
'                 when (instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') >0  ) AND (public_yn = ''N'')',
'                   then  ',
'                     ''<button id="toggleBody" class="a-Button a-Button--noLabel a-Button--iconTextButton a-Button--noUI" type="button" title="Toggle Body" aria-label="Toggle Body" onclick="$(this).closest(''''article'''').toggleClass(''''a-TimelineEntry--c'
||'ollapsed'''').toggleClass(''''a-TimelineEntry--expanded'''');"><span class="fa fa-expand-collapse" aria-hidden="true"></span></button>''',
'                 else null',
'             end ',
'        else null',
'    end entry_actions,',
'    (',
'       -- Dynamic Menu',
'       case ',
'       when event_target in (''ISSUE'',''COMMENT'') ',
'            and (',
'                    (instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') > 0) ',
'                      OR ',
'                    (t.entry_author = :APP_USER)',
'                )',
'       then',
'           ''<button type="button" class="a-Button a-Button--noLabel a-Button--noUI js-timelineEditButton js-menuButton" ''',
'            ||''data-menu="timelineMenu" aria-label="''||wwv_flow_lang.system_message(''APEX.ISSUES.SHOW_ACTIONS'')||''" title="''||wwv_flow_lang.system_message(''APEX.ISSUES.SHOW_ACTIONS'')||''"''',
'            -- Capture Event Type',
'            || ''data-type="''||lower(event_target)||''"'' ||',
'            -- Capture Edit Links',
'            case event_target ',
'              when ''ISSUE'' then ''data-link="''||trim( both '''''''' from regexp_substr(apex_util.prepare_url(p_url => ''f?p=''||:APP_ID||'':101:''||:APP_SESSION),''''''f\?p=[^'''']*'''''') )||''" ''',
'              when ''COMMENT'' then ''data-comment-id="''||id||''" data-link="''||trim( both '''''''' from regexp_substr(apex_util.prepare_url(p_url => ''f?p=''||:APP_ID||'':108:''||:APP_SESSION||''::::P108_COMMENT_ID,P100_ISSUE_ID_VALUE:''||id||'',''||:P100_ISSUE_ID)'
||',''''''f\?p=[^'''']*'''''') )||''" ''',
'              else null',
'            end ||',
'            -- Capture Comment Status',
'            case ',
'              when (instr(',
'                          wwv_flow_fnd_user_int.get_user_roles(',
'                            p_security_group_id => :flow_security_group_id, ',
'                            p_username => :APP_USER',
'                          ), ''ADMIN'') > 0  ) ',
'              then',
'                   case public_yn ',
'                     when ''N'' then ''data-comment-status="hidden"''',
'                     when ''Y'' then ''data-comment-status="visible"''',
'                   end',
'              else ',
'                null',
'            end ||',
'            ''><span aria-hidden="true" class="fa fa-ellipsis-v-o"></span></button>''',
'       else ',
'        null -- When the target is not an issue or comment, we don''t need to show actions menu',
'       end',
'    ) as entry_options_menu,',
'    entry_date,',
'    wwv_flow_issue_int.get_avatar(p_user_name => entry_author, p_image_size => 24, p_include_name => ''Y'', p_include_link => ''Y'') entry_author,',
'    case',
'        when u.user_id is null then',
'            ''''',
'        else',
'            ''wwv_flow_file_mgr.get_file?p_user_id='' || u.user_id',
'    end image_link',
'',
'  from timeline            t,',
'       wwv_flow_fnd_user   u',
' where t.entry_author = u.user_name (+)',
'   and :flow_security_group_id = u.security_group_id (+)',
' order by entry_date asc'))
,p_display_when_condition=>'P100_ISSUE_NUMBER'
,p_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_ajax_enabled=>'Y'
,p_ajax_items_to_submit=>'P100_ISSUE_ID'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(5473608411738262)
,p_query_num_rows=>1100
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(4929664747267902)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_column_heading=>'Id'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(4930781814267913)
,p_query_column_id=>2
,p_column_alias=>'EVENT_TARGET'
,p_column_display_sequence=>3
,p_column_heading=>'Event Target'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(6448950234807346)
,p_query_column_id=>3
,p_column_alias=>'EVENT_ACTION'
,p_column_display_sequence=>12
,p_column_heading=>'Event Action'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8721928967916103)
,p_query_column_id=>4
,p_column_alias=>'ENTRY_TYPE_ICON_MODIFIER'
,p_column_display_sequence=>11
,p_use_as_row_header=>'N'
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(4923539353003004)
,p_query_column_id=>5
,p_column_alias=>'ENTRY_TYPE_ICON_CLASS'
,p_column_display_sequence=>9
,p_column_heading=>'Entry Type Icon Class'
,p_use_as_row_header=>'N'
,p_column_html_expression=>'#ENTRY_TYPE_ICON_CLASS# #EVENT_ACTION#'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5444053036568815)
,p_query_column_id=>6
,p_column_alias=>'ENTRY_TYPE_ICON'
,p_column_display_sequence=>7
,p_column_heading=>'Entry Type Icon'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5443271658568807)
,p_query_column_id=>7
,p_column_alias=>'ENTRY_MODIFIER_CLASSES'
,p_column_display_sequence=>5
,p_column_heading=>'Entry Modifier Classes'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(15580721229474511)
,p_query_column_id=>8
,p_column_alias=>'ENTRY_BODY'
,p_column_display_sequence=>14
,p_column_heading=>'Entry Body'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(15607449604231506)
,p_query_column_id=>9
,p_column_alias=>'MORE_DATA'
,p_column_display_sequence=>15
,p_column_heading=>'More Data'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5444144303568816)
,p_query_column_id=>10
,p_column_alias=>'ENTRY_STATUS_TYPE'
,p_column_display_sequence=>8
,p_column_heading=>'Entry Status Type'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5960846667537001)
,p_query_column_id=>11
,p_column_alias=>'ENTRY_ACTIONS'
,p_column_display_sequence=>10
,p_column_heading=>'Entry Actions'
,p_use_as_row_header=>'N'
,p_column_html_expression=>'#ENTRY_ACTIONS##ENTRY_OPTIONS_MENU#'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8725456169916138)
,p_query_column_id=>12
,p_column_alias=>'ENTRY_OPTIONS_MENU'
,p_column_display_sequence=>13
,p_use_as_row_header=>'N'
,p_hidden_column=>'Y'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(4929997352267905)
,p_query_column_id=>13
,p_column_alias=>'ENTRY_DATE'
,p_column_display_sequence=>2
,p_column_heading=>'Entry Date'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5443468883568809)
,p_query_column_id=>14
,p_column_alias=>'ENTRY_AUTHOR'
,p_column_display_sequence=>6
,p_column_heading=>'Entry Author'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(4930974119267915)
,p_query_column_id=>15
,p_column_alias=>'IMAGE_LINK'
,p_column_display_sequence=>4
,p_column_heading=>'Image Link'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5446940561568844)
,p_plug_name=>'Comment'
,p_region_name=>'comment'
,p_region_css_classes=>'padding-sm'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>41
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<a name="comments"></a><h2 class="padding-sm">Add Comment</h2>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_plug_display_when_condition=>'P100_ISSUE_NUMBER'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(8722597345916109)
,p_plug_name=>'Comment Buttons'
,p_parent_plug_id=>wwv_flow_imp.id(5446940561568844)
,p_region_css_classes=>'padding-sm'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noPadding:a-ButtonRegion--noUI'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_plug_display_point=>'SUB_REGIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(6186211948627143)
,p_plug_name=>'Feedback'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' ',
'  from wwv_flow_feedback ',
' where ISSUE_ID = :P100_ISSUE_ID',
'   and SECURITY_GROUP_ID = :flow_security_group_id'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(6335901170146534)
,p_name=>'Assignees'
,p_template=>wwv_flow_imp.id(179998957300224011)
,p_display_sequence=>50
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'wwv_flow_issue_int.get_avatar(p_user_name => stakeholder, p_image_size => 24, p_include_name => ''Y'', p_include_link => ''Y'', p_modifier_class => ''a-User--block'') as display_value',
'from wwv_flow_issue_stakeholders s',
'where s.issue_id = :P100_ISSUE_ID',
'  and s.stakeholder_type = ''ASSIGNEE'''))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(6221345279028573)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>'No Users Assigned'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
end;
/
begin
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(6336194780146536)
,p_query_column_id=>1
,p_column_alias=>'DISPLAY_VALUE'
,p_column_display_sequence=>1
,p_column_heading=>'Display Value'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(6445706829807314)
,p_name=>'Marked Duplicate Of'
,p_template=>wwv_flow_imp.id(179998957300224011)
,p_display_sequence=>40
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''<a href="''||apex_util.prepare_url(''f?p=''||:APP_ID||'':100:''||:APP_SESSION||''::::P100_ISSUE_ID:''||i1.duplicate_of)||''">#''||i2.issue_number||'' ''||wwv_flow_escape.html(i2.title)||''</a>'' as display_value',
'from wwv_flow_issues i2 ,',
'     wwv_flow_issues i1',
'where i1.id = :P100_ISSUE_ID',
'  and i2.id = i1.duplicate_of',
'  and i1.security_group_id = :flow_security_group_id',
'  and i2.security_group_id = :flow_security_group_id'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' from wwv_flow_issues ',
'where id = :P100_ISSUE_ID ',
'  and DUPLICATE_OF is not null',
'  and security_group_id = :flow_security_group_id'))
,p_display_condition_type=>'EXISTS'
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(6221345279028573)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>'Not Marked as duplicate'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(6445847908807315)
,p_query_column_id=>1
,p_column_alias=>'DISPLAY_VALUE'
,p_column_display_sequence=>1
,p_column_heading=>'Display Value'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(8722347756916107)
,p_plug_name=>'Actions Menu'
,p_region_name=>'issueActions'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>51
,p_include_in_reg_disp_sel_yn=>'Y'
,p_list_id=>wwv_flow_imp.id(6321465669737549)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_imp.id(5208269691267696)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(11426346067280827)
,p_name=>'Attachments'
,p_region_name=>'attachmentsReport'
,p_template=>wwv_flow_imp.id(179998957300224011)
,p_display_sequence=>90
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_item_display_point=>'BELOW'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with attachments as (',
'select case ',
'            when substr(mime_type,1,5) = ''image'' then ',
'                wwv_flow_lang.system_message(''APEX.ISSUES.IMAGES'')',
'            when substr(mime_type,1,11) = ''application'' then',
'                case ',
'                    when substr(mime_type,13) in (''zip'',''x-gzip'') then',
'                        wwv_flow_lang.system_message(''APEX.ISSUES.ZIP_FILES'')',
'                    else ',
'                        wwv_flow_lang.system_message(''APEX.ISSUES.DOCUMENTS'')',
'                    end',
'            when substr(mime_type,1,4) = ''text'' then',
'                wwv_flow_lang.system_message(''APEX.ISSUES.TEXT_FILES'')',
'            else ',
'                wwv_flow_lang.system_message(''APEX.ISSUES.OTHER'')',
'        end Image_type,',
'        ''1'' files',
'from wwv_flow_issue_attachments',
'where issue_id = :P100_ISSUE_ID',
'  and security_group_id = :flow_security_group_id)',
'select image_type, sum(files) number_of_files',
'from attachments',
'group By image_type',
'order by 1 asc',
'                ',
'        '))
,p_display_when_condition=>'P100_ALLOW_ISSUE_FILES_YN'
,p_display_when_cond2=>'Y'
,p_display_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_ajax_enabled=>'Y'
,p_ajax_items_to_submit=>'P100_ISSUE_ID'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(1046851149224553954)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(11426465825280828)
,p_query_column_id=>1
,p_column_alias=>'IMAGE_TYPE'
,p_column_display_sequence=>1
,p_column_heading=>'Image Type'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(1218954926620101)
,p_query_column_id=>2
,p_column_alias=>'NUMBER_OF_FILES'
,p_column_display_sequence=>2
,p_column_heading=>'Number Of Files'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(11426709614280831)
,p_plug_name=>'Attachment button'
,p_parent_plug_id=>wwv_flow_imp.id(11426346067280827)
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--noUI:a-ButtonRegion--accessibleTitle'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_plug_display_point=>'SUB_REGIONS'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(156403623260150739)
,p_name=>'Associated With'
,p_template=>wwv_flow_imp.id(179998957300224011)
,p_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''<a href="f?p=4000:1:''||:APP_SESSION||''::NO:RP:FB_FLOW_ID,F4000_P1_FLOW,P0_FLOWPAGE,RECENT_PAGES:''||f.id||'',''||f.id||'',''||f.id||''">''||f.id||'' - ''||wwv_flow_escape.html(f.name)||''</a>''||',
'        decode(s.id, null, null, ''<br/><a href="f?p=4000:4500:''||:APP_SESSION||''::::FB_FLOW_ID,FB_FLOW_PAGE_ID:''||f.id||'',''||s.id||''">''||s.id||'' - ''||wwv_flow_escape.html(s.name)||''</a>'') as display_value',
'  from wwv_flows f, ',
'     wwv_flow_steps s, ',
'     wwv_flow_issues i',
'where i.id = :P100_ISSUE_ID',
'  and f.id = i.application_id ',
'  and s.id (+) = i.page_id ',
'  and s.flow_id (+) = f.id',
'  and i.security_group_id = :flow_security_group_id',
'  and f.security_group_id = :flow_security_group_id',
'  and s.security_group_id (+) = :flow_security_group_id'))
,p_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' from wwv_flow_issues ',
'where id = :P100_ISSUE_ID ',
'  and APPLICATION_ID is not null',
'  and security_group_id = :flow_security_group_id'))
,p_display_condition_type=>'EXISTS'
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(6221345279028573)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>'Not Marked as duplicate'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(156403716995150740)
,p_query_column_id=>1
,p_column_alias=>'DISPLAY_VALUE'
,p_column_display_sequence=>1
,p_column_heading=>'Display Value'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(629071096340884086)
,p_plug_name=>'About'
,p_region_css_classes=>'a-Region--stacked a-Region--padded a-Region--flush a-Region--sideRegion'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Issued Details enables you to manage the life of an issue. On the main page you''ll see the issue timeline showing all events and comments in order of occurrence. On the right you''ll see the the options that help classify the issue.</p>',
'<p><a target="_blank" href="&SYSTEM_HELP_URL./htmdb/creating-and-updating-issues.html#GUID-72F71401-8528-44A1-82AA-FBAC83D23690">Learn More ...</a></p>',
''))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(11426676059280830)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(11426709614280831)
,p_button_name=>'VIEW_ATTACHMENTS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'View Attachments'
,p_button_redirect_url=>'f?p=&APP_ID.:112:&SESSION.::&DEBUG.:RP,112::'
,p_grid_new_row=>'Y'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(156403200471150735)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(6186211948627143)
,p_button_name=>'FEEDBACK'
,p_button_action=>'REDIRECT_APP'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'View Related Feedback'
,p_button_redirect_url=>'f?p=4650:8001:&SESSION.::&DEBUG.:RP:P8001_ID:&P100_RELATED_FEEDBACK.'
,p_grid_new_row=>'Y'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5611080609530318)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(4874178306998311)
,p_button_name=>'MANAGE_MILESTONES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_imp.id(5208338701524668)
,p_button_image_alt=>'Set Milestones'
,p_button_position=>'CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:106:&SESSION.::&DEBUG.:RP,105::'
,p_icon_css_classes=>'icon-edit'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5710376476527220)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(4874097402998310)
,p_button_name=>'MANAGE_LABELS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_imp.id(5208338701524668)
,p_button_image_alt=>'Set Labels'
,p_button_position=>'CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:107:&SESSION.::&DEBUG.:RP,107::'
,p_icon_css_classes=>'icon-edit'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(6336046011146535)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(6335901170146534)
,p_button_name=>'MANAGE_ASSIGNEES'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#:a-Button--regionHeader'
,p_button_template_id=>wwv_flow_imp.id(5208338701524668)
,p_button_image_alt=>'Set Assignees'
,p_button_position=>'CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:105:&SESSION.::&DEBUG.:RP,105::'
,p_icon_css_classes=>'icon-edit'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5840320533198707)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(4873675327998306)
,p_button_name=>'JUMP_TO_LATEST'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Jump to Latest'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'#comments'
,p_button_condition=>'P100_ISSUE_NUMBER'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_button_css_classes=>'a-Button--simple'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(6333633915146511)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(8722597345916109)
,p_button_name=>'CLOSE'
,p_button_static_id=>'CLOSE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Comment and Close'
,p_button_position=>'NEXT'
,p_button_condition=>'P100_STATUS'
,p_button_condition2=>'OPEN'
,p_button_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(6333763850146512)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(8722597345916109)
,p_button_name=>'REOPEN'
,p_button_static_id=>'REOPEN'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Comment and Reopen'
,p_button_position=>'NEXT'
,p_button_condition=>'P100_STATUS'
,p_button_condition2=>'CLOSED'
,p_button_condition_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(8722484274916108)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(4873675327998306)
,p_button_name=>'ISSUE_ACTIONS'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(656569185201725731)
,p_button_image_alt=>'Actions'
,p_button_position=>'NEXT'
,p_warn_on_unsaved_changes=>null
,p_button_condition=>'P100_ISSUE_NUMBER'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_button_css_classes=>'js-menuButton'
,p_icon_css_classes=>'icon-menu-drop-down'
,p_button_cattributes=>'data-menu="issueActions_menu"'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5712509758527242)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_imp.id(8722597345916109)
,p_button_name=>'COMMENT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Comment'
,p_button_position=>'NEXT'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(10420941074079407)
,p_branch_name=>'Go To Page 1 on Delete'
,p_branch_action=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP,100::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_EQUALS_CONDITION'
,p_branch_condition=>'DELETE'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(6446192775807318)
,p_branch_name=>'Go To Page 100'
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP:P100_COMMENT:&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(1664662478663424)
,p_name=>'P100_REQUEST'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_imp.id(4929538370267901)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(4930095638267906)
,p_name=>'P100_ISSUE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(4929538370267901)
,p_item_default=>'4840740643993632'
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(4930125701267907)
,p_name=>'P100_ISSUE_TITLE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(4929538370267901)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(4930434506267910)
,p_name=>'P100_ISSUE_SLUG'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(4929538370267901)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(4930507711267911)
,p_name=>'P100_ISSUE_CREATE_MESSAGE'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_imp.id(4929538370267901)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5610586983530313)
,p_name=>'P100_SUBSCRIBED'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(4874226588998312)
,p_prompt=>'Subscribe'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_imp.id(566754195708398878)
,p_item_template_options=>'#DEFAULT#'
,p_warn_on_unsaved_changes=>'I'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6332865140146503)
,p_name=>'P100_ISSUE_NUMBER'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_imp.id(4929538370267901)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6333852047146513)
,p_name=>'P100_STATUS'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_imp.id(4929538370267901)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6748593635011304)
,p_name=>'P100_ATTACH_FILES_TARGET_URL'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(5446940561568844)
,p_use_cache_before_default=>'NO'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_util.prepare_url(',
'    p_url => ''f?p=''||:APP_ID||'':109:''||:APP_SESSION||''::::P109_ISSUE_ID:''||:P100_ISSUE_ID',
')'))
,p_source_type=>'EXPRESSION'
,p_source_language=>'PLSQL'
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(8722615197916110)
,p_name=>'P100_RESPONSE_TEMPLATE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(5446940561568844)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(10637390756317401)
,p_name=>'P100_COMMENT'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_imp.id(5446940561568844)
,p_prompt=>'Comment'
,p_display_as=>'NATIVE_MARKDOWN_EDITOR'
,p_field_template=>wwv_flow_imp.id(571215478963548485)
,p_item_css_classes=>'a-IssueComments'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_encrypt_session_state_yn=>'N'
,p_plugin_init_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function(options) {',
'    var markDownEditor = this;   ',
'    markDownEditor.onBeforePreviewText = function(text){',
'        return apex.issues.replacePrefixImage(text, ''P100_ISSUE_ID'');',
'    };',
'    var templatesLOV = JSON.parse($v(''P100_RESPONSE_TEMPLATES''));',
'    var templateMenu = [];',
'    templatesLOV.forEach(function(element){',
'        templateMenu.push(',
'            {',
'                type: "action",',
'                label: element.templateName,',
'                action: function(){',
'                    getResponseTemplate(element.templateID) ;',
'                }',
'            }',
'        );  ',
'    });',
'    ',
'    // template and attach buttons',
'    apex.issues.addAttachButton(options, ''P100_ALLOW_ISSUE_FILES_YN'', ''P100_COMMENT'', ''P100_ATTACH_FILES_TARGET_URL'');',
'    ',
'    if(templateMenu.length > 0){',
'       options',
'        .toolbar',
'        .data[options.toolbar.data.length - 1]',
'        .controls',
'        .unshift(',
'            {',
'                type: ''MENU'',',
'                label: apex.lang.getMessage("APEX.ISSUES.JS.TEMPLATE"),',
'                menu: {',
'                    items: templateMenu',
'                }',
'            }',
'        );',
'    }',
'    ',
'    // Add the Open Dialog',
' ',
'   ',
'    return options;',
'}'))
,p_attribute_01=>'FULL'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(11428653597280850)
,p_name=>'P100_FILES_INFO'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_imp.id(4929538370267901)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(11591683961975602)
,p_name=>'P100_FILE_NAME_SLUG'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(11426346067280827)
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(156403868198150741)
,p_name=>'P100_RELATED_FEEDBACK'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(6186211948627143)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(562258638644331715)
,p_name=>'P100_RESPONSE_TEMPLATES'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_imp.id(5446940561568844)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(581217966139849507)
,p_name=>'P100_ALLOW_ISSUE_FILES_YN'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_imp.id(4929538370267901)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(581218638645849514)
,p_name=>'P100_ISSUE_DOESNT_EXIST'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(4873675327998306)
,p_item_default=>'The Issue requested does not exist in this workspace.'
,p_prompt=>'Issue does not exist'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>'P100_ISSUE_NUMBER'
,p_display_when_type=>'ITEM_IS_NULL'
,p_field_template=>wwv_flow_imp.id(571215478963548485)
,p_item_template_options=>'#DEFAULT#'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
,p_attribute_05=>'PLAIN'
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(1664804295663426)
,p_computation_sequence=>10
,p_computation_item=>'P100_REQUEST'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'EXPRESSION'
,p_computation_language=>'SQL'
,p_computation=>':REQUEST'
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(11427275187280836)
,p_computation_sequence=>20
,p_computation_item=>'P100_COMMENT'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(562258742389331716)
,p_computation_sequence=>30
,p_computation_item=>'P100_RESPONSE_TEMPLATES'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'FUNCTION_BODY'
,p_computation_language=>'PLSQL'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_json     varchar2(32767);',
'begin ',
'    l_json := l_json ||''['';',
'    --',
'    for templates in (select template_name, id',
'                        from wwv_flow_issue_templates',
'                       where template_type = ''RESPONSE''',
'                         and security_group_id = :flow_security_group_id',
'                     )',
'    loop',
'        l_json := l_json ',
'                  || ''{',
'                             "templateName": "''||apex_escape.json(templates.template_name)||''",',
'                             "templateID": "''||templates.id||''"',
'                       },'';',
'    end loop;',
'    l_json := rtrim(l_json,'','');',
'    --',
'    l_json := l_json || '']'';',
'    return l_json;',
'--',
'end;'))
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(156403948907150742)
,p_computation_sequence=>40
,p_computation_item=>'P100_RELATED_FEEDBACK'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id ',
'  from wwv_flow_feedback ',
' where ISSUE_ID = :P100_ISSUE_ID',
'   and SECURITY_GROUP_ID = :flow_security_group_id'))
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(581218035298849508)
,p_computation_sequence=>50
,p_computation_item=>'P100_ALLOW_ISSUE_FILES_YN'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ALLOW_ISSUE_FILES_YN',
'  from wwv_flow_companies',
' where provisioning_company_id = :flow_security_group_id;'))
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(5610668348530314)
,p_name=>'Change Subscription Status'
,p_event_sequence=>20
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P100_SUBSCRIBED'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5610731991530315)
,p_event_id=>wwv_flow_imp.id(5610668348530314)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :P100_SUBSCRIBED = ''Y'' then ',
'    wwv_flow_issue_int.add_subscribers(p_issue_id => :P100_ISSUE_ID, p_subscriber_ids => :APP_USER);',
'elsif :P100_SUBSCRIBED = ''N'' then ',
'    wwv_flow_issue_int.remove_subscribers(p_issue_id => :P100_ISSUE_ID, p_subscriber_ids => :APP_USER);',
'end if;'))
,p_attribute_02=>'P100_ISSUE_ID,P100_SUBSCRIBED'
,p_attribute_05=>'PLSQL'
,p_wait_for_result=>'Y'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5610892628530316)
,p_event_id=>wwv_flow_imp.id(5610668348530314)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(4929538370267901)
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(5611797666530325)
,p_name=>'Manage Milestones Dialog Close'
,p_event_sequence=>30
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(5611080609530318)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5611847854530326)
,p_event_id=>wwv_flow_imp.id(5611797666530325)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(4874178306998311)
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5611934378530327)
,p_event_id=>wwv_flow_imp.id(5611797666530325)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(4929538370267901)
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(5948003590329305)
,p_name=>'Manage Labels Dialog Close'
,p_event_sequence=>40
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(5710376476527220)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5948166716329306)
,p_event_id=>wwv_flow_imp.id(5948003590329305)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(4874097402998310)
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5948277520329307)
,p_event_id=>wwv_flow_imp.id(5948003590329305)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(4929538370267901)
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(6186776800627148)
,p_name=>'Actions Menu on Dialog Close'
,p_event_sequence=>50
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'[id^=issueActions_menu]'
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(6186809967627149)
,p_event_id=>wwv_flow_imp.id(6186776800627148)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(4929538370267901)
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(6186963934627150)
,p_event_id=>wwv_flow_imp.id(6186776800627148)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(6335901170146534)
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(6332694523146501)
,p_event_id=>wwv_flow_imp.id(6186776800627148)
,p_event_result=>'TRUE'
,p_action_sequence=>40
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(4874097402998310)
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(6332760764146502)
,p_event_id=>wwv_flow_imp.id(6186776800627148)
,p_event_result=>'TRUE'
,p_action_sequence=>50
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(4874178306998311)
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(6336201193146537)
,p_name=>'Manage Assignees Dialog Clode'
,p_event_sequence=>80
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(6336046011146535)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(6336368941146538)
,p_event_id=>wwv_flow_imp.id(6336201193146537)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(6335901170146534)
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(6336403753146539)
,p_event_id=>wwv_flow_imp.id(6336201193146537)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(4929538370267901)
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(6448325525807340)
,p_name=>'Issue Timleine Actions Dialog Closed '
,p_event_sequence=>120
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'#issueTimeline'
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(6448490558807341)
,p_event_id=>wwv_flow_imp.id(6448325525807340)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(4929538370267901)
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(11428499493280848)
,p_name=>'View Attachments Dialog Close'
,p_event_sequence=>130
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(11426676059280830)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterclosedialog'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(15606984295231501)
,p_event_id=>wwv_flow_imp.id(11428499493280848)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SET_VALUE'
,p_affected_elements_type=>'ITEM'
,p_affected_elements=>'P100_FILES_INFO'
,p_attribute_01=>'FUNCTION_BODY'
,p_attribute_06=>'return :P112_FILES_INFO;'
,p_attribute_08=>'N'
,p_attribute_09=>'N'
,p_wait_for_result=>'Y'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(11428517860280849)
,p_event_id=>wwv_flow_imp.id(11428499493280848)
,p_event_result=>'TRUE'
,p_action_sequence=>30
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var filesInfoArray,',
'	urlPrefix = ''#ISSUE_FILE#'',',
'	i,',
'	len,',
'	file,',
'	fileName,',
'	fileUrl,',
'	loadImagePrefix;',
'',
'if ($v(''P100_FILES_INFO'')) {',
'	filesInfoArray = JSON.parse($v(''P100_FILES_INFO''));',
'	len = filesInfoArray.length;',
'',
'	for (i = 0; i < len; i++) {',
'		file = filesInfoArray[i];',
'		fileName = file.n;',
'		fileUrl = urlPrefix + file.slug;',
'		loadImagePrefix = file.isImage ? ''!'' : '''';',
'',
'		insertFileReference(loadImagePrefix + ''['' + fileName + '']('' + fileUrl + '')'');',
'	}',
'',
'}',
''))
);
end;
/
begin
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(1665340621663431)
,p_event_id=>wwv_flow_imp.id(11428499493280848)
,p_event_result=>'TRUE'
,p_action_sequence=>40
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(11426346067280827)
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(40399849212841613)
,p_name=>'Render Markdown After Refresh'
,p_event_sequence=>140
,p_triggering_element_type=>'REGION'
,p_triggering_region_id=>wwv_flow_imp.id(4929538370267901)
,p_bind_type=>'bind'
,p_bind_event_type=>'apexafterrefresh'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(40399925435841614)
,p_event_id=>wwv_flow_imp.id(40399849212841613)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_SHOW'
,p_affected_elements_type=>'JAVASCRIPT_EXPRESSION'
,p_affected_elements=>'apex.widget.markdown.render(''.a-TimelineEntry-bodyContent'');'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(1664959024663427)
,p_name=>'Display File Not Found'
,p_event_sequence=>150
,p_condition_element=>'P100_REQUEST'
,p_triggering_condition_type=>'EQUALS'
,p_triggering_expression=>'FILENOTFOUND'
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(1665033003663428)
,p_event_id=>wwv_flow_imp.id(1664959024663427)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>'apex.theme.openRegion("noFileFound");'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(1665625507663434)
,p_name=>'View Attachments Dialog CANCEL'
,p_event_sequence=>160
,p_triggering_element_type=>'JAVASCRIPT_EXPRESSION'
,p_triggering_element=>'document'
,p_bind_type=>'bind'
,p_bind_event_type=>'custom'
,p_bind_event_type_custom=>'customDialogClose'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(1665711374663435)
,p_event_id=>wwv_flow_imp.id(1665625507663434)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(11426346067280827)
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(4930377421267909)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Get Issue Details'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN',
'',
'           :P100_ISSUE_NUMBER := null;',
'           :P100_ISSUE_TITLE := null;',
'           :P100_ISSUE_SLUG := null;',
'           :P100_ISSUE_CREATE_MESSAGE := null;',
'           :P100_STATUS := null;',
'',
'    select issue_number, ',
'           title, ',
'           slug, ',
'           wwv_flow_issue_int.get_user_name(created_by)||'' opened this issue ''||apex_util.get_since(created_on),',
'           status',
'      into :P100_ISSUE_NUMBER, ',
'           :P100_ISSUE_TITLE,',
'           :P100_ISSUE_SLUG,',
'           :P100_ISSUE_CREATE_MESSAGE,',
'           :P100_STATUS',
'      from wwv_flow_issues ',
'     where id = :P100_ISSUE_ID;',
'EXCEPTION ',
'    when NO_DATA_FOUND then ',
'        null;',
'END;',
'          ',
'  '))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Not able to get issue detail.'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'P100_ISSUE_ID'
,p_process_when_type=>'ITEM_IS_NOT_NULL'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6448767675807344)
,p_process_sequence=>20
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'showComment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'',
'wwv_flow_issue_int.show_comment(p_comment_id =>apex_application.g_x01 );',
'',
'  ',
'sys.htp.p(''{"return": "SUCCESS"}'');',
'',
'    ',
'END;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6448855654807345)
,p_process_sequence=>30
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'hideComment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'',
'wwv_flow_issue_int.hide_comment(p_comment_id => apex_application.g_x01);',
'',
'sys.htp.p(''{"return": "SUCCESS"}'');',
'    ',
'END;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'JOEY'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>'DOUG'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6766034959282902)
,p_process_sequence=>40
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'deleteComment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'',
'wwv_flow_issue_int.delete_comment(p_comment_id => apex_application.g_x01 );',
'',
'',
'sys.htp.p(''{"return": "SUCCESS"}'');',
'    ',
'END;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'JOEY'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>'DOUG'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(11170716936554339)
,p_process_sequence=>60
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'getResponseTemplate'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_template varchar2(32767);',
'begin ',
'    --',
'    for template in (select template_text',
'                        from wwv_flow_issue_templates',
'                       where id = apex_application.g_x01',
'                         and security_group_id = :flow_security_group_id',
'                     )',
'    loop',
'        l_template := ''{"text": "''||apex_escape.json(template.template_text)||''"}'';',
'    end loop;',
'    --',
'    sys.htp.p(l_template);',
'--',
'end;',
'',
''))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(11591516245975601)
,p_process_sequence=>70
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'getAttachment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_file_blob wwv_flow_issue_attachments.file_blob%type;',
'    l_mime_type wwv_flow_issue_attachments.mime_type%type;',
'    l_charset   wwv_flow_issue_attachments.charset%type;',
'    l_file_name wwv_flow_issue_attachments.file_name%type;',
'begin    ',
'',
'    select file_blob,',
'           mime_type,',
'           charset, ',
'           file_name',
'      into l_file_blob,',
'           l_mime_type,',
'           l_charset,',
'           l_file_name',
'      from wwv_flow_issue_attachments',
'     where issue_id          = :P100_ISSUE_ID',
'       and file_name_slug    = :P100_FILE_NAME_SLUG',
'       and security_group_id = :flow_security_group_id;',
'       ',
'    -- download zip file to the browser',
'    sys.htp.init;',
'    apex_application.g_page_text_generated := true;',
'    wwv_flow_utilities.print_download_header (',
'        p_mime_type      => l_mime_type,',
'        p_mime_charset   => l_charset,',
'        p_file_name      => l_file_name,',
'        p_is_attachment  => true,',
'        p_content_length => length( l_file_blob ));',
'    sys.owa_util.http_header_close;',
'    sys.wpg_docload.download_file( l_file_blob );',
'    ',
'    apex_application.stop_apex_engine;',
'exception ',
'    when NO_DATA_FOUND then ',
'        apex_util.redirect_url(''f?p=4600:100:''||:APP_SESSION||'':FILENOTFOUND:NO:RP:P100_ISSUE_ID:''||:P100_ISSUE_ID);',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(15607567032231507)
,p_process_sequence=>80
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'getFullText'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
' declare',
'     l_clob   clob;',
'     l_chunk  varchar2(32767);',
'     l_offset pls_integer;',
' begin',
'',
'if apex_application.g_x01 = ''ISSUE'' then ',
'     select issue_text',
'       into l_clob',
'       from wwv_flow_issues',
'      where id = to_number(apex_application.g_x02)',
'        and security_group_id = :flow_security_group_id;',
'     --',
'     while apex_string.next_chunk (',
'               p_str    => l_clob,',
'               p_chunk  => l_chunk,',
'               p_offset => l_offset )',
'     loop',
'         sys.htp.prn(apex_escape.html(l_chunk));',
'     end loop;',
'else ',
'     select comment_text',
'       into l_clob',
'       from wwv_flow_issue_comments',
'      where id = to_number(apex_application.g_x02)',
'        and security_group_id = :flow_security_group_id;',
'     --',
'     while apex_string.next_chunk (',
'               p_str    => l_clob,',
'               p_chunk  => l_chunk,',
'               p_offset => l_offset )',
'     loop',
'         sys.htp.prn(apex_escape.html(l_chunk));',
'     end loop;',
'end if;',
'',
'end;',
'',
''))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5712762134527244)
,p_process_sequence=>10
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Save Comment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_comment_id number;',
'BEGIN',
'',
'IF :P100_COMMENT IS NOT NULL THEN ',
'    insert into wwv_flow_issue_comments ',
'    (Issue_id, comment_text)',
'    values',
'    (:P100_ISSUE_ID, :P100_COMMENT)',
'    returning id into l_comment_id;',
'    --',
'    commit;',
'    ',
'    --',
'    wwv_flow_issue_notify_int.add_notification( p_notification_type => ''COMMENT_ADD'',',
'                                                p_issue_id => null,',
'                                                p_comment_id => l_comment_id,',
'                                                p_event_id => null);',
'END IF;',
'',
'END;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'COMMENT,CLOSE,REOPEN'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6445917261807316)
,p_process_sequence=>20
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Mark Issue Closed'
,p_process_sql_clob=>'wwv_flow_issue_int.set_status(:P100_ISSUE_ID, ''CLOSED'');'
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_imp.id(6333633915146511)
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6446071303807317)
,p_process_sequence=>30
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Mark Issue Open'
,p_process_sql_clob=>'wwv_flow_issue_int.set_status(:P100_ISSUE_ID, ''OPEN'');'
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_imp.id(6333763850146512)
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(10420810126079406)
,p_process_sequence=>40
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Soft Delete Issue'
,p_process_sql_clob=>'wwv_flow_issue_int.soft_delete_issue(p_issue_id => :P100_ISSUE_ID);'
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'DELETE'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
,p_process_success_message=>'Issue successfully deleted.'
);
end;
/
prompt --application/pages/page_00101
begin
wwv_flow_imp_page.create_page(
 p_id=>101
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Edit Issue Text'
,p_page_mode=>'MODAL'
,p_step_title=>'Edit Issue Text'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_javascript_file_urls=>'#IMAGE_PREFIX#apex_ui/js/issues.utils.js'
,p_step_template=>wwv_flow_imp.id(126075773730973072)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_page_component_map=>'16'
,p_last_upd_yyyymmddhh24miss=>'20200218092731'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(6334297351146517)
,p_plug_name=>'Issue text'
,p_region_css_classes=>'padding-md'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(11846777498214663)
,p_plug_name=>'Button Region '
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(6400639309645830)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(11846777498214663)
,p_button_name=>'APPLY'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'CREATE'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6334306885146518)
,p_name=>'P101_ISSUE_TEXT'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(6334297351146517)
,p_prompt=>'Issue Text'
,p_display_as=>'NATIVE_MARKDOWN_EDITOR'
,p_field_template=>wwv_flow_imp.id(10128482508892221)
,p_item_template_options=>'#DEFAULT#'
,p_encrypt_session_state_yn=>'N'
,p_plugin_init_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function(options){',
'    var markdownEditor = this;',
'    markdownEditor.onBeforePreviewText = function(text){',
'        return apex.issues.replacePrefixImage(text, ''P101_ISSUE_ID'');',
'    };',
'    ',
'    apex.issues.addAttachButton(options, ''P101_ALLOW_ISSUE_FILES_YN'', ''P101_ISSUE_TEXT'', ''P101_ATTACH_FILES_TARGET_URL'');',
'    //apex.issues.addHeadButton(options);',
'}'))
,p_attribute_01=>'SIMPLE'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(40400426528841619)
,p_name=>'P101_ISSUE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(6334297351146517)
,p_item_default=>'P100_ISSUE_ID'
,p_item_default_type=>'ITEM'
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(495964836588606405)
,p_name=>'P101_ALLOW_ISSUE_FILES_YN'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(6334297351146517)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(495965030999606407)
,p_name=>'P101_ATTACH_FILES_TARGET_URL'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(6334297351146517)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_util.prepare_url(',
'    p_url => ''f?p=''||:APP_ID||'':109:''||:APP_SESSION||''::::P109_ISSUE_ID:''||:P101_ISSUE_ID',
')'))
,p_source_type=>'EXPRESSION'
,p_source_language=>'PLSQL'
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(495964963214606406)
,p_computation_sequence=>10
,p_computation_item=>'P101_ALLOW_ISSUE_FILES_YN'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ALLOW_ISSUE_FILES_YN',
'  from wwv_flow_companies',
' where provisioning_company_id = :flow_security_group_id;'))
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6334562680146520)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Issue text'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_issue_text clob;',
'',
'begin  ',
'    -- Get the original comment text ',
'    select issue_text ',
'      into l_issue_text',
'      from wwv_flow_issues',
'     where id = :P100_ISSUE_ID',
'       and security_group_id = :flow_security_group_id;',
'       ',
'    -- Update the table with the new comment',
'    update wwv_flow_issues',
'      set  issue_text = :P101_ISSUE_TEXT',
'     where ID = :P100_ISSUE_ID',
'      and  security_group_id = :flow_security_group_id;',
'    --',
'    commit;',
'      ',
'    -- Track the edit passing the old comment text',
'    wwv_flow_issue_int.track_issue_edit(p_issue_id =>:P100_ISSUE_ID,  p_issue_text => l_issue_text);',
'',
'end;',
'',
''))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6334758153146522)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6334403104146519)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'GET ISSUE_TEXT'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'select issue_text ',
'  into :P101_ISSUE_TEXT',
'  from wwv_flow_issues ',
' where id = :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id;',
'END;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00102
begin
wwv_flow_imp_page.create_page(
 p_id=>102
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Edit Issue Title'
,p_page_mode=>'MODAL'
,p_step_title=>'Edit Issue Title'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_step_template=>wwv_flow_imp.id(126075773730973072)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_dialog_height=>'300'
,p_page_component_map=>'16'
,p_last_upd_yyyymmddhh24miss=>'20200108112048'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(12740780471989523)
,p_plug_name=>'Issue Title'
,p_region_css_classes=>'padding-md'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(18253260619057669)
,p_plug_name=>'Button Region '
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(6407041119843008)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(18253260619057669)
,p_button_name=>'APPLY_CHANGES'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'CREATE'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(6335837729146533)
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6335353569146528)
,p_name=>'P102_ISSUE_SLUG'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(12740780471989523)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6407789750843020)
,p_name=>'P102_ISSUE_TITLE'
,p_is_required=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(12740780471989523)
,p_prompt=>'Issue Title'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>255
,p_cHeight=>2
,p_field_template=>wwv_flow_imp.id(566754195708398878)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'Y'
,p_attribute_04=>'BOTH'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(150599385643090737)
,p_validation_name=>'Title is unique in workspace'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1''',
'  from wwv_flow_issues',
' where title = :P102_ISSUE_TITLE',
'   and ID != :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>'Title must be unique within the workspace. Please enter another value.'
,p_associated_item=>wwv_flow_imp.id(6407789750843020)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(150599462651090738)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Generate Slug'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P102_ISSUE_SLUG := wwv_flow_issue_int.gen_slug(:P102_ISSUE_TITLE);',
'',
''))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6408554903843037)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Issue title and slug'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin  ',
'    update wwv_flow_issues',
'      set  title = :P102_ISSUE_TITLE, ',
'           slug = :P102_ISSUE_SLUG',
'     where ID = :P100_ISSUE_ID',
'      and  security_group_id = :flow_security_group_id;',
'end;',
'',
''))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_imp.id(6407041119843008)
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6408168465843036)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Get Title '
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'select TITLE,',
'       SLUG',
'  into :P102_ISSUE_TITLE,',
'       :P102_ISSUE_SLUG',
'  from wwv_flow_issues ',
' where id = :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id;',
'END;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00103
begin
wwv_flow_imp_page.create_page(
 p_id=>103
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Mark Duplicate'
,p_page_mode=>'MODAL'
,p_step_title=>'Mark Duplicate'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_step_template=>wwv_flow_imp.id(694269863376113197)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_page_component_map=>'16'
,p_last_upd_yyyymmddhh24miss=>'20190823143059'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(6336576116146540)
,p_plug_name=>'Comment'
,p_region_name=>'comment_region'
,p_region_template_options=>'#DEFAULT#:a-Form--labelsAbove'
,p_region_attributes=>'style="display:none;"'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(19170670253487938)
,p_plug_name=>'Search'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--noBorder:a-Region--accessibleHeader'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(24683150400556084)
,p_plug_name=>'Button Region '
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(6430438945498420)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(24683150400556084)
,p_button_name=>'MARK_DUPLICATE'
,p_button_static_id=>'MarkDuplicate'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply'
,p_button_position=>'NEXT'
,p_button_cattributes=>'style="disabled=true;"'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(6337229936146547)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(24683150400556084)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'PREVIOUS'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(6434443563498451)
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6336649483146541)
,p_name=>'P103_COMMENTS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(6336576116146540)
,p_prompt=>'Comments'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>30
,p_cHeight=>10
,p_field_template=>wwv_flow_imp.id(566754195708398878)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6336765193146542)
,p_name=>'P103_ISSUES'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(19170670253487938)
,p_prompt=>'Duplicate Issue'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Select ''#''||issue_number||'' ''||title d, id r',
'  from wwv_flow_issues',
' where security_group_id = :flow_security_group_id',
'   and id != :P100_ISSUE_ID',
' order by created_on asc , issue_number asc '))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Issue is not a duplicate -'
,p_cHeight=>1
,p_field_template=>wwv_flow_imp.id(566754273980399706)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6444900084807306)
,p_name=>'P103_CURRENT_DUP'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(19170670253487938)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(6337386049146548)
,p_name=>'Cancel Dialog'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(6337229936146547)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(6337493785146549)
,p_event_id=>wwv_flow_imp.id(6337386049146548)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(6444468363807301)
,p_name=>'On Change'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P103_ISSUES'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(6444578083807302)
,p_event_id=>wwv_flow_imp.id(6444468363807301)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var newIssue = $v(''P103_ISSUES'');',
'var oldIssue = $v(''P103_CURRENT_DUP'');',
'',
'console.log( $v(''P103_ISSUES''));',
'console.log( $v(''P103_CURRENT_DUP''));',
'',
'if (!newIssue) { ',
'    if (!oldIssue ) { ',
'        $(''#comment_region'').hide();',
'        apex.item( "MarkDuplicate" ).disable();',
'    } else {',
'        $(''#comment_region'').show();',
'        apex.item( "MarkDuplicate" ).enable();',
'    } ',
'} else if (newIssue == oldIssue) {',
'    $(''#comment_region'').hide();',
'    apex.item( "MarkDuplicate" ).disable();',
'',
'} else {',
'    $(''#comment_region'').show();',
'    apex.item( "MarkDuplicate" ).enable();',
'',
'}',
''))
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6433050199498449)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Duplicate and Create Comment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin  ',
'    -- Update the duplicate ',
'    if :P103_ISSUES IS NOT NULL then ',
'        wwv_flow_issue_int.add_duplicate( p_issue_id => :P100_ISSUE_ID,',
'                                           p_duplicate_issue_id => :P103_ISSUES,',
'                                           p_duplicate_identified_on => sysdate,',
'                                           p_duplicate_identified_by => :APP_USER);',
'    else',
'        wwv_flow_issue_int.remove_duplicate( p_issue_id => :P100_ISSUE_ID);',
'    end if;',
'      ',
'    ',
'    -- Add the Comment ',
'    if :P103_COMMENTS is not null then ',
'',
'        insert into wwv_flow_issue_comments ',
'            (Issue_id, comment_text)',
'            values',
'            (:P100_ISSUE_ID, :P103_COMMENTS);',
'        ',
'    end if;',
'end;',
'',
''))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6337539622146550)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load Duplicate'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select duplicate_of a, ',
'       duplicate_of b',
'  into :P103_ISSUES,',
'       :P103_CURRENT_DUP',
'  from wwv_flow_issues ',
' where id = :P100_ISSUE_ID',
'  and security_group_id = :flow_security_group_id;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_issues',
'where id = :P100_ISSUE_ID ',
'  and security_group_id = :flow_security_group_id ',
'  and duplicate_of is not null'))
,p_process_when_type=>'EXISTS'
);
end;
/
prompt --application/pages/page_00104
begin
wwv_flow_imp_page.create_page(
 p_id=>104
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Associate Application and Page'
,p_page_mode=>'MODAL'
,p_step_title=>'Associate Application and Page'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_step_template=>wwv_flow_imp.id(694269863376113197)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_page_component_map=>'16'
,p_last_upd_yyyymmddhh24miss=>'20190917053204'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(12813282274569173)
,p_plug_name=>'Comment'
,p_region_name=>'comment_region'
,p_region_template_options=>'#DEFAULT#:a-Form--labelsAbove'
,p_region_attributes=>'style="display:none;"'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(25647376411910571)
,p_plug_name=>'Search'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--noBorder:a-Region--accessibleHeader'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(31159856558978717)
,p_plug_name=>'Button Region '
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(6477306760422666)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(31159856558978717)
,p_button_name=>'ASSIGN_PAGE'
,p_button_static_id=>'AssignPage'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply'
,p_button_position=>'NEXT'
,p_button_cattributes=>'style="disabled=true;"'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(6477772252422672)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(31159856558978717)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'PREVIOUS'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(6482568654422746)
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6445251176807309)
,p_name=>'P104_PAGE'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(25647376411910571)
,p_prompt=>'Page '
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'  from wwv_flow_steps',
' where security_group_id = :flow_security_group_id and ',
'    FLOW_ID = :P104_APPLICATIONS',
' order by id'))
,p_lov_display_null=>'YES'
,p_lov_cascade_parent_items=>'P104_APPLICATIONS'
,p_ajax_items_to_submit=>'P104_APPLICAITONS'
,p_ajax_optimize_refresh=>'Y'
,p_cHeight=>1
,p_begin_on_new_line=>'N'
,p_field_template=>wwv_flow_imp.id(566754195708398878)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'YES'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6445328286807310)
,p_name=>'P104_ORIG_PAGE'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(25647376411910571)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6478494381422678)
,p_name=>'P104_APPLICATIONS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(25647376411910571)
,p_prompt=>'Application'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'APPLICATION NAME RETURNING ID'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id',
'       || ''. ''',
'       || name d,',
'       id r',
'  from wwv_flows f',
' where security_group_id = :flow_security_group_id',
'   and not exists (',
'    select null',
'      from wwv_flow_language_map',
'     where translation_flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
')',
'   and ( exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id is null',
'       and security_group_id = :flow_security_group_id',
')',
'    or exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
') )',
'order by id'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- No Application Assigned -'
,p_cHeight=>1
,p_field_template=>wwv_flow_imp.id(566754195708398878)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_lov_display_extra=>'NO'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6478889498422696)
,p_name=>'P104_ORIG_APP'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(25647376411910571)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6479519038422698)
,p_name=>'P104_COMMENTS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(12813282274569173)
,p_prompt=>'Comments'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>30
,p_cHeight=>10
,p_field_template=>wwv_flow_imp.id(566754195708398878)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(6480725217422741)
,p_name=>'Cancel Dialog'
,p_event_sequence=>20
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(6477772252422672)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(6481256132422742)
,p_event_id=>wwv_flow_imp.id(6480725217422741)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(6481571935422742)
,p_name=>'On Change'
,p_event_sequence=>30
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P104_APPLICATIONS,P104_PAGE'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(6482006217422743)
,p_event_id=>wwv_flow_imp.id(6481571935422742)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var newApp     = $v(''P104_APPLICATIONS'');',
'var oldApp     = $v(''P104_ORIG_APP'');',
'var newPage    = $v(''P104_PAGE'');',
'var oldPage    = $v(''P104_ORIG_PAGE'');',
'',
'',
'// If no app & page have been assigned',
'if (!newApp && !newPage) { ',
'    // If the current record has no app/page assigned',
'    if (!oldApp && !oldPage ) { ',
'        //Then there has been no change - Disable all the things.',
'        $(''#comment_region'').hide();',
'        apex.item( "AssignPage" ).disable();',
'    } else {',
'        //Otherwise, enable stuff ',
'        $(''#comment_region'').show();',
'        apex.item( "AssignPage" ).enable();',
'    } ',
'  // If the values are not null but the same as the originals  ',
'} else if (newApp === oldApp &&  newPage === oldPage) {',
'    // Then no change - Disable',
'    $(''#comment_region'').hide();',
'    apex.item( "AssignPage" ).disable();',
'} else {',
'    //Change is happening. ',
'    $(''#comment_region'').show();',
'    apex.item( "AssignPage" ).enable();',
'}',
''))
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6480392587422739)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update Association and create comment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin  ',
'    -- Update the Assignment ',
'    if :P104_APPLICATIONS is not null then ',
'        wwv_flow_issue_int.add_association(p_issue_id => :P100_ISSUE_ID,',
'                                            p_application_id => :P104_APPLICATIONS,',
'                                            p_page_id => :P104_PAGE);',
'    else ',
'        wwv_flow_issue_int.remove_association(p_issue_id => :P100_ISSUE_ID);',
'    end if;',
'    ',
'    -- Add the Comment ',
'    if :P104_COMMENTS is not null then ',
'',
'        insert into wwv_flow_issue_comments ',
'            (Issue_id, comment_text)',
'            values',
'            (:P100_ISSUE_ID, :P104_COMMENTS);',
'     ',
'    end if;',
' end;   ',
'  '))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6479952155422738)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Load Assignment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select application_id , ',
'       application_id ,',
'       page_id ,',
'       page_id ',
'  into :P104_APPLICATIONS,',
'       :P104_ORIG_APP,',
'       :P104_PAGE,',
'       :P104_ORIG_PAGE',
'  from wwv_flow_issues ',
' where id = :P100_ISSUE_ID',
'  and security_group_id = :flow_security_group_id;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_issues',
'where id = :P100_ISSUE_ID ',
'  and security_group_id = :flow_security_group_id ',
'  and application_id is not null'))
,p_process_when_type=>'EXISTS'
);
end;
/
prompt --application/pages/page_00105
begin
wwv_flow_imp_page.create_page(
 p_id=>105
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Assignees'
,p_page_mode=>'MODAL'
,p_step_title=>'Assignees'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_inline_css=>'.nodatafound {padding: 32px; text-align: center;}'
,p_step_template=>wwv_flow_imp.id(126075773730973072)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_dialog_width=>'480'
,p_dialog_attributes=>'maxHeight: ''640px'''
,p_page_component_map=>'03'
,p_last_upd_yyyymmddhh24miss=>'20190917060743'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(5445151085568826)
,p_name=>'Assignees'
,p_template=>wwv_flow_imp.id(214132567690623104)
,p_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-ContentRowReport--hideIcons'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'  null as ITEM_CUSTOM_ATTRS,',
'  null as ITEM_CSS_MODIFIERS,',
'  ',
'  apex_item.checkbox2(p_idx => 1, ',
'                      p_value => user_name, ',
'                      p_attributes =>( select ''CHECKED''',
'                                              from wwv_flow_issue_stakeholders s',
'                                          where s.stakeholder = u.user_name',
'                                            and s.issue_id = :P100_ISSUE_ID',
'                                            and s.stakeholder_type = ''ASSIGNEE'') || '' class="u-vh apex-ui-selector-input"'',',
'                           p_item_id => ''cb_''||user_name) || ''<label aria-labelledby="label_''||user_name||''" for="cb_''||user_name||''" class="apex-ui-selector"></label>''  as ITEM_SELECTION,',
'  ''<label for="cb_''||user_name||''" id="label_''||user_name||''">''||wwv_flow_issue_int.get_avatar (p_user_name => user_name, p_include_name => ''Y'')||''</label>'' as ITEM_TITLE,',
'  null as ITEM_ICON,',
'  null as ITEM_LINK,',
'  null as ITEM_DESCRIPTION,',
'  null as ITEM_MISC,',
'  null as ITEM_ACTIONS',
'  from wwv_flow_fnd_user u',
'  where security_group_id = :flow_security_group_id',
'    and wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => u.user_name) is not null',
'',
'',
'',
''))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(6811165341870886)
,p_query_num_rows=>500
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>'No assignees found.'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8724532710916129)
,p_query_column_id=>1
,p_column_alias=>'ITEM_CUSTOM_ATTRS'
,p_column_display_sequence=>1
,p_column_heading=>'Item Custom Attrs'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8724614189916130)
,p_query_column_id=>2
,p_column_alias=>'ITEM_CSS_MODIFIERS'
,p_column_display_sequence=>2
,p_column_heading=>'Item Css Modifiers'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8724716994916131)
,p_query_column_id=>3
,p_column_alias=>'ITEM_SELECTION'
,p_column_display_sequence=>3
,p_column_heading=>'Item Selection'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8724872976916132)
,p_query_column_id=>4
,p_column_alias=>'ITEM_TITLE'
,p_column_display_sequence=>4
,p_column_heading=>'Item Title'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8724929432916133)
,p_query_column_id=>5
,p_column_alias=>'ITEM_ICON'
,p_column_display_sequence=>5
,p_column_heading=>'Item Icon'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8725083927916134)
,p_query_column_id=>6
,p_column_alias=>'ITEM_LINK'
,p_column_display_sequence=>6
,p_column_heading=>'Item Link'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8725114396916135)
,p_query_column_id=>7
,p_column_alias=>'ITEM_DESCRIPTION'
,p_column_display_sequence=>7
,p_column_heading=>'Item Description'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8725211699916136)
,p_query_column_id=>8
,p_column_alias=>'ITEM_MISC'
,p_column_display_sequence=>8
,p_column_heading=>'Item Misc'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8725340384916137)
,p_query_column_id=>9
,p_column_alias=>'ITEM_ACTIONS'
,p_column_display_sequence=>9
,p_column_heading=>'Item Actions'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5446410161568839)
,p_plug_name=>'Button Region '
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5446323081568838)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(5446410161568839)
,p_button_name=>'APPLY'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'CREATE'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(165799887329198819)
,p_name=>'Refresh Search'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P105_SEARCH'
,p_bind_type=>'bind'
,p_bind_event_type=>'keyup'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(581219915741849527)
,p_event_id=>wwv_flow_imp.id(165799887329198819)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>':P105_SEARCH := :P105_SEARCH;'
,p_attribute_02=>'P105_SEARCH'
,p_attribute_05=>'PLSQL'
,p_wait_for_result=>'Y'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(165799981641198820)
,p_event_id=>wwv_flow_imp.id(165799887329198819)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(5445151085568826)
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5446521079568840)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Process Assignees'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_assignees varchar2(4000);',
'    l_unassign  varchar2(4000);',
'BEGIN',
'  FOR i in 1..APEX_APPLICATION.G_F01.COUNT LOOP',
'    BEGIN',
'      IF APEX_APPLICATION.G_F01(i) IS NOT NULL THEN',
'          l_assignees := l_assignees ||APEX_APPLICATION.G_F01(i)||'':'';',
'      END IF;',
'      EXCEPTION WHEN DUP_VAL_ON_INDEX THEN NULL;',
'    END;',
'  END LOOP;',
'  ',
'  l_assignees := trim(BOTH '':'' from l_assignees);',
'  ',
'  wwv_flow_issue_int.add_assignees(p_issue_id => :P100_ISSUE_ID, p_assignee_ids => l_assignees);',
'  ',
'  for a in (select user_name from wwv_flow_fnd_user where security_group_id = :flow_security_group_id) LOOP',
'      if nvl(instr(l_assignees, a.user_name),0) = 0 then ',
'          l_unassign := l_unassign || a.user_name ||'':'';',
'      end if;',
'  end loop;',
'  ',
'  l_unassign := trim(BOTH '':'' from l_unassign);',
'  wwv_flow_issue_int.remove_assignees(p_issue_id => :P100_ISSUE_ID, p_assignee_ids => l_unassign);',
'  ',
'END;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5447125281568846)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00106
begin
wwv_flow_imp_page.create_page(
 p_id=>106
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Milestones'
,p_page_mode=>'MODAL'
,p_step_title=>'Milestones'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_inline_css=>'.nodatafound {padding: 32px; text-align: center;}'
,p_step_template=>wwv_flow_imp.id(126075773730973072)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_dialog_width=>'480'
,p_page_component_map=>'03'
,p_last_upd_yyyymmddhh24miss=>'20191115114338'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5612570225530333)
,p_plug_name=>'Item Region'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_01'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(11082864205500636)
,p_name=>'Milestones'
,p_region_name=>'milestones'
,p_template=>wwv_flow_imp.id(214132567690623104)
,p_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#:a-ContentRowReport--hideIcons'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'  null as ITEM_CUSTOM_ATTRS,',
'  null as ITEM_CSS_MODIFIERS,',
'  ',
'  apex_item.checkbox2(p_idx        => 1, ',
'                      p_value      => id, ',
'                      p_attributes =>( select ''CHECKED''',
'                                              from wwv_flow_issue_milestones im',
'                                          where im.issue_id = :P100_ISSUE_ID',
'                                            and im.milestone_id = m.id) || '' class="u-vh apex-ui-selector-input"'',',
'                      p_item_id     => ''cb_''||id) || ''<label class="apex-ui-selector" for="cb_''||id||''" aria-labelledby="label_''||id||''"></label>''  as ITEM_SELECTION,',
'  ''<label for="cb_''||id||''" id="label_''||id||''">''||wwv_flow_escape.html(milestone_name)||''</label>'' as ITEM_TITLE,',
'  case ',
'      when milestone_status = ''CLOSED'' then ''fa fa-check-square xfam-check xfam-is-success u-success-text''',
'      when milestone_status = ''OPEN'' then',
'        case ',
'             when sysdate > milestone_date  then ''fa fa-exclamation-circle xfam-warning xfam-is-danger u-danger-text''',
'             when sysdate + 15 > milestone_date then ''fa fa-warning xfam-warning xfam-is-warning u-warning-text''',
'             else ''fa fa-flag-o''',
'        end ',
'  end as ITEM_ICON,',
'  null as ITEM_LINK,',
'  case ',
'      when milestone_status = ''CLOSED'' then ''<span class="fa fa-check-square u-success-text" aria-hidden="true"></span> Closed &mdash; '' || to_char(milestone_date, ''Month DD YYYY'')',
'      when milestone_status = ''OPEN'' then',
'        case ',
'             when sysdate > milestone_date  then ''<span class="fa fa-warning u-danger-text" aria-hidden="true"></span> Past due &mdash; '' || apex_util.get_since(milestone_date)',
'             when sysdate + 15 > milestone_date then ''<span aria-hidden="true" class="fa fa-info-square u-warning-text"></span> Due &mdash; '' || apex_util.get_since(milestone_date)',
'             else ''<span aria-hidden="true" class="fa fa-calendar-o"></span> Due &mdash; '' || apex_util.get_since(milestone_date)',
'        end ',
'  end as ITEM_DESCRIPTION,',
'',
'  -- apex_util.get_since(milestone_date) as ITEM_DESCRIPTION,',
'  null as ITEM_MISC,',
'  null as ITEM_ACTIONS',
'  ',
'  from wwv_flow_milestones m',
' where security_group_id = :flow_security_group_id',
'   and (',
'           (:P106_SHOW_CLOSED_YN is null and milestone_status = ''OPEN'')',
'           or',
'           (:P106_SHOW_CLOSED_YN = ''Y'')',
'       )',
' order by milestone_date asc',
''))
,p_ajax_enabled=>'Y'
,p_ajax_items_to_submit=>'P106_SHOW_CLOSED_YN'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(6811165341870886)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>'No Milestones have been defined.'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8726052589916144)
,p_query_column_id=>1
,p_column_alias=>'ITEM_CUSTOM_ATTRS'
,p_column_display_sequence=>1
,p_column_heading=>'Item Custom Attrs'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8726181300916145)
,p_query_column_id=>2
,p_column_alias=>'ITEM_CSS_MODIFIERS'
,p_column_display_sequence=>2
,p_column_heading=>'Item Css Modifiers'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8726213296916146)
,p_query_column_id=>3
,p_column_alias=>'ITEM_SELECTION'
,p_column_display_sequence=>3
,p_column_heading=>'Item Selection'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8726394719916147)
,p_query_column_id=>4
,p_column_alias=>'ITEM_TITLE'
,p_column_display_sequence=>4
,p_column_heading=>'Item Title'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8726415030916148)
,p_query_column_id=>5
,p_column_alias=>'ITEM_ICON'
,p_column_display_sequence=>5
,p_column_heading=>'Item Icon'
,p_use_as_row_header=>'N'
,p_column_html_expression=>'fa-lg #ITEM_ICON#'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8726580151916149)
,p_query_column_id=>6
,p_column_alias=>'ITEM_LINK'
,p_column_display_sequence=>6
,p_column_heading=>'Item Link'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8726637197916150)
,p_query_column_id=>7
,p_column_alias=>'ITEM_DESCRIPTION'
,p_column_display_sequence=>7
,p_column_heading=>'Item Description'
,p_use_as_row_header=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(6872159638843401)
,p_query_column_id=>8
,p_column_alias=>'ITEM_MISC'
,p_column_display_sequence=>8
,p_column_heading=>'Item Misc'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(6872256299843402)
,p_query_column_id=>9
,p_column_alias=>'ITEM_ACTIONS'
,p_column_display_sequence=>9
,p_column_heading=>'Item Actions'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(11084123281500649)
,p_plug_name=>'Button Region '
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5639480379931867)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(11084123281500649)
,p_button_name=>'APPLY'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'CREATE'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5612072482530328)
,p_name=>'P106_SHOW_CLOSED_YN'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(11084123281500649)
,p_prompt=>'Milestones Display'
,p_display_as=>'NATIVE_CHECKBOX'
,p_lov=>'STATIC:Show Closed Milestones;Y'
,p_field_template=>wwv_flow_imp.id(571215478963548485)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--autoLabelWidth'
,p_lov_display_extra=>'YES'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'1'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(5612275982530330)
,p_name=>'Refresh on toggle'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P106_SHOW_CLOSED_YN'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5612362900530331)
,p_event_id=>wwv_flow_imp.id(5612275982530330)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_REFRESH'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(11082864205500636)
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5639889869931889)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Process Milestones'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_milestones varchar2(4000);',
'    l_unassign  varchar2(4000);',
'BEGIN',
'  FOR i in 1..APEX_APPLICATION.G_F01.COUNT LOOP',
'    BEGIN',
'      IF APEX_APPLICATION.G_F01(i) IS NOT NULL THEN',
'          l_milestones := l_milestones ||APEX_APPLICATION.G_F01(i)||'':'';',
'      END IF;',
'    END;',
'  END LOOP;',
'  ',
'  l_milestones := trim(BOTH '':'' from l_milestones);',
'  ',
'  wwv_flow_issue_int.add_milestones(p_issue_id => :P100_ISSUE_ID, p_milestone_ids => l_milestones);',
'  ',
'  for a in (select to_char(id) milestone_id',
'             from wwv_flow_milestones ',
'            where security_group_id = :flow_security_group_id) LOOP',
'      if nvl(instr(l_milestones, a.milestone_id),0) = 0 then ',
'          l_unassign := l_unassign || a.milestone_id ||'':'';',
'      end if;',
'  end loop;',
'  ',
'  l_unassign := trim(BOTH '':'' from l_unassign);',
'  wwv_flow_issue_int.remove_milestones(p_issue_id => :P100_ISSUE_ID, p_milestone_ids => l_unassign);',
'  ',
'END;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5640216218931891)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00107
begin
wwv_flow_imp_page.create_page(
 p_id=>107
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Labels'
,p_page_mode=>'MODAL'
,p_step_title=>'Labels'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.group h2 {',
'  margin-bottom: 8px;',
'  font-size: 14px;',
'  line-height: 24px;',
'}',
'',
'.group p {',
'  color: #707070;',
'  margin-top: -4px;',
'}',
'',
'.group-item {',
'  margin: 8px 0;',
'}',
'',
'.group {',
'  margin: 24px 24px 20px 24px;',
'}',
'',
'.group-item label {',
'  display: flex;',
'  align-items: center;',
'}',
''))
,p_step_template=>wwv_flow_imp.id(126075773730973072)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_dialog_width=>'480'
,p_dialog_attributes=>'maxHeight: ''640px'''
,p_page_component_map=>'10'
,p_last_upd_yyyymmddhh24miss=>'20191115114339'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5947835348329303)
,p_plug_name=>'JavaScript for Check Boxes'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'    sys.htp.p(''<script>'');',
'    --',
'    for i in (select wwv_flow_issue_int.gen_slug(group_name) class',
'                from wwv_flow_label_groups ',
'               where values_are_exclusive = ''Y''',
'                 and security_group_id = :flow_security_group_id) ',
'    loop',
'        sys.htp.p(''$(".''||i.class||''").change(function() {',
'    $(".''||i.class||''").not(this).prop(''''checked'''', false);',
'});',
''');',
'    end loop;',
'    sys.htp.p(''</script>'');',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(6874950282843429)
,p_plug_name=>'Labels'
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_label_count number;',
'    l_item_type         varchar2(30);',
'begin',
'    -- See if there are any label groups to process',
'    select count(*) ',
'      into l_label_count ',
'      from wwv_flow_labels',
'    where security_group_id = :flow_security_group_id;',
'    --',
'    if l_label_count = 0 then ',
'        sys.htp.p(''<div class="padding-lg nodatafound u-tC">'' || wwv_flow_lang.system_message(''APEX.ISSUES.NO_LABLES_FOUND'') || ''</div>'');',
'    else',
'    ',
'        for label_group in (',
'          select id,',
'                 group_name,',
'                 values_are_exclusive,',
'                 group_color,',
'                 wwv_flow_issue_int.gen_slug(group_name) group_slug,',
'                 (select count(*) ',
'                        from wwv_flow_issue_labels il, wwv_flow_labels l ',
'                        where il.issue_id = :P100_ISSUE_ID and il.label_id = l.id and l.label_group_id = g.id ',
'                  ) active_selections',
'            from wwv_flow_label_groups g',
'           where security_group_id = :flow_security_group_id',
'           order by group_name',
'        ) ',
'        loop',
'            if label_group.values_are_exclusive = ''Y'' then ',
'                l_item_type := ''radio'';',
'            else ',
'                l_item_type := ''checkbox'';',
'            end if;',
'            ',
'            sys.htp.p(''<div class="group">'');',
'            sys.htp.p(''<h2 id="group_''||label_group.group_slug||''">''||wwv_flow_escape.html(label_group.group_name)||''</h2>'');',
'            sys.htp.p(''<div class="group-items" role="group" aria-labelledby="group_''||label_group.group_slug||''">'');',
'            for label in (',
'                select id,',
'                       label_name,',
'                       nvl(',
'                        (select ''checked '' from wwv_flow_issue_labels il where il.issue_id = :P100_ISSUE_ID and il.label_id = id),',
'                        '''') checked',
'                from wwv_flow_labels',
'                where security_group_id = :flow_security_group_id',
'                  and label_group_id = label_group.id',
'                order by display_sequence asc',
'            ) loop',
'                sys.htp.p(''<div class="group-item">'');',
'                sys.htp.p(''<label>'');',
'                sys.htp.p(''<input type="''||l_item_type||''" ''',
'                           ||''name="''||label_group.group_slug||''_''||label_group.id||''" ''',
'                           ||''value="''||label.id||''" ''',
'                           || label.checked',
'                           ||''class="u-vh label-item apex-ui-selector-input ''||wwv_flow_escape.html_attribute(label_group.group_name)||''" ''',
'                           ||''id="cb_''||label.id||''">''',
'                           || ''<span class="apex-ui-selector"></span>''',
'                           || ''<span class="a-IssueLabel ''||label_group.group_color||''">''||wwv_flow_escape.html(label.label_name)||''</span></label>'');',
'                sys.htp.p(''</label>'');',
'                sys.htp.p(''</div>''); -- close .group-item',
'            end loop;',
'    ',
'            if l_item_type = ''radio'' then',
'                sys.htp.p(''<div class="group-item">'');',
'                sys.htp.p(''<label>'');',
'                sys.htp.p(''<input type="radio" ''',
'                           ||''name="''||label_group.group_slug||''_''||label_group.id||''" ''',
'                           ||''value="" ''',
'                           ||''class="u-vh label-item apex-ui-selector-input ''||wwv_flow_escape.html_attribute(label_group.group_name)||''" '');',
'    ',
'                if label_group.active_selections = 0 then ',
'                    sys.htp.prn(''checked'');',
'                end if;',
'    ',
'                sys.htp.prn(''>''',
'                           || ''<span class="apex-ui-selector"></span>''',
'                           || ''<span class="a-IssueLabel group-label-none">'' || wwv_flow_lang.system_message(''CA.NONE'') || ''</span></label>'');',
'                sys.htp.p(''</label>'');',
'                sys.htp.p(''</div>''); -- close .group-item',
'            end if;',
'            sys.htp.p(''</div>''); -- close .group-items',
'    ',
'            sys.htp.p(''</div>''); -- close .group',
'        end loop;',
'    end if;',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(16891196011494332)
,p_plug_name=>'Button Region '
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5809101813993699)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(16891196011494332)
,p_button_name=>'APPLY'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'CREATE'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6874689428843426)
,p_name=>'P107_SELECTIONS'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(6874950282843429)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(6874756006843427)
,p_name=>'Update Selection on Change'
,p_event_sequence=>20
,p_triggering_element_type=>'JQUERY_SELECTOR'
,p_triggering_element=>'.label-item'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(6874876625843428)
,p_event_id=>wwv_flow_imp.id(6874756006843427)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'Y'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'var sel = '':'';',
'$(''.label-item:checked'').each(function(){',
'  if ($(this).val().length > 0) {',
'    sel = sel + $(this).val() + '':'';',
'  }',
'})',
'console.log(sel);',
'$s(''P107_SELECTIONS'',sel);'))
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5947984653329304)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Process Labels'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_labels     varchar2(4000);',
'    l_unassign   varchar2(4000);',
'begin',
'    --',
'    wwv_flow_issue_int.add_labels(p_issue_id => :p100_issue_id, p_label_ids => :P107_SELECTIONS);',
'    --',
'    for a in (',
'        select to_char(l.id) label_id',
'          from wwv_flow_labels l',
'         where l.security_group_id = :flow_security_group_id',
'    ) loop ',
'        --',
'        if nvl(instr(:P107_SELECTIONS, a.label_id),0) = 0 then',
'            l_unassign := l_unassign || a.label_id || '':'';',
'        end if;',
'    end loop;',
'    --',
'    l_unassign := trim(both '':'' from l_unassign);',
'    --',
'    wwv_flow_issue_int.remove_labels(p_issue_id => :p100_issue_id, p_label_ids => l_unassign);',
'',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Error ... '
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5810648769993713)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_imp.id(5809101813993699)
);
end;
/
prompt --application/pages/page_00108
begin
wwv_flow_imp_page.create_page(
 p_id=>108
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Edit Comment Text'
,p_page_mode=>'MODAL'
,p_step_title=>'Edit Comment Text'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_javascript_file_urls=>'#IMAGE_PREFIX#apex_ui/js/issues.utils.js'
,p_step_template=>wwv_flow_imp.id(126075773730973072)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_page_component_map=>'16'
,p_last_upd_yyyymmddhh24miss=>'20200218092731'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(13052086800306811)
,p_plug_name=>'Comment text'
,p_region_css_classes=>'padding-md'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(18564566947374957)
,p_plug_name=>'Button Region '
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(6719036574160314)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(18564566947374957)
,p_button_name=>'APPLY'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply'
,p_button_position=>'CREATE'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6448597442807342)
,p_name=>'P108_COMMENT_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(13052086800306811)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6718322419160311)
,p_name=>'P108_COMMENT_TEXT'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(13052086800306811)
,p_prompt=>'Comment Text'
,p_display_as=>'NATIVE_MARKDOWN_EDITOR'
,p_field_template=>wwv_flow_imp.id(571215478963548485)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_encrypt_session_state_yn=>'N'
,p_plugin_init_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function(options){    ',
'    var markdownEditor = this;',
'    markdownEditor.onBeforePreviewText = function(text){',
'        return apex.issues.replacePrefixImage(text, ''P100_ISSUE_ID_VALUE'');',
'    };',
'    apex.issues.addAttachButton(options, ''P108_ALLOW_ISSUE_FILES_YN'', ''P108_COMMENT_TEXT'', ''P108_ATTACH_FILES_TARGET_URL'');',
'}'))
,p_attribute_01=>'SIMPLE'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(40399772608841612)
,p_name=>'P100_ISSUE_ID_VALUE'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(13052086800306811)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(40400181717841616)
,p_name=>'P108_ALLOW_ISSUE_FILES_YN'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(13052086800306811)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(40400319525841618)
,p_name=>'P108_ATTACH_FILES_TARGET_URL'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_imp.id(13052086800306811)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_util.prepare_url(',
'    p_url => ''f?p=''||:APP_ID||'':109:''||:APP_SESSION||''::::P109_ISSUE_ID:''||:P100_ISSUE_ID_VALUE',
')'))
,p_source_type=>'EXPRESSION'
,p_source_language=>'PLSQL'
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(40400239674841617)
,p_computation_sequence=>10
,p_computation_item=>'P108_ALLOW_ISSUE_FILES_YN'
,p_computation_point=>'BEFORE_BOX_BODY'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ALLOW_ISSUE_FILES_YN',
'  from wwv_flow_companies',
' where provisioning_company_id = :flow_security_group_id;'))
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6719877740160327)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Update comment text'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_comment_text clob;',
'',
'begin  ',
'    -- Get the original comment text ',
'    select comment_text ',
'      into l_comment_text',
'      from wwv_flow_issue_comments',
'     where id = :P108_COMMENT_ID',
'       and issue_id = :P100_ISSUE_ID',
'       and security_group_id = :flow_security_group_id;',
'       ',
'    -- Update the table with the new comment',
'    update wwv_flow_issue_comments',
'      set  comment_text = :P108_COMMENT_TEXT',
'     where ID = :P108_COMMENT_ID',
'      and  issue_id = :P100_ISSUE_ID',
'      and  security_group_id = :flow_security_group_id;',
'    --',
'    commit;',
'      ',
'    -- Track the edit passing the old comment text',
'    wwv_flow_issue_int.track_comment_edit(p_comment_id =>:P108_COMMENT_ID,  p_comment_text => l_comment_text);',
'',
'end;',
'',
''))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6720216213160328)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6719437399160327)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'GET COMMENT_TEXT'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'BEGIN ',
'select comment_text ',
'  into :P108_COMMENT_TEXT',
'  from wwv_flow_issue_comments ',
' where id = :P108_COMMENT_ID',
'   and issue_id = :P100_ISSUE_ID',
'   and security_group_id = :flow_security_group_id;',
'END;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00109
begin
wwv_flow_imp_page.create_page(
 p_id=>109
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Attach File'
,p_alias=>'ATTACHMENTS'
,p_page_mode=>'MODAL'
,p_step_title=>'Attach File'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_javascript_code_onload=>wwv_flow_string.join(wwv_flow_t_varchar2(
'// Set drag and drop labels',
'var fileUpload$ = apex.jQuery(''.apex-item-group--file:not(.upload-completed) .apex-item-file-dropzone'');',
'',
'fileUpload$.append("<span class=''a-FileDrop-heading''>" + apex.lang.getMessage("DATA.LOAD.DRAG_DROP_FILE_HERE") + "</span> ");',
'fileUpload$.append("<span class=''a-FileDrop-action''>" + apex.lang.getMessage("DATA.LOAD.CHOOSE_FILE") + "</span> ");',
'//fileUpload$.append("<span class=''a-FileDrop-formats''>" + apex.lang.getMessage("DATA.LOAD.FILE_FORMATS") + "</span>");'))
,p_inline_css=>'.a-Dialog-body {padding: 0 32px 32px 32px !important}'
,p_step_template=>wwv_flow_imp.id(694269863376113197)
,p_page_css_classes=>'a-Page--DataLoad.is-first-step'
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_dialog_width=>'640'
,p_dialog_chained=>'N'
,p_page_component_map=>'16'
,p_last_upd_yyyymmddhh24miss=>'20200819171111'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(6446779703807324)
,p_plug_name=>'Attachments'
,p_region_name=>'drag_drop_file'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>10
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(581217655310849504)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(6446779703807324)
,p_button_name=>'SUBMIT'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Submit'
,p_button_condition_type=>'NEVER'
,p_grid_new_row=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6446848859807325)
,p_name=>'P109_FILE_BLOB'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(6446779703807324)
,p_prompt=>'Add Files'
,p_display_as=>'NATIVE_FILE'
,p_cSize=>60
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_imp.id(571215478963548485)
,p_item_css_classes=>'a-FileDrop data-load-input'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'APEX_APPLICATION_TEMP_FILES'
,p_attribute_09=>'SESSION'
,p_attribute_10=>'Y'
,p_attribute_11=>'&P109_ISSUE_ALLOWED_FILE_TYPES.'
,p_attribute_12=>'INLINE'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6446926953807326)
,p_name=>'P109_ISSUE_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(6446779703807324)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6447084409807327)
,p_name=>'P109_FILES_INFO'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(6446779703807324)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(156404580728150748)
,p_name=>'P109_ISSUE_FILES_YN'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_imp.id(6446779703807324)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(156404626462150749)
,p_name=>'P109_ISSUE_FS_LIMIT'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_imp.id(6446779703807324)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(581217730789849505)
,p_validation_name=>'Validate File Sizes'
,p_validation_sequence=>10
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_file_name_array           wwv_flow_global.vc_arr2;',
'    l_actual_file_size          number;',
'    l_too_large_count           number;',
'',
'begin ',
'    --      ',
'    l_too_large_count     := 0;',
'    ',
'    -- Split the selected files into an array',
'    l_file_name_array := apex_string.string_to_table(:P109_FILE_BLOB, '':'');',
'    ',
'    -- Loop through the files',
'    for i in 1 .. l_file_name_array.count loop',
'         -- Get the actual file size for the file',
'         select file_size',
'           into l_actual_file_size ',
'           from APEX_WORKSPACE_FILES',
'          where FILE_ID = substr(l_file_name_array(i),1,instr(l_file_name_array(i),''/'')-1);',
'         ',
'         -- if the file is too large. ',
'         if l_actual_file_size > :P109_ISSUE_FS_LIMIT then ',
'             l_too_large_count := l_too_large_count + 1;',
'         end if;',
'         --             ',
'    end loop;',
'    --',
'    if l_too_large_count > 0 then ',
'        if l_file_name_array.count > 1 then ',
'            return wwv_flow_lang.system_message(''APEX.ISSUES.FILE_SIZE_PLURAL'', p0=>to_char(:P109_ISSUE_FS_LIMIT,''999,999,999,999'') );',
'            --''One of these files is larger than the max file size of %0 bytes.'';',
'        else',
'            return wwv_flow_lang.system_message(''APEX.ISSUES.FILE_SIZE_SINGULAR'', p0=>to_char(:P109_ISSUE_FS_LIMIT,''999,999,999,999'') );',
'            --''This file is larger than the max file size of %0 bytes.'';',
'        end if;',
'     else ',
'         return null;',
'     end if;',
'     -- ',
'    RETURN null;',
'     ',
'',
'     EXCEPTION ',
'         WHEN OTHERS THEN ',
'             RETURN wwv_flow_lang.system_message(''APEX.ISSUES.FILE_SIZE_CHECK_ERROR'' );',
'             --''There was a problem checking file sizes. Please contact your system administrator.'';',
'     ',
'     ',
'end;'))
,p_validation2=>'PLSQL'
,p_validation_type=>'FUNC_BODY_RETURNING_ERR_TEXT'
,p_always_execute=>'Y'
,p_associated_item=>wwv_flow_imp.id(6446848859807325)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(597621907466219135)
,p_name=>'Upload File'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P109_FILE_BLOB'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(597622009250219136)
,p_event_id=>wwv_flow_imp.id(597621907466219135)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_JAVASCRIPT_CODE'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex.jQuery(".apex-item-group--file").addClass("uploading");',
'apex.jQuery(".apex-item-file-dropzone").html("<span class=''a-DataLoad-progressMeter''></span>");'))
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(597622379221219139)
,p_event_id=>wwv_flow_imp.id(597621907466219135)
,p_event_result=>'TRUE'
,p_action_sequence=>20
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_SUBMIT_PAGE'
,p_attribute_02=>'N'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6447457944807331)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Upload Files'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_issue_int.upload_files(',
'    p_issue_id => :P109_ISSUE_ID,',
'    p_file_names => :P109_FILE_BLOB,',
'    p_files_info => :P109_FILES_INFO);'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6447591159807332)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_attribute_01=>'P109_FILES_INFO'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(6447687059807333)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_SESSION_STATE'
,p_process_name=>'Reset page'
,p_attribute_01=>'CLEAR_CACHE_CURRENT_PAGE'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(581217897275849506)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Compute File Limits'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select allow_issue_files_yn, ',
'       issue_fs_limit',
' into :P109_ISSUE_FILES_YN,',
'      :P109_ISSUE_FS_LIMIT',
' from wwv_flow_companies    ',
'where provisioning_company_id = :flow_security_group_id;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00110
begin
wwv_flow_imp_page.create_page(
 p_id=>110
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'New Issue - Choose Template'
,p_page_mode=>'MODAL'
,p_step_title=>'New Issue'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_protection_level=>'C'
,p_page_component_map=>'03'
,p_last_upd_yyyymmddhh24miss=>'20191204112144'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5711295175527229)
,p_plug_name=>'Button Container'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5711777283527234)
,p_plug_name=>'No Template Message'
,p_region_css_classes=>'padding-md'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_source=>'Don''t see a template that matches your need? <a href="f?p=&APP_ID.:111:&APP_SESSION.:::111">Continue without a template</a>.'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(5860054780152803)
,p_name=>'Issue Templates'
,p_template=>wwv_flow_imp.id(214132567690623104)
,p_display_sequence=>10
,p_region_template_options=>'#DEFAULT#'
,p_component_template_options=>'#DEFAULT#'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'  id,',
'  '' '' as ITEM_CUSTOM_ATTRS,',
'  '' '' as ITEM_CSS_MODIFIERS,',
'  '' '' as ITEM_SELECTION,',
'  ''fa fa-lg fa-file-text-o'' as ITEM_ICON,',
'  apex_page.get_url(p_page => 111, p_items => ''P111_TEMPLATE_ID'', p_values => id) as ITEM_LINK,',
'  template_name as ITEM_TITLE,',
'  template_description as ITEM_DESCRIPTION,',
'  '' '' as ITEM_MISC,',
'  '' '' as ITEM_ACTIONS',
'  ',
'  from wwv_flow_issue_templates t',
' where t.template_type = ''ISSUE''',
'   and t.security_group_id = :flow_security_group_id',
'order by template_name'))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(10733983191535295)
,p_query_num_rows=>115
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_no_data_found=>'no data found'
,p_query_row_count_max=>500
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_prn_format=>'PDF'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5860414121152820)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8723661921916120)
,p_query_column_id=>2
,p_column_alias=>'ITEM_CUSTOM_ATTRS'
,p_column_display_sequence=>2
,p_column_heading=>'Item Custom Attrs'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8723717790916121)
,p_query_column_id=>3
,p_column_alias=>'ITEM_CSS_MODIFIERS'
,p_column_display_sequence=>3
,p_column_heading=>'Item Css Modifiers'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8723818089916122)
,p_query_column_id=>4
,p_column_alias=>'ITEM_SELECTION'
,p_column_display_sequence=>4
,p_column_heading=>'Item Selection'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8723964910916123)
,p_query_column_id=>5
,p_column_alias=>'ITEM_ICON'
,p_column_display_sequence=>5
,p_column_heading=>'Item Icon'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8724086277916124)
,p_query_column_id=>6
,p_column_alias=>'ITEM_LINK'
,p_column_display_sequence=>6
,p_column_heading=>'Item Link'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8724193230916125)
,p_query_column_id=>7
,p_column_alias=>'ITEM_TITLE'
,p_column_display_sequence=>7
,p_column_heading=>'Item Title'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8724286914916126)
,p_query_column_id=>8
,p_column_alias=>'ITEM_DESCRIPTION'
,p_column_display_sequence=>8
,p_column_heading=>'Item Description'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8724371112916127)
,p_query_column_id=>9
,p_column_alias=>'ITEM_MISC'
,p_column_display_sequence=>9
,p_column_heading=>'Item Misc'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(8724408782916128)
,p_query_column_id=>10
,p_column_alias=>'ITEM_ACTIONS'
,p_column_display_sequence=>10
,p_column_heading=>'Item Actions'
,p_use_as_row_header=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5711473141527231)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(5711295175527229)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(11817687209752049)
,p_branch_name=>'Redirect to New Issue if no Templates'
,p_branch_action=>'f?p=&APP_ID.:111:&SESSION.::&DEBUG.:RP,111::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'BEFORE_HEADER'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'NOT_EXISTS'
,p_branch_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'  null',
'  from wwv_flow_issue_templates t',
' where t.template_type = ''ISSUE''',
'   and t.security_group_id = :flow_security_group_id'))
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(150598856613090732)
,p_name=>'P110_ASSOCIATED_PAGE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(5860054780152803)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(150598982226090733)
,p_name=>'P110_ASSOCIATED_APP'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(5860054780152803)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(5711536102527232)
,p_name=>'Close Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(5711473141527231)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5711653250527233)
,p_event_id=>wwv_flow_imp.id(5711536102527232)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CLOSE'
);
end;
/
prompt --application/pages/page_00111
begin
wwv_flow_imp_page.create_page(
 p_id=>111
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'New Issue > Enter Details'
,p_page_mode=>'MODAL'
,p_step_title=>'New Issue'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_javascript_file_urls=>'#IMAGE_PREFIX#apex_ui/js/issues.utils.js'
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_protection_level=>'C'
,p_page_component_map=>'02'
,p_last_upd_yyyymmddhh24miss=>'20210218081157'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5870252943250868)
,p_plug_name=>'Issue Details'
,p_region_css_classes=>'a-Form--large'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(47229974494774989)
,p_plug_display_sequence=>10
,p_query_type=>'TABLE'
,p_query_table=>'WWV_FLOW_ISSUES'
,p_include_rowid_column=>false
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_plug_source_type=>'NATIVE_FORM'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5874723955250887)
,p_plug_name=>'Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5875170956250888)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(5874723955250887)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5877587528250891)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(5874723955250887)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Create Issue'
,p_button_position=>'NEXT'
,p_button_condition=>'P111_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5711878297527235)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(5874723955250887)
,p_button_name=>'PREVIOUS'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(5208338701524668)
,p_button_image_alt=>'Previous'
,p_button_position=>'PREVIOUS'
,p_button_redirect_url=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:RP,111::'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select',
'  null',
'  from wwv_flow_issue_templates t',
' where t.template_type = ''ISSUE''',
'   and t.security_group_id = :flow_security_group_id'))
,p_button_condition_type=>'EXISTS'
,p_icon_css_classes=>'icon-left-chevron'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(5712448293527241)
,p_branch_name=>'Return to Previoius Page'
,p_branch_action=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP,111:P100_ISSUE_ID:&P111_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5711911232527236)
,p_name=>'P111_TEMPLATE_ID'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5870575180250869)
,p_name=>'P111_ID'
,p_source_data_type=>'NUMBER'
,p_is_primary_key=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_item_source_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_source=>'ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_protection_level=>'S'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5870993442250874)
,p_name=>'P111_TITLE'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_item_source_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_prompt=>'Title'
,p_placeholder=>'Issue Title'
,p_source=>'TITLE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_imp.id(566754273980399706)
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_is_persistent=>'N'
,p_help_text=>'A succinct descriptive title for the issue.'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5871330662250882)
,p_name=>'P111_SLUG'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_item_source_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_source=>'SLUG'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_help_text=>'A string used to uniquely identify an issue. May only contain numbers, letters and dashes.'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5871767616250882)
,p_name=>'P111_ISSUE_TEXT'
,p_source_data_type=>'CLOB'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_item_source_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_prompt=>'Issue Text'
,p_placeholder=>'Enter issue here...'
,p_source=>'ISSUE_TEXT'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_MARKDOWN_EDITOR'
,p_field_template=>wwv_flow_imp.id(571215478963548485)
,p_item_css_classes=>'a-IssueComments'
,p_item_template_options=>'#DEFAULT#:a-Form-fieldContainer--stretch:a-Form-fieldContainer--autoLabelWidth'
,p_is_persistent=>'N'
,p_encrypt_session_state_yn=>'N'
,p_plugin_init_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function(options) {',
'    ',
'    // Add Attach Button',
'    ',
'    apex.issues.addAttachButton(options, ''P111_ALLOW_ISSUE_FILES_YN'', ''P111_ISSUE_TEXT'', ''P111_ATTACH_FILES_TARGET_URL'');',
'',
'    // Add the Open Dialog',
'    ',
'    return options;',
'}'))
,p_attribute_01=>'SIMPLE'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5872163254250883)
,p_name=>'P111_APPLICATION_ID'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_item_source_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_source=>'APPLICATION_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5872511005250883)
,p_name=>'P111_PAGE_ID'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_item_source_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_source=>'PAGE_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(15633150389171571)
,p_name=>'P111_FILES_INFO'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_prompt=>'File Info'
,p_display_as=>'NATIVE_HIDDEN'
,p_item_template_options=>'#DEFAULT#'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(15633472921181621)
,p_name=>'P111_ATTACH_FILES_TARGET_URL'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'apex_util.prepare_url(',
'    p_url => ''f?p=''||:APP_ID||'':109:''||:APP_SESSION||'':::::''',
')'))
,p_source_type=>'EXPRESSION'
,p_source_language=>'PLSQL'
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(581218191068849509)
,p_name=>'P111_ALLOW_ISSUE_FILES_YN'
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_imp.id(5870252943250868)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(581218293176849510)
,p_computation_sequence=>10
,p_computation_item=>'P111_ALLOW_ISSUE_FILES_YN'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'QUERY'
,p_computation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ALLOW_ISSUE_FILES_YN',
'  from wwv_flow_companies',
' where provisioning_company_id = :flow_security_group_id;'))
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(150599063324090734)
,p_computation_sequence=>20
,p_computation_item=>'P111_APPLICATION_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'ITEM_VALUE'
,p_computation=>'P110_ASSOCIATED_APP'
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(150599166321090735)
,p_computation_sequence=>30
,p_computation_item=>'P111_PAGE_ID'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'ITEM_VALUE'
,p_computation=>'P110_ASSOCIATED_PAGE'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(150598669682090730)
,p_validation_name=>'Title is Unique within worksapce'
,p_validation_sequence=>30
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1''',
'  from wwv_flow_issues',
' where title = :P111_TITLE',
'   and ID != :P111_id',
'   and security_group_id = :flow_security_group_id'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>'Title must be unique within this workspace. Please enter another value.'
,p_associated_item=>wwv_flow_imp.id(5870993442250874)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(5875263039250888)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(5875170956250888)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5876071399250889)
,p_event_id=>wwv_flow_imp.id(5875263039250888)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(150598745770090731)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Generate Slug for title'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P111_SLUG := wwv_flow_issue_int.gen_slug(:P111_TITLE);',
''))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5878346054250893)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_imp.id(5870252943250868)
,p_process_type=>'NATIVE_FORM_DML'
,p_process_name=>'Process form Create Form'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>'Issue created.'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(15580499362474508)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Upload Files'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_issue_int.upload_files(',
'    p_issue_id => :P111_ID,',
'    p_file_names => :P109_FILE_BLOB,',
'    p_files_info => :P109_FILES_INFO);'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5877986852250892)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_region_id=>wwv_flow_imp.id(5870252943250868)
,p_process_type=>'NATIVE_FORM_INIT'
,p_process_name=>'Initialize form Create Form'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5712229619527239)
,p_process_sequence=>20
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Fill Issue Text'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin ',
'    select template_text ',
'      into :P111_ISSUE_TEXT ',
'      from wwv_flow_issue_templates',
'     where id = :P111_TEMPLATE_ID',
'       and security_group_id = :flow_security_group_id;',
'exception ',
'    when no_data_found then ',
'        :P111_ISSUE_TEXT := '''';',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00112
begin
wwv_flow_imp_page.create_page(
 p_id=>112
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Attachments'
,p_page_mode=>'MODAL'
,p_step_title=>'Attachments'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_dialog_attributes=>'close: function() { customCloseEvent(''customDialogClose'', {modalPageId: ''MODAL_CLOSE_FIXED''});}'
,p_page_component_map=>'18'
,p_last_upd_yyyymmddhh24miss=>'20210812003719'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(11544255581836121)
,p_plug_name=>'Attachments'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(651492083233530570)
,p_plug_display_sequence=>10
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id,',
'       file_name,',
'       case',
'           when substr(mime_type, 1, 5) = ''image''        then',
'               wwv_flow_lang.system_message(''APEX.ISSUES.IMAGE'')',
'           when substr(mime_type, 1, 11) = ''Application'' then',
'               case',
'                    when substr(mime_type, 13) in (''zip'',''x-gzip'') then',
'                        wwv_flow_lang.system_message(''APEX.ISSUES.ZIP_FILE'')',
'                    else',
'                        wwv_flow_lang.system_message(''APEX.ISSUES.DOCUMENT'')',
'                end',
'            when substr(mime_type,1,4) = ''text'' then',
'                wwv_flow_lang.system_message(''APEX.ISSUES.TEXT_FILE'')',
'            else ',
'                wwv_flow_lang.system_message(''APEX.ISSUES.OTHER'')',
'       end  FILE_TYPE,',
'       sys.dbms_lob.getlength(file_blob) FILE_SIZE,',
'       sys.dbms_lob.getlength(file_blob) FILE_SIZE_DISPLAY,',
'       wwv_flow_issue_int.get_user_name(CREATED_BY) CREATED_BY, ',
'       apex_util.get_since(created_on) CREATED,',
'        ''<span style="display:flex"><button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--small" onclick="apex.page.submit({request:''''INSERT'''', set: {''''P112_ATTACHMENT_ID'''':''''''||id||''''''}, showWait: true});"  type="button"  style="mar'
||'gin-left:5px;"><span class="fa fa-download-alt" aria-hidden="true"></span></button>''||',
'        case ',
'            when instr(wwv_flow_fnd_user_int.get_user_roles(p_security_group_id => :flow_security_group_id, p_username => :APP_USER), ''ADMIN'') >0 OR  created_by = :APP_USER then ',
'                ''<button class="a-Button a-Button--noLabel a-Button--withIcon a-Button--small" onclick="apex.page.submit({request:''''DELETE'''', set: {''''P112_ATTACHMENT_ID'''':''''''||id||''''''}, showWait: true});"  type="button"  style="margin-left:5px;"><spa'
||'n class="fa fa-trash-o" aria-hidden="true"></span></button>'' ',
'            else ',
'                null',
'        end ||''</span>'' ACTIONS',
'  from WWV_FLOW_ISSUE_ATTACHMENTS',
' where issue_id = :P100_ISSUE_ID',
'and security_group_id = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>8.5
,p_prn_height=>11
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
,p_prn_page_header_alignment=>'CENTER'
,p_prn_page_footer_alignment=>'CENTER'
);
wwv_flow_imp_page.create_worksheet(
 p_id=>wwv_flow_imp.id(11171837955554350)
,p_max_row_count=>'1000000'
,p_no_data_found_message=>'No attachments found for this issue.'
,p_show_nulls_as=>'-'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_show_search_bar=>'N'
,p_report_list_mode=>'TABS'
,p_lazy_loading=>false
,p_show_detail_link=>'N'
,p_enable_mail_download=>'N'
,p_owner=>'DGAULT'
,p_internal_uid=>11171837955554350
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(15579778002474501)
,p_db_column_name=>'ID'
,p_display_order=>10
,p_column_identifier=>'A'
,p_column_label=>'Id'
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN_ESCAPE_SC'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(15579859930474502)
,p_db_column_name=>'FILE_NAME'
,p_display_order=>20
,p_column_identifier=>'B'
,p_column_label=>'File Name'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN_ESCAPE_SC'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(11428064698280844)
,p_db_column_name=>'FILE_TYPE'
,p_display_order=>30
,p_column_identifier=>'H'
,p_column_label=>'File Type'
,p_column_type=>'STRING'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(15579993911474503)
,p_db_column_name=>'FILE_SIZE'
,p_display_order=>40
,p_column_identifier=>'C'
,p_column_label=>'File Name'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'NUMBER'
,p_format_mask=>'DOWNLOAD:WWV_FLOW_ISSUE_ATTACHMENTS:FILE_BLOB:ID::MIME_TYPE:FILE_NAME:UPDATED_ON:CHARSET:attachment:#FILE_NAME#:'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(15580086208474504)
,p_db_column_name=>'FILE_SIZE_DISPLAY'
,p_display_order=>50
,p_column_identifier=>'D'
,p_column_label=>'File Size'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_format_mask=>'FILESIZE'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(15580127853474505)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>60
,p_column_identifier=>'E'
,p_column_label=>'Created By'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(15580281878474506)
,p_db_column_name=>'CREATED'
,p_display_order=>70
,p_column_identifier=>'F'
,p_column_label=>'Created'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(15580327924474507)
,p_db_column_name=>'ACTIONS'
,p_display_order=>80
,p_column_identifier=>'G'
,p_column_label=>'Actions'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_rpt(
 p_id=>wwv_flow_imp.id(15591164110482871)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_alias=>'155912'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_report_columns=>'FILE_SIZE:FILE_TYPE:FILE_SIZE_DISPLAY:CREATED_BY:CREATED:ACTIONS:'
,p_sort_column_1=>'CREATED'
,p_sort_direction_1=>'ASC'
,p_sort_column_2=>'FILE_SIZE'
,p_sort_direction_2=>'ASC'
,p_sort_column_3=>'FILE_SIZE_DISPLAY'
,p_sort_direction_3=>'DESC'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(11428129516280845)
,p_name=>'P112_ATTACHMENT_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(11544255581836121)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(15598869492897412)
,p_name=>'P112_FILES_INFO'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(11544255581836121)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(11428216101280846)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Build Attachment JSON'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_is_image       boolean := false;',
'    l_attachment     wwv_flow_issue_attachments%rowtype;',
'BEGIN ',
'    apex_json.initialize_clob_output;',
'    apex_json.open_array();',
'    --',
'    select * ',
'      into l_attachment',
'      from wwv_flow_issue_attachments',
'     where id = :P112_ATTACHMENT_ID',
'       and security_group_id = :flow_security_group_id; ',
'    --',
'    if instr(l_attachment.mime_type, ''image'') > 0 then  ',
'        l_is_image := true;',
'    else ',
'        l_is_image := false;',
'    end if;',
'    --',
'    apex_json.open_object;',
'    --',
'    apex_json.write(''n'',l_attachment.file_name);',
'    apex_json.write(''slug'', l_attachment.file_name_slug);',
'    apex_json.write(''id'',l_attachment.id);',
'    apex_json.write(''isImage'',l_is_image);',
'    --',
'    apex_json.close_object;',
'    --',
'    apex_json.close_array();',
'    --',
'    :P112_FILES_INFO := apex_json.get_clob_output;',
'    --',
'    apex_json.free_output;',
'EXCEPTION ',
'    when NO_DATA_FOUND then ',
'        :P112_FILES_INFO := '''';',
'END;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'INSERT'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(11428357134280847)
,p_process_sequence=>20
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog for Insert'
,p_attribute_01=>'P112_FILES_INFO'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'INSERT'
,p_process_when_type=>'REQUEST_EQUALS_CONDITION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(15607015948231502)
,p_process_sequence=>30
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Delete Attachment'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'wwv_flow_issue_int.remove_attachment(p_issue_id => :P100_ISSUE_ID, p_attachment_id => :P112_ATTACHMENT_ID);'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_success_message=>'Attachment successfully deleted.'
);
end;
/
prompt --application/pages/page_00120
begin
wwv_flow_imp_page.create_page(
 p_id=>120
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Edit Issue'
,p_page_mode=>'MODAL'
,p_step_title=>'Edit Issue'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883594172125992)
,p_javascript_code=>'var htmldb_delete_message = ''"DELETE_CONFIRM_MSG"'';'
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_protection_level=>'C'
,p_page_component_map=>'02'
,p_last_upd_yyyymmddhh24miss=>'20190916081321'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5910690798794428)
,p_plug_name=>'Create Form'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(47229974494774989)
,p_plug_display_sequence=>10
,p_query_type=>'TABLE'
,p_query_table=>'WWV_FLOW_ISSUES'
,p_include_rowid_column=>false
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_plug_source_type=>'NATIVE_FORM'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5917978397794433)
,p_plug_name=>'Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5918357445794434)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(5917978397794433)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5919932600794436)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(5917978397794433)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Delete'
,p_button_position=>'DELETE'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>'P120_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5920371002794436)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(5917978397794433)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'NEXT'
,p_button_condition=>'P120_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5920753096794436)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_imp.id(5917978397794433)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Create'
,p_button_position=>'NEXT'
,p_button_condition=>'P120_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5910972472794429)
,p_name=>'P120_ID'
,p_source_data_type=>'NUMBER'
,p_is_primary_key=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_item_source_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_source=>'ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_protection_level=>'S'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5911357220794429)
,p_name=>'P120_TITLE'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_item_source_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_prompt=>'Title'
,p_source=>'TITLE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>4000
,p_field_template=>wwv_flow_imp.id(457861279924367968)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5911786581794429)
,p_name=>'P120_SLUG'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_item_source_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_prompt=>'Slug'
,p_source=>'SLUG'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_imp.id(457861279924367968)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5912147053794430)
,p_name=>'P120_DUPLICATE_OF'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_item_source_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_prompt=>'Duplicate Of'
,p_source=>'DUPLICATE_OF'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_NUMBER_FIELD'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_imp.id(566752393121369432)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_encrypt_session_state_yn=>'N'
,p_attribute_03=>'right'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5912598076794430)
,p_name=>'P120_ISSUE_TEXT'
,p_source_data_type=>'CLOB'
,p_is_required=>true
,p_item_sequence=>110
,p_item_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_item_source_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_prompt=>'Issue Text'
,p_source=>'ISSUE_TEXT'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>255
,p_cHeight=>4
,p_field_template=>wwv_flow_imp.id(457861279924367968)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5913769127794431)
,p_name=>'P120_APPLICATION_ID'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>80
,p_item_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_item_source_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_prompt=>'Application Id'
,p_source=>'APPLICATION_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_named_lov=>'APPLICATION NAME RETURNING ID'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id',
'       || ''. ''',
'       || name d,',
'       id r',
'  from wwv_flows f',
' where security_group_id = :flow_security_group_id',
'   and not exists (',
'    select null',
'      from wwv_flow_language_map',
'     where translation_flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
')',
'   and ( exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id is null',
'       and security_group_id = :flow_security_group_id',
')',
'    or exists (',
'    select 1',
'      from wwv_flow_developers',
'     where userid = :app_user',
'       and flow_id = f.id',
'       and security_group_id = :flow_security_group_id',
') )',
'order by id'))
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_imp.id(566752393121369432)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'NO'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5914183028794431)
,p_name=>'P120_PAGE_ID'
,p_source_data_type=>'NUMBER'
,p_item_sequence=>90
,p_item_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_item_source_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_prompt=>'Page Id'
,p_source=>'PAGE_ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_POPUP_LOV'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'  from wwv_flow_steps',
' where security_group_id = :flow_security_group_id and ',
'    FLOW_ID = :P111_APPLICATION_ID',
' order by id'))
,p_lov_cascade_parent_items=>'P120_APPLICATION_ID'
,p_ajax_items_to_submit=>'P120_APPLICATION_ID'
,p_ajax_optimize_refresh=>'Y'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_imp.id(566752393121369432)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'NO'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'DIALOG'
,p_attribute_02=>'FIRST_ROWSET'
,p_attribute_04=>'N'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5914564763794431)
,p_name=>'P120_STATUS'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>100
,p_item_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_item_source_plug_id=>wwv_flow_imp.id(5910690798794428)
,p_prompt=>'Status'
,p_source=>'STATUS'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'ISSUE_STATUSES_STATIC'
,p_lov=>'.'||wwv_flow_imp.id(5664182917694426)||'.'
,p_lov_display_null=>'YES'
,p_cHeight=>1
,p_field_template=>wwv_flow_imp.id(566752393121369432)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'YES'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(5918466035794434)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(5918357445794434)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5919254149794435)
,p_event_id=>wwv_flow_imp.id(5918466035794434)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5921585551794437)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_imp.id(5910690798794428)
,p_process_type=>'NATIVE_FORM_DML'
,p_process_name=>'Process form Create Form'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5921946123794437)
,p_process_sequence=>50
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_CLOSE_WINDOW'
,p_process_name=>'Close Dialog'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when=>'CREATE,SAVE,DELETE'
,p_process_when_type=>'REQUEST_IN_CONDITION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5921122463794436)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_region_id=>wwv_flow_imp.id(5910690798794428)
,p_process_type=>'NATIVE_FORM_INIT'
,p_process_name=>'Initialize form Create Form'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00200
begin
wwv_flow_imp_page.create_page(
 p_id=>200
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Milestones'
,p_alias=>'MILESTONES'
,p_step_title=>'Milestones'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883665819126633)
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.a-ContentRowReport-itemMisc {',
'  flex-direction: column;',
'  align-items: flex-start;',
'  flex-basis: 33.333%;',
'}',
'',
'.a-ContentRowReport p {',
'  margin: 8px 0 0 0;',
'}'))
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_page_component_map=>'18'
,p_last_upd_yyyymmddhh24miss=>'20210812003731'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(4933933334267945)
,p_plug_name=>'Milestones'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(651492083233530570)
,p_plug_display_sequence=>11
,p_include_in_reg_disp_sel_yn=>'Y'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with milestone_data as ',
'( select id,',
'       milestone_name,',
'       milestone_desc,',
'       milestone_date,',
'       milestone_status,',
'       (select count(*) ',
'          from wwv_flow_issues i, wwv_flow_issue_milestones m ',
'         where i.id = m.issue_id ',
'           and m.milestone_id = mi.ID',
'           and i.security_group_id = :flow_security_group_id',
'           and m.security_group_id = :flow_security_group_id ',
'           and i.status = ''OPEN'') OPEN_COUNT, ',
'      (select count(*) ',
'          from wwv_flow_issues i, wwv_flow_issue_milestones m ',
'         where i.id = m.issue_id ',
'           and m.milestone_id = mi.ID',
'           and i.security_group_id = :flow_security_group_id',
'           and m.security_group_id = :flow_security_group_id ',
'           and i.status = ''CLOSED'') CLOSED_COUNT,  ',
'       created_on,',
'       created_by,',
'       updated_on,',
'       updated_by,',
'       milestone_slug,',
'       milestone_id,',
'       apex_page.get_url(p_page => 205, p_items => ''P205_ID'', p_values => id, p_clear_cache => 205) milestone_link,',
'       case ',
'           when milestone_status = ''CLOSED'' then ''<span class="fa fa-check-square u-success-text" aria-hidden="true"></span> '' || wwv_flow_lang.system_message(''CLOSED'') || '' &mdash; '' || to_char(milestone_date, ''Month DD YYYY'')',
'           when milestone_status = ''OPEN'' then',
'             case ',
'                  when sysdate > milestone_date  then ''<span class="fa fa-warning u-danger-text" aria-hidden="true"></span> '' || wwv_flow_lang.system_message(''PAST_DUE'') || '' &mdash; '' || apex_util.get_since(milestone_date)',
'                  when sysdate + 15 > milestone_date then ''<span aria-hidden="true" class="fa fa-info-square u-warning-text"></span> '' || wwv_flow_lang.system_message(''DUE'') || '' &mdash; '' || apex_util.get_since(milestone_date)',
'                  else ''<span aria-hidden="true" class="fa fa-calendar-o"></span> '' || wwv_flow_lang.system_message(''DUE'') || '' &mdash; '' || apex_util.get_since(milestone_date)',
'             end ',
'       end as DISPLAY_STATUS,',
'       case ',
'           when milestone_status = ''CLOSED'' then ''fa-check-square u-success-text''',
'           when milestone_status = ''OPEN'' then',
'             case ',
'                  when sysdate > milestone_date  then ''fa-warning u-danger-text''',
'                  when sysdate + 15 > milestone_date then ''fa-info-square u-warning-text''',
'                  else ''fa-calendar-o''',
'             end ',
'       end as MILESTONE_ICON',
'  from wwv_flow_milestones mi',
' where security_group_id = :flow_security_group_id)',
'select milestone_name,',
'       milestone_desc,',
'       milestone_date,',
'       milestone_status,',
'       open_count,',
'       closed_count,',
'       to_char(decode((closed_count + open_count),0,0,((closed_count / (closed_count + open_count))*100)), ''990'') percent_complete ,',
'       created_on,',
'       created_by,',
'       updated_on,',
'       updated_by,',
'       milestone_slug,',
'       milestone_id,',
'       milestone_link,',
'       display_status,',
'       milestone_icon, ',
'       wwv_flow_lang.system_message(''APEX.ISSUES.LAST_UPDATED'') last_updated_text,',
'       wwv_flow_lang.system_message(''APEX.ISSUES.OPEN'') open_text,',
'       wwv_flow_lang.system_message(''APEX.ISSUES.CLOSED'') closed_text,',
'       wwv_flow_lang.system_message(''APEX.ISSUES.COMPLETE'') complete_text',
'  from milestone_data',
''))
,p_plug_source_type=>'NATIVE_IR'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>8.5
,p_prn_height=>11
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
,p_prn_page_header_alignment=>'CENTER'
,p_prn_page_footer_alignment=>'CENTER'
);
wwv_flow_imp_page.create_worksheet(
 p_id=>wwv_flow_imp.id(5312744428399715)
,p_max_row_count=>'1000000'
,p_no_data_found_message=>'No Milestones have been defined.'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_lazy_loading=>false
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_download_formats=>'HTML:XLSX:PDF'
,p_enable_mail_download=>'Y'
,p_detail_view_enabled_yn=>'Y'
,p_detail_view_before_rows=>'<div class="a-ContentRowReport">'
,p_detail_view_for_each_row=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ContentRowReport-item">',
'  <div class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle"><a href="#MILESTONE_LINK#">#MILESTONE_NAME# - #MILESTONE_DATE#</a></h3>',
'        <div class="a-ContentRowReport-itemDescription">',
'          <div class="a-Attributes">',
'            <span class="a-Attribute">#DISPLAY_STATUS#</span>',
'            <span class="a-Attribute"><span aria-hidden="true" class="fa fa-clock-o"></span> #LAST_UPDATED_TEXT# #UPDATED_ON#</span>',
'          </div>',
'          <div>#MILESTONE_DESC#</div>',
'        </div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">',
'        <div class="a-Report-percentChart"><div class="a-Report-percentChart-fill" style="width: #PERCENT_COMPLETE#%;"></div>',
'        <span class="u-VisuallyHidden">#PERCENT_COMPLETE#%</span></div>',
'        <div class="a-Attributes">',
'          <span class="a-Attribute"><strong>#PERCENT_COMPLETE#%</strong> #COMPLETE_TEXT#</span>',
'          <span class="a-Attribute"><strong>#OPEN_COUNT#</strong> #OPEN_TEXT#</span>',
'          <span class="a-Attribute"><strong>#CLOSED_COUNT#</strong> #CLOSED_TEXT#</span>',
'          </div>',
'      </div>',
'    </div>',
'  </div>',
'</div>',
''))
,p_detail_view_after_rows=>'</div>'
,p_owner=>'DGAULT'
,p_internal_uid=>5312744428399715
);
wwv_flow_imp_page.create_worksheet_col_group(
 p_id=>wwv_flow_imp.id(5167526317832126)
,p_name=>'Assigned Issues'
,p_display_sequence=>10
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5313024374399718)
,p_db_column_name=>'MILESTONE_NAME'
,p_display_order=>30
,p_column_identifier=>'C'
,p_column_label=>'Milestone'
,p_column_link=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.:RP,210:P205_ID:#MILESTONE_ID#'
,p_column_linktext=>'#MILESTONE_NAME#'
,p_column_type=>'STRING'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5313700155399725)
,p_db_column_name=>'MILESTONE_SLUG'
,p_display_order=>40
,p_column_identifier=>'J'
,p_column_label=>'Milestone Slug'
,p_column_type=>'STRING'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(6449062434807347)
,p_db_column_name=>'MILESTONE_DESC'
,p_display_order=>50
,p_column_identifier=>'P'
,p_column_label=>'Milestone Desc'
,p_column_type=>'STRING'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5313124988399719)
,p_db_column_name=>'MILESTONE_DATE'
,p_display_order=>60
,p_column_identifier=>'D'
,p_column_label=>'Date'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_tz_dependent=>'N'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(10420770260079405)
,p_db_column_name=>'MILESTONE_STATUS'
,p_display_order=>70
,p_column_identifier=>'Q'
,p_column_label=>'Milestone Status'
,p_column_type=>'STRING'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5313436691399722)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>80
,p_column_identifier=>'G'
,p_column_label=>'Created By'
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_imp.id(5669473527908412)
,p_rpt_show_filter_lov=>'1'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5313344981399721)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>90
,p_column_identifier=>'F'
,p_column_label=>'Created On'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5313619600399724)
,p_db_column_name=>'UPDATED_BY'
,p_display_order=>100
,p_column_identifier=>'I'
,p_column_label=>'Updated By'
,p_column_type=>'STRING'
,p_display_text_as=>'LOV_ESCAPE_SC'
,p_rpt_named_lov=>wwv_flow_imp.id(5669473527908412)
,p_rpt_show_filter_lov=>'1'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5313524844399723)
,p_db_column_name=>'UPDATED_ON'
,p_display_order=>110
,p_column_identifier=>'H'
,p_column_label=>'Updated On'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5167277084832123)
,p_db_column_name=>'OPEN_COUNT'
,p_display_order=>120
,p_group_id=>wwv_flow_imp.id(5167526317832126)
,p_column_identifier=>'M'
,p_column_label=>'Open'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5167407311832125)
,p_db_column_name=>'CLOSED_COUNT'
,p_display_order=>140
,p_group_id=>wwv_flow_imp.id(5167526317832126)
,p_column_identifier=>'O'
,p_column_label=>'Closed'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5167603974832127)
,p_db_column_name=>'MILESTONE_ID'
,p_display_order=>150
,p_column_identifier=>'R'
,p_column_label=>'Milestone Id'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(6875382435843433)
,p_db_column_name=>'MILESTONE_ICON'
,p_display_order=>170
,p_column_identifier=>'T'
,p_column_label=>'Milestone Icon'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN_ESCAPE_SC'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(10421138593079409)
,p_db_column_name=>'DISPLAY_STATUS'
,p_display_order=>200
,p_column_identifier=>'W'
,p_column_label=>'Display Status'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(10421226247079410)
,p_db_column_name=>'MILESTONE_LINK'
,p_display_order=>210
,p_column_identifier=>'X'
,p_column_label=>'Milestone Link'
,p_column_type=>'STRING'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(10421322398079411)
,p_db_column_name=>'PERCENT_COMPLETE'
,p_display_order=>220
,p_column_identifier=>'Y'
,p_column_label=>'Percent Complete'
,p_column_type=>'STRING'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(889478866675514018)
,p_db_column_name=>'LAST_UPDATED_TEXT'
,p_display_order=>230
,p_column_identifier=>'Z'
,p_column_label=>'Last Updated Text'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN_ESCAPE_SC'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(889478951416514019)
,p_db_column_name=>'OPEN_TEXT'
,p_display_order=>240
,p_column_identifier=>'AA'
,p_column_label=>'Open Text'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN_ESCAPE_SC'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(889479086478514020)
,p_db_column_name=>'CLOSED_TEXT'
,p_display_order=>250
,p_column_identifier=>'AB'
,p_column_label=>'Closed Text'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN_ESCAPE_SC'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(889479190597514021)
,p_db_column_name=>'COMPLETE_TEXT'
,p_display_order=>260
,p_column_identifier=>'AC'
,p_column_label=>'Complete Text'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN_ESCAPE_SC'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_rpt(
 p_id=>wwv_flow_imp.id(5346708973540098)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_type=>'REPORT'
,p_report_alias=>'53468'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_view_mode=>'DETAIL'
,p_report_columns=>'MILESTONE_NAME:MILESTONE_SLUG:MILESTONE_DESC:MILESTONE_DATE:MILESTONE_STATUS:DISPLAY_STATUS:OPEN_COUNT:CLOSED_COUNT:PERCENT_COMPLETE:UPDATED_ON:'
,p_sort_column_1=>'MILESTONE_DATE'
,p_sort_direction_1=>'ASC'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5401082943234720)
,p_plug_name=>'About'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>'<p>Milestones track events. Issues can be assigned to one or more milestones.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(44794417850280067)
,p_plug_name=>'Utilities'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>21
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_list_id=>wwv_flow_imp.id(10555300999175496)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_imp.id(702419290542782266)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5314340360399731)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(4933933334267945)
,p_button_name=>'CREATE_MILESTONE'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(656569185201725731)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Create Milestone'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:210:&SESSION.::&DEBUG.:RP,210::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(5400915637234719)
,p_computation_sequence=>10
,p_computation_item=>'F4600_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'&APP_PAGE_ID.'
);
end;
/
prompt --application/pages/page_00205
begin
wwv_flow_imp_page.create_page(
 p_id=>205
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Milestone'
,p_step_title=>'Milestone'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883665819126633)
,p_step_template=>wwv_flow_imp.id(694810454825113224)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_protection_level=>'C'
,p_page_component_map=>'03'
,p_last_upd_yyyymmddhh24miss=>'20190821123434'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5314412550399732)
,p_plug_name=>'&P205_MILESTONE_NAME.'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--showTitle:a-Form--leftLabels'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5314892942399736)
,p_plug_name=>'Region Display Selector'
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_source_type=>'NATIVE_DISPLAY_SELECTOR'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'STANDARD'
,p_attribute_02=>'Y'
,p_attribute_03=>'Y'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5314983701399737)
,p_plug_name=>'Hidden Items'
,p_plug_display_sequence=>10
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(5315591150399743)
,p_name=>'Milestone'
,p_display_sequence=>20
,p_component_template_options=>'#DEFAULT#'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX 4600P205 */',
'    milestone_name,',
'    milestone_date,',
'    milestone_status,',
'    milestone_desc,',
'    wwv_flow_issue_int.get_avatar(p_user_name => created_by, p_image_size => 16, p_include_name => ''Y'', p_include_link => ''Y'') CREATED_BY,',
'    apex_util.get_since(m.created_on) CREATED_ON,',
'    wwv_flow_issue_int.get_avatar(p_user_name => updated_by, p_image_size => 16, p_include_name => ''Y'', p_include_link => ''Y'') UPDATED_BY,',
'    apex_util.get_since(m.updated_on) UPDATED_ON',
'from wwv_flow_milestones m',
'where security_group_id = :flow_security_group_id and ',
'      id = :P205_ID'))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(1046850417023553952)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5315636303399744)
,p_query_column_id=>1
,p_column_alias=>'MILESTONE_NAME'
,p_column_display_sequence=>1
,p_column_heading=>'Name'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(6449225521807349)
,p_query_column_id=>2
,p_column_alias=>'MILESTONE_DATE'
,p_column_display_sequence=>2
,p_column_heading=>'Date'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(10420318386079401)
,p_query_column_id=>3
,p_column_alias=>'MILESTONE_STATUS'
,p_column_display_sequence=>3
,p_column_heading=>'Status'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'TEXT_FROM_LOV'
,p_named_lov=>wwv_flow_imp.id(15773100381005765)
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(10420426153079402)
,p_query_column_id=>4
,p_column_alias=>'MILESTONE_DESC'
,p_column_display_sequence=>4
,p_column_heading=>'Description'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5315808685399746)
,p_query_column_id=>5
,p_column_alias=>'CREATED_BY'
,p_column_display_sequence=>5
,p_column_heading=>'Created By'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(10420535183079403)
,p_query_column_id=>6
,p_column_alias=>'CREATED_ON'
,p_column_display_sequence=>6
,p_column_heading=>'Created On'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5315940168399747)
,p_query_column_id=>7
,p_column_alias=>'UPDATED_BY'
,p_column_display_sequence=>7
,p_column_heading=>'Updated By'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(10420629544079404)
,p_query_column_id=>8
,p_column_alias=>'UPDATED_ON'
,p_column_display_sequence=>8
,p_column_heading=>'Updated On'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(5399599693234705)
,p_name=>'Associated Issues'
,p_template=>wwv_flow_imp.id(179998957300224011)
,p_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-Report--inline:a-Report--stretch'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'  select i.id,',
'       wwv_flow_issue_int.get_avatar(p_user_name =>i.created_by, p_image_size => 16, p_include_name => ''Y'', p_include_link => ''Y'') owner,',
'       i.title      issue,',
'       i.status     Status',
'  from wwv_flow_issues i,',
'       wwv_flow_issue_milestones im',
' where im.issue_id = i.id',
'   and im.milestone_id = :P205_ID'))
,p_display_when_condition=>'P205_ID'
,p_display_condition_type=>'ITEM_IS_NOT_NULL'
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(128932681614424007)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>'There are no issues associated with this Milestone.'
,p_query_num_rows_type=>'NEXT_PREVIOUS_LINKS'
,p_pagination_display_position=>'BOTTOM_RIGHT'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5399632808234706)
,p_query_column_id=>1
,p_column_alias=>'ID'
,p_column_display_sequence=>1
,p_use_as_row_header=>'N'
,p_hidden_column=>'Y'
,p_derived_column=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5399778095234707)
,p_query_column_id=>2
,p_column_alias=>'OWNER'
,p_column_display_sequence=>4
,p_column_heading=>'Owner'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5399836934234708)
,p_query_column_id=>3
,p_column_alias=>'ISSUE'
,p_column_display_sequence=>2
,p_column_heading=>'Issue'
,p_use_as_row_header=>'N'
,p_column_link=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP,100:P100_ISSUE_ID:#ID#'
,p_column_linktext=>'#ISSUE#'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5399914604234709)
,p_query_column_id=>4
,p_column_alias=>'STATUS'
,p_column_display_sequence=>3
,p_column_heading=>'Status'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_display_as=>'TEXT_FROM_LOV'
,p_named_lov=>wwv_flow_imp.id(15773100381005765)
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(5400044793234710)
,p_name=>'Metrics'
,p_display_sequence=>10
,p_component_template_options=>'#DEFAULT#:a-BadgeList--stacked:a-BadgeList--large'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select /* APEX4600P205Metrics */',
'   trunc (milestone_date) - trunc(sysdate) days_out,',
'   (select count(*) ',
'      from wwv_flow_issue_milestones',
'     where security_group_id = :flow_security_group_id ',
'       and milestone_id = m.id) associated_issues',
'  from wwv_flow_milestones m',
' where security_group_id = :flow_security_group_id ',
'   and id = :P205_ID'))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(1046845011939553934)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5400113068234711)
,p_query_column_id=>1
,p_column_alias=>'DAYS_OUT'
,p_column_display_sequence=>1
,p_column_heading=>'Days Out'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5400274615234712)
,p_query_column_id=>2
,p_column_alias=>'ASSOCIATED_ISSUES'
,p_column_display_sequence=>2
,p_column_heading=>'Associated Issues'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(5400359807234713)
,p_name=>'Breakdown'
,p_display_sequence=>20
,p_component_template_options=>'#DEFAULT#'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.OPEN'') status, count(*) ',
'          from wwv_flow_issues i, ',
'               wwv_flow_issue_milestones m',
'         where i.id = m.issue_id ',
'           and m.milestone_id = :P205_ID',
'           and i.security_group_id = :flow_security_group_id',
'           and m.security_group_id = :flow_security_group_id ',
'           and i.status = ''OPEN''',
'UNION ALL ',
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.CLOSED'') status, count(*) ',
'          from wwv_flow_issues i, ',
'               wwv_flow_issue_milestones m',
'         where i.id = m.issue_id ',
'           and m.milestone_id = :P205_ID',
'           and i.security_group_id = :flow_security_group_id',
'           and m.security_group_id = :flow_security_group_id ',
'           and i.status = ''CLOSED'''))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(52346073432218689)
,p_query_num_rows=>15
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'N'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5400659454234716)
,p_query_column_id=>1
,p_column_alias=>'STATUS'
,p_column_display_sequence=>1
,p_column_heading=>'Status'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(5612656439530334)
,p_query_column_id=>2
,p_column_alias=>'COUNT(*)'
,p_column_display_sequence=>2
,p_column_heading=>'Status Count'
,p_use_as_row_header=>'N'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5314759854399735)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(5314412550399732)
,p_button_name=>'EDIT'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Edit Milestone'
,p_button_position=>'CREATE'
,p_button_redirect_url=>'f?p=&APP_ID.:210:&SESSION.::&DEBUG.:210:P210_ID:&P205_ID.'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5314530526399733)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(5314412550399732)
,p_button_name=>'PREVIOUS_MILESONE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--pillStart'
,p_button_template_id=>wwv_flow_imp.id(359238865408012460)
,p_button_image_alt=>'Previous'
,p_button_position=>'PREVIOUS'
,p_button_css_classes=>'apex_disabled'
,p_icon_css_classes=>'icon-left-chevron'
,p_button_cattributes=>'disabled=""'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5314660324399734)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(5314412550399732)
,p_button_name=>'NEXT_MILESTONE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#:a-Button--pillEnd'
,p_button_template_id=>wwv_flow_imp.id(359238865408012460)
,p_button_image_alt=>'Next'
,p_button_position=>'PREVIOUS'
,p_button_css_classes=>'apex_disabled'
,p_icon_css_classes=>'icon-right-chevron'
,p_button_cattributes=>'disabled=""'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(5399392796234703)
,p_branch_name=>'Load Previous Milestone'
,p_branch_action=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.::P205_ID:&P205_PREVIOUS_MILESTONE_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_imp.id(5314530526399733)
,p_branch_sequence=>10
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(5399496323234704)
,p_branch_name=>'Load Next Milestone'
,p_branch_action=>'f?p=&APP_ID.:205:&SESSION.::&DEBUG.::P205_ID:&P205_NEXT_MILESTONE_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>20
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5315074498399738)
,p_name=>'P205_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(5314412550399732)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5315162449399739)
,p_name=>'P205_NEXT_MILESTONE_ID'
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(5314412550399732)
,p_display_as=>'NATIVE_HIDDEN'
,p_display_when=>'P205_NEXT_MILESTONE_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5315375449399741)
,p_name=>'P205_PREVIOUS_MILESTONE_ID'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(5314412550399732)
,p_display_as=>'NATIVE_HIDDEN'
,p_display_when=>'P205_PREVIOUS_MILESTONE_ID'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5315431704399742)
,p_name=>'P205_MILESTONE_NAME'
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(5314412550399732)
,p_display_as=>'NATIVE_HIDDEN'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_computation(
 p_id=>wwv_flow_imp.id(5400897196234718)
,p_computation_sequence=>10
,p_computation_item=>'F4600_LAST_VIEW'
,p_computation_point=>'BEFORE_HEADER'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation=>'&APP_PAGE_ID.'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(5316188393399749)
,p_name=>'ENABLE PREVIOUS'
,p_event_sequence=>10
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_display_when_cond=>'P205_PREVIOUS_MILESTONE_ID'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5316295926399750)
,p_event_id=>wwv_flow_imp.id(5316188393399749)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'BUTTON'
,p_affected_button_id=>wwv_flow_imp.id(5314530526399733)
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(5399144284234701)
,p_name=>'ENABLE NEXT'
,p_event_sequence=>20
,p_bind_type=>'bind'
,p_bind_event_type=>'ready'
,p_display_when_type=>'ITEM_IS_NOT_NULL'
,p_display_when_cond=>'P205_NEXT_MILESTONE_ID'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5399259798234702)
,p_event_id=>wwv_flow_imp.id(5399144284234701)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_ENABLE'
,p_affected_elements_type=>'BUTTON'
,p_affected_button_id=>wwv_flow_imp.id(5314660324399734)
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5315241181399740)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Compute Next and Previous'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_current_ms_date date;',
'    l_current_ms_id   number;',
'begin',
'',
':P205_NEXT_MILESTONE_ID     := null;',
':P205_PREVIOUS_MILESTONE_ID := null;',
'',
'--',
'for c1 in (select milestone_name, milestone_date, milestone_id',
'             from wwv_flow_milestones',
'            where id = :P205_ID',
'              and security_group_id = :flow_security_group_id) LOOP',
'    :P205_MILESTONE_NAME := c1.milestone_name;',
'    l_current_ms_date := c1.milestone_date;',
'    l_current_ms_id   := c1.milestone_id;',
'    exit;',
'end loop;',
'',
'--',
'for c1 in ( select id, milestone_id, milestone_date ',
'              from wwv_flow_milestones ',
'             where MILESTONE_DATE >=(select MILESTONE_DATE ',
'                                     from wwv_flow_milestones ',
'                                    where id = :P205_ID ',
'                                      and security_group_id = :flow_security_group_id) ',
'',
'               and security_group_id = :flow_security_group_id',
'               and id != :P205_ID',
'             order by milestone_date asc, milestone_id asc ) loop',
'     if c1.milestone_date > l_current_ms_date then ',
'        :P205_NEXT_MILESTONE_ID := c1.id;',
'        exit;',
'     elsif c1.milestone_date = l_current_ms_date and c1.milestone_id > l_current_ms_id then ',
'        :P205_NEXT_MILESTONE_ID := c1.id;',
'        exit;',
'     end if;',
'end loop;',
'',
'--',
'for c1 in ( select id, milestone_id, milestone_date ',
'              from wwv_flow_milestones ',
'             where MILESTONE_DATE <=(select MILESTONE_DATE ',
'                                     from wwv_flow_milestones ',
'                                    where id = :P205_ID ',
'                                      and security_group_id = :flow_security_group_id) ',
'',
'               and security_group_id = :flow_security_group_id',
'               and id != :P205_ID',
'             order by milestone_date desc, milestone_id desc ) loop',
'     if c1.milestone_date < l_current_ms_date then ',
'        :P205_PREVIOUS_MILESTONE_ID := c1.id;',
'        exit;',
'     elsif c1.milestone_date = l_current_ms_date and c1.milestone_id < l_current_ms_id then ',
'        :P205_PREVIOUS_MILESTONE_ID := c1.id;',
'        exit;',
'     end if;',
'end loop;',
'',
'',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00210
begin
wwv_flow_imp_page.create_page(
 p_id=>210
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Manage Milestone'
,p_step_title=>'Milestone'
,p_warn_on_unsaved_changes=>'N'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883665819126633)
,p_javascript_code=>'var htmldb_delete_message = ''"DELETE_CONFIRM_MSG"'';'
,p_step_template=>wwv_flow_imp.id(694810454825113224)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_protection_level=>'C'
,p_page_component_map=>'02'
,p_last_upd_yyyymmddhh24miss=>'20210910020453'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5314046459399728)
,p_plug_name=>'New'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5353968463645868)
,p_plug_name=>'Milestone'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>10
,p_query_type=>'TABLE'
,p_query_table=>'WWV_FLOW_MILESTONES'
,p_include_rowid_column=>false
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_plug_source_type=>'NATIVE_FORM'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(10828778852511881)
,p_plug_name=>'About'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>'<p>Milestones track events. Issues can be assigned to one or more milestones.</p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5359677139645897)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(5314046459399728)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'CREATE'
,p_button_condition=>'P210_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5360044073645897)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(5314046459399728)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Create'
,p_button_position=>'CREATE'
,p_button_condition=>'P210_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5358405324645890)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(5314046459399728)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'EDIT'
,p_button_redirect_url=>'f?p=&APP_ID.:&F4600_LAST_VIEW.:&SESSION.::&DEBUG.:::'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5359280496645896)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_imp.id(5314046459399728)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Delete'
,p_button_position=>'EDIT'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>'P210_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'DELETE'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(5360378019645897)
,p_branch_name=>'Go To Page &F4600_LAST_ViEW.'
,p_branch_action=>'f?p=&APP_ID.:&F4600_LAST_VIEW.:&SESSION.::&DEBUG.:::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>1
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5354201894645869)
,p_name=>'P210_ID'
,p_source_data_type=>'NUMBER'
,p_is_primary_key=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(5353968463645868)
,p_item_source_plug_id=>wwv_flow_imp.id(5353968463645868)
,p_source=>'ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_protection_level=>'S'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5355004527645887)
,p_name=>'P210_MILESTONE_NAME'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(5353968463645868)
,p_item_source_plug_id=>wwv_flow_imp.id(5353968463645868)
,p_prompt=>'Milestone Name'
,p_source=>'MILESTONE_NAME'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_imp.id(457861279924367968)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>'Identifies the name of the milestone.'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5355470848645888)
,p_name=>'P210_MILESTONE_DATE'
,p_source_data_type=>'DATE'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(5353968463645868)
,p_item_source_plug_id=>wwv_flow_imp.id(5353968463645868)
,p_prompt=>'Date'
,p_source=>'MILESTONE_DATE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_DATE_PICKER_JET'
,p_cSize=>32
,p_cMaxlength=>255
,p_field_template=>wwv_flow_imp.id(457861279924367968)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>'Identifies the milestone date.'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'POPUP'
,p_attribute_03=>'NONE'
,p_attribute_06=>'NONE'
,p_attribute_09=>'N'
,p_attribute_11=>'Y'
,p_attribute_12=>'MONTH-PICKER:YEAR-PICKER'
,p_attribute_13=>'VISIBLE'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5356231206645888)
,p_name=>'P210_MILESTONE_SLUG'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>30
,p_item_plug_id=>wwv_flow_imp.id(5353968463645868)
,p_item_source_plug_id=>wwv_flow_imp.id(5353968463645868)
,p_prompt=>'Slug'
,p_source=>'MILESTONE_SLUG'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_imp.id(457861279924367968)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>'A unique string identifier for the milestone that will be used in URLs.'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6449146520807348)
,p_name=>'P210_MILESTONE_DESC'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_imp.id(5353968463645868)
,p_item_source_plug_id=>wwv_flow_imp.id(5353968463645868)
,p_prompt=>'Description'
,p_source=>'MILESTONE_DESC'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>80
,p_cMaxlength=>4000
,p_cHeight=>5
,p_field_template=>wwv_flow_imp.id(566752393121369432)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(6449312976807350)
,p_name=>'P210_MILESTONE_STATUS'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_imp.id(5353968463645868)
,p_item_source_plug_id=>wwv_flow_imp.id(5353968463645868)
,p_item_default=>'OPEN'
,p_prompt=>'Milestone Status'
,p_source=>'MILESTONE_STATUS'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_named_lov=>'LOCALIZED OPEN CLOSED'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.OPEN'') d, ''OPEN'' r ',
'from dual',
'UNION',
'select wwv_flow_lang.system_message(''APEX.ISSUES.JS.CLOSED'') d, ''CLOSED'' r ',
'from dual'))
,p_cHeight=>1
,p_field_template=>wwv_flow_imp.id(566752393121369432)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'YES'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(5401961051234729)
,p_validation_name=>'Validate Slug'
,p_validation_sequence=>10
,p_validation=>'return wwv_flow_issue_int.validate_slug(:P210_MILESTONE_SLUG);'
,p_validation2=>'PLSQL'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'Invalid Slug. A slug may contain only lower case characters, numbers and dashes.'
,p_associated_item=>wwv_flow_imp.id(5356231206645888)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(5402084147234730)
,p_validation_name=>'Slug is unique in workspace'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1''',
'  from wwv_flow_milestones ',
' where milestone_slug = :P210_MILESTONE_SLUG',
'   and ID != :P210_ID',
'   and security_group_id = :flow_security_group_id'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>'Slug must be unique. Please enter another value containing only lower case characters, numbers and dashes.'
,p_associated_item=>wwv_flow_imp.id(5356231206645888)
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(5401195385234721)
,p_name=>'Generate Slug'
,p_event_sequence=>10
,p_triggering_element_type=>'ITEM'
,p_triggering_element=>'P210_MILESTONE_NAME'
,p_condition_element=>'P210_MILESTONE_NAME'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'keyup'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5401295713234722)
,p_event_id=>wwv_flow_imp.id(5401195385234721)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>':P210_MILESTONE_SLUG := wwv_flow_issue_int.gen_slug(:P210_MILESTONE_NAME);'
,p_attribute_02=>'P210_MILESTONE_NAME'
,p_attribute_03=>'P210_MILESTONE_SLUG'
,p_attribute_04=>'N'
,p_attribute_05=>'PLSQL'
,p_wait_for_result=>'Y'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5361282438645903)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_imp.id(5353968463645868)
,p_process_type=>'NATIVE_FORM_DML'
,p_process_name=>'Process form Create Form'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5360898494645903)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_region_id=>wwv_flow_imp.id(5353968463645868)
,p_process_type=>'NATIVE_FORM_INIT'
,p_process_name=>'Initialize form Create Form'
);
end;
/
prompt --application/pages/page_00300
begin
wwv_flow_imp_page.create_page(
 p_id=>300
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Labels'
,p_alias=>'LABELS'
,p_step_title=>'Labels'
,p_warn_on_unsaved_changes=>'N'
,p_first_item=>'AUTO_FIRST_ITEM'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883741872127080)
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'.color-option {',
'  display: block;',
'  width: 32px;',
'  height: 32px;',
'  padding: 3px;',
'  line-height: 24px;',
'  border-radius: 32px;',
'  text-align: center;',
'  border-style: solid;',
'  border-width: 1px;',
'  font-weight: 500;',
'}'))
,p_step_template=>wwv_flow_imp.id(391881764116992437)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_page_component_map=>'18'
,p_last_upd_yyyymmddhh24miss=>'20210812003731'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(1219801112620110)
,p_plug_name=>'Install Default Labels'
,p_region_template_options=>'#DEFAULT#:js-dialog-size480x320'
,p_plug_template=>wwv_flow_imp.id(10813455696794486)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_04'
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>'<p>Select which language should be used to install the sample Labels.</p></br>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(1220131719620113)
,p_plug_name=>'Install Default Labels'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion:a-Region--accessibleHeader'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>20
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'NOT_EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select * ',
'from wwv_flow_label_groups',
'where security_group_id = :flow_security_group_id'))
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5612979410530337)
,p_plug_name=>'Label Groups Report'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(651492083233530570)
,p_plug_display_sequence=>10
,p_plug_new_grid_row=>false
,p_plug_new_grid_column=>false
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id,',
'       group_name,',
'       group_color,',
'       group_description,',
'       case values_are_exclusive',
'        when ''Y'' then ''<span class="fa fa-star-o" title="Values are Exclusive"></span>''',
'        else null',
'       end values_are_exclusive ,',
'       --',
'       (select count(*) from wwv_flow_labels lg where lg.label_group_id = l.id and lg.security_group_id = :flow_security_group_id) entries,',
'       --',
'       nvl(l.updated_on, l.created_on) group_last_updated,',
'       --',
'       nvl(nvl((select max(nvl(updated_on, created_on))',
'                 from  wwv_flow_labels ',
'                where label_group_id = l.id',
'                  and updated_on is not null), l.updated_on), l.created_on ) entries_last_updated,',
'       wwv_flow_issue_int.get_user_name(created_by) created_by,',
'       created_on,',
'       ---',
'       apex_page.get_url(p_page => 305, p_items => ''P305_LABEL_GROUP_ID'', p_values => id, p_clear_cache => 305) group_link',
'  from wwv_flow_label_groups l',
'where security_group_id = :flow_security_group_id'))
,p_plug_source_type=>'NATIVE_IR'
,p_translate_title=>'N'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_prn_content_disposition=>'ATTACHMENT'
,p_prn_units=>'INCHES'
,p_prn_paper_size=>'LETTER'
,p_prn_width=>8.5
,p_prn_height=>11
,p_prn_orientation=>'HORIZONTAL'
,p_prn_page_header_font_color=>'#000000'
,p_prn_page_header_font_family=>'Helvetica'
,p_prn_page_header_font_weight=>'normal'
,p_prn_page_header_font_size=>'12'
,p_prn_page_footer_font_color=>'#000000'
,p_prn_page_footer_font_family=>'Helvetica'
,p_prn_page_footer_font_weight=>'normal'
,p_prn_page_footer_font_size=>'12'
,p_prn_header_bg_color=>'#9bafde'
,p_prn_header_font_color=>'#000000'
,p_prn_header_font_family=>'Helvetica'
,p_prn_header_font_weight=>'normal'
,p_prn_header_font_size=>'10'
,p_prn_body_bg_color=>'#efefef'
,p_prn_body_font_color=>'#000000'
,p_prn_body_font_family=>'Helvetica'
,p_prn_body_font_weight=>'normal'
,p_prn_body_font_size=>'10'
,p_prn_border_width=>.5
,p_prn_page_header_alignment=>'CENTER'
,p_prn_page_footer_alignment=>'CENTER'
);
wwv_flow_imp_page.create_worksheet(
 p_id=>wwv_flow_imp.id(5613062644530338)
,p_max_row_count=>'1000000'
,p_pagination_type=>'ROWS_X_TO_Y'
,p_pagination_display_pos=>'BOTTOM_RIGHT'
,p_report_list_mode=>'TABS'
,p_lazy_loading=>false
,p_show_detail_link=>'N'
,p_show_notify=>'Y'
,p_download_formats=>'HTML:XLSX:PDF'
,p_enable_mail_download=>'Y'
,p_detail_view_enabled_yn=>'Y'
,p_detail_view_before_rows=>'<div class="a-ContentRowReport">'
,p_detail_view_for_each_row=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<div class="a-ContentRowReport-item">',
'  <a href="#GROUP_LINK#" class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemIconWrap">',
'      <span class="a-ContentRowReport-itemIcon color-option #GROUP_COLOR#" aria-hidden="true">Aa</span>',
'    </div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle">#GROUP_NAME#</h3>',
'        <div class="a-ContentRowReport-itemDescription">#GROUP_DESCRIPTION#</div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">#VALUES_ARE_EXCLUSIVE#</div>',
'      <div class="a-ContentRowReport-itemActions"><span aria-hidden="true" class="fa fa-tags"></span> #ENTRIES#</div>',
'    </div>',
'  </a>',
'</div>',
''))
,p_detail_view_after_rows=>'</div>'
,p_owner=>'DGAULT'
,p_internal_uid=>5613062644530338
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5613193670530339)
,p_db_column_name=>'ID'
,p_display_order=>10
,p_column_identifier=>'A'
,p_column_label=>'Id'
,p_column_type=>'NUMBER'
,p_display_text_as=>'HIDDEN_ESCAPE_SC'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5613297696530340)
,p_db_column_name=>'GROUP_NAME'
,p_display_order=>20
,p_column_identifier=>'B'
,p_column_label=>'Group Name'
,p_column_link=>'f?p=&APP_ID.:305:&SESSION.::&DEBUG.:RP,305:P305_LABEL_GROUP_ID:#ID#'
,p_column_linktext=>'#GROUP_NAME#'
,p_column_type=>'STRING'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5613394497530341)
,p_db_column_name=>'GROUP_COLOR'
,p_display_order=>30
,p_column_identifier=>'C'
,p_column_label=>'Group Color'
,p_column_html_expression=>'<span class="color-option #GROUP_COLOR#">Aa</span>'
,p_allow_sorting=>'N'
,p_allow_filtering=>'N'
,p_allow_highlighting=>'N'
,p_allow_ctrl_breaks=>'N'
,p_allow_aggregations=>'N'
,p_allow_computations=>'N'
,p_allow_charting=>'N'
,p_allow_group_by=>'N'
,p_allow_pivot=>'N'
,p_allow_hide=>'N'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5613438620530342)
,p_db_column_name=>'GROUP_DESCRIPTION'
,p_display_order=>40
,p_column_identifier=>'D'
,p_column_label=>'Group Description'
,p_column_type=>'STRING'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5613533165530343)
,p_db_column_name=>'VALUES_ARE_EXCLUSIVE'
,p_display_order=>50
,p_column_identifier=>'E'
,p_column_label=>'Values Are Exclusive'
,p_column_type=>'STRING'
,p_display_text_as=>'WITHOUT_MODIFICATION'
,p_column_alignment=>'CENTER'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5613644069530344)
,p_db_column_name=>'ENTRIES'
,p_display_order=>60
,p_column_identifier=>'F'
,p_column_label=>'Entries'
,p_column_type=>'NUMBER'
,p_column_alignment=>'RIGHT'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5613740888530345)
,p_db_column_name=>'GROUP_LAST_UPDATED'
,p_display_order=>70
,p_column_identifier=>'G'
,p_column_label=>'Group Last Updated'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5613837599530346)
,p_db_column_name=>'ENTRIES_LAST_UPDATED'
,p_display_order=>80
,p_column_identifier=>'H'
,p_column_label=>'Entries Last Updated'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_format_mask=>'SINCE'
,p_tz_dependent=>'N'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5613935889530347)
,p_db_column_name=>'CREATED_BY'
,p_display_order=>90
,p_column_identifier=>'I'
,p_column_label=>'Created By'
,p_column_type=>'STRING'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(5614029872530348)
,p_db_column_name=>'CREATED_ON'
,p_display_order=>100
,p_column_identifier=>'J'
,p_column_label=>'Created On'
,p_column_type=>'DATE'
,p_column_alignment=>'CENTER'
,p_tz_dependent=>'N'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_column(
 p_id=>wwv_flow_imp.id(6875688403843436)
,p_db_column_name=>'GROUP_LINK'
,p_display_order=>110
,p_column_identifier=>'K'
,p_column_label=>'Group Link'
,p_column_type=>'STRING'
,p_display_text_as=>'HIDDEN_ESCAPE_SC'
,p_use_as_row_header=>'N'
);
wwv_flow_imp_page.create_worksheet_rpt(
 p_id=>wwv_flow_imp.id(5705047486344537)
,p_application_user=>'APXWS_DEFAULT'
,p_report_seq=>10
,p_report_type=>'REPORT'
,p_report_alias=>'57051'
,p_status=>'PUBLIC'
,p_is_default=>'Y'
,p_view_mode=>'DETAIL'
,p_report_columns=>'GROUP_NAME:GROUP_COLOR:VALUES_ARE_EXCLUSIVE:ENTRIES:GROUP_DESCRIPTION:GROUP_LAST_UPDATED:ENTRIES_LAST_UPDATED::GROUP_LINK'
,p_sort_column_1=>'GROUP_NAME'
,p_sort_direction_1=>'ASC'
,p_sort_column_2=>'0'
,p_sort_direction_2=>'ASC'
,p_sort_column_3=>'0'
,p_sort_direction_3=>'ASC'
,p_sort_column_4=>'0'
,p_sort_direction_4=>'ASC'
,p_sort_column_5=>'0'
,p_sort_direction_5=>'ASC'
,p_sort_column_6=>'0'
,p_sort_direction_6=>'ASC'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(6950681909294493)
,p_plug_name=>'About'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>'<p>Label Groups and Labels are used to classify issues. Each group is assigned an identifying color so that labels within the same group can be easily identified. Groups can defined as Exclusive or Non-Exclusive, dictating whether multiple values fro'
||'m a single group may be assigned to an issue. </p>'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(56003781858197975)
,p_plug_name=>'Utilities'
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding:a-Region--sideRegion'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>30
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_list_id=>wwv_flow_imp.id(10555300999175496)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_imp.id(702419290542782266)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(1220205376620114)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(1220131719620113)
,p_button_name=>'INSTALL_DEFAULT'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Install Default Labels'
,p_warn_on_unsaved_changes=>null
,p_grid_new_row=>'Y'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(1220069539620112)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(1219801112620110)
,p_button_name=>'INSTALL'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Install'
,p_button_position=>'NEXT'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(1219988323620111)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(1219801112620110)
,p_button_name=>'CANCEL'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'PREVIOUS'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5708453352527201)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(5612979410530337)
,p_button_name=>'RESET'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Reset'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:300,RIR::'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5708574915527202)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(5612979410530337)
,p_button_name=>'CREATE_NEW_GROUP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(656569185201725731)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Create'
,p_button_position=>'RIGHT_OF_IR_SEARCH_BAR'
,p_button_redirect_url=>'f?p=&APP_ID.:301:&SESSION.::&DEBUG.:301,305::'
,p_icon_css_classes=>'icon-right-chevron'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(1251680459956460)
,p_name=>'P300_LANGUAGE'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(1219801112620110)
,p_item_default=>'APEX_UTIL.GET_SESSION_LANG'
,p_item_default_type=>'EXPRESSION'
,p_item_default_language=>'PLSQL'
,p_prompt=>'Label Language'
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select  l.translated_lang_name d, f.flow_language r',
'                  from ( select flow_language',
'                           from wwv_flows f',
'                          where id = :APP_ID',
'                          union',
'                         select flow_language',
'                           from wwv_flows f',
'                          where id in ( select translation_flow_id',
'                                          from wwv_flow_language_map',
'                                         where primary_language_flow_id = :APP_ID )',
'                       ) f,',
'                       wwv_flow_languages l',
'                 where f.flow_language = l.lang_id'))
,p_cHeight=>1
,p_field_template=>wwv_flow_imp.id(457861279924367968)
,p_item_template_options=>'#DEFAULT#'
,p_lov_display_extra=>'NO'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'NONE'
,p_attribute_02=>'N'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(1220391298620115)
,p_name=>'Show Install Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(1220205376620114)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(1220482077620116)
,p_event_id=>wwv_flow_imp.id(1220391298620115)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_OPEN_REGION'
,p_affected_elements_type=>'REGION'
,p_affected_region_id=>wwv_flow_imp.id(1219801112620110)
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(1219682985620108)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'Create Default Labels'
,p_process_sql_clob=>'wwv_flow_issue_seed_int.install_default_labels(p_lang => :P300_LANGUAGE);'
,p_process_clob_language=>'PLSQL'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
,p_process_when_button_id=>wwv_flow_imp.id(1220069539620112)
);
end;
/
prompt --application/pages/page_00301
begin
wwv_flow_imp_page.create_page(
 p_id=>301
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Create / Edit Label Group'
,p_page_mode=>'MODAL'
,p_step_title=>'Create / Edit Label Group'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883741872127080)
,p_javascript_code=>'var htmldb_delete_message=''"DELETE_CONFIRM_MSG"'';'
,p_inline_css=>wwv_flow_string.join(wwv_flow_t_varchar2(
'/* Color Options Radio Item',
'   ========================================================================== */',
'/* Display radios as inline blocks */',
'.color-options-radio .apex-item-option {',
'  display: inline-block;',
'  vertical-align: top;',
'}',
'',
'/* This is necessary to show the help icon to the right of the color radios */',
'.color-options-radio .a-Form-inputContainer {',
'  display: flex;',
'  align-items: start;',
'}',
'',
'/* Remove the focus outline as the first radio will automatically gain focus */',
'.color-options-radio .apex-item-radio:focus {',
'  outline: none;',
'}',
'',
'/* Visually hide radio buttons */',
'.color-options-radio input[type=''radio''] {',
'  position: absolute;',
'  overflow: hidden;',
'  clip: rect(0 0 0 0);',
'  margin: -1px;',
'  padding: 0;',
'  width: 1px;',
'  height: 1px;',
'  border: 0;',
'}',
'',
'/* Display labels as block and set appropriate spacing, dimensions',
'   This label is used to indicate focus state */',
'.color-options-radio input + label {',
'  display: block;',
'  padding: 0 !important;',
'  margin: 4px;',
'  border-radius: 24px;',
'}',
'',
'.color-options-radio label:before,',
'.color-options-radio label:after {',
'  content: none !important;',
'}',
'',
'/* The default state for these color radios will display the text ',
'   ''Aa'' inside the circle */',
'.color-options-radio input + label span:before {',
'  content: ''Aa'';',
'  font-weight: 500;',
'}',
'',
'/* Add outline the label when checked */',
'.color-options-radio input:checked + label {',
'  box-shadow: 0 0 0 2px white, 0 0 0 4px #0572ce;',
'}',
'',
'/* Add an outline + glow to label when focused */',
'.color-options-radio input:focus + label {',
'  box-shadow: 0 0 0 2px white, 0 0 0 4px #0572ce, 0 0 4px 4px #0572ce;',
'}',
'',
'/* When an item is checked, display check icon instead of text */',
'.color-options-radio input:checked + label span:before {',
'  font-family: "apex-5-icon-font" !important;',
'  font-style: normal !important;',
'  font-weight: normal !important;',
'  font-variant: normal !important;',
'  text-transform: none !important;',
'  speak: none;',
'  font-size: 20px;',
'  line-height: 24px;',
'  -webkit-font-smoothing: antialiased;',
'  content: "\e007";',
'  display: block;',
'  text-shadow: 0 0 1px, 0 0 1px, 0 0 1px;',
'}',
'',
'/* Color Radio Options (set in the globalization template)',
'   ========================================================================== */',
'.color-option {',
'  display: block;',
'  width: 32px;',
'  height: 32px;',
'  padding: 3px;',
'  line-height: 24px;',
'  border-radius: 32px;',
'  text-align: center;',
'  border-style: solid;',
'  border-width: 1px;',
'}'))
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_protection_level=>'C'
,p_page_component_map=>'02'
,p_last_upd_yyyymmddhh24miss=>'20210525121358'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5760797683920682)
,p_plug_name=>'Edit Label Groups'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(47229974494774989)
,p_plug_display_sequence=>10
,p_query_type=>'TABLE'
,p_query_table=>'WWV_FLOW_LABEL_GROUPS'
,p_include_rowid_column=>false
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_lost_update_check_type=>'VALUES'
,p_plug_source_type=>'NATIVE_FORM'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5764550641920696)
,p_plug_name=>'Wizard Buttons'
,p_region_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>20
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'TEXT'
,p_attribute_03=>'Y'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5764939662920696)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(5764550641920696)
,p_button_name=>'CANCEL'
,p_button_action=>'DEFINED_BY_DA'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'CLOSE'
,p_warn_on_unsaved_changes=>null
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5766514193920717)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(5764550641920696)
,p_button_name=>'DELETE'
,p_button_action=>'REDIRECT_URL'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Delete'
,p_button_position=>'DELETE'
,p_button_redirect_url=>'javascript:apex.confirm(htmldb_delete_message,''DELETE'');'
,p_button_execute_validations=>'N'
,p_button_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_count number;',
'BEGIN ',
'',
'select count(*)',
'  into l_count',
'  from wwv_flow_issue_labels ',
' where label_id in (select l.id',
'                      from wwv_flow_labels l',
'                     where label_group_id = :P301_id',
'                       and security_group_id = :flow_security_group_id)',
'   and security_group_id = :flow_security_group_id;',
'--',
'if :P301_ID is not null and l_count = 0 then ',
'    return TRUE;',
'else ',
'    return FALSE;',
'end if;',
'',
'END;'))
,p_button_condition2=>'PLSQL'
,p_button_condition_type=>'FUNCTION_BODY'
,p_database_action=>'DELETE'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5766983411920718)
,p_button_sequence=>30
,p_button_plug_id=>wwv_flow_imp.id(5764550641920696)
,p_button_name=>'SAVE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Apply Changes'
,p_button_position=>'NEXT'
,p_button_condition=>'P301_ID'
,p_button_condition_type=>'ITEM_IS_NOT_NULL'
,p_database_action=>'UPDATE'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5767378673920718)
,p_button_sequence=>40
,p_button_plug_id=>wwv_flow_imp.id(5764550641920696)
,p_button_name=>'CREATE'
,p_button_action=>'SUBMIT'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_is_hot=>'Y'
,p_button_image_alt=>'Create'
,p_button_position=>'NEXT'
,p_button_condition=>'P301_ID'
,p_button_condition_type=>'ITEM_IS_NULL'
,p_database_action=>'INSERT'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(5709059297527207)
,p_branch_name=>'Go to 305'
,p_branch_action=>'f?p=&APP_ID.:305:&SESSION.::&DEBUG.:RP:P305_LABEL_GROUP_ID:&P301_ID.&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_sequence=>10
,p_branch_condition_type=>'REQUEST_IN_CONDITION'
,p_branch_condition=>'SAVE,CREATE'
);
wwv_flow_imp_page.create_page_branch(
 p_id=>wwv_flow_imp.id(5709152444527208)
,p_branch_name=>'Go To Page 301'
,p_branch_action=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP::&success_msg=#SUCCESS_MSG#'
,p_branch_point=>'AFTER_PROCESSING'
,p_branch_type=>'REDIRECT_URL'
,p_branch_when_button_id=>wwv_flow_imp.id(5766514193920717)
,p_branch_sequence=>20
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5710186210527218)
,p_name=>'P301_DELETE_WARNING'
,p_item_sequence=>70
,p_item_plug_id=>wwv_flow_imp.id(5760797683920682)
,p_item_default=>'wwv_flow_lang.system_message(''APEX.ISSUES.LABEL_GROUP_DELETE_WARNING'')'
,p_item_default_type=>'EXPRESSION'
,p_item_default_language=>'PLSQL'
,p_prompt=>'NOTE:'
,p_display_as=>'NATIVE_DISPLAY_ONLY'
,p_display_when=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1'' ',
'  from wwv_flow_issue_labels ',
' where label_id in (select l.id',
'                      from wwv_flow_labels l',
'                     where label_group_id = :P301_id',
'                       and security_group_id = :flow_security_group_id)',
'   and security_group_id = :flow_security_group_id',
'    '))
,p_display_when_type=>'EXISTS'
,p_field_template=>wwv_flow_imp.id(566752393121369432)
,p_item_template_options=>'#DEFAULT#'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'VALUE'
,p_attribute_04=>'Y'
,p_attribute_05=>'PLAIN'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5761077930920684)
,p_name=>'P301_ID'
,p_source_data_type=>'NUMBER'
,p_is_primary_key=>true
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(5760797683920682)
,p_item_source_plug_id=>wwv_flow_imp.id(5760797683920682)
,p_source=>'ID'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_HIDDEN'
,p_is_persistent=>'N'
,p_protection_level=>'S'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5761493789920691)
,p_name=>'P301_GROUP_NAME'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>20
,p_item_plug_id=>wwv_flow_imp.id(5760797683920682)
,p_item_source_plug_id=>wwv_flow_imp.id(5760797683920682)
,p_prompt=>'Group Name'
,p_source=>'GROUP_NAME'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXT_FIELD'
,p_cSize=>60
,p_cMaxlength=>255
,p_field_template=>wwv_flow_imp.id(457861279924367968)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>'Unique name for the label group.'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'N'
,p_attribute_04=>'TEXT'
,p_attribute_05=>'BOTH'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5761813224920693)
,p_name=>'P301_GROUP_COLOR'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>40
,p_item_plug_id=>wwv_flow_imp.id(5760797683920682)
,p_item_source_plug_id=>wwv_flow_imp.id(5760797683920682)
,p_prompt=>'Group Label Color'
,p_source=>'GROUP_COLOR'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_RADIOGROUP'
,p_named_lov=>'LABEL_GROUP_COLORS'
,p_lov=>'.'||wwv_flow_imp.id(5734638238767974)||'.'
,p_field_template=>wwv_flow_imp.id(457861279924367968)
,p_item_css_classes=>'color-options-radio'
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_lov_display_extra=>'NO'
,p_escape_on_http_output=>'N'
,p_restricted_characters=>'NO_SPECIAL_CHAR_NL'
,p_help_text=>'The color that will be used to display all labels within the group. '
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'8'
,p_attribute_02=>'NONE'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5762285296920694)
,p_name=>'P301_GROUP_DESCRIPTION'
,p_source_data_type=>'VARCHAR2'
,p_item_sequence=>60
,p_item_plug_id=>wwv_flow_imp.id(5760797683920682)
,p_item_source_plug_id=>wwv_flow_imp.id(5760797683920682)
,p_prompt=>'Group Description'
,p_source=>'GROUP_DESCRIPTION'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_TEXTAREA'
,p_cSize=>60
,p_cMaxlength=>4000
,p_cHeight=>4
,p_field_template=>wwv_flow_imp.id(566752393121369432)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5762658425920694)
,p_name=>'P301_VALUES_ARE_EXCLUSIVE'
,p_source_data_type=>'VARCHAR2'
,p_is_required=>true
,p_item_sequence=>50
,p_item_plug_id=>wwv_flow_imp.id(5760797683920682)
,p_item_source_plug_id=>wwv_flow_imp.id(5760797683920682)
,p_prompt=>'Values Are Exclusive'
,p_source=>'VALUES_ARE_EXCLUSIVE'
,p_source_type=>'REGION_SOURCE_COLUMN'
,p_display_as=>'NATIVE_YES_NO'
,p_field_template=>wwv_flow_imp.id(457861279924367968)
,p_item_template_options=>'#DEFAULT#'
,p_is_persistent=>'N'
,p_help_text=>'Dictates whether the values of the group are exclusively assigned to an issue. If <strong>On</strong>, then only one label from the group can be assigned to an issue at any given time. If <strong>Off</strong>, then multiple labels from the same group'
||' may be assigned to an issue.'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'N'
,p_attribute_02=>'Y'
,p_attribute_03=>'Yes'
,p_attribute_04=>'N'
,p_attribute_05=>'No'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(5765094853920696)
,p_name=>'Cancel Dialog'
,p_event_sequence=>10
,p_triggering_element_type=>'BUTTON'
,p_triggering_button_id=>wwv_flow_imp.id(5764939662920696)
,p_bind_type=>'bind'
,p_bind_event_type=>'click'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(5765898088920705)
,p_event_id=>wwv_flow_imp.id(5765094853920696)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_DIALOG_CANCEL'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5768140350920719)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_imp.id(5760797683920682)
,p_process_type=>'NATIVE_FORM_DML'
,p_process_name=>'Process form Create Form'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5767767486920719)
,p_process_sequence=>10
,p_process_point=>'BEFORE_HEADER'
,p_region_id=>wwv_flow_imp.id(5760797683920682)
,p_process_type=>'NATIVE_FORM_INIT'
,p_process_name=>'Initialize form Create Form'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00305
begin
wwv_flow_imp_page.create_page(
 p_id=>305
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'Manage Labels'
,p_step_title=>'Manage Labels'
,p_autocomplete_on_off=>'OFF'
,p_group_id=>wwv_flow_imp.id(4883741872127080)
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_page_component_map=>'21'
,p_last_upd_yyyymmddhh24miss=>'20210525121421'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5708682809527203)
,p_plug_name=>'Top Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5710040153527217)
,p_plug_name=>'About'
,p_region_template_options=>'#DEFAULT#:a-Region--paddedBody:a-Region--sideRegion'
,p_plug_template=>wwv_flow_imp.id(179998957300224011)
,p_plug_display_sequence=>10
,p_include_in_reg_disp_sel_yn=>'Y'
,p_plug_display_point=>'REGION_POSITION_03'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<p>Labels are sorted into Label Groups and are used to classify issues. Here you can manage the Labels for the selected Group. </p>',
'<br/>',
'<p><strong>NOTE:</strong> You may not delete labels that are currently assigned to an issue. </p>'))
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_attribute_01=>'N'
,p_attribute_02=>'HTML'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(5714789063586345)
,p_plug_name=>'Manage Labels'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(651492083233530570)
,p_plug_display_sequence=>11
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with labels as (select ID,',
'       LABEL_GROUP_ID,',
'       LABEL_NAME,',
'       LABEL_DESC,',
'       LABEL_SLUG,',
'       DISPLAY_SEQUENCE, ',
'       (select count(*) from wwv_flow_issue_labels where label_id = l.id and security_group_id = :flow_security_group_id) references',
'  from WWV_FLOW_LABELS l',
' where label_group_id = :P305_LABEL_GROUP_ID',
'   and security_group_id = :flow_security_group_id)',
' select ID, ',
'        LABEL_GROUP_ID,',
'        LABEL_NAME,',
'        LABEL_DESC,',
'        LABEL_SLUG,',
'        DISPLAY_SEQUENCE,',
'        REFERENCES, ',
'        case ',
'            when REFERENCES > 0 then ''U''',
'            ELSE ''UD''',
'        end ALLOWED_OPS',
'  from labels    '))
,p_plug_source_type=>'NATIVE_IG'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_plug_display_when_condition=>'P305_LABEL_GROUP_ID'
,p_plug_display_when_cond2=>'0'
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5709623269527213)
,p_name=>'ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>30
,p_attribute_01=>'Y'
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5709705992527214)
,p_name=>'REFERENCES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'REFERENCES'
,p_data_type=>'NUMBER'
,p_is_query_only=>true
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'References'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>100
,p_value_alignment=>'RIGHT'
,p_attribute_02=>'VALUE'
,p_attribute_05=>'PLAIN'
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>false
,p_is_primary_key=>false
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5709944021527216)
,p_name=>'ALLOWED_OPS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ALLOWED_OPS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>true
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>50
,p_attribute_01=>'Y'
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_is_primary_key=>false
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5715983075586359)
,p_name=>'APEX$ROW_SELECTOR'
,p_item_type=>'NATIVE_ROW_SELECTOR'
,p_display_sequence=>10
,p_attribute_01=>'Y'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_use_as_row_header=>false
,p_enable_hide=>true
,p_is_primary_key=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5716497343586364)
,p_name=>'APEX$ROW_ACTION'
,p_item_type=>'NATIVE_ROW_ACTION'
,p_label=>'Actions'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>20
,p_value_alignment=>'CENTER'
,p_use_as_row_header=>false
,p_enable_hide=>true
,p_is_primary_key=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5717653661586367)
,p_name=>'LABEL_GROUP_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_GROUP_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>40
,p_attribute_01=>'Y'
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_default_type=>'ITEM'
,p_default_expression=>'P305_LABEL_GROUP_ID'
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5718867906586368)
,p_name=>'LABEL_NAME'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_NAME'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Label Name'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>60
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>true
,p_max_length=>255
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5719470789586368)
,p_name=>'LABEL_DESC'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_DESC'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Label Desc'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>80
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5722449928586370)
,p_name=>'LABEL_SLUG'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABEL_SLUG'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'Label Slug'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>70
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>255
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(5723017344586370)
,p_name=>'DISPLAY_SEQUENCE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'DISPLAY_SEQUENCE'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Sequence'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>90
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_enable_pivot=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_interactive_grid(
 p_id=>wwv_flow_imp.id(5715253254586347)
,p_internal_uid=>5715253254586347
,p_is_editable=>true
,p_edit_operations=>'i:u:d'
,p_edit_row_operations_column=>'ALLOWED_OPS'
,p_lost_update_check_type=>'VALUES'
,p_add_row_if_empty=>false
,p_submit_checked_rows=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_show_nulls_as=>'-'
,p_select_first_row=>false
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>true
,p_no_data_found_message=>'There are currently no labels within this group. You may add them here.'
,p_show_toolbar=>true
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>true
,p_download_formats=>'HTML'
,p_enable_mail_download=>true
,p_fixed_header=>'PAGE'
,p_show_icon_view=>false
,p_show_detail_view=>false
);
wwv_flow_imp_page.create_ig_report(
 p_id=>wwv_flow_imp.id(5715653679586349)
,p_interactive_grid_id=>wwv_flow_imp.id(5715253254586347)
,p_static_id=>'9311'
,p_type=>'PRIMARY'
,p_default_view=>'GRID'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_imp_page.create_ig_report_view(
 p_id=>wwv_flow_imp.id(5715707786586352)
,p_report_id=>wwv_flow_imp.id(5715653679586349)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(5716877434586365)
,p_view_id=>wwv_flow_imp.id(5715707786586352)
,p_display_seq=>0
,p_column_id=>wwv_flow_imp.id(5716497343586364)
,p_is_visible=>true
,p_is_frozen=>true
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(5718042973586367)
,p_view_id=>wwv_flow_imp.id(5715707786586352)
,p_display_seq=>2
,p_column_id=>wwv_flow_imp.id(5717653661586367)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(5719223961586368)
,p_view_id=>wwv_flow_imp.id(5715707786586352)
,p_display_seq=>5
,p_column_id=>wwv_flow_imp.id(5718867906586368)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(5719891282586368)
,p_view_id=>wwv_flow_imp.id(5715707786586352)
,p_display_seq=>7
,p_column_id=>wwv_flow_imp.id(5719470789586368)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(5722804008586370)
,p_view_id=>wwv_flow_imp.id(5715707786586352)
,p_display_seq=>6
,p_column_id=>wwv_flow_imp.id(5722449928586370)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(5723484417586370)
,p_view_id=>wwv_flow_imp.id(5715707786586352)
,p_display_seq=>3
,p_column_id=>wwv_flow_imp.id(5723017344586370)
,p_is_visible=>true
,p_is_frozen=>false
,p_sort_order=>1
,p_sort_direction=>'ASC'
,p_sort_nulls=>'LAST'
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(5787728469211382)
,p_view_id=>wwv_flow_imp.id(5715707786586352)
,p_display_seq=>8
,p_column_id=>wwv_flow_imp.id(5709623269527213)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(5792555850327984)
,p_view_id=>wwv_flow_imp.id(5715707786586352)
,p_display_seq=>8
,p_column_id=>wwv_flow_imp.id(5709705992527214)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(5793629182360206)
,p_view_id=>wwv_flow_imp.id(5715707786586352)
,p_display_seq=>10
,p_column_id=>wwv_flow_imp.id(5709944021527216)
,p_is_visible=>true
,p_is_frozen=>false
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5708911293527206)
,p_button_sequence=>10
,p_button_plug_id=>wwv_flow_imp.id(5708682809527203)
,p_button_name=>'EDIT_GROUP'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Edit Group'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:301:&SESSION.::&DEBUG.:RP,301:P301_ID:&P305_LABEL_GROUP_ID.'
);
wwv_flow_imp_page.create_page_button(
 p_id=>wwv_flow_imp.id(5708861547527205)
,p_button_sequence=>20
,p_button_plug_id=>wwv_flow_imp.id(5708682809527203)
,p_button_name=>'CANCEL'
,p_button_action=>'REDIRECT_PAGE'
,p_button_template_options=>'#DEFAULT#'
,p_button_template_id=>wwv_flow_imp.id(188432383783551716)
,p_button_image_alt=>'Cancel'
,p_button_position=>'NEXT'
,p_button_redirect_url=>'f?p=&APP_ID.:300:&SESSION.::&DEBUG.:RP,305::'
);
wwv_flow_imp_page.create_page_item(
 p_id=>wwv_flow_imp.id(5708734444527204)
,p_name=>'P305_LABEL_GROUP_ID'
,p_item_sequence=>10
,p_item_plug_id=>wwv_flow_imp.id(5708682809527203)
,p_prompt=>'Label Group '
,p_display_as=>'NATIVE_SELECT_LIST'
,p_lov=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Select wwv_flow_escape.html(group_name) name, id',
'from wwv_flow_label_groups',
'where security_group_id = :flow_security_group_id',
'order by upper(name)'))
,p_lov_display_null=>'YES'
,p_lov_null_text=>'- Select Label Group -'
,p_lov_null_value=>'0'
,p_cHeight=>1
,p_field_template=>wwv_flow_imp.id(566752393121369432)
,p_item_template_options=>'#DEFAULT#'
,p_warn_on_unsaved_changes=>'I'
,p_lov_display_extra=>'NO'
,p_help_text=>'Select the Label Group you would like to edit. The Group Labels will automatically display. You must create or select a Label Group before adding Labels.'
,p_encrypt_session_state_yn=>'N'
,p_attribute_01=>'REDIRECT_SET_VALUE'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(5709491226527211)
,p_tabular_form_region_id=>wwv_flow_imp.id(5714789063586345)
,p_validation_name=>'Validate Slug'
,p_validation_sequence=>10
,p_validation=>'return wwv_flow_issue_int.validate_slug(:LABEL_SLUG);'
,p_validation2=>'PLSQL'
,p_validation_type=>'FUNC_BODY_RETURNING_BOOLEAN'
,p_error_message=>'Invalid Slug. A slug may contain only lower case characters, numbers and dashes.'
,p_always_execute=>'Y'
,p_associated_column=>'LABEL_SLUG'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_validation(
 p_id=>wwv_flow_imp.id(5709553111527212)
,p_tabular_form_region_id=>wwv_flow_imp.id(5714789063586345)
,p_validation_name=>'Label Slug is Unique in Workspace'
,p_validation_sequence=>20
,p_validation=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''1''',
'  from wwv_flow_labels',
' where label_slug = :LABEL_SLUG',
'   and id != :ID',
'   and security_group_id = :flow_security_group_id'))
,p_validation_type=>'NOT_EXISTS'
,p_error_message=>'Slug must be unique. Please enter another value containing only lower case characters, numbers and dashes.'
,p_associated_column=>'LABEL_SLUG'
,p_error_display_location=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_page.create_page_da_event(
 p_id=>wwv_flow_imp.id(889477190767514001)
,p_name=>'Gen Slug'
,p_event_sequence=>10
,p_triggering_element_type=>'COLUMN'
,p_triggering_region_id=>wwv_flow_imp.id(5714789063586345)
,p_triggering_element=>'LABEL_NAME'
,p_condition_element_type=>'COLUMN'
,p_condition_element=>'LABEL_NAME'
,p_triggering_condition_type=>'NOT_NULL'
,p_bind_type=>'bind'
,p_bind_event_type=>'change'
);
wwv_flow_imp_page.create_page_da_action(
 p_id=>wwv_flow_imp.id(889477275411514002)
,p_event_id=>wwv_flow_imp.id(889477190767514001)
,p_event_result=>'TRUE'
,p_action_sequence=>10
,p_execute_on_page_init=>'N'
,p_action=>'NATIVE_EXECUTE_PLSQL_CODE'
,p_attribute_01=>':LABEL_SLUG := wwv_flow_issue_int.gen_slug(:LABEL_NAME);'
,p_attribute_02=>'LABEL_SLUG,LABEL_NAME'
,p_attribute_03=>'LABEL_SLUG'
,p_attribute_04=>'N'
,p_attribute_05=>'PLSQL'
,p_wait_for_result=>'Y'
);
wwv_flow_imp_page.create_page_process(
 p_id=>wwv_flow_imp.id(5723669112586376)
,p_process_sequence=>10
,p_process_point=>'AFTER_SUBMIT'
,p_region_id=>wwv_flow_imp.id(5714789063586345)
,p_process_type=>'NATIVE_IG_DML'
,p_process_name=>'Manage Labels - Save Interactive Grid Data'
,p_attribute_01=>'REGION_SOURCE'
,p_attribute_05=>'Y'
,p_attribute_06=>'Y'
,p_attribute_08=>'Y'
,p_error_display_location=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/pages/page_00500
begin
wwv_flow_imp_page.create_page(
 p_id=>500
,p_user_interface_id=>wwv_flow_imp.id(9728334451760999)
,p_name=>'User Profile'
,p_step_title=>'&P500_DISPLAY_NAME. - Issues'
,p_autocomplete_on_off=>'OFF'
,p_page_template_options=>'#DEFAULT#'
,p_required_role=>wwv_flow_imp.id(17268112003727577)
,p_protection_level=>'C'
,p_page_component_map=>'21'
,p_last_upd_yyyymmddhh24miss=>'20210910021731'
);
wwv_flow_imp_page.create_report_region(
 p_id=>wwv_flow_imp.id(11047540937484649)
,p_name=>'Summary'
,p_region_name=>'dashboard'
,p_template=>wwv_flow_imp.id(179998957300224011)
,p_display_sequence=>20
,p_region_template_options=>'#DEFAULT#:a-Region--noPadding'
,p_component_template_options=>'#DEFAULT#:a-BadgeList--stacked:a-BadgeList--large'
,p_display_point=>'REGION_POSITION_03'
,p_source_type=>'NATIVE_SQL_REPORT'
,p_query_type=>'SQL'
,p_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues i',
'     where created_by = :P500_USER_NAME',
'       and i.status = ''OPEN''',
'       and i.deleted= ''N''',
'       and security_group_id = :flow_security_group_id)  owned_issues    ,',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues i, ',
'           wwv_flow_issue_stakeholders s',
'     where s.issue_id = i.id',
'       and s.stakeholder = :P500_USER_NAME',
'       and s.stakeholder_type = ''ASSIGNEE''',
'       and i.status = ''OPEN''',
'       and i.deleted = ''N''',
'       and s.security_group_id = :flow_security_group_id',
'       and i.security_group_id = :flow_security_group_id)  assigned_issues,       ',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_issues i, ',
'           wwv_flow_issue_stakeholders s',
'     where s.issue_id = i.id',
'       and s.stakeholder = :P500_USER_NAME',
'       and s.stakeholder_type = ''SUBSCRIBER''',
'       and i.status = ''OPEN''',
'       and i.deleted = ''N''',
'       and s.security_group_id = :flow_security_group_id',
'       and i.security_group_id = :flow_security_group_id)  subscribed_issues, ',
'   (select to_char(count(*),''999G999G999G990'') ',
'      from wwv_flow_milestones',
'     where security_group_id = :flow_security_group_id',
'       and created_by = :P500_USER_NAME) owned_milestones',
' from dual'))
,p_ajax_enabled=>'Y'
,p_lazy_loading=>false
,p_query_row_template=>wwv_flow_imp.id(1046845011939553934)
,p_query_num_rows=>7
,p_query_options=>'DERIVED_REPORT_COLUMNS'
,p_query_show_nulls_as=>'-'
,p_query_no_data_found=>'Report contains no data'
,p_query_row_count_max=>7
,p_csv_output=>'N'
,p_prn_output=>'N'
,p_sort_null=>'L'
,p_plug_query_strip_html=>'Y'
,p_comment=>'style="width:33%; float:left;"'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(6185654103627137)
,p_query_column_id=>1
,p_column_alias=>'OWNED_ISSUES'
,p_column_display_sequence=>1
,p_column_heading=>'Owned Issues'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'CENTER'
,p_disable_sort_column=>'N'
,p_display_as=>'WITHOUT_MODIFICATION'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(6185860860627139)
,p_query_column_id=>2
,p_column_alias=>'ASSIGNED_ISSUES'
,p_column_display_sequence=>3
,p_column_heading=>'Assigned Issues'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'CENTER'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(6185963790627140)
,p_query_column_id=>3
,p_column_alias=>'SUBSCRIBED_ISSUES'
,p_column_display_sequence=>4
,p_column_heading=>'Subscribed Issues'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'CENTER'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_report_columns(
 p_id=>wwv_flow_imp.id(6185790300627138)
,p_query_column_id=>4
,p_column_alias=>'OWNED_MILESTONES'
,p_column_display_sequence=>5
,p_column_heading=>'Owned Milestones'
,p_use_as_row_header=>'N'
,p_column_format=>'999G999G999G999G999G999G990'
,p_column_alignment=>'CENTER'
,p_disable_sort_column=>'N'
,p_derived_column=>'N'
,p_include_in_export=>'Y'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(11125556808028800)
,p_plug_name=>'Title Bar'
,p_region_template_options=>'#DEFAULT#:a-ButtonRegion--withItems:a-ButtonRegion--noBorder'
,p_plug_template=>wwv_flow_imp.id(694479338908463138)
,p_plug_display_sequence=>11
,p_plug_item_display_point=>'BELOW'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    l_html      varchar2(32767);',
'begin ',
'    l_html :=    ''',
'<div class="a-IssueHeader">',
'  <div class="a-IssueHeader-itemStatusIconWrap">'' || wwv_flow_issue_int.get_avatar(p_user_name => :P500_USER_NAME, p_modifier_class => ''a-User--lg'', p_include_name => ''N'') || ''</div>',
'  <div class="a-IssueHeader-body">',
'    <h1 class="a-IssueHeader-title">''||apex_escape.html(:P500_DISPLAY_NAME)||''</h1>',
'    <div class="a-IssueHeader-info">''||apex_escape.html(:P500_EMAIL_ADDRESS)||''</div>',
'  </div>',
'</div>',
''';',
'    sys.htp.p(l_html);',
'end;'))
,p_plug_source_type=>'NATIVE_PLSQL'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(11497747092045337)
,p_plug_name=>'User Tabs'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(214132567690623104)
,p_plug_display_sequence=>21
,p_list_id=>wwv_flow_imp.id(11496705512045322)
,p_plug_source_type=>'NATIVE_LIST'
,p_list_template_id=>wwv_flow_imp.id(11515926722097128)
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
,p_plug_display_condition_type=>'EXISTS'
,p_plug_display_when_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'  from dual ',
'where :APP_USER = :P500_USER_NAME'))
);
wwv_flow_imp_page.create_page_plug(
 p_id=>wwv_flow_imp.id(16097755849950438)
,p_plug_name=>'My Issues'
,p_region_name=>'issues'
,p_region_template_options=>'#DEFAULT#:a-IRR-region--noOuterBorders'
,p_component_template_options=>'#DEFAULT#'
,p_plug_template=>wwv_flow_imp.id(651492083233530570)
,p_plug_display_sequence=>31
,p_include_in_reg_disp_sel_yn=>'Y'
,p_query_type=>'SQL'
,p_plug_source=>wwv_flow_string.join(wwv_flow_t_varchar2(
'with agg_stakeholders as (',
'    select issue_id,',
'           listagg(case when seqnum <=5 then wwv_flow_issue_int.get_user_name(stakeholder) end, '', '') ',
'            within group(order by wwv_flow_issue_int.get_user_name(stakeholder) ) assignees, ',
'           listagg(case when seqnum <=5 then wwv_flow_issue_int.get_avatar(stakeholder, p_image_size => 24, p_include_link => ''Y'') end, '' '') ',
'            within group(order by stakeholder ) assignees_html, ',
'           count(*) assignee_count',
'      from (select ss.*, ',
'                   row_number() over (partition by ISSUE_ID order by stakeholder ) as seqnum ',
'              from wwv_flow_issue_stakeholders ss',
'             where ss.stakeholder_type = ''ASSIGNEE''',
'               and ss.security_group_id = :flow_security_group_id)',
'     group by issue_id',
'), agg_subscribers as (',
'    select issue_id,',
'           listagg(wwv_flow_issue_int.get_user_name(stakeholder), '':'') ',
'            within group(order by wwv_flow_issue_int.get_user_name(stakeholder) ) subcribers,',
'           listagg(wwv_flow_issue_int.get_avatar(stakeholder, p_image_size => 24, p_include_link => ''Y''), '' '') ',
'            within group( order by stakeholder ) subscribers_html, ',
'           count(*) subscriber_count',
'      from wwv_flow_issue_stakeholders',
'     where stakeholder_type = ''SUBSCRIBER''',
'       and security_group_id = :flow_security_group_id',
'     group by issue_id',
'), ',
'agg_labels as (',
'    select issue_id,',
'           listagg(label_name, '', '') within group(',
'                order by label_name',
'           ) labels, ',
'           listagg(''<span class="a-IssueLabel ''||g.group_color||''" > ''||label_name||''</span>'', '''') within group(',
'                order by g.group_name, l.label_name',
'           ) labels_html',
'      from wwv_flow_issue_labels il,',
'           wwv_flow_labels l, ',
'           wwv_flow_label_groups g',
'     where il.label_id = l.id',
'       and l.label_group_id = g.id',
'       and il.security_group_id = :flow_security_group_id',
'       and l.security_group_id = :flow_security_group_id',
'       and g.security_group_id = :flow_security_group_id',
'     group by issue_id',
'), ',
'agg_milestones as (',
'  select issue_id,',
'           listagg(milestone_name, '':'') within group(',
'                order by milestone_name',
'           ) milestones,',
'           listagg(''<a class="a-IssueMilestone" href="''||apex_util.prepare_url(''f?p=''||:APP_ID||'':205:''||:APP_SESSION||''::::P205_ID:''||m.id )||''"><span class="fa fa-map-signs" aria-hidden="true"></span>''||milestone_name||''</a> '', '' '') within group(',
'                order by milestone_name',
'           ) milestones_html',
'      from wwv_flow_issue_milestones im,',
'           wwv_flow_milestones m',
'     where im.milestone_id = m.id',
'       and im.security_group_id = :flow_security_group_id',
'       and m.security_group_id = :flow_security_group_id',
'     group by issue_id',
')',
'select i.id,',
'       i.issue_number,',
'       i.title,',
'       i.slug,',
'       i.status,',
'       case ',
'           when i.status = ''OPEN'' then ''<span aria-hidden="true" class="a-IssueList-itemStatusIcon a-IssueList-itemStatusIcon--open fa fa-exclamation-circle-o" title="''||i.status||''"></span>''',
'           WHEN i.status = ''CLOSED'' then ''<span aria-hidden="true" class="a-IssueList-itemStatusIcon a-IssueList-itemStatusIcon--closed fa fa-exclamation-circle-o fam-check fam-is-danger" title="''||i.status||''"></span>''',
'       end issue_status,',
'       i.issue_text,',
'       case ',
'            when i.duplicate_of is not null then ',
'                wwv_flow_lang.system_message(''APEX.ISSUES.TIMELINE.MARKED_DUPLICATE_OF'', p0=> i2.title, p1=> apex_util.get_since(i.duplicate_identified_on),  p2=>i.duplicate_identified_by )',
'            else ''''',
'        end  marked_duplicate,',
'       i.application_id,',
'       i.page_id,',
'        wwv_flow_lang.system_message(''APEX.ISSUES.TIMELINE.OPENED'', p0=>apex_util.get_since(i.created_on)) created,',
'       apex_util.prepare_url(''f?p=''||:APP_ID||'':500:''||:APP_SESSION||''::::P500_USER_NAME:''||i.created_by) created_by_link,',
'       i.created_on ,',
'       wwv_flow_issue_int.get_user_name(i.created_by) created_by,',
'       (',
'           select count(*)',
'             from wwv_flow_issue_comments c',
'            where c.issue_id = i.id',
'       ) comment_count,',
'       (',
'           select count(*)',
'             from wwv_flow_issue_events e',
'            where e.issue_id = i.id',
'       ) event_count,',
'       h.assignees,',
'       h.assignees_html,',
'       ss.subcribers,',
'       ss.subscribers_html,',
'       l.labels,',
'       l.labels_html,',
'       m.milestones, ',
'       m.milestones_html,',
'       apex_util.prepare_url(''f?p=''||:APP_ID||'':100:''||:APP_SESSION||''::NO:RP:P100_ISSUE_ID:''||i.id )issue_link, ',
'       case ',
'         when h.assignee_count > 5 then ''+''||(h.assignee_count -5) ',
'         else null',
'       end more_assignees',
'  from wwv_flow_issues               i,',
'       wwv_flow_current_workspaces   w,',
'       agg_stakeholders              h,',
'       agg_subscribers               ss,',
'       agg_labels                    l,',
'       wwv_flow_issues               i2,',
'       agg_milestones                  m',
' where i.deleted = ''N'' ',
'   and i.security_group_id = w.workspace_id',
'   and i.security_group_id = :flow_security_group_id',
'   and w.workspace_id = :flow_security_group_id',
'   and h.issue_id (+) = i.id',
'   and ss.issue_id (+) = i.id',
'   and l.issue_id (+) = i.id',
'   and m.issue_id (+) = i.id',
'   and i.duplicate_of = i2.id (+)',
'   and (i.created_by = :P500_USER_NAME',
'        OR ',
'        instr(h.assignees, wwv_flow_issue_int.get_user_name(:P500_USER_NAME) ) > 0',
'        OR',
'        instr(ss.subcribers,  wwv_flow_issue_int.get_user_name(:P500_USER_NAME)) > 0)',
''))
,p_plug_source_type=>'NATIVE_IG'
,p_plug_query_options=>'DERIVED_REPORT_COLUMNS'
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16098000256950440)
,p_name=>'ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'ID'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>20
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>true
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16098073052950441)
,p_name=>'TITLE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'TITLE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_LINK'
,p_heading=>'Title'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>30
,p_value_alignment=>'LEFT'
,p_link_target=>'f?p=&APP_ID.:100:&SESSION.::&DEBUG.:RP:P100_ISSUE_ID:&ID.'
,p_link_text=>'&TITLE.'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
,p_escape_on_http_output=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16098148723950442)
,p_name=>'SLUG'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SLUG'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_HIDDEN'
,p_display_sequence=>40
,p_attribute_01=>'Y'
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16098261686950443)
,p_name=>'ISSUE_STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_STATUS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Status Icon'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>50
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_attribute_05=>'HTML'
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16098335969950444)
,p_name=>'ISSUE_TEXT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_TEXT'
,p_data_type=>'CLOB'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Issue Text'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>60
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>true
,p_max_length=>32767
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16098498670950445)
,p_name=>'MARKED_DUPLICATE'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MARKED_DUPLICATE'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Marked Duplicate'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>70
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16098658687950447)
,p_name=>'PAGE_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'PAGE_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Page ID'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>90
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16098779357950448)
,p_name=>'CREATED'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Created'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>100
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16098832498950449)
,p_name=>'CREATED_BY'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_BY'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Created By'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>110
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16099004994950450)
,p_name=>'COMMENT_COUNT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'COMMENT_COUNT'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Comments'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>120
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16099091711950451)
,p_name=>'EVENT_COUNT'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'EVENT_COUNT'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Events'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>130
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16099133014950452)
,p_name=>'ASSIGNEES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ASSIGNEES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Assignee list'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>140
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16099297474950453)
,p_name=>'ASSIGNEES_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ASSIGNEES_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Assignee Icons'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>150
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_attribute_05=>'HTML'
,p_enable_filter=>false
,p_filter_is_required=>false
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16137859472284504)
,p_name=>'SUBCRIBERS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SUBCRIBERS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Subcriber List'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>160
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16137970055284505)
,p_name=>'SUBSCRIBERS_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'SUBSCRIBERS_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Subscriber Icons'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>170
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_attribute_05=>'HTML'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16138056062284506)
,p_name=>'LABELS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABELS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Label List'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>180
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16138207326284507)
,p_name=>'LABELS_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'LABELS_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Beutified Lables'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>190
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_attribute_05=>'HTML'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16138238471284508)
,p_name=>'MILESTONES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MILESTONES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Milestone List'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>200
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16138417422284509)
,p_name=>'MILESTONES_HTML'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MILESTONES_HTML'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Beautified Milestones'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>210
,p_value_alignment=>'LEFT'
,p_attribute_02=>'VALUE'
,p_attribute_05=>'HTML'
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>false
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16307965494246038)
,p_name=>'ISSUE_LINK'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_LINK'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Issue Link'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>220
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16642917689045004)
,p_name=>'STATUS'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'STATUS'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DISPLAY_ONLY'
,p_heading=>'Status'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>230
,p_value_alignment=>'LEFT'
,p_attribute_02=>'LOV'
,p_attribute_05=>'PLAIN'
,p_lov_type=>'SHARED'
,p_lov_id=>wwv_flow_imp.id(5664182917694426)
,p_lov_display_extra=>true
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'LOV'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16642970775045005)
,p_name=>'CREATED_ON'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_ON'
,p_data_type=>'DATE'
,p_is_query_only=>false
,p_item_type=>'NATIVE_DATE_PICKER_JET'
,p_heading=>'Created On'
,p_heading_alignment=>'CENTER'
,p_display_sequence=>240
,p_value_alignment=>'CENTER'
,p_attribute_01=>'N'
,p_attribute_02=>'POPUP'
,p_attribute_03=>'NONE'
,p_attribute_06=>'NONE'
,p_attribute_09=>'N'
,p_attribute_11=>'Y'
,p_attribute_12=>'MONTH-PICKER:YEAR-PICKER'
,p_attribute_13=>'VISIBLE'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_date_ranges=>'ALL'
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(16881324442342844)
,p_name=>'CREATED_BY_LINK'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'CREATED_BY_LINK'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXTAREA'
,p_heading=>'Created By Link'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>250
,p_value_alignment=>'LEFT'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
,p_attribute_03=>'N'
,p_attribute_04=>'BOTH'
,p_is_required=>false
,p_max_length=>4000
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>false
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(17028210148862207)
,p_name=>'ISSUE_NUMBER'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'ISSUE_NUMBER'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Issue #'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>260
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>true
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(156403038933150733)
,p_name=>'MORE_ASSIGNEES'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'MORE_ASSIGNEES'
,p_data_type=>'VARCHAR2'
,p_is_query_only=>false
,p_item_type=>'NATIVE_TEXT_FIELD'
,p_heading=>'More Assignees'
,p_heading_alignment=>'LEFT'
,p_display_sequence=>270
,p_value_alignment=>'LEFT'
,p_attribute_05=>'BOTH'
,p_is_required=>false
,p_max_length=>41
,p_enable_filter=>true
,p_filter_operators=>'C:S:CASE_INSENSITIVE:REGEXP'
,p_filter_is_required=>false
,p_filter_text_case=>'MIXED'
,p_filter_exact_match=>true
,p_filter_lov_type=>'DISTINCT'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(165799585931198816)
,p_name=>'APPLICATION_ID'
,p_source_type=>'DB_COLUMN'
,p_source_expression=>'APPLICATION_ID'
,p_data_type=>'NUMBER'
,p_is_query_only=>false
,p_item_type=>'NATIVE_NUMBER_FIELD'
,p_heading=>'Application ID'
,p_heading_alignment=>'RIGHT'
,p_display_sequence=>80
,p_value_alignment=>'RIGHT'
,p_attribute_03=>'right'
,p_is_required=>false
,p_enable_filter=>true
,p_filter_is_required=>false
,p_filter_lov_type=>'NONE'
,p_use_as_row_header=>false
,p_enable_sort_group=>true
,p_enable_control_break=>true
,p_enable_hide=>true
,p_is_primary_key=>false
,p_duplicate_value=>true
,p_include_in_export=>true
);
wwv_flow_imp_page.create_region_column(
 p_id=>wwv_flow_imp.id(681099570647003801)
,p_name=>'Row Selector'
,p_item_type=>'NATIVE_ROW_SELECTOR'
,p_display_sequence=>10
,p_attribute_01=>'Y'
,p_attribute_02=>'Y'
,p_attribute_03=>'N'
,p_use_as_row_header=>false
);
end;
/
begin
wwv_flow_imp_page.create_interactive_grid(
 p_id=>wwv_flow_imp.id(16097863831950439)
,p_internal_uid=>16097863831950439
,p_is_editable=>false
,p_lazy_loading=>false
,p_requires_filter=>false
,p_show_nulls_as=>'-'
,p_select_first_row=>false
,p_fixed_row_height=>true
,p_pagination_type=>'SCROLL'
,p_show_total_row_count=>false
,p_no_data_found_message=>'This user is not referenced by any issues.'
,p_show_toolbar=>true
,p_toolbar_buttons=>'SEARCH_FIELD:ACTIONS_MENU:RESET:SAVE'
,p_enable_save_public_report=>false
,p_enable_subscriptions=>true
,p_enable_flashback=>false
,p_define_chart_view=>false
,p_enable_download=>false
,p_download_formats=>null
,p_enable_mail_download=>true
,p_fixed_header=>'PAGE'
,p_show_icon_view=>true
,p_icon_view_use_custom=>true
,p_icon_view_custom=>wwv_flow_string.join(wwv_flow_t_varchar2(
'<li class="a-ContentRowReport-item" data-id="&APEX$ROW_ID.">',
'  <div class="a-ContentRowReport-itemWrap">',
'    <div class="a-ContentRowReport-itemSelection"><span class="u-selector"></span></div>',
'    <div class="a-ContentRowReport-itemIconWrap">&ISSUE_STATUS.</div>',
'    <div class="a-ContentRowReport-itemBody">',
'      <div class="a-ContentRowReport-itemContent">',
'        <h3 class="a-ContentRowReport-itemTitle" id="label_&ID."><a href="&ISSUE_LINK.">&TITLE.</a></h3> <span class="a-IssueList-itemLabels">&LABELS_HTML.</span>',
'        <div class="a-ContentRowReport-itemDescription">#&ISSUE_NUMBER. &CREATED. <a class="a-IssueList-itemAuthor" href="&CREATED_BY_LINK.">&CREATED_BY.</a> <span class="a-IssueList-itemMilestones">&MILESTONES_HTML.</span></div>',
'      </div>',
'      <div class="a-ContentRowReport-itemMisc">&ASSIGNEES_HTML.<span class="a-User a-User--more" title="&MORE_ASSIGNEES. other assignees"><span class="a-User-initials" role="presentation">&MORE_ASSIGNEES.</span></span></div>',
'      <div class="a-ContentRowReport-itemActions">',
'        <a class="a-IssueList-itemCommentsLink" href="&ISSUE_LINK."><span class="a-IssueList-itemCommentsIcon fa fa-comments-o"></span><span class="a-IssueList-itemCommentsCount">&COMMENT_COUNT.</span></a>',
'      </div>',
'    </div>',
'  </div>',
'</li>'))
,p_show_detail_view=>false
,p_javascript_code=>wwv_flow_string.join(wwv_flow_t_varchar2(
'function (options) {',
'    var $ = apex.jQuery,',
'        toolbarData = $.apex.interactiveGrid.copyDefaultToolbar();',
'',
'    // don''t want single row view',
'    apex.util.getNestedObject(options, "views.grid.features").singleRowView = false;',
'',
'    options.defaultIconViewOptions = {',
'        collectionClasses: "a-ContentRowReport a-IssueList",',
'        iconListOptions: {',
'            navigation: false,',
'            tabbableContent: "a"',
'            // comes from row selector when navigation is false',
'            // multiple: true ',
'            // itemSelector: true',
'        }',
'    }',
'',
'    options.initActions = function(actions) {',
'        var ig$ = $(actions.context),',
'            iconView = ig$.interactiveGrid("getViews").icon;',
'',
'        iconView.title = apex.lang.getMessage( "Cards"); ',
'        iconView.icon = "icon-ig-details";',
'    };',
'',
'    return options;',
'',
'}',
''))
);
wwv_flow_imp_page.create_ig_report(
 p_id=>wwv_flow_imp.id(22275636446049695)
,p_interactive_grid_id=>wwv_flow_imp.id(16097863831950439)
,p_name=>'Open Issues'
,p_static_id=>'Open'
,p_type=>'PRIMARY'
,p_default_view=>'ICON'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_imp_page.create_ig_report_view(
 p_id=>wwv_flow_imp.id(32836000000)
,p_report_id=>wwv_flow_imp.id(22275636446049695)
,p_view_type=>'ICON'
);
wwv_flow_imp_page.create_ig_report_view(
 p_id=>wwv_flow_imp.id(16826843550457215)
,p_report_id=>wwv_flow_imp.id(22275636446049695)
,p_view_type=>'DETAIL'
);
wwv_flow_imp_page.create_ig_report_view(
 p_id=>wwv_flow_imp.id(22275637777049702)
,p_report_id=>wwv_flow_imp.id(22275636446049695)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(31121006338722)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>26
,p_column_id=>wwv_flow_imp.id(165799585931198816)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(10695353644715703)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>23
,p_column_id=>wwv_flow_imp.id(16881324442342844)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(10695435629715703)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>2
,p_column_id=>wwv_flow_imp.id(17028210148862207)
,p_is_visible=>true
,p_is_frozen=>true
,p_width=>107.13329999999999
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22276154381049716)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>1
,p_column_id=>wwv_flow_imp.id(16098000256950440)
,p_is_visible=>false
,p_is_frozen=>true
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22276631991049744)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>4
,p_column_id=>wwv_flow_imp.id(16098073052950441)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>454.783
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22277120896049746)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>2
,p_column_id=>wwv_flow_imp.id(16098148723950442)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22277602826049747)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>4
,p_column_id=>wwv_flow_imp.id(16098261686950443)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22278116907049749)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>5
,p_column_id=>wwv_flow_imp.id(16098335969950444)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22278544558049750)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>6
,p_column_id=>wwv_flow_imp.id(16098498670950445)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22279582558049753)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>7
,p_column_id=>wwv_flow_imp.id(16098658687950447)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22280136478049755)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>11
,p_column_id=>wwv_flow_imp.id(16098779357950448)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>178
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22280569966049756)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>10
,p_column_id=>wwv_flow_imp.id(16098832498950449)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>168
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22281060139049758)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>16
,p_column_id=>wwv_flow_imp.id(16099004994950450)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>85
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22281619349049759)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>15
,p_column_id=>wwv_flow_imp.id(16099091711950451)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>69
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22282042660049761)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>13
,p_column_id=>wwv_flow_imp.id(16099133014950452)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>280
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22282567378049762)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>17
,p_column_id=>wwv_flow_imp.id(16099297474950453)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22283098144049768)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>18
,p_column_id=>wwv_flow_imp.id(16137859472284504)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22283598475049769)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>19
,p_column_id=>wwv_flow_imp.id(16137970055284505)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22284098342049771)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>12
,p_column_id=>wwv_flow_imp.id(16138056062284506)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>376
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22284546601049772)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>20
,p_column_id=>wwv_flow_imp.id(16138207326284507)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22285037217049774)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>14
,p_column_id=>wwv_flow_imp.id(16138238471284508)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>223
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22285555076049775)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>21
,p_column_id=>wwv_flow_imp.id(16138417422284509)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22514679451383400)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>22
,p_column_id=>wwv_flow_imp.id(16307965494246038)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22780467814804570)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>9
,p_column_id=>wwv_flow_imp.id(16642917689045004)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>67
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(22781083334804594)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>24
,p_column_id=>wwv_flow_imp.id(16642970775045005)
,p_is_visible=>false
,p_is_frozen=>false
,p_sort_order=>1
,p_sort_direction=>'ASC'
,p_sort_nulls=>'LAST'
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(471471936121674265)
,p_view_id=>wwv_flow_imp.id(22275637777049702)
,p_display_seq=>25
,p_column_id=>wwv_flow_imp.id(156403038933150733)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_filter(
 p_id=>wwv_flow_imp.id(183137000001)
,p_report_id=>wwv_flow_imp.id(22275636446049695)
,p_type=>'COLUMN'
,p_column_id=>wwv_flow_imp.id(16642917689045004)
,p_operator=>'EQ'
,p_is_case_sensitive=>false
,p_expression=>'Open'
,p_is_enabled=>true
);
wwv_flow_imp_page.create_ig_report(
 p_id=>wwv_flow_imp.id(699699266351067762)
,p_interactive_grid_id=>wwv_flow_imp.id(16097863831950439)
,p_name=>'Closed Issues'
,p_static_id=>'Closed'
,p_type=>'ALTERNATIVE'
,p_default_view=>'ICON'
,p_show_row_number=>false
,p_settings_area_expanded=>true
);
wwv_flow_imp_page.create_ig_report_view(
 p_id=>wwv_flow_imp.id(677423662741018067)
,p_report_id=>wwv_flow_imp.id(699699266351067762)
,p_view_type=>'ICON'
);
wwv_flow_imp_page.create_ig_report_view(
 p_id=>wwv_flow_imp.id(694250473455475282)
,p_report_id=>wwv_flow_imp.id(699699266351067762)
,p_view_type=>'DETAIL'
);
wwv_flow_imp_page.create_ig_report_view(
 p_id=>wwv_flow_imp.id(699699267682067769)
,p_report_id=>wwv_flow_imp.id(699699266351067762)
,p_view_type=>'GRID'
,p_stretch_columns=>true
,p_srv_exclude_null_values=>false
,p_srv_only_display_columns=>true
,p_edit_mode=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(677454750911356789)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>26
,p_column_id=>wwv_flow_imp.id(165799585931198816)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(688118983549733770)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>23
,p_column_id=>wwv_flow_imp.id(16881324442342844)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(688119065534733770)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>2
,p_column_id=>wwv_flow_imp.id(17028210148862207)
,p_is_visible=>true
,p_is_frozen=>true
,p_width=>107.13329999999999
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699699784286067783)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>1
,p_column_id=>wwv_flow_imp.id(16098000256950440)
,p_is_visible=>false
,p_is_frozen=>true
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699700261896067811)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>4
,p_column_id=>wwv_flow_imp.id(16098073052950441)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>454.783
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699700750801067813)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>2
,p_column_id=>wwv_flow_imp.id(16098148723950442)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699701232731067814)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>4
,p_column_id=>wwv_flow_imp.id(16098261686950443)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699701746812067816)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>5
,p_column_id=>wwv_flow_imp.id(16098335969950444)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699702174463067817)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>6
,p_column_id=>wwv_flow_imp.id(16098498670950445)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699703212463067820)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>7
,p_column_id=>wwv_flow_imp.id(16098658687950447)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699703766383067822)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>11
,p_column_id=>wwv_flow_imp.id(16098779357950448)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>178
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699704199871067823)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>10
,p_column_id=>wwv_flow_imp.id(16098832498950449)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>168
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699704690044067825)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>16
,p_column_id=>wwv_flow_imp.id(16099004994950450)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>85
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699705249254067826)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>15
,p_column_id=>wwv_flow_imp.id(16099091711950451)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>69
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699705672565067828)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>13
,p_column_id=>wwv_flow_imp.id(16099133014950452)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>280
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699706197283067829)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>17
,p_column_id=>wwv_flow_imp.id(16099297474950453)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699706728049067835)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>18
,p_column_id=>wwv_flow_imp.id(16137859472284504)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699707228380067836)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>19
,p_column_id=>wwv_flow_imp.id(16137970055284505)
,p_is_visible=>false
,p_is_frozen=>false
);
wwv_flow_imp_page.create_ig_report_column(
 p_id=>wwv_flow_imp.id(699707728247067838)
,p_view_id=>wwv_flow_imp.id(699699267682067769)
,p_display_seq=>12
,p_column_id=>wwv_flow_imp.id(16138056062284506)
,p_is_visible=>true
,p_is_frozen=>false
,p_width=>376
);
wwv_flow_imp_page.cr