prompt --application/set_environment
set define off verify off feedback off
--------------------------------------------------------------------------------
--
-- Oracle APEX export file
--
-- You should run the script connected to SQL*Plus as the Oracle user
-- APEX_220100 or as the owner (parsing schema) of the application.
--
-- NOTE: Calls to apex_application_install override the defaults below.
--
--------------------------------------------------------------------------------
begin
wwv_flow_imp.import_begin (
 p_version_yyyy_mm_dd=>'2022.04.12'
,p_release=>'22.1.0-17'
,p_default_workspace_id=>10
,p_default_application_id=>4000
,p_default_id_offset=>0
,p_default_owner=>'APEX_220100'
);
end;
/
 
prompt APPLICATION 4000 - Oracle APEX App Builder
--
-- Application Export:
--   Application:     4000
--   Name:            Oracle APEX App Builder
--   Exported By:     APEX_220100
--   Flashback:       0
--   Export Type:     Application Export
--     Pages:                    843
--       Items:                4,663
--       Computations:           572
--       Validations:          1,162
--       Processes:            1,275
--       Regions:              3,798
--       Buttons:              2,273
--       Dynamic Actions:      1,225
--     Shared Components:
--       Logic:
--         Items:                 32
--         Processes:             12
--         Computations:           7
--         Build Options:          7
--       Navigation:
--         Lists:                247
--         Breadcrumbs:            1
--           Entries:            758
--         NavBar Entries:         3
--       Security:
--         Authentication:         1
--         Authorization:         19
--       User Interface:
--         Themes:                 1
--         Templates:
--           Page:                10
--           Region:              40
--           Label:               11
--           List:                16
--           Popup LOV:            1
--           Calendar:             1
--           Breadcrumb:           1
--           Button:               7
--           Report:              20
--         LOVs:                 910
--         Shortcuts:              9
--         Plug-ins:              28
--       Globalization:
--         Messages:             540
--       Reports:
--       E-Mail:
--     Supporting Objects:  Included
--   Version:         22.1.0-17
--   Instance ID:     697845941895809
--

prompt --application/delete_application
begin
wwv_flow_imp.remove_flow(wwv_flow.g_flow_id);
end;
/
prompt --application/create_application
begin
wwv_flow_imp.create_flow(
 p_id=>wwv_flow.g_flow_id
,p_owner=>nvl(wwv_flow_application_install.get_schema,'APEX_220100')
,p_name=>nvl(wwv_flow_application_install.get_application_name,'Oracle APEX App Builder')
,p_alias=>nvl(wwv_flow_application_install.get_application_alias,'BUILDER')
,p_application_group=>wwv_flow_imp.id(91050719712959059)
,p_application_group_name=>'APEX Product'
,p_application_group_comment=>'Applications shipped with the APEX product distribution'
,p_page_view_logging=>'YES'
,p_charset=>'utf-8'
,p_page_protection_enabled_y_n=>'Y'
,p_checksum_salt_last_reset=>'20220419070441'
,p_bookmark_checksum_function=>'SH1'
,p_compatibility_mode=>'5.0'
,p_flow_language=>'en'
,p_flow_language_derived_from=>'SESSION'
,p_date_format=>'&DATE_FORMAT.'
,p_direction_right_to_left=>'N'
,p_flow_image_prefix => nvl(wwv_flow_application_install.get_image_prefix,'')
,p_publish_yn=>'Y'
,p_documentation_banner=>wwv_flow_string.join(wwv_flow_t_varchar2(
'Oracle APEX application development user interface.',
'',
'Developers:  Michael Hichwa, Joel Kallman, Christina Cho, Scott Spadafore, Marc Sewtz, Jason Straub, Sharon Kennedy, Carl Backstrom, Kris Rice, Syme Kutz, Terri Winters, Marco Adelfio, Hilary Farrell, Anthony Rayner, Allan Sitterson, Sathish Kumar, A'
||'shish Verma, Patrick Wolf, Carsten Czarski',
'',
'Contributors:  William Dwight, Tim Hoechst, Thomas Kyte, Chris Beck, David Bliss, Jason Rhodes, Sean Dillon, Ken Jacobs, Darcy Menard, Sudha Kannan, Ganesh Pitchaiah, Srinivas Rayapeddi, Anton Nielsen, Sergio Leunissen, Tyler Muth, Raj Mattamal, Scot'
||'t Spendolini'))
,p_authentication=>'PLUGIN'
,p_authentication_id=>wwv_flow_imp.id(532421019614096524)
,p_populate_roles=>'A'
,p_application_tab_set=>1
,p_logo_type=>'C'
,p_logo=>'<img src="#IMAGE_PREFIX#apex_ui/apexlogo.png" width="282" height="20" alt="&PRODUCT_NAME." />'
,p_public_user=>'APEX_PUBLIC_USER'
,p_proxy_server=>nvl(wwv_flow_application_install.get_proxy,'')
,p_no_proxy_domains=>nvl(wwv_flow_application_install.get_no_proxy_domains,'')
,p_flow_version=>'&PRODUCT_NAME. 22.1.0-17'
,p_flow_status=>'AVAILABLE_W_EDIT_LINK'
,p_flow_unavailable_text=>'This application is currently unavailable at this time.'
,p_exact_substitutions_only=>'Y'
,p_browser_cache=>'N'
,p_browser_frame=>'D'
,p_runtime_api_usage=>'T:O'
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
,p_authorize_public_pages_yn=>'Y'
,p_rejoin_existing_sessions=>'N'
,p_csv_encoding=>'Y'
,p_auto_time_zone=>'N'
,p_error_handling_function=>'wwv_flow_error_dev.internal_error_handler'
,p_friendly_url=>'N'
,p_substitution_string_01=>'HELP'
,p_substitution_value_01=>'Help'
,p_substitution_string_02=>'PRODUCT_NAME'
,p_substitution_value_02=>'Oracle APEX'
,p_substitution_string_03=>'MSG_COMPANY'
,p_substitution_value_03=>'Workspace: &COMPANY.'
,p_substitution_string_04=>'MSG_LANGUAGE'
,p_substitution_value_04=>'Language'
,p_substitution_string_05=>'MSG_COPYRIGHT'
,p_substitution_value_05=>'Copyright &copy; 1999, 2022, Oracle and/or its affiliates.'
,p_substitution_string_06=>'MSG_USER'
,p_substitution_value_06=>'User'
,p_substitution_string_07=>'MSG_JSCRIPT'
,p_substitution_value_07=>'You must run this product with JavaScript enabled.'
,p_substitution_string_08=>'MSG_TBL_SUMMARY'
,p_substitution_value_08=>'Page Layout Table'
,p_substitution_string_09=>'EDIT'
,p_substitution_value_09=>'Edit'
,p_substitution_string_10=>'DONE'
,p_substitution_value_10=>'Done'
,p_substitution_string_11=>'TOP'
,p_substitution_value_11=>'Top'
,p_substitution_string_12=>'CLOSE'
,p_substitution_value_12=>'Close'
,p_substitution_string_13=>'CONFIRM'
,p_substitution_value_13=>'Confirm'
,p_substitution_string_14=>'DATE_FORMAT'
,p_substitution_value_14=>'mm/dd/yyyy'
,p_substitution_string_15=>'LONG_DATE_FORMAT'
,p_substitution_value_15=>'fmDay, Month dd, yyyy'
,p_substitution_string_16=>'TIME_FORMAT'
,p_substitution_value_16=>'hh:mi:ss AM'
,p_substitution_string_17=>'DATE_TIME_FORMAT'
,p_substitution_value_17=>'mm/dd/yyyy hh:mi:ss AM'
,p_substitution_string_18=>'RETURN_TO_APP'
,p_substitution_value_18=>'Return to Application'
,p_substitution_string_19=>'DELETE_MSG'
,p_substitution_value_19=>'Would you like to perform this delete action?'
,p_substitution_string_20=>'PAGE'
,p_substitution_value_20=>'Page'
,p_last_updated_by=>''
,p_last_upd_yyyymmddhh24miss=>'20220419070441'
,p_file_prefix => nvl(wwv_flow_application_install.get_static_app_file_prefix,'')
,p_files_version=>19
,p_ui_type_name => null
,p_print_server_type=>'INSTANCE'
,p_is_pwa=>'N'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_tab_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(5297709875)
,p_name=>'shared.components.tab.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(450480819599472048)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Tabs'
,p_list_item_link_target=>'f?p=&APP_ID.:643:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'643'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(46189308080649570)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Manage Tabs'
,p_list_item_link_target=>'f?p=&APP_ID.:9000:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9000:9005'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(155545004712893410)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'TabSet View'
,p_list_item_link_target=>'f?p=&APP_ID.:77:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'77'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'77'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(155551816129903365)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Edit Standard Tabs'
,p_list_item_link_target=>'f?p=&APP_ID.:123:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'123'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(36310824965543438)
,p_list_item_display_sequence=>55
,p_list_item_link_text=>'Edit Parent Tabs'
,p_list_item_link_target=>'f?p=&APP_ID.:331:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'331'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(188150925414136195)
,p_list_item_display_sequence=>56
,p_list_item_link_text=>'Conditional Display'
,p_list_item_link_target=>'f?p=&APP_ID.:562:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'562'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4187304378934429)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&FLOW_ID.:200:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'200'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(31647421041127463)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Parent Tab Management'
,p_list_item_link_target=>'f?p=&APP_ID.:398:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'398'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'398'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11162415001016997)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=4000:58:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'58'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_template_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(12437772301)
,p_name=>'shared.components.template.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(12439783039)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Templates'
,p_list_item_link_target=>'f?p=&FLOW_ID.:4003:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4003'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(181570910687524006)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Subscription'
,p_list_item_link_target=>'f?p=&APP_ID.:124:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'124'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(103318918740149314)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Publish'
,p_list_item_link_target=>'f?p=&APP_ID.:727:&SESSION.::&DEBUG.:727:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'727:651'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(12441785324)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:4656:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4656,707'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(7436519543386292)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=4000:368:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'368'
);
end;
/
prompt --application/shared_components/navigation/lists/export_options
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(12802829107)
,p_name=>'Export_options'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(486267822373422835)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Export'
,p_list_item_link_target=>'f?p=&APP_ID.:523:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'523'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(79096314289012168)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Workspace'
,p_list_item_link_target=>'f?p=&APP_ID.:76:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'76'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(45716606101005971)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Applications'
,p_list_item_link_target=>'f?p=&APP_ID.:4900:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flows where security_group_id = :flow_security_group_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4900'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(189447213907433212)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'XML Export and Reporting'
,p_list_item_link_target=>'f?p=4850:1:&SESSION.'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(60513615035446206)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Themes'
,p_list_item_link_target=>'f?p=&FLOW_ID.:224:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'224'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(30477123909319995)
,p_list_item_display_sequence=>85
,p_list_item_link_text=>'Plug-ins'
,p_list_item_link_target=>'f?p=&APP_ID.:4460:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4460'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(145288215599412878)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'User Interface Defaults'
,p_list_item_link_target=>'f?p=&APP_ID.:479:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'479,541'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(472191226795751981)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Feedback'
,p_list_item_link_target=>'f?p=&APP_ID.:689:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'689'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3743275033992392)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Catalog'
,p_list_item_link_target=>'f?p=&APP_ID.:1965:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/pull_templates
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(320074633987)
,p_name=>'pull_templates'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(320076637876)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Creation Method'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(320078641296)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Copy From'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'26:4320:4069:86:4321:241:219:655:468:177'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(150871808522531061)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Identify Theme'
,p_list_item_link_target=>'f?p=&FLOW_ID.:498:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'498:225:343:353:412:413:415:418:423'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(177583606462600141)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'New Templates'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'144:158:159:167:168:242:223:657:469'
);
end;
/
prompt --application/shared_components/navigation/lists/p4500_create_menu
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(3734458575652)
,p_name=>'P4500 Create Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3734460575652)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Page'
,p_list_item_link_target=>'f?p=&APP_ID.:2500:&SESSION.::&DEBUG.:2500,2501,2502,2503,2504,2505,2506,2507,2508,2509,2510,2511,2512,2513,2514,2515,2516,2517,2518,2519,2520:FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_text_01=>'pd-create-page'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3734467605558)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Page as Copy'
,p_list_item_link_target=>'f?p=&APP_ID.:618:&SESSION.::&DEBUG.:618,301,302,305,308,309:::'
,p_list_text_01=>'pd-create-copy-page'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1478127242456137222)
,p_list_item_display_sequence=>17
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1477161567189313896)
,p_list_item_display_sequence=>19
,p_list_item_link_text=>'Page Component'
,p_list_item_link_target=>'f?p=&APP_ID.:97:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(337326867726113326)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Breadcrumb Region'
,p_list_item_link_target=>'f?p=&APP_ID.:263:&SESSION.:PD:&DEBUG.:259,181,380:::'
,p_list_text_01=>'pd-create-breadcrumb-region'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3734469612579)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Shared Component'
,p_list_item_link_target=>'f?p=&APP_ID.:364:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'pd-create-shared-component'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1557581895922320741)
,p_list_item_display_sequence=>52
,p_list_item_link_text=>'Page Group'
,p_list_item_link_target=>'f?p=&APP_ID.:521:&SESSION.::&DEBUG.:521:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1478127597899141859)
,p_list_item_display_sequence=>55
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3734471629609)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Developer Comment'
,p_list_item_link_target=>'f?p=&APP_ID.:1234:&SESSION.::&DEBUG.:1234:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(45451535915378438)
,p_list_item_display_sequence=>65
,p_list_item_link_text=>'Issue'
,p_list_item_link_target=>'f?p=4600:110:&SESSION.::&DEBUG.::P110_ASSOCIATED_APP,P110_ASSOCIATED_PAGE:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/p4500_utilities_menu
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(3741507057557)
,p_name=>'P4500 Utilities Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3759689081747)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Delete Page'
,p_list_item_link_target=>'f?p=&APP_ID.:21:&SESSION.::&DEBUG.:21:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1557582117917328385)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3741509057557)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Advisor'
,p_list_item_link_target=>'javascript:apex.navigation.popup({ url: ''f?p=&APP_ID.:8101:&SESSION.::&DEBUG.:8101:P8101_PAGE_ID:'' + pe.getCurrentPageId(), width: 1000, height: 800 }); void(0);'
,p_list_text_01=>'pd-advisor'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1557573865167095591)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Caching'
,p_list_item_link_target=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.:RP,14:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3759733090282)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:201:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(591681741179830880)
,p_list_item_display_sequence=>65
,p_list_item_link_text=>'Checksum'
,p_list_item_link_target=>'f?p=&APP_ID.:109:&SESSION.::&DEBUG.:109:P109_COMPONENT:PAGE:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3759730086463)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Export'
,p_list_item_link_target=>'f?p=&APP_ID.:164:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1564223914175232731)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(168415028897876470)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Show'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(84646475110887465)
,p_list_item_display_sequence=>170
,p_list_item_link_text=>'Tooltips'
,p_parent_list_item_id=>wwv_flow_imp.id(168415028897876470)
,p_list_text_01=>'pd-enable-tooltips'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(168639226669446654)
,p_list_item_display_sequence=>175
,p_list_item_link_text=>'----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(168415028897876470)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(168416197532917059)
,p_list_item_display_sequence=>190
,p_list_item_link_text=>'Layout View'
,p_parent_list_item_id=>wwv_flow_imp.id(168415028897876470)
,p_list_text_01=>'pd-show-layout-view'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(715120241154282785)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>'Layout'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(715121304457300310)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'Two Pane Mode'
,p_parent_list_item_id=>wwv_flow_imp.id(715120241154282785)
,p_list_text_01=>'pd-two-column'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(715121981042303143)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Three Pane Mode'
,p_parent_list_item_id=>wwv_flow_imp.id(715120241154282785)
,p_list_text_01=>'pd-three-column'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(715122647048306435)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(715120241154282785)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(715123600559310924)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'Reset Layout'
,p_parent_list_item_id=>wwv_flow_imp.id(715120241154282785)
,p_list_text_01=>'pd-reset-tab-layout'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/application_script_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(940230882533174)
,p_name=>'Application Script Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(940613006537413)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'View Install Summary'
,p_list_item_link_target=>'f?p=&APP_ID.:2106:&SESSION.::&DEBUG.:RP:P2106_DEPLOYMENT_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10221704948316206)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Export Application'
,p_list_item_link_target=>'f?p=&APP_ID.:4900:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23417101078571978)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Install Supporting Objects'
,p_list_item_link_target=>'f?p=4000:2100:&SESSION.::NO:RP,2100,2101,2102,2103,2104,2105:P2100_CANCEL_PAGE:2'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(57806406935019088)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>'Upgrade Supporting Objects'
,p_list_item_link_target=>'f?p=&APP_ID.:2150:&SESSION.::&DEBUG.:2150:P2150_CANCEL_PAGE:2:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23486008772829647)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Deinstall Supporting Objects'
,p_list_item_link_target=>'f?p=&APP_ID.:155:&SESSION.::&DEBUG.:155:FB_FLOW_ID,P2110_CANCEL_PAGE:&FB_FLOW_ID.,2:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from WWV_FLOW_INSTALL where FLOW_ID = :fb_flow_id and sys.dbms_lob.getlength(DEINSTALL_SCRIPT) > 2'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10173510414062342)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Remove All Supporting Objects'
,p_list_item_link_target=>'f?p=&APP_ID.:632:&SESSION.::&DEBUG.:632:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4800287802045379)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Create Data Package'
,p_list_item_link_target=>'f?p=&APP_ID.:6000:&SESSION.::&DEBUG.:6000:P850_SCRIPT_SOURCE:DATA:'
,p_security_scheme=>wwv_flow_imp.id(3200591188196688)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_taskdefs_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(1507124731460473)
,p_name=>'shared.components.taskdefs.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1507349964460476)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Task Definitions'
,p_list_item_link_target=>'f?p=&APP_ID.:9500:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2800349004582069)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:9508:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1508196532460478)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:9507:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_workflows
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(1601510944576262)
,p_name=>'shared.components.workflows'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1601767746576283)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Task Definitions'
,p_list_item_link_target=>'f?p=&APP_ID.:9500:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_TASK_DEFINITIONS.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(231803343077607847)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Automations'
,p_list_item_link_target=>'f?p=&APP_ID.:7020:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_AUTOMATIONS.'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/rest_source_catalog_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(2036513182725270)
,p_name=>'REST Source Catalog Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2038981474767972)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Import Catalog'
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.::&DEBUG.:RP,460:P460_FILE_TYPE:CATALOG:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2039418623771813)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Export Catalog'
,p_list_item_link_target=>'f?p=&APP_ID.:1965:&SESSION.::&DEBUG.:RP,1965:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2036724084725272)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Manage Catalog Groups'
,p_list_item_link_target=>'f?p=&APP_ID.:1968:&SESSION.::&DEBUG.:RP,1968:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_email_templates_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(2306436841283369)
,p_name=>'shared.components.email_templates.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2306693158283381)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Email Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:4860:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2307095200283385)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:4862:&APP_SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3100533916025399)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:4863:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_automations_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(2700189206621868)
,p_name=>'shared.components.automations.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2700397035621879)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Automations'
,p_list_item_link_target=>'f?p=&APP_ID.:7020:&APP_SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2700767814621880)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Execution Log'
,p_list_item_link_target=>'f?p=&APP_ID.:7025:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'7025,7026'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2701101624621880)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:7027:&APP_SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/workspace_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(2778715503937249)
,p_name=>'Workspace Utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(699057997282634091)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'All Workspace Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:182:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1500'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2779125546940169)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'App Builder Defaults'
,p_list_item_link_target=>'f?p=&APP_ID.:800:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-ui-defaults'
,p_list_text_01=>'Define application settings, themes and globalization attributes.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'800'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(525225511743184058)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'REST Enabled SQL Services'
,p_list_item_link_target=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-ords-rest'
,p_list_text_01=>'Manage references to external REST Enabled SQL services.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(533164636995207229)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Remote Servers'
,p_list_item_link_target=>'f?p=&APP_ID.:1931:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-database-object'
,p_list_text_01=>'Manage Remote Server objects used for REST Data Sources and Authentications.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(91019908621880192)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Application Groups'
,p_list_item_link_target=>'f?p=&APP_ID.:722:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-app-groups'
,p_list_text_01=>'Organize applications into logical groups.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'722'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(522749587305194510)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Web Credentials'
,p_list_item_link_target=>'f?p=&APP_ID.:1620:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-security-profiles'
,p_list_text_01=>'Manage secure credentials to connect to REST Enabled SQL or other REST services.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(113574116563879249)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Workspace Themes'
,p_list_item_link_target=>'f?p=&APP_ID.:763:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-workspace-themes'
,p_list_text_01=>'Manage workspace themes that can be utilized by any application within the workspace.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'763'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(787290498859273399)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Export ...'
,p_list_item_link_target=>'f?p=&APP_ID.:523:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-export-repository'
,p_list_text_01=>'Export workspace components.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(201138622968628415)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'&PRODUCT_NAME. Views'
,p_list_item_link_target=>'f?p=&APP_ID.:714:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-apex-views'
,p_list_text_01=>'Query the various views against &PRODUCT_NAME. metadata.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'714,905'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47677831332249228)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Cross Application Reports'
,p_list_item_link_target=>'f?p=&APP_ID.:9009:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-cross-app-reports'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'182'
,p_list_text_01=>'Review various attribute, comparison, security and UI reports for the workspace..'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9009'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(70887011747382286)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Manage Backups'
,p_list_item_link_target=>'f?p=&APP_ID.:970:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-apex-backup'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_backup.backup_limit() > 0'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_text_01=>'View and manage backups across applications in this workspace'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2035130738670100)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'REST Source Catalogs'
,p_list_item_link_target=>'f?p=&APP_ID.:1960:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-sc-data-references'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_backup.backup_limit() > 0'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_text_01=>'Manage catalogs of REST Sources for integration into applications'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_data_load_method
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(3306223094711954)
,p_name=>'Wizard Create Data Load Method'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3306442061711970)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Method'
,p_list_item_link_target=>'f?p=&APP_ID.:1815:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3306814575711971)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Copy From'
,p_list_item_link_target=>'f?p=&APP_ID.:1816:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3307245062711971)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Copy'
,p_list_item_link_target=>'f?p=&APP_ID.:1817:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/rest_catalog_services_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(3816997850663267)
,p_name=>'REST Catalog Services Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3817572751663269)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Export Catalog'
,p_list_item_link_target=>'f?p=&APP_ID.:1965:&SESSION.::&DEBUG.:RP,1965:P1965_CATALOG_ID:&P1963_CATALOG_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3817166638663268)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Refresh Catalog'
,p_list_item_link_target=>'f?p=&APP_ID.:1967:&SESSION.::&DEBUG.:RP,1967:P1967_ID:&P1963_CATALOG_ID.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null ',
'from wwv_web_src_catalogs ',
'where security_group_id = :WORKSPACE_ID ',
'and id = :P1963_CATALOG_ID ',
'and endpoint_url is not null'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_application_process_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(4020210037479119)
,p_name=>'shared.components.application_process.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4030001947619598)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Application Processes'
,p_list_item_link_target=>'f?p=&APP_ID.:4207:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4207'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11000225909481279)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:42:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'42'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_data_load_definitions
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(4115808439009126)
,p_name=>'Wizard Create Data Load Definitions'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4116092287009128)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Target'
,p_list_item_link_target=>'f?p=&APP_ID.:1811:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1810,1811,1812'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4201581850045538)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Sample Data'
,p_list_item_link_target=>'f?p=&APP_ID.:1810:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1810,1811,1812'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4201904650049010)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Map Columns'
,p_list_item_link_target=>'f?p=&APP_ID.:1812:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1810,1811,1812'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4202527391061819)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Navigation Menu'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                   p_application_id     => :FB_FLOW_ID, ',
'                   p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4202874397063680)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Tabs'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
end;
/
prompt --application/shared_components/navigation/lists/create_installation_script
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(4589709522084091)
,p_name=>'Create Installation Script'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4590429608089842)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Method'
,p_list_item_link_target=>'f?p=&APP_ID.:850:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'850'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4611332135223026)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Script Attributes'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'nvl(:P850_MODE,''INSTALL'') in (''INSTALL'',''UPGRADE'')'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'855,6000'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4591211039093928)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Define Script'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'856:857:858:578:669:6001'
);
end;
/
prompt --application/shared_components/navigation/lists/run_page
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(4717527352803690)
,p_name=>'run.page'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4717913977809214)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Run Page &FB_FLOW_PAGE_ID.'
,p_list_item_link_target=>'f?p=&APP_ID.:RUN_PAGE:&SESSION.:BRANCH_TO_PAGE_ACCEPT:&DEBUG.::FB_FLOW_ID,FB_FLOW_PAGE_ID,F4000_P1_FLOW:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.,&FB_FLOW_ID.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_steps p,',
'       wwv_flow_user_interfaces ui',
' where p.flow_id = :FB_FLOW_ID',
'   and p.id      = :FB_FLOW_PAGE_ID',
'   and ui.id     = p.user_interface_id',
'   and ( ui.global_page_id  <> :FB_FLOW_PAGE_ID',
'       or ui.global_page_id is null',
'       )'))
,p_list_text_01=>'runPage'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5741512908621046)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Edit Page &FB_FLOW_PAGE_ID.'
,p_list_item_link_target=>'f?p=&APP_ID.:4500:&SESSION.::&DEBUG.::FB_FLOW_ID,FB_FLOW_PAGE_ID:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.:'
,p_list_text_01=>'editPage'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1521230401042075)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Shared Components'
,p_list_item_link_target=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'9'
,p_list_text_01=>'sharedComponents'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(445219706544405464)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Application Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:674:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'utilities'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(123487516760321097)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Export Page &FB_FLOW_PAGE_ID.'
,p_list_item_link_target=>'f?p=&APP_ID.:164:&SESSION.::&DEBUG.::FB_FLOW_PAGE_ID,FB_FLOW_ID:&FB_FLOW_PAGE_ID.,&FB_FLOW_ID.:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'23,268,201,523,8'
,p_list_text_01=>'export'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4844126798254470)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Find'
,p_list_item_link_target=>'javascript:popUpNamed(''f?p=4000:273:&SESSION.:::RP:F4000_P273_PAGE:&FB_FLOW_PAGE_ID.'',''Finder'');'
,p_list_text_01=>'findItem'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/script_tabs
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(4852514958421306)
,p_name=>'Script Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(24081006745684565)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Script Properties'
,p_list_item_link_target=>'javascript:pageSubmit(''APPLY_CHANGES_328'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'328'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4853228464425278)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Script Editor'
,p_list_item_link_target=>'javascript:pageSubmit(''APPLY_CHANGES_865'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'865'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_tree_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(4884503079390537)
,p_name=>'shared.components.tree.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4888317947398805)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Trees'
,p_list_item_link_target=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'28'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4889111693401694)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:202:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from WWV_FLOW_TREES where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'202'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11042723644717174)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:45:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'45'
);
end;
/
prompt --application/shared_components/navigation/lists/websrcmodule_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(4900739432788654)
,p_name=>'websrcmodule.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4901345879788687)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Manage Synchronization'
,p_list_item_link_target=>'f?p=&APP_ID.:1951:&SESSION.::&DEBUG.:1951:P1951_WEB_SRC_MODULE_ID:&P1921_WEB_SRC_MODULE_ID.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2700581299603832)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'REST Source Catalogs'
,p_list_item_link_target=>'f?p=&APP_ID.:1960:&SESSION.::&DEBUG.:1960:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/page_tasks_4301
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(5093603989423342)
,p_name=>'Page Tasks 4301'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5093917495427251)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Delete Multiple Pages'
,p_list_item_link_target=>'f?p=&APP_ID.:339:&SESSION.::&DEBUG.::FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5094530439440376)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Manage Page Groups'
,p_list_item_link_target=>'f?p=&APP_ID.:520:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(5094707714443306)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Manage Page Locks'
,p_list_item_link_target=>'f?p=&APP_ID.:291:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/finder_tabs
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(6207014968942318)
,p_name=>'Finder Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(12888222063068359)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Items'
,p_list_item_link_target=>'f?p=&APP_ID.:273:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'273'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6208031937947265)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Pages'
,p_list_item_link_target=>'f?p=&APP_ID.:516:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'516'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6284502070657757)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Queries'
,p_list_item_link_target=>'f?p=&APP_ID.:527:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'527'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6207727781946089)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Tables'
,p_list_item_link_target=>'f?p=&APP_ID.:514:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'514'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(60548519958087566)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'PL/SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:431:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'431'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(451355613725606074)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Debug'
,p_list_item_link_target=>'f?p=&APP_ID.:19:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'939,19'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(451401219021090108)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Session'
,p_list_item_link_target=>'f?p=&APP_ID.:34:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'34'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(483658821697886476)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Errors'
,p_list_item_link_target=>'f?p=&APP_ID.:959:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'959'
);
end;
/
prompt --application/shared_components/navigation/lists/list_item_edit_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(6276618987043262)
,p_name=>'list item edit tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6277013577051156)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Change Parent List'
,p_list_item_link_target=>'f?p=&APP_ID.:4053:&SESSION.::&DEBUG.:4053:P4053_ID:&F4000_P4052_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_security
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(6730409642972302)
,p_name=>'shared.components.security'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(131581022927862632)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Security Attributes'
,p_list_item_link_target=>'f?p=&APP_ID.:509:&SESSION.::&DEBUG.:509:FB_FLOW_ID,509_FB_UPD_ID:&FB_FLOW_ID.,&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6731321416975780)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Authentication Schemes'
,p_list_item_link_target=>'f?p=&APP_ID.:801:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_AUTHN_SCHEMES.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6731930074978251)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Authorization Schemes'
,p_list_item_link_target=>'f?p=&APP_ID.:4070:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_AUTHZ_SCHEMES.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(715703720905977567)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Application Access Control'
,p_list_item_link_target=>'f?p=&APP_ID.:2300:&SESSION.::&DEBUG.:RP,2300:::'
,p_list_text_01=>'&P9_APP_ACCESS_ROLES.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(107341512439481992)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Session State Protection'
,p_list_item_link_target=>'f?p=&APP_ID.:510:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(154637234323820007)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Web Credentials'
,p_list_item_link_target=>'f?p=&APP_ID.:1620:&SESSION.::&DEBUG.:1620:::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_text_03=>'has-arrow'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_user_interface
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(6736213021992272)
,p_name=>'shared.components.user.interface'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(355051223966396435)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'User Interface Attributes'
,p_list_item_link_target=>'f?p=&APP_ID.:197:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106530626957945061)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Progressive Web App'
,p_list_item_link_target=>'f?p=&APP_ID.:507:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(716516312898369111)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Themes'
,p_list_item_link_target=>'f?p=&APP_ID.:260:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_THEMES.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(136592605767706703)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:4003:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_TEMPLATES.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6742208088009777)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Lists of Values'
,p_list_item_link_target=>'f?p=&APP_ID.:4110:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6744131637016530)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Shortcuts'
,p_list_item_link_target=>'f?p=&APP_ID.:4047:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(27476131766793984)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Plug-ins'
,p_list_item_link_target=>'f?p=&APP_ID.:4400:&SESSION.::&DEBUG.:RP:::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(14966220663089761)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Component Settings'
,p_list_item_link_target=>'f?p=&APP_ID.:4445:&SESSION.::&DEBUG.:RP:::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(231777605877531934)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Email Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:4860:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_EMAIL_TEMPLATES.'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(6746028090034478)
,p_name=>'shared.components.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6747207789038012)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Lists'
,p_list_item_link_target=>'f?p=&APP_ID.:405:&SESSION.::&DEBUG.:RIR:::'
,p_list_text_01=>'&P9_LISTS.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1404393804983091259)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Navigation Menu'
,p_list_item_link_target=>'f?p=&APP_ID.:405:&SESSION.::&DEBUG.:RIR:IR_IS_NAVMENU:1:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_themes',
'  where flow_id = :fb_flow_id ',
'     and security_group_id = :flow_security_group_id ',
'     and navigation_type = ''L'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6748930298044550)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Tabs (Legacy)'
,p_list_item_link_target=>'f?p=&APP_ID.:643:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_themes',
'  where flow_id = :fb_flow_id ',
'     and security_group_id = :flow_security_group_id ',
'     and navigation_type <> ''L'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6748216793040621)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Breadcrumbs'
,p_list_item_link_target=>'f?p=&APP_ID.:546:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_BREADCRUMBS.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6748621987042177)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Classic Navigation Bar Entries'
,p_list_item_link_target=>'f?p=&APP_ID.:4005:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_user_interfaces',
'where nav_bar_type = ''NAVBAR''',
'   and flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1418265896610430063)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Navigation Bar List'
,p_list_item_link_target=>'f?p=&APP_ID.:405:&SESSION.::&DEBUG.:RIR:IR_IS_NAVBAR:1:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_user_interfaces',
'where nav_bar_type = ''LIST''',
'   and flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_component_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(6753822621133458)
,p_name=>'shared component tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(204067027873902941)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Export Application Components'
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23409530421523625)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Manage Supporting Objects'
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(694983664029694709)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Edit Application Comment'
,p_list_item_link_target=>'f?p=&APP_ID.:4310:&SESSION.::&DEBUG.::F4000_P4310_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(185215606520315768)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Developer Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:606:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(185215915524318393)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Developer Comments Calendar'
,p_list_item_link_target=>'f?p=&APP_ID.:594:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_translations
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(6868813338465446)
,p_name=>'shared.components.translations'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(131583418902870966)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Globalization Attributes'
,p_list_item_link_target=>'f?p=&APP_ID.:506:&SESSION.::&DEBUG.:506:FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6873620180486312)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Text Messages'
,p_list_item_link_target=>'f?p=&APP_ID.:4006:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_TEXT_MESSAGES.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6870414162475145)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Application Translations'
,p_list_item_link_target=>'f?p=&APP_ID.:4761:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_APP_TRANSLATIONS.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_files
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(6874810268492937)
,p_name=>'shared.components.files'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(9999913109548888)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Static Application Files'
,p_list_item_link_target=>'f?p=&APP_ID.:40:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_APP_FILES.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6777811617190566)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Static Workspace Files'
,p_list_item_link_target=>'f?p=&APP_ID.:312:&SESSION.::&DEBUG.:RP:::'
,p_list_text_01=>'&P9_WORKSPACE_FILES.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(231782518871563201)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Report Queries'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_REPORT_QUERIES.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(231782854585563204)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Report Layouts'
,p_list_item_link_target=>'f?p=&APP_ID.:1400:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_REPORT_LAYOUTS.'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/application_monitor_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(7285601119000778)
,p_name=>'Application Monitor Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(7286509084003017)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Monitor Workspace Activity'
,p_list_item_link_target=>'f?p=4350:22:&SESSION.::NO:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(35256609257872204)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'View Developer Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:606:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_process2
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(8047824983989923)
,p_name=>'Wizard Create Process2'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_summarypage
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(8771208191950732)
,p_name=>'wizard_SummaryPage'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8776908610965769)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Page Attributes'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'5100'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(12306121730146667)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Navigation Menu'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                     p_application_id     => :FB_FLOW_ID, ',
'                     p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1523948471338130108)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Tabs'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(8878700445197468)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Item Attributes'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'5105'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(9251713948619425)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Summary Items'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'5110'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(7559603306884347)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Confirm'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'303'
);
end;
/
prompt --application/shared_components/navigation/lists/supporting_objects_installation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(10025113710400997)
,p_name=>'Supporting Objects Installation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10025907954408780)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Prerequisites'
,p_list_item_link_target=>'f?p=&APP_ID.:631:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10026522499412995)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Application Substitution Strings '
,p_list_item_link_target=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P2_SUBSTR_CNT.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(19115930214978417)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>'Build Options'
,p_list_item_link_target=>'f?p=&APP_ID.:511:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P2_BUILD_OPT_CNT.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10026826654414177)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Pre-installation Validations'
,p_list_item_link_target=>'f?p=&APP_ID.:445:&SESSION.::&DEBUG.:RP:::'
,p_list_text_01=>'&P2_PRE_INS_VAL_CNT.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10117115357770425)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Installation Scripts'
,p_list_item_link_target=>'f?p=&APP_ID.:473:&SESSION.::&DEBUG.:RP:::'
,p_list_text_01=>'&P2_INST_SCRIPT_CNT.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47099730350498293)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Messages'
,p_list_item_link_target=>'f?p=&APP_ID.:567:&SESSION.::&DEBUG.::FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/supporting_objects_deinstallation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(10121209647806692)
,p_name=>'Supporting Objects Deinstallation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10122025231811196)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Deinstallation Script'
,p_list_item_link_target=>'f?p=&APP_ID.:576:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P2_DE_INS_SCRIPT_CNT.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47101131567536488)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Deinstallation Message'
,p_list_item_link_target=>'f?p=&APP_ID.:567:&SESSION.::&DEBUG.::FB_FLOW_ID:&FB_FLOW_ID.#DEINSTALL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/workspace_static_files_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(10900130470111258)
,p_name=>'Workspace Static Files Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10900385148111269)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Export Workspace Static Files'
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.::&DEBUG.:688,MULTI_COMPONENT_EXPORT:P688_COMPONENT:WS_STATIC_FILE:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_web_service_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(11271810048283515)
,p_name=>'shared.components.web_service.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11272321130286719)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Web Service References'
,p_list_item_link_target=>'f?p=&APP_ID.:170:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'170'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11279906285310777)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:63:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'63'
);
end;
/
prompt --application/shared_components/navigation/lists/page_branch_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(11286824340344465)
,p_name=>'page.branch.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11288626203354383)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Branches'
,p_list_item_link_target=>'f?p=&APP_ID.:4202:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4202'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(58002325682402982)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Delete Multiple Branches'
,p_list_item_link_target=>'f?p=&APP_ID.:746:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'746'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194567927186940748)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:881:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'881:563:885'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11287304385348126)
,p_list_item_display_sequence=>64
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:64:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'64'
);
end;
/
prompt --application/shared_components/navigation/lists/page_process_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(11322022496485821)
,p_name=>'page.process.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11322821242494955)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Processes'
,p_list_item_link_target=>'f?p=&APP_ID.:4201:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4201'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(57980905334378187)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Delete Multiple Processes'
,p_list_item_link_target=>'f?p=&APP_ID.:745:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'745'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193857202841290851)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:482:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'482:213:552:866'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11323227822496829)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:65:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'65'
);
end;
/
prompt --application/shared_components/navigation/lists/create_breadcrumb
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(11694125812505020)
,p_name=>'create breadcrumb'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11694630293505024)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Breadcrumb'
,p_list_item_link_target=>'f?p=&APP_ID.:288:&SESSION.:'
,p_list_item_current_for_pages=>'288'
);
end;
/
prompt --application/shared_components/navigation/lists/page_region_view_mode
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(12991522578387911)
,p_name=>'page.region.view.mode'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(17995509153269699)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Calendar Attributes'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_CALENDAR'');'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from  wwv_flow_page_plugs ',
'where PLUG_SOURCE_TYPE = ''NATIVE_CALENDAR''',
'and   id = :F4000_P4651_ID and :APP_PAGE_ID NOT IN (122,697,670,661,836)'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2000'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(85461617780828062)
,p_list_item_display_sequence=>95
,p_list_item_link_text=>'Report Attributes'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_NATIVE_IR''); '
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_page_plugs ',
'where page_id = :fb_flow_page_id and',
'      flow_id = :fb_flow_id and',
'      :flow_page_id not in (754,370) and',
'      ((PLUG_SOURCE_TYPE = ''NATIVE_IR'' ',
'       and',
'      id = :F4000_P4651_ID ) or :flow_page_id in (601,687,694,742))'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'601:687:694'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11159118868729265)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Print Attributes'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_PRINT_ATTR'');'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_page_plugs ',
' where page_id = :fb_flow_page_id',
'   and flow_id = :fb_flow_id',
'   and :flow_page_id not in (754,370)',
'   and (  (PLUG_SOURCE_TYPE in ( ''NATIVE_SQL_REPORT'',',
'                                 ''NATIVE_TABFORM'',',
'                                 ''NATIVE_IR'' )',
'          and id = :F4000_P4651_ID)',
'       or :flow_page_id in (960,774))'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'960,774'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22186214630159256)
,p_list_item_display_sequence=>115
,p_list_item_link_text=>'Definition'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_CALENDAR_DEFINITION'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'122,697,670,661,836,80'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'697'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22153400161060412)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Monthly Calendar'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_MONTHLY_CALENDAR'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'122,697,670,661,836,80'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'122'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16872109954486071)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Weekly Calendar'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_WEEKLY_CALENDAR'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'122,697,670,661,836,80'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'670'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16872929001491541)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Daily Calendar'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_DAILY_CALENDAR'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'122,697,670,661,836,80'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'661'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(30766002077732772)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Custom Calendar'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_CUSTOM_CALENDAR'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'122,697,670,661,836,80'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'836'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3696311919048128)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'List Calendar'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_AGENDA_CALENDAR'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'122,697,670,661,836,80'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'80'
);
end;
/
prompt --application/shared_components/navigation/lists/page_region_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(13987931263515071)
,p_name=>'page.region.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(13996410232565779)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Regions'
,p_list_item_link_target=>'f?p=&APP_ID.:4650:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4650'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(58023120665439320)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Delete Multiple Regions'
,p_list_item_link_target=>'f?p=&APP_ID.:747:&SESSION.::&DEBUG.:RP,747:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'747'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(189958910147635012)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:853:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'853:249:480:70:157:438:459:128:247:217:212:864:136:690'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11228932521987173)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:60:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'60'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_component_settings_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(14972101971160040)
,p_name=>'shared.components.component_settings.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(14972319391160042)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Component Settings'
,p_list_item_link_target=>'f?p=&APP_ID.:4445:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(14972912989160044)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:4447:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/cross_application_reports_comparison
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(15030113309394959)
,p_name=>'Cross Application Reports / Comparison'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(15030613786404487)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Application Comparison'
,p_list_item_link_target=>'f?p=&APP_ID.:1300:&SESSION.:NORUN:&DEBUG.::::'
,p_list_item_icon=>'icon-util-app-compare'
,p_list_text_01=>'Query differences in component names.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(17208701402593062)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Component Summary Counts'
,p_list_item_link_target=>'f?p=&APP_ID.:1301:&SESSION.:NORUN:&DEBUG.::::'
,p_list_item_icon=>'icon-util-component-counts'
,p_list_text_01=>'Query differences in component counts.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_component_load_tables
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(15132926917246073)
,p_name=>'shared.component.load.tables'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(15133112993246073)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Data Load Definitions'
,p_list_item_link_target=>'f?p=&APP_ID.:1800:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2902795457911853)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:1821:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(15134306858246075)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:1808:&SESSION.:'
,p_list_item_current_for_pages=>'1808'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_form_on_ws
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(15577802944637145)
,p_name=>'wizard_form_on_ws'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(15578929956644992)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Page Attributes'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'605'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(15579201690646275)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Navigation Menu'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                     p_application_id     => :FB_FLOW_ID, ',
'                     p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1523950262441140962)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Tabs'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(15578618528641637)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Choose Service'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'600'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(15579621083651886)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Form Items'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'620:884'
);
end;
/
prompt --application/shared_components/navigation/lists/create_page_introduction
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(15960618523591402)
,p_name=>'create.page.introduction'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(15961725795593556)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Page'
,p_list_item_link_target=>'f?p=&APP_ID.:2500:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2500,752'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(15962230990595065)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Define'
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'500,849'
);
end;
/
prompt --application/shared_components/navigation/lists/create_component_introduction
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(16004105550701290)
,p_name=>'create.component.introduction'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16006006374710902)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Identify Control'
,p_list_item_link_target=>'f?p=&APP_ID.:0:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'323,364,336'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'323,364'
);
end;
/
prompt --application/shared_components/navigation/lists/create_menu_with_menu_option
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(16141621180084222)
,p_name=>'create.menu.with.menu.option'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16142629838086700)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Region Attributes'
,p_list_item_link_target=>'f?p=&APP_ID.:263:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'263'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16143922350093999)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Breadcrumb Entry'
,p_list_item_link_target=>'f?p=&APP_ID.:264:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'264'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16144801703097508)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Confirm'
,p_list_item_link_target=>'f?p=&APP_ID.:286:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'286'
);
end;
/
prompt --application/shared_components/navigation/lists/page_button_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(16353308133052510)
,p_name=>'page.button.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16359625373152129)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Buttons'
,p_list_item_link_target=>'f?p=&APP_ID.:4203:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4203'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(51143127397134983)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Delete Multiple Buttons'
,p_list_item_link_target=>'f?p=&APP_ID.:724:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'724'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(189959220536638052)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:852:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'852:250:446:548:878'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11249424312117274)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:61:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'61,'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_legacy_data_load_wizard
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(16993520375207189)
,p_name=>'Wizard Create Legacy Data Load Wizard'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(585808545428825920)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Data Load Table'
,p_list_item_link_target=>'f?p=&APP_ID.:1700:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(585808884340828845)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Transformation Rules'
,p_list_item_link_target=>'f?p=&APP_ID.:1702:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(585809128851831410)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Table Lookups'
,p_list_item_link_target=>'f?p=&APP_ID.:1701:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(20142616358500970)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Pages Attributes'
,p_list_item_link_target=>'f?p=&APP_ID.:1704:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1523936815498664127)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Navigation Menu'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                   p_application_id     => :FB_FLOW_ID, ',
'                   p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16994623223207192)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Tabs'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(307986230539557923)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Buttons and Branching'
,p_list_item_link_target=>'f?p=&APP_ID.:1706:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1706'
);
end;
/
prompt --application/shared_components/navigation/lists/home_page_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(17113830931867323)
,p_name=>'home.page.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(53347908603459381)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Delete this Application'
,p_list_item_link_target=>'f?p=&APP_ID.:2110:&SESSION.::&DEBUG.:RP,2110:FB_FLOW_ID,FB_FLOW_PAGE_ID,P2110_CANCEL_PAGE:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.,1:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flows ',
'where security_group_id = :flow_security_group_id and ',
':app_page_id = ''1'''))
,p_security_scheme=>wwv_flow_imp.id(12472323342703137)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(115201606939032288)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Copy this Application'
,p_list_item_link_target=>'f?p=&APP_ID.:499:&SESSION.::&DEBUG.:499,611:FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(212830002493156758)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Page Groups'
,p_list_item_link_target=>'f?p=&APP_ID.:520:&SESSION.::&DEBUG.:RP:FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(34528309073406519)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Page Locks'
,p_list_item_link_target=>'f?p=&APP_ID.:291:&SESSION.::&DEBUG.:RP:::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47796518629853915)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Dependencies'
,p_list_item_link_target=>'f?p=&APP_ID.:425:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(198461526128088208)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Export Repository'
,p_list_item_link_target=>'f?p=&APP_ID.:73:&SESSION.::&DEBUG.:RP:::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6831812856407773)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Add Feature Page'
,p_list_item_link_target=>'f?p=&APP_ID.:2500:&SESSION.::&DEBUG.:2500,500,572,575,849,1310,1311,1312,1313,1314,1315,1316,1317:FB_FLOW_ID,P2500_CATEGORY,P2500_PAGE_TYPE:&FB_FLOW_ID.,FEATURE,ABOUTAPP:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(210726611906133664)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Monitor Workspace Activity'
,p_list_item_link_target=>'f?p=4350:22:&SESSION.'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'71'
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6996930509253802)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Application Dashboard'
,p_list_item_link_target=>'f?p=&APP_ID.:71:&SESSION.::&DEBUG.::FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'71,300,70'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4065812606027121)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Activity Dashboard'
,p_list_item_link_target=>'f?p=&APP_ID.:14:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(70886790977359157)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Manage Backups'
,p_list_item_link_target=>'f?p=&APP_ID.:971:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>':APP_PAGE_ID in (1) and wwv_flow_backup.backup_limit() > 0'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(500599555964351445)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Browse by Facets'
,p_list_item_link_target=>'f?p=&APP_ID.:33:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/page_computation_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(17446232715505772)
,p_name=>'page.computation.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(17447319340511375)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Computations'
,p_list_item_link_target=>'f?p=&APP_ID.:4204:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4204'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(57947507450331474)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Delete Multiple Computations'
,p_list_item_link_target=>'f?p=&APP_ID.:744:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'744'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193688712738615625)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:847:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'847:215:549:877'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(17448822934521895)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:152:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'152'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_page
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(18564606387816293)
,p_name=>'wizard Copy Page'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(203365725936637465)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Copy Page Option'
,p_list_item_link_target=>'f?p=&APP_ID.:618:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'618'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(18565123356821261)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Page to Copy'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'301'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(18565729375832463)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Navigation Menu'
,p_list_item_link_target=>'f?p=&APP_ID.:305:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                     p_application_id     => :FB_FLOW_ID, ',
'                     p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'305:316'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1523947008998118995)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Tabs'
,p_list_item_link_target=>'f?p=&APP_ID.:305:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'305:316'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(20734321130916756)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'New Names'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'302'
);
end;
/
prompt --application/shared_components/navigation/lists/create_calendar_template
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(19035021988626357)
,p_name=>'create calendar template'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(19036431470638590)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Create Method'
,p_list_item_link_target=>'f?p=&FLOW_ID.:161:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'161'
);
end;
/
prompt --application/shared_components/navigation/lists/report_layout_creation_steps
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(19263904166280419)
,p_name=>'Report Layout Creation Steps'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(19265711569292026)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Layout Type'
,p_list_item_link_target=>'f?p=&APP_ID.:1401:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1401'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(19266719244398256)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Layout Source'
,p_list_item_link_target=>'f?p=&APP_ID.:1402:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1402,1406'
);
end;
/
prompt --application/shared_components/navigation/lists/switch_theme
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(20663215911569971)
,p_name=>'switch.theme'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(20663630109574042)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Identify Theme'
,p_list_item_link_target=>'f?p=&APP_ID.:179:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'179'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(20664529201583245)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Verify Compatibility'
,p_list_item_link_target=>'f?p=&APP_ID.:386:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'386'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(20670121761618936)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Confirm Switch'
,p_list_item_link_target=>'f?p=&APP_ID.:180:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'180'
);
end;
/
prompt --application/shared_components/navigation/lists/web_service_reference_wizard
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(22410710903630445)
,p_name=>'web service reference wizard'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(33465030663752652)
,p_list_item_display_sequence=>11
,p_list_item_link_text=>'REST Details'
,p_list_item_link_target=>'f?p=&APP_ID.:871:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P870_WEB_REFERENCE_TYPE'
,p_list_item_disp_condition2=>'REST'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'871'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(33473413946041089)
,p_list_item_display_sequence=>12
,p_list_item_link_text=>'REST Inputs'
,p_list_item_link_target=>'f?p=&APP_ID.:872:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P870_WEB_REFERENCE_TYPE'
,p_list_item_disp_condition2=>'REST'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'872'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(33478806692190351)
,p_list_item_display_sequence=>13
,p_list_item_link_text=>'REST Outputs'
,p_list_item_link_target=>'f?p=&APP_ID.:873:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P870_WEB_REFERENCE_TYPE'
,p_list_item_disp_condition2=>'REST'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'873'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22495103330356887)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'WSDL Location'
,p_list_item_link_target=>'f?p=&APP_ID.:580:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P870_WEB_REFERENCE_TYPE'
,p_list_item_disp_condition2=>'WSDL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'580'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22505817687597564)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Web Service Details'
,p_list_item_link_target=>'f?p=&APP_ID.:585:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P870_WEB_REFERENCE_TYPE'
,p_list_item_disp_condition2=>'WSDL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'585'
);
end;
/
prompt --application/shared_components/navigation/lists/deployment_tabs
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(22452018965176093)
,p_name=>'deployment tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22452810092182983)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Messages'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_567'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'567'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22521803109426954)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'Prerequisites'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_631'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'631'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22503614097373329)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>'Substitutions'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_17'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'17'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22516317738412258)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>'Build Options'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_511'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'511'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22484008809315095)
,p_list_item_display_sequence=>7
,p_list_item_link_text=>'Validations'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_445'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'445'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22468026031263279)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Install'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_473'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'473'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23543014930276179)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Upgrade'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_667'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'667'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22498325263357607)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Deinstall'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_576'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'576,579'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22452401088180364)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Export'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_633'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'633'
);
end;
/
prompt --application/shared_components/navigation/lists/create_shared_query_train
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(22638505565903517)
,p_name=>'create shared query train'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22639713530905876)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Report Query Definition'
,p_list_item_link_target=>'f?p=&APP_ID.:1110:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1110'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22640625305909268)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Source Queries'
,p_list_item_link_target=>'f?p=&APP_ID.:1113:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1113, 1119'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22641406735913386)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Download Definition'
,p_list_item_link_target=>'f?p=&APP_ID.:1115:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1115'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(112560706550636283)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Upload Report Layout'
,p_list_item_link_target=>'f?p=&APP_ID.:1118:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1118'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22641712623915044)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Confirm'
,p_list_item_link_target=>'f?p=&APP_ID.:1114:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1114'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_reports
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(22726621018248639)
,p_name=>'shared.components.reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11534830686211676)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Report Queries'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(18838121614544449)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Report Layouts'
,p_list_item_link_target=>'f?p=&APP_ID.:1400:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_component_application_attributes
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(23333311543130294)
,p_name=>'shared component application attributes'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23334104055137553)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Edit Definition'
,p_list_item_link_target=>'f?p=&APP_ID.:4001:&SESSION.::&DEBUG.::FB_FLOW_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23346722503199625)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Edit Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:4310:&SESSION.::&DEBUG.::F4000_P4310_ID:&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/supporting_object_upgrade
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(23445516456661592)
,p_name=>'Supporting Object Upgrade'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23447506544668156)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Upgrade Scripts'
,p_list_item_link_target=>'f?p=&APP_ID.:667:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P2_UPG_CNT.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47100700053527309)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Upgrade Message'
,p_list_item_link_target=>'f?p=&APP_ID.:567:&SESSION.::&DEBUG.::FB_FLOW_ID:&FB_FLOW_ID.#UPGRADE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_application
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(23817524863605164)
,p_name=>'Copy Application'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23817717317605164)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Identify Copy Target'
,p_list_item_link_target=>'f?p=&APP_ID.:499:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23818031260605166)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Confirm'
,p_list_item_link_target=>'f?p=&APP_ID.:611:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'611'
);
end;
/
prompt --application/shared_components/navigation/lists/script_results_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(24172418538839346)
,p_name=>'script results tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(24173525249850711)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Install Supporting Objects'
,p_list_item_link_target=>'f?p=&APP_ID.:2100:&SESSION.::&DEBUG.::P2100_CANCEL_PAGE:2:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(80633901866542564)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'Upgrade Supporting Objects'
,p_list_item_link_target=>'f?p=&APP_ID.:2150:&SESSION.::&DEBUG.:2150,2151,2152,2153,2154:P2150_CANCEL_PAGE:2:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(24173116592848238)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>'Deinstall Application'
,p_list_item_link_target=>'f?p=&APP_ID.:2110:&SESSION.::&DEBUG.:2110:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(24257620317868232)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>'Edit Installation Scripts'
,p_list_item_link_target=>'f?p=&APP_ID.:473:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'2106'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(24256800577862502)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Manage Supporting Objects'
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'2106'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(37122929947493126)
,p_list_item_display_sequence=>6
,p_list_item_link_text=>'Edit Application'
,p_list_item_link_target=>'f?p=&APP_ID.:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(96986426278147432)
,p_list_item_display_sequence=>7
,p_list_item_link_text=>'Run Application'
,p_list_item_link_target=>'&P2106_HOME_LINK.'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'2106'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(98381926501308170)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'View and Download Single Script'
,p_list_item_link_target=>'f?p=&APP_ID.:432:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :FLOW_PAGE_ID = 473 then',
'  for c1 in (select null',
'             from #OWNER#.wwv_flow_install_scripts',
'             where flow_id = :fb_flow_id ',
'             and security_group_id = :flow_security_group_id',
'             and nvl(script_type,''INSTALL'') = ''INSTALL'')',
'  loop',
'      return true;',
'  end loop;',
'end if;',
'return false;'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(403371215736939990)
,p_list_item_display_sequence=>12
,p_list_item_link_text=>'View and Download Single Script'
,p_list_item_link_target=>'f?p=&APP_ID.:457:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :FLOW_PAGE_ID = 667 then',
'  for c1 in (select 1',
'             from #OWNER#.wwv_flow_install_scripts',
'             where flow_id = :fb_flow_id ',
'             and security_group_id = :flow_security_group_id',
'             and nvl(script_type,''INSTALL'') = ''UPGRADE'')',
'  loop',
'      return true;',
'  end loop;',
'end if;',
'return false;'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(403375103864031484)
,p_list_item_display_sequence=>13
,p_list_item_link_text=>'View and Download Single Script'
,p_list_item_link_target=>'f?p=&APP_ID.:462:&SESSION.::&DEBUG.:462:::'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if :flow_page_id = 576 then',
'  for c1 in (select null',
'             from wwv_flow_install',
'             where flow_id = :fb_flow_id',
'             and security_group_id = :flow_security_group_id',
'             and nvl(sys.dbms_lob.getlength(deinstall_script),0) > 0)',
'  loop',
'      return true;',
'  end loop;',
'end if;',
'return false;',
''))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(118217100108549882)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Create Application DDL Script'
,p_list_item_link_target=>'javascript:doSubmit(''DDL_SCRIPT'')'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'1=2'
,p_list_item_disp_condition2=>'SQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(236577109798623828)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Resequence Scripts'
,p_list_item_link_target=>'f?p=&APP_ID.:802:&SESSION.::&DEBUG.:802:::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_install_scripts',
'where flow_id = :fb_flow_id ',
'and security_group_id = :flow_security_group_id',
'and nvl(script_type,''INSTALL'') = ''INSTALL''',
'and :APP_PAGE_ID = 473'))
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(380042987976769926)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Resequence Scripts'
,p_list_item_link_target=>'f?p=&APP_ID.:38:&SESSION.::&DEBUG.:38:::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'from wwv_flow_install_scripts',
'where flow_id = :fb_flow_id ',
'and security_group_id = :flow_security_group_id',
'and nvl(script_type,''INSTALL'') = ''UPGRADE''',
'and :APP_PAGE_ID = 667'))
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4700464872031326)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>'Create Data Package'
,p_list_item_link_target=>'f?p=&APP_ID.:6000:&SESSION.::&DEBUG.:6000:P850_SCRIPT_SOURCE:DATA:'
,p_security_scheme=>wwv_flow_imp.id(3200591188196688)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/create_dynamic_action
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(25338502483800688)
,p_name=>'create.dynamic_action'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/mb_context_menu
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(25800649414501670)
,p_name=>'MB Context Menu'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(25800842464501683)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Restore'
,p_list_item_link_target=>'f?p=&APP_ID.:974:&SESSION.::&DEBUG.:974:P974_ID,P974_FLOW_ID:$backupid$,$flowid$:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(25801216993501684)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Download'
,p_list_item_link_target=>'p?n=$objectid$'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(25801607394501685)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'View Details'
,p_list_item_link_target=>'f?p=&APP_ID.:973:&SESSION.::&DEBUG.:973:P973_ID:$backupid$:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(25802068672501685)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Manage Lock'
,p_list_item_link_target=>'f?p=&APP_ID.:976:&SESSION.::&DEBUG.:976:P976_ID:$backupid$:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(25803493813511373)
,p_list_item_display_sequence=>55
,p_list_item_link_text=>'-'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(25803138133508799)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Delete'
,p_list_item_link_target=>'f?p=&APP_ID.:977:&SESSION.::&DEBUG.:977:P977_FLOW_ID,P977_ID:$flowid$,$backupid$:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/create_application_process
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(25941806450198106)
,p_name=>'create.application.process'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(25942514415200446)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Identification'
,p_list_item_link_target=>'f?p=&APP_ID.:147:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'147'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(25943018571201605)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Source'
,p_list_item_link_target=>'f?p=&APP_ID.:148:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'148'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(25955304550235459)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Conditionality'
,p_list_item_link_target=>'f?p=&APP_ID.:150:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'150'
);
end;
/
prompt --application/shared_components/navigation/lists/multi_table_create_application
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(26219416632336505)
,p_name=>'multi-table create application'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(170634803652169586)
,p_list_item_display_sequence=>55
,p_list_item_link_text=>'Shared Components'
,p_list_item_link_target=>'f?p=&APP_ID.:17:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'17:476:433'
);
end;
/
prompt --application/shared_components/navigation/lists/developer_resources
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(26512283167477231)
,p_name=>'developer.resources'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(26512415103477231)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Font APEX Icons'
,p_list_item_link_target=>'https://apex.oracle.com/fontapex'
,p_list_text_02=>'target="_blank"'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_plugins_edit_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(27884204995681439)
,p_name=>'shared.components.plugins.edit.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(15025526109384601)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Component Settings'
,p_list_item_link_target=>'f?p=&APP_ID.:4445:&SESSION.::&DEBUG.:4445,CIR:::'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_plugin_dev.has_application_attributes (',
'    p_application_id => :P4410_FLOW_ID,',
'    p_plugin_type    => :P4410_PLUGIN_TYPE,',
'    p_plugin_name    => :P4410_NAME )'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(28084903887018683)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Export Plug-in'
,p_list_item_link_target=>'f?p=&APP_ID.:4460:&SESSION.::&DEBUG.:RP,4460:P4460_PLUGIN_ID:&P4410_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(27884715851681468)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:4420:&SESSION.::&DEBUG.:RP,CIR:IR_DISPLAY_NAME:&P4410_DISPLAY_NAME.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_plugins_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(27943608569240649)
,p_name=>'shared.components.plugins.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(28086530815045307)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Export Plug-in'
,p_list_item_link_target=>'f?p=&APP_ID.:4460:&SESSION.::&DEBUG.:RP,4460:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_dynamic_action_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(28119925264668131)
,p_name=>'page.dynamic_action.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(28120209465673032)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Dynamic Actions'
,p_list_item_link_target=>'f?p=&APP_ID.:773:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'773'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(28120415005674680)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Delete Multiple Dynamic Actions'
,p_list_item_link_target=>'f?p=&APP_ID.:794:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'794'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194156219281175220)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:699:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'863:699'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(28120618815675737)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:795:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'795'
);
end;
/
prompt --application/shared_components/navigation/lists/web_service_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(28359907580129646)
,p_name=>'web service tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(28360319831142579)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Create Web Service Reference Manually'
,p_list_item_link_target=>'f?p=&APP_ID.:199:&SESSION.::&DEBUG.:196:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/synchronize_defaults
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(28511519360309024)
,p_name=>'Synchronize Defaults'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/form_on_ws_with_rpt
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(30094110886480012)
,p_name=>'form_on_ws_with_rpt'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(30094627509484763)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Choose Service and Operation'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'700'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(30094903052487151)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Page and Region Attributes'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'705'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(30095522099492672)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Input Items'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'720:880'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22663523536956076)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>'Authentication'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flow_collections',
' where collection_name = ''WS_AUTH_ITEMS'''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(30095815304500150)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Web Service Results'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'725:842'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(30096124308502737)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Report Parameters'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'730:882:848'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(30095212402489886)
,p_list_item_display_sequence=>65
,p_list_item_link_text=>'Navigation Menu'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                   p_application_id     => :FB_FLOW_ID, ',
'                   p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1556523170111727633)
,p_list_item_display_sequence=>65
,p_list_item_link_text=>'Tabs'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(30096432619505205)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Confirm'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'735'
);
end;
/
prompt --application/shared_components/navigation/lists/application_utilities_line3
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(30782715391876326)
,p_name=>'application.utilities.line3'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(30782921600876331)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Saved Reports'
,p_list_item_link_target=>'f?p=&APP_ID.:37:&SESSION.::&DEBUG.:RP,RIR:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(30783226672876332)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Subscriptions'
,p_list_item_link_target=>'f?p=&APP_ID.:39:&SESSION.::&DEBUG.:RP,RIR:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/caching
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(31086920674251816)
,p_name=>'Caching'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(31098728732310986)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'All Cached Pages'
,p_list_item_link_target=>'f?p=&APP_ID.:638:&SESSION.::&DEBUG.:RIR:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(31087325522253253)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'All Cached Regions'
,p_list_item_link_target=>'f?p=&APP_ID.:656:&SESSION.::&DEBUG.:RIR:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/sqlquery_on_ws_result
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(31960916110521509)
,p_name=>'sqlquery_on_ws_result'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(31962812085529789)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Web Reference Information'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'760,775,784'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(31963927323534138)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Report Parameters and Options'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'765,780,790'
);
end;
/
prompt --application/shared_components/navigation/lists/list_utility_options
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(33430506092105266)
,p_name=>'list utility options'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(33455121161147439)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Copy List'
,p_list_item_link_target=>'f?p=&APP_ID.:663:&SESSION.::&DEBUG.:663:P663_ID:&F4000_P4050_LIST_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(33431712672107181)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Copy List Entries from one List to Another'
,p_list_item_link_target=>'f?p=&APP_ID.:477:&SESSION.::&DEBUG.:477:P477_COPY_LIST_FROM:&F4000_P4050_LIST_ID.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_lists',
' where id = :F4000_P4050_LIST_ID ',
'   and list_type = ''STATIC''',
'   and security_group_id = :WORKSPACE_ID'))
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(33434024793110611)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Reparent List Entries within this List'
,p_list_item_link_target=>'f?p=&APP_ID.:2222:&SESSION.::&DEBUG.::P2222_LIST_ID:&F4000_P4050_LIST_ID.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_lists',
' where id           = :F4000_P4050_LIST_ID',
'   and list_type    = ''STATIC''',
'   and reference_id is null',
'   and security_group_id = :WORKSPACE_ID'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(40745428326672193)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Manage Orphaned List Entries'
,p_list_item_link_target=>'f?p=&APP_ID.:712:&SESSION.::&DEBUG.:RP:P712_LIST_ID:&F4000_P4050_LIST_ID.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_lists',
' where id           = :F4000_P4050_LIST_ID',
'   and list_type    = ''STATIC''',
'   and reference_id is null',
'   and security_group_id = :WORKSPACE_ID'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(170300712666400884)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Resequence List Entries'
,p_list_item_link_target=>'f?p=&APP_ID.:536:&SESSION.::&DEBUG.::P536_LIST_ID:&F4000_P4050_LIST_ID.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_lists',
' where id           = :F4000_P4050_LIST_ID',
'   and list_type    = ''STATIC''',
'   and reference_id is null',
'   and security_group_id = :WORKSPACE_ID'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_list_entries
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(33731702665524035)
,p_name=>'Copy List Entries'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(33733202927543059)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Identify Copy Target'
,p_list_item_link_target=>'f?p=&APP_ID.:477:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'477'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(33733511584545617)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Confirm List Entry Copy'
,p_list_item_link_target=>'f?p=&APP_ID.:478:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'478'
);
end;
/
prompt --application/shared_components/navigation/lists/lock_functions
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(34740016606195595)
,p_name=>'lock.functions'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(34740422493197305)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Page Locks'
,p_list_item_link_target=>'f?p=&APP_ID.:291:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'291'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(34740830804199645)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Lock Administration'
,p_list_item_link_target=>'f?p=&APP_ID.:299:&SESSION.::&DEBUG.::::'
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'299'
);
end;
/
prompt --application/shared_components/navigation/lists/standard_tab_management
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(35060712015585948)
,p_name=>'standard.tab.management'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(35061409029594543)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Move highlighted Standard Tab to a different Parent Tab'
,p_list_item_link_target=>'f?p=&FLOW_ID.:77:&SESSION.::&DEBUG.:::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'  from WWV_FLOW_TOPLEVEL_TABS',
' where flow_id = :fb_flow_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(35061718033597155)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Rename Standard Tab Set'
,p_list_item_link_target=>'f?p=&FLOW_ID.:345:&SESSION.::&DEBUG.:::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_tabs where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(35062024959599144)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Resequence display order'
,p_list_item_link_target=>'f?p=&FLOW_ID.:123:&SESSION.::&DEBUG.:::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_tabs where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(35062632017610572)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Associate Page(s) with selected Standard Tab'
,p_list_item_link_target=>'f?p=&APP_ID.:9005:&SESSION.::&DEBUG.:9005:F4000_P9005_TAB_ID:&F4000_CUR_STD_TAB.:'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_tabs where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(35097012080765730)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>'Create New Standard Tab'
,p_list_item_link_target=>'f?p=4000:90:&SESSION.::NO:92,94,95,96,4722,4723,4724'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(35063015871615372)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Create New Standard Tab Set'
,p_list_item_link_target=>'f?p=4000:9000:&SESSION.::::F4000_P9000_CUR_PTAB,F4000_CUR_STD_TAB:999999999999,'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/install_progress
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(37438506954816730)
,p_name=>'Install Progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(37439316651819553)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Supporting Objects'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2100:2115'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(37439619768820400)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'License'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_install',
' where license_message is not null',
'   and flow_id = :fb_flow_id',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2101'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(37440226347822326)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>'Application Substitutions'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_install',
' where replace(prompt_substitution_01_yn||',
'                 prompt_substitution_02_yn||',
'                 prompt_substitution_03_yn||',
'                 prompt_substitution_04_yn||',
'                 prompt_substitution_05_yn||',
'                 prompt_substitution_06_yn||',
'                 prompt_substitution_07_yn||',
'                 prompt_substitution_08_yn||',
'                 prompt_substitution_09_yn||',
'                 prompt_substitution_10_yn||',
'                 prompt_substitution_11_yn||',
'                 prompt_substitution_12_yn||',
'                 prompt_substitution_13_yn||',
'                 prompt_substitution_14_yn||',
'                 prompt_substitution_15_yn||',
'                 prompt_substitution_16_yn||',
'                 prompt_substitution_17_yn||',
'                 prompt_substitution_18_yn||',
'                 prompt_substitution_19_yn||',
'                 prompt_substitution_20_yn,''N'','''') is not null',
'   and flow_id = :fb_flow_id',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2103'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(13556731674021001)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>'Build Options'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_install_build_opt',
' where flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2107'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(37439922884821393)
,p_list_item_display_sequence=>6
,p_list_item_link_text=>'Validations'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select * from wwv_flow_install_checks',
' where flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2102:2108'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(37440529810823352)
,p_list_item_display_sequence=>7
,p_list_item_link_text=>'Confirmation'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2104'
);
end;
/
prompt --application/shared_components/navigation/lists/import_progress
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(37899301707472090)
,p_name=>'import progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(37899710018474406)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Specify File'
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'460'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(37900017290476513)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'File Import Confirmation'
,p_list_item_link_target=>'f?p=&APP_ID.:163:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'163'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(37910625087516631)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Install'
,p_list_item_link_target=>'f?p=&APP_ID.:49:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'49:67:166:409:253:321:598:4450:929:494:612:1966'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(272780339297125857)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Prompts'
,p_list_item_link_target=>'f?p=&APP_ID.:2160:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/repository
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(38836703962860678)
,p_name=>'repository'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(38837209849862399)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Manage Export Repository'
,p_list_item_link_target=>'f?p=&APP_ID.:73:&SESSION.::&DEBUG.:RP:::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'460,163,48,644'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(226337903706179254)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Preview File'
,p_list_item_link_target=>'javascript:popupURL(''f?p=&FLOW_ID.:2120:&SESSION.::&DEBUG.::P2120_FILE_ID:&P163_FILE_ID.'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'163,49,48,494,644'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_calendar
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(41547421928169148)
,p_name=>'Wizard Create Calendar'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/home_page_apex_4_0_list
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(46890703166185102)
,p_name=>'Home Page APEX 4.0 list'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(46891214941188463)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Run Application'
,p_list_item_link_target=>'&F4000_P1_RUN_LINK.'
,p_list_item_icon=>'app-builder-run-app'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(46891420828190182)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Supporting Objects'
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex-sql-script'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(46891900873193850)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Shared Components'
,p_list_item_link_target=>'f?p=&APP_ID.:9:&SESSION.::&DEBUG.::FB_FLOW_ID,FB_FLOW_PAGE_ID:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.:'
,p_list_item_icon=>'app-builder-shared-components'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(177830030226412242)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:674:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex-utilities'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(46892107107195637)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Export / Import'
,p_list_item_link_target=>'f?p=&APP_ID.:461:&SESSION.::&DEBUG.::FB_FLOW_ID,FB_FLOW_PAGE_ID:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.:'
,p_list_item_icon=>'app-builder-export-import'
,p_list_item_icon_attributes=>'width="128" height="128" alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_region_utilities_report_regions
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(47104812669691866)
,p_name=>'page.region.utilities.report.regions'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47106211554691868)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Grid Edit all Standard Report Column Headings'
,p_list_item_link_target=>'f?p=&APP_ID.:217:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(445540813206505532)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Grid Edit all Interactive Report Column Headings'
,p_list_item_link_target=>'f?p=&APP_ID.:690:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47106522548691869)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Grid Edit all No Data Found Messages'
,p_list_item_link_target=>'f?p=&APP_ID.:212:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492651908993878213)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Update Interactive Report Settings'
,p_list_item_link_target=>'f?p=&APP_ID.:940:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47105918660691868)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'SQL Query Region Source'
,p_list_item_link_target=>'f?p=&APP_ID.:247:&SESSION.::&DEBUG.:RIR:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492644402142781679)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Interactive Report Subscriptions'
,p_list_item_link_target=>'f?p=4350:92:&SESSION.::&DEBUG.:RIR:IR_NFLOW_ID:&FB_FLOW_ID.'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/cross_application_reports_security
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(47648606548052805)
,p_name=>'Cross Application Reports / Security'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47650319458052824)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Security Profiles'
,p_list_item_link_target=>'f?p=&APP_ID.:9014:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-security-profiles'
,p_list_text_01=>'View security details for each application.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47650917494052824)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Authentication Schemes'
,p_list_item_link_target=>'f?p=&APP_ID.:9015:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-auth-scheme'
,p_list_text_01=>'View all authentication schemes for each application.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47650613876052824)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Password Items'
,p_list_item_link_target=>'f?p=&APP_ID.:7777:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-password'
,p_list_text_01=>'Review individual password items and their settings.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/cross_application_reports_user_interface
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(47656832568088745)
,p_name=>'Cross Application Reports / User Interface'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47658830638088749)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Theme Summary'
,p_list_item_link_target=>'f?p=&APP_ID.:737:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-theme-summary'
,p_list_text_01=>'View the default theme and theme count.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_application_item_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(47807005066095922)
,p_name=>'shared.components.application_item.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47807417533099513)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Application Items'
,p_list_item_link_target=>'f?p=&APP_ID.:4100:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4100'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47808827230102390)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:130:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'130'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(192556407703412832)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:533:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'533'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_application_computation_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(47827519966525945)
,p_name=>'shared.components.application_computation.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47827910747532792)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Application Computations'
,p_list_item_link_target=>'f?p=&APP_ID.:4101:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4101'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47828120790535668)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:43:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'43'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_build_option_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(47909111131552473)
,p_name=>'shared.components.build_option.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47909728792557644)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Build Options'
,p_list_item_link_target=>'f?p=&APP_ID.:4910:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4910'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47909902258559446)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:203:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'203'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(192566112775480588)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:535:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'535'
);
end;
/
prompt --application/shared_components/navigation/lists/delete_multiple_pages
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(48377323742917579)
,p_name=>'delete Multiple Pages'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(48377606904922202)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Delete Checked Pages'
,p_list_item_link_target=>'f?p=&APP_ID.:339:&SESSION.::&DEBUG.:339:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'339'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(48377811406923459)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Delete Pages by Range'
,p_list_item_link_target=>'f?p=&APP_ID.:72:&SESSION.::&DEBUG.:72:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'72'
);
end;
/
prompt --application/shared_components/navigation/lists/install_progress_upgrade
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(48681713885605105)
,p_name=>'Install Progress (Upgrade)'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(48681921050605105)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Supporting Objects'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2150'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(48682216352605105)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'License'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_install',
' where license_message is not null',
'   and flow_id = :fb_flow_id',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2151'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(48682518004605105)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>'Application Substitutions'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_install',
' where replace(prompt_substitution_01_yn||',
'                 prompt_substitution_02_yn||',
'                 prompt_substitution_03_yn||',
'                 prompt_substitution_04_yn||',
'                 prompt_substitution_05_yn||',
'                 prompt_substitution_06_yn||',
'                 prompt_substitution_07_yn||',
'                 prompt_substitution_08_yn||',
'                 prompt_substitution_09_yn||',
'                 prompt_substitution_10_yn||',
'                 prompt_substitution_11_yn||',
'                 prompt_substitution_12_yn||',
'                 prompt_substitution_13_yn||',
'                 prompt_substitution_14_yn||',
'                 prompt_substitution_15_yn||',
'                 prompt_substitution_16_yn||',
'                 prompt_substitution_17_yn||',
'                 prompt_substitution_18_yn||',
'                 prompt_substitution_19_yn||',
'                 prompt_substitution_20_yn,''N'','''') is not null',
'   and flow_id = :fb_flow_id',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2153'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(48682805062605105)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>'Build Options'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_install_build_opt',
' where flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2157'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(48683114640605105)
,p_list_item_display_sequence=>6
,p_list_item_link_text=>'Validations'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select * from wwv_flow_install_checks',
' where flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2152,2158'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(48683423866605106)
,p_list_item_display_sequence=>7
,p_list_item_link_text=>'Confirmation'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'2154'
);
end;
/
prompt --application/shared_components/navigation/lists/structured_query
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(55535125515641311)
,p_name=>'Structured_Query'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/create_web_reference_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(57083604297327751)
,p_name=>'create_web_reference_tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1030018641100391162)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Create RESTFul Web Reference'
,p_list_item_link_target=>'f?p=&APP_ID.:871:&SESSION.::&DEBUG.:871:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(57084621958332785)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Create Web Reference Manually'
,p_list_item_link_target=>'f?p=&APP_ID.:199:&SESSION.::&DEBUG.:199:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/install_preview_upgrade
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(57809829707044603)
,p_name=>'Install Preview (Upgrade)'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(57810025849044605)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Preview Upgrade Scripts'
,p_list_item_link_target=>'javascript:popupURL(''f?p=&APP_ID.:2109:&SESSION.::&DEBUG.::P2109_MODE:UPGRADE'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/export_install_navigate
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(58916220936178306)
,p_name=>'export.install.navigate'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(58917130286181031)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Manage Export Repository'
,p_list_item_link_target=>'f?p=&APP_ID.:73:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(486309116766298442)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Export'
,p_list_item_link_target=>'f?p=&APP_ID.:523:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'461'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(445307613122457455)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Component Export'
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'680'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_theme_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(58949101764235429)
,p_name=>'shared.components.theme.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1030175014751098308)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Themes'
,p_list_item_link_target=>'f?p=&APP_ID.:260:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(44080124445670825)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Reports'
,p_list_item_link_target=>'f?p=&APP_ID.:173:&SESSION.::&DEBUG.:RP:P173_SHOW:1:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'173,435,491,492'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193120127053383246)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:681:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'681'
);
end;
/
prompt --application/shared_components/navigation/lists/view_ui_default
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(59836303269637894)
,p_name=>'view.ui.default'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(59850310111658783)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'View Table Defaults'
,p_list_item_link_target=>'javascript:popupURL(''f?p=4000:391:&SESSION.:::391,RP:P391_SCHEMA,P391_TABLE:&UI_SCHEMA.,&UI_TABLE.'');'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'769,4795,4811,4017'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(177740131510804118)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Edit Table Dictionary'
,p_list_item_link_target=>'f?p=4500:802:&SESSION.::NO:RP,802:P800_SCHEMA,P802_TABLE_ID:&UI_SCHEMA.,&UI_TABLE_ID.'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'769,4795,4811,4017'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(491980431480090226)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'View Attribute Dictionary'
,p_list_item_link_target=>'javascript:popupURL(''f?p=4000:579:&SESSION.:::RIR:P391_SCHEMA:&UI_SCHEMA.'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(491968306537007365)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Edit Attribute Dictionary'
,p_list_item_link_target=>'f?p=4500:6:&SESSION.::NO:RIR:P800_SCHEMA:&UI_SCHEMA.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/theme_home_page_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(60448901162323653)
,p_name=>'theme home page utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(60452220471348108)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Copy Theme'
,p_list_item_link_target=>'f?p=&FLOW_ID.:401:&SESSION.::&DEBUG.:401::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(60458828136378754)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'Delete Theme'
,p_list_item_link_target=>'f?p=&FLOW_ID.:221:&SESSION.::&DEBUG.:221::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(60449412936327043)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>'Export Theme'
,p_list_item_link_target=>'f?p=&FLOW_ID.:224:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(60449817785328400)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Import Theme'
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.::&DEBUG.::P460_FILE_TYPE:THEME:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(60460231384389174)
,p_list_item_display_sequence=>6
,p_list_item_link_text=>'Change Identification Number'
,p_list_item_link_target=>'f?p=&FLOW_ID.:397:&SESSION.::&DEBUG.:397::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1433728355595982335)
,p_list_item_display_sequence=>7
,p_list_item_link_text=>'Restore Theme Subscription'
,p_list_item_link_target=>'f?p=&APP_ID.:117:&SESSION.::&DEBUG.:117:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(112939916055325918)
,p_list_item_display_sequence=>8
,p_list_item_link_text=>'Manage Workspace Themes'
,p_list_item_link_target=>'f?p=&APP_ID.:763:&SESSION.::&DEBUG.:RP,764,789,762:P764_FLOW_ID:&FB_FLOW_ID.:'
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_auth_scheme
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(61117217587002695)
,p_name=>'Wizard Create Auth Scheme'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/authorization_reports
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(62154210909909582)
,p_name=>'authorization.reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(62154920044921741)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Report Pages With Authorization Schemes'
,p_list_item_link_target=>'javascript:popupURL(''f?p=4000:4046:&SESSION.::&DEBUG.::P4046_OPT:1'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(62154609655918761)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Report Pages Without Authorization Schemes'
,p_list_item_link_target=>'javascript:popupURL(''f?p=4000:4046:&SESSION.::&DEBUG.::P4046_OPT:2'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_list_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(62973516530710918)
,p_name=>'shared.components.list.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(16379422446669293)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Lists'
,p_list_item_link_target=>'f?p=&APP_ID.:405:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'405'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(152909708490771744)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Unused'
,p_list_item_link_target=>'f?p=&APP_ID.:10:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_lists',
' where flow_id = :fb_flow_id',
'   and security_group_id = :WORKSPACE_ID'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'10'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(188112617636897422)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Conditional Entries'
,p_list_item_link_target=>'f?p=&APP_ID.:557:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'557'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(19301917517602348)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Subscription'
,p_list_item_link_target=>'f?p=&APP_ID.:4:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(3698822128638837)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:156:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'  from wwv_flow_lists',
' where flow_id = :fb_flow_id',
'   and security_group_id = :WORKSPACE_ID',
''))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'156,417'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11021905065645615)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:44:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'44'
);
end;
/
prompt --application/shared_components/navigation/lists/p1500_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(63310734885303893)
,p_name=>'p1500 tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(183788272600635275)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Manage Backups'
,p_list_item_link_target=>'f?p=&APP_ID.:970:&SESSION.::&DEBUG.:970:::'
,p_list_item_icon=>'icon-apex-backup'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(500597206178327494)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Browse by Facets'
,p_list_item_link_target=>'f?p=&APP_ID.:69:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/breadcrumb_entry_views
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(65506221314219691)
,p_name=>'breadcrumb entry views'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_button_template
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(79547928409156701)
,p_name=>'Wizard Create Button Template'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(79552721077160159)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Creation Method'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(79555017842161642)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Details'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'218'
);
end;
/
prompt --application/shared_components/navigation/lists/application_group_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(91618427870317883)
,p_name=>'Application Group Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(92285408876511015)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'Manage Assignments'
,p_list_item_link_target=>'f?p=&APP_ID.:736:&SESSION.::&DEBUG.:RP,736:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(91618806877321244)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Manage Unassigned'
,p_list_item_link_target=>'f?p=&APP_ID.:736:&SESSION.::&DEBUG.:RP,736:P736_SHOW:UNASSIGNED:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/ir_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(91747231305508774)
,p_name=>'ir_tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(196353019228502005)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'View Saved Report Activity'
,p_list_item_link_target=>'f?p=4350:93:&SESSION.:::RIR,CIR:IR_APPLICATION_ID,IR_PAGE_ID:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(442777026341677254)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Manage Subscriptions'
,p_list_item_link_target=>'f?p=4350:92:&SESSION.:::RIR,CIR:IR_NFLOW_ID,IR_NPAGE_ID:&FB_FLOW_ID.,&FB_FLOW_PAGE_ID.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_interactive_report_page
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(92836304316872750)
,p_name=>'wizard_create_interactive_report_page'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(92837021977877846)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Page Attributes'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'326,759,98,961'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(92837632366880883)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Navigation Menu'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_wizard_api.page_exists (',
'  p_flow_id => :fb_flow_id, ',
'  p_page_id => :F4000_P4701_FLOW_STEP_ID',
') = false',
'and',
'not wwv_flow_user_interface_dev.supports_tabs (',
'          p_application_id     => :FB_FLOW_ID, ',
'          p_user_interface_id => :P2500_USER_INTERFACE_ID)'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1523948867681134525)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Tabs'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_wizard_api.page_exists (',
'  p_flow_id => :fb_flow_id, ',
'  p_page_id => :F4000_P4701_FLOW_STEP_ID',
') = false',
'and',
'wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P2500_USER_INTERFACE_ID)'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(235189540462900083)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Web Reference Type'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P2500_PAGE_TYPE'
,p_list_item_disp_condition2=>'WEBSERVICE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'778'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(235190199021968007)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Web Reference Information'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P2500_PAGE_TYPE'
,p_list_item_disp_condition2=>'WEBSERVICE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'779:781:859'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(235190496270971838)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Parameters and Options'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P2500_PAGE_TYPE'
,p_list_item_disp_condition2=>'WEBSERVICE'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'782:783:860'
);
end;
/
prompt --application/shared_components/navigation/lists/edit_page_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(92837202675352059)
,p_name=>'edit Page Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(200213907900661288)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Edit Application Comment'
,p_list_item_link_target=>'f?p=&APP_ID.:4310:&SESSION.::&DEBUG.::F4000_P4310_ID:&FB_FLOW_ID.:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4001'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'f?p=4000:4310:&SESSION.::::F4000_P4310_ID:&FB_FLOW_ID.'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(138317724706866221)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Edit Theme &P4003_THEME.'
,p_list_item_link_target=>'f?p=&APP_ID.:267:&SESSION.::&DEBUG.::P267_ID:&P4003_THEME_ID.:'
,p_list_item_disp_cond_type=>'ITEM_NOT_NULL_OR_ZERO'
,p_list_item_disp_condition=>'P4003_THEME'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(59111509360577354)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Replace templates in this application with templates from another application.'
,p_list_item_link_target=>'f?p=&APP_ID.:220:&SESSION.::&DEBUG.:220,222:::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4003'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(93046821589098546)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'View Named Lists of Value'
,p_list_item_link_target=>'f?p=&APP_ID.:4110:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':APP_PAGE_ID = 4311 and',
':P4311_NAMED_LOV is not null'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(31490816073500952)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Add Row Selector'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_ADD_CHECK'');'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'    has_row_selector boolean := false;',
'begin',
'    for c1 in (',
'        select 1 from ',
'    	wwv_flow_region_report_column',
'    	where region_id = :P420_REGION_ID',
'    	and column_alias like ''CHECK$%''',
'    ) loop',
'        has_row_selector := true;',
'    end loop;	',
'    return not has_row_selector',
'           and :FLOW_PAGE_ID     = 420',
'           and :P420_REGION_TYPE = wwv_flow_region_native.c_tabform;',
'end;'))
,p_list_item_disp_condition2=>'PLSQL'
,p_required_patch=>wwv_flow_imp.id(121426746309283317)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(36704211967171442)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Add Column Link'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_ADD_LINK'');'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>':FLOW_PAGE_ID=420'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(36802112434805591)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Add Derived Column'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_ADD_COLUMN'');'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>':FLOW_PAGE_ID=420'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(205489829874815043)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Theme Reports'
,p_list_item_link_target=>'f?p=&APP_ID.:173:&SESSION.::&DEBUG.::P173_SHOW:1:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4003'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(98663518101847762)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Report Column Headings'
,p_list_item_link_target=>'f?p=&APP_ID.:217:&SESSION.::&DEBUG.:RP,217:P217_PAGE:&FB_FLOW_PAGE_ID.:'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'422'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(90724807717089029)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Replace Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:708:&SESSION.::&DEBUG.:708,711,713:::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4003'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(95667030632845330)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Unsubscribe Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:540:&SESSION.::&DEBUG.:540:::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'4311'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/button_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(97266605334780088)
,p_name=>'Button.Tasks'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_region
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(99487325551482211)
,p_name=>'Wizard Create Region'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(99491916062486630)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Display Attributes'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'474'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4016,91,2002,2003,799,313'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(99492810454489250)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Source'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_plugins',
' where flow_id = case',
'                   when :F4000_P4016_SOURCE_TYPE like ''NATIVE_%'' then 4411',
'                   else to_number(:FB_FLOW_ID)',
'                 end',
'   and plugin_type = ''REGION TYPE''',
'   and name        = substr(:F4000_P4016_SOURCE_TYPE, 8)',
'   and instr('':''||standard_attributes||'':'', '':SOURCE'') > 0',
'union all',
'select 1',
'  from dual',
' where substr(:F4000_P4016_SOURCE_TYPE, 1, 7) not in (''NATIVE_'', ''PLUGIN_'',''JSTREE'')',
'   and substr(:P4016_SOURCE_TYPE,1,7) not in (''JSTREE'')',
'   and :APP_PAGE_ID <> 7000'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4017,407,683'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(99494305710491468)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Conditional Display'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'474'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4018:692'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_button
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(99644130313723164)
,p_name=>'Wizard Create Button'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_item
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(99795626246952886)
,p_name=>'Wizard Create Item'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(99797121286955232)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Display Position and Name'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4717,690'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(99797817188957126)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Item Attributes'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_plugins',
' where flow_id = case',
'                   when :F4000_P4717_DISPLAY_AS like ''NATIVE_%'' then 4411',
'                   else to_number(:FB_FLOW_ID)',
'                 end',
'   and plugin_type = ''ITEM TYPE''',
'   and name        = substr(:F4000_P4717_DISPLAY_AS, 8)',
'   and instr('':''||standard_attributes||'':'', '':VISIBLE:'') > 0'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4721'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(99798513522958795)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Source'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'690'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4718,691'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_computation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(100146402180654207)
,p_name=>'Wizard Create Computation'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_validation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(100288425710144762)
,p_name=>'Wizard Create Validation'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_branches
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(100367812684257161)
,p_name=>'Wizard Create Branches'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_process
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(100583211191032690)
,p_name=>'Wizard Create Process'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_parent_tab
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(100804924518345585)
,p_name=>'Wizard Create Parent Tab'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(100806819126348134)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Parent Tab'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4725'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(100810614813350139)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Target'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4726'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(100812510716351983)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Sequence and Display'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4727'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_standard_tab
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(100922117111440207)
,p_name=>'Wizard Create Standard Tab'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(101132401201918650)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'New or Existing Tab Set'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'90'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(101135523617923462)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Tab Set'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'93:94'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(101900810245789723)
,p_list_item_display_sequence=>16
,p_list_item_link_text=>'Tab Parent'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'95'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(101901507441790975)
,p_list_item_display_sequence=>17
,p_list_item_link_text=>'Tab Name'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'96'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(100923610426443280)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Current Page'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4722'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(100924705466445586)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Sequence and Images'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4723'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(100925402231447156)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Display Conditions'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4724'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(101374521774334568)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Confirm'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'92'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_asynchronous_actions_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(103622378763412957)
,p_name=>'shared.components.asynchronous_actions.navigation'
,p_list_status=>'PUBLIC'
,p_required_patch=>wwv_flow_imp.id(103621306777465158)
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(103622584173412956)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Asynchronous Actions'
,p_list_item_link_target=>'f?p=&APP_ID.:7000:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(103622949684412955)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Asynchronous Action Details'
,p_list_item_link_target=>'f?p=&APP_ID.:7005:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(103623310655412955)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Execution Log'
,p_list_item_link_target=>'f?p=&APP_ID.:7009:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(103623751064412955)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:7010:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(103870209211856610)
,p_name=>'Wizard Create Navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(196983008322003866)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Method'
,p_list_item_link_target=>'f?p=&APP_ID.:22:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4023,4024,4025,392,497,392,22'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'22'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(103874127098863515)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Attributes'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4023,4024,4025,392,22'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4023'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(103875221491866142)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Target'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4023,4024,4025,392,22'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4024'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(103876314806869217)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Display Condition'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'4023,4024,4025,392,22'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4025'
);
end;
/
prompt --application/shared_components/navigation/lists/create_theme_progress
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(106473613360356705)
,p_name=>'create.theme.progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106476128944361283)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Method'
,p_list_item_link_target=>'f?p=&APP_ID.:207:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'207'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(274111320953713585)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'User Interface'
,p_list_item_link_target=>'f?p=&APP_ID.:1207:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106477412106365802)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Identify Theme'
,p_list_item_link_target=>'f?p=&APP_ID.:208:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'208,267'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106508026960460990)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Confirm'
,p_list_item_link_target=>'f?p=&APP_ID.:210:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1207,207,208,210'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'210'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_theme
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(106491204103410821)
,p_name=>'copy.theme'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106491709991412525)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Copy Theme'
,p_list_item_link_target=>'f?p=&APP_ID.:401:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'401'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106495009083421774)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Confirm'
,p_list_item_link_target=>'f?p=&APP_ID.:410:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'410'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_region_template
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(106501409747300331)
,p_name=>'Wizard - Create Region Template'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(17580228667075703)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Template Type'
,p_list_item_link_target=>'f?p=&APP_ID.:162:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'162'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106505327419307356)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Creation Method'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'901:920:931:941:951:238:211:348'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106947820318367086)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Name'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'902:924:935:945:955:240:225:652:349:350'
);
end;
/
prompt --application/shared_components/navigation/lists/theme_change_identification_number
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(106512001249472508)
,p_name=>'theme.change.identification.number'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106514712808485302)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Theme Number'
,p_list_item_link_target=>'f?p=&APP_ID.:397:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'397'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106515019042487151)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Confirm'
,p_list_item_link_target=>'f?p=&APP_ID.:400:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'400'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_asynchronous_action_train
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(106873536031910266)
,p_name=>'copy asynchronous action train'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106873705662910265)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Application'
,p_list_item_link_target=>'f?p=&APP_ID.:7002:&SESSION.::&DEBUG.::::'
,p_required_patch=>wwv_flow_imp.id(103621306777465158)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'7002'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106874144154910264)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Identify Asynchronous Action'
,p_list_item_link_target=>'f?p=&APP_ID.:7003:&SESSION.::&DEBUG.::::'
,p_required_patch=>wwv_flow_imp.id(103621306777465158)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'7003,7004'
);
end;
/
prompt --application/shared_components/navigation/lists/p7005_asynchronous_action_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(106944141274550933)
,p_name=>'P7005 asynchronous action utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106944732788550932)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Copy Asynchronous Action'
,p_list_item_link_target=>'f?p=&APP_ID.:7002:&SESSION.::&DEBUG.:7002,7003,7004:P7003_ID:&P7005_ACTION_TRIGGER_ID.:'
,p_required_patch=>wwv_flow_imp.id(103621306777465158)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106946388576550930)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Resequence Actions'
,p_list_item_link_target=>'f?p=&APP_ID.:7008:&SESSION.::&DEBUG.::P7008_ACTION_TRIGGER_ID:&P7005_ACTION_TRIGGER_ID.:'
,p_required_patch=>wwv_flow_imp.id(103621306777465158)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'7008'
);
end;
/
prompt --application/shared_components/navigation/lists/sssc
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(107370720292626153)
,p_name=>'sssc'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(107372308995632305)
,p_list_item_display_sequence=>2
,p_list_item_link_text=>'Page'
,p_list_item_link_target=>'f?p=&APP_ID.:512:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'menu/page_64.gif'
,p_list_item_icon_attributes=>'height="64" width="64" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(107373730120638467)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Page Item'
,p_list_item_link_target=>'f?p=&APP_ID.:513:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'menu/edit_64.gif'
,p_list_item_icon_attributes=>'height="64" width="64" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(107789910275250763)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Application Item'
,p_list_item_link_target=>'f?p=&APP_ID.:518:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'menu/prod_apex_64.gif'
,p_list_item_icon_attributes=>'height="64" width="64" title="#LIST_LABEL#" alt="#LIST_LABEL#"'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/sss_standard
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(109521305294221172)
,p_name=>'sss.standard'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(109521827242236960)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Session State Protection is disabled.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(110690209142337959)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Pages in your application will not require checksums.'
,p_list_item_link_target=>'f?p=&APP_ID.:9008:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(109522205902240205)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Application items can be set using arguments passed in a URL (except Restricted items).'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(110689114205329908)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Page items can be set using arguments set in a URL (except Restricted items).'
,p_list_item_link_target=>'f?p=&APP_ID.:9008:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(110694132391373080)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Page items'' <i>Escape on HTTP Input</i> attribute will continue to be observed.'
,p_list_item_link_target=>'f?p=&APP_ID.:9008:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/sss_progress
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(109642120442735590)
,p_name=>'sss.progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(109642530139738374)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Select Action'
,p_list_item_link_target=>'f?p=&APP_ID.:525:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'525'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(114177918693680391)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Page and Item Attributes'
,p_list_item_link_target=>'f?p=&APP_ID.:9006:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9006'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(109642810530742159)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Confirm'
,p_list_item_link_target=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9007,9008'
);
end;
/
prompt --application/shared_components/navigation/lists/authenitcation_create
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(109993128340686080)
,p_name=>'authenitcation.create'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(109993532150687193)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Method'
,p_list_item_link_target=>'f?p=&APP_ID.:815:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'815'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(109993802845688109)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Scheme'
,p_list_item_link_target=>'f?p=&APP_ID.:816:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'816,818'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_template
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(110615031296644849)
,p_name=>'Copy Template'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(110663804762646615)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Copy a template from another application'
,p_list_item_link_target=>'f?p=&APP_ID.:162:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/view_templates_task
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(111435127334933550)
,p_name=>'View Templates Task'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(111437316383939828)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'View Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:4003:&SESSION.::&DEBUG.:4003,RIR:IR_THEME,P4003_THEME:&FB_THEME_ID.,&FB_THEME_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1218253654992416500)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Delete Theme'
,p_list_item_link_target=>'f?p=&FLOW_ID.:221:&SESSION.::&DEBUG.:221::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_breadcrumb_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(111619820846587947)
,p_name=>'shared.components.breadcrumb.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(111620411281594656)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Breadcrumbs'
,p_list_item_link_target=>'f?p=&APP_ID.:546:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'546'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(183475506631296658)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Grid Edit'
,p_list_item_link_target=>'f?p=&APP_ID.:3:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'3'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(14900821723122972)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Reparent Entries'
,p_list_item_link_target=>'f?p=&APP_ID.:106:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(111620004355592595)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:365:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'365'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(111620206086593181)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:369:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'369'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_sqlquery_on_ws_page
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(114018423833281484)
,p_name=>'wizard_sqlquery_on_ws_page'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(206858322178171502)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Page and Region Attributes'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'776'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(206858932567174539)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Navigation Menu'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return not wwv_flow_user_interface_dev.supports_tabs (',
'                     p_application_id     => :FB_FLOW_ID, ',
'                     p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1523950895298145683)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Tabs'
,p_list_item_disp_cond_type=>'FUNCTION_BODY'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_user_interface_dev.supports_tabs (',
'               p_application_id     => :FB_FLOW_ID, ',
'               p_user_interface_id => :P2500_USER_INTERFACE_ID);'))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4716'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(114018618816281486)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Web Reference Type'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'778'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(114018928354281487)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Web Reference Information'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'779:781:859'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(114019202992281488)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Parameters and Options'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'782:783:860'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(114162210486514180)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Confirm'
,p_list_item_current_for_pages=>'786'
);
end;
/
prompt --application/shared_components/navigation/lists/sss_extended
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(114371329791585494)
,p_name=>'sss.extended'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(114418321983210267)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Pages: &P9007_PAGE_LEVEL.'
,p_list_item_link_target=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(114418726485211591)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Application Items: &P9007_APP_ITEM_LEVEL.'
,p_list_item_link_target=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(114420921767219662)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Data Entry Items: &P9007_DATA_ENTRY_ITEM_LEVEL.'
,p_list_item_link_target=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(114421526616221094)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Display Only Items: &P9007_DISPLAY_ONLY_ITEM_LEVEL.'
,p_list_item_link_target=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(114422831464222441)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Page Item Cross-Site Scripting Protection: &P9007_PAGE_ITEM_ESCAPE.'
,p_list_item_link_target=>'f?p=&APP_ID.:9007:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/workspace_theme_progress
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(114829600122838504)
,p_name=>'workspace theme progress'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(114830714320842637)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Identify Theme'
,p_list_item_link_target=>'f?p=&APP_ID.:764:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'754'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'764'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(114831221593844797)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Identify Name'
,p_list_item_link_target=>'f?p=&APP_ID.:789:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'754'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'789'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(114831926787846213)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Confirm'
,p_list_item_link_target=>'f?p=&APP_ID.:762:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'754'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'762'
);
end;
/
prompt --application/shared_components/navigation/lists/dependencies_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(117039522797176386)
,p_name=>'Dependencies Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(117040128338177988)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Generate DDL'
,p_list_item_link_target=>'f?p=&APP_ID.:637:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/create_app_from_spreasheet_opt
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(118042377093675208)
,p_name=>'create.app.from.spreasheet.opt'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(118042502492675209)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Upload file'
,p_list_item_link_target=>'f?p=4500:3100:&SESSION.:::3100,3110,3120:P3100_SOURCE_TYPE:FILE'
,p_list_item_icon=>'a-Icon icon-region- icon-file-upload'
,p_list_text_01=>'Upload CSV, XLSX, XML, JSON data'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(118042942497675210)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Copy and paste'
,p_list_item_link_target=>'f?p=4500:3100:&SESSION.:::3100,3110,3120:P3100_SOURCE_TYPE:COPY_PASTE'
,p_list_item_icon=>'a-Icon icon-region- icon-clipboard'
,p_list_text_01=>'Copy and paste CSV data'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/comments
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(123545913988020430)
,p_name=>'comments'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(123546321607022623)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Create Comment'
,p_list_item_link_target=>'f?p=&APP_ID.:1234:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1234'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(123546700960026141)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'View Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:1235:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1235'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(123547007539028056)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Edit Comment'
,p_list_item_link_target=>'f?p=&APP_ID.:1236:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1236'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1236'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(125612105656334840)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Delete Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:1237:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from WWV_FLOW_APP_COMMENTS',
'where flow_id = :fb_flow_id',
'and security_group_id = :flow_security_group_id'))
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1237,1238'
);
end;
/
prompt --application/shared_components/navigation/lists/create_application_image_nav
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(128724959151960807)
,p_name=>'Create Application - Image Nav'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(128725983083960807)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'New Application'
,p_list_item_link_target=>'f?p=4020:1:&SESSION.:NEW:&DEBUG.:1,5,130,150,170,250:::'
,p_list_item_icon=>'gi-icon-app-builder'
,p_list_text_01=>'Add pages on existing data, select application features, set your theme, and configure other options.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(128728137528960809)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'From a File'
,p_list_item_link_target=>'f?p=4500:3100:&SESSION.:::3100,3110,3120,APEX$DATALOAD_COLUMNS:P3100_SOURCE_TYPE:FILE'
,p_list_item_icon=>'gi-icon-create-app-websheet'
,p_list_text_01=>'Upload a CSV, XLSX, XML or JSON file, or copy and paste data, then create your application.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(128728733474960809)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Starter App'
,p_list_item_link_target=>'f?p=4750:50:&SESSION.::&DEBUG.:50:::'
,p_list_item_icon=>'gi-icon-create-app-pkg-apps'
,p_list_text_01=>'Install one of many Sample and Starter Apps from the Gallery.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/create_application_step_1
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(139866417493663090)
,p_name=>'create application step 1'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(139870325374684265)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Method'
,p_list_item_link_target=>'f?p=&APP_ID.:56:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'56'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(139870631607686094)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Select Application'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_list_item_disp_condition=>'84,3009'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'887'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(23857907389713612)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Identify Copy Target'
,p_list_item_link_target=>'f?p=&APP_ID.:3009:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'3009,84'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(139871004034687499)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Confirm'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'130,84'
);
end;
/
prompt --application/shared_components/navigation/lists/confirm_page
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(148407226188594759)
,p_name=>'confirm.page'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(148409915022610438)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Run Page'
,p_list_item_link_target=>'f?p=&FB_FLOW_ID.:&F4000_RUN_EDIT_PAGE.:&SESSION.'
,p_list_item_icon=>'htmldb/builder/run_flow.gif'
,p_list_item_icon_attributes=>'width="100" height="75" alt="&F4000_RUN."'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(148417611521656692)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Edit Page'
,p_list_item_link_target=>'f?p=&APP_ID.:4500:&SESSION.::&DEBUG.::FB_FLOW_ID,FB_FLOW_PAGE_ID,F4000_P1_FLOW:&FB_FLOW_ID.,&F4000_RUN_EDIT_PAGE.,&FB_FLOW_ID.:'
,p_list_item_icon=>'htmldb/builder/edit_page.gif'
,p_list_item_icon_attributes=>'width="100" height="75" alt="&EDIT."'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/p4651_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(153106004753776646)
,p_name=>'p4651_tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(153106418259780522)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Undo region source'
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.::P88_TABLE,P88_COLUMN,P88_ID,P88_CALLING_FIELD,P88_FLOW:WWV_FLOW_PAGE_PLUGS,PLUG_SOURCE,&F4000_P4651_ID.,F4000_P4651_PLUG_SOURCE,&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(22605518586883916)
,p_list_item_display_sequence=>46
,p_list_item_link_text=>'Upgrade to HTML5 Chart'
,p_list_item_link_target=>'f?p=&APP_ID.:280:&SESSION.::&DEBUG.::P280_REGION_ID:&F4000_P4651_ID.:'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>':F4000_P4651_PLUG_SOURCE_TYPE = wwv_flow_region_native.c_legacy_simple_chart'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/p4307_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(153171308852373878)
,p_name=>'P4307_TASKS'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(153178223312397008)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Find Items'
,p_list_item_link_target=>'javascript:popUp(''f?p=4000:273:&SESSION.::::F4000_P273_PAGE:&FB_FLOW_PAGE_ID.'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(153174705173382332)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Undo Header Template'
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.:88:P88_TABLE,P88_COLUMN,P88_ID,P88_CALLING_FIELD,P88_FLOW:WWV_FLOW_TEMPLATES,HEADER_TEMPLATE,&F4000_P4307_ID.,F4000_P4307_HEADER_TEMPLATE,&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(153175014524385009)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Undo Body Template'
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.:88:P88_TABLE,P88_COLUMN,P88_ID,P88_CALLING_FIELD,P88_FLOW:WWV_FLOW_TEMPLATES,BOX,&F4000_P4307_ID.,F4000_P4307_BOX,&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(153175723181387558)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Undo Footer Template'
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.::P88_TABLE,P88_COLUMN,P88_ID,P88_CALLING_FIELD,P88_FLOW:WWV_FLOW_TEMPLATES,FOOTER_TEMPLATE,&F4000_P4307_ID.,F4000_P4307_FOOTER_TEMPLATE,&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/p4653_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(153210815104527139)
,p_name=>'P4653_TASKS'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(153212128263530955)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Find Items'
,p_list_item_link_target=>'javascript:popUp(''f?p=4000:273:&SESSION.::::F4000_P273_PAGE:&FB_FLOW_PAGE_ID.'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(153214009001534772)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Undo Template Source'
,p_list_item_link_target=>'f?p=&APP_ID.:88:&SESSION.::&DEBUG.:88:P88_TABLE,P88_COLUMN,P88_ID,P88_CALLING_FIELD,P88_FLOW:WWV_FLOW_PAGE_PLUG_TEMPLATES,TEMPLATE,&F4000_P4653_ID.,F4000_P4653_TEMPLATE,&FB_FLOW_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_remote_servers_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(154051976265844427)
,p_name=>'shared.components.remote_servers.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(154052121551844430)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'REST Enabled SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1600'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(154052580732844434)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:1602:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1602'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(154052913913844434)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:1603:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1603'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_credential_stores_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(154583731613661573)
,p_name=>'shared.components.credential_stores.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(154583988141661575)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Web Credentials'
,p_list_item_link_target=>'f?p=&APP_ID.:1620:&SESSION.::&DEBUG.:1620:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1620'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(154584303580661578)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:1622:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1622'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(154584705715661578)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:1623:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1623'
);
end;
/
prompt --application/shared_components/navigation/lists/export_page
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(158038003748775992)
,p_name=>'Export Page'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(158038407557777097)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Export Page'
,p_list_item_link_target=>'f?p=&APP_ID.:164:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(25720216186980294)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Manage Supporting Objects'
,p_list_item_link_target=>'f?p=&APP_ID.:2:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(200682401972525159)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Component Export'
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'FB_FLOW_ID'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(168868615219020507)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Manage Export Repository'
,p_list_item_link_target=>'f?p=&APP_ID.:73:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_lov
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(161740513874429436)
,p_name=>'Wizard Create LOV'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(202904909845918905)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Source'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'137'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(161742306326432962)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Name and Type'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4004'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11540348458195148)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'List of Values Source'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4080'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(161745627233438452)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Static Values'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'F4000_P4004_TYPE'
,p_list_item_disp_condition2=>'STATIC'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4014'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11542493794381119)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Column Mappings'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'F4000_P4004_TYPE'
,p_list_item_disp_condition2=>'DYNAMIC'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4081'
);
end;
/
prompt --application/shared_components/navigation/lists/cross_application_reports_attributes
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(162360828277873558)
,p_name=>'Cross Application Reports / Attributes'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(162361613863878819)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Application Attributes'
,p_list_item_link_target=>'f?p=&APP_ID.:9010:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-application-attributes'
,p_list_text_01=>'View component counts for each application.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(205251931899374098)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Build Status and Application Status'
,p_list_item_link_target=>'f?p=&APP_ID.:103:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-app-status'
,p_list_text_01=>'Review the statuses for each application.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(162362223560881642)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Build Options'
,p_list_item_link_target=>'f?p=&APP_ID.:9012:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-build-options'
,p_list_text_01=>'View build options across all applications.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(131390824277396235)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Developer Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:380:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-comments'
,p_list_text_01=>'Review comments from all applications.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(217724513488899294)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Developer Comments Calendar'
,p_list_item_link_target=>'f?p=&APP_ID.:665:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-comments-calendar'
,p_list_text_01=>'View when all comments were created.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/translation_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(165621520543370755)
,p_name=>'translation.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(171880500668996222)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Text Messages'
,p_list_item_link_target=>'f?p=&APP_ID.:4006:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-create-manage-text'
,p_list_text_01=>'Create and manage text messages.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(165622300589374384)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Dynamic Translations'
,p_list_item_link_target=>'f?p=&APP_ID.:4756:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-manage-dynamic-translation'
,p_list_text_01=>'Manage dynamic translation repository.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(28665818452018310)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Translation Repository'
,p_list_item_link_target=>'f?p=&APP_ID.:702:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-manually-edit-translation'
,p_list_text_01=>'Manually edit translated text in the translation repository.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/parent_tab_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(165863110284077420)
,p_name=>'parent.tab.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(165865017557079566)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Rename Parent Tab Set'
,p_list_item_link_target=>'f?p=&FLOW_ID.:332:&SESSION.::&DEBUG.:332::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(165865522059080812)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Resequence display order'
,p_list_item_link_target=>'f?p=&FLOW_ID.:331:&SESSION.::&DEBUG.:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(165867932102083690)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Create New Parent Tab'
,p_list_item_link_target=>'f?p=&FLOW_ID.:4725:&SESSION.::&DEBUG.:4725,4726,4727::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/standard_tab_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(165876716780098264)
,p_name=>'standard.tab.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(165879130286102126)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Manage Standard Tabs'
,p_list_item_link_target=>'f?p=&APP_ID.:9000:&SESSION.::&DEBUG.::F4000_P9000_PAGE:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/parent_tab_tasks_p9000
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(165884427300110704)
,p_name=>'parent_tab_tasks_p9000'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(165885332495112173)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Manage Parent Tabs'
,p_list_item_link_target=>'f?p=&APP_ID.:398:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/tasks_page_4714
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(165935217145249689)
,p_name=>'tasks_page_4714'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(165938632036253973)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Create a Login Page'
,p_list_item_link_target=>'f?p=4000:500:&SESSION.::NO'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/how_to_translate
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(165943028704262550)
,p_name=>'how_to_translate'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(165944104940265156)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Define application languages'
,p_list_item_link_target=>'f?p=&APP_ID.:4751:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-map-primary-language'
,p_list_text_01=>'Map primary language application to translated applications.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(165945811520267011)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Seed translatable text'
,p_list_item_link_target=>'f?p=&APP_ID.:385:&SESSION.::&DEBUG.::P385_ACTION:SEED:'
,p_list_item_icon=>'icon-util-seed-translatable-text'
,p_list_text_01=>'Copy the translatable text from the primary application into the translation repository.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(162434002630201887)
,p_list_item_display_sequence=>24
,p_list_item_link_text=>'Download XLIFF translation files'
,p_list_item_link_target=>'f?p=&APP_ID.:4750:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-download-xlif-translation'
,p_list_text_01=>'Download files with translatable text from the translation repository.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(165947319138269194)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Translate text'
,p_list_item_link_target=>'f?p=&APP_ID.:306:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-translate-text'
,p_list_text_01=>'Send XLIFF files for translation or manually edit translation repository.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(165949127796271740)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Apply XLIFF translation files'
,p_list_item_link_target=>'f?p=&APP_ID.:4758:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-upload-apply-xliff'
,p_list_text_01=>'Upload XLIFF files with translated text and apply translations to the translation repository.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(162434303453211574)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Publish translated applications'
,p_list_item_link_target=>'f?p=&APP_ID.:385:&SESSION.::&DEBUG.::P385_ACTION:PUBLISH:'
,p_list_item_icon=>'icon-util-publish-translated-applications'
,p_list_text_01=>'Make the translated applications available to users.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_nav_bar_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(166766500720858594)
,p_name=>'shared.components.nav_bar.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(166769319685865035)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Classic Navigation Bar Entries'
,p_list_item_link_target=>'f?p=&APP_ID.:4005:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4005'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(166770609981869522)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Grid Edit'
,p_list_item_link_target=>'f?p=&APP_ID.:153:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_icon_bar where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'153'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(201265401410394101)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Subscription'
,p_list_item_link_target=>'f?p=&APP_ID.:54:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_icon_bar where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'54'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10056426696402671)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:394:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from wwv_flow_icon_bar where flow_id = :fb_flow_id'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'394'
);
end;
/
prompt --application/shared_components/navigation/lists/replace_templates_train
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(168734227577365586)
,p_name=>'replace templates train'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(168734406930369089)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Template Type'
,p_list_item_link_target=>'f?p=&APP_ID.:708:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'708'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(168734718358372471)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Identify Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:711:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'711'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(168734923899374008)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Confirm'
,p_list_item_link_target=>'f?p=&APP_ID.:713:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'713'
);
end;
/
prompt --application/shared_components/navigation/lists/create_list_train
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(169186610834587350)
,p_name=>'create list train'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(169186923301591019)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Name and Type'
,p_list_item_link_target=>'f?p=&APP_ID.:427:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'427'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(169189328373658702)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Query or Static Values '
,p_list_item_link_target=>'f?p=&APP_ID.:440:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'440,464'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(169192814961711597)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Confirm'
,p_list_item_link_target=>'f?p=&APP_ID.:529:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'529,734'
);
end;
/
prompt --application/shared_components/navigation/lists/page_region_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(171723423034567648)
,p_name=>'page.region.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(6821101659113491)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Grid Edit of all Region Titles'
,p_list_item_link_target=>'f?p=&APP_ID.:438:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193870804947518508)
,p_list_item_display_sequence=>3
,p_list_item_link_text=>'Region Attributes'
,p_list_item_link_target=>'f?p=&APP_ID.:249:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(171780931017721336)
,p_list_item_display_sequence=>4
,p_list_item_link_text=>'PL/SQL Regions'
,p_list_item_link_target=>'f?p=&APP_ID.:480:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11339330772242551)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Customized Regions'
,p_list_item_link_target=>'f?p=&APP_ID.:70:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47911925376585041)
,p_list_item_display_sequence=>6
,p_list_item_link_text=>'Conditional Regions'
,p_list_item_link_target=>'f?p=&APP_ID.:864:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_button_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(171743703949609405)
,p_name=>'page.button.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(240733721440954144)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Grid Edit all Button Labels'
,p_list_item_link_target=>'f?p=&APP_ID.:250:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193784520531105981)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Buttons by Page'
,p_list_item_link_target=>'f?p=&APP_ID.:548:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194556907147613285)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Conditional Buttons'
,p_list_item_link_target=>'f?p=&APP_ID.:878:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_item_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(171752432131627079)
,p_name=>'page.item.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(233014630647109050)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Grid Edit of all Item Labels'
,p_list_item_link_target=>'f?p=&APP_ID.:6:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(233013122336106602)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Grid Edit of all Item Help Text'
,p_list_item_link_target=>'f?p=&APP_ID.:408:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(251134632073178851)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Item Help Subscriptions'
,p_list_item_link_target=>'f?p=&APP_ID.:389:&SESSION.::&DEBUG.:RIR:IR_FLOW_STEP_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193917900275255057)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'All Page Items'
,p_list_item_link_target=>'f?p=&APP_ID.:547:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(15591500615424210)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Password Items'
,p_list_item_link_target=>'f?p=&APP_ID.:59:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194531425614476695)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Conditional Items'
,p_list_item_link_target=>'f?p=&APP_ID.:869:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_validation_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(171763620666671065)
,p_name=>'page.validation.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(240772729414032103)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Grid Edit of all Validation Error Messages'
,p_list_item_link_target=>'f?p=&APP_ID.:214:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(242557604450198238)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Validations by Page'
,p_list_item_link_target=>'f?p=&APP_ID.:501:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194198200000377701)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Conditional Validations'
,p_list_item_link_target=>'f?p=&APP_ID.:883:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_computation_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(171769406383685886)
,p_name=>'page.computation.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(240790724743068620)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Grid Edit of all Computation Error Messages'
,p_list_item_link_target=>'f?p=&APP_ID.:215:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(224269225570329050)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Computations by Page'
,p_list_item_link_target=>'f?p=&APP_ID.:549:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194540617827512267)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Conditional Computations'
,p_list_item_link_target=>'f?p=&APP_ID.:877:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_process_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(171773504090694644)
,p_name=>'page.process.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(240759729367003715)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Grid Edit of all Process Messages'
,p_list_item_link_target=>'f?p=&APP_ID.:213:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(225375711989419725)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Processes by Page'
,p_list_item_link_target=>'f?p=&APP_ID.:552:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194248225420820252)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Conditional Processes'
,p_list_item_link_target=>'f?p=&APP_ID.:866:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/application_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(177830919883437702)
,p_name=>'Application Utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(177833406770462269)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Application Dashboard'
,p_list_item_link_target=>'f?p=&APP_ID.:71:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-app-dashboard'
,p_list_text_01=>'Review a summary of this application.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1885595358268728653)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Advisor'
,p_list_item_link_target=>'javascript:apex.navigation.popup({ url: ''f?p=&APP_ID.:8101:&SESSION.::&DEBUG.:8101'', width: 1000, height: 800 }); void(0);'
,p_list_item_icon=>'icon-util-advisor'
,p_list_text_01=>'Perform various checks on this application, including programming errors and best practices.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1661255424982169004)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Upgrade Application'
,p_list_item_link_target=>'f?p=&APP_ID.:89:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-upgrade-app'
,p_list_text_01=>'After upgrading to a new release, review components for upgrading to include the latest features.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(466865607820087113)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Recently Updated Pages'
,p_list_item_link_target=>'f?p=&APP_ID.:8:&SESSION.::&DEBUG.:RIR:IR_UPDATED_BY:&APP_USER.:'
,p_list_item_icon=>'icon-util-recent-pages'
,p_list_text_01=>'View a history of the page updates made on this application.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1160235601024416138)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Attribute Dictionary'
,p_list_item_link_target=>'f?p=&APP_ID.:889:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-attribute-dictionary'
,p_list_text_01=>'Manage item / column user interface defaults for a selected page.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(177831203693437706)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Change History'
,p_list_item_link_target=>'f?p=&APP_ID.:358:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-change-history'
,p_list_text_01=>'View a detailed report of component updates made on this application.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1160225427040278954)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Database Object Dependencies'
,p_list_item_link_target=>'f?p=&APP_ID.:425:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-object-dependencies'
,p_list_text_01=>'Review the database objects referenced by this application.'
,p_translate_list_text_y_n=>'Y'
,p_required_patch=>wwv_flow_imp.id(170786031904296885)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492241124877437516)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Debug Messages'
,p_list_item_link_target=>'f?p=&APP_ID.:666:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-debug-messages'
,p_list_text_01=>'Review debug messages generated by this application.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1173931504465813227)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'&PRODUCT_NAME. Views'
,p_list_item_link_target=>'f?p=&APP_ID.:714:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-apex-views'
,p_list_text_01=>'Query the various views against &PRODUCT_NAME. metadata.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492240609162423534)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Export Repository'
,p_list_item_link_target=>'f?p=&APP_ID.:73:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-export-repository'
,p_list_text_01=>'View a history of application exports.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(70885805484327683)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Manage Backups'
,p_list_item_link_target=>'f?p=&APP_ID.:971:&SESSION.::&DEBUG.:971:::'
,p_list_item_icon=>'icon-apex-backup'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_backup.backup_limit() > 0'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_text_01=>'Review backup history, perform a manual backup or restore from a backup'
,p_list_text_02=>'P971_APPLICATION_ID:100'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1205104966610419)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Embedded Code'
,p_list_item_link_target=>'f?p=&APP_ID.:101:&SESSION.::&DEBUG.:RP,101:::'
,p_list_item_icon=>'icon-util-embedded-code'
,p_list_text_01=>'Review code such as SQL, PL/SQL, JavaScript etc.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(569740971924292915)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Application Checksum'
,p_list_item_link_target=>'f?p=&APP_ID.:109:&SESSION.::&DEBUG.:109:P109_COMPONENT:APPLICATION:'
,p_list_item_icon=>'icon-check-circle'
,p_list_text_01=>'The application checksum provides an easy way to determine whether the same application is deployed across workspaces.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(576931365336902572)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Font APEX Icons'
,p_list_item_link_target=>'f?p=&APP_ID.:110:&SESSION.::&DEBUG.:110:::'
,p_list_item_icon=>'icon-util-font-apex'
,p_list_text_01=>'Find Font APEX icons and HTML Markup'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(597489289435573267)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Page Checksums'
,p_list_item_link_target=>'f?p=&APP_ID.:111:&SESSION.::&DEBUG.:RP,111:P109_COMPONENT:APPLICATION:'
,p_list_item_icon=>'icon-check-circle'
,p_list_text_01=>'The page checksum report provides an easy way to compare two application deployments and see which pages are the same and which are different'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_item
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(179572716597169307)
,p_name=>'Wizard Copy Item'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(197073903769725734)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'New Page'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'171'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(179579323055181481)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'New Item'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'172'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_authentication_scheme_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(180433926348108856)
,p_name=>'shared.components.authentication_scheme.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(180435618514116022)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Authentication Schemes'
,p_list_item_link_target=>'f?p=&APP_ID.:801:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'801'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(180437106178121918)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Subscription'
,p_list_item_link_target=>'f?p=&APP_ID.:817:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'817'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(192776728065739452)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:554:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'554'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_authorization_scheme_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(180462022520306486)
,p_name=>'shared.components.authorization_scheme.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(180462914339313581)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Authorization Schemes'
,p_list_item_link_target=>'f?p=&APP_ID.:4070:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4070'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(180463224729316523)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Subscription'
,p_list_item_link_target=>'f?p=&APP_ID.:129:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'129'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47955811298564811)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'by Component'
,p_list_item_link_target=>'f?p=&APP_ID.:340:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'340'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(180463832347318756)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:4045:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4045'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(192784124265814091)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:558:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'558'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_button
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(181185105878280365)
,p_name=>'Wizard Copy Button'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(15213429898992140)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'New Page'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'231'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(181188725059286630)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'New Button'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'191'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_dynamic_action
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(181501623296103719)
,p_name=>'copy.dynamic_action'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(181503411306109716)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Dynamic Action to Copy'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'728'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(181503816154111137)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'To Page'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'796'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(181504222388112936)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'New Dynamic Action'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'797'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_map_region
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(185155905837041142)
,p_name=>'Wizard Create Map Region'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(185157403628041147)
,p_list_item_display_sequence=>6
,p_list_item_link_text=>'Map Source'
,p_list_item_link_target=>'f?p=&APP_ID.:840:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>':P181_REGION_TYPE = ''Map'''
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'840'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(185157801641041147)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Display Attributes'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4016,91,2002,2003,799,313'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(185159024483041149)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Query'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4017,407,683,537'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(185159826358041149)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Conditional Display'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4018:692'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_shortcut
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(185305822581982553)
,p_name=>'Wizard Create Shortcut'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(185307615464985837)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Creation Method'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'131'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(185308412229987392)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Shortcut Attributes'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'174'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_pull_shortcuts
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(185309707700989517)
,p_name=>'Wizard Pull Shortcuts'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(185313922784997656)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Creation Method'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'131'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(185314719980998966)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Copy From'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'132'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(185315516746000474)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'New Shortcuts'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'133'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_shortcut_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(186543329326722942)
,p_name=>'shared.components.shortcut.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(186545123935725534)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Shortcuts'
,p_list_item_link_target=>'f?p=&APP_ID.:4047:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4047'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(186545918543727968)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Subscription'
,p_list_item_link_target=>'f?p=&APP_ID.:175:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1 from WWV_FLOW_SHORTCUTS where flow_id = :FB_FLOW_ID'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'175'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(10983506807371682)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:41:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'41'
);
end;
/
prompt --application/shared_components/navigation/lists/page_item_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(186703109122914661)
,p_name=>'page.item.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(186714413638927747)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Items'
,p_list_item_link_target=>'f?p=4000:4200:&SESSION.::NO:4200'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4200'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(40289317195455624)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Delete Multiple Items'
,p_list_item_link_target=>'f?p=&APP_ID.:7:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'7'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(47958103726591074)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:854:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'854:408:6:547:59:869:389'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11258131416157207)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:62:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'62'
);
end;
/
prompt --application/shared_components/navigation/lists/page_validation_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(186826132498329280)
,p_name=>'page.validation.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(186832108129340579)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Validations'
,p_list_item_link_target=>'f?p=&APP_ID.:4205:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4205'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(57912215798286576)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Delete Multiple Validations'
,p_list_item_link_target=>'f?p=&APP_ID.:743:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'743'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193767726569918515)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:851:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'851:214:501:883'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(11340930817563888)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:66:&SESSION.::&DEBUG.:RIR:IR_PAGE_ID:&FB_FLOW_PAGE_ID.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'66'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_pull_security_schemes
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(186904126354727159)
,p_name=>'Wizard Pull Security Schemes'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(186905916218731926)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Creation Method'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'184'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(186906712336733691)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Copy From'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'185'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(186907507376736030)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Names'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'186'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_authorization_schemes
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(186911322244744240)
,p_name=>'Wizard Create Authorization Schemes'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(186913114912747650)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Creation Method'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'184'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(186914408226750829)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Details'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'188'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_plug_in_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(188993730020080349)
,p_name=>'shared.components.plug-in.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(188994312836084773)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Plug-ins'
,p_list_item_link_target=>'f?p=&APP_ID.:4400:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4400'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(188994619762086758)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:4420:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4420'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193358210391475853)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:841:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'841'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_report_query_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(193369209650497455)
,p_name=>'shared.components.report_query.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193369600778504265)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Report Queries'
,p_list_item_link_target=>'f?p=&APP_ID.:1100:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1100'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193369910128507049)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:843:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'843'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_report_layout_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(193374517232546937)
,p_name=>'shared.components.report_layout.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193374801581546942)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Report Layouts'
,p_list_item_link_target=>'f?p=&APP_ID.:1400:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1400'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193375221285546942)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:844:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'844'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_navbar
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(193684503309130516)
,p_name=>'Wizard Copy NavBar'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193686328960133836)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Creation Method'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'22'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193687125078135642)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Copy From'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'134'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193688421627137255)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'New Names'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'135'
);
end;
/
prompt --application/shared_components/navigation/lists/page_dynamic_action_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(194153003566161205)
,p_name=>'page.dynamic_action.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194154929885168734)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'All Dynamic Actions'
,p_list_item_link_target=>'f?p=&APP_ID.:699:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_region_utilities_region_counts
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(194250609883844198)
,p_name=>'page.region.utilities.region.counts'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194252923250844202)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Count by Region Type'
,p_list_item_link_target=>'f?p=&APP_ID.:128:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_region.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194253310565844203)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Count by Page Template Display Point'
,p_list_item_link_target=>'f?p=&APP_ID.:459:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'htmldb/icons/pt_region.png'
,p_list_item_icon_attributes=>'alt=""'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_branch_utilities
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(194565421168929524)
,p_name=>'page.branch.utilities'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194566126273929526)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Branches by Page'
,p_list_item_link_target=>'f?p=&APP_ID.:563:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(194566502198929526)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Conditional Branches'
,p_list_item_link_target=>'f?p=&APP_ID.:885:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_region
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(197233420990021629)
,p_name=>'Wizard Copy Region'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(197241701365030751)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'To Page'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'194'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(197243528741033202)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'New Region'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'195'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_views_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(200452609222306546)
,p_name=>'APEX Views Navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(200453224460311015)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Report View'
,p_list_item_link_target=>'f?p=&APP_ID.:714:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'714'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(201268128688684688)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Tree View'
,p_list_item_link_target=>'f?p=&APP_ID.:905:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'905'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(200453701734313844)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Select Columns'
,p_list_item_link_target=>'f?p=&APP_ID.:892:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
':P892_VIEW_NAME is not null or',
':APP_PAGE_ID = ''892'''))
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'892'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(200454107275315499)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Filter'
,p_list_item_link_target=>'f?p=&APP_ID.:893:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'P892_SELECTED_COLS'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'893'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(200454411431316639)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Results'
,p_list_item_link_target=>'f?p=&APP_ID.:896:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'ITEM_IS_NOT_NULL'
,p_list_item_disp_condition=>'P892_SELECTED_COLS'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'896'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_page_wiz_steps
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(202931703979545993)
,p_name=>'copy_page_wiz_steps'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(202933009304556968)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Copy Page Option'
,p_list_item_link_target=>'f?p=&APP_ID.:618:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'618'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(202934128351562472)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Page to Copy'
,p_list_item_link_target=>'f?p=&APP_ID.:621:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'621'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1556125534907719472)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Navigation Menu'
,p_list_item_link_target=>'f?p=&APP_ID.:617:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P621_NAVIGATION_TYPE'
,p_list_item_disp_condition2=>'L'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'671'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(204089926319940378)
,p_list_item_display_sequence=>35
,p_list_item_link_text=>'Tabs'
,p_list_item_link_target=>'f?p=&APP_ID.:617:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_list_item_disp_condition=>'P621_NAVIGATION_TYPE'
,p_list_item_disp_condition2=>'L'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'671'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(202934605626565380)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:622:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'622'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(202935113937567735)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Lists of Values'
,p_list_item_link_target=>'f?p=&APP_ID.:623:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'623'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(202935522249570117)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Lists'
,p_list_item_link_target=>'f?p=&APP_ID.:625:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'625'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(202935827097571532)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Authorization Schemes'
,p_list_item_link_target=>'f?p=&APP_ID.:627:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'627'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(208023117796803899)
,p_list_item_display_sequence=>75
,p_list_item_link_text=>'Branches'
,p_list_item_link_target=>'f?p=&APP_ID.:593:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'593'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(202936132291573046)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Confirm'
,p_list_item_link_target=>'f?p=&APP_ID.:628:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'628'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_pull_lov
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(202952222735973765)
,p_name=>'Wizard Pull LOV'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(202954017990975969)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Creation Method'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'137'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(202954813893977815)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Copy From '
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'138'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(202955610442979398)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'New Lists of Values'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'139'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_lov_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(203029530177365353)
,p_name=>'shared.components.lov.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(203035015081372358)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Lists of Values'
,p_list_item_link_target=>'f?p=&APP_ID.:4110:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4110'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(184816719223361035)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Edit Null Text'
,p_list_item_link_target=>'f?p=&APP_ID.:169:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'169'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(184821331999411979)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Locally Defined'
,p_list_item_link_target=>'f?p=&APP_ID.:419:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'419'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(184821605811413905)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Grid Edit'
,p_list_item_link_target=>'f?p=&APP_ID.:178:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'178'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(188105422784870512)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Conditional Entries'
,p_list_item_link_target=>'f?p=&APP_ID.:556:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'556'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(203035810552374398)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Subscription'
,p_list_item_link_target=>'f?p=&APP_ID.:142:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1  from WWV_FLOW_LISTS_OF_VALUES$ where flow_id = :FB_FLOW_ID'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'142'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(631171523671392471)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:87:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>'select 1  from WWV_FLOW_LISTS_OF_VALUES$ where flow_id = :FB_FLOW_ID'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'87'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(193350901986416680)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:686:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'686'
);
end;
/
prompt --application/shared_components/navigation/lists/p224_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(205602222789276628)
,p_name=>'p224 tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1036212995590553756)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Manage Themes'
,p_list_item_link_target=>'f?p=&APP_ID.:260:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/export_component_tabs
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(207503732215648915)
,p_name=>'export component tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(207504110528652105)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Components'
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.:AC:&DEBUG.::P688_MODE:AC:'
,p_list_item_current_type=>'EXPRESSION'
,p_list_item_current_for_pages=>'nvl(:P688_MODE,''AC'') = ''AC'''
,p_list_item_current_language=>'PLSQL'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(207504421956655470)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Components by Page'
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.:PD:&DEBUG.::P688_MODE:PD:'
,p_list_item_current_type=>'EXPRESSION'
,p_list_item_current_for_pages=>'nvl(:P688_MODE,''PD'') = ''PD'''
,p_list_item_current_language=>'PLSQL'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(228921921121485140)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Build Option Status'
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.::&DEBUG.::P688_MODE:BO:'
,p_list_item_current_type=>'EXPRESSION'
,p_list_item_current_for_pages=>'nvl(:P688_MODE,''AC'') = ''BO'''
,p_list_item_current_language=>'PLSQL'
);
end;
/
prompt --application/shared_components/navigation/lists/install_preview
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(210424614987781460)
,p_name=>'Install Preview'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(210426801959787134)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Preview Installation Script'
,p_list_item_link_target=>'javascript:popupURL(''f?p=&APP_ID.:2109:&SESSION.::&DEBUG.::P2109_MODE:INSTALL'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/component_export_train
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(210787017222419064)
,p_name=>'component export train'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(210787424148421054)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Identify Components'
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'688'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(210787931074423052)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Export Components'
,p_list_item_link_target=>'f?p=&APP_ID.:637:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'637'
);
end;
/
prompt --application/shared_components/navigation/lists/page_group_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(213192710092707758)
,p_name=>'page.group.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(213193117365709843)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Page Groups'
,p_list_item_link_target=>'f?p=&APP_ID.:520:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'520:521'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(7889418131882539)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Page Assignments'
,p_list_item_link_target=>'f?p=&APP_ID.:522:&SESSION.::&DEBUG.:RP,522:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'522'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(213326924824175665)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Pages by Page Group'
,p_list_item_link_target=>'f?p=&APP_ID.:528:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'528'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_template
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(222829818333256486)
,p_name=>'Wizard Copy Template'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(222830025179256507)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Template to Copy'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'584'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(222830500690256514)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'New Template'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'538:568:569:571:564:573:574:636'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_create_rest_data_source
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(226545212901831813)
,p_name=>'Wizard Create REST Data Source'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(226545418188831828)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'General'
,p_list_item_link_target=>'f?p=&APP_ID.:1941:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(226545892098831833)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Remote Server'
,p_list_item_link_target=>'f?p=&APP_ID.:1942:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1295970335077570)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Settings'
,p_list_item_link_target=>'f?p=&APP_ID.:1945:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(226546270015831833)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Authentication'
,p_list_item_link_target=>'f?p=&APP_ID.:1943:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(226680867806416802)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Parameters'
,p_list_item_link_target=>'f?p=&APP_ID.:1944:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_EQUALS_CONDITION'
,p_list_item_disp_condition=>'1944'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(226546658284831833)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Preview'
,p_list_item_link_target=>'f?p=&APP_ID.:1946:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/deinstall_preview
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(227753031474767408)
,p_name=>'Deinstall Preview'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(227754420869773895)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Preview Deinstallation Script'
,p_list_item_link_target=>'javascript:popupURL(''f?p=&APP_ID.:2109:&SESSION.::&DEBUG.::P2109_MODE:DEINSTALL'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_process
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(227766223920945009)
,p_name=>'Wizard Copy Process'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(227766422394945011)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Process to Copy'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'590'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(227766714836945011)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Process Options'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'645'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_validation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(228167614670175482)
,p_name=>'Wizard Copy Validation'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_branch
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(228256415837925869)
,p_name=>'Wizard Copy Branch'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(228256632661925872)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Branch to Copy'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'587'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(228256900182925873)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Branch Options'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'685'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_copy_computation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(228264919955974373)
,p_name=>'Wizard Copy Computation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(228266003117978994)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Computation to Copy'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'592'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(228266412121981558)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Computation Options'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'597'
);
end;
/
prompt --application/shared_components/navigation/lists/copy_list_train
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(231136205422723196)
,p_name=>'copy list train'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(231137725854729050)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Identify List'
,p_list_item_link_target=>'f?p=&APP_ID.:663:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'663'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_web_sources_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(241353531173849237)
,p_name=>'shared.components.web_sources.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(241353749272849252)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'REST Data Sources'
,p_list_item_link_target=>'f?p=&APP_ID.:1901:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(564743301883397522)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Synchronizations'
,p_list_item_link_target=>'f?p=&APP_ID.:1955:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(241354167823849253)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:1902:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(247801890036355717)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:1903:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/remoteserver_create
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(249337602894822823)
,p_name=>'remoteserver.create'
,p_list_status=>'PUBLIC'
);
end;
/
prompt --application/shared_components/navigation/lists/remoteserver_createnew
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(249355742923907578)
,p_name=>'remoteserver.createnew'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(249355942729907578)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'General'
,p_list_item_link_target=>'f?p=&APP_ID.:1615:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(249356348643907578)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Authentication'
,p_list_item_link_target=>'f?p=&APP_ID.:1616:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/websrcmodule_create
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(249385562937130742)
,p_name=>'websrcmodule.create'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(249385724604130742)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Method'
,p_list_item_link_target=>'f?p=&APP_ID.:1905:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(249386134393130742)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Copy From'
,p_list_item_link_target=>'f?p=&APP_ID.:1906:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P1905_ACTION'
,p_list_item_disp_condition2=>'COPY'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4600351737385437)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Create from Catalog'
,p_list_item_link_target=>'f?p=&APP_ID.:1908:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P1905_ACTION'
,p_list_item_disp_condition2=>'CATALOG'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1908'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1903006796784570)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Choose Services'
,p_list_item_link_target=>'f?p=&APP_ID.:1911:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P1905_ACTION'
,p_list_item_disp_condition2=>'CATALOG'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1911'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1904581007791181)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Summary'
,p_list_item_link_target=>'f?p=&APP_ID.:1910:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P1905_ACTION'
,p_list_item_disp_condition2=>'CATALOG'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1910'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(249386558688130742)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Copy'
,p_list_item_link_target=>'f?p=&APP_ID.:1907:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND2'
,p_list_item_disp_condition=>'P1905_ACTION'
,p_list_item_disp_condition2=>'CATALOG'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/application_attributes_tabs
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(274897624522614662)
,p_name=>'application attributes tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(274898302490617757)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Definition'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_DEFN'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'4001'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(274905604268646630)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Security'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_SEC'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'509'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(33757928911956810)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Globalization'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_GLOBAL'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'506'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(42233410928343483)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'User Interface'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_USERINTERFACE'');'
,p_required_patch=>wwv_flow_imp.id(235700916833599805)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'197, 677'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(106143872367571065)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Progressive Web App'
,p_list_item_link_target=>'javascript:doSubmit(''APPLY_CHANGES_PWA'');'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'507'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_administration_header
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(384736293175059813)
,p_name=>'APEX 5 - Administration (Header)'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(387750990921837996)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Administration'
,p_list_item_link_target=>'f?p=4350:1:&APP_SESSION.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(488619320836057116)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(572044671779464700)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Manage Service'
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697357627145483514)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Manage Service'
,p_list_item_link_target=>'f?p=4350:21:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(572044671779464700)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697357856198483516)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'------'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(572044671779464700)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(572699887011597076)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Make a Service Request'
,p_list_item_link_target=>'f?p=4350:96:&SESSION.::NO:49::'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'''
,p_list_item_disp_condition2=>'PLSQL'
,p_parent_list_item_id=>wwv_flow_imp.id(572044671779464700)
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697358175538483516)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Set Workspace Preferences'
,p_list_item_link_target=>'f?p=4350:17:&SESSION.::NO:RP::'
,p_parent_list_item_id=>wwv_flow_imp.id(572044671779464700)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697358473589483516)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Define Workspace Message'
,p_list_item_link_target=>'f?p=4350:35:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(572044671779464700)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(180638709312604050)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Define Environment Banner'
,p_list_item_link_target=>'f?p=4350:105:&SESSION.:::105:P105_LAST_APP_ID,P105_LAST_PAGE_ID:&APP_ID.,&APP_PAGE_ID.'
,p_parent_list_item_id=>wwv_flow_imp.id(572044671779464700)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(322860788157413129)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Workspace Utilization'
,p_list_item_link_target=>'f?p=4350:101:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(572044671779464700)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(195346789722904026)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Manage Users and Groups'
,p_list_item_link_target=>'f?p=4350:55:&SESSION.'
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(572046067324491819)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Monitor Activity'
,p_list_item_link_target=>'f?p=4350:22:&SESSION.'
,p_security_scheme=>wwv_flow_imp.id(10593027526205581)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(327720126528125003)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Dashboards'
,p_list_item_link_target=>'f?p=4350:33:&SESSION.'
,p_security_scheme=>wwv_flow_imp.id(10593027526205581)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1250496483207165958)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Change My Password'
,p_list_item_link_target=>'f?p=4350:3:&SESSION.::&DEBUG.:3#pwd'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_authentication_dev.can_edit_builder_users'
,p_list_item_disp_condition2=>'PLSQL'
,p_security_scheme=>wwv_flow_imp.id(10593027526205581)
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_tabs
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(384991882401692897)
,p_name=>'APEX 5 - Tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(384992396663692898)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'App Builder'
,p_list_item_link_target=>'f?p=&APP_ID.:1500:&SESSION.::&DEBUG.::::'
,p_list_item_icon_alt_attribute=>'App Builder Drill Down'
,p_list_text_01=>'tab-app-builder'
,p_security_scheme=>wwv_flow_imp.id(178938910382761975)
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(384998086804692900)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Create'
,p_list_item_link_target=>'f?p=&APP_ID.:56:&SESSION.::&DEBUG.:56,103,104,106,130,131,35,227,3020,3000,3001:FB_FLOW_ID,FB_FLOW_PAGE_ID::'
,p_parent_list_item_id=>wwv_flow_imp.id(384992396663692898)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(384998642350692901)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Import'
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.::&DEBUG.:460:P460_FILE_TYPE:FLOW_EXPORT:'
,p_parent_list_item_id=>wwv_flow_imp.id(384992396663692898)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(384998906454692901)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Export'
,p_list_item_link_target=>'f?p=4000:523:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(384992396663692898)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697375495888714842)
,p_list_item_display_sequence=>155
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(384992396663692898)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(385002826736692904)
,p_list_item_display_sequence=>160
,p_list_item_link_text=>'Workspace Utilities'
,p_parent_list_item_id=>wwv_flow_imp.id(384992396663692898)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(699060618186707760)
,p_list_item_display_sequence=>161
,p_list_item_link_text=>'All Workspace Utilities'
,p_list_item_link_target=>'f?p=4000:182:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(385002826736692904)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(699060810272707760)
,p_list_item_display_sequence=>162
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(385002826736692904)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697218772666647649)
,p_list_item_display_sequence=>163
,p_list_item_link_text=>'App Builder Defaults'
,p_list_item_link_target=>'f?p=&APP_ID.:800:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(385002826736692904)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697219764020653222)
,p_list_item_display_sequence=>165
,p_list_item_link_text=>'Workspace Themes'
,p_list_item_link_target=>'f?p=4000:763:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(385002826736692904)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697219311840650861)
,p_list_item_display_sequence=>166
,p_list_item_link_text=>'Application Groups'
,p_list_item_link_target=>'f?p=4000:722:&SESSION.::&DEBUG.:RP'
,p_parent_list_item_id=>wwv_flow_imp.id(385002826736692904)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697220796797659605)
,p_list_item_display_sequence=>167
,p_list_item_link_text=>'APEX Views'
,p_list_item_link_target=>'f?p=&APP_ID.:714:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(385002826736692904)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697220390514657026)
,p_list_item_display_sequence=>168
,p_list_item_link_text=>'Cross Application Reports'
,p_list_item_link_target=>'f?p=4000:9009:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(385002826736692904)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(384992635866692898)
,p_list_item_display_sequence=>200
,p_list_item_link_text=>'SQL Workshop'
,p_list_item_link_target=>'f?p=4500:3002:&SESSION.'
,p_list_item_icon_alt_attribute=>'SQL Workshop Drill Down'
,p_list_text_01=>'tab-sql-workshop'
,p_security_scheme=>wwv_flow_imp.id(178939331963761975)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(384993534292692898)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Object Browser'
,p_list_item_link_target=>'f?p=4500:1001:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(384992635866692898)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(384993809500692899)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'SQL Commands'
,p_list_item_link_target=>'f?p=4500:1003:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(384992635866692898)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697366669537617727)
,p_list_item_display_sequence=>230
,p_list_item_link_text=>'SQL Scripts'
,p_list_item_link_target=>'f?p=4500:1004:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(384992635866692898)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_display_sequence=>240
,p_list_item_link_text=>'Utilities'
,p_parent_list_item_id=>wwv_flow_imp.id(384992635866692898)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697367098027622850)
,p_list_item_display_sequence=>241
,p_list_item_link_text=>'All Utilities'
,p_list_item_link_target=>'f?p=4500:1005:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697367200739625365)
,p_list_item_display_sequence=>242
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697367573471631495)
,p_list_item_display_sequence=>243
,p_list_item_link_text=>'Data Workshop'
,p_list_item_link_target=>'f?p=4300:1:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1660711115262692)
,p_list_item_display_sequence=>243.5
,p_list_item_link_text=>'Data Generator'
,p_list_item_link_target=>'f?p=4500:4000:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_security_scheme=>wwv_flow_imp.id(1753774729792863)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697367739947635075)
,p_list_item_display_sequence=>244
,p_list_item_link_text=>'Query Builder'
,p_list_item_link_target=>'f?p=4500:1002:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(713688567094388045)
,p_list_item_display_sequence=>245
,p_list_item_link_text=>'Quick SQL'
,p_list_item_link_target=>'f?p=4500:1100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(670876181059880723)
,p_list_item_display_sequence=>246
,p_list_item_link_text=>'Sample Datasets'
,p_list_item_link_target=>'f?p=4300:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697367942849638524)
,p_list_item_display_sequence=>247
,p_list_item_link_text=>'Generate DDL'
,p_list_item_link_target=>'f?p=4500:12:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697368124231641328)
,p_list_item_display_sequence=>248
,p_list_item_link_text=>'User Interface Defaults'
,p_list_item_link_target=>'f?p=4500:813:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697369742087658694)
,p_list_item_display_sequence=>249
,p_list_item_link_text=>'Schema Comparison'
,p_list_item_link_target=>'f?p=4500:1350:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697368385017644833)
,p_list_item_display_sequence=>250
,p_list_item_link_text=>'Methods on Tables'
,p_list_item_link_target=>'f?p=4500:120:&SESSION.::NO::P117_CREATE_PACKAGE:TABLE'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697370148167661241)
,p_list_item_display_sequence=>251
,p_list_item_link_text=>'Recycle Bin'
,p_list_item_link_target=>'f?p=4500:1070:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697369196932653004)
,p_list_item_display_sequence=>252
,p_list_item_link_text=>'Object Reports'
,p_list_item_link_target=>'f?p=4500:1042:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697368631376650206)
,p_list_item_display_sequence=>253
,p_list_item_link_text=>'About Database'
,p_list_item_link_target=>'f?p=4500:36:&SESSION.'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_list_item_disp_condition2=>'PLSQL'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697369518797655840)
,p_list_item_display_sequence=>254
,p_list_item_link_text=>'Database Monitor'
,p_list_item_link_target=>'f?p=4500:11:&SESSION.'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>'wwv_flow_platform.get_preference(''ALLOW_DB_MONITOR'') = ''Y'''
,p_list_item_disp_condition2=>'PLSQL'
,p_parent_list_item_id=>wwv_flow_imp.id(697366891742619697)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(385003728877692904)
,p_list_item_display_sequence=>260
,p_list_item_link_text=>'RESTful Services'
,p_list_item_link_target=>'f?p=4850:100:&SESSION.'
,p_parent_list_item_id=>wwv_flow_imp.id(384992635866692898)
,p_security_scheme=>wwv_flow_imp.id(802892920094782611)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(384992969361692898)
,p_list_item_display_sequence=>300
,p_list_item_link_text=>'Team Development'
,p_list_item_link_target=>'f?p=4600:1:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon_alt_attribute=>'Team Development Drill Down'
,p_list_text_01=>'tab-team-dev'
,p_security_scheme=>wwv_flow_imp.id(178939812163761988)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(384995344172692899)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>'Labels'
,p_list_item_link_target=>'f?p=4600:300:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_imp.id(384992969361692898)
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(384995062424692899)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>'Milestones'
,p_list_item_link_target=>'f?p=4600:200:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_imp.id(384992969361692898)
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(384995637536692899)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>'Templates'
,p_list_item_link_target=>'f?p=4600:1000:&SESSION.::&DEBUG.:RP:::'
,p_parent_list_item_id=>wwv_flow_imp.id(384992969361692898)
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(384995957053692899)
,p_list_item_display_sequence=>340
,p_list_item_link_text=>'Utilities'
,p_list_item_link_target=>'f?p=4600:2000:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(384992969361692898)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697376668510727547)
,p_list_item_display_sequence=>355
,p_list_item_link_text=>'-----'
,p_list_item_link_target=>'separator'
,p_parent_list_item_id=>wwv_flow_imp.id(384992969361692898)
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697269568743762526)
,p_list_item_display_sequence=>360
,p_list_item_link_text=>'Feedback'
,p_list_item_link_target=>'f?p=4650:8012:&SESSION.::&DEBUG.::::'
,p_parent_list_item_id=>wwv_flow_imp.id(384992969361692898)
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(657003378451122018)
,p_list_item_display_sequence=>400
,p_list_item_link_text=>'Gallery'
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.'
,p_list_text_01=>'tab-apps'
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
,p_list_item_current_type=>'NEVER'
);
end;
/
prompt --application/shared_components/navigation/lists/application_utilities_managebackups
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(392874975855473167)
,p_name=>'application.utilities.managebackups'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(392875192940473167)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'All Backups'
,p_list_item_link_target=>'f?p=&APP_ID.:970:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(482121222077403370)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'All Backup Details'
,p_list_item_link_target=>'f?p=&APP_ID.:979:&SESSION.::&DEBUG.:RP,979:::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/attribute_dictionary
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(445192614743849621)
,p_name=>'Attribute Dictionary'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(445192924596849626)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Access Attribute Dictionary'
,p_list_item_link_target=>'f?p=4500:6:&SESSION.:'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/p164_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(445352903500710112)
,p_name=>'P164_TASKS'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(445353209286710113)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Export Application'
,p_list_item_link_target=>'f?p=&APP_ID.:4900:&SESSION.:'
,p_list_item_current_for_pages=>'4900'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(445353627788710114)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Export Components'
,p_list_item_link_target=>'f?p=&APP_ID.:688:&SESSION.:'
,p_list_item_current_for_pages=>'688'
);
end;
/
prompt --application/shared_components/navigation/lists/standard_tab_display
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(454874132315440955)
,p_name=>'Standard Tab Display'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(454874414531440958)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'The page identifies a <strong>Standard Tab Set</strong>.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(454881521635541944)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'The <strong>Tab Entry</strong> identifies the page as the <strong>Tab Page</strong>, or the <strong>Tab Also Current For Pages</strong>.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(454874801932440962)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'The page''s <strong>Page Template</strong> is capable of displaying <strong>Standard Tabs</strong>.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(454875215155440962)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'The tab entries <strong>display condition</strong> do not prevent tab from displaying'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(454920400070828946)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'The tab entries <strong>Authorization Scheme</strong> does not prevent the tab from being displayed.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/parent_tab_display
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(455042113172478942)
,p_name=>'Parent Tab Display'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(455042409640478944)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'The page successfully displays a <strong>Standard Tab</strong>.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(455051127155492375)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'The <strong>Standard Tab</strong> identifies the correct <strong>Parent Tab Set</strong>.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(455060118431660179)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'The <strong>Parent Tab</strong> identifies the correct tab set in the <strong>Current on Standard Tab Set</strong> attribute.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(455051817936499217)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'The pages <strong>Page Template</strong> is capable of displaying <strong>Standard Tabs</strong> and <strong>Parent Tabs</strong>.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(455054405216552285)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'The parent tabs <strong>Display Condition</strong> does not prevent the parent tab from displaying.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(455055223701567123)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'The parent tabs <strong>Authorization Scheme</strong> does not prevent the parent tab from displaying.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/wizard_advanced_migration
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(484017424976766961)
,p_name=>'Wizard_Advanced_Migration'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(499114818402832919)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Select Page'
,p_list_item_link_target=>'f?p=&APP_ID.:911:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(484017612155766970)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Select Validations to Upgrade'
,p_list_item_link_target=>'f?p=&APP_ID.:86:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'86'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(484017930508766978)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Select Buttons to Not Execute Validations'
,p_list_item_link_target=>'f?p=&APP_ID.:646:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'646'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(631593123192499955)
,p_list_item_display_sequence=>25
,p_list_item_link_text=>'Select Validations to Always Execute'
,p_list_item_link_target=>'f?p=&APP_ID.:862:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'862'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492683002038349240)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Upgrade '
,p_list_item_link_target=>'f?p=&APP_ID.:383:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'383'
);
end;
/
prompt --application/shared_components/navigation/lists/export
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(486268530815434681)
,p_name=>'Export'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(486269231292444337)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Workspace'
,p_list_item_link_target=>'f?p=&APP_ID.:76:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-workspace'
,p_list_text_01=>'Export a workspace, which includes user groups, users, and team development data, but not applications.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(486268818479440607)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Applications'
,p_list_item_link_target=>'f?p=&APP_ID.:4900:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-app-database'
,p_list_text_01=>'Export applications, individual pages, and shared components.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(486271016233477824)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Application Themes'
,p_list_item_link_target=>'f?p=&APP_ID.:224:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-workspace-themes'
,p_list_text_01=>'Export themes from a specific application.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(486271223505479946)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Plug-ins'
,p_list_item_link_target=>'f?p=&APP_ID.:4460:&SESSION.::&DEBUG.:4460:::'
,p_list_item_icon=>'icon-sc-plugin'
,p_list_text_01=>'Export plug-ins used in applications.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(486271911862486037)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'User Interface Defaults'
,p_list_item_link_target=>'f?p=&APP_ID.:479:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-utilities-ui-defaults'
,p_list_text_01=>'Export default layout properties from either table or attribute user interface defaults.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(486272411647495352)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Team Development Feedback'
,p_list_item_link_target=>'f?p=&APP_ID.:689:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-page-feedback'
,p_list_text_01=>'Export feedback provided by application users in this workspace.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(4117748652625154)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'REST Source Catalog'
,p_list_item_link_target=>'f?p=&APP_ID.:1965:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-sc-data-references'
,p_list_text_01=>'Export REST Source Catalogs to be imported into other workspaces.'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/export_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(486307715596288607)
,p_name=>'export tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(486307910526288621)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Export Repository'
,p_list_item_link_target=>'f?p=&APP_ID.:73:&SESSION.:'
,p_list_item_current_for_pages=>'73'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(486308216101288623)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Import'
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.:'
,p_list_item_current_for_pages=>'460'
);
end;
/
prompt --application/shared_components/navigation/lists/ui_def_export_tabs
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(486427731138207743)
,p_name=>'ui def export tabs'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(486428118802213684)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Table Dictionary'
,p_list_item_link_target=>'f?p=&APP_ID.:479:&SESSION.::&DEBUG.:479:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'479'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(486428330923217163)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Attribute Dictionary'
,p_list_item_link_target=>'f?p=&APP_ID.:541:&SESSION.::&DEBUG.:541:::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'541'
);
end;
/
prompt --application/shared_components/navigation/lists/apex_5_help
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(488490120498750288)
,p_name=>'APEX 5 - Help'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(488490330263750290)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Documentation'
,p_list_item_link_target=>'&SYSTEM_HELP_URL.'
,p_list_text_01=>'helpLinkNewWindow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2105950689804969205)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Discussion Forum'
,p_list_item_link_target=>'https://apex.oracle.com/forum'
,p_list_text_01=>'helpLinkForum'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2185440048625469825)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Learn More about Oracle APEX'
,p_list_item_link_target=>'https://apex.oracle.com'
,p_list_text_01=>'helpLinkOTN'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1493545637548007510)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Getting Started in Page Designer'
,p_list_item_link_target=>'f?p=&APP_ID.:30:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXPRESSION'
,p_list_item_disp_condition=>':APP_ID = 4000 and :APP_PAGE_ID = 4500'
,p_list_item_disp_condition2=>'PLSQL'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(488495081334766183)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Shortcuts'
,p_list_item_link_target=>'#'
,p_list_text_01=>'keyboardShortcuts'
,p_list_text_03=>'true'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(488616497367046354)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'---'
,p_list_item_link_target=>'separator'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(488492468953750295)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'About'
,p_list_item_link_target=>'f?p=4350:9:&SESSION.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/application_utilities_other
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(492631804585583697)
,p_name=>'application.utilities.other'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492632127095590176)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Cross Page Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:553:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(404527353730174909)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Page Groups'
,p_list_item_link_target=>'f?p=&APP_ID.:520:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492632330558591213)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Region Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:853:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492632500560591999)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Button Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:852:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492632703677592889)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Item Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:854:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492632906448593646)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Computation Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:847:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(821538007832540402)
,p_list_item_display_sequence=>70
,p_list_item_link_text=>'Validation Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:851:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492633108872594367)
,p_list_item_display_sequence=>80
,p_list_item_link_text=>'Process Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:482:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492633311642595224)
,p_list_item_display_sequence=>90
,p_list_item_link_text=>'Dynamic Action Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:699:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492633614413596002)
,p_list_item_display_sequence=>100
,p_list_item_link_text=>'Branch Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:881:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/page_utilities_cross_page
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(492636810051679904)
,p_name=>'page.utilities.cross.page'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492638225897703413)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Grid Edit of all Pages'
,p_list_item_link_target=>'f?p=&APP_ID.:243:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492638629491713849)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Delete Multiple Pages'
,p_list_item_link_target=>'f?p=&APP_ID.:339:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492638421180711426)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Page Attributes'
,p_list_item_link_target=>'f?p=&APP_ID.:484:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(492639008497717241)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Page Locks'
,p_list_item_link_target=>'f?p=&APP_ID.:291:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/advisor_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(504056409460898231)
,p_name=>'Advisor Tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(504056630453898233)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Save as My Preferences'
,p_list_item_link_target=>'javascript:apex.submit(''SAVE_PREF'')'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_workspace_objects
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(525226966024198272)
,p_name=>'shared.components.workspace_objects'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(525227999285198277)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Static Workspace Files'
,p_list_item_link_target=>'f?p=&APP_ID.:312:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(525227596268198277)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Credentials'
,p_list_item_link_target=>'f?p=&APP_ID.:1620:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(525227186638198275)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'REST Enabled SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(533134053205118467)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Remote Servers'
,p_list_item_link_target=>'f?p=&APP_ID.:1931:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_remote_servers
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(533145899605135270)
,p_name=>'shared.components.remote_servers'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(533146052588135270)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Remote Servers'
,p_list_item_link_target=>'f?p=&APP_ID.:1931:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(533146454181135274)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Utilization'
,p_list_item_link_target=>'f?p=&APP_ID.:1933:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(533187009031297607)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'History'
,p_list_item_link_target=>'f?p=&APP_ID.:1934:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/home_page_get_started_list
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(583541659513985598)
,p_name=>'Home Page Get Started List'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(583609906498114141)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'Create a New App'
,p_list_item_link_target=>'f?p=&APP_ID.:56:&SESSION.::&DEBUG.:56:::'
,p_list_item_icon=>'icon-check-circle'
,p_list_text_01=>'Start building your first application in Oracle APEX.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(583541885189985600)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Install a Starter or Sample App'
,p_list_item_link_target=>'f?p=4750:50:&APP_SESSION.'
,p_list_item_icon=>'icon-util-install'
,p_list_text_01=>'Choose from over 20 sample and starter apps.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/remoteprintserver_create
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(608916658335678510)
,p_name=>'remoteprintserver.create'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(608916854583678511)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Add Remote Print Server'
,p_list_item_link_target=>'f?p=&APP_ID.:1935:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(608917221616678511)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Add Remote Print Server Credentials'
,p_list_item_link_target=>'f?p=&APP_ID.:1936:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/legacy_data_load_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(675812107017852883)
,p_name=>'LEGACY_DATA_LOAD_TASKS'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(675812305879852884)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Create Pages using this Legacy Data Load'
,p_list_item_link_target=>'f?p=&APP_ID.:1704:&SESSION.::&DEBUG.:1704,1706:F4000_P1700_NAME,P1700_EXISTS:&P1801_NAME.,yes:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_components
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(694733590452503217)
,p_name=>'shared.components.components'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(694734693779503223)
,p_list_item_display_sequence=>5
,p_list_item_link_text=>'Lists of Values'
,p_list_item_link_target=>'f?p=&APP_ID.:4110:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_LOVS.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(694735222077503223)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Plug-ins'
,p_list_item_link_target=>'f?p=&APP_ID.:4400:&SESSION.::&DEBUG.:RP:::'
,p_list_text_01=>'&P9_PLUGINS.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(694735518639503226)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Component Settings'
,p_list_item_link_target=>'f?p=&APP_ID.:4445:&SESSION.::&DEBUG.:RP:::'
,p_list_item_current_type=>'NEVER'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(697104363364517738)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Trees'
,p_list_item_link_target=>'f?p=&APP_ID.:28:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from   WWV_FLOW_TREES t',
'where  flow_id = :fb_flow_id ',
'   and security_group_id = :flow_security_group_id'))
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(694734925778503223)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Shortcuts'
,p_list_item_link_target=>'f?p=&APP_ID.:4047:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_SHORTCUTS.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(680965773582442489)
,p_list_item_display_sequence=>60
,p_list_item_link_text=>'Email Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:4860:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_text_01=>'&P9_EMAIL_TEMPLATES.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_application_logic
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(694736922570524377)
,p_name=>'shared.components.application_logic'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(694739304257531368)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Application Definition'
,p_list_item_link_target=>'f?p=&APP_ID.:4001:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(694737191989524378)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Application Items'
,p_list_item_link_target=>'f?p=&APP_ID.:4100:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_APP_ITEMS.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(694737422504524378)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Application Processes'
,p_list_item_link_target=>'f?p=&APP_ID.:4207:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_APP_PROCESSES.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(694737701535524378)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Application Computations'
,p_list_item_link_target=>'f?p=&APP_ID.:4101:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_APP_COMPUTATIONS.'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(659490721011613496)
,p_list_item_display_sequence=>45
,p_list_item_link_text=>'Application Settings'
,p_list_item_link_target=>'f?p=&APP_ID.:4850:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_APP_SETTINGS.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(2900257312389557)
,p_list_item_display_sequence=>49
,p_list_item_link_text=>'Automations'
,p_list_item_link_target=>'f?p=&APP_ID.:7020:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'NEVER'
,p_list_text_01=>'&P9_AUTOMATIONS.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(154811378368453381)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Build Options'
,p_list_item_link_target=>'f?p=&APP_ID.:4910:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_BUILD_OPTIONS.'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/shared_components_references
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(694855238818571795)
,p_name=>'shared.components.references'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(694857216757571796)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Data Load Definitions'
,p_list_item_link_target=>'f?p=&APP_ID.:1800:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_DATA_LOAD_DEFINITIONS.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(154069177738949720)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'REST Enabled SQL'
,p_list_item_link_target=>'f?p=&APP_ID.:1600:&SESSION.::&DEBUG.::::'
,p_list_text_03=>'has-arrow'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(226162637659581893)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'REST Data Sources'
,p_list_item_link_target=>'f?p=&APP_ID.:1901:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_REST_DATA_SOURCES.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(231826647978900986)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'REST Synchronization'
,p_list_item_link_target=>'f?p=&APP_ID.:1955:&SESSION.::&DEBUG.::::'
,p_list_text_01=>'&P9_REST_SYNCS.'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(694856635326571796)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Legacy Web Service References'
,p_list_item_link_target=>'f?p=&APP_ID.:170:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from WWV_FLOW_SHARED_WEB_SERVICES',
' where SECURITY_GROUP_ID = :flow_security_group_id ',
'   and FLOW_ID = :fb_flow_id'))
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/cross_application_reports
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(702923103587108064)
,p_name=>'Cross Application Reports'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702928892130158098)
,p_list_item_display_sequence=>1
,p_list_item_link_text=>'All Reports'
,p_list_item_link_target=>'f?p=&APP_ID.:9009:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'182'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702923320676108064)
,p_list_item_display_sequence=>110
,p_list_item_link_text=>'Application Attributes'
,p_list_item_link_target=>'f?p=&APP_ID.:9010:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-application-attributes'
,p_list_text_01=>'View component counts for each application.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9010'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702923966900108065)
,p_list_item_display_sequence=>120
,p_list_item_link_text=>'Build and App Status'
,p_list_item_link_target=>'f?p=&APP_ID.:103:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-app-status'
,p_list_text_01=>'Review the statuses for each application.'
,p_translate_list_text_y_n=>'Y'
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'103'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702924515837108067)
,p_list_item_display_sequence=>130
,p_list_item_link_text=>'Build Options'
,p_list_item_link_target=>'f?p=&APP_ID.:9012:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-build-options'
,p_list_text_01=>'View Build options across all applications.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'9012'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702923668978108065)
,p_list_item_display_sequence=>140
,p_list_item_link_text=>'Developer Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:380:&SESSION.::&DEBUG.:RP:::'
,p_list_item_icon=>'icon-util-comments'
,p_list_text_01=>'Review comments from all applications.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'380'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702924262274108066)
,p_list_item_display_sequence=>150
,p_list_item_link_text=>'Comments Calendar'
,p_list_item_link_target=>'f?p=&APP_ID.:665:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'icon-util-comments-calendar'
,p_list_text_01=>'View when all comments were created.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'665'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702925980864149602)
,p_list_item_display_sequence=>210
,p_list_item_link_text=>'Application Comparison'
,p_list_item_link_target=>'f?p=&APP_ID.:1300:&SESSION.:NORUN:&DEBUG.::::'
,p_list_text_01=>'Query differences in component names.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_for_pages=>'1300'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702926244508149602)
,p_list_item_display_sequence=>220
,p_list_item_link_text=>'Component Comparison'
,p_list_item_link_target=>'f?p=&APP_ID.:1301:&SESSION.:NORUN:&DEBUG.::::'
,p_list_text_01=>'Query differences in component counts.'
,p_translate_list_text_y_n=>'Y'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702926528050149602)
,p_list_item_display_sequence=>310
,p_list_item_link_text=>'Security Profiles'
,p_list_item_link_target=>'f?p=&APP_ID.:9014:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'9014'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702926833196149603)
,p_list_item_display_sequence=>320
,p_list_item_link_text=>'Authentication Schemes'
,p_list_item_link_target=>'f?p=&APP_ID.:9015:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'9015'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702927168153149603)
,p_list_item_display_sequence=>330
,p_list_item_link_text=>'Password Items'
,p_list_item_link_target=>'f?p=&APP_ID.:7777:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'7777'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(702927429794149604)
,p_list_item_display_sequence=>410
,p_list_item_link_text=>'Theme Summary'
,p_list_item_link_target=>'f?p=&APP_ID.:737:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/developer_comments_navigation
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(784788000174894142)
,p_name=>'developer.comments.navigation'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(784788282093894144)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Developer Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:606:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'f?p=&APP_ID.:606:&SESSION.::&DEBUG.::::'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(784788561594894145)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Developer Comments Calendar'
,p_list_item_link_target=>'f?p=&APP_ID.:594:&SESSION.::&DEBUG.::::'
,p_list_item_current_for_pages=>'f?p=&APP_ID.:594:&SESSION.::&DEBUG.::::'
);
end;
/
prompt --application/shared_components/navigation/lists/developer_comments_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(786331487669013778)
,p_name=>'developer.comments.tasks'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(786331600475013783)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Delete Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:1237:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/app_builder_homepage_image_nav
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(787106333147859999)
,p_name=>'App Builder Homepage - Image Nav'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(787106515252860000)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Create'
,p_list_item_link_target=>'f?p=&APP_ID.:56:&SESSION.::&DEBUG.:56,103,104,106,130,131,35,227,3020,3000,3001:::'
,p_list_item_icon=>'app-builder-create-app'
,p_security_scheme=>wwv_flow_imp.id(12472323342703137)
,p_list_item_current_type=>'ALWAYS'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(787106820469860001)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Import'
,p_list_item_link_target=>'f?p=&APP_ID.:460:&SESSION.::&DEBUG.:460:P460_FILE_TYPE:FLOW_EXPORT:'
,p_list_item_icon=>'app-builder-import-app'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(787107719682860001)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Dashboard'
,p_list_item_link_target=>'f?p=&APP_ID.:160:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'admin-dashboards'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(787107428027860001)
,p_list_item_display_sequence=>50
,p_list_item_link_text=>'Workspace Utilities'
,p_list_item_link_target=>'f?p=&APP_ID.:182:&SESSION.::&DEBUG.::::'
,p_list_item_icon=>'apex-utilities'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
);
end;
/
prompt --application/shared_components/navigation/lists/delete_theme
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(1029750209782685847)
,p_name=>'delete.theme'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1029750412409686103)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Delete Theme'
,p_list_item_link_target=>'f?p=&APP_ID.:221:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1029750729764686109)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Confirm'
,p_list_item_link_target=>'f?p=&APP_ID.:229:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/replace_templates_from_different_application
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(1127562677974975992)
,p_name=>'Replace Templates From Different Application'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1127562895657976062)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Copy Templates From'
,p_list_item_link_target=>'f?p=&APP_ID.:220:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1127563065821976070)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Configure'
,p_list_item_link_target=>'f?p=&APP_ID.:222:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/new_comments
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(1284942185735713564)
,p_name=>'new comments'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1284942644091713566)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'View Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:1235:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1235'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1284942921905713567)
,p_list_item_display_sequence=>30
,p_list_item_link_text=>'Edit Comment'
,p_list_item_link_target=>'f?p=&APP_ID.:1236:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_list_item_disp_condition=>'1236'
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1236'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1284943266884713568)
,p_list_item_display_sequence=>40
,p_list_item_link_text=>'Delete Comments'
,p_list_item_link_target=>'f?p=&APP_ID.:1237:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'EXISTS'
,p_list_item_disp_condition=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from WWV_FLOW_APP_COMMENTS',
'where flow_id = :fb_flow_id',
'and security_group_id = :flow_security_group_id'))
,p_security_scheme=>wwv_flow_imp.id(12511519296310366)
,p_list_item_current_type=>'COLON_DELIMITED_PAGE_LIST'
,p_list_item_current_for_pages=>'1237,1238'
);
end;
/
prompt --application/shared_components/navigation/lists/plugin_create
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(1434105688733324411)
,p_name=>'plugin.create'
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1434105853379324421)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Method'
,p_list_item_link_target=>'f?p=&APP_ID.:4402:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1435745785714405537)
,p_list_item_display_sequence=>15
,p_list_item_link_text=>'Copy From'
,p_list_item_link_target=>'f?p=&APP_ID.:4404:&SESSION.::&DEBUG.::::'
,p_list_item_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_list_item_disp_condition=>'P4402_ACTION'
,p_list_item_disp_condition2=>'COPY'
,p_list_item_current_type=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1434106176547324425)
,p_list_item_display_sequence=>20
,p_list_item_link_text=>'Copy'
,p_list_item_link_target=>'f?p=&APP_ID.:4406:&SESSION.::&DEBUG.::::'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/shared_components/navigation/lists/template_utilization_tasks
begin
wwv_flow_imp_shared.create_list(
 p_id=>wwv_flow_imp.id(1598999842830947024)
,p_name=>'Template Utilization Tasks '
,p_list_status=>'PUBLIC'
);
wwv_flow_imp_shared.create_list_item(
 p_id=>wwv_flow_imp.id(1599000030969947024)
,p_list_item_display_sequence=>10
,p_list_item_link_text=>'Remove Unused Templates'
,p_list_item_link_target=>'f?p=&APP_ID.:46:&SESSION.:'
,p_list_item_current_type=>'TARGET_PAGE'
);
end;
/
prompt --application/plugin_settings
begin
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(233833500443227)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_STAR_RATING'
,p_attribute_01=>'fa-star'
,p_attribute_04=>'#VALUE#'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(970498439392559)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_CSS_CALENDAR'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(14848431076940926)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_YES_NO'
,p_attribute_01=>'Y'
,p_attribute_03=>'N'
,p_attribute_05=>'SWITCH_CB'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(92010790354572457)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_RICH_TEXT_EDITOR'
,p_attribute_01=>'N'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(99821115378888928)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_GEOCODED_ADDRESS'
,p_attribute_01=>'RELAX_HOUSE_NUMBER'
,p_attribute_02=>'N'
,p_attribute_03=>'POPUP:ITEM'
,p_attribute_04=>'default'
,p_attribute_06=>'LIST'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(174677809582024970)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.APEX.SPLITTER'
,p_attribute_01=>'Y'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(176117893097506806)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_SINGLE_CHECKBOX'
,p_attribute_01=>'Y'
,p_attribute_02=>'N'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(592208520316709428)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_DATE_PICKER_JET'
,p_attribute_01=>'MONTH-PICKER:YEAR-PICKER'
,p_attribute_02=>'VISIBLE'
,p_attribute_03=>'15'
,p_attribute_04=>'FOCUS'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1765072046903712054)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_DISPLAY_SELECTOR'
,p_attribute_01=>'N'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1831722437189993876)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'NATIVE_IR'
,p_attribute_01=>'IG'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(1917679704307940123)
,p_plugin_type=>'ITEM TYPE'
,p_plugin=>'NATIVE_COLOR_PICKER'
,p_attribute_01=>'FULL'
,p_attribute_02=>'POPUP'
);
wwv_flow_imp_shared.create_plugin_setting(
 p_id=>wwv_flow_imp.id(2010954470365119059)
,p_plugin_type=>'REGION TYPE'
,p_plugin=>'PLUGIN_COM.ORACLE.FLOTLINECHART2'
,p_attribute_01=>'3'
,p_attribute_02=>'1.333'
);
end;
/
prompt --application/shared_components/security/authorizations/user_may_edit_current_application
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(317822338466)
,p_name=>'User May Edit Current Application'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_security.user_is_internal then',
'   return true;',
'elsif wwv_flow_security.user_can_develop_flow(p_flow_id=>:FB_FLOW_ID) then',
'   return true;',
'else',
'   return false;',
'end if;'))
,p_error_message=>'The user &USER. does not have the privilege to edit the application in question.'
,p_reference_id=>786944233424207200
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_data_generator
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(1753774729792863)
,p_name=>'Flow: DATA_GENERATOR'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'DATA_GENERATOR'
,p_error_message=>'You are not authorized to use Data Generator in SQL Workshop'
,p_reference_id=>12480509677812756
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/dashboard_access
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(10593027526205581)
,p_name=>'Dashboard access'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return',
'    wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''ADMIN''',
'    )',
'    or wwv_flow_authorization.is_authorized_developer(',
'        p_developer_authorization => ''EDIT''',
'    );'))
,p_error_message=>'You are not authorized to access Dashboards and Monitor Activity.'
,p_reference_id=>786936829326142579
,p_caching=>'BY_USER_BY_SESSION'
,p_comments=>'Used to control access to Dashboards and Monitor Activity under Administration. Developers will have access when Builder is enabled, while Admins will always have access. Prompted by Bug 13859631.'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_create
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(12472323342703137)
,p_name=>'Flow: CREATE'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'CREATE'
,p_error_message=>'You are not allowed to create or delete applications'
,p_reference_id=>786942708067207200
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_edit
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(12510423405283164)
,p_name=>'Flow: EDIT'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>'You are not authorized to edit applications'
,p_reference_id=>12480509677812756
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_admin
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(12511519296310366)
,p_name=>'Flow: ADMIN'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'ADMIN'
,p_error_message=>'You are not authorized to administer applications'
,p_reference_id=>12511219858301010
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/developer_may_edit_page
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(34674432490821717)
,p_name=>'Developer may edit page'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_steps s',
' where flow_id = to_number(:FB_FLOW_ID)',
'   and id      = to_number(:FB_FLOW_PAGE_ID)',
'   and security_group_id = to_number(:WORKSPACE_ID)',
'   and not exists (',
'         select 1',
'           from wwv_flow_lock_page l',
'          where l.flow_id    = s.flow_id',
'            and l.object_id  = s.id',
'            and l.locked_by != :APP_USER )'))
,p_error_message=>'Page may not be edited by developer'
,p_reference_id=>786942462038207200
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/user_auth_to_access_schema
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(74725624313588476)
,p_name=>'User_auth_to_access_schema'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'from   wwv_flow_company_schemas c,',
'       wwv_flow_fnd_user u',
'where  c.security_group_id = :flow_security_group_id and',
'       u.security_group_id = :flow_security_group_id and',
'       u.user_name = :flow_user and',
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or',
'        instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0) and',
'        c.schema = :P391_SCHEMA'))
,p_error_message=>'You do not have access to the selected schema.'
,p_reference_id=>786944588379207201
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/user_has_edit_priv
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(74845831538733642)
,p_name=>'USER_HAS_EDIT_PRIV'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_security.user_can_develop_any_flow;'
,p_error_message=>'You have no privilege to edit applications.'
,p_reference_id=>786943988629207200
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/is_real_application_security_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(125788121598195155)
,p_name=>'Is Real Application Security enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_platform.get_preference(''ALLOW_RAS'')=''Y'';'
,p_error_message=>'Real Application Security is not enabled'
,p_reference_id=>786943379004207200
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_app_builder_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(178938910382761975)
,p_name=>'APEX 5.0 App Builder Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'EDIT'
,p_error_message=>'No privilege for attempted operation'
,p_reference_id=>786516029127697713
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_sql_workshop_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(178939331963761975)
,p_name=>'APEX 5.0 SQL Workshop Enabled'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'SQL'
,p_error_message=>'You are not authorized to use SQL Workshop'
,p_reference_id=>786516265251697717
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/apex_5_0_team_development_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(178939812163761988)
,p_name=>'APEX 5.0 Team Development enabled'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 ',
'from wwv_flow_companies w, ',
'        wwv_flow_fnd_user u',
'where nvl(w.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'' and ',
'      w.PROVISIONING_COMPANY_ID = :flow_security_group_id and',
'      u.security_group_id = :flow_security_group_id and',
'      u.USER_NAME = upper(:app_user) and',
'      nvl(u.ALLOW_TEAM_DEVELOPMENT_YN,''Y'') = ''Y'''))
,p_error_message=>'Team development not enabled for this workspace'
,p_reference_id=>786516861027697723
,p_caching=>'BY_USER_BY_PAGE_VIEW'
);
end;
/
prompt --application/shared_components/security/authorizations/sso_authentication
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(331660423436603298)
,p_name=>'SSO authentication'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>'return wwv_flow_authentication_dev.get_internal_authentication not in (''APEX'',''CLOUD_IDM'',''LDAP'',''DB'');'
,p_error_message=>'Builder SSO is not enabled'
,p_reference_id=>6738410669854771
,p_caching=>'BY_USER_BY_SESSION'
,p_comments=>wwv_flow_string.join(wwv_flow_t_varchar2(
'This authorization scheme checks whether the builder authentication can be used for single sign-on to workspaces. This includes SSO, header-based and LDAP authentication, but not',
'',
'  - APEX: login requires a workspace name',
'  - CLOUD_IDM: external login to IDM, but switching workspaces is not allowed, since the login is for a single tenant only'))
);
end;
/
prompt --application/shared_components/security/authorizations/attribute_dictionary_columns_defined
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(499915500493760557)
,p_name=>'Attribute Dictionary Columns Defined'
,p_scheme_type=>'NATIVE_EXISTS'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1 from wwv_flow_hnt_column_dict',
' where security_group_id = :FLOW_SECURITY_GROUP_ID'))
,p_error_message=>'There are no attributes define in the Attribute Dictionary.'
,p_reference_id=>786942219366207200
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/team_dev_file_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(692489888034486589)
,p_name=>'Team Dev File Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_team_file.team_dev_file_enabled then',
'   return true;',
'else',
'   return false;',
'end if;'))
,p_error_message=>'Access to this page requires team development files to be enabled.'
,p_reference_id=>786943600005207200
,p_caching=>'NOCACHE'
);
end;
/
prompt --application/shared_components/security/authorizations/flow_restful
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(802892920094782611)
,p_name=>'Flow: RESTFUL'
,p_scheme_type=>'PLUGIN_COM.ORACLE.APEX.DEVELOPER_AUTHORIZATION'
,p_attribute_01=>'RESTFUL'
,p_error_message=>'No privilege for attempted operation'
,p_reference_id=>786519856057734816
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/security/authorizations/developer_may_edit_supporting_object_script
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(857903402130335025)
,p_name=>'Developer may edit supporting object script'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'return wwv_flow_lock.user_can_edit_script (',
'    p_flow_id   => :FB_FLOW_ID,',
'    p_script_id => :P865_SCRIPT_ID,',
'    p_override  => :P865_MODE = ''NEW'' -- allow viewing if create',
'    );'))
,p_error_message=>'Script may not be edited by the developer.'
,p_caching=>'NOCACHE'
);
end;
/
prompt --application/shared_components/security/authorizations/service_requests_enabled
begin
wwv_flow_imp_shared.create_security_scheme(
 p_id=>wwv_flow_imp.id(917540220622028585)
,p_name=>'Service Requests Enabled'
,p_scheme_type=>'NATIVE_FUNCTION_BODY'
,p_attribute_01=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if wwv_flow_platform.get_preference(''SERVICE_REQUESTS_ENABLED'') = ''Y'' then',
'    return TRUE;',
'else',
'    return FALSE;',
'end if;'))
,p_error_message=>'No privilege for attempted operation.'
,p_reference_id=>786932326296107981
,p_caching=>'BY_USER_BY_SESSION'
);
end;
/
prompt --application/shared_components/navigation/navigation_bar
begin
wwv_flow_imp_shared.create_icon_bar_item(
 p_id=>wwv_flow_imp.id(1361802214166928)
,p_icon_sequence=>10
,p_icon_subtext=>'Workspace &COMPANY.'
,p_icon_target=>'#'
,p_icon_image_alt=>'Workspace &COMPANY.'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
wwv_flow_imp_shared.create_icon_bar_item(
 p_id=>wwv_flow_imp.id(331551200056558688)
,p_icon_sequence=>40
,p_icon_subtext=>'( <span style="text-decoration:underline;">Switch Workspace</span> )'
,p_icon_target=>'f?p=4550:20'
,p_icon_image_alt=>'Switch Workspace'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
,p_security_scheme=>wwv_flow_imp.id(331660423436603298)
);
wwv_flow_imp_shared.create_icon_bar_item(
 p_id=>wwv_flow_imp.id(39804528545736393)
,p_icon_sequence=>50
,p_icon_subtext=>'( <span style="text-decoration:underline;">Logout</span> )'
,p_icon_target=>'&LOGOUT_URL.'
,p_icon_image_alt=>'Logout'
,p_nav_entry_is_feedback_yn=>'N'
,p_begins_on_new_line=>'NO'
,p_cell_colspan=>1
);
end;
/
prompt --application/shared_components/logic/application_processes/returnnothing
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(26098116757095708)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'returnNothing'
,p_process_sql_clob=>'null;'
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
,p_process_comment=>'this is useful for setting item values where no return value is needed.'
);
end;
/
prompt --application/shared_components/logic/application_processes/p872_add_parameter
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(33555511200784610)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'P872_ADD_PARAMETER'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_collection.update_members(',
'  p_collection_name => wwv_flow.g_x01,',
'  p_seq => wwv_flow.g_f01,',
'  p_c001 => wwv_flow.g_f02,',
'  p_c002 => wwv_flow.g_f03,',
'  p_c003 => wwv_flow.g_f04,',
'  p_c004 => wwv_flow.g_f05,',
'  p_c005 => wwv_flow.g_f06 );',
'wwv_flow_collection.add_member(p_collection_name =>wwv_flow.g_x01, p_c004 =>''N'');'))
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/p875_test_rest
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(33809312666721107)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'P875_TEST_REST'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_f4000_util.test_legacy_rest_service (',
'    p_url             => wwv_flow.g_x01,',
'    p_proxy_override  => wwv_flow.g_x02,',
'    p_method          => wwv_flow.g_x03,',
'    p_username        => wwv_flow.g_x04,',
'    p_password        => wwv_flow.g_x05,',
'    p_body            => wwv_flow.g_x06,',
'    p_parm_name       => wwv_flow.g_f01,',
'    p_parm_value      => wwv_flow.g_f02,',
'    p_http_headers    => wwv_flow.g_f03,',
'    p_http_hdr_values => wwv_flow.g_f04 );'))
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'#SQLERRM#'
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/p872_remove_parameter
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(33980127084358949)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'P872_REMOVE_PARAMETER'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_collection.update_members(',
'  p_collection_name => wwv_flow.g_x01,',
'  p_seq => wwv_flow.g_f01,',
'  p_c001 => wwv_flow.g_f02,',
'  p_c002 => wwv_flow.g_f03,',
'  p_c003 => wwv_flow.g_f04,',
'  p_c004 => wwv_flow.g_f05,',
'  p_c005 => wwv_flow.g_f06 );',
'if nvl(wwv_flow.g_x03,''x'') != ''update'' then',
'  wwv_flow_collection.delete_member(wwv_flow.g_x01,wwv_flow.g_x02);',
'  wwv_flow_collection.resequence_collection(wwv_flow.g_x01);',
'else',
'  for c1 in (select c003',
'               from wwv_flow_collections',
'              where collection_name = wwv_flow.g_x01',
'                and seq_id = wwv_flow.g_x02 ) loop',
'    wwv_flow_collection.update_member(',
'      p_collection_name => wwv_flow.g_x01, ',
'      p_seq             => wwv_flow.g_x02,',
'      p_c001            => ''marked for delete'',',
'      p_c003            => c1.c003,',
'      p_c004            => ''D'' );',
'  end loop;',
'end if;'))
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/ajax_collect_clob
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(49827831510641638)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'AJAX_COLLECT_CLOB'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_code clob := empty_clob;',
'begin',
'   sys.dbms_lob.createtemporary( l_code, false, sys.dbms_lob.SESSION );',
'   for i in 1..wwv_flow.g_f01.count loop',
'        sys.dbms_lob.writeappend(l_code,length(wwv_flow.g_f01(i)),wwv_flow.g_f01(i));',
'    end loop;',
'apex_collection.create_or_truncate_collection(p_collection_name=>''CLOB_CONTENT'');',
'apex_collection.add_member(p_collection_name=>''CLOB_CONTENT'',p_clob001=>l_code);',
'sys.htp.prn(''SUCCESS'');',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/parse_report_query
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(59589024396402332)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'PARSE_REPORT_QUERY'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'  l_owner varchar2(4000)  := null;',
'  l_query varchar2(32767) := null;',
'  l_error varchar2(32767) := null;',
'begin',
'',
'  l_owner := wwv_flow_security.flow_owner ( ',
'     p_flow_id           =>:FB_FLOW_ID, ',
'     p_security_group_id =>:FLOW_SECURITY_GROUP_ID',
'  );',
'',
'  for c1 in (',
'    select clob001 ',
'    from wwv_flow_collections ',
'    where collection_name = ''REPORT_QUERY_TEMP''',
'  ) loop',
'    l_query := c1.clob001;',
'    l_error := wwv_flow_f4000_util.is_valid_report_query (',
'      p_plug_source      => l_query,',
'      p_plug_source_type => wwv_flow_region_native.c_sql_report,',
'      p_owner            => l_owner',
'    );',
'  end loop;',
'         ',
'  if l_error is null then',
'    sys.htp.p(''1''||wwv_flow_lang.system_message(''REPORT_QUERIES.VALID_QUERY''));',
'  else',
'    sys.htp.p(''0''||wwv_flow_utilities.striphtml(l_error));',
'  end if;',
'',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/spotlightindex
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(233703836072822139)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'spotlightIndex'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'wwv_flow_spotlight_dev.emit_spotlight_index(',
'    p_app_id           => wwv_flow.g_x01,',
'    p_get_apps_list    => wwv_flow.g_x02,',
'    p_is_page_designer => true);'))
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_processes/developertoolbar
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(241203394876147425)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'developerToolbar'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    wwv_flow_developer_toolbar.ajax;',
'    commit;',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_processes/get_plugin_sql_examples
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(468201615965604310)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'get_plugin_sql_examples'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    sys.htp.p (',
'        wwv_flow_plugin_dev.get_sql_examples (',
'            p_application_id => :FB_FLOW_ID,',
'            p_plugin_type    => wwv_flow.g_x01,',
'            p_plugin_name    => wwv_flow.g_x02 ) );',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/ajax_set_ui_mode
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(559208518059277022)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'ajax_set_ui_mode'
,p_process_sql_clob=>'wwv_flow_4000_ui.ajax_set_ui_mode;'
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>'MUST_NOT_BE_PUBLIC_USER'
);
end;
/
prompt --application/shared_components/logic/application_processes/theme_roller
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(1199152637279464946)
,p_process_sequence=>1
,p_process_point=>'ON_DEMAND'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'theme_roller'
,p_process_sql_clob=>wwv_flow_string.join(wwv_flow_t_varchar2(
'begin',
'    wwv_flow_theme_dev.theme_roller_ajax;',
'    commit;',
'end;'))
,p_process_clob_language=>'PLSQL'
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
);
end;
/
prompt --application/shared_components/logic/application_processes/set_flow_page
begin
wwv_flow_imp_shared.create_flow_process(
 p_id=>wwv_flow_imp.id(72694123644888753)
,p_process_sequence=>1
,p_process_point=>'ON_SUBMIT_BEFORE_COMPUTATION'
,p_process_type=>'NATIVE_PLSQL'
,p_process_name=>'set flow page'
,p_process_sql_clob=>'wwv_flow_f4000_util.set_flow_page;'
,p_process_clob_language=>'PLSQL'
,p_process_error_message=>'Error'
,p_process_when=>'1000,460,514,516,527,273,2100,2101,2102,2103,2104,2105,2106,2107,2108,2109,2111,2115,1500,163,56,176,189,433,447,448,451,454,458,494,495,496,3001,3002,3005,3020,49,57,8000,8101'
,p_process_when_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_security_scheme=>wwv_flow_imp.id(12510423405283164)
,p_process_comment=>'Used to set env when two browsers are working on different apps in the same session.  Prevents a wizard from creating a component in the wrong application.'
);
end;
/
prompt --application/shared_components/logic/application_items/ajax_temporary_item
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(6191718445268266)
,p_name=>'AJAX_TEMPORARY_ITEM'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/cascading_selectlist_item_1
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(187760430466726137)
,p_name=>'CASCADING_SELECTLIST_ITEM_1'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/company
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(323366420862)
,p_name=>'COMPANY'
,p_scope=>'GLOBAL'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
,p_item_comment=>'Prints workspace name referenced in page templates'
);
end;
/
prompt --application/shared_components/logic/application_items/f4000_check
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(137222915098326064)
,p_name=>'F4000_CHECK'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
,p_item_comment=>'Used to display system message "Check".'
);
end;
/
prompt --application/shared_components/logic/application_items/f4000_copy_to_theme
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(2461529447025552654)
,p_name=>'F4000_COPY_TO_THEME'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/f4000_cur_std_tab
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(49554522682292670)
,p_name=>'F4000_CUR_STD_TAB'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/f4000_find_label
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(2573484773802618001)
,p_name=>'F4000_FIND_LABEL'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/f4000_last_portal_view
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(201664305800188161)
,p_name=>'F4000_LAST_PORTAL_VIEW'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/f4000_last_view
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(46180307972)
,p_name=>'F4000_LAST_VIEW'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/f4000_p35_demo_flows
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(174779207867417973)
,p_name=>'F4000_P35_DEMO_FLOWS'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
,p_item_comment=>'an item used for demostrations'
);
end;
/
prompt --application/shared_components/logic/application_items/f4000_region_selected
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(60363923165055254)
,p_name=>'F4000_REGION_SELECTED'
,p_escape_on_http_output=>'N'
,p_item_comment=>'Used to dynamically compute button postions for that region'
);
end;
/
prompt --application/shared_components/logic/application_items/f4000_run
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(137215819075289336)
,p_name=>'F4000_RUN'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
,p_item_comment=>'Item used to display system message "Run".'
);
end;
/
prompt --application/shared_components/logic/application_items/f4000_run_edit_page
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(148405327096585472)
,p_name=>'F4000_RUN_EDIT_PAGE'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/fb_flow_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(40006855470898)
,p_name=>'FB_FLOW_ID'
,p_data_type=>'NUMBER'
,p_escape_on_http_output=>'N'
,p_item_comment=>'Identifies the flow.'
);
end;
/
prompt --application/shared_components/logic/application_items/fb_flow_name
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(40006856470899)
,p_name=>'FB_FLOW_NAME'
,p_escape_on_http_output=>'N'
,p_item_comment=>'Y'
);
end;
/
prompt --application/shared_components/logic/application_items/fb_flow_page_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(40006857470899)
,p_name=>'FB_FLOW_PAGE_ID'
,p_data_type=>'NUMBER'
,p_escape_on_http_output=>'N'
,p_item_comment=>'Identifies the flow page.'
);
end;
/
prompt --application/shared_components/logic/application_items/fb_theme_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(146658914296443870)
,p_name=>'FB_THEME_ID'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/fp_max_rows_per_page
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(76847111472614227)
,p_name=>'FP_MAX_ROWS_PER_PAGE'
,p_escape_on_http_output=>'N'
,p_item_comment=>'obsolete this item when you get a chance'
);
end;
/
prompt --application/shared_components/logic/application_items/fp_pref_show_information
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(76852381884625214)
,p_name=>'FP_PREF_SHOW_INFORMATION'
,p_escape_on_http_output=>'N'
,p_item_comment=>'obosolete this item when you get a chance'
);
end;
/
prompt --application/shared_components/logic/application_items/fsp_after_login_url
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(61573406162429920)
,p_name=>'FSP_AFTER_LOGIN_URL'
,p_escape_on_http_output=>'N'
,p_item_comment=>'Used by Custom2 authentication for deep linking support'
);
end;
/
prompt --application/shared_components/logic/application_items/g_bc_parent_label
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(4102236188852409)
,p_name=>'G_BC_PARENT_LABEL'
,p_protection_level=>'I'
,p_item_comment=>'Used to dynamically set the parent entry label in complex breadcrumb setups.'
);
end;
/
prompt --application/shared_components/logic/application_items/g_bc_parent_url
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(15520576343950350)
,p_name=>'G_BC_PARENT_URL'
,p_protection_level=>'I'
);
end;
/
prompt --application/shared_components/logic/application_items/g_parse_as_schema_override
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(3692062815389)
,p_name=>'G_PARSE_AS_SCHEMA_OVERRIDE'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/last_step
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(22788166245)
,p_name=>'LAST_STEP'
,p_escape_on_http_output=>'N'
,p_item_comment=>'Y'
);
end;
/
prompt --application/shared_components/logic/application_items/monitor_user
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(453606206)
,p_name=>'MONITOR_USER'
,p_escape_on_http_output=>'N'
,p_item_comment=>'Used by monitoring Utility'
);
end;
/
prompt --application/shared_components/logic/application_items/recent_pages
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(163678415474826275)
,p_name=>'RECENT_PAGES'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/theme_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(12973032052396511)
,p_name=>'THEME_ID'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/theme_next_page
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(52224418686048921)
,p_name=>'THEME_NEXT_PAGE'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/ui_schema
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(60734732002851561)
,p_name=>'UI_SCHEMA'
,p_protection_level=>'I'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/ui_table
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(60735102005852345)
,p_name=>'UI_TABLE'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/ui_table_id
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(114948426092978491)
,p_name=>'UI_TABLE_ID'
,p_protection_level=>'N'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_items/wizard_entry_page
begin
wwv_flow_imp_shared.create_flow_item(
 p_id=>wwv_flow_imp.id(106733613326936844)
,p_name=>'WIZARD_ENTRY_PAGE'
,p_escape_on_http_output=>'N'
);
end;
/
prompt --application/shared_components/logic/application_computations/company
begin
wwv_flow_imp_shared.create_flow_computation(
 p_id=>wwv_flow_imp.id(323368422455)
,p_computation_sequence=>10
,p_computation_item=>'COMPANY'
,p_computation_point=>'AFTER_LOGIN'
,p_computation_type=>'EXPRESSION'
,p_computation_language=>'PLSQL'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow.get_company_name;'
,p_compute_when=>'COMPANY'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>'Unable to compute workspace name.'
);
end;
/
prompt --application/shared_components/logic/application_computations/fb_flow_id
begin
wwv_flow_imp_shared.create_flow_computation(
 p_id=>wwv_flow_imp.id(40006858470900)
,p_computation_sequence=>1
,p_computation_item=>'FB_FLOW_ID'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'SET_ITEM_EQUAL_THIS_PREFERENCE'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'FB_FLOW_ID'
,p_compute_when_type=>'NEVER'
,p_computation_error_message=>'Unable to get preference for Application.'
);
end;
/
prompt --application/shared_components/logic/application_computations/fb_flow_page_id
begin
wwv_flow_imp_shared.create_flow_computation(
 p_id=>wwv_flow_imp.id(40006860470902)
,p_computation_sequence=>2
,p_computation_item=>'FB_FLOW_PAGE_ID'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'SET_ITEM_EQUAL_THIS_PREFERENCE'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'FB_FLOW_PAGE_ID'
,p_compute_when=>'FB_FLOW_PAGE_ID'
,p_compute_when_type=>'ITEM_IS_NULL'
,p_computation_error_message=>'Unable to get preference for app builder page ID.'
);
end;
/
prompt --application/shared_components/logic/application_computations/fb_flow_name
begin
wwv_flow_imp_shared.create_flow_computation(
 p_id=>wwv_flow_imp.id(40006859470901)
,p_computation_sequence=>3
,p_computation_item=>'FB_FLOW_NAME'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'EXPRESSION'
,p_computation_language=>'PLSQL'
,p_computation_processed=>'ON_NEW_INSTANCE'
,p_computation=>'wwv_flow_escape.html(v(''FB_FLOW_NAME''))'
,p_computation_error_message=>'Unable to determine application name.'
);
end;
/
prompt --application/shared_components/logic/application_computations/f4000_run
begin
wwv_flow_imp_shared.create_flow_computation(
 p_id=>wwv_flow_imp.id(137218026825301058)
,p_computation_sequence=>10
,p_computation_item=>'F4000_RUN'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'EXPRESSION'
,p_computation_language=>'PLSQL'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow_lang.system_message(''DEMO_APPLICATION.RUN'')'
);
end;
/
prompt --application/shared_components/logic/application_computations/f4000_check
begin
wwv_flow_imp_shared.create_flow_computation(
 p_id=>wwv_flow_imp.id(137224006571333058)
,p_computation_sequence=>10
,p_computation_item=>'F4000_CHECK'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'EXPRESSION'
,p_computation_language=>'PLSQL'
,p_computation_processed=>'REPLACE_EXISTING'
,p_computation=>'wwv_flow_lang.system_message(''F4500_CHECK'')'
);
end;
/
prompt --application/shared_components/logic/application_computations/f4000_last_portal_view
begin
wwv_flow_imp_shared.create_flow_computation(
 p_id=>wwv_flow_imp.id(201669928216192952)
,p_computation_sequence=>10
,p_computation_item=>'F4000_LAST_PORTAL_VIEW'
,p_computation_point=>'ON_NEW_INSTANCE'
,p_computation_type=>'STATIC_ASSIGNMENT'
,p_computation_processed=>'ON_NEW_INSTANCE'
,p_computation=>'page_definition'
);
end;
/
prompt --application/shared_components/logic/application_settings
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/standard
begin
null;
end;
/
prompt --application/shared_components/navigation/tabs/parent
begin
null;
end;
/
prompt --application/shared_components/user_interface/lovs/4500_ui_def_alignment_l_c_r
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(200094129140149873)
,p_lov_name=>'4500 UI DEF ALIGNMENT L.C.R'
,p_reference_id=>260501806598530292
,p_lov_query=>'.'||wwv_flow_imp.id(200094129140149873)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(441093505492065867)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Start'
,p_lov_return_value=>'L'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(441093315770065865)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Center'
,p_lov_return_value=>'C'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(441093715747065867)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'End'
,p_lov_return_value=>'R'
);
end;
/
prompt --application/shared_components/user_interface/lovs/4791_url_or_page
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(6718617245289867)
,p_lov_name=>'4791_URL_OR_PAGE'
,p_lov_query=>'.'||wwv_flow_imp.id(6718617245289867)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6718912393289869)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Create new edit page'
,p_lov_return_value=>'NEW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6719410796297458)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Page in this application'
,p_lov_return_value=>'FLOW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6719129689289872)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'URL'
,p_lov_return_value=>'URL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(598109125486803480)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Exclude Link Target'
,p_lov_return_value=>'NONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/9999_url_or_page
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(191802018719438597)
,p_lov_name=>'9999_URL_OR_PAGE'
,p_lov_query=>'.'||wwv_flow_imp.id(191802018719438597)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(191802221865438607)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Page in this Application'
,p_lov_return_value=>'FLOW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(191802417355438613)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'URL'
,p_lov_return_value=>'URL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(191803319328457621)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Javascript'
,p_lov_return_value=>'JAVASCRIPT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/advanced_upgrade_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(499502202331793325)
,p_lov_name=>'ADVANCED_UPGRADE_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(499502202331793325)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(499504213089793331)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Upgrade Text Item to Number Field'
,p_lov_return_value=>'NUMBER_FIELD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(499502630417793330)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Upgrade Date Picker to new Date Picker'
,p_lov_return_value=>'DATE_PICKER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(499504425018793331)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Change Required item attribute to Yes'
,p_lov_return_value=>'REQUIRED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/aggregate_by
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(167761011505168202)
,p_lov_name=>'AGGREGATE BY'
,p_lov_query=>'.'||wwv_flow_imp.id(167761011505168202)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(167761226870168212)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'SUM'
,p_lov_return_value=>'SUM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(167761407532168218)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'AVG'
,p_lov_return_value=>'AVG'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(167761632408168219)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'MIN'
,p_lov_return_value=>'MIN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(167761817557168219)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'MAX'
,p_lov_return_value=>'MAX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(167776619311284077)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'COUNT'
,p_lov_return_value=>'COUNT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/aggregate_function
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(49455515219053317)
,p_lov_name=>'AGGREGATE_FUNCTION'
,p_lov_query=>'.'||wwv_flow_imp.id(49455515219053317)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(49455814570053330)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Sum'
,p_lov_return_value=>'SUM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(49456006581053331)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Average'
,p_lov_return_value=>'AVG'
);
end;
/
prompt --application/shared_components/user_interface/lovs/aggregate_functions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(101016778607432389)
,p_lov_name=>'AGGREGATE_FUNCTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(101016778607432389)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(101017392766432406)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Count'
,p_lov_return_value=>'COUNT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(155331225296971782)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Count Distinct'
,p_lov_return_value=>'COUNT_DISTINCT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(155331592721974019)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Approx. Count Distinct'
,p_lov_return_value=>'APPROX_COUNT_DISTINCT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(155331898423975434)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Minimum'
,p_lov_return_value=>'MIN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(155332158908977182)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Maximum'
,p_lov_return_value=>'MAX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(101017723584432406)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Sum'
,p_lov_return_value=>'SUM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(155335855601993887)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Average'
,p_lov_return_value=>'AVG'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(166230555723037356)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Median'
,p_lov_return_value=>'MEDIAN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/alignment_l_c_r
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84702113000663314)
,p_lov_name=>'ALIGNMENT_L_C_R'
,p_lov_query=>'.'||wwv_flow_imp.id(84702113000663314)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84702319979663314)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'start'
,p_lov_return_value=>'LEFT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84702526646663315)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'center'
,p_lov_return_value=>'CENTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84702722814663315)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'end'
,p_lov_return_value=>'RIGHT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/all_items_page_and_application
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(194317808992054940)
,p_lov_name=>'ALL ITEMS (PAGE AND APPLICATION)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, name r',
'from wwv_flow_items',
'where security_group_id = :flow_security_group_id and',
'         flow_id = :fb_flow_id',
'union all',
'select name d, name r',
'from wwv_flow_step_items',
'where security_group_id = :flow_security_group_id and',
'         flow_id = :fb_flow_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/allow_page_repost
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84920132510743677)
,p_lov_name=>'ALLOW PAGE REPOST'
,p_lov_query=>'.'||wwv_flow_imp.id(84920132510743677)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84920305972743677)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'No - Prevent page from being re-posted'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84920515901743678)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Yes - Allow page to be re-posted'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/allowed_operations
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86630311100418314)
,p_lov_name=>'ALLOWED OPERATIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(86630311100418314)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88151603016962504)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Insert'
,p_lov_return_value=>'I'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88151802892962505)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Update'
,p_lov_return_value=>'U'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(605643319539148456)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Delete'
,p_lov_return_value=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/apex_end_users
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1741323331892226882)
,p_lov_name=>'APEX END USERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select user_name d, user_name r',
'from wwv_flow_fnd_user u',
'where security_group_id = :flow_security_group_id',
'and not exists (select null',
'                from wwv_flow_developers d',
'                where d.security_group_id = u.security_group_id',
'                and d.userid            = u.user_name',
'                and (instr(d.developer_role,''ADMIN'') > 0',
'                     or instr(d.developer_role,''EDIT'') > 0))',
'and nvl(u.account_locked,''N'') = ''N''',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/apex_views_filter_conditions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(200640422229340739)
,p_lov_name=>'APEX VIEWS FILTER CONDITIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(200640422229340739)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(200640620893340743)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'='
,p_lov_return_value=>'='
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(200640809968340743)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'!='
,p_lov_return_value=>'!='
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(200641025381340743)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'LIKE'
,p_lov_return_value=>'LIKE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(200641212319340743)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'NOT LIKE'
,p_lov_return_value=>'NOT LIKE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(200641411936340743)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'>'
,p_lov_return_value=>'>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(200641614080340743)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'<'
,p_lov_return_value=>'<'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(200642026032340743)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'IS NULL'
,p_lov_return_value=>'IS NULL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(193463382693188419)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'IS NOT NULL'
,p_lov_return_value=>'IS NOT NULL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_computation_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84926512995804334)
,p_lov_name=>'APP COMPUTATION TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(84926512995804334)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84927104623804335)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Expression'
,p_lov_return_value=>'EXPRESSION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84926706354804335)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Function Body'
,p_lov_return_value=>'FUNCTION_BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84926905769804335)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Item Value'
,p_lov_return_value=>'ITEM_VALUE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84927328096804335)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'SQL Query (return single value)'
,p_lov_return_value=>'QUERY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(484391218230836490)
,p_lov_disp_sequence=>45
,p_lov_disp_value=>'SQL Query (return colon separated value)'
,p_lov_return_value=>'QUERY_COLON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84927527354804336)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Set Item Equal to Preference'
,p_lov_return_value=>'SET_ITEM_EQUAL_THIS_PREFERENCE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84928121322804336)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Static Assignment'
,p_lov_return_value=>'STATIC_ASSIGNMENT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_diff_components
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(15166510896787111)
,p_lov_name=>'APP DIFF COMPONENTS'
,p_lov_query=>'.'||wwv_flow_imp.id(15166510896787111)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15166729440787257)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Page'
,p_lov_return_value=>'PAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15166920981787257)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Page Region'
,p_lov_return_value=>'PAGE.REGION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15167616090788599)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Page Item'
,p_lov_return_value=>'PAGE.ITEM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15214625580576733)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Page Button'
,p_lov_return_value=>'PAGE.BUTTON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15272703827450402)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Breadcrumb'
,p_lov_return_value=>'BREADCRUMB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15275406775489081)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Breadcrumb Entry'
,p_lov_return_value=>'BREADCRUMB.ENTRY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15280612335642113)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'List of Values'
,p_lov_return_value=>'LOV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15282816060662069)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'List of Values Entry'
,p_lov_return_value=>'LOV.ENTRY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15286423211730438)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Page Branch'
,p_lov_return_value=>'PAGE.BRANCH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15289020964767588)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Page Process'
,p_lov_return_value=>'PAGE.PROCESS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15405712412659795)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Navigation Bar Entry'
,p_lov_return_value=>'NAVBAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15407718009765502)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Page Validation'
,p_lov_return_value=>'PAGE.VALIDATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16035403732024287)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application Process'
,p_lov_return_value=>'APPLICATION.PROCESS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16049914242661216)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application Computation'
,p_lov_return_value=>'APPLICATION.COMPUTATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16051425979711899)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tab'
,p_lov_return_value=>'TAB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16053917069766164)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Parent Tab'
,p_lov_return_value=>'PARENT.TAB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16055929929798216)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application Item'
,p_lov_return_value=>'APPLICATION.ITEM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16057603787828581)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Build Option'
,p_lov_return_value=>'BUILD.OPTION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16059007512848565)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'List'
,p_lov_return_value=>'LIST'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16061027392939460)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'List Entry'
,p_lov_return_value=>'LIST.ENTRY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16063928309005945)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Shortcut'
,p_lov_return_value=>'SHORTCUT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16064814158030207)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tree'
,p_lov_return_value=>'TREE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16066121917117672)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Authentication Scheme'
,p_lov_return_value=>'AUTHENTICATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17120709519005837)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application Attribute'
,p_lov_return_value=>'APPLICATION.ATTRIBUTES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17177423445965489)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Report Column'
,p_lov_return_value=>'REPORT.COLUMN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17180127956042460)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Authorization Scheme'
,p_lov_return_value=>'AUTHORIZATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17181701739167324)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Theme'
,p_lov_return_value=>'THEME'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17182812400265020)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Page Template'
,p_lov_return_value=>'TEMPLATE.PAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23040505396709149)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Region Template'
,p_lov_return_value=>'TEMPLATE.REGION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23059602943831450)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'List Template'
,p_lov_return_value=>'TEMPLATE.LIST'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23060207099832682)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Label Template'
,p_lov_return_value=>'TEMPLATE.LABEL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23065614980853874)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Breadcrumb Template'
,p_lov_return_value=>'TEMPLATE.BREADCRUMB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23072813388938597)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Report Template'
,p_lov_return_value=>'TEMPLATE.REPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23111731368066835)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Calendar Template'
,p_lov_return_value=>'TEMPLATE.CALENDAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23112607258069299)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Popup List of Values Template'
,p_lov_return_value=>'TEMPLATE.POPUP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23114220071073019)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Button Template'
,p_lov_return_value=>'TEMPLATE.BUTTON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(27856206573040810)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Plug-in'
,p_lov_return_value=>'PLUGIN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(27856417308043979)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Data Loading'
,p_lov_return_value=>'DATA.LOADING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(27863524730206971)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Text Message'
,p_lov_return_value=>'TEXT.MESSAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(30579828593361171)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Web Service'
,p_lov_return_value=>'WEB.SERVICE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(101938626726557494)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Region Printing'
,p_lov_return_value=>'REGION PRINTING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(493071332668111886)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Page Computation'
,p_lov_return_value=>'PAGE.COMPUTATION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_extend_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84881512912473090)
,p_lov_name=>'APP EXTEND OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(84881512912473090)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84881732492473090)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'A blank page'))
,p_lov_return_value=>'PAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84881910860473091)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'A login page'))
,p_lov_return_value=>'LOGIN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84882130890473091)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'A page or application component'))
,p_lov_return_value=>'WIZARD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_extend_options2
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84884222524494810)
,p_lov_name=>'APP EXTEND OPTIONS2'
,p_lov_query=>'.'||wwv_flow_imp.id(84884222524494810)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84884418462494811)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'A blank page'))
,p_lov_return_value=>'PAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84884606421494811)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'A login page'))
,p_lov_return_value=>'LOGIN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84884814299494811)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'A page or application component'))
,p_lov_return_value=>'WIZARD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_groups_assigned_unassigned
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(92271115231446627)
,p_lov_name=>'APP GROUPS ASSIGNED UNASSIGNED'
,p_lov_query=>'.'||wwv_flow_imp.id(92271115231446627)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(92271314455446628)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'- All -'
,p_lov_return_value=>'0'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(92271714863446629)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Assigned'
,p_lov_return_value=>'ASSIGNED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(92271520282446629)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Unassigned'
,p_lov_return_value=>'UNASSIGNED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_print_server_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(6801471089410875)
,p_lov_name=>'APP PRINT SERVER TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(6801471089410875)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6802190151410888)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Native Printing'
,p_lov_return_value=>'NATIVE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6802558698410888)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Remote Print Server'
,p_lov_return_value=>'REMOTE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6801733822410887)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Use Instance Settings'
,p_lov_return_value=>'INSTANCE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_wizard_page_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(149548310855791684)
,p_lov_name=>'APP WIZARD PAGE TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(149548310855791684)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149548517242791690)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Blank page'
,p_lov_return_value=>'BLANK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149548725452791693)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Report page'
,p_lov_return_value=>'REPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149548909667791693)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Report with an edit form on a second page'
,p_lov_return_value=>'REPORTANDFORM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149549130170791694)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Editable Interactive Grid'
,p_lov_return_value=>'TABULARFORM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149549303695791694)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Form with insert, update and delete'
,p_lov_return_value=>'FORM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(147022416546025322)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Single page master detail'
,p_lov_return_value=>'MASTERDETAIL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(618762604165647502)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Chart page'
,p_lov_return_value=>'CHART'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(236361118648814472)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'List View Page'
,p_lov_return_value=>'LISTVIEW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(236361514982816147)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'List View with an edit form on the second page'
,p_lov_return_value=>'LISTVIEWANDFORM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_groups_and_unassigned_groups
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(91658312614512198)
,p_lov_name=>'APPLICATION GROUPS AND UNASSIGNED GROUPS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select group_name, id',
'  from (',
'select group_name, id, 2 ob',
'  from wwv_flow_application_groups ',
' where security_group_id = :flow_security_group_id ',
'union all',
'select ''- ''||wwv_flow_lang.system_message(''Unassigned'')||'' -'' group_name, -1 id, 1 ob',
'  from dual',
')',
'order by ob, group_name'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_logo_image_or_text
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(210991102136588089)
,p_lov_name=>'APPLICATION LOGO IMAGE OR TEXT'
,p_lov_query=>'.'||wwv_flow_imp.id(210991102136588089)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(210991321100588090)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Image'
,p_lov_return_value=>'I'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(210991511506588095)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Text'
,p_lov_return_value=>'T'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(238999874444009828)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Image and Text'
,p_lov_return_value=>'IT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(239000212173009829)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Custom'
,p_lov_return_value=>'C'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_status
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(461314228761951916)
,p_lov_name=>'APPLICATION STATUS'
,p_lov_query=>'.'||wwv_flow_imp.id(461314228761951916)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(461314410157951917)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Available'
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(461315009499955796)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Unavailable'
,p_lov_return_value=>'UNAVAILABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_themes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(60317311466182536)
,p_lov_name=>'APPLICATION THEMES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select theme_id||''. '' ||wwv_flow_escape.html(theme_name) d, theme_id',
'  from wwv_flow_themes',
' where flow_id = nvl(:P224_A, :fb_flow_id)',
'   and security_group_id = :flow_security_group_id',
' order by theme_id'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_themes_active
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(8544631431632408)
,p_lov_name=>'APPLICATION THEMES (ACTIVE)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select t.theme_id||''. '' ||t.theme_name as d,',
'       t.theme_id',
'  from wwv_flow_user_interfaces i,',
'       wwv_flow_themes t',
' where i.flow_id           = :FB_FLOW_ID',
'   and i.security_group_id = :WORKSPACE_ID',
'   and t.flow_id           = i.flow_id',
'   and t.theme_id          = i.theme_id',
'   and t.security_group_id = :WORKSPACE_ID',
' order by i.display_seq'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_compatibility_mode
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(207464823363457503)
,p_lov_name=>'APPLICATION.COMPATIBILITY_MODE'
,p_lov_query=>'.'||wwv_flow_imp.id(207464823363457503)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(48215073577260787)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'21.2 / 22.1'
,p_lov_return_value=>'21.2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(183105967630838029)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'19.2 / 20.1 / 20.2 / 21.1'
,p_lov_return_value=>'19.2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(218606250087580379)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'19.1'
,p_lov_return_value=>'19.1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(610184552140315733)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'5.1 / 18.1 / 18.2'
,p_lov_return_value=>'5.1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4967401114954788)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'5.0'
,p_lov_return_value=>'5.0'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(207465025563457504)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'4.2'
,p_lov_return_value=>'4.2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(207465319619457504)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'4.1'
,p_lov_return_value=>'4.1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(207465627664457504)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Pre 4.1'
,p_lov_return_value=>'4.0'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_menus
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(149605524191093671)
,p_lov_name=>'APPLICATION.MENUS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) name,',
'       id',
'from   wwv_flow_menus',
'where  flow_id = :fb_flow_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/applications
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(15049727442569349)
,p_lov_name=>'APPLICATIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'  from wwv_flow_visible_flows f',
' where f.build_status != ''RUN_AND_HIDDEN''',
' order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(100224418521422119)
,p_lov_name=>'APPLICATION_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||name d, id r',
'  from wwv_flows f',
' where security_group_id = 11 ',
'   and not exists ( select null',
'                      from wwv_flow_language_map',
'                     where translation_flow_id = f.id',
'                       and security_group_id = 11 )',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/application_view_mode
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84241428998396992)
,p_lov_name=>'APPLICATION_VIEW_MODE'
,p_lov_query=>'.'||wwv_flow_imp.id(84241428998396992)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84241625056396993)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Detail'
,p_lov_return_value=>'DETAIL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84241814483396993)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'List'
,p_lov_return_value=>'LIST'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_acl_groups
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(92479731157354006)
,p_lov_name=>'APP_ACL_GROUPS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select group_name d,',
'       id r',
'  from wwv_flow_fnd_user_groups',
' where security_group_id = :FLOW_SECURITY_GROUP_ID',
'   and flow_id           = :FB_FLOW_ID',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_auth_option
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1814979507688651821)
,p_lov_name=>'APP_AUTH_OPTION'
,p_lov_query=>'.'||wwv_flow_imp.id(1814979507688651821)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1814979824886651823)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Oracle APEX Accounts'
,p_lov_return_value=>'APEX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1814980014644651823)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Oracle Cloud Identity Management'
,p_lov_return_value=>'IDM'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>'wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM'''
,p_lov_disp_cond2=>'PLSQL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(288183120240134690)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'HTTP Header Variable'
,p_lov_return_value=>'HTTP_HEADER_VARIABLE'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>' wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_HHEAD'') = ''Y'''
,p_lov_disp_cond2=>'PLSQL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(288183408656134690)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'LDAP Directory'
,p_lov_return_value=>'LDAP'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>' wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_LDAP'') = ''Y'''
,p_lov_disp_cond2=>'PLSQL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(288183730099134690)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Oracle Application Server Single Sign-On'
,p_lov_return_value=>'IAS_SSO'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>' wwv_flow_platform.get_preference(''PKG_APP_AUTH_ALLOW_SSO'') = ''Y'''
,p_lov_disp_cond2=>'PLSQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_char_set
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86591912420238949)
,p_lov_name=>'APP_CHAR_SET'
,p_lov_query=>'.'||wwv_flow_imp.id(86591912420238949)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(87520523148833682)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (US-ASCII)'
,p_lov_return_value=>'US-ASCII'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(87520707773833682)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Unicode (UTF8)'
,p_lov_return_value=>'UTF8'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(87520910595833682)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Western (Windows-1252)'
,p_lov_return_value=>'Windows-1252'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(87521104177833683)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Western (iso-8859-1)'
,p_lov_return_value=>'iso-8859-1'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_computation_points
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(48425308522403722)
,p_lov_name=>'APP_COMPUTATION_POINTS'
,p_lov_query=>'.'||wwv_flow_imp.id(48425308522403722)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(48425626846403752)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'On New Instance (new session)'
,p_lov_return_value=>'ON_NEW_INSTANCE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(48425926823403752)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'After Authentication'
,p_lov_return_value=>'AFTER_LOGIN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(48426208730403756)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Before Header'
,p_lov_return_value=>'BEFORE_HEADER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(48426516073403756)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'After Header'
,p_lov_return_value=>'AFTER_HEADER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(48426820582403756)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Before Region(s)'
,p_lov_return_value=>'BEFORE_BOX_BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(48427107076403756)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'After Region(s)'
,p_lov_return_value=>'AFTER_BOX_BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(48427419682403756)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Before Footer'
,p_lov_return_value=>'BEFORE_FOOTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(48427721551403760)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'After Footer'
,p_lov_return_value=>'AFTER_FOOTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(48428021631403760)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'After Submit'
,p_lov_return_value=>'AFTER_SUBMIT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_copy_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84341526733632941)
,p_lov_name=>'APP_COPY_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(84341526733632941)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(171495412485960439)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'User Interface Themes'
,p_lov_return_value=>'THEMES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84341707833632941)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Lists of Values'
,p_lov_return_value=>'LOV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1435744414125343373)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Plug-Ins'
,p_lov_return_value=>'PLUGIN'
,p_required_patch=>wwv_flow_imp.id(170786031904296885)
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84341922244632941)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Navigation Bar Entries'
,p_lov_return_value=>'NAVBAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84342129977632942)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Authorization Schemes'
,p_lov_return_value=>'AUTHORIZATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(106274302385250184)
,p_lov_disp_sequence=>1040
,p_lov_disp_value=>'Authentication Schemes'
,p_lov_return_value=>'AUTHENTICATION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_item_scope
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(211617631947367477)
,p_lov_name=>'APP_ITEM_SCOPE'
,p_lov_query=>'.'||wwv_flow_imp.id(211617631947367477)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(211617908937367477)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Application'
,p_lov_return_value=>'APP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(211618207033367479)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Global'
,p_lov_return_value=>'GLOBAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_populate_roles
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(177081808679947721)
,p_lov_name=>'APP_POPULATE_ROLES'
,p_lov_query=>'.'||wwv_flow_imp.id(177081808679947721)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(177082156363947748)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Access Control User Role Assignments'
,p_lov_return_value=>'R'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(177082551234947749)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Authentication Scheme'
,p_lov_return_value=>'A'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(177082986222947749)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Custom Code'
,p_lov_return_value=>'C'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(367839101511546508)
,p_lov_name=>'APP_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(367839101511546508)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(367839421855546509)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Standard Application'
,p_lov_return_value=>'STANDARD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(367839606331546509)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Application Template'
,p_lov_return_value=>'TEMPLATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(367839807571546510)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Sample Application'
,p_lov_return_value=>'SAMPLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_web_sources_for_reports
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3852199756927887)
,p_lov_name=>'APP_WEB_SOURCES_FOR_REPORTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'  from wwv_flow_web_src_modules m',
' where flow_id           = :FB_FLOW_ID',
'   and security_group_id = :WORKSPACE_ID',
'   and exists ( select 1 ',
'                  from wwv_flow_web_src_operations',
'                 where web_src_module_id = m.id',
'                   and database_operation = ''FETCH_COLLECTION'' )',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_wiz_chart_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(161900516722838362)
,p_lov_name=>'APP_WIZ_CHART_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(161900516722838362)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161900809488838368)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'3D Column'
,p_lov_return_value=>'3DColumn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(618825618287796251)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'3D Range Column'
,p_lov_return_value=>'Range3DColumn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(617394520554093313)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'3D Stacked Column'
,p_lov_return_value=>'Stacked3DColumn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(617394723671094261)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'3D Stacked Column (Percent)'
,p_lov_return_value=>'3DSTACKED_PCT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161901023475838370)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'2D Column'
,p_lov_return_value=>'2DColumn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(618825824520798054)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'2D Range Column'
,p_lov_return_value=>'Range2DColumn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(617394927827095426)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'2D Stacked Column'
,p_lov_return_value=>'Stacked2DColumn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(615715300950879723)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'3D Bar Chart'
,p_lov_return_value=>'Horizontal3DColumn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(617395131982096613)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'2D Stacked Column (Percent)'
,p_lov_return_value=>'2DSTACKED_PCT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(618826103873801635)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'3D Range Bar Chart'
,p_lov_return_value=>'HorizontalRange3DColumn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(617404612290119346)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'3D Stacked Bar Chart'
,p_lov_return_value=>'StackedHorizontal3DColumn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(617404817138120730)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'3D Stacked Bar Chart (Percent)'
,p_lov_return_value=>'3DHSTACKED_PCT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(615715506838881495)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'2D Bar Chart'
,p_lov_return_value=>'Horizontal2DColumn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(618826408029802793)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'2D Range Bar Chart'
,p_lov_return_value=>'HorizontalRange2DColumn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(617405825103123010)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'2D Stacked Bar Chart'
,p_lov_return_value=>'StackedHorizontal2DColumn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(617406029951124372)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'2D Stacked Bar Chart (Percent)'
,p_lov_return_value=>'2DHSTACKED_PCT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(615716321729885785)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'Line'
,p_lov_return_value=>'2DLine'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(618826615301804931)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>'Scatter Marker'
,p_lov_return_value=>'ScatterMarker'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(615715710647882561)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>'3D Pie'
,p_lov_return_value=>'3DPie'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(615715914110883599)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'2D Pie'
,p_lov_return_value=>'2DPie'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(615716117573884523)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>'2D Doughnut'
,p_lov_return_value=>'2DDoughnut'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(615716629694888045)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>'Dial'
,p_lov_return_value=>'GaugeChart'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(618827129500808965)
,p_lov_disp_sequence=>23
,p_lov_disp_value=>'Dial (Percent)'
,p_lov_return_value=>'DIAL_PCT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(618826920842806469)
,p_lov_disp_sequence=>24
,p_lov_disp_value=>'Candlestick'
,p_lov_return_value=>'Candlestick'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(618827332616809914)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>'Project Gantt'
,p_lov_return_value=>'ProjectGantt'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(618827502965810767)
,p_lov_disp_sequence=>26
,p_lov_disp_value=>'Resource Gantt'
,p_lov_return_value=>'ResourceGantt'
);
end;
/
prompt --application/shared_components/user_interface/lovs/app_wiz_create_mode
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(161818726905576357)
,p_lov_name=>'APP_WIZ_CREATE_MODE'
,p_lov_query=>'.'||wwv_flow_imp.id(161818726905576357)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161819017462576362)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Read Only'
,p_lov_return_value=>'R'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161819201423576364)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Read and Write'
,p_lov_return_value=>'RW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/audit_action
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(192763415498955359)
,p_lov_name=>'AUDIT ACTION'
,p_lov_query=>'.'||wwv_flow_imp.id(192763415498955359)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192763609015955370)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Insert'
,p_lov_return_value=>'I'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192763829535955373)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Update'
,p_lov_return_value=>'U'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192764030537955373)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Delete'
,p_lov_return_value=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/audit_naming
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(192773330531006109)
,p_lov_name=>'AUDIT_NAMING'
,p_lov_query=>'.'||wwv_flow_imp.id(192773330531006109)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192773504494006111)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Application Attributes'
,p_lov_return_value=>'WWV_FLOWS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192773719028006113)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Template'
,p_lov_return_value=>'WWV_FLOW_TEMPLATES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192773912582006113)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Navigation Bar'
,p_lov_return_value=>'WWV_FLOW_ICON_BAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192774132498006113)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Application Process'
,p_lov_return_value=>'WWV_FLOW_PROCESSING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192774324088006113)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Application Item'
,p_lov_return_value=>'WWV_FLOW_ITEMS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192774507402006114)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Application Computation'
,p_lov_return_value=>'WWV_FLOW_COMPUTATIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192774728974006114)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Tabs'
,p_lov_return_value=>'WWV_FLOW_TABS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192774924389006115)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Parent Tab'
,p_lov_return_value=>'WWV_FLOW_TOPLEVEL_TABS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192775116232006115)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'List of Values'
,p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES$'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192775308893006115)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'List of Values Entry'
,p_lov_return_value=>'WWV_FLOW_LISTS_OF_VALUES_DATA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192775506134006116)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Attributes'
,p_lov_return_value=>'WWV_FLOW_STEPS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192775729209006116)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Button'
,p_lov_return_value=>'WWV_FLOW_STEP_BUTTONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192775914488006116)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Branch'
,p_lov_return_value=>'WWV_FLOW_STEP_BRANCHES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192776105194006116)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Branch Arguments'
,p_lov_return_value=>'WWV_FLOW_STEP_BRANCH_ARGS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192776313341006117)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Item'
,p_lov_return_value=>'WWV_FLOW_STEP_ITEMS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192776518774006117)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Computation'
,p_lov_return_value=>'WWV_FLOW_STEP_COMPUTATIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192776728927006117)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Validation'
,p_lov_return_value=>'WWV_FLOW_STEP_VALIDATIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192776908821006117)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Process'
,p_lov_return_value=>'WWV_FLOW_STEP_PROCESSING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192777132334006118)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Region Template'
,p_lov_return_value=>'WWV_FLOW_PAGE_PLUG_TEMPLATES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192777326352006118)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Row Template'
,p_lov_return_value=>'WWV_FLOW_ROW_TEMPLATES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192777504961006118)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'List Template'
,p_lov_return_value=>'WWV_FLOW_LIST_TEMPLATES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192777704768006118)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Region Attributes'
,p_lov_return_value=>'WWV_FLOW_PAGE_PLUGS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192777913070006119)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Messages'
,p_lov_return_value=>'WWV_FLOW_MESSAGES$'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192778131775006119)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Build Options'
,p_lov_return_value=>'WWV_FLOW_PATCHES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192778311606006120)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Application Developers (Administration)'
,p_lov_return_value=>'WWV_FLOW_DEVELOPERS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192778526631006120)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Lists'
,p_lov_return_value=>'WWV_FLOW_LISTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192778710948006120)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'List Item'
,p_lov_return_value=>'WWV_FLOW_LIST_ITEMS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192778903034006120)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Effective User ID (Administration)'
,p_lov_return_value=>'WWV_FLOW_EFFECTIVE_USERID_MAP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192779106904006121)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Shortcuts'
,p_lov_return_value=>'WWV_FLOW_SHORTCUTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192779305727006121)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Item Help Text'
,p_lov_return_value=>'WWV_FLOW_STEP_ITEM_HELP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192779523562006121)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Authentication Setups'
,p_lov_return_value=>'WWV_FLOW_AUTHENTICATIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192779703226006121)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Entry Points'
,p_lov_return_value=>'WWV_FLOW_ENTRY_POINTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192779919153006122)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Entry Point Arguments'
,p_lov_return_value=>'WWV_FLOW_ENTRY_POINT_ARGS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192814127076119594)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Breadcrumb Entry'
,p_lov_return_value=>'WWV_FLOW_MENU_OPTIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192918929997948694)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Themes'
,p_lov_return_value=>'WWV_FLOW_THEMES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/auth_scheme_component_list
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(19565023708932258)
,p_lov_name=>'AUTH SCHEME COMPONENT LIST'
,p_lov_query=>'.'||wwv_flow_imp.id(19565023708932258)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4401945308904583)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Dynamic Action'
,p_lov_return_value=>'WWV_FLOW_PAGE_DA_EVENTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4402224443904585)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Dynamic Action - Action'
,p_lov_return_value=>'WWV_FLOW_PAGE_DA_ACTIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19565408576932259)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Application Computation'
,p_lov_return_value=>'WWV_FLOW_COMPUTATIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19565616823932259)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Navigation Bar Entry'
,p_lov_return_value=>'WWV_FLOW_ICON_BAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19565811243932259)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'List Entry'
,p_lov_return_value=>'WWV_FLOW_LIST_ITEMS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19566018968932260)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Breadcrumb'
,p_lov_return_value=>'WWV_FLOW_MENU_OPTIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19566229367932260)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Application Process'
,p_lov_return_value=>'WWV_FLOW_PROCESSING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19566425485932260)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Branch'
,p_lov_return_value=>'WWV_FLOW_STEP_BRANCHES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19566609500932260)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Button'
,p_lov_return_value=>'WWV_FLOW_STEP_BUTTONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19566827943932260)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Computation'
,p_lov_return_value=>'WWV_FLOW_STEP_COMPUTATIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19567024556932261)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Item'
,p_lov_return_value=>'WWV_FLOW_STEP_ITEMS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19567203422932261)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Process'
,p_lov_return_value=>'WWV_FLOW_STEP_PROCESSING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19567427523932261)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Validation'
,p_lov_return_value=>'WWV_FLOW_STEP_VALIDATIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19567631501932261)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Standard Tab'
,p_lov_return_value=>'WWV_FLOW_TABS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19567802034932262)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Parent Tab'
,p_lov_return_value=>'WWV_FLOW_TOPLEVEL_TABS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19568016566932263)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page'
,p_lov_return_value=>'WWV_FLOW_STEPS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19664501543326267)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Report Column'
,p_lov_return_value=>'WWV_FLOW_REGION_REPORT_COLUMN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(19664915179339682)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Region'
,p_lov_return_value=>'WWV_FLOW_PAGE_PLUGS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/authentication_methods2
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(62983620392370890)
,p_lov_name=>'AUTHENTICATION_METHODS2'
,p_lov_query=>'.'||wwv_flow_imp.id(62983620392370890)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(124262609673589368)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'SCHEME(ready-to-run or craft your own)'
,p_lov_return_value=>'CUSTOM2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62984185221370917)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'INTERNAL (local account repository)'
,p_lov_return_value=>'COOKIE'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/authentication_schemes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(166264006489001223)
,p_lov_name=>'AUTHENTICATION_SCHEMES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name as d,',
'       id   as r',
'  from wwv_flow_authentications',
' where flow_id           = :fb_flow_id',
'   and security_group_id = :WORKSPACE_ID',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/authentication_scheme_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(346988529123216543)
,p_lov_name=>'AUTHENTICATION_SCHEME_TYPE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,',
'       r',
'  from (',
'        select wwv_flow_lang.system_message(''AUTHENTICATION_NAME.''|| name_with_prefix) as d,',
'               name_with_prefix      as r',
'          from wwv_flow_native_plugins',
'         where plugin_type = ''AUTHENTICATION TYPE''',
'         union all',
'        select display_name || wwv_flow_lang.system_message(''PLUGIN.DISPLAY_NAME_POSTFIX'') as d,',
'               ''PLUGIN_'' || name     as r',
'          from wwv_flow_plugins',
'         where flow_id           = to_number(:FB_FLOW_ID)',
'           and security_group_id = to_number(:WORKSPACE_ID)',
'           and plugin_type       = ''AUTHENTICATION TYPE''',
'       )',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/authorization_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(11239432234132441)
,p_lov_name=>'AUTHORIZATION TYPE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,',
'       r',
'  from (',
'        select wwv_flow_lang.system_message(''AUTHORIZATION_NAME.''|| name_with_prefix) as d,',
'               name_with_prefix      as r',
'          from wwv_flow_native_plugins',
'         where plugin_type = ''AUTHORIZATION TYPE''',
'         union all',
'        select display_name || wwv_flow_lang.system_message(''PLUGIN.DISPLAY_NAME_POSTFIX'') as d,',
'               ''PLUGIN_'' || name     as r',
'          from wwv_flow_plugins',
'         where flow_id           = to_number(:FB_FLOW_ID)',
'           and security_group_id = to_number(:WORKSPACE_ID)',
'           and plugin_type       = ''AUTHORIZATION TYPE''',
'       )',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/authz_scheme_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84861720259380643)
,p_lov_name=>'AUTHZ_SCHEME_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(84861720259380643)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84861902602380643)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Exists SQL Query'
,p_lov_return_value=>'EXISTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84862521867380644)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'NOT Exists SQL Query'
,p_lov_return_value=>'NOT_EXISTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84862132654380644)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Item in Expression 1 is NULL'
,p_lov_return_value=>'ITEM_IS_NULL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84862305726380644)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Item in Expression1 is NOT NULL'
,p_lov_return_value=>'ITEM_IS_NOT_NULL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84862724485380644)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'PL/SQL Function Returning Boolean'
,p_lov_return_value=>'FUNCTION_RETURNING_BOOLEAN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84862924429380645)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Value of Preference in Expression 1 Equals Expression 2'
,p_lov_return_value=>'PREFERENCE_EQ_COND_TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84863130627380645)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Value of Preference in Expression 1 Does NOT Equal Expression 2'
,p_lov_return_value=>'PREFERENCE_NOT_EQ_COND_TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84863509444380645)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Value of item in Expression 1 Equals Expression 2'
,p_lov_return_value=>'VAL_OF_ITEM_IN_COND_EQ_COND_TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84863327213380645)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'Value of Item in Expression 1 Does NOT Equal Expression 2'
,p_lov_return_value=>'VAL_OF_ITEM_IN_COND_NOT_EQ_COND_TEXT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/auth_scheme_caching
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84860700520374929)
,p_lov_name=>'AUTH_SCHEME_CACHING'
,p_lov_query=>'.'||wwv_flow_imp.id(84860700520374929)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84861103921374931)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Once per session'
,p_lov_return_value=>'BY_USER_BY_SESSION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84860914895374930)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Once per page view'
,p_lov_return_value=>'BY_USER_BY_PAGE_VIEW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(360366921153074028)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Once per component'
,p_lov_return_value=>'BY_COMPONENT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(360367209904074033)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Always (No Caching)'
,p_lov_return_value=>'NOCACHE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/auth_scheme_refresh
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86574617605164667)
,p_lov_name=>'AUTH_SCHEME_REFRESH'
,p_lov_query=>'select wwv_flow_lang.system_message(''INITCAP_REFRESH'')  a,''Y'' b from dual'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/auth_wiz_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84347110372647083)
,p_lov_name=>'AUTH_WIZ_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(84347110372647083)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88152606479963512)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'From Scratch'
,p_lov_return_value=>'BLANK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88152800735963512)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'As a Copy of an Existing Authorization Scheme'
,p_lov_return_value=>'COPY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/automations
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1378606678543833)
,p_lov_name=>'AUTOMATIONS'
,p_source_type=>'TABLE'
,p_location=>'LOCAL'
,p_query_table=>'WWV_FLOW_AUTOMATIONS'
,p_return_column_name=>'ID'
,p_display_column_name=>'NAME'
,p_default_sort_column_name=>'NAME'
,p_default_sort_direction=>'ASC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/automation_all_result_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1356468048734066)
,p_lov_name=>'AUTOMATION_ALL_RESULT_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(1356468048734066)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1356737017734067)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Rows Returned'
,p_lov_return_value=>'ROWS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1357181724734067)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'No Rows Returned'
,p_lov_return_value=>'NO_ROWS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1357517577734067)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'PL/SQL returning boolean'
,p_lov_return_value=>'FUNC_BODY_RETURNING_BOOLEAN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1357960373734067)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Always'
,p_lov_return_value=>'ALWAYS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/automation_object_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1387977807801823)
,p_lov_name=>'AUTOMATION_OBJECT_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(1387977807801823)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1388285199801823)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Automation'
,p_lov_return_value=>'AUTOMATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1388637743801823)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Automation Action'
,p_lov_return_value=>'AUTOMATION ACTION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/automation_polling_status
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1358229692738259)
,p_lov_name=>'AUTOMATION_POLLING_STATUS'
,p_lov_query=>'.'||wwv_flow_imp.id(1358229692738259)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1358558106738259)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Active'
,p_lov_return_value=>'ACTIVE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1358916784738259)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Disabled'
,p_lov_return_value=>'DISABLED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1359379608738259)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Disabled (Error)'
,p_lov_return_value=>'ERROR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/automation_result_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(601105473256773090)
,p_lov_name=>'AUTOMATION_RESULT_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(601105473256773090)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601105601663773090)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Rows returned'
,p_lov_return_value=>'ROWS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601106078134773091)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'No Rows returned'
,p_lov_return_value=>'NO_ROWS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/automation_trigger_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1355426926728029)
,p_lov_name=>'AUTOMATION_TRIGGER_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(1355426926728029)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1355759872728032)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'On Demand'
,p_lov_return_value=>'API'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1356183046728033)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Scheduled'
,p_lov_return_value=>'POLLING'
);
end;
/
prompt --application/shared_components/user_interface/lovs/axis_interval
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84866925931391695)
,p_lov_name=>'AXIS_INTERVAL'
,p_lov_query=>'.'||wwv_flow_imp.id(84866925931391695)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84867111432391695)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Define axis interval'
,p_lov_return_value=>'DEFINE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84867324796391696)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Display axis interval automatically'
,p_lov_return_value=>'AUTO'
);
end;
/
prompt --application/shared_components/user_interface/lovs/Begin_on_new_line
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(67832807038215585)
,p_lov_name=>'BEGIN ON NEW LINE'
,p_lov_query=>'.'||wwv_flow_imp.id(67832807038215585)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(67833101831215595)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Beginning on New Line'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/Begin_on_new_field
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86067527340770119)
,p_lov_name=>'BEGIN_ON_NEW_FIELD'
,p_lov_query=>'.'||wwv_flow_imp.id(86067527340770119)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88282922464772458)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Beginning on New Field'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/blob_format_content_disposition_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(317509508537932808)
,p_lov_name=>'BLOB_FORMAT_CONTENT_DISPOSITION_TYPES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''BLOB_FORMAT_ATTACHMENT'') d, ''Attachment'' r',
'     from dual',
'union',
'select wwv_flow_lang.system_message(''BLOB_FORMAT_INLINE'') d, ''Inline'' r',
'     from dual'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/blob_format_mask_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(317502218630715477)
,p_lov_name=>'BLOB_FORMAT_MASK_TYPES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''BLOB_FORMAT_DOWNLOAD'') d, ''DOWNLOAD'' r',
'     from dual',
'union',
'select wwv_flow_lang.system_message(''BLOB_FORMAT_IMAGE'') d, ''IMAGE'' r',
'     from dual'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/branch_points_condensed
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(185544520425574805)
,p_lov_name=>'BRANCH.POINTS.CONDENSED'
,p_lov_query=>'.'||wwv_flow_imp.id(185544520425574805)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(185544824823574814)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Before Computation'
,p_lov_return_value=>'BEFORE_COMPUTATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(185545021461574815)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Before Validation'
,p_lov_return_value=>'BEFORE_VALIDATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(185545229692574815)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Before Processing'
,p_lov_return_value=>'BEFORE_PROCESSING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(185545414740574816)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'After Processing'
,p_lov_return_value=>'AFTER_PROCESSING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(185545628448574816)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Before Header'
,p_lov_return_value=>'BEFORE_HEADER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/breadcrumb_entry_or_container
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(205111517140679117)
,p_lov_name=>'BREADCRUMB ENTRY OR CONTAINER'
,p_lov_query=>'.'||wwv_flow_imp.id(205111517140679117)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(205111902995679137)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Breadcrumb'
,p_lov_return_value=>'BREADCRUMB'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(205345212580624072)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Breadcrumb Entry'
,p_lov_return_value=>'REGION'
,p_lov_template=>'#DISPLAY_VALUE#'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>'select 1 from wwv_flow_menus where flow_id = :fb_flow_id and security_group_id = :flow_security_group_id;'
);
end;
/
prompt --application/shared_components/user_interface/lovs/break_on_report_positions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(83332708448288963)
,p_lov_name=>'BREAK.ON.REPORT.POSITIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(83332708448288963)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88283729044774273)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'First Column'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88283921634774274)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'First and Second Columns'
,p_lov_return_value=>'1:2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88284111739774274)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'First, Second and Third column'
,p_lov_return_value=>'1:2:3'
);
end;
/
prompt --application/shared_components/user_interface/lovs/break_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86602811774267145)
,p_lov_name=>'BREAK_COLUMNS'
,p_lov_query=>'.'||wwv_flow_imp.id(86602811774267145)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88287205065786323)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Column 1'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88287428523786324)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Column 1 and 2'
,p_lov_return_value=>'1:2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88287603244786324)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Column 1, 2 and 3'
,p_lov_return_value=>'1:2:3'
);
end;
/
prompt --application/shared_components/user_interface/lovs/break_on_report_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84247004458418293)
,p_lov_name=>'BREAK_ON_REPORT_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(84247004458418293)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84247211888418294)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'First Column'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84247432172418294)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'First and Second Columns'
,p_lov_return_value=>'12'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84247624024418294)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'First, Second and Third Column'
,p_lov_return_value=>'123'
);
end;
/
prompt --application/shared_components/user_interface/lovs/break_type_flag
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84369008472684429)
,p_lov_name=>'BREAK_TYPE_FLAG'
,p_lov_query=>'.'||wwv_flow_imp.id(84369008472684429)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84369227840684431)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Repeat Headings on Break'
,p_lov_return_value=>'REPEAT_HEADINGS_ON_BREAK_1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84369407631684431)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Default Break Formatting'
,p_lov_return_value=>'DEFAULT_BREAK_FORMATTING'
);
end;
/
prompt --application/shared_components/user_interface/lovs/browser_cache
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(875788205897309215)
,p_lov_name=>'BROWSER_CACHE'
,p_lov_query=>'.'||wwv_flow_imp.id(875788205897309215)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(875788522508309218)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Enabled'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(875788730295309223)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Disabled'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/browser_frame
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1098055005642193053)
,p_lov_name=>'BROWSER_FRAME'
,p_lov_query=>'.'||wwv_flow_imp.id(1098055005642193053)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1098055323316193055)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Deny'
,p_lov_return_value=>'D'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1098055511785193055)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Allow from same origin'
,p_lov_return_value=>'S'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1098055725585193055)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Allow'
,p_lov_return_value=>'A'
);
end;
/
prompt --application/shared_components/user_interface/lovs/build_status
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84305510710571518)
,p_lov_name=>'BUILD_STATUS'
,p_lov_query=>'.'||wwv_flow_imp.id(84305510710571518)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84305709177571518)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Run Application Only'
,p_lov_return_value=>'RUN_ONLY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84305911098571518)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Run and Build Application'
,p_lov_return_value=>'RUN_AND_BUILD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_theme_class_id
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(43576623634636183)
,p_lov_name=>'BUTTON THEME CLASS ID'
,p_lov_query=>'.'||wwv_flow_imp.id(43576623634636183)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43576912701636189)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Button'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43584317316653265)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Button, Alternative 1'
,p_lov_return_value=>'4'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43584619394653936)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Button, Alternative 2'
,p_lov_return_value=>'5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(44139910490884391)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Button, Alternative 3'
,p_lov_return_value=>'2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43588706496669090)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 1'
,p_lov_return_value=>'6'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43592228791685003)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 2'
,p_lov_return_value=>'7'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43592532254685982)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 3'
,p_lov_return_value=>'8'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43592802256686769)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 4'
,p_lov_return_value=>'9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43593427883694186)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 5'
,p_lov_return_value=>'10'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43593729961694767)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 6'
,p_lov_return_value=>'11'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43594031692695331)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 7'
,p_lov_return_value=>'12'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43594301695696066)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 8'
,p_lov_return_value=>'13'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_attributes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(147003111936901406)
,p_lov_name=>'BUTTON.ATTRIBUTES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct rtrim(BUTTON_CATTRIBUTES ) ba, rtrim(BUTTON_CATTRIBUTES ) r',
'from   wwv_flow_step_buttons',
'where  flow_id = :fb_flow_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_is_reset
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84945521447891923)
,p_lov_name=>'BUTTON.IS.RESET'
,p_lov_query=>'.'||wwv_flow_imp.id(84945521447891923)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84945714043891924)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Button is Reset'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/buttons_current_and_global_page
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(6214918033450806)
,p_lov_name=>'BUTTONS_CURRENT_AND_GLOBAL_PAGE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select button_name,',
'       id',
'  from (',
'        /* all region buttons from current page and global page */',
'        select case when b.flow_step_id = ui.global_page_id then',
'                   wwv_flow_lang.system_message(''LAYOUT.GLOBAL_PAGE_REGION_PREFIX'')',
'               end ||',
'               b.button_name ||',
'               '' ('' || b.button_image_alt || '')'' as button_name,',
'               b.id,',
'               b.button_name bn,',
'               case when b.flow_step_id = ui.global_page_id then 2 else 1 end x',
'          from wwv_flow_steps p,',
'               wwv_flow_user_interfaces ui,',
'               wwv_flow_step_buttons b',
'         where p.flow_id      = :FB_FLOW_ID',
'           and p.id           = :FB_FLOW_PAGE_ID',
'           and ui.id          = p.user_interface_id',
'           and b.flow_id      = ui.flow_id',
'           and b.flow_step_id in (:FB_FLOW_PAGE_ID, ui.global_page_id)',
'         order by x, bn ',
'       )'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_action
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(458463318087925002)
,p_lov_name=>'BUTTON_ACTION'
,p_lov_query=>'.'||wwv_flow_imp.id(458463318087925002)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(458465032417938534)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Submit Page'
,p_lov_return_value=>'SUBMIT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(458463516386925008)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Redirect to Page in this Application'
,p_lov_return_value=>'REDIRECT_PAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(393410308299183569)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Redirect to Page in a different Application'
,p_lov_return_value=>'REDIRECT_APP'
,p_lov_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_lov_disp_cond=>'4314'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(458463707481925009)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Redirect to URL'
,p_lov_return_value=>'REDIRECT_URL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2217226943030013)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>'Defined by Dynamic Action'
,p_lov_return_value=>'DEFINED_BY_DA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(460984115025005702)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Download Printable Report Query'
,p_lov_return_value=>'REPORT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_SHARED_QUERIES',
' where flow_id = :fb_flow_id ',
'   and security_group_id = :flow_security_group_id',
'   and :APP_PAGE_ID = 4732'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3791885581293)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Reset Page'
,p_lov_return_value=>'RESET'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3791888582683)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Next Page (DEPRECATED)'
,p_lov_return_value=>'NEXT_PAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3791891583799)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Previous Page (DEPRECATED)'
,p_lov_return_value=>'PREVIOUS_PAGE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_alignment_body
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1791921829301402873)
,p_lov_name=>'BUTTON_ALIGNMENT_BODY'
,p_lov_query=>'.'||wwv_flow_imp.id(1791921829301402873)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1791928140531406086)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Center'
,p_lov_return_value=>'CENTER'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1791992121273442944)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Center bottom'
,p_lov_return_value=>'CENTER-BOTTOM'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1791992586609442944)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Center center'
,p_lov_return_value=>'CENTER-CENTER'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1791992941985442945)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Center top'
,p_lov_return_value=>'CENTER-TOP'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1791922115849402875)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Start'
,p_lov_return_value=>'LEFT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1791994711029455023)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Start bottom'
,p_lov_return_value=>'LEFT-BOTTOM'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1791995189708455023)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Start center'
,p_lov_return_value=>'LEFT-CENTER'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1791995570954455023)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Start top'
,p_lov_return_value=>'LEFT-TOP'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1791922578885402875)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'End'
,p_lov_return_value=>'RIGHT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1791995970458455024)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'End bottom'
,p_lov_return_value=>'RIGHT-BOTTOM'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1791996381262455024)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'End center'
,p_lov_return_value=>'RIGHT-CENTER'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1791996791436455025)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'End top'
,p_lov_return_value=>'RIGHT-TOP'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'F4000_P4314_BUTTON_POSITION'
,p_lov_disp_cond2=>'BODY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_alignment_l_r
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84754827158805413)
,p_lov_name=>'BUTTON_ALIGNMENT_L_R'
,p_lov_query=>'.'||wwv_flow_imp.id(84754827158805413)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84755030664805414)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Start'
,p_lov_return_value=>'LEFT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84755202951805414)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'End'
,p_lov_return_value=>'RIGHT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_display_positions2
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(62990572348595109)
,p_lov_name=>'BUTTON_DISPLAY_POSITIONS2'
,p_lov_query=>'.'||wwv_flow_imp.id(62990572348595109)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62990815665595115)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Before Page Title'
,p_lov_return_value=>'LEFT_OF_TITLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62991037953595115)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'After Page Title'
,p_lov_return_value=>'RIGHT_OF_TITLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62991212359595118)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Above Region'
,p_lov_return_value=>'ABOVE_BOX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62991440121595118)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Top of Region'
,p_lov_return_value=>'TOP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62991617521595119)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Bottom of Region'
,p_lov_return_value=>'BOTTOM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62991820415595119)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Top and Bottom of Region'
,p_lov_return_value=>'TOP_AND_BOTTOM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62992017822595122)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Below Region'
,p_lov_return_value=>'BELOW_BOX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62992218359595123)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Region Template #DEFAULT# Position'
,p_lov_return_value=>'TEMPLATE_DEFAULT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(92320911107933644)
,p_lov_disp_sequence=>9.5
,p_lov_disp_value=>'Region Template Position #CHANGE#'
,p_lov_return_value=>'REGION_TEMPLATE_CHANGE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where (p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CHANGE#'') > 0',
'   and :F4000_REGION_SELECTED = p.id) '))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62992810843595124)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Region Template Position #CLOSE#'
,p_lov_return_value=>'REGION_TEMPLATE_CLOSE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CLOSE#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93091020144798464)
,p_lov_disp_sequence=>10.1
,p_lov_disp_value=>'Region Template Position #COPY#'
,p_lov_return_value=>'REGION_TEMPLATE_COPY'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#COPY#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62992615015595124)
,p_lov_disp_sequence=>10.2
,p_lov_disp_value=>'Region Template Position #CREATE#'
,p_lov_return_value=>'REGION_TEMPLATE_CREATE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CREATE#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(94882719481696997)
,p_lov_disp_sequence=>10.3
,p_lov_disp_value=>'Region Template Position #CREATE2#'
,p_lov_return_value=>'REGION_TEMPLATE_CREATE2'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CREATE2#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(92332909801949409)
,p_lov_disp_sequence=>10.5
,p_lov_disp_value=>'Region Template Position #DELETE#'
,p_lov_return_value=>'REGION_TEMPLATE_DELETE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#DELETE#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62992414762595123)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Region Template Position #EDIT#'
,p_lov_return_value=>'REGION_TEMPLATE_EDIT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#EDIT#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62993052778595124)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Region Template Position #EXPAND#'
,p_lov_return_value=>'REGION_TEMPLATE_EXPAND'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#EXPAND#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62993213440595125)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Region Template Position #HELP#'
,p_lov_return_value=>'REGION_TEMPLATE_HELP'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#HELP#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91088720180648151)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Region Template Position #NEXT#'
,p_lov_return_value=>'REGION_TEMPLATE_NEXT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#NEXT#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91089316514649842)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Region Template Position #PREVIOUS#'
,p_lov_return_value=>'REGION_TEMPLATE_PREVIOUS'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#PREVIOUS#'') > 0',
'   and :F4000_REGION_SELECTED = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(138976531453546871)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'Right of Interactive Report Search Bar'
,p_lov_return_value=>'RIGHT_OF_IR_SEARCH_BAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(624319995418870652)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'Body'
,p_lov_return_value=>'BODY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_display_positions_p4314
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1905973109443967318)
,p_lov_name=>'BUTTON_DISPLAY_POSITIONS_P4314'
,p_lov_query=>'.'||wwv_flow_imp.id(1905973109443967318)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905973494553967321)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Before Page Title'
,p_lov_return_value=>'LEFT_OF_TITLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905973847440967326)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'After Page Title'
,p_lov_return_value=>'RIGHT_OF_TITLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905974225968967326)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Above Region'
,p_lov_return_value=>'ABOVE_BOX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905974643088967327)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Top of Region'
,p_lov_return_value=>'TOP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905975001534967328)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Bottom of Region'
,p_lov_return_value=>'BOTTOM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905975451050967328)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Top and Bottom of Region'
,p_lov_return_value=>'TOP_AND_BOTTOM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905975896920967328)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Below Region'
,p_lov_return_value=>'BELOW_BOX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905976264022967329)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Region Template #DEFAULT# Position'
,p_lov_return_value=>'TEMPLATE_DEFAULT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905976604330967330)
,p_lov_disp_sequence=>9.5
,p_lov_disp_value=>'Region Template Position #CHANGE#'
,p_lov_return_value=>'REGION_TEMPLATE_CHANGE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where (p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CHANGE#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id) '))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905977013205967330)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Region Template Position #CLOSE#'
,p_lov_return_value=>'REGION_TEMPLATE_CLOSE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CLOSE#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905977454417967330)
,p_lov_disp_sequence=>10.1
,p_lov_disp_value=>'Region Template Position #COPY#'
,p_lov_return_value=>'REGION_TEMPLATE_COPY'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#COPY#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905977884980967330)
,p_lov_disp_sequence=>10.2
,p_lov_disp_value=>'Region Template Position #CREATE#'
,p_lov_return_value=>'REGION_TEMPLATE_CREATE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CREATE#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905978269729967331)
,p_lov_disp_sequence=>10.3
,p_lov_disp_value=>'Region Template Position #CREATE2#'
,p_lov_return_value=>'REGION_TEMPLATE_CREATE2'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#CREATE2#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905978605947967331)
,p_lov_disp_sequence=>10.5
,p_lov_disp_value=>'Region Template Position #DELETE#'
,p_lov_return_value=>'REGION_TEMPLATE_DELETE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#DELETE#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905979000705967331)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Region Template Position #EDIT#'
,p_lov_return_value=>'REGION_TEMPLATE_EDIT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#EDIT#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905979400972967331)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Region Template Position #EXPAND#'
,p_lov_return_value=>'REGION_TEMPLATE_EXPAND'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#EXPAND#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905979808782967331)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Region Template Position #HELP#'
,p_lov_return_value=>'REGION_TEMPLATE_HELP'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#HELP#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905980225496967331)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Region Template Position #NEXT#'
,p_lov_return_value=>'REGION_TEMPLATE_NEXT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#NEXT#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905980687897967331)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Region Template Position #PREVIOUS#'
,p_lov_return_value=>'REGION_TEMPLATE_PREVIOUS'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from WWV_FLOW_PAGE_PLUG_TEMPLATES t,wwv_flow_page_plugs p',
' where p.flow_id = :FB_FLOW_ID',
'   and p.PLUG_TEMPLATE = t.id',
'   and sys.dbms_lob.instr(t.template,''#PREVIOUS#'') > 0',
'   and :F4000_P4314_BUTTON_PLUG_ID = p.id'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905981095145967332)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'Right of Interactive Report Search Bar'
,p_lov_return_value=>'RIGHT_OF_IR_SEARCH_BAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1905981421062967332)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'Body'
,p_lov_return_value=>'BODY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_style
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86073927602789091)
,p_lov_name=>'BUTTON_STYLE'
,p_lov_query=>'.'||wwv_flow_imp.id(86073927602789091)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88291012122797801)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'HTML Button'
,p_lov_return_value=>'HTML'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88291203722797802)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Template Based Button'
,p_lov_return_value=>'BUTTON_TEMPLATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88291406025797802)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Image'
,p_lov_return_value=>'IMAGE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_tag_attributes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(159064700887669967)
,p_lov_name=>'BUTTON_TAG_ATTRIBUTES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct TAG_ATTRIBUTES d, tag_attributes r',
'from wwv_flow_step_items',
'where flow_id = :fb_flow_id and DISPLAY_AS = ''BUTTON''',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_template
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86577503884170242)
,p_lov_name=>'BUTTON_TEMPLATE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(template_name) d, id r',
'from   wwv_flow_button_templates',
'where  flow_id = :fb_flow_id and',
'       (:fb_theme_id is null or theme_id = :fb_theme_id)',
'order by upper(template_name)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_template_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(287725102195676672)
,p_lov_name=>'BUTTON_TEMPLATE_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(287725102195676672)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(287725414983676674)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Normal'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(287725628953676674)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Hot'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/button_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86072317559786247)
,p_lov_name=>'BUTTON_TYPE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''HTML_BUTTON'') d,''TEXT'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''TEMPLATE_DRIVEN'') d, ''TEMPLATE'' r from dual where exists (select 1 from wwv_flow_button_templates where flow_id = :FB_FLOW_ID) ',
'union all',
'select initcap(wwv_flow_lang.system_message(''IMAGE'')) d,''IMAGE'' r from dual order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/cache_mode_page_and_region
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(22602312173782467)
,p_lov_name=>'CACHE_MODE (PAGE AND REGION)'
,p_lov_query=>'.'||wwv_flow_imp.id(22602312173782467)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(22602526326782467)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Disabled'
,p_lov_return_value=>'NOCACHE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(22602720414782468)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Enabled'
,p_lov_return_value=>'CACHE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(22602908361782468)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Cache By User'
,p_lov_return_value=>'USER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(672312620996057364)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Cache By Session'
,p_lov_return_value=>'SESSION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/caching_mode
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(225840272947805161)
,p_lov_name=>'CACHING_MODE'
,p_lov_query=>'.'||wwv_flow_imp.id(225840272947805161)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(225840584522805162)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'For all Users'
,p_lov_return_value=>'ALL_USERS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(225840998538805162)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'By User'
,p_lov_return_value=>'USER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(225841321120805163)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'By Session'
,p_lov_return_value=>'SESSION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/cal_display_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(37322928139444048)
,p_lov_name=>'CAL.DISPLAY_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(37322928139444048)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(37323215840444057)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Column'
,p_lov_return_value=>'COL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(37323417633444059)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Custom'
,p_lov_return_value=>'CUS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(37323623070444059)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'No Display Value'
,p_lov_return_value=>'NONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/calendar_item_link_open_in
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(412002629772063159)
,p_lov_name=>'CALENDAR ITEM LINK OPEN IN'
,p_lov_query=>'.'||wwv_flow_imp.id(412002629772063159)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(412002801622063164)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Same Window'
,p_lov_return_value=>'W'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(412003126365063165)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Popup Window'
,p_lov_return_value=>'P'
);
end;
/
prompt --application/shared_components/user_interface/lovs/calendar_theme_class_id
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(43619531898960304)
,p_lov_name=>'CALENDAR THEME CLASS ID'
,p_lov_query=>'.'||wwv_flow_imp.id(43619531898960304)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43619801874960319)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Calendar'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43621609988960339)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Calendar, Alternative 1'
,p_lov_return_value=>'2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(52331910898784713)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Small Calendar'
,p_lov_return_value=>'3'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43620000338960319)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 1'
,p_lov_return_value=>'4'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43620205626960337)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 2'
,p_lov_return_value=>'5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43620400113960337)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 3'
,p_lov_return_value=>'6'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43620604334960337)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 4'
,p_lov_return_value=>'7'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43620830451960338)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 5'
,p_lov_return_value=>'8'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43621023248960338)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 6'
,p_lov_return_value=>'9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43621201713960338)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 7'
,p_lov_return_value=>'10'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43621428586960338)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 8'
,p_lov_return_value=>'11'
);
end;
/
prompt --application/shared_components/user_interface/lovs/calendar_date_format
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(597767214994667976)
,p_lov_name=>'CALENDAR_DATE_FORMAT'
,p_lov_query=>'.'||wwv_flow_imp.id(597767214994667976)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(597767532504667980)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Only'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(597767714309667984)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Date and Time'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/calendar_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(113156910229994686)
,p_lov_name=>'CALENDAR_TYPE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''CONFIRM.STANDARD_CALENDAR'') d, ''S'' r from dual union all',
'select wwv_flow_lang.system_message(''CONFIRM.PARTIAL_REFRESH_CALENDAR'') d, ''A'' r from dual'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/cards_layout_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(12784439638072063)
,p_lov_name=>'CARDS_LAYOUT_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(12784439638072063)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(12785155574072076)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Grid'
,p_lov_return_value=>'GRID'
,p_lov_template=>'#DISPLAY_VALUE#| card-grid'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(12785568359072076)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Float'
,p_lov_return_value=>'FLOAT'
,p_lov_template=>'#DISPLAY_VALUE#| card-float'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(12785968016072076)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Horizontal (Row)'
,p_lov_return_value=>'ROW'
,p_lov_template=>'#DISPLAY_VALUE#| card-row'
);
end;
/
prompt --application/shared_components/user_interface/lovs/case_sensitive
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(574890434307383427)
,p_lov_name=>'CASE SENSITIVE'
,p_lov_query=>'.'||wwv_flow_imp.id(574890434307383427)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(574890771059383430)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Case sensitive'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/catalog_groups
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2707908862132331)
,p_lov_name=>'CATALOG_GROUPS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name as dv, id as rv',
'from WWV_WEB_SRC_CATALOG_GROUPS',
'where security_group_id = :WORKSPACE_ID',
'order by name'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_use_local_sync_table=>false
,p_query_table=>'WWV_WEB_SRC_CATALOG_GROUPS'
,p_return_column_name=>'RV'
,p_display_column_name=>'DV'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_bar_color
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84324431881606062)
,p_lov_name=>'CHART_BAR_COLOR'
,p_lov_query=>'.'||wwv_flow_imp.id(84324431881606062)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84324600310606063)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Black'
,p_lov_return_value=>'BLACK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84324819442606063)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Blue'
,p_lov_return_value=>'BLUE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84325003884606064)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Brown'
,p_lov_return_value=>'BROWN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84325217038606064)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Green'
,p_lov_return_value=>'GREEN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84325407670606064)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Orange'
,p_lov_return_value=>'ORANGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84325609277606064)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Purple'
,p_lov_return_value=>'PURPLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84325828072606065)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Red'
,p_lov_return_value=>'RED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84326022893606065)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Yellow'
,p_lov_return_value=>'YELLOW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_label_opts
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84785018266011049)
,p_lov_name=>'CHART_LABEL_OPTS'
,p_lov_query=>'.'||wwv_flow_imp.id(84785018266011049)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84785213250011049)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Show Bubble'
,p_lov_return_value=>'BUBBLE'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84785432162011050)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Show Value'
,p_lov_return_value=>'VALUE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_link_column
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(193530927208786945)
,p_lov_name=>'CHART_LINK_COLUMN'
,p_lov_query=>'.'||wwv_flow_imp.id(193530927208786945)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(193531126012786958)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Link to Custom Target'
,p_lov_return_value=>'C'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(193531303307786960)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Use Value of LINK Column'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_query_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2944917074050416)
,p_lov_name=>'CHART_QUERY_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(2944917074050416)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2945205253050420)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Perform query validation'
,p_lov_return_value=>'PARSE_CHART_QUERY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2945401126050421)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Save query without validation'
,p_lov_return_value=>'IGNORE_CHART_QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_theme
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84770023535917923)
,p_lov_name=>'CHART_THEME'
,p_lov_query=>'.'||wwv_flow_imp.id(84770023535917923)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84770217422917924)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Look 1'
,p_lov_return_value=>'RED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84770421612917924)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Look 2'
,p_lov_return_value=>'ARG'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84770630757917924)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Look 3'
,p_lov_return_value=>'LOOK_3'
);
end;
/
prompt --application/shared_components/user_interface/lovs/chart_wizard_dial_maxvalue
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(249428101086098299)
,p_lov_name=>'CHART_WIZARD_DIAL_MAXVALUE'
,p_lov_query=>'.'||wwv_flow_imp.id(249428101086098299)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(249428318833098301)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'100%'
,p_lov_return_value=>'0'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(249457015809140458)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'MAX'
,p_lov_return_value=>'MAX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(249457621350142006)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'SUM'
,p_lov_return_value=>'SUM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_show_page_components
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(145937328496747754)
,p_lov_name=>'CHECKBOX SHOW PAGE COMPONENTS'
,p_lov_query=>'.'||wwv_flow_imp.id(145937328496747754)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(145937826343747822)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Components'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_show_shared_components
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(144512500887046057)
,p_lov_name=>'CHECKBOX SHOW SHARED COMPONENTS'
,p_lov_query=>'.'||wwv_flow_imp.id(144512500887046057)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144512826218046101)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Shared Components'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_show_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(152029513350781444)
,p_lov_name=>'CHECKBOX SHOW TEMPLATES'
,p_lov_query=>'.'||wwv_flow_imp.id(152029513350781444)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(152029929235781496)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Templates'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_update_all_strings
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(149088633646846887)
,p_lov_name=>'CHECKBOX_UPDATE_ALL_STRINGS'
,p_lov_query=>'.'||wwv_flow_imp.id(149088633646846887)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(149088975938846888)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Update all &P704_COUNT. occurrences of this string'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_yes_noprompt
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84718210763776190)
,p_lov_name=>'CHECKBOX_YES_NOPROMPT'
,p_lov_query=>'.'||wwv_flow_imp.id(84718210763776190)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84718405875776191)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'&nbsp;'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/checkbox_y_noprompt
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84715102189754797)
,p_lov_name=>'CHECKBOX_Y_NOPROMPT'
,p_lov_query=>'.'||wwv_flow_imp.id(84715102189754797)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84715319258754797)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'&nbsp;'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/check_all
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84334521061621823)
,p_lov_name=>'CHECK_ALL'
,p_lov_query=>'.'||wwv_flow_imp.id(84334521061621823)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84334731772621824)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'&nbsp;'
,p_lov_return_value=>'CHECK'
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_heading_sort
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(113075615286820438)
,p_lov_name=>'COLUMN_HEADING_SORT'
,p_lov_query=>'.'||wwv_flow_imp.id(113075615286820438)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(113075923766820443)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Use Column Heading Sorting'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_link_checksum_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(106733132624028207)
,p_lov_name=>'COLUMN_LINK_CHECKSUM_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(106733132624028207)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(106733331539028208)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Application Level - Link reusable by any user'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(106733500292028209)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'User Level - Link reusable by current user'
,p_lov_return_value=>'2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84700223258656794)
,p_lov_name=>'COLUMN_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(84700223258656794)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84700401229656794)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Derived from query columns'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84700609402656795)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Generic columns'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/column_width_units
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(137868513981838198)
,p_lov_name=>'COLUMN_WIDTH_UNITS'
,p_lov_query=>'.'||wwv_flow_imp.id(137868513981838198)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(137868804503838258)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Percent'
,p_lov_return_value=>'PERCENTAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(137869020870838259)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Point'
,p_lov_return_value=>'POINTS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/comment_mgt
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(131122619933750813)
,p_lov_name=>'COMMENT MGT'
,p_lov_query=>'.'||wwv_flow_imp.id(131122619933750813)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(131122805830750820)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Delete all comments'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(131123017423750828)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Delete comments created by a developer'
,p_lov_return_value=>'DEVELOPER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(131123206286750828)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Delete comments by date'
,p_lov_return_value=>'DATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/component_export_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(377667910269420728)
,p_lov_name=>'COMPONENT EXPORT TYPES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select display_name, type_name',
'  from wwv_flow_appl_component_types',
' order by 1'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'TYPE_NAME'
,p_display_column_name=>'DISPLAY_NAME'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'DISPLAY_NAME'
,p_default_sort_direction=>'ASC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/component_export_types_no_app_attributes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(219174618713592113)
,p_lov_name=>'COMPONENT EXPORT TYPES (NO APP ATTRIBUTES)'
,p_lov_query=>'.'||wwv_flow_imp.id(219174618713592113)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(27856632677057884)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Plug-in'
,p_lov_return_value=>'PLUGIN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(27863315726204362)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Text Message'
,p_lov_return_value=>'MESSAGES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(42344010960230413)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Data Loading'
,p_lov_return_value=>'DATA LOADING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(68335292197942905)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Remote Server'
,p_lov_return_value=>'REMOTE SERVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(68335681892942906)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Credential'
,p_lov_return_value=>'CREDENTIAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88136025596580349)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Report Query'
,p_lov_return_value=>'SHARED QUERY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88136305988584229)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Report Layout'
,p_lov_return_value=>'REPORT LAYOUT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(160795105281345158)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'REST Data Source'
,p_lov_return_value=>'WEB SOURCE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219174814389592127)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'List'
,p_lov_return_value=>'LIST'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219175013995592129)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Breadcrumb'
,p_lov_return_value=>'BREADCRUMB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219175232752592129)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Button Template'
,p_lov_return_value=>'BUTTON TEMPLATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219175403520592129)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Region Template'
,p_lov_return_value=>'REGION TEMPLATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219175624120592129)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'List Template'
,p_lov_return_value=>'LIST TEMPLATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219175816990592129)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Report Template'
,p_lov_return_value=>'REPORT TEMPLATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219176032395592130)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Label Template'
,p_lov_return_value=>'LABEL TEMPLATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219176207318592130)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Breadcrumb Template'
,p_lov_return_value=>'BREADCRUMB TEMPLATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219176423240592130)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Popup List of Values Template'
,p_lov_return_value=>'POPUP LOV TEMPLATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219176631734592130)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Calendar Template'
,p_lov_return_value=>'CALENDAR TEMPLATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219176806484592131)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Shortcut'
,p_lov_return_value=>'SHORTCUTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219177013573592131)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Page Template'
,p_lov_return_value=>'PAGE TEMPLATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219177221576592131)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Page'
,p_lov_return_value=>'PAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219177427540592131)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tab'
,p_lov_return_value=>'TAB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219177604186592131)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'List of Values'
,p_lov_return_value=>'LOV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219177807693592132)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Parent Tab'
,p_lov_return_value=>'PARENT TAB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219178031878592132)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Navigation Bar Entry'
,p_lov_return_value=>'NAVBAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219178207428592132)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Authorization Scheme'
,p_lov_return_value=>'SECURITY SCHEME'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219178405025592132)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tree'
,p_lov_return_value=>'TREE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219178614268592132)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application Process'
,p_lov_return_value=>'APP PROCESS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219178830557592133)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application Item'
,p_lov_return_value=>'APP ITEM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219179018777592133)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application Computation'
,p_lov_return_value=>'APP COMPUTATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219179226730592133)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Breadcrumb Entry'
,p_lov_return_value=>'BREADCRUMB ENTRY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219179423538592133)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Web Service'
,p_lov_return_value=>'WEB SERVICE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219179610668592133)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Authentication Scheme'
,p_lov_return_value=>'AUTH SETUP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(219179805578592134)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Build Option'
,p_lov_return_value=>'BUILD OPTION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(683805038458933638)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application Setting'
,p_lov_return_value=>'APP SETTING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(727757877803458898)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application Access Control Role'
,p_lov_return_value=>'APP ACL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/computation_item
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86610204202293298)
,p_lov_name=>'COMPUTATION_ITEM'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''APPLICATION'')||'': ''||name d, name v',
'from wwv_flow_items',
'where flow_id = :FB_FLOW_ID',
'union all',
'select wwv_flow_lang.system_message(''PAGE'')||'': ''||flow_step_id||'' ''||name d, name v',
'from wwv_flow_step_items',
'where flow_id = :FB_FLOW_ID',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/condition_control_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(179476200494904933)
,p_lov_name=>'CONDITION CONTROL TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(179476200494904933)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179477608235904943)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Branch'
,p_lov_return_value=>'BRANCH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179492924267978066)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Button'
,p_lov_return_value=>'BUTTON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179477001828904942)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Computation'
,p_lov_return_value=>'COMPUTATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179476801795904940)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Item'
,p_lov_return_value=>'ITEM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179477429719904942)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Process'
,p_lov_return_value=>'PROCESS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179476625958904939)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Region'
,p_lov_return_value=>'REGION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179477227849904942)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Validation'
,p_lov_return_value=>'VALIDATION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/condition_check
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(435017812694464482)
,p_lov_name=>'CONDITION_CHECK'
,p_lov_query=>'.'||wwv_flow_imp.id(435017812694464482)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(435018014601464492)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Do not validate code (parse code at runtime only).'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/confirm_component_removal
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(54171005356999729)
,p_lov_name=>'CONFIRM_COMPONENT_REMOVAL'
,p_lov_query=>'.'||wwv_flow_imp.id(54171005356999729)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(54171311988999730)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Yes - remove components'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/consolidate_template_names_returning_id
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(94009001670849130)
,p_lov_name=>'CONSOLIDATE_TEMPLATE_NAMES RETURNING ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select page_plug_template_name d, id',
'from wwv_flow_page_plug_templates',
'where flow_id = :FB_FLOW_ID and ',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''REGION''',
'union all',
'select name d, id ',
'from WWV_FLOW_TEMPLATES ',
'where flow_id = :FB_FLOW_ID and ',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''PAGE''',
'union all',
'select template_name d, id',
'from wwv_flow_field_templates f',
'where ',
'f.flow_id = :FB_FLOW_ID and ',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''LABEL''',
'union all',
'select ',
'l.list_template_name d, l.id',
'from ',
'wwv_flow_list_templates l',
'where ',
'l.flow_id = :FB_FLOW_ID and',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''LIST''',
'union all',
'select name d, id',
'from wwv_flow_cal_templates',
'where flow_id = :FB_FLOW_ID and',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''CALENDAR''',
'union all',
'select name d, id',
'from wwv_flow_menu_templates',
'where flow_id = :FB_FLOW_ID and',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''MENU''',
'union all',
'select template_name d, id',
'from WWV_FLOW_BUTTON_TEMPLATES',
'where flow_id = :FB_FLOW_ID and',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''BUTTON''',
'union all',
'select ''* ''||wwv_flow_lang.system_message(''HTML_BUTTON'') d, -1 id',
'from dual',
'where :P708_TEMPLATE_TYPE = ''BUTTON''',
'union all',
'select ROW_TEMPLATE_NAME d, id',
'from WWV_FLOW_ROW_TEMPLATES',
'where flow_id = :FB_FLOW_ID and',
'THEME_ID = (select theme_id from wwv_flow_user_interfaces where id = 	:P708_USER_INTERFACE_ID and flow_id = :FB_FLOW_ID) and',
':P708_TEMPLATE_TYPE = ''REPORT''',
'union all',
'select ''* ''||wwv_flow_lang.system_message(''REGION_TEMPLATES_NO_TEMPLATE'') d, -1 id',
'from dual',
'where :P708_TEMPLATE_TYPE in (''PAGE'',''REGION'')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/content_delivery_network
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(16362507680404890)
,p_lov_name=>'CONTENT DELIVERY NETWORK'
,p_lov_query=>'.'||wwv_flow_imp.id(16362507680404890)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16362719475404893)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Google'
,p_lov_return_value=>'GOOGLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16362912968404893)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Microsoft'
,p_lov_return_value=>'MICROSOFT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16363119553404893)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'jQuery'
,p_lov_return_value=>'JQUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/content_disposition
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(137375920403903467)
,p_lov_name=>'CONTENT_DISPOSITION'
,p_lov_query=>'.'||wwv_flow_imp.id(137375920403903467)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(137376221863903468)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Attachment'
,p_lov_return_value=>'ATTACHMENT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(137376416435903468)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Inline'
,p_lov_return_value=>'INLINE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/copy_asynch_action_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(108520683650237775)
,p_lov_name=>'COPY ASYNCH ACTION OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(108520683650237775)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108520999008237765)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Asynchronous Action in this application'
,p_lov_return_value=>'SAME'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108521351556237764)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Asynchronous Action in another application'
,p_lov_return_value=>'DIFF'
);
end;
/
prompt --application/shared_components/user_interface/lovs/copy_list_option
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(231048823449529621)
,p_lov_name=>'COPY LIST OPTION'
,p_lov_query=>'.'||wwv_flow_imp.id(231048823449529621)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(231049006115529624)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'List in this application'
,p_lov_return_value=>'SAME'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(231049208911529628)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'List in another application'
,p_lov_return_value=>'DIFF'
);
end;
/
prompt --application/shared_components/user_interface/lovs/copy_lists
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(10919919806296646)
,p_lov_name=>'COPY LISTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) d, id ',
'  from wwv_flow_lists ',
' where flow_id                 = :FB_FLOW_ID',
'   and security_group_id       = :WORKSPACE_ID',
'   and id                      <> :P477_COPY_LIST_FROM',
'   and nvl(list_type,''STATIC'') = ''STATIC''',
'   and reference_id            is null',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/copy_page_option
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(200992128346618114)
,p_lov_name=>'COPY_PAGE_OPTION'
,p_lov_query=>'.'||wwv_flow_imp.id(200992128346618114)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(200992325093618118)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page in this application'
,p_lov_return_value=>'SAME'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(200992505592618121)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Page in another application'
,p_lov_return_value=>'DIFF'
);
end;
/
prompt --application/shared_components/user_interface/lovs/copy_sc_option
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(201061511357162008)
,p_lov_name=>'COPY_SC_OPTION'
,p_lov_query=>'.'||wwv_flow_imp.id(201061511357162008)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201061731765162010)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Do Not Copy'
,p_lov_return_value=>'NO'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201061913763162012)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Copy'
,p_lov_return_value=>'COPY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201062131688162012)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Use Existing'
,p_lov_return_value=>'EXISTING'
);
end;
/
prompt --application/shared_components/user_interface/lovs/copy_source
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(9000141896148406)
,p_lov_name=>'COPY_SOURCE'
,p_lov_query=>'.'||wwv_flow_imp.id(9000141896148406)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9000407308148423)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'This Application'
,p_lov_return_value=>'THIS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9000858936148423)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Other Application'
,p_lov_return_value=>'OTHER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_application_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(59753909083040661)
,p_lov_name=>'CREATE APPLICATION OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(59753909083040661)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40660315892684513)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'New Application'
,p_lov_return_value=>'DBAPP'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-app-builder'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84640459791812785)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'From a Spreadsheet'
,p_lov_return_value=>'SPREADSHEET'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-create-app-websheet'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(40660901478689821)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Productivity App'
,p_lov_return_value=>'PKGAPP'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-create-app-pkg-apps'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_application_page_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(139812219112455338)
,p_lov_name=>'CREATE APPLICATION PAGE TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(139812219112455338)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(139812423391455342)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Add blank page to application'
,p_lov_return_value=>'BLANK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(139813830194458580)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Add a report'
,p_lov_return_value=>'REPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(386128979761969541)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Add a reflow table report'
,p_lov_return_value=>'REFLOWTABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(386129452191973929)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Add a column toggle report'
,p_lov_return_value=>'COLUMNTOGGLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(139812618398455343)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Add a report with an edit form on a second page'
,p_lov_return_value=>'REPORTANDFORM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(228985906117785632)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>'Add a list view with an edit form on a second page'
,p_lov_return_value=>'LISTVIEWANDFORM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(139812820281455343)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Add an editable interactive grid'
,p_lov_return_value=>'TABULARFORM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(139813027803455343)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Add a form with insert, update and delete'
,p_lov_return_value=>'FORM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(111750431837325937)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Add a single page master detail'
,p_lov_return_value=>'MASTERDETAIL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(615632927102875004)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Add a Chart'
,p_lov_return_value=>'CHART'
,p_lov_disp_cond=>'(:APP_USER = ''HILARY'')'
,p_lov_disp_cond2=>'HILARY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(236338032309717022)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Add a list view'
,p_lov_return_value=>'LISTVIEW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_cal_type2
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(637546843740095966)
,p_lov_name=>'CREATE CAL TYPE2'
,p_lov_query=>'.'||wwv_flow_imp.id(637546843740095966)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(637547104132095967)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Legacy Calendar'
,p_lov_return_value=>'CALENDAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(637547448261095970)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Calendar'
,p_lov_return_value=>'CSSCALENDAR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_install_script_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(4579300425024699)
,p_lov_name=>'CREATE INSTALL SCRIPT OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(4579300425024699)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4579506061024700)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Create from Scratch'
,p_lov_return_value=>'SCRATCH'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-blank'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4579908206024701)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Create from File'
,p_lov_return_value=>'FILE'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-blank'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(534084776604619224)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Create from Database Object'
,p_lov_return_value=>'DB'
,p_lov_template=>'#DISPLAY_VALUE#| icon-database-object'
,p_lov_disp_cond_type=>'VALUE_OF_ITEM_IN_CONDITION_NOT_IN_COLON_DELIMITED_LIST'
,p_lov_disp_cond=>'P850_MODE'
,p_lov_disp_cond2=>'UPGRADE:DEINSTALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1602302547430022)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Data Package'
,p_lov_return_value=>'DATA'
,p_lov_template=>'#DISPLAY_VALUE#| icon-util-apex-views'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>'sys.dbms_db_version.version >= 18 and :P850_MODE not in (''UPGRADE'',''DEINSTALL'')'
,p_lov_disp_cond2=>'PLSQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_multiple_items_p256
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(162048107844243840)
,p_lov_name=>'CREATE MULTIPLE ITEMS P256'
,p_lov_query=>'.'||wwv_flow_imp.id(162048107844243840)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(162048426183243882)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Text Field'
,p_lov_return_value=>'TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(162048628552243882)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Textarea'
,p_lov_return_value=>'TEXTAREA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(162048825522243882)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Checkbox'
,p_lov_return_value=>'CHECKBOX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(162049013715243883)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Radio Group'
,p_lov_return_value=>'RADIOGROUP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(162049424562243883)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Hidden'
,p_lov_return_value=>'HIDDEN_PROTECTED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_app_auth_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(175155625648607577)
,p_lov_name=>'CREATE.APP.AUTH.OPTIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, v from (',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.CLOUD_IDM'') d ,''CLOUD_IDM'' v from dual',
'where wwv_flow_authentication_dev.get_internal_authentication = ''CLOUD_IDM''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''AUTHENTICATION_NAME.NATIVE_APEX_ACCOUNTS'')d ,:PRODUCT_NAME v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.SSO'') d ,''SSO'' v from dual',
'where wwv_flow_authentication_dev.can_use_sso_yn = ''Y''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.DBACCOUNT'') d,''DBACCOUNT'' v',
'from dual',
'where wwv_flow_authentication_dev.get_internal_authentication <> ''CLOUD_IDM''',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.NO_AUTH'') d,''DATABASE'' v from dual',
')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_cal_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(16354319751573808)
,p_lov_name=>'CREATE.CAL.TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(16354319751573808)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(389128299383656476)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Calendar'
,p_lov_return_value=>'CSSCALENDAR'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-CSS-CALENDAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(16354825012573816)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Legacy Calendar'
,p_lov_return_value=>'CALENDAR'
,p_lov_template=>'#DISPLAY_VALUE#|NATIVE-CALENDAR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_flow_auth_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(52256503410339865)
,p_lov_name=>'CREATE.FLOW.AUTH.OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(52256503410339865)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(52257006525339871)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Oracle APEX Authentication'
,p_lov_return_value=>'HTML DB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(52257200649339871)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'No Authentication'
,p_lov_return_value=>'DATABASE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_region_chart_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(59940502744006894)
,p_lov_name=>'CREATE.REGION.CHART.TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(59940502744006894)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(59940825061006894)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'HTML Chart<br /><a href="f?p=4000:4016:&SESSION.::::P4016_SOURCE_TYPE:SIMPLE_CHART"><img src="#IMAGE_PREFIX#wwv_example_chart.gif" alt=HTML Chart" height="115" width="140"></a>'
,p_lov_return_value=>'SIMPLE_CHART'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_tabs
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84948109242907300)
,p_lov_name=>'CREATE.TABS'
,p_lov_query=>'.'||wwv_flow_imp.id(84948109242907300)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84948313600907300)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'No Tabs'
,p_lov_return_value=>'NO_TABS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84948509310907301)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'One Level of Tabs'
,p_lov_return_value=>'SINGLE_LEVEL_TABS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84948706961907301)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Two Levels of Tabs'
,p_lov_return_value=>'TWO_LEVEL_TABS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_template_opts
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88108326304250090)
,p_lov_name=>'CREATE.TEMPLATE.OPTS'
,p_lov_query=>'.'||wwv_flow_imp.id(88108326304250090)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88108531928250090)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Choose one from the &PRODUCT_NAME. repository'
,p_lov_return_value=>'DEFAULT'
,p_lov_disp_cond_type=>'NEVER'
,p_lov_disp_cond=>'161'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88108720351250091)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'From Scratch'
,p_lov_return_value=>'BLANK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88108928823250091)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'As a Copy of an Existing Template'
,p_lov_return_value=>'COPY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_app_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(238931611476537918)
,p_lov_name=>'CREATE_APP_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(238931611476537918)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(238931830914537923)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Start from scratch'
,p_lov_return_value=>'SCRATCH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(24117720307079483)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Include Home Page'
,p_lov_return_value=>'INCLUDE_HOME'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(238932009935537927)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Use previously created application model'
,p_lov_return_value=>'MODEL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_button_loc
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84893616038549667)
,p_lov_name=>'CREATE_BUTTON_LOC'
,p_lov_query=>'.'||wwv_flow_imp.id(84893616038549667)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84894000323549667)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Create a button in a region position'
,p_lov_return_value=>'REGION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84893831137549667)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Create a button displayed among this region''s items'
,p_lov_return_value=>'ITEM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_edit_build_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84363508688675017)
,p_lov_name=>'CREATE_EDIT_BUILD_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(84363508688675017)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84363715344675017)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'All Options'
,p_lov_return_value=>'ALL_OPTIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84363903362675018)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Excluded Options'
,p_lov_return_value=>'EXCLUDED_OPTIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84364127083675018)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Included Options'
,p_lov_return_value=>'INCLUDED_OPTIONS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_page_wiz_report_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(229526604906633214)
,p_lov_name=>'CREATE_PAGE_WIZ_REPORT_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(229526604906633214)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(229526903566633217)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Interactive Report'
,p_lov_return_value=>'INTERACTIVE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(229527314006633219)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Classic Report'
,p_lov_return_value=>'CLASSIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(229527755815633220)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Report on Web Service'
,p_lov_return_value=>'WEBSERVICE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(246582799020000524)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Interactive Grid'
,p_lov_return_value=>'GRID'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2492748530737796)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Faceted Search'
,p_lov_return_value=>'FACETED_SEARCH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4700607937986792)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Cards'
,p_lov_return_value=>'CARD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1500806028588547)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>'Map'
,p_lov_return_value=>'MAP_REGION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4501933264264256)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Smart Filters'
,p_lov_return_value=>'SMART_FILTERS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/create_ws_auth_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(460639712672013129)
,p_lov_name=>'CREATE_WS_AUTH_OPTIONS'
,p_reference_id=>174618728240220381
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, v from (',
'select ',
'  :product_name||''<br />''||',
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/admin_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d ,''HTML DB'' v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.NO_AUTH'')||''<br />''||',
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/opendoor_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d,''DATABASE'' v from dual',
'union all',
'select ',
'  wwv_flow_lang.system_message(''CREATE_FLOW.DBACCOUNT'')||''<br />''||',
'  ''<img src="#IMAGE_PREFIX#htmldb/builder/dbauth_page_xl.gif" class="htmldbGreenIcon" width="140" height="115" >'' d,''DBACCOUNT'' v from dual)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/credentials_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(154078822199034715)
,p_lov_name=>'CREDENTIALS_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(154078822199034715)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(154079142215034718)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Basic Authentication'
,p_lov_return_value=>'BASIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(154079510909034719)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'OAuth2 Client Credentials Flow'
,p_lov_return_value=>'OAUTH2_CLIENT_CREDENTIALS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(549452051899386464)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'JSON Web Token'
,p_lov_return_value=>'JWT'
,p_required_patch=>wwv_flow_imp.id(170786031904296885)
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1341457865820980)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Oracle Cloud Infrastructure (OCI)'
,p_lov_return_value=>'OCI'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>'sys.dbms_db_version.version >= 18'
,p_lov_disp_cond2=>'PLSQL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1701546541659999)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Certificate/Private Key Pair'
,p_lov_return_value=>'CERTIFICATE_PAIR'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>'wwv_flow_platform.get_preference(''SAML_ENABLED'')=''Y'''
,p_lov_disp_cond2=>'PLSQL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1800745749591458)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'HTTP Header'
,p_lov_return_value=>'HTTP_HEADER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1801015961593233)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'URL Query String'
,p_lov_return_value=>'HTTP_QUERY_STRING'
);
end;
/
prompt --application/shared_components/user_interface/lovs/css_categories
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2672426264055159)
,p_lov_name=>'CSS CATEGORIES'
,p_lov_query=>'.'||wwv_flow_imp.id(2672426264055159)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2672601779055159)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Absolute Sizes'
,p_lov_return_value=>'ABSOLUTE SIZES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2672821707055159)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Relative Sizes'
,p_lov_return_value=>'RELATIVE SIZES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2686105588181625)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Anchor Tags'
,p_lov_return_value=>'ANCHOR TAGS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/current_page_only
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(574892035638384809)
,p_lov_name=>'CURRENT PAGE ONLY'
,p_lov_query=>'.'||wwv_flow_imp.id(574892035638384809)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(574892359277384813)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Current page only'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/customizable_opts
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84780904844988257)
,p_lov_name=>'CUSTOMIZABLE_OPTS'
,p_lov_query=>'.'||wwv_flow_imp.id(84780904844988257)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84781129653988258)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Customizable and Not Shown By Default'
,p_lov_return_value=>'2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84781315535988258)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Customizable and Shown By Default'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84781523668988259)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Not Customizable By End Users'
,p_lov_return_value=>'0'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dashboard_chart_aggregate
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(657384343573981564)
,p_lov_name=>'DASHBOARD_CHART_AGGREGATE'
,p_lov_query=>'.'||wwv_flow_imp.id(657384343573981564)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(657384641982981565)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Column Value'
,p_lov_return_value=>'COLVALUE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(657385056655981565)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Sum'
,p_lov_return_value=>'SUM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(657385482368981565)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Count'
,p_lov_return_value=>'COUNT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dashboard_chart_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(657346995959744232)
,p_lov_name=>'DASHBOARD_CHART_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(657346995959744232)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(657347261583744232)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Area'
,p_lov_return_value=>'area'
,p_lov_template=>'<span class="a-Icon icon-region-chart-area" aria-hidden="true"></span><span class="u-VisuallyHidden">#DISPLAY_VALUE#</span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(657347677252744233)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Bar'
,p_lov_return_value=>'bar'
,p_lov_template=>'<span class="a-Icon icon-region-chart-bar" aria-hidden="true"></span><span class="u-VisuallyHidden">#DISPLAY_VALUE#</span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(657350049661744234)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Line'
,p_lov_return_value=>'line'
,p_lov_template=>'<span class="a-Icon icon-region-chart-line" aria-hidden="true"></span><span class="u-VisuallyHidden">#DISPLAY_VALUE#</span>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(657350886473744235)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Pie'
,p_lov_return_value=>'pie'
,p_lov_template=>'<span class="a-Icon icon-region-chart-pie" aria-hidden="true"></span><span class="u-VisuallyHidden">#DISPLAY_VALUE#</span>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dashboard_layout
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(42907758825155833)
,p_lov_name=>'DASHBOARD_LAYOUT'
,p_lov_query=>'.'||wwv_flow_imp.id(42907758825155833)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(42908060078155834)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Primary and 2 secondary charts'
,p_lov_return_value=>'PRIMARY_2_SECONDARY'
,p_lov_template=>'#DISPLAY_VALUE#| dashboard-1-top-2-bottom'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(42908446519155834)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Grid of 4 charts'
,p_lov_return_value=>'4_GRIDS'
,p_lov_template=>'#DISPLAY_VALUE#| dashboard-2-top-2-bottom'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(42908853030155834)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Primary and 3 secondary charts'
,p_lov_return_value=>'PRIMARY_3_SECONDARY'
,p_lov_template=>'#DISPLAY_VALUE#| dashboard-1-top-3-bottom'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(49787787520832477)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Grid of 6 charts'
,p_lov_return_value=>'6_GRIDS'
,p_lov_template=>'#DISPLAY_VALUE#| dashboard-3-top-3-bottom'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_case_sensitivity_option
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(15543021487067885)
,p_lov_name=>'DATA LOAD CASE SENSITIVITY OPTION'
,p_lov_query=>'.'||wwv_flow_imp.id(15543021487067885)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15543516355067889)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'No'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15543328204067888)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Yes'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_skip_validation
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(380391855980609161)
,p_lov_name=>'DATA LOAD SKIP VALIDATION'
,p_lov_query=>'.'||wwv_flow_imp.id(380391855980609161)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(380392176743609168)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'No'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(380392454037609170)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Yes'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_table_names
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(371957315073004609)
,p_lov_name=>'DATA LOAD TABLE NAMES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select TABLE_NAME display_value, TABLE_NAME return_value ',
'from WWV_FLOW_LOAD_TABLES',
'where name = :P1801_NAME order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_loading_rules_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(141003727830690827)
,p_lov_name=>'DATA LOADING RULES TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(141003727830690827)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(141004022216690828)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'To Upper Case'
,p_lov_return_value=>'TO_UPPER_CASE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(141004200887690829)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'To Lower Case'
,p_lov_return_value=>'TO_LOWER_CASE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(141004413247690829)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Replace'
,p_lov_return_value=>'REPLACE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(141004630986690829)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Trim'
,p_lov_return_value=>'TRIM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(675452628395802315)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Left Trim'
,p_lov_return_value=>'LTRIM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(675463400475803720)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Right Trim'
,p_lov_return_value=>'RTRIM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(141004815818690829)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Single Whitespace'
,p_lov_return_value=>'SINGLE_WHITESPACES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(141005014039690829)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'PLSQL Expression'
,p_lov_return_value=>'PLSQL_EXPRESSION'
,p_required_patch=>-wwv_flow_imp.id(170786031904296885)
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(141005230162690829)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Regular Expression'
,p_lov_return_value=>'REGULAR_EXPRESSION'
,p_required_patch=>wwv_flow_imp.id(170786031904296885)
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(13800125404733346)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'PLSQL Function Body'
,p_lov_return_value=>'PLSQL_FUNCTION_BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(13800313005733348)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'SQL Query (return single value)'
,p_lov_return_value=>'SQL_QUERY_SINGLE_VALUE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(13800507980733349)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'SQL Query (return colon separated value)'
,p_lov_return_value=>'SQL_QUERY_SEMI_COLON'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_loading_tables_list
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(15574010985556882)
,p_lov_name=>'DATA LOADING TABLES LIST'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select TABLE_NAME display_value, ID return_value ',
'from WWV_FLOW_LOAD_TABLES',
'where flow_id = :fb_flow_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_create_method
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3313626961776680)
,p_lov_name=>'DATA.LOAD.CREATE_METHOD'
,p_lov_query=>'.'||wwv_flow_imp.id(3313626961776680)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3313925521776688)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'From scratch'
,p_lov_return_value=>'CREATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3314383794776689)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'As copy of an existing Data Load Definition'
,p_lov_return_value=>'COPY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_csv_col_delimiter
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1963861252255121)
,p_lov_name=>'DATA.LOAD.CSV_COL_DELIMITER'
,p_lov_query=>'.'||wwv_flow_imp.id(1963861252255121)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1964152277255145)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>','
,p_lov_return_value=>','
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1964578744255147)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>';'
,p_lov_return_value=>';'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1964926636255147)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'|'
,p_lov_return_value=>'|'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1965387007255150)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'#'
,p_lov_return_value=>'#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1965775882255150)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'tab'
,p_lov_return_value=>'tab'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_csv_enclosed_by
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1966044064255150)
,p_lov_name=>'DATA.LOAD.CSV_ENCLOSED_BY'
,p_lov_query=>'.'||wwv_flow_imp.id(1966044064255150)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1966448886255152)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'None'
,p_lov_return_value=>'None'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1966850775255152)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'"'
,p_lov_return_value=>'"'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1967240441255152)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>''''
,p_lov_return_value=>''''
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_data_source_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2505800285473362)
,p_lov_name=>'DATA.LOAD.DATA_SOURCE_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(2505800285473362)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2506199905473375)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'File'
,p_lov_return_value=>'FILE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2506506206473376)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Paste Delimited Data'
,p_lov_return_value=>'TEXT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_error_handling
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2102956113429319)
,p_lov_name=>'DATA.LOAD.ERROR_HANDLING'
,p_lov_query=>'.'||wwv_flow_imp.id(2102956113429319)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2103697193429319)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Ignore'
,p_lov_return_value=>'IGNORE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2103238683429319)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Stop'
,p_lov_return_value=>'ABORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2104081805429319)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Log Error into Collection'
,p_lov_return_value=>'LOG_ROWS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4800818508627308)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Log into Error Log'
,p_lov_return_value=>'ERROR_LOG'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P1820_TARGET_TYPE'
,p_lov_disp_cond2=>'TABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_first_line
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1311667928909742)
,p_lov_name=>'DATA.LOAD.FIRST_LINE'
,p_lov_query=>'.'||wwv_flow_imp.id(1311667928909742)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1311961412909759)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'First line contains headers'
,p_lov_return_value=>'HEADERS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_method
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2101544010414427)
,p_lov_name=>'DATA.LOAD.METHOD'
,p_lov_query=>'.'||wwv_flow_imp.id(2101544010414427)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2102263743414445)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Append'
,p_lov_return_value=>'APPEND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2101835504414444)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Merge'
,p_lov_return_value=>'MERGE'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P1820_TARGET_TYPE'
,p_lov_disp_cond2=>'TABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2102647126414445)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Replace'
,p_lov_return_value=>'REPLACE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_sample_source_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1805213661837379)
,p_lov_name=>'DATA.LOAD.SAMPLE_SOURCE_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(1805213661837379)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1805549653837381)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Upload a File'
,p_lov_return_value=>'FILE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1805939151837382)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Copy and Paste'
,p_lov_return_value=>'COPY_PASTE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_selector_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(5203249727555533)
,p_lov_name=>'DATA.LOAD.SELECTOR_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(5203249727555533)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5203574623555536)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Name'
,p_lov_return_value=>'NAME'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5203977449555537)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Sequence'
,p_lov_return_value=>'SEQ'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(580688454483788977)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Regular Expression'
,p_lov_return_value=>'REGEXP'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_target_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1633774479940540)
,p_lov_name=>'DATA.LOAD.TARGET_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(1633774479940540)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1634008299940542)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Table'
,p_lov_return_value=>'TABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1634440835940544)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Collection'
,p_lov_return_value=>'COLLECTION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_load_transform_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(4818478622110870)
,p_lov_name=>'DATA.LOAD.TRANSFORM_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(4818478622110870)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4818717517110876)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'SQL Expression'
,p_lov_return_value=>'SQL_EXPRESSION'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4819193073110876)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'SQL Query (return single value)'
,p_lov_return_value=>'SQL_QUERY'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4819525559110876)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Left Trim'
,p_lov_return_value=>'LTRIM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4819919107110877)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Right Trim'
,p_lov_return_value=>'RTRIM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4820398208110877)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Trim'
,p_lov_return_value=>'TRIM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4820732892110877)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Replace'
,p_lov_return_value=>'REPLACE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4821110204110877)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'To Lower Case'
,p_lov_return_value=>'LOWER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4821569297110877)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'To Upper Case'
,p_lov_return_value=>'UPPER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4821998789110877)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Null If'
,p_lov_return_value=>'NULLIF'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4822345396110877)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Regular Expression Replace'
,p_lov_return_value=>'REGEXP_REPLACE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4822789377110878)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Regular Expression Null If'
,p_lov_return_value=>'REGEXP_NULLIF'
);
end;
/
prompt --application/shared_components/user_interface/lovs/database_action_button_lov
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(147433904650386326)
,p_lov_name=>'DATABASE_ACTION BUTTON LOV'
,p_lov_query=>'.'||wwv_flow_imp.id(147433904650386326)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(147434227021386334)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'SQL INSERT action'
,p_lov_return_value=>'INSERT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(147434419098386340)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'SQL UPDATE action'
,p_lov_return_value=>'UPDATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(147434607832386340)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'SQL DELETE action'
,p_lov_return_value=>'DELETE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_profile_col_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(242159593404725778)
,p_lov_name=>'DATA_PROFILE_COL_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(242159593404725778)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(242159828107725785)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Data'
,p_lov_return_value=>'DATA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4815028055049796)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Lookup'
,p_lov_return_value=>'LOOKUP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(242160239919725788)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'SQL Expression'
,p_lov_return_value=>'SQL_EXPRESSION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4815374705052172)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'SQL Query (return single value)'
,p_lov_return_value=>'SQL_QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_profile_data_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(225929676126476839)
,p_lov_name=>'DATA_PROFILE_DATA_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(225929676126476839)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(225929903268476840)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'VARCHAR2'
,p_lov_return_value=>'VARCHAR2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(225930368549476840)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'NUMBER'
,p_lov_return_value=>'NUMBER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(225930744436476841)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'DATE'
,p_lov_return_value=>'DATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(225931138522476841)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'TIMESTAMP'
,p_lov_return_value=>'TIMESTAMP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(225931522008476841)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'TIMESTAMP WITH LOCAL TIME ZONE'
,p_lov_return_value=>'TIMESTAMP WITH LOCAL TIME ZONE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(225931923485476841)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'TIMESTAMP WITH TIME ZONE'
,p_lov_return_value=>'TIMESTAMP WITH TIME ZONE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(249232043458816550)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'CLOB'
,p_lov_return_value=>'CLOB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1700989732317797)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Geometry (SDO_GEOMETRY)'
,p_lov_return_value=>'SDO_GEOMETRY'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>'wwv_flow_utilities.db_version_is_at_least(''12.2'') and wwv_flow_db_version.c_has_locator'
,p_lov_disp_cond2=>'PLSQL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(263573975956906615)
,p_lov_disp_sequence=>26
,p_lov_disp_value=>'JSON Document'
,p_lov_return_value=>'DOCUMENT_FRAGMENT'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>'wwv_flow_utilities.db_version_is_at_least(''12.1'')'
,p_lov_disp_cond2=>'PLSQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/data_profile_date_format_masks
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(225940310284555905)
,p_lov_name=>'DATA_PROFILE_DATE_FORMAT_MASKS'
,p_lov_query=>'.'||wwv_flow_imp.id(225940310284555905)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(225940649643555906)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'2016-12-01'
,p_lov_return_value=>'YYYY-MM-DD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(225941017139555907)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'2016-12-01T20:00:00'
,p_lov_return_value=>'YYYY-MM-DD"T"HH24:MI:SS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(225941432549555907)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'2016-12-02T20:00:00.516'
,p_lov_return_value=>'YYYY-MM-DD"T"HH24:MI:SS.FF3'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(225941811998555907)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'2016-12-02T20:00:00.516Z'
,p_lov_return_value=>'YYYY-MM-DD"T"HH24:MI:SS.FF3TZR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4412319045213134)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'$5,234.10'
,p_lov_return_value=>'FML999G999G999G999G990D00'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4412618495214033)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'5,234.10'
,p_lov_return_value=>'999G999G999G999G990D00'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4412945048216241)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'5,234'
,p_lov_return_value=>'999G999G999G999G999G999G990'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4413218817217822)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'-5,234.10'
,p_lov_return_value=>'S999G999G999G999G990D00'
);
end;
/
prompt --application/shared_components/user_interface/lovs/date_format_lov
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(460719917105668922)
,p_lov_name=>'DATE_FORMAT_LOV'
,p_reference_id=>460140315153255042
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r',
'  from wwv_flow_format_masks',
' where t=''D'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/days_of_the_week
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(185376216434149048)
,p_lov_name=>'DAYS OF THE WEEK'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,r from (',
'   select to_char(to_date(''19721105'',''YYYYMMDD''),''Day'') d,19721105 r from dual',
'   union all',
'   select to_char(to_date(''19721106'',''YYYYMMDD''),''Day''),19721106 from dual',
'   union all',
'   select to_char(to_date(''19721107'',''YYYYMMDD''),''Day''),19721107 from dual',
'   union all',
'   select to_char(to_date(''19721108'',''YYYYMMDD''),''Day''),19721108 from dual',
'   union all',
'   select to_char(to_date(''19721109'',''YYYYMMDD''),''Day''),19721109 from dual',
'   union all',
'   select to_char(to_date(''19721110'',''YYYYMMDD''),''Day''),19721110 from dual',
'   union all',
'   select to_char(to_date(''19721111'',''YYYYMMDD''),''Day''),19721111 from dual',
')',
'order by 2 '))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/db_column_items
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(156839505926131127)
,p_lov_name=>'DB.COLUMN.ITEMS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name a,name b',
'',
'from wwv_flow_step_items',
'',
'where flow_id = :fb_flow_id',
'',
'and flow_step_id = :FB_FLOW_PAGE_ID',
'',
'and security_group_id = :flow_security_group_id',
'',
'and source_type = ''DB_COLUMN'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/deep_linking
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(34319101845334424)
,p_lov_name=>'DEEP_LINKING'
,p_lov_query=>'.'||wwv_flow_imp.id(34319101845334424)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(34319403683334426)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Enabled'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(34319716050334427)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Disabled'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/default_error_display_location
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(191207805708435328)
,p_lov_name=>'DEFAULT_ERROR_DISPLAY_LOCATION'
,p_lov_query=>'.'||wwv_flow_imp.id(191207805708435328)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(191208023843435360)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Inline with Field and in Notification'
,p_lov_return_value=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(191208231710435370)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Inline with Field'
,p_lov_return_value=>'INLINE_WITH_FIELD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(191208402756435370)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Inline in Notification'
,p_lov_return_value=>'INLINE_IN_NOTIFICATION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/deinstall_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(17717826931614902)
,p_lov_name=>'DEINSTALL OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(17717826931614902)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17718426349614906)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Do Nothing'
,p_lov_return_value=>'NOT_ACCEPTED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(37670813248983399)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Delete Application Definition'
,p_lov_return_value=>'DROP_APP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17718232517614906)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Drop Database Objects'
,p_lov_return_value=>'DROP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17718011536614905)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Drop Database Objects and Delete Application Definition'
,p_lov_return_value=>'DROP_AND_DELETE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/delete_application_actions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(15857613201776764)
,p_lov_name=>'DELETE APPLICATION ACTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(15857613201776764)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15857829844776765)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Run Application Deinstall Script (recommended)'
,p_lov_return_value=>'SCRIPT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(15858025445776766)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Delete Application Definition'
,p_lov_return_value=>'DEL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/delete_corresponding_list_entries
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(139182915633902523)
,p_lov_name=>'DELETE CORRESPONDING LIST ENTRIES'
,p_lov_query=>'.'||wwv_flow_imp.id(139182915633902523)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(139183129828902528)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Yes -- Delete corresponding list entries'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(139183303567902531)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'No -- Do not delete corresponding list entries'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/delete_assoc_tabs
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84243720472403985)
,p_lov_name=>'DELETE_ASSOC_TABS'
,p_lov_query=>'.'||wwv_flow_imp.id(84243720472403985)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84243909960403986)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'No -- Do not delete corresponding tabs'
,p_lov_return_value=>'NO'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84244120450403986)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Yes -- Delete any associated tabs'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/deployment_build_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(19372012243626156)
,p_lov_name=>'DEPLOYMENT BUILD OPTIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select patch_name||'' (''||wwv_flow_lang.system_message(patch_status)||'')'' d, id r ',
'  from wwv_flow_patches ',
' where flow_id = :FB_FLOW_ID'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/deployment_license_acceptance
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(110337521891120166)
,p_lov_name=>'DEPLOYMENT LICENSE ACCEPTANCE'
,p_lov_query=>'.'||wwv_flow_imp.id(110337521891120166)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(110337709187120166)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'I Accept'
,p_lov_return_value=>'ACCEPTED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(110337913130120172)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'I Do Not Accept'
,p_lov_return_value=>'NOT_ACCEPTED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/developers_with_comments
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(125707019629972839)
,p_lov_name=>'DEVELOPERS WITH COMMENTS'
,p_lov_query=>'select distinct created_by d, created_by r from wwv_flow_app_comments where flow_id = :fb_flow_id order by upper(created_by)'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dialog_page_mode
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(44400703264122475)
,p_lov_name=>'DIALOG_PAGE_MODE'
,p_lov_query=>'.'||wwv_flow_imp.id(44400703264122475)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(44401020446122476)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Normal'
,p_lov_return_value=>'NORMAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(44401312153122478)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Modal Dialog'
,p_lov_return_value=>'MODAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(44401624389122478)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Non-Modal Dialog'
,p_lov_return_value=>'NON_MODAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dialog_page_mode_create_wizard
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1497542689968615899)
,p_lov_name=>'DIALOG_PAGE_MODE_CREATE_WIZARD'
,p_lov_query=>'.'||wwv_flow_imp.id(1497542689968615899)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1497542930985615927)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Normal'
,p_lov_return_value=>'NORMAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1497543374287615927)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Modal Dialog'
,p_lov_return_value=>'MODAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dialog_page_mode_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(887851591470130537)
,p_lov_name=>'DIALOG_PAGE_MODE_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(887851591470130537)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(887851822217130538)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Modal Dialog'
,p_lov_return_value=>'MODAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(887852157397130546)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Non-Modal Dialog'
,p_lov_return_value=>'NON_MODAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/display_3d_graph_y
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88110219855257765)
,p_lov_name=>'DISPLAY.3D.GRAPH.Y'
,p_lov_query=>'.'||wwv_flow_imp.id(88110219855257765)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88110415537257766)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Display 3D Graph'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_column_default_when
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(89803912916156290)
,p_lov_name=>'DQ_COLUMN_DEFAULT_WHEN'
,p_lov_query=>'.'||wwv_flow_imp.id(89803912916156290)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89804223419156291)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'When creating or updating rows and no value is provided'
,p_lov_return_value=>'WHEN_NULL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89804424514156291)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Only when creating new rows'
,p_lov_return_value=>'WHEN_INSERTING'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_column_functionality
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(135655901614273908)
,p_lov_name=>'DQ_COLUMN_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_imp.id(135655901614273908)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197867120372745037)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Hide'
,p_lov_return_value=>'HIDE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(135656201051273908)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Sort'
,p_lov_return_value=>'SORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(135656409479273908)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Filter'
,p_lov_return_value=>'FILTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(47292224899070718)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Highlight'
,p_lov_return_value=>'HIGHLIGHT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(135656630770273909)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Control Break'
,p_lov_return_value=>'BREAK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(135656816892273909)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Aggregate'
,p_lov_return_value=>'AGGREGATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(135657009007273909)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Compute'
,p_lov_return_value=>'COMPUTE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(135657212463273909)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Chart'
,p_lov_return_value=>'CHART'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1542409404810451)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Group By'
,p_lov_return_value=>'GROUP_BY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(367035115416400374)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'Pivot'
,p_lov_return_value=>'PIVOT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_column_group_show
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(90206330144997352)
,p_lov_name=>'DQ_COLUMN_GROUP_SHOW'
,p_lov_query=>'.'||wwv_flow_imp.id(90206330144997352)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(90206602571997357)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'All Columns'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(90206830794997359)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Unassigned Columns'
,p_lov_return_value=>'UNASSIGNED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_column_lov_from
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(89795021349092520)
,p_lov_name=>'DQ_COLUMN_LOV_FROM'
,p_lov_query=>'.'||wwv_flow_imp.id(89795021349092520)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89795329939092520)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Distinct Column Values'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89795515067092520)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Static Domain of Values'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_column_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(89661604165746991)
,p_lov_name=>'DQ_COLUMN_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(89661604165746991)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89661921597746991)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'String	'
,p_lov_return_value=>'STRING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89662130353746991)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Number'
,p_lov_return_value=>'NUMBER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89662330603746991)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Date'
,p_lov_return_value=>'DATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89662503487746992)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Document'
,p_lov_return_value=>'DOCUMENT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89662722742746992)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Computed'
,p_lov_return_value=>'COMPUTED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91733204209169832)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Detail Link'
,p_lov_return_value=>'DETAIL_LINK'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_detail_page_functionality
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(93896321430905901)
,p_lov_name=>'DQ_DETAIL_PAGE_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_imp.id(93896321430905901)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93896600582905901)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Allow Exclude Null Values'
,p_lov_return_value=>'EXCLUDE_NULL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93896828769905901)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Allow Displayed Columns'
,p_lov_return_value=>'HIDE_EXTR_COL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_display_in_def_rpt
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(94105402933265699)
,p_lov_name=>'DQ_DISPLAY_IN_DEF_RPT'
,p_lov_query=>'.'||wwv_flow_imp.id(94105402933265699)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(94105722376265699)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Display In Default Report'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_display_text_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(113775430732356381)
,p_lov_name=>'DQ_DISPLAY_TEXT_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(113775430732356381)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(113775715473356384)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Standard Report Column'
,p_lov_return_value=>'WITHOUT_MODIFICATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(113776305444356385)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Display as Text (escape special characters)'
,p_lov_return_value=>'ESCAPE_SC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(450124406392222095)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>'Display as Text (based on LOV, escape special characters)'
,p_lov_return_value=>'LOV_ESCAPE_SC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(442890225057859433)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Remove HTML and escape special characters'
,p_lov_return_value=>'STRIP_HTML_ESCAPE_SC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(135238030911430173)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Hidden'
,p_lov_return_value=>'HIDDEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_download_format
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(91727320467023155)
,p_lov_name=>'DQ_DOWNLOAD_FORMAT'
,p_lov_query=>'.'||wwv_flow_imp.id(91727320467023155)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91727602780023159)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CSV'
,p_lov_return_value=>'CSV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3830908039991257)
,p_lov_disp_sequence=>1.5
,p_lov_disp_value=>'HTML'
,p_lov_return_value=>'HTML'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9204300405839444)
,p_lov_disp_sequence=>1.7
,p_lov_disp_value=>'Email *'
,p_lov_return_value=>'EMAIL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91727810512023162)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'XLS'
,p_lov_return_value=>'XLS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91728030204023162)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'PDF'
,p_lov_return_value=>'PDF'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91728214017023162)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'RTF'
,p_lov_return_value=>'RTF'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_filter_date_range
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(113891626211903772)
,p_lov_name=>'DQ_FILTER_DATE_RANGE'
,p_lov_query=>'.'||wwv_flow_imp.id(113891626211903772)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(113891914381903774)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'All'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(113892122745903775)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Past'
,p_lov_return_value=>'PAST'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(113892318530903775)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Future'
,p_lov_return_value=>'FUTURE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_non_pub_rpt_functionality
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(480571702359614063)
,p_lov_name=>'DQ_NON_PUB_RPT_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_imp.id(480571702359614063)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(480574929174614071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Save Report'
,p_lov_return_value=>'RPT_SAVING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(480575104904614071)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Save Public Report'
,p_lov_return_value=>'SAVE_RPT_PUBLIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(480574106814614069)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Subscription'
,p_lov_return_value=>'NOTIFY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_rpt_functionality
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(93890902683872023)
,p_lov_name=>'DQ_RPT_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_imp.id(93890902683872023)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93891207939872035)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Select Columns'
,p_lov_return_value=>'SELECT_COLS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93891430852872035)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Filter'
,p_lov_return_value=>'FILTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(445491215210900584)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Rows Per Page'
,p_lov_return_value=>'ROWS_PER_PAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93891616940872035)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Sort'
,p_lov_return_value=>'SORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(141674418886754015)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Control Break'
,p_lov_return_value=>'BREAK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93891825853872035)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Highlight'
,p_lov_return_value=>'HIGHLIGHT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93893009214872050)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Compute'
,p_lov_return_value=>'COMPUTATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93892010217872035)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Aggregate'
,p_lov_return_value=>'AGGREGATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(96144107239525391)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'Chart'
,p_lov_return_value=>'CHART'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1541019690680918)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'Group By'
,p_lov_return_value=>'GROUP_BY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(367023902558041646)
,p_lov_disp_sequence=>105
,p_lov_disp_value=>'Pivot'
,p_lov_return_value=>'PIVOT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93892230261872036)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'Calendar'
,p_lov_return_value=>'CALENDAR'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93892430175872036)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'Flashback'
,p_lov_return_value=>'FLASHBACK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(480714630007218066)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'Save Report *'
,p_lov_return_value=>'RPT_SAVING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(480714802780219726)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>'Save Public Report *'
,p_lov_return_value=>'SAVE_RPT_PUBLIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93892610127872036)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>'Reset'
,p_lov_return_value=>'RESET'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(135686220155392741)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>'Help'
,p_lov_return_value=>'HELP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93892800927872050)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>'Download'
,p_lov_return_value=>'DOWNLOAD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(480715008321221245)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>'Subscription *'
,p_lov_return_value=>'NOTIFY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93893414283872050)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>'Allow Report Categories'
,p_lov_return_value=>'RPT_CATEGORY'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_rpt_list_mode
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(93938623554284943)
,p_lov_name=>'DQ_RPT_LIST_MODE'
,p_lov_query=>'.'||wwv_flow_imp.id(93938623554284943)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93938902214284943)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Yes'
,p_lov_return_value=>'TABS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(131717516025931094)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'No'
,p_lov_return_value=>'NONE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_same_label_for_detail_view
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(96419205216695800)
,p_lov_name=>'DQ_SAME_LABEL_FOR_DETAIL_VIEW'
,p_lov_query=>'.'||wwv_flow_imp.id(96419205216695800)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(96419521321695807)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Use Same Text for Single Row View'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_search_functionality
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(131635032236756030)
,p_lov_name=>'DQ_SEARCH_FUNCTIONALITY'
,p_lov_query=>'.'||wwv_flow_imp.id(131635032236756030)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(131635314260756031)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Search Field'
,p_lov_return_value=>'SEARCH_TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(131635716026756031)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Finder Drop Down'
,p_lov_return_value=>'FINDER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(192533912617244035)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Reports Select List'
,p_lov_return_value=>'REPORTS_SELECT_LIST'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(131635520752756031)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Rows Per Page Selector'
,p_lov_return_value=>'ROW_CNT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(135033300784021288)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Actions Menu'
,p_lov_return_value=>'ACTIONS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_worksheet_pagination
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(89240132490172141)
,p_lov_name=>'DQ_WORKSHEET_PAGINATION'
,p_lov_query=>'.'||wwv_flow_imp.id(89240132490172141)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89240414406172201)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Row Ranges X to Y of Z'
,p_lov_return_value=>'ROWS_X_TO_Y_OF_Z'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89240620434172201)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Row Ranges X to Y'
,p_lov_return_value=>'ROWS_X_TO_Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dq_worksheet_status
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(89234523991056148)
,p_lov_name=>'DQ_WORKSHEET_STATUS'
,p_lov_query=>'.'||wwv_flow_imp.id(89234523991056148)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89234802427056220)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Available for Owner'
,p_lov_return_value=>'AVAILABLE_FOR_OWNER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89235015173056220)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Not Available'
,p_lov_return_value=>'NOT_AVAILABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89235209196056220)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Available'
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(89235410026056220)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Access Control List'
,p_lov_return_value=>'ACL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_action_aff_elem_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(42588011898494805)
,p_lov_name=>'DYNAMIC ACTION AFF ELEM TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(42588011898494805)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(42588307156494808)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Item(s)'
,p_lov_return_value=>'ITEM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(206201404272235955)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Button'
,p_lov_return_value=>'BUTTON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(42588501084494810)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Region'
,p_lov_return_value=>'REGION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(42588703168494810)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Column'
,p_lov_return_value=>'COLUMN'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(42588930101494810)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'DOM Object [deprecated]'
,p_lov_return_value=>'DOM_OBJECT'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':APP_PAGE_ID <> 591',
'or ( :APP_PAGE_ID = 591 and :P591_AFFECTED_ELEMENTS_TYPE = ''DOM_OBJECT'' )'))
,p_lov_disp_cond2=>'PLSQL'
,p_required_patch=>wwv_flow_imp.id(121426746309283317)
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(42589125805494810)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'jQuery Selector'
,p_lov_return_value=>'JQUERY_SELECTOR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(855875291459963705)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'JavaScript Expression'
,p_lov_return_value=>'JAVASCRIPT_EXPRESSION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(486612219500089929)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Triggering Element'
,p_lov_return_value=>'TRIGGERING_ELEMENT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(486612426080091815)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Event Source'
,p_lov_return_value=>'EVENT_SOURCE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_action_bind_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(34818831818567513)
,p_lov_name=>'DYNAMIC ACTION BIND TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(34818831818567513)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(34819108605567514)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Static'
,p_lov_return_value=>'bind'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(34819317513567514)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Dynamic'
,p_lov_return_value=>'live'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(47188804631100745)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Once'
,p_lov_return_value=>'one'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_action_condition
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(4505805282372682)
,p_lov_name=>'DYNAMIC ACTION CONDITION'
,p_lov_query=>'.'||wwv_flow_imp.id(4505805282372682)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4506012984372684)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'equal to'
,p_lov_return_value=>'EQUALS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4506219163372689)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'not equal to'
,p_lov_return_value=>'NOT_EQUALS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4506429627372689)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'greater than'
,p_lov_return_value=>'GREATER_THAN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(485047623220016520)
,p_lov_disp_sequence=>35
,p_lov_disp_value=>'greater than or equal to'
,p_lov_return_value=>'GREATER_THAN_OR_EQUAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4506629608372689)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'less than'
,p_lov_return_value=>'LESS_THAN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(485047828414018007)
,p_lov_disp_sequence=>45
,p_lov_disp_value=>'less than or equal to'
,p_lov_return_value=>'LESS_THAN_OR_EQUAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4506817808372689)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'is null'
,p_lov_return_value=>'NULL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4507030226372689)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'is not null'
,p_lov_return_value=>'NOT_NULL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5702509159891012)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'in list'
,p_lov_return_value=>'IN_LIST'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5703019894894122)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'not in list'
,p_lov_return_value=>'NOT_IN_LIST'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(36337703765902045)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'JavaScript expression'
,p_lov_return_value=>'JAVASCRIPT_EXPRESSION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_action_trigg_elem_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(34817614503562438)
,p_lov_name=>'DYNAMIC ACTION TRIGG ELEM TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(34817614503562438)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(34817919388562441)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Item(s)'
,p_lov_return_value=>'ITEM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(34818325097562443)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Button'
,p_lov_return_value=>'BUTTON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(34818131975562443)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Region'
,p_lov_return_value=>'REGION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(34818512066562444)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'DOM Object [deprecated]'
,p_lov_return_value=>'DOM_OBJECT'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
':APP_PAGE_ID not in ( 423, 793, 797 )',
'or ( :APP_PAGE_ID = 793 and :P793_TRIGGERING_ELEMENT_TYPE = ''DOM_OBJECT'' )',
'or ( :APP_PAGE_ID = 797 and :P797_TRIGGERING_ELEMENT_TYPE = ''DOM_OBJECT'' )'))
,p_lov_disp_cond2=>'PLSQL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(34818720680562446)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'jQuery Selector'
,p_lov_return_value=>'JQUERY_SELECTOR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(855887929978084842)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'JavaScript Expression'
,p_lov_return_value=>'JAVASCRIPT_EXPRESSION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_action_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(176908416123204266)
,p_lov_name=>'DYNAMIC ACTION TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(176908416123204266)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(176908631630204301)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Show'
,p_lov_return_value=>'NATIVE_SHOW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(181460730381992265)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Hide'
,p_lov_return_value=>'NATIVE_HIDE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(176908832156204306)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Enable'
,p_lov_return_value=>'NATIVE_ENABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(184818803817394386)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Disable'
,p_lov_return_value=>'NATIVE_DISABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_actions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(34830410796693863)
,p_lov_name=>'DYNAMIC ACTIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''DA_NAME.''|| name_with_prefix) as d,',
'       name_with_prefix as r',
'  from wwv_flow_native_plugins',
' where plugin_type = ''DYNAMIC ACTION''',
' union all',
'select display_name || wwv_flow_lang.system_message(''PLUGIN.DISPLAY_NAME_POSTFIX'') as d,',
'       ''PLUGIN_'' || name as r',
'  from wwv_flow_plugins',
' where flow_id = to_number(:FB_FLOW_ID)',
'   and security_group_id = to_number(:WORKSPACE_ID)',
'   and plugin_type = ''DYNAMIC ACTION''',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_actions_old
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(4507311169374329)
,p_lov_name=>'DYNAMIC ACTIONS OLD'
,p_lov_query=>'.'||wwv_flow_imp.id(4507311169374329)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4507509318374330)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Show'
,p_lov_return_value=>'SHOW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4507707037374331)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Hide'
,p_lov_return_value=>'HIDE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(25500603273005492)
,p_lov_disp_sequence=>25
,p_lov_disp_value=>'Hide and Clear'
,p_lov_return_value=>'HIDE_AND_CLEAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4507925307374331)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Enable'
,p_lov_return_value=>'ENABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4508112618374331)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Disable'
,p_lov_return_value=>'DISABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4508306180374331)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Show Item Row'
,p_lov_return_value=>'SHOW_ITEM_ROW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4508511742374331)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Hide Item Row'
,p_lov_return_value=>'HIDE_ITEM_ROW'
);
end;
/
prompt --application/shared_components/user_interface/lovs/dynamic_theme_list
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(317672930832099392)
,p_lov_name=>'DYNAMIC_THEME_LIST'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''<br/><a href="f?p=4000:''||:THEME_NEXT_PAGE||'':''||:APP_SESSION||''::::THEME_ID:''||t.theme_id||''"><img src="#IMAGE_PREFIX#themes/theme_''||t.theme_id||''/themeshot.png" alt="''||wwv_flow_lang.'
||'system_message(''THEME'')||'' ''||t.theme_id||''" title="''||wwv_flow_lang.system_message(''THEME'')||'' ''||t.theme_id||''" width="150" height="80" class="htmldbthemeshots" /></a>'' display_value, t.theme_id ',
'from (',
'    select substr(object_name,16) theme_id ',
'    from   user_objects ',
'    where  object_name like ''WWV_FLOW_THEME_%''',
'    and    object_type = ''PACKAGE''',
'    and    substr(object_name,16) in (',
'        ''1'',''2'',''3'',''4'',''5'',''6'',''7'',''8'',''9'',''10'',',
'        ''11'',''12'',''13'',''14'',''15'',''16'',''17'',''18'',''19'',''20'',',
'        ''21'',''22'',''23'',''24'',''25'',''26'',''27'',''28'',''29'',''30'',',
'        ''31'',''32'',''33'',''34'',''35'',''36'',''37'',''38'',''39'',''40'',',
'        ''41'',''42'',''43'',''44'',''45'',''46'',''47'',''48'',''49'',''50'',',
'        ''51'',''52'',''53'',''54'',''55'',''56'',''57'',''58'',''59'',''60'',',
'        ''61'',''62'',''63'',''64'',''65'',''66'',''67'',''68'',''69'',''70'',',
'        ''71'',''72'',''73'',''74'',''75'',''76'',''77'',''78'',''79'',''80'',',
'        ''81'',''82'',''83'',''84'',''85'',''86'',''87'',''88'',''89'',''90'',',
'        ''91'',''92'',''93'',''94'',''95'',''96'',''97'',''98'',''99'',''100''',
'    )',
') t',
'where t.theme_id not in (select theme_id from wwv_flow_themes where flow_id = :fb_flow_id) ',
'order by to_number(t.theme_id)',
'',
'',
'',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/editable_static_lists
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(25201951125390366)
,p_lov_name=>'EDITABLE_STATIC_LISTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'  from wwv_flow_lists',
' where list_type    = ''STATIC''',
'   and reference_id is null',
'   and flow_id      = :FB_FLOW_ID',
'   and security_group_id = :WORKSPACE_ID',
' order by 1'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_use_local_sync_table=>false
,p_return_column_name=>'R'
,p_display_column_name=>'D'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/enabled_disabled_returns_y_or_n
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(91439803955181562)
,p_lov_name=>'ENABLED_DISABLED_RETURNS_Y_OR_N'
,p_lov_query=>'.'||wwv_flow_imp.id(91439803955181562)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91440204684181564)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Disabled'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91440020513181563)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Enabled'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/enable_calendar_data_add
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(7062800325985451)
,p_lov_name=>'ENABLE_CALENDAR_DATA_ADD'
,p_lov_query=>'select wwv_flow_lang.system_message(''CONFIRM.CALENDAR_ENABLE_AJAX_DATA_ADD'') d, ''Y'' r from dual'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/enable_calendar_drag_drop
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(7041321387979610)
,p_lov_name=>'ENABLE_CALENDAR_DRAG_DROP'
,p_lov_query=>'select wwv_flow_lang.system_message(''CONFIRM.CALENDAR_ENABLE_DRAG_AND_DROP'') d, ''Y'' r from dual'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/enable_csv_export
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(113206414430374390)
,p_lov_name=>'ENABLE_CSV_EXPORT'
,p_lov_query=>'.'||wwv_flow_imp.id(113206414430374390)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(113206730666374392)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Enable CSV Output'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/enable_disable
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84865108269386627)
,p_lov_name=>'ENABLE_DISABLE'
,p_lov_query=>'.'||wwv_flow_imp.id(84865108269386627)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84865322430386628)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Disable'
,p_lov_return_value=>'DISABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84865528406386628)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Enable'
,p_lov_return_value=>'ENABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/error_display_location
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(175855211406623797)
,p_lov_name=>'ERROR_DISPLAY_LOCATION'
,p_lov_query=>'.'||wwv_flow_imp.id(175855211406623797)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(175855515052623815)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Inline with Field and in Notification'
,p_lov_return_value=>'INLINE_WITH_FIELD_AND_NOTIFICATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(175855711259623816)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Inline with Field'
,p_lov_return_value=>'INLINE_WITH_FIELD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(175855923896623816)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Inline in Notification'
,p_lov_return_value=>'INLINE_IN_NOTIFICATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(175856114844623817)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'On Error Page'
,p_lov_return_value=>'ON_ERROR_PAGE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/exact_match
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(165376410332055484)
,p_lov_name=>'EXACT_MATCH'
,p_lov_query=>'.'||wwv_flow_imp.id(165376410332055484)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(165376716320055488)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'exact match'
,p_lov_return_value=>'y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/exact_subs_y_n
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84908521896674445)
,p_lov_name=>'EXACT_SUBS_Y_N'
,p_lov_query=>'.'||wwv_flow_imp.id(84908521896674445)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84908724352674446)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'No - Perform non exact substitutions as well'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84908932193674446)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Yes - Perform only exact substitutions'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/exec_location
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3842073961668883)
,p_lov_name=>'EXEC_LOCATION'
,p_lov_query=>'.'||wwv_flow_imp.id(3842073961668883)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3842372126668884)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Local Database'
,p_lov_return_value=>'LOCAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3842783209668886)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'REST Enabled SQL Service'
,p_lov_return_value=>'REMOTE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3843166174668886)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'REST Data Source'
,p_lov_return_value=>'WEB_SOURCE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/exec_sql_data_source_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(601107956819795211)
,p_lov_name=>'EXEC_SQL_DATA_SOURCE_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(601107956819795211)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601108186629795212)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Table'
,p_lov_return_value=>'TABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601108576965795212)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'SQL Query'
,p_lov_return_value=>'SQL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601108991977795212)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Function Body Returning SQL'
,p_lov_return_value=>'FUNC_BODY_RETURNING_SQL'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'4111'
);
end;
/
prompt --application/shared_components/user_interface/lovs/exec_sql_locations
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(601110993871808630)
,p_lov_name=>'EXEC_SQL_LOCATIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(601110993871808630)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601111150897808630)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Local Database'
,p_lov_return_value=>'LOCAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601111502081808631)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'REST Enabled SQL Service'
,p_lov_return_value=>'REMOTE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/exec_web_source_post_processing
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(601113045750817318)
,p_lov_name=>'EXEC_WEB_SOURCE_POST_PROCESSING'
,p_lov_query=>'.'||wwv_flow_imp.id(601113045750817318)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601113231405817319)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'None'
,p_lov_return_value=>'NONE'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'4111'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601113600388817319)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Where Clause'
,p_lov_return_value=>'WHERE_ORDER_BY_CLAUSE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601114018041817319)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'SQL Query'
,p_lov_return_value=>'SQL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601114450986817320)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Function Body Returning SQL Query'
,p_lov_return_value=>'FUNC_BODY_RETURNING_SQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_component_application_attributes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(201561021137913944)
,p_lov_name=>'EXPORT COMPONENT APPLICATION ATTRIBUTES'
,p_lov_query=>'.'||wwv_flow_imp.id(201561021137913944)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201561202964913947)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application Attribute: Default page template'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201561427317913952)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Application Attribute: Logo'
,p_lov_return_value=>'2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201561612262913952)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Application Attribute: Logout URL'
,p_lov_return_value=>'3'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201561802624913952)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Application Attribute: Global Notification'
,p_lov_return_value=>'4'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201562020313913952)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Application Attribute: Authentication'
,p_lov_return_value=>'5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201589706900307265)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Application Attribute: Home Link'
,p_lov_return_value=>'6'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201590720753311215)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Application Attribute: Image Prefix'
,p_lov_return_value=>'7'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201591029064313600)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Application Attribute: Logging (Yes or No)'
,p_lov_return_value=>'8'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201591602183315334)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'Application Attribute: Application Owner'
,p_lov_return_value=>'9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201592417767319814)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'Application Attribute: Static Substitution Strings'
,p_lov_return_value=>'10'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201603224693321841)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'Application Attribute: Application Status and Message'
,p_lov_return_value=>'11'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(201604303007325019)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'Application Attribute: Enable Debugging (Yes or No)'
,p_lov_return_value=>'12'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(204137731018130907)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>'Application Attribute: Application Name'
,p_lov_return_value=>'13'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(204138001713131913)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>'Application Attribute: Application Alias'
,p_lov_return_value=>'14'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(204138307946133739)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>'Application Attribute: Exact Substitution Mode'
,p_lov_return_value=>'15'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(204139019721137188)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>'Application Attribute: Security Scheme'
,p_lov_return_value=>'16'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(204139423184138143)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>'Application Attribute: Proxy Server'
,p_lov_return_value=>'17'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(204140027339139375)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>'Application Attribute: Page Protection'
,p_lov_return_value=>'18'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(204140631495140521)
,p_lov_disp_sequence=>190
,p_lov_disp_value=>'Application Attribute: Virtual Private Database'
,p_lov_return_value=>'19'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(45348605156549399)
,p_lov_name=>'EXPORT.OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(45348605156549399)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(45349208290549436)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Import'
,p_lov_return_value=>'IMPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1846115445438584)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Export'
,p_lov_return_value=>'EXPORT'
,p_lov_disp_cond_type=>'NOT_EXISTS'
,p_lov_disp_cond=>'select 1 from wwv_flows where security_group_id = :flow_security_group_id'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(45349021845549425)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Export'
,p_lov_return_value=>'EXPORT'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>'select 1 from wwv_flows where security_group_id = :flow_security_group_id'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_options_with_icons
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(805553919796597674)
,p_lov_name=>'EXPORT.OPTIONS WITH ICONS'
,p_lov_query=>'.'||wwv_flow_imp.id(805553919796597674)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(805554221842597674)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Import'
,p_lov_return_value=>'IMPORT'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-app-builder-import-app'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(805554564333597675)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Export'
,p_lov_return_value=>'EXPORT'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-app-builder-export-app'
,p_lov_disp_cond_type=>'NOT_EXISTS'
,p_lov_disp_cond=>'select 1 from wwv_flows where security_group_id = :flow_security_group_id'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(805554842111597676)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Export'
,p_lov_return_value=>'EXPORT'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-app-builder-export-app'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>'select 1 from wwv_flows where security_group_id = :flow_security_group_id'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3401075102772765)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Remote Deployment'
,p_lov_return_value=>'DEPLOY'
,p_lov_template=>'#DISPLAY_VALUE#| gi-icon-app-builder-remote-deploy'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_targets_no_xml
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(43935029932609535)
,p_lov_name=>'EXPORT.TARGETS.no.xml'
,p_lov_query=>'.'||wwv_flow_imp.id(43935029932609535)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43935319566609536)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'UNIX'
,p_lov_return_value=>'UNIX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43935500793609538)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'DOS'
,p_lov_return_value=>'DOS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(107236303690563927)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Database'
,p_lov_return_value=>'DB'
,p_lov_disp_cond_type=>'FUNCTION_BODY'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'if nvl(wwv_flow_platform.get_preference(''APP_EXPORT_TO_DB_ENABLED''),''Y'') = ''Y'' and :APP_PAGE_ID = 4900 then',
'    return TRUE;',
'else',
'    return FALSE;',
'end if;'))
,p_lov_disp_cond2=>'PLSQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_feedback_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(472293315458205653)
,p_lov_name=>'EXPORT_FEEDBACK_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(472293315458205653)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(472293519211205655)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Export feedback to development'
,p_lov_return_value=>'TO_DEVELOPMENT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(472293702716205659)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Export response to deployment'
,p_lov_return_value=>'TO_DEPLOYMENT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_file_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84829617133304005)
,p_lov_name=>'EXPORT_FILE_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(84829617133304005)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84829803958304006)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application, Page or Component Export'
,p_lov_return_value=>'FLOW_EXPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(30414604424207501)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Plug-in'
,p_lov_return_value=>'PLUGIN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84830627988304007)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Script File Export'
,p_lov_return_value=>'SCRIPT_FILE_EXPORT'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(141375217080001896)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Theme Export'
,p_lov_return_value=>'THEME'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(158557719334534776)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'User Interface Defaults'
,p_lov_return_value=>'UI_DEFAULTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(472592924227766354)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Team Development Feedback'
,p_lov_return_value=>'FEEDBACK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3820800835815571)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'REST Source Catalog'
,p_lov_return_value=>'CATALOG'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_sup_obj_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(388231942990864305)
,p_lov_name=>'EXPORT_SUP_OBJ_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(388231942990864305)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(388232203970864308)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Yes'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(388232554971864310)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'No'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(388232860273864310)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Yes and Install on Import Automatically'
,p_lov_return_value=>'I'
);
end;
/
prompt --application/shared_components/user_interface/lovs/export_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84313028848586180)
,p_lov_name=>'EXPORT_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(84313028848586180)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84313210243586181)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Workspaces'
,p_lov_return_value=>'COMPANY_EXPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84313400691586181)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Applications'
,p_lov_return_value=>'FLOW_EXPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84313629140586181)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Pages'
,p_lov_return_value=>'PAGE_EXPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(30460601502095997)
,p_lov_disp_sequence=>35
,p_lov_disp_value=>'Plug-in'
,p_lov_return_value=>'PLUGIN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84313822161586182)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'CSS'
,p_lov_return_value=>'CSS_EXPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84314021666586182)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Images'
,p_lov_return_value=>'IMAGE_EXPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84314231797586182)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Files'
,p_lov_return_value=>'FILE_EXPORT'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84314413534586182)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Scripts'
,p_lov_return_value=>'SCRIPT_FILE_EXPORT'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(218848421565947069)
,p_lov_disp_sequence=>75
,p_lov_disp_value=>'Static File Export'
,p_lov_return_value=>'FILE_EXPORT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217881026720006951)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Themes'
,p_lov_return_value=>'THEME'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(217881302263009316)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'User Interface Defaults'
,p_lov_return_value=>'UI_DEFAULTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(39083219682790387)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'Team Development Feedback'
,p_lov_return_value=>'FEEDBACK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3931071348171445)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'REST Source Catalog'
,p_lov_return_value=>'CATALOG'
);
end;
/
prompt --application/shared_components/user_interface/lovs/f4000_pt0x
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(104345318793564176)
,p_lov_name=>'F4000_PT0X'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select :F4000_PTN1 d, 1 r from dual ',
'where  :F4000_PTN1 is not null',
'union all',
'select :F4000_PTN2 d, 2 r from dual',
'where  :F4000_PTN2 is not null',
'union all',
'select :F4000_PTN3 d, 3 r from dual',
'where  :F4000_PTN3 is not null',
'union all',
'select :F4000_PTN4 d, 4 r from dual',
'where  :F4000_PTN4 is not null',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feedback_status
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1498508547672379782)
,p_lov_name=>'FEEDBACK STATUS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||''. ''||the_name the_name, id ',
'from wwv_flow_feedback_status ',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/feedback_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(692564541295242869)
,p_lov_name=>'FEEDBACK TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(692564541295242869)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(720957220062547736)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Developer Comment'
,p_lov_return_value=>'COMMENT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(692565162163242874)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Bug'
,p_lov_return_value=>'BUG'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(692564818123242871)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'To Do'
,p_lov_return_value=>'TODO'
);
end;
/
prompt --application/shared_components/user_interface/lovs/fieldtemplate
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(93450900806779850)
,p_lov_name=>'FIELDTEMPLATE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(template_name) d, id',
'from   wwv_flow_field_templates',
'where  flow_id = :fb_flow_id and ',
'       (:fb_theme_id is null or theme_id = :fb_theme_id)',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/field_alignment
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84354125395660958)
,p_lov_name=>'FIELD_ALIGNMENT'
,p_lov_query=>'.'||wwv_flow_imp.id(84354125395660958)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84354312984660959)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Center'
,p_lov_return_value=>'CENTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84354513344660959)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Center bottom'
,p_lov_return_value=>'CENTER-BOTTOM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84354712797660959)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Center center'
,p_lov_return_value=>'CENTER-CENTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84354917729660959)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Center top'
,p_lov_return_value=>'CENTER-TOP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84355106101660960)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Start'
,p_lov_return_value=>'LEFT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84355327264660960)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Start bottom'
,p_lov_return_value=>'LEFT-BOTTOM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84355517743660961)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Start center'
,p_lov_return_value=>'LEFT-CENTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84355723004660961)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Start top'
,p_lov_return_value=>'LEFT-TOP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84355913470660961)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'End'
,p_lov_return_value=>'RIGHT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84356104865660961)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'End bottom'
,p_lov_return_value=>'RIGHT-BOTTOM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84356323660660962)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'End center'
,p_lov_return_value=>'RIGHT-CENTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84356511314660962)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'End top'
,p_lov_return_value=>'RIGHT-TOP'
);
end;
/
prompt --application/shared_components/user_interface/lovs/file_extensions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(152392614641425297)
,p_lov_name=>'FILE EXTENSIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(152392614641425297)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(152392917070425300)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'gif'
,p_lov_return_value=>'gif'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(152393102499425300)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'jpg'
,p_lov_return_value=>'jpg'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(152393306933425300)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'png'
,p_lov_return_value=>'png'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(152393526593425301)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'js'
,p_lov_return_value=>'js'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(152393720879425301)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'ico'
,p_lov_return_value=>'ico'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(152393912392425301)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'swf'
,p_lov_return_value=>'swf'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(152561112881547769)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'css'
,p_lov_return_value=>'css'
);
end;
/
prompt --application/shared_components/user_interface/lovs/file_format
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84322414566600975)
,p_lov_name=>'FILE_FORMAT'
,p_lov_query=>'.'||wwv_flow_imp.id(84322414566600975)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84322611093600976)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'DOS'
,p_lov_return_value=>'DOS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84322801136600976)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'UNIX'
,p_lov_return_value=>'UNIX'
);
end;
/
prompt --application/shared_components/user_interface/lovs/find_files_report_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(152121930169975580)
,p_lov_name=>'FIND FILES REPORT OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(152121930169975580)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(152122103854975582)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'With context'
,p_lov_return_value=>'CONTEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(152122325945975584)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Without context'
,p_lov_return_value=>'NO_CONTEXT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/first_item
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88125512675662566)
,p_lov_name=>'FIRST.ITEM'
,p_lov_query=>'.'||wwv_flow_imp.id(88125512675662566)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88125727281662567)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'First item on page'
,p_lov_return_value=>'AUTO_FIRST_ITEM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88125912388662567)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Do not focus cursor'
,p_lov_return_value=>'NO_FIRST_ITEM'
);
end;
/
prompt --application/shared_components/user_interface/lovs/fixed_header_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1591954790699969778)
,p_lov_name=>'FIXED_HEADER_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(1591954790699969778)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1591955066049969781)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'None'
,p_lov_return_value=>'NONE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1591955376065969785)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Region'
,p_lov_return_value=>'REGION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1591955690098969785)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Page'
,p_lov_return_value=>'PAGE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/fk_col_source_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(61279713459133078)
,p_lov_name=>'FK_COL_SOURCE_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(61279713459133078)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(61280232645133087)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Item (application or page item name)'
,p_lov_return_value=>'ITEM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(137617420490097969)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'PL/SQL Expression or Function'
,p_lov_return_value=>'FUNCTION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flash_chart_query_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(6026412205740110)
,p_lov_name=>'FLASH_CHART_QUERY_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(6026412205740110)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6026711255740110)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'SQL Query'
,p_lov_return_value=>'SQL_QUERY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6026911236740110)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Function Returning SQL Query'
,p_lov_return_value=>'FUNCTION_RETURNING_SQL_QUERY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_process_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(179311318624565491)
,p_lov_name=>'FLOW.PROCESS.TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(179311318624565491)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179311622483565552)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'On Load: Before Header (page template header)'
,p_lov_return_value=>'BEFORE_HEADER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179311831825565556)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'On Load: After Header (page template header)'
,p_lov_return_value=>'AFTER_HEADER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179312200871565557)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'On Load: Before "Body" Region(s)'
,p_lov_return_value=>'BEFORE_BOX_BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179312423113565557)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'On Load: After "Body" Region(s)'
,p_lov_return_value=>'AFTER_BOX_BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179312600387565558)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'On Load: Before Footer (page template footer)'
,p_lov_return_value=>'BEFORE_FOOTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179312827063565558)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'On Load: After Footer (page template footer)'
,p_lov_return_value=>'AFTER_FOOTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3451613729145560)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'On Submit: After Page Submission - Before Computations and Validations'
,p_lov_return_value=>'ON_SUBMIT_BEFORE_COMPUTATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179313012514565558)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'On Submit: After Page Submission - After Computations and Validations'
,p_lov_return_value=>'AFTER_SUBMIT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(179313403662565559)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'On New Instance (new session)'
,p_lov_return_value=>'ON_NEW_INSTANCE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(48424707885351870)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'After Authentication'
,p_lov_return_value=>'AFTER_LOGIN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(195926500168560659)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Ajax Callback: Run this application process when requested by a page process.'
,p_lov_return_value=>'ON_DEMAND'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flowchart_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84246225797415032)
,p_lov_name=>'FLOWCHART_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(84246225797415032)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88293501517804182)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Show All'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88293722687804182)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Show Used'
,p_lov_return_value=>'USED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_page_process_point
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(842344044)
,p_lov_name=>'FLOW_PAGE_PROCESS_POINT'
,p_lov_query=>'.'||wwv_flow_imp.id(842344044)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88153412020965107)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'On New Instance (new session)'
,p_lov_return_value=>'ON_NEW_INSTANCE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88153630053965109)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'On Load - Before Header'))
,p_lov_return_value=>'BEFORE_HEADER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88153816621965110)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'On Load - After Header'))
,p_lov_return_value=>'AFTER_HEADER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88154016104965110)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'On Load - Before Regions'))
,p_lov_return_value=>'BEFORE_BOX_BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88154204450965110)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'On Load - After Regions'))
,p_lov_return_value=>'AFTER_BOX_BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88154401617965110)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'On Load - Before Footer'))
,p_lov_return_value=>'BEFORE_FOOTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88154630856965111)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'On Load - After Footer'))
,p_lov_return_value=>'AFTER_FOOTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88154821308965111)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'On Submit - Before Computations and Validations '))
,p_lov_return_value=>'ON_SUBMIT_BEFORE_COMPUTATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88155019536965111)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>wwv_flow_string.join(wwv_flow_t_varchar2(
'',
'On Submit - After Computations and Validations'))
,p_lov_return_value=>'AFTER_SUBMIT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(180086820088274193)
,p_lov_disp_sequence=>95
,p_lov_disp_value=>'Ajax Callback - Run this process when requested by Ajax'
,p_lov_return_value=>'ON_DEMAND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88155215743965111)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'On Error - After Header'
,p_lov_return_value=>'AFTER_ERROR_HEADER'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88155426385965112)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'On Error - Before Footer'
,p_lov_return_value=>'BEFORE_ERROR_FOOTER'
,p_lov_disp_cond_type=>'NEVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_page_process_types_used_by_layout_plb
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(173924028038191229)
,p_lov_name=>'FLOW_PAGE_PROCESS_TYPES (USED BY LAYOUT.PLB)'
,p_lov_query=>'.'||wwv_flow_imp.id(173924028038191229)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5385505863234534)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Get Next or Previous Primary Key Value'
,p_lov_return_value=>'GET_NEXT_OR_PREV_PK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(24106509225424138)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Reset Pagination For All Pages'
,p_lov_return_value=>'INITIALIZE_PAGINATION_FOR_ALL_PAGES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(24106822384427913)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Reset Pagination For Page(s) (PageID,PageID,PageID)'
,p_lov_return_value=>'INITIALIZE_PAGE_PAGINATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(37703005830510688)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Clear Cache For Current Application (removes all session state for current application)'
,p_lov_return_value=>'CLEAR_CACHE_CURRENT_FLOW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(37703320721515055)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Clear Cache For Applications (removes all session state for listed applications)'
,p_lov_return_value=>'CLEAR_CACHE_FOR_FLOWS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(55952701190174406)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Add rows to tabular form'
,p_lov_return_value=>'ADD_ROWS_TO_TABULAR_FORM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91224603956641545)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Web Service'
,p_lov_return_value=>'WEB_SERVICE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(108355614250314633)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Close popup window'
,p_lov_return_value=>'CLOSE_WINDOW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(173924310985191301)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'PL/SQL anonymous block'
,p_lov_return_value=>'PLSQL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(173924502801191303)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'PL/SQL DBMS JOB (runs anonymous block asynchronously)'
,p_lov_return_value=>'PLSQL_DBMS_JOB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(173924700917191304)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Reset Pagination'
,p_lov_return_value=>'RESET_PAGINATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(173924903829191304)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Clear Cache for all Items on Pages (PageID,PageID,PageID)'
,p_lov_return_value=>'CLEAR_CACHE_FOR_PAGES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(173925127021191304)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Clear Cache for Items (ITEM,ITEM,ITEM)'
,p_lov_return_value=>'CLEAR_CACHE_FOR_ITEMS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(173925314775191305)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Automated Row Fetch'
,p_lov_return_value=>'DML_FETCH_ROW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(173925531897191305)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Automatic Row Processing  (DML)'
,p_lov_return_value=>'DML_PROCESS_ROW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(173925724656191305)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Set Preference to value of Item'
,p_lov_return_value=>'SET_PREFERENCE_TO_ITEM_VALUE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(173925923660191306)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Set Preference to value of Item if item is not null (PreferenceName:ITEM)'
,p_lov_return_value=>'SET_PREFERENCE_TO_ITEM_VALUE_IF_ITEM_NOT_NULL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(173926131005191309)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Multi Row Update'
,p_lov_return_value=>'MULTI_ROW_UPDATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(173926306818191309)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Clear Cache For Current Session (removes all state for current session)'
,p_lov_return_value=>'RESET_SESSION_STATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(174071729595622534)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Reset Preferences (remove all preferences for current user)'
,p_lov_return_value=>'RESET_USER_PREFERENCES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(195164405401312743)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Initialize all page items'
,p_lov_return_value=>'INITIALIZE_ALL_PAGE_ITEMS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(196226115576823870)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Ajax Callback - Run an "ajax callback" application process'
,p_lov_return_value=>'ON_DEMAND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(31585223737231743)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Multi Row Delete'
,p_lov_return_value=>'MULTI_ROW_DELETE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_button_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(78596914570530945)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_BUTTON_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||'' -'' d, 0 r from dual union all',
'select flow_id||'' : ''||wwv_flow_escape.html(template_name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r',
'from   wwv_flow_button_templates',
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in (',
'select f.id',
'from   wwv_flows f',
'where  security_group_id = :flow_security_group_id and',
'     build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'') and',
'     exists (',
'      select 1 from wwv_flow_developers',
'      where userid = :flow_user and (flow_id = f.id or flow_id is null) and security_group_id = :flow_security_group_id)',
')',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_cal_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(38779012258862870)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_CAL_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||'' -'' d, 0 r from dual',
'union all',
'select flow_id||'' : ''||wwv_flow_escape.html(name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r',
'from   wwv_flow_cal_templates',
'where flow_id != nvl(:fb_flow_id,0) and flow_id in (',
' select f.id',
' from   wwv_flows f',
' where  security_group_id = :flow_security_group_id',
'  and  build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'')',
'  and  exists (',
'   select 1 ',
'   from wwv_flow_developers',
'   where userid = :flow_user ',
'     and (flow_id is null or flow_id = f.id)',
'     and security_group_id = :flow_security_group_id)',
')',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_field_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(164770817986385686)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_FIELD_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||',
''' -'' d, 0 r from dual union all',
'select flow_id||'' : ''||wwv_flow_escape.html(template_name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r',
'from   wwv_flow_field_templates',
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in (',
'select f.id',
'from   wwv_flows f',
'where  security_group_id = :flow_security_group_id and',
'       build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'') and',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and ( flow_id is null or flow_id = f.id) and security_group_id = :flow_security_group_id)',
')',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_item_help
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(36938013073570429)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_ITEM_HELP'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'lower(wwv_flow_lang.system_message(''NO_ITEM''))||',
''' -''  d, 0 r from dual union all',
'select i.flow_id||'' : ''||wwv_flow_escape.html(i.name) d, i.id r',
'from   wwv_flow_step_items i, wwv_flow_step_item_help h',
'where  i.id = h.flow_item_id',
'and i.flow_id = nvl(:fb_flow_id,0) and i.flow_id in (',
'select f.id',
'from   wwv_flows f',
'where  security_group_id = :flow_security_group_id and',
'       build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'') and',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)',
'       or',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )',
')',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_lists
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(10900121491345998)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_LISTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select flow_id||'' : ''||name d,',
'       id r',
'  from wwv_flow_lists l',
' where flow_id != nvl(:FB_FLOW_ID,0)',
'   and security_group_id = :FLOW_SECURITY_GROUP_ID',
'   and exists (',
'        select *',
'          from wwv_flows f',
'         where f.security_group_id = :FLOW_SECURITY_GROUP_ID',
'           and f.build_status      not in (''RUN_ONLY'',''RUN_AND_HIDDEN'')',
'           and l.flow_id           = f.id )',
'order by 1'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_use_local_sync_table=>false
,p_return_column_name=>'R'
,p_display_column_name=>'D'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_list_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(164157520028033233)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_LIST_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,r from(',
'select ''- ''||',
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||',
''' -''  d, 0 r, 1 ob',
'  from dual ',
' union all',
'select flow_id||'' : ''||wwv_flow_escape.html(list_template_name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r,2 ob',
'  from wwv_flow_list_templates',
' where flow_id != nvl(:fb_flow_id,0) and flow_id in (',
'    select f.id',
'      from wwv_flows f',
'     where security_group_id = :FLOW_SECURITY_GROUP_ID and',
'           build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'')',
'       and exists (',
'               select 1 ',
'                 from wwv_flow_developers',
'                where userid = :FLOW_USER ',
'                  and ( flow_id is null or flow_id = f.id )',
'                  and security_group_id = :FLOW_SECURITY_GROUP_ID)',
'',
'))',
'order by ob,d'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_lovs
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(202133627659471272)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_LOVS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'wwv_flow_lang.system_message(''NO_LOV'')||',
''' -'' d, 0 r from dual union all',
'select flow_id||'' : ''||wwv_flow_escape.html(LOV_NAME) d, id r',
'from   wwv_flow_lists_of_values$',
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in (',
'select f.id',
'from   wwv_flows f',
'where  security_group_id = :flow_security_group_id and',
'       build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'') and',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)',
'       or',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )',
')',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_menu_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(13324505967815786)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_MENU_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||',
''' -'' d, 0 r from dual union all',
'select flow_id||'' : ''||wwv_flow_escape.html(name)||decode(theme_id,null,'''','' (''||theme_id||'')'') n, id r',
'from   wwv_flow_menu_templates',
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in (',
'select f.id',
'from   wwv_flows f',
'where  security_group_id = :flow_security_group_id and',
'       build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'') and',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and ( flow_id is null or flow_id = f.id ) and security_group_id = :flow_security_group_id)',
')',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_navbars
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(200972808971926486)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_NAVBARS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'lower(wwv_flow_lang.system_message(''LAYOUT.T_NO''))||'' '' ||wwv_flow_lang.system_message(''NAVBAR'')||',
'''  -'' d, 0 r from dual union all',
'select flow_id||'' : ''||',
'icon_image_alt d,',
'id r',
'from   wwv_flow_icon_bar',
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in (',
'select f.id',
'from   wwv_flows f',
'where  security_group_id = :flow_security_group_id and',
'       build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'') and',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)',
'       or',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )',
')',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_page_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(162657018721377376)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_PAGE_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||',
''' -'' d, 0 r from dual union all',
'select d, r from (',
'select flow_id||'' : ''||wwv_flow_escape.html(name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r',
'from   wwv_flow_templates',
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in (',
'select f.id',
'from   wwv_flows f',
'where  security_group_id = :flow_security_group_id and',
'       build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'') and',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and ( flow_id is null or flow_id = f.id) and security_group_id = :flow_security_group_id)',
')',
'order by 1',
')'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_plugins
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(32725318570538377)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_PLUGINS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select p.flow_id||'' : ''||wwv_flow_escape.html(p.display_name) as d,',
'       p.id as r',
'  from wwv_flow_plugins p,',
'       wwv_flows f',
' where p.flow_id          != to_number(:FB_FLOW_ID)',
'   and p.security_group_id = to_number(:WORKSPACE_ID)',
'   and f.id                = p.flow_id',
'   and f.build_status     not in (''RUN_ONLY'',''RUN_AND_HIDDEN'')',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_popuplov_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(13178025111508374)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_POPUPLOV_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'       lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||',
'       '' -'' d, 0 r',
'  from dual',
' union all',
'select flow_id||'' : ''||',
'       lower(wwv_flow_lang.system_message(''POPUP_LOV''))||'' ''||',
'       lower(wwv_flow_lang.system_message(''TEMPLATE''))||decode(theme_id,null,'''','' (''||theme_id||'')'') d,',
'       id r',
'  from wwv_flow_popup_lov_template',
' where flow_id != nvl(:fb_flow_id,0)',
'  and flow_id in ( select f.id',
'                     from wwv_flow_visible_flows f',
'                    where build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'') )',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_region_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(164027403622318790)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_REGION_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select flow_id||'' : ''||wwv_flow_escape.html(page_plug_template_name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r',
'from   wwv_flow_page_plug_templates',
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in (',
'select f.id',
'from   wwv_flows f',
'where  security_group_id = :flow_security_group_id and',
'       build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'') and',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and ( flow_id is null or flow_id = f.id ) and security_group_id = :flow_security_group_id)',
')',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_report_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(164380503095031318)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_REPORT_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'lower(wwv_flow_lang.system_message(''NO_TEMPLATE''))||',
''' -'' d, 0 r from dual union all',
'select flow_id||'' : ''||wwv_flow_escape.html(row_template_name)||decode(theme_id,null,'''','' (''||theme_id||'')'') d, id r',
'from   wwv_flow_row_templates',
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in (',
'select f.id',
'from   wwv_flows f',
'where  security_group_id = :flow_security_group_id and',
'       build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'') and',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and ( flow_id is null or flow_id = f.id ) and security_group_id = :flow_security_group_id)',
')',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_security_schemes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(178729613950854599)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_SECURITY_SCHEMES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'wwv_flow_lang.system_message(''NO_AUTHORIZATION_SCHEME'')||',
''' -'' d, 0 r from dual union all',
'select flow_id||'' : ''||wwv_flow_escape.html(name) d, id r',
'from   wwv_flow_security_schemes',
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in (',
'select f.id',
'from   wwv_flows f',
'where  security_group_id = :flow_security_group_id and',
'       build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'') and',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)',
'       or',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )',
')',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/flow_subscribe_from_shortcuts
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(185072604868032254)
,p_lov_name=>'FLOW_SUBSCRIBE_FROM_SHORTCUTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''- ''||',
'wwv_flow_lang.system_message(''NO_SHORTCUT'')||',
''' -'' d, 0 r from dual union all',
'select flow_id||'' : ''||wwv_flow_escape.html(shortcut_name) d, id r',
'from   wwv_flow_shortcuts',
'where  flow_id != nvl(:fb_flow_id,0) and flow_id in (',
'select f.id',
'from   wwv_flows f',
'where  security_group_id = :flow_security_group_id and',
'       build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'') and',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and flow_id is null and security_group_id = :flow_security_group_id)',
'       or',
'       exists (',
'       select 1 from wwv_flow_developers',
'       where userid = :flow_user and flow_id = f.id and security_group_id = :flow_security_group_id )',
')',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/fnd_users
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(48667231497347248)
,p_lov_name=>'FND_USERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(user_name) u, user_name r',
'from wwv_flow_fnd_user',
'where security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/font_categories
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1362022415318990531)
,p_lov_name=>'FONT_CATEGORIES'
,p_lov_query=>'.'||wwv_flow_imp.id(1362022415318990531)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(497170667382843497)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Gender'
,p_lov_return_value=>'GENDER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(497171279425847351)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hand'
,p_lov_return_value=>'HAND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(497171505282849539)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Transportation'
,p_lov_return_value=>'TRANSPORTATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1362022731262990536)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Web Application'
,p_lov_return_value=>'WEB_APPLICATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1362023055345990537)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'File Type'
,p_lov_return_value=>'FILE_TYPE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1362023361612990537)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spinner'
,p_lov_return_value=>'SPINNER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1362023649634990537)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Form Control'
,p_lov_return_value=>'FORM_CONTROL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1362023956430990537)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Payment'
,p_lov_return_value=>'PAYMENT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1362024258223990538)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Chart'
,p_lov_return_value=>'CHART'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1362024591404990538)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Currency'
,p_lov_return_value=>'CURRENCY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1362024827423990538)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Text Editor'
,p_lov_return_value=>'TEXT_EDITOR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1362025156564990538)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Directional'
,p_lov_return_value=>'DIRECTIONAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1362025474226990538)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Video Player'
,p_lov_return_value=>'VIDEO_PLAYER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1362025761844990538)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Brand'
,p_lov_return_value=>'BRAND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1362026047790990538)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Medical'
,p_lov_return_value=>'MEDICAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1498481689694180020)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Calendar'
,p_lov_return_value=>'CALENDAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1498482021426180027)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Emoji'
,p_lov_return_value=>'EMOJI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1498482476450180027)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Numbers'
,p_lov_return_value=>'NUMBERS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(32743907454195192)
,p_lov_name=>'FORMAT MASK'
,p_lov_query=>'.'||wwv_flow_imp.id(32743907454195192)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(32744227838195194)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'$5,234.10'
,p_lov_return_value=>'FML999G999G999G999G990D00'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(32744409098195194)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'5,234.10'
,p_lov_return_value=>'FM999G999G999G999G990'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(32744605601195195)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'5,234.1000'
,p_lov_return_value=>'FM999G999G999G999G990D0000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(32744816704195195)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'12-JAN-04'
,p_lov_return_value=>'DD-MON-RR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(32745005542195195)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'12-JAN-2004'
,p_lov_return_value=>'DD-MON-YYYY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(32745228650195198)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'12-JAN'
,p_lov_return_value=>'DD-MON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(32745408887195198)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Monday, January 12th 2004'
,p_lov_return_value=>'FMDay, Month DDth YYYY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(32745602717195199)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'12-JAN-2004 14:30'
,p_lov_return_value=>'DD-MON-YYYY HH24:MI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(102480222352871523)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'10-JAN-2004 14:22:10'
,p_lov_return_value=>'DD-MON-YYYY HH24:MI:SS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(32745830450195199)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'12-JAN-2004 2:30PM'
,p_lov_return_value=>'DD-MON-YYYY HH:MIPM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(32746002562195199)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'January'
,p_lov_return_value=>'Month'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_for_charts
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(100170629844530853)
,p_lov_name=>'FORMAT.MASK.FOR.CHARTS'
,p_lov_query=>'.'||wwv_flow_imp.id(100170629844530853)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(100170923893530859)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'$5,234.10'
,p_lov_return_value=>'FML999G999G999G999G990D00'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(100171118880530862)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'5,234.10'
,p_lov_return_value=>'FM999,999,999,999,990.00'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(100171313816530862)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'5,234.1000'
,p_lov_return_value=>'FM999,999,999,999,990.0000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_for_charts_dynamic
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(44804526758842632)
,p_lov_name=>'FORMAT.MASK.FOR.CHARTS.DYNAMIC'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select to_char((5234.1),''FML999G999G999G999G990D00'') d, ''FML999G999G999G999G990D00'' r from dual',
'    union all',
'select trim(to_char((5234.1),''999G999G999G999G990D00'')) d, ''999G999G999G999G990D00'' r from dual',
'    union all',
'select trim(to_char((5234.1),''999G999G999G999G990D0000'')) d, ''999G999G999G999G990D0000'' r from dual',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(44798420131812391)
,p_lov_name=>'FORMAT_MASK_DYNAMIC'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(114314002567890312)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''S''',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_no_since
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(170713321121898589)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_NO_SINCE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_timestamps
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(49243501559614579)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_TIMESTAMPS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''T''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''S''',
'',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_timestamps_no_since
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(170713631164901556)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_TIMESTAMPS_NO_SINCE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''T''',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_timestamps_tzr
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(49243714718618311)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_TIMESTAMPS_TZR'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''Z''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''S''',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_dates_timestamps_tzr_no_since
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(170713910516904980)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_DATES_TIMESTAMPS_TZR_NO_SINCE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''D''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''T''',
'union all',
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''Z'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_numbers
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(441970320516445261)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_NUMBERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r ',
'  from wwv_flow_format_masks',
' where t = ''N''',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/format_mask_dynamic_w_download
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(189097425865243903)
,p_lov_name=>'FORMAT_MASK_DYNAMIC_W_DOWNLOAD'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d, r',
'  from (',
'select d, r, t',
'  from wwv_flow_format_masks',
'union',
'select wwv_flow_lang.system_message(''BLOB_FORMAT'') d, ''BLOB'' r, ''A''',
'  from dual',
'order by 3 desc)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/form_item_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(276983704971116375)
,p_lov_name=>'FORM_ITEM_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(276983704971116375)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(276983927598116379)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Data Entry Items'
,p_lov_return_value=>'FORM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(276984120590116380)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Display-Only Items'
,p_lov_return_value=>'DISPLAY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/form_on_sp_item_display_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(161974832535033307)
,p_lov_name=>'FORM_ON_SP.ITEM_DISPLAY_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(161974832535033307)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(24105515005047067)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Textarea'
,p_lov_return_value=>'NATIVE_TEXTAREA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161975121396033308)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Display Only'
,p_lov_return_value=>'NATIVE_DISPLAY_ONLY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161975324655033308)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Hidden'
,p_lov_return_value=>'NATIVE_HIDDEN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161975507223033308)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Password'
,p_lov_return_value=>'NATIVE_PASSWORD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161975722167033309)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Text Field'
,p_lov_return_value=>'NATIVE_TEXT_FIELD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(161976700263033310)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Date Picker'
,p_lov_return_value=>'NATIVE_DATE_PICKER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/form_pagination_tables_in_schema
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(8278125741110451)
,p_lov_name=>'FORM_PAGINATION_TABLES_IN_SCHEMA'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select object_name_esc,',
'       object_name',
'  from wwv_flow_tables_views_dev',
' where owner = :P165_OWNER'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/form_validation_data_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(197490902498999083)
,p_lov_name=>'FORM_VALIDATION_DATA_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(197490902498999083)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197491131615999084)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'NUMBER'
,p_lov_return_value=>'NUMBER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(197491316482999084)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'VARCHAR'
,p_lov_return_value=>'VARCHAR'
);
end;
/
prompt --application/shared_components/user_interface/lovs/fs_display_as
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(592389652645199591)
,p_lov_name=>'FS_DISPLAY_AS'
,p_lov_query=>'.'||wwv_flow_imp.id(592389652645199591)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(592389945959199592)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Report'
,p_lov_return_value=>'CR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(592390301964199592)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Cards'
,p_lov_return_value=>'CARD'
);
end;
/
prompt --application/shared_components/user_interface/lovs/generic_report_layout
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(141528024100206812)
,p_lov_name=>'GENERIC_REPORT_LAYOUT'
,p_lov_query=>'.'||wwv_flow_imp.id(141528024100206812)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(141542620899224770)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Create file based report layout'
,p_lov_return_value=>'FILE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(141528328048206813)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Use generic report layout'
,p_lov_return_value=>'GENERIC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/global_session_state_security
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(109607612170295323)
,p_lov_name=>'GLOBAL.SESSION.STATE.SECURITY'
,p_lov_query=>'.'||wwv_flow_imp.id(109607612170295323)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(109608209132295340)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Disable'
,p_lov_return_value=>'DISABLE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>'select 1 from wwv_flows where id=:FB_FLOW_ID and nvl(page_protection_enabled_y_n,''N'') = ''Y'''
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(109608009604295340)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Enable'
,p_lov_return_value=>'ENABLE'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>'select 1 from wwv_flows where id=:FB_FLOW_ID and nvl(page_protection_enabled_y_n,''N'') = ''N'''
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(165639226722055203)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Configure'
,p_lov_return_value=>'ALL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/global_set_session_state_security
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(114140130498629709)
,p_lov_name=>'GLOBAL.SET.SESSION.STATE.SECURITY'
,p_lov_query=>'.'||wwv_flow_imp.id(114140130498629709)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(114140303209629712)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Enable'
,p_lov_return_value=>'APP_ONLY'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:9007:&SESSION.::&DEBUG.:9006:P526_ACTION:APP_ONLY"><img src="#IMAGE_PREFIX#htmldb/builder/edit_page.gif" height="75" width="100" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(114140503745629714)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Enable and Set'
,p_lov_return_value=>'ALL'
,p_lov_template=>'#DISPLAY_VALUE#<br /><a href="f?p=4000:9006:&SESSION.::&DEBUG.:9006:P526_ACTION:ALL"><img src="#IMAGE_PREFIX#htmldb/builder/edit_page.gif" height="75" width="100" alt="#DISPLAY_VALUE#" class="htmldbGreenIcons" /></a>'
);
end;
/
prompt --application/shared_components/user_interface/lovs/globalization_nls_comp
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(326783910743783589)
,p_lov_name=>'GLOBALIZATION.NLS_COMP'
,p_lov_query=>'.'||wwv_flow_imp.id(326783910743783589)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(340064531506850448)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Database session NLS setting (default)'
,p_lov_return_value=>'0'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(326784217193783591)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Binary'
,p_lov_return_value=>'BINARY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(326784521494783591)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Linguistic'
,p_lov_return_value=>'LINGUISTIC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/grid_layout_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(203356809012666718)
,p_lov_name=>'GRID_LAYOUT.TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(203356809012666718)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(203357017969666729)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'HTML Table'
,p_lov_return_value=>'TABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(203357326722666733)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Fixed Number of Columns'
,p_lov_return_value=>'FIXED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(203357625148666733)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Variable Number of Columns'
,p_lov_return_value=>'VARIABLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/group_picker
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(212924308633451870)
,p_lov_name=>'GROUP PICKER'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(group_name) d, id ',
'from wwv_flow_page_groups ',
'where flow_id = :fb_flow_id',
'and security_group_id = :flow_security_group_id',
'order by upper(group_name)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/hash_function
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(367957504585280755)
,p_lov_name=>'HASH_FUNCTION'
,p_lov_query=>'.'||wwv_flow_imp.id(367957504585280755)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(367957804400280757)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'SHA-1'
,p_lov_return_value=>'SH1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(367958102306280760)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'SHA-2, 256 bit (requires 12c)'
,p_lov_return_value=>'SH256'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(367958428314280760)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'SHA-2, 384 bit (requires 12c)'
,p_lov_return_value=>'SH384'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(367958707602280760)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'SHA-2, 512 bit (requires 12c)'
,p_lov_return_value=>'SH512'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(367959005808280761)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'MD5 [Deprecated]'
,p_lov_return_value=>'MD5'
);
end;
/
prompt --application/shared_components/user_interface/lovs/hidden_or_hidden_and_protected
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(131237822858809392)
,p_lov_name=>'HIDDEN OR HIDDEN AND PROTECTED'
,p_lov_query=>'.'||wwv_flow_imp.id(131237822858809392)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(131238012226809394)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hidden and Protected'
,p_lov_return_value=>'HIDDEN_PROTECTED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(131238205714809394)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Hidden'
,p_lov_return_value=>'HIDDEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/home_page_display_mode
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(430811903296261990)
,p_lov_name=>'HOME PAGE DISPLAY MODE'
,p_lov_query=>'.'||wwv_flow_imp.id(430811903296261990)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(430812126757261993)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Use Icons'
,p_lov_return_value=>'ICONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(430812320446262006)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Use Buttons'
,p_lov_return_value=>'BUTTONS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/horizontal_n_vertical_y
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(148121507217144506)
,p_lov_name=>'HORIZONTAL_N_VERTICAL_Y'
,p_lov_query=>'.'||wwv_flow_imp.id(148121507217144506)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(148122607695144519)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Horizontal'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(148123400557144527)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Vertical'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/html_escaping_mode
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(314983827117600277)
,p_lov_name=>'HTML_ESCAPING_MODE'
,p_lov_query=>'.'||wwv_flow_imp.id(314983827117600277)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(314984126950600278)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Basic'
,p_lov_return_value=>'B'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(314984408541600278)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Extended'
,p_lov_return_value=>'E'
);
end;
/
prompt --application/shared_components/user_interface/lovs/http_response_header
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(137613906194173724)
,p_lov_name=>'HTTP_RESPONSE_HEADER'
,p_lov_query=>'.'||wwv_flow_imp.id(137613906194173724)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(137614421689173725)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Report Settings'
,p_lov_return_value=>'APEX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(137614228757173725)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Print Server'
,p_lov_return_value=>'SERVER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_iana_charset
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(144796827445692396)
,p_lov_name=>'I18N_IANA_CHARSET'
,p_lov_query=>'.'||wwv_flow_imp.id(144796827445692396)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9135511113548516)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unicode UTF-16 Little Endian'
,p_lov_return_value=>'utf-16le'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9205201229849121)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unicode UTF-16 Big Endian'
,p_lov_return_value=>'utf-16be'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(69601501664557233)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'US-ASCII'
,p_lov_return_value=>'us-ascii'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144797117419692400)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Arabic ISO-8859-6'
,p_lov_return_value=>'iso-8859-6'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144797316057692402)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Arabic Windows 1256'
,p_lov_return_value=>'windows-1256'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144797500330692402)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Chinese Big5'
,p_lov_return_value=>'big5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144797708396692402)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Chinese GBK'
,p_lov_return_value=>'gbk'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144797916474692403)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic ISO-8859-5'
,p_lov_return_value=>'iso-8859-5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144798131344692405)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic KOI8-R'
,p_lov_return_value=>'koi8-r'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144798312837692405)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic KOI8-U'
,p_lov_return_value=>'koi8-u'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144798504968692405)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Cyrilic Windows 1251'
,p_lov_return_value=>'windows-1251'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144798718838692405)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Eastern European ISO-8859-2'
,p_lov_return_value=>'iso-8859-2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144798932645692407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Eastern European Windows 1250'
,p_lov_return_value=>'windows-1250'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144799110457692407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Greek ISO-8859-7'
,p_lov_return_value=>'iso-8859-7'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144799314923692407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Greek Windows 1253'
,p_lov_return_value=>'windows-1253'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144799532216692407)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Hebrew ISO-8859-8-i'
,p_lov_return_value=>'iso-8859-8-i'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144799706409692408)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Hebrew Windows 1255'
,p_lov_return_value=>'windows-1255'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144799927372692408)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Japanese EUC'
,p_lov_return_value=>'euc-jp'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144800108899692408)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Japanese Shift JIS'
,p_lov_return_value=>'shift_jis'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144800330988692408)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Korean EUC'
,p_lov_return_value=>'euc-kr'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144800519069692409)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Northern European ISO-8859-4'
,p_lov_return_value=>'iso-8859-4'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144800711990692409)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Northern European Windows 1257'
,p_lov_return_value=>'windows-1257'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144800919398692409)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Southern European ISO-8859-3'
,p_lov_return_value=>'iso-8859-3'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144801121569692409)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Thai TIS-620'
,p_lov_return_value=>'tis-620'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144801321138692410)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Turkish ISO-8859-9'
,p_lov_return_value=>'iso-8859-9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144801513548692410)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Turkish Windows 1254'
,p_lov_return_value=>'windows-1254'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144801730411692410)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unicode UTF-8'
,p_lov_return_value=>'utf-8'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144801927440692410)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Vietnamese Windows 1258'
,p_lov_return_value=>'windows-1258'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144802114623692411)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Western European ISO-8859-1'
,p_lov_return_value=>'iso-8859-1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144802329838692411)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Western European Windows 1252'
,p_lov_return_value=>'windows-1252'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_iana_db_charset
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(144802427115692411)
,p_lov_name=>'I18N_IANA_DB_CHARSET'
,p_lov_query=>'.'||wwv_flow_imp.id(144802427115692411)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144802705132692411)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic ISO-8859-6'
,p_lov_return_value=>'AR8ISO8859P6'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144802901122692412)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Arabic Windows 1256'
,p_lov_return_value=>'AR8MSWIN1256'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144803127029692412)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Chinese Big5'
,p_lov_return_value=>'ZHT16MSWIN950'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144803324377692412)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Chinese GBK'
,p_lov_return_value=>'ZHS16GBK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144803513705692412)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Cyrilic ISO-8859-5'
,p_lov_return_value=>'CL8ISO8859P5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144803729051692412)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Cyrilic KOI8-R'
,p_lov_return_value=>'CL8KOI8R'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144803903575692413)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Cyrilic KOI8-U'
,p_lov_return_value=>'CL8KOI8U'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144804107518692413)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Cyrilic Windows 1251'
,p_lov_return_value=>'CL8MSWIN1251'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144804326415692413)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'Eastern European ISO-8859-2'
,p_lov_return_value=>'EE8ISO8859P2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144804519494692413)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'Eastern European Windows 1250'
,p_lov_return_value=>'EE8MSWIN1250'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144804719388692414)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'Greek ISO-8859-7'
,p_lov_return_value=>'EL8ISO8859P7'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144804930073692414)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'Greek Windows 1253'
,p_lov_return_value=>'EL8MSWIN1253'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144805102017692414)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>'Hebrew ISO-8859-8-i'
,p_lov_return_value=>'IW8ISO8859P8'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144805316824692414)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>'Hebrew Windows 1255'
,p_lov_return_value=>'IW8MSWIN1255'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144805529478692415)
,p_lov_disp_sequence=>150
,p_lov_disp_value=>'Japanese EUC'
,p_lov_return_value=>'JA16EUC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144805708758692415)
,p_lov_disp_sequence=>160
,p_lov_disp_value=>'Japanese Shift JIS'
,p_lov_return_value=>'JA16SJIS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144805930377692415)
,p_lov_disp_sequence=>170
,p_lov_disp_value=>'Korean EUC'
,p_lov_return_value=>'KO16MSWIN949'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144806119293692416)
,p_lov_disp_sequence=>180
,p_lov_disp_value=>'Northern European ISO-8859-4'
,p_lov_return_value=>'NEE8ISO8859P4'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144806300284692416)
,p_lov_disp_sequence=>190
,p_lov_disp_value=>'Northern European Windows 1257'
,p_lov_return_value=>'BLT8MSWIN1257'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144806517452692416)
,p_lov_disp_sequence=>200
,p_lov_disp_value=>'Southern European ISO-8859-3'
,p_lov_return_value=>'SE8ISO8859P3'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144806722982692416)
,p_lov_disp_sequence=>210
,p_lov_disp_value=>'Thai TIS-620'
,p_lov_return_value=>'TH8TISASCII'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144806902960692420)
,p_lov_disp_sequence=>220
,p_lov_disp_value=>'Turkish ISO-8859-9'
,p_lov_return_value=>'WE8ISO8859P9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144807116856692420)
,p_lov_disp_sequence=>230
,p_lov_disp_value=>'Turkish Windows 1254'
,p_lov_return_value=>'TR8MSWIN1254'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144807330588692420)
,p_lov_disp_sequence=>240
,p_lov_disp_value=>'Unicode UTF-8'
,p_lov_return_value=>'AL32UTF8'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9135825312552564)
,p_lov_disp_sequence=>242
,p_lov_disp_value=>'Unicode UTF-16 Big Endian'
,p_lov_return_value=>'AL16UTF16'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9136032238554585)
,p_lov_disp_sequence=>244
,p_lov_disp_value=>'Unicode UTF-16 Little Endian'
,p_lov_return_value=>'AL16UTF16LE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(69721018333590467)
,p_lov_disp_sequence=>248
,p_lov_disp_value=>'US-ASCII'
,p_lov_return_value=>'US7ASCII'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144807508184692421)
,p_lov_disp_sequence=>250
,p_lov_disp_value=>'Vietnamese Windows 1258'
,p_lov_return_value=>'VN8MSWIN1258'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144807715067692421)
,p_lov_disp_sequence=>260
,p_lov_disp_value=>'Western European ISO-8859-1'
,p_lov_return_value=>'WE8ISO8859P1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(144807907122692421)
,p_lov_disp_sequence=>270
,p_lov_disp_value=>'Western European Windows 1252'
,p_lov_return_value=>'WE8MSWIN1252'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_languages_locales
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(107899321117195063)
,p_lov_name=>'I18N_LANGUAGES_LOCALES'
,p_lov_query=>'.'||wwv_flow_imp.id(107899321117195063)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62331376945397671)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Azerbaijani (az)'
,p_lov_return_value=>'az'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(109801549002953044)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Serbian (Cyrillic)(sr-cyrl)'
,p_lov_return_value=>'sr-cyrl'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(109801808436950709)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Serbian (Latin)(sr-latn)'
,p_lov_return_value=>'sr-latn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198763720924437003)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Afrikaans (af)'
,p_lov_return_value=>'af'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198763917931437003)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (ar)'
,p_lov_return_value=>'ar'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198764111074437003)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Algeria) (ar-dz)'
,p_lov_return_value=>'ar-dz'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198764302926437004)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Bahrain) (ar-bh)'
,p_lov_return_value=>'ar-bh'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198764518950437004)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Egypt) (ar-eg)'
,p_lov_return_value=>'ar-eg'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198764707881437004)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Iraq) (ar-iq)'
,p_lov_return_value=>'ar-iq'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198764920585437004)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Jordan) (ar-jo)'
,p_lov_return_value=>'ar-jo'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198765125710437005)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Kuwait) (ar-kw)'
,p_lov_return_value=>'ar-kw'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198765301909437005)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Lebanon) (ar-lb)'
,p_lov_return_value=>'ar-lb'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198765514908437005)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Libya) (ar-ly)'
,p_lov_return_value=>'ar-ly'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198765710657437005)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Morocco) (ar-ma)'
,p_lov_return_value=>'ar-ma'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198765921945437006)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Oman) (ar-om)'
,p_lov_return_value=>'ar-om'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198766127407437006)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Qatar) (ar-qa)'
,p_lov_return_value=>'ar-qa'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198766300363437006)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Saudi Arabia) (ar-sa)'
,p_lov_return_value=>'ar-sa'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198766505773437006)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Syria) (ar-sy)'
,p_lov_return_value=>'ar-sy'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198766707839437007)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Tunisia) (ar-tn)'
,p_lov_return_value=>'ar-tn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198766917417437007)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (U.A.E.) (ar-ae)'
,p_lov_return_value=>'ar-ae'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198767112053437007)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Arabic (Yemen) (ar-ye)'
,p_lov_return_value=>'ar-ye'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198767312340437007)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Assamese (as)'
,p_lov_return_value=>'as'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198767522099437008)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Basque (eu)'
,p_lov_return_value=>'eu'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198767726246437008)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Belarusian (be)'
,p_lov_return_value=>'be'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198767919601437008)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bengali (bn)'
,p_lov_return_value=>'bn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198768103556437008)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bulgarian (bg)'
,p_lov_return_value=>'bg'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198768313681437009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Catalan (ca)'
,p_lov_return_value=>'ca'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198768503476437009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Chinese (zh)'
,p_lov_return_value=>'zh'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198768717157437009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Chinese (China) (zh-cn)'
,p_lov_return_value=>'zh-cn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198768915177437009)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Chinese (Hong Kong SAR) (zh-hk)'
,p_lov_return_value=>'zh-hk'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198769104560437010)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Chinese (Macau SAR) (zh-mo)'
,p_lov_return_value=>'zh-mo'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198769309316437010)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Chinese (Singapore) (zh-sg)'
,p_lov_return_value=>'zh-sg'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198769519659437010)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Chinese (Taiwan) (zh-tw)'
,p_lov_return_value=>'zh-tw'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198769707113437011)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Croatian (hr)'
,p_lov_return_value=>'hr'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198769930859437011)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Czech (cs)'
,p_lov_return_value=>'cs'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198770121194437011)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Danish (da)'
,p_lov_return_value=>'da'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198770321280437011)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Dutch (Belgium) (nl-be)'
,p_lov_return_value=>'nl-be'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198770514114437012)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Dutch (Netherlands) (nl)'
,p_lov_return_value=>'nl'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198770704682437012)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (en)'
,p_lov_return_value=>'en'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198770926869437012)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (Australia) (en-au)'
,p_lov_return_value=>'en-au'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198771101039437012)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (Belize) (en-bz)'
,p_lov_return_value=>'en-bz'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198771311078437013)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (Canada) (en-ca)'
,p_lov_return_value=>'en-ca'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198771515830437013)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (Ireland) (en-ie)'
,p_lov_return_value=>'en-ie'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198771701647437013)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (Jamaica) (en-jm)'
,p_lov_return_value=>'en-jm'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198771911421437013)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (New Zealand) (en-nz)'
,p_lov_return_value=>'en-nz'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198772116247437014)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (Philippines) (en-ph)'
,p_lov_return_value=>'en-ph'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198772303293437014)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (South Africa) (en-za)'
,p_lov_return_value=>'en-za'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198772506232437014)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (Trinidad) (en-tt)'
,p_lov_return_value=>'en-tt'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198772709014437014)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (United Kingdom) (en-gb)'
,p_lov_return_value=>'en-gb'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198772921663437015)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (United States) (en-us)'
,p_lov_return_value=>'en-us'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198773103842437015)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English (Zimbabwe) (en-zw)'
,p_lov_return_value=>'en-zw'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198773302783437015)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Estonian (et)'
,p_lov_return_value=>'et'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198773520055437015)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'FYRO Macedonian (mk)'
,p_lov_return_value=>'mk'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198773712018437016)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Faeroese (fo)'
,p_lov_return_value=>'fo'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198773905928437016)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Farsi (fa)'
,p_lov_return_value=>'fa'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198774118945437016)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'French (Switzerland) (fr-ch)'
,p_lov_return_value=>'fr-ch'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198774304989437016)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Finnish (fi)'
,p_lov_return_value=>'fi'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198774521702437017)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'French (Belgium) (fr-be)'
,p_lov_return_value=>'fr-be'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198774726368437017)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'French (Canada) (fr-ca)'
,p_lov_return_value=>'fr-ca'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198774928038437017)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'French (France) (fr)'
,p_lov_return_value=>'fr'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198775114927437017)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'French (Luxembourg) (fr-lu)'
,p_lov_return_value=>'fr-lu'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198775332434437018)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'French (Monaco) (fr-mc)'
,p_lov_return_value=>'fr-mc'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198775527857437018)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Gaelic (gd)'
,p_lov_return_value=>'gd'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198775711321437018)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Galician (gl)'
,p_lov_return_value=>'gl'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198775904103437018)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'German (Austria) (de-at)'
,p_lov_return_value=>'de-at'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198776121734437019)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'German (Germany) (de)'
,p_lov_return_value=>'de'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198776332647437019)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'German (Liechtenstein) (de-li)'
,p_lov_return_value=>'de-li'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198776529287437019)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'German (Luxemgourg) (de-lu)'
,p_lov_return_value=>'de-lu'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198776722310437019)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'German (Switzerland) (de-ch)'
,p_lov_return_value=>'de-ch'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198776930154437020)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Greek (el)'
,p_lov_return_value=>'el'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198777117663437020)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Gujarati (gu)'
,p_lov_return_value=>'gu'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198777314234437020)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hebrew (he)'
,p_lov_return_value=>'he'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198777520312437020)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hindi (hi)'
,p_lov_return_value=>'hi'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198777700475437021)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hungarian (hu)'
,p_lov_return_value=>'hu'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198777911922437021)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Icelandic (is)'
,p_lov_return_value=>'is'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198778128567437021)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Indonesian (id)'
,p_lov_return_value=>'id'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198778324997437021)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Italian (Italy) (it)'
,p_lov_return_value=>'it'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198778510434437022)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Italian (Switzerland) (it-ch)'
,p_lov_return_value=>'it-ch'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198778714304437022)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Japanese (ja)'
,p_lov_return_value=>'ja'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198778912949437022)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Kannada (kn)'
,p_lov_return_value=>'kn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198779115578437022)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Kazakh (kk)'
,p_lov_return_value=>'kk'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198779329622437023)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Konkani (kok)'
,p_lov_return_value=>'kok'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198779521470437023)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Korean (ko)'
,p_lov_return_value=>'ko'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198779730912437023)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Kyrgyz (kz)'
,p_lov_return_value=>'kz'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198779928215437023)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Latvian (lv)'
,p_lov_return_value=>'lv'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198780118707437024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Lithuanian (lt)'
,p_lov_return_value=>'lt'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198780313346437024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Malay (Malaysia) (ms)'
,p_lov_return_value=>'ms'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198780501262437024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Malayalam (ml)'
,p_lov_return_value=>'ml'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198780716986437024)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Maltese (mt)'
,p_lov_return_value=>'mt'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198780925915437025)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Marathi (mr)'
,p_lov_return_value=>'mr'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198781122126437025)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Nepali (India) (ne)'
,p_lov_return_value=>'ne'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198781323201437025)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Norwegian (Bokmal) (nb-no)'
,p_lov_return_value=>'nb-no'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198781531339437026)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Norwegian (Bokmal) (no)'
,p_lov_return_value=>'no'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198781717582437026)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Norwegian (Nynorsk) (nn-no)'
,p_lov_return_value=>'nn-no'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198781901148437026)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Oriya (or)'
,p_lov_return_value=>'or'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198782123357437026)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Polish (pl)'
,p_lov_return_value=>'pl'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198782308585437026)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Portuguese (Brazil) (pt-br)'
,p_lov_return_value=>'pt-br'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198782515205437027)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Portuguese (Portugal) (pt)'
,p_lov_return_value=>'pt'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198782712809437027)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Punjabi (pa)'
,p_lov_return_value=>'pa'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198782926250437027)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Romanian (ro)'
,p_lov_return_value=>'ro'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198783103701437028)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Russian (ru)'
,p_lov_return_value=>'ru'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198783313683437028)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Russian (Moldova) (ru-md)'
,p_lov_return_value=>'ru-md'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198783525893437028)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Serbian (sr)'
,p_lov_return_value=>'sr'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198783706765437028)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Slovak (sk)'
,p_lov_return_value=>'sk'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198783923934437029)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Slovenian (sl)'
,p_lov_return_value=>'sl'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198784123775437029)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Argentina) (es-ar)'
,p_lov_return_value=>'es-ar'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198784305305437029)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Bolivia) (es-bo)'
,p_lov_return_value=>'es-bo'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198784503555437029)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Chile) (es-cl)'
,p_lov_return_value=>'es-cl'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198784728332437030)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Colombia) (es-co)'
,p_lov_return_value=>'es-co'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198784908380437030)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Costa Rica) (es-cr)'
,p_lov_return_value=>'es-cr'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198785110585437030)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Dominican Republic) (es-do)'
,p_lov_return_value=>'es-do'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198785309022437030)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Ecuador) (es-ec)'
,p_lov_return_value=>'es-ec'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198785513360437031)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (El Salvador) (es-sv)'
,p_lov_return_value=>'es-sv'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198785722922437031)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Guatemala) (es-gt)'
,p_lov_return_value=>'es-gt'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198785903148437031)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Honduras) (es-hn)'
,p_lov_return_value=>'es-hn'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198786119876437031)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Mexico) (es-mx)'
,p_lov_return_value=>'es-mx'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198786323820437032)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Nicaragua) (es-ni)'
,p_lov_return_value=>'es-ni'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198786501745437032)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Panama) (es-pa)'
,p_lov_return_value=>'es-pa'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198786728889437032)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Paraguay) (es-py)'
,p_lov_return_value=>'es-py'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198786926053437032)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Peru) (es-pe)'
,p_lov_return_value=>'es-pe'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198787110239437033)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Puerto Rico) (es-pr)'
,p_lov_return_value=>'es-pr'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198787325084437033)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Traditional Sort) (es)'
,p_lov_return_value=>'es'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198787517364437033)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (United States) (es-us)'
,p_lov_return_value=>'es-us'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198787727100437033)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Uruguay) (es-uy)'
,p_lov_return_value=>'es-uy'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198787927315437033)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish (Venezuela) (es-ve)'
,p_lov_return_value=>'es-ve'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198788117011437034)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Swedish (sv)'
,p_lov_return_value=>'sv'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198788328010437034)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Swedish (Finland) (sv-fi)'
,p_lov_return_value=>'sv-fi'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198788517641437034)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tamil (ta)'
,p_lov_return_value=>'ta'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198788706442437034)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Telugu (te)'
,p_lov_return_value=>'te'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198788903837437035)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Thai (th)'
,p_lov_return_value=>'th'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198789120777437035)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Turkish (tr)'
,p_lov_return_value=>'tr'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198789331021437035)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ukrainian (uk)'
,p_lov_return_value=>'uk'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198789522886437035)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Urdu (ur)'
,p_lov_return_value=>'ur'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198789714421437036)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Uzbek (uz)'
,p_lov_return_value=>'uz'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(198789914419437036)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Vietnamese (vi)'
,p_lov_return_value=>'vi'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(296350229258484071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bosnian (ba)'
,p_lov_return_value=>'ba'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(296350523577489031)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Montenegrin (me)'
,p_lov_return_value=>'me'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(315594104997431311)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Irish (ga)'
,p_lov_return_value=>'ga'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(315594428276435636)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Welsh (cy)'
,p_lov_return_value=>'cy'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(398755246199483774)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Swahili (sw)'
,p_lov_return_value=>'sw'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2379664228886224616)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Albanian'
,p_lov_return_value=>'sq'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2379664559826228007)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Armenian'
,p_lov_return_value=>'hy'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_languages_locales_mapped_to_fb_flow_id
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(756583801210846491)
,p_lov_name=>'I18N_LANGUAGES_LOCALES_MAPPED_TO_FB_FLOW_ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_item.text_from_lov(translation_flow_language_code,''I18N_LANGUAGES_LOCALES'') d,',
'       translation_flow_id r',
'from   wwv_flow_language_map',
'where  security_group_id = :flow_security_group_id',
'  and  primary_language_flow_id = :FB_FLOW_ID',
'order  by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/i18n_territories
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(634612723768159258)
,p_lov_name=>'I18N_TERRITORIES'
,p_lov_query=>'.'||wwv_flow_imp.id(634612723768159258)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(62332080749407778)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Azerbaijan'
,p_lov_return_value=>'AZERBAIJAN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634612925634159272)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Algeria'
,p_lov_return_value=>'ALGERIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634617325415178665)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'America'
,p_lov_return_value=>'AMERICA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634617416564179068)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Argentina'
,p_lov_return_value=>'ARGENTINA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634617520069179068)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Australia'
,p_lov_return_value=>'AUSTRALIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634617601920179068)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Austria'
,p_lov_return_value=>'AUSTRIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634617719730179068)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bahrain'
,p_lov_return_value=>'BAHRAIN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634617805450179068)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bangladesh'
,p_lov_return_value=>'BANGLADESH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634617904577179068)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Belgium'
,p_lov_return_value=>'BELGIUM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634618014801179068)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Brazil'
,p_lov_return_value=>'BRAZIL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634618131872179068)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Bulgaria'
,p_lov_return_value=>'BULGARIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634618228314179068)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Canada'
,p_lov_return_value=>'CANADA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634618317133179068)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Catalonia'
,p_lov_return_value=>'CATALONIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634618420611179068)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Chile'
,p_lov_return_value=>'CHILE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634618517466179069)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'China'
,p_lov_return_value=>'CHINA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634618625184179069)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Colombia'
,p_lov_return_value=>'COLOMBIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634618732595179069)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Costa Rica'
,p_lov_return_value=>'COSTA RICA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634618800875179069)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Croatia'
,p_lov_return_value=>'CROATIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634618907315179069)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Czech Republic'
,p_lov_return_value=>'CZECH REPUBLIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634619005552179069)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Denmark'
,p_lov_return_value=>'DENMARK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634619102819179069)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ecuador'
,p_lov_return_value=>'ECUADOR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634619206088179069)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Egypt'
,p_lov_return_value=>'EGYPT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634619329332179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'El Salvador'
,p_lov_return_value=>'EL SALVADOR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634619417007179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Estonia'
,p_lov_return_value=>'ESTONIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634619515038179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Finland'
,p_lov_return_value=>'FINLAND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634619624034179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'France'
,p_lov_return_value=>'FRANCE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634619712611179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Macedonia'
,p_lov_return_value=>'FYR MACEDONIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634619819469179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Germany'
,p_lov_return_value=>'GERMANY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634619901797179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Greece'
,p_lov_return_value=>'GREECE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634620000995179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Guatemala'
,p_lov_return_value=>'GUATEMALA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634620128980179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hong Kong'
,p_lov_return_value=>'HONG KONG'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634620216260179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hungary'
,p_lov_return_value=>'HUNGARY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634620321313179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Iceland'
,p_lov_return_value=>'ICELAND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634620414838179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'India'
,p_lov_return_value=>'INDIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634620531315179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Indonesia'
,p_lov_return_value=>'INDONESIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634620623190179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Iraq'
,p_lov_return_value=>'IRAQ'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634620713620179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ireland'
,p_lov_return_value=>'IRELAND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634620825502179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Israel'
,p_lov_return_value=>'ISRAEL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634620901008179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Italy'
,p_lov_return_value=>'ITALY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634621030274179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Japan'
,p_lov_return_value=>'JAPAN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634621118591179070)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Jordan'
,p_lov_return_value=>'JORDAN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634621221080179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Kazakhstan'
,p_lov_return_value=>'KAZAKHSTAN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634621324332179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Korea'
,p_lov_return_value=>'KOREA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634621428808179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Kuwait'
,p_lov_return_value=>'KUWAIT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634621523349179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Latvia'
,p_lov_return_value=>'LATVIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634621617780179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Lebanon'
,p_lov_return_value=>'LEBANON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634621730434179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Libya'
,p_lov_return_value=>'LIBYA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634621829023179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Lithuania'
,p_lov_return_value=>'LITHUANIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634621931936179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Luxembourg'
,p_lov_return_value=>'LUXEMBOURG'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634622011057179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Malaysia'
,p_lov_return_value=>'MALAYSIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634622121433179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Mexico'
,p_lov_return_value=>'MEXICO'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634622209971179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Morocco'
,p_lov_return_value=>'MOROCCO'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634622316274179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'New Zealand'
,p_lov_return_value=>'NEW ZEALAND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634622424344179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Nicaragua'
,p_lov_return_value=>'NICARAGUA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634622503049179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Norway'
,p_lov_return_value=>'NORWAY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634622621796179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Oman'
,p_lov_return_value=>'OMAN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634622713614179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Panama'
,p_lov_return_value=>'PANAMA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634622824986179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Peru'
,p_lov_return_value=>'PERU'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634622920268179071)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Philippines'
,p_lov_return_value=>'PHILIPPINES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634623021563179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Poland'
,p_lov_return_value=>'POLAND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634623129496179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Portugal'
,p_lov_return_value=>'PORTUGAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634623217645179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Puerto Rico'
,p_lov_return_value=>'PUERTO RICO'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634623330760179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Qatar'
,p_lov_return_value=>'QATAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634623423279179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Romania'
,p_lov_return_value=>'ROMANIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634623511418179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Russia'
,p_lov_return_value=>'RUSSIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634623619236179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Saudi Arabia'
,p_lov_return_value=>'SAUDI ARABIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634623720537179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Serbia and Montenegro'
,p_lov_return_value=>'SERBIA AND MONTENEGRO'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634623812184179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Singapore'
,p_lov_return_value=>'SINGAPORE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634623911000179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Slovakia'
,p_lov_return_value=>'SLOVAKIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634624029069179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Slovenia'
,p_lov_return_value=>'SLOVENIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634624129059179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'South Africa'
,p_lov_return_value=>'SOUTH AFRICA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634624207346179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spain'
,p_lov_return_value=>'SPAIN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634624313399179072)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Sweden'
,p_lov_return_value=>'SWEDEN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634624425936179076)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Switzerland'
,p_lov_return_value=>'SWITZERLAND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634624529496179076)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Syria'
,p_lov_return_value=>'SYRIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634624617557179077)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Taiwan'
,p_lov_return_value=>'TAIWAN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634624710505179077)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Thailand'
,p_lov_return_value=>'THAILAND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634624807493179077)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Netherlands'
,p_lov_return_value=>'THE NETHERLANDS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634624919495179077)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Tunisia'
,p_lov_return_value=>'TUNISIA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634625012403179077)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Turkey'
,p_lov_return_value=>'TURKEY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634625126075179077)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Ukraine'
,p_lov_return_value=>'UKRAINE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634625205397179077)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'United Arab Emirates'
,p_lov_return_value=>'UNITED ARAB EMIRATES'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634625306022179077)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'United Kingdom'
,p_lov_return_value=>'UNITED KINGDOM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634625413970179077)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Uzbekistan'
,p_lov_return_value=>'UZBEKISTAN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634625513954179077)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Venezuela'
,p_lov_return_value=>'VENEZUELA'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634625626005179077)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Vietnam'
,p_lov_return_value=>'VIETNAM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(634625710240179077)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Yemen'
,p_lov_return_value=>'YEMEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/icon_animation
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(577722878770995845)
,p_lov_name=>'ICON ANIMATION'
,p_lov_query=>'.'||wwv_flow_imp.id(577722878770995845)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577723171929995847)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Spin'
,p_lov_return_value=>'fa-anim-spin'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577723576533995850)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Spin in Steps'
,p_lov_return_value=>'fa-anim-spin-step'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577723961937995850)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Flash'
,p_lov_return_value=>'fa-anim-flash'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577724321745995850)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Horizontal Shake'
,p_lov_return_value=>'fa-anim-horizontal-shake'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577724777139995850)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Vertical Shake'
,p_lov_return_value=>'fa-anim-vertical-shake'
);
end;
/
prompt --application/shared_components/user_interface/lovs/icon_categories
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(577691284053554107)
,p_lov_name=>'ICON CATEGORIES'
,p_lov_query=>'.'||wwv_flow_imp.id(577691284053554107)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577691593627554111)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Accessibility'
,p_lov_return_value=>'ACCESSIBILITY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577691952823554114)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Calendar'
,p_lov_return_value=>'CALENDAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577692301824554114)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Chart'
,p_lov_return_value=>'CHART'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577692726882554115)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Currency'
,p_lov_return_value=>'CURRENCY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577693122003554115)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Directional'
,p_lov_return_value=>'DIRECTIONAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577693541847554115)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Emoji'
,p_lov_return_value=>'EMOJI'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577693922238554115)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'File Type'
,p_lov_return_value=>'FILE_TYPE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577694301523554116)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Form Control'
,p_lov_return_value=>'FORM_CONTROL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577694781188554116)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Gender'
,p_lov_return_value=>'GENDER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577695129448554116)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hand'
,p_lov_return_value=>'HAND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577695507696554116)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Medical'
,p_lov_return_value=>'MEDICAL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577695969229554116)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Numbers'
,p_lov_return_value=>'NUMBERS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577696377143554117)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Payment'
,p_lov_return_value=>'PAYMENT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577696741617554117)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Spinner'
,p_lov_return_value=>'SPINNER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577697186360554125)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Text Editor'
,p_lov_return_value=>'TEXT_EDITOR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577697771170564752)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'Transportation'
,p_lov_return_value=>'TRANSPORTATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577698096318564753)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'Video Player'
,p_lov_return_value=>'VIDEO_PLAYER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577698486427564753)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>'Web Application'
,p_lov_return_value=>'WEB_APPLICATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(610340742405479426)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>'Maps'
,p_lov_return_value=>'MAPS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/icon_modifier
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(577742586590147796)
,p_lov_name=>'ICON MODIFIER'
,p_lov_query=>'.'||wwv_flow_imp.id(577742586590147796)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577742891771147796)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'25 Percent'
,p_lov_return_value=>'fam-25-percent'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577743228175147797)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'50 Percent'
,p_lov_return_value=>'fam-50-percent'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577743621479147797)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'75 Percent'
,p_lov_return_value=>'fam-75-percent'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577744006243147798)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'100 Percent'
,p_lov_return_value=>'fam-100-percent'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577744453509147798)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Arrow Down'
,p_lov_return_value=>'fam-arrow-down'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577744861593147798)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Arrow Left'
,p_lov_return_value=>'fam-arrow-left'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577745253038147799)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Arrow Right'
,p_lov_return_value=>'fam-arrow-right'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577745695304147799)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Arrow Up'
,p_lov_return_value=>'fam-arrow-up'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577746022797147800)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Blank'
,p_lov_return_value=>'fam-blank'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577746460643147800)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Check'
,p_lov_return_value=>'fam-check'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577746806145147800)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Circle'
,p_lov_return_value=>'fam-circle'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577747264625147800)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Clock'
,p_lov_return_value=>'fam-clock'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577747665892147800)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Ellipsis Horizontal'
,p_lov_return_value=>'fam-ellipsis-h'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577748081928147801)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Ellipsis Vertical'
,p_lov_return_value=>'fam-ellipsis-v'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577748430278147801)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Heart'
,p_lov_return_value=>'fam-heart'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577748910803151858)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'Information'
,p_lov_return_value=>'fam-information'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577749226646151858)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'Minus'
,p_lov_return_value=>'fam-minus'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577749667009151858)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>'Pause'
,p_lov_return_value=>'fam-pause'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577750392660159601)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>'Plus'
,p_lov_return_value=>'fam-plus'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577750060574159600)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>'Play'
,p_lov_return_value=>'fam-play'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577750790392159601)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>'Sleep'
,p_lov_return_value=>'fam-sleep'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577751113904159601)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Star'
,p_lov_return_value=>'fam-star'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577751577178159601)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>'Stop'
,p_lov_return_value=>'fam-stop'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577751997570159603)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>'Warning'
,p_lov_return_value=>'fam-warning'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577752309659159603)
,p_lov_disp_sequence=>23
,p_lov_disp_value=>'X'
,p_lov_return_value=>'fam-x'
);
end;
/
prompt --application/shared_components/user_interface/lovs/icon_modifier_status
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(577752611204165565)
,p_lov_name=>'ICON MODIFIER STATUS'
,p_lov_query=>'.'||wwv_flow_imp.id(577752611204165565)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577752963565165565)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Success'
,p_lov_return_value=>'fam-is-success'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577753360332165565)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Warning'
,p_lov_return_value=>'fam-is-warning'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577753798850165565)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Danger'
,p_lov_return_value=>'fam-is-danger'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577754112742165566)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Info'
,p_lov_return_value=>'fam-is-info'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577754522499165566)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Disabled'
,p_lov_return_value=>'fam-is-disabled'
);
end;
/
prompt --application/shared_components/user_interface/lovs/icon_preview_repository
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1845902759442614704)
,p_lov_name=>'ICON PREVIEW REPOSITORY'
,p_lov_query=>'.'||wwv_flow_imp.id(1845902759442614704)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1845903084419614712)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Previously Used Icons'
,p_lov_return_value=>'STANDARD_ICON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(483162162223780333)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Font APEX'
,p_lov_return_value=>'FONTAPEX'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_themes t,',
'       wwv_flow_user_interfaces ui',
' where ui.flow_id           = :FB_FLOW_ID',
'   and ui.security_group_id = :FLOW_SECURITY_GROUP_ID',
'   and t.flow_id            = ui.flow_id',
'   and t.theme_id           = ui.theme_id',
'   and t.security_group_id  = ui.security_group_id',
'   and t.icon_library       = ''FONTAPEX'''))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1845904233620614716)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Font Awesome Icons'
,p_lov_return_value=>'FONTAWESOME'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_themes t,',
'       wwv_flow_user_interfaces ui',
' where ui.flow_id           = :FB_FLOW_ID',
'   and ui.security_group_id = :FLOW_SECURITY_GROUP_ID',
'   and t.flow_id            = ui.flow_id',
'   and t.theme_id           = ui.theme_id',
'   and t.security_group_id  = ui.security_group_id',
'   and t.icon_library       = ''FONTAWESOME'''))
);
end;
/
prompt --application/shared_components/user_interface/lovs/icon_rotate
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(577740129346133895)
,p_lov_name=>'ICON ROTATE'
,p_lov_query=>'.'||wwv_flow_imp.id(577740129346133895)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577740415199133896)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Rotate 90'
,p_lov_return_value=>'fa-rotate-90'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577740873415133896)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Rotate 180'
,p_lov_return_value=>'fa-rotate-180'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577741280627133896)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Rotate 270'
,p_lov_return_value=>'fa-rotate-270'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577741676385133896)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Flip Horizontal'
,p_lov_return_value=>'fa-flip-horizontal'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577742097112133897)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Flip Vertical'
,p_lov_return_value=>'fa-flip-vertical'
);
end;
/
prompt --application/shared_components/user_interface/lovs/icon_size
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(577725423197001069)
,p_lov_name=>'ICON SIZE'
,p_lov_query=>'.'||wwv_flow_imp.id(577725423197001069)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577725702259001069)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Small'
,p_lov_return_value=>'SMALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(577726102930001069)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Large'
,p_lov_return_value=>'LARGE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/icon_libraries
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1284197032342757201)
,p_lov_name=>'ICON_LIBRARIES'
,p_lov_query=>'.'||wwv_flow_imp.id(1284197032342757201)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(482960538470359174)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Font APEX'
,p_lov_return_value=>'FONTAPEX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(72460945675795418)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Font APEX - Latest'
,p_lov_return_value=>'FONTAPEX_LATEST'
);
end;
/
prompt --application/shared_components/user_interface/lovs/image_preview_repository
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2545625667361279)
,p_lov_name=>'IMAGE PREVIEW REPOSITORY'
,p_lov_query=>'.'||wwv_flow_imp.id(2545625667361279)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2545817600361279)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Standard Images'
,p_lov_return_value=>'STANDARD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2546030307361279)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Workspace Images'
,p_lov_return_value=>'WORKSPACE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2546221573361279)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Application Images'
,p_lov_return_value=>'APPLICATION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(483093902289716002)
,p_lov_disp_sequence=>35
,p_lov_disp_value=>'Font APEX'
,p_lov_return_value=>'FONTAPEX'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_themes t,',
'       wwv_flow_user_interfaces ui',
' where ui.flow_id           = :FB_FLOW_ID',
'   and ui.security_group_id = :FLOW_SECURITY_GROUP_ID',
'   and t.flow_id            = ui.flow_id',
'   and t.theme_id           = ui.theme_id',
'   and t.security_group_id  = ui.security_group_id',
'   and t.icon_library       = ''FONTAPEX'''))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1362021991963894895)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Font Awesome Icons'
,p_lov_return_value=>'FONTAWESOME'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select 1',
'  from wwv_flow_themes t,',
'       wwv_flow_user_interfaces ui',
' where ui.flow_id           = :FB_FLOW_ID',
'   and ui.security_group_id = :FLOW_SECURITY_GROUP_ID',
'   and t.flow_id            = ui.flow_id',
'   and t.theme_id           = ui.theme_id',
'   and t.security_group_id  = ui.security_group_id',
'   and t.icon_library       = ''FONTAWESOME'''))
);
end;
/
prompt --application/shared_components/user_interface/lovs/image_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84856825191363086)
,p_lov_name=>'IMAGE_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(84856825191363086)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84857007575363086)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'All Images'
,p_lov_return_value=>'0'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84857400079363087)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Workspace Images (only)'
,p_lov_return_value=>'2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84857607859363087)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Application Images (only)'
,p_lov_return_value=>'3'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_functions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(60545525798060811)
,p_lov_name=>'INCLUDE FUNCTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(60545525798060811)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(60545732724060813)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Functions'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_packages
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(60546306536064747)
,p_lov_name=>'INCLUDE PACKAGES'
,p_lov_query=>'.'||wwv_flow_imp.id(60546306536064747)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(60546524313064747)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Packages'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_procedures
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(60547120735068828)
,p_lov_name=>'INCLUDE PROCEDURES'
,p_lov_query=>'.'||wwv_flow_imp.id(60547120735068828)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(60547315471068829)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Procedures'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_table_and_form_query_and_update
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(91319600010962461)
,p_lov_name=>'INCLUDE TABLE AND FORM (QUERY AND UPDATE)'
,p_lov_query=>'.'||wwv_flow_imp.id(91319600010962461)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91319803768962466)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Query Only'
,p_lov_return_value=>'QUERY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91320004153962467)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Query and Update'
,p_lov_return_value=>'UPDATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_views
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(6397115937331647)
,p_lov_name=>'INCLUDE VIEWS'
,p_lov_query=>'.'||wwv_flow_imp.id(6397115937331647)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(6397327633331648)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Views'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_analysis_pages
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(168959914296647601)
,p_lov_name=>'INCLUDE_ANALYSIS_PAGES'
,p_lov_query=>'.'||wwv_flow_imp.id(168959914296647601)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(168960106462647608)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Include Analysis Pages'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_custom_calendar
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(497222811063840780)
,p_lov_name=>'INCLUDE_CUSTOM_CALENDAR'
,p_lov_query=>'select wwv_flow_lang.system_message(''CONFIRM.INCLUDE_CUSTOM_CALENDAR'') d, ''Y'' r from dual'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_exclude
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84357332667662999)
,p_lov_name=>'INCLUDE_EXCLUDE'
,p_lov_query=>'.'||wwv_flow_imp.id(84357332667662999)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84357508456662999)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Exclude'
,p_lov_return_value=>'EXCLUDE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84357711858663000)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Include'
,p_lov_return_value=>'INCLUDE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_legacy_javascript
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(723325277005791161)
,p_lov_name=>'INCLUDE_LEGACY_JAVASCRIPT'
,p_lov_query=>'.'||wwv_flow_imp.id(723325277005791161)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(723325530060791162)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Pre 18.1'
,p_lov_return_value=>'PRE18'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(723325916568791163)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'18.x'
,p_lov_return_value=>'18'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_shared_components_y
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(417652505855073319)
,p_lov_name=>'INCLUDE_SHARED_COMPONENTS_Y'
,p_lov_query=>'.'||wwv_flow_imp.id(417652505855073319)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(417652808595073320)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Include Shared Components'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/include_success_message
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84362432452672420)
,p_lov_name=>'INCLUDE_SUCCESS_MESSAGE'
,p_lov_query=>'.'||wwv_flow_imp.id(84362432452672420)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84362620952672421)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'include process success message'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/install_flow_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(73071600194414972)
,p_lov_name=>'INSTALL.FLOW.OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(73071600194414972)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(73072113397414978)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Auto Assign New Application ID'
,p_lov_return_value=>'AUTO'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(73071919023414978)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Reuse Application ID &P49_IMP_FLOW_ID. From Export File'
,p_lov_return_value=>'REUSE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(73106501130701222)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Change Application ID'
,p_lov_return_value=>'SPECIFY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/installer_build_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(35684329623125996)
,p_lov_name=>'INSTALLER BUILD OPTIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select patch_name, id from wwv_flow_patches ',
'where id in (select build_opt_id from wwv_flow_install_build_opt',
'              where flow_id = :fb_flow_id',
'                and security_group_id = :flow_security_group_id)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/install_condition_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2610902469203915)
,p_lov_name=>'INSTALL_CONDITION_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(2610902469203915)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2611107226203916)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Exists (SQL query returns at least one row)'
,p_lov_return_value=>'EXISTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2611302822203917)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'NOT Exists (SQL query returns no rows)'
,p_lov_return_value=>'NOT_EXISTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2611722452203917)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Expression'
,p_lov_return_value=>'EXPRESSION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2611903369203917)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Function Body Returning a Boolean'
,p_lov_return_value=>'FUNCTION_BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2612125323203917)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Value of User Preference in Expression 1 = Expression 2'
,p_lov_return_value=>'USER_PREF_IN_COND_EQ_COND2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2612300618203918)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Value of User Preference in Expression 1 != Expression 2'
,p_lov_return_value=>'USER_PREF_IN_COND_NOT_EQ_COND2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2612510467203918)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Text in Expression 1 Is Contained within the Text in Expression 2'
,p_lov_return_value=>'DISPLAY_COND_IN_COND_TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2612716470203918)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Text in Expression 1 Is NOT Contained within the Text in Expression 2'
,p_lov_return_value=>'DISPLAY_COND_NOT_IN_COND_TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2612916275203918)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Text in Expression 1 = Expression 2 (includes &amp;ITEM substitutions)'
,p_lov_return_value=>'DISPLAY_COND_EQUAL_COND_TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2613122730203919)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Text in Expression 1 != Expression 2 (includes &amp;ITEM substitutions)'
,p_lov_return_value=>'DISP_COND_NOT_EQUAL_COND_TEXT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2613308299203919)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Current Language Is Contained within Expression 1'
,p_lov_return_value=>'CURRENT_LANG_IN_COND1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2613518327203919)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Current Language Is NOT Contained within Expression 1'
,p_lov_return_value=>'CURRENT_LANG_NOT_IN_COND1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2613719056203919)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Current Language != Expression 1'
,p_lov_return_value=>'CURRENT_LANG_NOT_EQ_COND1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2613931075203919)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Current Language = Expression 1'
,p_lov_return_value=>'CURRENT_LANG_EQ_COND1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2614914590207416)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'When CGI_ENV DAD_NAME = Expression 1'
,p_lov_return_value=>'DAD_NAME_EQ_CONDITION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2615524633210304)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'When CGI_ENV DAD_NAME != Expression 1'
,p_lov_return_value=>'DAD_NAME_NOT_EQ_CONDITION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2615829827211851)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>'When CGI_ENV SERVER_NAME = Expression 1'
,p_lov_return_value=>'SERVER_NAME_EQ_CONDITION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2616102946213515)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>'When CGI_ENV SERVER_NAME != Expression 1'
,p_lov_return_value=>'SERVER_NAME_NOT_EQ_CONDITION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2616407448214867)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'When CGI_ENV HTTP_HOST = Expression 1'
,p_lov_return_value=>'HTTP_HOST_EQ_CONDITION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2616711258215952)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>'When CGI_ENV HTTP_HOST != Expression 1'
,p_lov_return_value=>'HTTP_HOST_NOT_EQ_CONDITION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(35854932212539564)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Application Schema is in comma separated list in Expression 1'
,p_lov_return_value=>'SCHEMA_IN_LIST'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>'1=0'
,p_lov_disp_cond2=>'SQL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(35855211911543166)
,p_lov_disp_sequence=>31
,p_lov_disp_value=>'Application Schema NOT in comma separated list in Expression 1'
,p_lov_return_value=>'SCHEMA_NOT_IN_LIST'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>'1=0'
,p_lov_disp_cond2=>'SQL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(47908326353191665)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Previous Software Version < Version Specified in Expression 1'
,p_lov_return_value=>'PREV_VERSION_LESS_THAN'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(47908631893193277)
,p_lov_disp_sequence=>41
,p_lov_disp_value=>'Previous Software Version = Version Specified in Expression 1'
,p_lov_return_value=>'PREV_VERSION_EQUALS'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(47908904320194771)
,p_lov_disp_sequence=>42
,p_lov_disp_value=>'Previous Software Version > Version Specified in Expression 1'
,p_lov_return_value=>'PREV_VERSION_GREATER_THAN'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2617015067217035)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'Never'
,p_lov_return_value=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2617419223218210)
,p_lov_disp_sequence=>101
,p_lov_disp_value=>'Always'
,p_lov_return_value=>'ALWAYS'
);
end;
/
prompt --application/shared_components/user_interface/lovs/install_script_source
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(4626801323289842)
,p_lov_name=>'INSTALL_SCRIPT_SOURCE'
,p_lov_query=>'.'||wwv_flow_imp.id(4626801323289842)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4627023954289843)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'From Scratch'
,p_lov_return_value=>'SCRATCH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4627422435289843)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'From File'
,p_lov_return_value=>'FILE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(534087945348728527)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'From Database Object'
,p_lov_return_value=>'DB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1711580816703200)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Data Package'
,p_lov_return_value=>'DATA'
);
end;
/
prompt --application/shared_components/user_interface/lovs/install_ws_app_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(504711916337338970)
,p_lov_name=>'INSTALL_WS_APP_OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(504711916337338970)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(504712121140338973)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Auto Assign New Application ID'
,p_lov_return_value=>'AUTO'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(504712330088338973)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Reuse Application ID &P494_IMP_WS_APP_ID. From Export File'
,p_lov_return_value=>'REUSE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(504712504417338973)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Change Application ID'
,p_lov_return_value=>'SPECIFY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/irr_rowid_or_cols
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(114719118636380285)
,p_lov_name=>'IRR.ROWID_OR_COLS'
,p_lov_query=>'.'||wwv_flow_imp.id(114719118636380285)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(114719413876380287)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'ROWID'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(114719616889380287)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Unique Column'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/irr_column_filter_lov
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(147261022842307147)
,p_lov_name=>'IRR_COLUMN_FILTER_LOV'
,p_lov_query=>'.'||wwv_flow_imp.id(147261022842307147)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(147261325305307148)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'None'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(147261517398307148)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Default Based on Column Type'
,p_lov_return_value=>'D'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(147261708729307148)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Use Defined List of Values to Filter Exact Match'
,p_lov_return_value=>'S'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(46425214824687279)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Use Defined List of Values to Filter Word Contains'
,p_lov_return_value=>'C'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(450175625286008190)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Use Named List of Values to Filter Exact Match'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(450177224509026910)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Use Named List of Values to Filter Word Contains'
,p_lov_return_value=>'2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/irr_link_column
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(134903721394714997)
,p_lov_name=>'IRR_LINK_COLUMN'
,p_lov_query=>'.'||wwv_flow_imp.id(134903721394714997)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(134904030028714997)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Link to Single Row View'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(134905202132718861)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Link to Custom Target'
,p_lov_return_value=>'C'
,p_lov_disp_cond_type=>'CURRENT_PAGE_IN_CONDITION'
,p_lov_disp_cond=>'601'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(134904219905714998)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Exclude Link Column'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_notify_interval
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(30663301353708410)
,p_lov_name=>'IR_NOTIFY_INTERVAL'
,p_lov_query=>'.'||wwv_flow_imp.id(30663301353708410)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(30663617752708413)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Daily'
,p_lov_return_value=>'D'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(30663926891708420)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Weekly'
,p_lov_return_value=>'W'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(30664230138708420)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Monthly'
,p_lov_return_value=>'M'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_notify_status
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(30664415898712648)
,p_lov_name=>'IR_NOTIFY_STATUS'
,p_lov_query=>'.'||wwv_flow_imp.id(30664415898712648)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(30664728283712648)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Submitted'
,p_lov_return_value=>'SUBMITTED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(30665008213712648)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Sent'
,p_lov_return_value=>'SENT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(30665313148712651)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Error'
,p_lov_return_value=>'ERROR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1703941607612344)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Skipped'
,p_lov_return_value=>'SKIPPED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ir_report_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(591769261601865016)
,p_lov_name=>'IR_REPORT_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(591769261601865016)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(591769521956865020)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Primary Default'
,p_lov_return_value=>'PRIMARY_DEFAULT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(591769894133865024)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Alternative Default'
,p_lov_return_value=>'ALTERNATIVE_DEFAULT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(591770186081865024)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Public'
,p_lov_return_value=>'PUBLIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(591770409876865025)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Private'
,p_lov_return_value=>'PRIVATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/iscolumn_name_text
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(23469230991802389)
,p_lov_name=>'ISCOLUMN.NAME.TEXT'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select ''<span class="instructiontext">''||',
'wwv_flow_lang.system_message(''F4300_INSTRUCT_TEXT'')||''</span>'' d, ''Y'' r from dual'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_and_report
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(146337627678444760)
,p_lov_name=>'ITEM AND REPORT'
,p_lov_query=>'.'||wwv_flow_imp.id(146337627678444760)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(146337822091444773)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Page Item'
,p_lov_return_value=>'ITEM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(146338027107444777)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Report'
,p_lov_return_value=>'REPORT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_protection_level
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(17287012676783081)
,p_lov_name=>'ITEM PROTECTION LEVEL'
,p_lov_query=>'.'||wwv_flow_imp.id(17287012676783081)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17287200195783083)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unrestricted'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17287400587783083)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Checksum Required - Application Level'
,p_lov_return_value=>'B'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17287603082783083)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Checksum Required - User Level'
,p_lov_return_value=>'P'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17287806322783083)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Checksum Required - Session Level'
,p_lov_return_value=>'S'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(17304317734788157)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Restricted - May not be set from browser'
,p_lov_return_value=>'I'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_protection_level_d
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(109261519627066371)
,p_lov_name=>'ITEM PROTECTION LEVEL D'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'for c1 in (select nvl(PAGE_PROTECTION_ENABLED_Y_N,''N'') p from wwv_flows where id = :FB_FLOW_ID) loop',
'    if c1.p = ''Y'' then',
'       return  ''select wwv_flow_lang.system_message(''''UNRESTRICTED'''') d, ''''N'''' r',
'                  from dual union all',
'                select wwv_flow_lang.system_message(''''CHECKSUM_REQUIRED_APPLICATION'''') d, ''''B'''' r',
'                  from dual union all',
'                select wwv_flow_lang.system_message(''''CHECKSUM_REQUIRED_USER'''') d, ''''P'''' r',
'                  from dual union all               ',
'                select wwv_flow_lang.system_message(''''CHECKSUM_REQUIRED_SESSION'''') d, ''''S'''' r',
'                  from dual union all               ',
'                select wwv_flow_lang.system_message(''''RESTRICTED_NO_SET_FROM_BROWSER'''') d, ''''I'''' r',
'                  from dual'';',
'    else',
'       return  ''select wwv_flow_lang.system_message(''''UNRESTRICTED'''') d, ''''N'''' r',
'                  from dual union all ',
'                select wwv_flow_lang.system_message(''''RESTRICTED_NO_SET_FROM_BROWSER'''') d, ''''I'''' r',
'                  from dual'';',
'    end if;',
'end loop;'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_protection_level_no_restricted
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(109314413723246310)
,p_lov_name=>'ITEM PROTECTION LEVEL NO RESTRICTED'
,p_lov_query=>'.'||wwv_flow_imp.id(109314413723246310)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(109314629939246312)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Unrestricted'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(109314820854246316)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Checksum Required - Application Level'
,p_lov_return_value=>'B'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(109315024526246316)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Checksum Required - User Level'
,p_lov_return_value=>'P'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(109315221763246316)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Checksum Required - Session Level'
,p_lov_return_value=>'S'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_caching_rule
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84930714296823567)
,p_lov_name=>'ITEM.CACHING.RULE'
,p_lov_query=>'.'||wwv_flow_imp.id(84930714296823567)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84930930267823568)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Always, replacing any existing value in session state'
,p_lov_return_value=>'NO'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84931103028823568)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Only when current value in session state is null'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_default_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(38747715987262349)
,p_lov_name=>'ITEM.DEFAULT.TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(38747715987262349)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(38748018541262374)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Static Text with Session State Substitutions'
,p_lov_return_value=>'STATIC_TEXT_WITH_SUBSTITUTIONS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(38748231848262376)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'PL/SQL Function Body'
,p_lov_return_value=>'PLSQL_FUNCTION_BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(38748428126262376)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'PL/SQL Expression'
,p_lov_return_value=>'PLSQL_EXPRESSION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_help_search
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84895631752563737)
,p_lov_name=>'ITEM.HELP.SEARCH'
,p_lov_query=>'.'||wwv_flow_imp.id(84895631752563737)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84895800944563739)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'All Pages'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84896012258563739)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Current Page'
,p_lov_return_value=>'CURRENT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_button_template
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(387672699225327824)
,p_lov_name=>'ITEM_BUTTON_TEMPLATE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(template_name) d, ''template:''||id r',
'from   wwv_flow_button_templates',
'where  flow_id = :fb_flow_id and',
'       (:fb_theme_id is null or theme_id = :fb_theme_id)',
'order by upper(template_name)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_current_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84729824360877320)
,p_lov_name=>'ITEM_CURRENT_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(84729824360877320)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(14501616510583410)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Current Page is Target'
,p_lov_return_value=>'TARGET_PAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84730000591877321)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Always'
,p_lov_return_value=>'ALWAYS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84730215547877321)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Comma Delimited Page List'
,p_lov_return_value=>'COLON_DELIMITED_PAGE_LIST'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84730407325877321)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Exists SQL Query'
,p_lov_return_value=>'EXISTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84730612612877322)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Never'
,p_lov_return_value=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84730804253877322)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Not Exists SQL Query'
,p_lov_return_value=>'NOT_EXISTS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84731025371877322)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Expression'
,p_lov_return_value=>'EXPRESSION'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_source_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(129889837649)
,p_lov_name=>'ITEM_SOURCE_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(129889837649)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(129890840816)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Null'
,p_lov_return_value=>'ALWAYS_NULL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(129891851389)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Static Assignment (value equals source attribute)'
,p_lov_return_value=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(129892852681)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'SQL Query (return single value)'
,p_lov_return_value=>'QUERY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(458482816683473299)
,p_lov_disp_sequence=>35
,p_lov_disp_value=>'SQL Query (return colon separated value)'
,p_lov_return_value=>'QUERY_COLON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(129893855391)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Item (application or page item name)'
,p_lov_return_value=>'ITEM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(129894857627)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Expression'
,p_lov_return_value=>'EXPRESSION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(133432340478)
,p_lov_disp_sequence=>55
,p_lov_disp_value=>'Function Body'
,p_lov_return_value=>'FUNCTION_BODY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(129895858879)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Database Column'
,p_lov_return_value=>'DB_COLUMN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(76368092101)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Preference'
,p_lov_return_value=>'PREFERENCE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_types_requires_application_context
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(29353308376249352)
,p_lov_name=>'ITEM_TYPES (REQUIRES APPLICATION CONTEXT)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select display_name,',
'       name_with_prefix',
'  from wwv_flow_native_plugins',
' where plugin_type = ''ITEM TYPE''',
' union all',
'select display_name || wwv_flow_lang.system_message(''PLUGIN.DISPLAY_NAME_POSTFIX''),',
'       ''PLUGIN_'' || name',
'  from wwv_flow_plugins',
' where flow_id = to_number(:FB_FLOW_ID)',
'   and security_group_id = to_number(:WORKSPACE_ID)',
'   and plugin_type = ''ITEM TYPE''',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_types_without_plugins
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(29544521926748713)
,p_lov_name=>'ITEM_TYPES (WITHOUT PLUGINS)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_native_plugins varchar2(255);',
'begin',
'    l_native_plugins := '' union all select display_name as d, name_with_prefix as r from wwv_flow_native_plugins where plugin_type = ''''ITEM TYPE'''' order by 1'';',
'',
'    if lower(wwv_flow.g_flow_language) = ''en'' then',
'        return ''select display_name as d, name as r from wwv_flow_standard_item_types''||l_native_plugins;',
'    else',
'        return ''select wwv_flow_lang.system_message(''''ITEM_TYPE.''''||name) as d, name as r from wwv_flow_standard_item_types''||l_native_plugins;',
'    end if;',
'end;'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/item_types_including_button_requires_application_context
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(828112523658823842)
,p_lov_name=>'ITEM_TYPES INCLUDING BUTTON (REQUIRES APPLICATION CONTEXT)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare',
'    l_lov varchar2(32767);',
'begin',
'    if lower(wwv_flow.g_flow_language) = ''en'' then',
'        l_lov := ''select display_name as d, name as r from wwv_flow_standard_item_types'';',
'    else',
'        l_lov := ''select wwv_flow_lang.system_message(''''ITEM_TYPE.''''||name) as d, name as r from wwv_flow_standard_item_types'';',
'    end if;',
'',
'    return l_lov ||',
'           '' union all ''||',
'           ''select display_name, name_with_prefix from wwv_flow_native_plugins ''||',
'           ''where plugin_type = ''''ITEM TYPE''''''||',
'           '' union all ''||',
'           ''select display_name||wwv_flow_lang.system_message(''''PLUGIN.DISPLAY_NAME_POSTFIX''''), ''''PLUGIN_''''||name from wwv_flow_plugins ''||',
'           ''where flow_id = to_number(:FB_FLOW_ID) and security_group_id = to_number(:WORKSPACE_ID) and plugin_type = ''''ITEM TYPE'''' order by 1'';',
'end;'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/iud_select
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(88127426312675871)
,p_lov_name=>'IUD.SELECT'
,p_lov_query=>'.'||wwv_flow_imp.id(88127426312675871)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88156615137966014)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Insert'
,p_lov_return_value=>'I'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88156828112966014)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Update'
,p_lov_return_value=>'U'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88157015984966014)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Delete'
,p_lov_return_value=>'D'
);
end;
/
prompt --application/shared_components/user_interface/lovs/jet_chart_coordinate
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(272269905187811870)
,p_lov_name=>'JET_CHART_COORDINATE'
,p_lov_query=>'.'||wwv_flow_imp.id(272269905187811870)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(272270240012811871)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Polar'
,p_lov_return_value=>'polar'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(272270622978811872)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Cartesian'
,p_lov_return_value=>'cartesian'
);
end;
/
prompt --application/shared_components/user_interface/lovs/jet_chart_gallery
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(246508417548358609)
,p_lov_name=>'JET_CHART_GALLERY'
,p_lov_query=>'.'||wwv_flow_imp.id(246508417548358609)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(246508701590358611)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Area'
,p_lov_return_value=>'area'
,p_lov_template=>'#DISPLAY_VALUE#| chart-area'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(246509129938358611)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Bar'
,p_lov_return_value=>'bar'
,p_lov_template=>'#DISPLAY_VALUE#| chart-bar'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(205873042229302453)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Box Plot'
,p_lov_return_value=>'boxPlot'
,p_lov_template=>'#DISPLAY_VALUE#| chart-box-plot'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(246509548297358616)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Bubble'
,p_lov_return_value=>'bubble'
,p_lov_template=>'#DISPLAY_VALUE#| chart-bubble'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(246509973226358616)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Combination'
,p_lov_return_value=>'combo'
,p_lov_template=>'#DISPLAY_VALUE#| chart-combo'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(246510306110358617)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Status Meter Gauge'
,p_lov_return_value=>'dial'
,p_lov_template=>'#DISPLAY_VALUE#| chart-dial'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(308729675689444557)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Donut'
,p_lov_return_value=>'donut'
,p_lov_template=>'#DISPLAY_VALUE#| chart-donut'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(246510750377358617)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Funnel'
,p_lov_return_value=>'funnel'
,p_lov_template=>'#DISPLAY_VALUE#| chart-funnel'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(558148316798907518)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Gantt'
,p_lov_return_value=>'GANTT'
,p_lov_template=>'#DISPLAY_VALUE#| chart-gantt'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(246511142688358617)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Line'
,p_lov_return_value=>'line'
,p_lov_template=>'#DISPLAY_VALUE#| chart-line'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(246511596688358617)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Line with Area'
,p_lov_return_value=>'lineWithArea'
,p_lov_template=>'#DISPLAY_VALUE#| chart-line-area'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(246511943759358621)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Pie'
,p_lov_return_value=>'pie'
,p_lov_template=>'#DISPLAY_VALUE#| chart-pie'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(308729953426446044)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Polar'
,p_lov_return_value=>'polar'
,p_lov_template=>'#DISPLAY_VALUE#| chart-polar'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(155504274794633386)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Pyramid'
,p_lov_return_value=>'pyramid'
,p_lov_template=>'#DISPLAY_VALUE#| chart-pyramid'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(308730221520447970)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'Radar'
,p_lov_return_value=>'radar'
,p_lov_template=>'#DISPLAY_VALUE#| chart-radar'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(308730765229451160)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'Range'
,p_lov_return_value=>'range'
,p_lov_template=>'#DISPLAY_VALUE#| chart-range-bar'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(246512388827358624)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>'Scatter'
,p_lov_return_value=>'scatter'
,p_lov_template=>'#DISPLAY_VALUE#| chart-scatter'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(246512701000358624)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>'Stock'
,p_lov_return_value=>'stock'
,p_lov_template=>'#DISPLAY_VALUE#| chart-stock'
);
end;
/
prompt --application/shared_components/user_interface/lovs/jet_chart_legend
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(272324713923013998)
,p_lov_name=>'JET_CHART_LEGEND'
,p_lov_query=>'.'||wwv_flow_imp.id(272324713923013998)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(272325099342014001)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'None'
,p_lov_return_value=>'none'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(272325497871014002)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Automatic'
,p_lov_return_value=>'auto'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(272325879803014002)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Bottom'
,p_lov_return_value=>'bottom'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(272326207002014002)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'End'
,p_lov_return_value=>'end'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(272326686037014003)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Start'
,p_lov_return_value=>'start'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(272327073014014003)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Top'
,p_lov_return_value=>'top'
);
end;
/
prompt --application/shared_components/user_interface/lovs/jet_chart_orientation
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(272256574572764306)
,p_lov_name=>'JET_CHART_ORIENTATION'
,p_lov_query=>'.'||wwv_flow_imp.id(272256574572764306)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(272256824856764320)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Horizontal'
,p_lov_return_value=>'horizontal'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(272257282840764322)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Vertical'
,p_lov_return_value=>'vertical'
);
end;
/
prompt --application/shared_components/user_interface/lovs/jet_chart_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(285041260607381464)
,p_lov_name=>'JET_CHART_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(285041260607381464)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(285041507970381478)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Area'
,p_lov_return_value=>'area'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(285041919546381481)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Bar'
,p_lov_return_value=>'bar'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(285042396209381481)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Bubble'
,p_lov_return_value=>'bubble'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(285042788719381482)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Combination'
,p_lov_return_value=>'combo'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(285043177232381482)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Status Meter Gauge'
,p_lov_return_value=>'dial'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(308720430074729586)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Donut'
,p_lov_return_value=>'donut'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(285043586888381482)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Funnel'
,p_lov_return_value=>'funnel'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(285043903336381482)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Line'
,p_lov_return_value=>'line'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(285044346749381483)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'Line with Area'
,p_lov_return_value=>'lineWithArea'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(285044729648381483)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Pie'
,p_lov_return_value=>'pie'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(308719871403728110)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Polar'
,p_lov_return_value=>'polar'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(308720132434728806)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Radar'
,p_lov_return_value=>'radar'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(308719513006727167)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Range'
,p_lov_return_value=>'range'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(285045130826381483)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Scatter'
,p_lov_return_value=>'scatter'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(285045589583381483)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Stock'
,p_lov_return_value=>'stock'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(155509538047810000)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'Pyramid'
,p_lov_return_value=>'pyramid'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(205878611297350098)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'Box Plot'
,p_lov_return_value=>'boxPlot'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(5411068630930906)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>'Gantt'
,p_lov_return_value=>'GANTT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/jet_gauge_orientation
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(21606267597566254)
,p_lov_name=>'JET_GAUGE_ORIENTATION'
,p_lov_query=>'.'||wwv_flow_imp.id(21606267597566254)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21606569316566254)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Circular'
,p_lov_return_value=>'circular'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21606931960566254)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Horizontal'
,p_lov_return_value=>'horizontal'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(21607248117566255)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Vertical'
,p_lov_return_value=>'vertical'
);
end;
/
prompt --application/shared_components/user_interface/lovs/jstree_themes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(445986021038615393)
,p_lov_name=>'JSTREE_THEMES'
,p_lov_query=>'.'||wwv_flow_imp.id(445986021038615393)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(445986827650615404)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Default'
,p_lov_return_value=>'default'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(445986226113615399)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Blue'
,p_lov_return_value=>'apple'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(445986611271615404)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Classic'
,p_lov_return_value=>'classic'
);
end;
/
prompt --application/shared_components/user_interface/lovs/label_theme_class_id
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(43828319065855502)
,p_lov_name=>'LABEL THEME CLASS ID'
,p_lov_query=>'.'||wwv_flow_imp.id(43828319065855502)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43828604595855506)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Optional Label with Help'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43828821955855506)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Required Label with Help'
,p_lov_return_value=>'2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43829026521855506)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Optional Label'
,p_lov_return_value=>'3'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43829216754855507)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Required Label'
,p_lov_return_value=>'4'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(44168504088920423)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'No Label'
,p_lov_return_value=>'13'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43829403095855507)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 1'
,p_lov_return_value=>'5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43829614163855507)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 2'
,p_lov_return_value=>'6'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43829811310855507)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 3'
,p_lov_return_value=>'7'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43830028586855508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 4'
,p_lov_return_value=>'8'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43830230461855508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 5'
,p_lov_return_value=>'9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43830425504855508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 6'
,p_lov_return_value=>'10'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43830605003855508)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 7'
,p_lov_return_value=>'11'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43830820404855509)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 8'
,p_lov_return_value=>'12'
);
end;
/
prompt --application/shared_components/user_interface/lovs/label_alignment
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84757522618851451)
,p_lov_name=>'LABEL_ALIGNMENT'
,p_lov_query=>'.'||wwv_flow_imp.id(84757522618851451)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84757729764851451)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Above '
,p_lov_return_value=>'ABOVE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84757914076851452)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Below'
,p_lov_return_value=>'BELOW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84758122408851452)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Center'
,p_lov_return_value=>'CENTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84758309833851452)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Center bottom'
,p_lov_return_value=>'CENTER-BOTTOM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84758526184851452)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Center center'
,p_lov_return_value=>'CENTER-CENTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84758718640851453)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Center top'
,p_lov_return_value=>'CENTER-TOP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84758917390851453)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Start'
,p_lov_return_value=>'LEFT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84759122923851453)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Start bottom'
,p_lov_return_value=>'LEFT-BOTTOM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84759320284851453)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'Start center'
,p_lov_return_value=>'LEFT-CENTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84759518480851454)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'Start top'
,p_lov_return_value=>'LEFT-TOP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84759731211851454)
,p_lov_disp_sequence=>110
,p_lov_disp_value=>'End'
,p_lov_return_value=>'RIGHT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84759903007851454)
,p_lov_disp_sequence=>120
,p_lov_disp_value=>'End bottom'
,p_lov_return_value=>'RIGHT-BOTTOM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84760105209851455)
,p_lov_disp_sequence=>130
,p_lov_disp_value=>'End center'
,p_lov_return_value=>'RIGHT-CENTER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84760318434851455)
,p_lov_disp_sequence=>140
,p_lov_disp_value=>'End top'
,p_lov_return_value=>'RIGHT-TOP'
);
end;
/
prompt --application/shared_components/user_interface/lovs/label_template_wiz
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86598309219256908)
,p_lov_name=>'LABEL_TEMPLATE_WIZ'
,p_lov_query=>'.'||wwv_flow_imp.id(86598309219256908)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88294304634805085)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Choose one from the &PRODUCT_NAME. repository'
,p_lov_return_value=>'DEFAULT'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91902324410976802)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'From Scratch'
,p_lov_return_value=>'BLANK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(91903301685979689)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'As a Copy of an Existing Template'
,p_lov_return_value=>'COPY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/languages_installed
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(631619712812572565)
,p_lov_name=>'LANGUAGES_INSTALLED'
,p_lov_query=>'.'||wwv_flow_imp.id(631619712812572565)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(631619916261572566)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'English'
,p_lov_return_value=>'en'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = (select v(''APP_ID'') from dual)',
'       and translation_flow_language_code = ''zh-cn'')         '))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(631620120219572571)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Chinese (China)'
,p_lov_return_value=>'zh-cn'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = (select v(''APP_ID'') from dual)',
'       and translation_flow_language_code = ''zh-cn'')         '))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(631620319438572571)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Chinese (Taiwan)'
,p_lov_return_value=>'zh-tw'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = (select v(''APP_ID'') from dual)',
'       and translation_flow_language_code = ''zh-tw'')         '))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(631620524976572571)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Spanish'
,p_lov_return_value=>'es'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = (select v(''APP_ID'') from dual)',
'       and translation_flow_language_code = ''es'')         '))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(631620730994572572)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Italian'
,p_lov_return_value=>'it'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = (select v(''APP_ID'') from dual)',
'       and translation_flow_language_code = ''it'')         '))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(631620918813572572)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'French'
,p_lov_return_value=>'fr'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = (select v(''APP_ID'') from dual)',
'       and translation_flow_language_code = ''fr'')'))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(631621107621572572)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'German'
,p_lov_return_value=>'de'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = (select v(''APP_ID'') from dual)',
'       and translation_flow_language_code = ''de'')         '))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(631621331959572572)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Japanese'
,p_lov_return_value=>'ja'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = (select v(''APP_ID'') from dual)',
'       and translation_flow_language_code = ''ja'')         '))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(631621516834572572)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Portuguese (Brazil)'
,p_lov_return_value=>'pt-br'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = (select v(''APP_ID'') from dual)',
'       and translation_flow_language_code = ''pt-br'')         '))
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(797107324849116848)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Korean'
,p_lov_return_value=>'ko'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null',
'  from wwv_flows',
' where id in ',
'   (select translation_flow_id',
'      from wwv_flow_language_map',
'     where primary_language_flow_id = (select v(''APP_ID'') from dual)',
'       and translation_flow_language_code = ''ko'')'))
);
end;
/
prompt --application/shared_components/user_interface/lovs/language_derived_from
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(73566910745435962)
,p_lov_name=>'LANGUAGE_DERIVED_FROM'
,p_lov_query=>'.'||wwv_flow_imp.id(73566910745435962)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88294907751806000)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'No NLS (Application not translated)'
,p_lov_return_value=>'0'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'933'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88295118806806000)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Application Primary Language'
,p_lov_return_value=>'FLOW_PRIMARY_LANGUAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88295311143806000)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Browser (use browser language preference)'
,p_lov_return_value=>'BROWSER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88295501503806001)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Application Preference (use FSP_LANGUAGE_PREFERENCE)'
,p_lov_return_value=>'FLOW_PREFERENCE'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'933'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88295718259806001)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Item Preference (use item containing preference)'
,p_lov_return_value=>'ITEM_PREFERENCE'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'933'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(253845925497886980)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Session'
,p_lov_return_value=>'SESSION'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'933'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ldap_ssl_lov
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(487674627120619297)
,p_lov_name=>'LDAP_SSL_LOV'
,p_lov_query=>'.'||wwv_flow_imp.id(487674627120619297)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(487674822640619303)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'SSL'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(487675029047619305)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'SSL with Authentication'
,p_lov_return_value=>'A'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(487675215263619306)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'No SSL'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ldap_ssl_plugin_lov
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(29453800248365382)
,p_lov_name=>'LDAP_SSL_PLUGIN_LOV'
,p_lov_query=>'.'||wwv_flow_imp.id(29453800248365382)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(29454107923365385)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'SSL'
,p_lov_return_value=>'SSL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(29454406015365389)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'SSL with Authentication'
,p_lov_return_value=>'SSL_AUTH'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(29454730782365389)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'No SSL'
,p_lov_return_value=>'NO_SSL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/ldap_username_escaping
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(39475531325852002)
,p_lov_name=>'LDAP_USERNAME_ESCAPING'
,p_lov_query=>'.'||wwv_flow_imp.id(39475531325852002)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(39475812001852003)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Standard'
,p_lov_return_value=>'STD'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(39476117154852003)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Only special characters'
,p_lov_return_value=>'ONLY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(39476413911852003)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'No Escaping'
,p_lov_return_value=>'NO'
);
end;
/
prompt --application/shared_components/user_interface/lovs/line_style
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84878309186453156)
,p_lov_name=>'LINE_STYLE'
,p_lov_query=>'.'||wwv_flow_imp.id(84878309186453156)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84878510088453156)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Dotted 1'
,p_lov_return_value=>'DOTTED_1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84878703174453157)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Dotted 2'
,p_lov_return_value=>'DOTTED_2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84878910394453157)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Dotted 3'
,p_lov_return_value=>'DOTTED_3'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84879114364453157)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Solid'
,p_lov_return_value=>'STRAIGHT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/line_weight
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(244579719911969185)
,p_lov_name=>'LINE_WEIGHT'
,p_lov_query=>'.'||wwv_flow_imp.id(244579719911969185)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(244580030013969188)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'1'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(244580206494969189)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'2'
,p_lov_return_value=>'2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(244580404944969189)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'3'
,p_lov_return_value=>'3'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(244580616739969190)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'4'
,p_lov_return_value=>'4'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(244580829606969190)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(244581020219969190)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'6'
,p_lov_return_value=>'6'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(244581203664969190)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'7'
,p_lov_return_value=>'7'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(244581404612969190)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'8'
,p_lov_return_value=>'8'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(244581619284969191)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'9'
,p_lov_return_value=>'9'
);
end;
/
prompt --application/shared_components/user_interface/lovs/link_option
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84330300975616054)
,p_lov_name=>'LINK_OPTION'
,p_lov_query=>'.'||wwv_flow_imp.id(84330300975616054)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88296717080806862)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Nothing'
,p_lov_return_value=>'NOTHING'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88296510521806862)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Existing Application Item'
,p_lov_return_value=>'EXISTING'
);
end;
/
prompt --application/shared_components/user_interface/lovs/link_target
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84811707811178296)
,p_lov_name=>'LINK_TARGET'
,p_lov_query=>'.'||wwv_flow_imp.id(84811707811178296)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84811912899178296)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Current Application'
,p_lov_return_value=>'F'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84812101106178297)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'All Applications'
,p_lov_return_value=>'C'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84812328270178297)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Remote URL'
,p_lov_return_value=>'E'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_deployment_p529
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(169222400131754330)
,p_lov_name=>'LIST DEPLOYMENT P529'
,p_lov_query=>'.'||wwv_flow_imp.id(169222400131754330)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(169222607062754337)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Do not create list region(s)'
,p_lov_return_value=>'0'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(169222802542754344)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Create list region on current page'
,p_lov_return_value=>'CURRENT_PAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(169223024966754344)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Create list region for each target page'
,p_lov_return_value=>'EACH_ENTRY'
,p_lov_disp_cond_type=>'CURRENT_PAGE_NOT_IN_CONDITION'
,p_lov_disp_cond=>'734'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_exportable_flows
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(189999522998166355)
,p_lov_name=>'LIST EXPORTABLE FLOWS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'  from   wwv_flow_visible_flows f',
' order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_flows
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(312074852)
,p_lov_name=>'LIST FLOWS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'from   wwv_flow_visible_flows f',
'where  build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'')',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_items
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(918311972218937)
,p_lov_name=>'LIST ITEMS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(list_item_link_text) d, id from (',
'select lpad('' '',4*(level-1),''.'')|| list_item_link_text list_item_link_text, id',
'from ( ',
'  select id, parent_list_item_id, list_item_display_sequence, list_item_link_text',
'  from wwv_flow_list_items i',
'  where flow_id = :FB_FLOW_ID',
'  and security_group_id = :WORKSPACE_ID',
'  and list_id = :F4000_P4052_LIST_ID',
'  and id not in (',
'    select id from wwv_flow_list_items ',
'    where flow_id = :FB_FLOW_ID',
'    and security_group_id = :WORKSPACE_ID',
'    and list_id = :F4000_P4052_LIST_ID',
'    start with id = :F4000_P4052_ID ',
'    connect by prior id = parent_list_item_id',
'  ))',
'start with parent_list_item_id is null',
'connect by prior id = parent_list_item_id ',
'order siblings by list_item_display_sequence)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_items_inline_edit
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(108645906791566587)
,p_lov_name=>'LIST ITEMS (INLINE EDIT)'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select lpad('' '',4*(level-1),''.'')|| wwv_flow_escape.html(list_item_link_text) list_item_link_text, id',
'from wwv_flow_list_items i',
'where id not in (',
'    select id from wwv_flow_list_items ',
'    where flow_id = :FB_FLOW_ID',
'    and list_id = :P373_LIST_ID',
'    start with id = :P373_ID ',
'    connect by prior id = parent_list_item_id',
')',
'start with parent_list_item_id is null',
'       and flow_id = :FB_FLOW_ID',
'       and list_id = :P373_LIST_ID',
'connect by prior id = parent_list_item_id ',
'        and prior list_id = list_id',
'order siblings by list_item_display_sequence',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_other_flows
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(51319520349273399)
,p_lov_name=>'LIST OTHER FLOWS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct f.id||'' ''||wwv_flow_escape.html(f.name) d, f.id r',
'  from   wwv_flow_visible_flows f',
' where id != :FB_FLOW_ID',
'   and build_status not in (''RUN_ONLY'',''RUN_AND_HIDDEN'')',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_page_regions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(246039671)
,p_lov_name=>'LIST PAGE REGIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select plug_name, id from (',
'select plug_name || '' ('' || plug_display_sequence || '')'' as plug_name,',
'       id,',
'       upper(plug_name) pn,',
'       1 x',
'  from wwv_flow_page_plugs p',
' where flow_id           = :FB_FLOW_ID',
'   and page_id           = :FB_FLOW_PAGE_ID',
'   and security_group_id = :WORKSPACE_ID',
'union',
'select wwv_flow_lang.system_message(''LAYOUT.GLOBAL_PAGE_REGION_PREFIX'') ||',
'       r.plug_name || '' ('' || r.plug_display_sequence || '')'' as plug_name,',
'       r.id,',
'       upper(r.plug_name) pn,',
'       2 x',
'  from wwv_flow_steps p,',
'       wwv_flow_user_interfaces i,',
'       wwv_flow_page_plugs r',
' where p.flow_id           = :FB_FLOW_ID',
'   and p.id                = :FB_FLOW_PAGE_ID',
'   and p.security_group_id = :WORKSPACE_ID',
'   and i.id                = p.user_interface_id',
'   and i.global_page_id   <> :fb_flow_page_id',
'   and r.flow_id           = i.flow_id',
'   and r.page_id           = i.global_page_id',
' order by 4, 3) v'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_pages
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(313088181)
,p_lov_name=>'LIST PAGES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name n, id, id d    ',
'from wwv_flow_steps',
'where flow_id = :FB_FLOW_ID and security_group_id = :flow_security_group_id',
'order by 2'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'ID'
,p_display_column_name=>'N'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(556215676601931892)
,p_query_column_name=>'ID'
,p_display_sequence=>10
,p_data_type=>'NUMBER'
,p_is_visible=>'N'
,p_is_searchable=>'N'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(556216095466931893)
,p_query_column_name=>'D'
,p_heading=>'Page'
,p_display_sequence=>20
,p_data_type=>'NUMBER'
);
wwv_flow_imp_shared.create_list_of_values_cols(
 p_id=>wwv_flow_imp.id(556216448153931893)
,p_query_column_name=>'N'
,p_heading=>'Name'
,p_display_sequence=>30
,p_data_type=>'VARCHAR2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_pages_by_mode
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3783172060018)
,p_lov_name=>'LIST PAGES BY MODE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'declare ',
'  l_page_mode varchar2(10);',
'  l_where     varchar2(100) := '''';',
'begin',
'  l_page_mode := wwv_flow_page_dev.get_page_mode(p_application_id => :FB_FLOW_ID, p_page_id => :FB_FLOW_PAGE_ID);',
'  ',
'  if l_page_mode <> ''NORMAL'' then',
'    l_where := ''and page_mode=''''''||l_page_mode||'''''' '';',
'  end if;',
'',
'    return ''select id||'''' ''''||name n, id ''||',
'           ''from wwv_flow_steps ''||',
'           ''where flow_id = :FB_FLOW_ID and security_group_id = :flow_security_group_id ''||l_where||',
'           ''order by 2 '';',
'',
'end;'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_pages_escaped
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(375967232722946469)
,p_lov_name=>'LIST PAGES ESCAPED'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select id||'' ''||wwv_flow_escape.html(name) n, id',
'from wwv_flow_steps',
'where flow_id = :FB_FLOW_ID and security_group_id = :flow_security_group_id',
'order by 2'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_pagetemplates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(4569556776)
,p_lov_name=>'LIST PAGETEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) name, id',
'from   wwv_flow_templates',
'where  flow_id = :FB_FLOW_ID ',
'and   (:fb_theme_id is null or theme_id = :fb_theme_id)',
'and    is_popup = (case when :P4301_PAGE_MODE = ''NORMAL'' then ''N'' else ''Y'' end)',
'order  by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_theme_class_id
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(43918610013174571)
,p_lov_name=>'LIST THEME CLASS ID'
,p_lov_query=>'.'||wwv_flow_imp.id(43918610013174571)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43918904551174576)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Vertical Unordered List with Bullets'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43919114507174577)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Vertical Ordered List'
,p_lov_return_value=>'2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43919317508174577)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Horizontal Links List'
,p_lov_return_value=>'3'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43919513966174577)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Horizontal Images with Label List'
,p_lov_return_value=>'4'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43919702448174577)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Vertical Images List'
,p_lov_return_value=>'5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43919925901174577)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Button List'
,p_lov_return_value=>'6'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43920119551174578)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Tabbed Navigation List'
,p_lov_return_value=>'7'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43935130193237152)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Wizard Progress List'
,p_lov_return_value=>'17'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(58168303369425651)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Vertical Unordered List without Bullets'
,p_lov_return_value=>'18'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(111810925131441282)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Pull Down Menu'
,p_lov_return_value=>'20'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(111811229980442636)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Pull Down Menu with Image'
,p_lov_return_value=>'21'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(165320913369513737)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Vertical Sidebar List'
,p_lov_return_value=>'19'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43920508983174578)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 1'
,p_lov_return_value=>'9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43920717140174578)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 2'
,p_lov_return_value=>'10'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43920901196174579)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 3'
,p_lov_return_value=>'11'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43921121313174579)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 4'
,p_lov_return_value=>'12'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43921328149174579)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 5'
,p_lov_return_value=>'13'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43921510615174579)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 6'
,p_lov_return_value=>'14'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43921731720174580)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 7'
,p_lov_return_value=>'15'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43922216940176602)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 8'
,p_lov_return_value=>'16'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(172045731559260808)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Hierarchical Expanding'
,p_lov_return_value=>'22'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(172048114721265462)
,p_lov_disp_sequence=>22
,p_lov_disp_value=>'Hierarchical Expanded'
,p_lov_return_value=>'23'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_ldap_hosts
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(159071014187759020)
,p_lov_name=>'LIST.LDAP.HOSTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct',
'       attribute_01 d,',
'       attribute_01 r',
'  from wwv_flow_authentications',
' where scheme_type  = ''NATIVE_LDAP''',
'   and attribute_01 is not null',
'   and security_group_id = :WORKSPACE_ID',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_ldap_ports
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(159071623191761652)
,p_lov_name=>'LIST.LDAP.PORTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct',
'       attribute_02 d,',
'       attribute_02 r',
'  from wwv_flow_authentications',
' where scheme_type  = ''NATIVE_LDAP''',
'   and attribute_02 is not null',
'   and security_group_id = :WORKSPACE_ID',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_ldap_search_filter
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(492934916113886709)
,p_lov_name=>'LIST.LDAP.SEARCH_FILTER'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct',
'       attribute_06 d,',
'       attribute_06 r',
'  from wwv_flow_authentications',
' where scheme_type  = ''NATIVE_LDAP''',
'   and attribute_06 is not null',
'   and security_group_id = :WORKSPACE_ID',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_ldap_strings
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(159072229424763439)
,p_lov_name=>'LIST.LDAP.STRINGS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct',
'       attribute_04 d,',
'       attribute_04 r',
'  from wwv_flow_authentications',
' where scheme_type  = ''NATIVE_LDAP''',
'   and attribute_04 is not null',
'   and security_group_id = :WORKSPACE_ID',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_ldap_username_edit
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(159073420552770275)
,p_lov_name=>'LIST.LDAP.USERNAME.EDIT'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct',
'       attribute_07 d,',
'       attribute_07 r',
'  from wwv_flow_authentications',
' where scheme_type  = ''NATIVE_LDAP''',
'   and attribute_07 is not null',
'   and security_group_id = :WORKSPACE_ID',
' union',
'select ''return wwv_flow_custom_auth_std.ldap_dnprep;'' as d,',
'       ''return wwv_flow_custom_auth_std.ldap_dnprep;'' as r',
'  from dual',
' order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_security_schemes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(166867621769552393)
,p_lov_name=>'LIST.SECURITY.SCHEMES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) name, to_char(id) id',
'  from wwv_flow_security_schemes',
' where flow_id = :fb_flow_id',
'   and security_group_id = :flow_security_group_id',
' union all',
'select ''MUST_NOT_BE_PUBLIC_USER'' name, ''MUST_NOT_BE_PUBLIC_USER'' id',
'  from sys.dual',
' order by name'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_web_services
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(156841902941139735)
,p_lov_name=>'LIST.WEB.SERVICES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) d, id r from wwv_flow_shared_web_services',
'',
'where security_group_id = :flow_security_group_id and',
'',
'      flow_id = :fb_flow_id',
'',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/listallitems
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(598060166)
,p_lov_name=>'LISTALLITEMS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''CONFIRM.APPLICATION'')||',
''': ''||wwv_flow_escape.html(name) a, name b ',
'from wwv_flow_items',
'where flow_id = :FB_FLOW_ID',
'union all',
'select initcap(wwv_flow_lang.system_message(''PAGE''))||',
''': ''||flow_step_id||'': ''||wwv_flow_escape.html(name) a, name b',
'',
'from wwv_flow_step_items',
'',
'where flow_id = :FB_FLOW_ID',
'',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lists
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(158508012343182689)
,p_lov_name=>'LISTS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) d, id ',
'  from wwv_flow_lists',
' where flow_id = :FB_FLOW_ID',
'   and security_group_id = :WORKSPACE_ID',
' order by upper(name)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(304941591413)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(schema) d, schema r',
'from   wwv_flow_company_schemas',
'where  security_group_id = :flow_security_group_id',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_available_schemas2
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(64000716365052273)
,p_lov_name=>'LIST_AVAILABLE_SCHEMAS2'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(c.schema) d, c.schema r',
'',
'from   wwv_flow_company_schemas c,',
'',
'       wwv_flow_fnd_user u',
'',
'where  c.security_group_id = :flow_security_group_id and',
'',
'       u.security_group_id = :flow_security_group_id and',
'',
'       u.user_name = :flow_user and',
'',
'       (u.ALLOW_ACCESS_TO_SCHEMAS is null or    instr('':''||u.ALLOW_ACCESS_TO_SCHEMAS||'':'','':''||c.schema||'':'')>0)',
'',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_button_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(62093031232114360)
,p_lov_name=>'LIST_BUTTON_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) d, id r',
'from   wwv_flow_templates_all',
'where temp_type = ''BUTTON''',
'and flow_id = :fb_flow_id and',
'    (:fb_theme_id is null or theme_id = :fb_theme_id)',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_calendar_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(62098012232137239)
,p_lov_name=>'LIST_CALENDAR_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) d, id r',
'from   wwv_flow_templates_all',
'where temp_type = ''CALENDAR''',
'and flow_id = :fb_flow_id and',
'    (:fb_theme_id is null or theme_id = :fb_theme_id)',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_dialog_page_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(136602725312225757)
,p_lov_name=>'LIST_DIALOG_PAGE_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) name, id',
'from   wwv_flow_templates',
'where  flow_id = :FB_FLOW_ID ',
'and   (:fb_theme_id is null or theme_id = :fb_theme_id)',
'and    is_popup = ''Y''',
'order  by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_flow_status
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(634347472712995)
,p_lov_name=>'LIST_FLOW_STATUS'
,p_lov_query=>'.'||wwv_flow_imp.id(634347472712995)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88157618253966938)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Available'
,p_lov_return_value=>'AVAILABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88157826171966938)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Available with Developer Toolbar'
,p_lov_return_value=>'AVAILABLE_W_EDIT_LINK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88158015347966939)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Available to Developers Only'
,p_lov_return_value=>'DEVELOPERS_ONLY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88158201893966939)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Restricted Access'
,p_lov_return_value=>'RESTRICTED_ACCESS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88158430795966939)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Unavailable'
,p_lov_return_value=>'UNAVAILABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88158618218966939)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Unavailable (Status Shown with PL/SQL)'
,p_lov_return_value=>'UNAVAILABLE_PLSQL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88158822851966939)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'Unavailable (Redirect to URL)'
,p_lov_return_value=>'UNAVAILABLE_URL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_label_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(62099525391141046)
,p_lov_name=>'LIST_LABEL_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) d, id r',
'from   wwv_flow_templates_all',
'where temp_type = ''LABEL''',
'and flow_id = :fb_flow_id and',
'    (:fb_theme_id is null or theme_id = :fb_theme_id)',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_list_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(62101404051144326)
,p_lov_name=>'LIST_LIST_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) d, id r',
'from   wwv_flow_templates_all',
'where temp_type = ''LIST''',
'and flow_id = :fb_flow_id ',
'and theme_id = :fb_theme_id',
'order by upper(name)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_menu_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(62102615133147515)
,p_lov_name=>'LIST_MENU_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) d, id r',
'from   wwv_flow_templates_all',
'where temp_type = ''MENU''',
'and flow_id = :fb_flow_id and',
'    (:fb_theme_id is null or theme_id = :fb_theme_id)',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_page_items
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(5818802865968207)
,p_lov_name=>'LIST_PAGE_ITEMS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select initcap(wwv_flow_lang.system_message(''APPLICATION''))||',
''':''||name a, name b ',
'from wwv_flow_items',
'where flow_id = :FB_FLOW_ID',
'union all',
'select initcap(wwv_flow_lang.system_message(''PAGE''))||',
''': ''||flow_step_id||'': ''||name a, name b',
'from wwv_flow_step_items',
'where flow_id = :FB_FLOW_ID',
'and flow_step_id = :FB_FLOW_PAGE_ID',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_page_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(62094620627120744)
,p_lov_name=>'LIST_PAGE_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) d, id r',
'from   wwv_flow_templates_all',
'where temp_type = ''PAGE''',
'and flow_id = :fb_flow_id and',
'    (:fb_theme_id is null or theme_id = :fb_theme_id)',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_parent_tabsets
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(130412625318)
,p_lov_name=>'LIST_PARENT_TABSETS'
,p_lov_query=>'select distinct wwv_flow_escape.html(tab_set) d, tab_set r from wwv_flow_toplevel_tabs where flow_id = :fb_flow_id order by 1'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_patches
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(198057397)
,p_lov_name=>'LIST_PATCHES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(patch_name) pn, id',
'  from wwv_flow_patches',
' where flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id',
' union all',
'select ''{''||wwv_flow_lang.system_message(''NOT_W_ARGUMENT'', wwv_flow_escape.html(patch_name))||',
'''} '' pn,0-id id',
'  from wwv_flow_patches',
' where flow_id = :FB_FLOW_ID',
'   and security_group_id = :flow_security_group_id',
' order by pn'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_region_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(62103530370151962)
,p_lov_name=>'LIST_REGION_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select theme_id||''. ''||wwv_flow_escape.html(name) d, id r',
'from   wwv_flow_templates_all',
'where temp_type = ''REGION''',
'and flow_id = :fb_flow_id  and',
'    (:fb_theme_id is null or theme_id = :fb_theme_id)',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_report_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(62104811455155975)
,p_lov_name=>'LIST_REPORT_TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select theme_id||''. ''||wwv_flow_escape.html(name) d, id r',
'from   wwv_flow_templates_all',
'where temp_type = ''REPORT''',
'and flow_id = :fb_flow_id and',
'    (:fb_theme_id is null or theme_id = :fb_theme_id)',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_schema
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(385522518549261442)
,p_lov_name=>'LIST_SCHEMA'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(owner) d, owner v',
'  from wwv_flows',
' where id = :FB_FLOW_ID'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_schemas_have_privs
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(77465221343784725)
,p_lov_name=>'LIST_SCHEMAS_HAVE_PRIVS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(owner) d, owner v',
'  from wwv_flow_object_owners_dev',
'order by d                   '))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_tabsets
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(130408529381)
,p_lov_name=>'LIST_TABSETS'
,p_lov_query=>'select wwv_flow_escape.html(d) d, r from wwv_flow_tabset_view'
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_template_wiz
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86596530905253701)
,p_lov_name=>'LIST_TEMPLATE_WIZ'
,p_lov_query=>'.'||wwv_flow_imp.id(86596530905253701)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88297313984807785)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Choose one from the &PRODUCT_NAME. repository'
,p_lov_return_value=>'DEFAULT'
,p_lov_disp_cond_type=>'NEVER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88297514924807786)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'From Scratch'
,p_lov_return_value=>'BLANK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88297709869807786)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'As a Copy of an Existing Template'
,p_lov_return_value=>'COPY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_trees
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(42828313831634427)
,p_lov_name=>'LIST_TREES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(tree_name)||'' (''||initcap(tree_type)||'')'' d,',
'',
'       id',
'',
'from   wwv_flow_trees',
'',
'where  flow_id = :fb_flow_id and',
'',
'       security_group_id = :flow_security_group_id',
'',
'order  by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/list_wiz_lov
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(10676432019281440)
,p_lov_name=>'LIST_WIZ_LOV'
,p_lov_query=>'.'||wwv_flow_imp.id(10676432019281440)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(10676700422281446)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'From Scratch'
,p_lov_return_value=>'BLANK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(10676912271281449)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'As a Copy of an Existing List'
,p_lov_return_value=>'COPY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/load_data_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(23733127290776847)
,p_lov_name=>'LOAD_DATA_TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(23733127290776847)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23733404759776862)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'NUMBER'
,p_lov_return_value=>'NUMBER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23733619464776862)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'VARCHAR2'
,p_lov_return_value=>'VARCHAR2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23733832697776862)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'DATE'
,p_lov_return_value=>'DATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23734009833776862)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'CLOB'
,p_lov_return_value=>'CLOB'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23734214688776863)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'BINARY_FLOAT'
,p_lov_return_value=>'BINARY_FLOAT'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23734413485776863)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'BINARY_DOUBLE'
,p_lov_return_value=>'BINARY_DOUBLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(173822017218331590)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'JSON CLOB'
,p_lov_return_value=>'JSON_CLOB'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>'sys.dbms_db_version.version > 12 or (sys.dbms_db_version.version = 12 and sys.dbms_db_version.release >= 2)'
,p_lov_disp_cond2=>'PLSQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/locally_defined_lov_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3801130412459159)
,p_lov_name=>'LOCALLY_DEFINED_LOV_TYPE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''SC.LOV.PAGE_ITEM'') d,',
'       ''PAGE_ITEM'' r',
'from sys.dual',
'union all',
'select wwv_flow_lang.system_message(''SC.LOV.IG_COLUMN'') d,',
'       ''IG_COLUMN'' r',
'from sys.dual'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_use_local_sync_table=>false
,p_return_column_name=>'R'
,p_display_column_name=>'D'
,p_group_sort_direction=>'ASC'
,p_default_sort_column_name=>'D'
,p_default_sort_direction=>'ASC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lock_status_report_values
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(37430113453704739)
,p_lov_name=>'LOCK STATUS REPORT VALUES'
,p_lov_query=>'.'||wwv_flow_imp.id(37430113453704739)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(37430310670704743)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'All Pages'
,p_lov_return_value=>'ALL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(37430529682704745)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Locked Pages'
,p_lov_return_value=>'LOCKED'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(37430723675704745)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Unlocked Pages'
,p_lov_return_value=>'UNLOCKED'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lock_action
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(857850100888646856)
,p_lov_name=>'LOCK_ACTION'
,p_lov_query=>'.'||wwv_flow_imp.id(857850100888646856)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(857850431729646858)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Lock'
,p_lov_return_value=>'LOCK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(857850739143646859)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Unlock'
,p_lov_return_value=>'UNLOCK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(857851004836646859)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Update'
,p_lov_return_value=>'UPDATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/login_page_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86589528912234244)
,p_lov_name=>'LOGIN_PAGE_TYPE'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select d,r from (',
'    select initcap(',
'wwv_flow_lang.system_message(''USE_PAGE_AS_LOGIN_PAGE'',id)) d, ''LOGIN'' r, 4 ob from wwv_flow_steps where flow_id=:FB_FLOW_ID and upper(alias) = ''LOGIN''',
'  union all',
'    select initcap(',
'wwv_flow_lang.system_message(''CREATE_NEW_LOGIN_PAGE'')) d, ''CREATE'' r,2 ob from dual where',
'not exists (select 1 from wwv_flow_steps where flow_id=:FB_FLOW_ID and upper(alias) = ''LOGIN'')',
'  union all',
'    select initcap(',
'wwv_flow_lang.system_message(''USE_BUILTIN_LOGIN_PAGE''))  d,''-BUILTIN-'' r, 9 ob from dual)',
'order by ob'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/logo_attributes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(461376702019738964)
,p_lov_name=>'LOGO ATTRIBUTES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_lang.system_message(''BLACK_TEXT'') d, ''style="font-family:Arial; color:#000000; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''BLUE_TEXT'') d, ''style="font-family:Arial; color:#004C66; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''WHITE_TEXT'') d, ''style="font-family:Arial; color:#FFFFFF; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual',
'union all',
'select wwv_flow_lang.system_message(''GRAY_TEXT'') d, ''style="font-family:Arial; color:#303030; font-size:22px; white-space:nowrap; font-weight:bold;"'' r from dual ',
'union all',
'select wwv_flow_lang.system_message(''image_attributes'') d, ''alt="Application" title="Application"'' r from dual '))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lov_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84909926183685150)
,p_lov_name=>'LOV.TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(84909926183685150)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84910313696685150)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Static'
,p_lov_return_value=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84910101277685150)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Dynamic'
,p_lov_return_value=>'DYNAMIC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lov_column_display_roles
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(23061073014556223)
,p_lov_name=>'LOV_COLUMN_DISPLAY_ROLES'
,p_lov_query=>'.'||wwv_flow_imp.id(23061073014556223)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23061734797556224)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Displayed (Primary)'
,p_lov_return_value=>'PRIMARY_DISPLAY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23062121904556224)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Displayed'
,p_lov_return_value=>'DISPLAY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23062584379556225)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Group By'
,p_lov_return_value=>'GROUP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23062990524556225)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Icon'
,p_lov_return_value=>'ICON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(23195602034190758)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Hidden'
,p_lov_return_value=>'HIDDEN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lov_credential_stores
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(154515733779642473)
,p_lov_name=>'LOV_CREDENTIAL_STORES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name d, id r',
'  from wwv_credentials',
' where security_group_id = :flow_security_group_id',
' order by name'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lov_translated
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86578518083174290)
,p_lov_name=>'LOV_TRANSLATED'
,p_lov_query=>'.'||wwv_flow_imp.id(86578518083174290)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88298317101808717)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Yes'
,p_lov_return_value=>'Y'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lov_wiz_lov
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84344914743638898)
,p_lov_name=>'LOV_WIZ_LOV'
,p_lov_query=>'.'||wwv_flow_imp.id(84344914743638898)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88299120564809761)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'From Scratch'
,p_lov_return_value=>'BLANK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88299310826809761)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'As a Copy of an Existing List of Values'
,p_lov_return_value=>'COPY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/lanugagecodes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(61396703881)
,p_lov_name=>'LanugageCodes'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select translation_flow_language_code',
'',
'from   wwv_flow_language_map',
'',
'where  primary_language_flow_id = :FB_FLOW_ID',
'',
'order  by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/manage_dev_pref_view_mode
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(93546719421230687)
,p_lov_name=>'MANAGE_DEV_PREF_VIEW_MODE'
,p_lov_query=>'.'||wwv_flow_imp.id(93546719421230687)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93546924483230689)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Icons'
,p_lov_return_value=>'ICON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(93547106760230689)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Details'
,p_lov_return_value=>'DETAIL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/map_region_geometry_column_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2214661182663976)
,p_lov_name=>'MAP_REGION_GEOMETRY_COLUMN_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(2214661182663976)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2214906878663985)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Geometry Column'
,p_lov_return_value=>'GEOMETRY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2215331932663988)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Two Numeric Columns'
,p_lov_return_value=>'NUMBER'
);
end;
/
prompt --application/shared_components/user_interface/lovs/map_region_layer_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2204527800561582)
,p_lov_name=>'MAP_REGION_LAYER_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(2204527800561582)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2204840421561687)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Points'
,p_lov_return_value=>'POINT'
,p_lov_template=>'#DISPLAY_VALUE#| map-points'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2205270686561690)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Lines'
,p_lov_return_value=>'LINE'
,p_lov_template=>'#DISPLAY_VALUE#| map-lines'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2205538404561690)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Polygons'
,p_lov_return_value=>'POLYGON'
,p_lov_template=>'#DISPLAY_VALUE#| map-polygons'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2205977070561690)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Heat Map'
,p_lov_return_value=>'HEATMAP'
,p_lov_template=>'#DISPLAY_VALUE#| map-heatmap'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(2206380320561695)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Extruded Polygons'
,p_lov_return_value=>'POLYGON_3D'
,p_lov_template=>'#DISPLAY_VALUE#| map-extruded-polygons'
);
end;
/
prompt --application/shared_components/user_interface/lovs/marctest
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(125887329626694870)
,p_lov_name=>'MARCTEST'
,p_lov_query=>'.'||wwv_flow_imp.id(125887329626694870)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(125887611763694871)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'aaa'
,p_lov_return_value=>'10'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(125887930721694872)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'bbb'
,p_lov_return_value=>'20'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(125888224602694872)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'ccc'
,p_lov_return_value=>'30'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(125888508873694872)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'ddd'
,p_lov_return_value=>'40'
);
end;
/
prompt --application/shared_components/user_interface/lovs/marker_style
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84879717151455385)
,p_lov_name=>'MARKER_STYLE'
,p_lov_query=>'.'||wwv_flow_imp.id(84879717151455385)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84879905128455386)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Circle'
,p_lov_return_value=>'CIRCLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84880123391455386)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Diamond'
,p_lov_return_value=>'DIAMOND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84880312259455387)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Square'
,p_lov_return_value=>'SQUARE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84880528001455387)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Triangle'
,p_lov_return_value=>'TRIANGLE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/maximum_rows_per_page
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84800803131139158)
,p_lov_name=>'MAXIMUM ROWS PER PAGE'
,p_lov_query=>'.'||wwv_flow_imp.id(84800803131139158)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(180345125591578775)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'5'
,p_lov_return_value=>'5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84801031902139159)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'10'
,p_lov_return_value=>'10'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84801207012139159)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'15'
,p_lov_return_value=>'15'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84801406447139159)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'20'
,p_lov_return_value=>'20'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84801631719139159)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'25'
,p_lov_return_value=>'25'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(239238717004567042)
,p_lov_disp_sequence=>45
,p_lov_disp_value=>'30'
,p_lov_return_value=>'30'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84801809006139160)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'50'
,p_lov_return_value=>'50'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84802017106139160)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'75'
,p_lov_return_value=>'75'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84802230048139160)
,p_lov_disp_sequence=>70
,p_lov_disp_value=>'100'
,p_lov_return_value=>'100'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84802410431139160)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'500'
,p_lov_return_value=>'500'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84802619722139161)
,p_lov_disp_sequence=>90
,p_lov_disp_value=>'1000'
,p_lov_return_value=>'1000'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84802809542139161)
,p_lov_disp_sequence=>100
,p_lov_disp_value=>'5000'
,p_lov_return_value=>'5000'
);
end;
/
prompt --application/shared_components/user_interface/lovs/menu_theme_class_id
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(43945521366272493)
,p_lov_name=>'MENU THEME CLASS ID'
,p_lov_query=>'.'||wwv_flow_imp.id(43945521366272493)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43945822796272497)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Breadcrumb'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43946021659272497)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Hierarchical'
,p_lov_return_value=>'2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43946200038272497)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 1'
,p_lov_return_value=>'3'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43946403201272498)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 2'
,p_lov_return_value=>'4'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43946615168272498)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 3'
,p_lov_return_value=>'5'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43946827418272498)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 4'
,p_lov_return_value=>'6'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43947018619272498)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 5'
,p_lov_return_value=>'7'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43947229068272498)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 6'
,p_lov_return_value=>'8'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43947419430272499)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 7'
,p_lov_return_value=>'9'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(43947619554272499)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Custom 8'
,p_lov_return_value=>'10'
);
end;
/
prompt --application/shared_components/user_interface/lovs/menu_templates
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(146659516889284778)
,p_lov_name=>'MENU.TEMPLATES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(name) d, id',
'  from wwv_flow_menu_templates',
' where flow_id = :fb_flow_id and',
'    (:fb_theme_id is null or theme_id = :fb_theme_id)',
'order by upper(name)'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/menu_start_with
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84876111826444446)
,p_lov_name=>'MENU_START_WITH'
,p_lov_query=>'.'||wwv_flow_imp.id(84876111826444446)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84876328851444446)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Child Breadcrumb Entries'
,p_lov_return_value=>'CHILD_MENU'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84876509333444446)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Current Breadcrumb'
,p_lov_return_value=>'CURRENT_MENU'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84876719009444447)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Parent Breadcrumb Entries'
,p_lov_return_value=>'PARENT_MENU'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84876912643444447)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Parent to Leaf (breadcrumb style)'
,p_lov_return_value=>'PARENT_TO_LEAF'
);
end;
/
prompt --application/shared_components/user_interface/lovs/menu_template_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(86077012626803751)
,p_lov_name=>'MENU_TEMPLATE_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(86077012626803751)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88299923681810664)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'From Scratch'
,p_lov_return_value=>'BLANK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88300108885810665)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'As a Copy of an Existing Template'
,p_lov_return_value=>'COPY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/mobile_page_template
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(4794802534531342)
,p_lov_name=>'MOBILE_PAGE_TEMPLATE'
,p_lov_query=>'.'||wwv_flow_imp.id(4794802534531342)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4795112307531465)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Standard Browser'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/model_users
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(240554501608741323)
,p_lov_name=>'MODEL USERS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select distinct wwv_flow_escape.html(m.created_by) d, m.created_by r',
'from wwv_flow_models m, wwv_flow_model_pages p, wwv_flow_company_schemas s',
'where m.id = p.model_id ',
'and   m.owner = s.schema',
'and m.security_group_id = :flow_security_group_id',
'and s.security_group_id = :flow_security_group_id',
'and m.model_complete = ''Y''',
'group by m.created_by'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/model_link_extra_column
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(148927707220116911)
,p_lov_name=>'MODEL_LINK_EXTRA_COLUMN'
,p_lov_query=>'.'||wwv_flow_imp.id(148927707220116911)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(148928000552116912)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Use extra column to display link'
,p_lov_return_value=>'LINK_COLUMN'
);
end;
/
prompt --application/shared_components/user_interface/lovs/model_link_to_page
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(152446125589862819)
,p_lov_name=>'MODEL_LINK_TO_PAGE'
,p_lov_query=>'.'||wwv_flow_imp.id(152446125589862819)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(152446325930862821)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Theme Specific Edit Button'
,p_lov_return_value=>'LINK_COLUMN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(147361702073726841)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Report Column'
,p_lov_return_value=>'REPORT_COLUMN'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(147371230863763536)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Custom Link'
,p_lov_return_value=>'CUSTOM_LINK'
);
end;
/
prompt --application/shared_components/user_interface/lovs/model_use_theme_button
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(153128814386643499)
,p_lov_name=>'MODEL_USE_THEME_BUTTON'
,p_lov_query=>'.'||wwv_flow_imp.id(153128814386643499)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(153129027237643499)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Use theme-specific edit button'
,p_lov_return_value=>'THEME'
);
end;
/
prompt --application/shared_components/user_interface/lovs/named_lov
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(5278749326)
,p_lov_name=>'NAMED_LOV'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(lov_name) d, lov_name r',
'',
'from wwv_flow_lists_of_values$',
'',
'where flow_id = :FB_FLOW_ID',
'',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/named_lov_returning_id
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(73045019699242595)
,p_lov_name=>'NAMED_LOV_RETURNING_ID'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(lov_name) d, id',
'',
'from wwv_flow_lists_of_values$',
'',
'where flow_id = :FB_FLOW_ID',
'',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/navigation_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(174541309940513694)
,p_lov_name=>'NAVIGATION TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(174541309940513694)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(174541620822513696)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Tabs'
,p_lov_return_value=>'T'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(174541910206513699)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'List'
,p_lov_return_value=>'L'
);
end;
/
prompt --application/shared_components/user_interface/lovs/navigation_bar_position
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1383752466189575385)
,p_lov_name=>'NAVIGATION_BAR_POSITION'
,p_lov_query=>'.'||wwv_flow_imp.id(1383752466189575385)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1383752716721575387)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Top'
,p_lov_return_value=>'TOP'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1383753025830575387)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Side'
,p_lov_return_value=>'SIDE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/nav_bar_create_method
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84245132593407471)
,p_lov_name=>'NAV_BAR_CREATE_METHOD'
,p_lov_query=>'.'||wwv_flow_imp.id(84245132593407471)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88302321041819363)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'From Scratch'
,p_lov_return_value=>'BLANK'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(88302522891819363)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'As a Copy of an Existing Navigation Bar'
,p_lov_return_value=>'COPY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/nav_bar_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1383750926477562234)
,p_lov_name=>'NAV_BAR_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(1383750926477562234)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1383751231985562235)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Classic'
,p_lov_return_value=>'NAVBAR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1383751513527562236)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'List'
,p_lov_return_value=>'LIST'
);
end;
/
prompt --application/shared_components/user_interface/lovs/nav_menu_position_icons
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1856613427542451349)
,p_lov_name=>'NAV_MENU_POSITION_ICONS'
,p_lov_query=>'.'||wwv_flow_imp.id(1856613427542451349)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1856613755632451354)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Top'
,p_lov_return_value=>'TOP'
,p_lov_template=>'<span class="a-Icon icon-nav-top" aria-hidden="true"></span> #DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1856614196674451355)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Side'
,p_lov_return_value=>'SIDE'
,p_lov_template=>'<span class="a-Icon icon-nav-side" aria-hidden="true"></span> #DISPLAY_VALUE#'
);
end;
/
prompt --application/shared_components/user_interface/lovs/new
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(41348803113175334)
,p_lov_name=>'NEW'
,p_lov_query=>'.'||wwv_flow_imp.id(41348803113175334)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(41353729217192272)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'New page'
,p_lov_return_value=>'NEW_PAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(41349526190175350)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Region on this page'
,p_lov_return_value=>'NEW_REGION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(41349127275175345)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Page control on this page'
,p_lov_return_value=>'NEW_PAGE_CONTROL'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(41349322741175350)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Shared control'
,p_lov_return_value=>'NEW_SHARED_COMPONENT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/new_flow_component
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(56261603527740250)
,p_lov_name=>'NEW.FLOW.COMPONENT'
,p_lov_query=>'.'||wwv_flow_imp.id(56261603527740250)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155882395637829140)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Application Computation'
,p_lov_return_value=>'APP_COMPUTATION'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155881827328817113)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Application Item'
,p_lov_return_value=>'APP_ITEM'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155879848948783070)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Application Process'
,p_lov_return_value=>'APP_PROCESS'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155883932250884540)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Authentication Scheme'
,p_lov_return_value=>'AUTHENTICATION'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155878330459754175)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Authorization Scheme'
,p_lov_return_value=>'AUTH_SCHEME'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(56262910363740259)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Breadcrumb'
,p_lov_return_value=>'MENU'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155884584340896995)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Build Option'
,p_lov_return_value=>'BUILD_OPT'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(56262729926740259)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'List'
,p_lov_return_value=>'LIST'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(56262512111740259)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'List of Values'
,p_lov_return_value=>'LOV'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(56261902885740255)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Navigation Bar Entry'
,p_lov_return_value=>'NAVBAR'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(56262124240740258)
,p_lov_disp_sequence=>11
,p_lov_disp_value=>'Parent Tab'
,p_lov_return_value=>'PTAB'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155885541473911064)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'Plug-in'
,p_lov_return_value=>'PLUGIN'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155876629693724292)
,p_lov_disp_sequence=>13
,p_lov_disp_value=>'Report Layout'
,p_lov_return_value=>'REP_LAYOUT'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155875729258709848)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Report Query'
,p_lov_return_value=>'REP_QRY'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155877287613732395)
,p_lov_disp_sequence=>15
,p_lov_disp_value=>'Shortcut'
,p_lov_return_value=>'SHORTCUT'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(56262327091740258)
,p_lov_disp_sequence=>16
,p_lov_disp_value=>'Standard Tab'
,p_lov_return_value=>'STAB'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155880688440799375)
,p_lov_disp_sequence=>17
,p_lov_disp_value=>'Static Application File'
,p_lov_return_value=>'APP_FILE'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155881249285807487)
,p_lov_disp_sequence=>18
,p_lov_disp_value=>'Static Workspace File'
,p_lov_return_value=>'WS_FILE'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155885032437902193)
,p_lov_disp_sequence=>19
,p_lov_disp_value=>'Template'
,p_lov_return_value=>'TEMPLATE'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155879177309770213)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Text Message'
,p_lov_return_value=>'TEXT'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(1155874775728640463)
,p_lov_disp_sequence=>21
,p_lov_disp_value=>'Web Service Reference'
,p_lov_return_value=>'WS_REF'
,p_lov_template=>'#DISPLAY_VALUE#'
);
end;
/
prompt --application/shared_components/user_interface/lovs/new_form_options
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(54502713568963394)
,p_lov_name=>'NEW.FORM.OPTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(54502713568963394)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(54503231398963400)
,p_lov_disp_sequence=>32
,p_lov_disp_value=>'Form on a Table'
,p_lov_return_value=>'FORM'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-table'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(54503811384963401)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Form on a SQL Query'
,p_lov_return_value=>'FORMONSQL'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-sql'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(54503606699963400)
,p_lov_disp_sequence=>55
,p_lov_disp_value=>'Form on a Procedure'
,p_lov_return_value=>'FORMONPROC'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-form-procedure'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(202747215734446805)
,p_lov_disp_sequence=>80
,p_lov_disp_value=>'Form on Web Service'
,p_lov_return_value=>'FORMWS'
,p_lov_template=>'#DISPLAY_VALUE#| icon-page-report-webservice'
);
end;
/
prompt --application/shared_components/user_interface/lovs/new_page_component_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(55966712494123138)
,p_lov_name=>'NEW.PAGE.COMPONENT.TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(55966712494123138)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(55967204428123139)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Item'
,p_lov_return_value=>'ITEM'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(55967628285123140)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Button'
,p_lov_return_value=>'BUTTON'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(55967422140123139)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Branch'
,p_lov_return_value=>'BRANCH'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(55967827403123140)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Computation'
,p_lov_return_value=>'COMPUTATION'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(55968021272123140)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Process'
,p_lov_return_value=>'PROCESS'
,p_lov_template=>'#DISPLAY_VALUE#'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(55968210751123141)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Validation'
,p_lov_return_value=>'VALIDATION'
,p_lov_template=>'#DISPLAY_VALUE#'
);
end;
/
prompt --application/shared_components/user_interface/lovs/no_show_success_in_future
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(84732526223887360)
,p_lov_name=>'NO_SHOW_SUCCESS_IN_FUTURE'
,p_lov_query=>'.'||wwv_flow_imp.id(84732526223887360)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(84732711793887361)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Do not show success page in the future'
,p_lov_return_value=>'N'
);
end;
/
prompt --application/shared_components/user_interface/lovs/object_types
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(277431029384153056)
,p_lov_name=>'OBJECT.TYPES'
,p_lov_query=>'.'||wwv_flow_imp.id(277431029384153056)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(277431204230153061)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Function'
,p_lov_return_value=>'FUNCTION'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(277431400869153065)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Index'
,p_lov_return_value=>'INDEX'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(277431613646153065)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Package'
,p_lov_return_value=>'PACKAGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(277431823408153065)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Procedure'
,p_lov_return_value=>'PROCEDURE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(277432017860153065)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Sequence'
,p_lov_return_value=>'SEQUENCE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(277432208891153066)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Synonym'
,p_lov_return_value=>'SYNONYM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(277432406661153066)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Table'
,p_lov_return_value=>'TABLE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(277432614868153066)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Trigger'
,p_lov_return_value=>'TRIGGER'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(277432808078153066)
,p_lov_disp_sequence=>9
,p_lov_disp_value=>'View'
,p_lov_return_value=>'VIEW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(51094563587826026)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Type'
,p_lov_return_value=>'TYPE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/on_demand_processes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(156837711683123346)
,p_lov_name=>'ON.DEMAND.PROCESSES'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select wwv_flow_escape.html(process_name) d, id r',
'',
'  from wwv_flow_processing',
'',
'where flow_id = :fb_flow_id and process_point = ''ON_DEMAND''',
'',
' order by process_name',
'',
''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/on_off
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(9165706597746719)
,p_lov_name=>'ON_OFF'
,p_lov_query=>'.'||wwv_flow_imp.id(9165706597746719)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9165915858746727)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'On'
,p_lov_return_value=>'ON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(9166117224746730)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Off'
,p_lov_return_value=>'OFF'
);
end;
/
prompt --application/shared_components/user_interface/lovs/orphaned_lists_display
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(94838211998345101)
,p_lov_name=>'ORPHANED_LISTS_DISPLAY'
,p_lov_query=>'.'||wwv_flow_imp.id(94838211998345101)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(94838503112345102)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Orphaned'
,p_lov_return_value=>'O'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(94838713034345102)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'All'
,p_lov_return_value=>'A'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p104_sync_page_name
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(123726144609302218)
,p_lov_name=>'P104_SYNC_PAGE_NAME'
,p_lov_query=>'.'||wwv_flow_imp.id(123726144609302218)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(123726345582302214)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'synchronize page name and title'
,p_lov_return_value=>'YES'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p105_all_my_files
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(153643805218811160)
,p_lov_name=>'P105_ALL_MY_FILES'
,p_lov_query=>'.'||wwv_flow_imp.id(153643805218811160)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(153644123892811161)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'My Files'
,p_lov_return_value=>'MY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(153644329503811161)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'All Files'
,p_lov_return_value=>'ALL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p143_grid_column
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(217410917274629373)
,p_lov_name=>'P143.GRID_COLUMN'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
' select level as d, level as r',
'   from sys.dual',
'connect by level <= :P143_GRID_MAX_COLUMNS'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1556_display_selections
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(112777512483182861)
,p_lov_name=>'P1556_DISPLAY_SELECTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(112777512483182861)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(112777702670182866)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'- All -'
,p_lov_return_value=>'All'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(112777913428182869)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Label'
,p_lov_return_value=>'L'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(112778103167182870)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Display As'
,p_lov_return_value=>'D'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(112778319856182870)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Format'
,p_lov_return_value=>'F'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(112778517171182870)
,p_lov_disp_sequence=>5
,p_lov_disp_value=>'Form Default Value'
,p_lov_return_value=>'V'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(112778711439182870)
,p_lov_disp_sequence=>6
,p_lov_disp_value=>'Display Size'
,p_lov_return_value=>'S'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(112778913135182870)
,p_lov_disp_sequence=>7
,p_lov_disp_value=>'Form Help'
,p_lov_return_value=>'H'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(112779121557182871)
,p_lov_disp_sequence=>8
,p_lov_disp_value=>'Report Alignment'
,p_lov_return_value=>'A'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1610_actions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(249294887509698711)
,p_lov_name=>'P1610_ACTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(249294887509698711)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(249295104828698712)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'From scratch'
,p_lov_return_value=>'CREATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(249295509034698713)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'As copy of an existing REST Enabled SQL Service'
,p_lov_return_value=>'COPY'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1612_copy
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(249334505721803809)
,p_lov_name=>'P1612.COPY'
,p_lov_query=>'.'||wwv_flow_imp.id(249334505721803809)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(249334893554803810)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Yes'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(249335284311803810)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'No'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(249335642186803811)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Copy and Subscribe'
,p_lov_return_value=>'SUBSCRIBE'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>':P1611_COPY_FROM <> :FB_FLOW_ID'
,p_lov_disp_cond2=>'PLSQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1700_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(381833322409586869)
,p_lov_name=>'P1700_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_name_esc,',
'       column_name',
'  from wwv_flow_table_columns_dev',
' where owner      = :F4000_P1700_OWNER',
'   and table_name = :F4000_P1700_TABLE_NAME',
'   and data_type <> ''BLOB'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p173_show
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(48989614083583743)
,p_lov_name=>'P173_SHOW'
,p_lov_query=>'.'||wwv_flow_imp.id(48989614083583743)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(48989812927583749)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Application Templates'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(48990014681583750)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Theme Template Counts'
,p_lov_return_value=>'2'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(205410028377606456)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'File References'
,p_lov_return_value=>'FILE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(205425424268633678)
,p_lov_disp_sequence=>40
,p_lov_disp_value=>'Class References'
,p_lov_return_value=>'CLASS'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(205426329116635065)
,p_lov_disp_sequence=>50
,p_lov_disp_value=>'Template Substitution Strings'
,p_lov_return_value=>'TEMPLATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p176_page_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(714200985818178118)
,p_lov_name=>'P176_PAGE_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(714200985818178118)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(714201271961178121)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Report and Form'
,p_lov_return_value=>'REPORT_AND_FORM'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(714201627845178122)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Single Page'
,p_lov_return_value=>'SINGLE_PG'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p176_report_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(329353513116624468)
,p_lov_name=>'P176_REPORT_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(329353513116624468)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(329353826739624470)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Interactive Report'
,p_lov_return_value=>'INTERACTIVE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(713173926577991309)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Interactive Grid'
,p_lov_return_value=>'IG'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(329354106024624470)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Classic Report'
,p_lov_return_value=>'CLASSIC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1801_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(1172046023461279303)
,p_lov_name=>'P1801_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_name_esc,',
'       column_name',
'  from wwv_flow_table_columns_dev',
' where owner      = :P1801_OWNER',
'   and table_name = :P1801_TABLE_NAME'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1801_table_name
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(705239800153899318)
,p_lov_name=>'P1801_TABLE_NAME'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select TABLE_NAME display_value, ID return_value ',
'from WWV_FLOW_LOAD_TABLES',
'where name = :P1801_NAME',
'order by 1'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1802_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(694138215390835955)
,p_lov_name=>'P1802_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_name_esc,',
'       column_name',
'  from wwv_flow_table_columns_dev',
' where owner      = :P1802_LOOKUP_OWNER',
'   and table_name = :P1802_LOOKUP_TABLE_NAME',
'   and data_type <> ''BLOB'''))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1812_collection_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3007625702757031)
,p_lov_name=>'P1812_COLLECTION_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_name||'' (''|| initcap(data_type) ||'')'' as d,',
'       column_name as r',
'from sys.dba_tab_columns',
'where owner = :OWNER',
'and table_name = ''WWV_FLOW_COLLECTIONS''',
'and data_type not in ( ''BLOB'', ''XMLTYPE'' )',
'and column_name not in ( ''SEQ_ID'', ''MD5_ORIGINAL'', ''COLLECTION_NAME'' )',
'order by column_id'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_use_local_sync_table=>false
,p_return_column_name=>'R'
,p_display_column_name=>'D'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1812_table_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(2132493628676085)
,p_lov_name=>'P1812_TABLE_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_name||'' (''|| initcap(data_type) ||'')'' as d,',
'       column_name as r',
'from sys.dba_tab_columns',
'where owner = :P1811_TABLE_OWNER',
'and table_name = :P1811_TABLE_NAME',
'order by column_id'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_use_local_sync_table=>false
,p_return_column_name=>'R'
,p_display_column_name=>'D'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1817_copy
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(3387269549000655)
,p_lov_name=>'P1817.COPY'
,p_lov_query=>'.'||wwv_flow_imp.id(3387269549000655)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3387527981001063)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Yes'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3387951318001064)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'No'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(3388361761001064)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Copy and Subscribe'
,p_lov_return_value=>'SUBSCRIBE'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>':P1816_COPY_FROM <> :FB_FLOW_ID'
,p_lov_disp_cond2=>'PLSQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1905_actions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(247678451096396264)
,p_lov_name=>'P1905_ACTIONS'
,p_lov_query=>'.'||wwv_flow_imp.id(247678451096396264)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(247678721347396266)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'From scratch'
,p_lov_return_value=>'CREATE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(247679191058396269)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'As copy of an existing REST Data Source'
,p_lov_return_value=>'COPY'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4200940468413888)
,p_lov_disp_sequence=>12
,p_lov_disp_value=>'From a REST Source Catalog'
,p_lov_return_value=>'CATALOG'
,p_lov_disp_cond_type=>'EXISTS'
,p_lov_disp_cond=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select null ',
'  from WWV_WEB_SRC_CATALOGS c',
' where security_group_id = :WORKSPACE_ID',
'   and exists ( select 1 ',
'                  from wwv_web_src_catalog_services s',
'                 where security_group_id = :WORKSPACE_ID',
'                   and s.catalog_id = c.id )'))
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1907_copy
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(247782857688295098)
,p_lov_name=>'P1907.COPY'
,p_lov_query=>'.'||wwv_flow_imp.id(247782857688295098)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(247783143135295099)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'Yes'
,p_lov_return_value=>'Y'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(247783588055295099)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'No'
,p_lov_return_value=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(247783952074295099)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Copy and Subscribe'
,p_lov_return_value=>'SUBSCRIBE'
,p_lov_disp_cond_type=>'EXPRESSION'
,p_lov_disp_cond=>':P1906_COPY_FROM <> :FB_FLOW_ID'
,p_lov_disp_cond2=>'PLSQL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1925_data_profile_format
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(607713258081514419)
,p_lov_name=>'P1925_DATA_PROFILE_FORMAT'
,p_lov_query=>'.'||wwv_flow_imp.id(607713258081514419)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(607713548960514424)
,p_lov_disp_sequence=>1
,p_lov_disp_value=>'CSV'
,p_lov_return_value=>'CSV'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(607713952628514429)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'JSON'
,p_lov_return_value=>'JSON'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(607714315537514429)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'XLSX'
,p_lov_return_value=>'XLSX'
,p_lov_disp_cond_type=>'VAL_OF_ITEM_IN_COND_EQ_COND2'
,p_lov_disp_cond=>'P1925_IS_WEB_SRC_PROFILE'
,p_lov_disp_cond2=>'N'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(607714737048514430)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'XML'
,p_lov_return_value=>'XML'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1926_data_profile_cols
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(4483925603898914)
,p_lov_name=>'P1926_DATA_PROFILE_COLS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select name',
'from wwv_flow_data_profile_cols',
'where data_profile_id = :P1925_DATA_PROFILE_ID',
'and flow_id = :FB_FLOW_ID',
'and security_group_id = :FLOW_SECURITY_GROUP_ID',
'order by sequence'))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_return_column_name=>'NAME'
,p_display_column_name=>'NAME'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1926_lookup_columns
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(4458615411627104)
,p_lov_name=>'P1926_LOOKUP_COLUMNS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select column_name_esc,',
'       column_name',
'  from wwv_flow_table_columns_dev',
' where owner      = coalesce( :P1926_LOOKUP_OWNER, upper(wwv_flow_wizard_api.get_flow_owner(:FB_FLOW_ID)))',
'   and table_name = :P1926_LOOKUP_TABLE',
'   and data_type <> ''BLOB'''))
,p_source_type=>'SQL'
,p_location=>'LOCAL'
,p_use_local_sync_table=>false
,p_return_column_name=>'COLUMN_NAME'
,p_display_column_name=>'COLUMN_NAME_ESC'
,p_group_sort_direction=>'ASC'
,p_default_sort_direction=>'ASC'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1951_max_requests_exc_action
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(601125790424873502)
,p_lov_name=>'P1951_MAX_REQUESTS_EXC_ACTION'
,p_lov_query=>'.'||wwv_flow_imp.id(601125790424873502)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601125956648873502)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Raise Error'
,p_lov_return_value=>'ERROR'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601126391695873506)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Wait'
,p_lov_return_value=>'WAIT'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1951_new_or_existing_table
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(601127065669873845)
,p_lov_name=>'P1951_NEW_OR_EXISTING_TABLE'
,p_lov_query=>'.'||wwv_flow_imp.id(601127065669873845)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601127244730873845)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'New Table'
,p_lov_return_value=>'NEW'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601127625076873845)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Existing Table'
,p_lov_return_value=>'EXISTING'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1951_replace_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(601128335146874196)
,p_lov_name=>'P1951_REPLACE_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(601128335146874196)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601128505255874196)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'DELETE (transactional)'
,p_lov_return_value=>'DELETE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601128965924874196)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'TRUNCATE (non-transactional)'
,p_lov_return_value=>'TRUNCATE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1951_script_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(601129636599874441)
,p_lov_name=>'P1951_SCRIPT_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(601129636599874441)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601129868183874441)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Install'
,p_lov_return_value=>'1'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601130273688874441)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Upgrade'
,p_lov_return_value=>'2'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p1951_sync_type
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(601130955295874684)
,p_lov_name=>'P1951_SYNC_TYPE'
,p_lov_query=>'.'||wwv_flow_imp.id(601130955295874684)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601131122496874684)
,p_lov_disp_sequence=>10
,p_lov_disp_value=>'Append'
,p_lov_return_value=>'APPEND'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601131505261874685)
,p_lov_disp_sequence=>20
,p_lov_disp_value=>'Merge'
,p_lov_return_value=>'MERGE'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(601131967547874685)
,p_lov_disp_sequence=>30
,p_lov_disp_value=>'Replace'
,p_lov_return_value=>'REPLACE'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p195_parent_regions
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(170777029602529928)
,p_lov_name=>'P195_PARENT_REGIONS'
,p_lov_query=>wwv_flow_string.join(wwv_flow_t_varchar2(
'select plug_name || '' ('' || plug_display_sequence || '')'' as plug_name,',
'       id',
'  from wwv_flow_page_plugs p',
' where flow_id           = :FB_FLOW_ID',
'   and page_id           = :F4000_P194_COPY_TO_PAGE_ID',
'   and security_group_id = :WORKSPACE_ID',
' order by plug_name'))
,p_source_type=>'LEGACY_SQL'
,p_location=>'LOCAL'
);
end;
/
prompt --application/shared_components/user_interface/lovs/p198_icon_classes
begin
wwv_flow_imp_shared.create_list_of_values(
 p_id=>wwv_flow_imp.id(4020363974607382)
,p_lov_name=>'P198_ICON_CLASSES'
,p_lov_query=>'.'||wwv_flow_imp.id(4020363974607382)||'.'
,p_location=>'STATIC'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4020778800607383)
,p_lov_disp_sequence=>2
,p_lov_disp_value=>'Folder'
,p_lov_return_value=>'folder'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-folder'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4021195666607383)
,p_lov_disp_sequence=>3
,p_lov_disp_value=>'Spreadsheet'
,p_lov_return_value=>'spreadsheet'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-spreadsheet'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4021568429607383)
,p_lov_disp_sequence=>4
,p_lov_disp_value=>'Messages'
,p_lov_return_value=>'talk-bubbles'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-talk-bubbles'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4021910784607383)
,p_lov_disp_sequence=>14
,p_lov_disp_value=>'Analytics'
,p_lov_return_value=>'analytics'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-analytics'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4022358636607383)
,p_lov_disp_sequence=>24
,p_lov_disp_value=>'Bar Chart'
,p_lov_return_value=>'bar-line-chart'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-bar-line-chart'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4022725649607383)
,p_lov_disp_sequence=>34
,p_lov_disp_value=>'Calendar'
,p_lov_return_value=>'calendar'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-calendar'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4023111577607384)
,p_lov_disp_sequence=>44
,p_lov_disp_value=>'Cloud'
,p_lov_return_value=>'cloud'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-cloud'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4023568828607384)
,p_lov_disp_sequence=>54
,p_lov_disp_value=>'Cubes'
,p_lov_return_value=>'cubes'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-cubes'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4023948804607384)
,p_lov_disp_sequence=>60
,p_lov_disp_value=>'Mail'
,p_lov_return_value=>'email'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-email'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4024347009607384)
,p_lov_disp_sequence=>64
,p_lov_disp_value=>'Database'
,p_lov_return_value=>'database'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-database'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4024733582607384)
,p_lov_disp_sequence=>74
,p_lov_disp_value=>'Gear'
,p_lov_return_value=>'gear'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-gear'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4025115858607384)
,p_lov_disp_sequence=>84
,p_lov_disp_value=>'Graphs'
,p_lov_return_value=>'graphs'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-graphs'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4025555984607385)
,p_lov_disp_sequence=>94
,p_lov_disp_value=>'Map'
,p_lov_return_value=>'map'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-map'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4025992497607385)
,p_lov_disp_sequence=>104
,p_lov_disp_value=>'People'
,p_lov_return_value=>'people'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-people'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4026354838607385)
,p_lov_disp_sequence=>114
,p_lov_disp_value=>'Smiley'
,p_lov_return_value=>'smiley'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-smiley'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4026747246607385)
,p_lov_disp_sequence=>124
,p_lov_disp_value=>'To Do'
,p_lov_return_value=>'todo'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-todo'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4027167138607386)
,p_lov_disp_sequence=>134
,p_lov_disp_value=>'Bug'
,p_lov_return_value=>'bug'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-bug'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4027549401607386)
,p_lov_disp_sequence=>144
,p_lov_disp_value=>'Dots'
,p_lov_return_value=>'dots'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-dots'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4027918738607386)
,p_lov_disp_sequence=>154
,p_lov_disp_value=>'Gauge'
,p_lov_return_value=>'gauge'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-gauge'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4028334538607387)
,p_lov_disp_sequence=>164
,p_lov_disp_value=>'Grid'
,p_lov_return_value=>'grid'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-grid'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4028744784607387)
,p_lov_disp_sequence=>174
,p_lov_disp_value=>'Pencil and Paper'
,p_lov_return_value=>'pencil-paper'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-pencil-paper'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4029156326607387)
,p_lov_disp_sequence=>184
,p_lov_disp_value=>'Toolbox'
,p_lov_return_value=>'toolbox'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-toolbox'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4029573285607387)
,p_lov_disp_sequence=>194
,p_lov_disp_value=>'Wrench'
,p_lov_return_value=>'wrench'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-wrench'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4029930090607387)
,p_lov_disp_sequence=>204
,p_lov_disp_value=>'Activity'
,p_lov_return_value=>'activity'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-activity'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4030316517607387)
,p_lov_disp_sequence=>300
,p_lov_disp_value=>'Stopwatch'
,p_lov_return_value=>'stopwatch'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-stopwatch'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4030748484607387)
,p_lov_disp_sequence=>301
,p_lov_disp_value=>'Pie Chart'
,p_lov_return_value=>'pie-chart'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-pie-chart'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4031196281607387)
,p_lov_disp_sequence=>302
,p_lov_disp_value=>'Checkmark'
,p_lov_return_value=>'check-circle'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-check-circle'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4031535932607388)
,p_lov_disp_sequence=>303
,p_lov_disp_value=>'Rocket'
,p_lov_return_value=>'rocket'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-rocket'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4031919406607388)
,p_lov_disp_sequence=>304
,p_lov_disp_value=>'Shield'
,p_lov_return_value=>'shield'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-shield'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4032387684607388)
,p_lov_disp_sequence=>305
,p_lov_disp_value=>'Lightbulb'
,p_lov_return_value=>'lightbulb'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-lightbulb'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4032710058607388)
,p_lov_disp_sequence=>306
,p_lov_disp_value=>'Lock'
,p_lov_return_value=>'lock'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-lock'
);
wwv_flow_imp_shared.create_static_lov_data(
 p_id=>wwv_flow_imp.id(4033165706607388)
,p_lov_disp_sequence=>307
,p_lov_disp_value=>'Ship'
,p_lov_return_value=>'ship'
,p_lov_template=>'#DISPLAY_VALUE#| app-icon-ship'
);
end;
/
prompt --application/shared_components/user_interf