Rem  Copyright (c) Oracle Corporation 1999 - 2022. All Rights Reserved.
Rem
Rem    NAME
Rem      apxremov2.sql
Rem
Rem    DESCRIPTION
Rem      Removes Oracle APEX
Rem
Rem    NOTES
Rem      Assumes the SYS user is connected. You must exit the SQL*Plus session prior to running
Rem      apexins.sql
Rem
Rem    REQUIRENTS
Rem      Oracle APEX
Rem
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      jstraub   08/14/2006 - Created

set define '^' verify off
define PREFIX = '^1'

@^PREFIX.core/scripts/set_appun.sql

alter session set current_schema = SYS;

declare
    invalid_alter_priv exception;
    pragma exception_init(invalid_alter_priv,-02248);
begin
    execute immediate 'alter session set "_ORACLE_SCRIPT"=true';
exception
    when invalid_alter_priv then
        null;
end;
/

@^PREFIX.core/scripts/set_ufrom_and_upgrade.sql

-- Remove FLOWS SCHEMA
drop user ^APPUN cascade;

-- Remove FLOWS_FILES and APEX_PUBLIC_USER SCHEMA if no other versions exist

declare
    procedure ddl (
        p_stmt in varchar2 )
    is
    begin
        execute immediate p_stmt;
    exception when others then
        if sqlcode not in (-1918, -1924) then
            sys.dbms_output.put_line(sqlerrm);
            sys.dbms_output.put_line('... when running: '||p_stmt);
        end if;
    end ddl;
begin
    if '^UPGRADE' = '1' then
        ddl('drop user FLOWS_FILES cascade');
        ddl('drop user APEX_PUBLIC_USER cascade');
        ddl('drop user APEX_LISTENER cascade');
        ddl('drop user APEX_REST_PUBLIC_USER cascade');
        ddl('drop role APEX_ADMINISTRATOR_ROLE');
        ddl('drop role APEX_ADMINISTRATOR_READ_ROLE');
        ddl('drop role APEX_GRANTS_FOR_NEW_USERS_ROLE');
        ddl('drop context APEX$SESSION');
    end if;
end;
/

-- Remove SYS owned objects

begin
    if '^UPGRADE' = '1' then
        execute immediate 'drop procedure validate_apex';
        execute immediate 'drop package WWV_FLOW_VAL';
        execute immediate 'drop package WWV_FLOW_KEY';
        execute immediate 'drop library WWV_FLOW_VAL_LIB';
    end if;
    --
    -- drop old wwv_dbms_sql if it is invalid
    --
    for i in ( select 1
                 from sys.dba_objects
                where owner       = 'SYS'
                  and object_name = 'WWV_DBMS_SQL'
                  and status      = 'INVALID' )
    loop
        execute immediate 'drop package wwv_dbms_sql';
    end loop;
end;
/
drop package WWV_DBMS_SQL_^APPUN.;
drop package WWV_UTIL_^APPUN.;

declare
    invalid_alter_priv exception;
    pragma exception_init(invalid_alter_priv,-02248);
begin
    execute immediate 'alter session set "_ORACLE_SCRIPT"=false';
exception
    when invalid_alter_priv then
        null;
end;
/

prompt ...Oracle APEX Removed
prompt
prompt ********************************************************************
prompt ** You must exit this SQL*Plus session before running apexins.sql **
prompt ********************************************************************
