Rem  Copyright (c) 1999, 2022, Oracle and/or its affiliates.
Rem
Rem    NAME
Rem      apxdevrm_nocdb.sql
Rem
Rem    DESCRIPTION
Rem      This is the development environment removal script for Oracle APEX.
Rem
Rem    REQUIREMENTS
Rem      - Oracle Database 10.2.0.3 or later
Rem      - PL/SQL Web Toolkit
Rem
Rem    MODIFIED   (MM/DD/YYYY)
Rem      jstraub   06/26/2007 - Created

set define '^'
set concat on
set concat .
set verify off
set serveroutput on size unlimited
set feedback off

define PREFIX = '@'
define INSTALL_TYPE = 'DEVRM'

@^PREFIX.core/scripts/set_appun.sql

column foo3 new_val LOG1
select 'removedev'||to_char(sysdate,'YYYY-MM-DD_HH24-MI-SS')||'.log' foo3 from sys.dual;
spool ^LOG1

set termout on

--==============================================================================
timing start "Bootstrapping"

--==============================================================================
begin
    ^APPUN..wwv_install_api.begin_install (
        p_install_type => '^INSTALL_TYPE.',
        p_schema       => '^APPUN' );
    ^APPUN..wwv_install_api.begin_phase (
        p_phase        => 1 );
end;
/
set errorlogging on table ^APPUN..WWV_INSTALL_ERRORS

alter session set current_schema = SYS;

ALTER SESSION SET recyclebin = OFF;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Revoking Dev-Only Grants"
@^PREFIX.core/runtime_grant_revoke.sql

alter session set current_schema = ^APPUN;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Dev-Only Packages"

drop package wwv_flow_plsql_editor;
drop package wwv_flow_model_api;
drop package wwv_flow_approval_dev;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing SYS view wrappers"

drop view apex_sys_all_synonyms;
drop view apex_sys_all_objects;
drop view apex_sys_all_constraints;
drop view apex_sys_all_dependencies;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Dev-Only Views"

drop view wwv_flow_ui_types_dev;
drop view wwv_flow_search_result_dev;
drop view wwv_flow_advisor_result_dev;
drop view wwv_flow_ws_operations_dev;
drop view wwv_flow_ws_oper_param_dev;
drop view wwv_flow_page_proc_ws_parm_dev;
drop view wwv_flow_worksheet_col_grp_dev;
drop view wwv_flow_worksheet_rpts_dev;
drop view wwv_flow_ig_reports_dev;
drop view wwv_flow_steps_dev;
drop view wwv_flow_page_plugs_dev;
drop view wwv_flow_region_rpt_dev;
drop view wwv_flow_region_plugin_dev;
drop view wwv_flow_region_print_dev;
drop view wwv_flow_map_regions_dev;
drop view wwv_flow_map_layers_dev;
drop view wwv_flow_cards_dev;
drop view wwv_flow_region_rpt_col_dev;
drop view wwv_flow_worksheet_col_dev;
drop view wwv_flow_region_columns_dev;
drop view wwv_flow_ig_columns_dev;
drop view wwv_flow_step_items_dev;
drop view wwv_flow_filters_dev;
drop view wwv_flow_step_branches_dev;
drop view wwv_flow_jet_axes_dev;
drop view wwv_flow_jet_series_dev;
drop view wwv_flow_cals_dev;
drop view wwv_flow_page_da_events_dev;
drop view wwv_flow_page_da_actions_dev;
drop view wwv_flow_visible_flows;
drop view wwv_flow_object_owners_dev;
drop view wwv_flow_objects_dev;
drop view wwv_flow_tables_views_dev;
drop view wwv_flow_detail_tables_dev;
drop view wwv_flow_table_columns_dev;
drop view wwv_flow_sequences_dev;
drop view wwv_flow_trigger_source_dev;
drop view wwv_flow_jobs_dev;
drop view wwv_credentials_dev;
drop view wwv_remotesql_servers_dev;
drop view wwv_flow_data_view;
drop view wwv_flow_email_templates_dev;
drop view wwv_flow_page_types_dev;
drop view wwv_flow_lovs_dev;
drop view wwv_flow_data_profiles_dev;
drop view wwv_flow_data_profile_cols_dev;
drop view wwv_flow_automations_dev;
drop view wwv_flow_substitutions_dev;
drop view wwv_flow_install_subst_dev;
drop view wwv_flow_pages_dev;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Team Development objects"

drop package wwv_flow_team_api;
drop package wwv_flow_team_gen_api;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Re-Installing Runtime Views"

@^PREFIX.core/view.sql

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Other packages"

drop package wwv_flow_wizard_api;
drop package wwv_flow_form_region_dev;
drop package wwv_flow_calendar_dev;
drop package wwv_flow_lov_dev;
drop package wwv_flow_upgrade_app;
drop package wwv_flow_translation_utilities;
drop package wwv_flow_region_layout;
drop function wwv_flow_lov_used_on_pages;
drop package wwv_flow_query_builder;
drop package wwv_flow_sw_object_feed;
drop package wwv_flow_load_data;
drop package wwv_flow_copy_metadata;
drop package wwv_flow_copy_util;
drop package wwv_flow_tab_mgr;
drop package wwv_flow_generate_ddl;
drop package wwv_flow_table_drill;
drop package wwv_flow_copy_page;
drop package wwv_flow_generate_table_api;
drop package wwv_flow_gen_hint;
drop package wwv_flow_xliff;
drop package wwv_flow_create_model_app;
drop procedure apex_admin;
drop procedure htmldb_admin;
drop package wwv_flow_session_mon;
drop package wwv_flow_sw_page_calls;
drop package wwv_flow_wiz_confirm;
drop package wwv_flow_page_map;
drop package wwv_flow_dataload_xml;
drop package apex_ui_default_update;
drop package wwv_flow_dictionary_dev;
drop package wwv_flow_advisor_checks_api;
drop package wwv_flow_advisor_checks_int;
drop package wwv_flow_advisor_dev;
drop package wwv_flow_builder_search_dev;
drop package wwv_flow_f4000_plugins;
drop package wwv_flow_4000_ui;
drop package wwv_flow_4050_ui;
drop package wwv_flow_4350_ui;
drop package wwv_flow_workspace_reports;
drop package wwv_flow_create_app_from_query;
drop package wwv_flow_ui_type_dev;
drop package wwv_flow_dev;
drop package wwv_flow_theme_dev;
drop package wwv_flow_template_dev;
drop package wwv_flow_code_exec_mle_dev;
drop package wwv_flow_user_interface_dev;
drop package wwv_flow_page_dev;
drop package wwv_flow_file_editor_dev;
drop package wwv_flow_lang_dev;
drop package wwv_flow_mail_dev;
drop package wwv_flow_pwa_dev;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Create Blueprint App Wizard"

drop package wwv_flow_define_app_v3;
drop package wwv_flow_create_app_v3;
drop package wwv_flow_app_feature_v3;
drop package wwv_flow_app_shared_comp_v3;
drop package wwv_flow_create_app_log_v3;
drop package wwv_flow_blueprint_v3;
drop package wwv_flow_app_def_v3;
drop package wwv_flow_app_def_api_v3;
drop table wwv_flow_blueprint_repo cascade constraints;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Quick SQL"

drop package wwv_qs_design_schema_pub;
drop package wwv_qs_data;
drop sequence wwv_qs_seq;
drop sequence wwv_qs_random_names_seq;
drop table wwv_qs_models cascade constraints;
drop table wwv_qs_random_names cascade constraints;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing REST Workshop"

drop package wwv_flow_rest_ws;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Other Packages"

drop package wwv_flow_dynamic_action_dev;
drop package wwv_flow_authentication_dev;
drop package wwv_flow_error_dev;
drop package wwv_flow_export_dev;
drop package wwv_flow_property_dev;
drop package wwv_flow_cloud_db_services;
drop package wwv_flow_credential_dev;
drop package wwv_flow_remote_server_dev;
drop package wwv_flow_remote_deploy_dev;
drop package wwv_flow_data_profile_dev;
drop package wwv_flow_web_src_dev;
drop package wwv_flow_web_src_sync_dev;
drop package wwv_flow_automation_dev;
drop package wwv_flow_map_region_dev;
drop package wwv_flow_authorization_dev;
drop package wwv_flow_f4000_util;
drop package wwv_flow_plugin_dev;
drop package wwv_flow_code_exec_dev;
drop package wwv_flow_exec_dev;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Spotlight Search"

drop package wwv_flow_spotlight_dev;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Sample Dataset"

drop package wwv_sample_dataset;
drop table wwv_sample_dmls cascade constraints;
drop table wwv_sample_ddls cascade constraints;
drop table wwv_sample_dataset_companies cascade constraints;
drop table wwv_sample_json cascade constraints;
drop table wwv_sample_dataset_languages cascade constraints;
drop table wwv_sample_languages cascade constraints;
drop table wwv_sample_datasets cascade constraints;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Dictionary Cache"

drop package wwv_dictionary_cache_dev;
drop table wwv_dictionary_cache_log    cascade constraints;
drop table wwv_dictionary_cache_obj    cascade constraints;
drop table wwv_dictionary_cache_col    cascade constraints;
drop table wwv_dictionary_cache_fkcon  cascade constraints;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Report Package"

drop package wwv_flow_report_dev;
drop package wwv_flow_faceted_search_dev;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Issues Application"

drop package wwv_flow_issue_int;
drop package wwv_flow_issue_notify_int;
drop package wwv_flow_issue_seed_int;

drop table wwv_flow_label_groups cascade constraints;
drop table wwv_flow_labels cascade constraints;
drop table wwv_flow_milestones cascade constraints;
drop table wwv_flow_issues cascade constraints;
drop table wwv_flow_issue_attachments cascade constraints;
drop table wwv_flow_issue_stakeholders cascade constraints;
drop table wwv_flow_issue_comments cascade constraints;
drop table wwv_flow_issue_events cascade constraints;
drop table wwv_flow_issue_milestones cascade constraints;
drop table wwv_flow_issue_labels cascade constraints;
drop table wwv_flow_issue_templates cascade constraints;
drop table wwv_flow_issue_notifications cascade constraints;
drop table wwv_flow_issue_email_prefs cascade constraints;

drop view apex_issues;
drop view apex_issue_events;
drop view apex_issue_comments;
drop view apex_issue_attachments;
drop view apex_issue_stakeholders;
drop view apex_issue_milestones;
drop view apex_issue_label_groups;
drop view apex_issue_labels;
drop view apex_issue_label_relation;
drop view apex_issue_milestone_relation;
drop view apex_issue_email_prefs;
drop view apex_issue_notifications;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Application Backup feature"

drop package wwv_flow_backup;

begin
    delete from wwv_flow_file_objects$ where file_type = 'FLOW_BACKUP' and id in (select object_id from wwv_flow_backups$);
    commit;
end;
/

drop table wwv_flow_backups$;
drop table wwv_flow_backup_log;
drop view wwv_flow_workspace_backups;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing DBMS_CLOUD Data Loading" support
drop package wwv_dbms_cloud;
drop package wwv_flow_data_loader_dev;
drop package wwv_flow_soda_dev;

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing REST Source Catalogs"
drop package wwv_web_src_catalog_api;
drop package wwv_web_src_catalog;

drop view apex_rest_catalog_groups;
drop view apex_rest_catalogs;
drop view apex_rest_catalog_plugins;
drop view apex_rest_catalog_services;

drop table wwv_web_src_catalog_plugins;
drop table wwv_web_src_catalog_services;
drop table wwv_web_src_catalogs;
drop table wwv_web_src_catalog_groups;

--==============================================================================
@^PREFIX.core/scripts/reset_state_and_show_invalid.sql

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Dev-Only Jobs"

begin
    wwv_flow_upgrade.remove_dev_jobs(p_owner => '^APPUN.');
end;
/

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Recompiling ^APPUN."

exec sys.utl_recomp.recomp_parallel(schema => '^APPUN.');

@^PREFIX.core/scripts/reset_state_and_show_invalid.sql SYS,FLOWS_FILES,^APPUN

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Public Synonyms"

begin
    wwv_flow_upgrade.drop_public_synonyms();
end;
/

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Disabling Workspace Purge"

begin
    wwv_flow_platform.set_preference( p_preference_name => 'PURGE_ENABLED', p_preference_value => 'N' );
    commit;
end;
/

--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Removing Internal Development Applications"

declare
    l_app dbms_sql.number_table;
begin
    wwv_flow_security.g_security_group_id := 10;

    l_app(l_app.count+1) := 4000;
    l_app(l_app.count+1) := 4020;
    l_app(l_app.count+1) := 4050;
    l_app(l_app.count+1) := 4300;
    l_app(l_app.count+1) := 4350;
    l_app(l_app.count+1) := 4400;
    l_app(l_app.count+1) := 4500;
    l_app(l_app.count+1) := 4550;
    l_app(l_app.count+1) := 4700;
    l_app(l_app.count+1) := 4750;
    l_app(l_app.count+1) := 4800;
    l_app(l_app.count+1) := 4850;

    for i in 1..l_app.count loop
        for j in 0..9 loop
            wwv_flow_imp.remove_application( l_app(i)+j );
        end loop;
    end loop;
    commit;
end;
/


--==============================================================================
@^PREFIX.core/scripts/install_action.sql "Validating Installation"

alter session set current_schema = SYS;

alter session set recyclebin = ON;

exec validate_apex;

--==============================================================================
timing stop
begin
    ^APPUN..wwv_install_api.end_phase (
        p_phase       => 1,
        p_raise_error => false );
    ^APPUN..wwv_install_api.end_install;
end;
/

--==============================================================================
spool off

column global_name new_value gname
set termout off
select user global_name from sys.dual;
set termout on
set heading on
set feedback on
set sqlprompt '^gname> '

