/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.faces;

import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableDataProvider;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.faces.model.DataModel;
import javax.faces.model.DataModelEvent;
import javax.faces.model.DataModelListener;

public class TableDataProviderDataModel
extends DataModel {
    private FieldKey[] fieldKeys = null;
    private int rowIndex = -1;
    private TableDataProvider tdp = null;

    public TableDataProviderDataModel() {
        this(null);
    }

    public TableDataProviderDataModel(TableDataProvider tdp) {
        this.setTableDataProvider(tdp);
    }

    public TableDataProvider getTableDataProvider() {
        return this.tdp;
    }

    public void setTableDataProvider(TableDataProvider tdp) {
        this.tdp = tdp;
        if (tdp == null) {
            this.fieldKeys = null;
            this.rowIndex = -1;
        } else {
            this.fieldKeys = tdp.getFieldKeys();
        }
    }

    public boolean isRowAvailable() {
        if (this.getTableDataProvider() == null) {
            return false;
        }
        return this.getTableDataProvider().isRowAvailable(this.getRowKey());
    }

    public int getRowCount() {
        if (this.getTableDataProvider() == null) {
            return -1;
        }
        return this.getTableDataProvider().getRowCount();
    }

    public Object getRowData() {
        if (this.getTableDataProvider() == null) {
            return null;
        }
        if (!this.getTableDataProvider().isRowAvailable(this.getRowKey())) {
            throw new IllegalArgumentException("" + this.getRowIndex());
        }
        TableDataProviderMap map = new TableDataProviderMap();
        for (int i = 0; i < this.fieldKeys.length; ++i) {
            map.put(this.fieldKeys[i].getFieldId(), this.tdp.getValue(this.fieldKeys[i], this.getRowKey()));
        }
        return map;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public RowKey getRowKey() {
        int i = this.getRowIndex();
        RowKey[] rks = this.tdp.getRowKeys(i + 1, null);
        if (rks.length > i) {
            return rks[i];
        }
        return null;
    }

    public void setRowIndex(int rowIndex) {
        if (rowIndex < -1) {
            throw new IllegalArgumentException("" + rowIndex);
        }
        int oldIndex = this.rowIndex;
        this.rowIndex = rowIndex;
        if (this.getTableDataProvider() == null) {
            return;
        }
        DataModelListener[] listeners = this.getDataModelListeners();
        if (oldIndex != rowIndex && listeners != null) {
            Object rowData = null;
            if (this.isRowAvailable()) {
                rowData = this.getRowData();
            }
            DataModelEvent event = new DataModelEvent((DataModel)this, rowIndex, rowData);
            for (int i = 0; i < listeners.length; ++i) {
                listeners[i].rowSelected(event);
            }
        }
    }

    public Object getWrappedData() {
        return this.getTableDataProvider();
    }

    public void setWrappedData(Object data) {
        this.setTableDataProvider((TableDataProvider)data);
    }

    private class TableDataProviderEntries
    extends AbstractSet {
        private TableDataProviderMap map = null;

        public TableDataProviderEntries(TableDataProviderMap map) {
            this.map = map;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object o) {
            if (o == null) {
                throw new NullPointerException();
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object k = e.getKey();
            Object v = e.getValue();
            if (!this.map.containsKey(k)) {
                return false;
            }
            if (v == null) {
                return this.map.get(k) == null;
            }
            return v.equals(this.map.get(k));
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Iterator iterator() {
            return new TableDataProviderIterator(this.map);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }
    }

    private class TableDataProviderEntry
    implements Map.Entry {
        private TableDataProviderMap map = null;
        private Object key = null;

        public TableDataProviderEntry(TableDataProviderMap map, Object key) {
            this.map = map;
            this.key = key;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            if (this.key == null ? e.getKey() != null : !this.key.equals(e.getKey())) {
                return false;
            }
            Object v = this.map.get(this.key);
            return !(v == null ? e.getValue() != null : !v.equals(e.getValue()));
        }

        public Object getKey() {
            return this.key;
        }

        public Object getValue() {
            return this.map.get(this.key);
        }

        public int hashCode() {
            Object value = this.map.get(this.key);
            return (this.key == null ? 0 : this.key.hashCode()) ^ (value == null ? 0 : value.hashCode());
        }

        public Object setValue(Object value) {
            Object previous = this.map.get(this.key);
            this.map.put(this.key, value);
            return previous;
        }
    }

    private class TableDataProviderIterator
    implements Iterator {
        private TableDataProviderMap map = null;
        private Iterator keys = null;

        public TableDataProviderIterator(TableDataProviderMap map) {
            this.map = map;
            this.keys = map.keySet().iterator();
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            Object key = this.keys.next();
            return new TableDataProviderEntry(this.map, key);
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class TableDataProviderKeys
    extends AbstractSet {
        private TableDataProviderMap map = null;

        public TableDataProviderKeys(TableDataProviderMap map) {
            this.map = map;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object o) {
            return this.map.containsKey(o);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public Iterator iterator() {
            return new TableDataProviderKeysIterator(this.map);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }
    }

    private class TableDataProviderKeysIterator
    implements Iterator {
        private TableDataProviderMap map = null;
        private Iterator keys = null;

        public TableDataProviderKeysIterator(TableDataProviderMap map) {
            this.map = map;
            this.keys = map.realKeys();
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            return this.keys.next();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class TableDataProviderMap
    extends AbstractMap {
        private int rowIndex;
        private RowKey rowKey;
        private FieldKey[] fieldKeys;
        private TableDataProvider tdp;

        public TableDataProviderMap() {
            this.fieldKeys = TableDataProviderDataModel.this.fieldKeys;
            this.tdp = TableDataProviderDataModel.this.tdp;
            this.rowIndex = TableDataProviderDataModel.this.getRowIndex();
            this.rowKey = TableDataProviderDataModel.this.getRowKey();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsValue(Object value) {
            for (Object key : this.keySet()) {
                Object contained = this.get(key);
                if (!(value == null ? contained == null : value.equals(contained))) continue;
                return true;
            }
            return false;
        }

        public Set entrySet() {
            return new TableDataProviderEntries(this);
        }

        public Object get(Object key) {
            int columnIndex = this.index(key);
            if (columnIndex < 0) {
                return null;
            }
            return this.tdp.getValue(this.fieldKeys[columnIndex], this.rowKey);
        }

        public Set keySet() {
            return new TableDataProviderKeys(this);
        }

        public Object put(Object key, Object value) {
            int columnIndex = this.index(key);
            if (columnIndex < 0) {
                return null;
            }
            Object previous = this.tdp.getValue(this.fieldKeys[columnIndex], this.rowKey);
            this.tdp.setValue(this.fieldKeys[columnIndex], this.rowKey, value);
            return previous;
        }

        public void putAll(Map map) {
            for (Object key : map.keySet()) {
                this.put(key, map.get(key));
            }
        }

        public Object remove(Object key) {
            throw new UnsupportedOperationException();
        }

        public Collection values() {
            return new TableDataProviderValues(this);
        }

        private int index(Object key) {
            int index = -1;
            for (int i = 0; i < this.fieldKeys.length; ++i) {
                if (!key.equals(this.fieldKeys[i].getFieldId())) continue;
                index = i;
                break;
            }
            return index;
        }

        Object realKey(Object key) {
            return super.get(key);
        }

        Iterator realKeys() {
            return super.keySet().iterator();
        }
    }

    private class TableDataProviderValues
    extends AbstractCollection {
        private TableDataProviderMap map = null;

        public TableDataProviderValues(TableDataProviderMap map) {
            this.map = map;
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object value) {
            return this.map.containsValue(value);
        }

        public Iterator iterator() {
            return new TableDataProviderValuesIterator(this.map);
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.map.size();
        }
    }

    private class TableDataProviderValuesIterator
    implements Iterator {
        private TableDataProviderMap map = null;
        private Iterator keys = null;

        public TableDataProviderValuesIterator(TableDataProviderMap map) {
            this.map = map;
            this.keys = map.keySet().iterator();
        }

        public boolean hasNext() {
            return this.keys.hasNext();
        }

        public Object next() {
            return this.map.get(this.keys.next());
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

