/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataListener;
import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RefreshableDataListener;
import com.sun.data.provider.RefreshableDataProvider;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableCursorVetoException;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.TransactionalDataListener;
import com.sun.data.provider.TransactionalDataProvider;
import com.sun.data.provider.impl.AbstractTableDataProvider;
import com.sun.data.provider.impl.MetaDataDeserializer;
import com.sun.data.provider.impl.MetaDataSerializer;
import com.sun.sql.rowset.CachedRowSetX;
import com.sun.sql.rowset.SyncResolverX;
import java.beans.Beans;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileFilter;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.sql.RowSet;
import javax.sql.RowSetEvent;
import javax.sql.RowSetListener;
import javax.sql.rowset.CachedRowSet;
import javax.sql.rowset.serial.SerialBlob;
import javax.sql.rowset.serial.SerialClob;
import javax.sql.rowset.spi.SyncProviderException;
import javax.sql.rowset.spi.SyncResolver;

public class CachedRowSetDataProvider
extends AbstractTableDataProvider
implements TableDataProvider,
TransactionalDataProvider,
RefreshableDataProvider {
    private static Logger LOGGER = Logger.getLogger(CachedRowSetDataProvider.class.getName());
    private static ResourceBundle bundle = ResourceBundle.getBundle("com.sun.data.provider.impl.Bundle", Locale.getDefault(), CachedRowSetDataProvider.class.getClassLoader());
    private FieldKey[] fieldKeys = null;
    private Map fieldKeysMap = null;
    private transient ResultSetMetaData metaData = null;
    private CachedRowSet cachedRowSet = null;
    private boolean onInsertRow = false;
    private boolean executed = false;
    private boolean refreshMetaDataFile = false;
    private String metaDataFilename;
    private RowSetPropertyChangeListener propertyChangeListener = null;
    private RowSetListener rowSetListener = null;
    protected RowKey cursorRow = new CachedRowSetRowKey(0);

    public CachedRowSetDataProvider() {
    }

    public CachedRowSetDataProvider(CachedRowSet cachedRowSet) {
        this.setCachedRowSet(cachedRowSet);
    }

    public CachedRowSet getCachedRowSet() {
        return this.cachedRowSet;
    }

    public void setCachedRowSet(CachedRowSet cachedRowSet) {
        if (this.cachedRowSet != null && this.cachedRowSet instanceof CachedRowSetX && this.propertyChangeListener != null) {
            ((CachedRowSetX)this.cachedRowSet).removePropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
            this.propertyChangeListener = null;
        }
        if (this.cachedRowSet != null && this.rowSetListener != null) {
            this.cachedRowSet.removeRowSetListener(this.rowSetListener);
            this.rowSetListener = null;
        }
        try {
            this.cursorFirst();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.cachedRowSet = cachedRowSet;
        this.metaData = null;
        this.fieldKeys = null;
        this.fieldKeysMap = null;
        if (cachedRowSet != null && cachedRowSet instanceof CachedRowSetX) {
            this.propertyChangeListener = new RowSetPropertyChangeListener();
            ((CachedRowSetX)cachedRowSet).addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
            if (!Beans.isDesignTime()) {
                try {
                    this.executed = ((CachedRowSetX)cachedRowSet).isExecuted();
                }
                catch (SQLException e) {
                    LOGGER.log(Level.WARNING, null, e);
                    this.executed = false;
                }
            } else {
                this.executed = false;
            }
        }
        if (cachedRowSet != null) {
            this.rowSetListener = new CachedRowSetListener();
            cachedRowSet.addRowSetListener(this.rowSetListener);
        }
        this.fireProviderChanged();
    }

    public void close() {
        if (!Beans.isDesignTime()) {
            try {
                this.setCachedRowSet(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RowKey[] getRowKeys(int count, RowKey afterRow) throws DataProviderException {
        if (this.getCachedRowSet() == null) {
            return new CachedRowSetRowKey[0];
        }
        int cursorIndexSave = this.getCursorIndex();
        ArrayList<CachedRowSetRowKey> keys = new ArrayList<CachedRowSetRowKey>();
        try {
            int startIndex = 0;
            if (afterRow instanceof CachedRowSetRowKey) {
                startIndex = ((CachedRowSetRowKey)afterRow).getIndex() + 1;
            }
            while (this.absolute(startIndex + 1) && keys.size() < count) {
                try {
                    if (!this.isUpdatable() || !this.getCachedRowSet().rowDeleted()) {
                        keys.add(new CachedRowSetRowKey(startIndex));
                    }
                }
                catch (SQLException e) {
                    // empty catch block
                }
                ++startIndex;
            }
            RowKey[] rowKeyArray = keys.toArray(new CachedRowSetRowKey[0]);
            return rowKeyArray;
        }
        finally {
            try {
                this.setCursorIndex(cursorIndexSave);
            }
            catch (IllegalArgumentException e) {}
        }
    }

    public RowKey[] getAllRows() throws DataProviderException {
        return this.getRowKeys(Integer.MAX_VALUE, null);
    }

    public RowKey getRowKey(String rowId) throws DataProviderException {
        return CachedRowSetRowKey.create(rowId);
    }

    protected int getCursorIndex() {
        if (this.cursorRow instanceof CachedRowSetRowKey) {
            return ((CachedRowSetRowKey)this.cursorRow).getIndex();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean absolute(int index) {
        boolean bl;
        if (this.getCachedRowSet() == null) {
            return false;
        }
        if (Beans.isDesignTime()) {
            return index >= 1 && index <= 3;
        }
        this.checkExecute();
        boolean saveShowDeleted = this.getCachedRowSet().getShowDeleted();
        try {
            this.getCachedRowSet().setShowDeleted(true);
            bl = this.getCachedRowSet().absolute(index);
        }
        catch (SQLException e) {
            boolean bl2;
            try {
                bl2 = false;
            }
            catch (Throwable throwable) {
                try {
                    this.getCachedRowSet().setShowDeleted(saveShowDeleted);
                    throw throwable;
                }
                catch (SQLException e2) {
                    return false;
                }
            }
            this.getCachedRowSet().setShowDeleted(saveShowDeleted);
            return bl2;
        }
        this.getCachedRowSet().setShowDeleted(saveShowDeleted);
        return bl;
    }

    protected boolean setCursorIndex(int index) {
        try {
            this.setCursorRow(new CachedRowSetRowKey(index));
            return true;
        }
        catch (TableCursorVetoException tcvx) {
            return false;
        }
    }

    public RowKey getCursorRow() throws DataProviderException {
        return this.cursorRow;
    }

    public void setCursorRow(RowKey row) throws TableCursorVetoException {
        if (Beans.isDesignTime()) {
            if (!this.isRowAvailable(row)) {
                throw new IllegalArgumentException(bundle.getString("ROW_NOT_AVAILABLE"));
            }
            RowKey oldRow = this.cursorRow;
            this.fireCursorChanging(oldRow, row);
            this.cursorRow = row;
            this.fireCursorChanged(oldRow, this.cursorRow);
            return;
        }
        if (this.getCachedRowSet() != null && row instanceof CachedRowSetRowKey) {
            try {
                this.checkExecute();
                if (this.absolute(((CachedRowSetRowKey)row).getIndex() + 1)) {
                    if (this.isUpdatable() && this.getCachedRowSet().rowDeleted()) {
                        throw new IllegalArgumentException("" + row);
                    }
                    RowKey oldRow = this.cursorRow;
                    this.fireCursorChanging(oldRow, row);
                    this.cursorRow = row;
                    this.fireCursorChanged(oldRow, this.cursorRow);
                    return;
                }
                throw new IllegalArgumentException("" + row);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public boolean cursorFirst() throws DataProviderException {
        RowKey[] keys = this.getRowKeys(1, null);
        if (keys.length == 0) {
            return false;
        }
        try {
            this.setCursorRow((CachedRowSetRowKey)keys[0]);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean cursorNext() throws DataProviderException {
        RowKey[] keys = this.getRowKeys(1, this.getCursorRow());
        if (keys.length == 0) {
            return false;
        }
        try {
            this.setCursorRow((CachedRowSetRowKey)keys[0]);
            return true;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean cursorPrevious() throws DataProviderException {
        for (int idx = this.getCursorIndex() - 1; idx >= 0; --idx) {
            try {
                this.setCursorIndex(idx);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                continue;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean cursorLast() throws DataProviderException {
        if (Beans.isDesignTime()) {
            this.setCursorIndex(2);
            return true;
        }
        saveShowDeleted = false;
        try {
            try {
                saveShowDeleted = this.getCachedRowSet().getShowDeleted();
                this.getCachedRowSet().setShowDeleted(true);
                try {
                    this.getCachedRowSet().last();
                    while (true) lbl-1000:
                    // 2 sources

                    {
                        key = this.getCachedRowSet().getRow() - 1;
                        if (this.isUpdatable() && this.getCachedRowSet().rowDeleted()) continue;
                        this.setCursorRow(new CachedRowSetRowKey((int)key));
                        var3_5 = true;
                        return var3_5;
                    }
                }
                catch (SQLException e2) {
                    var3_7 = false;
                    return var3_7;
                }
                {
                    ** while (this.getCachedRowSet().previous())
                }
lbl23:
                // 1 sources

                key = false;
                return key;
            }
            finally {
                try {
                    this.getCachedRowSet().setShowDeleted(saveShowDeleted);
                }
                catch (SQLException e) {}
            }
        }
        catch (SQLException e) {
            return false;
        }
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        try {
            return this.getFieldKeyInternal(fieldId);
        }
        catch (IllegalArgumentException e) {
            if (fieldId.indexOf(46) == -1 && this.fieldKeysMap != null) {
                Iterator i = this.fieldKeysMap.values().iterator();
                while (i.hasNext()) {
                    FieldKey fieldKey = (FieldKey)i.next();
                    String val = fieldKey.getFieldId();
                    int loc = val.lastIndexOf(46);
                    if (loc >= 0 && loc + 1 < val.length()) {
                        val = val.substring(loc + 1);
                    }
                    if (!val.equalsIgnoreCase(fieldId)) continue;
                    return fieldKey;
                }
            }
            throw e;
        }
    }

    private FieldKey getFieldKeyInternal(String fieldId) throws DataProviderException {
        FieldKey fieldKey;
        if (this.fieldKeysMap == null) {
            if (this.fieldKeys == null) {
                this.getFieldKeys();
                if (this.fieldKeys == null) {
                    return null;
                }
            }
            this.fieldKeysMap = new TreeMap(String.CASE_INSENSITIVE_ORDER);
            for (int i = 0; i < this.fieldKeys.length; ++i) {
                this.fieldKeysMap.put(this.fieldKeys[i].getFieldId(), this.fieldKeys[i]);
            }
        }
        if ((fieldKey = (FieldKey)this.fieldKeysMap.get(fieldId)) != null) {
            return fieldKey;
        }
        throw new IllegalArgumentException(fieldId);
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        if (this.fieldKeys == null) {
            ResultSetMetaData metaData = this.getMetaData();
            if (metaData == null) {
                return FieldKey.EMPTY_ARRAY;
            }
            try {
                this.fieldKeys = new FieldKey[metaData.getColumnCount()];
                for (int i = 0; i < this.fieldKeys.length; ++i) {
                    String tableName = "";
                    if (metaData.getTableName(i + 1) != null && !metaData.getTableName(i + 1).equals("")) {
                        tableName = metaData.getTableName(i + 1) + ".";
                    }
                    this.fieldKeys[i] = new FieldKey(tableName + metaData.getColumnName(i + 1));
                }
            }
            catch (SQLException e) {
                this.fieldKeys = null;
                throw new RuntimeException(e);
            }
        }
        if (this.fieldKeys != null) {
            return this.fieldKeys;
        }
        return FieldKey.EMPTY_ARRAY;
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        ResultSetMetaData metaData = this.getMetaData();
        if (metaData != null) {
            try {
                int column = this.column(fieldKey);
                if (column > 0) {
                    String className = metaData.getColumnClassName(column);
                    if (Beans.isDesignTime() && className.equals("oracle.sql.TIMESTAMP")) {
                        return Timestamp.class;
                    }
                    if (Beans.isDesignTime() && className.equals("oracle.sql.CLOB")) {
                        return Clob.class;
                    }
                    return Class.forName(className);
                }
                throw new IllegalArgumentException(fieldKey.getFieldId());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public RowKey appendRow() throws DataProviderException {
        if (!this.canAppendRow()) {
            return null;
        }
        boolean saveShowDeleted = false;
        try {
            saveShowDeleted = this.getCachedRowSet().getShowDeleted();
            this.getCachedRowSet().setShowDeleted(true);
            try {
                this.getCachedRowSet().last();
                int newRow = this.getCachedRowSet().getRow();
                this.getCachedRowSet().moveToInsertRow();
                ResultSetMetaData rsmd = this.getMetaData();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                    if (rsmd.isNullable(i) != 0 || !rsmd.isWritable(i)) continue;
                    this.getCachedRowSet().updateObject(i, CachedRowSetDataProvider.manufacturePlaceholder(rsmd.getColumnClassName(i), false, rsmd.getColumnType(i)));
                }
                this.getCachedRowSet().insertRow();
                CachedRowSetRowKey cachedRowSetRowKey = new CachedRowSetRowKey(newRow);
                return cachedRowSetRowKey;
            }
            catch (SQLException e2) {
                try {
                    throw new RuntimeException(e2);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        finally {
            try {
                this.getCachedRowSet().setShowDeleted(saveShowDeleted);
            }
            catch (SQLException e) {}
        }
    }

    public boolean canInsertRow(RowKey beforeRow) throws DataProviderException {
        return false;
    }

    public boolean canAppendRow() throws DataProviderException {
        try {
            return this.isUpdatable();
        }
        catch (SQLException e) {
            return false;
        }
    }

    public boolean canRemoveRow(RowKey row) throws DataProviderException {
        try {
            return this.isUpdatable() && this.isRowAvailable(row);
        }
        catch (SQLException e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getRowCount() throws DataProviderException {
        if (this.getCachedRowSet() == null) {
            return 0;
        }
        int rowCount = 0;
        int cursorIndexSave = this.getCursorIndex();
        try {
            int startIndex = 0;
            while (this.absolute(startIndex + 1)) {
                try {
                    if (!this.isUpdatable() || !this.getCachedRowSet().rowDeleted()) {
                        ++rowCount;
                    }
                }
                catch (SQLException e) {
                    int n = -1;
                    try {
                        this.setCursorIndex(cursorIndexSave);
                    }
                    catch (IllegalArgumentException e2) {
                        // empty catch block
                    }
                    return n;
                }
                ++startIndex;
            }
            int n = rowCount;
            return n;
        }
        finally {
            try {
                this.setCursorIndex(cursorIndexSave);
            }
            catch (IllegalArgumentException e) {}
        }
    }

    public Object getValue(FieldKey fieldKey, RowKey row) throws DataProviderException {
        if (Beans.isDesignTime()) {
            try {
                return CachedRowSetDataProvider.manufacturePlaceholder(this.getMetaData().getColumnClassName(this.column(fieldKey)), true, this.getMetaData().getColumnType(this.column(fieldKey)));
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.getCachedRowSet() != null && row instanceof CachedRowSetRowKey) {
            try {
                this.checkExecute();
                if (this.absolute(((CachedRowSetRowKey)row).getIndex() + 1)) {
                    Object obj = this.getCachedRowSet().getObject(this.column(fieldKey));
                    if (this.getMetaData().getColumnClassName(this.column(fieldKey)).equals("oracle.sql.TIMESTAMP")) {
                        try {
                            Class<?> c = Class.forName("oracle.sql.TIMESTAMP");
                            if (obj.getClass().getName().equals("oracle.sql.TIMESTAMP")) {
                                Method m = c.getMethod("toJdbc", null);
                                Object newObj = m.invoke(obj, (Object[])null);
                                return newObj;
                            }
                            return obj;
                        }
                        catch (Exception e) {
                            return obj;
                        }
                    }
                    return obj;
                }
                throw new IndexOutOfBoundsException("" + row);
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public RowKey insertRow(RowKey beforeRow) throws DataProviderException {
        return null;
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        try {
            if (!this.isUpdatable()) {
                return true;
            }
            ResultSetMetaData metaData = this.getMetaData();
            if (metaData.isReadOnly(this.column(fieldKey))) {
                return true;
            }
        }
        catch (SQLException e) {
            return false;
        }
        return false;
    }

    public boolean isRowAvailable(RowKey row) throws DataProviderException {
        if (!(row instanceof CachedRowSetRowKey)) {
            return false;
        }
        int index = ((CachedRowSetRowKey)row).getIndex();
        if (Beans.isDesignTime()) {
            return index >= 0 && index <= 2;
        }
        if (this.getCachedRowSet() != null) {
            try {
                this.checkExecute();
                if (this.absolute(index + 1)) {
                    return !this.isUpdatable() || !this.getCachedRowSet().rowDeleted();
                }
            }
            catch (SQLException e) {
                return false;
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeRow(RowKey row) throws DataProviderException {
        int index = ((CachedRowSetRowKey)row).getIndex();
        if (this.getCachedRowSet() == null) throw new IllegalStateException();
        try {
            if (!this.isUpdatable()) {
                throw new IllegalArgumentException("" + row);
            }
            if (!this.absolute(index + 1)) throw new IllegalArgumentException("" + row);
            if (this.getCachedRowSet().rowDeleted()) return;
            this.getCachedRowSet().deleteRow();
            return;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public void setValue(FieldKey fieldKey, RowKey row, Object value) throws DataProviderException {
        block13: {
            if (this.getCachedRowSet() != null && row instanceof CachedRowSetRowKey) {
                try {
                    if (!this.isUpdatable()) {
                        throw new IllegalStateException("" + fieldKey.getFieldId());
                    }
                    if (this.absolute(((CachedRowSetRowKey)row).getIndex() + 1)) {
                        if (this.getCachedRowSet().rowDeleted()) {
                            throw new IllegalStateException("" + fieldKey.getFieldId());
                        }
                        if (this.isReadOnly(fieldKey)) {
                            throw new IllegalStateException("" + fieldKey.getFieldId());
                        }
                        int column = this.column(fieldKey);
                        Object old = this.getCachedRowSet().getObject(column);
                        boolean changed = false;
                        if (old == null) {
                            changed = value != null;
                        } else if (value == null) {
                            changed = true;
                        } else {
                            boolean bl = changed = !old.equals(value);
                        }
                        if (changed) {
                            this.getCachedRowSet().updateObject(column, value);
                            this.getCachedRowSet().updateRow();
                            this.fireValueChanged(fieldKey, row, old, value);
                            if (row != null && row.equals(this.getCursorRow())) {
                                this.fireValueChanged(fieldKey, old, value);
                            }
                        }
                        break block13;
                    }
                    throw new IndexOutOfBoundsException("" + row);
                }
                catch (SQLException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    public void addRefreshableDataListener(RefreshableDataListener listener) {
        super.addDataListener(listener);
    }

    public void removeRefreshableDataListener(RefreshableDataListener listener) {
        super.removeDataListener(listener);
    }

    public RefreshableDataListener[] getRefreshableDataListeners() {
        if (this.dpListeners == null) {
            return new RefreshableDataListener[0];
        }
        ArrayList<DataListener> rdList = new ArrayList<DataListener>();
        for (int i = 0; i < this.dpListeners.length; ++i) {
            if (!(this.dpListeners[i] instanceof RefreshableDataListener)) continue;
            rdList.add(this.dpListeners[i]);
        }
        return rdList.toArray(new RefreshableDataListener[rdList.size()]);
    }

    public void refresh() throws DataProviderException {
        if (this.getCachedRowSet() != null && this.getCachedRowSet() instanceof CachedRowSet) {
            try {
                this.getCachedRowSet().release();
                this.executed = false;
                this.fireRefreshed();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void commitChanges() throws DataProviderException {
        if (this.getCachedRowSet() != null) {
            try {
                this.checkExecute();
                try {
                    this.getCachedRowSet().acceptChanges();
                    this.fireChangesCommitted();
                }
                catch (SyncProviderException spe) {
                    SyncResolver resolver = spe.getSyncResolver();
                    String message = null;
                    if (resolver == null) {
                        message = spe.getMessage();
                    } else {
                        while (resolver.nextConflict()) {
                            int row = resolver.getRow();
                            String pattern = "{0} {1} {2}";
                            switch (resolver.getStatus()) {
                                case 1: {
                                    pattern = bundle.getString("DELETE_ROW_CONFLICT");
                                    break;
                                }
                                case 2: {
                                    pattern = bundle.getString("INSERT_ROW_CONFLICT");
                                    break;
                                }
                                case 0: {
                                    pattern = bundle.getString("UPDATE_ROW_CONFLICT");
                                }
                            }
                            String sqlExceptionText = "";
                            if (resolver instanceof SyncResolverX) {
                                sqlExceptionText = ((SyncResolverX)resolver).getSQLException().getLocalizedMessage();
                            }
                            Object[] args = new String[]{spe.getMessage(), Integer.toString(row - 1), sqlExceptionText};
                            message = MessageFormat.format(pattern, args);
                            this.absolute(row);
                            int colCount = this.getCachedRowSet().getMetaData().getColumnCount();
                            for (int i = 1; i <= colCount; ++i) {
                                try {
                                    if (resolver.getConflictValue(i) == null) continue;
                                    message = message + ": " + resolver.getConflictValue(this.getCachedRowSet().getMetaData().getColumnName(i));
                                    continue;
                                }
                                catch (SQLException se) {
                                    message = message + ": <unknown>";
                                }
                            }
                        }
                    }
                    throw new RuntimeException(message, spe);
                }
            }
            catch (SQLException sqle) {
                throw new RuntimeException(sqle);
            }
        }
    }

    public void revertChanges() throws DataProviderException {
        if (this.getCachedRowSet() != null) {
            try {
                this.checkExecute();
                this.getCachedRowSet().restoreOriginal();
                this.fireChangesReverted();
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void addTransactionalDataListener(TransactionalDataListener listener) {
        super.addDataListener(listener);
    }

    public void removeTransactionalDataListener(TransactionalDataListener listener) {
        super.removeDataListener(listener);
    }

    public TransactionalDataListener[] getTransactionalDataListeners() {
        if (this.dpListeners == null) {
            return new TransactionalDataListener[0];
        }
        ArrayList<DataListener> tdList = new ArrayList<DataListener>();
        for (int i = 0; i < this.dpListeners.length; ++i) {
            if (!(this.dpListeners[i] instanceof TransactionalDataListener)) continue;
            tdList.add(this.dpListeners[i]);
        }
        return tdList.toArray(new TransactionalDataListener[tdList.size()]);
    }

    private void fireRefreshed() {
        RefreshableDataListener[] rdList = this.getRefreshableDataListeners();
        for (int i = 0; i < rdList.length; ++i) {
            rdList[i].refreshed(this);
        }
    }

    private static Object manufacturePlaceholder(String className, boolean fakeData, int columnType) throws SQLException {
        if (className.equals("java.sql.Date")) {
            return new Date(new java.util.Date().getTime());
        }
        if (className.equals("java.sql.Time")) {
            return new Time(new java.util.Date().getTime());
        }
        if (className.equals("java.sql.Timestamp")) {
            return new Timestamp(new java.util.Date().getTime());
        }
        if (className.equals("java.math.BigDecimal")) {
            return new BigDecimal(fakeData ? BigInteger.ONE : BigInteger.ZERO);
        }
        if (className.equals("java.math.BigInteger")) {
            return fakeData ? BigInteger.ONE : BigInteger.ZERO;
        }
        if (className.equals("java.lang.Boolean")) {
            return fakeData ? Boolean.TRUE : Boolean.FALSE;
        }
        if (className.equals("java.lang.Byte")) {
            return new Byte(fakeData ? (byte)123 : 0);
        }
        if (className.equals("java.lang.Character")) {
            return new Character(fakeData ? (char)'c' : ' ');
        }
        if (className.equals("java.lang.Double")) {
            return new Double(fakeData ? 123.0 : 0.0);
        }
        if (className.equals("java.lang.Float")) {
            return new Float(fakeData ? 123.0 : 0.0);
        }
        if (className.equals("java.lang.Integer")) {
            return new Integer(fakeData ? 123 : 0);
        }
        if (className.equals("java.lang.Long")) {
            return new Long(fakeData ? 123L : 0L);
        }
        if (className.equals("java.lang.Short")) {
            return new Short((short)(fakeData ? 123 : 0));
        }
        if (className.equals("java.lang.String")) {
            return fakeData ? bundle.getString("arbitraryCharData") : "";
        }
        if (className.equals("java.sql.Blob")) {
            try {
                byte[] byArray;
                if (fakeData) {
                    byte[] byArray2 = new byte[5];
                    byArray2[0] = 1;
                    byArray2[1] = 2;
                    byArray2[2] = 3;
                    byArray2[3] = 4;
                    byArray = byArray2;
                    byArray2[4] = 5;
                } else {
                    byArray = new byte[]{};
                }
                return new SerialBlob(byArray);
            }
            catch (SQLException e) {
                return new Object();
            }
        }
        if (className.equals("javax.sql.SerialClob")) {
            try {
                return new SerialClob(fakeData ? bundle.getString("arbitraryClobData").toCharArray() : new char[]{});
            }
            catch (SQLException e) {
                return new Object();
            }
        }
        if (className.equals("java.net.URL")) {
            try {
                if (fakeData) {
                    return new URL("http://www.sun.com");
                }
                return new URL("");
            }
            catch (MalformedURLException e) {
                return new Object();
            }
        }
        if (className.equals("java.sql.Array")) {
            return new Array(){

                public Object getArray() {
                    return null;
                }

                public Object getArray(long index, int count) {
                    return null;
                }

                public Object getArray(long index, int count, Map map) {
                    return null;
                }

                public Object getArray(Map map) {
                    return null;
                }

                public int getBaseType() {
                    return 1;
                }

                public String getBaseTypeName() {
                    return "CHAR";
                }

                public ResultSet getResultSet() {
                    return null;
                }

                public ResultSet getResultSet(long index, int count) {
                    return null;
                }

                public ResultSet getResultSet(long index, int count, Map map) {
                    return null;
                }

                public ResultSet getResultSet(Map map) {
                    return null;
                }

                public void free() {
                }
            };
        }
        if (className.equals("char[]")) {
            char[] cArray;
            if (fakeData) {
                char[] cArray2 = new char[5];
                cArray2[0] = 97;
                cArray2[1] = 98;
                cArray2[2] = 99;
                cArray2[3] = 100;
                cArray = cArray2;
                cArray2[4] = 101;
            } else {
                cArray = new char[]{};
            }
            return cArray;
        }
        if (className.equals("byte[]")) {
            byte[] byArray;
            if (fakeData) {
                byte[] byArray3 = new byte[5];
                byArray3[0] = 1;
                byArray3[1] = 2;
                byArray3[2] = 3;
                byArray3[3] = 4;
                byArray = byArray3;
                byArray3[4] = 5;
            } else {
                byArray = new byte[]{};
            }
            return byArray;
        }
        if (className.equals("java.sql.Ref")) {
            return new Ref(){
                private Object data = CachedRowSetDataProvider.access$700().getString("arbitraryCharData");

                public String getBaseTypeName() {
                    return "CHAR";
                }

                public Object getObject() {
                    return this.data;
                }

                public Object getObject(Map map) {
                    return this.data;
                }

                public void setObject(Object value) {
                    this.data = value;
                }
            };
        }
        if (className.equals("java.sql.Struct")) {
            return new Struct(){
                private String[] data = new String[]{CachedRowSetDataProvider.access$700().getString("arbitraryCharData"), CachedRowSetDataProvider.access$700().getString("arbitraryCharData2"), CachedRowSetDataProvider.access$700().getString("arbitraryCharData3")};

                public Object[] getAttributes() {
                    return this.data;
                }

                public Object[] getAttributes(Map map) {
                    return this.data;
                }

                public String getSQLTypeName() {
                    return "CHAR";
                }
            };
        }
        if (fakeData) {
            return CachedRowSetDataProvider.getFakeData(columnType);
        }
        try {
            return Class.forName(className).newInstance();
        }
        catch (ClassNotFoundException e) {
            return new ColumnNotSet();
        }
        catch (InstantiationException e) {
            return new ColumnNotSet();
        }
        catch (IllegalAccessException e) {
            return new ColumnNotSet();
        }
    }

    protected void checkExecute() throws SQLException {
        if (!Beans.isDesignTime() && !this.executed) {
            this.getCachedRowSet().execute();
            this.getCachedRowSet().first();
            this.executed = true;
        }
    }

    private boolean isUpdatable() throws SQLException {
        if (Beans.isDesignTime() || this.getCachedRowSet() == null) {
            return false;
        }
        this.checkExecute();
        return this.getCachedRowSet().getConcurrency() != 1007;
    }

    private int column(FieldKey fieldKey) throws DataProviderException {
        if (this.fieldKeys == null) {
            this.getFieldKeys();
        }
        if (this.fieldKeys != null) {
            int i;
            for (i = 0; i < this.fieldKeys.length; ++i) {
                if (!fieldKey.getFieldId().equals(this.fieldKeys[i].getFieldId())) continue;
                return i + 1;
            }
            if (fieldKey.getFieldId().indexOf(46) == -1) {
                for (i = 0; i < this.fieldKeys.length; ++i) {
                    String val = this.fieldKeys[i].getFieldId();
                    int loc = val.lastIndexOf(46);
                    if (loc >= 0 && loc + 1 < val.length()) {
                        val = val.substring(loc + 1);
                    }
                    if (!val.equalsIgnoreCase(fieldKey.getFieldId())) continue;
                    return i + 1;
                }
            }
        }
        return 0;
    }

    protected void fireChangesCommitted() {
        TransactionalDataListener[] tdList = this.getTransactionalDataListeners();
        for (int i = 0; i < tdList.length; ++i) {
            tdList[i].changesCommitted(this);
        }
    }

    protected void fireChangesReverted() {
        TransactionalDataListener[] tdList = this.getTransactionalDataListeners();
        for (int i = 0; i < tdList.length; ++i) {
            tdList[i].changesReverted(this);
        }
    }

    private ResultSetMetaData getMetaData() {
        if (this.metaData == null && this.getCachedRowSet() != null) {
            try {
                MetaDataSerializer mdSerializer = new MetaDataSerializer();
                String filename = mdSerializer.generateMetaDataName(mdSerializer.generateFilename(this.getCachedRowSet().getDataSourceName(), this.getCachedRowSet().getCommand()));
                if (filename.startsWith("null")) {
                    this.metaData = this.getCachedRowSet().getMetaData();
                } else if (!mdSerializer.mdFileNameExists(filename)) {
                    this.metaData = this.getCachedRowSet().getMetaData();
                    mdSerializer.serialize(this.metaData, filename);
                    this.metaDataFilename = filename;
                } else {
                    if (this.refreshMetaDataFile) {
                        File metaDataFile;
                        if (this.metaDataFilename != null && (metaDataFile = new File(this.metaDataFilename)).exists()) {
                            metaDataFile.delete();
                        }
                        this.metaDataFilename = filename;
                        this.metaData = this.getCachedRowSet().getMetaData();
                        mdSerializer.serialize(this.metaData, filename);
                        this.refreshMetaDataFile = false;
                    } else {
                        this.metaData = new MetaDataDeserializer().deserialize(filename);
                    }
                    new InitialContext().lookup(this.cachedRowSet.getDataSourceName());
                }
            }
            catch (SQLException e) {
                throw new RuntimeException(e);
            }
            catch (NamingException ne) {
                throw new RuntimeException(ne);
            }
        }
        return this.metaData;
    }

    private static URLClassLoader getDriverClassLoader(ClassLoader parent) {
        File libDir = new File(System.getProperty("netbeans.user"), "jdbc-drivers");
        File[] files = libDir.listFiles(new FileFilter(){

            public boolean accept(File f) {
                return f.isDirectory() || f.getName().toLowerCase().endsWith("jar") || f.getName().toLowerCase().endsWith("zip");
            }
        });
        int len = files == null ? 0 : files.length;
        URL[] urls = new URL[len];
        for (int i = 0; i < len; ++i) {
            try {
                urls[i] = files[i].toURL();
                continue;
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        return URLClassLoader.newInstance(urls, parent);
    }

    private static Object getFakeData(int columnType) throws SQLException {
        switch (columnType) {
            case 2003: {
                return new Array(){

                    public Object getArray() {
                        return null;
                    }

                    public Object getArray(long index, int count) {
                        return null;
                    }

                    public Object getArray(long index, int count, Map map) {
                        return null;
                    }

                    public Object getArray(Map map) {
                        return null;
                    }

                    public int getBaseType() {
                        return 1;
                    }

                    public String getBaseTypeName() {
                        return "CHAR";
                    }

                    public ResultSet getResultSet() {
                        return null;
                    }

                    public ResultSet getResultSet(long index, int count) {
                        return null;
                    }

                    public ResultSet getResultSet(long index, int count, Map map) {
                        return null;
                    }

                    public ResultSet getResultSet(Map map) {
                        return null;
                    }

                    public void free() {
                    }
                };
            }
            case -5: {
                return new Long(123L);
            }
            case -2: {
                return new byte[]{1, 2, 3, 4, 5};
            }
            case -7: {
                return new Boolean(true);
            }
            case 2004: {
                return new SerialBlob(new byte[]{1, 2, 3, 4, 5});
            }
            case 16: {
                return new Boolean(true);
            }
            case 1: {
                return bundle.getString("arbitraryCharData");
            }
            case 2005: {
                return new SerialClob(bundle.getString("arbitraryClobData").toCharArray());
            }
            case 70: {
                try {
                    return new URL("http://www.sun.com");
                }
                catch (MalformedURLException e) {
                    return null;
                }
            }
            case 91: {
                return new Date(new java.util.Date().getTime());
            }
            case 3: {
                return new BigDecimal(BigInteger.ONE);
            }
            case 2001: {
                return null;
            }
            case 8: {
                return new Double(123.0);
            }
            case 6: {
                return new Double(123.0);
            }
            case 4: {
                return new Integer(123);
            }
            case 2000: {
                return bundle.getString("arbitraryCharData");
            }
            case -4: {
                return new byte[]{1, 2, 3, 4, 5};
            }
            case -1: {
                return bundle.getString("arbitraryCharData");
            }
            case 0: {
                return null;
            }
            case 2: {
                return new BigDecimal(BigInteger.ONE);
            }
            case 1111: {
                return null;
            }
            case 7: {
                return new Float(123.0f);
            }
            case 2006: {
                return new Ref(){
                    private Object data = CachedRowSetDataProvider.access$700().getString("arbitraryCharData");

                    public String getBaseTypeName() {
                        return "CHAR";
                    }

                    public Object getObject() {
                        return this.data;
                    }

                    public Object getObject(Map map) {
                        return this.data;
                    }

                    public void setObject(Object value) {
                        this.data = value;
                    }
                };
            }
            case 5: {
                return new Short(123);
            }
            case 2002: {
                return new Struct(){
                    private String[] data = new String[]{CachedRowSetDataProvider.access$700().getString("arbitraryCharData"), CachedRowSetDataProvider.access$700().getString("arbitraryCharData2"), CachedRowSetDataProvider.access$700().getString("arbitraryCharData3")};

                    public Object[] getAttributes() {
                        return this.data;
                    }

                    public Object[] getAttributes(Map map) {
                        return this.data;
                    }

                    public String getSQLTypeName() {
                        return "CHAR";
                    }
                };
            }
            case 92: {
                return new Time(new java.util.Date().getTime());
            }
            case 93: {
                return new Timestamp(new java.util.Date().getTime());
            }
            case -6: {
                return new Byte(123);
            }
            case -3: {
                return new byte[]{1, 2, 3, 4, 5};
            }
            case 12: {
                return bundle.getString("arbitraryCharData");
            }
        }
        return null;
    }

    static /* synthetic */ FieldKey[] access$302(CachedRowSetDataProvider x0, FieldKey[] x1) {
        x0.fieldKeys = x1;
        return x1;
    }

    static /* synthetic */ ResourceBundle access$700() {
        return bundle;
    }

    private class CachedRowSetListener
    implements RowSetListener,
    Serializable {
        private CachedRowSetListener() {
        }

        public void cursorMoved(RowSetEvent event) {
        }

        public void rowChanged(RowSetEvent event) {
            try {
                int row = ((RowSet)event.getSource()).getRow();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }

        public void rowSetChanged(RowSetEvent event) {
            CachedRowSetDataProvider.this.fireProviderChanged();
        }
    }

    private static class CachedRowSetRowKey
    extends RowKey
    implements Serializable {
        private int index;

        public static CachedRowSetRowKey create(String rowId) {
            try {
                return new CachedRowSetRowKey(Integer.parseInt(rowId));
            }
            catch (NumberFormatException nfx) {
                return null;
            }
        }

        CachedRowSetRowKey(int index) {
            super(String.valueOf(index));
            this.index = index;
        }

        int getIndex() {
            return this.index;
        }

        public boolean equals(Object o) {
            if (o instanceof CachedRowSetRowKey) {
                return ((CachedRowSetRowKey)o).getIndex() == this.getIndex();
            }
            return super.equals(o);
        }

        public String toString() {
            return "CachedRowSetRowKey[" + this.index + "]";
        }
    }

    private static class ColumnNotSet
    implements Serializable {
        private ColumnNotSet() {
        }

        public String toString() {
            return null;
        }
    }

    private class RowSetPropertyChangeListener
    implements PropertyChangeListener,
    Serializable {
        private RowSetPropertyChangeListener() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("command") || event.getPropertyName().equals("dataSourceName") || event.getPropertyName().equals("url") || event.getPropertyName().equals("username")) {
                try {
                    CachedRowSetDataProvider.this.setCursorIndex(0);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CachedRowSetDataProvider.this.metaData = null;
                CachedRowSetDataProvider.access$302(CachedRowSetDataProvider.this, null);
                CachedRowSetDataProvider.this.fieldKeysMap = null;
                CachedRowSetDataProvider.this.executed = false;
                CachedRowSetDataProvider.this.refreshMetaDataFile = true;
                CachedRowSetDataProvider.this.fireProviderChanged();
            }
        }
    }
}

