package com.example;

import org.apache.cxf.jaxrs.client.WebClient;
import org.apache.cxf.jaxrs.ext.multipart.Attachment;
import org.junit.Test;

import javax.activation.DataHandler;
import javax.ws.rs.core.Response;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

import static org.junit.Assert.assertEquals;

/**
 * @author mgunasek
 * @since 1.0 (1/10/11)
 */
public class TestAttachments {
    @Test
    public void testCxfWebClientMultiPart() throws Exception {
        WebClient client = WebClient.create("http://localhost:9999/jersey/attachJersey");
        client.type("multipart/mixed"); //.accept("multipart/mixed");
        List<Attachment> atts = new LinkedList<Attachment>();
        atts.add(new Attachment("root", "*/*", "Root msg"));

        URL testUrl = getClass().getResource("/test.txt");
        DataHandler dh = new DataHandler(testUrl);
        atts.add(new Attachment("file1", dh, null));

        Response response = client.post(atts);
        System.out.println("Response status = " + response.getStatus());

        assertEquals(200, response.getStatus());
    }
}
