package com.example;

import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.StdErrLog;
import org.eclipse.jetty.webapp.WebAppContext;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;

/**
 * @author mgunasek
 * @since 1.0 (1/10/11)
 */
public class SampleRestServer {

    public static final int HTTP_PORT = 9090;
    String baseDir = "/WEB-INF";
    String webxml = "web.xml";

    private Server server;

    public SampleRestServer() {
        server = new Server();
        addHandlers();
    }

    protected void addHandlers() {

        //add a Web Context that uses the web.xml under test/resources/WEB-INF
        WebAppContext webAppContext = new WebAppContext();

        URL baseDirUrl = this.getClass().getResource(baseDir);
        try {
            File webInfDir = new File(baseDirUrl.toURI());
            File webXmlFile = new File(webInfDir, webxml);
            System.out.println("using web.xml from path: " + webXmlFile.getAbsolutePath());

            webAppContext.setDescriptor(webXmlFile.getAbsolutePath());
            webAppContext.setResourceBase(webInfDir.getAbsolutePath());

            server.setHandler(webAppContext);
            server.setConnectors(getConnectors());

        } catch (URISyntaxException e) {
            e.printStackTrace();
        }

    }

    private Connector[] getConnectors() {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(HTTP_PORT);
        connector.setMaxIdleTime(30000);
        connector.setRequestHeaderSize(8192);

        return new Connector[]{connector};
    }

    public void start() {
        try {
            if (!server.isStarted()) {
                System.out.println("Starting Jetty Server...");
                server.start();
            } else {
                System.out.println("Jetty already running!");
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            System.out.println("Stopping Jetty Server");
            if (server.isRunning()) {
                server.stop();
            } else {
                System.out.println("Jetty already stopped!");
            }

        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        Log.setLog(new StdErrLog());
//        System.setProperty("java.util.logging.config.file", SampleRestServer.class.getResource("/logging.properties").getPath());
        new SampleRestServer().start();
    }
}
