package com.example;

import com.sun.jersey.multipart.BodyPart;
import com.sun.jersey.multipart.MultiPart;

import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.ws.rs.*;
import javax.ws.rs.core.Response;
import java.util.List;

/**
 * @author mgunasek
 * @since 1.0 (1/5/11)
 */
@WebServlet(name = "HelloServlet")
@Path("/")
public class HelloServlet extends HttpServlet {

    @GET
    @Produces("text/plain")
    public String doGet() {
        return "Hello";
    }

    @POST
    @Consumes("multipart/mixed")
    @Path("/attachJersey")
    public Response addAttachmentsUsingJersey(MultiPart multiPart) {
        List<BodyPart> bodyParts = multiPart.getBodyParts();
        for (BodyPart bodyPart : bodyParts) {

            Object entity = bodyPart.getEntity();
            System.out.println("Got part with entity: " + entity);
        }
        return Response.ok("Processed attachments using Jersey").build();
    }

}
