/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal.model;

import jdk.jpackage.internal.util.CompositeProxy;

public interface MacPkgPackage extends MacPackage, MacPkgPackageMixin {

    /**
     * Returns {@code true} if this PKG installer should be signed.
     *
     * @return {@code true} if this PKG installer should be signed
     */
    default boolean sign() {
        return signingConfig().isPresent();
    }

    public static MacPkgPackage create(MacPackage pkg, MacPkgPackageMixin mixin) {
        return CompositeProxy.create(MacPkgPackage.class, pkg, mixin);
    }
}
