/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package jdk.jpackage.internal;

import static jdk.jpackage.internal.StandardBundlerParam.OUTPUT_DIR;
import static jdk.jpackage.internal.StandardBundlerParam.SIGN_BUNDLE;

import java.util.Map;
import java.util.Optional;
import jdk.jpackage.internal.model.ConfigException;
import jdk.jpackage.internal.util.function.ExceptionBox;

public class MacAppBundler extends AppImageBundler {
     public MacAppBundler() {
         setAppImageSupplier((params, output) -> {

             // Order is important!
             final var app = MacFromParams.APPLICATION.fetchFrom(params);
             final BuildEnv env;

             if (StandardBundlerParam.hasPredefinedAppImage(params)) {
                 env = BuildEnvFromParams.BUILD_ENV.fetchFrom(params);
                 final var pkg = MacPackagingPipeline.createSignAppImagePackage(app, env);
                 MacPackagingPipeline.build(Optional.of(pkg)).create().execute(env, pkg, output);
             } else {
                 env = BuildEnv.withAppImageDir(BuildEnvFromParams.BUILD_ENV.fetchFrom(params), output);
                 MacPackagingPipeline.build(Optional.empty())
                         .excludeDirFromCopying(output.getParent())
                         .excludeDirFromCopying(OUTPUT_DIR.fetchFrom(params)).create().execute(env, app);
             }

         });
         setParamsValidator(MacAppBundler::doValidate);
    }

    private static void doValidate(Map<String, ? super Object> params)
            throws ConfigException {

        try {
            MacFromParams.APPLICATION.fetchFrom(params);
        } catch (ExceptionBox ex) {
            if (ex.getCause() instanceof ConfigException cfgEx) {
                throw cfgEx;
            } else {
                throw ex;
            }
        }

        if (StandardBundlerParam.getPredefinedAppImage(params) != null) {
            if (!Optional.ofNullable(
                    SIGN_BUNDLE.fetchFrom(params)).orElse(Boolean.FALSE)) {
                throw new ConfigException(
                        I18N.getString("error.app-image.mac-sign.required"),
                        null);
            }
        }
    }
}
