/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal.model;

import java.nio.file.Path;
import java.util.Optional;

public interface MacApplicationMixin {

    Optional<Path> icon();

    String bundleName();

    String bundleIdentifier();

    String category();

    boolean appStore();

    Optional<AppImageSigningConfig> signingConfig();

    record Stub(Optional<Path> icon, String bundleName, String bundleIdentifier, String category,
            boolean appStore, Optional<AppImageSigningConfig> signingConfig) implements MacApplicationMixin {
    }
}
