/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal;

import java.util.Objects;
import java.util.Optional;
import jdk.jpackage.internal.model.ConfigException;
import jdk.jpackage.internal.model.MacPkgPackage;
import jdk.jpackage.internal.model.MacPkgPackageMixin;
import jdk.jpackage.internal.model.PkgSigningConfig;

final class MacPkgPackageBuilder {

    MacPkgPackageBuilder(MacPackageBuilder pkgBuilder) {
        this.pkgBuilder = Objects.requireNonNull(pkgBuilder);
    }

    MacPkgPackageBuilder signingBuilder(SigningIdentityBuilder v) {
        signingBuilder = v;
        return this;
    }

    MacPkgPackage create() throws ConfigException {
        return MacPkgPackage.create(pkgBuilder.create(), new MacPkgPackageMixin.Stub(createSigningConfig()));
    }

    private Optional<PkgSigningConfig> createSigningConfig() throws ConfigException {
        if (signingBuilder != null) {
            return signingBuilder.create().map(cfg -> {
                return new PkgSigningConfig.Stub(cfg.identity(), cfg.keychain().map(Keychain::name));
            });
        } else {
            return Optional.empty();
        }
    }

    private final MacPackageBuilder pkgBuilder;
    private SigningIdentityBuilder signingBuilder;
}
