/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal;

import java.util.Objects;
import jdk.jpackage.internal.model.ConfigException;
import jdk.jpackage.internal.model.MacPackage;
import jdk.jpackage.internal.model.MacPackageMixin;

final class MacPackageBuilder {

    MacPackageBuilder(PackageBuilder pkgBuilder) {
        this.pkgBuilder = Objects.requireNonNull(pkgBuilder);
    }

    MacPackageBuilder predefinedAppImageSigned(boolean  v) {
        predefinedAppImageSigned = v;
        return this;
    }

    PackageBuilder pkgBuilder() {
        return pkgBuilder;
    }

    MacPackage create() throws ConfigException {
        final var pkg = pkgBuilder.create();
        return MacPackage.create(pkg, new MacPackageMixin.Stub(pkg.predefinedAppImage().map(v -> predefinedAppImageSigned)));
    }

    private final PackageBuilder pkgBuilder;
    private boolean predefinedAppImageSigned;
}
