/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal;

import static jdk.jpackage.internal.util.PathUtils.resolveNullablePath;

import java.nio.file.Path;
import jdk.jpackage.internal.model.ApplicationLayout;
import jdk.jpackage.internal.util.CompositeProxy;

interface MacApplicationLayout extends ApplicationLayout, MacApplicationLayoutMixin {

    static MacApplicationLayout create(ApplicationLayout layout, Path runtimeRootDir) {
        return CompositeProxy.build()
                .invokeTunnel(CompositeProxyTunnel.INSTANCE)
                .create(MacApplicationLayout.class, layout, new MacApplicationLayoutMixin.Stub(runtimeRootDir));
    }

    @Override
    default MacApplicationLayout resolveAt(Path root) {
        return create(ApplicationLayout.super.resolveAt(root),
                resolveNullablePath(root, runtimeRootDirectory()));
    }
}
