/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal;

import static jdk.jpackage.internal.AppImageFile.getBooleanExtraFieldValue;

import jdk.jpackage.internal.model.ExternalApplication;
import jdk.jpackage.internal.model.MacApplication.ExtraAppImageFileField;

record MacAppImageFileExtras(boolean signed, boolean appStore) {

    MacAppImageFileExtras(ExternalApplication app) {
        this(getBooleanExtraFieldValue(ExtraAppImageFileField.SIGNED.fieldName(), app),
                getBooleanExtraFieldValue(ExtraAppImageFileField.APP_STORE.fieldName(), app));
    }
}
