/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package sun.awt.screencast;

import sun.awt.SunToolkit;
import sun.awt.UNIXToolkit;

import java.awt.Toolkit;

public class XdgDesktopPortal {
    private static final String METHOD_X11 = "x11";
    private static final String METHOD_SCREENCAST = "dbusScreencast";
    private static final String METHOD_REMOTE_DESKTOP = "dbusRemoteDesktop";

    private static final String method;
    private static final boolean isRemoteDesktop;
    private static final boolean isScreencast;

    private XdgDesktopPortal() {}

    static {
        boolean isOnWayland = false;

        if (Toolkit.getDefaultToolkit() instanceof SunToolkit sunToolkit) {
            isOnWayland = sunToolkit.isRunningOnWayland();
        }

        String defaultMethod = METHOD_X11;
        if (isOnWayland) {
            Integer gnomeShellVersion = null;

            UNIXToolkit toolkit = (UNIXToolkit) Toolkit.getDefaultToolkit();
            if ("gnome".equals(toolkit.getDesktop())) {
                gnomeShellVersion = toolkit.getGnomeShellMajorVersion();
            }

            defaultMethod = (gnomeShellVersion != null && gnomeShellVersion >= 47)
                    ? METHOD_REMOTE_DESKTOP
                    : METHOD_SCREENCAST;
        }

        String m = System.getProperty("awt.robot.screenshotMethod", defaultMethod);

        if (!METHOD_REMOTE_DESKTOP.equals(m)
                && !METHOD_SCREENCAST.equals(m)
                && !METHOD_X11.equals(m)) {
            m = defaultMethod;
        }

        isRemoteDesktop = METHOD_REMOTE_DESKTOP.equals(m);
        isScreencast = METHOD_SCREENCAST.equals(m);
        method = m;

    }

    public static String getMethod() {
        return method;
    }

    public static boolean isRemoteDesktop() {
        return isRemoteDesktop;
    }

    public static boolean isScreencast() {
        return isScreencast;
    }
}
