/*
 * Copyright (c) 1999, 2021, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package sun.font;

import java.nio.charset.*;
import sun.nio.cs.*;
import static sun.nio.cs.CharsetMapping.*;

public final class X11GBK extends Charset {
    public X11GBK () {
        super("X11GBK", null);
    }
    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }
    @Override
    public CharsetDecoder newDecoder() {
        return new GBK().newDecoder();
    }

    @Override
    public boolean contains(Charset cs) {
        return cs instanceof X11GBK;
    }

    private static final class Encoder extends DoubleByte.Encoder {

        private DoubleByte.Encoder enc = (DoubleByte.Encoder)new GBK().newEncoder();

        Encoder(Charset cs) {
            super(cs, (char[])null, (char[])null);
        }

        @Override
        public boolean canEncode(char ch){
            if (ch < 0x80) return false;
            return enc.canEncode(ch);
        }

        @Override
        public int encodeChar(char ch) {
            if (ch < 0x80)
                return UNMAPPABLE_ENCODING;
            return enc.encodeChar(ch);
        }
    }
}
