/*
 * Copyright (c) 2014, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package jdk.jpackage.internal;

import static jdk.jpackage.internal.StandardBundlerParam.PREDEFINED_APP_IMAGE;
import static jdk.jpackage.internal.StandardBundlerParam.PREDEFINED_APP_IMAGE_FILE;
import static jdk.jpackage.internal.StandardBundlerParam.SIGN_BUNDLE;

import java.nio.file.Files;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Optional;
import jdk.jpackage.internal.model.ConfigException;

public abstract class MacBaseInstallerBundler extends AbstractBundler {

    public MacBaseInstallerBundler() {
        appImageBundler = new MacAppBundler();
    }

    protected void validateAppImageAndBundeler(
            Map<String, ? super Object> params) throws ConfigException {
        if (PREDEFINED_APP_IMAGE.fetchFrom(params) != null) {
            Path applicationImage = PREDEFINED_APP_IMAGE.fetchFrom(params);
            if (new MacAppImageFileExtras(PREDEFINED_APP_IMAGE_FILE.fetchFrom(params)).signed()) {
                var appLayout = ApplicationLayoutUtils.PLATFORM_APPLICATION_LAYOUT.resolveAt(applicationImage);
                if (!Files.exists(
                        PackageFile.getPathInAppImage(appLayout))) {
                    Log.info(MessageFormat.format(I18N.getString(
                            "warning.per.user.app.image.signed"),
                            PackageFile.getPathInAppImage(appLayout)));
                }
            } else {
                if (Optional.ofNullable(
                        SIGN_BUNDLE.fetchFrom(params)).orElse(Boolean.FALSE)) {
                    // if signing bundle with app-image, warn user if app-image
                    // is not already signed.
                    Log.info(MessageFormat.format(I18N.getString(
                            "warning.unsigned.app.image"), getID()));
                }
            }
        } else {
            appImageBundler.validate(params);
        }
    }

    @Override
    public String getBundleType() {
        return "INSTALLER";
    }

    private final Bundler appImageBundler;
}
