/*
 * Copyright (c) 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal;

import static jdk.jpackage.internal.util.PathUtils.resolveNullablePath;

import java.nio.file.Path;
import jdk.jpackage.internal.model.ApplicationLayout;
import jdk.jpackage.internal.util.CompositeProxy;

interface LinuxApplicationLayout extends ApplicationLayout, LinuxApplicationLayoutMixin {

    static LinuxApplicationLayout create(ApplicationLayout layout, Path libAppLauncher) {
        return CompositeProxy.build()
                .invokeTunnel(CompositeProxyTunnel.INSTANCE)
                .create(LinuxApplicationLayout.class, layout, new LinuxApplicationLayoutMixin.Stub(libAppLauncher));
    }

    @Override
    default LinuxApplicationLayout resolveAt(Path root) {
        return create(ApplicationLayout.super.resolveAt(root),
                resolveNullablePath(root, libAppLauncher()));
    }
}
