/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_pt extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Hor\u00e1rio do Meridiano de Greenwich",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Acre",
               "ACT",
               "Hor\u00e1rio de Ver\u00e3o do Acre",
               "ACST",
               "Hor\u00e1rio do Acre",
               "ACT",
            };
        final String[] Apia = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Apia",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Apia",
               "",
               "Hor\u00e1rio de Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Ilhas Cook",
               "",
               "Meio Hor\u00e1rio de Ver\u00e3o das Ilhas Cook",
               "",
               "Hor\u00e1rio das Ilhas Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Cuba",
               "CST",
               "Hor\u00e1rio de Ver\u00e3o de Cuba",
               "CDT",
               "Hor\u00e1rio de Cuba",
               "CT",
            };
        final String[] Fiji = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Fiji",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Fiji",
               "",
               "Hor\u00e1rio de Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Hor\u00e1rio do Golfo",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Hovd",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Hovd",
               "",
               "Hor\u00e1rio de Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Ir\u00e3",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Ir\u00e3",
               "",
               "Hor\u00e1rio do Ir\u00e3",
               "",
            };
        final String[] Niue = new String[] {
               "Hor\u00e1rio de Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Omsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Omsk",
               "",
               "Hor\u00e1rio de Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Peru",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Peru",
               "",
               "Hor\u00e1rio do Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Hor\u00e1rio de Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Hor\u00e1rio das Ilhas Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Chile",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Chile",
               "",
               "Hor\u00e1rio do Chile",
               "",
            };
        final String[] China = new String[] {
               "Hor\u00e1rio Padr\u00e3o da China",
               "CST",
               "Hor\u00e1rio de Ver\u00e3o da China",
               "CDT",
               "Hor\u00e1rio da China",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Hor\u00e1rio das Ilhas Coco",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Hor\u00e1rio de Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Hor\u00e1rio Padr\u00e3o da \u00cdndia",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Jap\u00e3o",
               "JST",
               "Hor\u00e1rio de Ver\u00e3o do Jap\u00e3o",
               "JDT",
               "Hor\u00e1rio do Jap\u00e3o",
               "JT",
            };
        final String[] Korea = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Coreia",
               "KST",
               "Hor\u00e1rio de Ver\u00e3o da Coreia",
               "KST",
               "Hor\u00e1rio da Coreia",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Hor\u00e1rio de Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Hor\u00e1rio do Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Hor\u00e1rio de Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Samoa",
               "SST",
               "Hor\u00e1rio de Ver\u00e3o de Samoa",
               "SST",
               "Hor\u00e1rio de Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Hor\u00e1rio de Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Tonga",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Tonga",
               "",
               "Hor\u00e1rio de Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Hor\u00e1rio do Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Alasca",
               "AKST",
               "Hor\u00e1rio de Ver\u00e3o do Alasca",
               "AKDT",
               "Hor\u00e1rio do Alasca",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Amazonas",
               "AMT",
               "Hor\u00e1rio de Ver\u00e3o do Amazonas",
               "AMST",
               "Hor\u00e1rio do Amazonas",
               "AMT",
            };
        final String[] Anadyr = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Anadyr",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Anadyr",
               "",
               "Hor\u00e1rio de Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Hor\u00e1rio Padr\u00e3o dos A\u00e7ores",
               "",
               "Hor\u00e1rio de Ver\u00e3o dos A\u00e7ores",
               "",
               "Hor\u00e1rio dos A\u00e7ores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Hor\u00e1rio do But\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Hor\u00e1rio de Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ilha de P\u00e1scoa",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Ilha de P\u00e1scoa",
               "",
               "Hor\u00e1rio da Ilha de P\u00e1scoa",
               "",
            };
        final String[] Guyana = new String[] {
               "Hor\u00e1rio da Guiana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Israel",
               "IST",
               "Hor\u00e1rio de Ver\u00e3o de Israel",
               "IDT",
               "Hor\u00e1rio de Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Hor\u00e1rio de Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Hor\u00e1rio de Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Moscou",
               "MSK",
               "Hor\u00e1rio de Ver\u00e3o de Moscou",
               "MSK",
               "Hor\u00e1rio de Moscou",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Hor\u00e1rio de Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Samara",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Samara",
               "",
               "Hor\u00e1rio de Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Hor\u00e1rio do Taiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Taipei",
               "CST",
               "Hor\u00e1rio de Ver\u00e3o de Taipei",
               "CDT",
               "Hor\u00e1rio de Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Hor\u00e1rio de Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Hor\u00e1rio de Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Hor\u00e1rio de Wallis e Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ar\u00e1bia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Ar\u00e1bia",
               "",
               "Hor\u00e1rio da Ar\u00e1bia",
               "",
            };
        final String[] Armenia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Arm\u00eania",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Arm\u00eania",
               "",
               "Hor\u00e1rio da Arm\u00eania",
               "",
            };
        final String[] Bolivia = new String[] {
               "Hor\u00e1rio da Bol\u00edvia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Chatham",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Chatham",
               "",
               "Hor\u00e1rio de Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Hor\u00e1rio Universal Coordenado",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Hor\u00e1rio do Equador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Hor\u00e1rio de Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ge\u00f3rgia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Ge\u00f3rgia",
               "",
               "Hor\u00e1rio da Ge\u00f3rgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Irkutsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Irkutsk",
               "",
               "Hor\u00e1rio de Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Magadan",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Magadan",
               "",
               "Hor\u00e1rio de Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Hor\u00e1rio de Mianmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Ilha Norfolk",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Ilha Norfolk",
               "",
               "Hor\u00e1rio da Ilha Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Fernando de Noronha",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Fernando de Noronha",
               "",
               "Hor\u00e1rio de Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Hor\u00e1rio de Reuni\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Hor\u00e1rio de Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Hor\u00e1rio das Ilhas Salom\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Hor\u00e1rio de Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Uruguai",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Uruguai",
               "",
               "Hor\u00e1rio do Uruguai",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Vanuatu",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Vanuatu",
               "",
               "Hor\u00e1rio de Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Yakutsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Yakutsk",
               "",
               "Hor\u00e1rio de Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Atl\u00e2ntico",
               "AST",
               "Hor\u00e1rio de Ver\u00e3o do Atl\u00e2ntico",
               "AST",
               "Hor\u00e1rio do Atl\u00e2ntico",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Bras\u00edlia",
               "BRT",
               "Hor\u00e1rio de Ver\u00e3o de Bras\u00edlia",
               "BRST",
               "Hor\u00e1rio de Bras\u00edlia",
               "BRT",
            };
        final String[] Chamorro = new String[] {
               "Hor\u00e1rio de Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Col\u00f4mbia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Col\u00f4mbia",
               "",
               "Hor\u00e1rio da Col\u00f4mbia",
               "",
            };
        final String[] Falkland = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Ilhas Malvinas",
               "",
               "Hor\u00e1rio de Ver\u00e3o das Ilhas Malvinas",
               "",
               "Hor\u00e1rio das Ilhas Malvinas",
               "",
            };
        final String[] Malaysia = new String[] {
               "Hor\u00e1rio da Mal\u00e1sia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Hor\u00e1rio das Ilhas Maldivas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Ulan Bator",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Ulan Bator",
               "",
               "Hor\u00e1rio de Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Paquist\u00e3o",
               "PKT",
               "Hor\u00e1rio de Ver\u00e3o do Paquist\u00e3o",
               "PKST",
               "Hor\u00e1rio do Paquist\u00e3o",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Paraguai",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Paraguai",
               "",
               "Hor\u00e1rio do Paraguai",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Hor\u00e1rio de Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Sacalina",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Sacalina",
               "",
               "Hor\u00e1rio de Sacalina",
               "",
            };
        final String[] Suriname = new String[] {
               "Hor\u00e1rio do Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Argentina",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Argentina",
               "",
               "Hor\u00e1rio da Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Hor\u00e1rio da Ilha Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Hor\u00e1rio de Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Hong Kong",
               "HKT",
               "Hor\u00e1rio de Ver\u00e3o de Hong Kong",
               "HKST",
               "Hor\u00e1rio de Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Hor\u00e1rio da Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Petropavlovsk-Kamchatski",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Petropavlovsk-Kamchatski",
               "",
               "Hor\u00e1rio de Petropavlovsk-Kamchatski",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Hor\u00e1rio do Quirguist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Lord Howe",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Lord Howe",
               "",
               "Hor\u00e1rio de Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Hor\u00e1rio das Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Maur\u00edcio",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Maur\u00edcio",
               "",
               "Hor\u00e1rio de Maur\u00edcio",
               "",
            };
        final String[] Singapore = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Singapura",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Hor\u00e1rio da Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Volgogrado",
               "MSK",
               "Hor\u00e1rio de Ver\u00e3o de Volgogrado",
               "MSK",
               "Hor\u00e1rio de Volgogrado",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Arzeibaij\u00e3o",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Arzeibaij\u00e3o",
               "",
               "Hor\u00e1rio do Arzeibaij\u00e3o",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Bangladesh",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Bangladesh",
               "",
               "Hor\u00e1rio de Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Cabo Verde",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Cabo Verde",
               "",
               "Hor\u00e1rio de Cabo Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Hor\u00e1rio do Timor-Leste",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "Hor\u00e1rio do Cazaquist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Hor\u00e1rio de Seicheles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Hor\u00e1rio do Tajiquist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Uzbequist\u00e3o",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Uzbequist\u00e3o",
               "",
               "Hor\u00e1rio do Uzbequist\u00e3o",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Hor\u00e1rio do Afeganist\u00e3o",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Krasnoyarsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Krasnoyarsk",
               "",
               "Hor\u00e1rio de Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Nova Zel\u00e2ndia",
               "NZST",
               "Hor\u00e1rio de Ver\u00e3o da Nova Zel\u00e2ndia",
               "NZDT",
               "Hor\u00e1rio da Nova Zel\u00e2ndia",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Novosibirsk",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Novosibirsk",
               "",
               "Hor\u00e1rio de Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Filipinas",
               "PST",
               "Hor\u00e1rio de Ver\u00e3o das Filipinas",
               "PDT",
               "Hor\u00e1rio das Filipinas",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Vladivostok",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Vladivostok",
               "",
               "Hor\u00e1rio de Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Hor\u00e1rio do Oceano \u00cdndico",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Hor\u00e1rio das Ilhas da Linha",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Terra Nova",
               "NST",
               "Hor\u00e1rio de Ver\u00e3o da Terra Nova",
               "NDT",
               "Hor\u00e1rio da Terra Nova",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Turcomenist\u00e3o",
               "",
               "Hor\u00e1rio de Ver\u00e3o do Turcomenist\u00e3o",
               "",
               "Hor\u00e1rio do Turcomenist\u00e3o",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Hor\u00e1rio da Guiana Francesa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Nova Caled\u00f4nia",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Nova Caled\u00f4nia",
               "",
               "Hor\u00e1rio da Nova Caled\u00f4nia",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Hor\u00e1rio da Ge\u00f3rgia do Sul",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Hor\u00e1rio Padr\u00e3o de Ecaterimburgo",
               "",
               "Hor\u00e1rio de Ver\u00e3o de Ecaterimburgo",
               "",
               "Hor\u00e1rio de Ecaterimburgo",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Hor\u00e1rio da \u00c1frica Central",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Hor\u00e1rio da \u00c1frica Oriental",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da \u00c1frica Ocidental",
               "WAT",
               "Hor\u00e1rio de Ver\u00e3o da \u00c1frica Ocidental",
               "WAT",
               "Hor\u00e1rio da \u00c1frica Ocidental",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Hor\u00e1rio de Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Europa Central",
               "CET",
               "Hor\u00e1rio de Ver\u00e3o da Europa Central",
               "CEST",
               "Hor\u00e1rio da Europa Central",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Europa Oriental",
               "EET",
               "Hor\u00e1rio de Ver\u00e3o da Europa Oriental",
               "EEST",
               "Hor\u00e1rio da Europa Oriental",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Europa Ocidental",
               "WET",
               "Hor\u00e1rio de Ver\u00e3o da Europa Ocidental",
               "WEST",
               "Hor\u00e1rio da Europa Ocidental",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Pac\u00edfico Mexicano",
               "MST",
               "Hor\u00e1rio de Ver\u00e3o do Pac\u00edfico Mexicano",
               "MDT",
               "Hor\u00e1rio do Pac\u00edfico Mexicano",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Hor\u00e1rio da \u00c1frica do Sul",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Hor\u00e1rio Padr\u00e3o Central",
               "CST",
               "Hor\u00e1rio de Ver\u00e3o Central",
               "CDT",
               "Hor\u00e1rio Central",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Leste",
               "EST",
               "Hor\u00e1rio de Ver\u00e3o do Leste",
               "EST",
               "Hor\u00e1rio do Leste",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Pac\u00edfico",
               "PST",
               "Hor\u00e1rio de Ver\u00e3o do Pac\u00edfico",
               "PDT",
               "Hor\u00e1rio do Pac\u00edfico",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Hor\u00e1rio dos Territ\u00f3rios Franceses do Sul e Ant\u00e1rtida",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Hor\u00e1rio das Ilhas Gilberto",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Hor\u00e1rio Padr\u00e3o do Hava\u00ed e Ilhas Aleutas",
               "HST",
               "Hor\u00e1rio de Ver\u00e3o do Hava\u00ed e Ilhas Aleutas",
               "HST",
               "Hor\u00e1rio do Hava\u00ed e Ilhas Aleutas",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "Hor\u00e1rio das Ilhas F\u00eanix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Hor\u00e1rio Padr\u00e3o de S\u00e3o Pedro e Miquel\u00e3o",
               "",
               "Hor\u00e1rio Ver\u00e3o de S\u00e3o Pedro e Miquel\u00e3o",
               "",
               "Hor\u00e1rio de S\u00e3o Pedro e Miquel\u00e3o",
               "",
            };
        final String[] America_Mountain = new String[] {
               "Hor\u00e1rio Padr\u00e3o das Montanhas",
               "MST",
               "Hor\u00e1rio de Ver\u00e3o das Montanhas",
               "MST",
               "Hor\u00e1rio das Montanhas",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "Hor\u00e1rio das Ilhas Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Hor\u00e1rio de Papua-Nova Guin\u00e9",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Central",
               "ACST",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Central",
               "ACDT",
               "Hor\u00e1rio da Austr\u00e1lia Central",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Oriental",
               "AEST",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Oriental",
               "AEDT",
               "Hor\u00e1rio da Austr\u00e1lia Oriental",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Ocidental",
               "AWST",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Ocidental",
               "AWDT",
               "Hor\u00e1rio da Austr\u00e1lia Ocidental",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Hor\u00e1rio da Indon\u00e9sia Central",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Hor\u00e1rio da Indon\u00e9sia Oriental",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Hor\u00e1rio da Indon\u00e9sia Ocidental",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Hor\u00e1rio Padr\u00e3o da Austr\u00e1lia Centro-Ocidental",
               "",
               "Hor\u00e1rio de Ver\u00e3o da Austr\u00e1lia Centro-Ocidental",
               "",
               "Hor\u00e1rio da Austr\u00e1lia Centro-Ocidental",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "GMT",
                    "Hor\u00e1rio de Ver\u00e3o Brit\u00e2nico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Hor\u00e1rio Universal Coordenado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "GMT",
                    "Hor\u00e1rio Padr\u00e3o Irland\u00eas",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Hor\u00e1rio Universal Coordenado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Hor\u00e1rio Universal Coordenado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "GMT",
                    "Hor\u00e1rio de Ver\u00e3o Brit\u00e2nico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Hor\u00e1rio Universal Coordenado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Hor\u00e1rio Universal Coordenado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Hor\u00e1rio Universal Coordenado",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "GMT",
                    "Hor\u00e1rio Padr\u00e3o Irland\u00eas",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "GMT",
                    "Hor\u00e1rio de Ver\u00e3o Brit\u00e2nico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "GMT",
                    "Hor\u00e1rio de Ver\u00e3o Brit\u00e2nico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "GMT",
                    "Hor\u00e1rio de Ver\u00e3o Brit\u00e2nico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "GMT",
                    "Hor\u00e1rio de Ver\u00e3o Brit\u00e2nico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Hor\u00e1rio do Meridiano de Greenwich",
                    "GMT",
                    "Hor\u00e1rio de Ver\u00e3o Brit\u00e2nico",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "\u00c1den" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "Am\u00e3" },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Dhaka", "Dacca" },
            { "timezone.excity.Asia/Kabul", "Cabul" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "timezone.excity.Asia/Qatar", "Catar" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "timezone.excity.Asia/Tokyo", "T\u00f3quio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Beirut", "Beirute" },
            { "timezone.excity.Asia/Muscat", "Mascate" },
            { "timezone.excity.Asia/Riyadh", "Riade" },
            { "timezone.excity.Asia/Saigon", "Cidade de Ho Chi Minh" },
            { "timezone.excity.Asia/Tehran", "Teer\u00e3" },
            { "timezone.excity.Etc/Unknown", "Cidade desconhecida" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "timezone.excity.Indian/Mahe", "Mah\u00e9" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "Acra" },
            { "timezone.excity.Africa/Tunis", "T\u00fanis" },
            { "timezone.excity.Asia/Baghdad", "Bagd\u00e1" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Jakarta", "Jacarta" },
            { "timezone.excity.Asia/Nicosia", "Nic\u00f3sia" },
            { "timezone.excity.Asia/Rangoon", "Rangum" },
            { "timezone.excity.Europe/Sofia", "S\u00f3fia" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "timezone.excity.Asia/Ashgabat", "Asgabate" },
            { "timezone.excity.Asia/Calcutta", "Calcut\u00e1" },
            { "timezone.excity.Asia/Damascus", "Damasco" },
            { "timezone.excity.Asia/Dushanbe", "Duchambe" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Sakhalin", "Sacalina" },
            { "timezone.excity.Asia/Shanghai", "Xangai" },
            { "timezone.excity.Europe/Athens", "Atenas" },
            { "timezone.excity.Europe/Berlin", "Berlim" },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Europe/London", "Londres" },
            { "timezone.excity.Europe/Madrid", "Madri" },
            { "timezone.excity.Europe/Monaco", "M\u00f4naco" },
            { "timezone.excity.Europe/Moscow", "Moscou" },
            { "timezone.excity.Europe/Prague", "Praga" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Viena" },
            { "timezone.excity.Europe/Warsaw", "Vars\u00f3via" },
            { "timezone.excity.Europe/Zurich", "Zurique" },
            { "timezone.excity.Indian/Comoro", "Comores" },
            { "timezone.excity.Pacific/Efate", "\u00c9fat\u00e9" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Argel" },
            { "timezone.excity.Africa/Conakry", "Conacri" },
            { "timezone.excity.Africa/Nairobi", "Nair\u00f3bi" },
            { "timezone.excity.Africa/Tripoli", "Tr\u00edpoli" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "timezone.excity.America/Cuiaba", "Cuiab\u00e1" },
            { "timezone.excity.America/Guyana", "Guiana" },
            { "timezone.excity.America/Maceio", "Macei\u00f3" },
            { "timezone.excity.America/Panama", "Panam\u00e1" },
            { "timezone.excity.Asia/Jerusalem", "Jerusal\u00e9m" },
            { "timezone.excity.Asia/Samarkand", "Samarcanda" },
            { "timezone.excity.Asia/Singapore", "Singapura" },
            { "timezone.excity.Europe/Vatican", "Vaticano" },
            { "timezone.excity.Indian/Reunion", "Reuni\u00e3o" },
            { "timezone.excity.Pacific/Easter", "Ilha de P\u00e1scoa" },
            { "timezone.excity.Pacific/Noumea", "Noum\u00e9a" },
            { "timezone.excity.Pacific/Tahiti", "Taiti" },
            { "timezone.excity.Pacific/Tarawa", "Taraua" },
            { "timezone.excity.Africa/Djibouti", "Djibuti" },
            { "timezone.excity.Africa/El_Aaiun", "El Aai\u00fan" },
            { "timezone.excity.Africa/Khartoum", "Cartum" },
            { "timezone.excity.Africa/Monrovia", "Monr\u00f3via" },
            { "timezone.excity.Africa/Ndjamena", "N\u2019Djamena" },
            { "timezone.excity.America/Antigua", "Ant\u00edgua" },
            { "timezone.excity.America/Cayenne", "Caiena" },
            { "timezone.excity.America/Cordoba", "C\u00f3rdoba" },
            { "timezone.excity.America/Grenada", "Granada" },
            { "timezone.excity.America/Managua", "Man\u00e1gua" },
            { "timezone.excity.Atlantic/Azores", "A\u00e7ores" },
            { "timezone.excity.Atlantic/Canary", "Can\u00e1rias" },
            { "timezone.excity.Atlantic/Faeroe", "Ilhas Faro\u00e9" },
            { "timezone.excity.Europe/Belgrade", "Belgrado" },
            { "timezone.excity.Europe/Brussels", "Bruxelas" },
            { "timezone.excity.Europe/Budapest", "Budapeste" },
            { "timezone.excity.Europe/Busingen", "B\u00fcsingen" },
            { "timezone.excity.Europe/Helsinki", "Helsinque" },
            { "timezone.excity.Europe/Istanbul", "Istambul" },
            { "timezone.excity.Indian/Maldives", "Maldivas" },
            { "timezone.excity.Pacific/Chatham", "Chatnam" },
            { "timezone.excity.Africa/Mogadishu", "Mogad\u00edscio" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/Asuncion", "Assun\u00e7\u00e3o" },
            { "timezone.excity.America/Eirunepe", "Eirunep\u00e9" },
            { "timezone.excity.America/New_York", "Nova York" },
            { "timezone.excity.America/Santarem", "Santar\u00e9m" },
            { "timezone.excity.America/St_Johns", "Saint John\u2019s" },
            { "timezone.excity.America/St_Kitts", "S\u00e3o Crist\u00f3v\u00e3o" },
            { "timezone.excity.America/St_Lucia", "Santa L\u00facia" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudas" },
            { "timezone.excity.Europe/Amsterdam", "Amsterd\u00e3" },
            { "timezone.excity.Europe/Astrakhan", "Astrac\u00e3" },
            { "timezone.excity.Europe/Bucharest", "Bucareste" },
            { "timezone.excity.Europe/Ljubljana", "Liubliana" },
            { "timezone.excity.Europe/Stockholm", "Estocolmo" },
            { "timezone.excity.Europe/Ulyanovsk", "Ulianovsk" },
            { "timezone.excity.Europe/Volgograd", "Volgogrado" },
            { "timezone.excity.Indian/Mauritius", "Maur\u00edcio" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Africa/Porto-Novo", "Porto Novo" },
            { "timezone.excity.America/Araguaina", "Aragua\u00edna" },
            { "timezone.excity.America/Guayaquil", "Guaiaquil" },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "timezone.excity.America/St_Thomas", "Saint Thomas" },
            { "timezone.excity.Europe/Copenhagen", "Copenhague" },
            { "timezone.excity.Europe/Luxembourg", "Luxemburgo" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.Africa/Addis_Ababa", "Adis Abeba" },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.America/Martinique", "Martinica" },
            { "timezone.excity.America/Montevideo", "Montevid\u00e9u" },
            { "timezone.excity.America/St_Vincent", "S\u00e3o Vicente" },
            { "timezone.excity.Asia/Yekaterinburg", "Ecaterimburgo" },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "timezone.excity.Atlantic/St_Helena", "Santa Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Ilha de Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrado" },
            { "timezone.excity.Africa/Johannesburg", "Joanesburgo" },
            { "timezone.excity.America/Mexico_City", "Cidade do M\u00e9xico" },
            { "timezone.excity.America/Puerto_Rico", "Porto Rico" },
            { "timezone.excity.Atlantic/Cape_Verde", "Cabo Verde" },
            { "timezone.excity.America/Indianapolis", "Indian\u00e1polis" },
            { "timezone.excity.America/St_Barthelemy", "S\u00e3o Bartolomeu" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia de Banderas" },
            { "timezone.excity.America/Port-au-Prince", "Porto Pr\u00edncipe" },
            { "timezone.excity.Atlantic/South_Georgia", "Ge\u00f3rgia do Sul" },
            { "timezone.excity.America/Argentina/Tucuman", "Tucum\u00e3" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota do Norte" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota do Norte" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salen, Dakota do Norte" },
        };
        return data;
    }
}
