/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package jdk.jpackage.internal;

public class LinuxAppBundler extends AppImageBundler {
    public LinuxAppBundler() {
        setAppImageSupplier((params, output) -> {
            // Order is important!
            var app = LinuxFromParams.APPLICATION.fetchFrom(params);
            var env = BuildEnvFromParams.BUILD_ENV.fetchFrom(params);
            LinuxPackagingPipeline.build()
                    .excludeDirFromCopying(output.getParent())
                    .create().execute(BuildEnv.withAppImageDir(env, output), app);
        });
    }
}
