/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_hr extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "univerzalno vrijeme",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Acre standardno vrijeme",
               "",
               "Acre ljetno vrijeme",
               "",
               "Acre vrijeme",
               "",
            };
        final String[] Apia = new String[] {
               "standardno vrijeme Apije",
               "",
               "ljetno vrijeme Apije",
               "",
               "vrijeme Apije",
               "",
            };
        final String[] Cook = new String[] {
               "standardno vrijeme Cookovih Otoka",
               "",
               "Cookovi Otoci, polusatni pomak, ljetno vrijeme",
               "",
               "vrijeme Cookovih Otoka",
               "",
            };
        final String[] Cuba = new String[] {
               "kubansko standardno vrijeme",
               "CST",
               "kubansko ljetno vrijeme",
               "CDT",
               "kubansko vrijeme",
               "CT",
            };
        final String[] Fiji = new String[] {
               "standardno vrijeme Fid\u017eija",
               "",
               "ljetno vrijeme Fid\u017eija",
               "",
               "vrijeme Fid\u017eija",
               "",
            };
        final String[] Gulf = new String[] {
               "zaljevsko standardno vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "hovdsko standardno vrijeme",
               "",
               "hovdsko ljetno vrijeme",
               "",
               "hovdsko vrijeme",
               "",
            };
        final String[] Iran = new String[] {
               "iransko standardno vrijeme",
               "",
               "iransko ljetno vrijeme",
               "",
               "iransko vrijeme",
               "",
            };
        final String[] Niue = new String[] {
               "vrijeme Niuea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "omsko standardno vrijeme",
               "",
               "omsko ljetno vrijeme",
               "",
               "omsko vrijeme",
               "",
            };
        final String[] Peru = new String[] {
               "peruansko standardno vrijeme",
               "",
               "peruansko ljetno vrijeme",
               "",
               "peruansko vrijeme",
               "",
            };
        final String[] Truk = new String[] {
               "vrijeme Chuuka",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "vrijeme Otoka Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "\u010dileansko standardno vrijeme",
               "",
               "\u010dileansko ljetno vrijeme",
               "",
               "\u010dileansko vrijeme",
               "",
            };
        final String[] China = new String[] {
               "kinesko standardno vrijeme",
               "CST",
               "kinesko ljetno vrijeme",
               "CDT",
               "kinesko vrijeme",
               "CT",
            };
        final String[] Cocos = new String[] {
               "vrijeme Kokosovih Otoka",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "vrijeme Davisa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "indijsko vrijeme",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "japansko standardno vrijeme",
               "JST",
               "japansko ljetno vrijeme",
               "JDT",
               "japansko vrijeme",
               "JT",
            };
        final String[] Korea = new String[] {
               "korejsko standardno vrijeme",
               "KST",
               "korejsko ljetno vrijeme",
               "KST",
               "korejsko vrijeme",
               "KST",
            };
        final String[] Nauru = new String[] {
               "vrijeme Naurua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "nepalsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "vrijeme Palaua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "samoansko standardno vrijeme",
               "SST",
               "samoansko ljetno vrijeme",
               "SST",
               "samoansko vrijeme",
               "SST",
            };
        final String[] Syowa = new String[] {
               "vrijeme Syowe",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "standardno vrijeme Tonge",
               "",
               "ljetno vrijeme Tonge",
               "",
               "vrijeme Tonge",
               "",
            };
        final String[] Yukon = new String[] {
               "jukon\u0161ko vrijeme",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "alja\u0161ko standardno vrijeme",
               "AKST",
               "alja\u0161ko ljetno vrijeme",
               "AKDT",
               "alja\u0161ko vrijeme",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "amazonsko standardno vrijeme",
               "",
               "amazonsko ljetno vrijeme",
               "",
               "amazonsko vrijeme",
               "",
            };
        final String[] Anadyr = new String[] {
               "anadirsko standardno vrijeme",
               "",
               "anadirsko ljetno vrijeme",
               "",
               "anadirsko vrijeme",
               "",
            };
        final String[] Azores = new String[] {
               "azorsko standardno vrijeme",
               "",
               "azorsko ljetno vrijeme",
               "",
               "azorsko vrijeme",
               "",
            };
        final String[] Bhutan = new String[] {
               "butansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "vrijeme za Brunej Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "standardno vrijeme Uskr\u0161njeg otoka",
               "",
               "ljetno vrijeme Uskr\u0161njeg otoka",
               "",
               "vrijeme Uskr\u0161njeg otoka",
               "",
            };
        final String[] Guyana = new String[] {
               "gvajansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "izraelsko standardno vrijeme",
               "IST",
               "izraelsko ljetno vrijeme",
               "IDT",
               "izraelsko vrijeme",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "vrijeme Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "mawsonsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "moskovsko standardno vrijeme",
               "MSK",
               "moskovsko ljetno vrijeme",
               "MSK",
               "moskovsko vrijeme",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ponapejsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "samarsko standardno vrijeme",
               "",
               "samarsko ljetno vrijeme",
               "",
               "samarsko vrijeme",
               "",
            };
        final String[] Tahiti = new String[] {
               "vrijeme Tahitija",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "tajpe\u0161ko standardno vrijeme",
               "CST",
               "tajpe\u0161ko ljetno vrijeme",
               "CDT",
               "tajpe\u0161ko vrijeme",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "vrijeme Tuvalua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "vosto\u010dko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "vrijeme Otoka Wallis i Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "arapsko standardno vrijeme",
               "",
               "arapsko ljetno vrijeme",
               "",
               "arapsko vrijeme",
               "",
            };
        final String[] Armenia = new String[] {
               "armensko standardno vrijeme",
               "",
               "armensko ljetno vrijeme",
               "",
               "armensko vrijeme",
               "",
            };
        final String[] Bolivia = new String[] {
               "bolivijsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "standardno vrijeme Chathama",
               "",
               "ljetno vrijeme Chathama",
               "",
               "vrijeme Chathama",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "koordinirano svjetsko vrijeme",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ekvadorsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "vrijeme Gambiera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "gruzijsko standardno vrijeme",
               "",
               "gruzijsko ljetno vrijeme",
               "",
               "gruzijsko vrijeme",
               "",
            };
        final String[] Irkutsk = new String[] {
               "irkutsko standardno vrijeme",
               "",
               "irkutsko ljetno vrijeme",
               "",
               "irkutsko vrijeme",
               "",
            };
        final String[] Magadan = new String[] {
               "magadansko standardno vrijeme",
               "",
               "magadansko ljetno vrijeme",
               "",
               "magadansko vrijeme",
               "",
            };
        final String[] Myanmar = new String[] {
               "mjanmarsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "standardno vrijeme Otoka Norfolk",
               "",
               "ljetno vrijeme Otoka Norfolk",
               "",
               "vrijeme Otoka Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "standardno vrijeme grada Fernando de Noronha",
               "",
               "ljetno vrijeme grada Fernando de Noronha",
               "",
               "vrijeme grada Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "vrijeme Reuniona",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "vrijeme Rothere",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "vrijeme Salomonovih Otoka",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "vrijeme Tokelaua",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "urugvajsko standardno vrijeme",
               "",
               "urugvajsko ljetno vrijeme",
               "",
               "urugvajsko vrijeme",
               "",
            };
        final String[] Vanuatu = new String[] {
               "standardno vrijeme Vanuatua",
               "",
               "ljetno vrijeme Vanuatua",
               "",
               "vrijeme Vanuatua",
               "",
            };
        final String[] Yakutsk = new String[] {
               "jakutsko standardno vrijeme",
               "",
               "jakutsko ljetno vrijeme",
               "",
               "jakutsko vrijeme",
               "",
            };
        final String[] Atlantic = new String[] {
               "atlantsko standardno vrijeme",
               "AST",
               "atlantsko ljetno vrijeme",
               "AST",
               "atlantsko vrijeme",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "brazilsko standardno vrijeme",
               "",
               "brazilsko ljetno vrijeme",
               "",
               "brazilsko vrijeme",
               "",
            };
        final String[] Chamorro = new String[] {
               "standardno vrijeme Chamorra",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "kolumbijsko standardno vrijeme",
               "",
               "kolumbijsko ljetno vrijeme",
               "",
               "kolumbijsko vrijeme",
               "",
            };
        final String[] Falkland = new String[] {
               "falklandsko standardno vrijeme",
               "",
               "falklandsko ljetno vrijeme",
               "",
               "falklandsko vrijeme",
               "",
            };
        final String[] Malaysia = new String[] {
               "malezijsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "maldivsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ulanbatorsko standardno vrijeme",
               "",
               "ulanbatorsko ljetno vrijeme",
               "",
               "ulanbatorsko vrijeme",
               "",
            };
        final String[] Pakistan = new String[] {
               "pakistansko standardno vrijeme",
               "PKT",
               "pakistansko ljetno vrijeme",
               "PKST",
               "pakistansko vrijeme",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "paragvajsko standardno vrijeme",
               "",
               "paragvajsko ljetno vrijeme",
               "",
               "paragvajsko vrijeme",
               "",
            };
        final String[] Pitcairn = new String[] {
               "pitcairnsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "sahalinsko standardno vrijeme",
               "",
               "sahalinsko ljetno vrijeme",
               "",
               "sahalinsko vrijeme",
               "",
            };
        final String[] Suriname = new String[] {
               "surinamsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "argentinsko standardno vrijeme",
               "",
               "argentinsko ljetno vrijeme",
               "",
               "argentinsko vrijeme",
               "",
            };
        final String[] Christmas = new String[] {
               "vrijeme Bo\u017ei\u0107nog Otoka",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "vrijeme Galapagosa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "hongkon\u0161ko standardno vrijeme",
               "HKT",
               "hongkon\u0161ko ljetno vrijeme",
               "HKST",
               "hongkon\u0161ko vrijeme",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "indokinesko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Petropavlovsk-kam\u010datsko standardno vrijeme",
               "",
               "Petropavlovsk-kam\u010datsko ljetno vrijeme",
               "",
               "Petropavlovsk-kam\u010datsko vrijeme",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "kirgistansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "standardno vrijeme otoka Lord Howe",
               "",
               "ljetno vrijeme otoka Lord Howe",
               "",
               "vrijeme otoka Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "marki\u017eansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "standardno vrijeme Mauricijusa",
               "",
               "ljetno vrijeme Mauricijusa",
               "",
               "vrijeme Mauricijusa",
               "",
            };
        final String[] Singapore = new String[] {
               "singapursko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "venezuelsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "volgogradsko standardno vrijeme",
               "MSK",
               "volgogradsko ljetno vrijeme",
               "MSK",
               "volgogradsko vrijeme",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "azerbajd\u017eansko standardno vrijeme",
               "",
               "azerbajd\u017eansko ljetno vrijeme",
               "",
               "azerbajd\u017eansko vrijeme",
               "",
            };
        final String[] Bangladesh = new String[] {
               "banglade\u0161ko standardno vrijeme",
               "",
               "banglade\u0161ko ljetno vrijeme",
               "",
               "banglade\u0161ko vrijeme",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "standardno vrijeme Zelenortskog oto\u010dja",
               "",
               "ljetno vrijeme Zelenortskog oto\u010dja",
               "",
               "vrijeme Zelenortskog oto\u010dja",
               "",
            };
        final String[] East_Timor = new String[] {
               "isto\u010dnotimorsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "kazahstansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "sej\u0161elsko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "tad\u017eikistansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "uzbekistansko standardno vrijeme",
               "",
               "uzbekistansko ljetno vrijeme",
               "",
               "uzbekistansko vrijeme",
               "",
            };
        final String[] Afghanistan = new String[] {
               "afganistansko vrijeme",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "krasnojarsko standardno vrijeme",
               "",
               "krasnojarsko ljetno vrijeme",
               "",
               "krasnojarsko vrijeme",
               "",
            };
        final String[] New_Zealand = new String[] {
               "novozelandsko standardno vrijeme",
               "NZST",
               "novozelandsko ljetno vrijeme",
               "NZDT",
               "novozelandsko vrijeme",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "novosibirsko standardno vrijeme",
               "",
               "novosibirsko ljetno vrijeme",
               "",
               "novosibirsko vrijeme",
               "",
            };
        final String[] Philippines = new String[] {
               "filipinsko standardno vrijeme",
               "PST",
               "filipinsko ljetno vrijeme",
               "PDT",
               "filipinsko vrijeme",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "vladivosto\u010dko standardno vrijeme",
               "",
               "vladivosto\u010dko ljetno vrijeme",
               "",
               "vladivosto\u010dko vrijeme",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "vrijeme Indijskog oceana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "vrijeme Ekvatorskih otoka",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "newfoundlandsko standardno vrijeme",
               "NST",
               "newfoundlandsko ljetno vrijeme",
               "NDT",
               "newfoundlandsko vrijeme",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "turkmenistansko standardno vrijeme",
               "",
               "turkmenistansko ljetno vrijeme",
               "",
               "turkmenistansko vrijeme",
               "",
            };
        final String[] French_Guiana = new String[] {
               "vrijeme Francuske Gijane",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "standardno vrijeme Nove Kaledonije",
               "",
               "ljetno vrijeme Nove Kaledonije",
               "",
               "vrijeme Nove Kaledonije",
               "",
            };
        final String[] South_Georgia = new String[] {
               "vrijeme Ju\u017ene Georgije",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "jekaterinbur\u0161ko standardno vrijeme",
               "",
               "jekaterinbur\u0161ko ljetno vrijeme",
               "",
               "jekaterinbur\u0161ko vrijeme",
               "",
            };
        final String[] Africa_Central = new String[] {
               "srednjoafri\u010dko vrijeme",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "isto\u010dnoafri\u010dko vrijeme",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "zapadnoafri\u010dko standardno vrijeme",
               "WAT",
               "zapadnoafri\u010dko ljetno vrijeme",
               "WAT",
               "zapadnoafri\u010dko vrijeme",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "vrijeme Dumont-d\u2019Urvillea",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "srednjoeuropsko standardno vrijeme",
               "CET",
               "srednjoeuropsko ljetno vrijeme",
               "CEST",
               "srednjoeuropsko vrijeme",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "isto\u010dnoeuropsko standardno vrijeme",
               "EET",
               "isto\u010dnoeuropsko ljetno vrijeme",
               "EEST",
               "isto\u010dnoeuropsko vrijeme",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "zapadnoeuropsko standardno vrijeme",
               "WET",
               "zapadnoeuropsko ljetno vrijeme",
               "WEST",
               "zapadnoeuropsko vrijeme",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "meksi\u010dko pacifi\u010dko standardno vrijeme",
               "MST",
               "meksi\u010dko pacifi\u010dko ljetno vrijeme",
               "MDT",
               "meksi\u010dko pacifi\u010dko vrijeme",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "ju\u017enoafri\u010dko vrijeme",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "sredi\u0161nje standardno vrijeme",
               "CST",
               "sredi\u0161nje ljetno vrijeme",
               "CDT",
               "sredi\u0161nje vrijeme",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "isto\u010dno standardno vrijeme",
               "EST",
               "isto\u010dno ljetno vrijeme",
               "EST",
               "isto\u010dno vrijeme",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "pacifi\u010dko standardno vrijeme",
               "PST",
               "pacifi\u010dko ljetno vrijeme",
               "PDT",
               "pacifi\u010dko vrijeme",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "vrijeme Francuskih Ju\u017enih Teritorija",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "vrijeme Gilbertovih otoka",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "havajsko-aleutsko standardno vrijeme",
               "HST",
               "havajsko-aleutsko ljetno vrijeme",
               "HST",
               "havajsko-aleutsko vrijeme",
               "HST",
            };
        final String[] Phoenix_Islands = new String[] {
               "vrijeme Otoka Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "standardno vrijeme za Sveti Petar i Mikelon",
               "",
               "ljetno vrijeme za Sveti Petar i Mikelon",
               "",
               "vrijeme za Sveti Petar i Mikelon",
               "",
            };
        final String[] America_Mountain = new String[] {
               "planinsko standardno vrijeme",
               "MST",
               "planinsko ljetno vrijeme",
               "MST",
               "planinsko vrijeme",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "vrijeme Mar\u0161alovih Otoka",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "vrijeme Papue Nove Gvineje",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "srednjoaustralsko standardno vrijeme",
               "ACST",
               "srednjoaustralsko ljetno vrijeme",
               "ACDT",
               "srednjoaustralsko vrijeme",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "isto\u010dnoaustralsko standardno vrijeme",
               "AEST",
               "isto\u010dnoaustralsko ljetno vrijeme",
               "AEDT",
               "isto\u010dnoaustralsko vrijeme",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "zapadnoaustralsko standardno vrijeme",
               "AWST",
               "zapadnoaustralsko ljetno vrijeme",
               "AWDT",
               "zapadnoaustralsko vrijeme",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "srednjoindonezijsko vrijeme",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "isto\u010dnoindonezijsko vrijeme",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "zapadnoindonezijsko vrijeme",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "australsko sredi\u0161nje zapadno standardno vrijeme",
               "",
               "australsko sredi\u0161nje zapadno ljetno vrijeme",
               "",
               "australsko sredi\u0161nje zapadno vrijeme",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "univerzalno vrijeme",
                    "GMT",
                    "britansko ljetno vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "koordinirano svjetsko vrijeme",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "univerzalno vrijeme",
                    "GMT",
                    "irsko standardno vrijeme",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "koordinirano svjetsko vrijeme",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "koordinirano svjetsko vrijeme",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "univerzalno vrijeme",
                    "GMT",
                    "britansko ljetno vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "koordinirano svjetsko vrijeme",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "koordinirano svjetsko vrijeme",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "koordinirano svjetsko vrijeme",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "univerzalno vrijeme",
                    "GMT",
                    "irsko standardno vrijeme",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "univerzalno vrijeme",
                    "GMT",
                    "britansko ljetno vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "univerzalno vrijeme",
                    "GMT",
                    "britansko ljetno vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "univerzalno vrijeme",
                    "GMT",
                    "britansko ljetno vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "univerzalno vrijeme",
                    "GMT",
                    "britansko ljetno vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "univerzalno vrijeme",
                    "GMT",
                    "britansko ljetno vrijeme",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Chita", "\u010cita" },
            { "timezone.excity.Asia/Macau", "Makao" },
            { "timezone.excity.Asia/Qatar", "Katar" },
            { "timezone.excity.Asia/Seoul", "Seul" },
            { "timezone.excity.Asia/Tokyo", "Tokio" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.Asia/Almaty", "Alma Ata" },
            { "timezone.excity.Asia/Anadyr", "Anadir" },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Brunei", "Brunej" },
            { "timezone.excity.Asia/Kuwait", "Kuvajt" },
            { "timezone.excity.Asia/Riyadh", "Rijad" },
            { "timezone.excity.Asia/Saigon", "Ho \u0160i Min" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Asia/Urumqi", "Urum\u010di" },
            { "timezone.excity.Etc/Unknown", "Nepoznati grad" },
            { "timezone.excity.Europe/Kiev", "Kijev" },
            { "timezone.excity.Europe/Rome", "Rim" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Baghdad", "Bagdad" },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Bishkek", "Bi\u0161kek" },
            { "timezone.excity.Asia/Jakarta", "D\u017eakarta" },
            { "timezone.excity.Asia/Karachi", "Kara\u010di" },
            { "timezone.excity.Asia/Nicosia", "Nikozija" },
            { "timezone.excity.Asia/Rangoon", "Rangun" },
            { "timezone.excity.Asia/Yakutsk", "Jakutsk" },
            { "timezone.excity.Asia/Yerevan", "Erevan" },
            { "timezone.excity.Europe/Paris", "Pariz" },
            { "timezone.excity.Europe/Sofia", "Sofija" },
            { "timezone.excity.Pacific/Fiji", "Fid\u017ei" },
            { "timezone.excity.Asia/Ashgabat", "A\u0161gabat" },
            { "timezone.excity.Asia/Damascus", "Damask" },
            { "timezone.excity.Asia/Dushanbe", "Du\u0161anbe" },
            { "timezone.excity.Asia/Katmandu", "Katmandu" },
            { "timezone.excity.Asia/Khandyga", "Handiga" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Asia/Sakhalin", "Sahalin" },
            { "timezone.excity.Asia/Shanghai", "\u0160angaj" },
            { "timezone.excity.Asia/Tashkent", "Ta\u0161kent" },
            { "timezone.excity.Europe/Athens", "Atena" },
            { "timezone.excity.Europe/Lisbon", "Lisabon" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskva" },
            { "timezone.excity.Europe/Prague", "Prag" },
            { "timezone.excity.Europe/Skopje", "Skoplje" },
            { "timezone.excity.Europe/Tirane", "Tirana" },
            { "timezone.excity.Europe/Vienna", "Be\u010d" },
            { "timezone.excity.Europe/Warsaw", "Var\u0161ava" },
            { "timezone.excity.Europe/Zurich", "Z\u00fcrich" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Al\u017eir" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Guyana", "Gvajana" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalem" },
            { "timezone.excity.Asia/Kamchatka", "Kam\u010datka" },
            { "timezone.excity.Asia/Pyongyang", "Pjongjang" },
            { "timezone.excity.Asia/Qyzylorda", "Kizilorda" },
            { "timezone.excity.Asia/Singapore", "Singapur" },
            { "timezone.excity.Europe/Andorra", "Andora" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Africa/Djibouti", "D\u017eibuti" },
            { "timezone.excity.America/Jamaica", "Jamajka" },
            { "timezone.excity.Atlantic/Azores", "Azori" },
            { "timezone.excity.Atlantic/Canary", "Kanari" },
            { "timezone.excity.Atlantic/Faeroe", "Ferojski otoci" },
            { "timezone.excity.Europe/Belgrade", "Beograd" },
            { "timezone.excity.Europe/Brussels", "Bruxelles" },
            { "timezone.excity.Europe/Budapest", "Budimpe\u0161ta" },
            { "timezone.excity.Europe/Chisinau", "Ki\u0161injev" },
            { "timezone.excity.Indian/Maldives", "Maldivi" },
            { "timezone.excity.America/Anguilla", "Angvila" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.Asia/Krasnoyarsk", "Krasnojarsk" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulan Bator" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudi" },
            { "timezone.excity.Europe/Astrakhan", "Astrahan" },
            { "timezone.excity.Europe/Bucharest", "Bukure\u0161t" },
            { "timezone.excity.Europe/Ulyanovsk", "Uljanovsk" },
            { "timezone.excity.Indian/Mauritius", "Mauricijus" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.America/Guatemala", "Gvatemala" },
            { "timezone.excity.Asia/Novokuznetsk", "Novokuznjeck" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "Luksemburg" },
            { "timezone.excity.Europe/Simferopol", "Simferopolj" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.Pacific/Marquesas", "Marki\u017eansko oto\u010dje" },
            { "timezone.excity.Africa/Addis_Ababa", "Addis Abeba" },
            { "timezone.excity.America/Costa_Rica", "Kostarika" },
            { "timezone.excity.America/Guadeloupe", "Guadalupe" },
            { "timezone.excity.Asia/Srednekolymsk", "Srednekolimsk" },
            { "timezone.excity.Asia/Yekaterinburg", "Jekaterinburg" },
            { "timezone.excity.Atlantic/St_Helena", "Sveta Helena" },
            { "timezone.excity.Europe/Isle_of_Man", "Otok Man" },
            { "timezone.excity.Europe/Kaliningrad", "Kalinjingrad" },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "timezone.excity.America/Mexico_City", "Ciudad de M\u00e9xico" },
            { "timezone.excity.America/Puerto_Rico", "Portoriko" },
            { "timezone.excity.America/St_Barthelemy", "Saint Barth\u00e9lemy" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Ju\u017ena Georgija" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Sjeverna Dakota" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Sjeverna Dakota" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Sjeverna Dakota" },
        };
        return data;
    }
}
