/*
 * Copyright (c) 2019, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jpackage.internal;

import java.util.ArrayList;
import java.util.List;
import java.util.ListResourceBundle;
import java.util.Map;
import jdk.internal.util.OperatingSystem;

import java.util.ResourceBundle;
import static java.util.stream.Collectors.toMap;
import java.util.stream.Stream;

class I18N {

    static String getString(String key) {
        return BUNDLE.getString(key);
    }

    private static class MultiResourceBundle extends ListResourceBundle {

        MultiResourceBundle(ResourceBundle... bundles) {
            contents = Stream.of(bundles).map(bundle -> {
                return bundle.keySet().stream().map(key -> {
                    return Map.entry(key, bundle.getObject(key));
                });
            }).flatMap(x -> x).collect(toMap(Map.Entry::getKey, Map.Entry::getValue, (o, n) -> {
                // Override old value with the new one
                return n;
            })).entrySet().stream().map(e -> {
                return new Object[]{e.getKey(), e.getValue()};
            }).toArray(Object[][]::new);
        }

        @Override
        protected Object[][] getContents() {
            return contents;
        }

        private final Object[][] contents;
    }

    private static final MultiResourceBundle BUNDLE;

    static {
        List<String> bundleNames = new ArrayList<>();

        bundleNames.add("jdk.jpackage.internal.resources.MainResources");

        if (OperatingSystem.isLinux()) {
            bundleNames.add("jdk.jpackage.internal.resources.LinuxResources");
        } else if (OperatingSystem.isWindows()) {
            bundleNames.add("jdk.jpackage.internal.resources.WinResources");
            bundleNames.add("jdk.jpackage.internal.resources.WinResourcesNoL10N");
        } else if (OperatingSystem.isMacOS()) {
            bundleNames.add("jdk.jpackage.internal.resources.MacResources");
        } else {
            throw new IllegalStateException("Unknown platform");
        }

        BUNDLE = new MultiResourceBundle(bundleNames.stream().map(ResourceBundle::getBundle)
                .toArray(ResourceBundle[]::new));
    }
}
