/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_ce extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u04c0\u0430\u044c\u0440\u0431\u0438\u0439\u043d";
        final String metaValue_hy = "\u044d\u0440\u043c\u0430\u043b\u043e\u0439\u043d";
        final String metaValue_ka = "\u0433\u0443\u044c\u0440\u0436\u0438\u0439\u043d";
        final String metaValue_el = "\u0433\u0440\u0435\u043a\u0438\u0439\u043d";
        final String metaValue_gu = "\u0433\u0443\u0434\u0436\u0430\u0440\u0430\u0442\u0438";
        final String metaValue_he = "\u0436\u0443\u0433\u0442\u0438\u0439\u043d";
        final String metaValue_ja = "\u044f\u043f\u043e\u043d\u0438\u0439\u043d";
        final String metaValue_km = "\u043a\u0445\u043c\u0435\u0440\u0438\u0439\u043d";
        final String metaValue_kn = "\u043a\u0430\u043d\u043d\u0430\u0434\u0430";
        final String metaValue_ko = "\u043a\u043e\u0440\u0435\u0439\u043d";
        final String metaValue_lo = "\u043b\u0430\u043e\u0441\u0441\u0438\u0439\u043d";
        final String metaValue_la = "\u043b\u0430\u0442\u0438\u043d\u0430\u043d";
        final String metaValue_mn = "\u043c\u043e\u043d\u0433\u043e\u043b\u0438\u0439\u043d";
        final String metaValue_or = "\u043e\u0440\u0438";
        final String metaValue_si = "\u0441\u0438\u043d\u0433\u0430\u043b\u0445\u043e\u0439\u043d";
        final String metaValue_ta = "\u0442\u0430\u043c\u0438\u043b\u0445\u043e\u0439\u043d";
        final String metaValue_te = "\u0442\u0435\u043b\u0443\u0433\u0443";
        final String metaValue_th = "\u0442\u0430\u0439\u043d";
        final String metaValue_bo = "\u0442\u0438\u0431\u0435\u0442\u0445\u043e\u0439\u043d";
        final String metaValue_fa = "\u0433\u04c0\u0430\u0436\u0430\u0440\u0438\u0439\u043d";
        final Object[][] data = new Object[][] {
            { "001", "\u0414\u0435\u0440\u0440\u0438\u0433\u0434\u0443\u044c\u043d\u0435\u043d\u0430\u043d" },
            { "002", "\u0410\u0444\u0440\u0438\u043a\u0430" },
            { "003", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "005", "\u041a\u044a\u0438\u043b\u0431\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "009", "\u041e\u043a\u0435\u0430\u043d\u0438" },
            { "011", "\u041c\u0430\u043b\u0445\u0431\u0443\u0437\u0435\u043d \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "013", "\u042e\u043a\u043a\u044a\u0435\u0440\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "014", "\u041c\u0430\u043b\u0445\u0431\u0430\u043b\u0435\u043d \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "015", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "017", "\u042e\u043a\u043a\u044a\u0435\u0440\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "018", "\u041a\u044a\u0438\u043b\u0431\u0430 \u0410\u0444\u0440\u0438\u043a\u0430" },
            { "019", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0430, \u043a\u044a\u0438\u043b\u0431\u0430 \u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "021", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0410\u043c\u0435\u0440\u0438\u043a\u0430 \u2013 \u0410\u0426\u0428 \u0430, \u041a\u0430\u043d\u0430\u0434\u0430 \u0430" },
            { "029", "\u041a\u0430\u0440\u0438\u0431\u0430\u0448" },
            { "030", "\u042e\u043a\u043a\u044a\u0435\u0440\u0430 \u0410\u0437\u0438" },
            { "034", "\u041a\u044a\u0438\u043b\u0431\u0430 \u0410\u0437\u0438" },
            { "035", "\u041a\u044a\u0438\u043b\u0431\u0430-\u043c\u0430\u043b\u0445\u0431\u0430\u043b\u0435\u043d \u0410\u0437\u0438" },
            { "039", "\u041a\u044a\u0438\u043b\u0431\u0430 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "053", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0430\u0437\u0438" },
            { "054", "\u041c\u0435\u043b\u0430\u043d\u0435\u0437\u0438" },
            { "057", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438" },
            { "061", "\u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438" },
            { "142", "\u0410\u0437\u0438" },
            { "143", "\u042e\u043a\u043a\u044a\u0435\u0440\u0430 \u041c\u0430\u043b\u0445\u0431\u0430\u043b\u0435" },
            { "145", "\u042e\u043a\u043a\u044a\u0435\u0440\u0430 \u0430, \u0413\u0435\u0440\u0433\u0430\u0440\u0430 \u0430 \u041c\u0430\u043b\u0445\u0431\u0430\u043b\u0435" },
            { "150", "\u0415\u0432\u0440\u043e\u043f\u0430" },
            { "151", "\u041c\u0430\u043b\u0445\u0431\u0430\u043b\u0435\u043d \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "154", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "155", "\u041c\u0430\u043b\u0445\u0431\u0443\u0437\u0435\u043d \u0415\u0432\u0440\u043e\u043f\u0430" },
            { "419", "\u041b\u0430\u0442\u0438\u043d\u0430\u043d \u0410\u043c\u0435\u0440\u0438\u043a\u0430" },
            { "AC", "\u0410\u0439\u044a\u0430\u0434\u0430\u043b\u0430\u0440\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435" },
            { "AD", "\u0410\u043d\u0434\u043e\u0440\u0440\u0430" },
            { "AE", "\u04c0\u0430\u0440\u0431\u0438\u0439\u043d \u0426\u0445\u044c\u0430\u043d\u0430\u0442\u043e\u044c\u0445\u043d\u0430 \u042d\u043c\u0438\u0440\u0430\u0442\u0430\u0448" },
            { "AF", "\u041e\u0432\u0445\u04c0\u0430\u043d \u043c\u043e\u0445\u043a" },
            { "AG", "\u0410\u043d\u0442\u0438\u0433\u0443\u0430 \u0430, \u0411\u0430\u0440\u0431\u0443\u0434\u0430 \u0430" },
            { "AI", "\u0410\u043d\u0433\u0438\u043b\u044c\u044f" },
            { "AL", "\u0410\u043b\u0431\u0430\u043d\u0438" },
            { "AM", "\u042d\u0440\u043c\u0430\u043b\u043e\u0439\u0447\u043e\u044c" },
            { "AO", "\u0410\u043d\u0433\u043e\u043b\u0430" },
            { "AQ", "\u0410\u043d\u0442\u0430\u0440\u043a\u0442\u0438\u0434\u0430" },
            { "AR", "\u0410\u0440\u0433\u0435\u043d\u0442\u0438\u043d\u0430" },
            { "AS", "\u0410\u043c\u0435\u0440\u0438\u043a\u0430\u043d \u0421\u0430\u043c\u043e\u0430" },
            { "AT", "\u0410\u0432\u0441\u0442\u0440\u0438" },
            { "AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438" },
            { "AW", "\u0410\u0440\u0443\u0431\u0430" },
            { "AX", "\u0410\u043b\u0430\u043d\u0434\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "AZ", "\u0410\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d" },
            { "BA", "\u0411\u043e\u0441\u043d\u0438 \u0430, \u0413\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d\u0430 \u0430" },
            { "BB", "\u0411\u0430\u0440\u0431\u0430\u0434\u043e\u0441" },
            { "BD", "\u0411\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448" },
            { "BE", "\u0411\u0435\u043b\u044c\u0433\u0438" },
            { "BF", "\u0411\u0443\u0440\u043a\u0438\u043d\u0430- \u0424\u0430\u0441\u043e" },
            { "BG", "\u0411\u043e\u043b\u0433\u0430\u0440\u0438" },
            { "BH", "\u0411\u0430\u0445\u0440\u0435\u0439\u043d" },
            { "BI", "\u0411\u0443\u0440\u0443\u043d\u0434\u0438" },
            { "BJ", "\u0411\u0435\u043d\u0438\u043d" },
            { "BL", "\u0421\u0435\u043d-\u0411\u0430\u0440\u0442\u0435\u043b\u044c\u043c\u0438" },
            { "BM", "\u0411\u0435\u0440\u043c\u0443\u0434\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "BN", "\u0411\u0440\u0443\u043d\u0435\u0439-\u0414\u0430\u0440\u0443\u0441\u0441\u0430\u043b\u0430\u043c" },
            { "BO", "\u0411\u043e\u043b\u0438\u0432\u0438" },
            { "BQ", "\u0411\u043e\u043d\u044d\u0439\u0440, \u0421\u0438\u043d\u0442-\u042d\u0441\u0442\u0430\u0442\u0438\u0443\u0441 \u0430, \u0421\u0430\u0431\u0430 \u0430" },
            { "BR", "\u0411\u0440\u0430\u0437\u0438\u043b\u0438" },
            { "BS", "\u0411\u0430\u0433\u0430\u043c\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "BT", "\u0411\u0443\u0442\u0430\u043d" },
            { "BV", "\u0411\u0443\u0432\u0435\u043d \u0433\u04c0\u0430\u0439\u0440\u0435" },
            { "BW", "\u0411\u043e\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "BY", "\u0411\u0435\u043b\u043e\u0440\u0443\u0441\u0441\u0438" },
            { "BZ", "\u0411\u0435\u043b\u0438\u0437" },
            { "CA", "\u041a\u0430\u043d\u0430\u0434\u0430" },
            { "CC", "\u041a\u043e\u043a\u043e\u0441\u0438\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "CD", "\u0414\u0435\u043c\u043e\u043a\u0440\u0430\u0442\u0438\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430 \u041a\u043e\u043d\u0433\u043e" },
            { "CF", "\u042e\u043a\u043a\u044a\u0435\u0440\u0447\u0443 \u0410\u0444\u0440\u0438\u043a\u0438\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "CG", "\u041a\u043e\u043d\u0433\u043e - \u0411\u0440\u0430\u0437\u0437\u0430\u0432\u0438\u043b\u044c" },
            { "CH", "\u0428\u0432\u0435\u0439\u0446\u0430\u0440\u0438" },
            { "CI", "\u041a\u043e\u0442-\u0414\u2019\u0438\u0432\u0443\u0430\u0440" },
            { "CK", "\u041a\u0443\u043a\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "CL", "\u0427\u0438\u043b\u0438" },
            { "CM", "\u041a\u0430\u043c\u0435\u0440\u0443\u043d" },
            { "CN", "\u0426\u0438\u0439\u0447\u043e\u044c" },
            { "CO", "\u041a\u043e\u043b\u0443\u043c\u0431\u0438" },
            { "CP", "\u041a\u043b\u0438\u043f\u043f\u0435\u0440\u0442\u043e\u043d" },
            { "CR", "\u041a\u043e\u0441\u0442\u0430-\u0420\u0438\u043a\u0430" },
            { "CU", "\u041a\u0443\u0431\u0430" },
            { "CV", "\u041a\u0430\u0431\u043e-\u0412\u0435\u0440\u0434\u0435" },
            { "CW", "\u041a\u044e\u0440\u0430\u0441\u0430\u043e" },
            { "CX", "\u0413\u04c0\u0430\u0439\u0440\u0435 \u04cf\u0438\u0441\u0430 \u043f\u0430\u0439\u0445\u04cf\u0430\u043c\u0430\u0440 \u0432\u0438\u043d\u0430 \u0434\u0435" },
            { "CY", "\u041a\u0438\u043f\u0440" },
            { "CZ", "\u0427\u0435\u0445\u0438" },
            { "DE", "\u0413\u0435\u0440\u043c\u0430\u043d\u0438" },
            { "DG", "\u0414\u0438\u0435\u0433\u043e-\u0413\u0430\u0440\u0441\u0438" },
            { "DJ", "\u0414\u0436\u0438\u0431\u0443\u0442\u0438" },
            { "DK", "\u0414\u0430\u043d\u0438" },
            { "DM", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430" },
            { "DO", "\u0414\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "DZ", "\u0410\u043b\u0436\u0438\u0440" },
            { "EA", "\u0421\u0435\u0443\u0442\u0430 \u0430, \u041c\u0435\u043b\u0438\u043b\u044c\u044f \u0430" },
            { "EC", "\u042d\u043a\u0432\u0430\u0434\u043e\u0440" },
            { "EE", "\u042d\u0441\u0442\u043e\u043d\u0438" },
            { "EG", "\u041c\u0438\u0441\u0430\u0440" },
            { "EH", "\u041c\u0430\u043b\u0445\u0431\u0443\u0437\u0435\u043d \u0421\u0430\u044c\u0445\u044c\u0430\u0440\u0430" },
            { "ER", "\u042d\u0440\u0438\u0442\u0440\u0435\u0439" },
            { "ES", "\u0418\u0441\u043f\u0430\u043d\u0438" },
            { "ET", "\u042d\u0444\u0438\u043e\u043f\u0438" },
            { "EU", "\u0415\u0432\u0440\u043e\u0431\u0430\u0440\u0442" },
            { "EZ", "\u0435\u0432\u0440\u043e\u0437\u043e\u043d\u0430" },
            { "FI", "\u0424\u0438\u043d\u043b\u044f\u043d\u0434\u0438" },
            { "FJ", "\u0424\u0438\u0434\u0436\u0438" },
            { "FK", "\u0424\u043e\u043b\u043a\u043b\u0435\u043d\u0434\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "FM", "\u041c\u0438\u043a\u0440\u043e\u043d\u0435\u0437\u0438\u043d \u0424\u0435\u0434\u0435\u0440\u0430\u0442\u0438\u0432\u043d\u0438 \u0448\u0442\u0430\u0442\u0430\u0448" },
            { "FO", "\u0424\u0430\u0440\u0435\u0440\u0438\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "FR", "\u0424\u0440\u0430\u043d\u0446\u0438" },
            { "GA", "\u0413\u0430\u0431\u043e\u043d" },
            { "GB", "\u0419\u043e\u043a\u043a\u0445\u0430 \u0411\u0440\u0438\u0442\u0430\u043d\u0438" },
            { "GD", "\u0413\u0440\u0435\u043d\u0430\u0434\u0430" },
            { "GE", "\u0413\u0443\u044c\u0440\u0436\u0438\u0439\u0447\u043e\u044c" },
            { "GF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d \u0413\u0432\u0438\u0430\u043d\u0430" },
            { "GG", "\u0413\u0435\u0440\u043d\u0441\u0438" },
            { "GH", "\u0413\u0430\u043d\u0430" },
            { "GI", "\u0413\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440" },
            { "GL", "\u0413\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0438" },
            { "GM", "\u0413\u0430\u043c\u0431\u0438" },
            { "GN", "\u0413\u0432\u0438\u043d\u0435\u0439" },
            { "GP", "\u0413\u0432\u0430\u0434\u0435\u043b\u0443\u043f\u0430" },
            { "GQ", "\u042d\u043a\u0432\u0430\u0442\u043e\u0440\u0430\u043d \u0413\u0432\u0438\u043d\u0435\u0439" },
            { "GR", "\u0413\u0440\u0435\u0446\u0438" },
            { "GS", "\u041a\u044a\u0438\u043b\u0431\u0430 \u0414\u0436\u043e\u0440\u0434\u0436\u0438 \u0430, \u041a\u044a\u0438\u043b\u0431\u0430 \u0413\u0430\u0432\u0430\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448 \u0430" },
            { "GT", "\u0413\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u0430" },
            { "GU", "\u0413\u0443\u0430\u043c" },
            { "GW", "\u0413\u0432\u0438\u043d\u0435\u0439-\u0411\u0438\u0441\u0430\u0443" },
            { "GY", "\u0413\u0430\u0439\u0430\u043d\u0430" },
            { "HK", "\u0413\u043e\u043d\u043a\u043e\u043d\u0433 (\u0448\u0430-\u043a\u044a\u0430\u044c\u0441\u0442\u0438\u043d\u0430 \u043a\u04c0\u043e\u0448\u0442)" },
            { "HM", "\u0425\u0435\u0440\u0434 \u0433\u04c0\u0430\u0439\u0440\u0435 \u0430, \u041c\u0430\u043a\u0434\u043e\u043d\u0430\u043b\u044c\u0434 \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448 \u0430" },
            { "HN", "\u0413\u043e\u043d\u0434\u0443\u0440\u0430\u0441" },
            { "HR", "\u0425\u043e\u0440\u0432\u0430\u0442\u0438" },
            { "HT", "\u0413\u0430\u0438\u0442\u0438" },
            { "HU", "\u0412\u0435\u043d\u0433\u0440\u0438" },
            { "IC", "\u041a\u0430\u043d\u0430\u0440\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "ID", "\u0418\u043d\u0434\u043e\u043d\u0435\u0437\u0438" },
            { "IE", "\u0418\u0440\u043b\u0430\u043d\u0434\u0438" },
            { "IL", "\u0418\u0437\u0440\u0430\u0438\u043b\u044c" },
            { "IM", "\u041c\u044d\u043d \u0433\u04c0\u0430\u0439\u0440\u0435" },
            { "IN", "\u0425\u04c0\u0438\u043d\u0434\u0438" },
            { "IQ", "\u04c0\u0438\u0440\u0430\u043a\u044a" },
            { "IR", "\u0413\u04c0\u0430\u0436\u0430\u0440\u0438\u0439\u0447\u043e\u044c" },
            { "IS", "\u0418\u0441\u043b\u0430\u043d\u0434\u0438" },
            { "IT", "\u0418\u0442\u0430\u043b\u0438" },
            { "JE", "\u0414\u0436\u0435\u0440\u0441\u0438" },
            { "JM", "\u042f\u043c\u0430\u0439\u043a\u0430" },
            { "JO", "\u0423\u0440\u0434\u0430\u043d" },
            { "JP", "\u042f\u043f\u043e\u043d\u0438" },
            { "KE", "\u041a\u0435\u043d\u0438" },
            { "KG", "\u041a\u0438\u0440\u0433\u0438\u0437\u0438" },
            { "KH", "\u041a\u0430\u043c\u0431\u043e\u0434\u0436\u0430" },
            { "KI", "\u041a\u0438\u0440\u0438\u0431\u0430\u0442\u0438" },
            { "KM", "\u041a\u043e\u043c\u043e\u0440\u0430\u0448" },
            { "KN", "\u0421\u0435\u043d\u0442-\u041a\u0438\u0442\u0441 \u0430, \u041d\u0435\u0432\u0438\u0441 \u0430" },
            { "KP", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u041a\u043e\u0440\u0435\u0439" },
            { "KR", "\u041a\u044a\u0438\u043b\u0431\u0430 \u041a\u043e\u0440\u0435\u0439" },
            { "KW", "\u041a\u0443\u0432\u0435\u0439\u0442" },
            { "KY", "\u041a\u0430\u0439\u043c\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "KZ", "\u041a\u0445\u0430\u0437\u0430\u043a\u0445\u0441\u0442\u0430\u043d" },
            { "LA", "\u041b\u0430\u043e\u0441" },
            { "LB", "\u041b\u0438\u0432\u0430\u043d" },
            { "LC", "\u0421\u0435\u043d\u0442-\u041b\u044e\u0441\u0438" },
            { "LI", "\u041b\u0438\u0445\u0442\u0435\u043d\u0448\u0442\u0435\u0439\u043d" },
            { "LK", "\u0428\u0440\u0438-\u041b\u0430\u043d\u043a\u0430" },
            { "LR", "\u041b\u0438\u0431\u0435\u0440\u0438" },
            { "LS", "\u041b\u0435\u0441\u043e\u0442\u043e" },
            { "LT", "\u041b\u0438\u0442\u0432\u0430" },
            { "LU", "\u041b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433" },
            { "LV", "\u041b\u0430\u0442\u0432\u0438" },
            { "LY", "\u041b\u0438\u0432\u0438" },
            { "MA", "\u041c\u0430\u0440\u043e\u043a\u043a\u043e" },
            { "MC", "\u041c\u043e\u043d\u0430\u043a\u043e" },
            { "MD", "\u041c\u043e\u043b\u0434\u0430\u0432\u0438" },
            { "ME", "\u04c0\u0430\u044c\u0440\u0436\u0430\u043b\u0430\u043c\u0430\u043d\u0447\u043e\u044c" },
            { "MF", "\u0421\u0435\u043d-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "MG", "\u041c\u0430\u0434\u0430\u0433\u0430\u0441\u043a\u0430\u0440" },
            { "MH", "\u041c\u0430\u0440\u0448\u0430\u043b\u043b\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "ML", "\u041c\u0430\u043b\u0438" },
            { "MM", "\u041c\u044c\u044f\u043d\u043c\u0430 (\u0411\u0438\u0440\u043c\u0430)" },
            { "MN", "\u041c\u043e\u043d\u0433\u043e\u043b\u0438" },
            { "MO", "\u041c\u0430\u043a\u0430\u043e (\u0448\u0430-\u043a\u044a\u0430\u044c\u0441\u0442\u0438\u043d\u0430 \u043a\u04c0\u043e\u0448\u0442)" },
            { "MP", "\u041a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u041c\u0430\u0440\u0438\u0430\u043d\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "MQ", "\u041c\u0430\u0440\u0442\u0438\u043d\u0438\u043a\u0430" },
            { "MR", "\u041c\u0430\u0432\u0440\u0438\u0442\u0430\u043d\u0438" },
            { "MS", "\u041c\u043e\u043d\u0442\u0441\u0435\u0440\u0440\u0430\u0442" },
            { "MT", "\u041c\u0430\u043b\u044c\u0442\u0430" },
            { "MU", "\u041c\u0430\u0432\u0440\u0438\u043a\u0438" },
            { "MV", "\u041c\u0430\u043b\u044c\u0434\u0438\u0432\u0430\u0448" },
            { "MW", "\u041c\u0430\u043b\u0430\u0432\u0438" },
            { "MX", "\u041c\u0435\u043a\u0441\u0438\u043a\u0430" },
            { "MY", "\u041c\u0430\u043b\u0430\u0439\u0437\u0438" },
            { "MZ", "\u041c\u043e\u0437\u0430\u043c\u0431\u0438\u043a" },
            { "NA", "\u041d\u0430\u043c\u0438\u0431\u0438" },
            { "NC", "\u041a\u0435\u0440\u043b\u0430 \u041a\u0430\u043b\u0435\u0434\u043e\u043d\u0438" },
            { "NE", "\u041d\u0438\u0433\u0435\u0440" },
            { "NF", "\u041d\u043e\u0440\u0444\u043e\u043b\u043a \u0433\u04c0\u0430\u0439\u0440\u0435" },
            { "NG", "\u041d\u0438\u0433\u0435\u0440\u0438" },
            { "NI", "\u041d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430" },
            { "NL", "\u041d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u0430\u0448" },
            { "NO", "\u041d\u043e\u0440\u0432\u0435\u0433\u0438" },
            { "NP", "\u041d\u0435\u043f\u0430\u043b" },
            { "NR", "\u041d\u0430\u0443\u0440\u0443" },
            { "NU", "\u041d\u0438\u0443\u044d" },
            { "NZ", "\u041a\u0435\u0440\u043b\u0430 \u0417\u0435\u043b\u0430\u043d\u0434\u0438" },
            { "OM", "\u04c0\u043e\u043c\u0430\u043d" },
            { "PA", "\u041f\u0430\u043d\u0430\u043c\u0430" },
            { "PE", "\u041f\u0435\u0440\u0443" },
            { "PF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d \u041f\u043e\u043b\u0438\u043d\u0435\u0437\u0438" },
            { "PG", "\u041f\u0430\u043f\u0443\u0430 \u2014 \u041a\u0435\u0440\u043b\u0430 \u0413\u0432\u0438\u043d\u0435\u0439" },
            { "PH", "\u0424\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u0430\u0448" },
            { "PK", "\u041f\u0430\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "PL", "\u041f\u043e\u043b\u044c\u0448\u0430" },
            { "PM", "\u0421\u0435\u043d-\u041f\u044c\u0435\u0440 \u0430, \u041c\u0438\u043a\u0435\u043b\u043e\u043d \u0430" },
            { "PN", "\u041f\u0438\u0442\u043a\u044d\u0440\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "PR", "\u041f\u0443\u044d\u0440\u0442\u043e-\u0420\u0438\u043a\u043e" },
            { "PS", "\u041f\u0430\u043b\u0435\u0441\u0442\u04c0\u0438\u043d\u0430\u043d \u043b\u0430\u0442\u0442\u0430\u043d\u0430\u0448" },
            { "PT", "\u041f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438" },
            { "PW", "\u041f\u0430\u043b\u0430\u0443" },
            { "PY", "\u041f\u0430\u0440\u0430\u0433\u0432\u0430\u0439" },
            { "QA", "\u041a\u0430\u0442\u0430\u0440" },
            { "QO", "\u0410\u0440\u0430\u0445\u044c\u0430\u0440\u0430 \u041e\u043a\u0435\u0430\u043d\u0438" },
            { "RE", "\u0420\u0435\u044e\u043d\u044c\u043e\u043d" },
            { "RO", "\u0420\u0443\u043c\u044b\u043d\u0438" },
            { "RS", "\u0421\u0435\u0440\u0431\u0438" },
            { "RU", "\u0420\u043e\u0441\u0441\u0438" },
            { "RW", "\u0420\u0443\u0430\u043d\u0434\u0430" },
            { "SA", "\u0421\u0430\u04c0\u0443\u0434\u0438\u0439\u043d \u04c0\u0430\u044c\u0440\u0431\u0438\u0439\u0447\u043e\u044c" },
            { "SB", "\u0421\u043e\u043b\u043e\u043c\u043e\u043d\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "SC", "\u0421\u0435\u0439\u0448\u0435\u043b\u0430\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "SD", "\u0421\u0443\u0434\u0430\u043d" },
            { "SE", "\u0428\u0432\u0435\u0446\u0438" },
            { "SG", "\u0421\u0438\u043d\u0433\u0430\u043f\u0443\u0440" },
            { "SH", "\u0421\u0438\u0439\u043b\u0430\u0445\u044c\u0447\u0443 \u0415\u043b\u0435\u043d\u0438\u043d \u0433\u04c0\u0430\u0439\u0440\u0435" },
            { "SI", "\u0421\u043b\u043e\u0432\u0435\u043d\u0438" },
            { "SJ", "\u0428\u043f\u0438\u0446\u0431\u0435\u0440\u0433\u0435\u043d \u0430, \u042f\u043d-\u041c\u0430\u0439\u0435\u043d \u0430" },
            { "SK", "\u0421\u043b\u043e\u0432\u0430\u043a\u0438" },
            { "SL", "\u0421\u044c\u0435\u0440\u0440\u0430- \u041b\u0435\u043e\u043d\u0435" },
            { "SM", "\u0421\u0430\u043d-\u041c\u0430\u0440\u0438\u043d\u043e" },
            { "SN", "\u0421\u0435\u043d\u0435\u0433\u0430\u043b" },
            { "SO", "\u0421\u043e\u043c\u0430\u043b\u0438" },
            { "SR", "\u0421\u0443\u0440\u0438\u043d\u0430\u043c" },
            { "SS", "\u041a\u044a\u0438\u043b\u0431\u0430 \u0421\u0443\u0434\u0430\u043d" },
            { "ST", "\u0421\u0430\u043d-\u0422\u043e\u043c\u0435 \u0430, \u041f\u0440\u0438\u043d\u0441\u0438\u043f\u0438 \u0430" },
            { "SV", "\u0421\u0430\u043b\u044c\u0432\u0430\u0434\u043e\u0440" },
            { "SX", "\u0421\u0438\u043d\u0442-\u041c\u0430\u0440\u0442\u0435\u043d" },
            { "SY", "\u0428\u0435\u043c\u0430" },
            { "SZ", "\u0421\u0432\u0430\u0437\u0438\u043b\u0435\u043d\u0434" },
            { "TA", "\u0422\u0440\u0438\u0441\u0442\u0430\u043d-\u0434\u0430- \u041a\u0443\u043d\u044c\u044f" },
            { "TC", "\u0422\u0451\u0440\u043a\u0441 \u0430, \u041a\u0430\u0439\u043a\u043e\u0441 \u0430 \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "TD", "\u0427\u0430\u0434" },
            { "TF", "\u0424\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d \u043a\u044a\u0438\u043b\u0431\u0430 \u043b\u0430\u0442\u0442\u0430\u043d\u0430\u0448" },
            { "TG", "\u0422\u043e\u0433\u043e" },
            { "TH", "\u0422\u0430\u0438\u043b\u0430\u043d\u0434" },
            { "TJ", "\u0422\u0430\u0434\u0436\u0438\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "TK", "\u0422\u043e\u043a\u0435\u043b\u0430\u0443" },
            { "TL", "\u041c\u0430\u043b\u0445\u0431\u0430\u043b\u0435\u043d \u0422\u0438\u043c\u043e\u0440" },
            { "TM", "\u0422\u0443\u0440\u043a\u043c\u0435\u043d\u0438" },
            { "TN", "\u0422\u0443\u043d\u0438\u0441" },
            { "TO", "\u0422\u043e\u043d\u0433\u0430" },
            { "TR", "\u0422\u0443\u0440\u043a\u043e\u0439\u0447\u043e\u044c" },
            { "TT", "\u0422\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0430, \u0422\u043e\u0431\u0430\u0433\u043e \u0430" },
            { "TV", "\u0422\u0443\u0432\u0430\u043b\u0443" },
            { "TW", "\u0422\u0430\u0439\u0432\u0430\u043d\u044c" },
            { "TZ", "\u0422\u0430\u043d\u0437\u0430\u043d\u0438" },
            { "UA", "\u0423\u043a\u0440\u0430\u0438\u043d\u0430" },
            { "UG", "\u0423\u0433\u0430\u043d\u0434\u0430" },
            { "UM", "\u0410\u0426\u0428\u043d \u0430\u0440\u0430\u0445\u044c\u0430\u0440\u0430 \u043a\u0435\u0433\u0438\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448" },
            { "UN", "\u0412\u043e\u0432\u0448\u0430\u0445\u043a\u0445\u0435\u0442\u0442\u0430 \u041a\u044a\u0430\u044c\u043c\u043d\u0438\u0439\u043d \u041e\u0440\u0433\u0430\u043d\u0438\u0437\u0430\u0446\u0438" },
            { "US", "\u0426\u0445\u044c\u0430\u043d\u0430\u0442\u043e\u044c\u0445\u043d\u0430 \u0428\u0442\u0430\u0442\u0430\u0448" },
            { "UY", "\u0423\u0440\u0443\u0433\u0432\u0430\u0439" },
            { "UZ", "\u0423\u0437\u0431\u0435\u043a\u0438\u0441\u0442\u0430\u043d" },
            { "VA", "\u0412\u0430\u0442\u0438\u043a\u0430\u043d" },
            { "VC", "\u0421\u0435\u043d\u0442-\u0412\u0438\u043d\u0441\u0435\u043d\u0442 \u0430, \u0413\u0440\u0435\u043d\u0430\u0434\u0438\u043d\u0430\u0448 \u0430" },
            { "VE", "\u0412\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0430" },
            { "VG", "\u0412\u0438\u0440\u0433\u0438\u043d\u0438\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448 (\u0411\u0440\u0438\u0442\u0430\u043d\u0438)" },
            { "VI", "\u0412\u0438\u0440\u0433\u0438\u043d\u0438\u0439\u043d \u0433\u04c0\u0430\u0439\u0440\u0435\u043d\u0430\u0448 (\u0410\u0426\u0428)" },
            { "VN", "\u0412\u044c\u0435\u0442\u043d\u0430\u043c" },
            { "VU", "\u0412\u0430\u043d\u0443\u0430\u0442\u0443" },
            { "WF", "\u0423\u043e\u043b\u043b\u0438\u0441 \u0430, \u0424\u0443\u0442\u0443\u043d\u0430 \u0430" },
            { "WS", "\u0421\u0430\u043c\u043e\u0430" },
            { "XK", "\u041a\u043e\u0441\u043e\u0432\u043e" },
            { "YE", "\u0419\u0435\u043c\u0435\u043d" },
            { "YT", "\u041c\u0430\u0439\u043e\u0442\u0442\u0430" },
            { "ZA", "\u041a\u044a\u0438\u043b\u0431\u0430-\u0410\u0444\u0440\u0438\u043a\u0438\u043d \u0420\u0435\u0441\u043f\u0443\u0431\u043b\u0438\u043a\u0430" },
            { "ZM", "\u0417\u0430\u043c\u0431\u0438" },
            { "ZW", "\u0417\u0438\u043c\u0431\u0430\u0431\u0432\u0435" },
            { "ZZ", "\u0419\u043e\u044c\u0432\u0437\u0443\u0448 \u0439\u043e\u0446\u0443 \u0440\u0435\u0433\u0438\u043e\u043d" },
            { "aa", "\u0430\u0444\u0430\u0440\u0438\u0439\u043d" },
            { "ab", "\u0430\u0431\u0445\u0430\u0437\u0445\u043e\u0439\u043d" },
            { "af", "\u0430\u0444\u0440\u0438\u043a\u0430\u0430\u043d\u0441" },
            { "ak", "\u0430\u043a\u0430\u043d" },
            { "am", "\u0430\u043c\u0445\u0430\u0440\u043e\u0439\u043d" },
            { "an", "\u0430\u0440\u0430\u0433\u043e\u043d\u043e\u0439\u043d" },
            { "ar", metaValue_ar },
            { "as", "\u0430\u0441\u0441\u0430\u043c\u0438\u0439\u043d" },
            { "av", "\u0441\u0443\u044c\u0439\u043b\u0438\u0439\u043d" },
            { "ay", "\u0430\u0439\u043c\u0430\u0440\u0430" },
            { "az", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0434\u0436\u0430\u043d\u0438\u0439\u043d" },
            { "ba", "\u0431\u0430\u0448\u043a\u0438\u0440\u0438\u0439\u043d" },
            { "be", "\u0431\u0435\u043b\u043e\u0440\u0443\u0441\u0438\u0439\u043d" },
            { "bg", "\u0431\u043e\u043b\u0433\u0430\u0440\u0438\u0439\u043d" },
            { "bi", "\u0431\u0438\u0441\u043b\u0430\u043c\u0430" },
            { "bm", "\u0431\u0430\u043c\u0431\u0430\u0440\u0430" },
            { "bn", "\u0431\u0435\u043d\u0433\u0430\u043b\u0438\u0439\u043d" },
            { "bo", metaValue_bo },
            { "br", "\u0431\u0440\u0435\u0442\u043e\u043d\u0438\u0439\u043d" },
            { "bs", "\u0431\u043e\u0441\u043d\u0438\u0439\u043d" },
            { "ca", "\u043a\u0430\u0442\u0430\u043b\u043e\u043d\u0438\u0439\u043d" },
            { "ce", "\u043d\u043e\u0445\u0447\u0438\u0439\u043d" },
            { "ch", "\u0447\u0430\u043c\u043e\u0440\u0440\u043e" },
            { "co", "\u043a\u043e\u0440\u0441\u0438\u043a\u0430\u043d\u0438\u0439\u043d" },
            { "cs", "\u0447\u0435\u0445\u0438\u0439\u043d" },
            { "cu", "\u043a\u0438\u043b\u0441\u0441\u043b\u0430\u0432\u044f\u043d\u0438\u0439\u043d" },
            { "cv", "\u0447\u0443\u0432\u0430\u0448\u0438\u0439\u043d" },
            { "cy", "\u0432\u0430\u043b\u043b\u0438\u0439\u043d" },
            { "da", "\u0434\u0430\u0442\u0445\u043e\u0439\u043d" },
            { "de", "\u043d\u0435\u043c\u0446\u043e\u0439\u043d" },
            { "dv", "\u043c\u0430\u043b\u044c\u0434\u0438\u0432\u0438\u0439\u043d" },
            { "dz", "\u0434\u0437\u043e\u043d\u0433-\u043a\u044d" },
            { "ee", "\u044d\u0432\u0435" },
            { "el", metaValue_el },
            { "en", "\u0438\u043d\u0433\u0430\u043b\u0441\u0430\u043d" },
            { "eo", "\u044d\u0441\u043f\u0435\u0440\u0430\u043d\u0442\u043e" },
            { "es", "\u0438\u0441\u043f\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "et", "\u044d\u0441\u0442\u043e\u043d\u0438\u0439\u043d" },
            { "eu", "\u0431\u0430\u0441\u043a\u0438\u0439\u043d" },
            { "fa", metaValue_fa },
            { "ff", "\u0444\u0443\u043b\u0430\u0445" },
            { "fi", "\u0444\u0438\u043d\u043d\u0438\u0439\u043d" },
            { "fj", "\u0444\u0438\u0434\u0436\u0438" },
            { "fo", "\u0444\u0430\u0440\u0435\u0440\u0438\u0439\u043d" },
            { "fr", "\u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d" },
            { "fy", "\u043c\u0430\u043b\u0445\u0431\u0443\u0437\u0435\u043d-\u0444\u0440\u0438\u0437\u0438\u0439\u043d" },
            { "ga", "\u0438\u0440\u043b\u0430\u043d\u0434\u0445\u043e\u0439\u043d" },
            { "gd", "\u0433\u044d\u043b\u0438\u0439\u043d" },
            { "gl", "\u0433\u0430\u043b\u0438\u0441\u0438\u0439\u043d" },
            { "gn", "\u0433\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "gu", metaValue_gu },
            { "gv", "\u043c\u044d\u043d\u0438\u0439\u043d" },
            { "ha", "\u0445\u0430\u0443\u0441\u0430" },
            { "he", metaValue_he },
            { "hi", "\u0445\u04c0\u0438\u043d\u0434\u0438" },
            { "hr", "\u0445\u043e\u0440\u0432\u0430\u0442\u0438\u0439\u043d" },
            { "ht", "\u0433\u0430\u0438\u0442\u0438\u0439\u043d" },
            { "hu", "\u0432\u0435\u043d\u0433\u0440\u0438\u0439\u043d" },
            { "hy", metaValue_hy },
            { "hz", "\u0433\u0435\u0440\u0435\u0440\u043e" },
            { "ia", "\u0438\u043d\u0442\u0435\u0440\u043b\u0438\u043d\u0433\u0432\u0430" },
            { "id", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438\u0445\u043e\u0439\u043d" },
            { "ig", "\u0438\u0433\u0431\u043e" },
            { "ii", "\u0441\u044b\u0447\u0443\u0430\u043d\u044c" },
            { "io", "\u0438\u0434\u043e" },
            { "is", "\u0438\u0441\u043b\u0430\u043d\u0434\u0445\u043e\u0439\u043d" },
            { "it", "\u0438\u0442\u0430\u043b\u044c\u044f\u043d\u0438\u0439\u043d" },
            { "iu", "\u0438\u043d\u0443\u043a\u0442\u0438\u0442\u0443\u0442" },
            { "ja", metaValue_ja },
            { "jv", "\u044f\u0432\u0430\u043d\u0438\u0439\u043d" },
            { "ka", metaValue_ka },
            { "ki", "\u043a\u0438\u043a\u0443\u0439\u044e" },
            { "kj", "\u043a\u0443\u043d\u0430\u043c\u0430" },
            { "kk", "\u043a\u0445\u0430\u0437\u0430\u043a\u0445\u0438\u0439\u043d" },
            { "kl", "\u0433\u0440\u0435\u043d\u043b\u0430\u043d\u0434\u0445\u043e\u0439\u043d" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u043a\u0430\u043d\u0443\u0440\u0438" },
            { "ks", "\u043a\u0430\u0448\u043c\u0438\u0440\u0438" },
            { "ku", "\u043a\u0443\u0440\u0434\u0438\u0439\u043d" },
            { "kv", "\u043a\u043e\u043c\u0438\u0439\u043d" },
            { "kw", "\u043a\u043e\u0440\u043d\u0443\u043e\u043b\u043b\u0438\u0439\u043d" },
            { "ky", "\u0433\u04c0\u0438\u0440\u0433\u04c0\u0438\u0437\u043e\u0439\u043d" },
            { "la", metaValue_la },
            { "lb", "\u043b\u044e\u043a\u0441\u0435\u043c\u0431\u0443\u0440\u0433\u0445\u043e\u0439\u043d" },
            { "lg", "\u0433\u0430\u043d\u0434\u0430" },
            { "li", "\u043b\u0438\u043c\u0431\u0443\u0440\u0433\u0438\u0439\u043d" },
            { "ln", "\u043b\u0438\u043d\u0433\u0430\u043b\u0430" },
            { "lo", metaValue_lo },
            { "lt", "\u043b\u0438\u0442\u0432\u0430\u0445\u043e\u0439\u043d" },
            { "lu", "\u043b\u0443\u0431\u0430-\u043a\u0430\u0442\u0430\u043d\u0433\u0430" },
            { "lv", "\u043b\u0430\u0442\u044b\u0448\u0438\u0439\u043d" },
            { "mg", "\u043c\u0430\u043b\u0430\u0433\u0430\u0441\u0438\u0439\u043d" },
            { "mh", "\u043c\u0430\u0440\u0448\u0430\u043b\u043b\u0438\u0439\u043d" },
            { "mi", "\u043c\u0430\u043e\u0440\u0438" },
            { "mk", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0445\u043e\u0439\u043d" },
            { "ml", "\u043c\u0430\u043b\u0430\u044f\u043b\u0430\u043c" },
            { "mn", metaValue_mn },
            { "mr", "\u043c\u0430\u0440\u0430\u0442\u0445\u0438" },
            { "ms", "\u043c\u0430\u043b\u0430\u0439\u043d" },
            { "mt", "\u043c\u0430\u043b\u044c\u0442\u043e\u0439\u043d" },
            { "my", "\u0431\u0438\u0440\u043c\u0430\u043d\u0438\u0439\u043d" },
            { "na", "\u043d\u0430\u0443\u0440\u0443" },
            { "nb", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438\u0439\u043d \u0431\u0443\u043a\u043c\u043e\u043b" },
            { "nd", "\u043a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u043d\u0434\u0435\u0431\u0435\u043b\u0438" },
            { "ne", "\u043d\u0435\u043f\u0430\u043b\u0445\u043e\u0439\u043d" },
            { "ng", "\u043d\u0434\u043e\u043d\u0433\u0430" },
            { "nl", "\u0433\u043e\u043b\u043b\u0430\u043d\u0434\u0445\u043e\u0439\u043d" },
            { "nn", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438\u0439\u043d \u043d\u044e\u043d\u043e\u0440\u0441\u043a" },
            { "nr", "\u043a\u044a\u0438\u043b\u0431\u0430 \u043d\u0434\u0435\u0431\u0435\u043b\u0435" },
            { "nv", "\u043d\u0430\u0432\u0430\u0445\u043e" },
            { "ny", "\u043d\u044c\u044f\u043d\u0434\u0436\u0430" },
            { "oc", "\u043e\u043a\u0441\u0438\u0442\u0430\u043d\u043e\u0439\u043d" },
            { "om", "\u043e\u0440\u043e\u043c\u043e" },
            { "or", metaValue_or },
            { "os", "\u0445\u04c0\u0438\u0440\u0438\u0439\u043d" },
            { "pa", "\u043f\u0430\u043d\u0434\u0436\u0430\u0431\u0438" },
            { "pl", "\u043f\u043e\u043b\u044f\u043a\u0438\u0439\u043d" },
            { "ps", "\u043f\u0443\u0448\u0442\u0443" },
            { "pt", "\u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u0445\u043e\u0439\u043d" },
            { "qu", "\u043a\u0435\u0447\u0443\u0430" },
            { "rm", "\u0440\u043e\u043c\u0430\u043d\u0448\u0438\u0439\u043d" },
            { "rn", "\u0440\u0443\u043d\u0434\u0438" },
            { "ro", "\u0440\u0443\u043c\u044b\u043d\u0438\u0439\u043d" },
            { "ru", "\u043e\u044c\u0440\u0441\u0438\u0439\u043d" },
            { "rw", "\u043a\u0438\u043d\u044c\u044f\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "sa", "\u0441\u0430\u043d\u0441\u043a\u0440\u0438\u0442" },
            { "sc", "\u0441\u0430\u0440\u0434\u0438\u043d\u0438\u0439\u043d" },
            { "sd", "\u0441\u0438\u043d\u0434\u0445\u0438" },
            { "se", "\u043a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0441\u0430\u0430\u043c\u0438\u0439\u043d" },
            { "sg", "\u0441\u0430\u043d\u0433\u043e" },
            { "si", metaValue_si },
            { "sk", "\u0441\u043b\u043e\u0432\u0430\u043a\u0438\u0439\u043d" },
            { "sl", "\u0441\u043b\u043e\u0432\u0435\u043d\u0438\u0439\u043d" },
            { "sm", "\u0441\u0430\u043c\u043e\u0430\u043d\u043e\u0439\u043d" },
            { "sn", "\u0448\u043e\u043d\u0430" },
            { "so", "\u0441\u043e\u043c\u0430\u043b\u0438" },
            { "sq", "\u0430\u043b\u0431\u0430\u043d\u043e\u0439\u043d" },
            { "sr", "\u0441\u0435\u0440\u0431\u0438\u0439\u043d" },
            { "ss", "\u0441\u0432\u0430\u0437\u0438" },
            { "st", "\u043a\u044a\u0438\u043b\u0431\u0430 \u0441\u043e\u0442\u043e" },
            { "su", "\u0441\u0443\u043d\u0434\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "sv", "\u0448\u0432\u0435\u0434\u0438\u0439\u043d" },
            { "sw", "\u0441\u0443\u0430\u0445\u0438\u043b\u0438" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u0442\u0430\u0434\u0436\u0438\u043a\u0438\u0439\u043d" },
            { "th", metaValue_th },
            { "ti", "\u0442\u0438\u0433\u0440\u0438\u043d\u044c\u044f" },
            { "tk", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d\u0438\u0439\u043d" },
            { "tn", "\u0442\u0441\u0432\u0430\u043d\u0430" },
            { "to", "\u0442\u043e\u043d\u0433\u0430\u043d\u0438\u0439\u043d" },
            { "tr", "\u0442\u0443\u0440\u043a\u043e\u0439\u043d" },
            { "ts", "\u0442\u0441\u043e\u043d\u0433\u0430" },
            { "tt", "\u0433\u04c0\u0435\u0437\u0430\u043b\u043e\u0439\u043d" },
            { "ty", "\u0442\u0430\u0438\u0442\u044f\u043d\u043e\u0439\u043d" },
            { "ug", "\u0443\u0439\u0433\u0443\u0440\u0438\u0439\u043d" },
            { "uk", "\u0443\u043a\u0440\u0430\u0438\u043d\u0438\u0439\u043d" },
            { "ur", "\u0443\u0440\u0434\u0443" },
            { "uz", "\u0443\u0437\u0431\u0435\u043a\u0438\u0439\u043d" },
            { "ve", "\u0432\u0435\u043d\u0434\u0430" },
            { "vi", "\u0432\u044c\u0435\u0442\u043d\u0430\u043c\u0445\u043e\u0439\u043d" },
            { "vo", "\u0432\u043e\u043b\u0430\u043f\u044e\u043a" },
            { "wa", "\u0432\u0430\u043b\u043b\u043e\u043d\u043e\u0439\u043d" },
            { "wo", "\u0432\u043e\u043b\u043e\u0444" },
            { "xh", "\u043a\u043e\u0441\u0430" },
            { "yi", "\u0438\u0434\u0438\u0448" },
            { "yo", "\u0439\u043e\u0440\u0443\u0431\u0430" },
            { "zh", "\u0446\u0438\u0439\u043d" },
            { "zu", "\u0437\u0443\u043b\u0443" },
            { "ace", "\u0430\u0447\u0435\u0445\u0438\u0439\u043d" },
            { "ada", "\u0430\u0434\u0430\u043d\u0433\u043c\u0435" },
            { "ady", "\u0430\u0434\u0438\u0433\u0435\u0439\u043d" },
            { "agq", "\u0430\u0433\u0445\u04c0\u0435\u043c" },
            { "ain", "\u0430\u0439\u043d\u0438\u0439\u043d" },
            { "ale", "\u0430\u043b\u0435\u0443\u0442\u0438\u0439\u043d" },
            { "alt", "\u043a\u044a\u0438\u043b\u0431\u0430 \u0430\u043b\u0442\u0430\u0439\u043d" },
            { "anp", "\u0430\u043d\u0433\u0438\u043a\u0430" },
            { "arn", "\u0430\u0440\u0430\u0443\u043a\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "arp", "\u0430\u0440\u0430\u043f\u0430\u0445\u043e" },
            { "asa", "\u0430\u0441\u0443" },
            { "ast", "\u0430\u0441\u0442\u0443\u0440\u0438\u0439\u043d" },
            { "awa", "\u0430\u0432\u0430\u0434\u0445\u0438" },
            { "ban", "\u0431\u0430\u043b\u0438\u0439\u043d" },
            { "bas", "\u0431\u0430\u0441\u0430" },
            { "bem", "\u0431\u0435\u043c\u0431\u0430" },
            { "bez", "\u0431\u0435\u043d\u0430" },
            { "bgn", "\u043c\u0430\u043b\u0445\u0431\u0443\u0437\u0435\u043d-\u0431\u0435\u043b\u0443\u0434\u0436\u0438\u0439\u043d" },
            { "bho", "\u0431\u0445\u043e\u0434\u0436\u043f\u0443\u0440\u0438" },
            { "bin", "\u0431\u0438\u043d\u0438" },
            { "bla", "\u0441\u0438\u043a\u0441\u0438\u043a\u0430" },
            { "brx", "\u0431\u043e\u0434\u043e" },
            { "bug", "\u0431\u0443\u0433\u0438\u0439\u043d" },
            { "byn", "\u0431\u0438\u043b\u0438\u0439\u043d" },
            { "ceb", "\u0441\u0435\u0431\u0443\u0430\u043d\u043e" },
            { "cgg", "\u0447\u0438\u0433\u0430" },
            { "chk", "\u0447\u0443\u043a\u0447\u0438\u0439\u043d" },
            { "chm", "\u043c\u0430\u0440\u0438\u0439\u043d" },
            { "cho", "\u0447\u043e\u043a\u0442\u0430\u0432\u0438\u0439\u043d" },
            { "chr", "\u0447\u0435\u0440\u043e\u043a\u0438" },
            { "chy", "\u0448\u0430\u0439\u0435\u043d\u0438\u0439\u043d" },
            { "ckb", "\u044e\u043a\u043a\u044a\u0435\u0440\u0447\u0443 \u043a\u0443\u0440\u0434\u0438\u0439\u043d" },
            { "crs", "\u0441\u0435\u0439\u0448\u0435\u043b\u0438\u0439\u043d \u043a\u0440\u0435\u043e\u043b\u0438\u0439\u043d" },
            { "dak", "\u0434\u0430\u043a\u043e\u0442\u0430" },
            { "dar", "\u0434\u0430\u044c\u0440\u0433\u04c0\u043e\u0439\u043d" },
            { "dav", "\u0442\u0430\u0438\u0442\u0430" },
            { "dgr", "\u0434\u043e\u0433\u0440\u0438\u0431" },
            { "dje", "\u0437\u0430\u0440\u043c\u0430" },
            { "dsb", "\u0441\u043e\u0440\u0431\u0438\u0439\u043d" },
            { "dua", "\u0434\u0443\u0430\u043b\u0430" },
            { "dyo", "\u0434\u044c\u043e\u043b\u0430-\u0444\u043e\u043d\u044c\u0438" },
            { "dzg", "\u0434\u0430\u0437\u0430" },
            { "ebu", "\u044d\u043c\u0431\u0443" },
            { "efi", "\u044d\u0444\u0438\u043a" },
            { "eka", "\u044d\u043a\u0430\u0434\u0436\u0443\u043a" },
            { "ewo", "\u044d\u0432\u043e\u043d\u0434\u043e" },
            { "fil", "\u0444\u0438\u043b\u0438\u043f\u043f\u0438\u043d\u0438\u0439\u043d" },
            { "fon", "\u0444\u043e\u043d" },
            { "fur", "\u0444\u0440\u0438\u0443\u043b\u0438\u0439\u043d" },
            { "gaa", "\u0433\u0430" },
            { "gag", "\u0433\u0430\u0433\u0430\u0443\u0437\u0438\u0439\u043d" },
            { "gez", "\u0433\u0435\u044d\u0437" },
            { "gil", "\u0433\u0438\u043b\u044c\u0431\u0435\u0440\u0442\u0438\u0439\u043d" },
            { "gor", "\u0433\u043e\u0440\u043e\u043d\u0442\u0430\u043b\u043e" },
            { "gsw", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u043d \u043d\u0435\u043c\u0446\u043e\u0439\u043d" },
            { "guz", "\u0433\u0443\u0441\u0438\u0438" },
            { "gwi", "\u0433\u0432\u0438\u0447\u0438\u043d" },
            { "haw", "\u0433\u0430\u0432\u0430\u0439\u043d" },
            { "hil", "\u0445\u0438\u043b\u0438\u0433\u0430\u0439\u043d\u043e\u043d" },
            { "hmn", "\u0445\u043c\u043e\u043d\u0433" },
            { "hsb", "\u043b\u0430\u043a\u0445\u0430\u0440\u0430 \u0441\u0435\u0440\u0431\u0438\u0439\u043d" },
            { "hup", "\u0445\u0443\u043f\u0430" },
            { "iba", "\u0438\u0431\u0430\u043d\u0438\u0439\u043d" },
            { "ibb", "\u0438\u0431\u0438\u0431\u0438\u043e" },
            { "ilo", "\u0438\u043b\u043e\u043a\u043e" },
            { "inh", "\u0433\u04c0\u0430\u043b\u0433\u04c0\u0430\u0439\u043d" },
            { "jbo", "\u043b\u043e\u0436\u0431\u0430\u043d" },
            { "jgo", "\u043d\u0433\u043e\u043c\u0431\u0430" },
            { "jmc", "\u043c\u0430\u0447\u0430\u043c\u0435" },
            { "kab", "\u043a\u0430\u0431\u0438\u043b\u0438\u0439\u043d" },
            { "kac", "\u043a\u0430\u0447\u0438\u043d\u0438\u0439\u043d" },
            { "kaj", "\u043a\u0430\u0434\u0436\u0438" },
            { "kam", "\u043a\u0430\u043c\u0431\u0430" },
            { "kbd", "\u0433\u04c0\u0435\u0431\u0430\u0440\u0442\u043e\u0439\u043d" },
            { "kcg", "\u0442\u044c\u044f\u043f" },
            { "kde", "\u043c\u0430\u043a\u043e\u043d\u0434\u0435" },
            { "kea", "\u043a\u0430\u0431\u0443\u0432\u0435\u0440\u0434\u044c\u044f\u043d\u0443" },
            { "kfo", "\u043a\u043e\u0440\u043e" },
            { "kha", "\u043a\u0445\u0430\u0441\u0438" },
            { "khq", "\u043a\u043e\u0439\u0440\u0430 \u0447\u0438\u0438\u043d\u0438" },
            { "kkj", "\u043a\u0430\u043a\u043e" },
            { "kln", "\u043a\u0430\u043b\u0435\u043d\u0434\u0436\u0438\u043d" },
            { "kmb", "\u043a\u0438\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "koi", "\u043a\u043e\u043c\u0438-\u043f\u0435\u0440\u043c\u044f\u043a\u0438\u0439\u043d" },
            { "kok", "\u043a\u043e\u043d\u043a\u0430\u043d\u0438" },
            { "kpe", "\u043a\u043f\u0435\u043b\u043b\u0435" },
            { "krc", "\u043a\u0445\u0430\u0440\u0430\u0447\u043e\u0439\u043d-\u0431\u0430\u043b\u043a\u0445\u0430\u0440\u043e\u0439\u043d" },
            { "krl", "\u043a\u0430\u0440\u0435\u043b\u0438\u0439\u043d" },
            { "kru", "\u043a\u0443\u0440\u0443\u0445" },
            { "ksb", "\u0448\u0430\u043c\u0431\u0430\u043b\u0430" },
            { "ksf", "\u0431\u0430\u0444\u0438\u0430" },
            { "ksh", "\u043a\u043e\u044c\u043b\u043d\u0438\u0439\u043d" },
            { "kum", "\u0433\u04c0\u0443\u043c\u043a\u0438\u0439\u043d" },
            { "lad", "\u043b\u0430\u0434\u0438\u043d\u043e" },
            { "lag", "\u043b\u0430\u043d\u0433\u0438" },
            { "lez", "\u043b\u0430\u044c\u0437\u0433\u0438\u0439\u043d" },
            { "lkt", "\u043b\u0430\u043a\u043e\u0442\u0430" },
            { "loz", "\u043b\u043e\u0437\u0438" },
            { "lrc", "\u043a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u043b\u0443\u0440\u0438" },
            { "lua", "\u043b\u0443\u0431\u0430-\u043b\u0443\u043b\u0443\u0430" },
            { "lun", "\u043b\u0443\u043d\u0434\u0430" },
            { "luo", "\u043b\u0443\u043e (\u041a\u0435\u043d\u0438 \u0430, \u0422\u0430\u043d\u0437\u0430\u043d\u0438 \u0430)" },
            { "lus", "\u043b\u0443\u0448\u0435\u0439" },
            { "luy", "\u043b\u0443\u0445\u044c\u044f" },
            { "mad", "\u043c\u0430\u0434\u0443\u0440\u0438\u0439\u043d" },
            { "mag", "\u043c\u0430\u0433\u0430\u0445\u0438" },
            { "mai", "\u043c\u0430\u0439\u0442\u0445\u0438\u043b\u0438" },
            { "mak", "\u043c\u0430\u043a\u0430\u0441\u0430\u0440\u0438\u0439\u043d" },
            { "mas", "\u043c\u0430\u0441\u0430\u0438" },
            { "mdf", "\u043c\u043e\u043a\u0448\u0430\u043d\u043e\u0439\u043d" },
            { "men", "\u043c\u0435\u043d\u0434\u0435" },
            { "mer", "\u043c\u0435\u0440\u0443" },
            { "mfe", "\u043c\u0430\u0432\u0440\u0438\u043a\u0438\u043d \u043a\u0440\u0435\u043e\u043b\u0438\u0439\u043d" },
            { "mgh", "\u043c\u0430\u043a\u0443\u0430-\u043c\u0435\u0435\u0442\u0442\u043e" },
            { "mgo", "\u043c\u0435\u0442\u0430" },
            { "mic", "\u043c\u0438\u043a\u043c\u0430\u043a" },
            { "min", "\u043c\u0438\u043d\u0430\u043d\u0433\u043a\u0430\u0431\u0430\u0443" },
            { "mni", "\u043c\u0430\u043d\u0438\u043f\u0443\u0440\u0438\u0439\u043d" },
            { "moh", "\u043c\u043e\u0445\u0430\u0443\u043a" },
            { "mos", "\u043c\u043e\u0441\u0438" },
            { "mua", "\u043c\u0443\u043d\u0434\u0430\u043d\u0433" },
            { "mul", "\u0442\u0430\u0439\u043f-\u0442\u0430\u0439\u043f\u0430 \u0434\u043e\u044c\u0437\u0430\u043b\u0430\u043d \u043c\u0435\u0442\u0442\u0430\u043d\u0430\u0448" },
            { "mus", "\u043a\u0440\u0438\u043a" },
            { "mwl", "\u043c\u0438\u0440\u0430\u043d\u0434\u043e\u0439\u043d" },
            { "myv", "\u044d\u0440\u0437\u044f\u043d\u0438\u0439\u043d" },
            { "mzn", "\u043c\u0430\u0437\u0430\u043d\u0434\u0435\u0440\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "nap", "\u043d\u0435\u0430\u043f\u043e\u043b\u0438\u0442\u0430\u043d\u043e\u0439\u043d" },
            { "naq", "\u043d\u0430\u043c\u0430" },
            { "nds", "\u043b\u0430\u0445\u0430\u0440\u0430 \u0433\u0435\u0440\u043c\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "new", "\u043d\u0435\u0432\u0430\u0440\u043e\u0439\u043d" },
            { "nia", "\u043d\u0438\u0430\u0441" },
            { "niu", "\u043d\u0438\u0443\u044d" },
            { "nmg", "\u043a\u0432\u0430\u0441\u0438\u043e" },
            { "nnh", "\u043d\u0433\u0438\u0435\u043c\u0431\u0443\u043d\u0434" },
            { "nog", "\u043d\u043e\u0433\u04c0\u0438\u0439\u043d" },
            { "nqo", "\u043d\u043a\u043e" },
            { "nso", "\u043a\u044a\u0438\u043b\u0431\u0430\u0441\u0435\u0434\u0430 \u0441\u043e\u0442\u043e" },
            { "nus", "\u043d\u0443\u044d\u0440" },
            { "nyn", "\u043d\u044c\u044f\u043d\u043a\u043e\u043b\u0435" },
            { "pag", "\u043f\u0430\u043d\u0433\u0430\u0441\u0438\u043d\u0430\u043d" },
            { "pam", "\u043f\u0430\u043c\u043f\u0430\u043d\u0433\u0430" },
            { "pap", "\u043f\u0430\u043f\u044c\u044f\u043c\u0435\u043d\u0442\u043e" },
            { "pau", "\u043f\u0430\u043b\u0430\u0443" },
            { "pcm", "\u043d\u0438\u0433\u0435\u0440\u0438\u0439\u043d-\u043a\u0440\u0435\u043e\u043b\u0438\u0439\u043d" },
            { "prg", "\u043f\u0440\u0443\u0441\u0441\u0438\u0439\u043d" },
            { "quc", "\u043a\u0438\u0447\u0435" },
            { "rap", "\u0440\u0430\u043f\u0430\u043d\u0443\u0439\u043d" },
            { "rar", "\u0440\u0430\u0440\u043e\u0442\u043e\u043d\u0433\u0430" },
            { "rof", "\u0440\u043e\u043c\u0431\u043e" },
            { "rup", "\u0430\u0440\u0443\u043c\u0438\u043d\u0438\u0439\u043d" },
            { "rwk", "\u0440\u0443\u0430\u043d\u0434\u0430" },
            { "sad", "\u0441\u0430\u043d\u0434\u0430\u0432\u0435" },
            { "sah", "\u044f\u043a\u0443\u0442\u0438\u0439\u043d" },
            { "saq", "\u0441\u0430\u043c\u0431\u0443\u0440\u0443" },
            { "sat", "\u0441\u0430\u043d\u0442\u0430\u043b\u0438" },
            { "sba", "\u043d\u0433\u0430\u043c\u0431\u0430\u0439\u043d" },
            { "sbp", "\u0441\u0430\u043d\u0433\u0443" },
            { "scn", "\u0441\u0438\u0446\u0438\u043b\u0438\u0439\u043d" },
            { "sco", "\u0448\u043e\u0442\u043b\u0430\u043d\u0434\u0445\u043e\u0439\u043d" },
            { "seh", "\u0441\u0435\u043d\u0430" },
            { "ses", "\u043a\u043e\u0439\u0440\u0430\u0431\u043e\u0440\u043e \u0441\u0435\u043d\u043d\u0438" },
            { "shi", "\u0442\u0430\u0445\u0435\u043b\u0445\u0438\u0442" },
            { "shn", "\u0448\u0430\u043d\u043e\u0439\u043d" },
            { "sma", "\u0441\u0430\u0430\u043c\u0438\u0439\u043d (\u043a\u044a\u0438\u043b\u0431\u0430)" },
            { "smj", "\u043b\u0443\u043b\u0435-\u0441\u0430\u0430\u043c\u0438\u0439\u043d" },
            { "smn", "\u0438\u043d\u0430\u0440\u0438-\u0441\u0430\u0430\u043c\u0438\u0439\u043d" },
            { "sms", "\u0441\u043a\u043e\u043b\u044c\u0442-\u0441\u0430\u0430\u043c\u0438\u0439\u043d" },
            { "snk", "\u0441\u043e\u043d\u0438\u043d\u043a\u0435" },
            { "srn", "\u0441\u0440\u0430\u043d\u0430\u043d-\u0442\u043e\u043d\u0433\u043e" },
            { "ssy", "\u0441\u0430\u0445\u043e" },
            { "suk", "\u0441\u0443\u043a\u0443\u043c\u0430" },
            { "swb", "\u043a\u043e\u043c\u043e\u0440\u0438\u0439\u043d" },
            { "syr", "\u0448\u0435\u043c\u0430\u0445\u043e\u0439\u043d" },
            { "tem", "\u0442\u0435\u043c\u043d\u0435" },
            { "teo", "\u0442\u0435\u0441\u043e" },
            { "tet", "\u0442\u0435\u0442\u0443\u043c" },
            { "tig", "\u0442\u0438\u0433\u0440\u0435" },
            { "tlh", "\u043a\u043b\u0438\u043d\u0433\u043e\u043d\u0438\u043d" },
            { "tpi", "\u0442\u043e\u043a-\u043f\u0438\u0441\u0438\u043d" },
            { "trv", "\u0441\u0435\u0434\u0435\u043a\u043e\u0439\u043d" },
            { "tum", "\u0442\u0443\u043c\u0431\u0443\u043a\u0430" },
            { "tvl", "\u0442\u0443\u0432\u0430\u043b\u0443" },
            { "twq", "\u0442\u0430\u0441\u0430\u0432\u0430\u043a" },
            { "tyv", "\u0442\u0443\u0432\u0438\u043d\u0438\u0439\u043d" },
            { "tzm", "\u0442\u0430\u043c\u0430\u0437\u0438\u0433\u0445\u0442\u0438\u0439\u043d" },
            { "udm", "\u0443\u0434\u043c\u0443\u0440\u0442\u0438\u0439\u043d" },
            { "umb", "\u0443\u043c\u0431\u0443\u043d\u0434\u0443" },
            { "und", "\u0431\u043e\u044c\u0432\u0437\u0443\u0448 \u0431\u043e\u0446\u0443 \u043c\u043e\u0442\u0442" },
            { "vai", "\u0432\u0430\u0438" },
            { "vun", "\u0432\u0443\u043d\u0434\u0436\u043e" },
            { "wae", "\u0432\u0430\u043b\u043b\u0438\u0441\u0438\u0439\u043d" },
            { "wal", "\u0432\u043e\u043b\u0430\u043c\u043e" },
            { "war", "\u0432\u0430\u0440\u0430\u0439" },
            { "wbp", "\u0432\u0430\u0440\u043b\u043f\u0438\u0440\u0438" },
            { "xal", "\u0433\u04c0\u0430\u043b\u043c\u0430\u043a\u0445\u043e\u0439\u043d" },
            { "xog", "\u0441\u043e\u0433\u0430" },
            { "yav", "\u044f\u043d\u0433\u0431\u0435\u043d" },
            { "ybb", "\u0439\u0435\u043c\u0431\u0430" },
            { "yue", "\u043a\u0430\u043d\u0442\u043e\u043d\u0438\u0439\u043d" },
            { "zgh", "\u043c\u043e\u0440\u043e\u043a\u043a\u043e\u043d \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u0430\u043d \u0442\u0430\u043c\u0430\u0437\u0438\u0433\u0445\u0442\u0438\u0439\u043d" },
            { "zun", "\u0437\u0443\u043d\u044c\u0438" },
            { "zxx", "\u043c\u0435\u0442\u0442\u0430\u043d \u0447\u0443\u043b\u0430\u0446\u0430\u043c \u0431\u043e\u0446\u0443\u0448" },
            { "zza", "\u0437\u0430\u0437\u0430" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Beng", "\u0431\u0435\u043d\u0433\u0430\u043b\u0445\u043e\u0439\u043d" },
            { "Bopo", "\u0431\u043e\u043f\u043e\u043c\u043e\u0444\u043e" },
            { "Brai", "\u0431\u0440\u0430\u0439\u043b\u044f" },
            { "Cyrl", "\u043a\u0438\u0440\u0438\u043b\u043b\u0438\u0446\u0430" },
            { "Deva", "\u0434\u0435\u0432\u0430\u043d\u0430\u0433\u0430\u0440\u0438" },
            { "Ethi", "\u044d\u0444\u0438\u043e\u043f\u0438\u043d" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "\u0433\u0443\u0440\u043c\u0443\u043a\u0445\u0438" },
            { "Hanb", "\u0445\u0430\u043d\u044c\u0431" },
            { "Hang", "\u0445\u0430\u043d\u0433\u044b\u043b\u044c" },
            { "Hani", "\u043a\u0438\u0442\u0430\u0439\u043d" },
            { "Hans", "\u0430\u0442\u0442\u0430 \u043a\u0438\u0442\u0430\u0439\u043d" },
            { "Hant", "\u043b\u0430\u043c\u0430\u0441\u0442\u0430\u043d \u043a\u0438\u0442\u0430\u0439\u043d" },
            { "Hebr", metaValue_he },
            { "Hira", "\u0445\u0438\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "Hrkt", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430 \u044f \u0445\u0438\u0440\u0430\u0433\u0430\u043d\u0430" },
            { "Jamo", "\u0434\u0436\u0430\u043c\u043e" },
            { "Jpan", metaValue_ja },
            { "Kana", "\u043a\u0430\u0442\u0430\u043a\u0430\u043d\u0430" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", "\u043c\u0430\u043b\u0430\u044f\u043b\u0438\u0439\u043d" },
            { "Mong", metaValue_mn },
            { "Mymr", "\u043c\u044c\u044f\u043d\u043c\u0430\u043d\u0438\u0439\u043d" },
            { "Orya", metaValue_or },
            { "Sinh", metaValue_si },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Thaa", "\u0442\u0430\u0430\u043d\u0430" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Zmth", "\u043c\u0430\u0442\u0435\u043c\u0430\u0442\u0438\u043a\u0430\u043d \u043c\u0430\u044c\u04c0\u043d\u0430" },
            { "Zsye", "\u044d\u043c\u043e\u0434\u0437\u0438" },
            { "Zsym", "\u0441\u0438\u043c\u0432\u043e\u043b\u0430\u0448" },
            { "Zxxx", "\u0439\u043e\u0437\u0430 \u0434\u043e\u0446\u0443" },
            { "Zyyy", "\u043c\u0430\u0441\u0441\u0430\u0440\u0430 \u0430 \u0442\u04c0\u0435\u044d\u0446\u043d\u0430" },
            { "Zzzz", "\u0434\u043e\u044c\u0432\u0437\u0443\u0448 \u0434\u043e\u0446\u0443 \u0439\u043e\u0437\u0430" },
            { "de_AT", "\u0430\u0432\u0441\u0442\u0440\u0438\u043d \u043d\u0435\u043c\u0446\u043e\u0439\u043d" },
            { "de_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u043d \u043b\u0438\u0442\u0435\u0440\u0430\u0442\u0443\u0440\u0438\u043d \u043d\u0435\u043c\u0446\u043e\u0439\u043d" },
            { "en_AU", "\u0410\u0432\u0441\u0442\u0440\u0430\u043b\u0438\u043d \u0438\u043d\u0433\u0430\u043b\u0441\u0430\u043d" },
            { "en_CA", "\u043a\u0430\u043d\u0430\u0434\u0430\u043d \u0438\u043d\u0433\u0430\u043b\u0441\u0430\u043d" },
            { "en_GB", "\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u043d \u0438\u043d\u0433\u0430\u043b\u0441\u0430\u043d" },
            { "en_US", "\u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d \u0438\u043d\u0433\u0430\u043b\u0441\u0430\u043d" },
            { "es_ES", "\u0435\u0432\u0440\u043e\u043f\u0430\u043d \u0438\u0441\u043f\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "es_MX", "\u043c\u0435\u043a\u0441\u0438\u043a\u0430\u043d \u0438\u0441\u043f\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "fr_CA", "\u043a\u0430\u043d\u0430\u0434\u0430\u043d \u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d" },
            { "fr_CH", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u0438\u043d \u0444\u0440\u0430\u043d\u0446\u0443\u0437\u0438\u0439\u043d" },
            { "nl_BE", "\u0444\u043b\u0430\u043c\u0430\u043d\u0434\u0438\u0439\u043d" },
            { "pt_BR", "\u0431\u0440\u0430\u0437\u0438\u043b\u0438\u043d \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u0445\u043e\u0439\u043d" },
            { "pt_PT", "\u0435\u0432\u0440\u043e\u043f\u0430\u043d \u043f\u043e\u0440\u0442\u0443\u0433\u0430\u043b\u0438\u0445\u043e\u0439\u043d" },
            { "ro_MD", "\u043c\u043e\u043b\u0434\u0430\u0432\u0438\u0439\u043d" },
            { "sw_CD", "\u0441\u0443\u0430\u0445\u0438\u043b\u0438 (\u041a\u043e\u043d\u0433\u043e)" },
            { "ar_001", "\u0425\u04c0\u0438\u043d\u0446\u0430 \u0431\u043e\u043b\u0443 \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u0430\u043d \u04c0\u0430\u044c\u0440\u0431\u0438\u0439\u043d" },
            { "es_419", "\u043b\u0430\u0442\u0438\u043d\u0430\u043d \u0430\u043c\u0435\u0440\u0438\u043a\u0430\u043d \u0438\u0441\u043f\u0430\u043d\u0445\u043e\u0439\u043d" },
            { "key.ca", "\u041a\u0430\u043b\u0435\u043d\u0434\u0430\u0440\u044c" },
            { "key.cu", "\u0430\u0445\u0447\u0430" },
            { "nds_NL", "\u043b\u0430\u0445\u0430\u0440\u0430 \u0441\u0430\u043a\u0441\u043e\u043d\u0438\u0439\u043d" },
            { "zh_Hans", "\u0430\u0442\u0442\u0430 \u0446\u0438\u0439\u043d" },
            { "zh_Hant", "\u043b\u0430\u043c\u0430\u0441\u0442\u0430\u043d \u0446\u0438\u0439\u043d" },
            { "type.ca.persian", metaValue_fa },
            { "type.ca.japanese", metaValue_ja },
            { "type.ca.gregorian", "\u0433\u0440\u0438\u0433\u043e\u0440\u0438\u0430\u043d\u0430\u043d" },
        };
        return data;
    }
}
