/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_chr extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_AZ = "\u13a0\u13ce\u13c6\u13e3\u13c2";
        final String metaValue_JP = "\u13e3\u13e9\u13c2\u13cf";
        final String metaValue_KG = "\u13a9\u13b5\u13e3\u13a2\u13cd";
        final String metaValue_NR = "\u13c3\u13a4\u13b7";
        final String metaValue_NP = "\u13c1\u13c6\u13b5";
        final String metaValue_SO = "\u13d0\u13b9\u13b5";
        final String metaValue_ML = "\u13b9\u13b5";
        final String metaValue_TV = "\u13da\u13e9\u13b7";
        final String metaValue_hy = "\u13a0\u13b3\u13bb\u13a0\u13c2";
        final String metaValue_ccp = "\u13e3\u13a7\u13b9";
        final String metaValue_chr = "\u13e3\u13b3\u13a9";
        final String metaValue_ka = "\u13e6\u13e5\u13a0\u13c2";
        final String metaValue_gu = "\u13ab\u13e3\u13b3\u13d8";
        final String metaValue_km = "\u13a9\u13bb\u13b7";
        final String metaValue_kn = "\u13a7\u13be\u13d3";
        final String metaValue_ko = "\u13aa\u13b5\u13a0\u13c2";
        final String metaValue_lo = "\u13b3\u13a3";
        final String metaValue_la = "\u13b3\u13d8\u13c2";
        final String metaValue_ml = "\u13b9\u13b3\u13ef\u13b3\u13bb";
        final String metaValue_mn = "\u13b9\u13c2\u13aa\u13b5\u13a0\u13c2";
        final String metaValue_nqo = "\u13be\u13aa";
        final String metaValue_or = "\u13a3\u13d7\u13a0";
        final String metaValue_ta = "\u13d4\u13bb\u13b5";
        final String metaValue_te = "\u13d6\u13b7\u13a6";
        final String metaValue_bo = "\u13d8\u13c7\u13d4\u13c2";
        final String metaValue_vai = "\u13e9\u13f1";
        final Object[][] data = new Object[][] {
            { "001", "\u13a1\u13b6\u13af" },
            { "002", "\u13ac\u13bf\u13a8\u13cd\u13db" },
            { "003", "\u13e7\u13f4\u13e2 \u13a0\u13b9\u13f0\u13df" },
            { "005", "\u13e7\u13a6\u13c3\u13ee \u13a0\u13ba\u13b5\u13a6" },
            { "009", "\u13a3\u13cf\u13f0\u13c2\u13a0" },
            { "011", "\u13ed\u13d5\u13b5\u13ac \u13d7\u13dc \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "013", "\u13a0\u13f0\u13df \u13a0\u13b9\u13f0\u13df" },
            { "014", "\u13d7\u13a7\u13b8\u13ac \u13d7\u13dc \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "015", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "017", "\u13a0\u13f0\u13df \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "018", "\u13e7\u13a6\u13be\u13ee \u13d7\u13dc \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "019", "\u13a0\u13ba\u13b5\u13a6\u13a2" },
            { "021", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13a0\u13b9\u13f0\u13df" },
            { "029", "\u13a8\u13c6\u13d9\u13ef" },
            { "030", "\u13d7\u13a7\u13b8\u13ac \u13d7\u13dc \u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "034", "\u13e7\u13a6\u13be\u13ee \u13d7\u13dc \u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "035", "\u13e7\u13a6\u13be\u13ee \u13d7\u13a7\u13b8\u13ac \u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "039", "\u13e7\u13a6\u13be\u13ee \u13d7\u13dc \u13f3\u13b3\u13db" },
            { "053", "\u13a0\u13cd\u13d4\u13b4\u13cf\u13a0" },
            { "054", "\u13ba\u13b3\u13c1\u13cf\u13a0" },
            { "057", "\u13a0\u13f0\u13df \u13e7\u13be\u13b5\u13aa\u13af \u13be\u13bf \u13b9\u13a2\u13c9\u13c2\u13cf\u13ef \u13a2\u13ac\u13be\u13d5\u13be" },
            { "061", "\u13c6\u13b5\u13c2\u13cf\u13a0" },
            { "142", "\u13d3\u13b6\u13be\u13a8\u13cd\u13db" },
            { "143", "\u13a0\u13f0\u13df \u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "145", "\u13ed\u13d5\u13b5\u13ac \u13d7\u13dc \u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "150", "\u13f3\u13b3\u13db" },
            { "151", "\u13d7\u13a7\u13b8\u13ac \u13d7\u13dc \u13f3\u13b3\u13db" },
            { "154", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13f3\u13b3\u13db" },
            { "155", "\u13ed\u13d5\u13b5\u13ac \u13d7\u13dc \u13f3\u13b3\u13db" },
            { "202", "\u13ad\u13eb\u13c2-\u13cc\u13ad\u13e9 \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "419", "\u13b3\u13d8\u13c2 \u13a0\u13b9\u13f0\u13df" },
            { "AC", "\u13a4\u13b5\u13cc\u13b3\u13d3\u13c5 \u13a4\u13a6\u13da\u13db\u13a2" },
            { "AD", "\u13a0\u13c2\u13d9\u13b3" },
            { "AE", "\u13cc\u13ca \u13a2\u13f3\u13be\u13b5\u13cd\u13d4\u13c5 \u13a1\u13b3\u13c8 \u13a2\u13b9\u13b5\u13d8\u13cf" },
            { "AF", "\u13a0\u13eb\u13a8\u13c2\u13cd\u13d6\u13c2" },
            { "AG", "\u13a4\u13ea\u13d8 & \u13c6\u13ca\u13d3" },
            { "AI", "\u13a0\u13c2\u13a9\u13b3" },
            { "AL", "\u13a0\u13b5\u13c7\u13c2\u13ef" },
            { "AM", "\u13a0\u13b5\u13bb\u13c2\u13a0" },
            { "AO", "\u13a0\u13c2\u13aa\u13b3" },
            { "AQ", "\u13e7\u13c1\u13cd\u13d3\u13b8" },
            { "AR", "\u13a0\u13e5\u13c2\u13d8\u13c2\u13a0" },
            { "AS", "\u13a0\u13ba\u13b5\u13a7 \u13cc\u13bc\u13a0" },
            { "AT", "\u13a0\u13cd\u13df\u13ef" },
            { "AU", "\u13a1\u13b3\u13d7\u13dc" },
            { "AW", "\u13a0\u13b7\u13c6" },
            { "AX", "\u13a3\u13b4\u13c5\u13d3 \u13da\u13a6\u13da\u13db\u13a2" },
            { "AZ", metaValue_AZ },
            { "BA", "\u13c9\u13cf\u13c2\u13a0 & \u13b2\u13e4\u13aa\u13eb\u13be" },
            { "BB", "\u13c6\u13c7\u13d9\u13cd" },
            { "BD", "\u13c6\u13c2\u13a6\u13b5\u13d5\u13cd" },
            { "BE", "\u13c7\u13b5\u13e5\u13a5\u13bb" },
            { "BF", "\u13cb\u13a9\u13be \u13e9\u13d0" },
            { "BG", "\u13ca\u13b5\u13a8\u13b5\u13a0" },
            { "BH", "\u13c6\u13ad\u13b4\u13a2\u13c2" },
            { "BI", "\u13cb\u13b7\u13c2\u13d7" },
            { "BJ", "\u13c6\u13c2\u13a2\u13c2" },
            { "BL", "\u13a4\u13d3\u13c5\u13d8 \u13c6\u13d5\u13b3\u13bb" },
            { "BM", "\u13c6\u13ca\u13d3" },
            { "BN", "\u13ca\u13be\u13a2" },
            { "BO", "\u13c9\u13b5\u13eb\u13a0" },
            { "BQ", "\u13a7\u13b5\u13c8\u13a2\u13c2\u13af \u13be\u13cd\u13a9\u13c1\u13db\u13b3\u13c2" },
            { "BR", "\u13c6\u13cf\u13b5" },
            { "BS", "\u13be\u13cd\u13a9 \u13c6\u13ad\u13b9\u13cd" },
            { "BT", "\u13ca\u13d4\u13c2" },
            { "BV", "\u13ca\u13ea \u13a4\u13a6\u13da\u13db\u13a2" },
            { "BW", "\u13c6\u13e3\u13e9\u13be" },
            { "BY", "\u13c7\u13b3\u13b7\u13cd" },
            { "BZ", "\u13c7\u13b5\u13cd" },
            { "CA", "\u13a8\u13be\u13d3" },
            { "CC", "\u13aa\u13aa\u13cd (\u13a9\u13b5\u13c2) \u13da\u13a6\u13da\u13db\u13a2" },
            { "CD", "\u13a7\u13c2\u13aa - \u13a8\u13c2\u13dd\u13cc" },
            { "CF", "\u13ac\u13bf\u13a8\u13cd\u13db \u13a0\u13f0\u13df \u13cd\u13a6\u13da\u13a9" },
            { "CG", "\u13a7\u13c2\u13aa - \u13c6\u13cc\u13e9\u13b5" },
            { "CH", "\u13cd\u13eb\u13cd" },
            { "CI", "\u13a2\u13ec\u13b5 \u13be\u13bf \u13a0\u13b9\u13f3\u13b6\u13d7" },
            { "CK", "\u13a0\u13d3\u13cd\u13d3\u13f4\u13b2\u13cd\u13a9 \u13da\u13a6\u13da\u13db\u13a2" },
            { "CL", "\u13e5\u13b5" },
            { "CM", "\u13a7\u13b9\u13b7\u13c2" },
            { "CN", "\u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "CO", "\u13aa\u13b8\u13bb\u13c8\u13a2\u13a0" },
            { "CP", "\u13a6\u13c2\u13f4\u13d4\u13c5\u13a3\u13d3\u13b8 \u13a4\u13a6\u13da\u13db\u13a2" },
            { "CR", "\u13aa\u13cd\u13d3 \u13b5\u13a7" },
            { "CU", "\u13ab\u13c6" },
            { "CV", "\u13a2\u13ac\u13be\u13d5\u13be \u13a2\u13e4\u13f3\u13cd\u13d7" },
            { "CW", "\u13ab\u13b3\u13a8\u13a3" },
            { "CX", "\u13d3\u13c2\u13cd\u13d3\u13f2\u13af\u13b2 \u13a4\u13a6\u13da\u13db\u13a2" },
            { "CY", "\u13cc\u13a2\u13c6\u13cd" },
            { "CZ", "\u13e4\u13a9\u13a0" },
            { "DE", "\u13a0\u13c2\u13db\u13e5" },
            { "DG", "\u13d7\u13f0\u13aa \u13a6\u13cf\u13ef" },
            { "DJ", "\u13e5\u13ca\u13d7" },
            { "DK", "\u13d7\u13c2\u13b9\u13a6" },
            { "DM", "\u13d9\u13bb\u13c2\u13a7" },
            { "DO", "\u13d9\u13bb\u13c2\u13a7\u13c2 \u13cd\u13a6\u13da\u13a9" },
            { "DZ", "\u13a0\u13b5\u13e5\u13b5\u13ef" },
            { "EA", "\u13d1\u13d4 \u13a0\u13b4 \u13ba\u13b5\u13ef" },
            { "EC", "\u13a1\u13c6\u13d9\u13b5" },
            { "EE", "\u13a1\u13cd\u13d9\u13c2\u13ef" },
            { "EG", "\u13a2\u13e5\u13c8\u13a2" },
            { "EH", "\u13ed\u13d5\u13b5\u13ac \u13d7\u13dc \u13cc\u13ae\u13b3" },
            { "ER", "\u13a1\u13b5\u13df\u13ef" },
            { "ES", "\u13a0\u13c2\u13cd\u13c6\u13c2\u13f1" },
            { "ET", "\u13a2\u13d7\u13a3\u13c8\u13a0" },
            { "EU", "\u13f3\u13b3\u13db \u13a0\u13c2\u13a4\u13be\u13d3\u13e1\u13ac" },
            { "EZ", "\u13f3\u13b6\u13a0\u13cd\u13d3\u13c5\u13c5" },
            { "FI", "\u13eb\u13c2\u13a6\u13d9\u13af" },
            { "FJ", "\u13eb\u13e5" },
            { "FK", "\u13e9\u13a9 \u13da\u13a6\u13da\u13db\u13a2" },
            { "FM", "\u13b9\u13a2\u13c9\u13c2\u13cf\u13ef" },
            { "FO", "\u13ea\u13b6 \u13da\u13a6\u13da\u13db\u13a2" },
            { "FR", "\u13a6\u13b8\u13e5\u13f1" },
            { "GA", "\u13a6\u13c9\u13c2" },
            { "GB", "\u13a9\u13b5\u13cf\u13f2" },
            { "GD", "\u13cb\u13be\u13d3" },
            { "GE", "\u13e3\u13a0\u13e5\u13a2" },
            { "GF", "\u13a0\u13c2\u13a6\u13b8\u13e5 \u13a9\u13a0" },
            { "GG", "\u13ac\u13c2\u13cf" },
            { "GH", "\u13a6\u13a0\u13be" },
            { "GI", "\u13e5\u13c6\u13b5\u13d3" },
            { "GL", "\u13a2\u13e4\u13cd\u13db\u13f1" },
            { "GM", "\u13a6\u13b9\u13c8\u13a2\u13a0" },
            { "GN", "\u13a9\u13a2\u13c2" },
            { "GP", "\u13e9\u13d3\u13b7\u13c7" },
            { "GQ", "\u13a1\u13c6\u13d9\u13b5\u13a0\u13b5 \u13a9\u13a2\u13c2" },
            { "GR", "\u13aa\u13a2\u13af" },
            { "GS", "\u13e7\u13a6\u13c3\u13ee \u13e3\u13a0\u13e5\u13a2 \u13a0\u13b4 \u13be\u13cd\u13a9 \u13e7\u13a6\u13c3\u13ee \u13a0\u13cd\u13db\u13ad\u13df \u13da\u13a6\u13da\u13db\u13a2" },
            { "GT", "\u13e9\u13d4\u13b9\u13b3" },
            { "GU", "\u13c6\u13bb" },
            { "GW", "\u13a9\u13a2\u13c2-\u13c8\u13cc\u13a4\u13eb" },
            { "GY", "\u13a6\u13ef\u13be" },
            { "HK", "\u13b0\u13c2\u13a9 \u13aa\u13c2\u13a9 \u13a4\u13d3\u13e4\u13b5\u13d3 \u13e7\u13c2\u13b8\u13eb\u13cd\u13d3\u13c1\u13d7 \u13a2\u13ac\u13be\u13d5\u13be \u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "HM", "\u13b2\u13d7 \u13a4\u13a6\u13da\u13db\u13a2 \u13a0\u13b4 \u13ba\u13a9\u13d3\u13be\u13b5\u13d7 \u13da\u13a6\u13da\u13db\u13a2" },
            { "HN", "\u13ad\u13c2\u13da\u13b3\u13cd" },
            { "HR", "\u13a7\u13b6\u13a1\u13cf\u13a0" },
            { "HT", "\u13ae\u13a2\u13d8" },
            { "HU", "\u13b2\u13c2\u13a6\u13b5" },
            { "IC", "\u13e5\u13cd\u13c6 \u13da\u13a6\u13da\u13db\u13a2" },
            { "ID", "\u13a2\u13c2\u13d9\u13c2\u13cd\u13ef" },
            { "IE", "\u13a0\u13f2\u13b3\u13c2" },
            { "IL", "\u13a2\u13cf\u13b5\u13f1" },
            { "IM", "\u13a4\u13cd\u13d7 \u13a4\u13a6\u13da\u13db\u13a2 \u13be\u13bf \u13a0\u13cd\u13a6\u13ef" },
            { "IN", "\u13a2\u13c5\u13d7\u13be" },
            { "IO", "\u13c8\u13d7\u13cf \u13f4\u13eb\u13ef \u13a0\u13ba\u13c9 \u13a2\u13ac\u13be\u13d5\u13c5" },
            { "IQ", "\u13a2\u13b3\u13a9" },
            { "IR", "\u13a2\u13b4\u13c2" },
            { "IS", "\u13e7\u13c1\u13cd\u13d3\u13b8\u13af" },
            { "IT", "\u13a2\u13d4\u13b5" },
            { "JE", "\u13e8\u13b5\u13cf" },
            { "JM", "\u13e3\u13ba\u13a2\u13a7" },
            { "JO", "\u13e6\u13d3\u13c2" },
            { "JP", metaValue_JP },
            { "KE", "\u13a8\u13c2\u13ef" },
            { "KG", metaValue_KG },
            { "KH", "\u13a7\u13b9\u13c9\u13d7\u13a0\u13c2" },
            { "KI", "\u13a7\u13b5\u13c6\u13d8" },
            { "KM", "\u13aa\u13bc\u13b3\u13cd" },
            { "KN", "\u13a4\u13d3\u13c5\u13d8 \u13a8\u13d8\u13cf \u13a0\u13b4 \u13c1\u13ea\u13cf" },
            { "KP", "\u13e7\u13f4\u13e2 \u13aa\u13b5\u13a0" },
            { "KR", "\u13e7\u13a6\u13c3\u13ee \u13aa\u13b5\u13a0" },
            { "KW", "\u13ab\u13ea\u13a2\u13d8" },
            { "KY", "\u13a8\u13a2\u13b9\u13c2 \u13da\u13a6\u13da\u13db\u13a2" },
            { "KZ", "\u13a7\u13ce\u13a7\u13cd\u13d5\u13c2" },
            { "LA", "\u13b4\u13a3\u13cd" },
            { "LB", "\u13b4\u13c6\u13be\u13c2" },
            { "LC", "\u13a4\u13d3\u13c5\u13d8 \u13b7\u13cf\u13ef" },
            { "LI", "\u13b5\u13a6\u13d7\u13c2\u13cd\u13d3\u13c2" },
            { "LK", "\u13cd\u13b5 \u13b3\u13c2\u13a7" },
            { "LR", "\u13b3\u13c8\u13b5\u13ef" },
            { "LS", "\u13b4\u13d0\u13d9" },
            { "LT", "\u13b5\u13d7\u13ea\u13c2\u13a0" },
            { "LU", "\u13b8\u13a7\u13ce\u13cb\u13a9" },
            { "LV", "\u13b3\u13d8\u13eb\u13a0" },
            { "LY", "\u13b5\u13c8\u13ef" },
            { "MA", "\u13bc\u13b6\u13aa" },
            { "MC", "\u13b9\u13be\u13aa" },
            { "MD", "\u13b9\u13b5\u13d9\u13eb\u13a0" },
            { "ME", "\u13bc\u13c2\u13d4\u13c1\u13a6\u13b6" },
            { "MF", "\u13a4\u13d3\u13c5\u13d8 \u13e1\u13e1" },
            { "MG", "\u13b9\u13d3\u13a6\u13cd\u13a7\u13b5" },
            { "MH", "\u13b9\u13cc\u13b5 \u13da\u13a6\u13da\u13db\u13a2" },
            { "MK", "\u13e7\u13f4\u13dc \u13b9\u13ce\u13d9\u13c2\u13ef" },
            { "ML", metaValue_ML },
            { "MM", "\u13b9\u13ef\u13b9\u13b5 (\u13c7\u13b5\u13b9)" },
            { "MN", "\u13b9\u13c2\u13aa\u13b5\u13a0" },
            { "MO", "\u13b9\u13a7\u13a3 (\u13a4\u13d3\u13e4\u13b5\u13d3 \u13e7\u13c2\u13b8\u13eb\u13cd\u13d3\u13c1\u13d7 \u13a2\u13ac\u13be\u13d5\u13be) \u13e3\u13a2" },
            { "MP", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13b9\u13b5\u13a0\u13be \u13da\u13a6\u13da\u13db\u13a2" },
            { "MQ", "\u13b9\u13d8\u13c2\u13a8" },
            { "MR", "\u13b9\u13d8\u13a2\u13ef" },
            { "MS", "\u13b9\u13c2\u13d8\u13cc\u13b3\u13d7" },
            { "MT", "\u13b9\u13b5\u13d4" },
            { "MU", "\u13bc\u13b5\u13cf\u13a5\u13cd" },
            { "MV", "\u13b9\u13b5\u13d7\u13eb\u13cd" },
            { "MW", "\u13b9\u13b3\u13eb" },
            { "MX", "\u13a0\u13c2\u13cd\u13c6\u13c2" },
            { "MY", "\u13b9\u13b4\u13cf\u13a2\u13a0" },
            { "MZ", "\u13bc\u13ce\u13bb\u13c7\u13a9" },
            { "NA", "\u13be\u13bb\u13c8\u13a2\u13ef" },
            { "NC", "\u13a2\u13e4 \u13a7\u13b5\u13d9\u13c2\u13a0\u13c2" },
            { "NE", "\u13be\u13a2\u13e8" },
            { "NF", "\u13c3\u13b5\u13ec\u13b5\u13a9 \u13a4\u13a6\u13da\u13db\u13a2" },
            { "NG", "\u13c2\u13e5\u13b5\u13ef" },
            { "NI", "\u13c2\u13a7\u13b3\u13c6" },
            { "NL", "\u13c1\u13db\u13b3\u13c2" },
            { "NO", "\u13c3\u13ea" },
            { "NP", metaValue_NP },
            { "NR", metaValue_NR },
            { "NU", "\u13c2\u13f3" },
            { "NZ", "\u13a2\u13e4 \u13cf\u13a2\u13b4\u13c2\u13d7" },
            { "OM", "\u13a3\u13ba\u13c2" },
            { "PA", "\u13c6\u13be\u13b9" },
            { "PE", "\u13c7\u13b7" },
            { "PF", "\u13a0\u13c2\u13a6\u13b8\u13e5 \u13c6\u13b5\u13c2\u13cf\u13a0" },
            { "PG", "\u13c6\u13c7 \u13a2\u13e4 \u13a9\u13a2\u13c2" },
            { "PH", "\u13a0\u13c2\u13c8\u13b5\u13a9\u13c3" },
            { "PK", "\u13c6\u13a9\u13cd\u13d6\u13c2" },
            { "PL", "\u13c9\u13b3\u13c2" },
            { "PM", "\u13a4\u13d3\u13c5\u13d8 \u13c8\u13f0 \u13a0\u13b4 \u13bb\u13c7\u13b6\u13c2" },
            { "PN", "\u13c8\u13a7\u13b5\u13c2 \u13da\u13a6\u13da\u13db\u13a2" },
            { "PR", "\u13c7\u13a1\u13d9 \u13b5\u13a2\u13aa" },
            { "PS", "\u13c6\u13b4\u13cd\u13d7\u13c2\u13a0\u13c2 \u13c4\u13ac\u13eb\u13f3\u13cc\u13d5\u13a9" },
            { "PT", "\u13c9\u13e5\u13a6\u13b3" },
            { "PW", "\u13c6\u13b4\u13a0\u13eb" },
            { "PY", "\u13c6\u13b3\u13c7\u13a2\u13ef" },
            { "QA", "\u13a7\u13d4\u13b5" },
            { "QO", "\u13a0\u13cd\u13db \u13a3\u13cf\u13f0\u13c2\u13a0" },
            { "RE", "\u13b4\u13f3\u13c2\u13a0\u13c2" },
            { "RO", "\u13b6\u13b9\u13c2\u13ef" },
            { "RS", "\u13d2\u13c8\u13ef" },
            { "RU", "\u13f2\u13c2\u13a2" },
            { "RW", "\u13b6\u13e9\u13c2\u13d3" },
            { "SA", "\u13cc\u13a4\u13d7 \u13a1\u13b4\u13c8\u13a0" },
            { "SB", "\u13d0\u13b6\u13b9\u13c2 \u13da\u13a6\u13da\u13db\u13a2" },
            { "SC", "\u13cf\u13a1\u13e5\u13b5\u13cd" },
            { "SD", "\u13d1\u13d5\u13c2" },
            { "SE", "\u13cd\u13eb\u13d5\u13c2" },
            { "SG", "\u13cf\u13c2\u13a6\u13c9\u13b5" },
            { "SH", "\u13a4\u13d3\u13c5\u13d8 \u13ae\u13b5\u13be" },
            { "SI", "\u13cd\u13b6\u13eb\u13c2\u13a0" },
            { "SJ", "\u13cd\u13e9\u13b5\u13c6\u13b5\u13d7 \u13a0\u13b4 \u13e4\u13c2 \u13b9\u13f0\u13c2" },
            { "SK", "\u13cd\u13b6\u13e9\u13a9\u13a0" },
            { "SL", "\u13cf\u13a1\u13b3 \u13b4\u13a3\u13c2" },
            { "SM", "\u13a4\u13d3\u13c5\u13d8 \u13b9\u13b5\u13a2\u13c3" },
            { "SN", "\u13cf\u13c2\u13a6\u13b5" },
            { "SO", metaValue_SO },
            { "SR", "\u13d2\u13b5\u13be\u13bb" },
            { "SS", "\u13e7\u13a6\u13be\u13ee \u13d1\u13d5\u13c2" },
            { "ST", "\u13cc\u13a3 \u13d9\u13ba \u13a0\u13b4 \u13c8\u13c2\u13cf\u13c7" },
            { "SV", "\u13a1\u13b5\u13cc\u13b5\u13c6\u13d9\u13b5" },
            { "SX", "\u13cf\u13c2\u13d8 \u13b9\u13d8\u13c2" },
            { "SY", "\u13cf\u13b5\u13a0" },
            { "SZ", "\u13a1\u13cd\u13e9\u13d8\u13c2" },
            { "TA", "\u13df\u13cd\u13db\u13c2 \u13d3 \u13ab\u13be\u13ad" },
            { "TC", "\u13a0\u13c2\u13db\u13b5\u13a9 \u13a0\u13b4 \u13a8\u13a2\u13aa \u13da\u13a6\u13da\u13db\u13a2" },
            { "TD", "\u13e3\u13d7" },
            { "TF", "\u13a0\u13c2\u13a6\u13b8\u13e5 \u13e7\u13a6\u13be\u13ee \u13a6\u13d9\u13af \u13a4\u13b5\u13cd\u13db\u13a2" },
            { "TG", "\u13d9\u13aa" },
            { "TH", "\u13d4\u13ef\u13b4\u13c2" },
            { "TJ", "\u13d4\u13e5\u13a9\u13cd\u13d5\u13c2" },
            { "TK", "\u13d9\u13a8\u13b3\u13ed" },
            { "TL", "\u13d8\u13bc\u13b5-\u13b4\u13cd\u13d6" },
            { "TM", "\u13db\u13b5\u13a9\u13ba\u13c2\u13cd\u13d4\u13c2" },
            { "TN", "\u13da\u13c2\u13cf\u13cd\u13a0" },
            { "TO", "\u13d9\u13be\u13a6" },
            { "TR", "\u13ac\u13c3" },
            { "TT", "\u13df\u13c2\u13d5\u13d7 \u13a0\u13b4 \u13d9\u13c6\u13aa" },
            { "TV", metaValue_TV },
            { "TW", "\u13d4\u13a2\u13e9\u13c2" },
            { "TZ", "\u13d6\u13c2\u13cf\u13c2\u13ef" },
            { "UA", "\u13f3\u13a7\u13b4\u13c2" },
            { "UG", "\u13f3\u13a6\u13c2\u13d3" },
            { "UM", "U.S. \u13a0\u13cd\u13db \u13da\u13a6\u13da\u13db\u13a2" },
            { "UN", "\u13cc\u13ca \u13a2\u13f3\u13be\u13b5\u13cd\u13d4\u13c5 \u13a0\u13f0\u13b5 \u13da\u13be\u13d9\u13e2\u13d2" },
            { "US", "\u13cc\u13ca \u13a2\u13f3\u13be\u13b5\u13cd\u13d4\u13c5 \u13cd\u13a6\u13da\u13a9" },
            { "UY", "\u13f3\u13b7\u13c7" },
            { "UZ", "\u13a4\u13cd\u13c7\u13a9\u13cd\u13d6\u13c2" },
            { "VA", "\u13a0\u13e5\u13b3\u13c1\u13e0 \u13a6\u13da\u13b2" },
            { "VC", "\u13a4\u13d3\u13c5\u13d8 \u13eb\u13c2\u13cf\u13c2\u13d7 \u13a0\u13b4 \u13be\u13cd\u13a9 \u13c7\u13be\u13d7\u13c1\u13cd" },
            { "VE", "\u13ea\u13c1\u13d1\u13ea\u13b3" },
            { "VG", "\u13c8\u13d7\u13cd \u13a0\u13d2\u13c2\u13b8 \u13c2\u13a8\u13d2\u13be \u13da\u13a6\u13da\u13db\u13a2" },
            { "VI", "U.S. \u13a0\u13d2\u13c2\u13b8 \u13c2\u13a8\u13d2\u13be \u13da\u13a6\u13da\u13db\u13a2" },
            { "VN", "\u13eb\u13a1\u13d8\u13be\u13bb" },
            { "VU", "\u13e9\u13c2\u13a4\u13e9\u13da" },
            { "WF", "\u13e9\u13b5\u13cd \u13a0\u13b4 \u13ca\u13da\u13be" },
            { "WS", "\u13cc\u13bc\u13a0" },
            { "XA", "\u13e1\u13d9-\u13c4\u13cd\u13db\u13a2\u13a5\u13a7\u13c1\u13ac\u13a2" },
            { "XB", "\u13e1\u13d9-\u13c8\u13d7" },
            { "XK", "\u13aa\u13d0\u13c9" },
            { "YE", "\u13f0\u13ba\u13c2" },
            { "YT", "\u13ba\u13ef\u13d6" },
            { "ZA", "\u13e7\u13a6\u13be\u13ee \u13ac\u13bf\u13a8\u13cd\u13db" },
            { "ZM", "\u13cc\u13bb\u13c8\u13ef" },
            { "ZW", "\u13cf\u13bb\u13c6\u13c7" },
            { "ZZ", "\u13c4\u13ec\u13b5\u13cd\u13db\u13be \u13a4\u13d4\u13c2\u13d7\u13a6\u13d9\u13af" },
            { "aa", "\u13a0\u13e9\u13b3" },
            { "ab", "\u13a0\u13c6\u13cf\u13a0\u13c2" },
            { "af", "\u13a0\u13ac\u13bf\u13a8\u13cd\u13db" },
            { "ak", "\u13a0\u13a7\u13be" },
            { "am", "\u13a0\u13b9\u13ad\u13b5\u13a9" },
            { "an", "\u13a0\u13e9\u13aa\u13c2\u13cf" },
            { "ar", "\u13a1\u13b3\u13c8" },
            { "as", "\u13a0\u13cc\u13bb\u13cf" },
            { "av", "\u13a0\u13e9\u13b5\u13a7" },
            { "ay", "\u13a0\u13f1\u13b9\u13b3" },
            { "az", metaValue_AZ },
            { "ba", "\u13c6\u13cd\u13af\u13a9\u13a0" },
            { "be", "\u13c7\u13b3\u13b7\u13cf" },
            { "bg", "\u13ca\u13b5\u13a8\u13b5\u13a0\u13c2" },
            { "bi", "\u13c8\u13cd\u13b3\u13b9" },
            { "bm", "\u13c6\u13bb\u13c6\u13b3" },
            { "bn", "\u13c7\u13c2\u13a6\u13b3" },
            { "bo", metaValue_bo },
            { "br", "\u13c7\u13d9\u13c2" },
            { "bs", "\u13c6\u13cd\u13c2\u13a0\u13c2" },
            { "ca", "\u13a8\u13d4\u13b3\u13c2" },
            { "ce", "\u13e4\u13e4\u13c2" },
            { "ch", "\u13e3\u13bc\u13b6" },
            { "co", "\u13aa\u13b5\u13cd\u13a2\u13a7\u13c2" },
            { "cs", "\u13e4\u13a9" },
            { "cu", "\u13e7\u13c2\u13b3\u13eb\u13cd\u13d7 \u13cd\u13b3\u13eb\u13aa" },
            { "cv", "\u13e7\u13e9\u13cf" },
            { "cy", "\u13ea\u13b5\u13cf" },
            { "da", "\u13d5\u13c2\u13cd" },
            { "de", "\u13d9\u13a2\u13e5" },
            { "dv", "\u13d7\u13ea\u13af" },
            { "dz", "\u13d3\u13d0\u13c5\u13a7" },
            { "ee", "\u13a1\u13ea" },
            { "el", "\u13a0\u13c2\u13aa\u13a2" },
            { "en", "\u13a9\u13b5\u13cf" },
            { "eo", "\u13a1\u13cd\u13c7\u13b3\u13c2\u13d9" },
            { "es", "\u13cd\u13c6\u13c2" },
            { "et", "\u13a1\u13cd\u13d9\u13c2\u13a0\u13c2" },
            { "eu", "\u13c6\u13cd\u13a8" },
            { "fa", "\u13c7\u13cf\u13a0\u13c2" },
            { "ff", "\u13ca\u13b3\u13c2" },
            { "fi", "\u13c8\u13c2\u13cd" },
            { "fj", "\u13eb\u13e5\u13a0\u13c2" },
            { "fo", "\u13c7\u13b6\u13a1\u13cd" },
            { "fr", "\u13a6\u13b8\u13e5" },
            { "fy", "\u13ed\u13d5\u13b5\u13ac \u13d7\u13dc \u13df\u13cf\u13a0\u13c2" },
            { "ga", "\u13a8\u13b5\u13a9" },
            { "gd", "\u13cd\u13a6\u13d7 \u13a8\u13b5\u13a9" },
            { "gl", "\u13a6\u13b5\u13cf\u13a0\u13c2" },
            { "gn", "\u13c6\u13b3\u13c2" },
            { "gu", metaValue_gu },
            { "gv", "\u13b9\u13be\u13a7\u13cf" },
            { "ha", "\u13ad\u13a4\u13cc" },
            { "he", "\u13a0\u13c2\u13c8\u13b7" },
            { "hi", "\u13af\u13c2\u13d7" },
            { "hr", "\u13a7\u13b6\u13a1\u13cf\u13c2" },
            { "ht", "\u13ae\u13cf\u13a0\u13c2 \u13df\u13f2\u13b5" },
            { "hu", "\u13b2\u13c2\u13a6\u13b5\u13a0\u13c2" },
            { "hy", metaValue_hy },
            { "hz", "\u13ae\u13b4\u13b6" },
            { "ia", "\u13a0\u13f0\u13df \u13a6\u13ec\u13c2\u13af\u13cd\u13d7" },
            { "id", "\u13a2\u13c2\u13d9\u13c2\u13cf\u13a0" },
            { "ig", "\u13a2\u13a6\u13aa" },
            { "ii", "\u13cf\u13e7\u13e9\u13c2 \u13f1" },
            { "io", "\u13a2\u13d9" },
            { "is", "\u13e7\u13c1\u13cd\u13d3\u13b8\u13af\u13a2\u13a9" },
            { "it", "\u13ac\u13e9\u13b5\u13f2\u13e5\u13a2" },
            { "iu", "\u13a2\u13c4\u13a6\u13d8\u13da" },
            { "ja", metaValue_JP },
            { "jv", "\u13c6\u13cc \u13e3\u13e9" },
            { "ka", metaValue_ka },
            { "ki", "\u13a9\u13ab\u13f3" },
            { "kj", "\u13ab\u13e9\u13c2\u13a0\u13b9" },
            { "kk", "\u13a7\u13cc\u13a7" },
            { "kl", "\u13a7\u13b3\u13b5\u13d1\u13d8" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "\u13a7\u13c4\u13b5" },
            { "ks", "\u13a7\u13cf\u13bb\u13b5" },
            { "ku", "\u13ab\u13d7\u13cf" },
            { "kv", "\u13aa\u13bb" },
            { "kw", "\u13ce\u13b7\u13ad" },
            { "ky", metaValue_KG },
            { "la", metaValue_la },
            { "lb", "\u13b8\u13a6\u13cf\u13bb\u13cb\u13a2\u13cd" },
            { "lg", "\u13a6\u13c2\u13d3" },
            { "li", "\u13b4\u13b9\u13ca\u13b5\u13cf" },
            { "ln", "\u13b5\u13c2\u13a6\u13b3" },
            { "lo", metaValue_lo },
            { "lt", "\u13b5\u13da\u13e9\u13c2\u13a0\u13c2" },
            { "lu", "\u13b7\u13c6-\u13a7\u13d4\u13a6" },
            { "lv", "\u13b3\u13d8\u13eb\u13a0\u13c2" },
            { "mg", "\u13b9\u13b3\u13a6\u13cf" },
            { "mh", "\u13b9\u13cc\u13b5\u13cf" },
            { "mi", "\u13b9\u13eb" },
            { "mk", "\u13b9\u13ce\u13d9\u13c2\u13a0\u13c2" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u13b9\u13b3\u13d8" },
            { "ms", "\u13b9\u13b4" },
            { "mt", "\u13b9\u13b5\u13d8\u13cd" },
            { "my", "\u13cb\u13bb\u13cd" },
            { "na", metaValue_NR },
            { "nb", "\u13c3\u13b5\u13ea\u13e5\u13c2 \u13c9\u13a7\u13b9\u13b5" },
            { "nd", "\u13e7\u13f4\u13e2 \u13c2\u13d5\u13c7\u13b4" },
            { "ne", metaValue_NP },
            { "ng", "\u13be\u13d9\u13a6" },
            { "nl", "\u13db\u13e5" },
            { "nn", "\u13c3\u13b5\u13ea\u13e5\u13c2 \u13be\u13b5\u13cd\u13a9" },
            { "no", "\u13c3\u13b5\u13ea\u13e5\u13c2" },
            { "nr", "\u13e7\u13a6\u13be\u13ee \u13c2\u13d5\u13c7\u13b4" },
            { "nv", "\u13be\u13e9\u13b0" },
            { "ny", "\u13c2\u13ef\u13c2\u13e3" },
            { "oc", "\u13a0\u13cf\u13d4\u13c2" },
            { "om", "\u13a3\u13b6\u13bc" },
            { "or", metaValue_or },
            { "os", "\u13a3\u13ce\u13d8\u13a7" },
            { "pa", "\u13e1\u13c2\u13e3\u13c8" },
            { "pl", "\u13c9\u13b5\u13cd" },
            { "ps", "\u13c6\u13cd\u13d9" },
            { "pt", "\u13c9\u13e7\u13a9\u13cd" },
            { "qu", "\u13a8\u13e7\u13e9" },
            { "rm", "\u13a0\u13c2\u13b6\u13ba\u13c2" },
            { "rn", "\u13b7\u13c2\u13d7" },
            { "ro", "\u13b6\u13b9\u13c2\u13a0\u13c2" },
            { "ru", "\u13f2\u13c5\u13af" },
            { "rw", "\u13a9\u13c2\u13ef\u13e9\u13c2\u13d3" },
            { "sa", "\u13cd\u13c2\u13cd\u13a9\u13d7" },
            { "sc", "\u13cc\u13d7\u13c2\u13a0\u13c2" },
            { "sd", "\u13cf\u13c2\u13d7" },
            { "se", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13cc\u13bb" },
            { "sg", "\u13cc\u13c2\u13aa" },
            { "si", "\u13cf\u13be\u13ad\u13b3" },
            { "sk", "\u13cd\u13b6\u13e9\u13a9" },
            { "sl", "\u13cd\u13b6\u13eb\u13c2\u13a0\u13c2" },
            { "sm", "\u13cc\u13bc\u13ef\u13c2" },
            { "sn", "\u13e0\u13be" },
            { "so", metaValue_SO },
            { "sq", "\u13a0\u13b5\u13c7\u13c2" },
            { "sr", "\u13d2\u13c8\u13a0\u13c2" },
            { "ss", "\u13cd\u13e9\u13d8" },
            { "st", "\u13e7\u13a6\u13be\u13ee \u13d7\u13dc \u13d0\u13e0" },
            { "su", "\u13d1\u13c2\u13d3\u13c2\u13cf" },
            { "sv", "\u13cd\u13eb\u13d7\u13cf" },
            { "sw", "\u13cd\u13e9\u13af\u13b5" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "\u13d4\u13e5\u13a9" },
            { "th", "\u13d4\u13f1" },
            { "ti", "\u13d8\u13a9\u13b5\u13c2\u13a0" },
            { "tk", "\u13a0\u13c2\u13ac\u13be" },
            { "tn", "\u13e7\u13e9\u13be" },
            { "to", "\u13d9\u13be\u13a6\u13c2" },
            { "tr", "\u13a0\u13ac\u13be" },
            { "ts", "\u13e6\u13be\u13a6" },
            { "tt", "\u13d4\u13d4" },
            { "ty", "\u13d4\u13af\u13d8\u13a0\u13c2" },
            { "ug", "\u13eb\u13a6" },
            { "uk", "\u13f3\u13a7\u13b4\u13c2\u13a0\u13c2" },
            { "ur", "\u13a4\u13b5\u13da" },
            { "uz", "\u13a4\u13cd\u13c7\u13a9" },
            { "ve", "\u13eb\u13c2\u13d3" },
            { "vi", "\u13eb\u13a1\u13d8\u13be\u13bb\u13cd" },
            { "vo", "\u13ec\u13b3\u13ca\u13a9" },
            { "wa", "\u13e9\u13b7\u13be" },
            { "wo", "\u13ec\u13b6\u13eb" },
            { "xh", "\u13e0\u13cc" },
            { "yi", "\u13f1\u13d7\u13cd" },
            { "yo", "\u13f2\u13c4\u13c6" },
            { "zh", "\u13d3\u13b6\u13c2\u13a8" },
            { "zu", "\u13d1\u13b7" },
            { "ace", "\u13a0\u13e5\u13c2\u13cf" },
            { "ada", "\u13a0\u13d3\u13be\u13a6\u13ba" },
            { "ady", "\u13a0\u13d7\u13a8" },
            { "agq", "\u13a0\u13a8\u13b9" },
            { "ain", "\u13a0\u13f1\u13c4" },
            { "ale", "\u13a0\u13b5\u13a4\u13d8" },
            { "alt", "\u13e7\u13a6\u13be\u13ee \u13d7\u13dc \u13a0\u13b5\u13d4\u13a2" },
            { "ann", "\u13a3\u13c9\u13b6" },
            { "anp", "\u13a0\u13be\u13a9\u13a7" },
            { "arn", "\u13b9\u13ca\u13e4" },
            { "arp", "\u13a0\u13e9\u13c8\u13b0" },
            { "ars", "\u13be\u13e3\u13d7 \u13a0\u13b3\u13c8" },
            { "asa", "\u13a0\u13d1" },
            { "ast", "\u13a0\u13cd\u13da\u13b5\u13a0\u13c2" },
            { "atj", "\u13a0\u13c2\u13d8\u13a7\u13ba\u13c6" },
            { "awa", "\u13a0\u13e9\u13d7" },
            { "ban", "\u13c6\u13b5\u13c1\u13cf" },
            { "bas", "\u13c6\u13cc\u13a0" },
            { "bem", "\u13c7\u13b9\u13c6" },
            { "bez", "\u13c7\u13be" },
            { "bgc", "\u13ad\u13ef\u13c5\u13a2" },
            { "bho", "\u13c9\u13e3\u13ca\u13b5" },
            { "bin", "\u13c8\u13c2" },
            { "bla", "\u13cf\u13a9\u13cf\u13a7" },
            { "brx", "\u13c9\u13d9" },
            { "bug", "\u13c8\u13a5\u13a9\u13c2\u13cd" },
            { "byn", "\u13df\u13c2" },
            { "cay", "\u13a7\u13f3\u13a6" },
            { "ccp", metaValue_ccp },
            { "ceb", "\u13ce\u13c6\u13c3" },
            { "cgg", "\u13e5\u13a6" },
            { "chk", "\u13e7\u13a8\u13ce" },
            { "chm", metaValue_ML },
            { "cho", "\u13a0\u13e3\u13d3" },
            { "chp", "\u13a0\u13e5\u13c7\u13ef\u13c2" },
            { "chr", metaValue_chr },
            { "chy", "\u13e3\u13f0\u13c2" },
            { "ckb", "\u13a0\u13f0\u13df \u13ab\u13d7\u13cf" },
            { "clc", "\u13e5\u13b8\u13aa\u13d8\u13be" },
            { "crg", "\u13bb\u13e5\u13e9" },
            { "crj", "\u13e7\u13a6\u13c3\u13ee \u13d7\u13a7\u13b8\u13ac \u13df" },
            { "crk", "\u13e0\u13a8\u13cf \u13df" },
            { "crl", "\u13e7\u13f4\u13e2 \u13d7\u13a7\u13b8\u13ac \u13df" },
            { "crm", "\u13a0\u13eb \u13a1\u13c6 \u13df" },
            { "crr", "\u13a0\u13b5\u13a6\u13c2\u13c8\u13a0\u13be" },
            { "crs", "\u13ce\u13ce\u13b5\u13e9 \u13df\u13f2\u13b5 \u13a0\u13c2\u13a6\u13b8" },
            { "csw", "\u13cc\u13b7\u13f1 \u13df" },
            { "dak", "\u13d3\u13aa\u13d4" },
            { "dar", "\u13d3\u13b3\u13c6" },
            { "dav", "\u13d4\u13a2\u13d4" },
            { "dgr", "\u13a9\u13df \u13a4\u13c4\u13b3\u13e5" },
            { "dje", "\u13cc\u13b9" },
            { "doi", "\u13d9\u13a6\u13b5" },
            { "dsb", "\u13a1\u13b3\u13d7 \u13d0\u13c8\u13a0\u13c2" },
            { "dua", "\u13da\u13a0\u13b3" },
            { "dyo", "\u13e6\u13b3-\u13ec\u13f1" },
            { "dzg", "\u13d3\u13cc\u13a6" },
            { "ebu", "\u13a1\u13bb\u13ca" },
            { "efi", "\u13a1\u13eb\u13a9" },
            { "eka", "\u13a8\u13a7\u13e7\u13a7" },
            { "ewo", "\u13a1\u13ec\u13c2\u13d9" },
            { "fil", "\u13a0\u13c8\u13b5\u13a9" },
            { "fon", "\u13e0\u13c2" },
            { "frc", "\u13a8\u13e8\u13c2 \u13a6\u13b8\u13e5" },
            { "frr", "\u13e7\u13f4\u13e2 \u13b7\u13c8" },
            { "fur", "\u13de\u13a4\u13b5\u13a0\u13c2" },
            { "gaa", "\u13a6" },
            { "gez", "\u13a9\u13cf" },
            { "gil", "\u13a9\u13c7\u13d8\u13cf" },
            { "gor", "\u13aa\u13b6\u13c2\u13d4\u13c3" },
            { "gsw", "\u13cd\u13eb\u13cf \u13a0\u13c2\u13d3\u13e5" },
            { "guz", "\u13ab\u13cf" },
            { "gwi", "\u13c8\u13e5\u13c2" },
            { "hai", "\u13ad\u13f1\u13d3" },
            { "haw", "\u13ad\u13e9\u13bc" },
            { "hax", "\u13e7\u13a6\u13c3\u13ee \u13d7\u13dc \u13ad\u13f1\u13d3" },
            { "hil", "\u13af\u13b5\u13a8\u13be\u13c2" },
            { "hmn", "\u13ad\u13bc\u13c2\u13a9" },
            { "hsb", "\u13a6\u13b8\u13b3\u13d7\u13a8 \u13d0\u13c8\u13a0\u13c2" },
            { "hup", "\u13a0\u13c2\u13b1\u13c6" },
            { "hur", "\u13ad\u13b5\u13aa\u13ba\u13b4\u13bb" },
            { "iba", "\u13a2\u13c6\u13c2" },
            { "ibb", "\u13a2\u13c8\u13c8\u13a3" },
            { "ikt", "\u13ed\u13d5\u13b5\u13ac \u13a8\u13be\u13d3 \u13a2\u13c4\u13a9\u13d8\u13da\u13d8" },
            { "ilo", "\u13a2\u13b6\u13aa" },
            { "inh", "\u13a2\u13c2\u13ab\u13cf" },
            { "jbo", "\u13b6\u13e3\u13c6\u13c2" },
            { "jgo", "\u13be\u13aa\u13c6" },
            { "jmc", "\u13b9\u13e3\u13ba" },
            { "kab", "\u13a7\u13c8\u13b4" },
            { "kac", "\u13a7\u13e5\u13c2" },
            { "kaj", "\u13e5\u13e7" },
            { "kam", "\u13a7\u13bb\u13c6" },
            { "kbd", "\u13a7\u13c6\u13d7\u13a0\u13c2" },
            { "kcg", "\u13d4\u13ef\u13c6" },
            { "kde", "\u13b9\u13aa\u13d5" },
            { "kea", "\u13a7\u13ca\u13ea\u13d7\u13a0\u13c4" },
            { "kfo", "\u13aa\u13b6" },
            { "kgp", "\u13a8\u13c2\u13a8\u13c2" },
            { "kha", "\u13a7\u13cf" },
            { "khq", "\u13aa\u13f1\u13b3 \u13e5\u13c2" },
            { "kkj", "\u13a7\u13aa" },
            { "kln", "\u13a7\u13b4\u13c2\u13e5\u13c2" },
            { "kmb", "\u13a9\u13bb\u13ca\u13da" },
            { "kok", "\u13a7\u13c2\u13a7\u13c2" },
            { "kpe", "\u13c7\u13b4" },
            { "krc", "\u13a7\u13b3\u13e3\u13f1-\u13c6\u13b5\u13a7\u13b5" },
            { "krl", "\u13a7\u13b4\u13b5\u13a0\u13c2" },
            { "kru", "\u13ab\u13b7\u13a9" },
            { "ksb", "\u13dd\u13bb\u13c6\u13b8" },
            { "ksf", "\u13c6\u13eb\u13a0" },
            { "ksh", "\u13aa\u13b6\u13c2\u13a0\u13c2" },
            { "kum", "\u13ab\u13bb\u13a7" },
            { "kwk", "\u13c6\u13c6\u13b3" },
            { "lad", "\u13b3\u13d7\u13c3" },
            { "lag", "\u13b3\u13c2\u13a9" },
            { "lez", "\u13b4\u13cf\u13a6\u13c2" },
            { "lil", "\u13b5\u13b6\u13a1\u13d8" },
            { "lkt", "\u13b3\u13aa\u13d3" },
            { "lou", "\u13b7\u13eb\u13cf\u13a1\u13be \u13a6\u13ec\u13c2\u13af\u13cd\u13d7" },
            { "loz", "\u13b6\u13cf" },
            { "lrc", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13b7\u13b5" },
            { "lsm", "\u13cc\u13a0\u13bb\u13a0" },
            { "lua", "\u13b7\u13c6-\u13b7\u13b7\u13a0" },
            { "lun", "\u13b7\u13be\u13d3" },
            { "luo", "\u13b7\u13a3" },
            { "lus", "\u13bb\u13d0" },
            { "luy", "\u13b7\u13f1\u13a0" },
            { "mad", "\u13b9\u13da\u13b4\u13cf" },
            { "mag", "\u13b9\u13a6\u13af" },
            { "mai", "\u13b9\u13df\u13b5" },
            { "mak", "\u13b9\u13a7\u13cc" },
            { "mas", "\u13b9\u13cc\u13f1" },
            { "mdf", "\u13bc\u13a7\u13cc" },
            { "men", "\u13ba\u13be\u13d5" },
            { "mer", "\u13ba\u13b7" },
            { "mfe", "\u13bc\u13b5\u13cf\u13a1\u13c2" },
            { "mgh", "\u13b9\u13ab\u13e9-\u13bb\u13d9" },
            { "mgo", "\u13ba\u13b3\u2019" },
            { "mic", "\u13bb\u13a7\u13b9\u13a9" },
            { "min", "\u13bb\u13be\u13a7\u13c6\u13a4" },
            { "mni", "\u13ba\u13c2\u13c9\u13b5" },
            { "moe", "\u13a2\u13c4-\u13a0\u13f1\u13f5\u13c2" },
            { "moh", "\u13bc\u13ad\u13a9" },
            { "mos", "\u13bc\u13cd\u13cf" },
            { "mua", "\u13bd\u13c2\u13d3\u13a9" },
            { "mul", "\u13e7\u13c8\u13cd\u13d7 \u13d7\u13a6\u13ec\u13c2\u13af\u13cd\u13d7" },
            { "mus", "\u13a0\u13ab\u13cc" },
            { "mwl", "\u13bb\u13b3\u13d5\u13cf" },
            { "myv", "\u13a1\u13cf\u13ef" },
            { "mzn", "\u13b9\u13cc\u13d5\u13b3\u13c2" },
            { "nap", "\u13c2\u13ef\u13c6\u13b5\u13d4\u13c2" },
            { "naq", "\u13be\u13b9" },
            { "nds", "\u13a1\u13b3\u13d7 \u13a0\u13c2\u13d3\u13e5" },
            { "new", "\u13c1\u13e9\u13b5" },
            { "nia", "\u13c2\u13a0\u13cf" },
            { "niu", "\u13c2\u13f3\u13eb\u13ef\u13c2" },
            { "nmg", "\u13c6\u13cf\u13f2" },
            { "nnh", "\u13be\u13e5\u13f0\u13b9\u13ca\u13c2" },
            { "nog", "\u13c3\u13a6\u13f1" },
            { "nqo", metaValue_nqo },
            { "nso", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13d0\u13e0" },
            { "nus", "\u13c4\u13ea\u13b5" },
            { "nyn", "\u13c2\u13ef\u13be\u13aa\u13b4" },
            { "ojb", "\u13e7\u13f4\u13e2 \u13ed\u13d5\u13b5\u13ac \u13a3\u13e5\u13c6" },
            { "ojc", "\u13a0\u13f0\u13df \u13a3\u13e5\u13c6" },
            { "ojs", "\u13a3\u13e5-\u13df" },
            { "ojw", "\u13ed\u13d5\u13b5\u13ac \u13d7\u13dc \u13a3\u13e5\u13c6" },
            { "oka", "\u13a3\u13a7\u13be\u13a6\u13c2" },
            { "pag", "\u13c7\u13a6\u13cf\u13a0\u13c2" },
            { "pam", "\u13c6\u13b9\u13c6\u13be\u13a6" },
            { "pap", "\u13c6\u13c8\u13ef\u13ba\u13be\u13d9" },
            { "pau", "\u13c6\u13b3\u13a4\u13e9\u13c2" },
            { "pcm", "\u13be\u13a9\u13b5\u13a0\u13c2 \u13c8\u13e5\u13c2" },
            { "pis", "\u13c8\u13e5\u13be" },
            { "pqm", "\u13b9\u13b5\u13cf\u13d8-\u13c7\u13cc\u13b9\u13c9\u13d7" },
            { "prg", "\u13e1\u13cf\u13a0\u13c2" },
            { "quc", "\u13a9\u13e4" },
            { "raj", "\u13b3\u13e3\u13cd\u13ad\u13c2" },
            { "rap", "\u13b3\u13c6\u13c4\u13eb" },
            { "rar", "\u13b3\u13b6\u13d9\u13be\u13a6\u13c2" },
            { "rhg", "\u13b6\u13af\u13c2\u13ef" },
            { "rof", "\u13b6\u13b9\u13c9" },
            { "rup", "\u13a0\u13ec\u13b9\u13c2\u13a0\u13c2" },
            { "rwk", "\u13c6" },
            { "sad", "\u13cc\u13c5\u13d3\u13eb" },
            { "sah", "\u13cc\u13a7\u13be" },
            { "saq", "\u13cc\u13b9\u13ca\u13b7" },
            { "sat", "\u13cc\u13c2\u13d4\u13b5" },
            { "sba", "\u13be\u13a6\u13b9\u13c7" },
            { "sbp", "\u13cc\u13c1\u13ab" },
            { "scn", "\u13cf\u13cf\u13b5\u13a0\u13c2" },
            { "sco", "\u13cd\u13a6\u13d7" },
            { "see", "\u13cf\u13c2\u13a6" },
            { "seh", "\u13ce\u13be" },
            { "ses", "\u13aa\u13f1\u13b3\u13c8\u13b6 \u13ce\u13c2" },
            { "shi", "\u13d4\u13e4\u13b5\u13af\u13d8" },
            { "shn", "\u13dd\u13c2" },
            { "slh", "\u13e7\u13a6\u13c3\u13ee \u13d7\u13dc \u13b7\u13d1\u13d8\u13cf\u13d7" },
            { "sma", "\u13e7\u13a6\u13be\u13ee \u13d7\u13dc \u13cc\u13bb" },
            { "smj", "\u13b7\u13b4 \u13cc\u13bb" },
            { "smn", "\u13a2\u13be\u13b5 \u13cc\u13bb" },
            { "sms", "\u13cd\u13aa\u13b5\u13d8 \u13cc\u13bb" },
            { "snk", "\u13d0\u13c2\u13c2\u13a8" },
            { "srn", "\u13cf\u13b3\u13be\u13c2 \u13d9\u13c3\u13aa" },
            { "ssy", "\u13cc\u13b0" },
            { "str", "\u13cc\u13b5\u13cf" },
            { "suk", "\u13d1\u13ab\u13b9" },
            { "swb", "\u13aa\u13bc\u13b5\u13a0\u13c2" },
            { "syr", "\u13cf\u13b5\u13a0\u13a9" },
            { "tce", "\u13e7\u13a6\u13c3\u13ee \u13da\u13e6\u13c1" },
            { "tem", "\u13d8\u13b9\u13c1" },
            { "teo", "\u13d6\u13d0" },
            { "tet", "\u13d6\u13da\u13bc" },
            { "tgx", "\u13d4\u13a9\u13cf" },
            { "tht", "\u13d4\u13dd\u13be" },
            { "tig", "\u13e2\u13d3\u13e5" },
            { "tlh", "\u13df\u13a6\u13be" },
            { "tli", "\u13df\u13a9\u13d8" },
            { "tok", "\u13d9\u13a9 \u13c9\u13be" },
            { "tpi", "\u13d9\u13a9 \u13c8\u13cf\u13c2" },
            { "trv", "\u13d4\u13b6\u13aa" },
            { "ttm", "\u13e7\u13f4\u13e2 \u13d7\u13dc \u13da\u13e6\u13c1" },
            { "tum", "\u13db\u13b9\u13ca\u13a7" },
            { "tvl", metaValue_TV },
            { "twq", "\u13d4\u13cc\u13e9\u13a9" },
            { "tyv", "\u13da\u13eb\u13c2\u13a0\u13c2" },
            { "tzm", "\u13a0\u13f0\u13df \u13a1\u13b6\u13af \u13d3\u13df\u13b6\u13cd\u13d7\u13d3\u13c5\u13a2 \u13d4\u13b9\u13cf\u13d8" },
            { "udm", "\u13a4\u13da\u13b7\u13d8" },
            { "umb", "\u13a4\u13b9\u13ca\u13c5\u13da" },
            { "und", "\u13c4\u13ec\u13b5\u13cd\u13db\u13be \u13a6\u13ec\u13c2\u13af\u13cd\u13d7" },
            { "vai", metaValue_vai },
            { "vun", "\u13ed\u13be\u13e6" },
            { "wae", "\u13e9\u13b5\u13ce\u13b5" },
            { "wal", "\u13ec\u13b3\u13f1\u13d4" },
            { "war", "\u13e9\u13b4" },
            { "wuu", "\u13ed \u13d3\u13b6\u13c2\u13a8\u13cd\u13db" },
            { "xal", "\u13a7\u13b3\u13bb\u13a7" },
            { "xog", "\u13d0\u13a6" },
            { "yav", "\u13f0\u13be\u13a6\u13c7\u13c2" },
            { "ybb", "\u13f0\u13b9\u13cb" },
            { "yrl", "\u13c2\u13be\u13a6\u13da" },
            { "yue", "\u13a8\u13be\u13d9\u13c2\u13cf" },
            { "zgh", "\u13a0\u13df\u13b6\u13cd\u13d7 \u13bc\u13b6\u13aa \u13d4\u13b9\u13cf\u13d8" },
            { "zun", "\u13d1\u13c2" },
            { "zxx", "\u13dd \u13a6\u13ec\u13c2\u13af\u13cd\u13d7 \u13a6\u13b8\u13db\u13a2 \u13f1\u13a9" },
            { "zza", "\u13cc\u13cc" },
            { "Adlm", "\u13a0\u13d3\u13b3\u13bb" },
            { "Arab", "\u13a1\u13b3\u13c8\u13a9" },
            { "Aran", "\u13be\u13cd\u13d4\u13b5\u13c6" },
            { "Armn", metaValue_hy },
            { "Beng", "\u13c7\u13c2\u13a6\u13a0" },
            { "Bopo", "\u13c6\u13c9\u13bc\u13ec" },
            { "Brai", "\u13d7\u13c2\u13a8\u13eb \u13a4\u13c3\u13ea\u13b6\u13d9\u13d7" },
            { "Cakm", metaValue_ccp },
            { "Cans", "\u13cc\u13ca \u13a8\u13be\u13d3 \u13a0\u13c2\u13f4\u13eb\u13ef \u13d7\u13aa\u13ea\u13b8" },
            { "Cher", metaValue_chr },
            { "Cyrl", "\u13f2\u13c2\u13a2 \u13d7\u13aa\u13ea\u13b5" },
            { "Deva", "\u13d5\u13eb\u13be\u13a6\u13b5" },
            { "Ethi", "\u13a2\u13d7\u13ef\u13c8\u13a9" },
            { "Geor", metaValue_ka },
            { "Grek", "\u13aa\u13a2" },
            { "Gujr", metaValue_gu },
            { "Guru", "\u13ac\u13b9\u13a9" },
            { "Hanb", "\u13ad\u13c2 \u13be\u13bf \u13c6\u13c9\u13bc\u13ec" },
            { "Hang", "\u13ad\u13c2\u13ab\u13b5" },
            { "Hani", "\u13ad\u13c2" },
            { "Hans", "\u13a0\u13af\u13d7\u13a8" },
            { "Hant", "\u13a4\u13e6\u13cd\u13d7" },
            { "Hebr", "\u13a0\u13c2\u13c8\u13b5" },
            { "Hira", "\u13af\u13b3\u13a6\u13be" },
            { "Hrkt", "\u13e3\u13e9\u13c2\u13cf \u13e7\u13c3\u13f4\u13a9" },
            { "Jamo", "\u13e3\u13bc" },
            { "Jpan", "\u13e3\u13c6\u13c2\u13cf" },
            { "Kana", "\u13a7\u13d4\u13a7\u13be" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "\u13ba\u13d6 \u13b9\u13f0\u13a9" },
            { "Mymr", "\u13b9\u13a1\u13c2\u13b9\u13b3" },
            { "Nkoo", metaValue_nqo },
            { "Olck", "\u13a3\u13b5 \u13e5\u13a9" },
            { "Orya", metaValue_or },
            { "Rohg", "\u13ad\u13c2\u13eb" },
            { "Sinh", "\u13cf\u13c5\u13ad\u13b3" },
            { "Sund", "\u13da\u13d3\u13c2\u13ce" },
            { "Syrc", "\u13cf\u13b5\u13a1\u13a9" },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Tfng", "\u13d8\u13eb\u13be\u13a6" },
            { "Thaa", "\u13d4\u13a0\u13be" },
            { "Thai", "\u13d4\u13f1 \u13d4\u13ef\u13b4\u13c2" },
            { "Tibt", metaValue_bo },
            { "Vaii", metaValue_vai },
            { "Yiii", "\u13f1" },
            { "Zmth", "\u13a0\u13f0\u13a6\u13b4\u13f4\u13eb\u13cd\u13a9 \u13a0\u13a4\u13d3\u13d7\u13cd\u13d9\u13d7" },
            { "Zsye", "\u13a1\u13bc\u13e5" },
            { "Zsym", "\u13d7\u13ac\u13df\u13b6\u13cd\u13d9\u13d7" },
            { "Zxxx", "\u13aa\u13ea\u13b3\u13c5 \u13c2\u13a8\u13d2\u13be" },
            { "Zyyy", "\u13ef\u13c3\u13c9 \u13f1\u13ac\u13cd\u13db\u13ed" },
            { "Zzzz", "\u13c4\u13ec\u13b5\u13cd\u13db\u13be \u13a0\u13cd\u13d3\u13e9\u13db\u13cd\u13d9\u13d7" },
            { "de_AT", "\u13a0\u13df\u13ef\u13c2 \u13a0\u13c2\u13d3\u13e5" },
            { "de_CH", "\u13cd\u13eb\u13cf \u13a6\u13b8\u13b3\u13d7 \u13a0\u13c2\u13d3\u13e5" },
            { "en_AU", "\u13a1\u13b3\u13d7\u13dc \u13a9\u13b5\u13cf" },
            { "en_CA", "\u13a8\u13be\u13d3 \u13a9\u13b5\u13cf" },
            { "en_GB", "\u13a9\u13b5\u13cf\u13f2 \u13a9\u13b5\u13cf" },
            { "en_US", "\u13a0\u13b9\u13f0\u13df \u13a9\u13b5\u13cf" },
            { "es_ES", "\u13a0\u13c2\u13cd\u13c6\u13c2\u13f1 \u13cd\u13c6\u13c2" },
            { "es_MX", "\u13cd\u13c6\u13c2\u13f1 \u13cd\u13c6\u13c2" },
            { "fa_AF", "\u13d3\u13b5" },
            { "fr_CA", "\u13a8\u13be\u13d3 \u13a6\u13b8\u13e5" },
            { "fr_CH", "\u13cd\u13eb\u13cf \u13a6\u13b8\u13e5" },
            { "nl_BE", "\u13ca\u13b5\u13e5\u13a5\u13bb \u13db\u13e5" },
            { "pt_BR", "\u13c6\u13cf\u13b5\u13a2 \u13c9\u13e7\u13a9\u13cd" },
            { "pt_PT", "\u13f3\u13b3\u13c8 \u13c9\u13e7\u13a9\u13cd" },
            { "ro_MD", "\u13b9\u13b5\u13d9\u13eb\u13a0 \u13e3\u13b9\u13c2\u13a0\u13c2" },
            { "sw_CD", "\u13a7\u13c2\u13aa \u13cd\u13e9\u13af\u13b5" },
            { "ar_001", "\u13aa\u13af\u13ca \u13a2\u13ac\u13e5\u13a9 \u13a0\u13df\u13b6\u13cd\u13d7 \u13a1\u13b3\u13c8" },
            { "es_419", "\u13d4\u13d8\u13c2 \u13a0\u13b9\u13f0\u13df \u13cd\u13c6\u13c2" },
            { "key.ca", "\u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "key.cf", "\u13a0\u13d5\u13b3 \u13f1\u13ac\u13c1\u13b8\u13af" },
            { "key.co", "\u13d7\u13a6\u13c5\u13c3\u13d9\u13d7 \u13d5\u13a6\u13c5\u13c3\u13db\u13a2" },
            { "key.cu", "\u13a0\u13d5\u13b3" },
            { "key.hc", "\u13d1\u13df\u13b6\u13d3 \u13a0\u13d3\u13c1\u13df\u13f4\u13ce\u13ac (12 vs 24)" },
            { "key.lb", "\u13a0\u13cd\u13d3\u13c5\u13c5 \u13a0\u13f2\u13cd\u13d4\u13c5\u13a9 \u13c2\u13da\u13cd\u13db" },
            { "key.ms", "\u13a0\u13df\u13b6\u13db \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2" },
            { "key.nu", "\u13d7\u13ce\u13cd\u13d7" },
            { "nds_NL", "\u13a1\u13b3\u13d7 \u13c1\u13db\u13b3\u13c2" },
            { "zh_Hans", "\u13a0\u13af\u13d7\u13a8 \u13d3\u13b6\u13c2\u13a8" },
            { "zh_Hant", "\u13a4\u13e6\u13cd\u13d7 \u13d3\u13b6\u13c2\u13a8" },
            { "type.ca.roc", "\u13cd\u13a6\u13da\u13a9 \u13be\u13bf \u13d3\u13b6\u13c2\u13a8\u13cd\u13db \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.hc.h11", "12 \u13a2\u13f3\u13df\u13b6\u13d3 \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2 (0\u201311)" },
            { "type.hc.h12", "12 \u13a2\u13f3\u13df\u13b6\u13d3 \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2 (1\u201312)" },
            { "type.hc.h23", "24 \u13a2\u13f3\u13df\u13b6\u13d3 \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2 (0\u201323)" },
            { "type.hc.h24", "24 \u13a2\u13f3\u13df\u13b6\u13d3 \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2 (1\u201324)" },
            { "type.nu.arab", "\u13a0\u13b3\u13c8-\u13a1\u13c2\u13d7\u13a9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.armn", "\u13a0\u13b3\u13bb\u13a0\u13c2 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.beng", "\u13c7\u13c2\u13a6\u13b3 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.cakm", "\u13e3\u13a9\u13b9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.deva", "\u13d5\u13eb\u13be\u13a6\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.ethi", "\u13a2\u13d7\u13ef\u13c8\u13a9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.geor", "\u13a9\u13b4\u13aa\u13b5\u13a0\u13c2 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.grek", "\u13a0\u13c2\u13aa\u13a2 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.gujr", "\u13ab\u13e3\u13b3\u13d8 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.guru", "\u13ac\u13b9\u13a9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.hans", "\u13a0\u13af\u13d7\u13a8 \u13d3\u13b6\u13c2\u13a8 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.hant", "\u13a4\u13e6\u13cd\u13d7 \u13d3\u13b6\u13c2\u13a8 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.hebr", "\u13a0\u13c2\u13c8\u13b7 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.java", "\u13e3\u13e9\u13c2\u13ce \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.jpan", "\u13e3\u13c6\u13c2\u13cf \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.khmr", "\u13a9\u13bb\u13b7 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.knda", "\u13a7\u13be\u13d3 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.laoo", "\u13b3\u13a3 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.latn", "\u13ed\u13d7\u13b5\u13ac \u13d7\u13dc \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.mlym", "\u13b9\u13b3\u13ef\u13b3\u13bb \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.mtei", "\u13bb\u13d6 \u13b9\u13f0\u13a9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.mymr", "\u13b9\u13ef\u13b9\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.olck", "\u13a3\u13b5 \u13e5\u13a9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.orya", "\u13a3\u13d7\u13a0 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.taml", "\u13a4\u13e6\u13cd\u13d7 \u13d4\u13bb\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.telu", "\u13d6\u13b7\u13a6 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.thai", "\u13d4\u13f1 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.tibt", "\u13d8\u13c7\u13d4\u13c2 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.vaii", "\u13e9\u13f1 \u13d7\u13ce\u13cd\u13d7" },
            { "type.ca.dangi", "\u13d3\u13c2\u13a9 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.co.ducet", "\u13a0\u13d3\u13c1\u13df\u13f4\u13d7\u13cd\u13a9 Unicode \u13d7\u13a6\u13c5\u13c3\u13d9\u13d7 \u13d5\u13a6\u13c5\u13c3\u13db\u13a2" },
            { "type.lb.loose", "\u13e9\u13be\u13a2 \u13a0\u13cd\u13d3\u13c5\u13c5 \u13a0\u13f2\u13cd\u13d4\u13c5\u13a9 \u13c2\u13da\u13cd\u13db" },
            { "type.nu.roman", "\u13a0\u13c2\u13b6\u13bb \u13d7\u13ce\u13cd\u13d7" },
            { "type.ca.coptic", "\u13a7\u13d8 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.ca.hebrew", "\u13a0\u13c2\u13c8\u13b7 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.co.search", "\u13c2\u13a6\u13a5-\u13a2\u13f3\u13f1\u13b8\u13d7 \u13a0\u13f1\u13cd\u13d7" },
            { "type.lb.normal", "\u13f1\u13ac\u13cd\u13d7\u13ad\u13ca \u13a0\u13cd\u13d3\u13c5\u13c5 \u13a0\u13f2\u13cd\u13d4\u13c5\u13a9 \u13c2\u13da\u13cd\u13db" },
            { "type.lb.strict", "\u13a4\u13b6\u13d2\u13cd\u13d4\u13c5\u13af \u13a0\u13cd\u13d3\u13c5\u13c5 \u13a0\u13f2\u13cd\u13d4\u13c5\u13a9 \u13c2\u13da\u13cd\u13db" },
            { "type.ms.metric", "\u13a0\u13c2\u13a9\u13b8\u13e5 \u13c2\u13d3\u13f3\u13d3\u13b4\u13c5\u13af \u13d7\u13ce\u13cd\u13d7 \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2" },
            { "type.ca.chinese", "\u13d3\u13b6\u13c2\u13a8\u13cd\u13db \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.ca.islamic", "\u13a2\u13cd\u13b3\u13bb\u13a9 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.ca.iso8601", "ISO-8601 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.ca.persian", "\u13c7\u13cf\u13a0\u13c2 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.cf.account", "\u13a0\u13d5\u13b3 \u13d7\u13ce\u13af\u13af \u13a0\u13d5\u13b3 \u13f1\u13ac\u13c1\u13b8\u13af" },
            { "type.nu.arabext", "\u13a6\u13c5\u13af\u13db \u13a0\u13b3\u13c8-\u13a1\u13c2\u13d7\u13a9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.armnlow", "\u13a0\u13b3\u13bb\u13a0\u13c2 \u13e7\u13cd\u13d7 \u13d7\u13aa\u13ea\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.greklow", "\u13a0\u13c2\u13aa\u13a2 \u13e7\u13cd\u13d7 \u13d7\u13aa\u13ea\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.hanidec", "\u13d3\u13b6\u13c2\u13a8 \u13d5\u13cf\u13b9\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.hansfin", "\u13a0\u13af\u13d7\u13a8 \u13d3\u13b6\u13c2\u13a8 \u13a0\u13d5\u13b3 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.hantfin", "\u13a4\u13e6\u13cd\u13d7 \u13d3\u13b6\u13c2\u13a8 \u13a0\u13d5\u13b3 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.jpanfin", "\u13e3\u13c6\u13c2\u13cf \u13a0\u13d5\u13b3 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.tamldec", "\u13d4\u13bb\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "type.ca.buddhist", "\u13ca\u13d7\u13cd\u13d8 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.ca.ethiopic", "\u13a2\u13d7\u13ef\u13c8\u13a9 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.ca.japanese", "\u13e3\u13c6\u13c2\u13cf \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.cf.standard", "\u13a0\u13df\u13b6\u13cd\u13d7 \u13a0\u13d5\u13b3 \u13f1\u13ac\u13c1\u13b8\u13af" },
            { "type.co.standard", "\u13a0\u13df\u13b6\u13cd\u13d7 \u13d7\u13a6\u13c5\u13c3\u13d9\u13d7 \u13d5\u13a6\u13c5\u13c3\u13db\u13a2" },
            { "type.ms.uksystem", "\u13c2\u13ac\u13be\u13db\u13a2 \u13a4\u13d3\u13e4\u13b5\u13a6\u13ef \u13a0\u13df\u13b6\u13db \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2" },
            { "type.ms.ussystem", "US \u13a0\u13df\u13b6\u13db \u13c4\u13cd\u13d7\u13d3\u13c5\u13a2" },
            { "type.nu.fullwide", "\u13a7\u13b5\u13a2-\u13be\u13ef\u13db\u13d2 \u13d7\u13ce\u13cd\u13d7" },
            { "type.nu.romanlow", "\u13a0\u13c2\u13b6\u13bb \u13e7\u13cd\u13d7 \u13d7\u13aa\u13ea\u13b5 \u13d7\u13ce\u13cd\u13d7" },
            { "type.ca.gregorian", "\u13a9\u13b4\u13aa\u13b5\u13a0\u13c2 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
            { "type.ca.islamic-civil", "\u13a2\u13cc\u13b3\u13bb\u13a9 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7 (\u13f4\u13eb \u13a1\u13c6\u13a9)" },
            { "type.ca.islamic-umalqura", "\u13a2\u13cc\u13b3\u13bb\u13a9 \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7 (\u13a5\u13bb \u13a0\u13b5-\u13ca\u13b3)" },
            { "type.ca.ethiopic-amete-alem", "\u13a1\u13d8\u13a3\u13c8\u13a0 \u13a0\u13ba\u13d6 \u13a0\u13b4\u13bb \u13c5\u13d9 \u13d7\u13ce\u13cd\u13d7" },
        };
        return data;
    }
}
