/*
 * Copyright (c) 2023, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */
package jdk.jfr.internal.periodic;

import jdk.internal.event.Event;
import jdk.jfr.internal.util.Utils;

/**
 * Periodic task that runs trusted code that doesn't require an access control
 * context.
 * <p>
 * This class can be removed once the Security Manager is no longer supported.
 */
final class JDKEventTask extends JavaEventTask {

    public JDKEventTask(Class<? extends Event> eventClass, Runnable runnable) {
        super(eventClass, runnable);
        if (!getEventType().isJDK()) {
            throw new InternalError("Must be a JDK event");
        }
        if (!Utils.isJDKClass(eventClass)) {
            throw new SecurityException("Periodic task can only be registered for event classes that belongs to the JDK");
        }
        if (!Utils.isJDKClass(runnable.getClass())) {
            throw new SecurityException("Runnable class must belong to the JDK");
        }
    }

    @Override
    public void execute(long timestamp, PeriodicType periodicType) {
        getRunnable().run();
    }
}
