/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_id extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwich Mean Time",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "Waktu Standar Acre",
               "",
               "Waktu Musim Panas Acre",
               "",
               "Waktu Acre",
               "",
            };
        final String[] Apia = new String[] {
               "Waktu Standar Apia",
               "",
               "Waktu Musim Panas Apia",
               "",
               "Waktu Apia",
               "",
            };
        final String[] Cook = new String[] {
               "Waktu Standar Kep. Cook",
               "",
               "Waktu Tengah Musim Panas Kep. Cook",
               "",
               "Waktu Kep. Cook",
               "",
            };
        final String[] Cuba = new String[] {
               "Waktu Standar Kuba",
               "CST (Kuba)",
               "Waktu Musim Panas Kuba",
               "CDT (Kuba)",
               "Waktu Kuba",
               "CT (Kuba)",
            };
        final String[] Fiji = new String[] {
               "Waktu Standar Fiji",
               "",
               "Waktu Musim Panas Fiji",
               "",
               "Waktu Fiji",
               "",
            };
        final String[] Gulf = new String[] {
               "Waktu Standar Teluk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "Waktu Standar Hovd",
               "",
               "Waktu Musim Panas Hovd",
               "",
               "Waktu Hovd",
               "",
            };
        final String[] Iran = new String[] {
               "Waktu Standar Iran",
               "",
               "Waktu Musim Panas Iran",
               "",
               "Waktu Iran",
               "",
            };
        final String[] Niue = new String[] {
               "Waktu Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "Waktu Standar Omsk",
               "",
               "Waktu Musim Panas Omsk",
               "",
               "Waktu Omsk",
               "",
            };
        final String[] Peru = new String[] {
               "Waktu Standar Peru",
               "",
               "Waktu Musim Panas Peru",
               "",
               "Waktu Peru",
               "",
            };
        final String[] Truk = new String[] {
               "Waktu Chuuk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "Waktu Kepulauan Wake",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "Waktu Standar Cile",
               "",
               "Waktu Musim Panas Cile",
               "",
               "Waktu Cile",
               "",
            };
        final String[] China = new String[] {
               "Waktu Standar Tiongkok",
               "CST",
               "Waktu Musim Panas Tiongkok",
               "CDT",
               "Waktu Tiongkok",
               "CT",
            };
        final String[] Cocos = new String[] {
               "Waktu Kepulauan Cocos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "Waktu Davis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "Waktu India",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "Waktu Standar Jepang",
               "JST",
               "Waktu Musim Panas Jepang",
               "JDT",
               "Waktu Jepang",
               "JT",
            };
        final String[] Korea = new String[] {
               "Waktu Standar Korea",
               "KST",
               "Waktu Musim Panas Korea",
               "KST",
               "Waktu Korea",
               "KST",
            };
        final String[] Nauru = new String[] {
               "Waktu Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "Waktu Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "Waktu Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "Waktu Standar Samoa",
               "SST",
               "Waktu Musim Panas Samoa",
               "SST",
               "Waktu Samoa",
               "SST",
            };
        final String[] Syowa = new String[] {
               "Waktu Syowa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "Waktu Standar Tonga",
               "",
               "Waktu Musim Panas Tonga",
               "",
               "Waktu Tonga",
               "",
            };
        final String[] Yukon = new String[] {
               "Waktu Yukon",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "Waktu Standar Alaska",
               "AKST",
               "Waktu Musim Panas Alaska",
               "AKDT",
               "Waktu Alaska",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "Waktu Standar Amazon",
               "",
               "Waktu Musim Panas Amazon",
               "",
               "Waktu Amazon",
               "",
            };
        final String[] Anadyr = new String[] {
               "Waktu Standar Anadyr",
               "",
               "Waktu Musim Panas Anadyr",
               "",
               "Waktu Anadyr",
               "",
            };
        final String[] Azores = new String[] {
               "Waktu Standar Azores",
               "",
               "Waktu Musim Panas Azores",
               "",
               "Waktu Azores",
               "",
            };
        final String[] Bhutan = new String[] {
               "Waktu Bhutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "Waktu Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "Waktu Standar Pulau Paskah",
               "",
               "Waktu Musim Panas Pulau Paskah",
               "",
               "Waktu Pulau Paskah",
               "",
            };
        final String[] Guyana = new String[] {
               "Waktu Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "Waktu Standar Israel",
               "IST",
               "Waktu Musim Panas Israel",
               "IDT",
               "Waktu Israel",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "Waktu Kosrae",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "Waktu Mawson",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "Waktu Standar Moskow",
               "MSK",
               "Waktu Musim Panas Moskow",
               "MSK",
               "Waktu Moskow",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "Waktu Ponape",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samara = new String[] {
               "Waktu Standar Samara",
               "",
               "Waktu Musim Panas Samara",
               "",
               "Waktu Samara",
               "",
            };
        final String[] Tahiti = new String[] {
               "Waktu Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "Waktu Standar Taipei",
               "CST",
               "Waktu Musim Panas Taipei",
               "CDT",
               "Waktu Taipei",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "Waktu Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "Waktu Vostok",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "Waktu Wallis dan Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "Waktu Standar Arab",
               "",
               "Waktu Musim Panas Arab",
               "",
               "Waktu Arab",
               "",
            };
        final String[] Armenia = new String[] {
               "Waktu Standar Armenia",
               "",
               "Waktu Musim Panas Armenia",
               "",
               "Waktu Armenia",
               "",
            };
        final String[] Bolivia = new String[] {
               "Waktu Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "Waktu Standar Chatham",
               "",
               "Waktu Musim Panas Chatham",
               "",
               "Waktu Chatham",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "Waktu Universal Terkoordinasi",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "Waktu Ekuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "Waktu Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "Waktu Standar Georgia",
               "",
               "Waktu Musim Panas Georgia",
               "",
               "Waktu Georgia",
               "",
            };
        final String[] Irkutsk = new String[] {
               "Waktu Standar Irkutsk",
               "",
               "Waktu Musim Panas Irkutsk",
               "",
               "Waktu Irkutsk",
               "",
            };
        final String[] Magadan = new String[] {
               "Waktu Standar Magadan",
               "",
               "Waktu Musim Panas Magadan",
               "",
               "Waktu Magadan",
               "",
            };
        final String[] Myanmar = new String[] {
               "Waktu Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "Waktu Standar Pulau Norfolk",
               "",
               "Waktu Musim Panas Pulau Norfolk",
               "",
               "Waktu Pulau Norfolk",
               "",
            };
        final String[] Noronha = new String[] {
               "Waktu Standar Fernando de Noronha",
               "",
               "Waktu Musim Panas Fernando de Noronha",
               "",
               "Waktu Fernando de Noronha",
               "",
            };
        final String[] Reunion = new String[] {
               "Waktu Reunion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "Waktu Rothera",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "Waktu Kepulauan Solomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "Waktu Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "Waktu Standar Uruguay",
               "",
               "Waktu Musim Panas Uruguay",
               "",
               "Waktu Uruguay",
               "",
            };
        final String[] Vanuatu = new String[] {
               "Waktu Standar Vanuatu",
               "",
               "Waktu Musim Panas Vanuatu",
               "",
               "Waktu Vanuatu",
               "",
            };
        final String[] Yakutsk = new String[] {
               "Waktu Standar Yakutsk",
               "",
               "Waktu Musim Panas Yakutsk",
               "",
               "Waktu Yakutsk",
               "",
            };
        final String[] Atlantic = new String[] {
               "Waktu Standar Atlantik",
               "AST",
               "Waktu Musim Panas Atlantik",
               "ADT",
               "Waktu Atlantik",
               "AT",
            };
        final String[] Brasilia = new String[] {
               "Waktu Standar Brasil",
               "",
               "Waktu Musim Panas Brasil",
               "",
               "Waktu Brasil",
               "",
            };
        final String[] Chamorro = new String[] {
               "Waktu Standar Chamorro",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "Waktu Standar Kolombia",
               "",
               "Waktu Musim Panas Kolombia",
               "",
               "Waktu Kolombia",
               "",
            };
        final String[] Falkland = new String[] {
               "Waktu Standar Kepulauan Falkland",
               "",
               "Waktu Musim Panas Kepulauan Falkland",
               "",
               "Waktu Kepulauan Falkland",
               "",
            };
        final String[] Malaysia = new String[] {
               "Waktu Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "Waktu Maladewa",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "Waktu Standar Ulan Bator",
               "",
               "Waktu Musim Panas Ulan Bator",
               "",
               "Waktu Ulan Bator",
               "",
            };
        final String[] Pakistan = new String[] {
               "Waktu Standar Pakistan",
               "PKT",
               "Waktu Musim Panas Pakistan",
               "PKST",
               "Waktu Pakistan",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "Waktu Standar Paraguay",
               "",
               "Waktu Musim Panas Paraguay",
               "",
               "Waktu Paraguay",
               "",
            };
        final String[] Pitcairn = new String[] {
               "Waktu Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Sakhalin = new String[] {
               "Waktu Standar Sakhalin",
               "",
               "Waktu Musim Panas Sakhalin",
               "",
               "Waktu Sakhalin",
               "",
            };
        final String[] Suriname = new String[] {
               "Waktu Suriname",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "Waktu Standar Argentina",
               "",
               "Waktu Musim Panas Argentina",
               "",
               "Waktu Argentina",
               "",
            };
        final String[] Christmas = new String[] {
               "Waktu Pulau Natal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "Waktu Galapagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "Waktu Standar Hong Kong",
               "HKT",
               "Waktu Musim Panas Hong Kong",
               "HKST",
               "Waktu Hong Kong",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "Waktu Indochina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kamchatka = new String[] {
               "Waktu Standar Petropavlovsk-Kamchatsky",
               "",
               "Waktu Musim Panas Petropavlovsk-Kamchatski",
               "",
               "Waktu Petropavlovsk-Kamchatsky",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "Waktu Kirgizstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "Waktu Standar Lord Howe",
               "",
               "Waktu Musim Panas Lord Howe",
               "",
               "Waktu Lord Howe",
               "",
            };
        final String[] Marquesas = new String[] {
               "Waktu Marquesas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "Waktu Standar Mauritius",
               "",
               "Waktu Musim Panas Mauritius",
               "",
               "Waktu Mauritius",
               "",
            };
        final String[] Singapore = new String[] {
               "Waktu Standar Singapura",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "Waktu Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Volgograd = new String[] {
               "Waktu Standar Volgograd",
               "MSK",
               "Waktu Musim Panas Volgograd",
               "MSK",
               "Waktu Volgograd",
               "MSK",
            };
        final String[] Azerbaijan = new String[] {
               "Waktu Standar Azerbaijan",
               "",
               "Waktu Musim Panas Azerbaijan",
               "",
               "Waktu Azerbaijan",
               "",
            };
        final String[] Bangladesh = new String[] {
               "Waktu Standar Bangladesh",
               "",
               "Waktu Musim Panas Bangladesh",
               "",
               "Waktu Bangladesh",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "Waktu Standar Tanjung Verde",
               "",
               "Waktu Musim Panas Tanjung Verde",
               "",
               "Waktu Tanjung Verde",
               "",
            };
        final String[] East_Timor = new String[] {
               "Waktu Timor Leste",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "Waktu Seychelles",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "Waktu Tajikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "Waktu Standar Uzbekistan",
               "",
               "Waktu Musim Panas Uzbekistan",
               "",
               "Waktu Uzbekistan",
               "",
            };
        final String[] Afghanistan = new String[] {
               "Waktu Afganistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "Waktu Standar Krasnoyarsk",
               "",
               "Waktu Musim Panas Krasnoyarsk",
               "",
               "Waktu Krasnoyarsk",
               "",
            };
        final String[] New_Zealand = new String[] {
               "Waktu Standar Selandia Baru",
               "NZST",
               "Waktu Musim Panas Selandia Baru",
               "NZDT",
               "Waktu Selandia Baru",
               "NZT",
            };
        final String[] Novosibirsk = new String[] {
               "Waktu Standar Novosibirsk",
               "",
               "Waktu Musim Panas Novosibirsk",
               "",
               "Waktu Novosibirsk",
               "",
            };
        final String[] Philippines = new String[] {
               "Waktu Standar Filipina",
               "PST",
               "Waktu Musim Panas Filipina",
               "PDT",
               "Waktu Filipina",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "Waktu Standar Vladivostok",
               "",
               "Waktu Musim Panas Vladivostok",
               "",
               "Waktu Vladivostok",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "Waktu Samudera Hindia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "Waktu Kep. Line",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "Waktu Standar Newfoundland",
               "NST",
               "Waktu Musim Panas Newfoundland",
               "NDT",
               "Waktu Newfoundland",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "Waktu Standar Turkmenistan",
               "",
               "Waktu Musim Panas Turkmenistan",
               "",
               "Waktu Turkmenistan",
               "",
            };
        final String[] French_Guiana = new String[] {
               "Waktu Guyana Prancis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "Waktu Standar Kaledonia Baru",
               "",
               "Waktu Musim Panas Kaledonia Baru",
               "",
               "Waktu Kaledonia Baru",
               "",
            };
        final String[] South_Georgia = new String[] {
               "Waktu Georgia Selatan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "Waktu Standar Yekaterinburg",
               "",
               "Waktu Musim Panas Yekaterinburg",
               "",
               "Waktu Yekaterinburg",
               "",
            };
        final String[] Africa_Central = new String[] {
               "Waktu Afrika Tengah",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "Waktu Afrika Timur",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "Waktu Standar Afrika Barat",
               "WAT",
               "Waktu Musim Panas Afrika Barat",
               "WAT",
               "Waktu Afrika Barat",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "Waktu Dumont-d\u2019Urville",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "Waktu Standar Eropa Tengah",
               "CET",
               "Waktu Musim Panas Eropa Tengah",
               "CEST",
               "Waktu Eropa Tengah",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "Waktu Standar Eropa Timur",
               "EET",
               "Waktu Musim Panas Eropa Timur",
               "EEST",
               "Waktu Eropa Timur",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "Waktu Standar Eropa Barat",
               "WET",
               "Waktu Musim Panas Eropa Barat",
               "WEST",
               "Waktu Eropa Barat",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "Waktu Standar Pasifik Meksiko",
               "MST",
               "Waktu Musim Panas Pasifik Meksiko",
               "MDT",
               "Waktu Pasifik Meksiko",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "Waktu Standar Afrika Selatan",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "Waktu Standar Tengah",
               "CST",
               "Waktu Musim Panas Tengah",
               "CDT",
               "Waktu Tengah",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Waktu Standar Timur",
               "EST",
               "Waktu Musim Panas Timur",
               "EDT",
               "Waktu Timur",
               "ET",
            };
        final String[] America_Pacific = new String[] {
               "Waktu Standar Pasifik",
               "PST",
               "Waktu Musim Panas Pasifik",
               "PDT",
               "Waktu Pasifik",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "Waktu Wilayah Selatan dan Antarktika Prancis",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "Waktu Kep. Gilbert",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Waktu Standar Hawaii-Aleutian",
               "HAST",
               "Waktu Musim Panas Hawaii-Aleutian",
               "HADT",
               "Waktu Hawaii-Aleutian",
               "HAT",
            };
        final String[] Phoenix_Islands = new String[] {
               "Waktu Kepulauan Phoenix",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "Waktu Standar Saint Pierre dan Miquelon",
               "PMST",
               "Waktu Musim Panas Saint Pierre dan Miquelon",
               "PMDT",
               "Waktu Saint Pierre dan Miquelon",
               "PMT",
            };
        final String[] America_Mountain = new String[] {
               "Waktu Standar Pegunungan",
               "MST",
               "Waktu Musim Panas Pegunungan",
               "MDT",
               "Waktu Pegunungan",
               "MT",
            };
        final String[] Marshall_Islands = new String[] {
               "Waktu Kep. Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "Waktu Papua Nugini",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "Waktu Standar Tengah Australia",
               "ACST",
               "Waktu Musim Panas Tengah Australia",
               "ACDT",
               "Waktu Tengah Australia",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "Waktu Standar Timur Australia",
               "AEST",
               "Waktu Musim Panas Timur Australia",
               "AEDT",
               "Waktu Timur Australia",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "Waktu Standar Barat Australia",
               "AWST",
               "Waktu Musim Panas Barat Australia",
               "AWDT",
               "Waktu Barat Australia",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "Waktu Indonesia Tengah",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Waktu Indonesia Timur",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "Waktu Indonesia Barat",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Waktu Kazakhstan Barat",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Waktu Standar Barat Tengah Australia",
               "",
               "Waktu Musim Panas Barat Tengah Australia",
               "",
               "Waktu Barat Tengah Australia",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Waktu Musim Panas Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii_Aleutian },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "Waktu Universal Terkoordinasi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Waktu Standar Irlandia",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "Waktu Universal Terkoordinasi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "Waktu Universal Terkoordinasi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Waktu Musim Panas Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "Waktu Universal Terkoordinasi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan_Western },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii_Aleutian },
            { "Universal",
                new String[] {
                    "Waktu Universal Terkoordinasi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan_Western },
            { "Asia/Anadyr", Anadyr },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan_Western },
            { "Asia/Sakhalin", Sakhalin },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "Waktu Universal Terkoordinasi",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Waktu Standar Irlandia",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Waktu Musim Panas Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Waktu Musim Panas Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Samara", Samara },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii_Aleutian },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kamchatka", Kamchatka },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan_Western },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Waktu Musim Panas Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Waktu Musim Panas Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Volgograd },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "Greenwich Mean Time",
                    "GMT",
                    "Waktu Musim Panas Inggris",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Aqtau", "Aktau" },
            { "timezone.excity.Asia/Macau", "Makau" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Asia/Aqtobe", "Aktobe" },
            { "timezone.excity.Asia/Muscat", "Muskat" },
            { "timezone.excity.Asia/Tehran", "Teheran" },
            { "timezone.excity.Etc/Unknown", "Kota Tidak Dikenal" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Cairo", "Kairo" },
            { "timezone.excity.Asia/Colombo", "Kolombo" },
            { "timezone.excity.Asia/Nicosia", "Nikosia" },
            { "timezone.excity.Asia/Rangoon", "Rangoon" },
            { "timezone.excity.Asia/Damascus", "Damaskus" },
            { "timezone.excity.Asia/Qostanay", "Kostanay" },
            { "timezone.excity.Europe/Athens", "Athena" },
            { "timezone.excity.Europe/Monaco", "Monako" },
            { "timezone.excity.Europe/Moscow", "Moskwa" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Europe/Vienna", "Wina" },
            { "timezone.excity.Europe/Warsaw", "Warsawa" },
            { "timezone.excity.Indian/Comoro", "Komoro" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Algiers", "Aljir" },
            { "timezone.excity.America/Cancun", "Cancun" },
            { "timezone.excity.America/Merida", "Merida" },
            { "timezone.excity.Asia/Jerusalem", "Yerusalem" },
            { "timezone.excity.Asia/Singapore", "Singapura" },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Europe/Belgrade", "Beograd" },
            { "timezone.excity.Europe/Chisinau", "Kishinev" },
            { "timezone.excity.Indian/Maldives", "Maladewa" },
            { "timezone.excity.America/Anguilla", "Anguila" },
            { "timezone.excity.America/Dominica", "Dominika" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "timezone.excity.Europe/Luxembourg", "Luksemburg" },
            { "timezone.excity.Pacific/Enderbury", "Enderbury" },
            { "timezone.excity.America/Costa_Rica", "Kosta Rika" },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "timezone.excity.Europe/Isle_of_Man", "Pulau Man" },
            { "timezone.excity.Atlantic/Cape_Verde", "Tanjung Verde" },
            { "timezone.excity.Pacific/Guadalcanal", "Guadalkanal" },
            { "timezone.excity.America/Ciudad_Juarez", "Ciudad Juarez" },
            { "timezone.excity.America/Bahia_Banderas", "Bahia Banderas" },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia Selatan" },
            { "timezone.excity.America/North_Dakota/Beulah", "Beulah, Dakota Utara" },
            { "timezone.excity.America/North_Dakota/Center", "Center, Dakota Utara" },
            { "timezone.excity.America/North_Dakota/New_Salem", "New Salem, Dakota Utara" },
        };
        return data;
    }
}
