/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_yo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_lo = "L\u00e1\u00f2";
        final String metaValue_ml = "M\u00e1l\u00e0y\u00e1l\u00e1m\u00f9";
        final String metaValue_mn = "M\u00f2ng\u00f3l\u00ed\u00e0";
        final String metaValue_or = "\u00d2d\u00ed\u00e0";
        final String metaValue_syr = "\u00c8d\u00e8 Siriaki";
        final Object[][] data = new Object[][] {
            { "001", "Agb\u00e1y\u00e9" },
            { "002", "\u00c1f\u00edr\u00edk\u00e0" },
            { "003", "\u00c0r\u00edw\u00e1 Am\u1eb9\u0301r\u00edk\u00e0" },
            { "005", "G\u00fa\u00fa\u1e63\u00f9 Am\u1eb9\u0301r\u00edk\u00e0" },
            { "009", "\u00d2s\u1ecd\u0301\u1ecd\u0301n\u00ed\u00e0" },
            { "011", "\u00ccw\u1ecd\u0300 oor\u00f9n Af\u00edr\u00edk\u00e0" },
            { "013", "\u00c0\u00e0rin Gb\u00f9gb\u00f9n \u00c0m\u1eb9\u0301r\u00edk\u00e0" },
            { "014", "\u00ccl\u00e0 Oor\u00f9n \u00c1f\u00edr\u00edk\u00e0" },
            { "015", "\u00c0r\u00edw\u00e1 Af\u00edr\u00edk\u00e0" },
            { "017", "\u00c0\u00e0r\u00edn gb\u00f9ngb\u00f9n Af\u00edr\u00edk\u00e0" },
            { "018", "Ap\u00e1g\u00fa\u00fas\u00f9 \u00c1f\u00edr\u00edk\u00e0" },
            { "019", "Am\u1eb9\u0301r\u00edk\u00e0" },
            { "021", "Ap\u00e1\u00e0r\u00edw\u00e1 Am\u1eb9\u0301r\u00edk\u00e0" },
            { "029", "K\u00e1r\u00edb\u00ed\u00e0n\u00f9" },
            { "030", "\u00ccl\u00e0 \u00d2\u00f2r\u00f9n E\u1e63\u00ed\u00e0" },
            { "034", "G\u00fa\u00fa\u1e63\u00f9 E\u1e63\u00ed\u00e0" },
            { "035", "G\u00fa\u00fa\u1e63\u00f9 \u00ecl\u00e0 \u00f2\u00f2r\u00f9n \u00c9\u1e63\u00ed\u00e0" },
            { "039", "G\u00fa\u00fa\u1e63\u00f9 Y\u00far\u00f3\u00f2p\u00f9" },
            { "053", "\u1ecc\u1e63ir\u00e9la\u1e63\u00ed\u00e0" },
            { "054", "M\u1eb9lan\u00e9\u1e63\u00ed\u00e0" },
            { "057", "Agb\u00e8gb\u00e8 Maikiron\u00e9\u1e63\u00ed\u00e0" },
            { "061", "Poline\u1e63\u00ed\u00e0" },
            { "142", "\u00c1\u1e63\u00ed\u00e0" },
            { "143", "\u00c0\u00e0rin Gb\u00f9ngb\u00f9n \u00c9\u1e63\u00ed\u00e0" },
            { "145", "\u00ccw\u1ecd\u0300 \u00d2\u00f2r\u00f9n E\u1e63\u00ed\u00e0" },
            { "150", "Y\u00far\u00f3\u00f2p\u00f9" },
            { "151", "\u00ccl\u00e0 \u00d2r\u00f9n Y\u00far\u00f3p\u00f9" },
            { "154", "\u00c0r\u00edw\u00e1 Y\u00far\u00f3\u00f2p\u00f9" },
            { "155", "\u00ccw\u1ecd\u0300 \u00d2\u00f2r\u00f9n Y\u00far\u00f3p\u00f9" },
            { "202", "Ap\u00e1 S\u00e0h\u00e1r\u00e0 \u00c1f\u00edr\u00edk\u00e0" },
            { "419", "L\u00e1t\u00edn Am\u1eb9\u0301r\u00edk\u00e0" },
            { "AC", "Er\u00e9k\u00f9s\u00f9 Ascension" },
            { "AD", "\u00c0\u00e0nd\u00f3r\u00e0" },
            { "AE", "\u1eb8mirate ti Aw\u1ecdn Arabu" },
            { "AF", "\u00c0f\u00f9g\u00e0n\u00edst\u00e1n\u00ec" },
            { "AG", "\u00c0\u00e0nt\u00edg\u00fa\u00e0 \u00e0ti B\u00e1r\u00edb\u00fad\u00e0" },
            { "AI", "\u00c0\u00e0ng\u00fal\u00edl\u00e0" },
            { "AL", "\u00c0l\u00f9b\u00e0n\u00ed\u00e1n\u00ec" },
            { "AM", "Am\u00e9n\u00ed\u00e0" },
            { "AO", "\u00c0\u00e0ng\u00f3l\u00e0" },
            { "AQ", "Antak\u00edt\u00edk\u00e0" },
            { "AR", "Agent\u00edn\u00e0" },
            { "AS", "S\u00e1m\u00f3\u00e1n\u00ec ti Or\u00edl\u1eb9\u0301\u00e8de \u00c0m\u00e9r\u00edk\u00e0" },
            { "AT", "As\u00edt\u00edr\u00ed\u00e0" },
            { "AU", "\u00c1str\u00e0l\u00ec\u00e1" },
            { "AW", "\u00c1r\u00fab\u00e0" },
            { "AX", "\u00c0w\u1ecdn Er\u00e9k\u00f9s\u00f9 ti \u00c5land" },
            { "AZ", "As\u1eb9\u0301b\u00e1j\u00e1n\u00ec" },
            { "BA", "B\u1ecd\u0300s\u00edn\u00ed\u00e0 \u00e0ti \u1eb8tis\u1eb9g\u00f3f\u00edn\u00e0" },
            { "BB", "B\u00e1b\u00e1d\u00f3s\u00ec" },
            { "BD", "B\u00e1ng\u00e1l\u00e1d\u00e9s\u00ec" },
            { "BE", "B\u00e9g\u00ed\u1ecd\u0301m\u00f9" },
            { "BF", "B\u00f9\u00f9k\u00edn\u00e1 Fas\u00f2" },
            { "BG", "B\u00f9\u00f9g\u00e1r\u00ed\u00e0" },
            { "BH", "B\u00e1r\u00e1n\u00ec" },
            { "BI", "B\u00f9\u00f9r\u00fand\u00ec" },
            { "BJ", "B\u1eb9\u0300n\u1eb9\u0300" },
            { "BL", "\u00ccl\u00fa B\u00e1t\u00edl\u1eb9\u0301m\u00ec" },
            { "BM", "B\u00e9m\u00fad\u00e0" },
            { "BN", "B\u00far\u00fan\u1eb9\u0301l\u00ec" },
            { "BO", "B\u1ecd\u0300l\u00edf\u00edy\u00e0" },
            { "BQ", "K\u00e0r\u00edb\u00ed\u00e1n\u00ec ti N\u1eb9\u0301d\u00e1l\u00e1nd\u00ec" },
            { "BR", "B\u00e0r\u00e0s\u00edl\u00ec" },
            { "BS", "B\u00e0h\u00e1m\u00e1s\u00ec" },
            { "BT", "B\u00fat\u00e1n\u00ec" },
            { "BV", "Er\u00e9k\u00f9s\u00f9 Bouvet" },
            { "BW", "B\u1ecd\u0300t\u00ecs\u00faw\u00e1n\u00e0" },
            { "BY", "B\u00e9l\u00e1r\u00fas\u00ec" },
            { "BZ", "B\u00e8l\u00eds\u1eb9\u0300" },
            { "CA", "K\u00e1n\u00e1d\u00e0" },
            { "CC", "Er\u00e9k\u00f9s\u00f9 Cocos (Keeling)" },
            { "CD", "K\u00f3\u0144g\u00f2 \u2013 Kinshasa" },
            { "CF", "\u00c0rin g\u00f9ngun \u00c1f\u00edr\u00edk\u00e0" },
            { "CG", "K\u00f3\u0144g\u00f2 \u2013 Brazaville" },
            { "CH", "switi\u1e63ilandi" },
            { "CI", "K\u00f3\u00fat\u00e8 for\u00e0" },
            { "CK", "Et\u00edokun K\u00f9\u00fak\u00f9" },
            { "CL", "\u1e62\u00edl\u00e8" },
            { "CM", "Kamer\u00fa\u00fan\u00ec" },
            { "CN", "\u1e62\u00e1\u00edn\u00e0" },
            { "CO", "K\u00f2l\u00f3m\u00edb\u00eca" },
            { "CP", "Er\u00e9k\u00f9s\u00f9 Clipperston" },
            { "CR", "Kuusita R\u00edk\u00e0" },
            { "CU", "K\u00fab\u00e0" },
            { "CV", "Et\u00edokun K\u00e1p\u00e9 f\u00e9nd\u00e8" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Er\u00e9k\u00f9s\u00f9 Christmas" },
            { "CY", "K\u00far\u00fas\u00ec" },
            { "CZ", "\u1e62\u1eb9\u0301\u1eb9\u0301k\u00ec" },
            { "DE", "J\u00e1m\u00e1n\u00ec" },
            { "DG", "Diego Ga\u1e63ia" },
            { "DJ", "D\u00edb\u1ecd\u0301\u00f3t\u00ec" },
            { "DK", "D\u1eb9\u0301m\u00e1k\u00ec" },
            { "DM", "D\u00f2m\u00edn\u00edk\u00e0" },
            { "DO", "D\u00f2m\u00edn\u00edk\u00e1n\u00ec" },
            { "DZ", "\u00c0l\u00f9g\u00e8r\u00ed\u00e1n\u00ec" },
            { "EA", "Seuta \u00e0ti Melilla" },
            { "EC", "Eku\u00e1d\u00f2" },
            { "EE", "Esitonia" },
            { "EG", "\u00c9g\u00edp\u00edt\u00ec" },
            { "EH", "\u00ccw\u1ecd\u0300\u00f2\u00f2r\u00f9n S\u00e0h\u00e1r\u00e0" },
            { "ER", "Eritira" },
            { "ES", "Sipani" },
            { "ET", "Etopia" },
            { "EU", "\u00c0pap\u1ecd\u0300 Y\u00far\u00f3\u00f2p\u00f9" },
            { "EZ", "Agb\u00e8gb\u00e8 Y\u00far\u00f2" },
            { "FI", "Filandi" },
            { "FJ", "Fiji" },
            { "FK", "Etikun Fakalandi" },
            { "FM", "Makoronesia" },
            { "FO", "\u00c0w\u1ecdn Er\u00e9k\u00f9s\u00f9 ti Faroe" },
            { "FR", "Faranse" },
            { "GA", "Gabon" },
            { "GB", "G\u1eb9\u0300\u1eb9\u0301s\u00ec" },
            { "GD", "Genada" },
            { "GE", "G\u1ecdgia" },
            { "GF", "Firen\u1e63i Guana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibaratara" },
            { "GL", "Gerelandi" },
            { "GM", "Gambia" },
            { "GN", "Gene" },
            { "GP", "Gadelope" },
            { "GQ", "Ekutoria Gini" },
            { "GR", "Geriisi" },
            { "GS", "G\u00fa\u00fas\u00f9 Georgia \u00e0ti G\u00fa\u00fas\u00f9 \u00c0w\u1ecdn Er\u00e9k\u00f9s\u00f9 Sandwich" },
            { "GT", "Guatemala" },
            { "GU", "Guamu" },
            { "GW", "Gene-Busau" },
            { "GY", "Guyana" },
            { "HK", "Agb\u00e8gb\u00e8 \u00cc\u1e63\u00e0k\u00f3so \u00cc\u1e63\u00fan\u00e1 Hong Kong T\u00ed \u1e62\u00e1n\u00e0 \u0143 Dar\u00ed" },
            { "HM", "Er\u00e9k\u00f9s\u00f9 Heard \u00e0ti Er\u00e9k\u00f9s\u00f9 McDonald" },
            { "HN", "Hondurasi" },
            { "HR", "K\u00f2r\u00f3\u00e1t\u00ed\u00e0" },
            { "HT", "Haati" },
            { "HU", "Hungari" },
            { "IC", "\u1eb8r\u00e9k\u00f9s\u00f9 K\u00e1n\u00e1r\u00ec" },
            { "ID", "Indonesia" },
            { "IE", "Ailandi" },
            { "IL", "Iser\u1eb9li" },
            { "IM", "Isle of Man" },
            { "IN", "India" },
            { "IO", "Et\u00edkun \u00cdnd\u00ed\u00e1n\u00ec ti \u00ccl\u00fa B\u00edr\u00edt\u00eds\u00ec" },
            { "IQ", "Iraki" },
            { "IR", "Irani" },
            { "IS", "A\u1e63ilandi" },
            { "IT", "It\u00e1li" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "J\u1ecddani" },
            { "JP", "Japani" },
            { "KE", "Kenya" },
            { "KG", "Kuri\u1e63isitani" },
            { "KH", "K\u00e0m\u00f9b\u00f3d\u00ed\u00e0" },
            { "KI", "Kiribati" },
            { "KM", "K\u00f2m\u00f2r\u00f3s\u00ec" },
            { "KN", "Kiiti ati Neefi" },
            { "KP", "Guusu K\u1ecdria" },
            { "KR", "Ariwa K\u1ecdria" },
            { "KW", "Kuweti" },
            { "KY", "Et\u00edokun K\u00e1m\u00e1n\u00ec" },
            { "KZ", "Ka\u1e63a\u1e63atani" },
            { "LA", "Laosi" },
            { "LB", "Lebanoni" },
            { "LC", "Lu\u1e63ia" },
            { "LI", "L\u1eb9\u1e63it\u1eb9nisiteni" },
            { "LK", "Siri Lanka" },
            { "LR", "Laberia" },
            { "LS", "Lesoto" },
            { "LT", "Lituania" },
            { "LU", "Lusemogi" },
            { "LV", "Latifia" },
            { "LY", "Libiya" },
            { "MA", "Moroko" },
            { "MC", "Monako" },
            { "MD", "Modofia" },
            { "ME", "Montenegro" },
            { "MF", "\u00ccl\u00fa M\u00e0t\u00ecn\u00ec" },
            { "MG", "Madasika" },
            { "MH", "Etikun M\u00e1\u1e63ali" },
            { "MK", "\u00c0r\u00edw\u00e1 Macedonia" },
            { "ML", "Mali" },
            { "MM", "Manamari" },
            { "MN", "Mogolia" },
            { "MO", "Agb\u00e8gb\u00e8 \u00cc\u1e63\u00e0k\u00f3so P\u00e0t\u00e0k\u00ec Macao" },
            { "MP", "Etikun Guusu Mariana" },
            { "MQ", "Matinikuwi" },
            { "MR", "Maritania" },
            { "MS", "Motserati" },
            { "MT", "Malata" },
            { "MU", "Maritiusi" },
            { "MV", "Maladifi" },
            { "MW", "Malawi" },
            { "MX", "Mesiko" },
            { "MY", "Malasia" },
            { "MZ", "Mo\u1e63amibiku" },
            { "NA", "Namibia" },
            { "NC", "Kaledonia Titun" },
            { "NE", "N\u00e0\u00ecj\u00e1" },
            { "NF", "Etikun N\u1ecd\u0301\u00faf\u00f3k\u00ec" },
            { "NG", "N\u00e0\u00ecj\u00edr\u00ed\u00e0" },
            { "NI", "Nikaragua" },
            { "NL", "Nedalandi" },
            { "NO", "N\u1ecd\u1ecdwii" },
            { "NP", "Nepa" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "\u1e62ilandi Titun" },
            { "OM", "\u1ecc\u1ecdma" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Firen\u1e63i Polinesia" },
            { "PG", "Paapu ti Giini" },
            { "PH", "Filipini" },
            { "PK", "Pakisitan" },
            { "PL", "Polandi" },
            { "PM", "P\u1eb9\u1eb9ri ati mikuloni" },
            { "PN", "Pikarini" },
            { "PR", "P\u1ecdto Riko" },
            { "PS", "Agb\u00e8gb\u00e8 ara Pal\u1eb9s\u00edt\u00edn\u00ec" },
            { "PT", "P\u1ecd\u0301t\u00fag\u00e0" },
            { "PW", "Paalu" },
            { "PY", "Paraguye" },
            { "QA", "Kota" },
            { "QO", "Agb\u00e8gb\u00e8 \u00d2\u1e63\u1ecd\u0301\u1ecd\u0301n\u00ed\u00e0" },
            { "RE", "Riuniyan" },
            { "RO", "Romaniya" },
            { "RS", "S\u1eb9\u0301b\u00ed\u00e0" },
            { "RU", "R\u1ecd\u1e63ia" },
            { "RW", "Ruwanda" },
            { "SA", "Saudi Arabia" },
            { "SB", "Etikun Solomoni" },
            { "SC", "\u1e62e\u1e63\u1eb9l\u1eb9si" },
            { "SD", "Sudani" },
            { "SE", "Swidini" },
            { "SG", "Singapo" },
            { "SH", "H\u1eb9lena" },
            { "SI", "Silofania" },
            { "SJ", "S\u00edf\u00e1b\u00e1\u00e0d\u00ec \u00e0ti J\u00e1n\u00ec M\u00e1y\u1eb9\u0300n\u00ec" },
            { "SK", "Silofakia" },
            { "SL", "Siria looni" },
            { "SM", "Sani Marino" },
            { "SN", "S\u1eb9n\u1eb9ga" },
            { "SO", "Somalia" },
            { "SR", "Surinami" },
            { "SS", "G\u00fa\u00fas\u00f9 Sudan" },
            { "ST", "Sao tomi ati pirii\u1e63ipi" },
            { "SV", "\u1eb8\u1eb9s\u00e1f\u00e1d\u00f2" },
            { "SX", "S\u00ednt\u00ec M\u00e1t\u1eb9\u0301\u1eb9\u0300n\u00ec" },
            { "SY", "Siria" },
            { "SZ", "Sa\u1e63iland" },
            { "TA", "Tristan da Kunha" },
            { "TC", "T\u1ecd\u1ecdki ati Etikun Kak\u1ecdsi" },
            { "TD", "\u1e62\u00e0\u00e0d\u00ec" },
            { "TF", "Agb\u00e8gb\u00e8 G\u00fa\u00fas\u00f9 Faran\u1e63\u00e9" },
            { "TG", "Togo" },
            { "TH", "Tailandi" },
            { "TJ", "Takisitani" },
            { "TK", "Tokelau" },
            { "TL", "\u00ccl\u00e0O\u00f2r\u00f9n T\u00edm\u1ecd\u0300" },
            { "TM", "T\u1ecd\u1ecdkimenisita" },
            { "TN", "Tuni\u1e63ia" },
            { "TO", "Tonga" },
            { "TR", "T\u1ecd\u1ecdki" },
            { "TT", "Tirinida ati Tobaga" },
            { "TV", "Tufalu" },
            { "TW", "Taiwani" },
            { "TZ", "T\u00e0\u01f9s\u00e1n\u00ed\u00e0" },
            { "UA", "Ukarini" },
            { "UG", "Uganda" },
            { "UM", "\u00c0w\u1ecdn Er\u00e9k\u00f9s\u00f9 K\u00e9k\u00e8k\u00e9 Agb\u00e8gb\u00e8 US" },
            { "UN", "\u00cc\u1e63\u1ecd\u0300kan \u00e0gb\u00e1y\u00e9" },
            { "US", "Am\u1eb9rik\u00e0" },
            { "UY", "Nruguayi" },
            { "UZ", "N\u1e63ib\u1eb9kisitani" },
            { "VA", "\u00ccl\u00fa Vatican" },
            { "VC", "Fis\u1eb9nnti ati Genadina" },
            { "VE", "F\u1eb9n\u1eb9\u1e63u\u1eb9la" },
            { "VG", "Et\u00edkun F\u00e1g\u00edn\u00ec ti \u00ecl\u00fa B\u00edr\u00edt\u00eds\u00ec" },
            { "VI", "Etikun Fagini ti Am\u1eb9rika" },
            { "VN", "F\u1eb9tinami" },
            { "VU", "Faniatu" },
            { "WF", "Wali ati futuna" },
            { "WS", "Sam\u1ecd" },
            { "XA", "\u00ecs\u1ecd\u0300r\u1ecd\u0300s\u00ed ir\u1ecd\u0301" },
            { "XB", "ibi ir\u1ecd\u0301" },
            { "XK", "K\u00f2s\u00f3f\u00f2" },
            { "YE", "Yemeni" },
            { "YT", "Mayote" },
            { "ZA", "G\u00fa\u00fa\u1e63\u00f9 \u00c1f\u00edr\u00edk\u00e0" },
            { "ZM", "\u1e62amibia" },
            { "ZW", "\u1e62imibabe" },
            { "ZZ", "\u00c0gb\u00e8gb\u00e8 \u00e0\u00ecm\u1ecd\u0300" },
            { "ab", "\u00c8d\u00e8 Abasia" },
            { "af", "\u00c8d\u00e8 Afrikani" },
            { "ak", "\u00c8d\u00e8 Akani" },
            { "am", "\u00c8d\u00e8 Amariki" },
            { "an", "\u00c8d\u00e8 Aragoni" },
            { "ar", "\u00c8d\u00e8 \u00c1r\u00e1b\u00eck\u00ec" },
            { "as", "\u00c8d\u00e8 Ti Assam" },
            { "av", "\u00c8d\u00e8 Afariki" },
            { "ay", "\u00c8d\u00e8 Amara" },
            { "az", "\u00c8d\u00e8 Azerbaijani" },
            { "ba", "\u00c8d\u00e8 Bashiri" },
            { "be", "\u00c8d\u00e8 Belarusi" },
            { "bg", "\u00c8d\u00e8 Bugaria" },
            { "bi", "\u00c8d\u00e8 Bisilama" },
            { "bm", "\u00c8d\u00e8 B\u00e1\u1e3fb\u00e0r\u00e0" },
            { "bn", "\u00c8d\u00e8 Bengali" },
            { "bo", "Tibet\u00e1n" },
            { "br", "\u00c8d\u00e8 Bretoni" },
            { "bs", "\u00c8d\u00e8 Bosnia" },
            { "ca", "\u00c8d\u00e8 Catala" },
            { "ce", "\u00c8d\u00e8 Chechen" },
            { "ch", "\u00c8d\u00e8 S\u0329amoro" },
            { "co", "\u00c8d\u00e8 Corsican" },
            { "cs", "\u00c8d\u00e8 Seeki" },
            { "cu", "\u00c8d\u00e8 S\u00edl\u00e1f\u00ed\u00edk\u00ec Il\u00e9 \u00ccj\u1ecd\u0301s\u00ecn" },
            { "cv", "\u00c8d\u00e8 Shufasi" },
            { "cy", "\u00c8d\u00e8 Welshi" },
            { "da", "\u00c8d\u00e8 Il\u1eb9\u0300 Denmark" },
            { "de", "\u00c8d\u00e8 J\u00e1m\u00e1n\u00ec" },
            { "dv", "\u00c8d\u00e8 Difehi" },
            { "dz", "\u00c8d\u00e8 Dzongkha" },
            { "ee", "\u00c8d\u00e8 Ew\u00e8" },
            { "el", "\u00c8d\u00e8 Giriki" },
            { "en", "\u00c8d\u00e8 G\u1eb9\u0300\u1eb9\u0301s\u00ec" },
            { "eo", "\u00c8d\u00e8 Esperanto" },
            { "es", "\u00c8d\u00e8 S\u00edp\u00e1n\u00ed\u00ec\u1e63\u00ec" },
            { "et", "\u00c8d\u00e8 Estonia" },
            { "eu", "\u00c8d\u00e8 Baski" },
            { "fa", "\u00c8d\u00e8 Pasia" },
            { "ff", "\u00c8d\u00e8 F\u00fal\u00e0n\u00ed" },
            { "fi", "\u00c8d\u00e8 Finisi" },
            { "fj", "\u00c8d\u00e8 Fiji" },
            { "fo", "\u00c8d\u00e8 Faroesi" },
            { "fr", "\u00c8d\u00e8 Farans\u00e9" },
            { "fy", "\u00c8d\u00e8 Frisia" },
            { "ga", "\u00c8d\u00e8 Ireland" },
            { "gd", "\u00c8d\u00e8 Gaelik ti Ilu Scotland" },
            { "gl", "\u00c8d\u00e8 Galicia" },
            { "gn", "\u00c8d\u00e8 Guarani" },
            { "gu", "\u00c8d\u00e8 Gujarati" },
            { "gv", "M\u00e1\u01f9k\u00ec" },
            { "ha", "\u00c8d\u00e8 Hausa" },
            { "he", "\u00c8d\u00e8 Heberu" },
            { "hi", "\u00c8d\u00e8 H\u00ed\u0144d\u00ec" },
            { "hr", "\u00c8d\u00e8 Kroatia" },
            { "ht", "Haitian Creole" },
            { "hu", "\u00c8d\u00e8 Hungaria" },
            { "hy", "\u00c8d\u00e8 Ile Armenia" },
            { "hz", "\u00c8d\u00e8 Herero" },
            { "ia", "\u00c8d\u00e8 pipo" },
            { "id", "\u00c8d\u00e8 Indon\u00e9\u1e63\u00ed\u00e0" },
            { "ie", "Iru \u00c8d\u00e8" },
            { "ig", "\u00c8d\u00e8 Y\u00edb\u00f2" },
            { "ii", "\u1e62\u00edku\u00e1n Y\u00ec" },
            { "io", "\u00c8d\u00e8 Ido" },
            { "is", "\u00c8d\u00e8 Icelandic" },
            { "it", "\u00c8d\u00e8 \u00cdt\u00e1l\u00ec" },
            { "iu", "\u00c8d\u00e8 Inukitu" },
            { "ja", "\u00c8d\u00e8 J\u00e0p\u00e1\u00e0n\u00f9" },
            { "jv", "\u00c8d\u00e8 Javanasi" },
            { "ka", "\u00c8d\u00e8 Georgia" },
            { "ki", "K\u00edk\u00fay\u00f9" },
            { "kj", "\u00c8d\u00e8 Kuayama" },
            { "kk", "Ka\u1e63ak\u00ec" },
            { "kl", "Kalaal\u00eds\u00f9t\u00ec" },
            { "km", "\u00c8d\u00e8 kameri" },
            { "kn", "\u00c8d\u00e8 Kannada" },
            { "ko", "\u00c8d\u00e8 K\u00f2r\u00ed\u00e0" },
            { "kr", "\u00c8d\u00e8 Kanuri" },
            { "ks", "Ka\u1e63\u00edmir\u00ec" },
            { "ku", "K\u1ecddi\u1e63\u00ec" },
            { "kv", "\u00c8d\u00e8 Komi" },
            { "kw", "\u00c8d\u00e8 K\u1ecd\u0301n\u00ec\u00ec\u1e63\u00ec" },
            { "ky", "K\u00edr\u00edg\u00ed\u00ecs\u00ec" },
            { "la", "\u00c8d\u00e8 Latini" },
            { "lb", "L\u00f9\u1e63\u1eb9\u0301mb\u1ecd\u0301\u1ecd\u0300g\u00ec" },
            { "lg", "Ganda" },
            { "li", "\u00c8d\u00e8 Limbogishi" },
            { "ln", "L\u00ec\u01f9g\u00e1l\u00e0" },
            { "lo", metaValue_lo },
            { "lt", "\u00c8d\u00e8 Lithuania" },
            { "lu", "L\u00fab\u00e0-Katanga" },
            { "lv", "\u00c8d\u00e8 Latvianu" },
            { "mg", "Malagas\u00ec" },
            { "mh", "\u00c8d\u00e8 Mashali" },
            { "mi", "M\u00e0\u00f3r\u00ec" },
            { "mk", "\u00c8d\u00e8 Macedonia" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "\u00c8d\u00e8 marathi" },
            { "ms", "\u00c8d\u00e8 Malaya" },
            { "mt", "\u00c8d\u00e8 Malta" },
            { "my", "\u00c8d\u00e8 Bumiisi" },
            { "na", "\u00c8d\u00e8 Nauru" },
            { "nb", "N\u1ecd\u0301\u1ecd\u0301w\u00e8 Bok\u00edm\u00e0l" },
            { "nd", "\u00c0r\u00edw\u00e1 Ndebele" },
            { "ne", "\u00c8d\u00e8 Nepali" },
            { "ng", "\u00c8d\u00e8 Ndonga" },
            { "nl", "\u00c8d\u00e8 D\u1ecd\u0301\u1ecd\u0300\u1e63\u00ec" },
            { "nn", "N\u1ecd\u0301\u1ecd\u0301w\u00e8 N\u00edn\u1ecd\u0300s\u00eck\u00ec" },
            { "no", "\u00c8d\u00e8 Norway" },
            { "nr", "\u00c8d\u00e8 Gusu Ndebele" },
            { "nv", "\u00c8d\u00e8 Nafajo" },
            { "ny", "\u0143y\u00e1j\u00e0" },
            { "oc", "\u00c8d\u00e8 Occitani" },
            { "om", "\u00d2r\u00f2m\u1ecd\u0301" },
            { "or", metaValue_or },
            { "os", "\u1ecc\u1e63\u1eb9\u0301t\u00ed\u00eck\u00ec" },
            { "pa", "\u00c8d\u00e8 Punjabi" },
            { "pl", "\u00c8d\u00e8 P\u00f3l\u00e1\u01f9d\u00ec" },
            { "ps", "P\u00e1sh\u00edt\u00f2" },
            { "pt", "\u00c8d\u00e8 P\u1ecdtog\u00ed" },
            { "qu", "K\u00fa\u1eb9\u0301\u0144j\u00f9\u00e0" },
            { "rm", "R\u00f3m\u00e1\u01f9\u1e63\u00ec" },
            { "rn", "R\u00fa\u0144d\u00ec" },
            { "ro", "\u00c8d\u00e8 Romania" },
            { "ru", "\u00c8d\u00e8 R\u1ecd\u0301\u1e63\u00ed\u00e0" },
            { "rw", "\u00c8d\u00e8 Ruwanda" },
            { "sa", "\u00c8d\u00e8 awon ara Indo" },
            { "sc", "\u00c8d\u00e8 Sadini" },
            { "sd", "\u00c8d\u00e8 Sindhi" },
            { "se", "Ap\u00e1\u00e0r\u00edw\u00e1 Sami" },
            { "sg", "Sango" },
            { "sh", "\u00c8d\u00e8 Serbo-Croatiani" },
            { "si", "\u00c8d\u00e8 Sinhalese" },
            { "sk", "\u00c8d\u00e8 Slovaki" },
            { "sl", "\u00c8d\u00e8 Slovenia" },
            { "sm", "S\u00e1m\u00f3\u00e1n\u00f9" },
            { "sn", "\u1e62\u1ecdn\u00e0" },
            { "so", "\u00c8d\u00e8 ara Somalia" },
            { "sq", "\u00c8d\u00e8 Albania" },
            { "sr", "\u00c8d\u00e8 Serbia" },
            { "ss", "\u00c8d\u00e8 Suwati" },
            { "st", "\u00c8d\u00e8 Sesoto" },
            { "su", "\u00c8d\u00e8 Sudan\u00eds\u00ec" },
            { "sv", "\u00c8d\u00e8 Suwidiisi" },
            { "sw", "\u00c8d\u00e8 Swahili" },
            { "ta", "\u00c8d\u00e8 Tamili" },
            { "te", "\u00c8d\u00e8 Telugu" },
            { "tg", "T\u00e0j\u00ed\u00eck\u00ec" },
            { "th", "\u00c8d\u00e8 Tai" },
            { "ti", "\u00c8d\u00e8 Tigrinya" },
            { "tk", "\u00c8d\u00e8 Turkmen" },
            { "tn", "\u00c8d\u00e8 Suwana" },
            { "to", "T\u00f3\u0144g\u00e0n" },
            { "tr", "\u00c8d\u00e8 T\u1ecd\u1ecdkisi" },
            { "ts", "\u00c8d\u00e8 Songa" },
            { "tt", "Tatar\u00ed" },
            { "ty", "\u00c8d\u00e8 Tahiti" },
            { "ug", "Y\u00fag\u1ecd\u0300" },
            { "uk", "\u00c8d\u00e8 Ukania" },
            { "ur", "\u00c8d\u00e8 Udu" },
            { "uz", "\u00c8d\u00e8 Uzbek" },
            { "ve", "\u00c8d\u00e8 Fenda" },
            { "vi", "\u00c8d\u00e8 Jetinamu" },
            { "vo", "F\u1ecd\u0301l\u00e1p\u00f9\u00f9k\u00f9" },
            { "wa", "\u00c8d\u00e8 Waluni" },
            { "wo", "W\u1ecd\u0301l\u1ecd\u0301\u1ecd\u0300f\u00f9" },
            { "xh", "\u00c8d\u00e8 Xhosa" },
            { "yi", "\u00c8d\u00e8 Yiddishi" },
            { "yo", "\u00c8d\u00e8 Yor\u00f9b\u00e1" },
            { "zh", "Ed\u00e8 \u1e62\u00e1\u00edn\u00e0" },
            { "zu", "\u00c8d\u00e8 \u1e62ulu" },
            { "ace", "\u00c8d\u00e8 Akinisi" },
            { "ada", "\u00c8d\u00e8 Adame" },
            { "ady", "\u00c8d\u00e8 Adiji" },
            { "agq", "\u00c8d\u00e8 \u00c1g\u1eb9\u0300\u1eb9\u0300m\u00f9" },
            { "ain", "\u00c8d\u00e8 Ainu" },
            { "ale", "\u00c8d\u00e8 Aleti" },
            { "alt", "\u00c8d\u00e8 Gusu Ata" },
            { "ann", "\u00c8d\u00e8 Obolo" },
            { "anp", "\u00c8d\u00e8 Angika" },
            { "arn", "\u00c8d\u00e8 Mapushe" },
            { "arp", "\u00c8d\u00e8 Arapaho" },
            { "ars", "\u00c8d\u00e8 Arabiki ti Najidi" },
            { "asa", "\u00c8d\u00e8 Asu" },
            { "ast", "\u00c8d\u00e8 Asturian" },
            { "atj", "\u00c8d\u00e8 Atikameki" },
            { "awa", "\u00c8d\u00e8 Awadi" },
            { "ban", "\u00c8d\u00e8 Balini" },
            { "bas", "\u00c8d\u00e8 Basaa" },
            { "bem", "\u00c8d\u00e8 B\u00e9\u1e3fb\u00e0" },
            { "bez", "\u00c8d\u00e8 B\u1eb9\u0301n\u00e0" },
            { "bgc", "\u00c8d\u00e8 Haryanvi" },
            { "bho", "\u00c8d\u00e8 Bojuri" },
            { "bin", "\u00c8d\u00e8 Bini" },
            { "bla", "\u00c8d\u00e8 Sikiska" },
            { "brx", "\u00c8d\u00e8 B\u00f3d\u00f2" },
            { "bug", "\u00c8d\u00e8 Bugini" },
            { "byn", "\u00c8d\u00e8 Bilini" },
            { "cay", "\u00c8d\u00e8 Kayuga" },
            { "ccp", "\u00c8d\u00e8 Chakma" },
            { "ceb", "\u00c8d\u00e8 Cebuano" },
            { "cgg", "\u00c8d\u00e8 Chiga" },
            { "chk", "\u00c8d\u00e8 Shuki" },
            { "chm", "\u00c8d\u00e8 Mari" },
            { "cho", "\u00c8d\u00e8 Shokita" },
            { "chp", "\u00c8d\u00e8 Shipewa" },
            { "chr", "\u00c8d\u00e8 Sh\u1eb9\u0301r\u00f3ki\u00ec" },
            { "chy", "\u00c8d\u00e8 Sheyeni" },
            { "ckb", "\u00c0\u00e0rin Gb\u00f9ngb\u00f9n Kurdish" },
            { "clc", "\u00c8d\u00e8 Shikoti" },
            { "crg", "\u00c8d\u00e8 Misifu" },
            { "crj", "\u00c8d\u00e8 Gusu Ila-oorun Kri" },
            { "crk", "\u00c8d\u00e8 Papa Kri" },
            { "crl", "\u00c8d\u00e8 ti Ila oorun Ariwa Kri" },
            { "crm", "\u00c8d\u00e8 Moose Kri" },
            { "crr", "\u00c8d\u00e8 Alonkuia ti Karolina" },
            { "csw", "\u00c8d\u00e8 Swampi Kri" },
            { "dak", "\u00c8d\u00e8 Dakota" },
            { "dar", "\u00c8d\u00e8 Dagiwa" },
            { "dav", "T\u00e1\u00edt\u00e0" },
            { "dgr", "\u00c8d\u00e8 Dogribu" },
            { "dje", "\u1e62\u00e1r\u00fam\u00e0" },
            { "doi", "\u00c8d\u00e8 Dogiri" },
            { "dsb", "\u1e62\u00f3b\u00ed\u00e1n\u00f9 Ap\u00e1 \u00cc\u1e63\u00e0l\u1eb9\u0300" },
            { "dua", "\u00c8d\u00e8 Duala" },
            { "dyo", "Jola-Fonyi" },
            { "dzg", "\u00c8d\u00e8 Dasaga" },
            { "ebu", "\u00c8d\u00e8 \u1eb8mb\u00f9" },
            { "efi", "\u00c8d\u00e8 Efiki" },
            { "eka", "\u00c8d\u00e8 Ekaju" },
            { "ewo", "\u00c8d\u00e8 \u00c8w\u00f3\u01f9d\u00f2" },
            { "fil", "\u00c8d\u00e8 Filipino" },
            { "fon", "\u00c8d\u00e8 Fon" },
            { "frc", "\u00c8d\u00e8 Faranse ti Kajun" },
            { "frr", "\u00c8d\u00e8 Ariwa Frisa" },
            { "fur", "Firi\u00fal\u00ed\u00e0n\u00ec" },
            { "gaa", "\u00c8d\u00e8 Gaa" },
            { "gez", "Ede G\u1eb9\u0301s\u00ec" },
            { "gil", "\u00c8d\u00e8 Gibaati" },
            { "gor", "\u00c8d\u00e8 Gorontalo" },
            { "gsw", "S\u00faw\u00eds\u00ec ti J\u00e1m\u00e1n\u00ec" },
            { "guz", "Gusii" },
            { "gwi", "\u00c8d\u00e8 giwisi" },
            { "hai", "\u00c8d\u00e8 Haida" },
            { "haw", "Hawaiian" },
            { "hax", "\u00c8d\u00e8 Gusu Haida" },
            { "hil", "\u00c8d\u00e8 Hilgayo" },
            { "hmn", "Hmong" },
            { "hsb", "Sorbian Ap\u00e1 \u00d2k\u00e8" },
            { "hup", "\u00c8d\u00e8 Hupa" },
            { "hur", "\u00c8d\u00e8 Hakomelemi" },
            { "iba", "\u00c8d\u00e8 Iba" },
            { "ibb", "\u00c8d\u00e8 Ibibio" },
            { "ikt", "\u00c8d\u00e8 Iwoorun Inutitu ti Kanada" },
            { "ilo", "\u00c8d\u00e8 Iloko" },
            { "inh", "\u00c8d\u00e8 Ingusi" },
            { "jbo", "\u00c8d\u00e8 Lobani" },
            { "jgo", "\u0143g\u00f2mb\u00e0" },
            { "jmc", "M\u00e1\u1e63\u00e1m\u00e8" },
            { "kab", "Kabil\u00e8" },
            { "kac", "\u00c8d\u00e8 Kashini" },
            { "kaj", "\u00c8d\u00e8 Ju" },
            { "kam", "K\u00e1\u0144b\u00e0" },
            { "kbd", "\u00c8d\u00e8 Kabadia" },
            { "kcg", "\u00c8d\u00e8 Tiyapu" },
            { "kde", "M\u00e1kond\u00e9" },
            { "kea", "Kabufad\u00ed\u00e1n\u00f9" },
            { "kfo", "\u00c8d\u00e8 Koro" },
            { "kgp", "\u00c8d\u00e8 Kaigani" },
            { "kha", "\u00c8d\u00e8 Kasi" },
            { "khq", "Koira \u1e62\u00ed\u00edn\u00ec" },
            { "kkj", "K\u00e0k\u00f3" },
            { "kln", "K\u00e1l\u1eb9nj\u00edn" },
            { "kmb", "\u00c8d\u00e8 Kimbundu" },
            { "kok", "K\u00f3nk\u00e1n\u00ec" },
            { "kpe", "\u00c8d\u00e8 Pele" },
            { "krc", "\u00c8d\u00e8 Karasha-Baka" },
            { "krl", "\u00c8d\u00e8 Karelia" },
            { "kru", "\u00c8d\u00e8 Kuruki" },
            { "ksb", "\u1e62\u00e1\u0144b\u00e1l\u00e0" },
            { "ksf", "\u00c8d\u00e8 B\u00e1f\u00ed\u00e0" },
            { "ksh", "\u00c8d\u00e8 Colognian" },
            { "kum", "\u00c8d\u00e8 Kumiki" },
            { "kwk", "\u00c8d\u00e8 Kwawala" },
            { "lad", "\u00c8d\u00e8 Ladino" },
            { "lag", "L\u00e1\u0144g\u00ec" },
            { "lez", "\u00c8d\u00e8 Lesgina" },
            { "lil", "\u00c8d\u00e8 Liloeti" },
            { "lkt", "L\u00e1kota" },
            { "lou", "\u00c8d\u00e8 Kreoli ti Louisiana" },
            { "loz", "\u00c8d\u00e8 Lozi" },
            { "lrc", "Ap\u00e1\u00e0r\u00edw\u00e1 L\u00far\u00ec" },
            { "lsm", "\u00c8d\u00e8 Samia" },
            { "lua", "\u00c8d\u00e8 Luba Lulua" },
            { "lun", "\u00c8d\u00e8 Lunda" },
            { "lus", "\u00c8d\u00e8 Miso" },
            { "luy", "Luy\u00ed\u00e0" },
            { "mad", "\u00c8d\u00e8 Maduri" },
            { "mag", "\u00c8d\u00e8 Magahi" },
            { "mai", "\u00c8d\u00e8 Matihi" },
            { "mak", "\u00c8d\u00e8 Makasa" },
            { "mas", "M\u00e1s\u00e1\u00ec" },
            { "mdf", "\u00c8d\u00e8 Mokisa" },
            { "men", "\u00c8d\u00e8 Mende" },
            { "mer", "M\u00e9r\u00f9" },
            { "mfe", "Morisiyen" },
            { "mgh", "Makhuwa-Meeto" },
            { "mgo", "M\u00e9t\u00e0" },
            { "mic", "\u00c8d\u00e8 Mikmaki" },
            { "min", "\u00c8d\u00e8 Minakabau" },
            { "mni", "\u00c8d\u00e8 Manipuri" },
            { "moe", "\u00c8d\u00e8 Inuamu" },
            { "moh", "\u00c8d\u00e8 Mohaki" },
            { "mos", "\u00c8d\u00e8 Mosi" },
            { "mua", "M\u00fand\u00e0ng\u00ec" },
            { "mul", "\u1eccl\u1ecd\u0301p\u1ecd\u0300 \u00e8d\u00e8" },
            { "mus", "\u00c8d\u00e8 Muskogi" },
            { "mwl", "\u00c8d\u00e8 Mirandisi" },
            { "myv", "\u00c8d\u00e8 Esiya" },
            { "mzn", "Masanderani" },
            { "nap", "\u00c8d\u00e8 Neapolita" },
            { "naq", "N\u00e1m\u00e0" },
            { "nds", "J\u00e1m\u00e1n\u00ec \u00ecp\u00ecl\u1eb9\u0300" },
            { "new", "\u00c8d\u00e8 Newari" },
            { "nia", "\u00c8d\u00e8 Nia" },
            { "niu", "\u00c8d\u00e8 Niu" },
            { "nmg", "K\u00edw\u00e1\u1e63\u00ed\u00f2" },
            { "nnh", "Ngiemb\u00f9n\u00f9" },
            { "nog", "\u00c8d\u00e8 Nogai" },
            { "nqo", "\u00c8d\u00e8 Nko" },
            { "nso", "\u00c8d\u00e8 Ariwa Soto" },
            { "nus", "N\u00fa\u1eb9\u0300" },
            { "nyn", "\u0143y\u00e1k\u1ecd\u0301l\u00e8" },
            { "ojb", "\u00c8d\u00e8 Ariwa-iwoorun Ojibwa" },
            { "ojc", "\u00c8d\u00e8 Ojibwa Aarin" },
            { "ojs", "\u00c8d\u00e8 Oji Kri" },
            { "ojw", "\u00c8d\u00e8 Iwoorun Ojibwa" },
            { "oka", "\u00c8d\u00e8 Okanaga" },
            { "pag", "\u00c8d\u00e8 Pangasina" },
            { "pam", "\u00c8d\u00e8 Pampanga" },
            { "pap", "\u00c8d\u00e8 Papiamento" },
            { "pau", "\u00c8d\u00e8 Pala" },
            { "pcm", "\u00c8d\u00e8 Pijini ti Naijiriya" },
            { "pis", "\u00c8d\u00e8 Piji" },
            { "pqm", "\u00c8d\u00e8 Maliseti-Pasamkodi" },
            { "prg", "P\u00far\u00fa\u1e63\u00ed\u00e0n\u00f9" },
            { "rap", "\u00c8d\u00e8 Rapanu" },
            { "rar", "\u00c8d\u00e8 Rarotonga" },
            { "rhg", "\u00c8d\u00e8 Rohinga" },
            { "rof", "R\u00f3\u0144b\u00f2" },
            { "rup", "\u00c8d\u00e8 Aromani" },
            { "rwk", "Riwa" },
            { "sad", "\u00c8d\u00e8 Sandawe" },
            { "sah", "S\u00e0k\u00edh\u00e0" },
            { "saq", "Samburu" },
            { "sat", "\u00c8d\u00e8 Santali" },
            { "sba", "\u00c8d\u00e8 Ngambayi" },
            { "sbp", "Sangu" },
            { "scn", "\u00c8d\u00e8 Sikila" },
            { "sco", "\u00c8d\u00e8 Sikoti" },
            { "seh", "\u1e62\u1eb9n\u00e0" },
            { "ses", "Koiraboro Seni" },
            { "shi", "Ta\u1e63el\u00ed\u00ect\u00ec" },
            { "shn", "\u00c8d\u00e8 Shani" },
            { "slh", "\u00c8d\u00e8 Gusu Lushootseed" },
            { "smn", "Inari Sami" },
            { "sms", "\u00c8d\u00e8 Sikoti Smi" },
            { "snk", "\u00c8d\u00e8 Sonike" },
            { "srn", "\u00c8d\u00e8 Sirana Tongo" },
            { "str", "\u00c8d\u00e8 Sitirati Salisi" },
            { "suk", "\u00c8d\u00e8 Sukuma" },
            { "swb", "\u00c8d\u00e8 Komora" },
            { "syr", metaValue_syr },
            { "tce", "\u00c8d\u00e8 Gusu Tushoni" },
            { "tem", "\u00c8d\u00e8 Timne" },
            { "teo", "T\u1eb9\u0301s\u00f2" },
            { "tet", "\u00c8d\u00e8 Tetum" },
            { "tgx", "\u00c8d\u00e8 Tagisi" },
            { "tht", "\u00c8d\u00e8 Tajiti" },
            { "tig", "\u00c8d\u00e8 Tigre" },
            { "tlh", "\u00c8d\u00e8 Klingoni" },
            { "tli", "\u00c8d\u00e8 Tlingiti" },
            { "tok", "\u00c8d\u00e8 Toki Pona" },
            { "tpi", "\u00c8d\u00e8 Tok Pisini" },
            { "trv", "\u00c8d\u00e8 Taroko" },
            { "ttm", "\u00c8d\u00e8 Ariwa Tusoni" },
            { "tum", "\u00c8d\u00e8 Tumbuka" },
            { "tvl", "\u00c8d\u00e8 Tifalu" },
            { "twq", "Tasawak" },
            { "tyv", "\u00c8d\u00e8 Tuvini" },
            { "tzm", "\u00c0\u00e0rin Gb\u00f9ngb\u00f9n Atlas Tamazight" },
            { "udm", "\u00c8d\u00e8 Udmuti" },
            { "umb", "\u00c8d\u00e8 Umbundu" },
            { "und", "\u00c8d\u00e8 \u00e0\u00ecm\u1ecd\u0300" },
            { "vun", "Funjo" },
            { "wae", "W\u1ecds\u00e0" },
            { "wal", "\u00c8d\u00e8 Wolata" },
            { "war", "\u00c8d\u00e8 Wara" },
            { "wuu", "\u00c8d\u00e8 Wu ti Saina" },
            { "xal", "\u00c8d\u00e8 Kalimi" },
            { "xog", "\u1e62\u00f3g\u00e0" },
            { "yav", "Yangb\u1eb9n" },
            { "ybb", "\u00c8d\u00e8 Yemba" },
            { "yrl", "\u00c8d\u00e8 Ningatu" },
            { "yue", "\u00c8d\u00e8 Cantonese" },
            { "zgh", "\u00c0f\u1eb9n\u00f9k\u00f2 T\u00e1m\u00e1s\u00e1\u00ect\u00ec ti M\u00f2r\u00f3k\u00f2" },
            { "zun", "\u00c8d\u00e8 Suni" },
            { "zxx", "K\u00f2 s\u00ed \u00e0k\u00f3\u00f2n\u00fa el\u00e9d\u00e8" },
            { "zza", "\u00c8d\u00e8 Sasa" },
            { "Adlm", "\u00c8d\u00e8 Adam" },
            { "Arab", "\u00e8d\u00e8 L\u00e1r\u00fab\u00e1w\u00e1" },
            { "Aran", "\u00c8d\u00e8 Aran" },
            { "Armn", "\u00c0m\u1eb9\u0301n\u00ed\u00e0" },
            { "Beng", "B\u00e1\u0144g\u00edl\u00e0" },
            { "Bopo", "Bopom\u00f3f\u00f2" },
            { "Brai", "B\u00edr\u00e1\u00ecl\u00e8" },
            { "Cakm", "Kami" },
            { "Cans", "\u00c8d\u00e8 Apapo Onile Onisilebu ti Kanada" },
            { "Cher", "\u00c8d\u00e8 Sheroki" },
            { "Cyrl", "\u00e8d\u00e8 il\u1eb9\u0300 R\u1ecd\u0301\u1e63\u00ed\u00e0" },
            { "Deva", "D\u1eb9fanag\u00e1r\u00ec" },
            { "Ethi", "\u1eb8ti\u00f3p\u00ed\u00eck\u00ec" },
            { "Geor", "J\u1ecd\u0301j\u00ed\u00e0n\u00f9" },
            { "Grek", "J\u1ecd\u0301j\u00ed\u00e0" },
            { "Gujr", "Gujar\u00e1ti" },
            { "Guru", "Gurum\u00fakh\u00ec" },
            { "Hanb", "Han p\u1eb9\u0300l\u00fa Bopom\u00f3f\u00f2" },
            { "Hang", "H\u00e1\u0144g\u00f9l\u00f9" },
            { "Hani", "H\u00e1\u00e0n\u00f9" },
            { "Hans", "t\u00ed w\u1ecd\u0301n m\u00fa r\u1ecdr\u00f9n." },
            { "Hant", "Hans \u00e0t\u1ecdw\u1ecd\u0301d\u1ecd\u0301w\u1ecd\u0301" },
            { "Hebr", "H\u00e9b\u00e9r\u00f9" },
            { "Hira", "Hirag\u00e1n\u00e0" },
            { "Hrkt", "\u00ecl\u00e0n\u00e0 \u00e0f\u1ecdw\u1ecd\u0301k\u1ecd ar\u00e1 J\u00e0p\u00e1n\u00f9" },
            { "Jpan", "\u00e8d\u00e8 j\u00e0p\u00e1\u00e0n\u00f9" },
            { "Kana", "Katak\u00e1n\u00e0" },
            { "Khmr", "K\u1eb9m\u1eb9\u0300" },
            { "Knda", "Kanada" },
            { "Kore", "K\u00f3r\u00ed\u00e0" },
            { "Laoo", metaValue_lo },
            { "Latn", "\u00c8d\u00e8 L\u00e1t\u00ecn" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Mtei", "\u00c8d\u00e8 Meitei Mayeki" },
            { "Mymr", "My\u00e1nmar\u00e0" },
            { "Nkoo", "\u00c8d\u00e8 Nkoo" },
            { "Olck", "\u00c8d\u00e8 Ol Siki" },
            { "Orya", metaValue_or },
            { "Rohg", "\u00c8d\u00e8 Hanifi" },
            { "Sinh", "S\u00ecnh\u00e1l\u00e0" },
            { "Sund", "\u00c8d\u00e8 Sundani" },
            { "Syrc", metaValue_syr },
            { "Taml", "T\u00e1m\u00edl\u00ec" },
            { "Telu", "T\u00e9l\u00fag\u00f9" },
            { "Tfng", "\u00c8d\u00e8 Tifina" },
            { "Thaa", "Taana" },
            { "Tibt", "T\u00edb\u00e9t\u00e1n" },
            { "Vaii", "\u00c8d\u00e8 Fai" },
            { "Yiii", "\u00c8d\u00e8 Yi" },
            { "Zmth", "\u00c0m\u00ec \u00cc\u1e63\u00e8s\u00ecr\u00f2" },
            { "Zsye", "\u00c9m\u00f3j\u00ec" },
            { "Zsym", "\u00c0w\u1ecdn \u00e0m\u00ec" },
            { "Zxxx", "Aik\u1ecdsil\u1eb9" },
            { "Zyyy", "W\u1ecd\u0301p\u1ecd\u0300" },
            { "Zzzz", "\u00cc\u1e63\u1ecdw\u1ecd\u0301k\u1ecd\u0300w\u00e9 \u00e0\u00ecm\u1ecd\u0300" },
            { "de_AT", "\u00c8d\u00e8 J\u00e1m\u00e1n\u00ec (\u1ecc\u0301s\u00edr\u00ed\u00e0 )" },
            { "de_CH", "\u00c8d\u00e8 Il\u1eb9\u0300 J\u00e1m\u00e1n\u00ec (Or\u00edl\u1eb9\u0301\u00e8de sw\u00edts\u00e0land\u00ec)" },
            { "en_AU", "\u00c8d\u00e8 G\u1eb9\u0300\u1eb9\u0301s\u00ec (\u00f3r\u00edl\u1eb9\u0300-\u00e8d\u00e8 \u1eccsir\u00e9l\u00ed\u00e0)" },
            { "en_CA", "\u00c8d\u00e8 G\u1eb9\u0300\u1eb9\u0301s\u00ec (Or\u00edl\u1eb9\u0300-\u00e8d\u00e8 K\u00e1n\u00e1d\u00e0)" },
            { "en_GB", "\u00c8d\u00e8 \u00f2y\u00ecnb\u00f3 G\u1eb9\u0300\u1eb9\u0301s\u00ec" },
            { "es_ES", "\u00c8d\u00e8 S\u00edp\u00e1n\u00ed\u00ec\u1e63\u00ec (or\u00edl\u1eb9\u0300-\u00e8d\u00e8 Y\u00far\u00f3\u00f2p\u00f9)" },
            { "es_MX", "\u00c8d\u00e8 S\u00edp\u00e1n\u00ed\u00ec\u1e63\u00ec (or\u00edl\u1eb9\u0300-\u00e8d\u00e8 M\u1eb9\u0301s\u00edk\u00f2)" },
            { "fr_CA", "\u00c8d\u00e8 Farans\u00e9 (or\u00edl\u1eb9\u0300-\u00e8d\u00e8 K\u00e1n\u00e1d\u00e0)" },
            { "fr_CH", "\u00c8d\u00e8 Faran\u1e63\u00e9 (S\u00faw\u00eds\u00e0la\u01f9d\u00ec)" },
            { "pt_BR", "\u00c8d\u00e8 P\u1ecdtog\u00ed (Oril\u1eb9\u0300-\u00e8d\u00e8 Br\u00e0s\u00edl)" },
            { "pt_PT", "\u00c8d\u00e8 P\u1ecdtog\u00ed (or\u00edl\u1eb9\u0300-\u00e8d\u00e8 Y\u00far\u00f3\u00f2p\u00f9)" },
            { "es_419", "\u00c8d\u00e8 S\u00edp\u00e1n\u00ed\u00ec\u1e63\u00ec (or\u00edl\u1eb9\u0300-\u00e8d\u00e8 L\u00e1t\u00ecn-Am\u1eb9\u0301r\u00edk\u00e0)" },
            { "key.ca", "K\u00e0l\u1eb9\u0301\u0144d\u00e0" },
            { "key.cf", "\u00ccg\u00fanr\u00e9g\u00e9 K\u1ecd\u0301r\u1eb9\u0301\u0144s\u00ec" },
            { "key.co", "\u00c8t\u00f2 \u1eb8l\u1eb9\u0301s\u1eb9\u1eb9s\u1eb9" },
            { "key.cu", "K\u1ecd\u0301r\u1eb9\u0301\u0144s\u00ec" },
            { "key.hc", "\u00d2b\u00edr\u00edkiti W\u00e1k\u00e0t\u00ed (12 vs 24)" },
            { "key.lb", "\u00c0ra \u00ccda \u00ccl\u00e0" },
            { "key.ms", "\u00c8to \u00ccdiw\u1ecd\u0300n" },
            { "key.nu", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0" },
            { "hi_Latn", "\u00c8d\u00e8 H\u00ednd\u00ec (L\u00e1t\u00ecn\u00ec)" },
            { "zh_Hans", "\u1eb8d\u00e8 \u1e62\u00e1\u00edn\u00e0 On\u00edr\u1ecd\u0300r\u00f9n" },
            { "zh_Hant", "\u00c8d\u00e8 \u1e62\u00e1\u00edn\u00e0 \u00ccb\u00edl\u1eb9\u0300" },
            { "type.ca.roc", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 Minguo" },
            { "type.hc.h11", "\u00c8to W\u00e1k\u00e0t\u00ed 12 (0\u201311)" },
            { "type.hc.h12", "\u00c8to W\u00e1k\u00e0t\u00ed 12 (1\u201312)" },
            { "type.hc.h23", "\u00c8to W\u00e1k\u00e0t\u00ed 24 (0\u201323)" },
            { "type.hc.h24", "\u00c8to W\u00e1k\u00e0t\u00ed 24 (1\u201324)" },
            { "type.nu.arab", "\u00e0w\u1ecdn d\u00edj\u00edt\u00ec L\u00e0rub\u00e1w\u00e1-\u00cdnd\u00ed\u00e0" },
            { "type.nu.armn", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u00c0m\u1eb9\u0301n\u00ed\u00e0" },
            { "type.nu.beng", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec B\u00e1\u0144g\u00edl\u00e0" },
            { "type.nu.cakm", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec Shakma" },
            { "type.nu.deva", "\u00c0w\u1ecdn d\u00edj\u00ec\u00ect\u00ec Defanag\u00e1r\u00ec" },
            { "type.nu.ethi", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u1eb8ti\u00f3p\u00ed\u00eck\u00ec" },
            { "type.nu.geor", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 J\u1ecd\u0301j\u00ed\u00e0" },
            { "type.nu.grek", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 G\u00edr\u00ed\u00eck\u00ec" },
            { "type.nu.gujr", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec G\u00f9j\u00e1r\u00e1t\u00ec" },
            { "type.nu.guru", "\u00c0w\u1ecdn D\u00edj\u00ed\u00ect\u00ec Gurumuk\u00ec" },
            { "type.nu.hans", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u00ccr\u1ecd\u0300r\u00f9n ti \u1e62\u00e1\u00ecn\u00e0" },
            { "type.nu.hant", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u00ccb\u00edl\u1eb9\u0300 \u1e62\u00e1\u00ecn\u00e0" },
            { "type.nu.hebr", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 H\u00e9b\u00e9r\u00f9" },
            { "type.nu.java", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec Jafaniisi" },
            { "type.nu.jpan", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 J\u00e1p\u00e0n\u00f9" },
            { "type.nu.khmr", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec K\u1eb9\u0301m\u1eb9\u0300" },
            { "type.nu.knda", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec kanada" },
            { "type.nu.laoo", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec L\u00e1\u00f3" },
            { "type.nu.latn", "D\u00edj\u00ed\u00edt\u00ec \u00ccw\u1ecd\u0300 O\u00f2r\u00f9n" },
            { "type.nu.mlym", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec M\u00e1l\u00e0y\u00e1l\u00e1m\u00f9" },
            { "type.nu.mtei", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec Mete Mayeki" },
            { "type.nu.mymr", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec My\u00e1nmar\u00ed" },
            { "type.nu.olck", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec Shiki" },
            { "type.nu.orya", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec \u00d2d\u00ed\u00e0" },
            { "type.nu.taml", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec \u00ccb\u00edl\u1eb9\u0300 T\u00e1m\u00edl\u00f9" },
            { "type.nu.telu", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec T\u00e9l\u00fag\u00f9" },
            { "type.nu.thai", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec Thai" },
            { "type.nu.tibt", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec Tibet\u00e1n" },
            { "type.nu.vaii", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec Fai" },
            { "type.ca.dangi", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 dangi" },
            { "type.co.ducet", "\u00c8t\u00f2 \u1eb8l\u1eb9\u0301s\u1eb9\u1eb9s\u1eb9 \u00c0k\u00f9\u00e0y\u00e0n Unicode" },
            { "type.lb.loose", "\u00c0ra \u00ccda \u00ccl\u00e0 T\u00edt\u00fa" },
            { "type.nu.roman", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec R\u00f3m\u00e1n\u00f9" },
            { "type.ca.coptic", "\u00c8d\u00e8 Kopti" },
            { "type.ca.hebrew", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 H\u00e9b\u00e9r\u00f9" },
            { "type.co.search", "\u00cc\u1e63\u00e0w\u00e1r\u00ed \u00c8te-Gbogbogb\u00f2" },
            { "type.lb.normal", "\u00c0ra \u00ccda \u00ccl\u00e0 D\u00e9\u00e9d\u00e9\u00e9" },
            { "type.lb.strict", "\u00c0ra \u00ccda \u00ccl\u00e0 M\u00edm\u00fan\u00e1" },
            { "type.ms.metric", "\u00c8to M\u1eb9\u0301t\u00edr\u00ed\u00eck\u00ec" },
            { "type.ca.chinese", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 ti \u1e62\u00e1\u00ecn\u00e0" },
            { "type.ca.islamic", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 L\u00e1r\u00fab\u00e1w\u00e1" },
            { "type.ca.iso8601", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 ISO-8601" },
            { "type.ca.persian", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 P\u00e1s\u00ed\u00e0n\u00f9" },
            { "type.cf.account", "\u00ccg\u00fanr\u00e9g\u00e9 \u00cc\u1e63ir\u00f2 Ow\u00f3 K\u1ecd\u0301r\u1eb9\u0301\u0144s\u00ec" },
            { "type.nu.arabext", "\u00c0w\u1ecdn D\u00edj\u00ed\u00ect\u00ec L\u00e1r\u00fab\u00e1w\u00e1-\u00cdnd\u00ed\u00e0 f\u00edf\u1eb9\u0300" },
            { "type.nu.armnlow", "\u00c0w\u1ecdn N\u1ecd\u0301\u0144b\u00e0 K\u00e9k\u00e8k\u00e9 ti Am\u1eb9\u0301r\u00edk\u00e0" },
            { "type.nu.greklow", "\u00c0w\u1ecdn N\u1ecd\u0301\u0144b\u00e0 G\u00edr\u00ed\u00eck\u00ec K\u00e9k\u00e8k\u00e9" },
            { "type.nu.hanidec", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 D\u1eb9\u0301s\u00edm\u00e0 \u1e62\u00e1\u00ecn\u00e0" },
            { "type.nu.hansfin", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u00cc\u1e63\u00fan\u00e1 \u00ccr\u1ecd\u0300r\u00f9n \u1e62\u00e1\u00ecn\u00e0" },
            { "type.nu.hantfin", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u00cc\u1e63\u00fan\u00e1 \u00ccb\u00edl\u1eb9\u0300 \u1e62\u00e1\u00ecn\u00e0" },
            { "type.nu.jpanfin", "\u00c0w\u1ecdn n\u1ecd\u0301\u0144b\u00e0 \u00cc\u1e63\u00fan\u00e1 J\u00e0p\u00e1\u00e0n\u00f9" },
            { "type.nu.tamldec", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec T\u00e0m\u00edl\u00f9" },
            { "type.ca.buddhist", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 Buddhist" },
            { "type.ca.ethiopic", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 \u1eb8t\u00ed\u00f3p\u00ed\u00eck\u00ec" },
            { "type.ca.japanese", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 ti J\u00e0p\u00e1n\u00f9" },
            { "type.cf.standard", "\u00ccg\u00fanr\u00e9g\u00e9 Gb\u00e8d\u00e9ke K\u1ecd\u0301r\u1eb9\u0301\u0144s\u00ec" },
            { "type.co.standard", "\u00ccl\u00e0n\u00e0 On\u00edr\u00faur\u00fa \u00c8t\u00f2" },
            { "type.ms.uksystem", "\u00c8to \u00ccdiw\u1ecd\u0300n \u1eccba" },
            { "type.ms.ussystem", "\u00c8to \u00ccdiw\u1ecd\u0300n US" },
            { "type.nu.fullwide", "\u00c0w\u1ecdn D\u00edj\u00ed\u00ect\u00ec F\u00edf\u1eb9\u0300-\u1eb8\u0300k\u00fan" },
            { "type.nu.romanlow", "\u00c0w\u1ecdn d\u00edj\u00ed\u00ect\u00ec R\u00f3m\u00e1n\u00f9 K\u00e9ker\u00e9" },
            { "type.ca.gregorian", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 Gregory" },
            { "type.ca.islamic-civil", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 ti Musulumi" },
            { "type.ca.islamic-umalqura", "K\u00e0l\u1eb9\u0301\u0144d\u00e0 Musulumi" },
            { "type.ca.ethiopic-amete-alem", "\u00c8d\u00e8 Kalenda Alem Amete tio Etiopia" },
        };
        return data;
    }
}
