/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_wae extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_TO = "Tonga";
        final String metaValue_ar = "Arabi\u0161";
        final String metaValue_hy = "Armeni\u0161";
        final String metaValue_bn = "Bengali\u0161";
        final String metaValue_ka = "Georgi\u0161";
        final String metaValue_el = "Gri\u010di\u0161";
        final String metaValue_gu = "Gujarati";
        final String metaValue_he = "Hebr\u00e4i\u0161";
        final String metaValue_ja = "Japani\u0161";
        final String metaValue_kn = "Kannada";
        final String metaValue_lo = "Laoti\u0161";
        final String metaValue_la = "Latini\u0161";
        final String metaValue_my = "Burmesi\u0161";
        final String metaValue_or = "Oriya";
        final String metaValue_si = "Singalesi\u0161";
        final String metaValue_ta = "Tamili\u0161";
        final String metaValue_te = "Telugu";
        final Object[][] data = new Object[][] {
            { "001", "W\u00e4ld" },
            { "002", "Afrika" },
            { "003", "Nordamerika" },
            { "005", "S\u00fcdamerika" },
            { "009", "Ozeanie" },
            { "011", "We\u0161tafrika" },
            { "013", "Zentralamerika" },
            { "014", "O\u0161tafrika" },
            { "015", "Nordafrika" },
            { "017", "Mittelafrika" },
            { "018", "S\u00fcdli\u010ds Afrika" },
            { "019", "Amerikani\u0161 Kontin\u00e4nt" },
            { "021", "N\u00f6rdli\u010ds Amerika" },
            { "029", "Karibik" },
            { "030", "O\u0161tasie" },
            { "034", "S\u00fcdasie" },
            { "035", "S\u00fcdo\u0161tasie" },
            { "039", "S\u00fcdeuropa" },
            { "053", "Au\u0161tralie und Niws\u00e9land" },
            { "054", "Melanesie" },
            { "057", "Mikronesi\u0161es Inselgebiet" },
            { "061", "Polinesie" },
            { "142", "Asie" },
            { "143", "Zentralasie" },
            { "145", "We\u0161tasie" },
            { "150", "Europa" },
            { "151", "O\u0161teuropa" },
            { "154", "Nordeuropa" },
            { "155", "We\u0161teuropa" },
            { "419", "Lat\u00edamerika" },
            { "AC", "Himmelf\u00e1rtsinsla" },
            { "AD", "Andorra" },
            { "AE", "Vereinigti Arabi\u0161e Emirat" },
            { "AF", "Afgani\u0161tan" },
            { "AG", "Antigua und Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanie" },
            { "AM", "Armenie" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentinie" },
            { "AS", "Amerikani\u0161 Samoa" },
            { "AT", "\u00d6\u0161tri\u010d" },
            { "AU", "Australie" },
            { "AW", "Aruba" },
            { "AX", "Alandinsl\u00e4" },
            { "AZ", "Aserbaid\u0161an" },
            { "BA", "Bosnie und Herzegovina" },
            { "BB", "Barbados" },
            { "BD", "Banglade\u0161" },
            { "BE", "Belgie" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarie" },
            { "BH", "Ba\u010drain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Bartholom\u00e4us-Insla" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Boliwie" },
            { "BR", "Brasilie" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvetinsla" },
            { "BW", "Botswana" },
            { "BY", "W\u00edsrussland" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosinsl\u00e4" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Zentralafrikani\u0161i Rebublik" },
            { "CG", "Kongo Brazzaville" },
            { "CH", "Schwiz" },
            { "CI", "Elfebeik\u00fc\u0161ta" },
            { "CK", "Cookinsl\u00e4" },
            { "CL", "T\u0161ile" },
            { "CM", "Kamerun" },
            { "CN", "China" },
            { "CO", "Kolumbie" },
            { "CP", "Clipperton Insla" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Kap Verde" },
            { "CX", "Wien\u00e4\u010dtsinsl\u00e4" },
            { "CY", "Zypre" },
            { "CZ", "T\u0161e\u010die" },
            { "DE", "Tit\u0161land" },
            { "DG", "Diego Garcia" },
            { "DJ", "D\u0161ibuti" },
            { "DK", "D\u00e4nemark" },
            { "DM", "Doninica" },
            { "DO", "Dominikani\u0161i Rebublik" },
            { "DZ", "Algerie" },
            { "EA", "Ceuta und Melilla" },
            { "EC", "Ecuador" },
            { "EE", "E\u0161tland" },
            { "EG", "Egypte" },
            { "EH", "We\u0161tsahara" },
            { "ER", "Eritrea" },
            { "ES", "Schpanie" },
            { "ET", "Ethiopie" },
            { "EU", "Europ\u00e4i\u0161i Unio" },
            { "FI", "Finnland" },
            { "FJ", "Fid\u0161i" },
            { "FK", "Falklandinsl\u00e4" },
            { "FM", "Mikronesie" },
            { "FO", "F\u00e4r\u00f6e" },
            { "FR", "Frankri\u010d" },
            { "GA", "Gabon" },
            { "GB", "England" },
            { "GD", "Grenada" },
            { "GE", "Georgie" },
            { "GF", "Franz\u00f6si\u0161 Guiana" },
            { "GG", "Guernsey" },
            { "GH", "Gana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f6nland" },
            { "GM", "Gambia" },
            { "GN", "Ginea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Equatorialginea" },
            { "GR", "Gri\u010deland" },
            { "GS", "S\u00fcdgeorgie und d\u2019s\u00fcdli\u010de Senwi\u010dinsl\u00e4" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Ginea Bissau" },
            { "GY", "Guyana" },
            { "HK", "Sonderverwaltigszona Hongkong" },
            { "HM", "Heard- und McDonald-Insl\u00e4" },
            { "HN", "Honduras" },
            { "HR", "Kroatie" },
            { "HT", "Haiti" },
            { "HU", "Ungare" },
            { "IC", "Kanari\u0161e Insl\u00e4" },
            { "ID", "Indonesie" },
            { "IE", "Irland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "Indie" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italie" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordanie" },
            { "JP", "Japan" },
            { "KE", "Kenya" },
            { "KG", "Kirgi\u0161tan" },
            { "KH", "Kambod\u0161a" },
            { "KI", "Kiribati" },
            { "KM", "Komore" },
            { "KN", "St. Kitts und Nevis" },
            { "KP", "Nordkorea" },
            { "KR", "S\u00fcdkorea" },
            { "KW", "Kuweit" },
            { "KY", "Kaimaninsl\u00e4" },
            { "KZ", "Kasa\u010dstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "St. Lucia" },
            { "LI", "Lie\u010dte\u0161tei" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litaue" },
            { "LU", "Luxeburg" },
            { "LV", "Lettland" },
            { "LY", "L\u00fcbie" },
            { "MA", "Maroko" },
            { "MC", "Monago" },
            { "MD", "Moldau" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Mar\u0161alinsl\u00e4" },
            { "ML", "Mali" },
            { "MM", "Burma" },
            { "MN", "Mongolei" },
            { "MO", "Sonderverwaltigszona Makau" },
            { "MP", "N\u00f6rdli\u010di Mariane" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanie" },
            { "MS", "Monserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Malediwe" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "NC", "Niwkaledonie" },
            { "NE", "Niger" },
            { "NF", "Norfolkinsla" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Holand" },
            { "NO", "Norw\u00e4ge" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Niws\u00e9land" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Franz\u00f6si\u0161 Polinesie" },
            { "PG", "Papua Niwginea" },
            { "PH", "Philippine" },
            { "PK", "Paki\u0161tan" },
            { "PL", "Pole" },
            { "PM", "St. Pierre und Miquelon" },
            { "PN", "Pitcairn" },
            { "PR", "Puerto Rico" },
            { "PS", "Pale\u0161tina" },
            { "PT", "Portugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Katar" },
            { "QO", "\u00dcssers Ozeanie" },
            { "RE", "R\u00e9union" },
            { "RO", "Rum\u00e4nie" },
            { "RS", "Serbie" },
            { "RU", "Russland" },
            { "RW", "Ruanda" },
            { "SA", "Saudi Arabie" },
            { "SB", "Salomone" },
            { "SC", "Se\u010delle" },
            { "SD", "Sudan" },
            { "SE", "Schwede" },
            { "SG", "Singapur" },
            { "SH", "St. Helena" },
            { "SI", "Slowenie" },
            { "SJ", "Svalbard und Jan Mayen" },
            { "SK", "Slowakei" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "ST", "S\u00e3o Tom\u00e9 and Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SY", "S\u00fcrie" },
            { "SZ", "Swasiland" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- und Caicosinsl\u00e4" },
            { "TD", "T\u0161ad" },
            { "TF", "Franz\u00f6si\u0161i S\u00fcd- und Antarktisgebiet" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tad\u0161ikistan" },
            { "TK", "Tokelau" },
            { "TL", "O\u0161ttimor" },
            { "TM", "Turkmeni\u0161tan" },
            { "TN", "Tunesie" },
            { "TO", metaValue_TO },
            { "TR", "T\u00fcrkei" },
            { "TT", "Trinidad und Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansania" },
            { "UA", "Ukraine" },
            { "UG", "Uganda" },
            { "UM", "Amerikani\u0161 Ozeanie" },
            { "US", "Amerika" },
            { "UY", "Urugauy" },
            { "UZ", "Usbeki\u0161tan" },
            { "VA", "Vatikan" },
            { "VC", "St. Vincent und d\u2019Grenadine" },
            { "VE", "Venezuela" },
            { "VG", "Briti\u0161i Jungfr\u00f6iwinsl\u00e4" },
            { "VI", "Amerikani\u0161i Jungfr\u00f6iwinsl\u00e4" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis und Futuna" },
            { "WS", "Samoa" },
            { "YE", "J\u00e9me" },
            { "YT", "Moyette" },
            { "ZA", "S\u00fcdafrika" },
            { "ZM", "Sambia" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Unbekannti Regio" },
            { "ab", "Ab\u010dasi\u0161" },
            { "af", "Afrik\u00e1ns" },
            { "am", "Amhari\u0161" },
            { "ar", metaValue_ar },
            { "as", "Assamesi\u0161" },
            { "ay", "Aymara" },
            { "az", "Serbaid\u0161ani\u0161" },
            { "be", "W\u00edsrussi\u0161" },
            { "bg", "Bulgari\u0161" },
            { "bn", metaValue_bn },
            { "bo", "Tibeti\u0161" },
            { "bs", "Bosni\u0161" },
            { "ca", "Katalani\u0161" },
            { "cs", "T\u0161e\u010di\u0161" },
            { "cy", "Walisi\u0161" },
            { "da", "D\u00e4ni\u0161" },
            { "de", "Tit\u0161" },
            { "dv", "Malediwi\u0161" },
            { "dz", "Butani\u0161" },
            { "el", metaValue_el },
            { "en", "Engli\u0161" },
            { "es", "Schpani\u0161" },
            { "et", "Estni\u0161" },
            { "eu", "Baski\u0161" },
            { "fa", "Persi\u0161" },
            { "fi", "Fini\u0161" },
            { "fj", "Fid\u0161iani\u0161" },
            { "fr", "W\u00e4l\u0161" },
            { "ga", "Iri\u0161" },
            { "gl", "Galizi\u0161" },
            { "gn", "Guarani" },
            { "gu", metaValue_gu },
            { "ha", "Hausa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "hr", "Kroati\u0161" },
            { "ht", "Haitiani\u0161" },
            { "hu", "Ungari\u0161" },
            { "hy", metaValue_hy },
            { "id", "Indonesi\u0161" },
            { "ig", "Igbo" },
            { "is", "Iisl\u00e4ndi\u0161" },
            { "it", "Italieni\u0161" },
            { "ja", metaValue_ja },
            { "ka", metaValue_ka },
            { "kk", "Kaza\u010di\u0161" },
            { "km", "Kambod\u0161ani\u0161" },
            { "kn", metaValue_kn },
            { "ko", "Koreani\u0161" },
            { "ks", "Ka\u0161miri\u0161" },
            { "ku", "Kurdi\u0161" },
            { "ky", "Kirgisi\u0161" },
            { "la", metaValue_la },
            { "lb", "Luxemburgi\u0161" },
            { "ln", "Lingala" },
            { "lo", metaValue_lo },
            { "lt", "Litaui\u0161" },
            { "lv", "Letti\u0161" },
            { "mg", "Malag\u00e1si" },
            { "mi", "Maori" },
            { "mk", "Mazedoni\u0161" },
            { "ml", "Malayalam" },
            { "mn", "Mongoli\u0161" },
            { "mr", "Marathi" },
            { "ms", "Mala\u00ed\u0161" },
            { "mt", "Maltesi\u0161" },
            { "my", metaValue_my },
            { "nb", "Norwegi\u0161 Bokm\u00e5l" },
            { "nd", "Nordndebele" },
            { "ne", "Nepalesi\u0161" },
            { "nl", "Hol\u00e4ndi\u0161" },
            { "nn", "Norwegi\u0161 Nynorsk" },
            { "ny", "Nyanja" },
            { "or", metaValue_or },
            { "os", "Os\u00e9ti\u0161" },
            { "pa", "Pand\u0161abi\u0161" },
            { "pl", "Polni\u0161" },
            { "ps", "Pa\u0161tu" },
            { "pt", "Portugisi\u0161" },
            { "qu", "Que\u010dua" },
            { "rm", "R\u00e4tromani\u0161" },
            { "rn", "Rundi" },
            { "ro", "Rum\u00e4ni\u0161" },
            { "ru", "Rusi\u0161" },
            { "rw", "Ruandi\u0161" },
            { "sa", "Sanskrit" },
            { "sd", "Sindhi" },
            { "se", "Nordsami\u0161" },
            { "sg", "Sango" },
            { "si", metaValue_si },
            { "sk", "Slowaki\u0161" },
            { "sl", "Sloweni\u0161" },
            { "sm", "Samoani\u0161" },
            { "sn", "Shona" },
            { "so", "Somali\u0161" },
            { "sq", "Albani\u0161" },
            { "sr", "Serbi\u0161" },
            { "ss", "Swazi" },
            { "st", "S\u00fcdsotho" },
            { "su", "Sundanesi\u0161" },
            { "sv", "Schwedi\u0161" },
            { "sw", "Suaheli\u0161" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "Tad\u0161iki\u0161" },
            { "th", "Thail\u00e4ndi\u0161" },
            { "ti", "Tigrinja" },
            { "tk", "Turkmeni\u0161" },
            { "tn", "Tswana" },
            { "to", metaValue_TO },
            { "tr", "T\u00fcrki\u0161" },
            { "ts", "Tsonga" },
            { "ty", "Taiti\u0161" },
            { "ug", "Uiguri\u0161" },
            { "uk", "Ukraini\u0161" },
            { "ur", "Urdu" },
            { "uz", "Usbeki\u0161" },
            { "ve", "Venda" },
            { "vi", "Vietnamesi\u0161" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yo", "Yoruba" },
            { "zh", "Chinesi\u0161" },
            { "zu", "Zulu" },
            { "efi", "Efik" },
            { "fil", "Filipini\u0161" },
            { "haw", "Hawa\u00edani\u0161" },
            { "nso", "Nordsotho" },
            { "sah", "Jakuti\u0161" },
            { "tet", "Tetum" },
            { "tpi", "Niwmelanesi\u0161" },
            { "und", "Unbekannti Schpra\u010d" },
            { "wae", "Walser" },
            { "Arab", metaValue_ar },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Cyrl", "Kirilli\u0161" },
            { "Deva", "Devanagari" },
            { "Ethi", "Ethiopi\u0161" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Hans", "Vereifa\u010dt" },
            { "Hant", "Traditionell" },
            { "Hebr", metaValue_he },
            { "Jpan", metaValue_ja },
            { "Khmr", "Khmer" },
            { "Knda", metaValue_kn },
            { "Kore", "Koriani\u0161" },
            { "Laoo", metaValue_lo },
            { "Latn", metaValue_la },
            { "Mlym", "Malaisi\u0161" },
            { "Mymr", metaValue_my },
            { "Orya", metaValue_or },
            { "Sinh", metaValue_si },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Thaa", "Th\u00e1na" },
            { "Thai", "Thai" },
            { "Zxxx", "Schriftlos" },
            { "Zzzz", "Unkodierti Schrift" },
            { "de_AT", "\u00d6\u0161tri\u010di\u0161es Tit\u0161" },
            { "de_CH", "Schwizer Ho\u010dtit\u0161" },
            { "en_AU", "Au\u0161trali\u0161es Engli\u0161" },
            { "en_CA", "Kanadi\u0161es Engli\u0161" },
            { "en_GB", "Briti\u0161es Engli\u0161" },
            { "en_US", "Amerikani\u0161es Engli\u0161" },
            { "es_ES", "Iberi\u0161es Schpani\u0161" },
            { "fr_CA", "Kanadi\u0161es W\u00e4l\u0161" },
            { "fr_CH", "Schwizer W\u00e4l\u0161" },
            { "nl_BE", "Fl\u00e4mi\u0161" },
            { "pt_BR", "Brasiliani\u0161es Portugisi\u0161" },
            { "pt_PT", "Iberi\u0161es Portugisi\u0161" },
            { "es_419", "Latiamerikani\u0161es Schpani\u0161" },
            { "zh_Hans", "Vereifa\u010dts Chinesi\u0161" },
            { "zh_Hant", "Traditionells Chinesi\u0161" },
            { "type.nu.latn", "Arabi\u0161i Z\u00e1l\u00e4" },
            { "type.co.ducet", "Standard Unicode Sortierreiefolg" },
            { "type.co.search", "Allgmeini S\u00fce\u010d" },
            { "type.ca.gregorian", "Gregoriani\u0161\u00e4 Kal\u00e4nder" },
        };
        return data;
    }
}
