/*
 * Copyright (c) 2012, 2024, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_az extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "\u0259r\u0259b";
        final String metaValue_hy = "erm\u0259ni";
        final String metaValue_ae = "avestan";
        final String metaValue_ban = "bali";
        final String metaValue_bn = "benqal";
        final String metaValue_ka = "g\u00fcrc\u00fc";
        final String metaValue_el = "yunan";
        final String metaValue_gu = "qucarat";
        final String metaValue_ja = "yapon";
        final String metaValue_km = "kxmer";
        final String metaValue_kn = "kannada";
        final String metaValue_ko = "koreya";
        final String metaValue_la = "lat\u0131n";
        final String metaValue_ml = "malayalam";
        final String metaValue_mn = "monqol";
        final String metaValue_nqo = "nko";
        final String metaValue_sam = "samaritan";
        final String metaValue_su = "sundan";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "teluqu";
        final String metaValue_tl = "taqaloq";
        final String metaValue_th = "tay";
        final String metaValue_bo = "tibet";
        final String metaValue_uga = "uqarit";
        final String metaValue_type_hc_h23 = "24 Saatl\u0131q Sistem (0\u201323)";
        final Object[][] data = new Object[][] {
            { "001", "D\u00fcnya" },
            { "002", "Afrika" },
            { "003", "\u015eimali Amerika" },
            { "005", "C\u0259nubi Amerika" },
            { "009", "Okeaniya" },
            { "011", "Q\u0259rbi Afrika" },
            { "013", "M\u0259rk\u0259zi Amerika" },
            { "014", "\u015e\u0259rqi Afrika" },
            { "015", "\u015eimali Afrika" },
            { "017", "M\u0259rk\u0259zi Afrika" },
            { "018", "C\u0259nubi Afrika" },
            { "019", "Amerika" },
            { "021", "\u015eimal Amerikas\u0131" },
            { "029", "Karib" },
            { "030", "\u015e\u0259rqi Asiya" },
            { "034", "C\u0259nubi Asiya" },
            { "035", "C\u0259nub-\u015e\u0259rqi Asiya" },
            { "039", "C\u0259nubi Avropa" },
            { "053", "Avstralaziya" },
            { "054", "Melaneziya" },
            { "057", "Mikroneziya Regionu" },
            { "061", "Polineziya" },
            { "142", "Asiya" },
            { "143", "M\u0259rk\u0259zi Asiya" },
            { "145", "Q\u0259rbi Asiya" },
            { "150", "Avropa" },
            { "151", "\u015e\u0259rqi Avropa" },
            { "154", "\u015eimali Avropa" },
            { "155", "Q\u0259rbi Avropa" },
            { "202", "Saharadan c\u0259nub" },
            { "419", "Lat\u0131n Amerikas\u0131" },
            { "AC", "Askenson adas\u0131" },
            { "AD", "Andorra" },
            { "AE", "Birl\u0259\u015fmi\u015f \u018fr\u0259b \u018fmirlikl\u0259ri" },
            { "AF", "\u018ffqan\u0131stan" },
            { "AG", "Antiqua v\u0259 Barbuda" },
            { "AI", "Angilya" },
            { "AL", "Albaniya" },
            { "AM", "Erm\u0259nistan" },
            { "AO", "Anqola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentina" },
            { "AS", "Amerika Samoas\u0131" },
            { "AT", "Avstriya" },
            { "AU", "Avstraliya" },
            { "AW", "Aruba" },
            { "AX", "Aland adalar\u0131" },
            { "AZ", "Az\u0259rbaycan" },
            { "BA", "Bosniya v\u0259 Herseqovina" },
            { "BB", "Barbados" },
            { "BD", "Banqlade\u015f" },
            { "BE", "Bel\u00e7ika" },
            { "BF", "Burkina Faso" },
            { "BG", "Bolqar\u0131stan" },
            { "BH", "B\u0259hreyn" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Sent-Bartelemi" },
            { "BM", "Bermud adalar\u0131" },
            { "BN", "Bruney" },
            { "BO", "Boliviya" },
            { "BQ", "Karib Niderland\u0131" },
            { "BR", "Braziliya" },
            { "BS", "Baham adalar\u0131" },
            { "BT", "Butan" },
            { "BV", "Buve adas\u0131" },
            { "BW", "Botsvana" },
            { "BY", "Belarus" },
            { "BZ", "Beliz" },
            { "CA", "Kanada" },
            { "CC", "Kokos (Kilinq) adalar\u0131" },
            { "CD", "Konqo - Kin\u015fasa" },
            { "CF", "M\u0259rk\u0259zi Afrika Respublikas\u0131" },
            { "CG", "Konqo - Brazzavil" },
            { "CH", "\u0130sve\u00e7r\u0259" },
            { "CI", "Kotd\u2019ivuar" },
            { "CK", "Kuk adalar\u0131" },
            { "CL", "\u00c7ili" },
            { "CM", "Kamerun" },
            { "CN", "\u00c7in" },
            { "CO", "Kolumbiya" },
            { "CP", "Klipperton adas\u0131" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Kabo-Verde" },
            { "CW", "Kurasao" },
            { "CX", "Milad adas\u0131" },
            { "CY", "Kipr" },
            { "CZ", "\u00c7exiya" },
            { "DE", "Almaniya" },
            { "DG", "Dieqo Qarsiya" },
            { "DJ", "Cibuti" },
            { "DK", "Danimarka" },
            { "DM", "Dominika" },
            { "DO", "Dominikan Respublikas\u0131" },
            { "DZ", "\u018flc\u0259zair" },
            { "EA", "Seuta v\u0259 Melilya" },
            { "EC", "Ekvador" },
            { "EE", "Estoniya" },
            { "EG", "Misir" },
            { "EH", "Q\u0259rbi Saxara" },
            { "ER", "Eritreya" },
            { "ES", "\u0130spaniya" },
            { "ET", "Efiopiya" },
            { "EU", "Avropa Birliyi" },
            { "EZ", "Avrozona" },
            { "FI", "Finlandiya" },
            { "FJ", "Fici" },
            { "FK", "Folklend adalar\u0131" },
            { "FM", "Mikroneziya" },
            { "FO", "Farer adalar\u0131" },
            { "FR", "Fransa" },
            { "GA", "Qabon" },
            { "GB", "Birl\u0259\u015fmi\u015f Krall\u0131q" },
            { "GD", "Qrenada" },
            { "GE", "G\u00fcrc\u00fcstan" },
            { "GF", "Fransa Qvianas\u0131" },
            { "GG", "Gernsi" },
            { "GH", "Qana" },
            { "GI", "C\u0259b\u0259ll\u00fctariq" },
            { "GL", "Qrenlandiya" },
            { "GM", "Qambiya" },
            { "GN", "Qvineya" },
            { "GP", "Qvadelupa" },
            { "GQ", "Ekvatorial Qvineya" },
            { "GR", "Yunan\u0131stan" },
            { "GS", "C\u0259nubi Corciya v\u0259 C\u0259nubi Sendvi\u00e7 adalar\u0131" },
            { "GT", "Qvatemala" },
            { "GU", "Quam" },
            { "GW", "Qvineya-Bisau" },
            { "GY", "Qayana" },
            { "HK", "Honq Konq X\u00fcsusi \u0130nzibati Rayonu \u00c7in" },
            { "HM", "Herd v\u0259 Makdonald adalar\u0131" },
            { "HN", "Honduras" },
            { "HR", "Xorvatiya" },
            { "HT", "Haiti" },
            { "HU", "Macar\u0131stan" },
            { "IC", "Kanar adalar\u0131" },
            { "ID", "\u0130ndoneziya" },
            { "IE", "\u0130rlandiya" },
            { "IL", "\u0130srail" },
            { "IM", "Men adas\u0131" },
            { "IN", "Hindistan" },
            { "IO", "Britaniyan\u0131n Hind Okean\u0131 \u018frazisi" },
            { "IQ", "\u0130raq" },
            { "IR", "\u0130ran" },
            { "IS", "\u0130slandiya" },
            { "IT", "\u0130taliya" },
            { "JE", "Cersi" },
            { "JM", "Yamayka" },
            { "JO", "\u0130ordaniya" },
            { "JP", "Yaponiya" },
            { "KE", "Keniya" },
            { "KG", "Q\u0131r\u011f\u0131z\u0131stan" },
            { "KH", "Kamboca" },
            { "KI", "Kiribati" },
            { "KM", "Komor adalar\u0131" },
            { "KN", "Sent-Kits v\u0259 Nevis" },
            { "KP", "\u015eimali Koreya" },
            { "KR", "C\u0259nubi Koreya" },
            { "KW", "K\u00fcveyt" },
            { "KY", "Kayman adalar\u0131" },
            { "KZ", "Qazax\u0131stan" },
            { "LA", "Laos" },
            { "LB", "Livan" },
            { "LC", "Sent-Lusiya" },
            { "LI", "Lixten\u015fteyn" },
            { "LK", "\u015eri-Lanka" },
            { "LR", "Liberiya" },
            { "LS", "Lesoto" },
            { "LT", "Litva" },
            { "LU", "L\u00fcksemburq" },
            { "LV", "Latviya" },
            { "LY", "Liviya" },
            { "MA", "M\u0259rake\u015f" },
            { "MC", "Monako" },
            { "MD", "Moldova" },
            { "ME", "Monteneqro" },
            { "MF", "Sent Martin" },
            { "MG", "Madaqaskar" },
            { "MH", "Mar\u015fal adalar\u0131" },
            { "MK", "\u015eimali Makedoniya" },
            { "ML", "Mali" },
            { "MM", "Myanma" },
            { "MN", "Monqolustan" },
            { "MO", "Makao X\u0130R \u00c7in" },
            { "MP", "\u015eimali Marian adalar\u0131" },
            { "MQ", "Martinik" },
            { "MR", "Mavritaniya" },
            { "MS", "Monserat" },
            { "MT", "Malta" },
            { "MU", "Mavriki" },
            { "MV", "Maldiv adalar\u0131" },
            { "MW", "Malavi" },
            { "MX", "Meksika" },
            { "MY", "Malayziya" },
            { "MZ", "Mozambik" },
            { "NA", "Namibiya" },
            { "NC", "Yeni Kaledoniya" },
            { "NE", "Niger" },
            { "NF", "Norfolk adas\u0131" },
            { "NG", "Nigeriya" },
            { "NI", "Nikaraqua" },
            { "NL", "Niderland" },
            { "NO", "Norve\u00e7" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Yeni Zelandiya" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Fransa Polineziyas\u0131" },
            { "PG", "Papua-Yeni Qvineya" },
            { "PH", "Filippin" },
            { "PK", "Pakistan" },
            { "PL", "Pol\u015fa" },
            { "PM", "M\u00fcq\u0259dd\u0259s Pyer v\u0259 Mikelon" },
            { "PN", "Pitkern adalar\u0131" },
            { "PR", "Puerto Riko" },
            { "PS", "F\u0259l\u0259stin \u018frazil\u0259ri" },
            { "PT", "Portuqaliya" },
            { "PW", "Palau" },
            { "PY", "Paraqvay" },
            { "QA", "Q\u0259t\u0259r" },
            { "QO", "Uzaq Okeaniya" },
            { "RE", "Reyunyon" },
            { "RO", "Rum\u0131niya" },
            { "RS", "Serbiya" },
            { "RU", "Rusiya" },
            { "RW", "Ruanda" },
            { "SA", "S\u0259udiyy\u0259 \u018fr\u0259bistan\u0131" },
            { "SB", "Solomon adalar\u0131" },
            { "SC", "Sey\u015fel adalar\u0131" },
            { "SD", "Sudan" },
            { "SE", "\u0130sve\u00e7" },
            { "SG", "Sinqapur" },
            { "SH", "M\u00fcq\u0259dd\u0259s Yelena" },
            { "SI", "Sloveniya" },
            { "SJ", "Svalbard v\u0259 Yan-Mayen" },
            { "SK", "Slovakiya" },
            { "SL", "Syerra-Leone" },
            { "SM", "San-Marino" },
            { "SN", "Seneqal" },
            { "SO", "Somali" },
            { "SR", "Surinam" },
            { "SS", "C\u0259nubi Sudan" },
            { "ST", "San-Tome v\u0259 Prinsipi" },
            { "SV", "Salvador" },
            { "SX", "Sint-Marten" },
            { "SY", "Suriya" },
            { "SZ", "Esvatini" },
            { "TA", "Tristan da Kunya" },
            { "TC", "T\u00f6rks v\u0259 Kaykos adalar\u0131" },
            { "TD", "\u00c7ad" },
            { "TF", "Fransan\u0131n C\u0259nub \u018frazil\u0259ri" },
            { "TG", "Toqo" },
            { "TH", "Tailand" },
            { "TJ", "Tacikistan" },
            { "TK", "Tokelau" },
            { "TL", "\u015e\u0259rqi Timor" },
            { "TM", "T\u00fcrkm\u0259nistan" },
            { "TN", "Tunis" },
            { "TO", "Tonqa" },
            { "TR", "T\u00fcrkiy\u0259" },
            { "TT", "Trinidad v\u0259 Tobaqo" },
            { "TV", "Tuvalu" },
            { "TW", "Tayvan" },
            { "TZ", "Tanzaniya" },
            { "UA", "Ukrayna" },
            { "UG", "Uqanda" },
            { "UM", "AB\u015e-a ba\u011fl\u0131 ki\u00e7ik adac\u0131qlar" },
            { "UN", "Birl\u0259\u015fmi\u015f Mill\u0259tl\u0259r T\u0259\u015fkilat\u0131" },
            { "US", "Amerika Birl\u0259\u015fmi\u015f \u015etatlar\u0131" },
            { "UY", "Uruqvay" },
            { "UZ", "\u00d6zb\u0259kistan" },
            { "VA", "Vatikan" },
            { "VC", "Sent-Vinsent v\u0259 Qrenadinl\u0259r" },
            { "VE", "Venesuela" },
            { "VG", "Britaniyan\u0131n Virgin adalar\u0131" },
            { "VI", "AB\u015e Virgin adalar\u0131" },
            { "VN", "Vyetnam" },
            { "VU", "Vanuatu" },
            { "WF", "Uollis v\u0259 Futuna" },
            { "WS", "Samoa" },
            { "XA", "Psevdo-Aksent" },
            { "XB", "Psevdo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Y\u0259m\u0259n" },
            { "YT", "Mayot" },
            { "ZA", "C\u0259nub Afrika" },
            { "ZM", "Zambiya" },
            { "ZW", "Zimbabve" },
            { "ZZ", "Nam\u0259lum Region" },
            { "aa", "afar" },
            { "ab", "abxaz" },
            { "ae", metaValue_ae },
            { "af", "afrikaans" },
            { "ak", "akan" },
            { "am", "amhar" },
            { "an", "araqon" },
            { "ar", metaValue_ar },
            { "as", "assam" },
            { "av", "avar" },
            { "ay", "aymara" },
            { "az", "az\u0259rbaycan" },
            { "ba", "ba\u015fq\u0131rd" },
            { "be", "belarus" },
            { "bg", "bolqar" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "breton" },
            { "bs", "bosniya" },
            { "ca", "katalan" },
            { "ce", "\u00e7e\u00e7en" },
            { "ch", "\u00e7amoro" },
            { "co", "korsika" },
            { "cr", "kri" },
            { "cs", "\u00e7ex" },
            { "cu", "slavyan" },
            { "cv", "\u00e7uva\u015f" },
            { "cy", "uels" },
            { "da", "danimarka" },
            { "de", "alman" },
            { "dv", "maldiv" },
            { "dz", "dzonqxa" },
            { "ee", "eve" },
            { "el", metaValue_el },
            { "en", "ingilis" },
            { "eo", "esperanto" },
            { "es", "ispan" },
            { "et", "eston" },
            { "eu", "bask" },
            { "fa", "fars" },
            { "ff", "fula" },
            { "fi", "fin" },
            { "fj", "fici" },
            { "fo", "farer" },
            { "fr", "frans\u0131z" },
            { "fy", "q\u0259rbi friz" },
            { "ga", "irland" },
            { "gd", "\u015eotlandiya keltc\u0259si" },
            { "gl", "qalisiya" },
            { "gn", "quarani" },
            { "gu", metaValue_gu },
            { "gv", "manks" },
            { "ha", "hausa" },
            { "he", "ivrit" },
            { "hi", "hind" },
            { "ho", "hiri motu" },
            { "hr", "xorvat" },
            { "ht", "haiti kreol" },
            { "hu", "macar" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlinqua" },
            { "id", "indoneziya" },
            { "ie", "interlinqve" },
            { "ig", "iqbo" },
            { "ii", "si\u00e7uan yi" },
            { "ik", "inupiaq" },
            { "io", "ido" },
            { "is", "island" },
            { "it", "italyan" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "yava" },
            { "ka", metaValue_ka },
            { "kg", "konqo" },
            { "ki", "kikuyu" },
            { "kj", "kuanyama" },
            { "kk", "qazax" },
            { "kl", "kalaallisut" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "k\u0259\u015fmir" },
            { "ku", "k\u00fcrd" },
            { "kv", "komi" },
            { "kw", "korn" },
            { "ky", "q\u0131r\u011f\u0131z" },
            { "la", metaValue_la },
            { "lb", "l\u00fcksemburq" },
            { "lg", "qanda" },
            { "li", "limburq" },
            { "ln", "linqala" },
            { "lo", "laos" },
            { "lt", "litva" },
            { "lu", "luba-katanqa" },
            { "lv", "lat\u0131\u015f" },
            { "mg", "malaqas" },
            { "mh", "mar\u015fal" },
            { "mi", "m\u0101ori" },
            { "mk", "makedon" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malay" },
            { "mt", "malta" },
            { "my", "birman" },
            { "na", "nauru" },
            { "nb", "bokmal norve\u00e7" },
            { "nd", "\u015fimali ndebele" },
            { "ne", "nepal" },
            { "ng", "ndonqa" },
            { "nl", "holland" },
            { "nn", "n\u00fcnorsk norve\u00e7" },
            { "no", "norve\u00e7" },
            { "nr", "c\u0259nubi ndebele" },
            { "nv", "navayo" },
            { "ny", "nyanca" },
            { "oc", "oksitan" },
            { "oj", "ocibva" },
            { "om", "oromo" },
            { "or", "odiya" },
            { "os", "osetin" },
            { "pa", "p\u0259ncab" },
            { "pi", "pali" },
            { "pl", "polyak" },
            { "ps", "pu\u015ftu" },
            { "pt", "portuqal" },
            { "qu", "ke\u00e7ua" },
            { "rm", "roman\u015f" },
            { "rn", "rundi" },
            { "ro", "rum\u0131n" },
            { "ru", "rus" },
            { "rw", "kinyarvanda" },
            { "sa", "sanskrit" },
            { "sc", "sardin" },
            { "sd", "sindhi" },
            { "se", "\u015fimali sami" },
            { "sg", "sanqo" },
            { "sh", "serb-xorvat" },
            { "si", "sinhala" },
            { "sk", "slovak" },
            { "sl", "sloven" },
            { "sm", "samoa" },
            { "sn", "\u015fona" },
            { "so", "somali" },
            { "sq", "alban" },
            { "sr", "serb" },
            { "ss", "svati" },
            { "st", "sesoto" },
            { "su", metaValue_su },
            { "sv", "isve\u00e7" },
            { "sw", "suahili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tacik" },
            { "th", metaValue_th },
            { "ti", "tiqrin" },
            { "tk", "t\u00fcrkm\u0259n" },
            { "tl", metaValue_tl },
            { "tn", "svana" },
            { "to", "tonqa" },
            { "tr", "t\u00fcrk" },
            { "ts", "sonqa" },
            { "tt", "tatar" },
            { "tw", "tvi" },
            { "ty", "taxiti" },
            { "ug", "uy\u011fur" },
            { "uk", "ukrayna" },
            { "ur", "urdu" },
            { "uz", "\u00f6zb\u0259k" },
            { "ve", "venda" },
            { "vi", "vyetnam" },
            { "vo", "volap\u00fck" },
            { "wa", "valun" },
            { "wo", "volof" },
            { "xh", "xosa" },
            { "yi", "idi\u015f" },
            { "yo", "yoruba" },
            { "za", "\u00e7juan" },
            { "zh", "\u00e7in" },
            { "zu", "zulu" },
            { "ace", "akin" },
            { "ach", "akoli" },
            { "ada", "adanqme" },
            { "ady", "ad\u0131gey" },
            { "afh", "afrihili" },
            { "agq", "aqhem" },
            { "ain", "aynu" },
            { "akk", "akkad" },
            { "ale", "aleut" },
            { "alt", "c\u0259nubi altay" },
            { "ang", "q\u0259dim ingilis" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "arc", "aramik" },
            { "arn", "mapu\u00e7e" },
            { "arp", "arapaho" },
            { "ars", "N\u0259cd \u0259r\u0259bc\u0259si" },
            { "arw", "aravak" },
            { "asa", "asu" },
            { "ast", "asturiya" },
            { "atj", "Atikamek" },
            { "awa", "avadhi" },
            { "bal", "baluc" },
            { "ban", metaValue_ban },
            { "bas", "basa" },
            { "bej", "beja" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "bgc", "Haryanvi" },
            { "bgn", "q\u0259rbi b\u0259luc" },
            { "bho", "bxo\u00e7puri" },
            { "bik", "bikol" },
            { "bin", "bini" },
            { "bla", "siksik\u0259" },
            { "bra", "braj" },
            { "brx", "bodo" },
            { "bua", "buryat" },
            { "bug", "bugin" },
            { "byn", "blin" },
            { "cad", "keddo" },
            { "car", "karib" },
            { "cay", "Kayuqa" },
            { "cch", "atsam" },
            { "ccp", "\u00c7akma" },
            { "ceb", "sebuan" },
            { "cgg", "\u00e7iqa" },
            { "chb", "\u00e7ib\u00e7a" },
            { "chg", "\u00e7a\u011fatay" },
            { "chk", "\u00e7ukiz" },
            { "chm", "mari" },
            { "chn", "\u00e7inuk l\u0259h\u00e7\u0259si" },
            { "cho", "\u00e7oktau" },
            { "chp", "\u00e7ipevyan" },
            { "chr", "\u00e7eroki" },
            { "chy", "\u00e7eyen" },
            { "ckb", "M\u0259rk\u0259zi k\u00fcrdc\u0259" },
            { "clc", "\u00c7ilotin" },
            { "cop", "kopt" },
            { "crg", "mi\u00e7if" },
            { "crh", "kr\u0131m t\u00fcrkc\u0259si" },
            { "crj", "c\u0259nub-\u015f\u0259rqi kri" },
            { "crk", "ova kric\u0259si" },
            { "crl", "\u015fimal-\u015f\u0259qri kri" },
            { "crm", "muz kri" },
            { "crr", "Karolina alonkinc\u0259si" },
            { "crs", "Sey\u015fel kreol frans\u0131zcas\u0131" },
            { "csb", "ka\u015fubyan" },
            { "csw", "bataql\u0131q kric\u0259si" },
            { "dak", "dakota" },
            { "dar", "darqva" },
            { "dav", "taita" },
            { "del", "delaver" },
            { "den", "slavey" },
            { "dgr", "doqrib" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "doqri" },
            { "dsb", "a\u015fa\u011f\u0131 sorb" },
            { "dua", "duala" },
            { "dum", "orta holland" },
            { "dyo", "diola" },
            { "dyu", "dyula" },
            { "dzg", "dazaqa" },
            { "ebu", "embu" },
            { "efi", "efik" },
            { "egy", "q\u0259dim misir" },
            { "eka", "ekacuk" },
            { "elx", "elamit" },
            { "enm", "orta ingilis" },
            { "ewo", "evondo" },
            { "fan", "fang" },
            { "fat", "fanti" },
            { "fil", "filippin" },
            { "fon", "fon" },
            { "frc", "Kacun frans\u0131zcas\u0131" },
            { "frm", "orta frans\u0131z" },
            { "fro", "q\u0259dim frans\u0131z" },
            { "frr", "\u015fimali fris" },
            { "fur", "friul" },
            { "gaa", "qa" },
            { "gag", "qaqauz" },
            { "gan", "qan" },
            { "gay", "qayo" },
            { "gba", "qabaya" },
            { "gez", "qez" },
            { "gil", "qilbert" },
            { "gmh", "orta y\u00fcks\u0259k alman" },
            { "goh", "q\u0259dim alman" },
            { "gon", "qondi" },
            { "gor", "qorontalo" },
            { "got", "qotika" },
            { "grb", "qrebo" },
            { "grc", "q\u0259dim yunan" },
            { "gsw", "\u0130sve\u00e7r\u0259 almancas\u0131" },
            { "guz", "qusi" },
            { "gwi", "qvi\u00e7in" },
            { "hai", "hayda" },
            { "hak", "hakka" },
            { "haw", "havay" },
            { "hax", "c\u0259nubi haida" },
            { "hil", "hiliqaynon" },
            { "hit", "hittit" },
            { "hmn", "monq" },
            { "hsb", "yuxar\u0131 sorb" },
            { "hsn", "syan" },
            { "hup", "hupa" },
            { "hur", "Halkomelem" },
            { "iba", "iban" },
            { "ibb", "ibibio" },
            { "ikt", "q\u0259rbi Kanada inuktitutu" },
            { "ilo", "iloko" },
            { "inh", "inqu\u015f" },
            { "jbo", "lo\u011fban" },
            { "jgo", "nqomba" },
            { "jmc", "ma\u00e7am" },
            { "jpr", "ivrit-fars" },
            { "jrb", "ivrit-\u0259r\u0259b" },
            { "kaa", "qaraqalpaq" },
            { "kab", "kabile" },
            { "kac", "ka\u00e7in" },
            { "kaj", "ju" },
            { "kam", "kamba" },
            { "kaw", "kavi" },
            { "kbd", "kabarda-\u00e7\u0259rk\u0259z" },
            { "kcg", "tiyap" },
            { "kde", "makond" },
            { "kea", "kabuverdian" },
            { "kfo", "koro" },
            { "kgp", "kaiqanq" },
            { "kha", "xazi" },
            { "kho", "xotan" },
            { "khq", "koyra \u00e7iini" },
            { "kkj", "kako" },
            { "kln", "kalencin" },
            { "kmb", "kimbundu" },
            { "koi", "komi-permyak" },
            { "kok", "konkani" },
            { "kos", "kosreyan" },
            { "kpe", "kpelle" },
            { "krc", "qara\u00e7ay-balkar" },
            { "krl", "karel" },
            { "kru", "kurux" },
            { "ksb", "\u015fambala" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f6ln" },
            { "kum", "kum\u0131k" },
            { "kut", "kutenay" },
            { "kwk", "Kvakvala" },
            { "lad", "sefard" },
            { "lag", "langi" },
            { "lah", "q\u0259rbi p\u0259ncab" },
            { "lam", "lamba" },
            { "lez", "l\u0259zgi" },
            { "lil", "Liluet" },
            { "lkt", "lakota" },
            { "lol", "monqo" },
            { "lou", "Luiziana kreolu" },
            { "loz", "lozi" },
            { "lrc", "\u015fimali luri" },
            { "lsm", "saamia" },
            { "lua", "luba-lulua" },
            { "lui", "luyseno" },
            { "lun", "lunda" },
            { "luo", "luo" },
            { "lus", "mizo" },
            { "luy", "luyia" },
            { "mad", "maduriz" },
            { "mag", "maqahi" },
            { "mai", "maitili" },
            { "mak", "makasar" },
            { "man", "m\u0259ndinqo" },
            { "mas", "masay" },
            { "mdf", "mok\u015fa" },
            { "mdr", "mandar" },
            { "men", "mende" },
            { "mer", "meru" },
            { "mfe", "morisien" },
            { "mga", "orta irland" },
            { "mgh", "maxuva-meetto" },
            { "mgo", "meta\u2019" },
            { "mic", "mikmak" },
            { "min", "minanqkaban" },
            { "mnc", "man\u00e7u" },
            { "mni", "manip\u00fcri" },
            { "moe", "\u0130nnu-aimun" },
            { "moh", "mohavk" },
            { "mos", "mosi" },
            { "mua", "mundanq" },
            { "mul", "\u00e7oxsayl\u0131 dill\u0259r" },
            { "mus", "krik" },
            { "mwl", "mirand" },
            { "mwr", "maruari" },
            { "myv", "erzya" },
            { "mzn", "mazandaran" },
            { "nan", "Min Nan" },
            { "nap", "neapolitan" },
            { "naq", "nama" },
            { "nds", "a\u015fa\u011f\u0131 alman" },
            { "new", "nevari" },
            { "nia", "nias" },
            { "niu", "niyuan" },
            { "nmg", "kvasio" },
            { "nnh", "ngiemboon" },
            { "nog", "noqay" },
            { "non", "q\u0259dim nors" },
            { "nqo", metaValue_nqo },
            { "nso", "\u015fimal soto" },
            { "nus", "nuer" },
            { "nym", "nyamvezi" },
            { "nyn", "nyankol" },
            { "nyo", "nyoro" },
            { "nzi", "nzima" },
            { "ojb", "\u015fimal-q\u0259rbi ocibva" },
            { "ojc", "M\u0259rk\u0259zi ocibva" },
            { "ojs", "ocikri" },
            { "ojw", "q\u0259rbi ocibva" },
            { "oka", "okanaqan" },
            { "osa", "osage" },
            { "ota", "osman" },
            { "pag", "panqasinan" },
            { "pal", "p\u0259hl\u0259vi" },
            { "pam", "pampanqa" },
            { "pap", "papyamento" },
            { "pau", "palayan" },
            { "pcm", "niger kreol" },
            { "peo", "q\u0259dim fars" },
            { "phn", "foyenik" },
            { "pis", "picin" },
            { "pon", "ponpey" },
            { "pqm", "malesit-passamakvodi" },
            { "prg", "pruss" },
            { "pro", "q\u0259dim provansal" },
            { "quc", "ki\u00e7e" },
            { "raj", "racastani" },
            { "rap", "rapanui" },
            { "rar", "rarotonqan" },
            { "rhg", "Rohinca" },
            { "rof", "rombo" },
            { "rom", "roman" },
            { "rup", "aroman" },
            { "rwk", "rua" },
            { "sad", "sandave" },
            { "sah", "saxa" },
            { "sam", metaValue_sam },
            { "saq", "samburu" },
            { "sas", "sasak" },
            { "sat", "santal" },
            { "sba", "nqambay" },
            { "sbp", "sanqu" },
            { "scn", "siciliya" },
            { "sco", "skots" },
            { "sdh", "c\u0259nubi k\u00fcrd" },
            { "seh", "sena" },
            { "sel", "selkup" },
            { "ses", "koyraboro senni" },
            { "sga", "q\u0259dim irland" },
            { "shi", "ta\u00e7elit" },
            { "shn", "\u015fan" },
            { "sid", "sidamo" },
            { "slh", "c\u0259nubi lu\u015fusid" },
            { "sma", "c\u0259nubi sami" },
            { "smj", "lule sami" },
            { "smn", "inari sami" },
            { "sms", "skolt sami" },
            { "snk", "soninke" },
            { "sog", "soqdiyen" },
            { "srn", "sranan tonqo" },
            { "srr", "serer" },
            { "ssy", "saho" },
            { "str", "streyts sali\u015f" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeryan" },
            { "swb", "komor" },
            { "syr", "suriya" },
            { "tce", "c\u0259nubi tu\u00e7on" },
            { "tem", "timne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetum" },
            { "tgx", "taq" },
            { "tht", "taltan" },
            { "tig", "tiqre" },
            { "tiv", "tiv" },
            { "tkl", "tokelay" },
            { "tlh", "klinqon" },
            { "tli", "tlinqit" },
            { "tmh", "tama\u015fek" },
            { "tog", "nyasa tonqa" },
            { "tok", "tokipona" },
            { "tpi", "tok pisin" },
            { "trv", "taroko" },
            { "tsi", "sim\u015fyan" },
            { "ttm", "\u015fimali tu\u00e7on" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "tasavaq" },
            { "tyv", "tuvinyan" },
            { "tzm", "M\u0259rk\u0259zi Atlas tamazic\u0259si" },
            { "udm", "udmurt" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "nam\u0259lum dil" },
            { "vai", "vai" },
            { "vot", "votik" },
            { "vun", "vunyo" },
            { "wae", "valles" },
            { "wal", "valamo" },
            { "war", "varay" },
            { "was", "va\u015fo" },
            { "wbp", "valpiri" },
            { "wuu", "vu" },
            { "xal", "kalm\u0131k" },
            { "xog", "soqa" },
            { "yao", "yao" },
            { "yap", "yapiz" },
            { "yav", "yanqben" },
            { "ybb", "yemba" },
            { "yrl", "nyenqatu" },
            { "yue", "kanton" },
            { "zap", "zapotek" },
            { "zbl", "blisimbols" },
            { "zen", "zenaqa" },
            { "zgh", "tamazi" },
            { "zun", "zuni" },
            { "zxx", "dil m\u0259zmunu yoxdur" },
            { "zza", "zaza" },
            { "Adlm", "adlam" },
            { "Arab", metaValue_ar },
            { "Aran", "aran" },
            { "Armi", "armi" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Batk", "batak" },
            { "Beng", metaValue_bn },
            { "Blis", "blissymbols" },
            { "Bopo", "bopomofo" },
            { "Brah", "brahmi" },
            { "Brai", "brayl" },
            { "Bugi", "buqin" },
            { "Buhd", "buhid" },
            { "Cakm", "\u00e7akma" },
            { "Cans", "birl\u0259\u015fmi\u015f kanada yerli yaz\u0131s\u0131" },
            { "Cari", "kariyan" },
            { "Cham", "\u00e7am" },
            { "Cher", "\u00e7iroki" },
            { "Cirt", "sirt" },
            { "Copt", "koptik" },
            { "Cprt", "kipr" },
            { "Cyrl", "kiril" },
            { "Cyrs", "q\u0259dimi kilsa kirili" },
            { "Deva", "devanaqari" },
            { "Dsrt", "deseret" },
            { "Egyd", "misir demotik" },
            { "Egyh", "misir hiyeratik" },
            { "Egyp", "misir hiyeroqlif" },
            { "Ethi", "efiop" },
            { "Geok", "g\u00fcrc\u00fc xutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "qlaqolitik" },
            { "Goth", "qotik" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "qurmuxi" },
            { "Hanb", "hanb" },
            { "Hang", "hanq\u0131l" },
            { "Hani", "han" },
            { "Hano", "hanunu" },
            { "Hans", "sad\u0259l\u0259\u015fmi\u015f" },
            { "Hant", "\u0259n\u0259n\u0259vi" },
            { "Hebr", "ibrani" },
            { "Hira", "iraqana" },
            { "Hmng", "pahav monq" },
            { "Hrkt", "hecal\u0131 yapon \u0259lifbas\u0131" },
            { "Hung", "q\u0259dimi macar" },
            { "Inds", "hindistan" },
            { "Ital", "q\u0259dimi italyal\u0131" },
            { "Jamo", "jamo" },
            { "Java", "cava" },
            { "Jpan", metaValue_ja },
            { "Kali", "kayax li" },
            { "Kana", "katakana" },
            { "Khar", "xaro\u015fti" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kthi", "kti" },
            { "Lana", "lanna" },
            { "Laoo", "lao" },
            { "Latf", "fraktur lat\u0131n\u0131" },
            { "Latg", "gael lat\u0131n\u0131" },
            { "Latn", metaValue_la },
            { "Lepc", "lep\u00e7\u0259" },
            { "Limb", "limbu" },
            { "Lyci", "lusian" },
            { "Lydi", "ludian" },
            { "Mand", "mandayen" },
            { "Mani", "mani\u00e7ayen" },
            { "Maya", "maya hiyeroqlifi" },
            { "Mero", "meroytik" },
            { "Mlym", metaValue_ml },
            { "Mong", metaValue_mn },
            { "Moon", "mun" },
            { "Mtei", "meytey mayek" },
            { "Mymr", "myanmar" },
            { "Nkoo", metaValue_nqo },
            { "Ogam", "o\u011fam" },
            { "Olck", "ol \u00e7iki" },
            { "Orkh", "orxon" },
            { "Orya", "oriya" },
            { "Osma", "osmanya" },
            { "Perm", "q\u0259dimi permik" },
            { "Phag", "faqs-pa" },
            { "Phli", "fli" },
            { "Phlp", "flp" },
            { "Phlv", "kitab paxlavi" },
            { "Phnx", "foenik" },
            { "Plrd", "polard fonetik" },
            { "Prti", "prti" },
            { "Rjng", "rec\u0259ng" },
            { "Rohg", "hanifi" },
            { "Roro", "ronqoronqo" },
            { "Runr", "runik" },
            { "Samr", metaValue_sam },
            { "Sara", "sarati" },
            { "Saur", "saurastra" },
            { "Sgnw", "i\u015far\u0259t yaz\u0131s\u0131" },
            { "Shaw", "\u015favyan" },
            { "Sinh", "sinhal" },
            { "Sund", metaValue_su },
            { "Sylo", "siloti n\u0259qri" },
            { "Syrc", "siryak" },
            { "Syre", "estrangela s\u00fcryanice" },
            { "Tagb", "taqbanva" },
            { "Tale", "tay le" },
            { "Talu", "t\u0259z\u0259 tay lu" },
            { "Taml", metaValue_ta },
            { "Tavt", "tavt" },
            { "Telu", metaValue_te },
            { "Teng", "tengvar" },
            { "Tfng", "tifinaq" },
            { "Tglg", metaValue_tl },
            { "Thaa", "thana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Ugar", metaValue_uga },
            { "Vaii", "vay" },
            { "Visp", "dan\u0131\u015fma s\u0259sl\u0259ri" },
            { "Xpeo", "q\u0259dimi fars" },
            { "Xsux", "sumer-akadyan kuneyform" },
            { "Yiii", "yi" },
            { "Zmth", "riyazi notasiya" },
            { "Zsye", "emoji" },
            { "Zsym", "simvollar" },
            { "Zxxx", "yaz\u0131s\u0131z" },
            { "Zyyy", "\u00fcmumi yaz\u0131" },
            { "Zzzz", "tan\u0131nmayan yaz\u0131" },
            { "de_AT", "Avstriya almancas\u0131" },
            { "de_CH", "\u0130sve\u00e7r\u0259 y\u00fcks\u0259k almancas\u0131" },
            { "en_AU", "Avstraliya ingilisc\u0259si" },
            { "en_CA", "Kanada ingilisc\u0259si" },
            { "en_GB", "Britaniya ingilisc\u0259si" },
            { "en_US", "Amerika ingilisc\u0259si" },
            { "es_ES", "Kastiliya ispancas\u0131" },
            { "es_MX", "Meksika ispancas\u0131" },
            { "fa_AF", "dari" },
            { "fr_CA", "Kanada frans\u0131zcas\u0131" },
            { "fr_CH", "\u0130sve\u00e7r\u0259 frans\u0131zcas\u0131" },
            { "nl_BE", "flamand" },
            { "pt_BR", "Braziliya portuqalcas\u0131" },
            { "pt_PT", "Portuqaliya portuqalcas\u0131" },
            { "ro_MD", "moldav" },
            { "sw_CD", "Konqo suahilic\u0259si" },
            { "ar_001", "m\u00fcasir standart \u0259r\u0259b" },
            { "es_419", "Lat\u0131n Amerikas\u0131 ispancas\u0131" },
            { "key.ca", "T\u0259qvim" },
            { "key.cf", "Valyuta Format\u0131" },
            { "key.co", "S\u0131ralama" },
            { "key.cu", "Valyuta" },
            { "key.hc", "Saat Sikli (12 / 24)" },
            { "key.lb", "S\u0259tird\u0259n s\u0259tr\u0259 ke\u00e7irm\u0259 \u00fcslubu" },
            { "key.ms", "\u00d6l\u00e7\u00fc Sistemi" },
            { "key.nu", "R\u0259q\u0259ml\u0259r" },
            { "nds_NL", "a\u015fa\u011f\u0131 sakson" },
            { "az_Arab", "c\u0259nubi az\u0259rbaycan" },
            { "hi_Latn", "Hindi (lat\u0131n)" },
            { "zh_Hans", "sad\u0259l\u0259\u015fmi\u015f \u00e7in" },
            { "zh_Hant", "\u0259n\u0259n\u0259vi \u00e7in" },
            { "type.ca.roc", "Minquo T\u0259qvimi" },
            { "type.hc.h11", "12 Saatl\u0131q Sistem (0\u201311)" },
            { "type.hc.h12", "12 Saatl\u0131q Sistem (0\u201312)" },
            { "type.hc.h23", metaValue_type_hc_h23 },
            { "type.hc.h24", metaValue_type_hc_h23 },
            { "type.nu.arab", "\u018fr\u0259b-Hind R\u0259q\u0259ml\u0259ri" },
            { "type.nu.armn", "Erm\u0259ni R\u0259q\u0259ml\u0259ri" },
            { "type.nu.beng", "Benqal R\u0259q\u0259ml\u0259ri" },
            { "type.nu.cakm", "\u00c7akma r\u0259q\u0259ml\u0259ri" },
            { "type.nu.deva", "Devanaqari R\u0259q\u0259ml\u0259ri" },
            { "type.nu.ethi", "Efiop R\u0259q\u0259ml\u0259ri" },
            { "type.nu.geor", "G\u00fcrc\u00fc R\u0259q\u0259ml\u0259ri" },
            { "type.nu.grek", "Yunan R\u0259q\u0259ml\u0259ri" },
            { "type.nu.gujr", "Qucarat R\u0259q\u0259ml\u0259ri" },
            { "type.nu.guru", "Qurmuxi R\u0259q\u0259ml\u0259ri" },
            { "type.nu.hans", "Sad\u0259l\u0259\u015fmi\u015f \u00c7in R\u0259q\u0259ml\u0259ri" },
            { "type.nu.hant", "\u018fn\u0259n\u0259vi \u00c7in R\u0259q\u0259ml\u0259ri" },
            { "type.nu.hebr", "\u0130vrit R\u0259q\u0259ml\u0259ri" },
            { "type.nu.java", "Cava r\u0259q\u0259ml\u0259ri" },
            { "type.nu.jpan", "Yapon R\u0259q\u0259ml\u0259ri" },
            { "type.nu.khmr", "Kxmer R\u0259q\u0259ml\u0259ri" },
            { "type.nu.knda", "Kannada R\u0259q\u0259ml\u0259ri" },
            { "type.nu.laoo", "Lao R\u0259q\u0259ml\u0259ri" },
            { "type.nu.latn", "Q\u0259rb R\u0259q\u0259ml\u0259ri" },
            { "type.nu.mlym", "Malayalam R\u0259q\u0259ml\u0259ri" },
            { "type.nu.mtei", "Mitei Mayek r\u0259q\u0259ml\u0259ri" },
            { "type.nu.mymr", "Myanma R\u0259q\u0259ml\u0259ri" },
            { "type.nu.olck", "Ol \u00c7iki r\u0259q\u0259ml\u0259ri" },
            { "type.nu.orya", "Oriya R\u0259q\u0259ml\u0259ri" },
            { "type.nu.taml", "\u018fn\u0259n\u0259vi Tamil R\u0259q\u0259ml\u0259ri" },
            { "type.nu.telu", "Teluqu R\u0259q\u0259ml\u0259ri" },
            { "type.nu.thai", "Tay R\u0259q\u0259ml\u0259ri" },
            { "type.nu.tibt", "Tibet R\u0259q\u0259ml\u0259ri" },
            { "type.nu.vaii", "Vai r\u0259q\u0259ml\u0259ri" },
            { "type.ca.dangi", "Dangi t\u0259qvimi" },
            { "type.co.ducet", "Standart Unicode S\u0131ralama" },
            { "type.lb.loose", "S\u0259rb\u0259st s\u0259tird\u0259n s\u0259tr\u0259 ke\u00e7irm\u0259 \u00fcslubu" },
            { "type.nu.roman", "Rum R\u0259q\u0259ml\u0259ri" },
            { "type.ca.coptic", "Kopt t\u0259qvimi" },
            { "type.ca.hebrew", "Y\u0259hudi T\u0259qvimi" },
            { "type.ca.indian", "Hindi t\u0259qvimi" },
            { "type.co.pinyin", "Pinyin t\u0259qvimi" },
            { "type.co.search", "\u00dcmumi M\u0259qs\u0259dli Axtar\u0131\u015f" },
            { "type.lb.normal", "Normal s\u0259tird\u0259n s\u0259tr\u0259 ke\u00e7irm\u0259 \u00fcslubu" },
            { "type.lb.strict", "S\u0259rt s\u0259tird\u0259n s\u0259tr\u0259 ke\u00e7irm\u0259 \u00fcslubu" },
            { "type.ms.metric", "Metrik Sistem" },
            { "type.ca.chinese", "\u00c7in t\u0259qvimi" },
            { "type.ca.islamic", "Hicri t\u0259qvimi" },
            { "type.ca.iso8601", "ISO-8601 T\u0259qvimi" },
            { "type.ca.persian", "\u0130ran T\u0259qvimi" },
            { "type.cf.account", "U\u00e7ot Valyuta Format\u0131" },
            { "type.nu.arabext", "Geni\u015fl\u0259nmi\u015f \u018fr\u0259b-Hind R\u0259q\u0259ml\u0259ri" },
            { "type.nu.armnlow", "Ki\u00e7ik Erm\u0259ni R\u0259q\u0259ml\u0259ri" },
            { "type.nu.greklow", "Ki\u00e7ik Yunan R\u0259q\u0259ml\u0259ri" },
            { "type.nu.hanidec", "Onluq \u00c7in R\u0259q\u0259ml\u0259ri" },
            { "type.nu.hansfin", "Sad\u0259l\u0259\u015fmi\u015f \u00c7in Maliyy\u0259 R\u0259q\u0259ml\u0259ri" },
            { "type.nu.hantfin", "\u018fn\u0259n\u0259vi \u00c7in Maliyy\u0259 R\u0259q\u0259ml\u0259ri" },
            { "type.nu.jpanfin", "Yapon Maliyy\u0259 R\u0259q\u0259ml\u0259ri" },
            { "type.nu.tamldec", "Tamil R\u0259q\u0259ml\u0259ri" },
            { "type.ca.buddhist", "Buddist t\u0259qvimi" },
            { "type.ca.ethiopic", "Efiop t\u0259qvimi" },
            { "type.ca.japanese", "Yapon T\u0259qvimi" },
            { "type.cf.standard", "Standart Valyuta Format\u0131" },
            { "type.co.standard", "Standart S\u0131ralama" },
            { "type.ms.uksystem", "\u0130mperial \u00d6l\u00e7\u00fc Sistemi" },
            { "type.ms.ussystem", "AB\u015e \u00d6l\u00e7\u00fc Sistemi" },
            { "type.nu.fullwide", "Tam Geni\u015f R\u0259q\u0259ml\u0259r" },
            { "type.nu.romanlow", "Ki\u00e7ik Rum R\u0259q\u0259ml\u0259ri" },
            { "type.ca.gregorian", "Qreqorian t\u0259qvimi" },
            { "type.ca.islamic-tbla", "Hicri t\u0259qvim (tabulyar, astromonik d\u00f6vr)" },
            { "type.ca.islamic-civil", "Hicri t\u0259qvimi (tabulyar, v\u0259t\u0259nda\u015fl\u0131q d\u00f6vr\u00fc)" },
            { "type.ca.islamic-umalqura", "Hicri t\u0259qvim (Umm \u0259l-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Efiop amet-alem t\u0259qvimi" },
        };
        return data;
    }
}
