/*
 * Copyright (c) 1998, 2017, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

/**
 * Contains classes and interfaces used by the {@code JFileChooser} component.
 * <p>
 * <strong>Note:</strong>
 * Most of the Swing API is <em>not</em> thread safe. For details, see
 * <a
 * href="https://docs.oracle.com/javase/tutorial/uiswing/concurrency/index.html"
 * target="_top">Concurrency in Swing</a>,
 * a section in
 * <em><a href="https://docs.oracle.com/javase/tutorial/"
 * target="_top">The Java Tutorial</a></em>.
 *
 * <h2>Related Documentation </h2>
 * This document forms the complete API specification. For overviews, tutorials,
 * examples, guides, and tool documentation, please see:
 * <ul>
 *     <li><a href="https://docs.oracle.com/javase/tutorial/uiswing/components/filechooser.html"
 *     target="_top">How to Use File Choosers</a>,
 *     a section in <em>The Java Tutorial</em></li>
 *     <li>{@extLink i18n_overview Internationalization Overview}</li>
 *     <li>{@extLink imf_overview Input Method Framework Overview}</li>
 * </ul>
 *
 * @since 1.2
 * @serial exclude
 */
package javax.swing.filechooser;
