// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: JDWPOptions.java
package com.oracle.svm.jdwp.resident;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class JDWPOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(JDWPOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "JDWP": {
            return OptionDescriptor.create(
                /*name*/ "JDWP",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Include JDWP support in the native executable",
                /*container*/ getContainer(),
                /*option*/ JDWPOptions.JDWP,
                /*fieldName*/ "JDWP",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JDWPOptions": {
            return OptionDescriptor.create(
                /*name*/ "JDWPOptions",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ String.class,
                /*help*/ "Specify JDWP options",
                /*container*/ getContainer(),
                /*option*/ JDWPOptions.JDWPOptions,
                /*fieldName*/ "JDWPOptions",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "JDWPTrace": {
            return OptionDescriptor.create(
                /*name*/ "JDWPTrace",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enable JDWP specifc logging",
                /*container*/ getContainer(),
                /*option*/ JDWPOptions.JDWPTrace,
                /*fieldName*/ "JDWPTrace",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 3;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("JDWP");
                    case 1: return get("JDWPOptions");
                    case 2: return get("JDWPTrace");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
