// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: DashboardOptions.java
package com.oracle.svm.hosted.dashboard;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class DashboardOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(DashboardOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "DashboardAll": {
            return OptionDescriptor.create(
                /*name*/ "DashboardAll",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "In the dashboard dump, include all available information about the native image (this takes precedence over more specific flags).",
                /*container*/ getContainer(),
                /*option*/ DashboardOptions.DashboardAll,
                /*fieldName*/ "DashboardAll",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DashboardBgv": {
            return OptionDescriptor.create(
                /*name*/ "DashboardBgv",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Set dashboard to use BGV format for dump.",
                /*container*/ getContainer(),
                /*option*/ DashboardOptions.DashboardBgv,
                /*fieldName*/ "DashboardBgv",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DashboardCode": {
            return OptionDescriptor.create(
                /*name*/ "DashboardCode",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "In the dashboard dump, include the breakdown of the code size across different packages.",
                /*container*/ getContainer(),
                /*option*/ DashboardOptions.DashboardCode,
                /*fieldName*/ "DashboardCode",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DashboardDump": {
            return OptionDescriptor.create(
                /*name*/ "DashboardDump",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ String.class,
                /*help*/ "Enable dashboard dumps to the specified file.",
                /*container*/ getContainer(),
                /*option*/ DashboardOptions.DashboardDump,
                /*fieldName*/ "DashboardDump",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DashboardHeap": {
            return OptionDescriptor.create(
                /*name*/ "DashboardHeap",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "In the dashboard dump, include the breakdown of the object sizes in the heap across different classes.",
                /*container*/ getContainer(),
                /*option*/ DashboardOptions.DashboardHeap,
                /*fieldName*/ "DashboardHeap",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DashboardJson": {
            return OptionDescriptor.create(
                /*name*/ "DashboardJson",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Set dashboard to use JSON format for dump.",
                /*container*/ getContainer(),
                /*option*/ DashboardOptions.DashboardJson,
                /*fieldName*/ "DashboardJson",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DashboardPointsTo": {
            return OptionDescriptor.create(
                /*name*/ "DashboardPointsTo",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "In the dashboard dump, include the information about the points-to analysis.",
                /*container*/ getContainer(),
                /*option*/ DashboardOptions.DashboardPointsTo,
                /*fieldName*/ "DashboardPointsTo",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "DashboardPretty": {
            return OptionDescriptor.create(
                /*name*/ "DashboardPretty",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Set dashboard to use pretty print in JSON format.",
                /*container*/ getContainer(),
                /*option*/ DashboardOptions.DashboardPretty,
                /*fieldName*/ "DashboardPretty",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 8;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("DashboardAll");
                    case 1: return get("DashboardBgv");
                    case 2: return get("DashboardCode");
                    case 3: return get("DashboardDump");
                    case 4: return get("DashboardHeap");
                    case 5: return get("DashboardJson");
                    case 6: return get("DashboardPointsTo");
                    case 7: return get("DashboardPretty");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
