// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: RuntimeCompilationFeature.Options.java
package com.oracle.svm.graal.hosted.runtimecompilation;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class RuntimeCompilationFeature_Options_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(RuntimeCompilationFeature.Options.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "EnforceMaxRuntimeCompileMethods": {
            return OptionDescriptor.create(
                /*name*/ "EnforceMaxRuntimeCompileMethods",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Enforce checking of maximum number of methods allowed for runtime compilation. Useful for checking in the gate that the number of methods does not go up without a good reason.",
                /*container*/ getContainer(),
                /*option*/ RuntimeCompilationFeature.Options.EnforceMaxRuntimeCompileMethods,
                /*fieldName*/ "EnforceMaxRuntimeCompileMethods",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaxRuntimeCompileMethods": {
            return OptionDescriptor.create(
                /*name*/ "MaxRuntimeCompileMethods",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ com.oracle.svm.core.option.AccumulatingLocatableMultiOptionValue.Strings.class,
                /*help*/ "Maximum number of methods allowed for runtime compilation.",
                /*container*/ getContainer(),
                /*option*/ RuntimeCompilationFeature.Options.MaxRuntimeCompileMethods,
                /*fieldName*/ "MaxRuntimeCompileMethods",
                /*stability*/ OptionStability.STABLE,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintRuntimeCompilationCallTree": {
            return OptionDescriptor.create(
                /*name*/ "PrintRuntimeCompilationCallTree",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print call tree of methods reachable for runtime compilation",
                /*container*/ getContainer(),
                /*option*/ RuntimeCompilationFeature.Options.PrintRuntimeCompilationCallTree,
                /*fieldName*/ "PrintRuntimeCompilationCallTree",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintRuntimeCompileMethods": {
            return OptionDescriptor.create(
                /*name*/ "PrintRuntimeCompileMethods",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print methods available for runtime compilation",
                /*container*/ getContainer(),
                /*option*/ RuntimeCompilationFeature.Options.PrintRuntimeCompileMethods,
                /*fieldName*/ "PrintRuntimeCompileMethods",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "RuntimeCompilationInlineBeforeAnalysis": {
            return OptionDescriptor.create(
                /*name*/ "RuntimeCompilationInlineBeforeAnalysis",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Deprecated, option no longer has any effect.",
                /*container*/ getContainer(),
                /*option*/ RuntimeCompilationFeature.Options.RuntimeCompilationInlineBeforeAnalysis,
                /*fieldName*/ "RuntimeCompilationInlineBeforeAnalysis",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ true,
                /*deprecationMessage*/ "It no longer has any effect, and no replacement is available");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 5;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("EnforceMaxRuntimeCompileMethods");
                    case 1: return get("MaxRuntimeCompileMethods");
                    case 2: return get("PrintRuntimeCompilationCallTree");
                    case 3: return get("PrintRuntimeCompileMethods");
                    case 4: return get("RuntimeCompilationInlineBeforeAnalysis");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
