// CheckStyle: stop header check
// CheckStyle: stop line length check
// GENERATED CONTENT - DO NOT EDIT
// Source: SerialAndEpsilonGCOptions.java
package com.oracle.svm.core.genscavenge;

import java.util.*;
import jdk.graal.compiler.options.*;
import jdk.graal.compiler.options.OptionType;
import jdk.graal.compiler.options.OptionStability;

public class SerialAndEpsilonGCOptions_OptionDescriptors implements OptionDescriptors {
    private OptionsContainer cachedContainer;
    @Override
    public OptionsContainer getContainer() {
        if (cachedContainer == null) {
            cachedContainer = new OptionsContainer.Default(SerialAndEpsilonGCOptions.class);
        }
        return cachedContainer;
    }

    @Override
    public OptionDescriptor get(String value) {
        switch (getContainer().unprefixed(value)) {
        // CheckStyle: stop line length check
        case "AlignedHeapChunkSize": {
            return OptionDescriptor.create(
                /*name*/ "AlignedHeapChunkSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Long.class,
                /*help*/ "The size of an aligned chunk. Serial and epsilon GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialAndEpsilonGCOptions.AlignedHeapChunkSize,
                /*fieldName*/ "AlignedHeapChunkSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "HeapChunkHeaderPadding": {
            return OptionDescriptor.create(
                /*name*/ "HeapChunkHeaderPadding",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Integer.class,
                /*help*/ "Number of bytes at the beginning of each heap chunk that are not used for payload data, i.e., can be freely used as metadata by the heap chunk provider. Serial and epsilon GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialAndEpsilonGCOptions.HeapChunkHeaderPadding,
                /*fieldName*/ "HeapChunkHeaderPadding",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "InitialTLABSize": {
            return OptionDescriptor.create(
                /*name*/ "InitialTLABSize",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Long.class,
                /*help*/ "Starting TLAB size (in bytes); zero means set ergonomically.",
                /*container*/ getContainer(),
                /*option*/ SerialAndEpsilonGCOptions.InitialTLABSize,
                /*fieldName*/ "InitialTLABSize",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "LargeArrayThreshold": {
            return OptionDescriptor.create(
                /*name*/ "LargeArrayThreshold",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Long.class,
                /*help*/ "The size at or above which an array will be allocated in its own unaligned chunk. Serial and epsilon GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialAndEpsilonGCOptions.LargeArrayThreshold,
                /*fieldName*/ "LargeArrayThreshold",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumHeapSizePercent": {
            return OptionDescriptor.create(
                /*name*/ "MaximumHeapSizePercent",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum heap size as percent of physical memory. Serial and epsilon GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialAndEpsilonGCOptions.MaximumHeapSizePercent,
                /*fieldName*/ "MaximumHeapSizePercent",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "MaximumYoungGenerationSizePercent": {
            return OptionDescriptor.create(
                /*name*/ "MaximumYoungGenerationSizePercent",
                /*optionType*/ OptionType.User,
                /*optionValueType*/ Integer.class,
                /*help*/ "The maximum size of the young generation as a percentage of the maximum heap size. Serial and epsilon GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialAndEpsilonGCOptions.MaximumYoungGenerationSizePercent,
                /*fieldName*/ "MaximumYoungGenerationSizePercent",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "PrintTLAB": {
            return OptionDescriptor.create(
                /*name*/ "PrintTLAB",
                /*optionType*/ OptionType.Expert,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Print information about TLABs. Printed when The TLABs are retired before a GC, and during the resizing of the TLABs. Serial and epsilon GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialAndEpsilonGCOptions.PrintTLAB,
                /*fieldName*/ "PrintTLAB",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Fill unused memory chunks with a sentinel value. Serial and epsilon GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialAndEpsilonGCOptions.ZapChunks,
                /*fieldName*/ "ZapChunks",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapConsumedHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapConsumedHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "After use, Fill memory chunks with a sentinel value. Serial and epsilon GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialAndEpsilonGCOptions.ZapConsumedHeapChunks,
                /*fieldName*/ "ZapConsumedHeapChunks",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        case "ZapProducedHeapChunks": {
            return OptionDescriptor.create(
                /*name*/ "ZapProducedHeapChunks",
                /*optionType*/ OptionType.Debug,
                /*optionValueType*/ Boolean.class,
                /*help*/ "Before use, fill memory chunks with a sentinel value. Serial and epsilon GC only.",
                /*container*/ getContainer(),
                /*option*/ SerialAndEpsilonGCOptions.ZapProducedHeapChunks,
                /*fieldName*/ "ZapProducedHeapChunks",
                /*stability*/ OptionStability.EXPERIMENTAL,
                /*deprecated*/ false,
                /*deprecationMessage*/ "");
        }
        // CheckStyle: resume line length check
        }
        return null;
    }

    @Override
    public Iterator<OptionDescriptor> iterator() {
        return new Iterator<>() {
            int i = 0;
            @Override
            public boolean hasNext() {
                return i < 10;
            }
            @Override
            public OptionDescriptor next() {
                switch (i++) {
                    case 0: return get("AlignedHeapChunkSize");
                    case 1: return get("HeapChunkHeaderPadding");
                    case 2: return get("InitialTLABSize");
                    case 3: return get("LargeArrayThreshold");
                    case 4: return get("MaximumHeapSizePercent");
                    case 5: return get("MaximumYoungGenerationSizePercent");
                    case 6: return get("PrintTLAB");
                    case 7: return get("ZapChunks");
                    case 8: return get("ZapConsumedHeapChunks");
                    case 9: return get("ZapProducedHeapChunks");
                }
                throw new NoSuchElementException();
            }
        };
    }
}
