/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_et extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_ar = "araabia";
        final String metaValue_hy = "armeenia";
        final String metaValue_ae = "avesta";
        final String metaValue_ban = "bali";
        final String metaValue_bbc = "bataki";
        final String metaValue_bn = "bengali";
        final String metaValue_zbl = "Blissi s\u00fcmbolid";
        final String metaValue_bug = "bugi";
        final String metaValue_ccp = "t\u0161aakma";
        final String metaValue_chr = "t\u0161erokii";
        final String metaValue_cop = "kopti";
        final String metaValue_gez = "etioopia";
        final String metaValue_ka = "gruusia";
        final String metaValue_got = "gooti";
        final String metaValue_el = "kreeka";
        final String metaValue_gu = "gud\u017earati";
        final String metaValue_ko = "korea";
        final String metaValue_he = "heebrea";
        final String metaValue_jv = "jaava";
        final String metaValue_ja = "jaapani";
        final String metaValue_kaw = "kaavi";
        final String metaValue_km = "khmeeri";
        final String metaValue_kn = "kannada";
        final String metaValue_kpe = "kpelle";
        final String metaValue_lo = "lao";
        final String metaValue_la = "ladina";
        final String metaValue_mak = "makassari";
        final String metaValue_men = "mende";
        final String metaValue_ml = "malajalami";
        final String metaValue_mn = "mongoli";
        final String metaValue_my = "birma";
        final String metaValue_new = "nevari";
        final String metaValue_nqo = "nkoo";
        final String metaValue_sat = "santali";
        final String metaValue_or = "oria";
        final String metaValue_osa = "oseid\u017ei";
        final String metaValue_phn = "foiniikia";
        final String metaValue_rhg = "rohingja";
        final String metaValue_saz = "saura\u0161tra";
        final String metaValue_si = "singali";
        final String metaValue_sog = "sogdi";
        final String metaValue_su = "sunda";
        final String metaValue_syr = "s\u00fc\u00fcria";
        final String metaValue_ta = "tamili";
        final String metaValue_te = "telugu";
        final String metaValue_tl = "tagalogi";
        final String metaValue_th = "tai";
        final String metaValue_bo = "tiibeti";
        final String metaValue_uga = "ugariti";
        final String metaValue_peo = "vanap\u00e4rsia";
        final Object[][] data = new Object[][] {
            { "001", "maailm" },
            { "002", "Aafrika" },
            { "003", "P\u00f5hja-Ameerika" },
            { "005", "L\u00f5una-Ameerika" },
            { "009", "Okeaania" },
            { "011", "L\u00e4\u00e4ne-Aafrika" },
            { "013", "Kesk-Ameerika" },
            { "014", "Ida-Aafrika" },
            { "015", "P\u00f5hja-Aafrika" },
            { "017", "Kesk-Aafrika" },
            { "018", "L\u00f5una-Aafrika" },
            { "019", "Ameerika" },
            { "021", "Ameerika p\u00f5hjaosa" },
            { "029", "Kariibi piirkond" },
            { "030", "Ida-Aasia" },
            { "034", "L\u00f5una-Aasia" },
            { "035", "Kagu-Aasia" },
            { "039", "L\u00f5una-Euroopa" },
            { "053", "Australaasia" },
            { "054", "Melaneesia" },
            { "057", "Mikroneesia (piirkond)" },
            { "061", "Pol\u00fcneesia" },
            { "142", "Aasia" },
            { "143", "Kesk-Aasia" },
            { "145", "L\u00e4\u00e4ne-Aasia" },
            { "150", "Euroopa" },
            { "151", "Ida-Euroopa" },
            { "154", "P\u00f5hja-Euroopa" },
            { "155", "L\u00e4\u00e4ne-Euroopa" },
            { "202", "Sahara-tagune Aafrika" },
            { "419", "Ladina-Ameerika" },
            { "AC", "Ascensioni saar" },
            { "AD", "Andorra" },
            { "AE", "Araabia \u00dchendemiraadid" },
            { "AF", "Afganistan" },
            { "AG", "Antigua ja Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albaania" },
            { "AM", "Armeenia" },
            { "AO", "Angola" },
            { "AQ", "Antarktika" },
            { "AR", "Argentina" },
            { "AS", "Ameerika Samoa" },
            { "AT", "Austria" },
            { "AU", "Austraalia" },
            { "AW", "Aruba" },
            { "AX", "Ahvenamaa" },
            { "AZ", "Aserbaid\u017eaan" },
            { "BA", "Bosnia ja Hertsegoviina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesh" },
            { "BE", "Belgia" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgaaria" },
            { "BH", "Bahrein" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "Saint-Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei" },
            { "BO", "Boliivia" },
            { "BQ", "Kariibi Madalmaad" },
            { "BR", "Brasiilia" },
            { "BS", "Bahama" },
            { "BT", "Bhutan" },
            { "BV", "Bouvet\u2019 saar" },
            { "BW", "Botswana" },
            { "BY", "Valgevene" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kookossaared" },
            { "CD", "Kongo DV" },
            { "CF", "Kesk-Aafrika Vabariik" },
            { "CG", "Kongo Vabariik" },
            { "CH", "\u0160veits" },
            { "CI", "Elevandiluurannik" },
            { "CK", "Cooki saared" },
            { "CL", "T\u0161iili" },
            { "CM", "Kamerun" },
            { "CN", "Hiina" },
            { "CO", "Colombia" },
            { "CP", "Clippertoni saar" },
            { "CQ", "Sark" },
            { "CR", "Costa Rica" },
            { "CU", "Kuuba" },
            { "CV", "Roheneemesaared" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "J\u00f5ulusaar" },
            { "CY", "K\u00fcpros" },
            { "CZ", "T\u0161ehhi" },
            { "DE", "Saksamaa" },
            { "DG", "Diego Garcia" },
            { "DJ", "Djibouti" },
            { "DK", "Taani" },
            { "DM", "Dominica" },
            { "DO", "Dominikaani Vabariik" },
            { "DZ", "Al\u017eeeria" },
            { "EA", "Ceuta ja Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Eesti" },
            { "EG", "Egiptus" },
            { "EH", "L\u00e4\u00e4ne-Sahara" },
            { "ER", "Eritrea" },
            { "ES", "Hispaania" },
            { "ET", "Etioopia" },
            { "EU", "Euroopa Liit" },
            { "EZ", "euroala" },
            { "FI", "Soome" },
            { "FJ", "Fid\u017ei" },
            { "FK", "Falklandi saared" },
            { "FM", "Mikroneesia" },
            { "FO", "F\u00e4\u00e4ri saared" },
            { "FR", "Prantsusmaa" },
            { "GA", "Gabon" },
            { "GB", "\u00dchendkuningriik" },
            { "GD", "Grenada" },
            { "GE", "Gruusia" },
            { "GF", "Prantsuse Guajaana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f6\u00f6nimaa" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "Ekvatoriaal-Guinea" },
            { "GR", "Kreeka" },
            { "GS", "L\u00f5una-Georgia ja L\u00f5una-Sandwichi saared" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Hongkongi erihalduspiirkond" },
            { "HM", "Heardi ja McDonaldi saared" },
            { "HN", "Honduras" },
            { "HR", "Horvaatia" },
            { "HT", "Haiti" },
            { "HU", "Ungari" },
            { "IC", "Kanaari saared" },
            { "ID", "Indoneesia" },
            { "IE", "Iirimaa" },
            { "IL", "Iisrael" },
            { "IM", "Mani saar" },
            { "IN", "India" },
            { "IO", "Briti India ookeani ala" },
            { "IQ", "Iraak" },
            { "IR", "Iraan" },
            { "IS", "Island" },
            { "IT", "Itaalia" },
            { "JE", "Jersey" },
            { "JM", "Jamaica" },
            { "JO", "Jordaania" },
            { "JP", "Jaapan" },
            { "KE", "Keenia" },
            { "KG", "K\u00f5rg\u00f5zstan" },
            { "KH", "Kambod\u017ea" },
            { "KI", "Kiribati" },
            { "KM", "Komoorid" },
            { "KN", "Saint Kitts ja Nevis" },
            { "KP", "P\u00f5hja-Korea" },
            { "KR", "L\u00f5una-Korea" },
            { "KW", "Kuveit" },
            { "KY", "Kaimanisaared" },
            { "KZ", "Kasahstan" },
            { "LA", "Laos" },
            { "LB", "Liibanon" },
            { "LC", "Saint Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Libeeria" },
            { "LS", "Lesotho" },
            { "LT", "Leedu" },
            { "LU", "Luksemburg" },
            { "LV", "L\u00e4ti" },
            { "LY", "Liib\u00fca" },
            { "MA", "Maroko" },
            { "MC", "Monaco" },
            { "MD", "Moldova" },
            { "ME", "Montenegro" },
            { "MF", "Saint-Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshalli Saared" },
            { "MK", "P\u00f5hja-Makedoonia" },
            { "ML", "Mali" },
            { "MM", "Myanmar (Birma)" },
            { "MN", "Mongoolia" },
            { "MO", "Macau erihalduspiirkond" },
            { "MP", "P\u00f5hja-Mariaanid" },
            { "MQ", "Martinique" },
            { "MR", "Mauritaania" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Maldiivid" },
            { "MW", "Malawi" },
            { "MX", "Mehhiko" },
            { "MY", "Malaisia" },
            { "MZ", "Mosambiik" },
            { "NA", "Namiibia" },
            { "NC", "Uus-Kaledoonia" },
            { "NE", "Niger" },
            { "NF", "Norfolk" },
            { "NG", "Nigeeria" },
            { "NI", "Nicaragua" },
            { "NL", "Holland" },
            { "NO", "Norra" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Uus-Meremaa" },
            { "OM", "Omaan" },
            { "PA", "Panama" },
            { "PE", "Peruu" },
            { "PF", "Prantsuse Pol\u00fcneesia" },
            { "PG", "Paapua Uus-Guinea" },
            { "PH", "Filipiinid" },
            { "PK", "Pakistan" },
            { "PL", "Poola" },
            { "PM", "Saint-Pierre ja Miquelon" },
            { "PN", "Pitcairni saared" },
            { "PR", "Puerto Rico" },
            { "PS", "Palestiina alad" },
            { "PT", "Portugal" },
            { "PW", "Belau" },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "Okeaania hajasaared" },
            { "RE", "R\u00e9union" },
            { "RO", "Rumeenia" },
            { "RS", "Serbia" },
            { "RU", "Venemaa" },
            { "RW", "Rwanda" },
            { "SA", "Saudi Araabia" },
            { "SB", "Saalomoni Saared" },
            { "SC", "Sei\u0161ellid" },
            { "SD", "Sudaan" },
            { "SE", "Rootsi" },
            { "SG", "Singapur" },
            { "SH", "Saint Helena" },
            { "SI", "Sloveenia" },
            { "SJ", "Svalbard ja Jan Mayen" },
            { "SK", "Slovakkia" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somaalia" },
            { "SR", "Suriname" },
            { "SS", "L\u00f5una-Sudaan" },
            { "ST", "S\u00e3o Tom\u00e9 ja Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "S\u00fc\u00fcria" },
            { "SZ", "Svaasimaa" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks ja Caicos" },
            { "TD", "T\u0161aad" },
            { "TF", "Prantsuse L\u00f5unaalad" },
            { "TG", "Togo" },
            { "TH", "Tai" },
            { "TJ", "Tad\u017eikistan" },
            { "TK", "Tokelau" },
            { "TL", "Ida-Timor" },
            { "TM", "T\u00fcrkmenistan" },
            { "TN", "Tuneesia" },
            { "TO", "Tonga" },
            { "TR", "T\u00fcrgi" },
            { "TT", "Trinidad ja Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansaania" },
            { "UA", "Ukraina" },
            { "UG", "Uganda" },
            { "UM", "\u00dchendriikide hajasaared" },
            { "UN", "\u00dchinenud Rahvaste Organisatsioon" },
            { "US", "Ameerika \u00dchendriigid" },
            { "UY", "Uruguay" },
            { "UZ", "Usbekistan" },
            { "VA", "Vatikan" },
            { "VC", "Saint Vincent ja Grenadiinid" },
            { "VE", "Venezuela" },
            { "VG", "Briti Neitsisaared" },
            { "VI", "USA Neitsisaared" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis ja Futuna" },
            { "WS", "Samoa" },
            { "XA", "pseudo-aktsent" },
            { "XB", "pseudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Jeemen" },
            { "YT", "Mayotte" },
            { "ZA", "L\u00f5una-Aafrika Vabariik" },
            { "ZM", "Sambia" },
            { "ZW", "Zimbabwe" },
            { "ZZ", "tundmatu piirkond" },
            { "aa", "afari" },
            { "ab", "abhaasi" },
            { "ae", metaValue_ae },
            { "af", "afrikaani" },
            { "ak", "akani" },
            { "am", "amhara" },
            { "an", "aragoni" },
            { "ar", metaValue_ar },
            { "as", "assami" },
            { "av", "avaari" },
            { "ay", "aimara" },
            { "az", "aserbaid\u017eaani" },
            { "ba", "ba\u0161kiiri" },
            { "be", "valgevene" },
            { "bg", "bulgaaria" },
            { "bi", "bislama" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretooni" },
            { "bs", "bosnia" },
            { "ca", "katalaani" },
            { "ce", "t\u0161et\u0161eeni" },
            { "ch", "t\u0161amorro" },
            { "co", "korsika" },
            { "cr", "krii" },
            { "cs", "t\u0161ehhi" },
            { "cu", "kirikuslaavi" },
            { "cv", "t\u0161uva\u0161i" },
            { "cy", "k\u00f5mri" },
            { "da", "taani" },
            { "de", "saksa" },
            { "dv", "maldiivi" },
            { "dz", "dzongkha" },
            { "ee", "eve" },
            { "el", metaValue_el },
            { "en", "inglise" },
            { "eo", "esperanto" },
            { "es", "hispaania" },
            { "et", "eesti" },
            { "eu", "baski" },
            { "fa", "p\u00e4rsia" },
            { "ff", "fula" },
            { "fi", "soome" },
            { "fj", "fid\u017ei" },
            { "fo", "f\u00e4\u00e4ri" },
            { "fr", "prantsuse" },
            { "fy", "l\u00e4\u00e4nefriisi" },
            { "ga", "iiri" },
            { "gd", "gaeli" },
            { "gl", "galeegi" },
            { "gn", "guaranii" },
            { "gu", metaValue_gu },
            { "gv", "m\u00e4nksi" },
            { "ha", "hausa" },
            { "he", metaValue_he },
            { "hi", "hindi" },
            { "ho", "hirimotu" },
            { "hr", "horvaadi" },
            { "ht", "haiti" },
            { "hu", "ungari" },
            { "hy", metaValue_hy },
            { "hz", "herero" },
            { "ia", "interlingua" },
            { "id", "indoneesia" },
            { "ie", "interlingue" },
            { "ig", "ibo" },
            { "ii", "nuosu" },
            { "ik", "injupiaki" },
            { "io", "ido" },
            { "is", "islandi" },
            { "it", "itaalia" },
            { "iu", "inuktituti" },
            { "ja", metaValue_ja },
            { "jv", metaValue_jv },
            { "ka", metaValue_ka },
            { "kg", "kongo" },
            { "ki", "kikuju" },
            { "kj", "kvanjama" },
            { "kk", "kasahhi" },
            { "kl", "gr\u00f6\u00f6ni" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "kanuri" },
            { "ks", "ka\u0161miiri" },
            { "ku", "kurdi" },
            { "kv", "komi" },
            { "kw", "korni" },
            { "ky", "kirgiisi" },
            { "la", metaValue_la },
            { "lb", "letseburgi" },
            { "lg", "ganda" },
            { "li", "limburgi" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "leedu" },
            { "lu", "Katanga luba" },
            { "lv", "l\u00e4ti" },
            { "mg", "malagassi" },
            { "mh", "mar\u0161alli" },
            { "mi", "maoori" },
            { "mk", "makedoonia" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "marathi" },
            { "ms", "malai" },
            { "mt", "malta" },
            { "my", metaValue_my },
            { "na", "nauru" },
            { "nb", "norra bokm\u00e5l" },
            { "nd", "p\u00f5hjandebele" },
            { "ne", "nepali" },
            { "ng", "ndonga" },
            { "nl", "hollandi" },
            { "nn", "uusnorra" },
            { "no", "norra" },
            { "nr", "l\u00f5unandebele" },
            { "nv", "navaho" },
            { "ny", "njand\u017ea" },
            { "oc", "oksitaani" },
            { "oj", "od\u017eibvei" },
            { "om", "oromo" },
            { "or", metaValue_or },
            { "os", "osseedi" },
            { "pa", "pand\u017eabi" },
            { "pi", "paali" },
            { "pl", "poola" },
            { "ps", "pu\u0161tu" },
            { "pt", "portugali" },
            { "qu", "ket\u0161ua" },
            { "rm", "roman\u0161i" },
            { "rn", "rundi" },
            { "ro", "rumeenia" },
            { "ru", "vene" },
            { "rw", "ruanda" },
            { "sa", "sanskriti" },
            { "sc", "sardi" },
            { "sd", "sindhi" },
            { "se", "p\u00f5hjasaami" },
            { "sg", "sango" },
            { "sh", "serbia-horvaadi" },
            { "si", metaValue_si },
            { "sk", "slovaki" },
            { "sl", "sloveeni" },
            { "sm", "samoa" },
            { "sn", "\u0161ona" },
            { "so", "somaali" },
            { "sq", "albaania" },
            { "sr", "serbia" },
            { "ss", "svaasi" },
            { "st", "l\u00f5unasotho" },
            { "su", metaValue_su },
            { "sv", "rootsi" },
            { "sw", "suahiili" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tad\u017eiki" },
            { "th", metaValue_th },
            { "ti", "tigrinja" },
            { "tk", "t\u00fcrkmeeni" },
            { "tl", metaValue_tl },
            { "tn", "tsvana" },
            { "to", "tonga" },
            { "tr", "t\u00fcrgi" },
            { "ts", "tsonga" },
            { "tt", "tatari" },
            { "tw", "tvii" },
            { "ty", "tahiti" },
            { "ug", "uiguuri" },
            { "uk", "ukraina" },
            { "ur", "urdu" },
            { "uz", "usbeki" },
            { "ve", "venda" },
            { "vi", "vietnami" },
            { "vo", "volap\u00fcki" },
            { "wa", "vallooni" },
            { "wo", "volofi" },
            { "xh", "koosa" },
            { "yi", "jidi\u0161i" },
            { "yo", "joruba" },
            { "za", "t\u0161uangi" },
            { "zh", "hiina" },
            { "zu", "suulu" },
            { "ace", "at\u0161ehi" },
            { "ach", "at\u0161oli" },
            { "ada", "adangme" },
            { "ady", "ad\u00f5gee" },
            { "aeb", "Tuneesia araabia" },
            { "afh", "afrihili" },
            { "agq", "aghemi" },
            { "ain", "ainu" },
            { "akk", "akadi" },
            { "akz", "alabama" },
            { "ale", "aleuudi" },
            { "aln", "geegi" },
            { "alt", "altai" },
            { "ang", "vanainglise" },
            { "ann", "obolo" },
            { "anp", "angika" },
            { "apc", "Levandi araabia" },
            { "arc", "aramea" },
            { "arn", "mapudunguni" },
            { "aro", "araona" },
            { "arp", "arapaho" },
            { "arq", "Al\u017eeeria araabia" },
            { "ars", "Najdi araabia" },
            { "arw", "aravaki" },
            { "ary", "Maroko araabia" },
            { "arz", "Egiptuse araabia" },
            { "asa", "asu" },
            { "ase", "Ameerika viipekeel" },
            { "ast", "astuuria" },
            { "atj", "atikameki" },
            { "awa", "avadhi" },
            { "bal", "belut\u0161i" },
            { "ban", metaValue_ban },
            { "bar", "baieri" },
            { "bas", "basaa" },
            { "bax", "bamuni" },
            { "bbc", metaValue_bbc },
            { "bbj", "ghomala" },
            { "bej", "bed\u017ea" },
            { "bem", "bemba" },
            { "bew", "betavi" },
            { "bez", "bena" },
            { "bfd", "bafuti" },
            { "bfq", "badaga" },
            { "bgc", "harjaanvi" },
            { "bgn", "l\u00e4\u00e4nebelut\u0161i" },
            { "bho", "bhod\u017epuri" },
            { "bik", "bikoli" },
            { "bin", "edo" },
            { "bjn", "band\u017eari" },
            { "bkm", "komi (Aafrika)" },
            { "bla", "mustjalaindiaani" },
            { "blo", "anii" },
            { "blt", "tai-dami" },
            { "bpy", "bi\u0161nuprija" },
            { "bqi", "bahtiari" },
            { "bra", "brad\u017ei" },
            { "brh", "brahui" },
            { "brx", "bodo" },
            { "bss", "akoose" },
            { "bua", "burjaadi" },
            { "bug", metaValue_bug },
            { "bum", "bulu" },
            { "byn", "bilini" },
            { "byv", "medumba" },
            { "cad", "kado" },
            { "car", "kariibi" },
            { "cay", "kajuka" },
            { "cch", "ait\u0161ami" },
            { "ccp", metaValue_ccp },
            { "ceb", "sebu" },
            { "cgg", "t\u0161iga" },
            { "chb", "t\u0161ibt\u0161a" },
            { "chg", "t\u0161agatai" },
            { "chk", "t\u0161uugi" },
            { "chm", "mari" },
            { "chn", "t\u0161inuki \u017eargoon" },
            { "cho", "t\u0161okto" },
            { "chp", "t\u0161ipevai" },
            { "chr", metaValue_chr },
            { "chy", "\u0161aieeni" },
            { "cic", "t\u0161ikasoo" },
            { "ckb", "sorani" },
            { "clc", "t\u0161ilkotini" },
            { "cop", metaValue_cop },
            { "cps", "kapisnoni" },
            { "crg", "michifi" },
            { "crh", "krimmitatari" },
            { "crj", "l\u00f5una-idakrii" },
            { "crk", "tasandikukrii" },
            { "crl", "p\u00f5hja-idakrii" },
            { "crm", "p\u00f5drakrii" },
            { "crr", "Carolina algonkini" },
            { "crs", "sei\u0161elli" },
            { "csb", "ka\u0161uubi" },
            { "csw", "sookrii" },
            { "dak", "siuu" },
            { "dar", "dargi" },
            { "dav", "davida" },
            { "del", "delavari" },
            { "den", "sleivi" },
            { "dgr", "dogribi" },
            { "din", "dinka" },
            { "dje", "zarma" },
            { "doi", "dogri" },
            { "dsb", "alamsorbi" },
            { "dtp", "keskdusuni" },
            { "dua", "duala" },
            { "dum", "keskhollandi" },
            { "dyo", "fonji" },
            { "dyu", "djula" },
            { "dzg", "daza" },
            { "ebu", "embu" },
            { "efi", "efiki" },
            { "egl", "emiilia" },
            { "egy", "egiptuse" },
            { "eka", "ekad\u017euki" },
            { "elx", "eelami" },
            { "enm", "keskinglise" },
            { "esu", "keskjupiki" },
            { "ewo", "evondo" },
            { "ext", "estremenju" },
            { "fan", "fangi" },
            { "fat", "fanti" },
            { "fil", "filipiini" },
            { "fit", "me\u00e4" },
            { "fon", "foni" },
            { "frc", "cajun\u2019i" },
            { "frm", "keskprantsuse" },
            { "fro", "vanaprantsuse" },
            { "frp", "frankoprovansi" },
            { "frr", "p\u00f5hjafriisi" },
            { "frs", "idafriisi" },
            { "fur", "friuuli" },
            { "gag", "gagauusi" },
            { "gan", "kani" },
            { "gay", "gajo" },
            { "gba", "gbaja" },
            { "gez", metaValue_gez },
            { "gil", "kiribati" },
            { "glk", "gilaki" },
            { "gmh", "kesk\u00fclemsaksa" },
            { "goh", "vana\u00fclemsaksa" },
            { "gon", "gondi" },
            { "gor", "gorontalo" },
            { "got", metaValue_got },
            { "grb", "grebo" },
            { "grc", "vanakreeka" },
            { "gsw", "\u0161veitsisaksa" },
            { "guc", "vajuu" },
            { "gur", "farefare" },
            { "guz", "gusii" },
            { "gwi", "gvit\u0161ini" },
            { "hai", "haida" },
            { "hak", "hakka" },
            { "haw", "havai" },
            { "hax", "l\u00f5unahaida" },
            { "hif", "Fid\u017ei hindi" },
            { "hil", "hiligainoni" },
            { "hit", "heti" },
            { "hmn", "hmongi" },
            { "hsb", "\u00fclemsorbi" },
            { "hsn", "sjangi" },
            { "hup", "hupa" },
            { "hur", "halkomelemi" },
            { "iba", "ibani" },
            { "ibb", "ibibio" },
            { "ikt", "L\u00e4\u00e4ne-Kanada inuktituti" },
            { "ilo", "iloko" },
            { "inh", "ingu\u0161i" },
            { "izh", "isuri" },
            { "jam", "Jamaica kreoolkeel" },
            { "jbo", "lo\u017eban" },
            { "jgo", "ngomba" },
            { "jmc", "mat\u0161ame" },
            { "jpr", "juudip\u00e4rsia" },
            { "jrb", "juudiaraabia" },
            { "jut", "j\u00fc\u00fcti" },
            { "kaa", "karakalpaki" },
            { "kab", "kabiili" },
            { "kac", "kat\u0161ini" },
            { "kaj", "jju" },
            { "kam", "kamba" },
            { "kaw", metaValue_kaw },
            { "kbd", "kabardi-t\u0161erkessi" },
            { "kbl", "kanembu" },
            { "kcg", "tjapi" },
            { "kde", "makonde" },
            { "kea", "kabuverdianu" },
            { "kfo", "koro" },
            { "kgp", "kaingangi" },
            { "kha", "khasi" },
            { "kho", "saka" },
            { "khq", "koyra chiini" },
            { "khw", "khovari" },
            { "kiu", "k\u00f5rmand\u017eki" },
            { "kkj", "kako" },
            { "kln", "kalend\u017eini" },
            { "kmb", "mbundu" },
            { "koi", "permikomi" },
            { "kok", "konkani" },
            { "kos", "kosrae" },
            { "kpe", metaValue_kpe },
            { "krc", "karat\u0161ai-balkaari" },
            { "kri", "krio" },
            { "krj", "kinaraia" },
            { "krl", "karjala" },
            { "kru", "kuruhhi" },
            { "ksb", "\u0161ambala" },
            { "ksf", "bafia" },
            { "ksh", "k\u00f6lni" },
            { "kum", "kum\u00f5ki" },
            { "kut", "kutenai" },
            { "kwk", "kvakvala" },
            { "kxv", "kuvi" },
            { "lad", "ladiino" },
            { "lag", "langi" },
            { "lah", "lahnda" },
            { "lam", "lamba" },
            { "lez", "lesgi" },
            { "lij", "liguuri" },
            { "lil", "lillueti" },
            { "liv", "liivi" },
            { "lkt", "lakota" },
            { "lld", "ladiini" },
            { "lmo", "lombardi" },
            { "lol", "mongo" },
            { "lou", "Louisiana kreoolkeel" },
            { "loz", "lozi" },
            { "lrc", "p\u00f5hjaluri" },
            { "lsm", "samia" },
            { "ltg", "latgali" },
            { "lua", "lulua" },
            { "lui", "luisenjo" },
            { "lun", "lunda" },
            { "lus", "lu\u0161ei" },
            { "luy", "luhja" },
            { "lzh", "klassikaline hiina" },
            { "lzz", "lazi" },
            { "mad", "madura" },
            { "maf", "mafa" },
            { "mag", "magahi" },
            { "mai", "maithili" },
            { "mak", metaValue_mak },
            { "man", "malinke" },
            { "mas", "masai" },
            { "mde", "maba" },
            { "mdf", "mok\u0161a" },
            { "mdr", "mandari" },
            { "men", metaValue_men },
            { "mer", "meru" },
            { "mfe", "Mauritiuse kreoolkeel" },
            { "mga", "keskiiri" },
            { "mgh", "makhuwa-meetto" },
            { "mgo", "meta" },
            { "mhn", "mohheni" },
            { "mic", "mikmaki" },
            { "min", "minangkabau" },
            { "mnc", "mand\u017eu" },
            { "mni", "manipuri" },
            { "moe", "innu" },
            { "moh", "mohoogi" },
            { "mos", "more" },
            { "mrj", "m\u00e4emari" },
            { "mua", "mundangi" },
            { "mul", "mitu keelt" },
            { "mus", "maskogi" },
            { "mwl", "miranda" },
            { "mwr", "marvari" },
            { "mwv", "mentavei" },
            { "mye", "mjene" },
            { "myv", "ersa" },
            { "mzn", "mazandaraani" },
            { "nan", "l\u00f5unamini" },
            { "nap", "napoli" },
            { "naq", "nama" },
            { "nds", "alamsaksa" },
            { "new", metaValue_new },
            { "nia", "niasi" },
            { "niu", "niue" },
            { "njo", "ao" },
            { "nmg", "kwasio" },
            { "nnh", "ngiembooni" },
            { "nog", "nogai" },
            { "non", "vanap\u00f5hja" },
            { "nov", "noviaal" },
            { "nqo", metaValue_nqo },
            { "nso", "p\u00f5hjasotho" },
            { "nus", "nueri" },
            { "nwc", "vananevari" },
            { "nym", "njamvesi" },
            { "nyn", "njankole" },
            { "nyo", "njoro" },
            { "nzi", "nzima" },
            { "ojb", "loodeod\u017eibvei" },
            { "ojc", "keskod\u017eibvei" },
            { "ojs", "Severni od\u017eibvei" },
            { "ojw", "l\u00e4\u00e4neod\u017eibvei" },
            { "oka", "okanagani" },
            { "osa", metaValue_osa },
            { "ota", "osmanit\u00fcrgi" },
            { "pag", "pangasinani" },
            { "pal", "pahlavi" },
            { "pam", "pampanga" },
            { "pap", "papiamento" },
            { "pau", "belau" },
            { "pcd", "pikardi" },
            { "pcm", "Nigeeria pid\u017einkeel" },
            { "pdc", "Pennsylvania saksa" },
            { "pdt", "mennoniidisaksa" },
            { "peo", metaValue_peo },
            { "pfl", "Pfalzi" },
            { "phn", metaValue_phn },
            { "pis", "pijini" },
            { "pms", "piemonte" },
            { "pnt", "pontose" },
            { "pon", "poonpei" },
            { "pqm", "passamakodi" },
            { "prg", "preisi" },
            { "pro", "vanaprovansi" },
            { "quc", "kit\u0161e" },
            { "raj", "rad\u017eastani" },
            { "rap", "rapanui" },
            { "rar", "rarotonga" },
            { "rgn", "romanja" },
            { "rhg", metaValue_rhg },
            { "rif", "riifi" },
            { "rof", "rombo" },
            { "rom", "mustlaskeel" },
            { "rtm", "rotuma" },
            { "rue", "russiini" },
            { "rug", "roviana" },
            { "rup", "aromuuni" },
            { "rwk", "rvaa" },
            { "sad", "sandave" },
            { "sah", "jakuudi" },
            { "sam", "Samaaria aramea" },
            { "saq", "samburu" },
            { "sas", "sasaki" },
            { "sat", metaValue_sat },
            { "saz", metaValue_saz },
            { "sba", "ngambai" },
            { "sbp", "sangu" },
            { "scn", "sitsiilia" },
            { "sco", "\u0161oti" },
            { "sdh", "l\u00f5unakurdi" },
            { "see", "seneka" },
            { "seh", "sena" },
            { "sei", "seri" },
            { "sel", "s\u00f6lkupi" },
            { "ses", "koyraboro senni" },
            { "sga", "vanaiiri" },
            { "sgs", "\u017eemaidi" },
            { "shi", "\u0161ilha" },
            { "shn", "\u0161ani" },
            { "shu", "T\u0161aadi araabia" },
            { "sid", "sidamo" },
            { "skr", "seraiki" },
            { "slh", "L\u00f5una-Puget-Soundi sali\u0161i" },
            { "sli", "alamsileesia" },
            { "sly", "selajari" },
            { "sma", "l\u00f5unasaami" },
            { "smj", "Lule saami" },
            { "smn", "Inari saami" },
            { "sms", "koltasaami" },
            { "snk", "soninke" },
            { "sog", metaValue_sog },
            { "srn", "sranani" },
            { "srr", "sereri" },
            { "ssy", "saho" },
            { "stq", "saterfriisi" },
            { "str", "v\u00e4inasali\u0161i" },
            { "suk", "sukuma" },
            { "sus", "susu" },
            { "sux", "sumeri" },
            { "swb", "komoori" },
            { "syc", "vanas\u00fc\u00fcria" },
            { "syr", metaValue_syr },
            { "szl", "sileesia" },
            { "tce", "l\u00f5unatut\u0161oni" },
            { "tcy", "tulu" },
            { "tem", "temne" },
            { "teo", "teso" },
            { "ter", "tereno" },
            { "tet", "tetumi" },
            { "tgx", "tagishi" },
            { "tht", "tahltani" },
            { "tig", "tigree" },
            { "tiv", "tivi" },
            { "tkl", "tokelau" },
            { "tkr", "tsahhi" },
            { "tlh", "klingoni" },
            { "tli", "tlingiti" },
            { "tly", "tal\u00f5\u0161i" },
            { "tmh", "tama\u0161eki" },
            { "tog", "t\u0161itonga" },
            { "tok", "toki pona" },
            { "tpi", "uusmelaneesia" },
            { "tru", "turojo" },
            { "trv", "taroko" },
            { "trw", "torvali" },
            { "tsd", "tsakoonia" },
            { "tsi", "tsim\u0161i" },
            { "ttm", "p\u00f5hjatut\u0161oni" },
            { "ttt", "l\u00f5unataadi" },
            { "tum", "tumbuka" },
            { "tvl", "tuvalu" },
            { "twq", "taswaqi" },
            { "tyv", "t\u00f5va" },
            { "tzm", "tamasikti" },
            { "udm", "udmurdi" },
            { "uga", metaValue_uga },
            { "umb", "umbundu" },
            { "und", "m\u00e4\u00e4ramata keel" },
            { "vec", "veneti" },
            { "vep", "vepsa" },
            { "vls", "l\u00e4\u00e4neflaami" },
            { "vmf", "Maini frangi" },
            { "vmw", "makua" },
            { "vot", "vadja" },
            { "vro", "v\u00f5ru" },
            { "vun", "vund\u017eo" },
            { "wae", "valsi" },
            { "wal", "volaita" },
            { "war", "varai" },
            { "was", "va\u0161o" },
            { "wbp", "varlpiri" },
            { "wuu", "uu" },
            { "xal", "kalm\u00f5ki" },
            { "xmf", "megreli" },
            { "xnr", "kangri" },
            { "xog", "soga" },
            { "yao", "jao" },
            { "yap", "japi" },
            { "yav", "yangbeni" },
            { "ybb", "jemba" },
            { "yrl", "njengatu" },
            { "yue", "kantoni" },
            { "zap", "sapoteegi" },
            { "zbl", metaValue_zbl },
            { "zea", "zeelandi" },
            { "zen", "zenaga" },
            { "zgh", "tamasikti (Maroko)" },
            { "zun", "sunji" },
            { "zxx", "mittekeeleline" },
            { "zza", "zaza" },
            { "Adlm", "adlami" },
            { "Afak", "afaka" },
            { "Aghb", "albaani" },
            { "Ahom", "ahomi" },
            { "Arab", metaValue_ar },
            { "Aran", "nastaliik" },
            { "Armi", "vanaaramea" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", "bamumi" },
            { "Bass", "bassa" },
            { "Batk", metaValue_bbc },
            { "Beng", metaValue_bn },
            { "Blis", metaValue_zbl },
            { "Bopo", "bopomofo" },
            { "Brah", "braahmi" },
            { "Brai", "punktkiri" },
            { "Bugi", metaValue_bug },
            { "Buhd", "buhidi" },
            { "Cakm", metaValue_ccp },
            { "Cans", "Kanada p\u00f5lisrahvaste \u00fchtlustatud silpkiri" },
            { "Cari", "kaaria" },
            { "Cham", "t\u0161aami" },
            { "Cher", metaValue_chr },
            { "Chrs", "horezmi" },
            { "Cirt", "Cirthi" },
            { "Copt", metaValue_cop },
            { "Cpmn", "K\u00fcprose minose" },
            { "Cprt", "K\u00fcprose silpkiri" },
            { "Cyrl", "kirillitsa" },
            { "Cyrs", "k\u00fcrilliline kirikuslaavi" },
            { "Deva", "devanaagari" },
            { "Diak", "divehi" },
            { "Dsrt", "desereti" },
            { "Dupl", "Duploy\u00e9 kiirkiri" },
            { "Egyd", "egiptuse demootiline" },
            { "Egyh", "egiptuse hieraatiline" },
            { "Egyp", "egiptuse hierogl\u00fc\u00fcfkiri" },
            { "Elba", "Elbasani" },
            { "Elym", "el\u00fcmi" },
            { "Ethi", metaValue_gez },
            { "Gara", "garai" },
            { "Geok", "hutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "glagoolitsa" },
            { "Gong", "G\u016bnj\u0101la gondi" },
            { "Gonm", "Masarami gondi" },
            { "Goth", metaValue_got },
            { "Gran", "grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmukhi" },
            { "Hanb", "hanbi" },
            { "Hang", metaValue_ko },
            { "Hani", "hani" },
            { "Hano", "hanunoo" },
            { "Hans", "lihtsustatud" },
            { "Hant", "traditsiooniline" },
            { "Hatr", "Hatra" },
            { "Hebr", metaValue_he },
            { "Hira", "hiragana" },
            { "Hluw", "Anatoolia hierogl\u00fc\u00fcfkiri" },
            { "Hmng", "phahau-hmongi kiri" },
            { "Hrkt", "jaapani silpkirjad" },
            { "Hung", "vanaungari" },
            { "Inds", "Induse" },
            { "Ital", "vanaitali" },
            { "Jamo", "jamo" },
            { "Java", metaValue_jv },
            { "Jpan", metaValue_ja },
            { "Jurc", "t\u0161urt\u0161eni" },
            { "Kali", "kaja-lii" },
            { "Kana", "katakana" },
            { "Kawi", metaValue_kaw },
            { "Khar", "kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "hod\u017eki" },
            { "Kits", "kitani v\u00e4ike kiri" },
            { "Knda", metaValue_kn },
            { "Kore", "korea segakiri" },
            { "Kpel", metaValue_kpe },
            { "Kthi", "kaithi" },
            { "Lana", "tai-thami" },
            { "Laoo", metaValue_lo },
            { "Latf", "ladina fraktuurkiri" },
            { "Latg", "ladina gaeli" },
            { "Latn", metaValue_la },
            { "Lepc", "lept\u0161a" },
            { "Limb", "limbu" },
            { "Lina", "lineaarkiri A" },
            { "Linb", "lineaarkiri B" },
            { "Lisu", "lisu" },
            { "Loma", "loma" },
            { "Lyci", "l\u00fc\u00fckia" },
            { "Lydi", "l\u00fc\u00fcdia" },
            { "Mahj", "mahaad\u017eani" },
            { "Maka", metaValue_mak },
            { "Mand", "mandea" },
            { "Mani", "mani" },
            { "Maya", "maaja hierogl\u00fc\u00fcfkiri" },
            { "Mend", metaValue_men },
            { "Merc", "meroe kursiivkiri" },
            { "Mero", "meroe" },
            { "Mlym", metaValue_ml },
            { "Modi", "modi" },
            { "Mong", metaValue_mn },
            { "Moon", "Mooni" },
            { "Mroo", "mruu" },
            { "Mtei", "meitei" },
            { "Mult", "Multani" },
            { "Mymr", metaValue_my },
            { "Nagm", "Nagi mundari" },
            { "Narb", "P\u00f5hja-Araabia" },
            { "Nbat", "Nabatea" },
            { "Newa", metaValue_new },
            { "Nkgb", "nasi" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "n\u00fc\u0161u" },
            { "Ogam", "ogam" },
            { "Olck", metaValue_sat },
            { "Orkh", "Orhoni" },
            { "Orya", metaValue_or },
            { "Osge", metaValue_osa },
            { "Osma", "osmani" },
            { "Ougr", "vanauiguuri" },
            { "Palm", "Palmyra" },
            { "Perm", "vanapermi" },
            { "Phag", "phakpa" },
            { "Phli", "pahlavi raidkiri" },
            { "Phlp", "pahlavi psalmikiri" },
            { "Phlv", "pahlavi raamatukiri" },
            { "Phnx", metaValue_phn },
            { "Plrd", "Pollardi miao" },
            { "Prti", "partia raidkiri" },
            { "Rjng", "red\u017eangi" },
            { "Rohg", metaValue_rhg },
            { "Roro", "rongorongo" },
            { "Runr", "ruunikiri" },
            { "Samr", "Samaaria" },
            { "Sara", "sarati" },
            { "Sarb", "L\u00f5una-Araabia" },
            { "Saur", metaValue_saz },
            { "Sgnw", "viipekiri" },
            { "Shaw", "Shaw\u2019 kiri" },
            { "Shrd", "\u0161aarada" },
            { "Sidd", "siddhami" },
            { "Sind", "hudavadi" },
            { "Sinh", metaValue_si },
            { "Sogd", metaValue_sog },
            { "Sogo", "vanasogdi" },
            { "Sora", "sora" },
            { "Soyo", "sojombo" },
            { "Sund", metaValue_su },
            { "Sunu", "sunvari" },
            { "Sylo", "siloti" },
            { "Syrc", metaValue_syr },
            { "Syre", "s\u00fc\u00fcria estrangelo" },
            { "Syrj", "l\u00e4\u00e4nes\u00fc\u00fcria" },
            { "Syrn", "idas\u00fc\u00fcria" },
            { "Tagb", "tagbanva" },
            { "Takr", "taakri" },
            { "Tale", "tai-l\u00f6\u00f6" },
            { "Talu", "uus tai-l\u00f5\u00f5" },
            { "Taml", metaValue_ta },
            { "Tang", "tanguudi" },
            { "Tavt", "tai-vieti" },
            { "Telu", metaValue_te },
            { "Teng", "Tengwari" },
            { "Tfng", "tifinagi" },
            { "Tglg", metaValue_tl },
            { "Thaa", "taana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Tirh", "tirhuta" },
            { "Tnsa", "tase" },
            { "Toto", "toto" },
            { "Ugar", metaValue_uga },
            { "Vaii", "vai" },
            { "Visp", "n\u00e4htava k\u00f5ne" },
            { "Vith", "Vithkuqi" },
            { "Wara", "hoo" },
            { "Wcho", "vant\u0161o" },
            { "Wole", "voleai" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "sumeri-akadi kiilkiri" },
            { "Yezi", "jeziidi" },
            { "Yiii", "jii" },
            { "Zanb", "Dzanabadzari ruutkiri" },
            { "Zinh", "p\u00e4ritud" },
            { "Zmth", "matemaatiline t\u00e4histus" },
            { "Zsye", "emoji" },
            { "Zsym", "s\u00fcmbolid" },
            { "Zxxx", "kirjakeeleta" },
            { "Zyyy", "\u00fcldine" },
            { "Zzzz", "m\u00e4\u00e4ramata kiri" },
            { "de_AT", "Austria saksa" },
            { "de_CH", "\u0160veitsi \u00fclemsaksa" },
            { "en_AU", "Austraalia inglise" },
            { "en_CA", "Kanada inglise" },
            { "en_GB", "Briti inglise" },
            { "en_US", "Ameerika inglise" },
            { "es_ES", "Euroopa hispaania" },
            { "es_MX", "Mehhiko hispaania" },
            { "fa_AF", "dari" },
            { "fr_CA", "Kanada prantsuse" },
            { "fr_CH", "\u0160veitsi prantsuse" },
            { "nl_BE", "flaami" },
            { "pt_BR", "Brasiilia portugali" },
            { "pt_PT", "Euroopa portugali" },
            { "ro_MD", "moldova" },
            { "sw_CD", "Kongo suahiili" },
            { "%%1901", "saksa traditsiooniline kirjaviis" },
            { "%%1994", "normitud Resia kirjaviis" },
            { "%%1996", "saksa reformitud kirjaviis" },
            { "ar_001", "t\u00e4nap\u00e4eva araabia kirjakeel" },
            { "es_419", "Ladina-Ameerika hispaania" },
            { "key.ca", "kalender" },
            { "key.cf", "rahavorming" },
            { "key.co", "j\u00e4rjestus" },
            { "key.cu", "v\u00e4\u00e4ring" },
            { "key.hc", "12 v\u00f5i 24 tunni s\u00fcsteem" },
            { "key.lb", "reavahetuse laad" },
            { "key.ms", "m\u00f5\u00f5dustik" },
            { "key.nu", "numbrid" },
            { "key.tz", "ajav\u00f6\u00f6nd" },
            { "key.va", "lokaadi variant" },
            { "nds_NL", "Hollandi alamsaksa" },
            { "%%BISKE", "San Giorgio/Bila murre" },
            { "%%BOONT", "boontlingi" },
            { "%%KKCOR", "\u00fcldlevinud kirjaviis" },
            { "%%KSCOR", "normitud kirjaviis" },
            { "%%LIPAW", "Resia Lipovaz\u2019i murre" },
            { "%%NEDIS", "Natisone murre" },
            { "%%NJIVA", "Gniva/Njiva murre" },
            { "%%OSOJS", "Oseacco/Osojane murre" },
            { "%%POSIX", "arvuti" },
            { "%%ROZAJ", "Resia murre" },
            { "%%SAAHO", "saho murre" },
            { "%%SOLBA", "Stolvizza/Solbica murre" },
            { "%%UCCOR", "\u00fchtlustatud ortograafia" },
            { "zh_Hans", "lihtsustatud hiina" },
            { "zh_Hant", "traditsiooniline hiina" },
            { "%%EKAVSK", "\u0161tokavi e-line murrak" },
            { "%%FONIPA", "IPA foneetika" },
            { "%%FONUPA", "UPA foneetika" },
            { "%%PINYIN", "pinyin" },
            { "%%SCOUSE", "scouse" },
            { "%%TARASK", "Taraskievica ortograafia" },
            { "%%UCRCOR", "\u00fchtlustatud redigeeritud ortograafia" },
            { "%%ALALC97", "ALA-LC latinisatsioon (1997)" },
            { "%%AREVELA", "idaarmeenia" },
            { "%%AREVMDA", "l\u00e4\u00e4nearmeenia" },
            { "%%HEPBURN", "Hepburni latinisatsioon" },
            { "%%MONOTON", "monotoonne" },
            { "%%POLYTON", "pol\u00fctooniline" },
            { "%%REVISED", "uus kirjaviis" },
            { "%%1606NICT", "hiliskeskprantsuse (kuni 1606)" },
            { "%%1694ACAD", "varajane moodne prantsuse" },
            { "%%1959ACAD", "akadeemiline" },
            { "%%BAKU1926", "\u00fchtlustatud t\u00fcrgi-ladina t\u00e4hestik" },
            { "%%IJEKAVSK", "\u0161tokavi ije-line murrak" },
            { "%%SCOTLAND", "\u0161oti tavainglise" },
            { "%%VALENCIA", "valentsia" },
            { "%%WADEGILE", "Wade\u2019i-Gilesi latinisatsioon" },
            { "type.ca.roc", "Hiina Vabariigi kalender" },
            { "type.co.eor", "Euroopa j\u00e4rjestusreeglid" },
            { "type.hc.h11", "12-tunnine s\u00fcsteem (0\u201311)" },
            { "type.hc.h12", "12-tunnine s\u00fcsteem (1\u201312)" },
            { "type.hc.h23", "24-tunnine s\u00fcsteem (0\u201323)" },
            { "type.hc.h24", "24-tunnine s\u00fcsteem (1\u201324)" },
            { "type.m0.bgn", "transkriptsioon (BGN)" },
            { "type.nu.ahom", "ahomi numbrid" },
            { "type.nu.arab", "idaaraabia numbrid" },
            { "type.nu.armn", "armeenia numbrid" },
            { "type.nu.bali", "bali numbrid" },
            { "type.nu.beng", "bengali numbrid" },
            { "type.nu.brah", "braahmi numbrid" },
            { "type.nu.cakm", "t\u0161aakma numbrid" },
            { "type.nu.cham", "t\u0161aami numbrid" },
            { "type.nu.cyrl", "kirillitsa numbrid" },
            { "type.nu.deva", "devanaagari numbrid" },
            { "type.nu.diak", "divehi numbrid" },
            { "type.nu.ethi", "etioopia numbrid" },
            { "type.nu.geor", "gruusia numbrid" },
            { "type.nu.gong", "G\u016bnj\u0101la gondi numbrid" },
            { "type.nu.gonm", "Masarami gondi numbrid" },
            { "type.nu.grek", "kreeka numbrid" },
            { "type.nu.gujr", "gud\u017earati numbrid" },
            { "type.nu.guru", "gurmukhi numbrid" },
            { "type.nu.hans", "lihtsustatud hiina keele numbrid" },
            { "type.nu.hant", "traditsioonilise hiina keele numbrid" },
            { "type.nu.hebr", "heebrea numbrid" },
            { "type.nu.hmng", "phahau-hmongi numbrid" },
            { "type.nu.java", "jaava numbrid" },
            { "type.nu.jpan", "jaapani numbrid" },
            { "type.nu.kali", "kaja-lii numbrid" },
            { "type.nu.kawi", "kaavi numbrid" },
            { "type.nu.khmr", "khmeeri numbrid" },
            { "type.nu.knda", "kannada numbrid" },
            { "type.nu.lana", "tai tham hora numbrid" },
            { "type.nu.laoo", "lao numbrid" },
            { "type.nu.latn", "araabia numbrid" },
            { "type.nu.lepc", "lept\u0161a numbrid" },
            { "type.nu.limb", "limbu numbrid" },
            { "type.nu.mlym", "malajalami numbrid" },
            { "type.nu.modi", "modi numbrid" },
            { "type.nu.mong", "mongoli numbrid" },
            { "type.nu.mroo", "mruu numbrid" },
            { "type.nu.mtei", "meitei numbrid" },
            { "type.nu.mymr", "birma numbrid" },
            { "type.nu.nagm", "Nagi mundari numbrid" },
            { "type.nu.nkoo", "nkoo numbrid" },
            { "type.nu.olck", "santali numbrid" },
            { "type.nu.orya", "oria numbrid" },
            { "type.nu.osma", "osmani numbrid" },
            { "type.nu.rohg", "rohingja numbrid" },
            { "type.nu.saur", "saura\u0161tra numbrid" },
            { "type.nu.shrd", "\u0161aarada numbrid" },
            { "type.nu.sind", "hudavadi numbrid" },
            { "type.nu.sinh", "sinhala lithi numbrid" },
            { "type.nu.sora", "sora numbrid" },
            { "type.nu.sund", "sunda numbrid" },
            { "type.nu.takr", "taakri numbrid" },
            { "type.nu.talu", "uue tai-l\u00f5\u00f5 numbrid" },
            { "type.nu.taml", "traditsioonilised tamili numbrid" },
            { "type.nu.telu", "telugu numbrid" },
            { "type.nu.thai", "tai numbrid" },
            { "type.nu.tibt", "tiibeti numbrid" },
            { "type.nu.tirh", "tirhuta numbrid" },
            { "type.nu.tnsa", "tase numbrid" },
            { "type.nu.vaii", "vai numbrid" },
            { "type.nu.wara", "hoo numbrid" },
            { "type.nu.wcho", "vant\u0161o numbrid" },
            { "type.ca.dangi", "dangi kalender" },
            { "type.co.ducet", "Unicode\u2019i vaikej\u00e4rjestus" },
            { "type.co.emoji", "emoji sortimisj\u00e4rjestus" },
            { "type.lb.loose", "paindlik reavahetuse laad" },
            { "type.nu.roman", "Rooma numbrid" },
            { "type.ca.coptic", "kopti kalender" },
            { "type.ca.hebrew", "juudi kalender" },
            { "type.ca.indian", "India rahvuslik kalender" },
            { "type.co.compat", "varasem sortimisj\u00e4rjestus (\u00fchilduvuse jaoks)" },
            { "type.co.pinyin", "pinyin\u2019i sortimisj\u00e4rjestus" },
            { "type.co.search", "\u00fcldeesm\u00e4rgiline otsing" },
            { "type.co.stroke", "kriipsude sortimisj\u00e4rjestus" },
            { "type.co.unihan", "v\u00f5tmete-kriipsude sortimisj\u00e4rjestus" },
            { "type.co.zhuyin", "zhuyin\u2019i sortimisj\u00e4rjestus" },
            { "type.d0.fwidth", "t\u00e4islaius" },
            { "type.d0.hwidth", "poollaius" },
            { "type.lb.normal", "harilik reavahetuse laad" },
            { "type.lb.strict", "j\u00e4ik reavahetuse laad" },
            { "type.m0.ungegn", "transkriptsioon (UNGEGN)" },
            { "type.ms.metric", "meeterm\u00f5\u00f5dustik" },
            { "type.nu.native", "kohalikud numbrid" },
            { "type.ca.chinese", "Hiina kalender" },
            { "type.ca.islamic", "hid\u017era kalender" },
            { "type.ca.iso8601", "ISO-8601 kalender" },
            { "type.ca.persian", "P\u00e4rsia kalender" },
            { "type.cf.account", "arvelduse rahavorming" },
            { "type.co.big5han", "hiina traditsiooniline sortimisj\u00e4rjestus (Big5)" },
            { "type.d0.npinyin", "Numbriline" },
            { "type.nu.arabext", "laiendatud idaaraabia numbrid" },
            { "type.nu.armnlow", "v\u00e4iket\u00e4helised armeenia numbrid" },
            { "type.nu.finance", "finantsnumbrid" },
            { "type.nu.greklow", "v\u00e4iket\u00e4helised kreeka numbrid" },
            { "type.nu.hanidec", "hiina k\u00fcmnendnumbrid" },
            { "type.nu.hansfin", "lihtsustatud hiina keele finantsnumbrid" },
            { "type.nu.hantfin", "traditsioonilise hiina keele finantsnumbrid" },
            { "type.nu.jpanfin", "jaapani finantsnumbrid" },
            { "type.nu.tamldec", "tamili numbrid" },
            { "type.ca.buddhist", "budistlik kalender" },
            { "type.ca.ethiopic", "Etioopia kalender" },
            { "type.ca.japanese", "Jaapani kalender" },
            { "type.cf.standard", "standardne rahavorming" },
            { "type.co.phonetic", "foneetiline sortimisj\u00e4rjestus" },
            { "type.co.searchjl", "otsing korea alguskonsonandi j\u00e4rgi" },
            { "type.co.standard", "standardne j\u00e4rjestus" },
            { "type.ms.uksystem", "inglise m\u00f5\u00f5dustik" },
            { "type.ms.ussystem", "USA m\u00f5\u00f5dustik" },
            { "type.nu.fullwide", "t\u00e4islaiusega numbrid" },
            { "type.nu.lanatham", "tai tham tham numbrid" },
            { "type.nu.mymrshan", "myanmari shan numbrid" },
            { "type.nu.mymrtlng", "myanmari tai laing numbrid" },
            { "type.nu.romanlow", "v\u00e4iket\u00e4helised Rooma numbrid" },
            { "type.ca.gregorian", "Gregoriuse kalender" },
            { "type.co.gb2312han", "hiina lihtsustatud sortimisj\u00e4rjestus (GB2312)" },
            { "type.co.phonebook", "telefoniraamatu sortimisj\u00e4rjestus" },
            { "type.co.dictionary", "s\u00f5nastiku sortimisj\u00e4rjestus" },
            { "type.co.traditional", "traditsiooniline sortimisj\u00e4rjestus" },
            { "type.nu.traditional", "traditsioonilised numbrid" },
            { "type.ca.islamic-rgsa", "hid\u017era kalender (Saudi Araabia, vaatlusp\u00f5hine)" },
            { "type.ca.islamic-tbla", "hid\u017era kalender (tabelkalender, astronoomiline ajastu)" },
            { "type.ca.islamic-civil", "hid\u017era kalender (tabelkalender, ilmalik)" },
            { "type.ca.islamic-umalqura", "hid\u017era kalender (Umm al-Qur\u00e1)" },
            { "type.ca.ethiopic-amete-alem", "Etioopia amete alemi kalender" },
        };
        return data;
    }
}
